<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# get information about a user of my network
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : éàèù
# ***************************************
/**
*
* \brief Load user information
*
*   return xml file
*
*  \relatesalso
*   application.js
*   $p.group.card.load
*   $p.network.card.load
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
*
**/

$folder = "";
$not_access = 1;
$granted = "I";
$pagename = "portal/xmlnetwork_userdetail.php";
//includes
require_once('includes.php');
require_once('../db_layer/'.__DBTYPE.'/enterprise.php');
require_once('../includes/xml.inc.php');

$file = new xmlFile();

$file->header("user");

if( isset($_GET["id"]) )
{
	$id = $_GET["id"];

	//get general information about the user
	$DB->getResults($xmlnetworkuserdetail_getUser,$DB->escape($id));
	if ($DB->nbResults() != 0)
    {
		$row=$DB->fetch(0);
		echo "<username>".$row["username"]."</username>";
		echo "<longname><![CDATA[".$row["long_name"]."]]></longname>";
		echo "<picture>".$row["picture"]."</picture>";
		$DB->freeResults();

		//get the description you set for this user => user is in my network
        $status = '';
		$DB->getResults($xmlnetworkuserdetail_getMyDescription,$DB->escape($_SESSION['user_id']),$DB->escape($id));
        if ($DB->nbResults() > 0) {
            $row = $DB->fetch(0);
            $status = $row["status"];
            $description = $row["description"];
            $DB->freeResults();
        }
        
		if ($status == 'O') {
			echo "<new>0</new>";
			echo "<description><![CDATA[".$description."]]></description>";
			echo "<status>".$status."</status>";
			//get the keywords you set for this user
			$DB->getResults($xmlnetworkuserdetail_getMyKeywords,$DB->escape($_SESSION['user_id']),$DB->escape($id));
			while($row = $DB->fetch(0)) {
				echo "<keyword><![CDATA[".$row["label"]."]]></keyword>";
			}
		}
        else {
			echo "<status>".$status."</status>";
            $DB->getResults($xmlnetworkuserdetail_get1levelPath,$DB->escape($_SESSION['user_id']),$DB->escape($id));
            if ($DB->nbResults() > 0) {
                $row = $DB->fetch(0);

                echo "<path>";
                echo "<id>".$row['cid']."</id>";
                echo "<name><![CDATA[".$row['cname']."]]></name>";
                echo "<picture><![CDATA[".$row['cpicture']."]]></picture>";
                echo "</path>";
            }
            else
            {
                $DB->freeResults();

                $DB->getResults($xmlnetworkuserdetail_get2levelPath,$DB->escape($_SESSION['user_id']),$DB->escape($id));
                if ($DB->nbResults() > 0)
                {
                    $row = $DB->fetch(0);

                    echo "<path>";
                    echo "<id>".$row['cid']."</id>";
                    echo "<name><![CDATA[".$row['cname']."]]></name>";
                    echo "<picture><![CDATA[".$row['cpicture']."]]></picture>";
                    echo "</path>";
                    echo "<path>";
                    echo "<id>".$row['eid']."</id>";
                    echo "<name><![CDATA[".$row['ename']."]]></name>";
                    echo "<picture><![CDATA[".$row['epicture']."]]></picture>";
                    echo "</path>";
                }
            }
        }
        $DB->freeResults();
        
		//get the number of groups the user is a member of
		$DB->getResults($xmlgroup_getNbGroups,$DB->escape($_SESSION['user_id']));
		if ($DB->nbResults()>0)
		    echo "<group>1</group>";
	} else {
		$file->error("lblNoUser");
	}
} else {
	$file->error("useridundefined");
}
$DB->freeResults();

$file->footer("user");

$DB->close();
?>