#! /usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import os
import time
import ldap
import MySQLdb
import authserver
from eoleldaptor.ldapproxy import LdapProxy
from eoleldaptor.eoleldapproxy import EoleLdapProxy
import config
import profilcacheconfig

# initialisations pour la localisation

APP = 'eolesso'
import locale, gettext
locale.setlocale(locale.LC_ALL, config.LC_ALL)
gettext.bindtextdomain (APP)
gettext.textdomain (APP)
gettext.install (APP, unicode=0)

try:
    _ = _
except NameError:
    _ = unicode
    
#####################################################################################
#CONSTANTES POUR GROUPES ET CLASSES
#####################################################################################
USERGROUPS_FILTER = "(&(objectclass=sambaGroupMapping)\
(objectClass=posixGroup)(memberUid=%s))"
CLASSES_FILTER = "(&(objectclass=sambaGroupMapping)\
(objectClass=posixGroup)(|(%s)))"
#####################################################################################
#Initialisation d'un SSOSessionManager
#####################################################################################
sm = authserver.SSOSessionManager()
sm.load_conf()
#####################################################################################
#On prend le LDAP Reader défini dans eolesso
#####################################################################################
reader = config.LDAP_READER[0]
pass_file = config.LDAP_READER_PASSFILE[0]
if reader != "" and os.path.isfile(pass_file):                   
    reader_dn = reader
    reader_pass = passwd = open(pass_file).read().strip()
#####################################################################################
#Initialisation d'un EoleLdapProxy
#####################################################################################
eoleproxy = EoleLdapProxy(config.LDAP_BASE[0], config.LDAP_SERVER[0], config.LDAP_PORT[0], reader_dn=reader_dn, reader_pass=reader_pass)
#####################################################################################
#CONNEXION BASE ET CREATION TABLE
#####################################################################################
conn = MySQLdb.connect(host=profilcacheconfig.mysql_host,    user=profilcacheconfig.mysql_user,    passwd=profilcacheconfig.mysql_passwd,   db=profilcacheconfig.mysql_db)
conn.autocommit(False)
c = conn.cursor()
req_table = "CREATE TABLE IF NOT EXISTS profilcache (user_dn VARCHAR(200)"
for app in profilcacheconfig.apps:
    if app in sm.filters:
        req_table += ", attrs_"+app+" TEXT"
req_table += ", EXECTIME FLOAT, MAJ TEXT) ENGINE=InnoDB" 
#print req_table
c.execute("SHOW TABLES")
tables = c.fetchall()
if tables and tables[0][0] == 'profilcache':
    if len(sys.argv) > 1 and sys.argv[1]=='auto':
        c.execute("SELECT (timediff( now( ) , max( MAJ ) ) > '24:00:00' ) from profilcache")
        times = c.fetchall()
        if times[0][0] == 0:
            print "LA DERNIERE EXECUTION REMONTE A MOINS DE 24 HEURES ----- ABANDON"
            sys.exit()
    c.execute("DROP TABLE IF EXISTS profilcache")
c.execute(req_table)
#####################################################################################
#FIN CONNEXION BASE ET CREATION TABLE
#####################################################################################

#####################################################################################
#INIT DE FILTER_LIST
#####################################################################################
#on explose la liste des filtres de app_filters
#pour chaque appli de app_filters on vérifie si elle est dans les applis prédéfinies
#ensuite si c'est le cas on l'ajoute à la liste des attributs à rapatrier
filter_list = []
for appname,filtervalues in sm.filters.items():
    if appname in profilcacheconfig.apps:
        for values in filtervalues.itervalues():
           for filtername in values.itervalues():
               if filtername not in filter_list:
                   filter_list.append(filtername)
#on a donc maintenant une liste des attributs calculés et une liste des filtres à rappatrier
#####################################################################################
#FIN INIT DE FILTER_LIST
#####################################################################################


# calc_infos : calcule les attributs à partir d'un ensemble d'infos (fiche LDAP) et du nom d'un attribut

def calc_infos(infos, calc_name):
    data = {}
    try:
        # execution de la fonction de calcul
        calc_infos = sm.user_infos.dict_infos[calc_name][0](infos)
        if type(calc_infos) is dict:
            # la fonction de calcul renvoie plusieurs attributs
            for calc_info in calc_infos:
                data[calc_name] = calc_info
        else:
            data[calc_name] = calc_infos
    except Exception, e:
        print("""%s '%s' :  %s""" % (_("Error computing data for attribute"), calc_name, str(e)))
    return data

# filter_data : filtre les données à traiter en fonction de la fiche (infos) et d'un nom de filtre (id_filter)

def _filter_data(infos, id_filter):
    """filtrage en fonction de l'application si des filtres sont définis"""
    data = {}
    if id_filter in sm.filters:
        for section, glob_attrs in sm.global_filter.items():
            for libelle_cas, nom_val in glob_attrs.items():
                data[libelle_cas] = infos.get(nom_val, '')
        for section, attrs in sm.filters[id_filter].items():
            for libelle_cas, nom_val in attrs.items():
                data[libelle_cas] = infos.get(nom_val, '')
    else:
        data.update(infos)
    return data

#ldap_search : effectue une recherche dans le ldap en fonction d'un filtre (searchFilter) et d'un base DN. 
# Les autres params ont des valeurs par défauts, mais peuvent être surchargés
# Le host LDAP est celui défini dans la conf eolesso.

def ldap_search(searchFilter, searchScope=ldap.SCOPE_SUBTREE, retrieveAttributes=None):
    result_set = []
    try:
        l = ldap.open(config.LDAP_SERVER[0])
        d_dn = l.bind(reader_dn, reader_pass)
        ldap_result_id = l.search(profilcacheconfig.baseDN if hasattr(profilcacheconfig,"baseDN") else config.LDAP_BASE[0], searchScope, searchFilter, retrieveAttributes)
        while 1:
            result_type, result_data = l.result(ldap_result_id, 0)
            if (result_data == []):
                break
            else:
                if result_type == ldap.RES_SEARCH_ENTRY:
                    result_data[0][1]['user_dn'] = result_data[0][0]
                    result_set.append(result_data[0][1])
    except ldap.LDAPError, e:
        print "EXCEPTION : '"+str(e)
    return result_set

# get_user_classes : cherche les classes d'un user, appelé par get_user_groups

def get_user_classes((user_groups, infos_groups, classes)):
    if not classes:
        return (user_groups, infos_groups, None)
    else:
        classesSearchFilter = CLASSES_FILTER % (
                    ")(".join( ("cn=%s" % (cl,) for cl in classes)),
                                          )
        res = ldap_search(classesSearchFilter)
        res2 = eoleproxy.add_groupinfos_inlist(res, user_groups, infos_groups, None)
        return res2

# get_user_data : cherche les groupes d'un user
    
def get_user_groups(uid):
    groupsSearchFilter = USERGROUPS_FILTER % (uid,)
    res = ldap_search(groupsSearchFilter) 
    res2 = eoleproxy.handle_group_list(res)
    res3 = get_user_classes(res2)
    return res3

# get_user_data : renvoie les données LDAP brutes 

def get_user_data(search_attrs, retrieveAttributes=None):
    result = []
    users_data = ldap_search(search_attrs)
    if 'user_groups' in filter_list:
        testpresencegroupesamba = ldap_search("(&(objectclass=sambaGroupMapping)(objectClass=posixGroup))")
        for user_data in users_data:
            if not testpresencegroupesamba:
                user_data['user_groups'] = []
                user_data['infos_groups'] = []
            else:
                user_groups = get_user_groups(user_data['uid'][0])
                user_data['user_groups'] = user_groups[0]
                user_data['infos_groups'] = user_groups[1]
            result.append(user_data)
    else:
        for user_data in users_data:
            result.append(user_data)
  
    return result

#attrs_calc :  renvoie tous les attributs calculés pour les données renvoyées par get_user_data en entrée

def attrs_calc(infos):
    # liste des attributs calculés
    # on la trie par ordre alphabetique
    calc_names = sm.user_infos.dict_infos.keys()
    calc_names.sort()
    data = {}
    for fiche in infos:
        start_time = time.time()  
        user_dn = fiche['user_dn']
        if user_dn and user_dn != '':
            req = 'INSERT INTO profilcache VALUES ("'+MySQLdb.escape_string(user_dn)+'"'
            for calc_name in calc_names:
                if calc_name in filter_list:
                    fiche.update(calc_infos(fiche, calc_name))
            for idfilter in profilcacheconfig.apps:  
                if idfilter in sm.filters:
                    filterdata = _filter_data(fiche, idfilter)
                    req += ',"'+MySQLdb.escape_string(str(filterdata))+'"'
            execution_time = time.time() - start_time
            req += ',"'+str(execution_time)+'",now())'
#            print req
            c.execute(req)
            try:
                conn.commit()
            except:
                conn.rollback()


user_data = get_user_data(profilcacheconfig.searchFilter)
attrs_calc(user_data)

conn.close()
