<?php
/*
 * Copyright 2007-2011 Pierre Wirtz
 * This file is part of AjaXplorer.
 *
 * AjaXplorer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * AjaXplorer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with AjaXplorer.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <http://www.ajaxplorer.info/>.
 */
defined('AJXP_EXEC') or die( 'Access not allowed');

/**
 * @package info.ajaxplorer.plugins
 * Authenticate users against an CAS server
 *
 */


/* get globals we me need */
require_once('CAS-1.3.1/eoleCAS.php');
require_once('configCAS/cas.inc.php');

class casAuthDriver extends AbstractAuthDriver {

    var $connectUrl;
    var $casServer ;
    var $casPort = 8443;
    var $casUrl = '';
    var $casProtocol = "https";
    var $casVersion = "2.0";
    var $casLogout = true;
    var $casDebug = false;
    var $gateway = false;
    var $usersSerFile;

    var $casconn = null;

    function init($options){
        parent::init($options);
        AJXP_Logger::info(__CLASS__,__FUNCTION__,"Auth.cas :: init");

        $this->casconn = new eolephpCAS();
        if (__CAS_DEBUG){
            $this->casconn->setDebug("/var/log/posh/ajaxplorer-cas_auth.log");
        }

        $this->casServer = $options["CAS_SERVER"];
        $this->usersSerFile = $options["USERS_FILEPATH"];
        if ($options["CAS_PORT"]) $this->casPort = (int)($options["CAS_PORT"]);
        if ($options["CAS_PROTOCOL"]) $this->casProtocol = $options["CAS_PROTOCOL"];
    }

    function set_connect_url ($url){
        $this->connectUrl = $url;
    }

    function get_connect_url(){
        return $this->connectUrl;
    }

    function preLogUser($sessionid){
        $auth = $this->auth($_GET);
        if ($auth){
            $data_array = Array($this->casconn->getUser(), uniqid("CAS-"));
        }else{
            exit();
        }
        $user = $data_array[0];
        $pgt = $data_array[1];
        if ($pgt == null){
            AJXP_Logger::logAction('Cas Server connexion could NOT be established');
        }else{
            $this->login($user,$pgt);
        }
    }

    function listUsers(){
        return AJXP_Utils::loadSerialFile($this->usersSerFile);
    }

    function userExists($login){
        $users = $this->listUsers();
        if(!is_array($users) || !array_key_exists($login, $users)) return false;
        return true;
    }

    function login($user,$pass){
        if (! $this->userExists($user)){
            $this->createUser($user,$pass);
        }
        $loggingResult = AuthService::logUser($user, "", true, false);
        $userObj = AuthService::getLoggedUser();
        AuthService::updateAdminRights($userObj);
        $_SESSION['username'] = $user;
    }

    function createUser($login, $passwd){
        $users = $this->listUsers();
        if(!is_array($users)) $users = array();
        if(array_key_exists($login, $users)) return "exists";
        if($this->getOption("TRANSMIT_CLEAR_PASS") === true){
            $users[$login] = $passwd;
        }else{
            $users[$login] = md5($passwd);
        }
        AJXP_Utils::saveSerialFile($this->usersSerFile, $users);
    }

    function get_logout_url () {
        $this->casconn->proxy(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false);

        // Maj pour phpCAS 1.3.1
        if (__CAS_VALIDER_CA) {
            $this->casconn->setCasServerCACert(__CAS_CA_LOCATION); // vérification par rapport à la CA
        } else {
            if (method_exists($this->casconn, "setNoCasServerValidation")){
                $this->casconn->setNoCasServerValidation();
            }
        }

		if (__CAS_LOGOUT){
			if(method_exists('EolephpCAS','EoleLogoutRequests')) $this->casconn->EoleLogoutRequests(false);
		}        

        $cas_url = $this->casconn->getServerLogoutURL();
        $paramSeparator = '?';
        $url = str_replace('content.php', '', $_SERVER['SCRIPT_URI']);
        $cas_url = $cas_url . $paramSeparator . "url=" . urlencode($url);
        return $cas_url;
    }

    function auth($GET){
        $auth = false;
        session_start();
        $this->casconn->proxy(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false);

        // Maj pour phpCAS 1.3.1
        if (__CAS_VALIDER_CA) {
            $this->casconn->setCasServerCACert(__CAS_CA_LOCATION); // vérification par rapport à la CA
        } else {
            if (method_exists("eolephpCAS", "setNoCasServerValidation")){
                $this->casconn->setNoCasServerValidation();
            }
        }

		if (__CAS_LOGOUT){
			if(method_exists('EolephpCAS','EoleLogoutRequests')) EolephpCAS::EoleLogoutRequests(false);
		}        
        
        if (method_exists("eolephpCAS", 'setFixedServiceURL')){
            casAuthDriver::set_connect_url($_SERVER['SCRIPT_URI']);
            $this->casconn->setFixedServiceURL(casAuthDriver::get_connect_url());
        }

        if (! $this->casconn->isAuthenticated()){
            if ( ! $this->gateway){
                $this->casconn->forceAuthentication();
            }
            else
            {
                if (! isset($GET['ticket'])){
                    $this->casconn->checkAuthentication();
                }
            }
        }

        if ($this->casconn->isAuthenticated())
        {
            return true;
        }
        else
        {
            return false;
        }

/*
        } else {
            AJXP_Logger::logAction("Error while connection to CAS server");
        }
*/

    }

    function getLogoutRedirect(){
        session_unset();
        session_destroy();
        return "<![CDATA[" . $this->get_logout_url() . "]]>";
    }

    function createCookieString($login){
        $userPass = $this->getUserPass($login);
        //var_dump($userPass);
        return md5($login.":".$userPass.":ajxp");
    }

    function usersEditable(){
        return false;
    }
    function passwordsEditable(){
        return false;
    }

}
?>
