<?php
/**
 * CAS Authentication
 *
 * configuration file
 */

include_once("configCAS/cas.inc.php");

// whether to act as a CAS proxy. If set to true, a proxy ticket will be
//     retrieved from the CAS server to be used as password for logging into
//     the IMAP server. This is the preferred method of authenticating
//     to the IMAP backend.
//     If set to false, the IMAP password specified below will be used.
$rcmail_config['cas_proxy'] = true;

// directory where PGTs will be temporarily stored. Will only be used if
//     cas_proxy is set to true.
$rcmail_config['cas_pgt_dir'] = '/tmp';

// name of the IMAP service. Will only be used if cas_proxy is set to true.
//     This service name must be authorized to be used with the CAS server.
//FIXME
$rcmail_config['cas_imap_name'] = 'imap://localhost';
$rcmail_config['cas_smtp_name'] = 'smtp://localhost';

// whether the IMAP server caches proxy tickets it has received for subsequent
//    requests. Will only be used if cas_proxy is set to true. If set to true,
//    proxy tickets will be reused to connect to the IMAP server until an IMAP
//    connection fails, after which a new proxy ticket will be retrieved. If
//    set to false, a new proxy ticket will be retrieved before each IMAP
//    request. Setting this to true and enabling caching on the IMAP server
//    significantly reduces the number of requests made to the CAS server.
$rcmail_config['cas_imap_caching'] = true;

// password for logging into the IMAP server. Will only be used if cas_proxy
//     is set to false. The IMAP backend must accept this password for all
//     authorized users.
$rcmail_config['cas_imap_password'] = '';

// CAS server host name.
$rcmail_config['cas_hostname'] = __CAS_SERVER;

// CAS server port number.
$rcmail_config['cas_port'] = __CAS_PORT;

// CAS service URI on the CAS server.
$rcmail_config['cas_uri'] = __CAS_FOLDER;

// CAS server SSL validation: 'self' for self-signed certificate, 'ca' for
//     certificate from a CA, empty for no SSL validation.
$rcmail_config['cas_validation'] = '';

// CAS server certificate in PEM format, used when CAS validation is set to
//     'self' or 'ca'.
$rcmail_config['cas_cert'] = '/etc/ssl/certs/ca.crt';

// CAS service login URL.
$rcmail_config['cas_login_url'] = '';

// CAS service logout URL.
$rcmail_config['cas_logout_url'] = '';
?>
