<?php

/**
 * Help Plugin
 *
 * @author Aleksander 'A.L.E.C' Machniak
 * @license GNU GPLv3+
 *
 * Configuration (see config.inc.php.dist)
 * 
 **/

class envole extends rcube_plugin
{
    // all task excluding 'login' and 'logout'
    public $task = '?(?!login|logout).*';
    // we've got no ajax handlers
    public $noajax = true;
    // skip frames
    public $noframe = true;

    function init()
    {
        $rcmail = rcmail::get_instance();

        $this->add_texts('localization/', false);

        // register task
        $this->register_task('envole');

        // register request
        $this->register_action('numberunread',	array($this, 'request'));

        // register mini
        $this->register_action('mini',   		array($this, 'mini'));
        
        // register frame
        $this->register_action('index',   		array($this, 'frame'));
        $this->register_action('about',   		array($this, 'frame'));
        $this->register_action('license', 		array($this, 'frame'));

        // add taskbar button
        /*
        $this->add_button(array(
            'command'    => 'help',
            'class'      => 'button-help',
            'classsel'   => 'button-help button-selected',
            'innerclass' => 'button-inner',
            'label'      => 'envole.help',
        ), 'taskbar');
		*/
		
        // add style for taskbar button (must be here) and Help UI
        $skin_path = $this->local_skin_path();
        
        if (is_file($this->home . "/$skin_path/envole.css")) {
            $this->include_stylesheet("$skin_path/envole.css");
        }
    }

	function request()
	{
        $rcmail = rcmail::get_instance();
        $this->load_config();

        // register UI objects
        
        $rcmail->output->add_handlers(array('envolecontent' => array($this, 'content'), ));

        $rcmail->output->send('envole.blank');
	}

    function frame()
    {
        $rcmail = rcmail::get_instance();
        $this->load_config();

        // register UI objects
        $rcmail->output->add_handlers(array('envolecontent' => array($this, 'content'), ));

        if ($rcmail->action == 'about')
            $rcmail->output->set_pagetitle($this->gettext('about'));
        else if ($rcmail->action == 'license')
            $rcmail->output->set_pagetitle($this->gettext('license'));
        else
            $rcmail->output->set_pagetitle($this->gettext('help'));

        $rcmail->output->send('envole.envole');
    }

	function mini()
	{
        $rcmail = rcmail::get_instance();
        $this->load_config();
        $rcmail->output->add_handlers(array('envolecontent' => array($this, 'content'), ));
        $rcmail->output->send('envole.mini');
	
	}
	
	
    function content($attrib)
    {
        $rcmail = rcmail::get_instance();
		
		// Mini
        if ($rcmail->action == 'mini') {
			$cfg = rcmail::get_instance()->config->all();
			$IMAP = new rcube_imap(null);
			$user = $rcmail->user;		
			
			$count=0;
			$html="";
			
			if ($IMAP->connect($cfg['default_host'], $user->data['username'], $_SESSION['cas_pt'][php_uname('n')], $cfg['default_port'], false))
			{					
				$IMAP->set_folder('INBOX');
				$index = $IMAP->index('', null, 'DESC');
				$count = $IMAP->count();	
				$index = $index->get();
				if($count>8) $fgplus=true;
				$count=min($count,20);
				
				if($count>0){
					$html=$html.'<table id="envolemessagelist" class="records-table sortheader" style="border:none !important;"><tbody>';
				}
				
				for ($i = 0; $i < $count; $i++)
				{
					$headers = $IMAP->get_message_headers($index[$i]);
					$from = current(rcube_mime::decode_address_list($headers->from, 1, false));
					$subject = rcube_mime::decode_header($headers->subject, $headers->charset);
					
					$lbback="background: url(/roundcube/" . $this->local_skin_path() . "/images/buttons.png?v=3e15.39327) -1000px 0 no-repeat; background-position: 0 -22px;";
					$lbstyle="font-weight:bold;";
					if($headers->flags['SEEN']) {
						$lbstyle="font-weight:normal;";
						$lbback="background: url(/roundcube/" . $this->local_skin_path() . "/images/buttons.png?v=3e15.39327) -1000px 0 no-repeat; background-position: 0 0px;";
					}
					
					
					
					$html=$html."<tr id='msg".$headers->uid."' class='message' style='".$lbstyle."'>";
					$html=$html."<td class='subject' style='border:none !important;'>";
					
					$html=$html."<div style='padding-bottom:10px;display:inline-block;'>";
					$html=$html."<a	onClick='document.getElementById(\"envoleback".$headers->uid."\").style.backgroundPosition=\"0 0px\"; document.getElementById(\"msg".$headers->uid."\").style.fontWeight=\"normal\"'	href='./?_task=mail&amp;_action=show&amp;_mbox=INBOX&amp;_uid=".$headers->uid."' style='font-size:10px' target='_blank'>";
					$html=$html."<div id='envoleback".$headers->uid."' style='width:35px; height:25px;float:left;margin-top:5px;$lbback'></div>";
										
					$html=$html."<div style='float:left;'>";
					$html=$html."<span id='envolesubject' style='font-size:140%'>".$subject."</span><br>";
					$html=$html.$from['mailto']."<br>".date("d/m/Y H:i:s",strtotime($headers->date));
					$html=$html."</div>";
					
					$html=$html."</a>";
					$html=$html."</div>";
					$html=$html."</td></tr>";
				}							
			}	
			
			if($html!=""){
				$html=$html.'</tbody></table>';
			}
			
			//echo "<script>alert('".$html."');</script>";
			return $html;
        }
		
		// Request
        if ($rcmail->action == 'numberunread') {
			$cfg = rcmail::get_instance()->config->all();
			$IMAP = new rcube_imap(null);
			$user = $rcmail->user;		
			
			$count=0;
			if ($IMAP->connect($cfg['default_host'], $user->data['username'], $_SESSION['cas_pt'][php_uname('n')],  $cfg['default_port'], false))
			{					
				$IMAP->set_folder('INBOX');
				$count = $IMAP->count('','UNSEEN');				
			}

            // Si une URL de callback est précisé, on retourne vers la page avec ce callback par du javascript
            // en précisant les informations attendues, c'est ça dire le nombre de message non lus
            // NOTE: On test l'existance de callback et _callback, car callback est remplacé par _callback après retour d'une autentification CAS.
            // idem pour id, qui est l'id de l'appliquation de xdesktop
            // Se mécanisnme de callback permet le passage par une iframe (qui gère l'autehntification CAS) contrairement à un appel AJAX
            // comme le callback se trouve sur le même domaine que la page affichée, nous n'avons pas de problème de xframe cross-scripting
            if (isset($_GET["callback"]) || isset($_GET["_callback"])) {
                $callback=isset($_GET["callback"])?$_GET["callback"]:$_GET["_callback"];
                $id=isset($_GET["id"])?$_GET["id"]:$_GET["_id"];
                $message="Vous avez $count message".(($count>1)?"s":"");
                $ret="<script>";
                $ret=$ret."window.location.href='$callback?id=$id&count=$count&message=$message&type=count&link=self'";
                $ret=$ret."</script>";
                return $ret;
            } 
            // Si pas d'URL de callback, on retourne un objet json, en prenant soin de clore l'objet IMAP
            else
            {
                $IMAP->close();
                die('{"count":'.$count.',"message":"","type":"count"}');
            }
			//return '{"count":"'.$count.'"}';
        }

		// Frame
        else if ($rcmail->action == 'about') {
            return @file_get_contents($this->home.'/content/about.html');
        }
        else if ($rcmail->action == 'license') {
            return @file_get_contents($this->home.'/content/license.html');
        }
        
        // default content: iframe
        $attrib['src']='http://trac.roundcube.net/wiki';      

        if (empty($attrib['id']))
            $attrib['id'] = 'rcmailenvolecontent';

        $attrib['name'] = $attrib['id'];

        return $rcmail->output->frame($attrib);
    }
}
