DROP TABLE IF EXISTS sacoche_socle_entree;

CREATE TABLE sacoche_socle_entree (
  entree_id    SMALLINT(5)  UNSIGNED                NOT NULL AUTO_INCREMENT,
  section_id   TINYINT(3)   UNSIGNED                NOT NULL DEFAULT 0,
  entree_ordre TINYINT(3)   UNSIGNED                NOT NULL DEFAULT 0 COMMENT "Commence à 0.",
  entree_nom   VARCHAR(235) COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  PRIMARY KEY (entree_id),
  KEY section_id (section_id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE sacoche_socle_entree DISABLE KEYS;

INSERT INTO sacoche_socle_entree VALUES 
(  111 , 44,  0, "Adapter son mode de lecture à la nature du texte proposé et à l’objectif poursuivi."),
(  112 , 44,  1, "Repérer les informations dans un texte à partir des éléments explicites et des éléments implicites nécessaires."),
(  113 , 44,  2, "Utiliser ses capacités de raisonnement, ses connaissances sur la langue, savoir faire appel à des outils appropriés pour lire."),
(  114 , 44,  3, "Dégager, par écrit ou oralement, l’essentiel d’un texte lu."),
(  115 , 44,  4, "Manifester, par des moyens divers, sa compréhension de textes variés."),
(  121 , 45,  0, "Reproduire un document sans erreur et avec une présentation adaptée."),
(  122 , 45,  1, "Écrire lisiblement un texte, spontanément ou sous la dictée, en respectant l’orthographe et la grammaire."),
(  123 , 45,  2, "Rédiger un texte bref, cohérent et ponctué, en réponse à une question ou à partir de consignes données."),
(  124 , 45,  3, "Utiliser ses capacités de raisonnement, ses connaissances sur la langue, savoir faire appel à des outils variés pour améliorer son texte."),
(  131 , 46,  0, "Formuler clairement un propos simple."),
(  132 , 46,  1, "Développer de façon suivie un propos en public sur un sujet déterminé."),
(  133 , 46,  2, "Adapter sa prise de parole à la situation de communication."),
(  134 , 46,  3, "Participer à un débat, à un échange verbal."),
(  211 , 48,  0, "Établir un contact social."),
(  212 , 48,  1, "Dialoguer sur des sujets familiers."),
(  213 , 48,  2, "Demander et donner des informations."),
(  214 , 48,  3, "Réagir à des propositions."),
(  221 , 49,  0, "Comprendre un message oral pour réaliser une tâche."),
(  222 , 49,  1, "Comprendre les points essentiels d’un message oral (conversation, information, récit, exposé)."),
(  231 , 50,  0, "Reproduire un modèle oral."),
(  232 , 50,  1, "Décrire, raconter, expliquer."),
(  233 , 50,  2, "Présenter un projet et lire à haute voix."),
(  241 , 51,  0, "Comprendre le sens général de documents écrits."),
(  242 , 51,  1, "Savoir repérer des informations dans un texte."),
(  251 , 52,  0, "Copier, écrire sous la dictée."),
(  252 , 52,  1, "Renseigner un questionnaire."),
(  253 , 52,  2, "Écrire un message simple."),
(  254 , 52,  3, "Rendre compte de faits."),
(  255 , 52,  4, "Écrire un court récit, une description."),
(  311 , 53,  0, "Rechercher, extraire et organiser l’information utile."),
(  312 , 53,  1, "Réaliser, manipuler, mesurer, calculer, appliquer des consignes."),
(  313 , 53,  2, "Raisonner, argumenter, pratiquer une démarche expérimentale ou technologique, démontrer."),
(  314 , 53,  3, "Présenter la démarche suivie, les résultats obtenus, communiquer à l’aide d’un langage adapté."),
(  321 , 54,  0, "Organisation et gestion de données : reconnaître des situations de proportionnalité, utiliser des pourcentages, des tableaux, des graphiques. Exploiter des données statistiques et aborder des situations simples de probabilité."),
(  322 , 54,  1, "Nombres et calculs : connaître et utiliser les nombres entiers, décimaux et fractionnaires. Mener à bien un calcul : mental, à la main, à la calculatrice, avec un ordinateur."),
(  323 , 54,  2, "Géométrie : connaître et représenter des figures géométriques et des objets de l’espace. Utiliser leurs propriétés."),
(  324 , 54,  3, "Grandeurs et mesures : réaliser des mesures (longueurs, durées, …), calculer des valeurs (volumes, vitesses, …) en utilisant différentes unités."),
(  331 , 55,  0, "L’univers et la Terre : organisation de l’univers ; structure et évolution au cours des temps géologiques de la Terre, phénomènes physiques."),
(  332 , 55,  1, "La matière : principales caractéristiques, états et transformations ; propriétés physiques et chimiques de la matière et des matériaux ; comportement électrique, interactions avec la lumière."),
(  333 , 55,  2, "Le vivant : unité d’organisation et diversité ; fonctionnement des organismes vivants, évolution des espèces, organisation et fonctionnement du corps humain."),
(  334 , 55,  3, "L’énergie : différentes formes d’énergie, notamment l’énergie électrique, et transformations d’une forme à une autre."),
(  335 , 55,  4, "Les objets techniques : analyse, conception et réalisation ; fonctionnement et conditions d’utilisation."),
(  341 , 56,  0, "Mobiliser ses connaissances pour comprendre des questions liées à l’environnement et au développement durable."),
(  411 , 57,  0, "Utiliser, gérer des espaces de stockage à disposition."),
(  412 , 57,  1, "Utiliser les périphériques à disposition."),
(  413 , 57,  2, "Utiliser les logiciels et les services à disposition."),
(  421 , 58,  0, "Connaître et respecter les règles élémentaires du droit relatif à sa pratique."),
(  422 , 58,  1, "Protéger sa personne et ses données."),
(  423 , 58,  2, "Faire preuve d’esprit critique face à l’information et à son traitement."),
(  424 , 58,  3, "Participer à des travaux collaboratifs en connaissant les enjeux et en respectant les règles."),
(  431 , 59,  0, "Saisir et mettre en page un texte."),
(  432 , 59,  1, "Traiter une image, un son ou une vidéo."),
(  433 , 59,  2, "Organiser la composition du document, prévoir sa présentation en fonction de sa destination."),
(  434 , 59,  3, "Différencier une situation simulée ou modélisée d’une situation réelle."),
(  441 , 60,  0, "Consulter des bases de données documentaires en mode simple (plein texte)."),
(  442 , 60,  1, "Identifier, trier et évaluer des ressources."),
(  443 , 60,  2, "Chercher et sélectionner l’information demandée."),
(  453 , 61,  0, "Écrire, envoyer, diffuser, publier."),
(  454 , 61,  1, "Recevoir un commentaire, un message y compris avec pièces jointes."),
(  455 , 61,  2, "Exploiter les spécificités des différentes situations de communication en temps réel ou différé."),
(  511 , 62,  0, "Relevant de l’espace : les grands ensembles physiques et humains et les grands types d’aménagements dans le monde, les principales caractéristiques géographiques de la France et de l’Europe."),
(  512 , 62,  1, "Relevant du temps : les différentes périodes de l’histoire de l’humanité - Les grands traits de l’histoire (politique, sociale, économique, littéraire, artistique, culturelle) de la France et de l’Europe."),
(  513 , 62,  2, "Relevant de la culture littéraire : œuvres littéraires du patrimoine."),
(  514 , 62,  3, "Relevant de la culture artistique : œuvres picturales, musicales, scéniques, architecturales ou cinématographiques du patrimoine."),
(  515 , 62,  4, "Relevant de la culture civique : Droits de l’Homme - Formes d’organisation politique, économique et sociale dans l’Union européenne - Place et rôle de l’État en France - Mondialisation - Développement durable."),
(  521 , 67,  0, "Situer des événements, des œuvres littéraires ou artistiques, des découvertes scientifiques ou techniques, des ensembles géographiques."),
(  522 , 67,  1, "Identifier la diversité des civilisations, des langues, des sociétés, des religions."),
(  523 , 67,  2, "Établir des liens entre les œuvres (littéraires, artistiques) pour mieux les comprendre."),
(  524 , 67,  3, "Mobiliser ses connaissances pour donner du sens à l’actualité."),
(  531 , 66,  0, "Lire et employer différents langages : textes – graphiques – cartes – images – musique."),
(  532 , 66,  1, "Connaître et pratiquer diverses formes d’expression à visée littéraire."),
(  533 , 66,  2, "Connaître et pratiquer diverses formes d’expression à visée artistique."),
(  541 , 74,  0, "Être sensible aux enjeux esthétiques et humains d’un texte littéraire."),
(  542 , 74,  1, "Être sensible aux enjeux esthétiques et humains d’une œuvre artistique."),
(  543 , 74,  2, "Être capable de porter un regard critique sur un fait, un document, une œuvre."),
(  544 , 74,  3, "Manifester sa curiosité pour l’actualité et pour les activités culturelles ou artistiques."),
(  611 , 68,  0, "Principaux droits de l’Homme et du citoyen."),
(  612 , 68,  1, "Valeurs, symboles, institutions de la République."),
(  613 , 68,  2, "Règles fondamentales de la démocratie et de la justice."),
(  614 , 68,  3, "Grandes institutions de l’Union européenne et rôle des grands organismes internationaux."),
(  615 , 68,  4, "Rôle de la défense nationale."),
(  616 , 68,  5, "Fonctionnement et rôle de différents médias."),
(  621 , 69,  0, "Respecter les règles de la vie collective."),
(  622 , 69,  1, "Comprendre l’importance du respect mutuel et accepter toutes les différences."),
(  623 , 69,  2, "Respecter des comportements favorables à sa santé et sa sécurité."),
(  624 , 69,  3, "Respecter quelques notions juridiques de base."),
(  625 , 69,  4, "Savoir utiliser quelques notions économiques et budgétaires de base."),
(  711 , 70,  0, "Se familiariser avec l’environnement économique, les entreprises, les métiers de secteurs et de niveaux de qualification variés."),
(  712 , 70,  1, "Connaître les parcours de formation correspondant à ces métiers et les possibilités de s’y intégrer."),
(  713 , 70,  2, "Savoir s’autoévaluer et être capable de décrire ses intérêts, ses compétences et ses acquis."),
(  721 , 71,  0, "Être autonome dans son travail : savoir l’organiser, le planifier, l’anticiper, rechercher et sélectionner des informations utiles."),
(  722 , 71,  1, "Identifier ses points forts et ses points faibles dans des situations variées."),
(  723 , 71,  2, "Mobiliser à bon escient ses capacités motrices dans le cadre d’une pratique physique (sportive ou artistique) adaptée à son potentiel."),
(  724 , 71,  3, "Savoir nager."),
(  731 , 72,  0, "S’engager dans un projet individuel."),
(  732 , 72,  1, "S’intégrer et coopérer dans un projet collectif."),
(  733 , 72,  2, "Manifester curiosité, créativité, motivation à travers des activités conduites ou reconnues par l’établissement."),
(  734 , 72,  3, "Assumer des rôles, prendre des initiatives et des décisions."),
( 2111 , 13,  0, "S’exprimer à l’oral comme à l’écrit dans un vocabulaire approprié et précis."),
( 2112 , 13,  1, "Prendre la parole en respectant le niveau de langue adapté."),
( 2113 , 13,  2, "Répondre à une question par une phrase complète à l’oral."),
( 2114 , 13,  3, "Prendre part à un dialogue : prendre la parole devant les autres, écouter autrui, formuler et justifier un point de vue."),
( 2115 , 13,  4, "Dire de mémoire, de façon expressive, une dizaine de poèmes et de textes en prose."),
( 2121 , 14,  0, "Lire avec aisance (à haute voix, silencieusement) un texte."),
( 2122 , 14,  1, "Lire seul des textes du patrimoine et des œuvres intégrales de la littérature de jeunesse, adaptés à son âge."),
( 2123 , 14,  2, "Lire seul et comprendre un énoncé, une consigne."),
( 2124 , 14,  3, "Dégager le thème d’un texte."),
( 2125 , 14,  4, "Repérer dans un texte des informations explicites."),
( 2126 , 14,  5, "Inférer des informations nouvelles (implicites)."),
( 2127 , 14,  6, "Repérer les effets de choix formels (emploi de certains mots, utilisation d’un niveau de langue)."),
( 2128 , 14,  7, "Utiliser ses connaissances pour réfléchir sur un texte, mieux le comprendre."),
( 2129 , 14,  8, "Effectuer, seul, des recherches dans des ouvrages documentaires (livres, produits multimédia)."),
( 21210, 14,  9, "Se repérer dans une bibliothèque, une médiathèque."),
( 2131 , 15,  0, "Copier sans erreur un texte d’au moins quinze lignes en lui donnant une présentation adaptée."),
( 2132 , 15,  1, "Utiliser ses connaissances pour réfléchir sur un texte, mieux l’écrire."),
( 2133 , 15,  2, "Répondre à une question par une phrase complète à l’écrit."),
( 2134 , 15,  3, "Rédiger un texte d’une quinzaine de lignes (récit, description, dialogue, texte poétique, compte rendu) en utilisant ses connaissances en vocabulaire et en grammaire."),
( 2141 , 16,  0, "Comprendre des mots nouveaux et les utiliser à bon escient."),
( 2142 , 16,  1, "Maîtriser quelques relations de sens entre les mots."),
( 2143 , 16,  2, "Maîtriser quelques relations concernant la forme et le sens des mots."),
( 2144 , 16,  3, "Savoir utiliser un dictionnaire papier ou numérique."),
( 2151 , 17,  0, "Distinguer les mots selon leur nature."),
( 2152 , 17,  1, "Identifier les fonctions des mots dans la phrase."),
( 2153 , 17,  2, "Conjuguer les verbes, utiliser les temps à bon escient."),
( 2161 , 18,  0, "Maîtriser l’orthographe grammaticale."),
( 2162 , 18,  1, "Maîtriser l’orthographe lexicale."),
( 2163 , 18,  2, "Orthographier correctement un texte simple de dix lignes – lors de sa rédaction ou de sa dictée – en se référant aux règles connues d’orthographe et de grammaire ainsi qu’à la connaissance du vocabulaire."),
( 2211 , 19,  0, "Communiquer, au besoin avec des pauses pour chercher ses mots."),
( 2212 , 19,  1, "Se présenter ; présenter quelqu’un ; demander à quelqu’un de ses nouvelles en utilisant les formes de politesse les plus élémentaires ; accueil et prise de congé."),
( 2213 , 19,  2, "Répondre à des questions et en poser (sujets familiers ou besoins immédiats)."),
( 2214 , 19,  3, "Épeler des mots familiers."),
( 2221 , 20,  0, "Comprendre les consignes de classe."),
( 2222 , 20,  1, "Comprendre des mots familiers et des expressions très courantes."),
( 2223 , 20,  2, "Suivre des instructions courtes et simples."),
( 2231 , 21,  0, "Reproduire un modèle oral."),
( 2232 , 21,  1, "Utiliser des expressions et des phrases proches des modèles rencontrés lors des apprentissages."),
( 2233 , 21,  2, "Lire à haute voix et de manière expressive un texte bref après répétition."),
( 2241 , 22,  0, "Comprendre des textes courts et simples en s’appuyant sur des éléments connus (indications, informations)."),
( 2242 , 22,  1, "Se faire une idée du contenu d’un texte informatif simple, accompagné éventuellement d’un document visuel."),
( 2251 , 23,  0, "Copier des mots isolés et des textes courts."),
( 2252 , 23,  1, "Écrire un message électronique simple ou une courte carte postale en référence à des modèles."),
( 2253 , 23,  2, "Renseigner un questionnaire."),
( 2254 , 23,  3, "Produire de manière autonome quelques phrases."),
( 2255 , 23,  4, "Écrire sous la dictée des expressions connues."),
( 2311 , 24,  0, "Écrire, nommer, comparer et utiliser les nombres entiers, les nombres décimaux (jusqu’au centième) et quelques fractions simples."),
( 2312 , 24,  1, "Restituer les tables d’addition et de multiplication de 2 à 9."),
( 2313 , 24,  2, "Utiliser les techniques opératoires des quatre opérations sur les nombres entiers et décimaux (pour la division, le diviseur est un nombre entier)."),
( 2314 , 24,  3, "Ajouter deux fractions décimales ou deux fractions simples de même dénominateur."),
( 2315 , 24,  4, "Calculer mentalement en utilisant les quatre opérations."),
( 2316 , 24,  5, "Estimer l’ordre de grandeur d’un résultat."),
( 2317 , 24,  6, "Résoudre des problèmes relevant des quatre opérations."),
( 2318 , 24,  7, "Utiliser une calculatrice."),
( 2321 , 25,  0, "Reconnaître, décrire et nommer les figures et solides usuels."),
( 2322 , 25,  1, "Utiliser la règle, l’équerre et le compas pour vérifier la nature de figures planes usuelles et les construire avec soin et précision."),
( 2323 , 25,  2, "Percevoir et reconnaitre parallèles et perpendiculaires."),
( 2324 , 25,  3, "Résoudre des problèmes de reproduction, de construction."),
( 2331 , 26,  0, "Utiliser des instruments de mesure."),
( 2332 , 26,  1, "Connaître et utiliser les formules du périmètre et de l’aire d’un carré, d’un rectangle et d’un triangle."),
( 2333 , 26,  2, "Utiliser les unités de mesures usuelles."),
( 2334 , 26,  3, "Résoudre des problèmes dont la résolution implique des conversions."),
( 2341 , 27,  0, "Lire, interpréter et construire quelques représentations simples : tableaux, graphiques."),
( 2342 , 27,  1, "Savoir organiser des informations numériques ou géométriques, justifier et apprécier la vraisemblance d’un résultat."),
( 2343 , 27,  2, "Résoudre un problème mettant en jeu une situation de proportionnalité."),
( 2351 , 28,  0, "Pratiquer une démarche d’investigation : savoir observer, questionner."),
( 2352 , 28,  1, "Manipuler et expérimenter, formuler une hypothèse et la tester, argumenter, mettre à l’essai plusieurs pistes de solutions."),
( 2353 , 28,  2, "Exprimer et exploiter les résultats d’une mesure et d’une recherche en utilisant un vocabulaire scientifique à l’écrit ou à l’oral."),
( 2361 , 29,  0, "Le ciel et la Terre."),
( 2362 , 29,  1, "La matière."),
( 2363 , 29,  2, "L’énergie."),
( 2364 , 29,  3, "L’unité et la diversité du vivant."),
( 2365 , 29,  4, "Le fonctionnement du vivant."),
( 2366 , 29,  5, "Le fonctionnement du corps humain et la santé."),
( 2367 , 29,  6, "Les êtres vivants dans leur environnement."),
( 2368 , 29,  7, "Les objets techniques."),
( 2371 , 30,  0, "Mobiliser ses connaissances pour comprendre quelques questions liées à l’environnement et au développement durable et agir en conséquence."),
( 2411 , 31,  0, "Connaitre et maîtriser les fonctions de base d’un ordinateur et de ses périphériques."),
( 2421 , 32,  0, "Prendre conscience des enjeux citoyens de l’usage de l’informatique et de l’internet et adopter une attitude critique face aux résultats obtenus."),
( 2431 , 33,  0, "Produire un document numérique : texte, image, son."),
( 2432 , 33,  1, "Utiliser l’outil informatique pour présenter un travail."),
( 2441 , 34,  0, "Lire un document numérique."),
( 2442 , 34,  1, "Chercher des informations par voie électronique."),
( 2443 , 34,  2, "Découvrir les richesses et les limites des ressources de l’internet."),
( 2453 , 35,  0, "Échanger avec les technologies de l’information et de la communication."),
( 2511 , 36,  0, "Identifier les périodes de l’histoire au programme."),
( 2512 , 36,  1, "Connaître et mémoriser les principaux repères chronologiques (évènements et personnages)."),
( 2513 , 36,  2, "Connaître les principaux caractères géographiques physiques et humains de la région où vit l’élève, de la France et de l’Union européenne, les repérer sur des cartes à différentes échelles."),
( 2514 , 36,  3, "Comprendre une ou deux questions liées au développement durable et agir en conséquence (l’eau dans la commune, la réduction et le recyclage des déchets)."),
( 2521 , 37,  0, "Lire des œuvres majeures du patrimoine et de la littérature pour la jeunesse."),
( 2522 , 37,  1, "Établir des liens entre les textes lus."),
( 2531 , 73,  0, "Lire et utiliser textes, cartes, croquis, graphiques."),
( 2541 , 38,  0, "Distinguer les grandes catégories de la création artistique (littérature, musique, danse, théâtre, cinéma, dessin, peinture, sculpture, architecture)."),
( 2542 , 38,  1, "Reconnaître et décrire des œuvres préalablement étudiées."),
( 2543 , 38,  2, "Pratiquer le dessin et diverses formes d’expressions visuelles et plastiques."),
( 2544 , 38,  3, "Interpréter de mémoire une chanson, participer à un jeu rythmique ; repérer des éléments musicaux caractéristiques simples."),
( 2545 , 38,  4, "Inventer et réaliser des textes, des œuvres plastiques, des chorégraphies ou des enchaînements, à visée artistique ou expressive."),
( 2611 , 39,  0, "Reconnaître les symboles de la République et de l’Union européenne."),
( 2612 , 39,  1, "Comprendre les notions de droits et de devoirs, les accepter et les mettre en application."),
( 2613 , 39,  2, "Avoir conscience de la dignité de la personne humaine et en tirer les conséquences au quotidien."),
( 2621 , 40,  0, "Respecter les règles de la vie collective."),
( 2622 , 40,  1, "Respecter tous les autres, et notamment appliquer les principes de l’égalité des filles et des garçons."),
( 2711 , 41,  0, "Respecter des consignes simples, en autonomie."),
( 2712 , 41,  1, "Être persévérant dans toutes les activités."),
( 2713 , 41,  2, "Commencer à savoir s’autoévaluer dans des situations simples."),
( 2714 , 41,  3, "Soutenir une écoute prolongée (lecture, musique, spectacle, etc.)."),
( 2721 , 42,  0, "S’impliquer dans un projet individuel ou collectif."),
( 2731 , 43,  0, "Se respecter en respectant les principales règles d’hygiène de vie ; accomplir les gestes quotidiens sans risquer de se faire mal."),
( 2732 , 43,  1, "Réaliser une performance mesurée dans les activités athlétiques et en natation."),
( 2733 , 43,  2, "Se déplacer en s’adaptant à l’environnement."),
(    1 ,  1,  0, "S’exprimer clairement à l’oral en utilisant un vocabulaire approprié."),
(    2 ,  1,  1, "Participer en classe à un échange verbal en respectant les règles de la communication."),
(    3 ,  1,  2, "Dire de mémoire quelques textes en prose ou poèmes courts."),
(    4 ,  2,  0, "Lire seul, à haute voix, un texte comprenant des mots connus et inconnus."),
(    5 ,  2,  1, "Lire seul et écouter lire des textes du patrimoine et des œuvres intégrales de la littérature de jeunesse adaptés à son âge."),
(    6 ,  2,  2, "Lire seul et comprendre un énoncé, une consigne simple."),
(    7 ,  2,  3, "Dégager le thème d’un paragraphe ou d’un texte court."),
(    8 ,  2,  4, "Lire silencieusement un texte en déchiffrant les mots inconnus et manifester sa compréhension dans un résumé, une reformulation, des réponses à des questions."),
(    9 ,  3,  0, "Copier un texte court sans erreur dans une écriture cursive lisible et avec une présentation soignée."),
(   10 ,  3,  1, "Utiliser ses connaissances pour mieux écrire un texte court."),
(   11 ,  3,  2, "Écrire de manière autonome un texte de cinq à dix lignes."),
(   12 ,  4,  0, "Utiliser des mots précis pour s’exprimer."),
(   13 ,  4,  1, "Donner des synonymes."),
(   14 ,  4,  2, "Trouver un mot de sens opposé."),
(   15 ,  4,  3, "Regrouper des mots par familles."),
(   16 ,  4,  4, "Commencer à utiliser l’ordre alphabétique."),
(   17 ,  5,  0, "Identifier la phrase, le verbe, le nom, l’article, l’adjectif qualificatif, le pronom personnel (sujet)."),
(   18 ,  5,  1, "Repérer le verbe d’une phrase et son sujet."),
(   19 ,  5,  2, "Conjuguer les verbes du 1er groupe, être et avoir, au présent, au futur, au passé composé de l’indicatif ; conjuguer les verbes faire, aller, dire, venir, au présent de l’indicatif."),
(   20 ,  5,  3, "Distinguer le présent du futur et du passé."),
(   21 ,  6,  0, "Écrire en respectant les correspondances entre lettres et sons et les règles relatives à la valeur des lettres."),
(   22 ,  6,  1, "Écrire sans erreur des mots mémorisés."),
(   23 ,  6,  2, "Orthographier correctement des formes conjuguées, respecter l’accord entre le sujet et le verbe, ainsi que les accords en genre et en nombre dans le groupe nominal."),
(   24 ,  7,  0, "Écrire, nommer, comparer, ranger les nombres entiers naturels inférieurs à 1000."),
(   25 ,  7,  1, "Résoudre des problèmes de dénombrement."),
(   26 ,  7,  2, "Calculer : addition, soustraction, multiplication."),
(   27 ,  7,  3, "Diviser par 2 et par 5 dans le cas où le quotient exact est entier."),
(   28 ,  7,  4, "Restituer et utiliser les tables d’addition et de multiplication par 2, 3, 4 et 5."),
(   29 ,  7,  5, "Calculer mentalement en utilisant des additions, des soustractions et des multiplications simples."),
(   30 ,  7,  6, "Résoudre des problèmes relevant de l’addition, de la soustraction et de la multiplication."),
(   31 ,  7,  7, "Utiliser les fonctions de base de la calculatrice."),
(   32 ,  8,  0, "Situer un objet par rapport à soi ou à un autre objet, donner sa position et décrire son déplacement."),
(   33 ,  8,  1, "Reconnaître, nommer et décrire les figures planes et les solides usuels."),
(   34 ,  8,  2, "Utiliser la règle et l’équerre pour tracer avec soin et précision un carré, un rectangle, un triangle rectangle."),
(   35 ,  8,  3, "Percevoir et reconnaître quelques relations et propriétés géométriques : alignement, angle droit, axe de symétrie, égalité de longueurs."),
(   36 ,  8,  4, "Repérer des cases, des nœuds d’un quadrillage."),
(   37 ,  8,  5, "Résoudre un problème géométrique."),
(   38 ,  9,  0, "Utiliser les unités usuelles de mesure ; estimer une mesure."),
(   39 ,  9,  1, "Être précis et soigneux dans les mesures et les calculs."),
(   40 ,  9,  2, "Résoudre des problèmes de longueur et de masse."),
(   41 , 10,  0, "Utiliser un tableau, un graphique."),
(   42 , 10,  1, "Organiser les données d’un énoncé."),
(   43 , 11,  0, "Reconnaître les emblèmes et les symboles de la République française."),
(   44 , 12,  0, "Respecter les autres et les règles de la vie collective."),
(   45 , 12,  1, "Pratiquer un jeu ou un sport collectif en en respectant les règles."),
(   46 , 12,  2, "Appliquer les codes de la politesse dans ses relations avec ses camarades, avec les adultes de l’école et hors de l’école, avec le maître au sein de la classe.");

ALTER TABLE sacoche_socle_entree ENABLE KEYS;
