<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2015
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d'Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}
if(($_SESSION['SESAMATH_ID']==ID_DEMO)&&($_POST['f_action']!='Afficher_bilan')){Json::end( FALSE , 'Action désactivée pour la démo.' );}

$action       = (isset($_POST['f_action']))       ? Clean::texte($_POST['f_action'])        : '';
$eleve_id     = (isset($_POST['f_user']))         ? Clean::entier($_POST['f_user'])         : 0;
$palier_id    = (isset($_POST['f_palier']))       ? Clean::entier($_POST['f_palier'])       : 0;
$pilier_id    = (isset($_POST['f_pilier']))       ? Clean::entier($_POST['f_pilier'])       : 0;
$delete_id    = (isset($_POST['delete_id']))      ? Clean::texte($_POST['delete_id'])       : '';
$groupe_type  = (isset($_POST['f_groupe_type']))  ? Clean::lettres($_POST['f_groupe_type']) : '';
$eleves_ordre = (isset($_POST['f_eleves_ordre'])) ? Clean::texte($_POST['f_eleves_ordre'])  : '';
// Normalement ce sont des tableaux qui sont transmis, mais au cas où...
$tab_pilier   = (isset($_POST['f_pilier'])) ? ( (is_array($_POST['f_pilier'])) ? $_POST['f_pilier'] : explode(',',$_POST['f_pilier']) ) : array() ;
$tab_eleve    = (isset($_POST['f_eleve']))  ? ( (is_array($_POST['f_eleve']))  ? $_POST['f_eleve']  : explode(',',$_POST['f_eleve'])  ) : array() ;
$tab_pilier   = array_filter( Clean::map('entier',$tab_pilier) , 'positif' );
$tab_eleve    = array_filter( Clean::map('entier',$tab_eleve)  , 'positif' );

$listing_eleve_id = implode(',',$tab_eleve);

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Afficher le tableau avec les états de validations ET NE CONSERVER QUE LES VALIDATIONS POSITIVES
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if( ($action=='Afficher_bilan') && $palier_id && count($tab_pilier) && count($tab_eleve) && $groupe_type && $eleves_ordre )
{
  Form::save_choix('validation_socle_pilier');
  $affichage = '';
  // Tableau des langues
  $tfoot = '';
  require(CHEMIN_DOSSIER_INCLUDE.'tableau_langues_socle.php');
  // Récupérer les données des élèves
  $eleves_ordre = ($groupe_type=='Classes') ? 'alpha' : $eleves_ordre ;
  $tab_eleve_infos = DB_STRUCTURE_BILAN::DB_lister_eleves_cibles( $listing_eleve_id , $eleves_ordre , FALSE /*with_gepi*/ , TRUE /*with_langue*/ , FALSE /*with_brevet_serie*/ );
  if(!is_array($tab_eleve_infos))
  {
    Json::end( FALSE , 'Aucun élève trouvé correspondant aux identifiants transmis !' );
  }
  // Afficher la première ligne du tableau avec les étiquettes des élèves
  $tab_eleve_id = array(); // listing des ids des élèves mis à jour au cas où la récupération dans la base soit différente des ids transmis...
  $affichage .= '<thead><tr>';
  foreach($tab_eleve_infos as $eleve_id => $tab_eleve)
  {
    extract($tab_eleve);  // $eleve_nom $eleve_prenom $eleve_id_gepi
    $affichage .= '<th><img id="I'.$eleve_id.'" alt="'.html($eleve_nom.' '.$eleve_prenom).'" src="./_img/php/etiquette.php?dossier='.$_SESSION['BASE'].'&amp;nom='.urlencode($eleve_nom).'&amp;prenom='.urlencode($eleve_prenom).'" /></th>';
    $tfoot .= '<td class="L'.$eleve_langue.'" title="'.$tab_langues[$eleve_langue]['texte'].'"></td>';
    $tab_eleve_id[] = $eleve_id;
  }
  $affichage .= '<th class="nu">&nbsp;&nbsp;&nbsp;</th>';
  $affichage .= '<th class="nu">';
  $affichage .=   '<p class="danger">Outil à utiliser avec parcimonie, uniquement pour rectifier des erreurs de saisie.</p>';
  $affichage .=   '<div id="confirmation" style="opacity:0">';
  $affichage .=     '<ul class="puce"><li id="report_nom"></li><li id="report_compet"></li></ul>';
  $affichage .=     '<input type="hidden" id="f_valid" name="f_valid" val="" /><button id="Enregistrer_validation" type="button" class="valider">Confirmer la suppression de cette validation</button><label id="ajax_msg_validation"></label>';
  $affichage .=   '</div>';
  $affichage .=   '<div><button id="fermer_zone_validation" type="button" class="retourner">Retour</button></div>';
  $affichage .=   '<div class="m1 b p">@PALIER@</div>';
  $affichage .= '</th>';
  $affichage .= '</tr></thead>';
  $affichage .= '<tbody>';
  // Récupérer l'arborescence des piliers du palier du socle (enfin... uniquement les piliers, ça suffit ici)
  $tab_pilier_id = array(); // listing des ids des piliers mis à jour au cas où la récupération dans la base soit différente des ids transmis...
  $DB_TAB = DB_STRUCTURE_SOCLE::DB_recuperer_piliers($palier_id);
  foreach($DB_TAB as $DB_ROW)
  {
    $pilier_id = $DB_ROW['rubrique_id'];
    if(in_array($pilier_id,$tab_pilier))
    {
      $tab_pilier_id[] = $pilier_id;
      // Afficher la ligne du tableau avec les validations des piliers, puis le nom du pilier (officiellement compétence)
      $affichage .= '<tr>';
      foreach($tab_eleve_id as $eleve_id)
      {
        $affichage .= '<td id="U'.$eleve_id.'C'.$pilier_id.'" class="V3"></td>';
      }
      $affichage .= '<th class="nu" colspan="2"><div class="n1">'.html($DB_ROW['rubrique_nom']).'</div></th>';
      $affichage .= '</tr>';
    }
  }
  $affichage .= '</tbody>';
  // Ligne avec le drapeau de la LV, si compétence concernée sélectionnée.
  $affichage .= count(array_intersect($tab_pilier_id,$tab_langue_piliers)) ? '<tfoot>'.$tfoot.'<th class="nu" colspan="3"></th></tfoot>' : '' ;
  // Récupérer la liste des jointures (validations)
  $listing_eleve_id  = implode(',',$tab_eleve_id);
  $listing_pilier_id = implode(',',$tab_pilier_id);
  $DB_TAB = DB_STRUCTURE_SOCLE::DB_lister_jointure_user_pilier($listing_eleve_id,$listing_pilier_id,$palier_id=0); // en fait on connait aussi le palier mais la requête est plus simple (pas de jointure) avec les piliers
  $tab_bad = array();
  $tab_bon = array();
  foreach($DB_TAB as $DB_ROW)
  {
    if($DB_ROW['validation_pilier_etat'])
    {
      $tab_bad[] = 'U'.$DB_ROW['user_id'].'C'.$DB_ROW['pilier_id'].'" class="V3">';
      $tab_bon[] = 'U'.$DB_ROW['user_id'].'C'.$DB_ROW['pilier_id'].'" class="V'.$DB_ROW['validation_pilier_etat'].'" title="Validé le '.To::date_mysql_to_french($DB_ROW['validation_pilier_date']).' par '.html($DB_ROW['validation_pilier_info']).'" data-etat="lock">';
    }
  }
  $affichage = str_replace($tab_bad,$tab_bon,$affichage);
  // Afficher le résultat
  Json::end( TRUE , $affichage );
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Supprimer une validation positive
// ////////////////////////////////////////////////////////////////////////////////////////////////////

elseif( ($action=='Enregistrer_validation') && ($delete_id) )
{
  // Récupérer le duo {eleve;pilier}
  $string_infos = str_replace( array('U','C') , '_' , $delete_id);
  list($rien,$eleve_id,$pilier_id) = explode('_',$string_infos);
  // Mettre à jour la base
  DB_STRUCTURE_SOCLE::DB_supprimer_validation('pilier',$eleve_id,$pilier_id);
  Json::end( TRUE );
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// On ne devrait pas en arriver là...
// ////////////////////////////////////////////////////////////////////////////////////////////////////

Json::end( FALSE , 'Erreur avec les données transmises !' );

?>
