DROP TABLE IF EXISTS sacoche_matiere;

-- Attention : pas d`apostrophes dans les lignes commentées sinon on peut obtenir un bug d`analyse dans la classe pdo de SebR : "SQLSTATE[HY093]: Invalid parameter number: no parameters were bound ..."

CREATE TABLE sacoche_matiere (
  matiere_id          SMALLINT(5) UNSIGNED                NOT NULL AUTO_INCREMENT,
  matiere_active      TINYINT(1)  UNSIGNED                NOT NULL DEFAULT 0,
  matiere_usuelle     TINYINT(1)  UNSIGNED                NOT NULL DEFAULT 0,
  matiere_famille_id  TINYINT(3)  UNSIGNED                NOT NULL DEFAULT 0,
  matiere_nb_demandes TINYINT(3)  UNSIGNED                NOT NULL DEFAULT 0,
  matiere_ordre       TINYINT(3)  UNSIGNED                NOT NULL DEFAULT 255,
  matiere_ref         VARCHAR(5)  COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  matiere_nom         VARCHAR(63) COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  PRIMARY KEY (matiere_id),
  KEY matiere_active (matiere_active),
  KEY matiere_famille_id (matiere_famille_id),
  FULLTEXT KEY matiere_nom (matiere_nom)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE sacoche_matiere DISABLE KEYS;

-- Attention : sur certains LCS le module pdo_mysql bloque au dela de 40 instructions envoyées d`un coup (mais un INSERT multiple avec des milliers de lignes ne pose pas de pb).

INSERT INTO sacoche_matiere VALUES

-- Activités non spécialisées

(   1, 0, 0, 100, 0, 255, "PBSCU", "Problèmes socioculturels"),
(   2, 0, 0, 100, 0, 255, "CPORT", "Comportement"),
(   3, 0, 0, 100, 0, 255, "ACAUT", "Activités autonomes"),
(   4, 0, 0, 100, 0, 255, "STAGE", "Stages"),
(   5, 0, 0, 100, 0, 255, "EDSCU", "Education socioculturelle"),
(   6, 0, 0, 100, 0, 255, "P-STA", "Préparation stages"),
(   7, 0, 0, 100, 0, 255, "ACPER", "Activités personnelles"),
(   8, 0, 0, 100, 0, 255, "F-GEN", "Formation générale"),
(   9, 0, 0, 100, 0, 255, "ETPRA", "Étude pratique (ses)"),
(  10, 0, 0, 100, 0, 255, "F-PRO", "Formation professionnelle (ses)"),
(  11, 0, 0, 100, 0, 255, "IMTRA", "Information monde travail"),
(  12, 0, 0, 100, 0, 255, "F-PRA", "Formation pratique"),
(  13, 0, 0, 100, 0, 255, "PR-PF", "Pratiques professionnelles"),
(  14, 0, 0, 100, 0, 255, "SOUTN", "Soutien"),
(  15, 0, 0, 100, 0, 255, "ALLEG", "Allègement"),
(  16, 0, 0, 100, 0, 255, "HYGSC", "Hygiène sécurité"),
(  17, 0, 0, 100, 0, 255, "CULGE", "Culture générale"),
(  18, 0, 0, 100, 0, 255, "MADIV", "Matières diverses"),
(  19, 0, 0, 100, 0, 255, "ACMIP", "Activités en milieu professionnel"),
(  20, 0, 0, 100, 0, 255, "ACPPD", "Activités personnelles et professionnelles dirigées"),
(  21, 0, 0, 100, 0, 255, "I-RHU", "Initiation aux relations humaines"),
(  22, 0, 0, 100, 0, 255, "MOADP", "Modules d'adaptation"),
(  23, 0, 0, 100, 0, 255, "TPE"  , "Travaux personnels encadrés"),
(  24, 0, 0, 100, 0, 255, "ACALI", "Accès en autonomie au labo.informatique"),
(  25, 0, 0, 100, 0, 255, "REHUM", "Relations humaines"),
(  26, 0, 0, 100, 0, 255, "F-RHU", "Formation relations humaines"),
(  27, 0, 0, 100, 0, 255, "EDGTM", "Education gestuelle Travaux manuels (ses)"),
(  28, 0, 0, 100, 0, 255, "BRIDG", "Bridge"),
(  29, 0, 0, 100, 0, 255, "BRAIL", "Braille"),
(  30, 0, 0, 100, 0, 255, "PR-SC", "Pratiques sociales et culturelles"),
(  31, 0, 0, 100, 0, 255, "MODUL", "Module"),
(  32, 0, 0, 100, 0, 255, "AMEXP", "Acquisition des moyens d'expression"),
(  33, 0, 0, 100, 0, 255, "TX-IP", "Travaux initiative personnelle encadrés"),
(  34, 0, 0, 100, 0, 255, "EDUOR", "Education à l'orientation"),
(  35, 0, 0, 100, 0, 255, "PPCP" , "Projet pluridisciplinaire à caractère professionnel"),
(  36, 0, 0, 100, 0, 255, "APD"  , "Activités professionnelles dirigées"),
(  37, 0, 0, 100, 0, 255, "ATRAV", "Accompagnement du travail personnel"),
(  38, 0, 0, 100, 0, 255, "D-SCO", "Traitement des difficultés scolaires"),
(  39, 0, 0, 100, 0, 255, "VIPRO", "Aide à la vie professionnelle"),
(  40, 0, 0, 100, 0, 255, "IDNCH", "Itinéraire découverte - nature corps humain"),
(  41, 0, 0, 100, 0, 255, "IDARH", "Itinéraire découverte - arts humanité"),
(  42, 0, 0, 100, 0, 255, "IDLCI", "Itinéraire découverte - langues civilisations"),
(  43, 0, 0, 100, 0, 255, "IDCTQ", "Itinéraire découverte - création techniques"),
(  44, 0, 0, 100, 0, 255, "DLIAR", "Domaine littéraire et artistique"),
(  45, 0, 0, 100, 0, 255, "DPRJT", "Démarche de projet"),
(  46, 0, 0, 100, 0, 255, "IDAUT", "Itinéraire découverte - autres"),
(  47, 0, 0, 100, 0, 255, "MODRE", "Module régional"),
(  48, 0, 0, 100, 0, 255, "ASECT", "Approfondissement sectoriel"),
(  49, 0, 0, 100, 0, 255, "LABCC", "Laboratoire de création et de conception"),
(  50, 0, 0, 100, 0, 255, "DP3H" , "Découverte professionnelle 3 heures"),
(  51, 0, 0, 100, 0, 255, "DP6H" , "Découverte professionnelle 6 heures"),
(  52, 0, 0, 100, 0, 255, "CGEXP", "Culture générale et expression"),
(  53, 0, 0, 100, 0, 255, "SIGNE", "Langue des signes"),
(  54, 0, 1, 100, 0, 255, "VISCO", "Vie scolaire"),
(  55, 0, 0, 100, 0, 255, "SECUR", "Sécurité"),
(  56, 0, 0, 100, 0, 255, "PPENC", "Projet pluritechnique encadré"),
(  57, 0, 0, 100, 0, 255, "RELAP", "Relations professionnelles"),
(  58, 0, 0, 100, 0, 255, "METHO", "Modules méthodologiques"),
(  59, 0, 0, 100, 0, 255, "PPAPP", "Projets professionnels appliqués"),
(  60, 0, 0, 100, 0, 255, "CMPRO", "Connaissance du milieu professionnel"),
(  61, 0, 0, 100, 0, 255, "APAMO", "Aide au partenariat et à la mobilité"),
(  62, 0, 0, 100, 0, 255, "ACDEL", "Activités déléguées"),
(  63, 0, 0, 100, 0, 255, "ATMET", "Ateliers métiers"),
(  64, 0, 0, 100, 0, 255, "ATLIE", "Atelier(s)"),
(  65, 0, 0, 100, 0, 255, "AALIC", "Acces auton. labo informatiq. & communication"),
(  66, 0, 0, 100, 0, 255, "ACCPE", "Accompagnement personnalisé"),
(  67, 0, 0, 100, 0, 255, "INVES", "Méthodologie d'investigation"),
(  68, 0, 0, 100, 0, 255, "CGENX", "Culture générale et expression"),
(  69, 0, 0, 100, 0, 255, "ARTS" , "Arts"),
(  70, 0, 0, 100, 0, 255, "MEPRO", "Méthodologie de projet"),
(  71, 0, 0, 100, 0, 255, "MRECH", "Méthodologie de recherche"),
(  72, 0, 0, 100, 0, 255, "ISIC" , "Isic"),
(  73, 0, 0, 100, 0, 255, "ISAP" , "Isap"),
(  74, 0, 0, 100, 0, 255, "DECPR", "Découverte professionnelle"),
(  75, 0, 0, 100, 0, 255, "ACIND", "Activités inter-disciplinaires"),
(  76, 0, 0, 100, 0, 255, "ACTPR", "Activités de projet"),
(  77, 0, 0, 100, 0, 255, "CERPR", "Certification professionnelle"),
(  78, 0, 0, 100, 0, 255, "AAEPR", "Accès autonomie équipements professionnels"),
(  79, 0, 0, 100, 0, 255, "APDPR", "Approche pluridisciplinaire & dimension professionnelle"),
(  80, 0, 0, 100, 0, 255, "MOENG", "Modules (français - maths - hist.geo - LV1)"),
(  81, 0, 0, 100, 0, 255, "AAALO", "Actions appliquées et d'adaptation locale"),
(  82, 0, 0, 100, 0, 255, "ARRDI", "Accès en responsabilité aux ress. doc. informatisées ets"),
(  83, 0, 0, 100, 0, 255, "ETUDE", "Études (dirigées ou encadrées)"),
(  84, 0, 0, 100, 0, 255, "VICLA", "Vie de la classe"),
(  85, 0, 0, 100, 0, 255, "AIAUT", "Aide individualisée autres matières"),
(  86, 0, 0, 100, 0, 255, "RANIV", "Remise à niveau"),
(  87, 0, 0, 100, 0, 255, "AIDIN", "Aide individualisée"),
(  88, 0, 0, 100, 0, 255, "ACTIP", "Action professionnelle"),
(  89, 0, 0, 100, 0, 255, "STRTI", "Stratégie et techniques d'intervention"),
(  90, 0, 0, 100, 0, 255, "MEQUI", "Management d'équipe"),
(  91, 0, 0, 100, 0, 255, "EPE"  , "Étude personnalisée encadrée"),
(  92, 0, 0, 100, 0, 255, "ATELP", "Atelier de professionnalisation"),
(  93, 0, 0, 100, 0, 255, "FILOC", "Formation d'initiative locale"),
(  94, 0, 0, 100, 0, 255, "AT-PX", "Ateliers principaux"),
(  95, 0, 0, 100, 0, 255, "AT-CO", "Ateliers complémentaires"),
(  96, 0, 0, 100, 0, 255, "COMPR", "Connaissance des milieux professionnels"),
(  97, 0, 0, 100, 0, 255, "PROPR", "Projet professionnel"),
(  98, 0, 0, 100, 0, 255, "AEAID", "Acccompagn.éducatif - aide devoirs leçons"),
(  99, 0, 0, 100, 0, 255, "ACNSD", "Activités non spécialisées diverses"),

-- Philosophie sciences humaines

( 101, 0, 0,   1, 0, 255, "CULSH", "Culture générale et sciences humaines"),
( 102, 0, 0,   1, 0, 255, "PHI-R", "Philosophie renforcée"),
( 103, 0, 1,   1, 0, 255, "PHILO", "Philosophie"),
( 104, 0, 0,   1, 0, 255, "SCHUM", "Sciences humaines"),
( 106, 0, 0,   1, 0, 255, "PSY-S", "Psychologie sociologie"),
( 107, 0, 0,   1, 0, 255, "PSY-P", "Psychologie - psychosociologie"),
( 108, 0, 0,   1, 0, 255, "SOCIO", "Sociologie"),
( 109, 0, 0,   1, 0, 255, "ESTSE", "Esthétique sémiologie"),
( 110, 0, 0,   1, 0, 255, "PSYKO", "Psychologie"),
( 111, 0, 0,   1, 0, 255, "PSY-G", "Psychologie et pédagogie"),
( 112, 0, 0,   1, 0, 255, "PSYSE", "Psycho-sociologie - esthétique - sémiologie"),
( 113, 0, 0,   1, 0, 255, "PSYCO", "Psychologie de la communication"),
( 114, 0, 0,   1, 0, 255, "IMACS", "Image:communication sémiologie - esthétique"),
( 115, 0, 0,   1, 0, 255, "PHIAR", "Philosophie générale de l'art"),
( 116, 0, 0,   1, 0, 255, "SEMIO", "Sémiologie"),
( 117, 0, 0,   1, 0, 255, "CULSP", "Culture du spectacle"),
( 118, 0, 0,   1, 0, 255, "C-COM", "Cultures de la communication"),
( 119, 0, 0,   1, 0, 255, "S-PSY", "Sensibilisation concepts psy etc"),
( 120, 0, 0,   1, 0, 255, "CPOLI", "Connaissance des politiques institutions"),
( 199, 0, 0,   1, 0, 255, "PHI-H", "Philosophie sciences humaines divers"),

-- Lettres

( 201, 0, 1,   2, 0, 255, "LATIN", "Latin"),
( 202, 0, 1,   2, 0, 255, "GREC" , "Grec ancien"),
( 203, 0, 0,   2, 0, 255, "LCALA", "Langues et cultures de l'antiquité latine"),
( 204, 0, 0,   2, 0, 255, "LCAGR", "Langues et cultures de l'antiquité grecque"),
( 205, 0, 0,   2, 0, 255, "FR-PA", "Français et éléments de psychologie appliquée"),
( 206, 0, 0,   2, 0, 255, "EX-RU", "Expression française - relations humaines"),
( 207, 0, 1,   2, 0, 255, "FRANC", "Français"),
( 208, 0, 0,   2, 0, 255, "FR-MO", "Franchis module"),
( 209, 0, 0,   2, 0, 255, "LITSO", "Littérature & société"),
( 210, 0, 0,   2, 0, 255, "THEME", "Thème"),
( 211, 0, 0,   2, 0, 255, "FR-MT", "Français maths (ses)"),
( 212, 0, 0,   2, 0, 255, "CULEF", "Culture et expression française"),
( 213, 0, 0,   2, 0, 255, "EXPRS", "Expression"),
( 214, 0, 0,   2, 0, 255, "EX-FR", "Expression française"),
( 215, 0, 0,   2, 0, 255, "T-EEO", "Techniques d'expression écrite et orale"),
( 216, 0, 0,   2, 0, 255, "FR-SH", "Français sciences humaines"),
( 217, 0, 0,   2, 0, 255, "FR-PE", "Français et problèmes économiques"),
( 218, 0, 0,   2, 0, 255, "T-ANA", "Techniques d'analyse"),
( 219, 0, 0,   2, 0, 255, "EVLAR", "Environnement littéraire et artistique"),
( 220, 0, 0,   2, 0, 255, "ECEXF", "Ecriture et expression française"),
( 221, 0, 0,   2, 0, 255, "FR-HG", "Français - histoire - géographie"),
( 223, 0, 0,   2, 0, 255, "LETTR", "Lettres"),
( 224, 0, 0,   2, 0, 255, "GRESP", "Grec spécialité"),
( 225, 0, 0,   2, 0, 255, "LATSP", "Latin spécialité"),
( 226, 0, 0,   2, 0, 255, "CGPCO", "Culture générale pratique de la communication"),
( 227, 0, 0,   2, 0, 255, "FR-PH", "Français philosophie"),
( 228, 0, 0,   2, 0, 255, "CULCO", "Culture et communication"),
( 229, 0, 0,   2, 0, 255, "LITCI", "Littérature et civilisation étrangère"),
( 230, 0, 0,   2, 0, 255, "LCR"  , "Langues et cultures régionales"),
( 231, 0, 0,   2, 0, 255, "AIFRA", "Aide individualisée en français"),
( 232, 0, 0,   2, 0, 255, "FRLIT", "Français et littérature"),
( 233, 0, 0,   2, 0, 255, "LITTE", "Littérature"),
( 234, 0, 0,   2, 0, 255, "CUGEX", "Culture générale et expression"),
( 235, 0, 0,   2, 0, 255, "FHGEC", "Français - histoire-géo. - éduc. civique"),
( 299, 0, 0,   2, 0, 255, "LETDI", "Lettres divers"),

-- Langues vivantes

( 300, 0, 0,   3, 0, 255, "FLE"  , "Français langue étrangère"),
( 301, 0, 0,   3, 0, 255, "ALL"  , "Allemand"),
( 302, 0, 0,   3, 0, 255, "AGL"  , "Anglais"),
( 303, 0, 0,   3, 0, 255, "ARA"  , "Arabe"),
( 304, 0, 0,   3, 0, 255, "CHI"  , "Chinois"),
( 305, 0, 0,   3, 0, 255, "DAN"  , "Danois"),
( 306, 0, 0,   3, 0, 255, "ESP"  , "Espagnol"),
( 309, 0, 0,   3, 0, 255, "ITA"  , "Italien"),
( 310, 0, 0,   3, 0, 255, "JAP"  , "Japonais"),
( 311, 0, 0,   3, 0, 255, "POR"  , "Portugais"),
( 312, 0, 0,   3, 0, 255, "NEE"  , "Néerlandais"),
( 313, 0, 0,   3, 0, 255, "POL"  , "Polonais"),
( 314, 0, 0,   3, 0, 255, "RUS"  , "Russe"),
( 315, 0, 1,   3, 0, 255, "ALL1" , "Allemand LV1"),
( 316, 0, 1,   3, 0, 255, "AGL1" , "Anglais LV1"),
( 317, 0, 0,   3, 0, 255, "ARA1" , "Arabe LV1"),
( 318, 0, 0,   3, 0, 255, "CHI1" , "Chinois LV1"),
( 319, 0, 0,   3, 0, 255, "DAN1" , "Danois LV1"),
( 320, 0, 1,   3, 0, 255, "ESP1" , "Espagnol LV1"),
( 321, 0, 0,   3, 0, 255, "ITA1" , "Italien LV1"),
( 322, 0, 0,   3, 0, 255, "JAP1" , "Japonais LV1"),
( 323, 0, 0,   3, 0, 255, "POR1" , "Portugais LV1"),
( 324, 0, 0,   3, 0, 255, "NEE1" , "Néerlandais LV1"),
( 325, 0, 0,   3, 0, 255, "POL1" , "Polonais LV1"),
( 326, 0, 0,   3, 0, 255, "RUS1" , "Russe LV1"),
( 327, 0, 1,   3, 0, 255, "ALL2" , "Allemand LV2"),
( 328, 0, 1,   3, 0, 255, "AGL2" , "Anglais LV2"),
( 329, 0, 0,   3, 0, 255, "ARA2" , "Arabe LV2"),
( 330, 0, 0,   3, 0, 255, "CHI2" , "Chinois LV2"),
( 331, 0, 0,   3, 0, 255, "DAN2" , "Danois LV2"),
( 332, 0, 1,   3, 0, 255, "ESP2" , "Espagnol LV2"),
( 333, 0, 0,   3, 0, 255, "ITA2" , "Italien LV2"),
( 334, 0, 0,   3, 0, 255, "JAP2" , "Japonais LV2"),
( 335, 0, 0,   3, 0, 255, "POR2" , "Portugais LV2"),
( 336, 0, 0,   3, 0, 255, "NEE2" , "Néerlandais LV2"),
( 337, 0, 0,   3, 0, 255, "POL2" , "Polonais LV2"),
( 338, 0, 0,   3, 0, 255, "RUS2" , "Russe LV2"),
( 339, 0, 0,   3, 0, 255, "ALL3" , "Allemand LV3"),
( 340, 0, 0,   3, 0, 255, "AGL3" , "Anglais LV3"),
( 341, 0, 0,   3, 0, 255, "ARA3" , "Arabe LV3"),
( 342, 0, 0,   3, 0, 255, "CHI3" , "Chinois LV3"),
( 343, 0, 0,   3, 0, 255, "DAN3" , "Danois LV3"),
( 344, 0, 0,   3, 0, 255, "ESP3" , "Espagnol LV3"),
( 345, 0, 0,   3, 0, 255, "ITA3" , "Italien LV3"),
( 346, 0, 0,   3, 0, 255, "JAP3" , "Japonais LV3"),
( 347, 0, 0,   3, 0, 255, "POR3" , "Portugais LV3"),
( 348, 0, 0,   3, 0, 255, "NEE3" , "Néerlandais LV3"),
( 349, 0, 0,   3, 0, 255, "POL3" , "Polonais LV3"),
( 350, 0, 0,   3, 0, 255, "RUS3" , "Russe LV3"),
( 351, 0, 0,   3, 0, 255, "ALL4" , "Allemand renforcé"),
( 352, 0, 0,   3, 0, 255, "AGL4" , "Anglais renforcé"),
( 353, 0, 0,   3, 0, 255, "ARA4" , "Arabe renforcé"),
( 354, 0, 0,   3, 0, 255, "CHI4" , "Chinois renforcé"),
( 355, 0, 0,   3, 0, 255, "DAN4" , "Danois renforcé"),
( 356, 0, 0,   3, 0, 255, "ESP4" , "Espagnol renforcé"),
( 357, 0, 0,   3, 0, 255, "ITA4" , "Italien renforcé"),
( 358, 0, 0,   3, 0, 255, "JAP4" , "Japonais renforcé"),
( 359, 0, 0,   3, 0, 255, "POR4" , "Portugais renforcé"),
( 360, 0, 0,   3, 0, 255, "NEE4" , "Néerlandais renforcé"),
( 361, 0, 0,   3, 0, 255, "POL4" , "Polonais renforcé"),
( 362, 0, 0,   3, 0, 255, "RUS4" , "Russe renforcé"),
( 363, 0, 0,   3, 0, 255, "ALLS" , "Allemand section européenne"),
( 364, 0, 0,   3, 0, 255, "AGLS" , "Anglais section européenne"),
( 365, 0, 0,   3, 0, 255, "ARAS" , "Arabe section européenne"),
( 366, 0, 0,   3, 0, 255, "CHIS" , "Chinois section européenne"),
( 367, 0, 0,   3, 0, 255, "DANS" , "Danois section européenne"),
( 368, 0, 0,   3, 0, 255, "ESPS" , "Espagnol section européenne"),
( 369, 0, 0,   3, 0, 255, "ITAS" , "Italien section européenne"),
( 370, 0, 0,   3, 0, 255, "JAPS" , "Japonais section européenne"),
( 371, 0, 0,   3, 0, 255, "PORS" , "Portugais section européenne"),
( 372, 0, 0,   3, 0, 255, "NEES" , "Néerlandais section européenne"),
( 373, 0, 0,   3, 0, 255, "POLS" , "Polonais section européenne"),
( 374, 0, 0,   3, 0, 255, "RUSS" , "Russe section européenne"),
( 375, 0, 0,   3, 0, 255, "ALL9" , "Allemand lettres étrangères"),
( 376, 0, 0,   3, 0, 255, "AGL9" , "Anglais lettres étrangères"),
( 377, 0, 0,   3, 0, 255, "ARA9" , "Arabe lettres étrangères"),
( 378, 0, 0,   3, 0, 255, "CHI9" , "Chinois lettres étrangères"),
( 379, 0, 0,   3, 0, 255, "DAN9" , "Danois lettres étrangères"),
( 380, 0, 0,   3, 0, 255, "ESP9" , "Espagnol lettres étrangères"),
( 381, 0, 0,   3, 0, 255, "ITA9" , "Italien lettres étrangères"),
( 382, 0, 0,   3, 0, 255, "JAP9" , "Japonais lettres étrangères"),
( 383, 0, 0,   3, 0, 255, "POR9" , "Portugais lettres étrangères"),
( 384, 0, 0,   3, 0, 255, "NEE9" , "Néerlandais lettres étrangères"),
( 385, 0, 0,   3, 0, 255, "POL9" , "Polonais lettres étrangères"),
( 386, 0, 0,   3, 0, 255, "RUS9" , "Russe lettres étrangères"),
( 387, 0, 0,   3, 0, 255, "ALL8" , "Littérature étrangère en allemand"),
( 388, 0, 0,   3, 0, 255, "AGL8" , "Littérature étrangère en anglais"),
( 389, 0, 0,   3, 0, 255, "ARA8" , "Littérature étrangère en arabe"),
( 390, 0, 0,   3, 0, 255, "CHI8" , "Littérature étrangère en chinois"),
( 391, 0, 0,   3, 0, 255, "DAN8" , "Littérature étrangère en danois"),
( 392, 0, 0,   3, 0, 255, "ESP8" , "Littérature étrangère en espagnol"),
( 393, 0, 0,   3, 0, 255, "ITA8" , "Littérature étrangère en italien"),
( 394, 0, 0,   3, 0, 255, "JAP8" , "Littérature étrangère en japonais"),
( 395, 0, 0,   3, 0, 255, "POR8" , "Littérature étrangère en portugais"),
( 396, 0, 0,   3, 0, 255, "NEE8" , "Littérature étrangère en néerlandais"),
( 397, 0, 0,   3, 0, 255, "POL8" , "Littérature étrangère en polonais"),
( 398, 0, 0,   3, 0, 255, "RUS8" , "Littérature étrangère en russe"),
( 399, 0, 0,   3, 0, 255, "LANDI", "Langues divers"),

-- Histoire géographie

( 401, 0, 0,   4, 0, 255, "HIGHO", "Histoire et géographie hôtelière"),
( 402, 0, 0,   4, 0, 255, "I-MDC", "Initiation au monde contemporain"),
( 403, 0, 0,   4, 0, 255, "HIGEC", "Histoire et géographie économique"),
( 404, 0, 0,   4, 0, 255, "HIFES", "Histoire faits économiques et sociaux"),
( 405, 0, 0,   4, 0, 255, "HISTE", "Histoire sciences techniques entreprises"),
( 406, 0, 1,   4, 0, 255, "HIGEO", "Histoire et géographie"),
( 407, 0, 0,   4, 0, 255, "HIGMO", "Histoire géographie module"),
( 408, 0, 0,   4, 0, 255, "HISTO", "Histoire"),
( 409, 0, 0,   4, 0, 255, "GEOGF", "Géographie"),
( 410, 0, 0,   4, 0, 255, "GEOGT", "Géographie générale et touristique"),
( 411, 0, 0,   4, 0, 255, "GEOAT", "Géographie appliquée au tourisme"),
( 412, 0, 0,   4, 0, 255, "GEOAP", "Géographie appliquée"),
( 413, 0, 0,   4, 0, 255, "GEOEC", "Géographie économique"),
( 414, 0, 0,   4, 0, 255, "EDCIV", "Education civique"),
( 415, 0, 0,   4, 0, 255, "CO-MC", "Connaissance du monde contemporain"),
( 416, 0, 0,   4, 0, 255, "HIGIC", "Histoire - géographie - instruction civique"),
( 417, 0, 0,   4, 0, 255, "CIVLS", "Civilisation"),
( 418, 0, 0,   4, 0, 255, "HIANC", "Histoire ancienne"),
( 419, 0, 0,   4, 0, 255, "HICTX", "Histoire - commentaire de textes"),
( 420, 0, 0,   4, 0, 255, "HGECV", "Hist-géo - économie et éducation civique"),
( 421, 0, 0,   4, 0, 255, "HIGCV", "Histoire - géographie - éducation civique"),
( 422, 0, 0,   4, 0, 255, "HIGLP", "Hist - géographie - législation professionnelle"),
( 423, 0, 0,   4, 0, 255, "HICON", "Histoire contemporaine"),
( 424, 0, 0,   4, 0, 255, "HIMOD", "Histoire moderne de la France"),
( 425, 0, 0,   4, 0, 255, "GEFRA", "Géographie historique de la France"),
( 426, 0, 0,   4, 0, 255, "HIMED", "Histoire médiévale"),
( 427, 0, 0,   4, 0, 255, "HISMC", "Histoire moderne et contemporaine"),
( 428, 0, 0,   4, 0, 255, "HECRI", "Histoire des écritures"),
( 429, 0, 0,   4, 0, 255, "ECJS" , "Education civique juridique et sociale"),
( 430, 0, 0,   4, 0, 255, "GHCIV", "Géographie et histoire des civilisations"),
( 431, 0, 0,   4, 0, 255, "ANPAT", "Analyse du patrimoine"),
( 432, 0, 0,   4, 0, 255, "PATRG", "Patrimoine culturel & touristique régional"),
( 433, 0, 0,   4, 0, 255, "FHGCI", "Francais hist.geo. éducation civique"),
( 434, 0, 0,   4, 0, 255, "HIMAG", "Histoire de l'image"),
( 435, 0, 0,   4, 0, 255, "HMEMO", "Histoire médiévale & moderne"),
( 436, 0, 0,   4, 0, 255, "HGGMC", "Histoire, géographie & géopolitique du monde contemporain"),
( 437, 0, 0,   4, 0, 255, "HI-GE", "Histoire-géographie"),
( 438, 0, 1,   4, 0, 255, "EMC"  , "Enseignement moral et civique"),
( 499, 0, 0,   4, 0, 255, "HIGDV", "Histoire et géographie divers"),

-- Sciences économiques et sociales

( 501, 0, 0,   5, 0, 255, "TDECO", "Travaux dirigés d'économie"),
( 502, 0, 0,   5, 0, 255, "SECO" , "Sciences économiques"),
( 503, 0, 0,   5, 0, 255, "E-OAN", "Économie (analyse des économies)"),
( 504, 0, 0,   5, 0, 255, "I-ESC", "Initiation économique et sociale"),
( 505, 0, 0,   5, 0, 255, "I-ECO", "Initiation économique"),
( 506, 0, 0,   5, 0, 255, "STECO", "Sciences et techniques économiques"),
( 507, 0, 1,   5, 0, 255, "SES"  , "Sciences économiques et sociales"),
( 508, 0, 0,   5, 0, 255, "E-OAP", "Économie appliquée"),
( 509, 0, 0,   5, 0, 255, "E-OSS", "Économie et sciences sociales"),
( 510, 0, 0,   5, 0, 255, "E-OSO", "Économie et social"),
( 511, 0, 0,   5, 0, 255, "SESMO", "SES module"),
( 512, 0, 0,   5, 0, 255, "SESDB", "SES débutants"),
( 513, 0, 0,   5, 0, 255, "SESPE", "Sciences économiques spécialité"),
( 514, 0, 0,   5, 0, 255, "E-HSC", "Anal économ historiq sociétés contemp."),
( 515, 0, 0,   5, 0, 255, "I-SEC", "Initiation aux sciences économiques"),
( 516, 0, 0,   5, 0, 255, "SCSOC", "Sciences sociales"),
( 517, 0, 0,   5, 0, 255, "PUBLI", "Publics"),
( 518, 0, 0,   5, 0, 255, "PRESE", "Prestations et services"),
( 519, 0, 0,   5, 0, 255, "RSHUM", "Ressources humaines"),
( 520, 0, 0,   5, 0, 255, "ADDRH", "Administ. develop. ressources humaines"),
( 521, 0, 0,   5, 0, 255, "SSPOL", "Sciences sociales et politiques"),
( 522, 0, 0,   5, 0, 255, "ECOAP", "Économie approfondie"),
( 523, 0, 0,   5, 0, 255, "ESHMC", "Économie, sociologie & histoire du monde contemporain"),
( 599, 0, 0,   5, 0, 255, "SECSD", "Sciences économiques et sociales divers"),

-- Sciences

( 600, 0, 0,   6, 0, 255, "EIST" , "Enseignement intégré de science et technologie"), -- Utilisée mais pas dans la BCN...
( 601, 0, 0,   6, 0, 255, "PCAPP", "Physique et chimie appliquées"),
( 602, 0, 0,   6, 0, 255, "TPPHC", "Travaux pratiques de physique-chimie"),
( 603, 0, 0,   6, 0, 255, "CH-GE", "Chimie générale"),
( 604, 0, 0,   6, 0, 255, "CPIND", "Chimie et physique industrielles"),
( 605, 0, 0,   6, 0, 255, "TPMAT", "Travaux pratiques mathemat. sup. ou spe."),
( 606, 0, 0,   6, 0, 255, "SCIEN", "Sciences"),
( 607, 0, 0,   6, 0, 255, "MA-AI", "Mathématiques appliquées et informatique"),
( 608, 0, 0,   6, 0, 255, "TDPHY", "Travaux dirigés de physique"),
( 609, 0, 0,   6, 0, 255, "CH-MN", "Chimie minérale"),
( 610, 0, 0,   6, 0, 255, "TDMAT", "Travaux dirigés de mathématiques"),
( 611, 0, 0,   6, 0, 255, "SCAPL", "Sciences appliquées"),
( 612, 0, 0,   6, 0, 255, "CFOSC", "Complément de formation scientifique"),
( 613, 0, 1,   6, 0, 255, "MATHS", "Mathématiques"),
( 614, 0, 0,   6, 0, 255, "MA-RF", "Mathématiques renforcées"),
( 615, 0, 0,   6, 0, 255, "MA-AP", "Mathématiques appliquées"),
( 616, 0, 0,   6, 0, 255, "MA-IF", "Mathématiques informatique"),
( 617, 0, 0,   6, 0, 255, "MA-SC", "Maths sciences"),
( 618, 0, 0,   6, 0, 255, "MA-PH", "Mathématiques - sciences physiques"),
( 619, 0, 0,   6, 0, 255, "OPTIM", "Optique optoélectronique et imagerie"),
( 620, 0, 0,   6, 0, 255, "MA-SI", "Mathématiques statistiques informatique"),
( 621, 0, 0,   6, 0, 255, "MA-ST", "Mathématiques et statistiques"),
( 622, 0, 0,   6, 0, 255, "MA-ME", "Mathématiques et mécaniques"),
( 623, 0, 1,   6, 0, 255, "PH-CH", "Physique-chimie"),
( 624, 0, 0,   6, 0, 255, "SCPHY", "Sciences physiques"),
( 625, 0, 0,   6, 0, 255, "TPSPH", "TP de sciences physiques"),
( 626, 0, 0,   6, 0, 255, "PH-LI", "Physique (labo industriel et recherche)"),
( 627, 0, 0,   6, 0, 255, "PH-IN", "Physique industrielle"),
( 628, 0, 0,   6, 0, 255, "SCPHA", "Sciences physiques appliquées"),
( 629, 0, 1,   6, 0, 255, "SVT"  , "Sciences de la vie et de la terre"),
( 630, 0, 0,   6, 0, 255, "PH-AO", "Physique appliquée optique"),
( 631, 0, 0,   6, 0, 255, "PH-EL", "Physique électricité"),
( 632, 0, 0,   6, 0, 255, "CH-LI", "Chimie (labo industriel et recherche)"),
( 633, 0, 0,   6, 0, 255, "CHIMI", "Chimie"),
( 634, 0, 0,   6, 0, 255, "SCTKN", "Sciences appliquées et technologies nouvelles"),
( 635, 0, 0,   6, 0, 255, "CH-CO", "Chimie générale et chimie organique"),
( 636, 0, 0,   6, 0, 255, "CH-GI", "Chimie générale et inorganique"),
( 637, 0, 0,   6, 0, 255, "MOSPH", "Module sciences physiques"),
( 638, 0, 0,   6, 0, 255, "CH-OR", "Chimie organique"),
( 639, 0, 0,   6, 0, 255, "CH-AM", "Chimie appliquée aux matériaux"),
( 640, 0, 0,   6, 0, 255, "MA-MO", "Mathématiques module"),
( 641, 0, 0,   6, 0, 255, "OPEAC", "Optique électronique acoustique"),
( 642, 0, 0,   6, 0, 255, "PH-CM", "Physique chimie module"),
( 643, 0, 0,   6, 0, 255, "SPHSA", "Sciences physiques et sciences appliquées"),
( 644, 0, 0,   6, 0, 255, "SVTMO", "Sciences de la vie et de la terre module"),
( 645, 0, 0,   6, 0, 255, "SCNAT", "Sciences naturelles"),
( 646, 0, 0,   6, 0, 255, "LABO" , "Laboratoire"),
( 647, 0, 0,   6, 0, 255, "SPHPA", "Sciences physiques et physique appliquée"),
( 648, 0, 0,   6, 0, 255, "UIFCH", "Utilisation de l'informatique en chimie"),
( 649, 0, 0,   6, 0, 255, "IESP" , "Informatique et électronique en sc ph"),
( 650, 0, 0,   6, 0, 255, "STATI", "Statistiques"),
( 651, 0, 0,   6, 0, 255, "MA-AQ", "Mathématiques appliquées et statistiques"),
( 652, 0, 0,   6, 0, 255, "TSP"  , "Techniques des sciences physiques"),
( 653, 0, 0,   6, 0, 255, "G-SCI", "Enseignement scientifique"),
( 654, 0, 0,   6, 0, 255, "PH-MT", "Physique : mécanique - thermique - fluidique"),
( 655, 0, 0,   6, 0, 255, "CH-AP", "Chimie appliquée"),
( 656, 0, 0,   6, 0, 255, "OPPHC", "Optique et physico-chimie"),
( 657, 0, 0,   6, 0, 255, "PHYSI", "Physique"),
( 658, 0, 0,   6, 0, 255, "TPPHY", "Travaux pratiques de physique"),
( 659, 0, 0,   6, 0, 255, "TPCHI", "Travaux pratiques de chimie"),
( 660, 0, 0,   6, 0, 255, "TECSH", "Technologie et schéma"),
( 661, 0, 0,   6, 0, 255, "CSCTE", "Cadre scientifique et technologique"),
( 662, 0, 0,   6, 0, 255, "SCEXP", "Sciences expérimentales"),
( 663, 0, 0,   6, 0, 255, "MA-AS", "Mathématiques appliquées spécialité"),
( 664, 0, 0,   6, 0, 255, "MA-SP", "Mathématiques spécialité"),
( 665, 0, 0,   6, 0, 255, "PH-CS", "Physique chimie spécialité"),
( 666, 0, 0,   6, 0, 255, "SVT-S", "Sciences de la vie & de terre spécialité"),
( 667, 0, 0,   6, 0, 255, "ATGCH", "Atelier de génie chimique"),
( 668, 0, 0,   6, 0, 255, "OPTIQ", "Optique"),
( 669, 0, 0,   6, 0, 255, "SPHCA", "Sciences phys et physique chimie appliquées"),
( 670, 0, 0,   6, 0, 255, "S-IND", "Sciences industrielles"),
( 671, 0, 0,   6, 0, 255, "CHI-4", "Chimie (4 heures cpge : pcsi)"),
( 672, 0, 0,   6, 0, 255, "CHI-2", "Chimie (2eme periode cpge : psi)"),
( 673, 0, 0,   6, 0, 255, "SC-IG", "Sciences de l'ingénieur"),
( 674, 0, 0,   6, 0, 255, "CH-TC", "Chimie et technologie chimique"),
( 675, 0, 0,   6, 0, 255, "PH-TP", "Physique et technologie physique"),
( 676, 0, 0,   6, 0, 255, "S-IN4", "Sciences indust 4 heures 2e période mpsi"),
( 677, 0, 0,   6, 0, 255, "S-IN2", "Sciences industr 2 heures mpsi"),
( 678, 0, 0,   6, 0, 255, "PHCHA", "Physique appliquée - chimie appliquée"),
( 679, 0, 0,   6, 0, 255, "OPTGP", "Optique géométrique et physique"),
( 680, 0, 0,   6, 0, 255, "ETSOP", "Étude technique des systèmes optiques"),
( 681, 0, 0,   6, 0, 255, "SPCHA", "Sciences physiques et chimie appliquée"),
( 682, 0, 0,   6, 0, 255, "PCMET", "Physique chimie métallurgie"),
( 683, 0, 0,   6, 0, 255, "AIMAT", "Aide individualisée en mathématiques"),
( 684, 0, 0,   6, 0, 255, "MAPSP", "Mathématiques appliquées sc physiques"),
( 685, 0, 0,   6, 0, 255, "MATPC", "Mathématiques physique-chimie"),
( 686, 0, 0,   6, 0, 255, "MASPC", "Mathématiques sciences physiques & chimiques"),
( 687, 0, 0,   6, 0, 255, "SCIIN", "Sciences industrielles de l'ingénieur"),
( 688, 0, 0,   6, 0, 255, "PCLAB", "Physique et chimie de laboratoire"),
( 689, 0, 0,   6, 0, 255, "MPHIN", "Mesures physiques et informatique"),
( 690, 0, 0,   6, 0, 255, "ISING", "Initiation aux sciences de l'ingénieur"),
( 691, 0, 0,   6, 0, 255, "PHYAP", "Physique appliquée"),
( 692, 0, 0,   6, 0, 255, "PAUDI", "Perception auditive"),
( 693, 0, 0,   6, 0, 255, "PVISU", "Perception visuelle"),
( 694, 0, 0,   6, 0, 255, "SPHCH", "Sciences physiques et chimiques"),
( 695, 0, 0,   6, 0, 255, "SPCAP", "Sciences physiques&chimiques appliquées"),
( 696, 0, 0,   6, 0, 255, "MP-SC", "Méthodes & pratiques scientifiques"),
( 697, 0, 0,   6, 0, 255, "SCLAB", "Sciences physiques et chimiques en labo."),
( 698, 0, 0,   6, 0, 255, "MATAP", "Mathématiques approfondies"),
( 699, 0, 0,   6, 0, 255, "SCDIV", "Sciences divers"),

-- Technologie

( 701, 0, 0,   7, 0, 255, "TECTD", "Technologie et travaux dirigés"),
( 702, 0, 0,   7, 0, 255, "TECRE", "Technologie et réalisation"),
( 703, 0, 0,   7, 0, 255, "TECAV", "Technologie appliquée au véhicule"),
( 704, 0, 0,   7, 0, 255, "MESAU", "Mesures et automatismes"),
( 705, 0, 0,   7, 0, 255, "T-IND", "Techniques industrielles"),
( 706, 0, 0,   7, 0, 255, "TECAI", "Technologie et automatismes industriels"),
( 707, 0, 0,   7, 0, 255, "CNTRE", "Contrôle et régulation"),
( 708, 0, 1,   7, 0, 255, "TECHN", "Technologie"),
( 709, 0, 0,   7, 0, 255, "TECGL", "Technologie générale"),
( 710, 0, 0,   7, 0, 255, "ENPRO", "Enseignement professionnel"),
( 711, 0, 0,   7, 0, 255, "G-TPR", "Enseignement technologique-professionnel"),
( 712, 0, 0,   7, 0, 255, "T-REA", "Technique et réalisation"),
( 713, 0, 0,   7, 0, 255, "TECIN", "Technologie industrielle"),
( 714, 0, 0,   7, 0, 255, "TECMT", "Technologie appliquée moteur-transmission"),
( 715, 0, 0,   7, 0, 255, "D-TEC", "Dessin et technologie"),
( 716, 0, 0,   7, 0, 255, "TECPR", "Technologie professionnelle"),
( 717, 0, 0,   7, 0, 255, "TECTA", "Technologie et travaux d'atelier"),
( 718, 0, 0,   7, 0, 255, "TECIM", "Technologie industrielle module"),
( 719, 0, 0,   7, 0, 255, "ATCTK", "Atelier de conception - technologie"),
( 720, 0, 0,   7, 0, 255, "TREAL", "Technologie de réalisation"),
( 721, 0, 0,   7, 0, 255, "TECME", "Technologie : métallurgie"),
( 722, 0, 0,   7, 0, 255, "TECDE", "Technologie et dessin"),
( 723, 0, 0,   7, 0, 255, "TECES", "Technologie des équipements et supports"),
( 724, 0, 0,   7, 0, 255, "T-MEO", "Techniques et mise en œuvre"),
( 725, 0, 0,   7, 0, 255, "TMNUM", "Technologie des médias numériques"),
( 726, 0, 0,   7, 0, 255, "MOETP", "Module: enseign. techno. et professionnel."),
( 727, 0, 0,   7, 0, 255, "ETDIF", "Enseignement technologique différencié"),
( 728, 0, 0,   7, 0, 255, "QUAEX", "Qualité expérimentation"),
( 729, 0, 0,   7, 0, 255, "NOUTK", "Nouvelles technologies"),
( 730, 0, 0,   7, 0, 255, "TCMET", "Technologie - méthodes"),
( 731, 0, 0,   7, 0, 255, "SCTCI", "Sciences et techniques industrielles"),
( 732, 0, 0,   7, 0, 255, "ENSTC", "Enseignement technique"),
( 733, 0, 0,   7, 0, 255, "TMMED", "Technologie multimédia"),
( 734, 0, 0,   7, 0, 255, "FUTIL", "Fonction utilisateur"),
( 735, 0, 0,   7, 0, 255, "CITEC", "Création & innovation technologiques"),
( 736, 0, 0,   7, 0, 255, "INTEC", "Innovation technologique et eco-concept."),
( 737, 0, 0,   7, 0, 255, "ETT"  , "Enseignements technologiques transversaux"),
( 738, 0, 0,   7, 0, 255, "STECH", "Sciences et technologie"),
( 739, 0, 0,   7, 0, 255, "TFABR", "Technologie de fabrication"),
( 740, 0, 0,   7, 0, 255, "TPROF", "Technologies professionnelles"),
( 741, 0, 0,   7, 0, 255, "ETP"  , "Enseignements techniques et professionnels"),
( 742, 0, 0,   7, 0, 255, "TTPRO", "Technologie & techniques professionnelles"),
( 799, 0, 0,   7, 0, 255, "TECDI", "Technologie divers"),

-- Éducation musicale

( 800, 0, 0,   8, 0, 255, "EMUGT", "Education musicale générale et technique"),
( 801, 0, 0,   8, 0, 255, "HIMCO", "Histoire musique - critique œuvres enregistrées"),
( 802, 0, 0,   8, 0, 255, "DISTI", "Dictée - solfège - technique instrumentale"),
( 803, 0, 0,   8, 0, 255, "DISOL", "Dictée - solfège"),
( 804, 0, 0,   8, 0, 255, "T-INS", "Technique instrumentale"),
( 805, 0, 0,   8, 0, 255, "DISTM", "Dictée - solfège - théorie musicale"),
( 806, 0, 0,   8, 0, 255, "ENITM", "Ensemble instrumental"),
( 807, 0, 0,   8, 0, 255, "HARMO", "Harmonie"),
( 808, 0, 0,   8, 0, 255, "SOLFG", "Solfège"),
( 809, 0, 0,   8, 0, 255, "CHANK", "Chant choral"),
( 811, 0, 0,   8, 0, 255, "PCVOI", "Pratique collective vocale ou instrumentale"),
( 812, 0, 0,   8, 0, 255, "N-MUS", "Enseignement musical"),
( 813, 0, 1,   8, 0, 255, "EDMUS", "Education musicale"),
( 814, 0, 0,   8, 0, 255, "MUSI5", "Musique 5 heures"),
( 815, 0, 0,   8, 0, 255, "DANS5", "Danse 5 heures"),
( 816, 0, 0,   8, 0, 255, "EXEIN", "Exécution instrumentale"),
( 817, 0, 0,   8, 0, 255, "EXECH", "Exécution chorégraphique"),
( 818, 0, 0,   8, 0, 255, "HIMUS", "Histoire de la musique"),
( 819, 0, 0,   8, 0, 255, "I-OMU", "Initiation aux œuvres musicales"),
( 820, 0, 0,   8, 0, 255, "DIMUS", "Dictée musicale"),
( 821, 0, 0,   8, 0, 255, "ANALY", "Analyse"),
( 822, 0, 0,   8, 0, 255, "LECVI", "Lecture à vue instrumentale"),
( 823, 0, 0,   8, 0, 255, "MUSEN", "Musique d'ensemble"),
( 824, 0, 0,   8, 0, 255, "HARSO", "Harmonie ou solfège"),
( 825, 0, 0,   8, 0, 255, "DANSE", "Danse"),
( 826, 0, 0,   8, 0, 255, "PR-IS", "Pratique instrumentale"),
( 827, 0, 0,   8, 0, 255, "TECIV", "Technologie instrumentale et vocale"),
( 828, 0, 0,   8, 0, 255, "KORAL", "Chorale"),
( 829, 0, 0,   8, 0, 255, "TPENR", "Travaux pratiques d'enregistrement"),
( 830, 0, 0,   8, 0, 255, "HASOK", "Harmonie ou solfège ou chorégraphie"),
( 831, 0, 0,   8, 0, 255, "CHANT", "Chant"),
( 832, 0, 0,   8, 0, 255, "MUSIQ", "Musique"),
( 833, 0, 0,   8, 0, 255, "HIMUD", "Histoire de la musique et de la danse"),
( 834, 0, 0,   8, 0, 255, "N-ART", "Enseignement artistique"),
( 835, 0, 0,   8, 0, 255, "AP-MU", "Atelier de pratique : musique"),
( 836, 0, 0,   8, 0, 255, "MUSPE", "Musique spécialité"),
( 837, 0, 0,   8, 0, 255, "MUSPA", "Musique option - pratique artistique"),
( 838, 0, 0,   8, 0, 255, "MUSCO", "Musicologie"),
( 839, 0, 0,   8, 0, 255, "FOMUS", "Formation musicale"),
( 840, 0, 0,   8, 0, 255, "ENSVI", "Ensemble vocal et/ou instrumental"),
( 841, 0, 0,   8, 0, 255, "CMFOR", "Culture musicale formation de l'oreille"),
( 842, 0, 0,   8, 0, 255, "FINST", "Formation instrumentale"),
( 843, 0, 0,   8, 0, 255, "CHKO" , "Chant choral collectif"),
( 844, 0, 0,   8, 0, 255, "FVOCA", "Formation vocale"),
( 845, 0, 0,   8, 0, 255, "HIS-M", "Histoire des instruments - styles et musicologie"),
( 846, 0, 0,   8, 0, 255, "CHORE", "Culture chorégraphique"),
( 847, 0, 0,   8, 0, 255, "CMUSI", "Culture musicale"),
( 848, 0, 0,   8, 0, 255, "ATSON", "Atelier son"),
( 849, 0, 0,   8, 0, 255, "A-SON", "Arts du son"),
( 899, 0, 0,   8, 0, 255, "EDMUD", "Education musicale divers"),

-- Arts plastiques

( 901, 0, 1,   9, 0, 255, "A-PLA", "Arts plastiques"),
( 902, 0, 0,   9, 0, 255, "APLA5", "Arts plastiques 5 heures"),
( 903, 0, 0,   9, 0, 255, "A-VIS", "Arts visuels"),
( 904, 0, 0,   9, 0, 255, "EDEST", "Education esthétique"),
( 905, 0, 0,   9, 0, 255, "EDART", "Education artistique"),
( 906, 0, 0,   9, 0, 255, "I-EST", "Initiation esthétique"),
( 907, 0, 0,   9, 0, 255, "GRAPH", "Graphisme"),
( 908, 0, 0,   9, 0, 255, "VOLUM", "Volume"),
( 909, 0, 0,   9, 0, 255, "COULR", "Couleur"),
( 910, 0, 0,   9, 0, 255, "AP-AP", "Atelier de pratique : arts plastiques"),
( 911, 0, 0,   9, 0, 255, "A-PSP", "Arts plastiques spécialité"),
( 912, 0, 0,   9, 0, 255, "A-PPA", "Arts plastiques option - pratique artistique"),
( 913, 0, 0,   9, 0, 255, "TROID", "Compréhension 3d"),
( 914, 0, 0,   9, 0, 255, "FESTH", "Formation esthétique (sai)"),
( 915, 0, 0,   9, 0, 255, "AT-3D", "Atelier 3d"),
( 916, 0, 0,   9, 0, 255, "CVISU", "Culture visuelle"),
( 917, 0, 0,   9, 0, 255, "CPHOV", "Culture photographique et visuelle"),
( 918, 0, 0,   9, 0, 255, "CDESG", "Culture du design graphique"),
( 919, 0, 0,   9, 0, 255, "CTYPO", "Culture typographique"),
( 920, 0, 0,   9, 0, 255, "PPGRA", "Pratique plastique & graphique"),
( 921, 0, 0,   9, 0, 255, "DANAL", "Dessin analytique"),
( 999, 0, 0,   9, 0, 255, "A-PLD", "Arts plastiques divers"),

-- Éducation physique et sportive

(1001, 0, 1,  10, 0, 255, "EPS"  , "Education physique et sportive"),
(1002, 0, 0,  10, 0, 255, "ACSPS", "Activités sportives spécialisées"),
(1003, 0, 0,  10, 0, 255, "EQUIT", "Equitation"),
(1004, 0, 0,  10, 0, 255, "ESCRI", "Escrime"),
(1005, 0, 0,  10, 0, 255, "EPSPA", "Education physique et sportive de plein air"),
(1006, 0, 0,  10, 0, 255, "AP-PP", "Atelier de pratique : prat phys sport"),
(1007, 0, 0,  10, 0, 255, "ATHLE", "Athlétisme"),
(1008, 0, 0,  10, 0, 255, "AVIRO", "Aviron"),
(1009, 0, 0,  10, 0, 255, "BASKT", "Basket-ball"),
(1010, 0, 0,  10, 0, 255, "FOOTB", "Football"),
(1011, 0, 0,  10, 0, 255, "GYMGA", "Gymnastique garçons"),
(1012, 0, 0,  10, 0, 255, "GYMNA", "Gymnastique"),
(1013, 0, 0,  10, 0, 255, "HANDB", "Handball"),
(1014, 0, 0,  10, 0, 255, "JUDO" , "Judo"),
(1015, 0, 0,  10, 0, 255, "NATAT", "Natation"),
(1016, 0, 0,  10, 0, 255, "RUGBY", "Rugby"),
(1017, 0, 0,  10, 0, 255, "SKI"  , "Ski"),
(1018, 0, 0,  10, 0, 255, "TENIS", "Tennis"),
(1019, 0, 0,  10, 0, 255, "TENIT", "Tennis de table"),
(1020, 0, 0,  10, 0, 255, "TIRAC", "Tir à l'arc"),
(1021, 0, 0,  10, 0, 255, "VOLEY", "Volley Ball"),
(1022, 0, 0,  10, 0, 255, "ESCAL", "Escalade"),
(1023, 0, 0,  10, 0, 255, "SKIFD", "Ski de fond"),
(1025, 0, 0,  10, 0, 255, "HPPEQ", "Hippologie et équitation"),
(1026, 0, 0,  10, 0, 255, "AP-PS", "Atelier de pratique phys et sportives"),
(1027, 0, 0,  10, 0, 255, "CANOK", "Canoë kayak"),
(1028, 0, 0,  10, 0, 255, "GYMRS", "Gymnastique rythmique et sportive"),
(1029, 0, 0,  10, 0, 255, "PAROU", "Patinage artistique sur roulettes"),
(1030, 0, 0,  10, 0, 255, "GLADS", "Sports de glace (danse sur glace)"),
(1031, 0, 0,  10, 0, 255, "VOLEF", "Volley-ball féminin"),
(1032, 0, 0,  10, 0, 255, "VOLEM", "Volley-ball masculin"),
(1033, 0, 0,  10, 0, 255, "SPAQT", "Sport aquatique"),
(1034, 0, 0,  10, 0, 255, "CYCLI", "Cyclisme"),
(1035, 0, 0,  10, 0, 255, "VOILE", "Voile"),
(1036, 0, 0,  10, 0, 255, "GOLF" , "Golf"),
(1037, 0, 0,  10, 0, 255, "EPS5H", "Education physique sportive (5 heures)"),
(1038, 0, 0,  10, 0, 255, "ATEPS", "Atelier d'éducation physique et sportive"),
(1039, 0, 0,  10, 0, 255, "EPS4H", "Education physique sportive (4 heures)"),
(1040, 0, 0,  10, 0, 255, "EPSDE", "Educ physique sportive de détermination"),
(1041, 0, 0,  10, 0, 255, "EPSCO", "Educ physique et sportive de complément"),
(1042, 0, 0,  10, 0, 255, "COURS", "Courses athlétiques"),
(1043, 0, 0,  10, 0, 255, "SAUTS", "Sauts athlétiques"),
(1044, 0, 0,  10, 0, 255, "LANCE", "Lancers athlétiques"),
(1045, 0, 0,  10, 0, 255, "VTT"  , "VTT"),
(1046, 0, 0,  10, 0, 255, "BICRS", "Bicross"),
(1047, 0, 0,  10, 0, 255, "HALMU", "Haltérophile et musculation"),
(1048, 0, 0,  10, 0, 255, "ARMAR", "Arts martiaux (autres que le judo)"),
(1049, 0, 0,  10, 0, 255, "GRYTM", "Gymnastique rythmique"),
(1050, 0, 0,  10, 0, 255, "GAERO", "Gymnastique aérobique"),
(1051, 0, 0,  10, 0, 255, "GACRO", "Gymnastique acrobatique"),
(1052, 0, 0,  10, 0, 255, "ROLLE", "Activités sportives sur rollers"),
(1053, 0, 0,  10, 0, 255, "GAGRE", "Gymnastique aux agrès"),
(1054, 0, 0,  10, 0, 255, "GSOL" , "Gymnastique au sol"),
(1055, 0, 0,  10, 0, 255, "GDOUC", "Gymnastiques douces"),
(1056, 0, 0,  10, 0, 255, "PVOIL", "Planche à voile"),
(1057, 0, 0,  10, 0, 255, "TRIAT", "Triathlon"),
(1058, 0, 0,  10, 0, 255, "LUTTE", "Luttes"),
(1059, 0, 0,  10, 0, 255, "BOXE" , "Boxe"),
(1060, 0, 0,  10, 0, 255, "BOXFR", "Boxe française"),
(1061, 0, 0,  10, 0, 255, "BADMI", "Badminton"),
(1062, 0, 0,  10, 0, 255, "BASEB", "Baseball"),
(1063, 0, 0,  10, 0, 255, "GARTI", "Gymnastique artistique"),
(1064, 0, 0,  10, 0, 255, "ULTIM", "Ultimate"),
(1065, 0, 0,  10, 0, 255, "SUBAQ", "Activités sportives subaquatiques"),
(1066, 0, 0,  10, 0, 255, "TERNA", "Activités sportives terrestres de pleine nature"),
(1067, 0, 0,  10, 0, 255, "ACIRQ", "Activités sportives de cirque"),
(1068, 0, 0,  10, 0, 255, "AQUNA", "Activités sportives aquatiques de pleine nature"),
(1069, 0, 0,  10, 0, 255, "SUBAN", "Activités sportives subaquatiques de pleine nature"),
(1070, 0, 0,  10, 0, 255, "RAQUE", "Raquette"),
(1071, 0, 0,  10, 0, 255, "GLACE", "Sports de glace"),
(1072, 0, 0,  10, 0, 255, "AMONT", "Activités sportives de montagne"),
(1073, 0, 0,  10, 0, 255, "CHARV", "Char a voiles"),
(1074, 0, 0,  10, 0, 255, "CORPS", "Connaissance du corps"),
(1075, 0, 0,  10, 0, 255, "EPSEE", "EPS enseignement d'exploration"),
(1098, 0, 0,  10, 0, 255, "AESPO", "Accompagnemt éducatif - pratique sportive"),
(1099, 0, 0,  10, 0, 255, "EPSDI", "EPS divers"),

-- Génie industriel du bois

(1102, 0, 0,  11, 0, 255, "ATTSE", "Atelier techno spécialité ébénisterie"),
(1103, 0, 0,  11, 0, 255, "HIAAS", "Histoire de l'art et analyse des styles"),
(1105, 0, 0,  11, 0, 255, "ETFAB", "Étude de fabrication"),
(1106, 0, 0,  11, 0, 255, "ETSYC", "Étude des systèmes constructifs"),
(1107, 0, 0,  11, 0, 255, "TPFAS", "TP: fabrication - site"),
(1108, 0, 0,  11, 0, 255, "TECSP", "Technologie de spécialité"),
(1109, 0, 0,  11, 0, 255, "CALST", "Calcul des structures"),
(1110, 0, 0,  11, 0, 255, "TECEB", "Technologie générale ébénisterie"),
(1111, 0, 0,  11, 0, 255, "TECSE", "Technologie spécialité ébénisterie"),
(1112, 0, 0,  11, 0, 255, "P-OR" , "Préparation et organisation"),
(1113, 0, 0,  11, 0, 255, "R-GIB", "Réalisation et contrôle (gen indus bois)"),
(1114, 0, 0,  11, 0, 255, "HISTY", "Histoire des styles"),
(1115, 0, 0,  11, 0, 255, "TECCN", "Technologie et construction"),
(1116, 0, 0,  11, 0, 255, "XYLOG", "Xylologie"),
(1117, 0, 0,  11, 0, 255, "A-TMH", "Arts et tech du mobilier et de l'habitat"),
(1118, 0, 0,  11, 0, 255, "BUREM", "Bureau d'études méthodes fabrication pos"),
(1119, 0, 0,  11, 0, 255, "HYGSP", "Hygiène sécurité prévention"),
(1120, 0, 0,  11, 0, 255, "MRMNB", "Monographie reco.macr.negoce du bois"),
(1121, 0, 0,  11, 0, 255, "APINP", "Applications industrielles papeterie"),
(1122, 0, 0,  11, 0, 255, "EQBOI", "Equipements annexes des industries du bois"),
(1123, 0, 0,  11, 0, 255, "ATSPE", "Atelier spécialité ébénisterie"),
(1124, 0, 0,  11, 0, 255, "MESPP", "Mesures et modèles processus papetiers"),
(1125, 0, 0,  11, 0, 255, "TECIP", "Technologie des industries papetières"),
(1126, 0, 0,  11, 0, 255, "EFPAP", "Étude fonction et structures des systèmes"),
(1127, 0, 0,  11, 0, 255, "ERPAP", "Et.relat.produits-procédés (génie papetier)"),
(1128, 0, 0,  11, 0, 255, "ESPAP", "Étude systémique process (génie papetier)"),
(1129, 0, 0,  11, 0, 255, "CPPAP", "Conduite des process (génie papetier)"),
(1130, 0, 0,  11, 0, 255, "EEPBA", "Expérimentation et essais (prod bois-am)"),
(1131, 0, 0,  11, 0, 255, "ETINT", "Étude d'industrialisation et technologie"),
(1132, 0, 0,  11, 0, 255, "QUALB", "Qualité (productique bois ameublement)"),
(1133, 0, 0,  11, 0, 255, "FSECB", "Fabrication et sécurité (prod bois am )"),
(1134, 0, 0,  11, 0, 255, "E-TMT", "Étude techno moyens de transfo (génie papetier)"),
(1135, 0, 0,  11, 0, 255, "MOGMT", "Mise en o. gest.moyens de transf.(g.pap)"),
(1136, 0, 0,  11, 0, 255, "DEVPR", "Développement de produits"),
(1137, 0, 0,  11, 0, 255, "REAPR", "Réalisation de produits"),
(1138, 0, 0,  11, 0, 255, "ETARC", "Étude architecturale"),
(1139, 0, 0,  11, 0, 255, "ETPRP", "Étude et préparation de projet"),
(1199, 0, 0,  11, 0, 255, "GNIBD", "Génie industriel du bois divers"),

-- Génie industriel textile et cuir

(1201, 0, 0,  12, 0, 255, "D-PRJ", "Dessin et projet"),
(1202, 0, 0,  12, 0, 255, "TECAT", "Technologie application et travaux pratiques"),
(1203, 0, 0,  12, 0, 255, "D-PAR", "Dessin professionnel artistique"),
(1204, 0, 0,  12, 0, 255, "TECCP", "Technologie de complément"),
(1205, 0, 0,  12, 0, 255, "CTPRD", "Construction du produit"),
(1206, 0, 0,  12, 0, 255, "D-APF", "Dessin applique à la profession"),
(1207, 0, 0,  12, 0, 255, "MOEUV", "Mise en œuvre"),
(1208, 0, 0,  12, 0, 255, "TECCM", "Technologie construction mach - étude matériels"),
(1209, 0, 0,  12, 0, 255, "FA-TC", "Fabrication (textile et cuir)"),
(1210, 0, 0,  12, 0, 255, "ETMTR", "Étude du matériau"),
(1211, 0, 0,  12, 0, 255, "D-TKM", "Dessin technique machines"),
(1212, 0, 0,  12, 0, 255, "D-PRO", "Dessin professionnel"),
(1213, 0, 0,  12, 0, 255, "MONOB", "Mise en œuvre de l'ennoblissement"),
(1214, 0, 0,  12, 0, 255, "SPTMO", "Sciences physiques et techno de matières d'œuvre"),
(1215, 0, 0,  12, 0, 255, "ETSET", "Étude des systèmes d'entretien articles textiles"),
(1216, 0, 0,  12, 0, 255, "PRD-T", "Product m en oeuvre des proc entretien textiles"),
(1217, 0, 0,  12, 0, 255, "TECCC", "Technologie de construction chaussures"),
(1218, 0, 0,  12, 0, 255, "TPTKA", "Travaux pratiques et techno d'application"),
(1219, 0, 0,  12, 0, 255, "D-TXT", "Dessin technique (textile et cuir)"),
(1220, 0, 0,  12, 0, 255, "N-PCH", "Enseignement professionnel chaussures"),
(1221, 0, 0,  12, 0, 255, "TECGF", "Technologie générale de fabrication"),
(1222, 0, 0,  12, 0, 255, "TPHSP", "TP:hygiène-sécur.prod.-réglages-rel.hum."),
(1223, 0, 0,  12, 0, 255, "TPTXT", "Travaux pratiques (textile et cuir)"),
(1224, 0, 0,  12, 0, 255, "COUPE", "Coupe (trace moulage)"),
(1225, 0, 0,  12, 0, 255, "O-IND", "Organisation industrielle"),
(1226, 0, 0,  12, 0, 255, "F-EST", "Formation esthétique"),
(1227, 0, 0,  12, 0, 255, "CUIRT", "Cuir brut et tannerie"),
(1228, 0, 0,  12, 0, 255, "TECFA", "Technologie de fabrication"),
(1229, 0, 0,  12, 0, 255, "G-OST", "Gestion-organ scient travail"),
(1230, 0, 0,  12, 0, 255, "CH-AE", "Chimie appliquée à l'ennoblissement"),
(1234, 0, 0,  12, 0, 255, "CDIRP", "Conception dévelop. industrialisation realisation produits"),
(1240, 0, 0,  12, 0, 255, "GNIND", "Génie industriel"),
(1241, 0, 0,  12, 0, 255, "LGTEC", "Langage technique"),
(1242, 0, 0,  12, 0, 255, "ATCGP", "Atelier-controles et gestion de product"),
(1299, 0, 0,  12, 0, 255, "GNITD", "Génie industriel textile et cuir divers"),

-- Génie industriel verre céramique

(1301, 0, 0,  13, 0, 255, "TPMIR", "Travaux pratiques miroiterie"),
(1302, 0, 0,  13, 0, 255, "ATTP" , "Atelier TP (famille 13)"),
(1303, 0, 0,  13, 0, 255, "R-EF" , "Réalisation d'ensembles fonctionnels"),
(1304, 0, 0,  13, 0, 255, "SCAPF", "Sciences appliquées à la profession"),
(1305, 0, 0,  13, 0, 255, "TPFAB", "Travaux pratiques de fabrication"),
(1306, 0, 0,  13, 0, 255, "CP-EO", "Conception produits - étude outillages"),
(1307, 0, 0,  13, 0, 255, "MPMEO", "Matériaux et procédés de mise en œuvre"),
(1308, 0, 0,  13, 0, 255, "T-DEC", "Techniques de décoration"),
(1309, 0, 0,  13, 0, 255, "SYOPT", "Système optique"),
(1310, 0, 0,  13, 0, 255, "PROPT", "Production optique"),
(1311, 0, 0,  13, 0, 255, "PRMEC", "Production mécanique (optique)"),
(1399, 0, 0,  13, 0, 255, "GNVCD", "Génie industriel verre et céramique div"),

-- Génie structures métalliques

(1402, 0, 0,  14, 0, 255, "P-OFC", "Prep et organis fabrication et contrôle"),
(1403, 0, 0,  14, 0, 255, "METAL", "Métallurgie"),
(1404, 0, 0,  14, 0, 255, "TRACG", "Traçage"),
(1405, 0, 0,  14, 0, 255, "ESOUT", "Étude des systèmes d'outillage"),
(1406, 0, 0,  14, 0, 255, "EPROC", "Étude des processus"),
(1407, 0, 0,  14, 0, 255, "LABSM", "Laboratoire (structures métalliques)"),
(1408, 0, 0,  14, 0, 255, "REASM", "Réalisation"),
(1409, 0, 0,  14, 0, 255, "ESYST", "Étude des systèmes str métalliques"),
(1410, 0, 0,  14, 0, 255, "TGQPR", "Technologie gestion qualité prévention"),
(1411, 0, 0,  14, 0, 255, "EMMPG", "Etud moulage méthode prep gest product"),
(1412, 0, 0,  14, 0, 255, "MEORL", "MEO réalisation (fabrication essais contrôles)"),
(1413, 0, 0,  14, 0, 255, "TTTUY", "Technologie - traçage - tuyauterie"),
(1414, 0, 0,  14, 0, 255, "GPDVQ", "Gestion de production - devis - qualité"),
(1415, 0, 0,  14, 0, 255, "PCHAN", "Préparation du travail - chantier"),
(1416, 0, 0,  14, 0, 255, "TKMEO", "Techniques de mise en œuvre"),
(1417, 0, 0,  14, 0, 255, "RPROJ", "Thème (réalisation projet)"),
(1418, 0, 0,  14, 0, 255, "MOUGR", "Moulage gravitaire"),
(1419, 0, 0,  14, 0, 255, "MOUSP", "Moulage sous pression"),
(1420, 0, 0,  14, 0, 255, "EPRDT", "Étude de produits"),
(1421, 0, 0,  14, 0, 255, "PPROD", "Préparation de la production"),
(1422, 0, 0,  14, 0, 255, "EMOAF", "Et.&m.en œuvre alliag de fond.&mat.conx"),
(1499, 0, 0,  14, 0, 255, "GNSMD", "Génie ind structures métal divers"),

-- Génie industriel plastiques composites

(1501, 0, 0,  15, 0, 255, "EVEXI", "Environnement externe et interne"),
(1502, 0, 0,  15, 0, 255, "T-CO" , "Techniques connexes (stoc manu trans meca)"),
(1503, 0, 0,  15, 0, 255, "CA-PC", "Conception et analyse (plastiques composites)"),
(1504, 0, 0,  15, 0, 255, "CH-MP", "Chimie matières plastiques"),
(1505, 0, 0,  15, 0, 255, "MOPMM", "Mise oeuv.plast. - maint.matériels essais"),
(1506, 0, 0,  15, 0, 255, "ETFGR", "Étude fonctionnelle et graphique"),
(1507, 0, 0,  15, 0, 255, "TPAPC", "TP atelier (plastiques composites)"),
(1508, 0, 0,  15, 0, 255, "ETRIP", "Étude et réalisation industr de produits"),
(1509, 0, 0,  15, 0, 255, "ROMOP", "Réalisation outillage pr mise œuvre plastique"),
(1510, 0, 0,  15, 0, 255, "ETCMP", "Étude et contrôle matériaux et produc"),
(1511, 0, 0,  15, 0, 255, "CT-OU", "Conception des outillages"),
(1512, 0, 0,  15, 0, 255, "O-FAB", "Organisation des fabrications"),
(1513, 0, 0,  15, 0, 255, "ETMLA", "Étude des matériaux et laboratoire"),
(1514, 0, 0,  15, 0, 255, "ETMDT", "Étude matériaux et div tech trans plas"),
(1515, 0, 0,  15, 0, 255, "TPMDE", "TP de maintenance-dépannage équipements"),
(1516, 0, 0,  15, 0, 255, "MPOSP", "Materiaux - procedés orga - suivi product"),
(1517, 0, 0,  15, 0, 255, "LAOTP", "Labo - analyse - mise œuvre techno produits"),
(1518, 0, 0,  15, 0, 255, "CT-PL", "Conception (plastiques composites)"),
(1519, 0, 0,  15, 0, 255, "PH-AM", "Physique appliquée aux matériaux"),
(1520, 0, 0,  15, 0, 255, "PRD-C", "Productions et contrôles"),
(1521, 0, 0,  15, 0, 255, "CTCPO", "Construction conception pièces outillage"),
(1522, 0, 0,  15, 0, 255, "P-OTR", "Préparation organisation travail"),
(1523, 0, 0,  15, 0, 255, "O-BMT", "Organisation production: bureau méthodes"),
(1524, 0, 0,  15, 0, 255, "TEPRO", "Technologie étude de procédés"),
(1525, 0, 0,  15, 0, 255, "LANGT", "Langage technique plasturgie"),
(1526, 0, 0,  15, 0, 255, "PSCQG", "Production suivi contrôle qualité gestion"),
(1527, 0, 0,  15, 0, 255, "MCOMP", "Matériaux composites"),
(1528, 0, 0,  15, 0, 255, "TCMPC", "Technologie contrôle matériaux (plastiques composites)"),
(1529, 0, 0,  15, 0, 255, "MEOPC", "Mise en œuvre (plastiques composites)"),
(1530, 0, 0,  15, 0, 255, "QSEPC", "Organisation et qse (plastiques composites)"),
(1531, 0, 0,  15, 0, 255, "IP-PC", "Industrialisation projet (plastiques composites)"),
(1532, 0, 0,  15, 0, 255, "MPOPC", "Mainten processus outillage (plastiques composites)"),
(1599, 0, 0,  15, 0, 255, "GNIPD", "Génie indus plastiques divers"),

-- Génie chimique

(1601, 0, 0,  16, 0, 255, "TECGC", "Technologie et génie chimique"),
(1602, 0, 0,  16, 0, 255, "CH-ME", "Chimie - métallurgie"),
(1603, 0, 0,  16, 0, 255, "TECGQ", "Technologie-gestion de la qualité-prod"),
(1604, 0, 0,  16, 0, 255, "MT-DA", "Méthodes de développement d'une application"),
(1605, 0, 0,  16, 0, 255, "MAPLI", "Montage d'appareils (laboratoire indus )"),
(1606, 0, 0,  16, 0, 255, "T-FBR", "Techniques de fabrication"),
(1607, 0, 0,  16, 0, 255, "GENCH", "Génie chimique"),
(1699, 0, 0,  16, 0, 255, "GNCHD", "Génie chimique divers"),

-- Génie civil

(1701, 0, 0,  17, 0, 255, "D-GCV", "Dessin (génie civil)"),
(1702, 0, 0,  17, 0, 255, "TOPOG", "Topographie"),
(1703, 0, 0,  17, 0, 255, "GR3DV", "Gr3 (devis-et couts-prix-compta trav-pr)"),
(1704, 0, 0,  17, 0, 255, "CO-BA", "Connaissances de base"),
(1705, 0, 0,  17, 0, 255, "PRJBA", "Projet de bâtiment"),
(1706, 0, 0,  17, 0, 255, "R-TEM", "Réalisation:topographie - essais - mesures-c"),
(1707, 0, 0,  17, 0, 255, "PDATP", "Projet : dessin d'architecture et travaux pratiques"),
(1708, 0, 0,  17, 0, 255, "PXDOI", "Principaux domaines d'intervention"),
(1709, 0, 0,  17, 0, 255, "VPTTP", "Visite et présentation techniques (TP)"),
(1710, 0, 0,  17, 0, 255, "CRQCO", "Croquis cote"),
(1711, 0, 0,  17, 0, 255, "R-TVX", "Réalisation études et travaux"),
(1712, 0, 0,  17, 0, 255, "ESSMC", "Essais - mesures - contrôle"),
(1713, 0, 0,  17, 0, 255, "T-AF" , "Technique améliorations foncières"),
(1714, 0, 0,  17, 0, 255, "MAKET", "Maquette"),
(1715, 0, 0,  17, 0, 255, "PHGRA", "Photogrammétrie"),
(1716, 0, 0,  17, 0, 255, "ARCCO", "Architectures et composants"),
(1717, 0, 0,  17, 0, 255, "R-OUV", "Réalisation des ouvrages"),
(1718, 0, 0,  17, 0, 255, "R-GCV", "Réalisation et contrôle (génie civil)"),
(1719, 0, 0,  17, 0, 255, "P-CCH", "Préparation et conduite de chantier"),
(1720, 0, 0,  17, 0, 255, "TOPOL", "Topologie"),
(1721, 0, 0,  17, 0, 255, "METRE", "Métré et étude de coûts"),
(1722, 0, 0,  17, 0, 255, "O-CMO", "Orga et gestion chantier-mise en œuvre"),
(1723, 0, 0,  17, 0, 255, "P-CHT", "Préparation de chantier"),
(1724, 0, 0,  17, 0, 255, "EOMST", "Et.ouvr.:meca stru.-techno constructions"),
(1725, 0, 0,  17, 0, 255, "GR5PM", "Gr5 (techno proc meth-droit-regle const)"),
(1726, 0, 0,  17, 0, 255, "CADAS", "Cadastre"),
(1727, 0, 0,  17, 0, 255, "CALTO", "Calculs topométriques"),
(1728, 0, 0,  17, 0, 255, "GODSI", "Géodésie"),
(1729, 0, 0,  17, 0, 255, "D-HAC", "Dessin arts appliqués - histoire architect construct"),
(1730, 0, 0,  17, 0, 255, "TOPTA", "Topographie (thème et application)"),
(1731, 0, 0,  17, 0, 255, "GR4GD", "Gr4 (dcs-geometrie descri.-tcs-mrm)"),
(1732, 0, 0,  17, 0, 255, "ETCGC", "Étude des constructions (génie civil)"),
(1733, 0, 0,  17, 0, 255, "ECPRP", "Et.ct prix-real.piec.ecrit-org.p.d.const"),
(1734, 0, 0,  17, 0, 255, "TECNU", "Technologie des TP notions d'urbanisme"),
(1735, 0, 0,  17, 0, 255, "ARCHI", "Architecture"),
(1736, 0, 0,  17, 0, 255, "MENCH", "Menuiserie charpente"),
(1737, 0, 0,  17, 0, 255, "ELBAT", "Électricité du bâtiment"),
(1738, 0, 0,  17, 0, 255, "TPELC", "TP d'électricité"),
(1739, 0, 0,  17, 0, 255, "PLBSA", "Plomberie sanitaire"),
(1740, 0, 0,  17, 0, 255, "BATIM", "Bâtiment"),
(1741, 0, 0,  17, 0, 255, "MACON", "Maçonnerie"),
(1742, 0, 0,  17, 0, 255, "T-BAT", "Technique du bâtiment"),
(1743, 0, 0,  17, 0, 255, "ARCON", "Architecture de la construction"),
(1744, 0, 0,  17, 0, 255, "FABMI", "Fabrication mise en œuvre"),
(1745, 0, 0,  17, 0, 255, "CONST", "Construction"),
(1746, 0, 0,  17, 0, 255, "E-OUV", "Études des ouvrages"),
(1747, 0, 0,  17, 0, 255, "COTOP", "Connaissances topographiques"),
(1748, 0, 0,  17, 0, 255, "DIGEO", "Domaines d'intervention du géomètre"),
(1749, 0, 0,  17, 0, 255, "COOTX", "Coordination de travaux"),
(1750, 0, 0,  17, 0, 255, "GCMTP", "Génie civil et matériels travaux publics"),
(1751, 0, 0,  17, 0, 255, "PO-GC", "Projet d'ouvrage (génie civil)"),
(1752, 0, 0,  17, 0, 255, "ARCHC", "Architecture et construction"),
(1753, 0, 0,  17, 0, 255, "AHUDD", "Architecture, habitat & urbanisme, développement durable"),
(1799, 0, 0,  17, 0, 255, "GNCID", "Génie civil divers"),

-- Génie thermique

(1801, 0, 0,  18, 0, 255, "MOSYS", "Mise en œuvre des systèmes"),
(1802, 0, 0,  18, 0, 255, "TMFAV", "Thermo meca fluide appliquée véhicule"),
(1803, 0, 0,  18, 0, 255, "TMDPP", "Thermodynamique thermopropulsion"),
(1804, 0, 0,  18, 0, 255, "AMFVU", "Aérodynamique mécanique des fluides-vol.-tec.util"),
(1805, 0, 0,  18, 0, 255, "ETCSY", "Étude et conception des systèmes"),
(1806, 0, 0,  18, 0, 255, "ETSYS", "Étude des systèmes"),
(1807, 0, 0,  18, 0, 255, "ETITL", "Étude des installations"),
(1808, 0, 0,  18, 0, 255, "R-INS", "Réalisation et contrôle installations"),
(1809, 0, 0,  18, 0, 255, "TMDMF", "Thermodynamique mécanique des fluides"),
(1810, 0, 0,  18, 0, 255, "OSTCH", "Ost-chaudronnerie"),
(1811, 0, 0,  18, 0, 255, "PREPA", "Préparation"),
(1812, 0, 0,  18, 0, 255, "FLDEG", "Fluidique et énergétique"),
(1813, 0, 0,  18, 0, 255, "FLDEA", "Fluidique et énergétique appliquées"),
(1814, 0, 0,  18, 0, 255, "TMDTM", "Thermodynamique et thermique"),
(1815, 0, 0,  18, 0, 255, "ENFLE", "Énergétique fluidique environnement"),
(1816, 0, 0,  18, 0, 255, "RMOPT", "Réalisation mise en œuvre procédures (génie thermique)"),
(1817, 0, 0,  18, 0, 255, "ENENV", "Energies et environnement"),
(1899, 0, 0,  18, 0, 255, "GNTHD", "Génie thermique divers"),

-- Génie mécanique de la construction

(1901, 0, 0,  19, 0, 255, "D-CAT", "Dessin de construction atelier"),
(1902, 0, 0,  19, 0, 255, "PD-CT", "Productique construction"),
(1903, 0, 0,  19, 0, 255, "D-CTR", "Dessin de construction"),
(1904, 0, 0,  19, 0, 255, "ME-TS", "Mécanique et technologie des structures"),
(1905, 0, 0,  19, 0, 255, "D-IMC", "Dessin industriel mécanique"),
(1906, 0, 0,  19, 0, 255, "CTAUT", "Construction et automatisme"),
(1907, 0, 0,  19, 0, 255, "CTMAT", "Construction mécanique appliquée techno"),
(1908, 0, 0,  19, 0, 255, "P-MCM", "Prepar orga méthode const moules modèles"),
(1909, 0, 0,  19, 0, 255, "TECPA", "Technologie securité prévention accidents travail"),
(1910, 0, 0,  19, 0, 255, "TPEFB", "Travaux pratiques étude fabrication"),
(1911, 0, 0,  19, 0, 255, "TECMX", "Technologie des matériaux"),
(1912, 0, 0,  19, 0, 255, "CT"   , "Construction (famille 19)"),
(1913, 0, 0,  19, 0, 255, "ETCST", "Étude des constructions"),
(1914, 0, 0,  19, 0, 255, "CTMEC", "Construction mécanique"),
(1915, 0, 0,  19, 0, 255, "ME-CT", "Mécanique et construction"),
(1916, 0, 0,  19, 0, 255, "T-TCM", "Techniques graph techno constr des machines"),
(1917, 0, 0,  19, 0, 255, "D-TGD", "Dessin technique - géométrie descriptive"),
(1918, 0, 0,  19, 0, 255, "TDATG", "Trav.dirigés analy.technique et expr.gra"),
(1919, 0, 0,  19, 0, 255, "OBPRD", "Obtention des produits"),
(1920, 0, 0,  19, 0, 255, "INPRD", "Industrialisation des produits"),
(1922, 0, 0,  19, 0, 255, "EXMMA", "Étude expe maintenance mater agricoles"),
(1923, 0, 0,  19, 0, 255, "COMST", "Comportement des systèmes techniques"),
(1924, 0, 0,  19, 0, 255, "ETAER", "Étude de l'aeronef et de ses systèmes"),
(1925, 0, 0,  19, 0, 255, "PRPRO", "Préparation de production"),
(1999, 0, 0,  19, 0, 255, "GNMCD", "Génie meca construction divers"),

-- Génie mécanique de la productique

(2001, 0, 0,  20, 0, 255, "P-OMF", "Préparation-organisation : méthodes-fabrication-contrôle"),
(2002, 0, 0,  20, 0, 255, "INSTR", "Instrumentation"),
(2003, 0, 0,  20, 0, 255, "ME-ID", "Mécanique industrielle"),
(2004, 0, 0,  20, 0, 255, "MECAN", "Mécanique"),
(2005, 0, 0,  20, 0, 255, "PD-PO", "Productique : préparation organisation"),
(2006, 0, 0,  20, 0, 255, "ME-MX", "Mécanique et résistance des matériaux"),
(2007, 0, 0,  20, 0, 255, "ETMAI", "Étude des mécanismes et autom indust"),
(2008, 0, 0,  20, 0, 255, "ETCMA", "Étude système (construction-mécanismes-automatismes)"),
(2009, 0, 0,  20, 0, 255, "TSA"  , "Technologie des systèmes automatisés"),
(2013, 0, 0,  20, 0, 255, "D-TTC", "Dessin technique technologie de construction"),
(2014, 0, 0,  20, 0, 255, "PJTCT", "Projet et technologie de construction"),
(2015, 0, 0,  20, 0, 255, "MESUR", "Mesures"),
(2016, 0, 0,  20, 0, 255, "D-ITC", "Dessin industriel et tech construction"),
(2017, 0, 0,  20, 0, 255, "AUTMT", "Automatismes"),
(2018, 0, 0,  20, 0, 255, "MOPIN", "Mise en œuvre des processus industriels"),
(2019, 0, 0,  20, 0, 255, "P-ORG", "Préparation - organisation"),
(2020, 0, 0,  20, 0, 255, "DFPRC", "Définition des processus"),
(2021, 0, 0,  20, 0, 255, "CTDNI", "Construction et dessin industriel"),
(2022, 0, 0,  20, 0, 255, "ATAUM", "Atelier automatismes mesures"),
(2023, 0, 0,  20, 0, 255, "ASAIF", "Automatisation systèmes automatisés informatique"),
(2024, 0, 0,  20, 0, 255, "USIMS", "Usinage m.s."),
(2025, 0, 0,  20, 0, 255, "AVPRJ", "Avant-projet"),
(2026, 0, 0,  20, 0, 255, "PROJT", "Projet"),
(2027, 0, 0,  20, 0, 255, "ETPMM", "Étude : procédés - moyens - mise en œuvre"),
(2028, 0, 0,  20, 0, 255, "R-PRQ", "Réalisation et contrôle (productique)"),
(2029, 0, 0,  20, 0, 255, "ANSPR", "Analyse des syst de pro (productiq text)"),
(2031, 0, 0,  20, 0, 255, "TPPRD", "Travaux pratiques production"),
(2032, 0, 0,  20, 0, 255, "ETMMP", "Étude méthodes et moyens de production"),
(2033, 0, 0,  20, 0, 255, "ATGMP", "Atelier (génie mécanique productique)"),
(2034, 0, 0,  20, 0, 255, "D-IND", "Dessin industriel"),
(2035, 0, 0,  20, 0, 255, "ETPOP", "Étude des parties opératives"),
(2036, 0, 0,  20, 0, 255, "MORFE", "Mise œuvre-realis.(fabrication-essais-contrôle)"),
(2038, 0, 0,  20, 0, 255, "P-OMH", "Préparation et organisation : méthodes"),
(2039, 0, 0,  20, 0, 255, "TPAEL", "TP d'automatisme et d'électrotechnique"),
(2040, 0, 0,  20, 0, 255, "R-SYS", "Réalisation et contrôle de systèmes"),
(2041, 0, 0,  20, 0, 255, "ETCCP", "Étude de conception et construction de produit"),
(2042, 0, 0,  20, 0, 255, "MITKA", "Mesures industrielles et tech d'appareil"),
(2043, 0, 0,  20, 0, 255, "PRODQ", "Productique"),
(2044, 0, 0,  20, 0, 255, "MICTK", "Microtechniques"),
(2045, 0, 0,  20, 0, 255, "FA-GM", "Fabrication (génie mécanique productique)"),
(2046, 0, 0,  20, 0, 255, "AJUST", "Ajustage"),
(2047, 0, 0,  20, 0, 255, "ANFAB", "Analyse fabrication"),
(2048, 0, 0,  20, 0, 255, "AUCMA", "Automatismes et commande de machines"),
(2049, 0, 0,  20, 0, 255, "RGDYI", "Régulation et dynamique des installations"),
(2050, 0, 0,  20, 0, 255, "MICGR", "Micrographie"),
(2051, 0, 0,  20, 0, 255, "ETPAC", "Étude des parties commandes"),
(2052, 0, 0,  20, 0, 255, "P-OSP", "Prep org suivi productions technologie fabrication"),
(2053, 0, 0,  20, 0, 255, "CTMOU", "Construction - technologie des matériaux outillages"),
(2054, 0, 0,  20, 0, 255, "CNTQU", "Contrôle qualité"),
(2055, 0, 0,  20, 0, 255, "TECCT", "Technologie de construction"),
(2056, 0, 0,  20, 0, 255, "STSYP", "Structure des systèmes de production"),
(2057, 0, 0,  20, 0, 255, "ME-AP", "Mécanique appliquée"),
(2058, 0, 0,  20, 0, 255, "PD-MO", "Productique systèmes motorises"),
(2059, 0, 0,  20, 0, 255, "PD-SM", "Productique structures métalliques"),
(2060, 0, 0,  20, 0, 255, "PD-BM", "Productique bois et matériaux associés"),
(2061, 0, 0,  20, 0, 255, "PD-MC", "Productique mécanique"),
(2062, 0, 0,  20, 0, 255, "PD-MS", "Productique matériaux souples"),
(2063, 0, 0,  20, 0, 255, "AUCRG", "Automatique - contrôle et régulation"),
(2064, 0, 0,  20, 0, 255, "SYSAU", "Systèmes automatises"),
(2065, 0, 0,  20, 0, 255, "ETMIC", "Études (microtechniques)"),
(2066, 0, 0,  20, 0, 255, "PRMIC", "Préparation (microtechniques)"),
(2067, 0, 0,  20, 0, 255, "EPROU", "Étude des produits et des outillages"),
(2068, 0, 0,  20, 0, 255, "INDMC", "Industrialisation"),
(2069, 0, 0,  20, 0, 255, "PROMC", "Production"),
(2070, 0, 0,  20, 0, 255, "PD-MT", "Productique microtechniques"),
(2071, 0, 0,  20, 0, 255, "C-OUT", "Conception des outillages (product mécanique)"),
(2072, 0, 0,  20, 0, 255, "RE-CO", "Réalisation et contrôle"),
(2073, 0, 0,  20, 0, 255, "G-MEC", "Génie mécanique"),
(2074, 0, 0,  20, 0, 255, "COPAC", "Conception des parties de commande"),
(2075, 0, 0,  20, 0, 255, "COPOP", "Conception des parties opératives"),
(2076, 0, 0,  20, 0, 255, "AELTT", "Automatisme et électrotechnique"),
(2077, 0, 0,  20, 0, 255, "ISYPR", "Informatique et systèmes de production"),
(2078, 0, 0,  20, 0, 255, "CSAUT", "Conception des systèmes automatiques"),
(2079, 0, 0,  20, 0, 255, "CRCLI", "Conduite  et réalisation  projet client"),
(2080, 0, 0,  20, 0, 255, "EPCAR", "Étude des produits carrossés"),
(2081, 0, 0,  20, 0, 255, "CPCAR", "Conception des produits carrossés"),
(2082, 0, 0,  20, 0, 255, "RPCAR", "Réalisation des produits carrossés"),
(2099, 0, 0,  20, 0, 255, "GNMPD", "Génie mécanique productique divers"),

-- Génie mécanique de la maintenance

(2101, 0, 0,  21, 0, 255, "TECCS", "Technologie cellules et systèmes"),
(2102, 0, 0,  21, 0, 255, "MNMEC", "Maintenance mécanique"),
(2103, 0, 0,  21, 0, 255, "ME-AT", "Mécanique appliquée moteur transmission"),
(2104, 0, 0,  21, 0, 255, "MAINT", "Maintenance"),
(2105, 0, 0,  21, 0, 255, "ME-AV", "Mécanique appliquée au véhicule"),
(2106, 0, 0,  21, 0, 255, "ANTDI", "Analyse technique dessin industriel"),
(2107, 0, 0,  21, 0, 255, "TPITV", "TP intervention"),
(2108, 0, 0,  21, 0, 255, "TPAMN", "TP atelier (maintenance)"),
(2109, 0, 0,  21, 0, 255, "TPCEM", "TP : carburants - électricité - moteurs - organe"),
(2110, 0, 0,  21, 0, 255, "TPATD", "TP anal tech diag rep regl gest maint"),
(2111, 0, 0,  21, 0, 255, "ETSYT", "Étude des systèmes techniques"),
(2112, 0, 0,  21, 0, 255, "RESMX", "Résistance des matériaux"),
(2113, 0, 0,  21, 0, 255, "G-MTP", "Gestion de maintenance - technologie-TP"),
(2114, 0, 0,  21, 0, 255, "ANFST", "Analyse fonctionnelle et structurelle"),
(2115, 0, 0,  21, 0, 255, "ANFSE", "Analyse fonct. struct. esth indus"),
(2116, 0, 0,  21, 0, 255, "ANFME", "Analyse fonctionnelle et mécanique"),
(2117, 0, 0,  21, 0, 255, "MT-MA", "Méthodes de maintenance"),
(2118, 0, 0,  21, 0, 255, "TPMHS", "TP maintenance hygiène sécurité"),
(2119, 0, 0,  21, 0, 255, "ESSMO", "Essais moteur"),
(2120, 0, 0,  21, 0, 255, "ME-VB", "Mécanique et vibrations"),
(2121, 0, 0,  21, 0, 255, "MEPSM", "Modélisation étude prédictive systèmes mécaniques"),
(2122, 0, 0,  21, 0, 255, "EMMTP", "Etud expe maintenanc matériels trvx pub"),
(2123, 0, 0,  21, 0, 255, "STRMT", "Stratégie de maintenance"),
(2124, 0, 0,  21, 0, 255, "TPMTN", "Travaux pratiques de maintenance"),
(2125, 0, 0,  21, 0, 255, "ACPRA", "Activités pratiques"),
(2126, 0, 0,  21, 0, 255, "ANFSM", "Analyse fonction. - structur. & mécanique"),
(2127, 0, 0,  21, 0, 255, "ORMAV", "Organisation  maintenance & après-vente"),
(2128, 0, 0,  21, 0, 255, "TNCIV", "Technologie & intervention sur véhicules"),
(2129, 0, 0,  21, 0, 255, "AMAER", "Assemblage et maintenance des aéronefs"),
(2130, 0, 0,  21, 0, 255, "MCMAT", "Modélisation comportement des matériels"),
(2131, 0, 0,  21, 0, 255, "TIMAT", "Technologie & intervention sur matériels"),
(2132, 0, 0,  21, 0, 255, "EPSYS", "Étude pluritechnologique des systèmes"),
(2133, 0, 0,  21, 0, 255, "ORMAT", "Organisation de la maintenance"),
(2134, 0, 0,  21, 0, 255, "TMCPR", "Technique de maintenance conduite prévention"),
(2199, 0, 0,  21, 0, 255, "GNMMD", "Génie mécanique maintenance divers"),

-- Génie électrique électronique

(2201, 0, 0,  22, 0, 255, "ELTRO", "Électronique"),
(2202, 0, 0,  22, 0, 255, "ETHMA", "Étude théorique et schéma"),
(2203, 0, 0,  22, 0, 255, "ELSIB", "Eln et logique - servomécanismes instruments de bord"),
(2204, 0, 0,  22, 0, 255, "P-OTS", "Préparation organisation : technologie systèmes électriques"),
(2205, 0, 0,  22, 0, 255, "MESES", "Mesures et essais"),
(2206, 0, 0,  22, 0, 255, "AUTMQ", "Automatique"),
(2207, 0, 0,  22, 0, 255, "ESSYS", "Essai de systèmes"),
(2208, 0, 0,  22, 0, 255, "ELTAP", "Électrotechnique électronique appliquée"),
(2209, 0, 0,  22, 0, 255, "R-SEL", "Réalisation cont syst électroniques"),
(2210, 0, 0,  22, 0, 255, "ELETR", "Électricité et électronique"),
(2211, 0, 0,  22, 0, 255, "APPEM", "Applications pratiques - essais et mesures"),
(2212, 0, 0,  22, 0, 255, "TECSC", "Technologie syst commande regul auto :schéma"),
(2213, 0, 0,  22, 0, 255, "REGUL", "Régulation"),
(2214, 0, 0,  22, 0, 255, "ELOII", "Électronique - informatique industrielle"),
(2215, 0, 0,  22, 0, 255, "ANMOS", "Analyse et mise en œuvre des systèmes"),
(2216, 0, 0,  22, 0, 255, "THSIG", "Théorie du signal"),
(2217, 0, 0,  22, 0, 255, "ELPUI", "Électronique de puissance"),
(2218, 0, 0,  22, 0, 255, "ELCOM", "Électronique et communications"),
(2220, 0, 0,  22, 0, 255, "ELOAI", "Électronique automatique informatique indus"),
(2221, 0, 0,  22, 0, 255, "G-ELC", "Génie électrique"),
(2222, 0, 0,  22, 0, 255, "GEIAP", "Génie électrique - informatique appliquée"),
(2223, 0, 0,  22, 0, 255, "ELIOP", "Electron informatiq ind optoelectroniq"),
(2224, 0, 0,  22, 0, 255, "AIIAL", "Automatique informatique indus électronique"),
(2225, 0, 0,  22, 0, 255, "TSENS", "Technologie sensitométrie"),
(2226, 0, 0,  22, 0, 255, "TQUIP", "Technologie équipements"),
(2227, 0, 0,  22, 0, 255, "PDVUE", "Prise de vue"),
(2228, 0, 0,  22, 0, 255, "TIMAG", "Traitement de l'image"),
(2299, 0, 0,  22, 0, 255, "CTAUD", "Construction et automatisme divers"),

-- Génie électrique électrotechnique

(2301, 0, 0,  23, 0, 255, "ELMEC", "Électricité et mécanique"),
(2302, 0, 0,  23, 0, 255, "TPIEL", "TP initiation à l'électricité"),
(2303, 0, 0,  23, 0, 255, "PH-AE", "Physique appliquée à l'électrotechnique"),
(2304, 0, 0,  23, 0, 255, "ELTEO", "Électrotechnique - électronique"),
(2305, 0, 0,  23, 0, 255, "FA-TP", "Fabrication réalisation TP"),
(2306, 0, 0,  23, 0, 255, "ELCHI", "Électrochimie"),
(2307, 0, 0,  23, 0, 255, "ELTTK", "Électrotechnique"),
(2309, 0, 0,  23, 0, 255, "TECTS", "Technologie des traitements de surfaces ost"),
(2310, 0, 0,  23, 0, 255, "R-TPA", "Réalisation (TP appareillage et S.A)"),
(2311, 0, 0,  23, 0, 255, "P-TOG", "Préparation (tech ost-gest prod)"),
(2312, 0, 0,  23, 0, 255, "ELECT", "Électricité"),
(2313, 0, 0,  23, 0, 255, "CTELO", "Construction (électrotechnique)"),
(2314, 0, 0,  23, 0, 255, "TECSF", "Technologie schéma et fabrication"),
(2315, 0, 0,  23, 0, 255, "R-TSU", "Réalisation de traitements de surfaces"),
(2316, 0, 0,  23, 0, 255, "ESSME", "Essais mesures"),
(2317, 0, 0,  23, 0, 255, "N-IND", "Enseignement industriel"),
(2318, 0, 0,  23, 0, 255, "ECLAI", "Éclairage"),
(2319, 0, 0,  23, 0, 255, "SONOR", "Sonorisation"),
(2320, 0, 0,  23, 0, 255, "CSMAE", "Const.struct.mater.appliq. électronique"),
(2321, 0, 0,  23, 0, 255, "SCEEL", "Sciences appliquées électriq électroniq"),
(2322, 0, 0,  23, 0, 255, "CSMEL", "Const.str.mat.appliq. électrotechnique"),
(2399, 0, 0,  23, 0, 255, "GNEED", "Génie électrique électronique divers"),

-- Génie électrique informat.- télématique

(2401, 0, 0,  24, 0, 255, "ARCSI", "Architecture des systèmes informatiques"),
(2402, 0, 0,  24, 0, 255, "MT-IF", "Méthodes informatiques"),
(2403, 0, 0,  24, 0, 255, "TTNUM", "Traitements numériques"),
(2404, 0, 0,  24, 0, 255, "IFIND", "Informatique industrielle"),
(2405, 0, 0,  24, 0, 255, "IFTIQ", "Informatique"),
(2406, 0, 0,  24, 0, 255, "TECIA", "Technologie maternels:informatique appl"),
(2407, 0, 0,  24, 0, 255, "IFAPL", "Informatique appliquée"),
(2408, 0, 0,  24, 0, 255, "ME-II", "Mécanique automatique et informatique indus"),
(2409, 0, 0,  24, 0, 255, "AUIFI", "Automatique et informatique industrielle"),
(2410, 0, 0,  24, 0, 255, "IFAUT", "Informatique et automatismes"),
(2411, 0, 0,  24, 0, 255, "LOGIC", "Logiciels"),
(2412, 0, 0,  24, 0, 255, "MOSIF", "Mise en œuvre systèmes informatiques"),
(2413, 0, 0,  24, 0, 255, "AUIFA", "Automatique et informatique appliquées"),
(2414, 0, 0,  24, 0, 255, "AULOG", "Automatismes et logique"),
(2415, 0, 0,  24, 0, 255, "XAO"  , "XAO"),
(2416, 0, 0,  24, 0, 255, "MANIN", "Mise à niveau en informatique"),
(2417, 0, 0,  24, 0, 255, "ISYST", "Informatique système"),
(2418, 0, 0,  24, 0, 255, "GESSI", "Gestion des systèmes d'information"),
(2419, 0, 0,  24, 0, 255, "BIOIL", "Bio-informatique et informatique de labo"),
(2420, 0, 0,  24, 0, 255, "SINUM", "Systèmes d'information et numérique"),
(2421, 0, 0,  24, 0, 255, "INFRE", "Informatique et réseaux"),
(2499, 0, 0,  24, 0, 255, "GNEID", "Génie électrique inform electro divers"),

-- Indust. graphiques (imprimerie - livre)

(2501, 0, 0,  25, 0, 255, "IMPRE", "Impression"),
(2502, 0, 0,  25, 0, 255, "FINIT", "Finition"),
(2503, 0, 0,  25, 0, 255, "P-FIM", "Préparation de la forme imprimante"),
(2504, 0, 0,  25, 0, 255, "EX-GR", "Expression graphique"),
(2505, 0, 0,  25, 0, 255, "TXPCP", "Trav.prof.conduite production"),
(2506, 0, 0,  25, 0, 255, "T-FAB", "Technique de fabrication"),
(2507, 0, 0,  25, 0, 255, "TECPT", "Technologie professionnelle et travaux pratiques"),
(2508, 0, 0,  25, 0, 255, "TECPG", "Technologie des syst de production graphique"),
(2509, 0, 0,  25, 0, 255, "DFPGR", "Définition des proces production graphique"),
(2510, 0, 0,  25, 0, 255, "PD-GR", "Productique graphique"),
(2511, 0, 0,  25, 0, 255, "TECSI", "Technologie des syst d'information graphique"),
(2512, 0, 0,  25, 0, 255, "O-OPG", "Org mise en œuvre processus graphiques"),
(2513, 0, 0,  25, 0, 255, "CMNGR", "Communication graphique"),
(2514, 0, 0,  25, 0, 255, "HIECR", "Histoire sémiologie métamorph écritures"),
(2515, 0, 0,  25, 0, 255, "D-TYP", "Calligraphie dessin typographie mise en page"),
(2516, 0, 0,  25, 0, 255, "TYPNU", "Typographie numérique et informatique"),
(2517, 0, 0,  25, 0, 255, "ATGRA", "Atelier (arts graphiques)"),
(2518, 0, 0,  25, 0, 255, "LABEG", "Laboratoire expérimentations graphiques"),
(2599, 0, 0,  25, 0, 255, "IGRAD", "Industrie graphiques divers"),

-- Conduite - navigation

(2601, 0, 0,  26, 0, 255, "EXPTR", "Exploitation des transports"),
(2602, 0, 0,  26, 0, 255, "MMSOU", "Motorisation meca soudure"),
(2603, 0, 0,  26, 0, 255, "ENCOQ", "Entretien des coques"),
(2604, 0, 0,  26, 0, 255, "CO-NA", "Connaissance du navire"),
(2605, 0, 0,  26, 0, 255, "HYDSD", "Hydrostatique et hydrodynamique"),
(2606, 0, 0,  26, 0, 255, "LOGTQ", "Logistique"),
(2607, 0, 0,  26, 0, 255, "MANMC", "Manutention mécanisée"),
(2608, 0, 0,  26, 0, 255, "FEOTL", "Faisab. eval. Opérations transport logis"),
(2609, 0, 0,  26, 0, 255, "OGOTL", "Org.meo gest. Opérations transport logis"),
(2610, 0, 0,  26, 0, 255, "SVOTL", "Suivi opérations transport logistique"),
(2699, 0, 0,  26, 0, 255, "AUTAC", "Autres activités (conduite-navigation)dv"),

-- Métiers des arts appliqués

(2701, 0, 0,  27, 0, 255, "ATTKA", "Atelier et technologie appliquée"),
(2702, 0, 0,  27, 0, 255, "EDAAA", "Education artistique - arts appliqués - ana"),
(2703, 0, 0,  27, 0, 255, "ARCIE", "Archi interieure et expression plastique"),
(2704, 0, 0,  27, 0, 255, "A-CTA", "Arts et civil;techniques agencement et habitat"),
(2705, 0, 0,  27, 0, 255, "A-APP", "Arts appliqués"),
(2706, 0, 0,  27, 0, 255, "PLAST", "Plastique"),
(2707, 0, 0,  27, 0, 255, "ORGAN", "Organologie"),
(2708, 0, 0,  27, 0, 255, "TXPRO", "Travaux professionnels"),
(2709, 0, 0,  27, 0, 255, "TECEP", "Technologie spec -ethique-org profes legisla"),
(2710, 0, 0,  27, 0, 255, "BCCRE", "Bureau de création : créations"),
(2711, 0, 0,  27, 0, 255, "BCTEP", "Bureau de création : tvx et études prat"),
(2712, 0, 0,  27, 0, 255, "BCREA", "Bureau de création : réalisation"),
(2713, 0, 0,  27, 0, 255, "EDARA", "Education artistique arts appliqués"),
(2714, 0, 0,  27, 0, 255, "BCCOM", "Bureau de création : communication"),
(2715, 0, 0,  27, 0, 255, "MODCR", "Modes convent. représentation"),
(2716, 0, 0,  27, 0, 255, "D-ARA", "Dessin d'arts appliqués"),
(2717, 0, 0,  27, 0, 255, "BURET", "Bureau d'étude"),
(2718, 0, 0,  27, 0, 255, "HIATK", "Histoire des arts et des techniques"),
(2719, 0, 0,  27, 0, 255, "EDPAA", "Education plastique et arts appliqués"),
(2720, 0, 0,  27, 0, 255, "TECAP", "Technologie approfondissement"),
(2721, 0, 0,  27, 0, 255, "CPAAD", "Composition art applique aux domaines"),
(2722, 0, 0,  27, 0, 255, "ESTAP", "Esthétique appliquée à la profession"),
(2723, 0, 0,  27, 0, 255, "TXEPR", "Travaux et études pratiques"),
(2724, 0, 0,  27, 0, 255, "CREAT", "Créativité"),
(2725, 0, 0,  27, 0, 255, "T-GRA", "Technique graphique"),
(2726, 0, 0,  27, 0, 255, "D-TAC", "Dessin-technologie-atelier de création"),
(2727, 0, 0,  27, 0, 255, "PERSP", "Perspective"),
(2728, 0, 0,  27, 0, 255, "ETDOC", "Étude documentaire"),
(2729, 0, 0,  27, 0, 255, "TECTP", "Technologie et travaux pratiques"),
(2730, 0, 0,  27, 0, 255, "CPARA", "Composition d'arts appliqués"),
(2731, 0, 0,  27, 0, 255, "TTGRA", "Traitements graphiques"),
(2732, 0, 0,  27, 0, 255, "EDAEI", "Education artistique et esthétique indus"),
(2733, 0, 0,  27, 0, 255, "BCCRC", "Bureau de création : création céramique"),
(2734, 0, 0,  27, 0, 255, "BCCPL", "Bureau de création : création plastique"),
(2735, 0, 0,  27, 0, 255, "ATCTS", "Atelier création reali-techno specialit"),
(2736, 0, 0,  27, 0, 255, "BCAIN", "Bureau création architecture intérieure"),
(2737, 0, 0,  27, 0, 255, "BCSCM", "Bureau création style et croquis de mode"),
(2738, 0, 0,  27, 0, 255, "BCCTX", "Bureau de création : création textile"),
(2739, 0, 0,  27, 0, 255, "RPLAS", "Recherches plastiques"),
(2740, 0, 0,  27, 0, 255, "CAATR", "Comp arts appl et tech repres projets"),
(2741, 0, 0,  27, 0, 255, "EX-PC", "Expres plastique dessin création volume"),
(2742, 0, 0,  27, 0, 255, "A-ATX", "Arts appliqués aux textiles"),
(2743, 0, 0,  27, 0, 255, "BCDNT", "Bureau de création:TP et dessin technique"),
(2744, 0, 0,  27, 0, 255, "T-PPG", "Techniques de prod pub graph et audio"),
(2745, 0, 0,  27, 0, 255, "ERGON", "Ergonomie"),
(2746, 0, 0,  27, 0, 255, "HIACO", "Histoire de l'art et du costume"),
(2747, 0, 0,  27, 0, 255, "T-HAB", "Techniques de l'habillage"),
(2748, 0, 0,  27, 0, 255, "T-MAE", "Techniques maintenance - entretien"),
(2749, 0, 0,  27, 0, 255, "ETDFO", "Études et définitions des formes"),
(2750, 0, 0,  27, 0, 255, "ETREA", "Études et réalisations"),
(2751, 0, 0,  27, 0, 255, "CREAA", "Création artisanale"),
(2752, 0, 0,  27, 0, 255, "CREAI", "Création industrielle"),
(2753, 0, 0,  27, 0, 255, "INFGR", "Infographie"),
(2754, 0, 0,  27, 0, 255, "CT-RE", "Conception de réalisation"),
(2755, 0, 0,  27, 0, 255, "T-REL", "Techniques (ou technologie) de réalisation"),
(2756, 0, 0,  27, 0, 255, "TECCO", "Technologie de la communication"),
(2757, 0, 1,  27, 0, 255, "HIDA" , "Histoire des arts"),
(2758, 0, 0,  27, 0, 255, "D-CON", "Dessin de conception et d'application"),
(2759, 0, 0,  27, 0, 255, "HITEC", "Histoire des techniques"),
(2760, 0, 0,  27, 0, 255, "CR-DS", "Création design"),
(2761, 0, 0,  27, 0, 255, "CU-DS", "Culture design"),
(2762, 0, 0,  27, 0, 255, "STUCR", "Studio de création"),
(2763, 0, 0,  27, 0, 255, "ARVIS", "Arts visuels et appliqués"),
(2764, 0, 0,  27, 0, 255, "TEDEC", "Techniques du décor"),
(2765, 0, 0,  27, 0, 255, "R-DEV", "Recherche et développement"),
(2766, 0, 0,  27, 0, 255, "LABPV", "Labo photo ou vidéo"),
(2767, 0, 0,  27, 0, 255, "ARCAS", "Étude de cas (arts appliqués)"),
(2768, 0, 0,  27, 0, 255, "EPFRA", "Expres plastiq fondam - recherche appliq"),
(2769, 0, 0,  27, 0, 255, "EPRAM", "Exp plastiq fond - recherch.appliq. max"),
(2770, 0, 0,  27, 0, 255, "CREIP", "Création industrielle : produit"),
(2771, 0, 0,  27, 0, 255, "CREIE", "Création industrielle : environnement"),
(2772, 0, 0,  27, 0, 255, "BURCR", "Bureau de création"),
(2773, 0, 0,  27, 0, 255, "BCRDV", "Bureau de création:recherche et développement"),
(2774, 0, 0,  27, 0, 255, "RCONV", "Représentation conventionnelle"),
(2775, 0, 0,  27, 0, 255, "HIDA5", "Histoire des arts 5 heures"),
(2776, 0, 0,  27, 0, 255, "LIMNU", "Laboratoire images numériques"),
(2777, 0, 0,  27, 0, 255, "RDEVO", "Représentation en dessin et volume"),
(2778, 0, 0,  27, 0, 255, "FOGAB", "Formes - outillage et gabarits"),
(2779, 0, 0,  27, 0, 255, "TECHP", "Techniques particulières"),
(2780, 0, 0,  27, 0, 255, "ATART", "Atelier artistique"),
(2781, 0, 0,  27, 0, 255, "PJART", "Projet d'art appliqué"),
(2782, 0, 0,  27, 0, 255, "PAAHA", "Projet art appliqué et histoire de l'art"),
(2783, 0, 0,  27, 0, 255, "AACAR", "Arts appliqués et cultures artistiques"),
(2784, 0, 0,  27, 0, 255, "EQLSC", "Équipement des lieux scéniques"),
(2785, 0, 0,  27, 0, 255, "THEAT", "Théâtre"),
(2786, 0, 0,  27, 0, 255, "CIRQU", "Arts du cirque"),
(2787, 0, 0,  27, 0, 255, "PRPLA", "Pratique plastique"),
(2788, 0, 0,  27, 0, 255, "ATCON", "Ateliers de conception"),
(2789, 0, 0,  27, 0, 255, "CUART", "Culture artistique et technique"),
(2790, 0, 0,  27, 0, 255, "DCREA", "Démarche créative"),
(2791, 0, 0,  27, 0, 255, "COTEC", "Communication technique"),
(2792, 0, 0,  27, 0, 255, "ATECR", "Atelier de création et de réalisation"),
(2793, 0, 0,  27, 0, 255, "RCHPP", "Recherches et pratiques plastiques"),
(2794, 0, 0,  27, 0, 255, "A-SPE", "Arts du spectacle"),
(2795, 0, 0,  27, 0, 255, "PATRI", "Patrimoines"),
(2796, 0, 0,  27, 0, 255, "CCDES", "Création & culture design"),
(2797, 0, 0,  27, 0, 255, "DESAA", "Design et arts appliqués"),
(2798, 0, 0,  27, 0, 255, "HASCT", "Histoire de l'art des sciences & techniques"),
(2799, 0, 0,  27, 0, 255, "MARAD", "Métiers d'arts appliqués divers"),

-- Métiers d`art

(2801, 0, 0,  28, 0, 255, "D-GEO", "Dessin géométrique"),
(2802, 0, 0,  28, 0, 255, "D-ART", "Dessin d'arts"),
(2803, 0, 0,  28, 0, 255, "PR-AR", "Pratique artistique"),
(2804, 0, 0,  28, 0, 255, "HIART", "Histoire de l'art"),
(2805, 0, 0,  28, 0, 255, "HICIV", "Hist civilis et de leur exp art"),
(2806, 0, 0,  28, 0, 255, "HISDN", "Histoire des styles et dessins"),
(2807, 0, 0,  28, 0, 255, "D-VOL", "Dessin : volume"),
(2808, 0, 0,  28, 0, 255, "D-COU", "Dessin : couleur"),
(2809, 0, 0,  28, 0, 255, "D-DOC", "Dessin : document"),
(2810, 0, 0,  28, 0, 255, "CPPVO", "Composition plane et en volume"),
(2811, 0, 0,  28, 0, 255, "MODVO", "Modelage et études en volume"),
(2812, 0, 0,  28, 0, 255, "A-TKC", "Arts - techniques et civilisation"),
(2813, 0, 0,  28, 0, 255, "DSCRP", "Descriptive"),
(2814, 0, 0,  28, 0, 255, "RCHAR", "Recherche artistique"),
(2815, 0, 0,  28, 0, 255, "EVCRP", "Envir culturel et recherche plastique"),
(2816, 0, 0,  28, 0, 255, "T-SON", "Techniques du son"),
(2817, 0, 0,  28, 0, 255, "THED5", "Théâtre expression dramatique 5 heures"),
(2818, 0, 0,  28, 0, 255, "TECRL", "Technologie relations"),
(2819, 0, 0,  28, 0, 255, "T-EVS", "Techniques d'express visuelle et sémiologique"),
(2820, 0, 0,  28, 0, 255, "TECOU", "Technologie ouverture"),
(2821, 0, 0,  28, 0, 255, "TPRAT", "Travaux pratiques"),
(2822, 0, 0,  28, 0, 255, "T-EXA", "Techniques d'expression audiovisuelle"),
(2823, 0, 0,  28, 0, 255, "HICVI", "Hist des arts liée à la commu visuelle"),
(2824, 0, 0,  28, 0, 255, "TECPM", "Technologie profession-mach spectacle"),
(2825, 0, 0,  28, 0, 255, "DCVIS", "Document et communication visuelle"),
(2826, 0, 0,  28, 0, 255, "HISPC", "Histoire du spectacle"),
(2827, 0, 0,  28, 0, 255, "CO-MS", "Connaissance du monde du spectacle"),
(2828, 0, 0,  28, 0, 255, "CIAV5", "Cinéma - audiovisuel 5 heures"),
(2829, 0, 0,  28, 0, 255, "CMEDI", "Comédie"),
(2830, 0, 0,  28, 0, 255, "ETROL", "Étude d'un rôle"),
(2831, 0, 0,  28, 0, 255, "EX-VR", "Expression verbale"),
(2832, 0, 0,  28, 0, 255, "EX-CP", "Expression corporelle"),
(2833, 0, 0,  28, 0, 255, "SONPT", "Sonorisation pratique"),
(2834, 0, 0,  28, 0, 255, "ERSON", "Enregistrements sonores"),
(2835, 0, 0,  28, 0, 255, "ETRCO", "Étude et réalisation de costumes"),
(2836, 0, 0,  28, 0, 255, "ECLAR", "Eclairagisme artistique"),
(2837, 0, 0,  28, 0, 255, "SCENO", "Scénographie"),
(2838, 0, 0,  28, 0, 255, "THEAD", "Théâtre - expression dramatique"),
(2839, 0, 0,  28, 0, 255, "EXEMD", "Exécution maquettes décors accessoires"),
(2840, 0, 0,  28, 0, 255, "RGLUM", "Réglage de la lumière"),
(2841, 0, 0,  28, 0, 255, "RGMES", "Réglage d'une mise en scène"),
(2842, 0, 0,  28, 0, 255, "RLVMS", "Relevé d'une mise en scène"),
(2843, 0, 0,  28, 0, 255, "SCEMX", "Sciences appliquées et étude matériaux"),
(2844, 0, 0,  28, 0, 255, "HITHE", "Histoire du théâtre"),
(2845, 0, 0,  28, 0, 255, "PEMAQ", "Perruquage maquillage"),
(2846, 0, 0,  28, 0, 255, "RDECO", "Recherche en décors costumes"),
(2847, 0, 0,  28, 0, 255, "T-EPH", "Technique et expression photographique"),
(2848, 0, 0,  28, 0, 255, "PHOTO", "Photographie"),
(2849, 0, 0,  28, 0, 255, "AUDVI", "Audiovisuel"),
(2850, 0, 0,  28, 0, 255, "ADMTH", "Administration (théâtre)"),
(2851, 0, 0,  28, 0, 255, "T-EXV", "Techniques d'expression visuelle"),
(2852, 0, 0,  28, 0, 255, "CI-AV", "Cinéma - audiovisuel"),
(2853, 0, 0,  28, 0, 255, "REGIE", "Régie"),
(2854, 0, 0,  28, 0, 255, "CI-TG", "Cinématographie"),
(2855, 0, 0,  28, 0, 255, "PERUQ", "Perruquage"),
(2856, 0, 0,  28, 0, 255, "ACCES", "Accessoirisme"),
(2857, 0, 0,  28, 0, 255, "MAQIL", "Maquillage"),
(2858, 0, 0,  28, 0, 255, "TGOMU", "Transpos.graphique d'une œuvre musicale"),
(2859, 0, 0,  28, 0, 255, "EX-PL", "Expression plastique"),
(2860, 0, 0,  28, 0, 255, "D-EPL", "Dessin et expression plastique"),
(2861, 0, 0,  28, 0, 255, "SDPCC", "Scénographie-décor-personnages conception"),
(2862, 0, 0,  28, 0, 255, "IMANI", "Interprétation- manipulation"),
(2863, 0, 0,  28, 0, 255, "SDPCT", "Scénographie-décor-personnages construction"),
(2864, 0, 0,  28, 0, 255, "TECPL", "Technologie du plateau"),
(2865, 0, 0,  28, 0, 255, "EX-MU", "Expression musicale"),
(2867, 0, 0,  28, 0, 255, "DRAMS", "Dramaturgie - mise en scène"),
(2868, 0, 0,  28, 0, 255, "A-DRA", "Art dramatique"),
(2869, 0, 0,  28, 0, 255, "T-PHO", "Technique photographie"),
(2870, 0, 0,  28, 0, 255, "ACOUS", "Acoustique"),
(2871, 0, 0,  28, 0, 255, "AP-CA", "Atel de pratique : cinéma - audiovisuel"),
(2872, 0, 0,  28, 0, 255, "AP-TE", "Atel de prat : théâtre exp dramatique"),
(2873, 0, 0,  28, 0, 255, "CI-SP", "Cinéma spécialité"),
(2874, 0, 0,  28, 0, 255, "THTSP", "Théâtre spécialité"),
(2875, 0, 0,  28, 0, 255, "CI-PA", "Cinéma option - pratique artistique"),
(2876, 0, 0,  28, 0, 255, "THTPA", "Théâtre option - pratique artistique"),
(2877, 0, 0,  28, 0, 255, "HIASC", "Histoire des arts et scénographie"),
(2878, 0, 0,  28, 0, 255, "HITDR", "Histoire du théâtre et dramaturgie"),
(2879, 0, 0,  28, 0, 255, "SOSPC", "Sociologie du spectacle"),
(2880, 0, 0,  28, 0, 255, "SMACH", "Scénographie - machinerie"),
(2881, 0, 0,  28, 0, 255, "REGLU", "Régie lumière"),
(2882, 0, 0,  28, 0, 255, "CULAR", "Culture artistique"),
(2883, 0, 0,  28, 0, 255, "HIAGR", "Histoire de l'art et de la gravure"),
(2884, 0, 0,  28, 0, 255, "HIALI", "Histoire de l'art et du livre"),
(2885, 0, 0,  28, 0, 255, "CPLAC", "Culture plastique - approche création"),
(2886, 0, 0,  28, 0, 255, "CIPRO", "Arts du cirque (enseignement professionnel)"),
(2887, 0, 0,  28, 0, 255, "MAPRO", "Arts marionnette (enseignement professionnel)"),
(2888, 0, 0,  28, 0, 255, "METAO", "Méthode d'analyse des œuvres"),
(2889, 0, 0,  28, 0, 255, "HADEC", "Histoire de l'art et du décor"),
(2890, 0, 0,  28, 0, 255, "HSVCA", "Hist spect vivant - cinéma - audiovisuel"),
(2891, 0, 0,  28, 0, 255, "TCIRQ", "Technique de cirque"),
(2892, 0, 0,  28, 0, 255, "TSPEC", "Technique de spectacle"),
(2893, 0, 0,  28, 0, 255, "SPECS", "Spécialisation (cirque et spectacle)"),
(2894, 0, 0,  28, 0, 255, "ARMAQ", "Art et maquillage"),
(2895, 0, 0,  28, 0, 255, "RECHA", "Recherche appliquée (arts)"),
(2896, 0, 0,  28, 0, 255, "SMSON", "Studio de montage et de son"),
(2897, 0, 0,  28, 0, 255, "SFTEC", "Studio de fabrication - technologie"),
(2898, 0, 0,  28, 0, 255, "ATEXA", "Atelier d'expression artistique"),
(2899, 0, 0,  28, 0, 255, "MARDI", "Métiers d'art divers"),

-- Métiers de l`artisanat et spécifiques

(2901, 0, 0,  29, 0, 255, "BIJOU", "Bijouterie"),
(2902, 0, 0,  29, 0, 255, "CADTP", "Compo.art appli.dom.techniq.repres.projt"),
(2999, 0, 0,  29, 0, 255, "ARDIV", "Artisanat divers"),

-- Biotechnologie génie biol.- biochimique

(3001, 0, 0,  30, 0, 255, "TDBIO", "Travaux dirigés de biologie"),
(3002, 0, 0,  30, 0, 255, "GEOLO", "Géologie"),
(3003, 0, 0,  30, 0, 255, "TECSO", "Technologie sondage"),
(3004, 0, 0,  30, 0, 255, "ACEXT", "Activités extérieures"),
(3005, 0, 0,  30, 0, 255, "BLGGL", "Biologie - géologie"),
(3006, 0, 0,  30, 0, 255, "SCBIO", "Sciences biologiques"),
(3007, 0, 0,  30, 0, 255, "ETSPE", "Étude des syst prod equip-instal usines"),
(3008, 0, 0,  30, 0, 255, "TECAL", "Technologie de l'alimentation"),
(3009, 0, 0,  30, 0, 255, "ACTEC", "Activités technologiques"),
(3010, 0, 0,  30, 0, 255, "I-TAD", "Init travaux d'atelier de demi-grand"),
(3011, 0, 0,  30, 0, 255, "BLGIE", "Biologie"),
(3012, 0, 0,  30, 0, 255, "ARBOR", "Arboriculture d'ornement"),
(3013, 0, 0,  30, 0, 255, "BLGAP", "Biologie appliquée"),
(3014, 0, 0,  30, 0, 255, "CH-IC", "Chimie appliquée aux industries céréalières"),
(3015, 0, 0,  30, 0, 255, "BLGVG", "Biologie végétale"),
(3016, 0, 0,  30, 0, 255, "OENOL", "Œnologie"),
(3017, 0, 0,  30, 0, 255, "TECCE", "Technologie des céréales"),
(3018, 0, 0,  30, 0, 255, "BLGCM", "Biol cellulaire et moléculaire"),
(3019, 0, 0,  30, 0, 255, "BLGAN", "Biologie animale"),
(3020, 0, 0,  30, 0, 255, "MIBIO", "Microbiologie"),
(3021, 0, 0,  30, 0, 255, "BCHBL", "Biochimie biologie"),
(3022, 0, 0,  30, 0, 255, "BCHIM", "Biochimie"),
(3023, 0, 0,  30, 0, 255, "ALIAN", "Alimentation animale"),
(3024, 0, 0,  30, 0, 255, "BCHPH", "Biochimie physiologie"),
(3025, 0, 0,  30, 0, 255, "BCHMI", "Biochimie microbiologie"),
(3026, 0, 0,  30, 0, 255, "EXPRM", "Exploitation des ressources de la mer"),
(3027, 0, 0,  30, 0, 255, "GNRUR", "Génie rural"),
(3028, 0, 0,  30, 0, 255, "FA-MM", "Fab mainten ds les dom rur et maritimes"),
(3029, 0, 0,  30, 0, 255, "MI1TF", "Meunerie et industries de 1ere transfor"),
(3030, 0, 0,  30, 0, 255, "PHYSL", "Physiologie"),
(3031, 0, 0,  30, 0, 255, "MSPPA", "Manipulation sci de phys papetière"),
(3032, 0, 0,  30, 0, 255, "SAMEP", "Sciences app mise en œuvre d'études papetières"),
(3033, 0, 0,  30, 0, 255, "PRD-P", "Production et transformation (papier)"),
(3034, 0, 0,  30, 0, 255, "I-MAR", "Initiation au milieu marin"),
(3035, 0, 0,  30, 0, 255, "AGRON", "Agronomie"),
(3036, 0, 0,  30, 0, 255, "GNBTA", "Génie biologique et techno analyse"),
(3037, 0, 0,  30, 0, 255, "STL"  , "Sciences et techno des laboratoires"),
(3038, 0, 0,  30, 0, 255, "GLMIN", "Géologie et minéralogie"),
(3039, 0, 0,  30, 0, 255, "TECAC", "Technologie des appareils correcteurs"),
(3040, 0, 0,  30, 0, 255, "TPTAP", "TP et technologie d'application"),
(3041, 0, 0,  30, 0, 255, "D-TBT", "Dessin technique (biotechnologie)"),
(3042, 0, 0,  30, 0, 255, "TECCH", "Technologie construction de chaussures"),
(3043, 0, 0,  30, 0, 255, "SPBSA", "Sciences phy bio et sciences appliquées"),
(3044, 0, 0,  30, 0, 255, "SCBAG", "Sciences biologiques et agronomie"),
(3045, 0, 0,  30, 0, 255, "BLGEC", "Biologie - écologie"),
(3046, 0, 0,  30, 0, 255, "AGRIV", "Agriculture et environnement"),
(3047, 0, 0,  30, 0, 255, "AMGEV", "Aménagement et environnement"),
(3048, 0, 0,  30, 0, 255, "BLGEM", "Biologie écologie module"),
(3049, 0, 0,  30, 0, 255, "HYDRO", "Hydraulique"),
(3050, 0, 0,  30, 0, 255, "GNPTE", "Génie des procédés traitement des eaux"),
(3051, 0, 0,  30, 0, 255, "SSSOC", "Sciences sanitaires et sociales"),
(3052, 0, 0,  30, 0, 255, "CMNAS", "Communication en santé et action sociale"),
(3053, 0, 0,  30, 0, 255, "BLGHU", "Biologie humaine"),
(3054, 0, 0,  30, 0, 255, "AGROV", "Agronomie et environnement"),
(3055, 0, 0,  30, 0, 255, "BLGES", "Biologie écologie agronomie spécialité"),
(3056, 0, 0,  30, 0, 255, "P-CSS", "Préparation aux concours sanitaire et social"),
(3057, 0, 0,  30, 0, 255, "S-BT" , "Sciences biologiques et de la terre"),
(3058, 0, 0,  30, 0, 255, "ECOAG", "Ecologie - agronomie"),
(3059, 0, 0,  30, 0, 255, "GEIND", "Génie industriel bio"),
(3060, 0, 0,  30, 0, 255, "GEPRO", "Génie des procédés"),
(3061, 0, 0,  30, 0, 255, "STBIO", "Sciences et techno des bio-industries"),
(3062, 0, 0,  30, 0, 255, "IALAB", "Informatique appliquée au laboratoire"),
(3063, 0, 0,  30, 0, 255, "EXPAN", "Expérimentation animale"),
(3064, 0, 0,  30, 0, 255, "BBM-E", "Biochimie biologie microbiologie des eaux"),
(3065, 0, 0,  30, 0, 255, "SCALI", "Sciences des aliments"),
(3066, 0, 0,  30, 0, 255, "EATCI", "Ecologie-agronomie-territoire-citoyenneté"),
(3067, 0, 0,  30, 0, 255, "BIOLP", "Biologie de laboratoire et paramédicale"),
(3068, 0, 0,  30, 0, 255, "AGTCI", "Agronomie-territoire-citoyenneté"),
(3069, 0, 0,  30, 0, 255, "BASAN", "Biologie appliquée - santé"),
(3070, 0, 0,  30, 0, 255, "BIOTA", "Biochimie et technologies d'analyse"),
(3071, 0, 0,  30, 0, 255, "BBCMO", "Biochim. biologie cellulaire moléculaire"),
(3072, 0, 0,  30, 0, 255, "MBTAN", "Microbiologie et technologies d'analyse"),
(3073, 0, 0,  30, 0, 255, "MBBCM", "Microbiologie biologie cellul. Molécul."),
(3074, 0, 0,  30, 0, 255, "STBIN", "Sciences technologies bio-industrielles"),
(3075, 0, 0,  30, 0, 255, "TECBB", "Technologies biochimiques et biologiques"),
(3076, 0, 0,  30, 0, 255, "SCTSS", "Scienc. & techniq. sanitaires & sociales"),
(3077, 0, 0,  30, 0, 255, "BPPHU", "Biologie & physiopathologie humaines"),
(3078, 0, 0,  30, 0, 255, "BIMGG", "Biologie moléculaire et génie génétique"),
(3079, 0, 0,  30, 0, 255, "BANAL", "Biochimie analytique"),
(3080, 0, 0,  30, 0, 255, "BISFP", "Biochimie structur.& fonction. Protéines"),
(3081, 0, 0,  30, 0, 255, "MBIGF", "Microbiologie et génie fermentaire"),
(3082, 0, 0,  30, 0, 255, "BTCEL", "Biologie et technologies cellulaires"),
(3083, 0, 0,  30, 0, 255, "SLABO", "Sciences & laboratoire"),
(3084, 0, 0,  30, 0, 255, "EAEDD", "Ecologie - ecolo.agro.territ.dev.durable"),
(3085, 0, 0,  30, 0, 255, "BAT2D", "Biologie agro. territoir.& devel.durable"),
(3086, 0, 0,  30, 0, 255, "VIVAN", "Chimie - biochimie - sciences du vivant"),
(3087, 0, 0,  30, 0, 255, "MESIN", "Mesure et instrumentation"),
(3088, 0, 0,  30, 0, 255, "ECAGT", "Ecologie agronomie et territoires"),
(3089, 0, 0,  30, 0, 255, "MAPHY", "Microbiologie appliquée & physiopathologie"),
(3090, 0, 0,  30, 0, 255, "ACMAE", "Agronomie & connaissance milieu agroéquipement"),
(3091, 0, 0,  30, 0, 255, "STSYS", "Sciences et technologie des systèmes"),
(3092, 0, 0,  30, 0, 255, "SQSER", "Syst.qual.sécur.envir. resp.sociale & devel.durable"),
(3093, 0, 0,  30, 0, 255, "BMEAP", "Biologie microbiologie & écologie appliquée"),
(3099, 0, 0,  30, 0, 255, "BTGBD", "Biotechnologie génie bio divers"),

-- Biotechnologie santé environnement collectivités

(3101, 0, 0,  31, 0, 255, "ALIHU", "Alimentation humaine"),
(3102, 0, 0,  31, 0, 255, "E-FS" , "Économie familiale et sociale"),
(3103, 0, 0,  31, 0, 255, "DACVQ", "Domaines activités vie quotidienne"),
(3104, 0, 0,  31, 0, 255, "MCESF", "Mode intervention conseiller en ESF"),
(3105, 0, 0,  31, 0, 255, "E-DOM", "Économie domestique"),
(3106, 0, 0,  31, 0, 255, "P-VSF", "Préparation à la vie sociale et familial"),
(3107, 0, 0,  31, 0, 255, "P-VSP", "Préparation vie sociale et prof (ses)"),
(3108, 0, 0,  31, 0, 255, "E-SFQ", "Économie sociale-familiale appl quotidien"),
(3109, 0, 0,  31, 0, 255, "HYGAL", "Hygiène générale et alimentaire"),
(3110, 0, 0,  31, 0, 255, "HYGPS", "Hygiène prévention secourisme"),
(3111, 0, 0,  31, 0, 255, "BANCS", "Banc essai"),
(3112, 0, 0,  31, 0, 255, "REGIM", "Régimes"),
(3113, 0, 0,  31, 0, 255, "STBPM", "Sciences et techniques bio et paramédicales"),
(3114, 0, 0,  31, 0, 255, "T-PRO", "Techniques professionnelles"),
(3115, 0, 0,  31, 0, 255, "VISTA", "Visites stages"),
(3116, 0, 0,  31, 0, 255, "BPDIE", "Bases physiopathologiques de diététique"),
(3117, 0, 0,  31, 0, 255, "NUTAL", "Nutrition et alimentation"),
(3118, 0, 0,  31, 0, 255, "CO-MV", "Connaissance milieu vie et travail"),
(3119, 0, 0,  31, 0, 255, "VSPRO", "Vie sociale et professionnelle"),
(3120, 0, 0,  31, 0, 255, "STHEV", "Sciences et techno habitat environnement"),
(3121, 0, 0,  31, 0, 255, "PRVSF", "Prep à la vie sociale et familiale"),
(3122, 0, 0,  31, 0, 255, "QUALI", "Qualité (famille 31)"),
(3123, 0, 0,  31, 0, 255, "METSO", "Méthodologie du travail social"),
(3124, 0, 0,  31, 0, 255, "ALTHP", "Alimentation théorique et pratique"),
(3125, 0, 0,  31, 0, 255, "HABAM", "Habillement ameublement"),
(3126, 0, 0,  31, 0, 255, "APSEC", "Actions professionnelles (bio.sant.env.collec)"),
(3127, 0, 0,  31, 0, 255, "PRISQ", "Prévention des risques"),
(3128, 0, 0,  31, 0, 255, "PSE"  , "Prévention - santé - environnement"),
(3129, 0, 0,  31, 0, 255, "HABLO", "Habitat - logement"),
(3130, 0, 0,  31, 0, 255, "ALSHY", "Alimentation - santé - hygiène"),
(3131, 0, 0,  31, 0, 255, "BIOTE", "Biotechnologies"),
(3132, 0, 0,  31, 0, 255, "CDESF", "Connaissance domaines majeurs esf"),
(3133, 0, 0,  31, 0, 255, "ISPRO", "Insertion sociale et professionnelle"),
(3134, 0, 0,  31, 0, 255, "INTSO", "Intervention sociale"),
(3199, 0, 0,  31, 0, 255, "BTSAD", "Biotechnologie santé divers"),

-- Paramédical et médical

(3201, 0, 0,  32, 0, 255, "ANAOM", "Anatomie (ostéologie-myologie)"),
(3202, 0, 0,  32, 0, 255, "FSPTM", "Physiopatho terminologie médicale"),
(3203, 0, 0,  32, 0, 255, "APB"  , "APB"),
(3204, 0, 0,  32, 0, 255, "PGIPR", "Patho gene intro pharma radiobio"),
(3205, 0, 0,  32, 0, 255, "PTTRT", "Patho - therapeu - tech radiodiag - therap"),
(3206, 0, 0,  32, 0, 255, "T-RR" , "Techniques radiodiag et radiotherap"),
(3207, 0, 0,  32, 0, 255, "SMS"  , "Sciences médico-sociales"),
(3208, 0, 0,  32, 0, 255, "STMS" , "Sciences et techniques médico-sociales"),
(3209, 0, 0,  32, 0, 255, "STRAD", "Stages radiologie"),
(3210, 0, 0,  32, 0, 255, "ECMED", "Éléments de connaissance médicale"),
(3211, 0, 0,  32, 0, 255, "IMUNO", "Immunologie"),
(3212, 0, 0,  32, 0, 255, "HCYTO", "Histologie cytologie"),
(3213, 0, 0,  32, 0, 255, "HEMAT", "Hématologie"),
(3214, 0, 0,  32, 0, 255, "P-PSG", "Prepa cert capa en prélèvement sanguin"),
(3215, 0, 0,  32, 0, 255, "STHSP", "Stage technique hospitalière"),
(3216, 0, 0,  32, 0, 255, "ANATO", "Anatomie"),
(3217, 0, 0,  32, 0, 255, "ANAPP", "Anatomie physiologie pathologie"),
(3218, 0, 0,  32, 0, 255, "SMEDS", "Stage milieu médical spécialisé"),
(3219, 0, 0,  32, 0, 255, "HHCYT", "Hématologie - histologie - cytologie"),
(3220, 0, 0,  32, 0, 255, "TECMA", "Technologie matériels"),
(3221, 0, 0,  32, 0, 255, "ANAMP", "Anatomie - morphologie"),
(3223, 0, 0,  32, 0, 255, "STBP" , "Sciences et techn biol et paramédicales"),
(3224, 0, 0,  32, 0, 255, "IMNEP", "Im med medec nucl 4rad elec pathol pharm"),
(3226, 0, 0,  32, 0, 255, "C-MED", "Connaissances médicales"),
(3227, 0, 0,  32, 0, 255, "TPPOD", "Travaux pratiques (podo-orthesiste)"),
(3228, 0, 0,  32, 0, 255, "TPPRT", "Travaux pratiques (prothesiste.-orthesiste)"),
(3229, 0, 0,  32, 0, 255, "APPAP", "Application de l'appareillage"),
(3230, 0, 0,  32, 0, 255, "ETCAP", "Étude et conception de l'appareillage"),
(3231, 0, 0,  32, 0, 255, "REAAP", "Réalisation de l'appareillage"),
(3232, 0, 0,  32, 0, 255, "ANVIS", "Analyse de la vision"),
(3233, 0, 0,  32, 0, 255, "MSFAC", "Mesures faciales"),
(3234, 0, 0,  32, 0, 255, "ERCEQ", "Étude réalisation contrôle d'équipement"),
(3235, 0, 0,  32, 0, 255, "MAGAP", "Magasin d'application"),
(3236, 0, 0,  32, 0, 255, "IMHCY", "Immunologie histologie cytologie"),
(3237, 0, 0,  32, 0, 255, "ERGSE", "Sécurité et ergonomie"),
(3238, 0, 0,  32, 0, 255, "IEXPA", "Immunologie et expérimentation animale"),
(3239, 0, 0,  32, 0, 255, "HEHIC", "Hématologie - histologie - cytologie"),
(3240, 0, 0,  32, 0, 255, "PHOFF", "Pharmacie d'officine"),
(3241, 0, 0,  32, 0, 255, "MASSS", "Methodo.appliq.secteur sanit.& soc."),
(3242, 0, 0,  32, 0, 255, "HEMAN", "Hématologie - anatomopathologie"),
(3243, 0, 0,  32, 0, 255, "SANTS", "Sante & social"),
(3244, 0, 0,  32, 0, 255, "AOCCL", "Anatomie-occlusodontie"),
(3245, 0, 0,  32, 0, 255, "SMVSM", "Sc. matière et vie et sciences médicales"),
(3246, 0, 0,  32, 0, 255, "IMDTR", "Sc. & techn., fond. méth. imagerie médicale"),
(3247, 0, 0,  32, 0, 255, "IIMDT", "Sc. & techn., intervention en imagerie médicale"),
(3248, 0, 0,  32, 0, 255, "OUTMT", "Outils et méthodes de travail"),
(3249, 0, 0,  32, 0, 255, "INSPP", "Intégration savoirs & posture professionnelle"),
(3299, 0, 0,  32, 0, 255, "PRMDI", "Paramédical divers"),

-- Soins personnels

(3301, 0, 0,  33, 0, 255, "ESTCP", "Esthétique - cosmétique - parfumerie"),
(3302, 0, 0,  33, 0, 255, "ETCRT", "Étude de cas concrets"),
(3303, 0, 0,  33, 0, 255, "T-HYH", "Techniques de soins et hygiène hospitalière"),
(3304, 0, 0,  33, 0, 255, "COSME", "Cosmétologie"),
(3305, 0, 0,  33, 0, 255, "TALOC", "Technologie des appareils et des locaux"),
(3306, 0, 0,  33, 0, 255, "TESTH", "Techniques esthétiques"),
(3307, 0, 0,  33, 0, 255, "QUOTI", "Interv.sur le quotidien et son évolution"),
(3308, 0, 0,  33, 0, 255, "CMOTE", "Conception et moe de techniques cosmet."),
(3309, 0, 0,  33, 0, 255, "ENEST", "Environnement esthétique"),
(3310, 0, 0,  33, 0, 255, "PRCOS", "Le produit cosmétique"),
(3311, 0, 0,  33, 0, 255, "APECP", "Actions professionnelles (esthétique cosmétique parfumerie)"),
(3312, 0, 0,  33, 0, 255, "TPPLU", "Travaux pratiques pluridimensionnels"),
(3313, 0, 0,  33, 0, 255, "EFPRC", "Efficacite des produits cosmétiques"),
(3314, 0, 0,  33, 0, 255, "COELP", "Conception, élaboration, production"),
(3315, 0, 0,  33, 0, 255, "TECHC", "Techniques cosmétiques"),
(3316, 0, 0,  33, 0, 255, "FPCCO", "Fondement physico-chimiques cosmétologie"),
(3317, 0, 0,  33, 0, 255, "COSAP", "Cosmétologie appliquée"),
(3399, 0, 0,  33, 0, 255, "SPERD", "Soins personnels divers"),

-- Commerce

(3401, 0, 0,  34, 0, 255, "VADIS", "Vente à distance"),
(3402, 0, 0,  34, 0, 255, "GDIST", "Grande distribution"),
(3403, 0, 0,  34, 0, 255, "VPRFR", "Vente de produits frais"),
(3404, 0, 0,  34, 0, 255, "VCETR", "Vente à la clientèle étrangère"),
(3405, 0, 0,  34, 0, 255, "VARVS", "Vente d'articles vestimentaires"),
(3406, 0, 0,  34, 0, 255, "TE-CO", "Technico-commercial"),
(3407, 0, 0,  34, 0, 255, "VVHOR", "Vente de végétaux horticoles"),
(3408, 0, 0,  34, 0, 255, "COMGE", "Commercialisation - gestion"),
(3409, 0, 0,  34, 0, 255, "EXPCT", "Exploitation entrepr com traditionnelle"),
(3410, 0, 0,  34, 0, 255, "ETOM" , "Étude des offres et marches"),
(3411, 0, 0,  34, 0, 255, "MARKT", "Marketing études de marchés études de cas"),
(3412, 0, 0,  34, 0, 255, "FCTCO", "Fonction commerciale"),
(3413, 0, 0,  34, 0, 255, "ATVTA", "Action vente appliquée"),
(3414, 0, 0,  34, 0, 255, "T-COM", "Techniques commerciales"),
(3415, 0, 0,  34, 0, 255, "CMNNE", "Communication et négociation"),
(3416, 0, 0,  34, 0, 255, "G-CMF", "Gestion ciale et manag force de vente"),
(3417, 0, 0,  34, 0, 255, "VENTP", "Vente(tp-présentation-expr.-comportement)"),
(3418, 0, 0,  34, 0, 255, "ATTCA", "Actions technico-commerciales appliquées"),
(3419, 0, 0,  34, 0, 255, "COMIA", "Commerce international appliqué"),
(3420, 0, 0,  34, 0, 255, "MT-AC", "Méthodes administratives et commerciales"),
(3421, 0, 0,  34, 0, 255, "ATCOM", "Action commerciale"),
(3422, 0, 0,  34, 0, 255, "VLIBR", "Vente en librairie"),
(3423, 0, 0,  34, 0, 255, "T-TCI", "Technique du commerce international"),
(3424, 0, 0,  34, 0, 255, "BURCO", "Bureau commercial"),
(3425, 0, 0,  34, 0, 255, "N-COM", "Enseignement commercial"),
(3426, 0, 0,  34, 0, 255, "MQNEG", "Mercatique et négociation"),
(3427, 0, 0,  34, 0, 255, "ANTCO", "Analyse technico-commerciale"),
(3428, 0, 0,  34, 0, 255, "OU-GC", "Outils de gestion commerciale"),
(3429, 0, 0,  34, 0, 255, "MERCA", "Mercatique"),
(3430, 0, 0,  34, 0, 255, "SERVC", "Service et commercialisation"),
(3431, 0, 0,  34, 0, 255, "APRSE", "Approfondissement sectoriel"),
(3432, 0, 0,  34, 0, 255, "AIVPF", "Aide à la vie professionnelle"),
(3433, 0, 0,  34, 0, 255, "MQNMI", "Mercatique négociation - management international"),
(3434, 0, 0,  34, 0, 255, "AIPAR", "Aide au partenariat"),
(3435, 0, 0,  34, 0, 255, "ATCOC", "Action et communication commerciales"),
(3436, 0, 0,  34, 0, 255, "VPAMT", "Vente produits arts maison table"),
(3437, 0, 0,  34, 0, 255, "ANIML", "Animalerie"),
(3438, 0, 0,  34, 0, 255, "AGTCC", "Agent commercial de conduite"),
(3439, 0, 0,  34, 0, 255, "VDISQ", "Vente de disques et produits assimiles"),
(3440, 0, 0,  34, 0, 255, "VCLAV", "Vente claviers électronique - informatique musicale"),
(3441, 0, 0,  34, 0, 255, "VBRUN", "Vente de produits bruns"),
(3442, 0, 0,  34, 0, 255, "G-COM", "Gestion commerciale"),
(3443, 0, 0,  34, 0, 255, "VHABT", "Vente de produits de l'habitat"),
(3444, 0, 0,  34, 0, 255, "VTVIN", "Vente de vin"),
(3445, 0, 0,  34, 0, 255, "CPSMB", "Commerc prdts serv micro-inform bureautq"),
(3446, 0, 0,  34, 0, 255, "VTPBF", "Vente produits bancaires et financiers"),
(3447, 0, 0,  34, 0, 255, "VTPAA", "Vente de produits agroalimentaires"),
(3448, 0, 0,  34, 0, 255, "CPTOU", "Commercialisation de produits touristiques"),
(3449, 0, 0,  34, 0, 255, "MGUCO", "Management gestion unités commerciales"),
(3450, 0, 0,  34, 0, 255, "GRCOM", "Gestion de la relation commerciale"),
(3451, 0, 0,  34, 0, 255, "DUNCO", "Développement de l'unité commerciale"),
(3452, 0, 0,  34, 0, 255, "G-CLI", "Gestion de clientèles"),
(3453, 0, 0,  34, 0, 255, "RELCL", "Relation client"),
(3454, 0, 0,  34, 0, 255, "MEQCO", "Management de l'équipe commerciale"),
(3455, 0, 0,  34, 0, 255, "GPROJ", "Gestion de projet"),
(3456, 0, 0,  34, 0, 255, "DCLIE", "Développement de clientèles"),
(3457, 0, 0,  34, 0, 255, "MANCO", "Management commercial"),
(3458, 0, 0,  34, 0, 255, "EVDME", "Étude et veille des marches étrangers"),
(3459, 0, 0,  34, 0, 255, "PSCLI", "Prospection et suivi de clientèle"),
(3460, 0, 0,  34, 0, 255, "NEGOV", "Négociation vente"),
(3461, 0, 0,  34, 0, 255, "GOPIE", "Gestion des ope rations d'import-export"),
(3462, 0, 0,  34, 0, 255, "GRSER", "Gestion de la relation de service"),
(3463, 0, 0,  34, 0, 255, "ARELC", "Atelier relations commerciales"),
(3464, 0, 0,  34, 0, 255, "RELCF", "Relation avec la clientèle & les fournisseurs"),
(3465, 0, 0,  34, 0, 255, "MANEC", "Management de l'entité commerciale"),
(3466, 0, 0,  34, 0, 255, "VPSCP", "Mise en valeur prod. et serv. et comm. publiciaire"),
(3467, 0, 0,  34, 0, 255, "TNERC", "Technique de négociation relation client"),
(3468, 0, 0,  34, 0, 255, "TECOM", "Technologies commerciales"),
(3469, 0, 0,  34, 0, 255, "IMSMA", "Image et mise en scène de la marque"),
(3470, 0, 0,  34, 0, 255, "DSACC", "Développement & suivi de l'activité commerciale"),
(3471, 0, 0,  34, 0, 255, "MAGRH", "Management gestion des ressources humaines"),
(3472, 0, 0,  34, 0, 255, "MERMA", "Mercatique (marketing)"),
(3499, 0, 0,  34, 0, 255, "E-GSD", "Économie et gestion divers"),

-- Bureautique et secrétariat

(3501, 0, 0,  35, 0, 255, "SDSCI", "Secrétariat et documentation scientifique"),
(3502, 0, 0,  35, 0, 255, "CORES", "Correspondance"),
(3503, 0, 0,  35, 0, 255, "SAIDO", "Saisie données"),
(3504, 0, 0,  35, 0, 255, "CORRA", "Correspondance et rapport"),
(3505, 0, 0,  35, 0, 255, "T-SEC", "Techniques de secrétariat"),
(3506, 0, 0,  35, 0, 255, "BURTQ", "Bureautique"),
(3507, 0, 0,  35, 0, 255, "UCLAV", "Utilisation des claviers"),
(3508, 0, 0,  35, 0, 255, "DACTL", "Dactylographie"),
(3509, 0, 0,  35, 0, 255, "PRPAR", "Prise rapide de la parole"),
(3510, 0, 0,  35, 0, 255, "STENO", "Sténographie"),
(3511, 0, 0,  35, 0, 255, "SCTLA", "Secrétariat en langue étrangère A"),
(3512, 0, 0,  35, 0, 255, "SCTLB", "Secrétariat en langue étrangère B"),
(3513, 0, 0,  35, 0, 255, "T-BSE", "Techniques de base du secrétariat"),
(3514, 0, 0,  35, 0, 255, "BUREA", "Bureau"),
(3515, 0, 0,  35, 0, 255, "MA1BU", "Module d'approfond. 1 (bureautique)"),
(3516, 0, 0,  35, 0, 255, "MA2BU", "Module d'approfond. 2 (bureautique)"),
(3517, 0, 0,  35, 0, 255, "I-OUB", "Initiation aux outils de la bureautique"),
(3518, 0, 0,  35, 0, 255, "MTPCP", "Méthode pratique de communication professionnelle"),
(3519, 0, 0,  35, 0, 255, "O-GES", "Organisation et gestion"),
(3520, 0, 0,  35, 0, 255, "MTACP", "Méthodologie action et conduite projets"),
(3521, 0, 0,  35, 0, 255, "CMNLF", "Communic profess secret langue française"),
(3522, 0, 0,  35, 0, 255, "CMNLE", "Communic profess secret langues étrangères"),
(3523, 0, 0,  35, 0, 255, "O-GAI", "Organisation gest. activ. nationale internationale"),
(3524, 0, 0,  35, 0, 255, "ATPRO", "Actions professionnelles"),
(3525, 0, 0,  35, 0, 255, "AIVPR", "Aide à la vie professionnelle"),
(3526, 0, 0,  35, 0, 255, "RATTR", "Rattrapage (enseignement professionnel)"),
(3599, 0, 0,  35, 0, 255, "BRTSD", "Bureautique et secrétariat divers"),

-- Droit et législation

(3601, 0, 0,  36, 0, 255, "ITDRE", "Introduction au droit de l'entreprise"),
(3602, 0, 0,  36, 0, 255, "DR-VG", "Droit - vie et gestion des entreprises"),
(3603, 0, 0,  36, 0, 255, "LGSET", "Législation et sécurité du travail"),
(3604, 0, 0,  36, 0, 255, "E-GDR", "Économie - gestion et droit"),
(3605, 0, 0,  36, 0, 255, "DR-LS", "Droit - législation sociale - organisation du travail"),
(3606, 0, 0,  36, 0, 255, "DR-TR", "Droit du travail"),
(3607, 0, 0,  36, 0, 255, "LDTSS", "Législation - drt travail santé securité-travail"),
(3608, 0, 0,  36, 0, 255, "DR-TP", "Droit en travaux publics"),
(3609, 0, 0,  36, 0, 255, "LEGIS", "Législation"),
(3610, 0, 0,  36, 0, 255, "LGSPA", "Législation - sécurité - prévention accident"),
(3611, 0, 0,  36, 0, 255, "DR-TL", "Droit travail - législation sociale - org. de l'entreprise"),
(3612, 0, 0,  36, 0, 255, "RJCTC", "Relations juridiques crédit travail contentieux"),
(3613, 0, 0,  36, 0, 255, "AECJS", "Actualité économique juridique et sociale"),
(3614, 0, 0,  36, 0, 255, "G-ELT", "Gestion entreprises - législation travail"),
(3615, 0, 0,  36, 0, 255, "LGRGS", "Législation - règlementation - sécurité"),
(3616, 0, 0,  36, 0, 255, "DR-SF", "Droit des sociétés - droit fiscal"),
(3617, 0, 0,  36, 0, 255, "PGXDR", "Principes généraux du droit"),
(3618, 0, 0,  36, 0, 255, "LGDEO", "Législation déontologie"),
(3619, 0, 0,  36, 0, 255, "LGTRA", "Législation du travail"),
(3620, 0, 0,  36, 0, 255, "DROIT", "Droit"),
(3621, 0, 0,  36, 0, 255, "I-JUR", "Initiation juridique"),
(3622, 0, 0,  36, 0, 255, "DR-FI", "Droit fiscal"),
(3623, 0, 0,  36, 0, 255, "DR-LG", "Droit législatif"),
(3624, 0, 0,  36, 0, 255, "DR-SO", "Droit social"),
(3625, 0, 0,  36, 0, 255, "I-DCI", "Initiation au droit civil"),
(3626, 0, 0,  36, 0, 255, "I-DCO", "Initiation au droit commercial"),
(3627, 0, 0,  36, 0, 255, "E-GLG", "Économie gestion législation"),
(3628, 0, 0,  36, 0, 255, "DR-CC", "Droit civil et commercial"),
(3629, 0, 0,  36, 0, 255, "DR-AP", "Droit appliqué"),
(3630, 0, 0,  36, 0, 255, "LGECO", "Législation et économie"),
(3631, 0, 0,  36, 0, 255, "LGOST", "Législation et org scient du travail"),
(3632, 0, 0,  36, 0, 255, "ATSIN", "Action sociale et institutions"),
(3633, 0, 0,  36, 0, 255, "ASPPS", "Aspects psychosociaux et juridiques"),
(3634, 0, 0,  36, 0, 255, "I-EJU", "Initiation économique et juridique"),
(3635, 0, 0,  36, 0, 255, "DIMJE", "Dimension juridico-économique"),
(3636, 0, 0,  36, 0, 255, "GREGE", "Gr (ent-gest - eco gen - e ent - droit social)"),
(3637, 0, 0,  36, 0, 255, "LGEGE", "Législation - économie - gestion entreprise"),
(3638, 0, 0,  36, 0, 255, "LGTRS", "Législation du travail et sécurité"),
(3639, 0, 0,  36, 0, 255, "DR-DA", "Droit général et droit des assurances"),
(3640, 0, 0,  36, 0, 255, "RGLTT", "Règlement et legis transports tourisme"),
(3641, 0, 0,  36, 0, 255, "DR-CI", "Droit civil"),
(3642, 0, 0,  36, 0, 255, "DR-CO", "Droit commercial"),
(3643, 0, 0,  36, 0, 255, "SMSBU", "Sciences médico-sociales et bureautique"),
(3644, 0, 0,  36, 0, 255, "DRGIM", "Droit général de l'immobilier"),
(3645, 0, 0,  36, 0, 255, "DGSMQ", "Droit - gestion et mercatique appliquée"),
(3646, 0, 0,  36, 0, 255, "DRTPR", "Droit professionnel"),
(3647, 0, 0,  36, 0, 255, "DRSOC", "Droit des sociétés"),
(3648, 0, 0,  36, 0, 255, "VEJEC", "Vie eco.jurid. de l'entrep. Commercialisation"),
(3649, 0, 0,  36, 0, 255, "CASVQ", "Cadre pol jur act soc vie quotidienne"),
(3650, 0, 0,  36, 0, 255, "INTDT", "Introduction au droit"),
(3651, 0, 0,  36, 0, 255, "INRES", "Institutions et réseaux"),
(3652, 0, 0,  36, 0, 255, "EEJMA", "Environ.eco.jur.& manager.de l'assurance"),
(3653, 0, 0,  36, 0, 255, "DG-DN", "Droit général et droit notarial"),
(3654, 0, 0,  36, 0, 255, "T-NOT", "Techniques du notariat"),
(3655, 0, 0,  36, 0, 255, "APA-N", "Activités prof. appliquées (notariat)"),
(3656, 0, 0,  36, 0, 255, "OIRAE", "Organisat.indust.&règlement.aéronautique"),
(3657, 0, 0,  36, 0, 255, "DGEMC", "Droit et grands enjeux du monde contemporain"),
(3659, 0, 0,  36, 0, 255, "ENVEJ", "Environnement économique et juridique"),
(3660, 0, 0,  36, 0, 255, "COJAT", "Cadre organisationnel juridique activité touristique"),
(3661, 0, 0,  36, 0, 255, "DR-VD", "Droit et veille juridique"),
(3662, 0, 0,  36, 0, 255, "ETUOS", "Environnement de travail : outil stratégique"),
(3663, 0, 0,  36, 0, 255, "EVENP", "Évolution de l'environnement professionnel"),
(3664, 0, 0,  36, 0, 255, "DRECO", "Document. règlement. expert. cosmetovig."),
(3665, 0, 0,  36, 0, 255, "EEJME", "Environnement économ., juridique & manager. édition"),
(3666, 0, 0,  36, 0, 255, "EEJOB", "Environnement économ., juridique & organis. activité bancaire"),
(3667, 0, 0,  36, 0, 255, "ENVPR", "Environnement professionnel"),
(3699, 0, 0,  36, 0, 255, "DR-LD", "Droit et législation divers"),

-- Informatique de gestion

(3701, 0, 0,  37, 0, 255, "MA-GI", "Maths appliquées - outils gestion - informatique"),
(3702, 0, 0,  37, 0, 255, "APINF", "Applications informatiques"),
(3703, 0, 0,  37, 0, 255, "TTDON", "Traitement des données"),
(3704, 0, 0,  37, 0, 255, "ECOSI", "Enseignement commun (si)"),
(3705, 0, 0,  37, 0, 255, "TECIF", "Technologies informatiques"),
(3706, 0, 0,  37, 0, 255, "G-INF", "Gestion et informatique"),
(3707, 0, 0,  37, 0, 255, "STT"  , "Sciences et technologies tertiaires"),
(3708, 0, 0,  37, 0, 255, "NEGIF", "Négociations informatiques"),
(3709, 0, 0,  37, 0, 255, "ALGLG", "Algorithme et langages"),
(3710, 0, 0,  37, 0, 255, "TXAIN", "Travaux d'application d'informat."),
(3711, 0, 0,  37, 0, 255, "G-AMG", "Gestion et application math à la gestion"),
(3712, 0, 0,  37, 0, 255, "IFOSI", "Informatique organisat syst information"),
(3713, 0, 0,  37, 0, 255, "ANOIF", "Analyse organisation - informatisation"),
(3714, 0, 0,  37, 0, 255, "IFAPG", "Informatique appliquée à la gestion"),
(3715, 0, 0,  37, 0, 255, "ITAGM", "Informat telemat appli gest mercatique"),
(3716, 0, 0,  37, 0, 255, "APROF", "Approfondissements"),
(3717, 0, 0,  37, 0, 255, "OU-GI", "Outils de gestion et informatique appli"),
(3718, 0, 0,  37, 0, 255, "IFGES", "Informatique et gestion"),
(3719, 0, 0,  37, 0, 255, "IUMLI", "Init utilis mater - logic informatique de l'ets"),
(3720, 0, 0,  37, 0, 255, "AMSIQ", "Architecture matérielle systèmes informatiques"),
(3721, 0, 0,  37, 0, 255, "ALSIQ", "Architecture logicielle systèmes informatiques"),
(3722, 0, 0,  37, 0, 255, "DAIGL", "Dvlpt applications informatiques génie logiciel"),
(3723, 0, 0,  37, 0, 255, "ACPIG", "Actions professionnelles (informatique gestion)"),
(3724, 0, 0,  37, 0, 255, "IFGCM", "Informatique de gestion et communication"),
(3725, 0, 0,  37, 0, 255, "CEIPE", "Connaissance de l'entreprise init. pratique informatique"),
(3726, 0, 0,  37, 0, 255, "IFCOM", "Informatique commerciale"),
(3727, 0, 0,  37, 0, 255, "GSYSI", "Gestion du système d'information"),
(3728, 0, 0,  37, 0, 255, "ALGOA", "Algorithmique appliquée"),
(3729, 0, 0,  37, 0, 255, "AEMJI", "An.eco.manager.jurid. services informatiques"),
(3730, 0, 0,  37, 0, 255, "MTINF", "Méthodes et techniques informatiques"),
(3731, 0, 0,  37, 0, 255, "ISCNU", "Informatique et sciences du numérique"),
(3732, 0, 0,  37, 0, 255, "SIGET", "Systèmes d'information de gestion"),
(3733, 0, 0,  37, 0, 255, "SYSIG", "Système d'information de gestion"),
(3734, 0, 0,  37, 0, 255, "SISR" , "Solutions d’infrastructure, systèmes et réseaux"),
(3735, 0, 0,  37, 0, 255, "SLAM" , "Solutions logicielles et applications métiers"),
(3736, 0, 0,  37, 0, 255, "PRPEN", "Projets personnalisés encadrés"),
(3799, 0, 0,  37, 0, 255, "IFGSD", "Informatique de gestion divers"),

-- Économie

(3801, 0, 0,  38, 0, 255, "E-TRU", "Économie de la construction"),
(3802, 0, 0,  38, 0, 255, "DOMEC", "Domaine économique"),
(3803, 0, 0,  38, 0, 255, "E-GCG", "Économie et gestion/conjoint"),
(3804, 0, 0,  38, 0, 255, "E-OGS", "Économie et gestion"),
(3805, 0, 0,  38, 0, 255, "E-TKG", "Économie et techniques de gestion"),
(3806, 0, 0,  38, 0, 255, "E-OGN", "Économie générale"),
(3807, 0, 0,  38, 0, 255, "E-VIE", "Économie - vie des entreprises"),
(3808, 0, 0,  38, 0, 255, "E-ONO", "Économie"),
(3809, 0, 0,  38, 0, 255, "PBECO", "Problèmes économiques"),
(3810, 0, 0,  38, 0, 255, "E-DRT", "Économie et droit"),
(3811, 0, 0,  38, 0, 255, "EVEJU", "Environnement économique et juridique"),
(3812, 0, 0,  38, 0, 255, "CFOEC", "Complément de formation économique"),
(3813, 0, 0,  38, 0, 255, "E-GEE", "Économie générale et eco d'entreprise"),
(3814, 0, 0,  38, 0, 255, "E-EED", "Économie générale - eco entreprise droit"),
(3815, 0, 0,  38, 0, 255, "APRMT", "Approfondissement méthodologique"),
(3816, 0, 0,  38, 0, 255, "HIECO", "Histoire économique"),
(3817, 0, 0,  38, 0, 255, "ANMPE", "Analyse monétaire politique économique"),
(3818, 0, 0,  38, 0, 255, "ODOEC", "Option à dominante économique"),
(3819, 0, 0,  38, 0, 255, "E-TDR", "Économie générale et touristique-droit"),
(3820, 0, 0,  38, 0, 255, "ECEND", "Économie d'entreprise et droit"),
(3821, 0, 0,  38, 0, 255, "ETECO", "Études techniques et économiques"),
(3822, 0, 0,  38, 0, 255, "ENVEC", "Environnement économique"),
(3823, 0, 0,  38, 0, 255, "PO-EG", "Projet d'ouvrage (économie gestion)"),
(3824, 0, 0,  38, 0, 255, "ECDBQ", "Économie et droit bancaire"),
(3825, 0, 0,  38, 0, 255, "DEDPI", "Dimension économique des projet industriel"),
(3826, 0, 0,  38, 0, 255, "EDTOU", "Économie et droit appliqués au tourisme"),
(3827, 0, 0,  38, 0, 255, "EGOTR", "Économie gestion organisation du travail"),
(3828, 0, 0,  38, 0, 255, "EEMNO", "Environ. eco et managerial du notariat"),
(3829, 0, 0,  38, 0, 255, "ECONS", "Économie - consommation"),
(3830, 0, 0,  38, 0, 255, "PFEG" , "Principes fondament. Économie & gestion"),
(3831, 0, 0,  38, 0, 255, "ECOOR", "Économie et organisation"),
(3832, 0, 0,  38, 0, 255, "CEJUM", "Culture économique, juridique et manageriale"),
(3833, 0, 0,  38, 0, 255, "ECOGE", "Économie-gestion"),
(3834, 0, 0,  38, 0, 255, "EC-DR", "Économie-droit"),
(3899, 0, 0,  38, 0, 255, "E-ODI", "Économie divers"),

-- Comptabilité - finances

(3901, 0, 0,  39, 0, 255, "G-FDT", "Gestion financière des travaux"),
(3902, 0, 0,  39, 0, 255, "G-FIN", "Gestion financière"),
(3903, 0, 0,  39, 0, 255, "G-CAB", "Gestion - comptabilité analytique-budgétaire"),
(3904, 0, 0,  39, 0, 255, "MOCTB", "Module élémentaire comptabilité"),
(3905, 0, 0,  39, 0, 255, "MT-QU", "Méthodes quantitatives"),
(3906, 0, 0,  39, 0, 255, "CPT-G", "Comptabilité et gestion"),
(3907, 0, 0,  39, 0, 255, "FIETB", "Financement des entr et techn bancaires"),
(3908, 0, 0,  39, 0, 255, "CPTTA", "Comptabilité"),
(3909, 0, 0,  39, 0, 255, "TXSYC", "Travaux de synthèse comptabilité"),
(3910, 0, 0,  39, 0, 255, "TXSYN", "Travaux de synthèse"),
(3911, 0, 0,  39, 0, 255, "ETCAS", "Étude de cas"),
(3912, 0, 0,  39, 0, 255, "TPSYN", "Travaux pratiques de synthèse"),
(3913, 0, 0,  39, 0, 255, "T-IMM", "Technique de l'immobilier"),
(3914, 0, 0,  39, 0, 255, "CPT-R", "Comptabilité approfondie et révision"),
(3915, 0, 0,  39, 0, 255, "G-CFS", "Gestion comptable fiscale et sociale"),
(3916, 0, 0,  39, 0, 255, "GFPAC", "Gest financ prev analyses contrôle gestion"),
(3917, 0, 0,  39, 0, 255, "ACTPS", "Activités professionnelles de synthèse"),
(3918, 0, 0,  39, 0, 255, "MANCI", "Mise à niveau (comptabilité finances informatique)"),
(3919, 0, 0,  39, 0, 255, "TECBQ", "Techniques bancaires"),
(3920, 0, 0,  39, 0, 255, "ABQAP", "Actions bancaires appliquées"),
(3921, 0, 0,  39, 0, 255, "OGACO", "Organisation et gestion administrative et comptable"),
(3922, 0, 0,  39, 0, 255, "CPTFI", "Comptabilité et finance d'entreprises"),
(3923, 0, 0,  39, 0, 255, "FINET", "Finance d'entreprise"),
(3924, 0, 0,  39, 0, 255, "INTCT", "Introduction a la comptabilité"),
(3925, 0, 0,  39, 0, 255, "CTAPP", "Comptabilité approfondie"),
(3926, 0, 0,  39, 0, 255, "TGADF", "Techniq. gestion administr. & financière"),
(3927, 0, 0,  39, 0, 255, "GFACT", "Gestion et financement des actifs"),
(3928, 0, 0,  39, 0, 255, "PEREN", "Pérennisation de l'entreprise"),
(3929, 0, 0,  39, 0, 255, "GRISQ", "Gestion du risque"),
(3930, 0, 0,  39, 0, 255, "P1P2" , "P1 plus P2"),
(3931, 0, 0,  39, 0, 255, "P3P4" , "P3 plus P4"),
(3932, 0, 0,  39, 0, 255, "P5P6" , "P5 plus P6"),
(3933, 0, 0,  39, 0, 255, "P7-"  , "P7"),
(3934, 0, 0,  39, 0, 255, "ATEPR", "Ateliers professionnels"),
(3935, 0, 0,  39, 0, 255, "MOPAP", "Module optionnel d'approfondissement"),
(3936, 0, 0,  39, 0, 255, "AREID", "Accès ressources informatiques & documentaires"),
(3999, 0, 0,  39, 0, 255, "CPT-F", "Comptabilité - finances divers"),

-- Hôtellerie - tourisme

(4001, 0, 0,  40, 0, 255, "GGTIC", "Geo gene - touris et itinéraires commerc"),
(4002, 0, 0,  40, 0, 255, "CUISI", "Cuisine"),
(4003, 0, 0,  40, 0, 255, "CUITP", "Cuisine (technologie - travaux pratiques)"),
(4004, 0, 0,  40, 0, 255, "MQTOU", "Mercatique du tourisme"),
(4005, 0, 0,  40, 0, 255, "T-CUL", "Techniques culinaires"),
(4006, 0, 0,  40, 0, 255, "ATTOG", "Action touristique générale"),
(4007, 0, 0,  40, 0, 255, "ATTAA", "Action touristique approfondie appliquée"),
(4008, 0, 0,  40, 0, 255, "RESTP", "Restaurant(technologie - tp - oenologie)"),
(4009, 0, 0,  40, 0, 255, "ATTOA", "Action touristique approfondie"),
(4010, 0, 0,  40, 0, 255, "ATTGA", "Action touristique générale appliquée"),
(4011, 0, 0,  40, 0, 255, "DCTRP", "Document de transport"),
(4012, 0, 0,  40, 0, 255, "O-TOU", "Organisation du tourisme"),
(4013, 0, 0,  40, 0, 255, "E-TOU", "Économie touristique"),
(4015, 0, 0,  40, 0, 255, "BTARI", "Billetterie et tarification"),
(4016, 0, 0,  40, 0, 255, "TPAGE", "Travaux pratiques d'agence"),
(4017, 0, 0,  40, 0, 255, "FRETF", "Fret et trafic"),
(4018, 0, 0,  40, 0, 255, "DOCUM", "Documentation"),
(4019, 0, 0,  40, 0, 255, "RESTO", "Restaurant"),
(4020, 0, 0,  40, 0, 255, "O-PCL", "Organisation et production culinaire"),
(4021, 0, 0,  40, 0, 255, "T-AHR", "Techniques administratives hôtelières restaur"),
(4022, 0, 0,  40, 0, 255, "ACPRO", "Activités professionnelles"),
(4023, 0, 0,  40, 0, 255, "HBGMT", "Hébergement"),
(4024, 0, 0,  40, 0, 255, "SAHRE", "Sciences app à l'hôtellerie et à la restauration"),
(4025, 0, 0,  40, 0, 255, "G-HOT", "Gestion hôtelière"),
(4026, 0, 0,  40, 0, 255, "HOTTP", "Hôtel (technologie - travaux pratiques)"),
(4027, 0, 0,  40, 0, 255, "T-HOT", "Techniques hôtelières"),
(4028, 0, 0,  40, 0, 255, "IHOTM", "Ingénierie hôtel et maintenance"),
(4029, 0, 0,  40, 0, 255, "CAEHT", "Cond animat entreprise hôtelière"),
(4030, 0, 0,  40, 0, 255, "TECCU", "Technologie culinaire"),
(4031, 0, 0,  40, 0, 255, "PR-CG", "Pratique de la conduite des groupes"),
(4032, 0, 0,  40, 0, 255, "PUBED", "Publicité édition"),
(4033, 0, 0,  40, 0, 255, "O-STT", "Organisation de la station"),
(4034, 0, 0,  40, 0, 255, "T-HEB", "Technique de l'hébergement"),
(4035, 0, 0,  40, 0, 255, "O-SEJ", "Organisation des séjours"),
(4036, 0, 0,  40, 0, 255, "E-GTL", "Économie gest entre et org tour loisir"),
(4037, 0, 0,  40, 0, 255, "RSOHU", "Relations sociales et humaines"),
(4038, 0, 0,  40, 0, 255, "T-HCP", "Techniques accueil heberg communication prof"),
(4039, 0, 0,  40, 0, 255, "ACMPR", "Activités et manifestations professionnelles"),
(4040, 0, 0,  40, 0, 255, "SCTEC", "Sciences appliquées et technologie"),
(4041, 0, 0,  40, 0, 255, "PCTRG", "Patrimoine culturel et tourist régional"),
(4042, 0, 0,  40, 0, 255, "TOURQ", "Tourismatique"),
(4043, 0, 0,  40, 0, 255, "DVTOU", "Développement touristique"),
(4044, 0, 0,  40, 0, 255, "EVTOU", "Environnement touristique"),
(4045, 0, 0,  40, 0, 255, "NGTOU", "Négociation touristique"),
(4046, 0, 0,  40, 0, 255, "CCTOU", "Concep commerc produits touristiques syst infq"),
(4047, 0, 0,  40, 0, 255, "AAPRO", "Accueil animation professionnels"),
(4048, 0, 0,  40, 0, 255, "ACSPE", "Accueil de touristes à besoins spécifiques"),
(4049, 0, 0,  40, 0, 255, "OTRLV", "Organisation et technique de la réception"),
(4050, 0, 0,  40, 0, 255, "ASPAT", "Analyse spatiale appliquée au tourisme"),
(4051, 0, 0,  40, 0, 255, "MGAOT", "Mercatique gestion appliquée organisation touristique"),
(4052, 0, 0,  40, 0, 255, "TCTOU", "Techniques touristiques"),
(4053, 0, 0,  40, 0, 255, "APTOU", "Action professionnelle touristique"),
(4054, 0, 0,  40, 0, 255, "MPTOU", "Mercatique et productions touristiques"),
(4055, 0, 0,  40, 0, 255, "GTMED", "Gestion de projet touristique multimédia"),
(4056, 0, 0,  40, 0, 255, "OTETA", "Organisation et technique des étages"),
(4057, 0, 0,  40, 0, 255, "MERTC", "Mercatique et techniques de commercialisation"),
(4059, 0, 0,  40, 0, 255, "TTERR", "Tourisme et territoire"),
(4060, 0, 0,  40, 0, 255, "MCPT" , "Mercatique conception prestation touristique"),
(4061, 0, 0,  40, 0, 255, "ECGEH", "Économie et gestion hôteliere"),
(4062, 0, 0,  40, 0, 255, "PRSTC", "Projet sthr (sciences & technologies culinaires)"),
(4063, 0, 0,  40, 0, 255, "PRSTS", "Projet sthr (sciences & technologies des services)"),
(4064, 0, 0,  40, 0, 255, "SCTES", "Sciences et technologies des services"),
(4065, 0, 0,  40, 0, 255, "STECU", "Sciences et technologies culinaires"),
(4066, 0, 0,  40, 0, 255, "ESALE", "Enseignement scientifique alimentation-environnement"),
(4099, 0, 0,  40, 0, 255, "HOTDI", "Hôtellerie tourisme divers"),

-- Communication

(4101, 0, 0,  41, 0, 255, "T-INF", "Techniques d'information"),
(4102, 0, 0,  41, 0, 255, "T-ANG", "Techniques d'animation de groupes"),
(4103, 0, 0,  41, 0, 255, "DEXPI", "Discipline d'expression et d'information"),
(4104, 0, 0,  41, 0, 255, "T-COA", "Technique de communication - d'animation"),
(4105, 0, 0,  41, 0, 255, "CMNPO", "Communication professio orale et écrite"),
(4106, 0, 0,  41, 0, 255, "EX-CM", "Expression communication"),
(4107, 0, 0,  41, 0, 255, "CMNCA", "Communication"),
(4108, 0, 0,  41, 0, 255, "MT-TG", "Méthodes et techniques graphiques communication"),
(4109, 0, 0,  41, 0, 255, "EDTKC", "Edition et techniques de communication"),
(4110, 0, 0,  41, 0, 255, "FR-TC", "Français et techniques de communication"),
(4111, 0, 0,  41, 0, 255, "CMNCI", "Communication et civilisation"),
(4112, 0, 0,  41, 0, 255, "OU-TC", "Outils et techniques de communication"),
(4113, 0, 0,  41, 0, 255, "DIMPF", "Dimension professionnelle"),
(4114, 0, 0,  41, 0, 255, "DIMPS", "Dimension psychologique et sociologique"),
(4115, 0, 0,  41, 0, 255, "SHUTE", "Sciences humaines et techniques d'expression"),
(4116, 0, 0,  41, 0, 255, "AP-TI", "Atelier de pratique:techn info comm"),
(4117, 0, 0,  41, 0, 255, "CMNOR", "Communication et organisation"),
(4118, 0, 0,  41, 0, 255, "ATCOA", "Action et communication administratives"),
(4119, 0, 0,  41, 0, 255, "EVISP", "Expression visuelle et production"),
(4120, 0, 0,  41, 0, 255, "ERACO", "Études recherches appliquées à la communication"),
(4121, 0, 0,  41, 0, 255, "STCOE", "Stratégie de communication des entreprises"),
(4122, 0, 0,  41, 0, 255, "CTCOM", "Conception et technique de communication"),
(4123, 0, 0,  41, 0, 255, "CMGRH", "Communication gestion ressources humaines"),
(4124, 0, 0,  41, 0, 255, "TECIC", "Technologie informatique et de communication"),
(4125, 0, 0,  41, 0, 255, "TINFC", "Technologie information et communication"),
(4126, 0, 0,  41, 0, 255, "COTCO", "Communication techniques commerciales"),
(4127, 0, 0,  41, 0, 255, "TOIFA", "Techniques d'org techniq info formation animation"),
(4128, 0, 0,  41, 0, 255, "OUCOT", "Outils de la communication technique"),
(4129, 0, 0,  41, 0, 255, "COMTC", "Communication commerciale et technique"),
(4130, 0, 0,  41, 0, 255, "GCLCP", "Gestion clientèle communication profes"),
(4131, 0, 0,  41, 0, 255, "SEMEC", "Sémiologie espace et  communication"),
(4132, 0, 0,  41, 0, 255, "CP-LN", "Communication professionnelle en langue nationale"),
(4133, 0, 0,  41, 0, 255, "INFCO", "Information et communication"),
(4134, 0, 0,  41, 0, 255, "INFGE", "Information et gestion"),
(4135, 0, 0,  41, 0, 255, "COMAN", "Communication animation"),
(4136, 0, 0,  41, 0, 255, "TICOP", "Techniq.information & communication prof"),
(4137, 0, 0,  41, 0, 255, "COGRC", "Communication & gestion relation client"),
(4138, 0, 0,  41, 0, 255, "CMAIC", "Communication  management interculturels"),
(4139, 0, 0,  41, 0, 255, "INFOR", "Information"),
(4140, 0, 0,  41, 0, 255, "ANCOM", "Analyse et communication"),
(4141, 0, 0,  41, 0, 255, "PJCOM", "Projet de communication"),
(4142, 0, 0,  41, 0, 255, "CONSA", "Conseil et relation annonceur"),
(4143, 0, 0,  41, 0, 255, "VEILO", "Veille opérationnelle"),
(4144, 0, 0,  41, 0, 255, "APROD", "Atelier production"),
(4145, 0, 0,  41, 0, 255, "ANIMF", "Techniques d'animation et de formation"),
(4146, 0, 0,  41, 0, 255, "CPUBL", "Connaissances des publics"),
(4147, 0, 0,  41, 0, 255, "COMEO", "Communication écrite et orale"),
(4148, 0, 0,  41, 0, 255, "DESCV", "Design de communication visuelle"),
(4149, 0, 0,  41, 0, 255, "COMTK", "Communication technique"),
(4150, 0, 0,  41, 0, 255, "PRJCO", "Projet de communication"),
(4151, 0, 0,  41, 0, 255, "TPIII", "Travail partenariat instut.et interinsti"),
(4152, 0, 0,  41, 0, 255, "COPRO", "Communication professionnelle"),
(4153, 0, 0,  41, 0, 255, "DYPAR", "Implications ds dynamiques partenariales"),
(4154, 0, 0,  41, 0, 255, "GRCLI", "Gestion de la relation client"),
(4155, 0, 0,  41, 0, 255, "GINFT", "Gestion de l'information touristique"),
(4156, 0, 0,  41, 0, 255, "IMMED", "Information et multimedias"),
(4157, 0, 0,  41, 0, 255, "ITOUR", "Information et tourismatique"),
(4158, 0, 0,  41, 0, 255, "CCOMM", "Culture de la communication"),
(4159, 0, 0,  41, 0, 255, "MEMOC", "Méthodes et moyens de communication"),
(4160, 0, 0,  41, 0, 255, "PROCC", "Promotion et communication commerciale"),
(4161, 0, 0,  41, 0, 255, "TEFAP", "Technique de formation, d'animation de promotion"),
(4162, 0, 0,  41, 0, 255, "ERPED", "Étude & réalisation de projets d'édition"),
(4163, 0, 0,  41, 0, 255, "CTMAN", "Communication & techniques de management"),
(4164, 0, 0,  41, 0, 255, "CTECO", "Communication technique et commerciale"),
(4165, 0, 0,  41, 0, 255, "OAEXC", "Outils analyse expression et communication"),
(4166, 0, 0,  41, 0, 255, "RHCOM", "Ressources humaines et communication"),
(4199, 0, 0,  41, 0, 255, "CMNDV", "Communication divers"),

-- Assurances

(4201, 0, 0,  42, 0, 255, "TXASS", "Travaux d'assurance"),
(4202, 0, 0,  42, 0, 255, "BURAS", "Bureau d'assurance"),
(4203, 0, 0,  42, 0, 255, "DCASS", "Différentes catégories d'assurance"),
(4204, 0, 0,  42, 0, 255, "ASSMF", "Assurances maritimes fluviales aériennes"),
(4205, 0, 0,  42, 0, 255, "TXASY", "Travaux d'application et de synthèse"),
(4206, 0, 0,  42, 0, 255, "FONDA", "Fondamentaux de l'assurance"),
(4207, 0, 0,  42, 0, 255, "TASSU", "Technique d'assurance"),
(4208, 0, 0,  42, 0, 255, "AVPRO", "Aide à la vie professionnelle assurance"),
(4209, 0, 0,  42, 0, 255, "ATRSP", "Assurances transports"),
(4210, 0, 0,  42, 0, 255, "EOASS", "Économie et organisation de l'assurance"),
(4211, 0, 0,  42, 0, 255, "EJBCA", "Ens eco jur out bur tec comm comp adm"),
(4299, 0, 0,  42, 0, 255, "ASSUD", "Assurances divers"),

-- Gestion des entreprises

(4301, 0, 0,  43, 0, 255, "T-GES", "Techniques de gestion et informatique"),
(4302, 0, 0,  43, 0, 255, "DECPV", "Découverte pratique vie orga entreprise"),
(4303, 0, 0,  43, 0, 255, "INTEX", "Intervention extérieure sur entreprise"),
(4304, 0, 0,  43, 0, 255, "O-TRA", "Organisation du travail"),
(4305, 0, 0,  43, 0, 255, "G-ENT", "Gestion de l'entreprise"),
(4306, 0, 0,  43, 0, 255, "CNTGS", "Contrôle de gestion"),
(4307, 0, 0,  43, 0, 255, "E-OVE", "Économie et orga et vie de l'entreprise"),
(4308, 0, 0,  43, 0, 255, "O-GEN", "Organisation et gestion de l'entreprise"),
(4309, 0, 0,  43, 0, 255, "OU-MG", "Outils mathématiques de gestion"),
(4310, 0, 0,  43, 0, 255, "PGSEN", "Principe de gestion entreprises"),
(4311, 0, 0,  43, 0, 255, "O-PLN", "Organisation et planification"),
(4312, 0, 0,  43, 0, 255, "E-OEN", "Économie et organi de l'entreprise"),
(4313, 0, 0,  43, 0, 255, "ANADA", "Analyse administrative et appliquée"),
(4314, 0, 0,  43, 0, 255, "OU-GS", "Outils de gestion"),
(4315, 0, 0,  43, 0, 255, "VIENT", "Vie de l'entreprise"),
(4316, 0, 0,  43, 0, 255, "T-QTG", "Techniques quantitatives de gestion"),
(4317, 0, 0,  43, 0, 255, "G-LEG", "Gestion et législation"),
(4318, 0, 0,  43, 0, 255, "O-EEC", "Organisation exploitations entreprises chantiers"),
(4319, 0, 0,  43, 0, 255, "G-VDE", "Gestion et vie des entreprises"),
(4320, 0, 0,  43, 0, 255, "GESTN", "Gestion"),
(4321, 0, 0,  43, 0, 255, "N-GES", "Enseignement mise à niveau gestion"),
(4322, 0, 0,  43, 0, 255, "E-GSE", "Économie et gestion de l'entreprise"),
(4323, 0, 0,  43, 0, 255, "MT-AG", "Méthodes administratives et gestion"),
(4324, 0, 0,  43, 0, 255, "G-ADM", "Gestion des activités administratives"),
(4325, 0, 0,  43, 0, 255, "I-GSE", "Initiation à la gestion des entreprises"),
(4326, 0, 0,  43, 0, 255, "T-ADM", "Techniques administratives"),
(4327, 0, 0,  43, 0, 255, "ENTGS", "L'entreprise et sa gestion"),
(4328, 0, 0,  43, 0, 255, "E-ENT", "Économie d'entreprise"),
(4329, 0, 0,  43, 0, 255, "O-EGE", "Organisatio product : eco gest entreprise"),
(4330, 0, 0,  43, 0, 255, "E-EGS", "Économie d'entreprise et gestion"),
(4331, 0, 0,  43, 0, 255, "MA-GG", "Mathématiques générales appliquées gestion"),
(4332, 0, 0,  43, 0, 255, "OADGS", "Option à dominante gestion"),
(4333, 0, 0,  43, 0, 255, "E-ORO", "Économie et organisation d'une opération"),
(4334, 0, 0,  43, 0, 255, "MT-GP", "Méthodes d'administration et de gestion des PME PMI"),
(4335, 0, 0,  43, 0, 255, "TXSAP", "Travaux de synthèse et actions profess."),
(4336, 0, 0,  43, 0, 255, "GQUAL", "Gestion de la qualité (gest entreprises)"),
(4337, 0, 0,  43, 0, 255, "OGCOM", "Organisation gestion commerciales"),
(4338, 0, 0,  43, 0, 255, "GLMOM", "Gest legisl mercatiq outils mathem"),
(4339, 0, 0,  43, 0, 255, "GEOSI", "Gest entrepr org syst information"),
(4340, 0, 0,  43, 0, 255, "COGDF", "Communic org gest dossiers fonctionnels"),
(4341, 0, 0,  43, 0, 255, "GEXPL", "Gestion de l'exploitation"),
(4342, 0, 0,  43, 0, 255, "GT-RH", "Gestion et techniques des ressources humaines"),
(4343, 0, 0,  43, 0, 255, "MANOR", "Management des organisations"),
(4344, 0, 0,  43, 0, 255, "GTEAF", "Gestion techn. et econ. d'une affaire"),
(4345, 0, 0,  43, 0, 255, "MANAG", "Management"),
(4346, 0, 0,  43, 0, 255, "SIGES", "Système d'information et de gestion"),
(4347, 0, 0,  43, 0, 255, "MANGE", "Management et gestion de l'entreprise"),
(4348, 0, 0,  43, 0, 255, "AIDEC", "Aide a la décision"),
(4349, 0, 0,  43, 0, 255, "ORGAC", "Organisation de l'action"),
(4350, 0, 0,  43, 0, 255, "GTECO", "Gestion technique et économique"),
(4351, 0, 0,  43, 0, 255, "GVQSE", "Gest.vie quotidienne ds serv.ou entrepr."),
(4352, 0, 0,  43, 0, 255, "GDROI", "Gestion et droit"),
(4353, 0, 0,  43, 0, 255, "MENTR", "Management des entreprises"),
(4354, 0, 0,  43, 0, 255, "SCDG" , "Sciences de gestion"),
(4355, 0, 0,  43, 0, 255, "GESFI", "Gestion et finance"),
(4356, 0, 0,  43, 0, 255, "EGAAE", "Économie-gestion appliquée agroéquipement"),
(4357, 0, 0,  43, 0, 255, "GEDAC", "Gestion économique & développement de l'activité"),
(4358, 0, 0,  43, 0, 255, "ORMEO", "Organisation et mise en œuvre"),
(4359, 0, 0,  43, 0, 255, "MASCG", "Management et sciences de gestion"),
(4360, 0, 0,  43, 0, 255, "GESMG", "Gestion et management"),
(4399, 0, 0,  43, 0, 255, "G-DIV", "Gestion divers"),

-- Publicité

(4401, 0, 0,  44, 0, 255, "TXSAC", "Trav.prof.synth.et action.publici.appro."),
(4402, 0, 0,  44, 0, 255, "ETCPU", "Études commerciales et études publicitaires"),
(4403, 0, 0,  44, 0, 255, "SMCPU", "Stratégie et moyens de communication publicitaire"),
(4499, 0, 0,  44, 0, 255, "PUBDI", "Publicité divers"),

-- Métiers des arts appliqués (suite)

(4501, 0, 0,  45, 0, 255, "HUMOD", "Humanités modernes"),
(4502, 0, 0,  45, 0, 255, "SMAJU", "Stratégie marketing juridique"),
(4503, 0, 0,  45, 0, 255, "CPRTE", "Cultures et pratiques techniques"),
(4504, 0, 0,  45, 0, 255, "PPLME", "Pratiques plastiques et médiations"),
(4505, 0, 0,  45, 0, 255, "IPRRE", "Innovation, prospective et recherche"),
(4506, 0, 0,  45, 0, 255, "LEXRE", "Laboratoire expérimentation et recherche"),
(4507, 0, 0,  45, 0, 255, "MACPR", "Macro-projet"),
(4508, 0, 0,  45, 0, 255, "MREPR", "Mémoire de recherche professionnel"),
(4509, 0, 0,  45, 0, 255, "MELVE", "Mémoire en langue vivante etrangère"),
(4510, 0, 0,  45, 0, 255, "PRCRA", "Pratiques créatives et artistiques"),
(4511, 0, 0,  45, 0, 255, "RDPRO", "Recherche et démarche de projet"),
(4512, 0, 0,  45, 0, 255, "DESTC", "Design, sciences & technologies contemporaines"),
(4513, 0, 0,  45, 0, 255, "INEXP", "Investigation, exploitation, projection"),
(4514, 0, 0,  45, 0, 255, "MEDIA", "Médiation"),

-- Métiers d`art (suite)

(4601, 0, 0,  46, 0, 255, "CULTA", "Cultures artistiques"),
(4602, 0, 0,  46, 0, 255, "TEMEO", "Technique et mise en œuvre"),
(4603, 0, 0,  46, 0, 255, "CAUDA", "Culture audiovisuelle et artistique"),

-- Langue technique

(5001, 0, 0,  50, 0, 255, "AGINF", "Langue anglaise appliquée à l'informatique"),
(5002, 0, 0,  50, 0, 255, "AGTEC", "Anglais technique"),
(5003, 0, 0,  50, 0, 255, "AGCOM", "Anglais commercial et technique"),
(5004, 0, 0,  50, 0, 255, "ANGL" , "Anglais"),
(5005, 0, 0,  50, 0, 255, "LGMOD", "Langue vivante module"),
(5006, 0, 0,  50, 0, 255, "COMLV", "Communication en lv étrangère"),
(5007, 0, 0,  50, 0, 255, "ANGAF", "Anglais appliqué aux affaires"),
(5008, 0, 0,  50, 0, 255, "NVLVE", "Négociation vente en lve"),
(5009, 0, 0,  50, 0, 255, "LILVE", "Littérature étrangère en langue étrangère"),
(5010, 0, 0,  50, 0, 255, "DAALV", "Design et arts appliqués en lv1"),
(5011, 0, 0,  50, 0, 255, "ETLV1", "Enseignement technologique en lv1"),
(5098, 0, 0,  50, 0, 255, "AELVE", "Accompagn.éducatif - pratique orale lve"),
(5099, 0, 0,  50, 0, 255, "LGDIV", "Langue technique diverse"),

-- Activités hippiques

(6001, 0, 0,  60, 0, 255, "6001A", "Equitation"),
(6002, 0, 0,  60, 0, 255, "6002A", "Hippologie-équitation"),
(6003, 0, 0,  60, 0, 255, "6003A", "Maréchalerie"),
(6004, 0, 0,  60, 0, 255, "6004A", "Zootechnie hippologie"),

-- Commercialisation

(6101, 0, 0,  61, 0, 255, "6101A", "Techniques commerciales"),
(6102, 0, 0,  61, 0, 255, "6102A", "Techniques économiques"),

-- Élevage et soins aux animaux

(6201, 0, 0,  62, 0, 255, "6201A", "Techniques animalières"),

-- Environnement - aménagement de l`espace

(6301, 0, 0,  63, 0, 255, "6301A", "Économie soc. familiale"),
(6302, 0, 0,  63, 0, 255, "6302A", "Aménagement espaces naturels"),
(6303, 0, 0,  63, 0, 255, "6303A", "Techniques forestières"),
(6304, 0, 0,  63, 0, 255, "6304A", "Aménagement paysager"),

-- Équipements pour l`agriculture

(6401, 0, 0,  64, 0, 255, "6401A", "Machinisme"),
(6402, 0, 0,  64, 0, 255, "6402A", "Sc. et techno équipements"),
(6403, 0, 0,  64, 0, 255, "6403A", "Agro-équipements"),
(6404, 0, 0,  64, 0, 255, "6404A", "Equipements agroalimentaires"),
(6405, 0, 0,  64, 0, 255, "6405A", "Equipements hydrauliques"),

-- Disciplines professionnelles de l`enseignement agricole

(6510, 0, 0,  65, 0, 255, "ETP-A", "Enseignement technologique et professionnel"),
(6520, 0, 0,  65, 0, 255, "SCTCA", "Sciences et techniques"),
(6530, 0, 0,  65, 0, 255, "PPROA", "Pratiques professionnelles"),
(6540, 0, 0,  65, 0, 255, "PROPA", "Projet professionnel"),
(6550, 0, 0,  65, 0, 255, "FRDOA", "Français Documentation"),
(6551, 0, 0,  65, 0, 255, "6951A", "Français Philosophie"),
(6552, 0, 0,  65, 0, 255, "MAINA", "Mathématiques Informatique"),

-- Production

(6601, 0, 0,  66, 0, 255, "6601A", "Agronomie"),
(6602, 0, 0,  66, 0, 255, "6602A", "Sci. techn. aquacoles"),
(6603, 0, 0,  66, 0, 255, "6603A", "Sci. techn. horticoles"),
(6604, 0, 0,  66, 0, 255, "6604A", "Œnologie"),
(6605, 0, 0,  66, 0, 255, "6605A", "Viticulture"),
(6606, 0, 0,  66, 0, 255, "6606A", "Viticulture - Œnologie"),
(6607, 0, 0,  66, 0, 255, "6607A", "Zootechnie"),

-- Services

-- Transformation

(6801, 0, 0,  68, 0, 255, "6801A", "Génie des procédés IAA"),
(6802, 0, 0,  68, 0, 255, "6802A", "Génie alimentaire"),
(6803, 0, 0,  68, 0, 255, "6803A", "Génie industriel"),

-- Disciplines générales enseignement agricole

(6901, 0, 0,  69, 0, 255, "6901A", "Act. pluridisciplinaires"),
(6902, 0, 0,  69, 0, 255, "6902A", "Aide indiv français"),
(6903, 0, 0,  69, 0, 255, "6903A", "Aide indiv maths"),
(6904, 0, 0,  69, 0, 255, "6904A", "Arts"),
(6905, 0, 0,  69, 0, 255, "6905A", "Biochimie"),
(6906, 0, 0,  69, 0, 255, "6906A", "Biochimie - microbiologie"),
(6907, 0, 0,  69, 0, 255, "6907A", "Biologie"),
(6908, 0, 0,  69, 0, 255, "6908A", "Biologie animale"),
(6909, 0, 0,  69, 0, 255, "6909A", "Biologie végétale"),
(6910, 0, 0,  69, 0, 255, "6910A", "Biologie - Ecologie"),
(6911, 0, 0,  69, 0, 255, "6911A", "Chimie"),
(6912, 0, 0,  69, 0, 255, "6912A", "Compta-bureau"),
(6913, 0, 0,  69, 0, 255, "6913A", "Documentation"),
(6914, 0, 0,  69, 0, 255, "6914A", "E.P.S."),
(6915, 0, 0,  69, 0, 255, "6915A", "Ecologie"),
(6916, 0, 0,  69, 0, 255, "6916A", "Économie d'entreprise"),
(6917, 0, 0,  69, 0, 255, "6917A", "Économie - droit"),
(6918, 0, 0,  69, 0, 255, "6918A", "Education civique - juridique - sociale"),
(6919, 0, 0,  69, 0, 255, "6919A", "Education socioculturelle"),
(6920, 0, 0,  69, 0, 255, "6920A", "Français"),
(6921, 0, 0,  69, 0, 255, "6921A", "Géographie"),
(6922, 0, 0,  69, 0, 255, "6922A", "Gestion"),
(6923, 0, 0,  69, 0, 255, "6923A", "Grec"),
(6924, 0, 0,  69, 0, 255, "6924A", "Heures de vie de classe"),
(6925, 0, 0,  69, 0, 255, "6925A", "Histoire-Géo. - Education civique"),
(6926, 0, 0,  69, 0, 255, "6926A", "Histoire-Géographie"),
(6927, 0, 0,  69, 0, 255, "6927A", "Hygiène - Prévention - Secourisme"),
(6928, 0, 0,  69, 0, 255, "6928A", "Informatique"),
(6929, 0, 0,  69, 0, 255, "6929A", "Latin"),
(6930, 0, 0,  69, 0, 255, "6930A", "Mathématiques"),
(6931, 0, 0,  69, 0, 255, "6931A", "Mercatique"),
(6932, 0, 0,  69, 0, 255, "6932A", "Microbiologie"),
(6933, 0, 0,  69, 0, 255, "6933A", "Philosophie"),
(6934, 0, 0,  69, 0, 255, "6934A", "Physique"),
(6935, 0, 0,  69, 0, 255, "6935A", "Physique appliquée"),
(6936, 0, 0,  69, 0, 255, "6936A", "Physique-Chimie"),
(6937, 0, 0,  69, 0, 255, "6937A", "Pratiques prof."),
(6938, 0, 0,  69, 0, 255, "6938A", "Pratiques soc. et cultur."),
(6939, 0, 0,  69, 0, 255, "6939A", "Prévention santé environnement"),
(6940, 0, 0,  69, 0, 255, "6940A", "Sci. éco- soc.- gestion"),
(6941, 0, 0,  69, 0, 255, "6941A", "Sciences éco et sociales"),
(6942, 0, 0,  69, 0, 255, "6942A", "Sciences éco. et humaines"),
(6943, 0, 0,  69, 0, 255, "6943A", "Sciences économiques"),
(6944, 0, 0,  69, 0, 255, "6944A", "Secrét. bureautique"),
(6945, 0, 0,  69, 0, 255, "6945A", "Statistiques"),
(6946, 0, 0,  69, 0, 255, "6946A", "Sciences de la vie et de la terre"),
(6947, 0, 0,  69, 0, 255, "6947A", "Tech. de communication"),
(6948, 0, 0,  69, 0, 255, "6948A", "Tech. de documentation"),
(6949, 0, 0,  69, 0, 255, "6949A", "TIM"),

-- Enseignement religieux

(9010, 0, 0,  90, 0, 255, "CATHO", "Enseignement religieux catholique"),
(9020, 0, 0,  90, 0, 255, "ISRLT", "Enseignement religieux israélite"),
(9030, 0, 0,  90, 0, 255, "PROTT", "Enseignement religieux protestant"),
(9031, 0, 0,  90, 0, 255, "LUTHR", "Enseignement religieux luthérien"),
(9032, 0, 0,  90, 0, 255, "CALVN", "Enseignement religieux calviniste"),
(9099, 0, 0,  90, 0, 255, "RLGDI", "Enseignement religieux divers"),

-- Langues vivantes régionales ou spécifiques

(9307, 0, 0,  93, 0, 255, "GRE", "Grec moderne"),
(9308, 0, 0,  93, 0, 255, "HEB", "Hébreu"),
(9315, 0, 0,  93, 0, 255, "ARM", "Arménien"),
(9316, 0, 0,  93, 0, 255, "AMH", "Amharique"),
(9317, 0, 0,  93, 0, 255, "ARD", "Arabe dialectal"),
(9318, 0, 0,  93, 0, 255, "BER", "Berbère"),
(9319, 0, 0,  93, 0, 255, "BUL", "Bulgare"),
(9320, 0, 0,  93, 0, 255, "CAM", "Cambodgien"),
(9321, 0, 0,  93, 0, 255, "VIE", "Vietnamien"),
(9322, 0, 0,  93, 0, 255, "FIN", "Finnois"),
(9323, 0, 0,  93, 0, 255, "HON", "Hongrois"),
(9324, 0, 0,  93, 0, 255, "ISL", "Islandais"),
(9325, 0, 0,  93, 0, 255, "NOR", "Norvégien"),
(9326, 0, 0,  93, 0, 255, "MLG", "Malgache"),
(9327, 0, 0,  93, 0, 255, "ROU", "Roumain"),
(9328, 0, 0,  93, 0, 255, "TCH", "Tchèque"),
(9330, 0, 0,  93, 0, 255, "PER", "Persan"),
(9331, 0, 0,  93, 0, 255, "TUR", "Turc"),
(9332, 0, 0,  93, 0, 255, "LAO", "Laotien"),
(9333, 0, 0,  93, 0, 255, "SUE", "Suédois"),
(9334, 0, 0,  93, 0, 255, "AME", "Américain"),
(9335, 0, 0,  93, 0, 255, "ALB", "Albanais"),
(9336, 0, 0,  93, 0, 255, "SER", "Serbe"),
(9337, 0, 0,  93, 0, 255, "CRO", "Croate"),
(9338, 0, 0,  93, 0, 255, "BAM", "Bambara"),
(9339, 0, 0,  93, 0, 255, "COE", "Coréen"),
(9340, 0, 0,  93, 0, 255, "HAO", "Haoussa"),
(9341, 0, 0,  93, 0, 255, "HIN", "Hindi"),
(9342, 0, 0,  93, 0, 255, "INM", "Indonésien-malaysien"),
(9343, 0, 0,  93, 0, 255, "MAC", "Macédonien"),
(9344, 0, 0,  93, 0, 255, "PEU", "Peuhl"),
(9345, 0, 0,  93, 0, 255, "SLQ", "Slovaque"),
(9346, 0, 0,  93, 0, 255, "SLN", "Slovène"),
(9347, 0, 0,  93, 0, 255, "SWA", "Swahili"),
(9348, 0, 0,  93, 0, 255, "TAM", "Tamoul"),
(9350, 0, 0,  93, 0, 255, "AUV", "Auvergnat"),
(9351, 0, 0,  93, 0, 255, "BAS", "Basque"),
(9352, 0, 0,  93, 0, 255, "BRE", "Breton"),
(9353, 0, 0,  93, 0, 255, "CAT", "Catalan"),
(9354, 0, 0,  93, 0, 255, "COR", "Corse"),
(9355, 0, 0,  93, 0, 255, "GAL", "Gallo"),
(9356, 0, 0,  93, 0, 255, "GAS", "Gascon"),
(9357, 0, 0,  93, 0, 255, "LAN", "Languedocien"),
(9358, 0, 0,  93, 0, 255, "OCC", "Langue occitane"),
(9359, 0, 0,  93, 0, 255, "LRA", "Langues régionales d'alsace"),
(9360, 0, 0,  93, 0, 255, "LIM", "Limousin"),
(9361, 0, 0,  93, 0, 255, "NIS", "Nissart"),
(9362, 0, 0,  93, 0, 255, "PRV", "Provençal"),
(9363, 0, 0,  93, 0, 255, "TAH", "Tahitien"),
(9364, 0, 0,  93, 0, 255, "VAL", "Vivaro-alpin"),
(9367, 0, 0,  93, 0, 255, "MOS", "Langues régionales des pays mosellans"),
(9368, 0, 0,  93, 0, 255, "MEL", "Langues mélanésiennes"),
(9369, 0, 0,  93, 0, 255, "LMJ", "Mélanésien ajie"),
(9370, 0, 0,  93, 0, 255, "LMR", "Mélanésien drehu"),
(9371, 0, 0,  93, 0, 255, "LMN", "Mélanésien nengone"),
(9372, 0, 0,  93, 0, 255, "LMD", "Mélanésien paici"),
(9373, 0, 0,  93, 0, 255, "CRE", "Créole"),

-- Spécialités de baccalauréat professionnel (http://eduscol.education.fr/cid47640/le-baccalaureat-professionnel.html#lien2)

(9701, 0, 0,  97, 0, 255, "BPASS", "Accompagnement soins et services à la personne"),
(9702, 0, 0,  97, 0, 255, "BPARC", "Accueil - relation clients et usagers"),
(9703, 0, 0,  97, 0, 255, "BPAOA", "Aéronautique - option mécanicien systèmes avionique"),
(9704, 0, 0,  97, 0, 255, "BPAOC", "Aéronautique - option mécanicien système cellule"),
(9705, 0, 0,  97, 0, 255, "BPA3O", "Aéronautique à trois options (avionique - syst. et structures)"),
(9706, 0, 0,  97, 0, 255, "BPAEA", "Agencement de l'espace architectural"),
(9707, 0, 0,  97, 0, 255, "BPAFB", "Aménagement et finition du bâtiment"),
(9708, 0, 0,  97, 0, 255, "BPAMP", "Artisanat et métiers d'art - option arts de la pierre"),
(9709, 0, 0,  97, 0, 255, "BPAMC", "Artisanat et métiers d'art - option comm. visuelle pluri média"),
(9710, 0, 0,  97, 0, 255, "BPAME", "Artisanat et métiers d'art - option ébéniste"),
(9711, 0, 0,  97, 0, 255, "BPAMM", "Artisanat et métiers d'art - option marchandisage visuel"),
(9712, 0, 0,  97, 0, 255, "BPAMT", "Artisanat et métiers d'art - option tapissier d'ameublement"),
(9713, 0, 0,  97, 0, 255, "BPAMV", "Artisanat et métiers d'art - verrerie + enseigne / signalétique"),
(9714, 0, 0,  97, 0, 255, "BPAG" , "Aviation générale"),
(9715, 0, 0,  97, 0, 255, "BPBIT", "Bio-industries de transformation"),
(9716, 0, 0,  97, 0, 255, "BPBP" , "Boulanger - pâtissier"),
(9717, 0, 0,  97, 0, 255, "BPBCT", "Boucher charcutier traiteur"),
(9718, 0, 0,  97, 0, 255, "BPCOM", "Commerce"),
(9719, 0, 0,  97, 0, 255, "BPCSR", "Commercialisation et services en restauration"),
(9720, 0, 0,  97, 0, 255, "BPCPT", "Comptabilité"),
(9721, 0, 0,  97, 0, 255, "BPCTR", "Conducteur transport routier marchandises"),
(9722, 0, 0,  97, 0, 255, "BPCR" , "Construction des carrosseries"),
(9723, 0, 0,  97, 0, 255, "BPCUI", "Cuisine"),
(9724, 0, 0,  97, 0, 255, "BPCM" , "Cultures marines"),
(9725, 0, 0,  97, 0, 255, "BPEEE", "Électrotechnique, énergie, équipement communicants"),
(9726, 0, 0,  97, 0, 255, "BPEN" , "Environnement nucléaire"),
(9727, 0, 0,  97, 0, 255, "BPECP", "Esthétique cosmétique parfumerie"),
(9728, 0, 0,  97, 0, 255, "BPEPI", "Étude et définition de produits industriels"),
(9729, 0, 0,  97, 0, 255, "BPFPI", "Façonnage de produits imprimés, routage"),
(9730, 0, 0,  97, 0, 255, "BPFON", "Fonderie"),
(9731, 0, 0,  97, 0, 255, "BPGA" , "Gestion-administration"),
(9732, 0, 0,  97, 0, 255, "BPGP" , "Gestion des pollutions et protection de l'environnement"),
(9733, 0, 0,  97, 0, 255, "BPHE" , "Hygiène et environnement"),
(9734, 0, 0,  97, 0, 255, "BPHPS", "Hygiène, propreté et stérilisation"),
(9735, 0, 0,  97, 0, 255, "BPIP" , "Industrie de procédés"),
(9736, 0, 0,  97, 0, 255, "BPIPC", "Industries des pates, papiers et cartons"),
(9737, 0, 0,  97, 0, 255, "BPIPB", "Interventions sur le patrimoine bâti"),
(9738, 0, 0,  97, 0, 255, "BPLOG", "Logistique"),
(9739, 0, 0,  97, 0, 255, "BPMVA", "Maintenance de véhicules automobiles"),
(9740, 0, 0,  97, 0, 255, "BPMEI", "Maintenance des équipements industriels"),
(9741, 0, 0,  97, 0, 255, "BPMM" , "Maintenance des matériels"),
(9742, 0, 0,  97, 0, 255, "BPMN" , "Maintenance nautique"),
(9743, 0, 0,  97, 0, 255, "BPMMV", "Métiers de la mode - vêtements"),
(9744, 0, 0,  97, 0, 255, "BPMCC", "Métiers du cuir option chaussures"),
(9745, 0, 0,  97, 0, 255, "BPMCM", "Métiers du cuir option maroquinerie"),
(9746, 0, 0,  97, 0, 255, "BPMPB", "Métiers du pressing et de la blanchisserie"),
(9747, 0, 0,  97, 0, 255, "BPMIC", "Microtechniques"),
(9748, 0, 0,  97, 0, 255, "BPMIT", "Mise en œuvre des matériaux option industries textiles"),
(9749, 0, 0,  97, 0, 255, "BPMMC", "Mise en œuvre des matériaux opt. mat. métal. moulés, céramiques"),
(9750, 0, 0,  97, 0, 255, "BPOL" , "Optique lunetterie"),
(9751, 0, 0,  97, 0, 255, "BPOBS", "Ouvrage du bâtiment : aluminium, verre et matériaux de synthèse"),
(9752, 0, 0,  97, 0, 255, "BPOBM", "Ouvrage du bâtiment : métallerie"),
(9753, 0, 0,  97, 0, 255, "BPPP" , "Perruquier posticheur"),
(9754, 0, 0,  97, 0, 255, "BPPHO", "Photographie"),
(9755, 0, 0,  97, 0, 255, "BPPSP", "Pilotage de systèmes de production automatisée"),
(9756, 0, 0,  97, 0, 255, "BPPLP", "Pilote de ligne de production"),
(9757, 0, 0,  97, 0, 255, "BPPC" , "Plastiques et composites"),
(9758, 0, 0,  97, 0, 255, "BPPET", "Poissonnier écailler traiteur"),
(9759, 0, 0,  97, 0, 255, "BPPCE", "Procédés de la chimie, de l'eau et des papiers-cartons"),
(9760, 0, 0,  97, 0, 255, "BPPG" , "Production graphique"),
(9761, 0, 0,  97, 0, 255, "BPPI" , "Production imprimée"),
(9762, 0, 0,  97, 0, 255, "BPPMD", "Productique mécanique - option décolletage"),
(9763, 0, 0,  97, 0, 255, "BPPD" , "Prothèse dentaire"),
(9764, 0, 0,  97, 0, 255, "BPRC" , "Réparation des carrosseries"),
(9765, 0, 0,  97, 0, 255, "BPSEC", "Secrétariat"),
(9766, 0, 0,  97, 0, 255, "BPSP" , "Sécurité prévention"),
(9767, 0, 0,  97, 0, 255, "BPSPL", "Services de proximité et vie locale"),
(9768, 0, 0,  97, 0, 255, "BPSEN", "Systèmes électroniques numériques"),
(9769, 0, 0,  97, 0, 255, "BPTA" , "Technicien aérostructure"),
(9770, 0, 0,  97, 0, 255, "BPTCB", "Technicien constructeur bois"),
(9771, 0, 0,  97, 0, 255, "BPTFB", "Technicien de fabrication bois et matériaux associes"),
(9772, 0, 0,  97, 0, 255, "BPTEC", "Technicien de maintenance de syst. énergétiques et climatiques"),
(9773, 0, 0,  97, 0, 255, "BPTSC" , "Technicien de scierie"),
(9774, 0, 0,  97, 0, 255, "BPTB" , "Technicien du bâtiment : organisation réalisation du gros œuvre"),
(9775, 0, 0,  97, 0, 255, "BPTFC", "Technique du froid et du conditionnement de l'air"),
(9776, 0, 0,  97, 0, 255, "BPTEB", "Technicien d'études du bâtiment"),
(9777, 0, 0,  97, 0, 255, "BPTU" , "Technicien d'usinage"),
(9778, 0, 0,  97, 0, 255, "BPTCI", "Technicien en chaudronnerie industrielle"),
(9779, 0, 0,  97, 0, 255, "BPTIC", "Technicien en installation de syst. énergétiques et climatiques"),
(9780, 0, 0,  97, 0, 255, "BPTGT", "Technicien géomètre topographe"),
(9781, 0, 0,  97, 0, 255, "BPTMA", "Technicien menuisier agenceur"),
(9782, 0, 0,  97, 0, 255, "BPTM" , "Technicien modeleur"),
(9783, 0, 0,  97, 0, 255, "BPTO" , "Technicien outilleur"),
(9784, 0, 0,  97, 0, 255, "BPTSU", "Traitements de surfaces"),
(9785, 0, 0,  97, 0, 255, "BPTRA", "Transport"),
(9786, 0, 0,  97, 0, 255, "BPTF" , "Transport fluvial"),
(9787, 0, 0,  97, 0, 255, "BPTP" , "Travaux publics"),
(9788, 0, 0,  97, 0, 255, "BPV"  , "Vente (prospection-négociation-suivi de clientèle)"),

-- Champs professionnels en SEGPA (http://www.education.gouv.fr/cid24467/mene0900316c.html)

(9801, 0, 0,  98, 0, 255, "CPHAB", "Habitat"),
(9802, 0, 0,  98, 0, 255, "CPHAS", "Hygiène - Alimentation - Services"),
(9803, 0, 0,  98, 0, 255, "CPERE", "Espace rural et environnement"),
(9804, 0, 0,  98, 0, 255, "CPVDM", "Vente - Distribution - Magasinage"),
(9805, 0, 0,  98, 0, 255, "CPPI" , "Production industrielle"),

-- Matières principales

(9901, 0, 1,  99, 0, 255, "P1"   , "1 Maîtrise de la langue française"),
(9902, 0, 1,  99, 0, 255, "P2"   , "2 Pratique d'une langue vivante étrangère"),
(9903, 0, 1,  99, 0, 255, "P3A"  , "3 Principaux éléments de mathématiques"),
(9904, 0, 1,  99, 0, 255, "P3B"  , "3 Culture scientifique et technologique"),
(9905, 0, 1,  99, 0, 255, "P4"   , "4 Maîtrise des TICE"),
(9906, 0, 1,  99, 0, 255, "P5"   , "5 Culture humaniste"),
(9907, 0, 1,  99, 0, 255, "P6"   , "6 Compétences sociales et civiques"),
(9908, 0, 1,  99, 0, 255, "P7"   , "7 Autonomie et initiative"),
(9911, 0, 1,  99, 0, 255, "APS"  , "Apprendre à porter secours"),
(9912, 0, 1,  99, 0, 255, "PSC1" , "Prévention et secours civiques de niveau 1"),
(9913, 0, 1,  99, 0, 255, "PSC2" , "Prévention et secours civiques de niveau 2"),
(9921, 0, 1,  99, 0, 255, "APER" , "Attestation de première éducation à la route"),
(9922, 0, 1,  99, 0, 255, "ASSR1", "Attestation scolaire de sécurité routière de niveau 1"),
(9923, 0, 1,  99, 0, 255, "ASSR2", "Attestation scolaire de sécurité routière de niveau 2"),
(9991, 0, 1,  99, 0, 255, "DOC"  , "Documentation"),
(9992, 0, 1,  99, 0, 255, "INFO" , "Informatique"),
(9999, 0, 1,  99, 0, 255, "TRANS", "Transversal");

ALTER TABLE sacoche_matiere ENABLE KEYS;
