DROP TABLE IF EXISTS sacoche_user;

CREATE TABLE sacoche_user (
  user_id             MEDIUMINT(8)            UNSIGNED                NOT NULL AUTO_INCREMENT,
  user_sconet_id      MEDIUMINT(8)            UNSIGNED                NOT NULL DEFAULT 0   COMMENT "ELEVE.ELEVE.ID pour un élève ; INDIVIDU_ID pour un prof ; PERSONNE_ID pour un parent",
  user_sconet_elenoet SMALLINT(5)             UNSIGNED                NOT NULL DEFAULT 0   COMMENT "ELENOET pour un élève (entre 2000 et 5000 ; parfois appelé n° GEP avec un 0 devant)",
  user_reference      CHAR(11)                COLLATE utf8_unicode_ci NOT NULL DEFAULT ""  COMMENT "Dans Sconet, ID_NATIONAL pour un élève (pour un prof ce pourrait être le NUMEN mais il n'est pas renseigné et il faudrait deux caractères de plus). Ce champ sert aussi pour un import tableur.",
  user_profil_sigle   CHAR(3)                 COLLATE utf8_unicode_ci NOT NULL DEFAULT ""  COMMENT "Nomenclature issue de la BCN (table n_fonction_filiere) et de user_profils SDET.",
  user_genre          ENUM("I","M","F")       COLLATE utf8_unicode_ci NOT NULL DEFAULT "I" COMMENT "Indéterminé / Masculin / Féminin",
  user_nom            VARCHAR(25)             COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  user_prenom         VARCHAR(25)             COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  user_naissance_date DATE                                                     DEFAULT NULL ,
  user_email          VARCHAR(63)             COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  user_email_origine  ENUM("","user","admin") COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  user_login          VARCHAR(20)             COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  user_password       CHAR(32)                COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  user_langue         VARCHAR(6)              COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  user_daltonisme     TINYINT(1)              UNSIGNED                NOT NULL DEFAULT 0,
  user_connexion_date DATETIME                                                 DEFAULT NULL ,
  user_sortie_date    DATE                                            NOT NULL DEFAULT "9999-12-31",
  eleve_classe_id     MEDIUMINT(8)            UNSIGNED                NOT NULL DEFAULT 0,
  eleve_langue        TINYINT(3)              UNSIGNED                NOT NULL DEFAULT 100 COMMENT "Langue choisie pour le socle.",
  eleve_brevet_serie  VARCHAR(6)              COLLATE utf8_unicode_ci NOT NULL DEFAULT "X" COMMENT "Série du brevet pour Notanet.",
  user_id_ent         VARCHAR(63)             COLLATE utf8_unicode_ci NOT NULL DEFAULT ""  COMMENT "Paramètre renvoyé après une identification CAS depuis un ENT (ça peut être le login, mais ça peut aussi être un numéro interne à l'ENT...).",
  user_id_gepi        VARCHAR(63)             COLLATE utf8_unicode_ci NOT NULL DEFAULT ""  COMMENT "Login de l'utilisateur dans Gepi utilisé pour un transfert note/moyenne vers un bulletin.",
  user_param_accueil  VARCHAR(93)             COLLATE utf8_unicode_ci NOT NULL DEFAULT "user,alert,messages,resultats,faiblesses,reussites,demandes,saisies,officiel,socle,help,ecolo",
  user_pass_key       CHAR(32)                COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  PRIMARY KEY (user_id),
  UNIQUE KEY user_login (user_login),
  KEY profil_sigle (user_profil_sigle),
  KEY user_sortie_date (user_sortie_date),
  KEY eleve_classe_id (eleve_classe_id),
  KEY eleve_brevet_serie (eleve_brevet_serie),
  KEY user_id_ent (user_id_ent),
  KEY user_id_gepi (user_id_gepi)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
