<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2015
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d'Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}
$TITRE = html(Lang::_("Groupes"));
?>

<div class="hc">
  <a href="./index.php?page=<?php echo $PAGE ?>&amp;section=gestion">Groupes (gestion).</a>  ||
  <a href="./index.php?page=<?php echo $PAGE ?>&amp;section=classe_groupe">Périodes &amp; classes / groupes.</a>  ||
  <a href="./index.php?page=<?php echo $PAGE ?>&amp;section=eleve">Élèves &amp; groupes.</a>  ||
  <a href="./index.php?page=<?php echo $PAGE ?>&amp;section=professeur">Professeurs &amp; groupes.</a>
</div>

<hr />

<?php
if(($SECTION=='eleve')||($SECTION=='professeur'))
{
  // échanger $PAGE et $SECTION pour piocher le bon fichier sans avoir besoin de le dupliquer, tout en gardant ce menu
  $PAGE    = 'administrateur_'.$SECTION;
  $SECTION = 'groupe';
}
elseif($SECTION=='classe_groupe')
{
  // remplacer $PAGE pour piocher le bon fichier sans avoir besoin de le dupliquer, tout en gardant ce menu
  $PAGE = 'administrateur_periode';
}
// Afficher la bonne page et appeler le bon js / ajax par la suite
$fichier_section = CHEMIN_DOSSIER_PAGES.$PAGE.'_'.$SECTION.'.php';
if(is_file($fichier_section))
{
  $PAGE = $PAGE.'_'.$SECTION ;
  require($fichier_section);
}
else
{
  echo'<p class="astuce">Choisir une rubrique ci-dessus&hellip;</p>'.NL;
  echo'<p><span class="manuel"><a class="pop_up" href="'.SERVEUR_DOCUMENTAIRE.'?fichier=support_administrateur__gestion_groupes">DOC : Gestion des groupes</a></span></p>'.NL;
}
?>
