DROP TABLE IF EXISTS sacoche_socle_section;

CREATE TABLE sacoche_socle_section (
  section_id    TINYINT(3)   UNSIGNED                NOT NULL AUTO_INCREMENT,
  pilier_id     TINYINT(3)   UNSIGNED                NOT NULL DEFAULT 0,
  section_ordre TINYINT(3)   UNSIGNED                NOT NULL DEFAULT 1 COMMENT "Commence à 1.",
  section_nom   VARCHAR(165) COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  PRIMARY KEY (section_id),
  KEY pilier_id (pilier_id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE sacoche_socle_section DISABLE KEYS;

INSERT INTO sacoche_socle_section VALUES 
(  1, 16, 1, "Dire"),
(  2, 16, 2, "Lire"),
(  3, 16, 3, "Écrire"),
(  4, 16, 4, "Étude de la langue - vocabulaire"),
(  5, 16, 5, "Étude de la langue - grammaire"),
(  6, 16, 6, "Étude de la langue - orthographe"),
(  7, 17, 1, "Nombres et calcul"),
(  8, 17, 2, "Géométrie"),
(  9, 17, 3, "Grandeurs et mesures"),
( 10, 17, 4, "Organisation et gestion de données"),
( 11, 18, 1, "Connaître les principes et fondements de la vie civique et sociale"),
( 12, 18, 2, "Avoir un comportement responsable"),
( 13,  8, 1, "Dire"),
( 14,  8, 2, "Lire"),
( 15,  8, 3, "Écrire"),
( 16,  8, 4, "Étude de la langue - vocabulaire"),
( 17,  8, 5, "Étude de la langue - grammaire"),
( 18,  8, 6, "Étude de la langue - orthographe"),
( 19,  9, 1, "Réagir et dialoguer"),
( 20,  9, 2, "Comprendre à l’oral"),
( 21,  9, 3, "Parler en continu"),
( 22,  9, 4, "Lire"),
( 23,  9, 5, "Écrire"),
( 24, 10, 1, "Nombres et calcul"),
( 25, 10, 2, "Géométrie"),
( 26, 10, 3, "Grandeurs et mesures"),
( 27, 10, 4, "Organisation et gestion de données"),
( 28, 11, 1, "Pratiquer une démarche scientifique ou technologique"),
( 29, 11, 2, "Maîtriser des connaissances dans divers domaines scientifiques et les mobiliser dans des contextes scientifiques différents et dans des activités de la vie courante"),
( 30, 11, 3, "Environnement et développement durable"),
( 31, 12, 1, "S’approprier un environnement informatique de travail"),
( 32, 12, 2, "Adopter une attitude responsable"),
( 33, 12, 3, "Créer, produire, traiter, exploiter des données"),
( 34, 12, 4, "S’informer, se documenter"),
( 35, 12, 5, "Communiquer, échanger"),
( 36, 13, 1, "Avoir des repères relevant du temps et de l’espace"),
( 37, 13, 2, "Avoir des repères littéraires"),
( 73, 13, 3, "Lire et pratiquer différents langages"),
( 38, 13, 4, "Pratiquer les arts et avoir des repères en histoire des arts"),
( 39, 14, 1, "Connaître les principes et fondements de la vie civique et sociale"),
( 40, 14, 2, "Avoir un comportement responsable"),
( 41, 15, 1, "S’appuyer sur des méthodes de travail pour être autonome"),
( 42, 15, 2, "Faire preuve d’initiative"),
( 43, 15, 3, "Avoir une bonne maîtrise de son corps et une pratique physique (sportive ou artistique)"),
( 44,  1, 1, "Lire"),
( 45,  1, 2, "Écrire"),
( 46,  1, 3, "Dire"),
( 48,  2, 1, "Réagir et dialoguer"),
( 49,  2, 2, "Écouter et comprendre"),
( 50,  2, 3, "Parler en continu"),
( 51,  2, 4, "Lire"),
( 52,  2, 5, "Écrire"),
( 53,  3, 1, "Pratiquer une démarche scientifique et technologique, résoudre des problèmes"),
( 54,  3, 2, "Savoir utiliser des connaissances et des compétences mathématiques"),
( 55,  3, 3, "Savoir utiliser des connaissances dans divers domaines scientifiques"),
( 56,  3, 4, "Environnement et développement durable"),
( 57,  4, 1, "S’approprier un environnement informatique de travail"),
( 58,  4, 2, "Adopter une attitude responsable"),
( 59,  4, 3, "Créer, produire, traiter, exploiter des données"),
( 60,  4, 4, "S’informer, se documenter"),
( 61,  4, 5, "Communiquer, échanger"),
( 62,  5, 1, "Avoir des connaissances et des repères"),
( 67,  5, 2, "Situer dans le temps, l’espace, les civilisations"),
( 66,  5, 3, "Lire et pratiquer différents langages"),
( 74,  5, 4, "Faire preuve de sensibilité, d’esprit critique, de curiosité"),
( 68,  6, 1, "Connaître les principes et fondements de la vie civique et sociale"),
( 69,  6, 2, "Avoir un comportement responsable"),
( 70,  7, 1, "Être acteur de son parcours de formation et d’orientation"),
( 71,  7, 2, "Être capable de mobiliser ses ressources intellectuelles et physiques dans diverses situations"),
( 72,  7, 3, "Faire preuve d’initiative");

ALTER TABLE sacoche_socle_section ENABLE KEYS;
