<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2015
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d'Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}
$TITRE = html(Lang::_("Paliers du socle"));
?>

<p class="probleme">Cette section concerne le socle commun sur la période 2006-2015.<br />Aucun choix n'est à faire pour le nouveau socle 2016.</p>

<div><span class="manuel"><a class="pop_up" href="<?php echo SERVEUR_DOCUMENTAIRE ?>?fichier=support_administrateur__gestion_paliers_socle">DOC : Paliers du socle</a></span></div>

<hr />

<form id="table_action" action="#" method="post" id="socle">
  <table class="form">
    <thead>
      <tr><th class="nu"></th><th>Palier</th><th class="nu">&nbsp;</th></tr>
    </thead>
    <tbody>
      <?php
      // Lister les paliers
      $DB_TAB = DB_STRUCTURE_ADMINISTRATEUR::DB_lister_paliers_SACoche();
      foreach($DB_TAB as $DB_ROW)
      {
        // Afficher une ligne du tableau
        $checked = ($DB_ROW['palier_actif']) ? ' checked' : '' ;
        echo'<tr>';
        echo  '<td class="nu"><input type="checkbox" name="f_tab_id" value="'.$DB_ROW['palier_id'].'"'.$checked.' /></td>';
        echo  '<td class="label">'.html($DB_ROW['palier_nom']).'</td>';
        echo  '<td class="nu"><q class="voir" id="id_'.$DB_ROW['palier_id'].'" title="Voir le détail de ce palier du socle."></q></td>';
        echo'</tr>'.NL;
      }
      ?>
    </tbody>
  </table>
  <p>
    <span class="tab"></span><button id="bouton_valider" type="button" class="parametre">Valider ce choix de paliers.</button><label id="ajax_msg">&nbsp;</label>
  </p>
</form>

<hr />

<div id="zone_paliers" class="arbre_dynamique">
  <?php
  // Affichage de la liste des items du socle pour chaque palier
  $DB_TAB = DB_STRUCTURE_ADMINISTRATEUR::DB_recuperer_arborescence_paliers();
  echo str_replace( '<li class="li_m1"' , '<li class="li_m1 hide"' , HtmlArborescence::afficher_socle_from_SQL( $DB_TAB , TRUE /*dynamique*/ , FALSE /*reference*/ , FALSE /*aff_input*/ , FALSE /*ids*/ ) );
  ?>
</div>


