<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2018
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d'Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

// Liens de téléchargement.

define( 'FIREFOX_URL_DOWNLOAD', 'https://www.mozilla.org/fr/');
define(  'CHROME_URL_DOWNLOAD', 'https://www.google.fr/chrome');
define(   'OPERA_URL_DOWNLOAD', 'http://www.opera.com/fr/download');
define(    'EDGE_URL_DOWNLOAD', 'https://www.microsoft.com/fr-fr/windows/microsoft-edge');
define(  'SAFARI_URL_DOWNLOAD', 'http://www.apple.com/fr/safari/'); // plus téléchargeable ? Pour Windows, devel stoppé version 5.1.7.
define('EXPLORER_URL_DOWNLOAD', 'http://windows.microsoft.com/fr-fr/internet-explorer/download-ie');

// Versions des navigateurs.
// https://caniuse.com/#search=transform
// https://caniuse.com/#search=writing-mode

define( 'FIREFOX_VERSION_MINI_REQUISE'   , 3.5); define( 'FIREFOX_DATE_MINI_REQUISE'   , '(juin 2009)');
define( 'FIREFOX_VERSION_MINI_CONSEILLEE',41  ); define( 'FIREFOX_DATE_MINI_CONSEILLEE', '(septembre 2015)');

define(  'CHROME_VERSION_MINI_REQUISE'   , 8  ); define(  'CHROME_DATE_MINI_REQUISE'   , '(décembre 2010)');
define(  'CHROME_VERSION_MINI_CONSEILLEE',48  ); define(  'CHROME_DATE_MINI_CONSEILLEE', '(janvier 2016)');

define(   'OPERA_VERSION_MINI_REQUISE'   ,15  ); define(   'OPERA_DATE_MINI_REQUISE'   , '(juillet 2013)');
define(   'OPERA_VERSION_MINI_CONSEILLEE',35  ); define(   'OPERA_DATE_MINI_CONSEILLEE', '(février 2016)');

define(    'EDGE_VERSION_MINI_REQUISE'   ,12  ); define(    'EDGE_DATE_MINI_REQUISE'   , '(juillet 2015)');
define(    'EDGE_VERSION_MINI_CONSEILLEE',12  ); define(    'EDGE_DATE_MINI_CONSEILLEE', '(juillet 2015)');

define(  'SAFARI_VERSION_MINI_REQUISE'   , 5.1); define(  'SAFARI_DATE_MINI_REQUISE'   , '(mars 2012)');
define(  'SAFARI_VERSION_MINI_CONSEILLEE', 9  ); define(  'SAFARI_DATE_MINI_CONSEILLEE', '(octobre 2015)');

define('EXPLORER_VERSION_MINI_REQUISE'   , 9  ); define('EXPLORER_DATE_MINI_REQUISE'   , '(mars 2011)');
define('EXPLORER_VERSION_MINI_CONSEILLEE',11  ); define('EXPLORER_DATE_MINI_CONSEILLEE', '(octobre 2013)');

class Browser
{

  public static $tab_navigo = array(
    'firefox'  => 'Firefox' ,
    'chrome'   => 'Chrome' ,
    'opera'    => 'Opéra' ,
    'edge'     => 'Edge' ,
    'safari'   => 'Safari' ,
    'explorer' => 'Internet Explorer'
  );

  // //////////////////////////////////////////////////
  // Méthode privée (interne)
  // //////////////////////////////////////////////////

  /**
   * PHP CSS Browser Selector v0.0.1
   * @author Bastian Allgeier (http://bastian-allgeier.de)
   * http://bastian-allgeier.de/css_browser_selector
   * License: http://creativecommons.org/licenses/by/2.5/
   * Credits: This is a php port from Rafael Lima's original Javascript CSS Browser Selector: http://rafael.adm.br/css_browser_selector
   * 
   * Autre solution intéressante mais lourde :
   * https://github.com/GaretJax/phpbrowscap (http://tempdownloads.browserscap.com/)
   *
   * Fonction originale réécrite et modifiée pour SACoche par Thomas Crespin.
   * @param string   $UserAgent   facultatif
   * @return array                array( 'modele' , 'version' );
   */
  private static function css_selector($UserAgent=NULL)
  {
    $tab_retour = array( 'modele'=>'' , 'version'=>0 );
    // Variable à analyser
    $UserAgent = ($UserAgent) ? strtolower($UserAgent) : ( isset($_SERVER['HTTP_USER_AGENT']) ? strtolower($_SERVER['HTTP_USER_AGENT']) : '' ) ; // Pas Clean::lower() car appelé depuis ./_js/video.js.php
    // Détection du navigateur et si possible de sa version
    if(strstr($UserAgent,'Edge'))
    {
      $tab_retour['modele']  = 'edge';
      $tab_retour['version'] = (preg_match('#Edge/([0-9]+\.?[0-9]*)#',$UserAgent,$array)) ? (int)$array[1] : 0 ;
    }
    elseif( (!preg_match('#opera|webtv#', $UserAgent)) && (strstr($UserAgent,'msie')) )
    {
      $tab_retour['modele']  = 'explorer';
      $tab_retour['version'] = (preg_match('#msie\s([0-9]+\.?[0-9]*)#',$UserAgent,$array)) ? (int)$array[1] : 0 ;
    }
    // IE11 ne contient plus "MSIE" pour ne pas se faire repérer comme étant IE ! Alors on cherche aussi "Trident" (IE8+).
    elseif( (!preg_match('#opera|webtv#', $UserAgent)) && (strstr($UserAgent,'trident')) )
    {
      $tab_retour['modele']  = 'explorer';
      $tab_retour['version'] = (preg_match('#rv:([0-9]+\.?[0-9]*)#',$UserAgent,$array)) ? (int)$array[1] : 0 ;
    }
    elseif(strstr($UserAgent,'firefox'))
    {
      $tab_retour['modele']  = 'firefox';
      $tab_retour['version'] = (preg_match('#firefox/([0-9]+\.?[0-9]*)#',$UserAgent,$array)) ? (int)$array[1] : 0 ;
    }
    elseif(strstr($UserAgent,'iceweasel'))
    {
      $tab_retour['modele']  = 'firefox';
      $tab_retour['version'] = (preg_match('#iceweasel/([0-9]+\.?[0-9]*)#',$UserAgent,$array)) ? (int)$array[1] : 0 ;
    }
    elseif(strstr($UserAgent,'icecat'))
    {
      $tab_retour['modele']  = 'firefox';
      $tab_retour['version'] = (preg_match('#icecat/([0-9]+\.?[0-9]*)#',$UserAgent,$array)) ? (int)$array[1] : 0 ;
    }
    elseif(strstr($UserAgent,'gecko/'))
    {
      $tab_retour['modele']  = 'gecko';
    }
    elseif(strstr($UserAgent,'opera'))
    {
      $tab_retour['modele']  = 'opera';
      $tab_retour['version'] = (preg_match('#opera(\s|\/)([0-9]+\.?[0-9]*)#',$UserAgent,$array)) ? (int)$array[2] : 0 ;
      $tab_retour['version'] = (preg_match('#version/([0-9]+\.?[0-9]*)#', $UserAgent, $array)) ? $array[1] : $tab_retour['version'] ;
    }
    elseif(strstr($UserAgent,'konqueror'))
    {
      $tab_retour['modele']  = 'konqueror';
    }
    elseif(strstr($UserAgent,'chrome'))
    {
      $tab_retour['modele']  = 'chrome';
      $tab_retour['version'] = (preg_match('#chrome/([0-9]+\.?[0-9]*)#',$UserAgent,$array)) ? (int)$array[1] : 0 ;

    }
    elseif(strstr($UserAgent,'iron'))
    {
      $tab_retour['modele']  = 'chrome';
    }
    elseif(strstr($UserAgent,'applewebkit/'))
    {
      $tab_retour['modele']  = 'safari';
      $tab_retour['version'] = (preg_match('#version\/([0-9]+\.?[0-9]*)#', $UserAgent, $array)) ? (int)$array[1] : 0 ;
    }
    elseif(strstr($UserAgent,'mozilla'))
    {
      $tab_retour['modele']  = 'gecko';
    }
    // Envoi du résultat
    return $tab_retour;
  }

  // //////////////////////////////////////////////////
  // Méthode publique
  // //////////////////////////////////////////////////

  /*
   * Méthode pour renvoyer les infos concernant le navigateur utilisé.
   * 
   * @param void
   * @return array   array( 'modele'=>... , 'version'=>... , 'alerte'=>... )
   */
  public static function caracteristiques_navigateur()
  {
    $tab_return = Browser::css_selector(); // array( 'modele' , 'version' );
    $alerte = '';
    foreach(Browser::$tab_navigo as $navigo_ref => $navigo_name)
    {
      if($tab_return['modele']==$navigo_ref)
      {
        $navigo_upper = strtoupper($navigo_ref); // Pas Clean::upper() car appelé depuis ./_js/video.js.php
        $version_mini_requise    = constant($navigo_upper.'_VERSION_MINI_REQUISE');
        $version_mini_conseillee = constant($navigo_upper.'_VERSION_MINI_CONSEILLEE');
        if($tab_return['version']<$version_mini_requise)
        {
          $alerte = 'Votre navigateur est trop ancien pour utiliser <em>SACoche</em> ! '.$navigo_name.' est utilisable à partir de sa version '.$version_mini_requise.'.';
        }
        elseif($tab_return['version']<$version_mini_conseillee)
        {
          $alerte = ($navigo_ref=='explorer') ? 'Votre navigateur dysfonctionne ! L\'usage d\'Internet Explorer est déconseillé avant sa version 9.' : 'Votre navigateur est dépassé ! Utilisez une version récente pour une navigation plus sure, rapide et efficace.' ;
        }
      }
    }
    if(defined('APPEL_SITE_PROJET'))
    {
      // On est déjà sur la page de téléchargement
      $lien = '';
    }
    else if(defined('SERVEUR_BROWSERS'))
    {
      $lien = '<br /><a target="_blank" rel="noopener noreferrer" href="'.SERVEUR_BROWSERS.'">Informations et liens de téléchargement.</a>';
    }
    else
    {
      // Appel depuis ./_js/video.js.php
      $lien = '<br /><a target="_blank" rel="noopener noreferrer" href="https://sacoche.sesamath.net/?page=browsers">Informations et liens de téléchargement.</a>';
    }
    $tab_return['alerte'] = ($alerte) ? $alerte.$lien : NULL ;
    return $tab_return;
  }

}
?>