<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2018
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d'Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2017-12-22 => 2018-01-09
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2017-12-22')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-01-09';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modification sacoche_parametre (nom connecteur CAS pour ENT)
    // Attention, penser à effectuer aussi la modif sur la table sacoche_webmestre.sacoche_convention
    $connexion_nom = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT parametre_valeur FROM sacoche_parametre WHERE parametre_nom="connexion_nom"' );
    if($connexion_nom=='openent_monlycee')
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="entlibre_monlycee" WHERE parametre_nom="connexion_nom" ' );
    }
    if($connexion_nom=='openent_pcn')
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="entlibre_pcn" WHERE parametre_nom="connexion_nom" ' );
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-01-09 => 2018-01-14
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-01-09')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-01-14';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout d'une colonne à sacoche_jointure_devoir_eleve, et correction au passage du type erroné d'une autre colonne
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_jointure_devoir_eleve CHANGE jointure_texte jointure_texte VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT "" ' );
    if(empty($reload_sacoche_jointure_devoir_eleve))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_jointure_devoir_eleve ADD jointure_memo_autoeval VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "Au format json" AFTER jointure_audio ' );
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-01-14 => 2018-01-17
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-01-14')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-01-17';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modif valeurs de sacoche_user_profil
    if(empty($reload_sacoche_user_profil))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_user_profil SET user_profil_nom_court_singulier="PsyEN", user_profil_nom_court_pluriel="PsyEN", user_profil_nom_long_singulier="psychologue Éducation Nationale", user_profil_nom_long_pluriel="psychologues Éducation Nationale" WHERE user_profil_sigle="ORI" ');
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-01-17 => 2018-01-24
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-01-17')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-01-24';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout de 2 colonnes à sacoche_jointure_devoir_eleve
    if(empty($reload_sacoche_jointure_devoir_eleve))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_jointure_devoir_eleve ADD jointure_doc_sujet   VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "URL du document" AFTER jointure_memo_autoeval ' );
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_jointure_devoir_eleve ADD jointure_doc_corrige VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "URL du document" AFTER jointure_doc_sujet ' );
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-01-24 => 2018-01-26
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-01-24')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-01-26';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout colonne table sacoche_devoir
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_devoir ADD devoir_diagnostic TINYINT(1) UNSIGNED NOT NULL DEFAULT 0 AFTER devoir_fini ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_devoir ADD INDEX devoir_diagnostic(devoir_diagnostic)' );
    // correction de données incorrectes dans sacoche_officiel_configuration
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_configuration SET configuration_contenu = REPLACE( configuration_contenu , "\\"cases_largeur\\":0" , "\\"cases_largeur\\":5" ) WHERE officiel_type="releve" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-01-26 => 2018-01-31
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-01-26')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-01-31';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modification des archives suite à l'ajout d'un paramètre à une fonction
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\"multimatiere\",\"eleve\",1" , "\"multimatiere\",\"eleve\",1,true" ) WHERE archive_ref="releve" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\"multimatiere\",\"eleve\",0" , "\"multimatiere\",\"eleve\",0,true" ) WHERE archive_ref="releve" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-01-31 => 2018-02-02
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-01-31')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-02-02';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // l'archivage des nouveaux relevés ne tenait pas compte de l'ajout du paramètre précédent
    // du coup il faut relancer le patch pour les bilans générés entre ces deux mises à jour
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\"multimatiere\",\"eleve\",1,false,0" , "\"multimatiere\",\"eleve\",1,true,false,0" ) WHERE archive_ref="releve" AND sacoche_version="2018-01-31" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\"multimatiere\",\"eleve\",0,false,0" , "\"multimatiere\",\"eleve\",0,true,false,0" ) WHERE archive_ref="releve" AND sacoche_version="2018-01-31" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-02-02 => 2018-02-07
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-02-02')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-02-07';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modif colonne de [sacoche_livret_jointure_modaccomp_eleve]
    if(empty($reload_sacoche_livret_jointure_modaccomp_eleve))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_livret_jointure_modaccomp_eleve CHANGE info_complement info_complement TEXT COLLATE utf8_unicode_ci NOT NULL COMMENT "Dans le cas où la modalité d\'accompagnement est PPRE ou CTR."' );
    }
    // ajout d'une ligne à [sacoche_livret_modaccomp]
    if(empty($reload_sacoche_livret_modaccomp))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'INSERT INTO sacoche_livret_modaccomp VALUES ("CTR","Contrat de réussite")' );
    }
    // nouvelle table [sacoche_livret_jointure_devoirsfaits_eleve]
    $reload_sacoche_livret_jointure_devoirsfaits_eleve = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_jointure_devoirsfaits_eleve.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // nouvelle table [sacoche_livret_langcultregion]
    $reload_sacoche_livret_langcultregion = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_langcultregion.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // nouvelle table [sacoche_livret_jointure_langcultregion_eleve]
    $reload_sacoche_livret_jointure_langcultregion_eleve = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_jointure_langcultregion_eleve.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // modif colonne de la table [sacoche_livret_saisie]
    if(empty($reload_sacoche_livret_saisie))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_livret_saisie CHANGE rubrique_type rubrique_type VARCHAR(14) COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "eval | socle | ap | epi | parcours | viesco | bilan | enscompl | langcultregion | attitude" ' );
    }
    // modif colonne de la table [sacoche_livret_export]
    if(empty($reload_sacoche_livret_export))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_livret_export CHANGE jointure_periode jointure_periode VARCHAR(2) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT "Renseigné si livret_page_periodicite = periode ; @see sacoche_periode.periode_livret" ' );
    }
    // ajout de paramètres
    $droit_gerer_livret_modaccomp = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT parametre_valeur FROM sacoche_parametre WHERE parametre_nom="droit_gerer_livret_modaccomp"' );
    $droit_gerer_livret_enscompl  = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT parametre_valeur FROM sacoche_parametre WHERE parametre_nom="droit_gerer_livret_enscompl"' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'INSERT INTO sacoche_parametre VALUES ("droit_gerer_livret_devoirsfaits"   , "'.$droit_gerer_livret_modaccomp.'")' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'INSERT INTO sacoche_parametre VALUES ("droit_gerer_livret_langcultregion" , "'.$droit_gerer_livret_enscompl.'")' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-02-07 => 2018-02-14
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-02-07')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-02-14';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout d'un paramètre dans sacoche_officiel_configuration
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_configuration SET configuration_contenu = REPLACE( configuration_contenu , "\\"appreciation_generale_modele\\"" , "\\"appreciation_generale_position\\":\\"apres\\",\\"appreciation_generale_modele\\"" ) WHERE officiel_type="releve" ' );
    // il faut aussi mettre à jour les archives des bilans officiels
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"RELEVE_APPRECIATION_GENERALE_MODELE\\"" , "\\"RELEVE_APPRECIATION_GENERALE_POSITION\\":\\"apres\\",\\"RELEVE_APPRECIATION_GENERALE_MODELE\\"" ) WHERE archive_ref="releve" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-02-14 => 2018-02-23
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-02-14')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-02-23';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout d'un paramètre dans sacoche_officiel_configuration
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_configuration SET configuration_contenu = REPLACE( configuration_contenu , "\\"envoi_mail_parent\\"" , "\\"page_bilan_classe\\":0,\\"envoi_mail_parent\\"" ) ' );
    // il faut aussi mettre à jour les archives des bilans officiels
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"RELEVE_ENVOI_MAIL_PARENT\\"" , "\\"RELEVE_PAGE_BILAN_CLASSE\\":0,\\"RELEVE_ENVOI_MAIL_PARENT\\"" ) WHERE archive_ref="releve" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"LIVRET_ENVOI_MAIL_PARENT\\"" , "\\"LIVRET_PAGE_BILAN_CLASSE\\":0,\\"LIVRET_ENVOI_MAIL_PARENT\\"" ) WHERE archive_ref="livret" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"BULLETIN_ENVOI_MAIL_PARENT\\"" , "\\"BULLETIN_PAGE_BILAN_CLASSE\\":0,\\"BULLETIN_ENVOI_MAIL_PARENT\\"" ) WHERE archive_ref="bulletin" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-02-23 => 2018-03-02
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-02-23')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-03-02';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout de paramètres dans sacoche_officiel_configuration
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_configuration SET configuration_contenu = REPLACE( configuration_contenu , "\\"envoi_mail_parent\\"" , "\\"decision_mention\\":1,\\"decision_orientation\\":0,\\"envoi_mail_parent\\"" ) ' );
    // il faut aussi mettre à jour les archives des bilans officiels
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"RELEVE_ENVOI_MAIL_PARENT\\"" , "\\"RELEVE_DECISION_MENTION\\":1,\\"RELEVE_DECISION_ORIENTATION\\":0,\\"RELEVE_ENVOI_MAIL_PARENT\\"" ) WHERE archive_ref="releve" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"LIVRET_ENVOI_MAIL_PARENT\\"" , "\\"LIVRET_DECISION_MENTION\\":1,\\"LIVRET_DECISION_ORIENTATION\\":0,\\"LIVRET_ENVOI_MAIL_PARENT\\"" ) WHERE archive_ref="livret" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"BULLETIN_ENVOI_MAIL_PARENT\\"" , "\\"BULLETIN_DECISION_MENTION\\":1,\\"BULLETIN_DECISION_ORIENTATION\\":0,\\"BULLETIN_ENVOI_MAIL_PARENT\\"" ) WHERE archive_ref="bulletin" ' );
    // nouvelle table [sacoche_officiel_decision]
    $reload_sacoche_officiel_decision = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_officiel_decision.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // nouvelle table [sacoche_officiel_jointure_decision]
    $reload_sacoche_officiel_jointure_decision = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_officiel_jointure_decision.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-03-02 => 2018-03-07
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-03-02')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-03-07';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout d'un champ à la table [sacoche_user]
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_user ADD user_form_options TEXT COLLATE utf8_unicode_ci COMMENT "Choix d\'options des formulaires enregistrées sérializées." AFTER user_param_favori' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_user SET user_form_options = NULL' );
    // Y reporter les préférences auparavant enregistrées dans des fichiers
    $dossier_cookie = CHEMIN_DOSSIER_TMP.'cookie'.DS.$_SESSION['BASE'].DS; // CHEMIN_DOSSIER_COOKIE non utilisé car peut ne plus être défini
    if(is_dir($dossier_cookie))
    {
      $DB_SQL = 'UPDATE sacoche_user SET user_form_options =:form_options WHERE user_id=:user_id';
      $tab_fichier = FileSystem::lister_contenu_dossier($dossier_cookie);
      foreach($tab_fichier as $fichier_cookie)
      {
        if( substr($fichier_cookie,0,4) == 'user' )
        {
          $contenu = file_get_contents($dossier_cookie.$fichier_cookie);
          $user_id = (int)substr($fichier_cookie,4,-4); // userXXX.txt
          $DB_VAR = array(
            ':form_options' => $contenu,
            ':user_id'      => $user_id,
          );
          DB::query(SACOCHE_STRUCTURE_BD_NAME , $DB_SQL , $DB_VAR);
        }
      }
      FileSystem::supprimer_dossier($dossier_cookie);
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-03-07 => 2018-03-14
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-03-07')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-03-14';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout d'un paramètre dans sacoche_officiel_configuration
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_configuration SET configuration_contenu = REPLACE( configuration_contenu , "\\"moyenne_classe\\"" , "\\"aff_prop_sans_score\\":0,\\"moyenne_classe\\"" ) WHERE officiel_type="bulletin" ' );
    // il faut aussi mettre à jour les archives des bilans officiels
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"BULLETIN_MOYENNE_CLASSE\\"" , "\\"BULLETIN_AFF_PROP_SANS_SCORE\\":0,\\"BULLETIN_MOYENNE_CLASSE\\"" ) WHERE archive_ref="bulletin" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-03-14 => 2018-03-21
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-03-14')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-03-21';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // nouvelle table [sacoche_courriel_erreur]
    $reload_sacoche_courriel_erreur = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_courriel_erreur.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-03-21 => 2018-03-25
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-03-21')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-03-25';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // nouvelle table [sacoche_catalogue_categorie]
    $reload_sacoche_catalogue_categorie = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_catalogue_categorie.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // nouvelle table [sacoche_catalogue_appreciation]
    $reload_sacoche_catalogue_appreciation = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_catalogue_appreciation.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-03-25 => 2018-04-02
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-03-25')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-04-02';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout d'un paramètre
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'INSERT INTO sacoche_parametre VALUES ("officiel_signature_transparence" , "non")' );
    // réordonner la table sacoche_parametre (ligne à déplacer vers la dernière MAJ lors d'ajout dans sacoche_parametre)
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_parametre ORDER BY parametre_nom' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-04-02 => 2018-04-03
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-04-02')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-04-03';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modification des spécifications du Livret Scolaire pour "langue et culture régionale"
    if(empty($reload_sacoche_livret_langcultregion))
    {
      $reload_sacoche_livret_langcultregion = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_langcultregion.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_jointure_langcultregion_eleve SET livret_langcultregion_code="BAQ" WHERE livret_langcultregion_code="BAS"' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_jointure_langcultregion_eleve SET livret_langcultregion_code="COS" WHERE livret_langcultregion_code="COR"' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_jointure_langcultregion_eleve SET livret_langcultregion_code="OCI" WHERE livret_langcultregion_code="OCC"' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_jointure_langcultregion_eleve SET livret_langcultregion_code="GSW" WHERE livret_langcultregion_code="ALS"' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DELETE FROM sacoche_livret_jointure_langcultregion_eleve WHERE livret_langcultregion_code="MOS"' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DELETE FROM sacoche_livret_saisie WHERE rubrique_type="langcultregion" AND rubrique_id=6' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_export SET export_contenu = REPLACE( export_contenu , "{\"code\":\"BAS\"," , "{\"code\":\"BAQ\"," ) ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_export SET export_contenu = REPLACE( export_contenu , "{\"code\":\"COR\"," , "{\"code\":\"COS\"," ) ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_export SET export_contenu = REPLACE( export_contenu , "{\"code\":\"OCC\"," , "{\"code\":\"OCI\"," ) ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_export SET export_contenu = REPLACE( export_contenu , "{\"code\":\"ALS\"," , "{\"code\":\"GSW\"," ) ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_export SET export_contenu = REPLACE( export_contenu , ",\"langcultregion\":{\"code\":\"MOS\",\"positionnement\":2}" , "" ) ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_export SET export_contenu = REPLACE( export_contenu , ",\"langcultregion\":{\"code\":\"MOS\",\"positionnement\":1}" , "" ) ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-04-03 => 2018-04-09
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-04-03')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-04-09';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modif colonne table sacoche_devoir
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_devoir CHANGE devoir_eleves_ordre devoir_eleves_ordre VARCHAR(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT "alpha" COMMENT "alpha | classe | n° de plan de classe" ' );
    // modification des menus
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_user SET user_param_menu = REPLACE( user_param_menu , "information" , "information_perso,information_general" ) ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_user SET user_param_menu = REPLACE( user_param_menu , "parametrage" , "parametrage_compte,parametrage_pedago" ) ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre_profil SET profil_param_menu = REPLACE( profil_param_menu , "information" , "information_perso,information_general" ) ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre_profil SET profil_param_menu = REPLACE( profil_param_menu , "parametrage" , "parametrage_compte,parametrage_pedago" ) ' );
    // nouvelle table [sacoche_plan_classe]
    $reload_sacoche_plan_classe = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_plan_classe.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // nouvelle table [sacoche_jointure_plan_eleve]
    $reload_sacoche_jointure_plan_eleve = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_jointure_plan_eleve.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // on en profite pour supprimer un dossier qui ne sert plus
    $dossier_badge = CHEMIN_DOSSIER_TMP.'badge'.DS.$_SESSION['BASE'].DS; // CHEMIN_DOSSIER_BADGE non utilisé car peut ne plus être défini
    if(is_dir($dossier_badge))
    {
      FileSystem::supprimer_dossier($dossier_badge);
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-04-09 => 2018-04-26
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-04-09')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-04-26';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout d'un paramètre dans sacoche_officiel_configuration
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_configuration SET configuration_contenu = REPLACE( configuration_contenu , "\\"import_bulletin_notes\\"" , "\\"cycle_import_synthese_periode\\":0,\\"import_bulletin_notes\\"" ) WHERE officiel_type="livret" ' );
    // il faut aussi mettre à jour les archives des bilans officiels
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"IMPORT_BULLETIN_NOTES\\"" , "\\"CYCLE_IMPORT_SYNTHESE_PERIODE\\":0,\\"IMPORT_BULLETIN_NOTES\\"" ) WHERE archive_ref="livret" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-04-26 => 2018-05-17
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-04-26')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-05-17';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // Correction d'un pb de TRUNCATE appliqué sur la table sacoche_devoir lors de l'initialisation annuelle, ce qui a initialisé son auto-incrément
    // On s'appuie sur le fichier de log des actions sensibles pour détecter l'erreur, donc il faut se trouver sur le serveur concerné...
    $date_version_bug_debut_mysql = '2017-11-26';
    $date_version_bug_fin_mysql   = '2018-05-16';
    $date_bug_mysql = '';
    $devoir_id_max  = 0;
    $fichier_log_contenu = SACocheLog::lire($_SESSION['BASE']);
    if($fichier_log_contenu!==NULL)
    {
      $tab_lignes = SACocheLog::extraire_lignes($fichier_log_contenu);
      $nb_lignes = count($tab_lignes);
      for( $indice_ligne=0 ; $indice_ligne<$nb_lignes ; $indice_ligne++ )
      {
        list( $balise_debut , $date_heure , $utilisateur , $action , $balise_fin ) = explode("\t",$tab_lignes[$indice_ligne]);
        $date_mysql = To::date_french_to_mysql( str_replace('-','/',substr($date_heure,0,10)) );
        if( ($date_mysql>=$date_version_bug_debut_mysql) && ($date_mysql<=$date_version_bug_fin_mysql) && strpos($action,'Purge annuelle de la base en cours') )
        {
          $date_bug_mysql = $date_mysql;
          break;
        }
        else if ($date_mysql>$date_version_bug_fin_mysql)
        {
          break;
        }
      }
    }
    if($date_bug_mysql)
    {
      // On est dans le cas où l'initialisation annuelle a entraîné le bug
      $devoir_id_max_devoir = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT MAX(devoir_id) FROM sacoche_devoir ' );
      $devoir_id_max_saisie = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT MAX(devoir_id) FROM sacoche_saisie ' );
      $devoir_id_max = max( $devoir_id_max_devoir , $devoir_id_max_saisie );
      if($devoir_id_max)
      {
        $tab_tables = array( 'sacoche_devoir' , 'sacoche_jointure_devoir_item' , 'sacoche_jointure_devoir_prof' , 'sacoche_jointure_devoir_eleve' );
        foreach( $tab_tables as $table )
        {
          DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE '.$table.' SET devoir_id=devoir_id+'.$devoir_id_max );
        }
        // Pour les saisies c'est plus embêtant, leur date a pu être actualisée, on ne peut pas s'y fier, alors on restreint aux prof et items concernés.
        $DB_TAB = DB::queryTab(SACOCHE_STRUCTURE_BD_NAME , 'SELECT devoir_id, proprio_id FROM sacoche_devoir' );
        foreach($DB_TAB as $DB_ROW)
        {
          $devoir_id_new = (int)$DB_ROW['devoir_id'];
          $prof_id       = (int)$DB_ROW['proprio_id'];
          $items = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT GROUP_CONCAT(item_id) FROM sacoche_jointure_devoir_item WHERE devoir_id='.$devoir_id_new );
          if($items)
          {
            DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_saisie SET devoir_id='.$devoir_id_new.' WHERE devoir_id='.($devoir_id_new-$devoir_id_max).' AND item_id IN('.$items.') AND prof_id='.$prof_id );
          }
        }
        // Il reste le problème d'infos associées aux saisies qui ont été modifiées : saisie_date ; saisie_visible_date ; saisie_info
        // Pas d'autre solution pour ces cas là que de faire des REPLACE INTO à partir d'un extrait d'une sauvegarde antérieure au problème...
      }
    }
    // ajout de paramètres pour logguer l'existence du bug, même partiellement corrigé
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'INSERT INTO sacoche_parametre VALUES ("log_bug_2018_may_purge_date"   , "'.$date_bug_mysql.'")' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'INSERT INTO sacoche_parametre VALUES ("log_bug_2018_may_id_increment" , "'.$devoir_id_max.'")' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'INSERT INTO sacoche_parametre VALUES ("log_bug_2018_may_restore_date" , "")' ); // à renseigner si restauration ultérieure d'une svg à une date donnée
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-05-17 => 2018-05-25
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-05-17')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-05-25';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // augmentation de longueur du champ avec hash du mdp
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_user CHANGE user_password user_password VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "Hashage avec un salage aléatoire." ');
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-05-25 => 2018-05-28
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-05-25')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-05-28';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout d'un paramètre dans sacoche_officiel_configuration
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_configuration SET configuration_contenu = REPLACE( configuration_contenu , "\\"cycle_import_synthese_periode\\"" , "\\"cycle_stop_recalcul_step\\":6,\\"cycle_import_synthese_periode\\"" ) WHERE officiel_type="livret" ' );
    // il faut aussi mettre à jour les archives des bilans officiels
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"CYCLE_IMPORT_SYNTHESE_PERIODE\\"" , "\\"CYCLE_STOP_RECALCUL_STEP\\":6,\\"CYCLE_IMPORT_SYNTHESE_PERIODE\\"" ) WHERE archive_ref="livret" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-05-28 => 2018-06-15
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-05-28')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-06-15';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modif colonne de la table [sacoche_livret_export]
    if(empty($reload_sacoche_livret_export))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_livret_export CHANGE export_contenu export_contenu MEDIUMTEXT COLLATE utf8_unicode_ci DEFAULT NULL ' );
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-06-15 => 2018-06-18
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-06-15')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-06-18';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // nouvelle table [sacoche_acces_historique]
    $reload_sacoche_acces_historique = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_acces_historique.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2018-06-18 => 2018-06-27
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2018-06-18')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2018-06-27';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // Présence sur 2 bases de bilans archivés de cycle curieux avec jointure_periode qui vaut 0 au lieu de "" ce qui cause des doublons à l'export.
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DELETE FROM sacoche_livret_export WHERE jointure_periode="0" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// NE PAS OUBLIER de modifier aussi le nécessaire dans ./_sql/structure/ en fonction des évolutions !!!
// ////////////////////////////////////////////////////////////////////////////////////////////////////

// ///////////////////////////////////////////////////////////////////////////////////////////////////////
// NE PAS OUBLIER de maj les 2 tables de la base sacoche_projet en cas modif de matières ou de niveaux !!!
// ///////////////////////////////////////////////////////////////////////////////////////////////////////

?>
