<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2018
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d'Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}
if($_SESSION['SESAMATH_ID']==ID_DEMO){Json::end( FALSE , 'Action désactivée pour la démo.' );}

$action    = (isset($_POST['f_action']))    ? Clean::texte($_POST['f_action'])    : '';
$catalogue = (isset($_POST['f_catalogue'])) ? Clean::texte($_POST['f_catalogue']) : '';

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Retourner les options (formulaire select) d'un catalogue d'appréciations
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($action=='recuperer_options')
{
  $tab_catalogue_user = DB_STRUCTURE_CATALOGUE::DB_OPT_lister_appreciations($_SESSION['USER_ID']);
  $options_catalogue_user = empty($tab_catalogue_user) ? '<option value="0" disabled>Aucune appréciation ne figure dans votre catalogue.</option>' : HtmlForm::afficher_select( $tab_catalogue_user , '' /*select_nom*/ , '' /*option_first*/ , FALSE /*selection*/ , 'appr_categorie' /*optgroup*/ ) ;
  Json::end( TRUE , $options_catalogue_user );
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Enregistrer catégories et appréciations
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($action=='enregistrer')
{
  // Besoin de retourner les nouveaux identifiants éventuels
  $tab_retour = array();
  $is_new_id = FALSE;
  // On récupère le contenu de la base afin de la comparer à l'existant
  $tab_categories_bdd    = array();
  $tab_appreciations_bdd = array();
  $DB_TAB = DB_STRUCTURE_CATALOGUE::DB_lister_appreciations_avec_categories($_SESSION['USER_ID']);
  if(!empty($DB_TAB))
  {
    $categorie_id = 0;
    foreach($DB_TAB as $DB_ROW)
    {
      if($DB_ROW['categorie_id']!=$categorie_id)
      {
        $tab_categories_bdd[$DB_ROW['categorie_id']] = array(
          'ordre'   => $DB_ROW['categorie_ordre'],
          'contenu' => $DB_ROW['categorie_titre'],
        );
        $categorie_id = $DB_ROW['categorie_id'];
      }
      if(!empty($DB_ROW['appreciation_id']))
      {
        $tab_appreciations_bdd[$DB_ROW['appreciation_id']] = array(
          'cat_id'  => $DB_ROW['categorie_id'],
          'ordre'   => $DB_ROW['appreciation_ordre'],
          'contenu' => $DB_ROW['appreciation_contenu'],
        );
      }
    }
  }
  // On récupère ce qui est transmis ; au passage on ajoute les nouveaux éléments et on modifie ceux qui le nécessitent
  if(!empty($catalogue))
  {
    $tab_catalogue = explode('}¤{',$catalogue);
    if( substr($tab_catalogue[0],0,3) == 'app' )
    {
      // Catégorie par défaut si appréciations sans catégorie
      array_unshift( $tab_catalogue , 'cat_0'.']¤['.'Catégorie par défaut' );
    }
    $categorie_ordre = 0;
    foreach($tab_catalogue as $data)
    {
      list($ref,$contenu) = explode(']¤[',$data);
      list($objet,$id) = explode('_',$ref);
      if($objet=='cat')
      {
        $categorie_ordre++;
        $appreciation_ordre = 0;
        if(!$id)
        {
          $categorie_id = DB_STRUCTURE_CATALOGUE::DB_ajouter_categorie( $_SESSION['USER_ID'] , $categorie_ordre , $contenu );
          $is_new_id = TRUE;
        }
        else
        {
          $categorie_id = $id;
          if( !isset($tab_categories_bdd[$categorie_id]) )
          {
            Json::end( FALSE , 'Erreur catégorie n°'.$categorie_id.' introuvable !' );
          }
          $info_bdd = $tab_categories_bdd[$categorie_id];
          if( ($info_bdd['ordre']!=$categorie_ordre) || ($info_bdd['contenu']!=$contenu) )
          {
            DB_STRUCTURE_CATALOGUE::DB_modifier_categorie( $categorie_id , $_SESSION['USER_ID'] , $categorie_ordre , $contenu );
          }
          unset($tab_categories_bdd[$categorie_id]);
        }
        $tab_retour[] = '<li id="cat_'.$categorie_id.'"><span class="b u">'.html($contenu).'</span>{{QC}}</li>';
      }
      else
      {
        $appreciation_ordre++;
        if(!$id)
        {
          $appreciation_id = DB_STRUCTURE_CATALOGUE::DB_ajouter_appreciation( $_SESSION['USER_ID'] , $categorie_id , $appreciation_ordre , $contenu ) ;
          $is_new_id = TRUE;
        }
        else
        {
          $appreciation_id = $id;
          if( !isset($tab_appreciations_bdd[$appreciation_id]) )
          {
            Json::end( FALSE , 'Erreur appréciation n°'.$appreciation_id.' introuvable !' );
          }
          $info_bdd = $tab_appreciations_bdd[$appreciation_id];
          if( ($info_bdd['cat_id']!=$categorie_id) || ($info_bdd['ordre']!=$appreciation_ordre) || ($info_bdd['contenu']!=$contenu) )
          {
            DB_STRUCTURE_CATALOGUE::DB_modifier_appreciation( $appreciation_id , $_SESSION['USER_ID'] , $categorie_id , $appreciation_ordre , $contenu );
          }
          unset($tab_appreciations_bdd[$appreciation_id]);
        }
        $tab_retour[] = '<li id="app_'.$appreciation_id.'"><span>'.html($contenu).'</span>{{QA}}</li>';
      }
    }
  }
  // Il reste à supprimer ce qui reste
  foreach($tab_categories_bdd as $categorie_id => $tab)
  {
    DB_STRUCTURE_CATALOGUE::DB_supprimer_categorie( $categorie_id );
  }
  foreach($tab_appreciations_bdd as $appreciation_id => $tab)
  {
    DB_STRUCTURE_CATALOGUE::DB_supprimer_appreciation( $appreciation_id );
  }
  // Terminé !
  $retour = ($is_new_id) ? implode('',$tab_retour) : NULL ;
  Json::end( TRUE , $retour );
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// On ne devrait pas en arriver là...
// ////////////////////////////////////////////////////////////////////////////////////////////////////

Json::end( FALSE , 'Erreur avec les données transmises !' );

?>
