<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2018
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d'Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}
if($_SESSION['SESAMATH_ID']==ID_DEMO) {Json::end( FALSE , 'Action désactivée pour la démo.' );}

$action = (isset($_POST['f_action'])) ? Clean::texte($_POST['f_action']) : '';
$profil = isset($_POST['f_profil'])   ? Clean::code($_POST['f_profil'])  : '';

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Enregistrer les menu et favori pour cet utilisateur (si tout est décoché alors rien n'est transmis)
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if( ($action=='enregistrer') && ( $profil == $_SESSION['USER_PROFIL_TYPE'] ) )
{

  $tab_memo_menu   = array() ;
  $tab_memo_favori = array() ;

  // récupère $tab_menu & $tab_sous_menu
  require(CHEMIN_DOSSIER_MENUS.'menu_'.$profil.'.php');

  foreach($tab_menu as $menu_id => $menu_titre)
  {
    if( !isset($_POST['menu_'.$menu_id]) )
    {
       $tab_memo_menu[] = $menu_id;
    }
    else
    {
      foreach($tab_sous_menu[$menu_id] as $sous_menu_id => $tab)
      {
        if( !isset($_POST['sousmenu_'.$sous_menu_id]) )
        {
           $tab_memo_menu[] = $sous_menu_id;
        }
        if( isset($_POST['favori_'.$sous_menu_id]) )
        {
           $tab_memo_favori[] = $sous_menu_id;
        }
      }
    }
  }
  $user_param_menu   = implode(',',$tab_memo_menu);
  $user_param_favori = implode(',',$tab_memo_favori);

}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Revenir aux réglages des administrateurs
// ////////////////////////////////////////////////////////////////////////////////////////////////////

else if($action=='annuler')
{
  $user_param_menu   = NULL;
  $user_param_favori = NULL;
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// On ne devrait pas en arriver là...
// ////////////////////////////////////////////////////////////////////////////////////////////////////

else
{
  Json::end( FALSE , 'Erreur avec les données transmises !' );
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Mettre à jour la session & Retour
// ////////////////////////////////////////////////////////////////////////////////////////////////////

// Mettre à jour la session
Session::_set('USER_PARAM_MENU'   , $user_param_menu );
Session::_set('USER_PARAM_FAVORI' , $user_param_favori );
SessionUser::memoriser_menu();

DB_STRUCTURE_COMMUN::DB_modifier_user_parametre( $_SESSION['USER_ID'] , 'user_param_menu'   , $_SESSION['USER_PARAM_MENU']   );
DB_STRUCTURE_COMMUN::DB_modifier_user_parametre( $_SESSION['USER_ID'] , 'user_param_favori' , $_SESSION['USER_PARAM_FAVORI'] );

// Retour
Json::end( TRUE );

?>