
CREATE DATABASE `sacoche` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;
grant all on sacoche.* to 'sacoche'@'%%adresse_ip_web' identified by 'sacoche';
flush privileges ;

USE `sacoche`;



-- phpMyAdmin SQL Dump
-- version 4.0.10deb1
-- http://www.phpmyadmin.net
--
-- Client: localhost
-- Généré le: Jeu 06 Octobre 2016 à 15:41
-- Version du serveur: 5.5.52-0ubuntu0.14.04.1
-- Version de PHP: 5.5.9-1ubuntu4.20

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Base de données: `sacoche`
--

DELIMITER $$
--
-- Procédures
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `AddAdminSacoche`(_adminuser VARCHAR( 32 ))
BEGIN
    DECLARE ad_id INT DEFAULT 0;
    DECLARE out_param INT DEFAULT 0;

    SELECT COUNT(*) INTO ad_id FROM sacoche_user WHERE user_login=_adminuser COLLATE utf8_unicode_ci;

    IF ad_id = 0 THEN
        INSERT INTO `sacoche_user` (`user_sconet_id`, `user_sconet_elenoet`, `user_reference`, `user_profil_sigle`, `user_genre`, `user_nom`, `user_prenom`, `user_naissance_date`, `user_email`, `user_email_origine`, `user_login`, `user_password`, `user_langue`, `user_daltonisme`, `user_connexion_date`, `user_sortie_date`, `eleve_classe_id`, `eleve_langue`, `eleve_brevet_serie`, `user_id_ent`, `user_id_gepi`, `user_param_accueil`, `user_pass_key`) VALUES
		(0, 0, '', 'ADM', 'I', 'Envole', 'Admin', NULL, '', 'admin', _adminuser, '', '', 0, '', '9999-12-31', 0, 100, 'X', _adminuser, '', 'user,alert,messages,resultats,faiblesses,reussites,demandes,saisies,officiel,socle,help,ecolo', '');
    END IF;

    UPDATE sacoche_user SET user_profil_sigle = 'ADM' WHERE user_login = _adminuser COLLATE utf8_unicode_ci;

END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_abonnement`
--

CREATE TABLE IF NOT EXISTS `sacoche_abonnement` (
  `abonnement_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `abonnement_obligatoire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Visibilité obligatoire ou au choix de l''utilisateur.',
  `abonnement_courriel_only` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Abonnement obligatoire par courriel ou indication possible en page d''accueil.',
  `abonnement_profils` varchar(63) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `abonnement_objet` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `abonnement_descriptif` varchar(70) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`abonnement_ref`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='En cas d''abonnement d''un utilisateur (sacoche_jointure_user_abonnement), les notifications sont dans la table sacoche_notification.';

--
-- Contenu de la table `sacoche_abonnement`
--

INSERT INTO `sacoche_abonnement` (`abonnement_ref`, `abonnement_obligatoire`, `abonnement_courriel_only`, `abonnement_profils`, `abonnement_objet`, `abonnement_descriptif`) VALUES
('message_accueil', 0, 1, 'professeur,directeur,parent,eleve', 'Message d''accueil', 'Message d''accueil nouveau ou modifié.'),
('fiche_brevet_statut', 0, 0, 'professeur,directeur', 'Fiche brevet, étape de saisie', 'Ouverture d''étape de saisie d''une fiche brevet.'),
('bilan_officiel_statut', 0, 0, 'professeur,directeur', 'Bilan officiel, étape de saisie', 'Ouverture d''étape de saisie d''un bilan officiel.'),
('bilan_officiel_appreciation', 1, 0, 'professeur,directeur', 'Bilan officiel, erreur appréciation', 'Signalement d''un souci pour une appréciation d''un bilan officiel.'),
('referentiel_edition', 0, 0, 'professeur', 'Modification de référentiel', 'Modification de référentiel (y compris import / suppression).'),
('demande_evaluation_eleve', 0, 1, 'professeur', 'Demande d''évaluation formulée', 'Demande d''évaluation formulée ou retirée.'),
('devoir_autoevaluation_eleve', 0, 0, 'professeur', 'Auto-évaluation effectuée', 'Auto-évaluation effectuée par un élève.'),
('devoir_prof_partage', 0, 0, 'professeur', 'Devoir partagé', 'Partage d''un devoir par un collègue.'),
('devoir_edition', 0, 0, 'parent,eleve', 'Devoir préparé', 'Création ou modification d''un devoir.'),
('devoir_saisie', 0, 0, 'parent,eleve', 'Saisie de résultats', 'Saisie de notes ou de commentaires d''une évaluation.'),
('demande_evaluation_prof', 0, 1, 'eleve', 'Demande d''évaluation traitée', 'Demande d''évaluation traitée (préparation d''un devoir ou rejet).'),
('bilan_officiel_visible', 0, 1, 'parent,eleve', 'Bilan officiel disponible', 'Bilan officiel disponible au format PDF.'),
('action_sensible', 0, 0, 'administrateur', 'Action sensible effectuée', 'Action sensible effectuée par un enseignant.'),
('action_admin', 0, 0, 'administrateur', 'Action d''administration', 'Action effectuée par un autre administrateur.'),
('contact_externe', 1, 0, 'administrateur', 'Contact externe', 'Contact effectué depuis la page d''authentification');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_brevet_epreuve`
--

CREATE TABLE IF NOT EXISTS `sacoche_brevet_epreuve` (
  `brevet_serie_ref` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Série du brevet.',
  `brevet_epreuve_code` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Code de l''épreuve.',
  `brevet_epreuve_nom` varchar(127) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Nom de l''épreuve.',
  `brevet_epreuve_obligatoire` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Épreuve obligatoire ou facultative.',
  `brevet_epreuve_note_chiffree` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Épreuve avec notre chiffrée.',
  `brevet_epreuve_point_sup_10` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Épreuve avec prise en compte des seuls points supérieurs à la moyenne.',
  `brevet_epreuve_note_comptee` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Épreuve comptabilisée dans le total des points.',
  `brevet_epreuve_coefficient` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Coef 1 ou 2 ou 3 pour une note sur 20 ou 40 ou 60.',
  `brevet_epreuve_code_speciaux` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'AB' COMMENT 'Liste des codes spéciaux autorisés à la saisie.',
  `brevet_epreuve_matieres_cibles` varchar(127) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Liste des matiere_id proposés par défaut pour le rapprochement.',
  `brevet_epreuve_choix_recherche` tinyint(1) unsigned DEFAULT NULL COMMENT '1 = utiliser en priorité les moyennes des bulletins ; 0 = utiliser la moyenne annuelle des acquisitions ;  NULL = non paramétré',
  `brevet_epreuve_choix_moyenne` tinyint(1) unsigned DEFAULT NULL COMMENT '1 = utiliser la moyenne du premier référentiel trouvé ; 0 = utiliser la moyenne de tous les référentiels trouvés ;  NULL = non paramétré',
  `brevet_epreuve_choix_matieres` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Liste des matiere_id à examiner ; NULL = non paramétré.',
  PRIMARY KEY (`brevet_serie_ref`,`brevet_epreuve_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_brevet_epreuve`
--

INSERT INTO `sacoche_brevet_epreuve` (`brevet_serie_ref`, `brevet_epreuve_code`, `brevet_epreuve_nom`, `brevet_epreuve_obligatoire`, `brevet_epreuve_note_chiffree`, `brevet_epreuve_point_sup_10`, `brevet_epreuve_note_comptee`, `brevet_epreuve_coefficient`, `brevet_epreuve_code_speciaux`, `brevet_epreuve_matieres_cibles`, `brevet_epreuve_choix_recherche`, `brevet_epreuve_choix_moyenne`, `brevet_epreuve_choix_matieres`) VALUES
('G', 101, 'Français', 1, 1, 0, 1, 1, 'AB', '207,6920', NULL, 1, NULL),
('G', 102, 'Mathématiques', 1, 1, 0, 1, 1, 'AB', '613,6930', NULL, 1, NULL),
('G', 103, 'Première langue vivante', 1, 1, 0, 1, 1, 'AB,DI', '315,316,317,318,319,320,321,322,323,324,325,326', NULL, 1, NULL),
('G', 104, 'Sciences de la vie et de la terre', 1, 1, 0, 1, 1, 'AB,DI', '629,6946', NULL, 1, NULL),
('G', 105, 'Physique-chimie', 1, 1, 0, 1, 1, 'AB,DI', '623,6936', NULL, 1, NULL),
('G', 106, 'Éducation physique et sportive', 1, 1, 0, 1, 1, 'AB,DI', '1001,6914', NULL, 1, NULL),
('G', 107, 'Arts plastiques', 1, 1, 0, 1, 1, 'AB,DI', '901', NULL, 1, NULL),
('G', 108, 'Éducation musicale', 1, 1, 0, 1, 1, 'AB,DI', '813', NULL, 1, NULL),
('G', 109, 'Technologie', 1, 1, 0, 1, 1, 'AB,DI', '708,738', NULL, 1, NULL),
('G', 110, 'Deuxième langue vivante', 1, 1, 0, 1, 1, 'AB,DI', '327,328,329,330,331,332,333,334,335,336,337,338', NULL, 1, NULL),
('G', 113, 'Option facultative', 0, 1, 1, 1, 1, 'AB,DI', '201,6929,202,6923,50,51,74,399,230', NULL, 1, NULL),
('G', 121, 'Histoire-géographie', 1, 1, 0, 0, 1, 'AB', '406,6926,421', NULL, 1, NULL),
('G', 122, 'Enseignement moral et civique', 1, 1, 0, 0, 1, 'AB', '438,414,406,6926,421,6925', NULL, 1, NULL),
('G', 130, 'Niveau A2 de langue régionale', 0, 0, 0, 1, 0, 'AB,VA,NV', '230,399', NULL, 1, NULL),
('P', 101, 'Français', 1, 1, 0, 1, 1, 'AB', '207,6920', NULL, 1, NULL),
('P', 102, 'Mathématiques', 1, 1, 0, 1, 1, 'AB', '613,6930', NULL, 1, NULL),
('P', 103, 'Langues vivantes', 1, 1, 0, 1, 1, 'AB,DI', '315,316,317,318,319,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338', NULL, 0, NULL),
('P', 105, 'Prévention santé environnement', 1, 1, 0, 1, 1, 'AB,DI', '3128,6939', NULL, 1, NULL),
('P', 106, 'Éducation physique et sportive', 1, 1, 0, 1, 1, 'AB,DI', '1001,6914', NULL, 1, NULL),
('P', 107, 'Éducation artistique', 1, 1, 0, 1, 1, 'AB,DI', '905', NULL, 0, NULL),
('P', 108, 'Sciences et technologie', 1, 1, 0, 1, 2, 'AB,DI', '708,738', NULL, 0, NULL),
('P', 110, 'Découverte professionnelle', 1, 1, 0, 1, 3, 'AB,DI', '50,51,74', NULL, 1, NULL),
('P', 121, 'Histoire-géographie Enseignement moral et civique', 1, 1, 0, 0, 1, 'AB', '438,421,6925,406,6926,414', NULL, 0, NULL),
('P', 130, 'Niveau A2 de langue régionale', 0, 0, 0, 1, 0, 'AB,VA,NV', '230,399', NULL, 1, NULL),
('P-Agri', 101, 'Français', 1, 1, 0, 1, 1, 'AB', '207,6920', NULL, 1, NULL),
('P-Agri', 102, 'Mathématiques', 1, 1, 0, 1, 1, 'AB', '613,6930', NULL, 1, NULL),
('P-Agri', 103, 'Première langue vivante', 1, 1, 0, 1, 1, 'AB,DI', '315,316,317,318,319,320,321,322,323,324,325,326', NULL, 1, NULL),
('P-Agri', 105, 'Prévention santé environnement', 1, 1, 0, 1, 1, 'AB,DI', '3128,6939', NULL, 1, NULL),
('P-Agri', 106, 'Éducation physique et sportive', 1, 1, 0, 1, 1, 'AB,DI', '1001,6914', NULL, 1, NULL),
('P-Agri', 107, 'Éducation socioculturelle', 1, 1, 0, 1, 1, 'AB,DI', '5,6919', NULL, 1, NULL),
('P-Agri', 109, 'Technologie, sciences et découverte de la vie professionnelle et des métiers', 1, 1, 0, 1, 3, 'AB,DI', '708,738', NULL, 0, NULL),
('P-Agri', 121, 'Histoire-géographie Enseignement moral et civique', 1, 1, 0, 0, 1, 'AB', '438,421,6925,406,6926,414', NULL, 0, NULL),
('P-Agri', 130, 'Niveau A2 de langue régionale', 0, 0, 0, 1, 0, 'AB,VA,NV', '230,399', NULL, 1, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_brevet_fichier`
--

CREATE TABLE IF NOT EXISTS `sacoche_brevet_fichier` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fichier_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_brevet_saisie`
--

CREATE TABLE IF NOT EXISTS `sacoche_brevet_saisie` (
  `brevet_serie_ref` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Série du brevet.',
  `brevet_epreuve_code` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Code de l''épreuve ; 255 pour le total des points et l''appréciation du conseil de classe.',
  `eleve_ou_classe_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'id élève ou classe suivant le champ saisie_type',
  `saisie_type` enum('eleve','classe') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'eleve' COMMENT 'indique si la saisie concerne un élève ou une classe',
  `prof_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'dernier auteur de l''appréciation',
  `matieres_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Liste des matiere_id finalement retenus pour extraire la note, et donc des profs qui auront accès à l''appréciation.',
  `saisie_note` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'note épreuve sur 20 arrondi à 0.5, ou total des points, ou code spécial',
  `saisie_appreciation` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'appréciation, unique par épreuve, ou avis du conseil de classe si brevet_epreuve_code=255',
  PRIMARY KEY (`brevet_serie_ref`,`brevet_epreuve_code`,`eleve_ou_classe_id`,`saisie_type`),
  KEY `brevet_epreuve_code` (`brevet_epreuve_code`),
  KEY `eleve_ou_classe_id` (`eleve_ou_classe_id`),
  KEY `saisie_type` (`saisie_type`),
  KEY `prof_id` (`prof_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_brevet_serie`
--

CREATE TABLE IF NOT EXISTS `sacoche_brevet_serie` (
  `brevet_serie_ref` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'X' COMMENT 'Série du brevet pour Notanet ( G = générale ; P = professionnelle ; options éventuelles LV2 DP6 AGRI ).',
  `brevet_serie_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `brevet_serie_nom` varchar(63) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`brevet_serie_ref`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_brevet_serie`
--

INSERT INTO `sacoche_brevet_serie` (`brevet_serie_ref`, `brevet_serie_ordre`, `brevet_serie_nom`) VALUES
('X', 1, 'Série indéterminée'),
('G', 2, 'Série Générale'),
('P', 3, 'Série Professionnelle, sans option'),
('P-Agri', 4, 'Série Professionnelle, option Agricole');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_demande`
--

CREATE TABLE IF NOT EXISTS `sacoche_demande` (
  `demande_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `eleve_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `matiere_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `item_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `prof_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'Dans le cas où l''élève adresse sa demande à un prof donné.',
  `demande_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `demande_score` tinyint(3) unsigned DEFAULT NULL COMMENT 'Sert à mémoriser le score avant réévaluation pour ne pas avoir à le recalculer ; valeur null si item non évalué.',
  `demande_statut` enum('eleve','prof') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'eleve' COMMENT '[eleve] pour une demande d''élève ; [prof] pour une prévision d''évaluation par le prof ; une annulation de l''élève ou du prof efface l''enregistrement',
  `demande_messages` text COLLATE utf8_unicode_ci NOT NULL,
  `demande_doc` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`demande_id`),
  UNIQUE KEY `demande_key` (`eleve_id`,`matiere_id`,`item_id`),
  KEY `matiere_id` (`matiere_id`),
  KEY `item_id` (`item_id`),
  KEY `prof_id` (`prof_id`),
  KEY `demande_statut` (`demande_statut`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_devoir`
--

CREATE TABLE IF NOT EXISTS `sacoche_devoir` (
  `devoir_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `proprio_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `groupe_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `devoir_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `devoir_info` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `devoir_visible_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `devoir_autoeval_date` date DEFAULT NULL,
  `devoir_doc_sujet` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `devoir_doc_corrige` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `devoir_fini` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `devoir_eleves_ordre` enum('alpha','classe') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'alpha',
  PRIMARY KEY (`devoir_id`),
  KEY `proprio_id` (`proprio_id`),
  KEY `groupe_id` (`groupe_id`),
  KEY `devoir_date` (`devoir_date`),
  KEY `devoir_visible_date` (`devoir_visible_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_geo_academie`
--

CREATE TABLE IF NOT EXISTS `sacoche_geo_academie` (
  `geo_academie_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `geo_academie_nom` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`geo_academie_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_geo_academie`
--

INSERT INTO `sacoche_geo_academie` (`geo_academie_id`, `geo_academie_nom`) VALUES
(1, 'Paris'),
(2, 'Aix-Marseille'),
(3, 'Besançon'),
(4, 'Bordeaux'),
(5, 'Caen'),
(6, 'Clermont-Ferrand'),
(7, 'Dijon'),
(8, 'Grenoble'),
(9, 'Lille'),
(10, 'Lyon'),
(11, 'Montpellier'),
(12, 'Nancy-Metz'),
(13, 'Poitiers'),
(14, 'Rennes'),
(15, 'Strasbourg'),
(16, 'Toulouse'),
(17, 'Nantes'),
(18, 'Orléans-Tours'),
(19, 'Reims'),
(20, 'Amiens'),
(21, 'Rouen'),
(22, 'Limoges'),
(23, 'Nice'),
(24, 'Créteil'),
(25, 'Versailles'),
(27, 'Corse'),
(28, 'Réunion'),
(31, 'Martinique'),
(32, 'Guadeloupe'),
(33, 'Guyane'),
(40, 'Nouvelle-Calédonie'),
(41, 'Polynésie Française'),
(42, 'Wallis-et-Futuna'),
(43, 'Mayotte'),
(44, 'St-Pierre-et-Miquelon'),
(99, 'Sans objet');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_geo_departement`
--

CREATE TABLE IF NOT EXISTS `sacoche_geo_departement` (
  `geo_departement_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `geo_academie_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `geo_departement_numero` char(4) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `geo_departement_nom` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`geo_departement_id`),
  KEY `geo_academie_id` (`geo_academie_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_geo_departement`
--

INSERT INTO `sacoche_geo_departement` (`geo_departement_id`, `geo_academie_id`, `geo_departement_numero`, `geo_departement_nom`) VALUES
(0, 99, '', 'Sans Objet'),
(1, 10, ' 01', 'Ain'),
(2, 20, ' 02', 'Aisne'),
(3, 6, ' 03', 'Allier'),
(4, 2, ' 04', 'Alpes-de-Haute-Provence'),
(5, 2, ' 05', 'Hautes-Alpes'),
(6, 23, ' 06', 'Alpes-Maritimes'),
(7, 8, ' 07', 'Ardèche'),
(8, 19, ' 08', 'Ardennes'),
(9, 16, ' 09', 'Ariège'),
(10, 19, ' 10', 'Aube'),
(11, 11, ' 11', 'Aude'),
(12, 16, ' 12', 'Aveyron'),
(13, 2, ' 13', 'Bouches-du-Rhône'),
(14, 5, ' 14', 'Calvados'),
(15, 6, ' 15', 'Cantal'),
(16, 13, ' 16', 'Charente'),
(17, 13, ' 17', 'Charente-Maritime'),
(18, 18, ' 18', 'Cher'),
(19, 22, ' 19', 'Corrèze'),
(21, 7, ' 21', 'Côte-d''Or'),
(22, 14, ' 22', 'Côtes-d''Armor'),
(23, 22, ' 23', 'Creuse'),
(24, 4, ' 24', 'Dordogne'),
(25, 3, ' 25', 'Doubs'),
(26, 8, ' 26', 'Drôme'),
(27, 21, ' 27', 'Eure'),
(28, 18, ' 28', 'Eure-et-Loir'),
(29, 14, ' 29', 'Finistère'),
(30, 11, ' 30', 'Gard'),
(31, 16, ' 31', 'Haute-Garonne'),
(32, 16, ' 32', 'Gers'),
(33, 4, ' 33', 'Gironde'),
(34, 11, ' 34', 'Hérault'),
(35, 14, ' 35', 'Ille-et-Vilaine'),
(36, 18, ' 36', 'Indre'),
(37, 18, ' 37', 'Indre-et-Loire'),
(38, 8, ' 38', 'Isère'),
(39, 3, ' 39', 'Jura'),
(40, 4, ' 40', 'Landes'),
(41, 18, ' 41', 'Loir-et-Cher'),
(42, 10, ' 42', 'Loire'),
(43, 6, ' 43', 'Haute-Loire'),
(44, 17, ' 44', 'Loire-Atlantique'),
(45, 18, ' 45', 'Loiret'),
(46, 16, ' 46', 'Lot'),
(47, 4, ' 47', 'Lot-et-Garonne'),
(48, 11, ' 48', 'Lozère'),
(49, 17, ' 49', 'Maine-et-Loire'),
(50, 5, ' 50', 'Manche'),
(51, 19, ' 51', 'Marne'),
(52, 19, ' 52', 'Haute-Marne'),
(53, 17, ' 53', 'Mayenne'),
(54, 12, ' 54', 'Meurthe-et-Moselle'),
(55, 12, ' 55', 'Meuse'),
(56, 14, ' 56', 'Morbihan'),
(57, 12, ' 57', 'Moselle'),
(58, 7, ' 58', 'Nièvre'),
(59, 9, ' 59', 'Nord'),
(60, 20, ' 60', 'Oise'),
(61, 5, ' 61', 'Orne'),
(62, 9, ' 62', 'Pas-de-Calais'),
(63, 6, ' 63', 'Puy-de-Dôme'),
(64, 4, ' 64', 'Pyrénées-Atlantiques'),
(65, 16, ' 65', 'Hautes-Pyrénées'),
(66, 11, ' 66', 'Pyrénées-Orientales'),
(67, 15, ' 67', 'Bas-Rhin'),
(68, 15, ' 68', 'Haut-Rhin'),
(69, 10, ' 69', 'Rhône'),
(70, 3, ' 70', 'Haute-Saône'),
(71, 7, ' 71', 'Saône-et-Loire'),
(72, 17, ' 72', 'Sarthe'),
(73, 8, ' 73', 'Savoie'),
(74, 8, ' 74', 'Haute-Savoie'),
(75, 1, ' 75', 'Paris'),
(76, 21, ' 76', 'Seine-Maritime'),
(77, 24, ' 77', 'Seine-et-Marne'),
(78, 25, ' 78', 'Yvelines'),
(79, 13, ' 79', 'Deux-Sèvres'),
(80, 20, ' 80', 'Somme'),
(81, 16, ' 81', 'Tarn'),
(82, 16, ' 82', 'Tarn-et-Garonne'),
(83, 23, ' 83', 'Var'),
(84, 2, ' 84', 'Vaucluse'),
(85, 17, ' 85', 'Vendée'),
(86, 13, ' 86', 'Vienne'),
(87, 22, ' 87', 'Haute-Vienne'),
(88, 12, ' 88', 'Vosges'),
(89, 7, ' 89', 'Yonne'),
(90, 3, ' 90', 'Territoire de Belfort'),
(91, 25, ' 91', 'Essonne'),
(92, 25, ' 92', 'Hauts-de-Seine'),
(93, 24, ' 93', 'Seine-Saint-Denis'),
(94, 24, ' 94', 'Val-de-Marne'),
(95, 25, ' 95', 'Val-d''Oise'),
(620, 27, ' 20A', 'Corse-du-Sud'),
(720, 27, ' 20B', 'Haute-Corse'),
(971, 32, '971', 'Guadeloupe'),
(972, 31, '972', 'Martinique'),
(973, 33, '973', 'Guyane française'),
(974, 28, '974', 'La Réunion'),
(975, 44, '975', 'Saint-Pierre-et-Miquelon'),
(976, 43, '985', 'Mayotte'),
(983, 40, '988', 'Nouvelle-Calédonie'),
(984, 41, '987', 'Polynésie Française'),
(987, 42, '986', 'Wallis-et-Futuna'),
(989, 99, '984', 'Terres Australes, Antarctique Française');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_groupe`
--

CREATE TABLE IF NOT EXISTS `sacoche_groupe` (
  `groupe_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `groupe_type` enum('classe','groupe','besoin','eval') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'classe',
  `groupe_ref` char(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `groupe_nom` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `niveau_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fiche_brevet` enum('','1vide','2rubrique','3mixte','4synthese','5complet') COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`groupe_id`),
  KEY `niveau_id` (`niveau_id`),
  KEY `groupe_type` (`groupe_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_image`
--

CREATE TABLE IF NOT EXISTS `sacoche_image` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '0 pour le tampon de l''établissement (objet signature) ou le logo de l''établissement',
  `image_objet` enum('signature','photo','logo') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'photo',
  `image_contenu` mediumblob NOT NULL,
  `image_format` char(4) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `image_largeur` smallint(5) unsigned NOT NULL DEFAULT '0',
  `image_hauteur` smallint(5) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `user_id` (`user_id`,`image_objet`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Photos pour les élèves, signatures pour les professeurs et directeurs, logo pour l''établissement.';

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_image_note`
--

CREATE TABLE IF NOT EXISTS `sacoche_image_note` (
  `image_note_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `image_contenu_h` mediumblob NOT NULL,
  `image_contenu_v` mediumblob NOT NULL,
  PRIMARY KEY (`image_note_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_devoir_eleve`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_devoir_eleve` (
  `devoir_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `eleve_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `jointure_texte` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `jointure_audio` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`devoir_id`,`eleve_id`),
  KEY `eleve_id` (`eleve_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_devoir_item`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_devoir_item` (
  `devoir_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `item_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `jointure_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`devoir_id`,`item_id`),
  KEY `item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_devoir_prof`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_devoir_prof` (
  `devoir_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `prof_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `jointure_droit` enum('voir','saisir','modifier') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'saisir',
  PRIMARY KEY (`devoir_id`,`prof_id`),
  KEY `prof_id` (`prof_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_groupe_periode`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_groupe_periode` (
  `groupe_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `periode_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `jointure_date_debut` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `jointure_date_fin` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `officiel_releve` enum('','1vide','2rubrique','3mixte','4synthese','5complet') COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `officiel_bulletin` enum('','1vide','2rubrique','3mixte','4synthese','5complet') COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `officiel_palier1` enum('','1vide','2rubrique','3mixte','4synthese','5complet') COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `officiel_palier2` enum('','1vide','2rubrique','3mixte','4synthese','5complet') COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `officiel_palier3` enum('','1vide','2rubrique','3mixte','4synthese','5complet') COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`groupe_id`,`periode_id`),
  KEY `periode_id` (`periode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_message_destinataire`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_message_destinataire` (
  `message_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_profil_type` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `destinataire_type` enum('all','niveau','classe','groupe','besoin','user') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'user',
  `destinataire_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`message_id`,`user_profil_type`,`destinataire_type`,`destinataire_id`),
  KEY `destinataire` (`destinataire_type`,`destinataire_id`),
  KEY `message_id` (`message_id`),
  KEY `user_profil_type` (`user_profil_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_parent_eleve`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_parent_eleve` (
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `eleve_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `resp_legal_num` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`parent_id`,`eleve_id`),
  KEY `eleve_id` (`eleve_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_referentiel_socle`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_referentiel_socle` (
  `item_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `socle_cycle_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `socle_composante_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`,`socle_cycle_id`,`socle_composante_id`),
  KEY `item_id` (`item_id`),
  KEY `socle_cycle_id` (`socle_cycle_id`),
  KEY `socle_composante_id` (`socle_composante_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_selection_item`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_selection_item` (
  `selection_item_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `item_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`selection_item_id`,`item_id`),
  KEY `item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_selection_prof`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_selection_prof` (
  `selection_item_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `prof_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `jointure_droit` enum('voir','modifier') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'voir',
  PRIMARY KEY (`selection_item_id`,`prof_id`),
  KEY `prof_id` (`prof_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_user_abonnement`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_user_abonnement` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `abonnement_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `jointure_mode` enum('courriel','accueil') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'courriel',
  PRIMARY KEY (`user_id`,`abonnement_ref`),
  KEY `abonnement_ref` (`abonnement_ref`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_jointure_user_abonnement`
--

INSERT INTO `sacoche_jointure_user_abonnement` (`user_id`, `abonnement_ref`, `jointure_mode`) VALUES
(1, 'contact_externe', 'accueil');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_user_entree`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_user_entree` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `entree_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `validation_entree_etat` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1 si validation positive ; 0 si validation négative.',
  `validation_entree_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `validation_entree_info` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Enregistrement statique du nom du validateur, conservé les années suivantes.',
  PRIMARY KEY (`user_id`,`entree_id`),
  KEY `entree_id` (`entree_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_user_groupe`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_user_groupe` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `groupe_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `jointure_pp` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`groupe_id`),
  KEY `groupe_id` (`groupe_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_user_matiere`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_user_matiere` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `matiere_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `jointure_coord` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`matiere_id`),
  KEY `matiere_id` (`matiere_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_jointure_user_pilier`
--

CREATE TABLE IF NOT EXISTS `sacoche_jointure_user_pilier` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `pilier_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `validation_pilier_etat` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1 si validation positive ; 0 si validation négative.',
  `validation_pilier_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `validation_pilier_info` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Enregistrement statique du nom du validateur, conservé les années suivantes.',
  PRIMARY KEY (`user_id`,`pilier_id`),
  KEY `pilier_id` (`pilier_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_ap`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_ap` (
  `livret_ap_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `livret_page_ref` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `groupe_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `livret_ap_titre` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`livret_ap_id`),
  KEY `livret_page_ref` (`livret_page_ref`),
  KEY `groupe_id` (`groupe_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_colonne`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_colonne` (
  `livret_colonne_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `livret_colonne_type` varchar(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_colonne_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'De 1 à 3 ou 4.',
  `livret_colonne_titre` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_colonne_legende` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_colonne_seuil_defaut_min` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Entre 0 et 99 ; doit être cohérent avec l''ordre.',
  `livret_colonne_seuil_defaut_max` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Entre 1 et 100 ; doit être cohérent avec l''ordre.',
  `livret_colonne_couleur_1` char(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_colonne_couleur_2` char(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`livret_colonne_id`),
  UNIQUE KEY `livret_colonne_type` (`livret_colonne_type`,`livret_colonne_ordre`),
  KEY `livret_colonne_ordre` (`livret_colonne_ordre`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_livret_colonne`
--

INSERT INTO `sacoche_livret_colonne` (`livret_colonne_id`, `livret_colonne_type`, `livret_colonne_ordre`, `livret_colonne_titre`, `livret_colonne_legende`, `livret_colonne_seuil_defaut_min`, `livret_colonne_seuil_defaut_max`, `livret_colonne_couleur_1`, `livret_colonne_couleur_2`) VALUES
(11, 'reussite', 1, 'Réussite', 'ne réussit pas encore', 0, 30, '#c7e1f5', ''),
(12, 'reussite', 2, 'Réussite', 'est en voie de réussite', 31, 69, '#acd4f1', ''),
(13, 'reussite', 3, 'Réussite', 'réussit souvent', 70, 100, '#91c9ed', ''),
(21, 'objectif', 1, 'Objectifs d''apprentissage', 'Non atteints', 0, 34, '#e5f2fb', '#f2f8fd'),
(22, 'objectif', 2, 'Objectifs d''apprentissage', 'Partiellement atteints', 35, 64, '#cce5f7', '#d8ecf9'),
(23, 'objectif', 3, 'Objectifs d''apprentissage', 'Atteints', 65, 89, '#b3d9f4', '#bfdff6'),
(24, 'objectif', 4, 'Objectifs d''apprentissage', 'Dépassés', 90, 100, '#9acef0', '#a6d4f2'),
(31, 'maitrise', 1, 'Maîtrise des composantes du socle', 'Maîtrise insuffisante', 0, 34, '#e5f2fb', '#f2f8fd'),
(32, 'maitrise', 2, 'Maîtrise des composantes du socle', 'Maîtrise fragile', 35, 59, '#cce5f7', '#d8ecf9'),
(33, 'maitrise', 3, 'Maîtrise des composantes du socle', 'Maîtrise satisfaisante', 60, 81, '#b3d9f4', '#bfdff6'),
(34, 'maitrise', 4, 'Maîtrise des composantes du socle', 'Très bonne maîtrise', 81, 100, '#9acef0', '#a6d4f2'),
(41, 'position', 1, 'Échelle', '1 sur 4', 0, 24, '#dbe5f1', ''),
(42, 'position', 2, 'Échelle', '2 sur 4', 25, 49, '#8db3e2', ''),
(43, 'position', 3, 'Échelle', '3 sur 4', 50, 74, '#548dd4', ''),
(44, 'position', 4, 'Échelle', '4 sur 4', 75, 100, '#0070c0', ''),
(51, 'moyenne', 1, 'Moyenne', 'de l''élève', 0, 20, '', ''),
(52, 'moyenne', 2, 'Moyenne', 'de la classe', 0, 20, '', ''),
(61, 'pourcentage', 1, 'Pourcentage', 'de l''élève', 0, 100, '', ''),
(62, 'pourcentage', 2, 'Pourcentage', 'de la classe', 0, 100, '', '');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_epi`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_epi` (
  `livret_epi_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `livret_epi_theme_code` varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_page_ref` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `groupe_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `livret_epi_titre` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`livret_epi_id`),
  UNIQUE KEY `livret_epi` (`livret_epi_theme_code`,`livret_page_ref`,`groupe_id`),
  KEY `livret_page_ref` (`livret_page_ref`),
  KEY `groupe_id` (`groupe_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_epi_theme`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_epi_theme` (
  `livret_epi_theme_code` varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_epi_theme_nom` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`livret_epi_theme_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_livret_epi_theme`
--

INSERT INTO `sacoche_livret_epi_theme` (`livret_epi_theme_code`, `livret_epi_theme_nom`) VALUES
('EPI_SAN', 'Corps, santé, bien-être et sécurité'),
('EPI_ART', 'Culture et création artistiques'),
('EPI_EDD', 'Transition écologique et développement durable'),
('EPI_ICC', 'Information, communication, citoyenneté'),
('EPI_LGA', 'Langues et cultures de l''Antiquité'),
('EPI_LGE', 'Langues et cultures étrangères ou régionales'),
('EPI_PRO', 'Monde économique et professionnel'),
('EPI_STS', 'Sciences, technologie et société');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_jointure_ap_prof`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_jointure_ap_prof` (
  `livret_ap_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `matiere_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `prof_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`livret_ap_id`,`matiere_id`,`prof_id`),
  KEY `matiere_id` (`matiere_id`),
  KEY `prof_id` (`prof_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_jointure_epi_prof`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_jointure_epi_prof` (
  `livret_epi_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `matiere_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `prof_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`livret_epi_id`,`matiere_id`,`prof_id`),
  KEY `matiere_id` (`matiere_id`),
  KEY `prof_id` (`prof_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_jointure_groupe`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_jointure_groupe` (
  `groupe_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `livret_page_ref` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_page_periodicite` enum('periode','cycle','college') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'periode',
  `jointure_periode` enum('','T1','T2','T3','S1','S2') COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Renseigné si livret_page_periodicite = periode ; @see sacoche_periode.periode_livret',
  `jointure_etat` enum('1vide','2rubrique','3mixte','4synthese','5complet') COLLATE utf8_unicode_ci NOT NULL DEFAULT '1vide',
  PRIMARY KEY (`groupe_id`,`livret_page_ref`,`livret_page_periodicite`,`jointure_periode`),
  KEY `livret_page_ref` (`livret_page_ref`),
  KEY `livret_page_periodicite` (`livret_page_periodicite`),
  KEY `jointure_periode` (`jointure_periode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_jointure_modaccomp_eleve`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_jointure_modaccomp_eleve` (
  `livret_modaccomp_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `eleve_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `info_complement` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'Dans le cas où la modalité d''accompagnement est PPRE.',
  PRIMARY KEY (`livret_modaccomp_code`,`eleve_id`),
  KEY `eleve_id` (`eleve_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_jointure_referentiel`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_jointure_referentiel` (
  `livret_rubrique_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_rubrique_ou_matiere_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `element_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'matiere_id | domaine_id | theme_id | item_id | user_id ; la nature étant indiquée par sacoche_livret_page.livret_page_rubrique_join',
  PRIMARY KEY (`livret_rubrique_type`,`livret_rubrique_ou_matiere_id`,`element_id`),
  KEY `rubrique` (`livret_rubrique_type`,`livret_rubrique_ou_matiere_id`),
  KEY `livret_rubrique_ou_matiere_id` (`livret_rubrique_ou_matiere_id`),
  KEY `element_id` (`element_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_matiere`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_matiere` (
  `livret_matiere_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `livret_matiere_ordre` tinyint(3) unsigned NOT NULL DEFAULT '255',
  `livret_siecle_code_matiere` char(6) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Issu de SIECLE <MATIERE CODE> et requis pour l''export LSUN ; correspond à sacoche_matiere.matiere_code précédé de zéros (sauf cas particuliers).',
  `livret_siecle_code_gestion` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Issu de SIECLE <CODE_GESTION> ; correspond à sacoche_matiere.matiere_ref.',
  `livret_siecle_libelle` varchar(63) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`livret_matiere_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=247 ;

--
-- Contenu de la table `sacoche_livret_matiere`
--

INSERT INTO `sacoche_livret_matiere` (`livret_matiere_id`, `livret_matiere_ordre`, `livret_siecle_code_matiere`, `livret_siecle_code_gestion`, `livret_siecle_libelle`) VALUES
(231, 1, NULL, NULL, 'Français'),
(232, 2, NULL, NULL, 'Mathématiques'),
(233, 3, NULL, NULL, 'Histoire-géographie'),
(234, 4, NULL, NULL, 'Enseignement moral et civique'),
(235, 5, NULL, NULL, 'Langue vivante 1'),
(236, 6, NULL, NULL, 'Langue vivante 2'),
(237, 7, NULL, NULL, 'Education physique et sportive'),
(238, 8, NULL, NULL, 'Arts plastiques'),
(239, 9, NULL, NULL, 'Education musicale'),
(240, 10, NULL, NULL, 'Sciences de la vie et de la terre'),
(241, 11, NULL, NULL, 'Technologie'),
(242, 12, NULL, NULL, 'Physique-chimie'),
(243, 13, NULL, NULL, 'Langues et cultures de l''Antiquité'),
(244, 14, NULL, NULL, 'Matière personnalisée n°1'),
(245, 15, NULL, NULL, 'Matière personnalisée n°2'),
(246, 16, NULL, NULL, 'Matière personnalisée n°3');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_modaccomp`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_modaccomp` (
  `livret_modaccomp_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_modaccomp_nom` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`livret_modaccomp_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_livret_modaccomp`
--

INSERT INTO `sacoche_livret_modaccomp` (`livret_modaccomp_code`, `livret_modaccomp_nom`) VALUES
('PAP', 'Projet d''accompagnement personnalisé'),
('PAI', 'Projet d''accueil individualisé'),
('PPRE', 'Projet personnalisé de réussite éducative'),
('PPS', 'Projet personnalisé de scolarisation'),
('ULIS', 'Unité localisée pour l''inclusion scolaire'),
('UPE2A', 'Unité pédagogique pour élèves allophones arrivants'),
('SEGPA', 'Section d''enseignement général adapté');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_page`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_page` (
  `livret_page_ref` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_page_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `livret_page_moment` varchar(17) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_page_titre_classe` varchar(13) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_page_resume` varchar(84) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_page_periodicite` enum('periode','cycle','college') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'periode',
  `livret_page_rubrique_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_page_rubrique_join` varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Modifiable, pour indiquer le type de jointure à utiliser (matiere | domaine | theme | item | user).',
  `livret_page_colonne` varchar(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Modifiable pour 6e 5e 4e 3e (moyenne | pourcentage | position).',
  `livret_page_epi` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `livret_page_ap` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `livret_page_parcours` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Chaîne de livret_parcours_type_code (P_AVN,P_CIT,P_ART,P_SAN).',
  `livret_page_vie_scolaire` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`livret_page_ref`),
  UNIQUE KEY `livret_page_ordre` (`livret_page_ordre`),
  KEY `livret_page_periodicite` (`livret_page_periodicite`),
  KEY `livret_page_rubrique_type` (`livret_page_rubrique_type`),
  KEY `livret_page_colonne` (`livret_page_colonne`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Livret Scolaire Unique';

--
-- Contenu de la table `sacoche_livret_page`
--

INSERT INTO `sacoche_livret_page` (`livret_page_ref`, `livret_page_ordre`, `livret_page_moment`, `livret_page_titre_classe`, `livret_page_resume`, `livret_page_periodicite`, `livret_page_rubrique_type`, `livret_page_rubrique_join`, `livret_page_colonne`, `livret_page_epi`, `livret_page_ap`, `livret_page_parcours`, `livret_page_vie_scolaire`) VALUES
('cycle1', 19, 'Fin de maternelle', 'Classe de GS', 'Synthèse des acquis scolaires', 'cycle', 'c1_theme', 'theme', 'reussite', 0, 0, '', 0),
('cp', 21, 'Niveau CP', 'Classe de CP', 'Suivi des acquis scolaires - Bilan de l''acquisition des connaissances et compétences', 'periode', 'c2_domaine', 'domaine', 'objectif', 0, 0, 'P_CIT,P_ART,P_SAN', 0),
('ce1', 22, 'Niveau CE1', 'Classe de CE1', 'Suivi des acquis scolaires - Bilan de l''acquisition des connaissances et compétences', 'periode', 'c2_domaine', 'domaine', 'objectif', 0, 0, 'P_CIT,P_ART,P_SAN', 0),
('ce2', 23, 'Niveau CE2', 'Classe de CE2', 'Suivi des acquis scolaires - Bilan de l''acquisition des connaissances et compétences', 'periode', 'c2_domaine', 'domaine', 'objectif', 0, 0, 'P_CIT,P_ART,P_SAN', 0),
('cycle2', 29, 'Fin de cycle 2', 'Classe de CE2', 'Maîtrise des composantes du socle - Synthèse des acquis scolaires', 'cycle', 'c2_socle', 'item', 'maitrise', 0, 0, '', 0),
('cm1', 31, 'Niveau CM1', 'Classe de CM1', 'Suivi des acquis scolaires - Bilan de l''acquisition des connaissances et compétences', 'periode', 'c3_domaine', 'domaine', 'objectif', 0, 0, 'P_CIT,P_ART,P_SAN', 0),
('cm2', 32, 'Niveau CM2', 'Classe de CM2', 'Suivi des acquis scolaires - Bilan de l''acquisition des connaissances et compétences', 'periode', 'c3_domaine', 'domaine', 'objectif', 0, 0, 'P_CIT,P_ART,P_SAN', 0),
('6e', 33, 'Niveau 6e', 'Classe de 6e', 'Suivi des acquis scolaires - Bilan de l''acquisition des connaissances et compétences', 'periode', 'c3_matiere', 'matiere', 'moyenne', 0, 1, 'P_AVN,P_CIT,P_ART,P_SAN', 1),
('cycle3', 39, 'Fin de cycle 3', 'Classe de 6e', 'Maîtrise des composantes du socle - Synthèse des acquis scolaires', 'cycle', 'c3_socle', 'item', 'maitrise', 0, 0, '', 0),
('5e', 41, 'Niveau 5e', 'Classe de 5e', 'Suivi des acquis scolaires - Bilan de l''acquisition des connaissances et compétences', 'periode', 'c4_matiere', 'matiere', 'moyenne', 1, 1, 'P_AVN,P_CIT,P_ART,P_SAN', 1),
('4e', 42, 'Niveau 4e', 'Classe de 4e', 'Suivi des acquis scolaires - Bilan de l''acquisition des connaissances et compétences', 'periode', 'c4_matiere', 'matiere', 'moyenne', 1, 1, 'P_AVN,P_CIT,P_ART,P_SAN', 1),
('3e', 43, 'Niveau 3e', 'Classe de 3e', 'Suivi des acquis scolaires - Bilan de l''acquisition des connaissances et compétences', 'periode', 'c4_matiere', 'matiere', 'moyenne', 1, 1, 'P_AVN,P_CIT,P_ART,P_SAN', 1),
('cycle4', 49, 'Fin de cycle 4', 'Classe de 3e', 'Maîtrise des composantes du socle - Synthèse des acquis scolaires', 'cycle', 'c4_socle', 'item', 'maitrise', 0, 0, '', 0),
('brevet', 50, 'Fin de collège', 'Classe de 3e', 'Brevet des collèges', 'college', '', '', '', 0, 0, '', 0);

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_parcours`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_parcours` (
  `livret_parcours_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `livret_parcours_type_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_page_ref` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `groupe_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `prof_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`livret_parcours_id`),
  UNIQUE KEY `livret_parcours` (`livret_parcours_type_code`,`livret_page_ref`,`groupe_id`),
  KEY `livret_page_ref` (`livret_page_ref`),
  KEY `groupe_id` (`groupe_id`),
  KEY `prof_id` (`prof_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_parcours_type`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_parcours_type` (
  `livret_parcours_type_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_parcours_type_nom` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_parcours_type_url_sitegouv` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_parcours_type_url_txtofficiel` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`livret_parcours_type_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_livret_parcours_type`
--

INSERT INTO `sacoche_livret_parcours_type` (`livret_parcours_type_code`, `livret_parcours_type_nom`, `livret_parcours_type_url_sitegouv`, `livret_parcours_type_url_txtofficiel`) VALUES
('P_AVN', 'Parcours avenir', 'http://www.education.gouv.fr/cid83948/le-parcours-avenir.html', 'http://www.education.gouv.fr/pid25535/bulletin_officiel.html?cid_bo=91137'),
('P_CIT', 'Parcours citoyen', 'http://www.education.gouv.fr/cid100517/le-parcours-citoyen.html', 'http://cache.media.education.gouv.fr/file/CSP/70/5/parcours_citoyen_10-03-16_adopte_551705.pdf'),
('P_ART', 'Parcours d''éducation artistique et culturelle', 'http://eduscol.education.fr/cid74945/le-parcours-d-education-artistique-et-culturelle.html', 'http://www.education.gouv.fr/pid25535/bulletin_officiel.html?cid_bo=91164'),
('P_SAN', 'Parcours éducatif de santé', 'http://www.education.gouv.fr/cid50297/la-sante-des-eleves.html', 'http://www.education.gouv.fr/pid285/bulletin_officiel.html?cid_bo=97990');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_rubrique`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_rubrique` (
  `livret_rubrique_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `livret_rubrique_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_rubrique_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `livret_rubrique_titre` varchar(70) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_rubrique_sous_titre` varchar(130) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`livret_rubrique_id`),
  UNIQUE KEY `livret_rubrique_type` (`livret_rubrique_type`,`livret_rubrique_ordre`),
  KEY `livret_rubrique_titre` (`livret_rubrique_titre`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_livret_rubrique`
--

INSERT INTO `sacoche_livret_rubrique` (`livret_rubrique_id`, `livret_rubrique_type`, `livret_rubrique_ordre`, `livret_rubrique_titre`, `livret_rubrique_sous_titre`) VALUES
(11, 'c1_theme', 1, 'Mobiliser le langage dans toutes ses dimensions', 'Langage oral : communication, expression'),
(12, 'c1_theme', 2, 'Mobiliser le langage dans toutes ses dimensions', 'Compréhension d''un message oral ou d''un texte lu par l''adulte'),
(13, 'c1_theme', 3, 'Mobiliser le langage dans toutes ses dimensions', 'Découverte de l''écrit ; relations entre l''oral et l''écrit'),
(14, 'c1_theme', 4, 'Mobiliser le langage dans toutes ses dimensions', 'Geste graphique, écriture'),
(15, 'c1_theme', 5, 'Mobiliser le langage dans toutes ses dimensions', 'Mémorisation, restitution de textes (comptines, poèmes…)'),
(21, 'c1_theme', 6, 'Agir, s''exprimer, comprendre à travers l''activité physique', 'Engagement, aisance et inventivité dans les actions ou déplacements'),
(22, 'c1_theme', 7, 'Agir, s''exprimer, comprendre à travers l''activité physique', 'Coopération, interactions avec respect des rôles de chacun'),
(23, 'c1_theme', 8, 'Agir, s''exprimer, comprendre à travers les activités artistiques', 'Engagement dans les activités, réalisation de productions personnelles : dessin, compositions graphiques, compositions plastiques'),
(24, 'c1_theme', 9, 'Agir, s''exprimer, comprendre à travers les activités artistiques', 'Engagement dans les activités, réalisation de productions personnelles : voix, chants, pratiques rythmiques et corporelles'),
(31, 'c1_theme', 10, 'Construire les premiers outils pour structurer sa pensée', 'Utilisation des nombres'),
(32, 'c1_theme', 11, 'Construire les premiers outils pour structurer sa pensée', 'Première compréhension du nombre'),
(33, 'c1_theme', 12, 'Construire les premiers outils pour structurer sa pensée', 'Petits problèmes de composition et de décomposition de nombres (ex : 3 c''est 2 et encore 1 ; 1 et encore 2)'),
(34, 'c1_theme', 13, 'Construire les premiers outils pour structurer sa pensée', 'Tris, classements, rangements, algorithmes '),
(41, 'c1_theme', 14, 'Explorer le monde', 'Temps : repérage, représentations, utilisation de mots de liaison (puis, pendant, avant, après,…)'),
(42, 'c1_theme', 15, 'Explorer le monde', 'Espace : repérage, représentations, utilisation des termes de position (devant, derrière, loin, près,…)'),
(43, 'c1_theme', 16, 'Explorer le monde', 'Premières connaissances sur le vivant (développement ; besoins…)'),
(44, 'c1_theme', 17, 'Explorer le monde', 'Utilisation, fabrication et manipulation d''objets'),
(45, 'c1_theme', 18, 'Explorer le monde', 'Compréhension de règles de sécurité et d''hygiène'),
(51, 'c2_domaine', 1, 'Français', 'Langage oral'),
(52, 'c2_domaine', 2, 'Français', 'Lecture et compréhension de l''écrit'),
(53, 'c2_domaine', 3, 'Français', 'Écriture'),
(54, 'c2_domaine', 4, 'Français', 'Étude de la langue (vocabulaire, orthographe, grammaire)'),
(61, 'c2_domaine', 5, 'Mathématiques', 'Nombres et calcul'),
(62, 'c2_domaine', 6, 'Mathématiques', 'Grandeurs et mesures'),
(63, 'c2_domaine', 7, 'Mathématiques', 'Espace et géométrie'),
(71, 'c2_domaine', 8, 'Éducation physique et sportive', NULL),
(72, 'c2_domaine', 9, 'Enseignements artistiques', NULL),
(73, 'c2_domaine', 10, 'Questionner le monde', NULL),
(74, 'c2_domaine', 11, 'Enseignement moral et civique', NULL),
(81, 'c2_domaine', 12, 'Langue vivante', 'Écouter et parler'),
(82, 'c2_domaine', 13, 'Langue vivante', 'Lire et écrire'),
(91, 'c3_domaine', 1, 'Français', 'Langage oral'),
(92, 'c3_domaine', 2, 'Français', 'Lecture et compréhension de l''écrit'),
(93, 'c3_domaine', 3, 'Français', 'Écriture'),
(94, 'c3_domaine', 4, 'Français', 'Étude de la langue (grammaire, orthographe, lexique)'),
(101, 'c3_domaine', 5, 'Mathématiques', 'Nombres et calcul'),
(102, 'c3_domaine', 6, 'Mathématiques', 'Grandeurs et mesures'),
(103, 'c3_domaine', 7, 'Mathématiques', 'Espace et géométrie'),
(111, 'c3_domaine', 8, 'Éducation physique et sportive', NULL),
(112, 'c3_domaine', 9, 'Sciences et technologie', NULL),
(121, 'c3_domaine', 10, 'Enseignements artistiques', 'Arts plastiques et visuels'),
(122, 'c3_domaine', 11, 'Enseignements artistiques', 'Éducation musicale'),
(123, 'c3_domaine', 12, 'Enseignements artistiques', 'Histoire des arts'),
(131, 'c3_domaine', 13, 'Histoire géographie', 'Histoire'),
(132, 'c3_domaine', 14, 'Histoire géographie', 'Géographie'),
(133, 'c3_domaine', 15, 'Enseignement moral et civique', NULL),
(141, 'c3_domaine', 16, 'Langue vivante', 'Écouter et parler'),
(142, 'c3_domaine', 17, 'Langue vivante', 'Lire et écrire');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_livret_seuil`
--

CREATE TABLE IF NOT EXISTS `sacoche_livret_seuil` (
  `livret_page_ref` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `livret_colonne_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `livret_seuil_min` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Entre 0 et 99 ; doit être cohérent avec l''ordre.',
  `livret_seuil_max` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Entre 1 et 100 ; doit être cohérent avec l''ordre.',
  PRIMARY KEY (`livret_page_ref`,`livret_colonne_id`),
  KEY `livret_colonne_id` (`livret_colonne_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_livret_seuil`
--

INSERT INTO `sacoche_livret_seuil` (`livret_page_ref`, `livret_colonne_id`, `livret_seuil_min`, `livret_seuil_max`) VALUES
('cycle1', 11, 0, 30),
('cycle1', 12, 31, 69),
('cycle1', 13, 70, 100),
('cp', 21, 0, 34),
('cp', 22, 35, 64),
('cp', 23, 65, 89),
('cp', 24, 90, 100),
('ce1', 21, 0, 34),
('ce1', 22, 35, 64),
('ce1', 23, 65, 89),
('ce1', 24, 90, 100),
('ce2', 21, 0, 34),
('ce2', 22, 35, 64),
('ce2', 23, 65, 89),
('ce2', 24, 90, 100),
('cm1', 21, 0, 34),
('cm1', 22, 35, 64),
('cm1', 23, 65, 89),
('cm1', 24, 90, 100),
('cm2', 21, 0, 34),
('cm2', 22, 35, 64),
('cm2', 23, 65, 89),
('cm2', 24, 90, 100),
('cycle2', 31, 0, 34),
('cycle2', 32, 35, 59),
('cycle2', 33, 60, 80),
('cycle2', 34, 81, 100),
('cycle3', 31, 0, 34),
('cycle3', 32, 35, 59),
('cycle3', 33, 60, 80),
('cycle3', 34, 81, 100),
('cycle4', 31, 0, 34),
('cycle4', 32, 35, 59),
('cycle4', 33, 60, 80),
('cycle4', 34, 81, 100),
('6e', 41, 0, 24),
('6e', 42, 25, 49),
('6e', 43, 50, 74),
('6e', 44, 75, 100),
('5e', 41, 0, 24),
('5e', 42, 25, 49),
('5e', 43, 50, 74),
('5e', 44, 75, 100),
('4e', 41, 0, 24),
('4e', 42, 25, 49),
('4e', 43, 50, 74),
('4e', 44, 75, 100),
('3e', 41, 0, 24),
('3e', 42, 25, 49),
('3e', 43, 50, 74),
('3e', 44, 75, 100);

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_matiere`
--

CREATE TABLE IF NOT EXISTS `sacoche_matiere` (
  `matiere_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `matiere_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `matiere_usuelle` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `matiere_famille_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `matiere_nb_demandes` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `matiere_ordre` tinyint(3) unsigned NOT NULL DEFAULT '255',
  `matiere_code` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'Id de la BCN requis pour l''export LSUN.',
  `matiere_ref` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `matiere_nom` varchar(63) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`matiere_id`),
  KEY `matiere_active` (`matiere_active`),
  KEY `matiere_famille_id` (`matiere_famille_id`),
  FULLTEXT KEY `matiere_nom` (`matiere_nom`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=10000 ;

--
-- Contenu de la table `sacoche_matiere`
--

INSERT INTO `sacoche_matiere` (`matiere_id`, `matiere_active`, `matiere_usuelle`, `matiere_famille_id`, `matiere_nb_demandes`, `matiere_ordre`, `matiere_code`, `matiere_ref`, `matiere_nom`) VALUES
(1, 0, 0, 100, 0, 255, 100, 'PBSCU', 'Problèmes socioculturels'),
(2, 0, 0, 100, 0, 255, 200, 'CPORT', 'Comportement'),
(3, 0, 0, 100, 0, 255, 300, 'ACAUT', 'Activités autonomes'),
(4, 0, 0, 100, 0, 255, 400, 'STAGE', 'Stages'),
(5, 0, 0, 100, 0, 255, 500, 'EDSCU', 'Education socioculturelle'),
(6, 0, 0, 100, 0, 255, 600, 'P-STA', 'Préparation stages'),
(7, 0, 0, 100, 0, 255, 700, 'ACPER', 'Activités personnelles'),
(8, 0, 0, 100, 0, 255, 800, 'F-GEN', 'Formation générale'),
(9, 0, 0, 100, 0, 255, 900, 'ETPRA', 'Étude pratique (ses)'),
(10, 0, 0, 100, 0, 255, 1000, 'F-PRO', 'Formation professionnelle (ses)'),
(11, 0, 0, 100, 0, 255, 1100, 'IMTRA', 'Information monde travail'),
(12, 0, 0, 100, 0, 255, 1200, 'F-PRA', 'Formation pratique'),
(13, 0, 0, 100, 0, 255, 1300, 'PR-PF', 'Pratiques professionnelles'),
(14, 0, 0, 100, 0, 255, 1400, 'SOUTN', 'Soutien'),
(15, 0, 0, 100, 0, 255, 1500, 'ALLEG', 'Allègement'),
(16, 0, 0, 100, 0, 255, 1600, 'HYGSC', 'Hygiène sécurité'),
(17, 0, 0, 100, 0, 255, 1700, 'CULGE', 'Culture générale'),
(18, 0, 0, 100, 0, 255, 1800, 'MADIV', 'Matières diverses'),
(19, 0, 0, 100, 0, 255, 1900, 'ACMIP', 'Activités en milieu professionnel'),
(20, 0, 0, 100, 0, 255, 2000, 'ACPPD', 'Activités personnelles et professionnelles dirigées'),
(21, 0, 0, 100, 0, 255, 2100, 'I-RHU', 'Initiation aux relations humaines'),
(22, 0, 0, 100, 0, 255, 2200, 'MOADP', 'Modules d''adaptation'),
(23, 0, 0, 100, 0, 255, 2300, 'TPE', 'Travaux personnels encadrés'),
(24, 0, 0, 100, 0, 255, 2400, 'ACALI', 'Accès en autonomie au laboratoire informatique'),
(25, 0, 0, 100, 0, 255, 2500, 'REHUM', 'Relations humaines'),
(26, 0, 0, 100, 0, 255, 2600, 'F-RHU', 'Formation relations humaines'),
(27, 0, 0, 100, 0, 255, 2700, 'EDGTM', 'Education gestuelle Travaux manuels (ses)'),
(28, 0, 0, 100, 0, 255, 2800, 'BRIDG', 'Bridge'),
(29, 0, 0, 100, 0, 255, 2900, 'BRAIL', 'Braille'),
(30, 0, 0, 100, 0, 255, 3000, 'PR-SC', 'Pratiques sociales et culturelles'),
(31, 0, 0, 100, 0, 255, 3100, 'MODUL', 'Module'),
(32, 0, 0, 100, 0, 255, 3200, 'AMEXP', 'Acquisition des moyens d''expression'),
(33, 0, 0, 100, 0, 255, 3300, 'TX-IP', 'Travaux initiative personnelle encadrés'),
(34, 0, 0, 100, 0, 255, 3400, 'EDUOR', 'Education à l''orientation'),
(35, 0, 0, 100, 0, 255, 3500, 'PPCP', 'Projet pluridisciplinaire à caractère professionnel'),
(36, 0, 0, 100, 0, 255, 3600, 'APD', 'Activités professionnelles dirigées'),
(37, 0, 0, 100, 0, 255, 3700, 'ATRAV', 'Accompagnement du travail personnel'),
(38, 0, 0, 100, 0, 255, 3800, 'D-SCO', 'Traitement des difficultés scolaires'),
(39, 0, 0, 100, 0, 255, 3900, 'VIPRO', 'Aide à la vie professionnelle'),
(40, 0, 0, 100, 0, 255, 4000, 'IDNCH', 'Itinéraire découverte - nature corps humain'),
(41, 0, 0, 100, 0, 255, 4100, 'IDARH', 'Itinéraire découverte - arts humanité'),
(42, 0, 0, 100, 0, 255, 4200, 'IDLCI', 'Itinéraire découverte - langues civilisations'),
(43, 0, 0, 100, 0, 255, 4300, 'IDCTQ', 'Itinéraire découverte - création techniques'),
(44, 0, 0, 100, 0, 255, 4400, 'DLIAR', 'Domaine littéraire et artistique'),
(45, 0, 0, 100, 0, 255, 4500, 'DPRJT', 'Démarche de projet'),
(46, 0, 0, 100, 0, 255, 4600, 'IDAUT', 'Itinéraire découverte - autres'),
(47, 0, 0, 100, 0, 255, 4700, 'MODRE', 'Module régional'),
(48, 0, 0, 100, 0, 255, 4800, 'ASECT', 'Approfondissement sectoriel'),
(49, 0, 0, 100, 0, 255, 4900, 'LABCC', 'Laboratoire de création et de conception'),
(50, 0, 0, 100, 0, 255, 5000, 'DP3H', 'Découverte professionnelle 3 heures'),
(51, 0, 0, 100, 0, 255, 5100, 'DP6H', 'Découverte professionnelle 6 heures'),
(52, 0, 0, 100, 0, 255, 5200, 'CGEXP', 'Culture générale et expression'),
(53, 0, 0, 100, 0, 255, 5300, 'SIGNE', 'Langue des signes'),
(54, 0, 1, 100, 0, 255, 5400, 'VISCO', 'Vie scolaire'),
(55, 0, 0, 100, 0, 255, 5500, 'SECUR', 'Sécurité'),
(56, 0, 0, 100, 0, 255, 5600, 'PPENC', 'Projet pluritechnique encadré'),
(57, 0, 0, 100, 0, 255, 5700, 'RELAP', 'Relations professionnelles'),
(58, 0, 0, 100, 0, 255, 5800, 'METHO', 'Modules méthodologiques'),
(59, 0, 0, 100, 0, 255, 5900, 'PPAPP', 'Projets professionnels appliqués'),
(60, 0, 0, 100, 0, 255, 6000, 'CMPRO', 'Connaissance du milieu professionnel'),
(61, 0, 0, 100, 0, 255, 6100, 'APAMO', 'Aide au partenariat et à la mobilité'),
(62, 0, 0, 100, 0, 255, 6200, 'ACDEL', 'Activités déléguées'),
(63, 0, 0, 100, 0, 255, 6300, 'ATMET', 'Ateliers métiers'),
(64, 0, 0, 100, 0, 255, 6400, 'ATLIE', 'Atelier(s)'),
(65, 0, 0, 100, 0, 255, 6500, 'AALIC', 'Accès autonomie laboratoire informatique & communication'),
(66, 0, 0, 100, 0, 255, 6600, 'ACCPE', 'Accompagnement personnalisé'),
(67, 0, 0, 100, 0, 255, 6700, 'INVES', 'Méthodologie d''investigation'),
(68, 0, 0, 100, 0, 255, 6800, 'CGENX', 'Culture générale et expression'),
(69, 0, 0, 100, 0, 255, 6900, 'ARTS', 'Arts'),
(70, 0, 0, 100, 0, 255, 7000, 'MEPRO', 'Méthodologie de projet'),
(71, 0, 0, 100, 0, 255, 7100, 'MRECH', 'Méthodologie de recherche'),
(72, 0, 0, 100, 0, 255, 7200, 'ISIC', 'Isic'),
(73, 0, 0, 100, 0, 255, 7300, 'ISAP', 'Isap'),
(74, 0, 0, 100, 0, 255, 7400, 'DECPR', 'Découverte professionnelle'),
(75, 0, 0, 100, 0, 255, 7500, 'ACIND', 'Activités inter-disciplinaires'),
(76, 0, 0, 100, 0, 255, 7600, 'ACTPR', 'Activités de projet'),
(77, 0, 0, 100, 0, 255, 7700, 'CERPR', 'Certification professionnelle'),
(78, 0, 0, 100, 0, 255, 7800, 'AAEPR', 'Accès autonomie équipements professionnels'),
(79, 0, 0, 100, 0, 255, 7900, 'APDPR', 'Approche pluridisciplinaire & dimension professionnelle'),
(80, 0, 0, 100, 0, 255, 8000, 'MOENG', 'Modules (français - maths - hist.geo - LV1)'),
(81, 0, 0, 100, 0, 255, 8100, 'AAALO', 'Actions appliquées et d''adaptation locale'),
(82, 0, 0, 100, 0, 255, 8200, 'ARRDI', 'Accès en responsabilité aux ress. doc. informatisées ets'),
(83, 0, 0, 100, 0, 255, 8300, 'ETUDE', 'Études (dirigées ou encadrées)'),
(84, 0, 0, 100, 0, 255, 8400, 'VICLA', 'Vie de la classe'),
(85, 0, 0, 100, 0, 255, 8500, 'AIAUT', 'Aide individualisée autres matières'),
(86, 0, 0, 100, 0, 255, 8600, 'RANIV', 'Remise à niveau'),
(87, 0, 0, 100, 0, 255, 8700, 'AIDIN', 'Aide individualisée'),
(88, 0, 0, 100, 0, 255, 8800, 'ACTIP', 'Action professionnelle'),
(89, 0, 0, 100, 0, 255, 8900, 'STRTI', 'Stratégie et techniques d''intervention'),
(90, 0, 0, 100, 0, 255, 9000, 'MEQUI', 'Management d''équipe'),
(91, 0, 0, 100, 0, 255, 9100, 'EPE', 'Étude personnalisée encadrée'),
(92, 0, 0, 100, 0, 255, 9200, 'ATELP', 'Atelier de professionnalisation'),
(93, 0, 0, 100, 0, 255, 9300, 'FILOC', 'Formation d''initiative locale'),
(94, 0, 0, 100, 0, 255, 9400, 'AT-PX', 'Ateliers principaux'),
(95, 0, 0, 100, 0, 255, 9500, 'AT-CO', 'Ateliers complémentaires'),
(96, 0, 0, 100, 0, 255, 9600, 'COMPR', 'Connaissance des milieux professionnels'),
(97, 0, 0, 100, 0, 255, 9700, 'PROPR', 'Projet professionnel'),
(98, 0, 0, 100, 0, 255, 9800, 'AEAID', 'Acccompagn.éducatif - aide devoirs leçons'),
(99, 0, 0, 100, 0, 255, 9900, 'ACNSD', 'Activités non spécialisées diverses'),
(101, 0, 0, 1, 0, 255, 10100, 'CULSH', 'Culture générale et sciences humaines'),
(102, 0, 0, 1, 0, 255, 10200, 'PHI-R', 'Philosophie renforcée'),
(103, 0, 1, 1, 0, 255, 10300, 'PHILO', 'Philosophie'),
(104, 0, 0, 1, 0, 255, 10400, 'SCHUM', 'Sciences humaines'),
(106, 0, 0, 1, 0, 255, 10600, 'PSY-S', 'Psychologie sociologie'),
(107, 0, 0, 1, 0, 255, 10700, 'PSY-P', 'Psychologie - psychosociologie'),
(108, 0, 0, 1, 0, 255, 10800, 'SOCIO', 'Sociologie'),
(109, 0, 0, 1, 0, 255, 10900, 'ESTSE', 'Esthétique sémiologie'),
(110, 0, 0, 1, 0, 255, 11000, 'PSYKO', 'Psychologie'),
(111, 0, 0, 1, 0, 255, 11100, 'PSY-G', 'Psychologie et pédagogie'),
(112, 0, 0, 1, 0, 255, 11200, 'PSYSE', 'Psycho-sociologie - esthétique - sémiologie'),
(113, 0, 0, 1, 0, 255, 11300, 'PSYCO', 'Psychologie de la communication'),
(114, 0, 0, 1, 0, 255, 11400, 'IMACS', 'Image:communication sémiologie - esthétique'),
(115, 0, 0, 1, 0, 255, 11500, 'PHIAR', 'Philosophie générale de l''art'),
(116, 0, 0, 1, 0, 255, 11600, 'SEMIO', 'Sémiologie'),
(117, 0, 0, 1, 0, 255, 11700, 'CULSP', 'Culture du spectacle'),
(118, 0, 0, 1, 0, 255, 11800, 'C-COM', 'Cultures de la communication'),
(119, 0, 0, 1, 0, 255, 11900, 'S-PSY', 'Sensibilisation concepts psy etc'),
(120, 0, 0, 1, 0, 255, 12000, 'CPOLI', 'Connaissance des politiques institutions'),
(121, 0, 0, 1, 0, 255, 12100, 'SCHSD', 'Sciences humaines, sociales et droit'),
(122, 0, 0, 1, 0, 255, 12200, 'SHPAD', 'Sciences humaines et philosophie générale de l''art et du design'),
(199, 0, 0, 1, 0, 255, 19900, 'PHI-H', 'Philosophie sciences humaines divers'),
(201, 0, 1, 2, 0, 255, 20100, 'LATIN', 'Latin'),
(202, 0, 1, 2, 0, 255, 20200, 'GREC', 'Grec ancien'),
(203, 0, 0, 2, 0, 255, 20300, 'LCALA', 'Langues et cultures de l''antiquité latine'),
(204, 0, 0, 2, 0, 255, 20400, 'LCAGR', 'Langues et cultures de l''antiquité grecque'),
(205, 0, 0, 2, 0, 255, 20500, 'FR-PA', 'Français et éléments de psychologie appliquée'),
(206, 0, 0, 2, 0, 255, 20600, 'EX-RU', 'Expression française - relations humaines'),
(207, 0, 1, 2, 0, 255, 20700, 'FRANC', 'Français'),
(208, 0, 0, 2, 0, 255, 20800, 'FR-MO', 'Franchis module'),
(209, 0, 0, 2, 0, 255, 20900, 'LITSO', 'Littérature & société'),
(210, 0, 0, 2, 0, 255, 21000, 'THEME', 'Thème'),
(211, 0, 0, 2, 0, 255, 21100, 'FR-MT', 'Français maths (ses)'),
(212, 0, 0, 2, 0, 255, 21200, 'CULEF', 'Culture et expression française'),
(213, 0, 0, 2, 0, 255, 21300, 'EXPRS', 'Expression'),
(214, 0, 0, 2, 0, 255, 21400, 'EX-FR', 'Expression française'),
(215, 0, 0, 2, 0, 255, 21500, 'T-EEO', 'Techniques d''expression écrite et orale'),
(216, 0, 0, 2, 0, 255, 21600, 'FR-SH', 'Français sciences humaines'),
(217, 0, 0, 2, 0, 255, 21700, 'FR-PE', 'Français et problèmes économiques'),
(218, 0, 0, 2, 0, 255, 21800, 'T-ANA', 'Techniques d''analyse'),
(219, 0, 0, 2, 0, 255, 21900, 'EVLAR', 'Environnement littéraire et artistique'),
(220, 0, 0, 2, 0, 255, 22000, 'ECEXF', 'Ecriture et expression française'),
(221, 0, 0, 2, 0, 255, 22100, 'FR-HG', 'Français - histoire - géographie'),
(223, 0, 0, 2, 0, 255, 22300, 'LETTR', 'Lettres'),
(224, 0, 0, 2, 0, 255, 22400, 'GRESP', 'Grec spécialité'),
(225, 0, 0, 2, 0, 255, 22500, 'LATSP', 'Latin spécialité'),
(226, 0, 0, 2, 0, 255, 22600, 'CGPCO', 'Culture générale pratique de la communication'),
(227, 0, 0, 2, 0, 255, 22700, 'FR-PH', 'Français philosophie'),
(228, 0, 0, 2, 0, 255, 22800, 'CULCO', 'Culture et communication'),
(229, 0, 0, 2, 0, 255, 22900, 'LITCI', 'Littérature et civilisation étrangère'),
(230, 0, 0, 2, 0, 255, 23000, 'LCR', 'Langues et cultures régionales'),
(231, 0, 0, 2, 0, 255, 23100, 'AIFRA', 'Aide individualisée en français'),
(232, 0, 0, 2, 0, 255, 23200, 'FRLIT', 'Français et littérature'),
(233, 0, 0, 2, 0, 255, 23300, 'LITTE', 'Littérature'),
(234, 0, 0, 2, 0, 255, 23400, 'CUGEX', 'Culture générale et expression'),
(235, 0, 0, 2, 0, 255, 23500, 'FHGEC', 'Français - histoire-géo. - éduc. civique'),
(236, 0, 0, 2, 0, 255, 23600, 'LGLIT', 'Langue et littérature'),
(299, 0, 0, 2, 0, 255, 29900, 'LETDI', 'Lettres divers'),
(300, 0, 0, 3, 0, 255, 39701, 'FLE', 'Français langue étrangère'),
(301, 0, 0, 3, 0, 255, 30100, 'ALL', 'Allemand'),
(302, 0, 0, 3, 0, 255, 30200, 'AGL', 'Anglais'),
(303, 0, 0, 3, 0, 255, 30300, 'ARA', 'Arabe'),
(304, 0, 0, 3, 0, 255, 30400, 'CHI', 'Chinois'),
(305, 0, 0, 3, 0, 255, 30500, 'DAN', 'Danois'),
(306, 0, 0, 3, 0, 255, 30600, 'ESP', 'Espagnol'),
(309, 0, 0, 3, 0, 255, 30900, 'ITA', 'Italien'),
(310, 0, 0, 3, 0, 255, 31000, 'JAP', 'Japonais'),
(311, 0, 0, 3, 0, 255, 31100, 'POR', 'Portugais'),
(312, 0, 0, 3, 0, 255, 31200, 'NEE', 'Néerlandais'),
(313, 0, 0, 3, 0, 255, 31300, 'POL', 'Polonais'),
(314, 0, 0, 3, 0, 255, 31400, 'RUS', 'Russe'),
(315, 0, 1, 3, 0, 255, 30101, 'ALL1', 'Allemand LV1'),
(316, 0, 1, 3, 0, 255, 30201, 'AGL1', 'Anglais LV1'),
(317, 0, 0, 3, 0, 255, 30301, 'ARA1', 'Arabe LV1'),
(318, 0, 0, 3, 0, 255, 30401, 'CHI1', 'Chinois LV1'),
(319, 0, 0, 3, 0, 255, 30501, 'DAN1', 'Danois LV1'),
(320, 0, 1, 3, 0, 255, 30601, 'ESP1', 'Espagnol LV1'),
(321, 0, 0, 3, 0, 255, 30901, 'ITA1', 'Italien LV1'),
(322, 0, 0, 3, 0, 255, 31001, 'JAP1', 'Japonais LV1'),
(323, 0, 0, 3, 0, 255, 31101, 'POR1', 'Portugais LV1'),
(324, 0, 0, 3, 0, 255, 31201, 'NEE1', 'Néerlandais LV1'),
(325, 0, 0, 3, 0, 255, 31301, 'POL1', 'Polonais LV1'),
(326, 0, 0, 3, 0, 255, 31401, 'RUS1', 'Russe LV1'),
(327, 0, 1, 3, 0, 255, 30102, 'ALL2', 'Allemand LV2'),
(328, 0, 1, 3, 0, 255, 30202, 'AGL2', 'Anglais LV2'),
(329, 0, 0, 3, 0, 255, 30302, 'ARA2', 'Arabe LV2'),
(330, 0, 0, 3, 0, 255, 30402, 'CHI2', 'Chinois LV2'),
(331, 0, 0, 3, 0, 255, 30502, 'DAN2', 'Danois LV2'),
(332, 0, 1, 3, 0, 255, 30602, 'ESP2', 'Espagnol LV2'),
(333, 0, 0, 3, 0, 255, 30902, 'ITA2', 'Italien LV2'),
(334, 0, 0, 3, 0, 255, 31002, 'JAP2', 'Japonais LV2'),
(335, 0, 0, 3, 0, 255, 31102, 'POR2', 'Portugais LV2'),
(336, 0, 0, 3, 0, 255, 31202, 'NEE2', 'Néerlandais LV2'),
(337, 0, 0, 3, 0, 255, 31302, 'POL2', 'Polonais LV2'),
(338, 0, 0, 3, 0, 255, 31402, 'RUS2', 'Russe LV2'),
(339, 0, 0, 3, 0, 255, 30103, 'ALL3', 'Allemand LV3'),
(340, 0, 0, 3, 0, 255, 30203, 'AGL3', 'Anglais LV3'),
(341, 0, 0, 3, 0, 255, 30303, 'ARA3', 'Arabe LV3'),
(342, 0, 0, 3, 0, 255, 30403, 'CHI3', 'Chinois LV3'),
(343, 0, 0, 3, 0, 255, 30503, 'DAN3', 'Danois LV3'),
(344, 0, 0, 3, 0, 255, 30603, 'ESP3', 'Espagnol LV3'),
(345, 0, 0, 3, 0, 255, 30903, 'ITA3', 'Italien LV3'),
(346, 0, 0, 3, 0, 255, 31003, 'JAP3', 'Japonais LV3'),
(347, 0, 0, 3, 0, 255, 31103, 'POR3', 'Portugais LV3'),
(348, 0, 0, 3, 0, 255, 31203, 'NEE3', 'Néerlandais LV3'),
(349, 0, 0, 3, 0, 255, 31303, 'POL3', 'Polonais LV3'),
(350, 0, 0, 3, 0, 255, 31403, 'RUS3', 'Russe LV3'),
(351, 0, 0, 3, 0, 255, 30104, 'ALL4', 'Allemand renforcé'),
(352, 0, 0, 3, 0, 255, 30204, 'AGL4', 'Anglais renforcé'),
(353, 0, 0, 3, 0, 255, 30304, 'ARA4', 'Arabe renforcé'),
(354, 0, 0, 3, 0, 255, 30404, 'CHI4', 'Chinois renforcé'),
(355, 0, 0, 3, 0, 255, 30504, 'DAN4', 'Danois renforcé'),
(356, 0, 0, 3, 0, 255, 30604, 'ESP4', 'Espagnol renforcé'),
(357, 0, 0, 3, 0, 255, 30904, 'ITA4', 'Italien renforcé'),
(358, 0, 0, 3, 0, 255, 31004, 'JAP4', 'Japonais renforcé'),
(359, 0, 0, 3, 0, 255, 31104, 'POR4', 'Portugais renforcé'),
(360, 0, 0, 3, 0, 255, 31204, 'NEE4', 'Néerlandais renforcé'),
(361, 0, 0, 3, 0, 255, 31304, 'POL4', 'Polonais renforcé'),
(362, 0, 0, 3, 0, 255, 31404, 'RUS4', 'Russe renforcé'),
(363, 0, 0, 3, 0, 255, 30109, 'ALL9', 'Allemand langue de section'),
(364, 0, 0, 3, 0, 255, 30209, 'AGL9', 'Anglais langue de section'),
(365, 0, 0, 3, 0, 255, 30309, 'ARA9', 'Arabe langue de section'),
(366, 0, 0, 3, 0, 255, 30409, 'CHI9', 'Chinois langue de section'),
(367, 0, 0, 3, 0, 255, 30509, 'DAN9', 'Danois langue de section'),
(368, 0, 0, 3, 0, 255, 30609, 'ESP9', 'Espagnol langue de section'),
(369, 0, 0, 3, 0, 255, 30909, 'ITA9', 'Italien langue de section'),
(370, 0, 0, 3, 0, 255, 31009, 'JAP9', 'Japonais langue de section'),
(371, 0, 0, 3, 0, 255, 31109, 'POR9', 'Portugais langue de section'),
(372, 0, 0, 3, 0, 255, 31209, 'NEE9', 'Néerlandais langue de section'),
(373, 0, 0, 3, 0, 255, 31309, 'POL9', 'Polonais langue de section'),
(374, 0, 0, 3, 0, 255, 31409, 'RUS9', 'Russe langue de section'),
(375, 0, 0, 3, 0, 255, 30119, 'ALL9C', 'Allemand lettres étrangères'),
(376, 0, 0, 3, 0, 255, 30219, 'AGL9C', 'Anglais lettres étrangères'),
(377, 0, 0, 3, 0, 255, 30319, 'ARA9C', 'Arabe lettres étrangères'),
(378, 0, 0, 3, 0, 255, 30419, 'CHI9C', 'Chinois lettres étrangères'),
(379, 0, 0, 3, 0, 255, 30519, 'DAN9C', 'Danois lettres étrangères'),
(380, 0, 0, 3, 0, 255, 30619, 'ESP9C', 'Espagnol lettres étrangères'),
(381, 0, 0, 3, 0, 255, 30919, 'ITA9C', 'Italien lettres étrangères'),
(382, 0, 0, 3, 0, 255, 31019, 'JAP9C', 'Japonais lettres étrangères'),
(383, 0, 0, 3, 0, 255, 31119, 'POR9C', 'Portugais lettres étrangères'),
(384, 0, 0, 3, 0, 255, 31219, 'NEE9C', 'Néerlandais lettres étrangères'),
(385, 0, 0, 3, 0, 255, 31319, 'POL9C', 'Polonais lettres étrangères'),
(386, 0, 0, 3, 0, 255, 31419, 'RUS9C', 'Russe lettres étrangères'),
(387, 0, 0, 3, 0, 255, 30108, 'ALL8', 'Littérature étrangère en allemand'),
(388, 0, 0, 3, 0, 255, 30208, 'AGL8', 'Littérature étrangère en anglais'),
(389, 0, 0, 3, 0, 255, 30308, 'ARA8', 'Littérature étrangère en arabe'),
(390, 0, 0, 3, 0, 255, 30408, 'CHI8', 'Littérature étrangère en chinois'),
(391, 0, 0, 3, 0, 255, 30508, 'DAN8', 'Littérature étrangère en danois'),
(392, 0, 0, 3, 0, 255, 30608, 'ESP8', 'Littérature étrangère en espagnol'),
(393, 0, 0, 3, 0, 255, 30908, 'ITA8', 'Littérature étrangère en italien'),
(394, 0, 0, 3, 0, 255, 31008, 'JAP8', 'Littérature étrangère en japonais'),
(395, 0, 0, 3, 0, 255, 31108, 'POR8', 'Littérature étrangère en portugais'),
(396, 0, 0, 3, 0, 255, 31208, 'NEE8', 'Littérature étrangère en néerlandais'),
(397, 0, 0, 3, 0, 255, 31308, 'POL8', 'Littérature étrangère en polonais'),
(398, 0, 0, 3, 0, 255, 31408, 'RUS8', 'Littérature étrangère en russe'),
(399, 0, 0, 3, 0, 255, 39900, 'LANDI', 'Langues divers'),
(401, 0, 0, 4, 0, 255, 40100, 'HIGHO', 'Histoire et géographie hôtelière'),
(402, 0, 0, 4, 0, 255, 40200, 'I-MDC', 'Initiation au monde contemporain'),
(403, 0, 0, 4, 0, 255, 40300, 'HIGEC', 'Histoire et géographie économique'),
(404, 0, 0, 4, 0, 255, 40400, 'HIFES', 'Histoire faits économiques et sociaux'),
(405, 0, 0, 4, 0, 255, 40500, 'HISTE', 'Histoire sciences techniques entreprises'),
(406, 0, 1, 4, 0, 255, 40600, 'HIGEO', 'Histoire et géographie'),
(407, 0, 0, 4, 0, 255, 40700, 'HIGMO', 'Histoire géographie module'),
(408, 0, 0, 4, 0, 255, 40800, 'HISTO', 'Histoire'),
(409, 0, 0, 4, 0, 255, 40900, 'GEOGF', 'Géographie'),
(410, 0, 0, 4, 0, 255, 41000, 'GEOGT', 'Géographie générale et touristique'),
(411, 0, 0, 4, 0, 255, 41100, 'GEOAT', 'Géographie appliquée au tourisme'),
(412, 0, 0, 4, 0, 255, 41200, 'GEOAP', 'Géographie appliquée'),
(413, 0, 0, 4, 0, 255, 41300, 'GEOEC', 'Géographie économique'),
(414, 0, 0, 4, 0, 255, 41400, 'EDCIV', 'Education civique'),
(415, 0, 0, 4, 0, 255, 41500, 'CO-MC', 'Connaissance du monde contemporain'),
(416, 0, 0, 4, 0, 255, 41600, 'HIGIC', 'Histoire - géographie - instruction civique'),
(417, 0, 0, 4, 0, 255, 41700, 'CIVLS', 'Civilisation'),
(418, 0, 0, 4, 0, 255, 41800, 'HIANC', 'Histoire ancienne'),
(419, 0, 0, 4, 0, 255, 41900, 'HICTX', 'Histoire - commentaire de textes'),
(420, 0, 0, 4, 0, 255, 42000, 'HGECV', 'Hist-géo - économie et éducation civique'),
(421, 0, 0, 4, 0, 255, 42100, 'HIGCV', 'Histoire - géographie - éducation civique'),
(422, 0, 0, 4, 0, 255, 42200, 'HIGLP', 'Hist - géographie - législation professionnelle'),
(423, 0, 0, 4, 0, 255, 42300, 'HICON', 'Histoire contemporaine'),
(424, 0, 0, 4, 0, 255, 42400, 'HIMOD', 'Histoire moderne de la France'),
(425, 0, 0, 4, 0, 255, 42500, 'GEFRA', 'Géographie historique de la France'),
(426, 0, 0, 4, 0, 255, 42600, 'HIMED', 'Histoire médiévale'),
(427, 0, 0, 4, 0, 255, 42700, 'HISMC', 'Histoire moderne et contemporaine'),
(428, 0, 0, 4, 0, 255, 42800, 'HECRI', 'Histoire des écritures'),
(429, 0, 0, 4, 0, 255, 42900, 'ECJS', 'Education civique juridique et sociale'),
(430, 0, 0, 4, 0, 255, 43000, 'GHCIV', 'Géographie et histoire des civilisations'),
(431, 0, 0, 4, 0, 255, 43100, 'ANPAT', 'Analyse du patrimoine'),
(432, 0, 0, 4, 0, 255, 43200, 'PATRG', 'Patrimoine culturel & touristique régional'),
(433, 0, 0, 4, 0, 255, 43300, 'FHGCI', 'Francais hist.geo. éducation civique'),
(434, 0, 0, 4, 0, 255, 43400, 'HIMAG', 'Histoire de l''image'),
(435, 0, 0, 4, 0, 255, 43500, 'HMEMO', 'Histoire médiévale & moderne'),
(436, 0, 0, 4, 0, 255, 43600, 'HGGMC', 'Histoire, géographie & géopolitique du monde contemporain'),
(437, 0, 0, 4, 0, 255, 43700, 'HI-GE', 'Histoire-géographie'),
(438, 0, 1, 4, 0, 255, 43800, 'EMC', 'Enseignement moral et civique'),
(499, 0, 0, 4, 0, 255, 49900, 'HIGDV', 'Histoire et géographie divers'),
(501, 0, 0, 5, 0, 255, 50100, 'TDECO', 'Travaux dirigés d''économie'),
(502, 0, 0, 5, 0, 255, 50200, 'SECO', 'Sciences économiques'),
(503, 0, 0, 5, 0, 255, 50300, 'E-OAN', 'Économie (analyse des économies)'),
(504, 0, 0, 5, 0, 255, 50400, 'I-ESC', 'Initiation économique et sociale'),
(505, 0, 0, 5, 0, 255, 50500, 'I-ECO', 'Initiation économique'),
(506, 0, 0, 5, 0, 255, 50600, 'STECO', 'Sciences et techniques économiques'),
(507, 0, 1, 5, 0, 255, 50700, 'SES', 'Sciences économiques et sociales'),
(508, 0, 0, 5, 0, 255, 50800, 'E-OAP', 'Économie appliquée'),
(509, 0, 0, 5, 0, 255, 50900, 'E-OSS', 'Économie et sciences sociales'),
(510, 0, 0, 5, 0, 255, 51000, 'E-OSO', 'Économie et social'),
(511, 0, 0, 5, 0, 255, 51100, 'SESMO', 'SES module'),
(512, 0, 0, 5, 0, 255, 51200, 'SESDB', 'SES débutants'),
(513, 0, 0, 5, 0, 255, 51300, 'SESPE', 'Sciences économiques spécialité'),
(514, 0, 0, 5, 0, 255, 51400, 'E-HSC', 'Anal économ historiq sociétés contemp.'),
(515, 0, 0, 5, 0, 255, 51500, 'I-SEC', 'Initiation aux sciences économiques'),
(516, 0, 0, 5, 0, 255, 51600, 'SCSOC', 'Sciences sociales'),
(517, 0, 0, 5, 0, 255, 51700, 'PUBLI', 'Publics'),
(518, 0, 0, 5, 0, 255, 51800, 'PRESE', 'Prestations et services'),
(519, 0, 0, 5, 0, 255, 51900, 'RSHUM', 'Ressources humaines'),
(520, 0, 0, 5, 0, 255, 52000, 'ADDRH', 'Administ. develop. ressources humaines'),
(521, 0, 0, 5, 0, 255, 52100, 'SSPOL', 'Sciences sociales et politiques'),
(522, 0, 0, 5, 0, 255, 52200, 'ECOAP', 'Économie approfondie'),
(523, 0, 0, 5, 0, 255, 52300, 'ESHMC', 'Économie, sociologie & histoire du monde contemporain'),
(599, 0, 0, 5, 0, 255, 59900, 'SECSD', 'Sciences économiques et sociales divers'),
(600, 0, 0, 6, 0, 255, 0, 'EIST', 'Enseignement intégré de science et technologie'),
(601, 0, 0, 6, 0, 255, 60100, 'PCAPP', 'Physique et chimie appliquées'),
(602, 0, 0, 6, 0, 255, 60200, 'TPPHC', 'Travaux pratiques de physique-chimie'),
(603, 0, 0, 6, 0, 255, 60300, 'CH-GE', 'Chimie générale'),
(604, 0, 0, 6, 0, 255, 60400, 'CPIND', 'Chimie et physique industrielles'),
(605, 0, 0, 6, 0, 255, 60500, 'TPMAT', 'Travaux pratiques mathemat. sup. ou spe.'),
(606, 0, 0, 6, 0, 255, 60600, 'SCIEN', 'Sciences'),
(607, 0, 0, 6, 0, 255, 60700, 'MA-AI', 'Mathématiques appliquées et informatique'),
(608, 0, 0, 6, 0, 255, 60800, 'TDPHY', 'Travaux dirigés de physique'),
(609, 0, 0, 6, 0, 255, 60900, 'CH-MN', 'Chimie minérale'),
(610, 0, 0, 6, 0, 255, 61000, 'TDMAT', 'Travaux dirigés de mathématiques'),
(611, 0, 0, 6, 0, 255, 61100, 'SCAPL', 'Sciences appliquées'),
(612, 0, 0, 6, 0, 255, 61200, 'CFOSC', 'Complément de formation scientifique'),
(613, 0, 1, 6, 0, 255, 61300, 'MATHS', 'Mathématiques'),
(614, 0, 0, 6, 0, 255, 61400, 'MA-RF', 'Mathématiques renforcées'),
(615, 0, 0, 6, 0, 255, 61500, 'MA-AP', 'Mathématiques appliquées'),
(616, 0, 0, 6, 0, 255, 61600, 'MA-IF', 'Mathématiques informatique'),
(617, 0, 0, 6, 0, 255, 61700, 'MA-SC', 'Maths sciences'),
(618, 0, 0, 6, 0, 255, 61800, 'MA-PH', 'Mathématiques - sciences physiques'),
(619, 0, 0, 6, 0, 255, 61900, 'OPTIM', 'Optique optoélectronique et imagerie'),
(620, 0, 0, 6, 0, 255, 62000, 'MA-SI', 'Mathématiques statistiques informatique'),
(621, 0, 0, 6, 0, 255, 62100, 'MA-ST', 'Mathématiques et statistiques'),
(622, 0, 0, 6, 0, 255, 62200, 'MA-ME', 'Mathématiques et mécaniques'),
(623, 0, 1, 6, 0, 255, 62300, 'PH-CH', 'Physique-chimie'),
(624, 0, 0, 6, 0, 255, 62400, 'SCPHY', 'Sciences physiques'),
(625, 0, 0, 6, 0, 255, 62500, 'TPSPH', 'TP de sciences physiques'),
(626, 0, 0, 6, 0, 255, 62600, 'PH-LI', 'Physique (laboratoire industriel et recherche)'),
(627, 0, 0, 6, 0, 255, 62700, 'PH-IN', 'Physique industrielle'),
(628, 0, 0, 6, 0, 255, 62800, 'SCPHA', 'Sciences physiques appliquées'),
(629, 0, 1, 6, 0, 255, 62900, 'SVT', 'Sciences de la vie et de la terre'),
(630, 0, 0, 6, 0, 255, 63000, 'PH-AO', 'Physique appliquée optique'),
(631, 0, 0, 6, 0, 255, 63100, 'PH-EL', 'Physique électricité'),
(632, 0, 0, 6, 0, 255, 63200, 'CH-LI', 'Chimie (laboratoire industriel et recherche)'),
(633, 0, 0, 6, 0, 255, 63300, 'CHIMI', 'Chimie'),
(634, 0, 0, 6, 0, 255, 63400, 'SCTKN', 'Sciences appliquées et technologies nouvelles'),
(635, 0, 0, 6, 0, 255, 63500, 'CH-CO', 'Chimie générale et chimie organique'),
(636, 0, 0, 6, 0, 255, 63600, 'CH-GI', 'Chimie générale et inorganique'),
(637, 0, 0, 6, 0, 255, 63700, 'MOSPH', 'Module sciences physiques'),
(638, 0, 0, 6, 0, 255, 63800, 'CH-OR', 'Chimie organique'),
(639, 0, 0, 6, 0, 255, 63900, 'CH-AM', 'Chimie appliquée aux matériaux'),
(640, 0, 0, 6, 0, 255, 64000, 'MA-MO', 'Mathématiques module'),
(641, 0, 0, 6, 0, 255, 64100, 'OPEAC', 'Optique électronique acoustique'),
(642, 0, 0, 6, 0, 255, 64200, 'PH-CM', 'Physique chimie module'),
(643, 0, 0, 6, 0, 255, 64300, 'SPHSA', 'Sciences physiques et sciences appliquées'),
(644, 0, 0, 6, 0, 255, 64400, 'SVTMO', 'Sciences de la vie et de la terre module'),
(645, 0, 0, 6, 0, 255, 64500, 'SCNAT', 'Sciences naturelles'),
(646, 0, 0, 6, 0, 255, 64600, 'LABO', 'Laboratoire'),
(647, 0, 0, 6, 0, 255, 64700, 'SPHPA', 'Sciences physiques et physique appliquée'),
(648, 0, 0, 6, 0, 255, 64800, 'UIFCH', 'Utilisation de l''informatique en chimie'),
(649, 0, 0, 6, 0, 255, 64900, 'IESP', 'Informatique et électronique en sc ph'),
(650, 0, 0, 6, 0, 255, 65000, 'STATI', 'Statistiques'),
(651, 0, 0, 6, 0, 255, 65100, 'MA-AQ', 'Mathématiques appliquées et statistiques'),
(652, 0, 0, 6, 0, 255, 65200, 'TSP', 'Techniques des sciences physiques'),
(653, 0, 0, 6, 0, 255, 65300, 'G-SCI', 'Enseignement scientifique'),
(654, 0, 0, 6, 0, 255, 65400, 'PH-MT', 'Physique : mécanique - thermique - fluidique'),
(655, 0, 0, 6, 0, 255, 65500, 'CH-AP', 'Chimie appliquée'),
(656, 0, 0, 6, 0, 255, 65600, 'OPPHC', 'Optique et physico-chimie'),
(657, 0, 0, 6, 0, 255, 65700, 'PHYSI', 'Physique'),
(658, 0, 0, 6, 0, 255, 65800, 'TPPHY', 'Travaux pratiques de physique'),
(659, 0, 0, 6, 0, 255, 65900, 'TPCHI', 'Travaux pratiques de chimie'),
(660, 0, 0, 6, 0, 255, 66000, 'TECSH', 'Technologie et schéma'),
(661, 0, 0, 6, 0, 255, 66100, 'CSCTE', 'Cadre scientifique et technologique'),
(662, 0, 0, 6, 0, 255, 66200, 'SCEXP', 'Sciences expérimentales'),
(663, 0, 0, 6, 0, 255, 66300, 'MA-AS', 'Mathématiques appliquées spécialité'),
(664, 0, 0, 6, 0, 255, 66400, 'MA-SP', 'Mathématiques spécialité'),
(665, 0, 0, 6, 0, 255, 66500, 'PH-CS', 'Physique chimie spécialité'),
(666, 0, 0, 6, 0, 255, 66600, 'SVT-S', 'Sciences de la vie & de terre spécialité'),
(667, 0, 0, 6, 0, 255, 66700, 'ATGCH', 'Atelier de génie chimique'),
(668, 0, 0, 6, 0, 255, 66800, 'OPTIQ', 'Optique'),
(669, 0, 0, 6, 0, 255, 66900, 'SPHCA', 'Sciences phys et physique chimie appliquées'),
(670, 0, 0, 6, 0, 255, 67000, 'S-IND', 'Sciences industrielles'),
(671, 0, 0, 6, 0, 255, 67100, 'CHI-4', 'Chimie (4 heures cpge : pcsi)'),
(672, 0, 0, 6, 0, 255, 67200, 'CHI-2', 'Chimie (2eme periode cpge : psi)'),
(673, 0, 0, 6, 0, 255, 67300, 'SC-IG', 'Sciences de l''ingénieur'),
(674, 0, 0, 6, 0, 255, 67400, 'CH-TC', 'Chimie et technologie chimique'),
(675, 0, 0, 6, 0, 255, 67500, 'PH-TP', 'Physique et technologie physique'),
(676, 0, 0, 6, 0, 255, 67600, 'S-IN4', 'Sciences indust 4 heures 2e période mpsi'),
(677, 0, 0, 6, 0, 255, 67700, 'S-IN2', 'Sciences industr 2 heures mpsi'),
(678, 0, 0, 6, 0, 255, 67800, 'PHCHA', 'Physique appliquée - chimie appliquée'),
(679, 0, 0, 6, 0, 255, 67900, 'OPTGP', 'Optique géométrique et physique'),
(680, 0, 0, 6, 0, 255, 68000, 'ETSOP', 'Étude technique des systèmes optiques'),
(681, 0, 0, 6, 0, 255, 68100, 'SPCHA', 'Sciences physiques et chimie appliquée'),
(682, 0, 0, 6, 0, 255, 68200, 'PCMET', 'Physique chimie métallurgie'),
(683, 0, 0, 6, 0, 255, 68300, 'AIMAT', 'Aide individualisée en mathématiques'),
(684, 0, 0, 6, 0, 255, 68400, 'MAPSP', 'Mathématiques appliquées sc physiques'),
(685, 0, 0, 6, 0, 255, 68500, 'MATPC', 'Mathématiques physique-chimie'),
(686, 0, 0, 6, 0, 255, 68600, 'MASPC', 'Mathématiques sciences physiques & chimiques'),
(687, 0, 0, 6, 0, 255, 68700, 'SCIIN', 'Sciences industrielles de l''ingénieur'),
(688, 0, 0, 6, 0, 255, 68800, 'PCLAB', 'Physique et chimie de laboratoire'),
(689, 0, 0, 6, 0, 255, 68900, 'MPHIN', 'Mesures physiques et informatique'),
(690, 0, 0, 6, 0, 255, 69000, 'ISING', 'Initiation aux sciences de l''ingénieur'),
(691, 0, 0, 6, 0, 255, 69100, 'PHYAP', 'Physique appliquée'),
(692, 0, 0, 6, 0, 255, 69200, 'PAUDI', 'Perception auditive'),
(693, 0, 0, 6, 0, 255, 69300, 'PVISU', 'Perception visuelle'),
(694, 0, 0, 6, 0, 255, 69400, 'SPHCH', 'Sciences physiques et chimiques'),
(695, 0, 0, 6, 0, 255, 69500, 'SPCAP', 'Sciences physiques&chimiques appliquées'),
(696, 0, 0, 6, 0, 255, 69600, 'MP-SC', 'Méthodes & pratiques scientifiques'),
(697, 0, 0, 6, 0, 255, 69700, 'SCLAB', 'Sciences physiques et chimiques en laboratoire'),
(698, 0, 0, 6, 0, 255, 69800, 'MATAP', 'Mathématiques approfondies'),
(699, 0, 0, 6, 0, 255, 69900, 'SCDIV', 'Sciences divers'),
(701, 0, 0, 7, 0, 255, 70100, 'TECTD', 'Technologie et travaux dirigés'),
(702, 0, 0, 7, 0, 255, 70200, 'TECRE', 'Technologie et réalisation'),
(703, 0, 0, 7, 0, 255, 70300, 'TECAV', 'Technologie appliquée au véhicule'),
(704, 0, 0, 7, 0, 255, 70400, 'MESAU', 'Mesures et automatismes'),
(705, 0, 0, 7, 0, 255, 70500, 'T-IND', 'Techniques industrielles'),
(706, 0, 0, 7, 0, 255, 70600, 'TECAI', 'Technologie et automatismes industriels'),
(707, 0, 0, 7, 0, 255, 70700, 'CNTRE', 'Contrôle et régulation'),
(708, 0, 1, 7, 0, 255, 70800, 'TECHN', 'Technologie'),
(709, 0, 0, 7, 0, 255, 70900, 'TECGL', 'Technologie générale'),
(710, 0, 0, 7, 0, 255, 71000, 'ENPRO', 'Enseignement professionnel'),
(711, 0, 0, 7, 0, 255, 71100, 'G-TPR', 'Enseignement technologique-professionnel'),
(712, 0, 0, 7, 0, 255, 71200, 'T-REA', 'Technique et réalisation'),
(713, 0, 0, 7, 0, 255, 71300, 'TECIN', 'Technologie industrielle'),
(714, 0, 0, 7, 0, 255, 71400, 'TECMT', 'Technologie appliquée moteur-transmission'),
(715, 0, 0, 7, 0, 255, 71500, 'D-TEC', 'Dessin et technologie'),
(716, 0, 0, 7, 0, 255, 71600, 'TECPR', 'Technologie professionnelle'),
(717, 0, 0, 7, 0, 255, 71700, 'TECTA', 'Technologie et travaux d''atelier'),
(718, 0, 0, 7, 0, 255, 71800, 'TECIM', 'Technologie industrielle module'),
(719, 0, 0, 7, 0, 255, 71900, 'ATCTK', 'Atelier de conception - technologie'),
(720, 0, 0, 7, 0, 255, 72000, 'TREAL', 'Technologie de réalisation'),
(721, 0, 0, 7, 0, 255, 72100, 'TECME', 'Technologie : métallurgie'),
(722, 0, 0, 7, 0, 255, 72200, 'TECDE', 'Technologie et dessin'),
(723, 0, 0, 7, 0, 255, 72300, 'TECES', 'Technologie des équipements et supports'),
(724, 0, 0, 7, 0, 255, 72400, 'T-MEO', 'Techniques et mise en œuvre'),
(725, 0, 0, 7, 0, 255, 72500, 'TMNUM', 'Technologie des médias numériques'),
(726, 0, 0, 7, 0, 255, 72600, 'MOETP', 'Module: enseign. techno. et professionnel.'),
(727, 0, 0, 7, 0, 255, 72700, 'ETDIF', 'Enseignement technologique différencié'),
(728, 0, 0, 7, 0, 255, 72800, 'QUAEX', 'Qualité expérimentation'),
(729, 0, 0, 7, 0, 255, 72900, 'NOUTK', 'Nouvelles technologies'),
(730, 0, 0, 7, 0, 255, 73000, 'TCMET', 'Technologie - méthodes'),
(731, 0, 0, 7, 0, 255, 73100, 'SCTCI', 'Sciences et techniques industrielles'),
(732, 0, 0, 7, 0, 255, 73200, 'ENSTC', 'Enseignement technique'),
(733, 0, 0, 7, 0, 255, 73300, 'TMMED', 'Technologie multimédia'),
(734, 0, 0, 7, 0, 255, 73400, 'FUTIL', 'Fonction utilisateur'),
(735, 0, 0, 7, 0, 255, 73500, 'CITEC', 'Création & innovation technologiques'),
(736, 0, 0, 7, 0, 255, 73600, 'INTEC', 'Innovation technologique et éco-conception'),
(737, 0, 0, 7, 0, 255, 73700, 'ETT', 'Enseignements technologiques transversaux'),
(738, 0, 0, 7, 0, 255, 73800, 'STECH', 'Sciences et technologie'),
(739, 0, 0, 7, 0, 255, 73900, 'TFABR', 'Technologie de fabrication'),
(740, 0, 0, 7, 0, 255, 74000, 'TPROF', 'Technologies professionnelles'),
(741, 0, 0, 7, 0, 255, 74100, 'ETP', 'Enseignements techniques et professionnels'),
(742, 0, 0, 7, 0, 255, 74200, 'TTPRO', 'Technologie & techniques professionnelles'),
(799, 0, 0, 7, 0, 255, 79900, 'TECDI', 'Technologie divers'),
(800, 0, 0, 8, 0, 255, 81000, 'EMUGT', 'Education musicale générale et technique'),
(801, 0, 0, 8, 0, 255, 80100, 'HIMCO', 'Histoire musique - critique œuvres enregistrées'),
(802, 0, 0, 8, 0, 255, 80200, 'DISTI', 'Dictée - solfège - technique instrumentale'),
(803, 0, 0, 8, 0, 255, 80300, 'DISOL', 'Dictée - solfège'),
(804, 0, 0, 8, 0, 255, 80400, 'T-INS', 'Technique instrumentale'),
(805, 0, 0, 8, 0, 255, 80500, 'DISTM', 'Dictée - solfège - théorie musicale'),
(806, 0, 0, 8, 0, 255, 80600, 'ENITM', 'Ensemble instrumental'),
(807, 0, 0, 8, 0, 255, 80700, 'HARMO', 'Harmonie'),
(808, 0, 0, 8, 0, 255, 80800, 'SOLFG', 'Solfège'),
(809, 0, 0, 8, 0, 255, 80900, 'CHANK', 'Chant choral'),
(811, 0, 0, 8, 0, 255, 81100, 'PCVOI', 'Pratique collective vocale ou instrumentale'),
(812, 0, 0, 8, 0, 255, 81200, 'N-MUS', 'Enseignement musical'),
(813, 0, 1, 8, 0, 255, 81300, 'EDMUS', 'Education musicale'),
(814, 0, 0, 8, 0, 255, 81400, 'MUSI5', 'Musique 5 heures'),
(815, 0, 0, 8, 0, 255, 81500, 'DANS5', 'Danse 5 heures'),
(816, 0, 0, 8, 0, 255, 81600, 'EXEIN', 'Exécution instrumentale'),
(817, 0, 0, 8, 0, 255, 81700, 'EXECH', 'Exécution chorégraphique'),
(818, 0, 0, 8, 0, 255, 81800, 'HIMUS', 'Histoire de la musique'),
(819, 0, 0, 8, 0, 255, 81900, 'I-OMU', 'Initiation aux œuvres musicales'),
(820, 0, 0, 8, 0, 255, 82000, 'DIMUS', 'Dictée musicale'),
(821, 0, 0, 8, 0, 255, 82100, 'ANALY', 'Analyse'),
(822, 0, 0, 8, 0, 255, 82200, 'LECVI', 'Lecture à vue instrumentale'),
(823, 0, 0, 8, 0, 255, 82300, 'MUSEN', 'Musique d''ensemble'),
(824, 0, 0, 8, 0, 255, 82400, 'HARSO', 'Harmonie ou solfège'),
(825, 0, 0, 8, 0, 255, 82500, 'DANSE', 'Danse'),
(826, 0, 0, 8, 0, 255, 82600, 'PR-IS', 'Pratique instrumentale'),
(827, 0, 0, 8, 0, 255, 82700, 'TECIV', 'Technologie instrumentale et vocale'),
(828, 0, 0, 8, 0, 255, 82800, 'KORAL', 'Chorale'),
(829, 0, 0, 8, 0, 255, 82900, 'TPENR', 'Travaux pratiques d''enregistrement'),
(830, 0, 0, 8, 0, 255, 83000, 'HASOK', 'Harmonie ou solfège ou chorégraphie'),
(831, 0, 0, 8, 0, 255, 83100, 'CHANT', 'Chant'),
(832, 0, 0, 8, 0, 255, 83200, 'MUSIQ', 'Musique'),
(833, 0, 0, 8, 0, 255, 83300, 'HIMUD', 'Histoire de la musique et de la danse'),
(834, 0, 0, 8, 0, 255, 83400, 'N-ART', 'Enseignement artistique'),
(835, 0, 0, 8, 0, 255, 83500, 'AP-MU', 'Atelier de pratique : musique'),
(836, 0, 0, 8, 0, 255, 83600, 'MUSPE', 'Musique spécialité'),
(837, 0, 0, 8, 0, 255, 83700, 'MUSPA', 'Musique option - pratique artistique'),
(838, 0, 0, 8, 0, 255, 83800, 'MUSCO', 'Musicologie'),
(839, 0, 0, 8, 0, 255, 83900, 'FOMUS', 'Formation musicale'),
(840, 0, 0, 8, 0, 255, 84000, 'ENSVI', 'Ensemble vocal et/ou instrumental'),
(841, 0, 0, 8, 0, 255, 84100, 'CMFOR', 'Culture musicale formation de l''oreille'),
(842, 0, 0, 8, 0, 255, 84200, 'FINST', 'Formation instrumentale'),
(843, 0, 0, 8, 0, 255, 84300, 'CHKO', 'Chant choral collectif'),
(844, 0, 0, 8, 0, 255, 84400, 'FVOCA', 'Formation vocale'),
(845, 0, 0, 8, 0, 255, 84500, 'HIS-M', 'Histoire des instruments - styles et musicologie'),
(846, 0, 0, 8, 0, 255, 84600, 'CHORE', 'Culture chorégraphique'),
(847, 0, 0, 8, 0, 255, 84700, 'CMUSI', 'Culture musicale'),
(848, 0, 0, 8, 0, 255, 84800, 'ATSON', 'Atelier son'),
(849, 0, 0, 8, 0, 255, 84900, 'A-SON', 'Arts du son'),
(899, 0, 0, 8, 0, 255, 89900, 'EDMUD', 'Education musicale divers'),
(901, 0, 1, 9, 0, 255, 90100, 'A-PLA', 'Arts plastiques'),
(902, 0, 0, 9, 0, 255, 90200, 'APLA5', 'Arts plastiques 5 heures'),
(903, 0, 0, 9, 0, 255, 90300, 'A-VIS', 'Arts visuels'),
(904, 0, 0, 9, 0, 255, 90400, 'EDEST', 'Education esthétique'),
(905, 0, 0, 9, 0, 255, 90500, 'EDART', 'Education artistique'),
(906, 0, 0, 9, 0, 255, 90600, 'I-EST', 'Initiation esthétique'),
(907, 0, 0, 9, 0, 255, 90700, 'GRAPH', 'Graphisme'),
(908, 0, 0, 9, 0, 255, 90800, 'VOLUM', 'Volume'),
(909, 0, 0, 9, 0, 255, 90900, 'COULR', 'Couleur'),
(910, 0, 0, 9, 0, 255, 91000, 'AP-AP', 'Atelier de pratique : arts plastiques'),
(911, 0, 0, 9, 0, 255, 91100, 'A-PSP', 'Arts plastiques spécialité'),
(912, 0, 0, 9, 0, 255, 91200, 'A-PPA', 'Arts plastiques option - pratique artistique'),
(913, 0, 0, 9, 0, 255, 91300, 'TROID', 'Compréhension 3d'),
(914, 0, 0, 9, 0, 255, 91400, 'FESTH', 'Formation esthétique (sai)'),
(915, 0, 0, 9, 0, 255, 91500, 'AT-3D', 'Atelier 3d'),
(916, 0, 0, 9, 0, 255, 91600, 'CVISU', 'Culture visuelle'),
(917, 0, 0, 9, 0, 255, 91700, 'CPHOV', 'Culture photographique et visuelle'),
(918, 0, 0, 9, 0, 255, 91800, 'CDESG', 'Culture du design graphique'),
(919, 0, 0, 9, 0, 255, 91900, 'CTYPO', 'Culture typographique'),
(920, 0, 0, 9, 0, 255, 92000, 'PPGRA', 'Pratique plastique & graphique'),
(921, 0, 0, 9, 0, 255, 92100, 'DANAL', 'Dessin analytique'),
(998, 0, 0, 9, 0, 255, 99800, 'AEART', 'Accompagnement éducatif - pratique art.culturel'),
(999, 0, 0, 9, 0, 255, 99900, 'A-PLD', 'Arts plastiques divers'),
(1001, 0, 1, 10, 0, 255, 100100, 'EPS', 'Education physique et sportive'),
(1002, 0, 0, 10, 0, 255, 100200, 'ACSPS', 'Activités sportives spécialisées'),
(1003, 0, 0, 10, 0, 255, 100300, 'EQUIT', 'Equitation'),
(1004, 0, 0, 10, 0, 255, 100400, 'ESCRI', 'Escrime'),
(1005, 0, 0, 10, 0, 255, 100500, 'EPSPA', 'Education physique et sportive de plein air'),
(1006, 0, 0, 10, 0, 255, 100600, 'AP-PP', 'Atelier de pratique : prat phys sport'),
(1007, 0, 0, 10, 0, 255, 100700, 'ATHLE', 'Athlétisme'),
(1008, 0, 0, 10, 0, 255, 100800, 'AVIRO', 'Aviron'),
(1009, 0, 0, 10, 0, 255, 100900, 'BASKT', 'Basket-ball'),
(1010, 0, 0, 10, 0, 255, 101000, 'FOOTB', 'Football'),
(1011, 0, 0, 10, 0, 255, 101100, 'GYMGA', 'Gymnastique garçons'),
(1012, 0, 0, 10, 0, 255, 101200, 'GYMNA', 'Gymnastique'),
(1013, 0, 0, 10, 0, 255, 101300, 'HANDB', 'Handball'),
(1014, 0, 0, 10, 0, 255, 101400, 'JUDO', 'Judo'),
(1015, 0, 0, 10, 0, 255, 101500, 'NATAT', 'Natation'),
(1016, 0, 0, 10, 0, 255, 101600, 'RUGBY', 'Rugby'),
(1017, 0, 0, 10, 0, 255, 101700, 'SKI', 'Ski'),
(1018, 0, 0, 10, 0, 255, 101800, 'TENIS', 'Tennis'),
(1019, 0, 0, 10, 0, 255, 101900, 'TENIT', 'Tennis de table'),
(1020, 0, 0, 10, 0, 255, 102000, 'TIRAC', 'Tir à l''arc'),
(1021, 0, 0, 10, 0, 255, 102100, 'VOLEY', 'Volley Ball'),
(1022, 0, 0, 10, 0, 255, 102200, 'ESCAL', 'Escalade'),
(1023, 0, 0, 10, 0, 255, 102300, 'SKIFD', 'Ski de fond'),
(1025, 0, 0, 10, 0, 255, 102500, 'HPPEQ', 'Hippologie et équitation'),
(1026, 0, 0, 10, 0, 255, 102600, 'AP-PS', 'Atelier de pratique phys et sportives'),
(1027, 0, 0, 10, 0, 255, 102700, 'CANOK', 'Canoë kayak'),
(1028, 0, 0, 10, 0, 255, 102800, 'GYMRS', 'Gymnastique rythmique et sportive'),
(1029, 0, 0, 10, 0, 255, 102900, 'PAROU', 'Patinage artistique sur roulettes'),
(1030, 0, 0, 10, 0, 255, 103000, 'GLADS', 'Sports de glace (danse sur glace)'),
(1031, 0, 0, 10, 0, 255, 103100, 'VOLEF', 'Volley-ball féminin'),
(1032, 0, 0, 10, 0, 255, 103200, 'VOLEM', 'Volley-ball masculin'),
(1033, 0, 0, 10, 0, 255, 103300, 'SPAQT', 'Sport aquatique'),
(1034, 0, 0, 10, 0, 255, 103400, 'CYCLI', 'Cyclisme'),
(1035, 0, 0, 10, 0, 255, 103500, 'VOILE', 'Voile'),
(1036, 0, 0, 10, 0, 255, 103600, 'GOLF', 'Golf'),
(1037, 0, 0, 10, 0, 255, 103700, 'EPS5H', 'Education physique sportive (5 heures)'),
(1038, 0, 0, 10, 0, 255, 103800, 'ATEPS', 'Atelier d''éducation physique et sportive'),
(1039, 0, 0, 10, 0, 255, 103900, 'EPS4H', 'Education physique sportive (4 heures)'),
(1040, 0, 0, 10, 0, 255, 104000, 'EPSDE', 'Educ physique sportive de détermination'),
(1041, 0, 0, 10, 0, 255, 104100, 'EPSCO', 'Educ physique et sportive de complément'),
(1042, 0, 0, 10, 0, 255, 104200, 'COURS', 'Courses athlétiques'),
(1043, 0, 0, 10, 0, 255, 104300, 'SAUTS', 'Sauts athlétiques'),
(1044, 0, 0, 10, 0, 255, 104400, 'LANCE', 'Lancers athlétiques'),
(1045, 0, 0, 10, 0, 255, 104500, 'VTT', 'VTT'),
(1046, 0, 0, 10, 0, 255, 104600, 'BICRS', 'Bicross'),
(1047, 0, 0, 10, 0, 255, 104700, 'HALMU', 'Haltérophile et musculation'),
(1048, 0, 0, 10, 0, 255, 104800, 'ARMAR', 'Arts martiaux (autres que le judo)'),
(1049, 0, 0, 10, 0, 255, 104900, 'GRYTM', 'Gymnastique rythmique'),
(1050, 0, 0, 10, 0, 255, 105000, 'GAERO', 'Gymnastique aérobique'),
(1051, 0, 0, 10, 0, 255, 105100, 'GACRO', 'Gymnastique acrobatique'),
(1052, 0, 0, 10, 0, 255, 105200, 'ROLLE', 'Activités sportives sur rollers'),
(1053, 0, 0, 10, 0, 255, 105300, 'GAGRE', 'Gymnastique aux agrès'),
(1054, 0, 0, 10, 0, 255, 105400, 'GSOL', 'Gymnastique au sol'),
(1055, 0, 0, 10, 0, 255, 105500, 'GDOUC', 'Gymnastiques douces'),
(1056, 0, 0, 10, 0, 255, 105600, 'PVOIL', 'Planche à voile'),
(1057, 0, 0, 10, 0, 255, 105700, 'TRIAT', 'Triathlon'),
(1058, 0, 0, 10, 0, 255, 105800, 'LUTTE', 'Luttes'),
(1059, 0, 0, 10, 0, 255, 105900, 'BOXE', 'Boxe'),
(1060, 0, 0, 10, 0, 255, 106000, 'BOXFR', 'Boxe française'),
(1061, 0, 0, 10, 0, 255, 106100, 'BADMI', 'Badminton'),
(1062, 0, 0, 10, 0, 255, 106200, 'BASEB', 'Baseball'),
(1063, 0, 0, 10, 0, 255, 106300, 'GARTI', 'Gymnastique artistique'),
(1064, 0, 0, 10, 0, 255, 106400, 'ULTIM', 'Ultimate'),
(1065, 0, 0, 10, 0, 255, 106500, 'SUBAQ', 'Activités sportives subaquatiques'),
(1066, 0, 0, 10, 0, 255, 106600, 'TERNA', 'Activités sportives terrestres de pleine nature'),
(1067, 0, 0, 10, 0, 255, 106700, 'ACIRQ', 'Activités sportives de cirque'),
(1068, 0, 0, 10, 0, 255, 106800, 'AQUNA', 'Activités sportives aquatiques de pleine nature'),
(1069, 0, 0, 10, 0, 255, 106900, 'SUBAN', 'Activités sportives subaquatiques de pleine nature'),
(1070, 0, 0, 10, 0, 255, 107000, 'RAQUE', 'Raquette'),
(1071, 0, 0, 10, 0, 255, 107100, 'GLACE', 'Sports de glace'),
(1072, 0, 0, 10, 0, 255, 107200, 'AMONT', 'Activités sportives de montagne'),
(1073, 0, 0, 10, 0, 255, 107300, 'CHARV', 'Char a voiles'),
(1074, 0, 0, 10, 0, 255, 107400, 'CORPS', 'Connaissance du corps'),
(1075, 0, 0, 10, 0, 255, 107500, 'EPSEE', 'EPS enseignement d''exploration'),
(1098, 0, 0, 10, 0, 255, 109800, 'AESPO', 'Accompagnemt éducatif - pratique sportive'),
(1099, 0, 0, 10, 0, 255, 109900, 'EPSDI', 'EPS divers'),
(1102, 0, 0, 11, 0, 255, 110200, 'ATTSE', 'Atelier techno spécialité ébénisterie'),
(1103, 0, 0, 11, 0, 255, 110300, 'HIAAS', 'Histoire de l''art et analyse des styles'),
(1105, 0, 0, 11, 0, 255, 110500, 'ETFAB', 'Étude de fabrication'),
(1106, 0, 0, 11, 0, 255, 110600, 'ETSYC', 'Étude des systèmes constructifs'),
(1107, 0, 0, 11, 0, 255, 110700, 'TPFAS', 'TP: fabrication - site'),
(1108, 0, 0, 11, 0, 255, 110800, 'TECSP', 'Technologie de spécialité'),
(1109, 0, 0, 11, 0, 255, 110900, 'CALST', 'Calcul des structures'),
(1110, 0, 0, 11, 0, 255, 111000, 'TECEB', 'Technologie générale ébénisterie'),
(1111, 0, 0, 11, 0, 255, 111100, 'TECSE', 'Technologie spécialité ébénisterie'),
(1112, 0, 0, 11, 0, 255, 111200, 'P-OR', 'Préparation et organisation'),
(1113, 0, 0, 11, 0, 255, 111300, 'R-GIB', 'Réalisation et contrôle (gen indus bois)'),
(1114, 0, 0, 11, 0, 255, 111400, 'HISTY', 'Histoire des styles'),
(1115, 0, 0, 11, 0, 255, 111500, 'TECCN', 'Technologie et construction'),
(1116, 0, 0, 11, 0, 255, 111600, 'XYLOG', 'Xylologie'),
(1117, 0, 0, 11, 0, 255, 111700, 'A-TMH', 'Arts et tech du mobilier et de l''habitat'),
(1118, 0, 0, 11, 0, 255, 111800, 'BUREM', 'Bureau d''études méthodes fabrication pos'),
(1119, 0, 0, 11, 0, 255, 111900, 'HYGSP', 'Hygiène sécurité prévention'),
(1120, 0, 0, 11, 0, 255, 112000, 'MRMNB', 'Monographie reco.macr.negoce du bois'),
(1121, 0, 0, 11, 0, 255, 112100, 'APINP', 'Applications industrielles papeterie'),
(1122, 0, 0, 11, 0, 255, 112200, 'EQBOI', 'Equipements annexes des industries du bois'),
(1123, 0, 0, 11, 0, 255, 112300, 'ATSPE', 'Atelier spécialité ébénisterie'),
(1124, 0, 0, 11, 0, 255, 112400, 'MESPP', 'Mesures et modèles processus papetiers'),
(1125, 0, 0, 11, 0, 255, 112500, 'TECIP', 'Technologie des industries papetières'),
(1126, 0, 0, 11, 0, 255, 112600, 'EFPAP', 'Étude fonction et structures des systèmes'),
(1127, 0, 0, 11, 0, 255, 112700, 'ERPAP', 'Et.relat.produits-procédés (génie papetier)'),
(1128, 0, 0, 11, 0, 255, 112800, 'ESPAP', 'Étude systémique process (génie papetier)'),
(1129, 0, 0, 11, 0, 255, 112900, 'CPPAP', 'Conduite des process (génie papetier)'),
(1130, 0, 0, 11, 0, 255, 113000, 'EEPBA', 'Expérimentation et essais (prod bois-am)'),
(1131, 0, 0, 11, 0, 255, 113100, 'ETINT', 'Étude d''industrialisation et technologie'),
(1132, 0, 0, 11, 0, 255, 113200, 'QUALB', 'Qualité (productique bois ameublement)'),
(1133, 0, 0, 11, 0, 255, 113300, 'FSECB', 'Fabrication et sécurité (prod bois am )'),
(1134, 0, 0, 11, 0, 255, 113400, 'E-TMT', 'Étude techno moyens de transfo (génie papetier)'),
(1135, 0, 0, 11, 0, 255, 113500, 'MOGMT', 'Mise en o. gest.moyens de transf.(g.pap)'),
(1136, 0, 0, 11, 0, 255, 113600, 'DEVPR', 'Développement de produits'),
(1137, 0, 0, 11, 0, 255, 113700, 'REAPR', 'Réalisation de produits'),
(1138, 0, 0, 11, 0, 255, 113800, 'ETARC', 'Étude architecturale'),
(1139, 0, 0, 11, 0, 255, 113900, 'ETPRP', 'Étude et préparation de projet'),
(1199, 0, 0, 11, 0, 255, 119900, 'GNIBD', 'Génie industriel du bois divers'),
(1201, 0, 0, 12, 0, 255, 120100, 'D-PRJ', 'Dessin et projet'),
(1202, 0, 0, 12, 0, 255, 120200, 'TECAT', 'Technologie application et travaux pratiques'),
(1203, 0, 0, 12, 0, 255, 120300, 'D-PAR', 'Dessin professionnel artistique'),
(1204, 0, 0, 12, 0, 255, 120400, 'TECCP', 'Technologie de complément'),
(1205, 0, 0, 12, 0, 255, 120500, 'CTPRD', 'Construction du produit'),
(1206, 0, 0, 12, 0, 255, 120600, 'D-APF', 'Dessin applique à la profession'),
(1207, 0, 0, 12, 0, 255, 120700, 'MOEUV', 'Mise en œuvre'),
(1208, 0, 0, 12, 0, 255, 120800, 'TECCM', 'Technologie construction mach - étude matériels'),
(1209, 0, 0, 12, 0, 255, 120900, 'FA-TC', 'Fabrication (textile et cuir)'),
(1210, 0, 0, 12, 0, 255, 121000, 'ETMTR', 'Étude du matériau'),
(1211, 0, 0, 12, 0, 255, 121100, 'D-TKM', 'Dessin technique machines'),
(1212, 0, 0, 12, 0, 255, 121200, 'D-PRO', 'Dessin professionnel'),
(1213, 0, 0, 12, 0, 255, 121300, 'MONOB', 'Mise en œuvre de l''ennoblissement'),
(1214, 0, 0, 12, 0, 255, 121400, 'SPTMO', 'Sciences physiques et techno de matières d''œuvre'),
(1215, 0, 0, 12, 0, 255, 121500, 'ETSET', 'Étude des systèmes d''entretien articles textiles'),
(1216, 0, 0, 12, 0, 255, 121600, 'PRD-T', 'Product m en oeuvre des proc entretien textiles'),
(1217, 0, 0, 12, 0, 255, 121700, 'TECCC', 'Technologie de construction chaussures'),
(1218, 0, 0, 12, 0, 255, 121800, 'TPTKA', 'Travaux pratiques et techno d''application'),
(1219, 0, 0, 12, 0, 255, 121900, 'D-TXT', 'Dessin technique (textile et cuir)'),
(1220, 0, 0, 12, 0, 255, 122000, 'N-PCH', 'Enseignement professionnel chaussures'),
(1221, 0, 0, 12, 0, 255, 122100, 'TECGF', 'Technologie générale de fabrication'),
(1222, 0, 0, 12, 0, 255, 122200, 'TPHSP', 'TP:hygiène-sécur.prod.-réglages-rel.hum.'),
(1223, 0, 0, 12, 0, 255, 122300, 'TPTXT', 'Travaux pratiques (textile et cuir)'),
(1224, 0, 0, 12, 0, 255, 122400, 'COUPE', 'Coupe (trace moulage)'),
(1225, 0, 0, 12, 0, 255, 122500, 'O-IND', 'Organisation industrielle'),
(1226, 0, 0, 12, 0, 255, 122600, 'F-EST', 'Formation esthétique'),
(1227, 0, 0, 12, 0, 255, 122700, 'CUIRT', 'Cuir brut et tannerie'),
(1228, 0, 0, 12, 0, 255, 122800, 'TECFA', 'Technologie de fabrication'),
(1229, 0, 0, 12, 0, 255, 122900, 'G-OST', 'Gestion-organ scient travail'),
(1230, 0, 0, 12, 0, 255, 123000, 'CH-AE', 'Chimie appliquée à l''ennoblissement'),
(1234, 0, 0, 12, 0, 255, 123400, 'CDIRP', 'Conception dévelop. industrialisation realisation produits'),
(1240, 0, 0, 12, 0, 255, 124000, 'GNIND', 'Génie industriel'),
(1241, 0, 0, 12, 0, 255, 124100, 'LGTEC', 'Langage technique'),
(1242, 0, 0, 12, 0, 255, 124200, 'ATCGP', 'Atelier-controles et gestion de product'),
(1299, 0, 0, 12, 0, 255, 129900, 'GNITD', 'Génie industriel textile et cuir divers'),
(1301, 0, 0, 13, 0, 255, 130100, 'TPMIR', 'Travaux pratiques miroiterie'),
(1302, 0, 0, 13, 0, 255, 130200, 'ATTP', 'Atelier TP (famille 13)'),
(1303, 0, 0, 13, 0, 255, 130300, 'R-EF', 'Réalisation d''ensembles fonctionnels'),
(1304, 0, 0, 13, 0, 255, 130400, 'SCAPF', 'Sciences appliquées à la profession'),
(1305, 0, 0, 13, 0, 255, 130500, 'TPFAB', 'Travaux pratiques de fabrication'),
(1306, 0, 0, 13, 0, 255, 130600, 'CP-EO', 'Conception produits - étude outillages'),
(1307, 0, 0, 13, 0, 255, 130700, 'MPMEO', 'Matériaux et procédés de mise en œuvre'),
(1308, 0, 0, 13, 0, 255, 130800, 'T-DEC', 'Techniques de décoration'),
(1309, 0, 0, 13, 0, 255, 130900, 'SYOPT', 'Système optique'),
(1310, 0, 0, 13, 0, 255, 131000, 'PROPT', 'Production optique'),
(1311, 0, 0, 13, 0, 255, 131100, 'PRMEC', 'Production mécanique (optique)'),
(1399, 0, 0, 13, 0, 255, 139900, 'GNVCD', 'Génie industriel verre et céramique div'),
(1402, 0, 0, 14, 0, 255, 140200, 'P-OFC', 'Prep et organis fabrication et contrôle'),
(1403, 0, 0, 14, 0, 255, 140300, 'METAL', 'Métallurgie'),
(1404, 0, 0, 14, 0, 255, 140400, 'TRACG', 'Traçage'),
(1405, 0, 0, 14, 0, 255, 140500, 'ESOUT', 'Étude des systèmes d''outillage'),
(1406, 0, 0, 14, 0, 255, 140600, 'EPROC', 'Étude des processus'),
(1407, 0, 0, 14, 0, 255, 140700, 'LABSM', 'Laboratoire (structures métalliques)'),
(1408, 0, 0, 14, 0, 255, 140800, 'REASM', 'Réalisation'),
(1409, 0, 0, 14, 0, 255, 140900, 'ESYST', 'Étude des systèmes str métalliques'),
(1410, 0, 0, 14, 0, 255, 141000, 'TGQPR', 'Technologie gestion qualité prévention'),
(1411, 0, 0, 14, 0, 255, 141100, 'EMMPG', 'Etud moulage méthode prep gest product'),
(1412, 0, 0, 14, 0, 255, 141200, 'MEORL', 'MEO réalisation (fabrication essais contrôles)'),
(1413, 0, 0, 14, 0, 255, 141300, 'TTTUY', 'Technologie - traçage - tuyauterie'),
(1414, 0, 0, 14, 0, 255, 141400, 'GPDVQ', 'Gestion de production - devis - qualité'),
(1415, 0, 0, 14, 0, 255, 141500, 'PCHAN', 'Préparation du travail - chantier'),
(1416, 0, 0, 14, 0, 255, 141600, 'TKMEO', 'Techniques de mise en œuvre'),
(1417, 0, 0, 14, 0, 255, 141700, 'RPROJ', 'Thème (réalisation projet)'),
(1418, 0, 0, 14, 0, 255, 141800, 'MOUGR', 'Moulage gravitaire'),
(1419, 0, 0, 14, 0, 255, 141900, 'MOUSP', 'Moulage sous pression'),
(1420, 0, 0, 14, 0, 255, 142000, 'EPRDT', 'Étude de produits'),
(1421, 0, 0, 14, 0, 255, 142100, 'PPROD', 'Préparation de la production'),
(1422, 0, 0, 14, 0, 255, 142200, 'EMOAF', 'Et.&m.en œuvre alliag de fond.&mat.conx'),
(1499, 0, 0, 14, 0, 255, 149900, 'GNSMD', 'Génie ind structures métal divers'),
(1501, 0, 0, 15, 0, 255, 150100, 'EVEXI', 'Environnement externe et interne'),
(1502, 0, 0, 15, 0, 255, 150200, 'T-CO', 'Techniques connexes (stoc manu trans meca)'),
(1503, 0, 0, 15, 0, 255, 150300, 'CA-PC', 'Conception et analyse (plastiques composites)'),
(1504, 0, 0, 15, 0, 255, 150400, 'CH-MP', 'Chimie matières plastiques');
INSERT INTO `sacoche_matiere` (`matiere_id`, `matiere_active`, `matiere_usuelle`, `matiere_famille_id`, `matiere_nb_demandes`, `matiere_ordre`, `matiere_code`, `matiere_ref`, `matiere_nom`) VALUES
(1505, 0, 0, 15, 0, 255, 150500, 'MOPMM', 'Mise oeuv.plast. - maint.matériels essais'),
(1506, 0, 0, 15, 0, 255, 150600, 'ETFGR', 'Étude fonctionnelle et graphique'),
(1507, 0, 0, 15, 0, 255, 150700, 'TPAPC', 'TP atelier (plastiques composites)'),
(1508, 0, 0, 15, 0, 255, 150800, 'ETRIP', 'Étude et réalisation industr de produits'),
(1509, 0, 0, 15, 0, 255, 150900, 'ROMOP', 'Réalisation outillage pr mise œuvre plastique'),
(1510, 0, 0, 15, 0, 255, 151000, 'ETCMP', 'Étude et contrôle matériaux et produc'),
(1511, 0, 0, 15, 0, 255, 151100, 'CT-OU', 'Conception des outillages'),
(1512, 0, 0, 15, 0, 255, 151200, 'O-FAB', 'Organisation des fabrications'),
(1513, 0, 0, 15, 0, 255, 151300, 'ETMLA', 'Étude des matériaux et laboratoire'),
(1514, 0, 0, 15, 0, 255, 151400, 'ETMDT', 'Étude matériaux et div tech trans plas'),
(1515, 0, 0, 15, 0, 255, 151500, 'TPMDE', 'TP de maintenance-dépannage équipements'),
(1516, 0, 0, 15, 0, 255, 151600, 'MPOSP', 'Materiaux - procedés orga - suivi product'),
(1517, 0, 0, 15, 0, 255, 151700, 'LAOTP', 'Labo - analyse - mise œuvre techno produits'),
(1518, 0, 0, 15, 0, 255, 151800, 'CT-PL', 'Conception (plastiques composites)'),
(1519, 0, 0, 15, 0, 255, 151900, 'PH-AM', 'Physique appliquée aux matériaux'),
(1520, 0, 0, 15, 0, 255, 152000, 'PRD-C', 'Productions et contrôles'),
(1521, 0, 0, 15, 0, 255, 152100, 'CTCPO', 'Construction conception pièces outillage'),
(1522, 0, 0, 15, 0, 255, 152200, 'P-OTR', 'Préparation organisation travail'),
(1523, 0, 0, 15, 0, 255, 152300, 'O-BMT', 'Organisation production: bureau méthodes'),
(1524, 0, 0, 15, 0, 255, 152400, 'TEPRO', 'Technologie étude de procédés'),
(1525, 0, 0, 15, 0, 255, 152500, 'LANGT', 'Langage technique plasturgie'),
(1526, 0, 0, 15, 0, 255, 152600, 'PSCQG', 'Production suivi contrôle qualité gestion'),
(1527, 0, 0, 15, 0, 255, 152700, 'MCOMP', 'Matériaux composites'),
(1528, 0, 0, 15, 0, 255, 152800, 'TCMPC', 'Technologie contrôle matériaux (plastiques composites)'),
(1529, 0, 0, 15, 0, 255, 152900, 'MEOPC', 'Mise en œuvre (plastiques composites)'),
(1530, 0, 0, 15, 0, 255, 153000, 'QSEPC', 'Organisation et qse (plastiques composites)'),
(1531, 0, 0, 15, 0, 255, 153100, 'IP-PC', 'Industrialisation projet (plastiques composites)'),
(1532, 0, 0, 15, 0, 255, 153200, 'MPOPC', 'Mainten processus outillage (plastiques composites)'),
(1599, 0, 0, 15, 0, 255, 159900, 'GNIPD', 'Génie indus plastiques divers'),
(1601, 0, 0, 16, 0, 255, 160100, 'TECGC', 'Technologie et génie chimique'),
(1602, 0, 0, 16, 0, 255, 160200, 'CH-ME', 'Chimie - métallurgie'),
(1603, 0, 0, 16, 0, 255, 160300, 'TECGQ', 'Technologie-gestion de la qualité-prod'),
(1604, 0, 0, 16, 0, 255, 160400, 'MT-DA', 'Méthodes de développement d''une application'),
(1605, 0, 0, 16, 0, 255, 160500, 'MAPLI', 'Montage d''appareils (laboratoire indus )'),
(1606, 0, 0, 16, 0, 255, 160600, 'T-FBR', 'Techniques de fabrication'),
(1607, 0, 0, 16, 0, 255, 160700, 'GENCH', 'Génie chimique'),
(1699, 0, 0, 16, 0, 255, 169900, 'GNCHD', 'Génie chimique divers'),
(1701, 0, 0, 17, 0, 255, 170100, 'D-GCV', 'Dessin (génie civil)'),
(1702, 0, 0, 17, 0, 255, 170200, 'TOPOG', 'Topographie'),
(1703, 0, 0, 17, 0, 255, 170300, 'GR3DV', 'Gr3 (devis-et couts-prix-compta trav-pr)'),
(1704, 0, 0, 17, 0, 255, 170400, 'CO-BA', 'Connaissances de base'),
(1705, 0, 0, 17, 0, 255, 170500, 'PRJBA', 'Projet de bâtiment'),
(1706, 0, 0, 17, 0, 255, 170600, 'R-TEM', 'Réalisation:topographie - essais - mesures-c'),
(1707, 0, 0, 17, 0, 255, 170700, 'PDATP', 'Projet : dessin d''architecture et travaux pratiques'),
(1708, 0, 0, 17, 0, 255, 170800, 'PXDOI', 'Principaux domaines d''intervention'),
(1709, 0, 0, 17, 0, 255, 170900, 'VPTTP', 'Visite et présentation techniques (TP)'),
(1710, 0, 0, 17, 0, 255, 171000, 'CRQCO', 'Croquis cote'),
(1711, 0, 0, 17, 0, 255, 171100, 'R-TVX', 'Réalisation études et travaux'),
(1712, 0, 0, 17, 0, 255, 171200, 'ESSMC', 'Essais - mesures - contrôle'),
(1713, 0, 0, 17, 0, 255, 171300, 'T-AF', 'Technique améliorations foncières'),
(1714, 0, 0, 17, 0, 255, 171400, 'MAKET', 'Maquette'),
(1715, 0, 0, 17, 0, 255, 171500, 'PHGRA', 'Photogrammétrie'),
(1716, 0, 0, 17, 0, 255, 171600, 'ARCCO', 'Architectures et composants'),
(1717, 0, 0, 17, 0, 255, 171700, 'R-OUV', 'Réalisation des ouvrages'),
(1718, 0, 0, 17, 0, 255, 171800, 'R-GCV', 'Réalisation et contrôle (génie civil)'),
(1719, 0, 0, 17, 0, 255, 171900, 'P-CCH', 'Préparation et conduite de chantier'),
(1720, 0, 0, 17, 0, 255, 172000, 'TOPOL', 'Topologie'),
(1721, 0, 0, 17, 0, 255, 172100, 'METRE', 'Métré et étude de coûts'),
(1722, 0, 0, 17, 0, 255, 172200, 'O-CMO', 'Orga et gestion chantier-mise en œuvre'),
(1723, 0, 0, 17, 0, 255, 172300, 'P-CHT', 'Préparation de chantier'),
(1724, 0, 0, 17, 0, 255, 172400, 'EOMST', 'Et.ouvr.:meca stru.-techno constructions'),
(1725, 0, 0, 17, 0, 255, 172500, 'GR5PM', 'Gr5 (techno proc meth-droit-regle const)'),
(1726, 0, 0, 17, 0, 255, 172600, 'CADAS', 'Cadastre'),
(1727, 0, 0, 17, 0, 255, 172700, 'CALTO', 'Calculs topométriques'),
(1728, 0, 0, 17, 0, 255, 172800, 'GODSI', 'Géodésie'),
(1729, 0, 0, 17, 0, 255, 172900, 'D-HAC', 'Dessin arts appliqués - histoire architect construct'),
(1730, 0, 0, 17, 0, 255, 173000, 'TOPTA', 'Topographie (thème et application)'),
(1731, 0, 0, 17, 0, 255, 173100, 'GR4GD', 'Gr4 (dcs-geometrie descri.-tcs-mrm)'),
(1732, 0, 0, 17, 0, 255, 173200, 'ETCGC', 'Étude des constructions (génie civil)'),
(1733, 0, 0, 17, 0, 255, 173300, 'ECPRP', 'Et.ct prix-real.piec.ecrit-org.p.d.const'),
(1734, 0, 0, 17, 0, 255, 173400, 'TECNU', 'Technologie des TP notions d''urbanisme'),
(1735, 0, 0, 17, 0, 255, 173500, 'ARCHI', 'Architecture'),
(1736, 0, 0, 17, 0, 255, 173600, 'MENCH', 'Menuiserie charpente'),
(1737, 0, 0, 17, 0, 255, 173700, 'ELBAT', 'Électricité du bâtiment'),
(1738, 0, 0, 17, 0, 255, 173800, 'TPELC', 'TP d''électricité'),
(1739, 0, 0, 17, 0, 255, 173900, 'PLBSA', 'Plomberie sanitaire'),
(1740, 0, 0, 17, 0, 255, 174000, 'BATIM', 'Bâtiment'),
(1741, 0, 0, 17, 0, 255, 174100, 'MACON', 'Maçonnerie'),
(1742, 0, 0, 17, 0, 255, 174200, 'T-BAT', 'Technique du bâtiment'),
(1743, 0, 0, 17, 0, 255, 174300, 'ARCON', 'Architecture de la construction'),
(1744, 0, 0, 17, 0, 255, 174400, 'FABMI', 'Fabrication mise en œuvre'),
(1745, 0, 0, 17, 0, 255, 174500, 'CONST', 'Construction'),
(1746, 0, 0, 17, 0, 255, 174600, 'E-OUV', 'Études des ouvrages'),
(1747, 0, 0, 17, 0, 255, 174700, 'COTOP', 'Connaissances topographiques'),
(1748, 0, 0, 17, 0, 255, 174800, 'DIGEO', 'Domaines d''intervention du géomètre'),
(1749, 0, 0, 17, 0, 255, 174900, 'COOTX', 'Coordination de travaux'),
(1750, 0, 0, 17, 0, 255, 175000, 'GCMTP', 'Génie civil et matériels travaux publics'),
(1751, 0, 0, 17, 0, 255, 175100, 'PO-GC', 'Projet d''ouvrage (génie civil)'),
(1752, 0, 0, 17, 0, 255, 175200, 'ARCHC', 'Architecture et construction'),
(1753, 0, 0, 17, 0, 255, 175300, 'AHUDD', 'Architecture, habitat & urbanisme, développement durable'),
(1754, 0, 0, 17, 0, 255, 175400, 'GENCI', 'Génie civil'),
(1799, 0, 0, 17, 0, 255, 179900, 'GNCID', 'Génie civil divers'),
(1801, 0, 0, 18, 0, 255, 180100, 'MOSYS', 'Mise en œuvre des systèmes'),
(1802, 0, 0, 18, 0, 255, 180200, 'TMFAV', 'Thermo meca fluide appliquée véhicule'),
(1803, 0, 0, 18, 0, 255, 180300, 'TMDPP', 'Thermodynamique thermopropulsion'),
(1804, 0, 0, 18, 0, 255, 180400, 'AMFVU', 'Aérodynamique mécanique des fluides-vol.-tec.util'),
(1805, 0, 0, 18, 0, 255, 180500, 'ETCSY', 'Étude et conception des systèmes'),
(1806, 0, 0, 18, 0, 255, 180600, 'ETSYS', 'Étude des systèmes'),
(1807, 0, 0, 18, 0, 255, 180700, 'ETITL', 'Étude des installations'),
(1808, 0, 0, 18, 0, 255, 180800, 'R-INS', 'Réalisation et contrôle installations'),
(1809, 0, 0, 18, 0, 255, 180900, 'TMDMF', 'Thermodynamique mécanique des fluides'),
(1810, 0, 0, 18, 0, 255, 181000, 'OSTCH', 'Ost-chaudronnerie'),
(1811, 0, 0, 18, 0, 255, 181100, 'PREPA', 'Préparation'),
(1812, 0, 0, 18, 0, 255, 181200, 'FLDEG', 'Fluidique et énergétique'),
(1813, 0, 0, 18, 0, 255, 181300, 'FLDEA', 'Fluidique et énergétique appliquées'),
(1814, 0, 0, 18, 0, 255, 181400, 'TMDTM', 'Thermodynamique et thermique'),
(1815, 0, 0, 18, 0, 255, 181500, 'ENFLE', 'Énergétique fluidique environnement'),
(1816, 0, 0, 18, 0, 255, 181600, 'RMOPT', 'Réalisation mise en œuvre procédures (génie thermique)'),
(1817, 0, 0, 18, 0, 255, 181700, 'ENENV', 'Énergies et environnement'),
(1899, 0, 0, 18, 0, 255, 189900, 'GNTHD', 'Génie thermique divers'),
(1901, 0, 0, 19, 0, 255, 190100, 'D-CAT', 'Dessin de construction atelier'),
(1902, 0, 0, 19, 0, 255, 190200, 'PD-CT', 'Productique construction'),
(1903, 0, 0, 19, 0, 255, 190300, 'D-CTR', 'Dessin de construction'),
(1904, 0, 0, 19, 0, 255, 190400, 'ME-TS', 'Mécanique et technologie des structures'),
(1905, 0, 0, 19, 0, 255, 190500, 'D-IMC', 'Dessin industriel mécanique'),
(1906, 0, 0, 19, 0, 255, 190600, 'CTAUT', 'Construction et automatisme'),
(1907, 0, 0, 19, 0, 255, 190700, 'CTMAT', 'Construction mécanique appliquée techno'),
(1908, 0, 0, 19, 0, 255, 190800, 'P-MCM', 'Prepar orga méthode const moules modèles'),
(1909, 0, 0, 19, 0, 255, 190900, 'TECPA', 'Technologie securité prévention accidents travail'),
(1910, 0, 0, 19, 0, 255, 191000, 'TPEFB', 'Travaux pratiques étude fabrication'),
(1911, 0, 0, 19, 0, 255, 191100, 'TECMX', 'Technologie des matériaux'),
(1912, 0, 0, 19, 0, 255, 191200, 'CT', 'Construction (famille 19)'),
(1913, 0, 0, 19, 0, 255, 191300, 'ETCST', 'Étude des constructions'),
(1914, 0, 0, 19, 0, 255, 191400, 'CTMEC', 'Construction mécanique'),
(1915, 0, 0, 19, 0, 255, 191500, 'ME-CT', 'Mécanique et construction'),
(1916, 0, 0, 19, 0, 255, 191600, 'T-TCM', 'Techniques graph techno constr des machines'),
(1917, 0, 0, 19, 0, 255, 191700, 'D-TGD', 'Dessin technique - géométrie descriptive'),
(1918, 0, 0, 19, 0, 255, 191800, 'TDATG', 'Trav.dirigés analy.technique et expr.gra'),
(1919, 0, 0, 19, 0, 255, 191900, 'OBPRD', 'Obtention des produits'),
(1920, 0, 0, 19, 0, 255, 192000, 'INPRD', 'Industrialisation des produits'),
(1922, 0, 0, 19, 0, 255, 192200, 'EXMMA', 'Étude expe maintenance mater agricoles'),
(1923, 0, 0, 19, 0, 255, 192300, 'COMST', 'Comportement des systèmes techniques'),
(1924, 0, 0, 19, 0, 255, 192400, 'ETAER', 'Étude de l''aeronef et de ses systèmes'),
(1925, 0, 0, 19, 0, 255, 192500, 'PRPRO', 'Préparation de production'),
(1999, 0, 0, 19, 0, 255, 199900, 'GNMCD', 'Génie meca construction divers'),
(2001, 0, 0, 20, 0, 255, 200100, 'P-OMF', 'Préparation-organisation : méthodes-fabrication-contrôle'),
(2002, 0, 0, 20, 0, 255, 200200, 'INSTR', 'Instrumentation'),
(2003, 0, 0, 20, 0, 255, 200300, 'ME-ID', 'Mécanique industrielle'),
(2004, 0, 0, 20, 0, 255, 200400, 'MECAN', 'Mécanique'),
(2005, 0, 0, 20, 0, 255, 200500, 'PD-PO', 'Productique : préparation organisation'),
(2006, 0, 0, 20, 0, 255, 200600, 'ME-MX', 'Mécanique et résistance des matériaux'),
(2007, 0, 0, 20, 0, 255, 200700, 'ETMAI', 'Étude des mécanismes et autom indust'),
(2008, 0, 0, 20, 0, 255, 200800, 'ETCMA', 'Étude système (construction-mécanismes-automatismes)'),
(2009, 0, 0, 20, 0, 255, 200900, 'TSA', 'Technologie des systèmes automatisés'),
(2013, 0, 0, 20, 0, 255, 201300, 'D-TTC', 'Dessin technique technologie de construction'),
(2014, 0, 0, 20, 0, 255, 201400, 'PJTCT', 'Projet et technologie de construction'),
(2015, 0, 0, 20, 0, 255, 201500, 'MESUR', 'Mesures'),
(2016, 0, 0, 20, 0, 255, 201600, 'D-ITC', 'Dessin industriel et tech construction'),
(2017, 0, 0, 20, 0, 255, 201700, 'AUTMT', 'Automatismes'),
(2018, 0, 0, 20, 0, 255, 201800, 'MOPIN', 'Mise en œuvre des processus industriels'),
(2019, 0, 0, 20, 0, 255, 201900, 'P-ORG', 'Préparation - organisation'),
(2020, 0, 0, 20, 0, 255, 202000, 'DFPRC', 'Définition des processus'),
(2021, 0, 0, 20, 0, 255, 202100, 'CTDNI', 'Construction et dessin industriel'),
(2022, 0, 0, 20, 0, 255, 202200, 'ATAUM', 'Atelier automatismes mesures'),
(2023, 0, 0, 20, 0, 255, 202300, 'ASAIF', 'Automatisation systèmes automatisés informatique'),
(2024, 0, 0, 20, 0, 255, 202400, 'USIMS', 'Usinage m.s.'),
(2025, 0, 0, 20, 0, 255, 202500, 'AVPRJ', 'Avant-projet'),
(2026, 0, 0, 20, 0, 255, 202600, 'PROJT', 'Projet'),
(2027, 0, 0, 20, 0, 255, 202700, 'ETPMM', 'Étude : procédés - moyens - mise en œuvre'),
(2028, 0, 0, 20, 0, 255, 202800, 'R-PRQ', 'Réalisation et contrôle (productique)'),
(2029, 0, 0, 20, 0, 255, 202900, 'ANSPR', 'Analyse des syst de pro (productiq text)'),
(2031, 0, 0, 20, 0, 255, 203100, 'TPPRD', 'Travaux pratiques production'),
(2032, 0, 0, 20, 0, 255, 203200, 'ETMMP', 'Étude méthodes et moyens de production'),
(2033, 0, 0, 20, 0, 255, 203300, 'ATGMP', 'Atelier (génie mécanique productique)'),
(2034, 0, 0, 20, 0, 255, 203400, 'D-IND', 'Dessin industriel'),
(2035, 0, 0, 20, 0, 255, 203500, 'ETPOP', 'Étude des parties opératives'),
(2036, 0, 0, 20, 0, 255, 203600, 'MORFE', 'Mise œuvre-realis.(fabrication-essais-contrôle)'),
(2038, 0, 0, 20, 0, 255, 203800, 'P-OMH', 'Préparation et organisation : méthodes'),
(2039, 0, 0, 20, 0, 255, 203900, 'TPAEL', 'TP d''automatisme et d''électrotechnique'),
(2040, 0, 0, 20, 0, 255, 204000, 'R-SYS', 'Réalisation et contrôle de systèmes'),
(2041, 0, 0, 20, 0, 255, 204100, 'ETCCP', 'Étude de conception et construction de produit'),
(2042, 0, 0, 20, 0, 255, 204200, 'MITKA', 'Mesures industrielles et tech d''appareil'),
(2043, 0, 0, 20, 0, 255, 204300, 'PRODQ', 'Productique'),
(2044, 0, 0, 20, 0, 255, 204400, 'MICTK', 'Microtechniques'),
(2045, 0, 0, 20, 0, 255, 204500, 'FA-GM', 'Fabrication (génie mécanique productique)'),
(2046, 0, 0, 20, 0, 255, 204600, 'AJUST', 'Ajustage'),
(2047, 0, 0, 20, 0, 255, 204700, 'ANFAB', 'Analyse fabrication'),
(2048, 0, 0, 20, 0, 255, 204800, 'AUCMA', 'Automatismes et commande de machines'),
(2049, 0, 0, 20, 0, 255, 204900, 'RGDYI', 'Régulation et dynamique des installations'),
(2050, 0, 0, 20, 0, 255, 205000, 'MICGR', 'Micrographie'),
(2051, 0, 0, 20, 0, 255, 205100, 'ETPAC', 'Étude des parties commandes'),
(2052, 0, 0, 20, 0, 255, 205200, 'P-OSP', 'Prep org suivi productions technologie fabrication'),
(2053, 0, 0, 20, 0, 255, 205300, 'CTMOU', 'Construction - technologie des matériaux outillages'),
(2054, 0, 0, 20, 0, 255, 205400, 'CNTQU', 'Contrôle qualité'),
(2055, 0, 0, 20, 0, 255, 205500, 'TECCT', 'Technologie de construction'),
(2056, 0, 0, 20, 0, 255, 205600, 'STSYP', 'Structure des systèmes de production'),
(2057, 0, 0, 20, 0, 255, 205700, 'ME-AP', 'Mécanique appliquée'),
(2058, 0, 0, 20, 0, 255, 205800, 'PD-MO', 'Productique systèmes motorises'),
(2059, 0, 0, 20, 0, 255, 205900, 'PD-SM', 'Productique structures métalliques'),
(2060, 0, 0, 20, 0, 255, 206000, 'PD-BM', 'Productique bois et matériaux associés'),
(2061, 0, 0, 20, 0, 255, 206100, 'PD-MC', 'Productique mécanique'),
(2062, 0, 0, 20, 0, 255, 206200, 'PD-MS', 'Productique matériaux souples'),
(2063, 0, 0, 20, 0, 255, 206300, 'AUCRG', 'Automatique - contrôle et régulation'),
(2064, 0, 0, 20, 0, 255, 206400, 'SYSAU', 'Systèmes automatises'),
(2065, 0, 0, 20, 0, 255, 206500, 'ETMIC', 'Études (microtechniques)'),
(2066, 0, 0, 20, 0, 255, 206600, 'PRMIC', 'Préparation (microtechniques)'),
(2067, 0, 0, 20, 0, 255, 206700, 'EPROU', 'Étude des produits et des outillages'),
(2068, 0, 0, 20, 0, 255, 206800, 'INDMC', 'Industrialisation'),
(2069, 0, 0, 20, 0, 255, 206900, 'PROMC', 'Production'),
(2070, 0, 0, 20, 0, 255, 207000, 'PD-MT', 'Productique microtechniques'),
(2071, 0, 0, 20, 0, 255, 207100, 'C-OUT', 'Conception des outillages (product mécanique)'),
(2072, 0, 0, 20, 0, 255, 207200, 'RE-CO', 'Réalisation et contrôle'),
(2073, 0, 0, 20, 0, 255, 207300, 'G-MEC', 'Génie mécanique'),
(2074, 0, 0, 20, 0, 255, 207400, 'COPAC', 'Conception des parties de commande'),
(2075, 0, 0, 20, 0, 255, 207500, 'COPOP', 'Conception des parties opératives'),
(2076, 0, 0, 20, 0, 255, 207600, 'AELTT', 'Automatisme et électrotechnique'),
(2077, 0, 0, 20, 0, 255, 207700, 'ISYPR', 'Informatique et systèmes de production'),
(2078, 0, 0, 20, 0, 255, 207800, 'CSAUT', 'Conception des systèmes automatiques'),
(2079, 0, 0, 20, 0, 255, 207900, 'CRCLI', 'Conduite  et réalisation  projet client'),
(2080, 0, 0, 20, 0, 255, 208000, 'EPCAR', 'Étude des produits carrossés'),
(2081, 0, 0, 20, 0, 255, 208100, 'CPCAR', 'Conception des produits carrossés'),
(2082, 0, 0, 20, 0, 255, 208200, 'RPCAR', 'Réalisation des produits carrossés'),
(2099, 0, 0, 20, 0, 255, 209900, 'GNMPD', 'Génie mécanique productique divers'),
(2101, 0, 0, 21, 0, 255, 210100, 'TECCS', 'Technologie cellules et systèmes'),
(2102, 0, 0, 21, 0, 255, 210200, 'MNMEC', 'Maintenance mécanique'),
(2103, 0, 0, 21, 0, 255, 210300, 'ME-AT', 'Mécanique appliquée moteur transmission'),
(2104, 0, 0, 21, 0, 255, 210400, 'MAINT', 'Maintenance'),
(2105, 0, 0, 21, 0, 255, 210500, 'ME-AV', 'Mécanique appliquée au véhicule'),
(2106, 0, 0, 21, 0, 255, 210600, 'ANTDI', 'Analyse technique dessin industriel'),
(2107, 0, 0, 21, 0, 255, 210700, 'TPITV', 'TP intervention'),
(2108, 0, 0, 21, 0, 255, 210800, 'TPAMN', 'TP atelier (maintenance)'),
(2109, 0, 0, 21, 0, 255, 210900, 'TPCEM', 'TP : carburants - électricité - moteurs - organe'),
(2110, 0, 0, 21, 0, 255, 211000, 'TPATD', 'TP anal tech diag rep regl gest maint'),
(2111, 0, 0, 21, 0, 255, 211100, 'ETSYT', 'Étude des systèmes techniques'),
(2112, 0, 0, 21, 0, 255, 211200, 'RESMX', 'Résistance des matériaux'),
(2113, 0, 0, 21, 0, 255, 211300, 'G-MTP', 'Gestion de maintenance - technologie-TP'),
(2114, 0, 0, 21, 0, 255, 211400, 'ANFST', 'Analyse fonctionnelle et structurelle'),
(2115, 0, 0, 21, 0, 255, 211500, 'ANFSE', 'Analyse fonct. struct. esth indus'),
(2116, 0, 0, 21, 0, 255, 211600, 'ANFME', 'Analyse fonctionnelle et mécanique'),
(2117, 0, 0, 21, 0, 255, 211700, 'MT-MA', 'Méthodes de maintenance'),
(2118, 0, 0, 21, 0, 255, 211800, 'TPMHS', 'TP maintenance hygiène sécurité'),
(2119, 0, 0, 21, 0, 255, 211900, 'ESSMO', 'Essais moteur'),
(2120, 0, 0, 21, 0, 255, 212000, 'ME-VB', 'Mécanique et vibrations'),
(2121, 0, 0, 21, 0, 255, 212100, 'MEPSM', 'Modélisation étude prédictive systèmes mécaniques'),
(2122, 0, 0, 21, 0, 255, 212200, 'EMMTP', 'Etud expe maintenanc matériels trvx pub'),
(2123, 0, 0, 21, 0, 255, 212300, 'STRMT', 'Stratégie de maintenance'),
(2124, 0, 0, 21, 0, 255, 212400, 'TPMTN', 'Travaux pratiques de maintenance'),
(2125, 0, 0, 21, 0, 255, 212500, 'ACPRA', 'Activités pratiques'),
(2126, 0, 0, 21, 0, 255, 212600, 'ANFSM', 'Analyse fonction. - structur. & mécanique'),
(2127, 0, 0, 21, 0, 255, 212700, 'ORMAV', 'Organisation  maintenance & après-vente'),
(2128, 0, 0, 21, 0, 255, 212800, 'TNCIV', 'Technologie & intervention sur véhicules'),
(2129, 0, 0, 21, 0, 255, 212900, 'AMAER', 'Assemblage et maintenance des aéronefs'),
(2130, 0, 0, 21, 0, 255, 213000, 'MCMAT', 'Modélisation comportement des matériels'),
(2131, 0, 0, 21, 0, 255, 213100, 'TIMAT', 'Technologie & intervention sur matériels'),
(2132, 0, 0, 21, 0, 255, 213200, 'EPSYS', 'Étude pluritechnologique des systèmes'),
(2133, 0, 0, 21, 0, 255, 213300, 'ORMAT', 'Organisation de la maintenance'),
(2134, 0, 0, 21, 0, 255, 213400, 'TMCPR', 'Technique de maintenance conduite prévention'),
(2199, 0, 0, 21, 0, 255, 219900, 'GNMMD', 'Génie mécanique maintenance divers'),
(2201, 0, 0, 22, 0, 255, 220100, 'ELTRO', 'Électronique'),
(2202, 0, 0, 22, 0, 255, 220200, 'ETHMA', 'Étude théorique et schéma'),
(2203, 0, 0, 22, 0, 255, 220300, 'ELSIB', 'Eln et logique - servomécanismes instruments de bord'),
(2204, 0, 0, 22, 0, 255, 220400, 'P-OTS', 'Préparation organisation : technologie systèmes électriques'),
(2205, 0, 0, 22, 0, 255, 220500, 'MESES', 'Mesures et essais'),
(2206, 0, 0, 22, 0, 255, 220600, 'AUTMQ', 'Automatique'),
(2207, 0, 0, 22, 0, 255, 220700, 'ESSYS', 'Essai de systèmes'),
(2208, 0, 0, 22, 0, 255, 220800, 'ELTAP', 'Électrotechnique électronique appliquée'),
(2209, 0, 0, 22, 0, 255, 220900, 'R-SEL', 'Réalisation cont syst électroniques'),
(2210, 0, 0, 22, 0, 255, 221000, 'ELETR', 'Électricité et électronique'),
(2211, 0, 0, 22, 0, 255, 221100, 'APPEM', 'Applications pratiques - essais et mesures'),
(2212, 0, 0, 22, 0, 255, 221200, 'TECSC', 'Technologie syst commande regul auto :schéma'),
(2213, 0, 0, 22, 0, 255, 221300, 'REGUL', 'Régulation'),
(2214, 0, 0, 22, 0, 255, 221400, 'ELOII', 'Électronique - informatique industrielle'),
(2215, 0, 0, 22, 0, 255, 221500, 'ANMOS', 'Analyse et mise en œuvre des systèmes'),
(2216, 0, 0, 22, 0, 255, 221600, 'THSIG', 'Théorie du signal'),
(2217, 0, 0, 22, 0, 255, 221700, 'ELPUI', 'Électronique de puissance'),
(2218, 0, 0, 22, 0, 255, 221800, 'ELCOM', 'Électronique et communications'),
(2220, 0, 0, 22, 0, 255, 222000, 'ELOAI', 'Électronique automatique informatique indus'),
(2221, 0, 0, 22, 0, 255, 222100, 'G-ELC', 'Génie électrique'),
(2222, 0, 0, 22, 0, 255, 222200, 'GEIAP', 'Génie électrique - informatique appliquée'),
(2223, 0, 0, 22, 0, 255, 222300, 'ELIOP', 'Electron informatiq ind optoelectroniq'),
(2224, 0, 0, 22, 0, 255, 222400, 'AIIAL', 'Automatique informatique indus électronique'),
(2225, 0, 0, 22, 0, 255, 222500, 'TSENS', 'Technologie sensitométrie'),
(2226, 0, 0, 22, 0, 255, 222600, 'TQUIP', 'Technologie équipements'),
(2227, 0, 0, 22, 0, 255, 222700, 'PDVUE', 'Prise de vue'),
(2228, 0, 0, 22, 0, 255, 222800, 'TIMAG', 'Traitement de l''image'),
(2299, 0, 0, 22, 0, 255, 229900, 'CTAUD', 'Construction et automatisme divers'),
(2301, 0, 0, 23, 0, 255, 230100, 'ELMEC', 'Électricité et mécanique'),
(2302, 0, 0, 23, 0, 255, 230200, 'TPIEL', 'TP initiation à l''électricité'),
(2303, 0, 0, 23, 0, 255, 230300, 'PH-AE', 'Physique appliquée à l''électrotechnique'),
(2304, 0, 0, 23, 0, 255, 230400, 'ELTEO', 'Électrotechnique - électronique'),
(2305, 0, 0, 23, 0, 255, 230500, 'FA-TP', 'Fabrication réalisation TP'),
(2306, 0, 0, 23, 0, 255, 230600, 'ELCHI', 'Électrochimie'),
(2307, 0, 0, 23, 0, 255, 230700, 'ELTTK', 'Électrotechnique'),
(2309, 0, 0, 23, 0, 255, 230900, 'TECTS', 'Technologie des traitements de surfaces ost'),
(2310, 0, 0, 23, 0, 255, 231000, 'R-TPA', 'Réalisation (TP appareillage et S.A)'),
(2311, 0, 0, 23, 0, 255, 231100, 'P-TOG', 'Préparation (tech ost-gest prod)'),
(2312, 0, 0, 23, 0, 255, 231200, 'ELECT', 'Électricité'),
(2313, 0, 0, 23, 0, 255, 231300, 'CTELO', 'Construction (électrotechnique)'),
(2314, 0, 0, 23, 0, 255, 231400, 'TECSF', 'Technologie schéma et fabrication'),
(2315, 0, 0, 23, 0, 255, 231500, 'R-TSU', 'Réalisation de traitements de surfaces'),
(2316, 0, 0, 23, 0, 255, 231600, 'ESSME', 'Essais mesures'),
(2317, 0, 0, 23, 0, 255, 231700, 'N-IND', 'Enseignement industriel'),
(2318, 0, 0, 23, 0, 255, 231800, 'ECLAI', 'Éclairage'),
(2319, 0, 0, 23, 0, 255, 231900, 'SONOR', 'Sonorisation'),
(2320, 0, 0, 23, 0, 255, 232000, 'CSMAE', 'Const.struct.mater.appliq. électronique'),
(2321, 0, 0, 23, 0, 255, 232100, 'SCEEL', 'Sciences appliquées électriq électroniq'),
(2322, 0, 0, 23, 0, 255, 232200, 'CSMEL', 'Const.str.mat.appliq. électrotechnique'),
(2399, 0, 0, 23, 0, 255, 239900, 'GNEED', 'Génie électrique électronique divers'),
(2401, 0, 0, 24, 0, 255, 240100, 'ARCSI', 'Architecture des systèmes informatiques'),
(2402, 0, 0, 24, 0, 255, 240200, 'MT-IF', 'Méthodes informatiques'),
(2403, 0, 0, 24, 0, 255, 240300, 'TTNUM', 'Traitements numériques'),
(2404, 0, 0, 24, 0, 255, 240400, 'IFIND', 'Informatique industrielle'),
(2405, 0, 0, 24, 0, 255, 240500, 'IFTIQ', 'Informatique'),
(2406, 0, 0, 24, 0, 255, 240600, 'TECIA', 'Technologie maternels:informatique appl'),
(2407, 0, 0, 24, 0, 255, 240700, 'IFAPL', 'Informatique appliquée'),
(2408, 0, 0, 24, 0, 255, 240800, 'ME-II', 'Mécanique automatique et informatique indus'),
(2409, 0, 0, 24, 0, 255, 240900, 'AUIFI', 'Automatique et informatique industrielle'),
(2410, 0, 0, 24, 0, 255, 241000, 'IFAUT', 'Informatique et automatismes'),
(2411, 0, 0, 24, 0, 255, 241100, 'LOGIC', 'Logiciels'),
(2412, 0, 0, 24, 0, 255, 241200, 'MOSIF', 'Mise en œuvre systèmes informatiques'),
(2413, 0, 0, 24, 0, 255, 241300, 'AUIFA', 'Automatique et informatique appliquées'),
(2414, 0, 0, 24, 0, 255, 241400, 'AULOG', 'Automatismes et logique'),
(2415, 0, 0, 24, 0, 255, 241500, 'XAO', 'XAO'),
(2416, 0, 0, 24, 0, 255, 241600, 'MANIN', 'Mise à niveau en informatique'),
(2417, 0, 0, 24, 0, 255, 241700, 'ISYST', 'Informatique système'),
(2418, 0, 0, 24, 0, 255, 241800, 'GESSI', 'Gestion des systèmes d''information'),
(2419, 0, 0, 24, 0, 255, 241900, 'BIOIL', 'Bio-informatique et informatique de laboratoire'),
(2420, 0, 0, 24, 0, 255, 242000, 'SINUM', 'Systèmes d''information et numérique'),
(2421, 0, 0, 24, 0, 255, 242100, 'INFRE', 'Informatique et réseaux'),
(2499, 0, 0, 24, 0, 255, 249900, 'GNEID', 'Génie électrique inform electro divers'),
(2501, 0, 0, 25, 0, 255, 250100, 'IMPRE', 'Impression'),
(2502, 0, 0, 25, 0, 255, 250200, 'FINIT', 'Finition'),
(2503, 0, 0, 25, 0, 255, 250300, 'P-FIM', 'Préparation de la forme imprimante'),
(2504, 0, 0, 25, 0, 255, 250400, 'EX-GR', 'Expression graphique'),
(2505, 0, 0, 25, 0, 255, 250500, 'TXPCP', 'Trav.prof.conduite production'),
(2506, 0, 0, 25, 0, 255, 250600, 'T-FAB', 'Technique de fabrication'),
(2507, 0, 0, 25, 0, 255, 250700, 'TECPT', 'Technologie professionnelle et travaux pratiques'),
(2508, 0, 0, 25, 0, 255, 250800, 'TECPG', 'Technologie des syst de production graphique'),
(2509, 0, 0, 25, 0, 255, 250900, 'DFPGR', 'Définition des proces production graphique'),
(2510, 0, 0, 25, 0, 255, 251000, 'PD-GR', 'Productique graphique'),
(2511, 0, 0, 25, 0, 255, 251100, 'TECSI', 'Technologie des syst d''information graphique'),
(2512, 0, 0, 25, 0, 255, 251200, 'O-OPG', 'Org mise en œuvre processus graphiques'),
(2513, 0, 0, 25, 0, 255, 251300, 'CMNGR', 'Communication graphique'),
(2514, 0, 0, 25, 0, 255, 251400, 'HIECR', 'Histoire sémiologie métamorph écritures'),
(2515, 0, 0, 25, 0, 255, 251500, 'D-TYP', 'Calligraphie dessin typographie mise en page'),
(2516, 0, 0, 25, 0, 255, 251600, 'TYPNU', 'Typographie numérique et informatique'),
(2517, 0, 0, 25, 0, 255, 251700, 'ATGRA', 'Atelier (arts graphiques)'),
(2518, 0, 0, 25, 0, 255, 251800, 'LABEG', 'Laboratoire expérimentations graphiques'),
(2599, 0, 0, 25, 0, 255, 259900, 'IGRAD', 'Industrie graphiques divers'),
(2601, 0, 0, 26, 0, 255, 260100, 'EXPTR', 'Exploitation des transports'),
(2602, 0, 0, 26, 0, 255, 260200, 'MMSOU', 'Motorisation meca soudure'),
(2603, 0, 0, 26, 0, 255, 260300, 'ENCOQ', 'Entretien des coques'),
(2604, 0, 0, 26, 0, 255, 260400, 'CO-NA', 'Connaissance du navire'),
(2605, 0, 0, 26, 0, 255, 260500, 'HYDSD', 'Hydrostatique et hydrodynamique'),
(2606, 0, 0, 26, 0, 255, 260600, 'LOGTQ', 'Logistique'),
(2607, 0, 0, 26, 0, 255, 260700, 'MANMC', 'Manutention mécanisée'),
(2608, 0, 0, 26, 0, 255, 260800, 'FEOTL', 'Faisab. eval. Opérations transport logis'),
(2609, 0, 0, 26, 0, 255, 260900, 'OGOTL', 'Org.meo gest. Opérations transport logis'),
(2610, 0, 0, 26, 0, 255, 261000, 'SVOTL', 'Suivi opérations transport logistique'),
(2699, 0, 0, 26, 0, 255, 269900, 'AUTAC', 'Autres activités (conduite-navigation)dv'),
(2701, 0, 0, 27, 0, 255, 270100, 'ATTKA', 'Atelier et technologie appliquée'),
(2702, 0, 0, 27, 0, 255, 270200, 'EDAAA', 'Education artistique - arts appliqués - ana'),
(2703, 0, 0, 27, 0, 255, 270300, 'ARCIE', 'Archi interieure et expression plastique'),
(2704, 0, 0, 27, 0, 255, 270400, 'A-CTA', 'Arts et civil;techniques agencement et habitat'),
(2705, 0, 0, 27, 0, 255, 270500, 'A-APP', 'Arts appliqués'),
(2706, 0, 0, 27, 0, 255, 270600, 'PLAST', 'Plastique'),
(2707, 0, 0, 27, 0, 255, 270700, 'ORGAN', 'Organologie'),
(2708, 0, 0, 27, 0, 255, 270800, 'TXPRO', 'Travaux professionnels'),
(2709, 0, 0, 27, 0, 255, 270900, 'TECEP', 'Technologie spec -ethique-org profes legisla'),
(2710, 0, 0, 27, 0, 255, 271000, 'BCCRE', 'Bureau de création : créations'),
(2711, 0, 0, 27, 0, 255, 271100, 'BCTEP', 'Bureau de création : tvx et études prat'),
(2712, 0, 0, 27, 0, 255, 271200, 'BCREA', 'Bureau de création : réalisation'),
(2713, 0, 0, 27, 0, 255, 271300, 'EDARA', 'Education artistique arts appliqués'),
(2714, 0, 0, 27, 0, 255, 271400, 'BCCOM', 'Bureau de création : communication'),
(2715, 0, 0, 27, 0, 255, 271500, 'MODCR', 'Modes convent. représentation'),
(2716, 0, 0, 27, 0, 255, 271600, 'D-ARA', 'Dessin d''arts appliqués'),
(2717, 0, 0, 27, 0, 255, 271700, 'BURET', 'Bureau d''étude'),
(2718, 0, 0, 27, 0, 255, 271800, 'HIATK', 'Histoire des arts et des techniques'),
(2719, 0, 0, 27, 0, 255, 271900, 'EDPAA', 'Education plastique et arts appliqués'),
(2720, 0, 0, 27, 0, 255, 272000, 'TECAP', 'Technologie approfondissement'),
(2721, 0, 0, 27, 0, 255, 272100, 'CPAAD', 'Composition art applique aux domaines'),
(2722, 0, 0, 27, 0, 255, 272200, 'ESTAP', 'Esthétique appliquée à la profession'),
(2723, 0, 0, 27, 0, 255, 272300, 'TXEPR', 'Travaux et études pratiques'),
(2724, 0, 0, 27, 0, 255, 272400, 'CREAT', 'Créativité'),
(2725, 0, 0, 27, 0, 255, 272500, 'T-GRA', 'Technique graphique'),
(2726, 0, 0, 27, 0, 255, 272600, 'D-TAC', 'Dessin-technologie-atelier de création'),
(2727, 0, 0, 27, 0, 255, 272700, 'PERSP', 'Perspective'),
(2728, 0, 0, 27, 0, 255, 272800, 'ETDOC', 'Étude documentaire'),
(2729, 0, 0, 27, 0, 255, 272900, 'TECTP', 'Technologie et travaux pratiques'),
(2730, 0, 0, 27, 0, 255, 273000, 'CPARA', 'Composition d''arts appliqués'),
(2731, 0, 0, 27, 0, 255, 273100, 'TTGRA', 'Traitements graphiques'),
(2732, 0, 0, 27, 0, 255, 273200, 'EDAEI', 'Education artistique et esthétique indus'),
(2733, 0, 0, 27, 0, 255, 273300, 'BCCRC', 'Bureau de création : création céramique'),
(2734, 0, 0, 27, 0, 255, 273400, 'BCCPL', 'Bureau de création : création plastique'),
(2735, 0, 0, 27, 0, 255, 273500, 'ATCTS', 'Atelier création reali-techno specialit'),
(2736, 0, 0, 27, 0, 255, 273600, 'BCAIN', 'Bureau création architecture intérieure'),
(2737, 0, 0, 27, 0, 255, 273700, 'BCSCM', 'Bureau création style et croquis de mode'),
(2738, 0, 0, 27, 0, 255, 273800, 'BCCTX', 'Bureau de création : création textile'),
(2739, 0, 0, 27, 0, 255, 273900, 'RPLAS', 'Recherches plastiques'),
(2740, 0, 0, 27, 0, 255, 274000, 'CAATR', 'Comp arts appl et tech repres projets'),
(2741, 0, 0, 27, 0, 255, 274100, 'EX-PC', 'Expres plastique dessin création volume'),
(2742, 0, 0, 27, 0, 255, 274200, 'A-ATX', 'Arts appliqués aux textiles'),
(2743, 0, 0, 27, 0, 255, 274300, 'BCDNT', 'Bureau de création:TP et dessin technique'),
(2744, 0, 0, 27, 0, 255, 274400, 'T-PPG', 'Techniques de prod pub graph et audio'),
(2745, 0, 0, 27, 0, 255, 274500, 'ERGON', 'Ergonomie'),
(2746, 0, 0, 27, 0, 255, 274600, 'HIACO', 'Histoire de l''art et du costume'),
(2747, 0, 0, 27, 0, 255, 274700, 'T-HAB', 'Techniques de l''habillage'),
(2748, 0, 0, 27, 0, 255, 274800, 'T-MAE', 'Techniques maintenance - entretien'),
(2749, 0, 0, 27, 0, 255, 274900, 'ETDFO', 'Études et définitions des formes'),
(2750, 0, 0, 27, 0, 255, 275000, 'ETREA', 'Études et réalisations'),
(2751, 0, 0, 27, 0, 255, 275100, 'CREAA', 'Création artisanale'),
(2752, 0, 0, 27, 0, 255, 275200, 'CREAI', 'Création industrielle'),
(2753, 0, 0, 27, 0, 255, 275300, 'INFGR', 'Infographie'),
(2754, 0, 0, 27, 0, 255, 275400, 'CT-RE', 'Conception de réalisation'),
(2755, 0, 0, 27, 0, 255, 275500, 'T-REL', 'Techniques (ou technologie) de réalisation'),
(2756, 0, 0, 27, 0, 255, 275600, 'TECCO', 'Technologie de la communication'),
(2757, 0, 1, 27, 0, 255, 275700, 'HIDA', 'Histoire des arts'),
(2758, 0, 0, 27, 0, 255, 275800, 'D-CON', 'Dessin de conception et d''application'),
(2759, 0, 0, 27, 0, 255, 275900, 'HITEC', 'Histoire des techniques'),
(2760, 0, 0, 27, 0, 255, 276000, 'CR-DS', 'Création design'),
(2761, 0, 0, 27, 0, 255, 276100, 'CU-DS', 'Culture design'),
(2762, 0, 0, 27, 0, 255, 276200, 'STUCR', 'Studio de création'),
(2763, 0, 0, 27, 0, 255, 276300, 'ARVIS', 'Arts visuels et appliqués'),
(2764, 0, 0, 27, 0, 255, 276400, 'TEDEC', 'Techniques du décor'),
(2765, 0, 0, 27, 0, 255, 276500, 'R-DEV', 'Recherche et développement'),
(2766, 0, 0, 27, 0, 255, 276600, 'LABPV', 'Labo photo ou vidéo'),
(2767, 0, 0, 27, 0, 255, 276700, 'ARCAS', 'Étude de cas (arts appliqués)'),
(2768, 0, 0, 27, 0, 255, 276800, 'EPFRA', 'Expres plastiq fondam - recherche appliq'),
(2769, 0, 0, 27, 0, 255, 276900, 'EPRAM', 'Exp plastiq fond - recherch.appliq. max'),
(2770, 0, 0, 27, 0, 255, 277000, 'CREIP', 'Création industrielle : produit'),
(2771, 0, 0, 27, 0, 255, 277100, 'CREIE', 'Création industrielle : environnement'),
(2772, 0, 0, 27, 0, 255, 277200, 'BURCR', 'Bureau de création'),
(2773, 0, 0, 27, 0, 255, 277300, 'BCRDV', 'Bureau de création:recherche et développement'),
(2774, 0, 0, 27, 0, 255, 277400, 'RCONV', 'Représentation conventionnelle'),
(2775, 0, 0, 27, 0, 255, 277500, 'HIDA5', 'Histoire des arts 5 heures'),
(2776, 0, 0, 27, 0, 255, 277600, 'LIMNU', 'Laboratoire images numériques'),
(2777, 0, 0, 27, 0, 255, 277700, 'RDEVO', 'Représentation en dessin et volume'),
(2778, 0, 0, 27, 0, 255, 277800, 'FOGAB', 'Formes - outillage et gabarits'),
(2779, 0, 0, 27, 0, 255, 277900, 'TECHP', 'Techniques particulières'),
(2780, 0, 0, 27, 0, 255, 278000, 'ATART', 'Atelier artistique'),
(2781, 0, 0, 27, 0, 255, 278100, 'PJART', 'Projet d''art appliqué'),
(2782, 0, 0, 27, 0, 255, 278200, 'PAAHA', 'Projet art appliqué et histoire de l''art'),
(2783, 0, 0, 27, 0, 255, 278300, 'AACAR', 'Arts appliqués et cultures artistiques'),
(2784, 0, 0, 27, 0, 255, 278400, 'EQLSC', 'Équipement des lieux scéniques'),
(2785, 0, 0, 27, 0, 255, 278500, 'THEAT', 'Théâtre'),
(2786, 0, 0, 27, 0, 255, 278600, 'CIRQU', 'Arts du cirque'),
(2787, 0, 0, 27, 0, 255, 278700, 'PRPLA', 'Pratique plastique'),
(2788, 0, 0, 27, 0, 255, 278800, 'ATCON', 'Ateliers de conception'),
(2789, 0, 0, 27, 0, 255, 278900, 'CUART', 'Culture artistique et technique'),
(2790, 0, 0, 27, 0, 255, 279000, 'DCREA', 'Démarche créative'),
(2791, 0, 0, 27, 0, 255, 279100, 'COTEC', 'Communication technique'),
(2792, 0, 0, 27, 0, 255, 279200, 'ATECR', 'Atelier de création et de réalisation'),
(2793, 0, 0, 27, 0, 255, 279300, 'RCHPP', 'Recherches et pratiques plastiques'),
(2794, 0, 0, 27, 0, 255, 279400, 'A-SPE', 'Arts du spectacle'),
(2795, 0, 0, 27, 0, 255, 279500, 'PATRI', 'Patrimoines'),
(2796, 0, 0, 27, 0, 255, 279600, 'CCDES', 'Création & culture design'),
(2797, 0, 0, 27, 0, 255, 279700, 'DESAA', 'Design et arts appliqués'),
(2798, 0, 0, 27, 0, 255, 279800, 'HASCT', 'Histoire de l''art des sciences & techniques'),
(2799, 0, 0, 27, 0, 255, 279900, 'MARAD', 'Métiers d''arts appliqués divers'),
(2801, 0, 0, 28, 0, 255, 280100, 'D-GEO', 'Dessin géométrique'),
(2802, 0, 0, 28, 0, 255, 280200, 'D-ART', 'Dessin d''arts'),
(2803, 0, 0, 28, 0, 255, 280300, 'PR-AR', 'Pratique artistique'),
(2804, 0, 0, 28, 0, 255, 280400, 'HIART', 'Histoire de l''art'),
(2805, 0, 0, 28, 0, 255, 280500, 'HICIV', 'Hist civilis et de leur exp art'),
(2806, 0, 0, 28, 0, 255, 280600, 'HISDN', 'Histoire des styles et dessins'),
(2807, 0, 0, 28, 0, 255, 280700, 'D-VOL', 'Dessin : volume'),
(2808, 0, 0, 28, 0, 255, 280800, 'D-COU', 'Dessin : couleur'),
(2809, 0, 0, 28, 0, 255, 280900, 'D-DOC', 'Dessin : document'),
(2810, 0, 0, 28, 0, 255, 281000, 'CPPVO', 'Composition plane et en volume'),
(2811, 0, 0, 28, 0, 255, 281100, 'MODVO', 'Modelage et études en volume'),
(2812, 0, 0, 28, 0, 255, 281200, 'A-TKC', 'Arts - techniques et civilisation'),
(2813, 0, 0, 28, 0, 255, 281300, 'DSCRP', 'Descriptive'),
(2814, 0, 0, 28, 0, 255, 281400, 'RCHAR', 'Recherche artistique'),
(2815, 0, 0, 28, 0, 255, 281500, 'EVCRP', 'Envir culturel et recherche plastique'),
(2816, 0, 0, 28, 0, 255, 281600, 'T-SON', 'Techniques du son'),
(2817, 0, 0, 28, 0, 255, 281700, 'THED5', 'Théâtre expression dramatique 5 heures'),
(2818, 0, 0, 28, 0, 255, 281800, 'TECRL', 'Technologie relations'),
(2819, 0, 0, 28, 0, 255, 281900, 'T-EVS', 'Techniques d''express visuelle et sémiologique'),
(2820, 0, 0, 28, 0, 255, 282000, 'TECOU', 'Technologie ouverture'),
(2821, 0, 0, 28, 0, 255, 282100, 'TPRAT', 'Travaux pratiques'),
(2822, 0, 0, 28, 0, 255, 282200, 'T-EXA', 'Techniques d''expression audiovisuelle'),
(2823, 0, 0, 28, 0, 255, 282300, 'HICVI', 'Hist des arts liée à la commu visuelle'),
(2824, 0, 0, 28, 0, 255, 282400, 'TECPM', 'Technologie profession-mach spectacle'),
(2825, 0, 0, 28, 0, 255, 282500, 'DCVIS', 'Document et communication visuelle'),
(2826, 0, 0, 28, 0, 255, 282600, 'HISPC', 'Histoire du spectacle'),
(2827, 0, 0, 28, 0, 255, 282700, 'CO-MS', 'Connaissance du monde du spectacle'),
(2828, 0, 0, 28, 0, 255, 282800, 'CIAV5', 'Cinéma - audiovisuel 5 heures'),
(2829, 0, 0, 28, 0, 255, 282900, 'CMEDI', 'Comédie'),
(2830, 0, 0, 28, 0, 255, 283000, 'ETROL', 'Étude d''un rôle'),
(2831, 0, 0, 28, 0, 255, 283100, 'EX-VR', 'Expression verbale'),
(2832, 0, 0, 28, 0, 255, 283200, 'EX-CP', 'Expression corporelle'),
(2833, 0, 0, 28, 0, 255, 283300, 'SONPT', 'Sonorisation pratique'),
(2834, 0, 0, 28, 0, 255, 283400, 'ERSON', 'Enregistrements sonores'),
(2835, 0, 0, 28, 0, 255, 283500, 'ETRCO', 'Étude et réalisation de costumes'),
(2836, 0, 0, 28, 0, 255, 283600, 'ECLAR', 'Eclairagisme artistique'),
(2837, 0, 0, 28, 0, 255, 283700, 'SCENO', 'Scénographie'),
(2838, 0, 0, 28, 0, 255, 283800, 'THEAD', 'Théâtre - expression dramatique'),
(2839, 0, 0, 28, 0, 255, 283900, 'EXEMD', 'Exécution maquettes décors accessoires'),
(2840, 0, 0, 28, 0, 255, 284000, 'RGLUM', 'Réglage de la lumière'),
(2841, 0, 0, 28, 0, 255, 284100, 'RGMES', 'Réglage d''une mise en scène'),
(2842, 0, 0, 28, 0, 255, 284200, 'RLVMS', 'Relevé d''une mise en scène'),
(2843, 0, 0, 28, 0, 255, 284300, 'SCEMX', 'Sciences appliquées et étude matériaux'),
(2844, 0, 0, 28, 0, 255, 284400, 'HITHE', 'Histoire du théâtre'),
(2845, 0, 0, 28, 0, 255, 284500, 'PEMAQ', 'Perruquage maquillage'),
(2846, 0, 0, 28, 0, 255, 284600, 'RDECO', 'Recherche en décors costumes'),
(2847, 0, 0, 28, 0, 255, 284700, 'T-EPH', 'Technique et expression photographique'),
(2848, 0, 0, 28, 0, 255, 284800, 'PHOTO', 'Photographie'),
(2849, 0, 0, 28, 0, 255, 284900, 'AUDVI', 'Audiovisuel'),
(2850, 0, 0, 28, 0, 255, 285000, 'ADMTH', 'Administration (théâtre)'),
(2851, 0, 0, 28, 0, 255, 285100, 'T-EXV', 'Techniques d''expression visuelle'),
(2852, 0, 0, 28, 0, 255, 285200, 'CI-AV', 'Cinéma - audiovisuel'),
(2853, 0, 0, 28, 0, 255, 285300, 'REGIE', 'Régie'),
(2854, 0, 0, 28, 0, 255, 285400, 'CI-TG', 'Cinématographie'),
(2855, 0, 0, 28, 0, 255, 285500, 'PERUQ', 'Perruquage'),
(2856, 0, 0, 28, 0, 255, 285600, 'ACCES', 'Accessoirisme'),
(2857, 0, 0, 28, 0, 255, 285700, 'MAQIL', 'Maquillage'),
(2858, 0, 0, 28, 0, 255, 285800, 'TGOMU', 'Transpos.graphique d''une œuvre musicale'),
(2859, 0, 0, 28, 0, 255, 285900, 'EX-PL', 'Expression plastique'),
(2860, 0, 0, 28, 0, 255, 286000, 'D-EPL', 'Dessin et expression plastique'),
(2861, 0, 0, 28, 0, 255, 286100, 'SDPCC', 'Scénographie-décor-personnages conception'),
(2862, 0, 0, 28, 0, 255, 286200, 'IMANI', 'Interprétation- manipulation'),
(2863, 0, 0, 28, 0, 255, 286300, 'SDPCT', 'Scénographie-décor-personnages construction'),
(2864, 0, 0, 28, 0, 255, 286400, 'TECPL', 'Technologie du plateau'),
(2865, 0, 0, 28, 0, 255, 286500, 'EX-MU', 'Expression musicale'),
(2867, 0, 0, 28, 0, 255, 286700, 'DRAMS', 'Dramaturgie - mise en scène'),
(2868, 0, 0, 28, 0, 255, 286800, 'A-DRA', 'Art dramatique'),
(2869, 0, 0, 28, 0, 255, 286900, 'T-PHO', 'Technique photographie'),
(2870, 0, 0, 28, 0, 255, 287000, 'ACOUS', 'Acoustique'),
(2871, 0, 0, 28, 0, 255, 287100, 'AP-CA', 'Atel de pratique : cinéma - audiovisuel'),
(2872, 0, 0, 28, 0, 255, 287200, 'AP-TE', 'Atel de prat : théâtre exp dramatique'),
(2873, 0, 0, 28, 0, 255, 287300, 'CI-SP', 'Cinéma spécialité'),
(2874, 0, 0, 28, 0, 255, 287400, 'THTSP', 'Théâtre spécialité'),
(2875, 0, 0, 28, 0, 255, 287500, 'CI-PA', 'Cinéma option - pratique artistique'),
(2876, 0, 0, 28, 0, 255, 287600, 'THTPA', 'Théâtre option - pratique artistique'),
(2877, 0, 0, 28, 0, 255, 287700, 'HIASC', 'Histoire des arts et scénographie'),
(2878, 0, 0, 28, 0, 255, 287800, 'HITDR', 'Histoire du théâtre et dramaturgie'),
(2879, 0, 0, 28, 0, 255, 287900, 'SOSPC', 'Sociologie du spectacle'),
(2880, 0, 0, 28, 0, 255, 288000, 'SMACH', 'Scénographie - machinerie'),
(2881, 0, 0, 28, 0, 255, 288100, 'REGLU', 'Régie lumière'),
(2882, 0, 0, 28, 0, 255, 288200, 'CULAR', 'Culture artistique'),
(2883, 0, 0, 28, 0, 255, 288300, 'HIAGR', 'Histoire de l''art et de la gravure'),
(2884, 0, 0, 28, 0, 255, 288400, 'HIALI', 'Histoire de l''art et du livre'),
(2885, 0, 0, 28, 0, 255, 288500, 'CPLAC', 'Culture plastique - approche création'),
(2886, 0, 0, 28, 0, 255, 288600, 'CIPRO', 'Arts du cirque (enseignement professionnel)'),
(2887, 0, 0, 28, 0, 255, 288700, 'MAPRO', 'Arts marionnette (enseignement professionnel)'),
(2888, 0, 0, 28, 0, 255, 288800, 'METAO', 'Méthode d''analyse des œuvres'),
(2889, 0, 0, 28, 0, 255, 288900, 'HADEC', 'Histoire de l''art et du décor'),
(2890, 0, 0, 28, 0, 255, 289000, 'HSVCA', 'Hist spect vivant - cinéma - audiovisuel'),
(2891, 0, 0, 28, 0, 255, 289100, 'TCIRQ', 'Technique de cirque'),
(2892, 0, 0, 28, 0, 255, 289200, 'TSPEC', 'Technique de spectacle'),
(2893, 0, 0, 28, 0, 255, 289300, 'SPECS', 'Spécialisation (cirque et spectacle)'),
(2894, 0, 0, 28, 0, 255, 289400, 'ARMAQ', 'Art et maquillage'),
(2895, 0, 0, 28, 0, 255, 289500, 'RECHA', 'Recherche appliquée (arts)'),
(2896, 0, 0, 28, 0, 255, 289600, 'SMSON', 'Studio de montage et de son'),
(2897, 0, 0, 28, 0, 255, 289700, 'SFTEC', 'Studio de fabrication - technologie'),
(2898, 0, 0, 28, 0, 255, 289800, 'ATEXA', 'Atelier d''expression artistique'),
(2899, 0, 0, 28, 0, 255, 289900, 'MARDI', 'Métiers d''art divers'),
(2901, 0, 0, 29, 0, 255, 290100, 'BIJOU', 'Bijouterie'),
(2902, 0, 0, 29, 0, 255, 290200, 'CADTP', 'Compo.art appli.dom.techniq.repres.projt'),
(2999, 0, 0, 29, 0, 255, 299900, 'ARDIV', 'Artisanat divers'),
(3001, 0, 0, 30, 0, 255, 300100, 'TDBIO', 'Travaux dirigés de biologie'),
(3002, 0, 0, 30, 0, 255, 300200, 'GEOLO', 'Géologie'),
(3003, 0, 0, 30, 0, 255, 300300, 'TECSO', 'Technologie sondage'),
(3004, 0, 0, 30, 0, 255, 300400, 'ACEXT', 'Activités extérieures'),
(3005, 0, 0, 30, 0, 255, 300500, 'BLGGL', 'Biologie - géologie'),
(3006, 0, 0, 30, 0, 255, 300600, 'SCBIO', 'Sciences biologiques'),
(3007, 0, 0, 30, 0, 255, 300700, 'ETSPE', 'Étude des syst prod equip-instal usines'),
(3008, 0, 0, 30, 0, 255, 300800, 'TECAL', 'Technologie de l''alimentation'),
(3009, 0, 0, 30, 0, 255, 300900, 'ACTEC', 'Activités technologiques'),
(3010, 0, 0, 30, 0, 255, 301000, 'I-TAD', 'Init travaux d''atelier de demi-grand'),
(3011, 0, 0, 30, 0, 255, 301100, 'BLGIE', 'Biologie'),
(3012, 0, 0, 30, 0, 255, 301200, 'ARBOR', 'Arboriculture d''ornement'),
(3013, 0, 0, 30, 0, 255, 301300, 'BLGAP', 'Biologie appliquée'),
(3014, 0, 0, 30, 0, 255, 301400, 'CH-IC', 'Chimie appliquée aux industries céréalières'),
(3015, 0, 0, 30, 0, 255, 301500, 'BLGVG', 'Biologie végétale'),
(3016, 0, 0, 30, 0, 255, 301600, 'OENOL', 'Œnologie'),
(3017, 0, 0, 30, 0, 255, 301700, 'TECCE', 'Technologie des céréales'),
(3018, 0, 0, 30, 0, 255, 301800, 'BLGCM', 'Biol cellulaire et moléculaire'),
(3019, 0, 0, 30, 0, 255, 301900, 'BLGAN', 'Biologie animale'),
(3020, 0, 0, 30, 0, 255, 302000, 'MIBIO', 'Microbiologie'),
(3021, 0, 0, 30, 0, 255, 302100, 'BCHBL', 'Biochimie biologie'),
(3022, 0, 0, 30, 0, 255, 302200, 'BCHIM', 'Biochimie'),
(3023, 0, 0, 30, 0, 255, 302300, 'ALIAN', 'Alimentation animale'),
(3024, 0, 0, 30, 0, 255, 302400, 'BCHPH', 'Biochimie physiologie'),
(3025, 0, 0, 30, 0, 255, 302500, 'BCHMI', 'Biochimie microbiologie'),
(3026, 0, 0, 30, 0, 255, 302600, 'EXPRM', 'Exploitation des ressources de la mer'),
(3027, 0, 0, 30, 0, 255, 302700, 'GNRUR', 'Génie rural'),
(3028, 0, 0, 30, 0, 255, 302800, 'FA-MM', 'Fab mainten ds les dom rur et maritimes'),
(3029, 0, 0, 30, 0, 255, 302900, 'MI1TF', 'Meunerie et industries de 1ere transfor'),
(3030, 0, 0, 30, 0, 255, 303000, 'PHYSL', 'Physiologie'),
(3031, 0, 0, 30, 0, 255, 303100, 'MSPPA', 'Manipulation sci de phys papetière'),
(3032, 0, 0, 30, 0, 255, 303200, 'SAMEP', 'Sciences app mise en œuvre d''études papetières'),
(3033, 0, 0, 30, 0, 255, 303300, 'PRD-P', 'Production et transformation (papier)'),
(3034, 0, 0, 30, 0, 255, 303400, 'I-MAR', 'Initiation au milieu marin'),
(3035, 0, 0, 30, 0, 255, 303500, 'AGRON', 'Agronomie'),
(3036, 0, 0, 30, 0, 255, 303600, 'GNBTA', 'Génie biologique et techno analyse'),
(3037, 0, 0, 30, 0, 255, 303700, 'STL', 'Sciences et techno des laboratoires'),
(3038, 0, 0, 30, 0, 255, 303800, 'GLMIN', 'Géologie et minéralogie'),
(3039, 0, 0, 30, 0, 255, 303900, 'TECAC', 'Technologie des appareils correcteurs'),
(3040, 0, 0, 30, 0, 255, 304000, 'TPTAP', 'TP et technologie d''application'),
(3041, 0, 0, 30, 0, 255, 304100, 'D-TBT', 'Dessin technique (biotechnologie)'),
(3042, 0, 0, 30, 0, 255, 304200, 'TECCH', 'Technologie construction de chaussures'),
(3043, 0, 0, 30, 0, 255, 304300, 'SPBSA', 'Sciences phy bio et sciences appliquées'),
(3044, 0, 0, 30, 0, 255, 304400, 'SCBAG', 'Sciences biologiques et agronomie'),
(3045, 0, 0, 30, 0, 255, 304500, 'BLGEC', 'Biologie - écologie'),
(3046, 0, 0, 30, 0, 255, 304600, 'AGRIV', 'Agriculture et environnement'),
(3047, 0, 0, 30, 0, 255, 304700, 'AMGEV', 'Aménagement et environnement'),
(3048, 0, 0, 30, 0, 255, 304800, 'BLGEM', 'Biologie écologie module'),
(3049, 0, 0, 30, 0, 255, 304900, 'HYDRO', 'Hydraulique'),
(3050, 0, 0, 30, 0, 255, 305000, 'GNPTE', 'Génie des procédés traitement des eaux'),
(3051, 0, 0, 30, 0, 255, 305100, 'SSSOC', 'Sciences sanitaires et sociales'),
(3052, 0, 0, 30, 0, 255, 305200, 'CMNAS', 'Communication en santé et action sociale'),
(3053, 0, 0, 30, 0, 255, 305300, 'BLGHU', 'Biologie humaine'),
(3054, 0, 0, 30, 0, 255, 305400, 'AGROV', 'Agronomie et environnement'),
(3055, 0, 0, 30, 0, 255, 305500, 'BLGES', 'Biologie écologie agronomie spécialité'),
(3056, 0, 0, 30, 0, 255, 305600, 'P-CSS', 'Préparation aux concours sanitaire et social'),
(3057, 0, 0, 30, 0, 255, 305700, 'S-BT', 'Sciences biologiques et de la terre'),
(3058, 0, 0, 30, 0, 255, 305800, 'ECOAG', 'Ecologie - agronomie'),
(3059, 0, 0, 30, 0, 255, 305900, 'GEIND', 'Génie industriel bio'),
(3060, 0, 0, 30, 0, 255, 306000, 'GEPRO', 'Génie des procédés'),
(3061, 0, 0, 30, 0, 255, 306100, 'STBIO', 'Sciences et techno des bio-industries'),
(3062, 0, 0, 30, 0, 255, 306200, 'IALAB', 'Informatique appliquée au laboratoire'),
(3063, 0, 0, 30, 0, 255, 306300, 'EXPAN', 'Expérimentation animale'),
(3064, 0, 0, 30, 0, 255, 306400, 'BBM-E', 'Biochimie biologie microbiologie des eaux'),
(3065, 0, 0, 30, 0, 255, 306500, 'SCALI', 'Sciences des aliments'),
(3066, 0, 0, 30, 0, 255, 306600, 'EATCI', 'Ecologie-agronomie-territoire-citoyenneté'),
(3067, 0, 0, 30, 0, 255, 306700, 'BIOLP', 'Biologie de laboratoire et paramédicale'),
(3068, 0, 0, 30, 0, 255, 306800, 'AGTCI', 'Agronomie-territoire-citoyenneté'),
(3069, 0, 0, 30, 0, 255, 306900, 'BASAN', 'Biologie appliquée - santé'),
(3070, 0, 0, 30, 0, 255, 307000, 'BIOTA', 'Biochimie et technologies d''analyse'),
(3071, 0, 0, 30, 0, 255, 307100, 'BBCMO', 'Biochim. biologie cellulaire moléculaire'),
(3072, 0, 0, 30, 0, 255, 307200, 'MBTAN', 'Microbiologie et technologies d''analyse'),
(3073, 0, 0, 30, 0, 255, 307300, 'MBBCM', 'Microbiologie biologie cellul. Molécul.'),
(3074, 0, 0, 30, 0, 255, 307400, 'STBIN', 'Sciences technologies bio-industrielles'),
(3075, 0, 0, 30, 0, 255, 307500, 'TECBB', 'Technologies biochimiques et biologiques'),
(3076, 0, 0, 30, 0, 255, 307600, 'SCTSS', 'Scienc. & techniq. sanitaires & sociales'),
(3077, 0, 0, 30, 0, 255, 307700, 'BPPHU', 'Biologie & physiopathologie humaines'),
(3078, 0, 0, 30, 0, 255, 307800, 'BIMGG', 'Biologie moléculaire et génie génétique'),
(3079, 0, 0, 30, 0, 255, 307900, 'BANAL', 'Biochimie analytique'),
(3080, 0, 0, 30, 0, 255, 308000, 'BISFP', 'Biochimie structur.& fonction. Protéines'),
(3081, 0, 0, 30, 0, 255, 308100, 'MBIGF', 'Microbiologie et génie fermentaire'),
(3082, 0, 0, 30, 0, 255, 308200, 'BTCEL', 'Biologie et technologies cellulaires'),
(3083, 0, 0, 30, 0, 255, 308300, 'SLABO', 'Sciences & laboratoire'),
(3084, 0, 0, 30, 0, 255, 308400, 'EAEDD', 'Ecologie - ecolo.agro.territ.dev.durable'),
(3085, 0, 0, 30, 0, 255, 308500, 'BAT2D', 'Biologie agro. territoir.& devel.durable'),
(3086, 0, 0, 30, 0, 255, 308600, 'VIVAN', 'Chimie - biochimie - sciences du vivant'),
(3087, 0, 0, 30, 0, 255, 308700, 'MESIN', 'Mesure et instrumentation'),
(3088, 0, 0, 30, 0, 255, 308800, 'ECAGT', 'Ecologie agronomie et territoires'),
(3089, 0, 0, 30, 0, 255, 308900, 'MAPHY', 'Microbiologie appliquée & physiopathologie'),
(3090, 0, 0, 30, 0, 255, 309000, 'ACMAE', 'Agronomie & connaissance milieu agroéquipement'),
(3091, 0, 0, 30, 0, 255, 309100, 'STSYS', 'Sciences et technologie des systèmes'),
(3092, 0, 0, 30, 0, 255, 309200, 'SQSER', 'Syst.qual.sécur.envir. resp.sociale & devel.durable'),
(3093, 0, 0, 30, 0, 255, 309300, 'BMEAP', 'Biologie microbiologie & écologie appliquée'),
(3099, 0, 0, 30, 0, 255, 309900, 'BTGBD', 'Biotechnologie génie bio divers'),
(3101, 0, 0, 31, 0, 255, 310100, 'ALIHU', 'Alimentation humaine'),
(3102, 0, 0, 31, 0, 255, 310200, 'E-FS', 'Économie familiale et sociale'),
(3103, 0, 0, 31, 0, 255, 310300, 'DACVQ', 'Domaines activités vie quotidienne'),
(3104, 0, 0, 31, 0, 255, 310400, 'MCESF', 'Mode intervention conseiller en ESF'),
(3105, 0, 0, 31, 0, 255, 310500, 'E-DOM', 'Économie domestique'),
(3106, 0, 0, 31, 0, 255, 310600, 'P-VSF', 'Préparation à la vie sociale et familial'),
(3107, 0, 0, 31, 0, 255, 310700, 'P-VSP', 'Préparation vie sociale et prof (ses)'),
(3108, 0, 0, 31, 0, 255, 310800, 'E-SFQ', 'Économie sociale-familiale appl quotidien'),
(3109, 0, 0, 31, 0, 255, 310900, 'HYGAL', 'Hygiène générale et alimentaire'),
(3110, 0, 0, 31, 0, 255, 311000, 'HYGPS', 'Hygiène prévention secourisme'),
(3111, 0, 0, 31, 0, 255, 311100, 'BANCS', 'Banc essai'),
(3112, 0, 0, 31, 0, 255, 311200, 'REGIM', 'Régimes'),
(3113, 0, 0, 31, 0, 255, 311300, 'STBPM', 'Sciences et techniques bio et paramédicales'),
(3114, 0, 0, 31, 0, 255, 311400, 'T-PRO', 'Techniques professionnelles'),
(3115, 0, 0, 31, 0, 255, 311500, 'VISTA', 'Visites stages'),
(3116, 0, 0, 31, 0, 255, 311600, 'BPDIE', 'Bases physiopathologiques de diététique'),
(3117, 0, 0, 31, 0, 255, 311700, 'NUTAL', 'Nutrition et alimentation'),
(3118, 0, 0, 31, 0, 255, 311800, 'CO-MV', 'Connaissance milieu vie et travail'),
(3119, 0, 0, 31, 0, 255, 311900, 'VSPRO', 'Vie sociale et professionnelle'),
(3120, 0, 0, 31, 0, 255, 312000, 'STHEV', 'Sciences et techno habitat environnement');
INSERT INTO `sacoche_matiere` (`matiere_id`, `matiere_active`, `matiere_usuelle`, `matiere_famille_id`, `matiere_nb_demandes`, `matiere_ordre`, `matiere_code`, `matiere_ref`, `matiere_nom`) VALUES
(3121, 0, 0, 31, 0, 255, 312100, 'PRVSF', 'Prep à la vie sociale et familiale'),
(3122, 0, 0, 31, 0, 255, 312200, 'QUALI', 'Qualité (famille 31)'),
(3123, 0, 0, 31, 0, 255, 312300, 'METSO', 'Méthodologie du travail social'),
(3124, 0, 0, 31, 0, 255, 312400, 'ALTHP', 'Alimentation théorique et pratique'),
(3125, 0, 0, 31, 0, 255, 312500, 'HABAM', 'Habillement ameublement'),
(3126, 0, 0, 31, 0, 255, 312600, 'APSEC', 'Actions professionnelles (bio.sant.env.collec)'),
(3127, 0, 0, 31, 0, 255, 312700, 'PRISQ', 'Prévention des risques'),
(3128, 0, 0, 31, 0, 255, 312800, 'PSE', 'Prévention - santé - environnement'),
(3129, 0, 0, 31, 0, 255, 312900, 'HABLO', 'Habitat - logement'),
(3130, 0, 0, 31, 0, 255, 313000, 'ALSHY', 'Alimentation - santé - hygiène'),
(3131, 0, 0, 31, 0, 255, 313100, 'BIOTE', 'Biotechnologies'),
(3132, 0, 0, 31, 0, 255, 313200, 'CDESF', 'Connaissance domaines majeurs esf'),
(3133, 0, 0, 31, 0, 255, 313300, 'ISPRO', 'Insertion sociale et professionnelle'),
(3134, 0, 0, 31, 0, 255, 313400, 'INTSO', 'Intervention sociale'),
(3199, 0, 0, 31, 0, 255, 319900, 'BTSAD', 'Biotechnologie santé divers'),
(3201, 0, 0, 32, 0, 255, 320100, 'ANAOM', 'Anatomie (ostéologie-myologie)'),
(3202, 0, 0, 32, 0, 255, 320200, 'FSPTM', 'Physiopatho terminologie médicale'),
(3203, 0, 0, 32, 0, 255, 320300, 'APB', 'APB'),
(3204, 0, 0, 32, 0, 255, 320400, 'PGIPR', 'Patho gene intro pharma radiobio'),
(3205, 0, 0, 32, 0, 255, 320500, 'PTTRT', 'Patho - therapeu - tech radiodiag - therap'),
(3206, 0, 0, 32, 0, 255, 320600, 'T-RR', 'Techniques radiodiag et radiotherap'),
(3207, 0, 0, 32, 0, 255, 320700, 'SMS', 'Sciences médico-sociales'),
(3208, 0, 0, 32, 0, 255, 320800, 'STMS', 'Sciences et techniques médico-sociales'),
(3209, 0, 0, 32, 0, 255, 320900, 'STRAD', 'Stages radiologie'),
(3210, 0, 0, 32, 0, 255, 321000, 'ECMED', 'Éléments de connaissance médicale'),
(3211, 0, 0, 32, 0, 255, 321100, 'IMUNO', 'Immunologie'),
(3212, 0, 0, 32, 0, 255, 321200, 'HCYTO', 'Histologie cytologie'),
(3213, 0, 0, 32, 0, 255, 321300, 'HEMAT', 'Hématologie'),
(3214, 0, 0, 32, 0, 255, 321400, 'P-PSG', 'Prepa cert capa en prélèvement sanguin'),
(3215, 0, 0, 32, 0, 255, 321500, 'STHSP', 'Stage technique hospitalière'),
(3216, 0, 0, 32, 0, 255, 321600, 'ANATO', 'Anatomie'),
(3217, 0, 0, 32, 0, 255, 321700, 'ANAPP', 'Anatomie physiologie pathologie'),
(3218, 0, 0, 32, 0, 255, 321800, 'SMEDS', 'Stage milieu médical spécialisé'),
(3219, 0, 0, 32, 0, 255, 321900, 'HHCYT', 'Hématologie - histologie - cytologie'),
(3220, 0, 0, 32, 0, 255, 322000, 'TECMA', 'Technologie matériels'),
(3221, 0, 0, 32, 0, 255, 322100, 'ANAMP', 'Anatomie - morphologie'),
(3222, 0, 0, 32, 0, 255, 322200, 'HANCY', 'Hématologie - anatomocythopathologie'),
(3223, 0, 0, 32, 0, 255, 322300, 'STBP', 'Sciences et techn biol et paramédicales'),
(3224, 0, 0, 32, 0, 255, 322400, 'IMNEP', 'Im med medec nucl 4rad elec pathol pharm'),
(3225, 0, 0, 32, 0, 255, 322520, 'EMEDS', 'Enseignement médical et scientifique'),
(3226, 0, 0, 32, 0, 255, 322600, 'C-MED', 'Connaissances médicales'),
(3227, 0, 0, 32, 0, 255, 322700, 'TPPOD', 'Travaux pratiques (podo-orthesiste)'),
(3228, 0, 0, 32, 0, 255, 322800, 'TPPRT', 'Travaux pratiques (prothesiste.-orthesiste)'),
(3229, 0, 0, 32, 0, 255, 322900, 'APPAP', 'Application de l''appareillage'),
(3230, 0, 0, 32, 0, 255, 323000, 'ETCAP', 'Étude et conception de l''appareillage'),
(3231, 0, 0, 32, 0, 255, 323100, 'REAAP', 'Réalisation de l''appareillage'),
(3232, 0, 0, 32, 0, 255, 323200, 'ANVIS', 'Analyse de la vision'),
(3233, 0, 0, 32, 0, 255, 323300, 'MSFAC', 'Mesures faciales'),
(3234, 0, 0, 32, 0, 255, 323400, 'ERCEQ', 'Étude réalisation contrôle d''équipement'),
(3235, 0, 0, 32, 0, 255, 323500, 'MAGAP', 'Magasin d''application'),
(3236, 0, 0, 32, 0, 255, 323600, 'IMHCY', 'Immunologie histologie cytologie'),
(3237, 0, 0, 32, 0, 255, 323700, 'ERGSE', 'Sécurité et ergonomie'),
(3238, 0, 0, 32, 0, 255, 323800, 'IEXPA', 'Immunologie et expérimentation animale'),
(3239, 0, 0, 32, 0, 255, 323900, 'HEHIC', 'Hématologie - histologie - cytologie'),
(3240, 0, 0, 32, 0, 255, 324000, 'PHOFF', 'Pharmacie d''officine'),
(3241, 0, 0, 32, 0, 255, 324100, 'MASSS', 'Methodo.appliq.secteur sanit.& soc.'),
(3242, 0, 0, 32, 0, 255, 324200, 'HEMAN', 'Hématologie - anatomopathologie'),
(3243, 0, 0, 32, 0, 255, 324300, 'SANTS', 'Sante & social'),
(3244, 0, 0, 32, 0, 255, 324400, 'AOCCL', 'Anatomie-occlusodontie'),
(3245, 0, 0, 32, 0, 255, 324500, 'SMVSM', 'Sc. matière et vie et sciences médicales'),
(3246, 0, 0, 32, 0, 255, 324600, 'IMDTR', 'Sc. & techn., fond. méth. imagerie médicale'),
(3247, 0, 0, 32, 0, 255, 324700, 'IIMDT', 'Sc. & techn., intervention en imagerie médicale'),
(3248, 0, 0, 32, 0, 255, 324800, 'OUTMT', 'Outils et méthodes de travail'),
(3249, 0, 0, 32, 0, 255, 324900, 'INSPP', 'Intégration savoirs & posture professionnelle'),
(3299, 0, 0, 32, 0, 255, 329900, 'PRMDI', 'Paramédical divers'),
(3301, 0, 0, 33, 0, 255, 330100, 'ESTCP', 'Esthétique - cosmétique - parfumerie'),
(3302, 0, 0, 33, 0, 255, 330200, 'ETCRT', 'Étude de cas concrets'),
(3303, 0, 0, 33, 0, 255, 330300, 'T-HYH', 'Techniques de soins et hygiène hospitalière'),
(3304, 0, 0, 33, 0, 255, 330400, 'COSME', 'Cosmétologie'),
(3305, 0, 0, 33, 0, 255, 330500, 'TALOC', 'Technologie des appareils et des locaux'),
(3306, 0, 0, 33, 0, 255, 330600, 'TESTH', 'Techniques esthétiques'),
(3307, 0, 0, 33, 0, 255, 330700, 'QUOTI', 'Interv.sur le quotidien et son évolution'),
(3308, 0, 0, 33, 0, 255, 330800, 'CMOTE', 'Conception et moe de techniques cosmet.'),
(3309, 0, 0, 33, 0, 255, 330900, 'ENEST', 'Environnement esthétique'),
(3310, 0, 0, 33, 0, 255, 331000, 'PRCOS', 'Le produit cosmétique'),
(3311, 0, 0, 33, 0, 255, 331100, 'APECP', 'Actions professionnelles (esthétique cosmétique parfumerie)'),
(3312, 0, 0, 33, 0, 255, 331200, 'TPPLU', 'Travaux pratiques pluridimensionnels'),
(3313, 0, 0, 33, 0, 255, 331300, 'EFPRC', 'Efficacite des produits cosmétiques'),
(3314, 0, 0, 33, 0, 255, 331400, 'COELP', 'Conception, élaboration, production'),
(3315, 0, 0, 33, 0, 255, 331500, 'TECHC', 'Techniques cosmétiques'),
(3316, 0, 0, 33, 0, 255, 331600, 'FPCCO', 'Fondement physico-chimiques cosmétologie'),
(3317, 0, 0, 33, 0, 255, 331700, 'COSAP', 'Cosmétologie appliquée'),
(3399, 0, 0, 33, 0, 255, 339900, 'SPERD', 'Soins personnels divers'),
(3401, 0, 0, 34, 0, 255, 340100, 'VADIS', 'Vente à distance'),
(3402, 0, 0, 34, 0, 255, 340200, 'GDIST', 'Grande distribution'),
(3403, 0, 0, 34, 0, 255, 340300, 'VPRFR', 'Vente de produits frais'),
(3404, 0, 0, 34, 0, 255, 340400, 'VCETR', 'Vente à la clientèle étrangère'),
(3405, 0, 0, 34, 0, 255, 340500, 'VARVS', 'Vente d''articles vestimentaires'),
(3406, 0, 0, 34, 0, 255, 340600, 'TE-CO', 'Technico-commercial'),
(3407, 0, 0, 34, 0, 255, 340700, 'VVHOR', 'Vente de végétaux horticoles'),
(3408, 0, 0, 34, 0, 255, 340800, 'COMGE', 'Commercialisation - gestion'),
(3409, 0, 0, 34, 0, 255, 340900, 'EXPCT', 'Exploitation entrepr com traditionnelle'),
(3410, 0, 0, 34, 0, 255, 341000, 'ETOM', 'Étude des offres et marches'),
(3411, 0, 0, 34, 0, 255, 341100, 'MARKT', 'Marketing études de marchés études de cas'),
(3412, 0, 0, 34, 0, 255, 341200, 'FCTCO', 'Fonction commerciale'),
(3413, 0, 0, 34, 0, 255, 341300, 'ATVTA', 'Action vente appliquée'),
(3414, 0, 0, 34, 0, 255, 341400, 'T-COM', 'Techniques commerciales'),
(3415, 0, 0, 34, 0, 255, 341500, 'CMNNE', 'Communication et négociation'),
(3416, 0, 0, 34, 0, 255, 341600, 'G-CMF', 'Gestion ciale et manag force de vente'),
(3417, 0, 0, 34, 0, 255, 341700, 'VENTP', 'Vente(tp-présentation-expr.-comportement)'),
(3418, 0, 0, 34, 0, 255, 341800, 'ATTCA', 'Actions technico-commerciales appliquées'),
(3419, 0, 0, 34, 0, 255, 341900, 'COMIA', 'Commerce international appliqué'),
(3420, 0, 0, 34, 0, 255, 342000, 'MT-AC', 'Méthodes administratives et commerciales'),
(3421, 0, 0, 34, 0, 255, 342100, 'ATCOM', 'Action commerciale'),
(3422, 0, 0, 34, 0, 255, 342200, 'VLIBR', 'Vente en librairie'),
(3423, 0, 0, 34, 0, 255, 342300, 'T-TCI', 'Technique du commerce international'),
(3424, 0, 0, 34, 0, 255, 342400, 'BURCO', 'Bureau commercial'),
(3425, 0, 0, 34, 0, 255, 342500, 'N-COM', 'Enseignement commercial'),
(3426, 0, 0, 34, 0, 255, 342600, 'MQNEG', 'Mercatique et négociation'),
(3427, 0, 0, 34, 0, 255, 342700, 'ANTCO', 'Analyse technico-commerciale'),
(3428, 0, 0, 34, 0, 255, 342800, 'OU-GC', 'Outils de gestion commerciale'),
(3429, 0, 0, 34, 0, 255, 342900, 'MERCA', 'Mercatique'),
(3430, 0, 0, 34, 0, 255, 343000, 'SERVC', 'Service et commercialisation'),
(3431, 0, 0, 34, 0, 255, 343100, 'APRSE', 'Approfondissement sectoriel'),
(3432, 0, 0, 34, 0, 255, 343200, 'AIVPF', 'Aide à la vie professionnelle'),
(3433, 0, 0, 34, 0, 255, 343300, 'MQNMI', 'Mercatique négociation - management international'),
(3434, 0, 0, 34, 0, 255, 343400, 'AIPAR', 'Aide au partenariat'),
(3435, 0, 0, 34, 0, 255, 343500, 'ATCOC', 'Action et communication commerciales'),
(3436, 0, 0, 34, 0, 255, 343600, 'VPAMT', 'Vente produits arts maison table'),
(3437, 0, 0, 34, 0, 255, 343700, 'ANIML', 'Animalerie'),
(3438, 0, 0, 34, 0, 255, 343800, 'AGTCC', 'Agent commercial de conduite'),
(3439, 0, 0, 34, 0, 255, 343900, 'VDISQ', 'Vente de disques et produits assimiles'),
(3440, 0, 0, 34, 0, 255, 344000, 'VCLAV', 'Vente claviers électronique - informatique musicale'),
(3441, 0, 0, 34, 0, 255, 344100, 'VBRUN', 'Vente de produits bruns'),
(3442, 0, 0, 34, 0, 255, 344200, 'G-COM', 'Gestion commerciale'),
(3443, 0, 0, 34, 0, 255, 344300, 'VHABT', 'Vente de produits de l''habitat'),
(3444, 0, 0, 34, 0, 255, 344400, 'VTVIN', 'Vente de vin'),
(3445, 0, 0, 34, 0, 255, 344500, 'CPSMB', 'Commerc prdts serv micro-inform bureautq'),
(3446, 0, 0, 34, 0, 255, 344600, 'VTPBF', 'Vente produits bancaires et financiers'),
(3447, 0, 0, 34, 0, 255, 344700, 'VTPAA', 'Vente de produits agroalimentaires'),
(3448, 0, 0, 34, 0, 255, 344800, 'CPTOU', 'Commercialisation de produits touristiques'),
(3449, 0, 0, 34, 0, 255, 344900, 'MGUCO', 'Management gestion unités commerciales'),
(3450, 0, 0, 34, 0, 255, 345000, 'GRCOM', 'Gestion de la relation commerciale'),
(3451, 0, 0, 34, 0, 255, 345100, 'DUNCO', 'Développement de l''unité commerciale'),
(3452, 0, 0, 34, 0, 255, 345200, 'G-CLI', 'Gestion de clientèles'),
(3453, 0, 0, 34, 0, 255, 345300, 'RELCL', 'Relation client'),
(3454, 0, 0, 34, 0, 255, 345400, 'MEQCO', 'Management de l''équipe commerciale'),
(3455, 0, 0, 34, 0, 255, 345500, 'GPROJ', 'Gestion de projet'),
(3456, 0, 0, 34, 0, 255, 345600, 'DCLIE', 'Développement de clientèles'),
(3457, 0, 0, 34, 0, 255, 345700, 'MANCO', 'Management commercial'),
(3458, 0, 0, 34, 0, 255, 345800, 'EVDME', 'Étude et veille des marches étrangers'),
(3459, 0, 0, 34, 0, 255, 345900, 'PSCLI', 'Prospection et suivi de clientèle'),
(3460, 0, 0, 34, 0, 255, 346000, 'NEGOV', 'Négociation vente'),
(3461, 0, 0, 34, 0, 255, 346100, 'GOPIE', 'Gestion des ope rations d''import-export'),
(3462, 0, 0, 34, 0, 255, 346200, 'GRSER', 'Gestion de la relation de service'),
(3463, 0, 0, 34, 0, 255, 346300, 'ARELC', 'Atelier relations commerciales'),
(3464, 0, 0, 34, 0, 255, 346400, 'RELCF', 'Relation avec la clientèle & les fournisseurs'),
(3465, 0, 0, 34, 0, 255, 346500, 'MANEC', 'Management de l''entité commerciale'),
(3466, 0, 0, 34, 0, 255, 346600, 'VPSCP', 'Mise en valeur prod. et serv. et comm. publiciaire'),
(3467, 0, 0, 34, 0, 255, 346700, 'TNERC', 'Technique de négociation relation client'),
(3468, 0, 0, 34, 0, 255, 346800, 'TECOM', 'Technologies commerciales'),
(3469, 0, 0, 34, 0, 255, 346900, 'IMSMA', 'Image et mise en scène de la marque'),
(3470, 0, 0, 34, 0, 255, 347000, 'DSACC', 'Développement & suivi de l''activité commerciale'),
(3471, 0, 0, 34, 0, 255, 347100, 'MAGRH', 'Management gestion des ressources humaines'),
(3472, 0, 0, 34, 0, 255, 347200, 'MERMA', 'Mercatique (marketing)'),
(3499, 0, 0, 34, 0, 255, 349900, 'E-GSD', 'Économie et gestion divers'),
(3501, 0, 0, 35, 0, 255, 350100, 'SDSCI', 'Secrétariat et documentation scientifique'),
(3502, 0, 0, 35, 0, 255, 350200, 'CORES', 'Correspondance'),
(3503, 0, 0, 35, 0, 255, 350300, 'SAIDO', 'Saisie données'),
(3504, 0, 0, 35, 0, 255, 350400, 'CORRA', 'Correspondance et rapport'),
(3505, 0, 0, 35, 0, 255, 350500, 'T-SEC', 'Techniques de secrétariat'),
(3506, 0, 0, 35, 0, 255, 350600, 'BURTQ', 'Bureautique'),
(3507, 0, 0, 35, 0, 255, 350700, 'UCLAV', 'Utilisation des claviers'),
(3508, 0, 0, 35, 0, 255, 350800, 'DACTL', 'Dactylographie'),
(3509, 0, 0, 35, 0, 255, 350900, 'PRPAR', 'Prise rapide de la parole'),
(3510, 0, 0, 35, 0, 255, 351000, 'STENO', 'Sténographie'),
(3511, 0, 0, 35, 0, 255, 351100, 'SCTLA', 'Secrétariat en langue étrangère A'),
(3512, 0, 0, 35, 0, 255, 351200, 'SCTLB', 'Secrétariat en langue étrangère B'),
(3513, 0, 0, 35, 0, 255, 351300, 'T-BSE', 'Techniques de base du secrétariat'),
(3514, 0, 0, 35, 0, 255, 351400, 'BUREA', 'Bureau'),
(3515, 0, 0, 35, 0, 255, 351500, 'MA1BU', 'Module d''approfond. 1 (bureautique)'),
(3516, 0, 0, 35, 0, 255, 351600, 'MA2BU', 'Module d''approfond. 2 (bureautique)'),
(3517, 0, 0, 35, 0, 255, 351700, 'I-OUB', 'Initiation aux outils de la bureautique'),
(3518, 0, 0, 35, 0, 255, 351800, 'MTPCP', 'Méthode pratique de communication professionnelle'),
(3519, 0, 0, 35, 0, 255, 351900, 'O-GES', 'Organisation et gestion'),
(3520, 0, 0, 35, 0, 255, 352000, 'MTACP', 'Méthodologie action et conduite projets'),
(3521, 0, 0, 35, 0, 255, 352100, 'CMNLF', 'Communic profess secret langue française'),
(3522, 0, 0, 35, 0, 255, 352200, 'CMNLE', 'Communic profess secret langues étrangères'),
(3523, 0, 0, 35, 0, 255, 352300, 'O-GAI', 'Organisation gest. activ. nationale internationale'),
(3524, 0, 0, 35, 0, 255, 352400, 'ATPRO', 'Actions professionnelles'),
(3525, 0, 0, 35, 0, 255, 352500, 'AIVPR', 'Aide à la vie professionnelle'),
(3526, 0, 0, 35, 0, 255, 352600, 'RATTR', 'Rattrapage (enseignement professionnel)'),
(3599, 0, 0, 35, 0, 255, 359900, 'BRTSD', 'Bureautique et secrétariat divers'),
(3601, 0, 0, 36, 0, 255, 360100, 'ITDRE', 'Introduction au droit de l''entreprise'),
(3602, 0, 0, 36, 0, 255, 360200, 'DR-VG', 'Droit - vie et gestion des entreprises'),
(3603, 0, 0, 36, 0, 255, 360300, 'LGSET', 'Législation et sécurité du travail'),
(3604, 0, 0, 36, 0, 255, 360400, 'E-GDR', 'Économie - gestion et droit'),
(3605, 0, 0, 36, 0, 255, 360500, 'DR-LS', 'Droit - législation sociale - organisation du travail'),
(3606, 0, 0, 36, 0, 255, 360600, 'DR-TR', 'Droit du travail'),
(3607, 0, 0, 36, 0, 255, 360700, 'LDTSS', 'Législation - drt travail santé securité-travail'),
(3608, 0, 0, 36, 0, 255, 360800, 'DR-TP', 'Droit en travaux publics'),
(3609, 0, 0, 36, 0, 255, 360900, 'LEGIS', 'Législation'),
(3610, 0, 0, 36, 0, 255, 361000, 'LGSPA', 'Législation - sécurité - prévention accident'),
(3611, 0, 0, 36, 0, 255, 361100, 'DR-TL', 'Droit travail - législation sociale - org. de l''entreprise'),
(3612, 0, 0, 36, 0, 255, 361200, 'RJCTC', 'Relations juridiques crédit travail contentieux'),
(3613, 0, 0, 36, 0, 255, 361300, 'AECJS', 'Actualité économique juridique et sociale'),
(3614, 0, 0, 36, 0, 255, 361400, 'G-ELT', 'Gestion entreprises - législation travail'),
(3615, 0, 0, 36, 0, 255, 361500, 'LGRGS', 'Législation - règlementation - sécurité'),
(3616, 0, 0, 36, 0, 255, 361600, 'DR-SF', 'Droit des sociétés - droit fiscal'),
(3617, 0, 0, 36, 0, 255, 361700, 'PGXDR', 'Principes généraux du droit'),
(3618, 0, 0, 36, 0, 255, 361800, 'LGDEO', 'Législation déontologie'),
(3619, 0, 0, 36, 0, 255, 361900, 'LGTRA', 'Législation du travail'),
(3620, 0, 0, 36, 0, 255, 362000, 'DROIT', 'Droit'),
(3621, 0, 0, 36, 0, 255, 362100, 'I-JUR', 'Initiation juridique'),
(3622, 0, 0, 36, 0, 255, 362200, 'DR-FI', 'Droit fiscal'),
(3623, 0, 0, 36, 0, 255, 362300, 'DR-LG', 'Droit législatif'),
(3624, 0, 0, 36, 0, 255, 362400, 'DR-SO', 'Droit social'),
(3625, 0, 0, 36, 0, 255, 362500, 'I-DCI', 'Initiation au droit civil'),
(3626, 0, 0, 36, 0, 255, 362600, 'I-DCO', 'Initiation au droit commercial'),
(3627, 0, 0, 36, 0, 255, 362700, 'E-GLG', 'Économie gestion législation'),
(3628, 0, 0, 36, 0, 255, 362800, 'DR-CC', 'Droit civil et commercial'),
(3629, 0, 0, 36, 0, 255, 362900, 'DR-AP', 'Droit appliqué'),
(3630, 0, 0, 36, 0, 255, 363000, 'LGECO', 'Législation et économie'),
(3631, 0, 0, 36, 0, 255, 363100, 'LGOST', 'Législation et org scient du travail'),
(3632, 0, 0, 36, 0, 255, 363200, 'ATSIN', 'Action sociale et institutions'),
(3633, 0, 0, 36, 0, 255, 363300, 'ASPPS', 'Aspects psychosociaux et juridiques'),
(3634, 0, 0, 36, 0, 255, 363400, 'I-EJU', 'Initiation économique et juridique'),
(3635, 0, 0, 36, 0, 255, 363500, 'DIMJE', 'Dimension juridico-économique'),
(3636, 0, 0, 36, 0, 255, 363600, 'GREGE', 'Gr (ent-gest - eco gen - e ent - droit social)'),
(3637, 0, 0, 36, 0, 255, 363700, 'LGEGE', 'Législation - économie - gestion entreprise'),
(3638, 0, 0, 36, 0, 255, 363800, 'LGTRS', 'Législation du travail et sécurité'),
(3639, 0, 0, 36, 0, 255, 363900, 'DR-DA', 'Droit général et droit des assurances'),
(3640, 0, 0, 36, 0, 255, 364000, 'RGLTT', 'Règlement et legis transports tourisme'),
(3641, 0, 0, 36, 0, 255, 364100, 'DR-CI', 'Droit civil'),
(3642, 0, 0, 36, 0, 255, 364200, 'DR-CO', 'Droit commercial'),
(3643, 0, 0, 36, 0, 255, 364300, 'SMSBU', 'Sciences médico-sociales et bureautique'),
(3644, 0, 0, 36, 0, 255, 364400, 'DRGIM', 'Droit général de l''immobilier'),
(3645, 0, 0, 36, 0, 255, 364500, 'DGSMQ', 'Droit - gestion et mercatique appliquée'),
(3646, 0, 0, 36, 0, 255, 364600, 'DRTPR', 'Droit professionnel'),
(3647, 0, 0, 36, 0, 255, 364700, 'DRSOC', 'Droit des sociétés'),
(3648, 0, 0, 36, 0, 255, 364800, 'VEJEC', 'Vie eco.jurid. de l''entrep. Commercialisation'),
(3649, 0, 0, 36, 0, 255, 364900, 'CASVQ', 'Cadre pol jur act soc vie quotidienne'),
(3650, 0, 0, 36, 0, 255, 365000, 'INTDT', 'Introduction au droit'),
(3651, 0, 0, 36, 0, 255, 365100, 'INRES', 'Institutions et réseaux'),
(3652, 0, 0, 36, 0, 255, 365200, 'EEJMA', 'Environ.eco.jur.& manager.de l''assurance'),
(3653, 0, 0, 36, 0, 255, 365300, 'DG-DN', 'Droit général et droit notarial'),
(3654, 0, 0, 36, 0, 255, 365400, 'T-NOT', 'Techniques du notariat'),
(3655, 0, 0, 36, 0, 255, 365500, 'APA-N', 'Activités prof. appliquées (notariat)'),
(3656, 0, 0, 36, 0, 255, 365600, 'OIRAE', 'Organisat.indust.&règlement.aéronautique'),
(3657, 0, 0, 36, 0, 255, 365700, 'DGEMC', 'Droit et grands enjeux du monde contemporain'),
(3658, 0, 0, 36, 0, 255, 365800, 'DRAPP', 'Droit approfondi'),
(3659, 0, 0, 36, 0, 255, 365900, 'ENVEJ', 'Environnement économique et juridique'),
(3660, 0, 0, 36, 0, 255, 366000, 'COJAT', 'Cadre organisationnel juridique activité touristique'),
(3661, 0, 0, 36, 0, 255, 366100, 'DR-VD', 'Droit et veille juridique'),
(3662, 0, 0, 36, 0, 255, 366200, 'ETUOS', 'Environnement de travail : outil stratégique'),
(3663, 0, 0, 36, 0, 255, 366300, 'EVENP', 'Évolution de l''environnement professionnel'),
(3664, 0, 0, 36, 0, 255, 366400, 'DRECO', 'Document. règlement. expert. cosmetovig.'),
(3665, 0, 0, 36, 0, 255, 366500, 'EEJME', 'Environnement économ., juridique & manager. édition'),
(3666, 0, 0, 36, 0, 255, 366600, 'EEJOB', 'Environnement économ., juridique & organis. activité bancaire'),
(3667, 0, 0, 36, 0, 255, 366700, 'ENVPR', 'Environnement professionnel'),
(3699, 0, 0, 36, 0, 255, 369900, 'DR-LD', 'Droit et législation divers'),
(3701, 0, 0, 37, 0, 255, 370100, 'MA-GI', 'Maths appliquées - outils gestion - informatique'),
(3702, 0, 0, 37, 0, 255, 370200, 'APINF', 'Applications informatiques'),
(3703, 0, 0, 37, 0, 255, 370300, 'TTDON', 'Traitement des données'),
(3704, 0, 0, 37, 0, 255, 370400, 'ECOSI', 'Enseignement commun (si)'),
(3705, 0, 0, 37, 0, 255, 370500, 'TECIF', 'Technologies informatiques'),
(3706, 0, 0, 37, 0, 255, 370600, 'G-INF', 'Gestion et informatique'),
(3707, 0, 0, 37, 0, 255, 370700, 'STT', 'Sciences et technologies tertiaires'),
(3708, 0, 0, 37, 0, 255, 370800, 'NEGIF', 'Négociations informatiques'),
(3709, 0, 0, 37, 0, 255, 370900, 'ALGLG', 'Algorithme et langages'),
(3710, 0, 0, 37, 0, 255, 371000, 'TXAIN', 'Travaux d''application d''informat.'),
(3711, 0, 0, 37, 0, 255, 371100, 'G-AMG', 'Gestion et application math à la gestion'),
(3712, 0, 0, 37, 0, 255, 371200, 'IFOSI', 'Informatique organisat syst information'),
(3713, 0, 0, 37, 0, 255, 371300, 'ANOIF', 'Analyse organisation - informatisation'),
(3714, 0, 0, 37, 0, 255, 371400, 'IFAPG', 'Informatique appliquée à la gestion'),
(3715, 0, 0, 37, 0, 255, 371500, 'ITAGM', 'Informat telemat appli gest mercatique'),
(3716, 0, 0, 37, 0, 255, 371600, 'APROF', 'Approfondissements'),
(3717, 0, 0, 37, 0, 255, 371700, 'OU-GI', 'Outils de gestion et informatique appli'),
(3718, 0, 0, 37, 0, 255, 371800, 'IFGES', 'Informatique et gestion'),
(3719, 0, 0, 37, 0, 255, 371900, 'IUMLI', 'Init utilis mater - logic informatique de l''ets'),
(3720, 0, 0, 37, 0, 255, 372000, 'AMSIQ', 'Architecture matérielle systèmes informatiques'),
(3721, 0, 0, 37, 0, 255, 372100, 'ALSIQ', 'Architecture logicielle systèmes informatiques'),
(3722, 0, 0, 37, 0, 255, 372200, 'DAIGL', 'Dvlpt applications informatiques génie logiciel'),
(3723, 0, 0, 37, 0, 255, 372300, 'ACPIG', 'Actions professionnelles (informatique gestion)'),
(3724, 0, 0, 37, 0, 255, 372400, 'IFGCM', 'Informatique de gestion et communication'),
(3725, 0, 0, 37, 0, 255, 372500, 'CEIPE', 'Connaissance de l''entreprise init. pratique informatique'),
(3726, 0, 0, 37, 0, 255, 372600, 'IFCOM', 'Informatique commerciale'),
(3727, 0, 0, 37, 0, 255, 372700, 'GSYSI', 'Gestion du système d''information'),
(3728, 0, 0, 37, 0, 255, 372800, 'ALGOA', 'Algorithmique appliquée'),
(3729, 0, 0, 37, 0, 255, 372900, 'AEMJI', 'An.eco.manager.jurid. services informatiques'),
(3730, 0, 0, 37, 0, 255, 373000, 'MTINF', 'Méthodes et techniques informatiques'),
(3731, 0, 0, 37, 0, 255, 373100, 'ISCNU', 'Informatique et sciences du numérique'),
(3732, 0, 0, 37, 0, 255, 373200, 'SIGET', 'Systèmes d''information de gestion'),
(3733, 0, 0, 37, 0, 255, 373300, 'SYSIG', 'Système d''information de gestion'),
(3734, 0, 0, 37, 0, 255, 373400, 'SISR', 'Solutions d’infrastructure, systèmes et réseaux'),
(3735, 0, 0, 37, 0, 255, 373500, 'SLAM', 'Solutions logicielles et applications métiers'),
(3736, 0, 0, 37, 0, 255, 373600, 'PRPEN', 'Projets personnalisés encadrés'),
(3737, 0, 0, 37, 0, 255, 373700, 'ICN', 'Informatique et création numérique'),
(3799, 0, 0, 37, 0, 255, 379900, 'IFGSD', 'Informatique de gestion divers'),
(3801, 0, 0, 38, 0, 255, 380100, 'E-TRU', 'Économie de la construction'),
(3802, 0, 0, 38, 0, 255, 380200, 'DOMEC', 'Domaine économique'),
(3803, 0, 0, 38, 0, 255, 380300, 'E-GCG', 'Économie et gestion/conjoint'),
(3804, 0, 0, 38, 0, 255, 380400, 'E-OGS', 'Économie et gestion'),
(3805, 0, 0, 38, 0, 255, 380500, 'E-TKG', 'Économie et techniques de gestion'),
(3806, 0, 0, 38, 0, 255, 380600, 'E-OGN', 'Économie générale'),
(3807, 0, 0, 38, 0, 255, 380700, 'E-VIE', 'Économie - vie des entreprises'),
(3808, 0, 0, 38, 0, 255, 380800, 'E-ONO', 'Économie'),
(3809, 0, 0, 38, 0, 255, 380900, 'PBECO', 'Problèmes économiques'),
(3810, 0, 0, 38, 0, 255, 381000, 'E-DRT', 'Économie et droit'),
(3811, 0, 0, 38, 0, 255, 381100, 'EVEJU', 'Environnement économique et juridique'),
(3812, 0, 0, 38, 0, 255, 381200, 'CFOEC', 'Complément de formation économique'),
(3813, 0, 0, 38, 0, 255, 381300, 'E-GEE', 'Économie générale et eco d''entreprise'),
(3814, 0, 0, 38, 0, 255, 381400, 'E-EED', 'Économie générale - eco entreprise droit'),
(3815, 0, 0, 38, 0, 255, 381500, 'APRMT', 'Approfondissement méthodologique'),
(3816, 0, 0, 38, 0, 255, 381600, 'HIECO', 'Histoire économique'),
(3817, 0, 0, 38, 0, 255, 381700, 'ANMPE', 'Analyse monétaire politique économique'),
(3818, 0, 0, 38, 0, 255, 381800, 'ODOEC', 'Option à dominante économique'),
(3819, 0, 0, 38, 0, 255, 381900, 'E-TDR', 'Économie générale et touristique-droit'),
(3820, 0, 0, 38, 0, 255, 382000, 'ECEND', 'Économie d''entreprise et droit'),
(3821, 0, 0, 38, 0, 255, 382100, 'ETECO', 'Études techniques et économiques'),
(3822, 0, 0, 38, 0, 255, 382200, 'ENVEC', 'Environnement économique'),
(3823, 0, 0, 38, 0, 255, 382300, 'PO-EG', 'Projet d''ouvrage (économie gestion)'),
(3824, 0, 0, 38, 0, 255, 382400, 'ECDBQ', 'Économie et droit bancaire'),
(3825, 0, 0, 38, 0, 255, 382500, 'DEDPI', 'Dimension économique des projet industriel'),
(3826, 0, 0, 38, 0, 255, 382600, 'EDTOU', 'Économie et droit appliqués au tourisme'),
(3827, 0, 0, 38, 0, 255, 382700, 'EGOTR', 'Économie gestion organisation du travail'),
(3828, 0, 0, 38, 0, 255, 382800, 'EEMNO', 'Environ. eco et managerial du notariat'),
(3829, 0, 0, 38, 0, 255, 382900, 'ECONS', 'Économie - consommation'),
(3830, 0, 0, 38, 0, 255, 383000, 'PFEG', 'Principes fondament. Économie & gestion'),
(3831, 0, 0, 38, 0, 255, 383100, 'ECOOR', 'Économie et organisation'),
(3832, 0, 0, 38, 0, 255, 383200, 'CEJUM', 'Culture économique, juridique et manageriale'),
(3833, 0, 0, 38, 0, 255, 383300, 'ECOGE', 'Économie-gestion'),
(3834, 0, 0, 38, 0, 255, 383400, 'EC-DR', 'Économie-droit'),
(3899, 0, 0, 38, 0, 255, 389900, 'E-ODI', 'Économie divers'),
(3901, 0, 0, 39, 0, 255, 390100, 'G-FDT', 'Gestion financière des travaux'),
(3902, 0, 0, 39, 0, 255, 390200, 'G-FIN', 'Gestion financière'),
(3903, 0, 0, 39, 0, 255, 390300, 'G-CAB', 'Gestion - comptabilité analytique-budgétaire'),
(3904, 0, 0, 39, 0, 255, 390400, 'MOCTB', 'Module élémentaire comptabilité'),
(3905, 0, 0, 39, 0, 255, 390500, 'MT-QU', 'Méthodes quantitatives'),
(3906, 0, 0, 39, 0, 255, 390600, 'CPT-G', 'Comptabilité et gestion'),
(3907, 0, 0, 39, 0, 255, 390700, 'FIETB', 'Financement des entr et techn bancaires'),
(3908, 0, 0, 39, 0, 255, 390800, 'CPTTA', 'Comptabilité'),
(3909, 0, 0, 39, 0, 255, 390900, 'TXSYC', 'Travaux de synthèse comptabilité'),
(3910, 0, 0, 39, 0, 255, 391000, 'TXSYN', 'Travaux de synthèse'),
(3911, 0, 0, 39, 0, 255, 391100, 'ETCAS', 'Étude de cas'),
(3912, 0, 0, 39, 0, 255, 391200, 'TPSYN', 'Travaux pratiques de synthèse'),
(3913, 0, 0, 39, 0, 255, 391300, 'T-IMM', 'Technique de l''immobilier'),
(3914, 0, 0, 39, 0, 255, 391400, 'CPT-R', 'Comptabilité approfondie et révision'),
(3915, 0, 0, 39, 0, 255, 391500, 'G-CFS', 'Gestion comptable fiscale et sociale'),
(3916, 0, 0, 39, 0, 255, 391600, 'GFPAC', 'Gest financ prev analyses contrôle gestion'),
(3917, 0, 0, 39, 0, 255, 391700, 'ACTPS', 'Activités professionnelles de synthèse'),
(3918, 0, 0, 39, 0, 255, 391800, 'MANCI', 'Mise à niveau (comptabilité finances informatique)'),
(3919, 0, 0, 39, 0, 255, 391900, 'TECBQ', 'Techniques bancaires'),
(3920, 0, 0, 39, 0, 255, 392000, 'ABQAP', 'Actions bancaires appliquées'),
(3921, 0, 0, 39, 0, 255, 392100, 'OGACO', 'Organisation et gestion administrative et comptable'),
(3922, 0, 0, 39, 0, 255, 392200, 'CPTFI', 'Comptabilité et finance d''entreprises'),
(3923, 0, 0, 39, 0, 255, 392300, 'FINET', 'Finance d''entreprise'),
(3924, 0, 0, 39, 0, 255, 392400, 'INTCT', 'Introduction a la comptabilité'),
(3925, 0, 0, 39, 0, 255, 392500, 'CTAPP', 'Comptabilité approfondie'),
(3926, 0, 0, 39, 0, 255, 392600, 'TGADF', 'Techniq. gestion administr. & financière'),
(3927, 0, 0, 39, 0, 255, 392700, 'GFACT', 'Gestion et financement des actifs'),
(3928, 0, 0, 39, 0, 255, 392800, 'PEREN', 'Pérennisation de l''entreprise'),
(3929, 0, 0, 39, 0, 255, 392900, 'GRISQ', 'Gestion du risque'),
(3930, 0, 0, 39, 0, 255, 393000, 'P1P2', 'P1 plus P2'),
(3931, 0, 0, 39, 0, 255, 393100, 'P3P4', 'P3 plus P4'),
(3932, 0, 0, 39, 0, 255, 393200, 'P5P6', 'P5 plus P6'),
(3933, 0, 0, 39, 0, 255, 393300, 'P7-', 'P7'),
(3934, 0, 0, 39, 0, 255, 393400, 'ATEPR', 'Ateliers professionnels'),
(3935, 0, 0, 39, 0, 255, 393500, 'MOPAP', 'Module optionnel d''approfondissement'),
(3936, 0, 0, 39, 0, 255, 393600, 'AREID', 'Accès ressources informatiques & documentaires'),
(3999, 0, 0, 39, 0, 255, 399900, 'CPT-F', 'Comptabilité - finances divers'),
(4001, 0, 0, 40, 0, 255, 400100, 'GGTIC', 'Geo gene - touris et itinéraires commerc'),
(4002, 0, 0, 40, 0, 255, 400200, 'CUISI', 'Cuisine'),
(4003, 0, 0, 40, 0, 255, 400300, 'CUITP', 'Cuisine (technologie - travaux pratiques)'),
(4004, 0, 0, 40, 0, 255, 400400, 'MQTOU', 'Mercatique du tourisme'),
(4005, 0, 0, 40, 0, 255, 400500, 'T-CUL', 'Techniques culinaires'),
(4006, 0, 0, 40, 0, 255, 400600, 'ATTOG', 'Action touristique générale'),
(4007, 0, 0, 40, 0, 255, 400700, 'ATTAA', 'Action touristique approfondie appliquée'),
(4008, 0, 0, 40, 0, 255, 400800, 'RESTP', 'Restaurant(technologie - tp - oenologie)'),
(4009, 0, 0, 40, 0, 255, 400900, 'ATTOA', 'Action touristique approfondie'),
(4010, 0, 0, 40, 0, 255, 401000, 'ATTGA', 'Action touristique générale appliquée'),
(4011, 0, 0, 40, 0, 255, 401100, 'DCTRP', 'Document de transport'),
(4012, 0, 0, 40, 0, 255, 401200, 'O-TOU', 'Organisation du tourisme'),
(4013, 0, 0, 40, 0, 255, 401300, 'E-TOU', 'Économie touristique'),
(4015, 0, 0, 40, 0, 255, 401500, 'BTARI', 'Billetterie et tarification'),
(4016, 0, 0, 40, 0, 255, 401600, 'TPAGE', 'Travaux pratiques d''agence'),
(4017, 0, 0, 40, 0, 255, 401700, 'FRETF', 'Fret et trafic'),
(4018, 0, 0, 40, 0, 255, 401800, 'DOCUM', 'Documentation'),
(4019, 0, 0, 40, 0, 255, 401900, 'RESTO', 'Restaurant'),
(4020, 0, 0, 40, 0, 255, 402000, 'O-PCL', 'Organisation et production culinaire'),
(4021, 0, 0, 40, 0, 255, 402100, 'T-AHR', 'Techniques administratives hôtelières restaur'),
(4022, 0, 0, 40, 0, 255, 402200, 'ACPRO', 'Activités professionnelles'),
(4023, 0, 0, 40, 0, 255, 402300, 'HBGMT', 'Hébergement'),
(4024, 0, 0, 40, 0, 255, 402400, 'SAHRE', 'Sciences app à l''hôtellerie et à la restauration'),
(4025, 0, 0, 40, 0, 255, 402500, 'G-HOT', 'Gestion hôtelière'),
(4026, 0, 0, 40, 0, 255, 402600, 'HOTTP', 'Hôtel (technologie - travaux pratiques)'),
(4027, 0, 0, 40, 0, 255, 402700, 'T-HOT', 'Techniques hôtelières'),
(4028, 0, 0, 40, 0, 255, 402800, 'IHOTM', 'Ingénierie hôtel et maintenance'),
(4029, 0, 0, 40, 0, 255, 402900, 'CAEHT', 'Cond animat entreprise hôtelière'),
(4030, 0, 0, 40, 0, 255, 403000, 'TECCU', 'Technologie culinaire'),
(4031, 0, 0, 40, 0, 255, 403100, 'PR-CG', 'Pratique de la conduite des groupes'),
(4032, 0, 0, 40, 0, 255, 403200, 'PUBED', 'Publicité édition'),
(4033, 0, 0, 40, 0, 255, 403300, 'O-STT', 'Organisation de la station'),
(4034, 0, 0, 40, 0, 255, 403400, 'T-HEB', 'Technique de l''hébergement'),
(4035, 0, 0, 40, 0, 255, 403500, 'O-SEJ', 'Organisation des séjours'),
(4036, 0, 0, 40, 0, 255, 403600, 'E-GTL', 'Économie gest entre et org tour loisir'),
(4037, 0, 0, 40, 0, 255, 403700, 'RSOHU', 'Relations sociales et humaines'),
(4038, 0, 0, 40, 0, 255, 403800, 'T-HCP', 'Techniques accueil heberg communication prof'),
(4039, 0, 0, 40, 0, 255, 403900, 'ACMPR', 'Activités et manifestations professionnelles'),
(4040, 0, 0, 40, 0, 255, 404000, 'SCTEC', 'Sciences appliquées et technologie'),
(4041, 0, 0, 40, 0, 255, 404100, 'PCTRG', 'Patrimoine culturel et tourist régional'),
(4042, 0, 0, 40, 0, 255, 404200, 'TOURQ', 'Tourismatique'),
(4043, 0, 0, 40, 0, 255, 404300, 'DVTOU', 'Développement touristique'),
(4044, 0, 0, 40, 0, 255, 404400, 'EVTOU', 'Environnement touristique'),
(4045, 0, 0, 40, 0, 255, 404500, 'NGTOU', 'Négociation touristique'),
(4046, 0, 0, 40, 0, 255, 404600, 'CCTOU', 'Concep commerc produits touristiques syst infq'),
(4047, 0, 0, 40, 0, 255, 404700, 'AAPRO', 'Accueil animation professionnels'),
(4048, 0, 0, 40, 0, 255, 404800, 'ACSPE', 'Accueil de touristes à besoins spécifiques'),
(4049, 0, 0, 40, 0, 255, 404900, 'OTRLV', 'Organisation et technique de la réception'),
(4050, 0, 0, 40, 0, 255, 405000, 'ASPAT', 'Analyse spatiale appliquée au tourisme'),
(4051, 0, 0, 40, 0, 255, 405100, 'MGAOT', 'Mercatique gestion appliquée organisation touristique'),
(4052, 0, 0, 40, 0, 255, 405200, 'TCTOU', 'Techniques touristiques'),
(4053, 0, 0, 40, 0, 255, 405300, 'APTOU', 'Action professionnelle touristique'),
(4054, 0, 0, 40, 0, 255, 405400, 'MPTOU', 'Mercatique et productions touristiques'),
(4055, 0, 0, 40, 0, 255, 405500, 'GTMED', 'Gestion de projet touristique multimédia'),
(4056, 0, 0, 40, 0, 255, 405600, 'OTETA', 'Organisation et technique des étages'),
(4057, 0, 0, 40, 0, 255, 405700, 'MERTC', 'Mercatique et techniques de commercialisation'),
(4058, 0, 0, 40, 0, 255, 405800, 'SAAHE', 'Sciences appliquées alimentation hygiène environnement'),
(4059, 0, 0, 40, 0, 255, 405900, 'TTERR', 'Tourisme et territoire'),
(4060, 0, 0, 40, 0, 255, 406000, 'MCPT', 'Mercatique conception prestation touristique'),
(4061, 0, 0, 40, 0, 255, 406100, 'ECGEH', 'Économie et gestion hôteliere'),
(4062, 0, 0, 40, 0, 255, 406200, 'PRSTC', 'Projet sthr (sciences & technologies culinaires)'),
(4063, 0, 0, 40, 0, 255, 406300, 'PRSTS', 'Projet sthr (sciences & technologies des services)'),
(4064, 0, 0, 40, 0, 255, 406400, 'SCTES', 'Sciences et technologies des services'),
(4065, 0, 0, 40, 0, 255, 406500, 'STECU', 'Sciences et technologies culinaires'),
(4066, 0, 0, 40, 0, 255, 406600, 'ESALE', 'Enseignement scientifique alimentation-environnement'),
(4067, 0, 0, 40, 0, 255, 406700, 'MAEHR', 'Management d''une entreprise d''hôtellerie-restauration'),
(4099, 0, 0, 40, 0, 255, 409900, 'HOTDI', 'Hôtellerie tourisme divers'),
(4101, 0, 0, 41, 0, 255, 410100, 'T-INF', 'Techniques d''information'),
(4102, 0, 0, 41, 0, 255, 410200, 'T-ANG', 'Techniques d''animation de groupes'),
(4103, 0, 0, 41, 0, 255, 410300, 'DEXPI', 'Discipline d''expression et d''information'),
(4104, 0, 0, 41, 0, 255, 410400, 'T-COA', 'Technique de communication - d''animation'),
(4105, 0, 0, 41, 0, 255, 410500, 'CMNPO', 'Communication professio orale et écrite'),
(4106, 0, 0, 41, 0, 255, 410600, 'EX-CM', 'Expression communication'),
(4107, 0, 0, 41, 0, 255, 410700, 'CMNCA', 'Communication'),
(4108, 0, 0, 41, 0, 255, 410800, 'MT-TG', 'Méthodes et techniques graphiques communication'),
(4109, 0, 0, 41, 0, 255, 410900, 'EDTKC', 'Edition et techniques de communication'),
(4110, 0, 0, 41, 0, 255, 411000, 'FR-TC', 'Français et techniques de communication'),
(4111, 0, 0, 41, 0, 255, 411100, 'CMNCI', 'Communication et civilisation'),
(4112, 0, 0, 41, 0, 255, 411200, 'OU-TC', 'Outils et techniques de communication'),
(4113, 0, 0, 41, 0, 255, 411300, 'DIMPF', 'Dimension professionnelle'),
(4114, 0, 0, 41, 0, 255, 411400, 'DIMPS', 'Dimension psychologique et sociologique'),
(4115, 0, 0, 41, 0, 255, 411500, 'SHUTE', 'Sciences humaines et techniques d''expression'),
(4116, 0, 0, 41, 0, 255, 411600, 'AP-TI', 'Atelier de pratique:techn info comm'),
(4117, 0, 0, 41, 0, 255, 411700, 'CMNOR', 'Communication et organisation'),
(4118, 0, 0, 41, 0, 255, 411800, 'ATCOA', 'Action et communication administratives'),
(4119, 0, 0, 41, 0, 255, 411900, 'EVISP', 'Expression visuelle et production'),
(4120, 0, 0, 41, 0, 255, 412000, 'ERACO', 'Études recherches appliquées à la communication'),
(4121, 0, 0, 41, 0, 255, 412100, 'STCOE', 'Stratégie de communication des entreprises'),
(4122, 0, 0, 41, 0, 255, 412200, 'CTCOM', 'Conception et technique de communication'),
(4123, 0, 0, 41, 0, 255, 412300, 'CMGRH', 'Communication gestion ressources humaines'),
(4124, 0, 0, 41, 0, 255, 412400, 'TECIC', 'Technologie informatique et de communication'),
(4125, 0, 0, 41, 0, 255, 412500, 'TINFC', 'Technologie information et communication'),
(4126, 0, 0, 41, 0, 255, 412600, 'COTCO', 'Communication techniques commerciales'),
(4127, 0, 0, 41, 0, 255, 412700, 'TOIFA', 'Techniques d''org techniq info formation animation'),
(4128, 0, 0, 41, 0, 255, 412800, 'OUCOT', 'Outils de la communication technique'),
(4129, 0, 0, 41, 0, 255, 412900, 'COMTC', 'Communication commerciale et technique'),
(4130, 0, 0, 41, 0, 255, 413000, 'GCLCP', 'Gestion clientèle communication profes'),
(4131, 0, 0, 41, 0, 255, 413100, 'SEMEC', 'Sémiologie espace et  communication'),
(4132, 0, 0, 41, 0, 255, 413200, 'CP-LN', 'Communication professionnelle en langue nationale'),
(4133, 0, 0, 41, 0, 255, 413300, 'INFCO', 'Information et communication'),
(4134, 0, 0, 41, 0, 255, 413400, 'INFGE', 'Information et gestion'),
(4135, 0, 0, 41, 0, 255, 413500, 'COMAN', 'Communication animation'),
(4136, 0, 0, 41, 0, 255, 413600, 'TICOP', 'Techniq.information & communication prof'),
(4137, 0, 0, 41, 0, 255, 413700, 'COGRC', 'Communication & gestion relation client'),
(4138, 0, 0, 41, 0, 255, 413800, 'CMAIC', 'Communication  management interculturels'),
(4139, 0, 0, 41, 0, 255, 413900, 'INFOR', 'Information'),
(4140, 0, 0, 41, 0, 255, 414000, 'ANCOM', 'Analyse et communication'),
(4141, 0, 0, 41, 0, 255, 414100, 'PJCOM', 'Projet de communication'),
(4142, 0, 0, 41, 0, 255, 414200, 'CONSA', 'Conseil et relation annonceur'),
(4143, 0, 0, 41, 0, 255, 414300, 'VEILO', 'Veille opérationnelle'),
(4144, 0, 0, 41, 0, 255, 414400, 'APROD', 'Atelier production'),
(4145, 0, 0, 41, 0, 255, 414500, 'ANIMF', 'Techniques d''animation et de formation'),
(4146, 0, 0, 41, 0, 255, 414600, 'CPUBL', 'Connaissances des publics'),
(4147, 0, 0, 41, 0, 255, 414700, 'COMEO', 'Communication écrite et orale'),
(4148, 0, 0, 41, 0, 255, 414800, 'DESCV', 'Design de communication visuelle'),
(4149, 0, 0, 41, 0, 255, 414900, 'COMTK', 'Communication technique'),
(4150, 0, 0, 41, 0, 255, 415000, 'PRJCO', 'Projet de communication'),
(4151, 0, 0, 41, 0, 255, 415100, 'TPIII', 'Travail partenariat instut.et interinsti'),
(4152, 0, 0, 41, 0, 255, 415200, 'COPRO', 'Communication professionnelle'),
(4153, 0, 0, 41, 0, 255, 415300, 'DYPAR', 'Implications ds dynamiques partenariales'),
(4154, 0, 0, 41, 0, 255, 415400, 'GRCLI', 'Gestion de la relation client'),
(4155, 0, 0, 41, 0, 255, 415500, 'GINFT', 'Gestion de l''information touristique'),
(4156, 0, 0, 41, 0, 255, 415600, 'IMMED', 'Information et multimedias'),
(4157, 0, 0, 41, 0, 255, 415700, 'ITOUR', 'Information et tourismatique'),
(4158, 0, 0, 41, 0, 255, 415800, 'CCOMM', 'Culture de la communication'),
(4159, 0, 0, 41, 0, 255, 415900, 'MEMOC', 'Méthodes et moyens de communication'),
(4160, 0, 0, 41, 0, 255, 416000, 'PROCC', 'Promotion et communication commerciale'),
(4161, 0, 0, 41, 0, 255, 416100, 'TEFAP', 'Technique de formation, d''animation de promotion'),
(4162, 0, 0, 41, 0, 255, 416200, 'ERPED', 'Étude & réalisation de projets d''édition'),
(4163, 0, 0, 41, 0, 255, 416300, 'CTMAN', 'Communication & techniques de management'),
(4164, 0, 0, 41, 0, 255, 416400, 'CTECO', 'Communication technique et commerciale'),
(4165, 0, 0, 41, 0, 255, 416500, 'OAEXC', 'Outils analyse expression et communication'),
(4166, 0, 0, 41, 0, 255, 416600, 'RHCOM', 'Ressources humaines et communication'),
(4199, 0, 0, 41, 0, 255, 419900, 'CMNDV', 'Communication divers'),
(4201, 0, 0, 42, 0, 255, 420100, 'TXASS', 'Travaux d''assurance'),
(4202, 0, 0, 42, 0, 255, 420200, 'BURAS', 'Bureau d''assurance'),
(4203, 0, 0, 42, 0, 255, 420300, 'DCASS', 'Différentes catégories d''assurance'),
(4204, 0, 0, 42, 0, 255, 420400, 'ASSMF', 'Assurances maritimes fluviales aériennes'),
(4205, 0, 0, 42, 0, 255, 420500, 'TXASY', 'Travaux d''application et de synthèse'),
(4206, 0, 0, 42, 0, 255, 420600, 'FONDA', 'Fondamentaux de l''assurance'),
(4207, 0, 0, 42, 0, 255, 420700, 'TASSU', 'Technique d''assurance'),
(4208, 0, 0, 42, 0, 255, 420800, 'AVPRO', 'Aide à la vie professionnelle assurance'),
(4209, 0, 0, 42, 0, 255, 420900, 'ATRSP', 'Assurances transports'),
(4210, 0, 0, 42, 0, 255, 421000, 'EOASS', 'Économie et organisation de l''assurance'),
(4211, 0, 0, 42, 0, 255, 421100, 'EJBCA', 'Ens eco jur out bur tec comm comp adm'),
(4299, 0, 0, 42, 0, 255, 429900, 'ASSUD', 'Assurances divers'),
(4301, 0, 0, 43, 0, 255, 430100, 'T-GES', 'Techniques de gestion et informatique'),
(4302, 0, 0, 43, 0, 255, 430200, 'DECPV', 'Découverte pratique vie orga entreprise'),
(4303, 0, 0, 43, 0, 255, 430300, 'INTEX', 'Intervention extérieure sur entreprise'),
(4304, 0, 0, 43, 0, 255, 430400, 'O-TRA', 'Organisation du travail'),
(4305, 0, 0, 43, 0, 255, 430500, 'G-ENT', 'Gestion de l''entreprise'),
(4306, 0, 0, 43, 0, 255, 430600, 'CNTGS', 'Contrôle de gestion'),
(4307, 0, 0, 43, 0, 255, 430700, 'E-OVE', 'Économie et orga et vie de l''entreprise'),
(4308, 0, 0, 43, 0, 255, 430800, 'O-GEN', 'Organisation et gestion de l''entreprise'),
(4309, 0, 0, 43, 0, 255, 430900, 'OU-MG', 'Outils mathématiques de gestion'),
(4310, 0, 0, 43, 0, 255, 431000, 'PGSEN', 'Principe de gestion entreprises'),
(4311, 0, 0, 43, 0, 255, 431100, 'O-PLN', 'Organisation et planification'),
(4312, 0, 0, 43, 0, 255, 431200, 'E-OEN', 'Économie et organi de l''entreprise'),
(4313, 0, 0, 43, 0, 255, 431300, 'ANADA', 'Analyse administrative et appliquée'),
(4314, 0, 0, 43, 0, 255, 431400, 'OU-GS', 'Outils de gestion'),
(4315, 0, 0, 43, 0, 255, 431500, 'VIENT', 'Vie de l''entreprise'),
(4316, 0, 0, 43, 0, 255, 431600, 'T-QTG', 'Techniques quantitatives de gestion'),
(4317, 0, 0, 43, 0, 255, 431700, 'G-LEG', 'Gestion et législation'),
(4318, 0, 0, 43, 0, 255, 431800, 'O-EEC', 'Organisation exploitations entreprises chantiers'),
(4319, 0, 0, 43, 0, 255, 431900, 'G-VDE', 'Gestion et vie des entreprises'),
(4320, 0, 0, 43, 0, 255, 432000, 'GESTN', 'Gestion'),
(4321, 0, 0, 43, 0, 255, 432100, 'N-GES', 'Enseignement mise à niveau gestion'),
(4322, 0, 0, 43, 0, 255, 432200, 'E-GSE', 'Économie et gestion de l''entreprise'),
(4323, 0, 0, 43, 0, 255, 432300, 'MT-AG', 'Méthodes administratives et gestion'),
(4324, 0, 0, 43, 0, 255, 432400, 'G-ADM', 'Gestion des activités administratives'),
(4325, 0, 0, 43, 0, 255, 432500, 'I-GSE', 'Initiation à la gestion des entreprises'),
(4326, 0, 0, 43, 0, 255, 432600, 'T-ADM', 'Techniques administratives'),
(4327, 0, 0, 43, 0, 255, 432700, 'ENTGS', 'L''entreprise et sa gestion'),
(4328, 0, 0, 43, 0, 255, 432800, 'E-ENT', 'Économie d''entreprise'),
(4329, 0, 0, 43, 0, 255, 432900, 'O-EGE', 'Organisatio product : eco gest entreprise'),
(4330, 0, 0, 43, 0, 255, 433000, 'E-EGS', 'Économie d''entreprise et gestion'),
(4331, 0, 0, 43, 0, 255, 433100, 'MA-GG', 'Mathématiques générales appliquées gestion'),
(4332, 0, 0, 43, 0, 255, 433200, 'OADGS', 'Option à dominante gestion'),
(4333, 0, 0, 43, 0, 255, 433300, 'E-ORO', 'Économie et organisation d''une opération'),
(4334, 0, 0, 43, 0, 255, 433400, 'MT-GP', 'Méthodes d''administration et de gestion des PME PMI'),
(4335, 0, 0, 43, 0, 255, 433500, 'TXSAP', 'Travaux de synthèse et actions profess.'),
(4336, 0, 0, 43, 0, 255, 433600, 'GQUAL', 'Gestion de la qualité (gest entreprises)'),
(4337, 0, 0, 43, 0, 255, 433700, 'OGCOM', 'Organisation gestion commerciales'),
(4338, 0, 0, 43, 0, 255, 433800, 'GLMOM', 'Gest legisl mercatiq outils mathem'),
(4339, 0, 0, 43, 0, 255, 433900, 'GEOSI', 'Gest entrepr org syst information'),
(4340, 0, 0, 43, 0, 255, 434000, 'COGDF', 'Communic org gest dossiers fonctionnels'),
(4341, 0, 0, 43, 0, 255, 434100, 'GEXPL', 'Gestion de l''exploitation'),
(4342, 0, 0, 43, 0, 255, 434200, 'GT-RH', 'Gestion et techniques des ressources humaines'),
(4343, 0, 0, 43, 0, 255, 434300, 'MANOR', 'Management des organisations'),
(4344, 0, 0, 43, 0, 255, 434400, 'GTEAF', 'Gestion techn. et econ. d''une affaire'),
(4345, 0, 0, 43, 0, 255, 434500, 'MANAG', 'Management'),
(4346, 0, 0, 43, 0, 255, 434600, 'SIGES', 'Système d''information et de gestion'),
(4347, 0, 0, 43, 0, 255, 434700, 'MANGE', 'Management et gestion de l''entreprise'),
(4348, 0, 0, 43, 0, 255, 434800, 'AIDEC', 'Aide a la décision'),
(4349, 0, 0, 43, 0, 255, 434900, 'ORGAC', 'Organisation de l''action'),
(4350, 0, 0, 43, 0, 255, 435000, 'GTECO', 'Gestion technique et économique'),
(4351, 0, 0, 43, 0, 255, 435100, 'GVQSE', 'Gest.vie quotidienne ds serv.ou entrepr.'),
(4352, 0, 0, 43, 0, 255, 435200, 'GDROI', 'Gestion et droit'),
(4353, 0, 0, 43, 0, 255, 435300, 'MENTR', 'Management des entreprises'),
(4354, 0, 0, 43, 0, 255, 435400, 'SCDG', 'Sciences de gestion'),
(4355, 0, 0, 43, 0, 255, 435500, 'GESFI', 'Gestion et finance'),
(4356, 0, 0, 43, 0, 255, 435600, 'EGAAE', 'Économie-gestion appliquée agroéquipement'),
(4357, 0, 0, 43, 0, 255, 435700, 'GEDAC', 'Gestion économique & développement de l''activité'),
(4358, 0, 0, 43, 0, 255, 435800, 'ORMEO', 'Organisation et mise en œuvre'),
(4359, 0, 0, 43, 0, 255, 435900, 'MASCG', 'Management et sciences de gestion'),
(4360, 0, 0, 43, 0, 255, 436000, 'GESMG', 'Gestion et management'),
(4361, 0, 0, 43, 0, 255, 436100, 'GEAPP', 'Gestion approfondie'),
(4399, 0, 0, 43, 0, 255, 439900, 'G-DIV', 'Gestion divers'),
(4401, 0, 0, 44, 0, 255, 440100, 'TXSAC', 'Trav.prof.synth.et action.publici.appro.'),
(4402, 0, 0, 44, 0, 255, 440200, 'ETCPU', 'Études commerciales et études publicitaires'),
(4403, 0, 0, 44, 0, 255, 440300, 'SMCPU', 'Stratégie et moyens de communication publicitaire'),
(4499, 0, 0, 44, 0, 255, 449900, 'PUBDI', 'Publicité divers'),
(4501, 0, 0, 45, 0, 255, 450100, 'HUMOD', 'Humanités modernes'),
(4502, 0, 0, 45, 0, 255, 450200, 'SMAJU', 'Stratégie marketing juridique'),
(4503, 0, 0, 45, 0, 255, 450300, 'CPRTE', 'Cultures et pratiques techniques'),
(4504, 0, 0, 45, 0, 255, 450400, 'PPLME', 'Pratiques plastiques et médiations'),
(4505, 0, 0, 45, 0, 255, 450500, 'IPRRE', 'Innovation, prospective et recherche'),
(4506, 0, 0, 45, 0, 255, 450600, 'LEXRE', 'Laboratoire expérimentation et recherche'),
(4507, 0, 0, 45, 0, 255, 450700, 'MACPR', 'Macro-projet'),
(4508, 0, 0, 45, 0, 255, 450800, 'MREPR', 'Mémoire de recherche professionnel'),
(4509, 0, 0, 45, 0, 255, 450900, 'MELVE', 'Mémoire en langue vivante etrangère'),
(4510, 0, 0, 45, 0, 255, 451000, 'PRCRA', 'Pratiques créatives et artistiques'),
(4511, 0, 0, 45, 0, 255, 451100, 'RDPRO', 'Recherche et démarche de projet'),
(4512, 0, 0, 45, 0, 255, 451200, 'DESTC', 'Design, sciences & technologies contemporaines'),
(4513, 0, 0, 45, 0, 255, 451300, 'INEXP', 'Investigation, exploitation, projection'),
(4514, 0, 0, 45, 0, 255, 451400, 'MEDIA', 'Médiation'),
(4601, 0, 0, 46, 0, 255, 460100, 'CULTA', 'Cultures artistiques'),
(4602, 0, 0, 46, 0, 255, 460200, 'TEMEO', 'Technique et mise en œuvre'),
(4603, 0, 0, 46, 0, 255, 460300, 'CAUDA', 'Culture audiovisuelle et artistique'),
(4701, 0, 0, 47, 0, 255, 470100, 'ACMET', 'Accompagnement méthodologique'),
(4702, 0, 0, 47, 0, 255, 470200, 'MODAS', 'Module d''aides spécifiques'),
(4703, 0, 0, 47, 0, 255, 470300, 'ENSHL', 'Enseignement non suivi hors langue vivante'),
(4801, 0, 0, 48, 0, 255, 480100, 'TSYOP', 'Technologie des systèmes optiques'),
(5001, 0, 0, 50, 0, 255, 500100, 'AGINF', 'Langue anglaise appliquée à l''informatique'),
(5002, 0, 0, 50, 0, 255, 500200, 'AGTEC', 'Anglais technique'),
(5003, 0, 0, 50, 0, 255, 500300, 'AGCOM', 'Anglais commercial et technique'),
(5004, 0, 0, 50, 0, 255, 500400, 'ANGL', 'Anglais'),
(5005, 0, 0, 50, 0, 255, 500500, 'LGMOD', 'Langue vivante module'),
(5006, 0, 0, 50, 0, 255, 500600, 'COMLV', 'Communication en lv étrangère'),
(5007, 0, 0, 50, 0, 255, 500700, 'ANGAF', 'Anglais appliqué aux affaires'),
(5008, 0, 0, 50, 0, 255, 500800, 'NVLVE', 'Négociation vente en lve'),
(5009, 0, 0, 50, 0, 255, 500900, 'LILVE', 'Littérature étrangère en langue étrangère'),
(5010, 0, 0, 50, 0, 255, 501000, 'DAALV', 'Design et arts appliqués en lv1'),
(5011, 0, 0, 50, 0, 255, 501100, 'ETLV1', 'Enseignement technologique en lv1'),
(5098, 0, 0, 50, 0, 255, 509800, 'AELVE', 'Accompagn.éducatif - pratique orale lve'),
(5099, 0, 0, 50, 0, 255, 509900, 'LGDIV', 'Langue technique diverse'),
(6001, 0, 0, 60, 0, 255, 600100, 'EQUIA', 'Equitation'),
(6002, 0, 0, 60, 0, 255, 600200, 'HIEQA', 'Hippologie-équitation'),
(6003, 0, 0, 60, 0, 255, 600300, 'MAREA', 'Maréchalerie'),
(6004, 0, 0, 60, 0, 255, 600400, 'ZOOHA', 'Zootechnie hippologie'),
(6101, 0, 0, 61, 0, 255, 610100, 'TCMRA', 'Techniques commerciales'),
(6102, 0, 0, 61, 0, 255, 610200, 'TECOA', 'Techniques économiques'),
(6201, 0, 0, 62, 0, 255, 620100, 'TANIA', 'Techniques animalières'),
(6301, 0, 0, 63, 0, 255, 630100, 'ESF-A', 'Économie sociale familiale'),
(6302, 0, 0, 63, 0, 255, 630200, 'AEN-A', 'Aménagement espaces naturels'),
(6303, 0, 0, 63, 0, 255, 630300, 'TFORA', 'Techniques forestières'),
(6304, 0, 0, 63, 0, 255, 630400, 'APAYA', 'Aménagement paysager'),
(6401, 0, 0, 64, 0, 255, 640100, 'MACHA', 'Machinisme'),
(6402, 0, 0, 64, 0, 255, 640200, 'STEQA', 'Sciences et technologies des équipements'),
(6403, 0, 0, 64, 0, 255, 640300, 'AEQUA', 'Agro-équipements'),
(6404, 0, 0, 64, 0, 255, 640400, 'EQAGA', 'Equipements agroalimentaires'),
(6405, 0, 0, 64, 0, 255, 640500, 'EQHYA', 'Equipements hydrauliques'),
(6406, 0, 0, 64, 0, 255, 640600, 'STAEQ', 'Sciences et techniques des agroéquipements'),
(6510, 0, 0, 65, 0, 255, 651000, 'ETP-A', 'Enseignement technologique et professionnel'),
(6520, 0, 0, 65, 0, 255, 652000, 'SCTCA', 'Sciences et techniques'),
(6530, 0, 0, 65, 0, 255, 653000, 'PPROA', 'Pratiques professionnelles'),
(6540, 0, 0, 65, 0, 255, 654000, 'PROPA', 'Projet professionnel'),
(6601, 0, 0, 66, 0, 255, 660100, 'AGROA', 'Agronomie'),
(6602, 0, 0, 66, 0, 255, 660200, 'STAQA', 'Sciences et techniques aquacoles'),
(6603, 0, 0, 66, 0, 255, 660300, 'STHOA', 'Sciences et techniques horticoles'),
(6604, 0, 0, 66, 0, 255, 660400, 'OENOA', 'Œnologie'),
(6605, 0, 0, 66, 0, 255, 660500, 'VITIA', 'Viticulture'),
(6606, 0, 0, 66, 0, 255, 660600, 'VIOEA', 'Viticulture - Œnologie'),
(6607, 0, 0, 66, 0, 255, 660700, 'ZOOTA', 'Zootechnie'),
(6608, 0, 0, 66, 0, 255, 660800, 'TAQUA', 'Technologie aquacole'),
(6801, 0, 0, 68, 0, 255, 680100, 'GPIAA', 'Génie des procédés IAA'),
(6802, 0, 0, 68, 0, 255, 680200, 'GALIM', 'Génie alimentaire'),
(6803, 0, 0, 68, 0, 255, 680300, 'GINDA', 'Génie industriel'),
(6901, 0, 0, 69, 0, 255, 690100, 'APLUA', 'Act. pluridisciplinaires'),
(6902, 0, 0, 69, 0, 255, 690200, 'AIF-A', 'Aide indiv français'),
(6903, 0, 0, 69, 0, 255, 690300, 'AIM-A', 'Aide indiv maths'),
(6904, 0, 0, 69, 0, 255, 690400, 'ARTSA', 'Arts'),
(6905, 0, 0, 69, 0, 255, 690500, 'BCHIA', 'Biochimie'),
(6906, 0, 0, 69, 0, 255, 690600, 'BCHMA', 'Biochimie - microbiologie'),
(6907, 0, 0, 69, 0, 255, 690700, 'BIOLA', 'Biologie'),
(6908, 0, 0, 69, 0, 255, 690800, 'BANIA', 'Biologie animale'),
(6909, 0, 0, 69, 0, 255, 690900, 'BVEGA', 'Biologie végétale'),
(6910, 0, 0, 69, 0, 255, 691000, 'BECOA', 'Biologie - Ecologie'),
(6911, 0, 0, 69, 0, 255, 691100, 'CHIMA', 'Chimie'),
(6912, 0, 0, 69, 0, 255, 691200, 'CPTBA', 'Compta-bureau'),
(6913, 0, 0, 69, 0, 255, 691300, 'DOCUA', 'Documentation'),
(6914, 0, 0, 69, 0, 255, 691400, 'EPS-A', 'E.P.S.'),
(6915, 0, 0, 69, 0, 255, 691500, 'ECOLA', 'Ecologie'),
(6916, 0, 0, 69, 0, 255, 691600, 'EENTA', 'Économie d''entreprise'),
(6917, 0, 0, 69, 0, 255, 691700, 'EDRTA', 'Économie - droit');
INSERT INTO `sacoche_matiere` (`matiere_id`, `matiere_active`, `matiere_usuelle`, `matiere_famille_id`, `matiere_nb_demandes`, `matiere_ordre`, `matiere_code`, `matiere_ref`, `matiere_nom`) VALUES
(6918, 0, 0, 69, 0, 255, 691800, 'ECJSA', 'Education civique - juridique - sociale'),
(6919, 0, 0, 69, 0, 255, 691900, 'ESOCA', 'Education socioculturelle'),
(6920, 0, 0, 69, 0, 255, 692000, 'FRANA', 'Français'),
(6921, 0, 0, 69, 0, 255, 692100, 'GEO-A', 'Géographie'),
(6922, 0, 0, 69, 0, 255, 692200, 'GESTA', 'Gestion'),
(6923, 0, 0, 69, 0, 255, 692300, 'GRECA', 'Grec'),
(6924, 0, 0, 69, 0, 255, 692400, 'HVC-A', 'Heures de vie de classe'),
(6925, 0, 0, 69, 0, 255, 692500, 'HGECA', 'Histoire-Géo. - Education civique'),
(6926, 0, 0, 69, 0, 255, 692600, 'HIGEA', 'Histoire-Géographie'),
(6927, 0, 0, 69, 0, 255, 692700, 'HPS-A', 'Hygiène - Prévention - Secourisme'),
(6928, 0, 0, 69, 0, 255, 692800, 'INFOA', 'Informatique'),
(6929, 0, 0, 69, 0, 255, 692900, 'LATIA', 'Latin'),
(6930, 0, 0, 69, 0, 255, 693000, 'MATHA', 'Mathématiques'),
(6931, 0, 0, 69, 0, 255, 693100, 'MRCAA', 'Mercatique'),
(6932, 0, 0, 69, 0, 255, 693200, 'MBIOA', 'Microbiologie'),
(6933, 0, 0, 69, 0, 255, 693300, 'PHILA', 'Philosophie'),
(6934, 0, 0, 69, 0, 255, 693400, 'PHYSA', 'Physique'),
(6935, 0, 0, 69, 0, 255, 693500, 'P-APA', 'Physique appliquée'),
(6936, 0, 0, 69, 0, 255, 693600, 'P-CHA', 'Physique-Chimie'),
(6937, 0, 0, 69, 0, 255, 693700, '6937A', 'Pratiques prof.'),
(6938, 0, 0, 69, 0, 255, 693800, 'PSC-A', 'Pratiques soc. et cultur.'),
(6939, 0, 0, 69, 0, 255, 693900, 'PSE-A', 'Prévention santé environnement'),
(6940, 0, 0, 69, 0, 255, 694000, 'SESGA', 'Sci. éco- soc.- gestion'),
(6941, 0, 0, 69, 0, 255, 694100, 'SES-A', 'Sciences éco et sociales'),
(6942, 0, 0, 69, 0, 255, 694200, 'SEH-A', 'Sciences éco. et humaines'),
(6943, 0, 0, 69, 0, 255, 694300, 'SECOA', 'Sciences économiques'),
(6944, 0, 0, 69, 0, 255, 694400, 'SBURA', 'Secrét. bureautique'),
(6945, 0, 0, 69, 0, 255, 694500, 'STATA', 'Statistiques'),
(6946, 0, 0, 69, 0, 255, 694600, 'SVT-A', 'Sciences de la vie et de la terre'),
(6947, 0, 0, 69, 0, 255, 694700, 'TCMUA', 'Tech. de communication'),
(6948, 0, 0, 69, 0, 255, 694800, 'TDOCA', 'Tech. de documentation'),
(6949, 0, 0, 69, 0, 255, 694900, 'TIM-A', 'TIM'),
(6950, 0, 0, 69, 0, 255, 695000, 'FRDOA', 'Français Documentation'),
(6951, 0, 0, 69, 0, 255, 695100, 'FRPHA', 'Français Philosophie'),
(6952, 0, 0, 69, 0, 255, 695200, 'MAINA', 'Mathématiques Informatique'),
(6991, 0, 0, 69, 0, 255, 695301, 'ANG-A', 'Anglais'),
(6992, 0, 0, 69, 0, 255, 695302, 'ALL-A', 'Allemand'),
(6993, 0, 0, 69, 0, 255, 695303, 'ITA-A', 'Italien'),
(6994, 0, 0, 69, 0, 255, 695304, 'ESP-A', 'Espagnol'),
(9010, 0, 0, 90, 0, 255, 901000, 'CATHO', 'Enseignement religieux catholique'),
(9020, 0, 0, 90, 0, 255, 902000, 'ISRLT', 'Enseignement religieux israélite'),
(9030, 0, 0, 90, 0, 255, 903000, 'PROTT', 'Enseignement religieux protestant'),
(9031, 0, 0, 90, 0, 255, 903100, 'LUTHR', 'Enseignement religieux luthérien'),
(9032, 0, 0, 90, 0, 255, 903200, 'CALVN', 'Enseignement religieux calviniste'),
(9099, 0, 0, 90, 0, 255, 909900, 'RLGDI', 'Enseignement religieux divers'),
(9307, 0, 0, 93, 0, 255, 30700, 'GRE', 'Grec moderne'),
(9308, 0, 0, 93, 0, 255, 30800, 'HEB', 'Hébreu'),
(9315, 0, 0, 93, 0, 255, 31500, 'ARM', 'Arménien'),
(9316, 0, 0, 93, 0, 255, 31600, 'AMH', 'Amharique'),
(9317, 0, 0, 93, 0, 255, 31700, 'ARD', 'Arabe dialectal'),
(9318, 0, 0, 93, 0, 255, 31800, 'BER', 'Berbère'),
(9319, 0, 0, 93, 0, 255, 31900, 'BUL', 'Bulgare'),
(9320, 0, 0, 93, 0, 255, 32000, 'CAM', 'Cambodgien'),
(9321, 0, 0, 93, 0, 255, 32100, 'VIE', 'Vietnamien'),
(9322, 0, 0, 93, 0, 255, 32200, 'FIN', 'Finnois'),
(9323, 0, 0, 93, 0, 255, 32300, 'HON', 'Hongrois'),
(9324, 0, 0, 93, 0, 255, 32400, 'ISL', 'Islandais'),
(9325, 0, 0, 93, 0, 255, 32500, 'NOR', 'Norvégien'),
(9326, 0, 0, 93, 0, 255, 32600, 'MLG', 'Malgache'),
(9327, 0, 0, 93, 0, 255, 32700, 'ROU', 'Roumain'),
(9328, 0, 0, 93, 0, 255, 32800, 'TCH', 'Tchèque'),
(9330, 0, 0, 93, 0, 255, 33000, 'PER', 'Persan'),
(9331, 0, 0, 93, 0, 255, 33100, 'TUR', 'Turc'),
(9332, 0, 0, 93, 0, 255, 33200, 'LAO', 'Laotien'),
(9333, 0, 0, 93, 0, 255, 33300, 'SUE', 'Suédois'),
(9334, 0, 0, 93, 0, 255, 33400, 'AME', 'Américain'),
(9335, 0, 0, 93, 0, 255, 33500, 'ALB', 'Albanais'),
(9336, 0, 0, 93, 0, 255, 33600, 'SER', 'Serbe'),
(9337, 0, 0, 93, 0, 255, 33700, 'CRO', 'Croate'),
(9338, 0, 0, 93, 0, 255, 33800, 'BAM', 'Bambara'),
(9339, 0, 0, 93, 0, 255, 33900, 'COE', 'Coréen'),
(9340, 0, 0, 93, 0, 255, 34000, 'HAO', 'Haoussa'),
(9341, 0, 0, 93, 0, 255, 34100, 'HIN', 'Hindi'),
(9342, 0, 0, 93, 0, 255, 34200, 'INM', 'Indonésien-malaysien'),
(9343, 0, 0, 93, 0, 255, 34300, 'MAC', 'Macédonien'),
(9344, 0, 0, 93, 0, 255, 34400, 'PEU', 'Peuhl'),
(9345, 0, 0, 93, 0, 255, 34500, 'SLQ', 'Slovaque'),
(9346, 0, 0, 93, 0, 255, 34600, 'SLN', 'Slovène'),
(9347, 0, 0, 93, 0, 255, 34700, 'SWA', 'Swahili'),
(9348, 0, 0, 93, 0, 255, 34800, 'TAM', 'Tamoul'),
(9350, 0, 0, 93, 0, 255, 35000, 'AUV', 'Auvergnat'),
(9351, 0, 0, 93, 0, 255, 35100, 'BAS', 'Basque'),
(9352, 0, 0, 93, 0, 255, 35200, 'BRE', 'Breton'),
(9353, 0, 0, 93, 0, 255, 35300, 'CAT', 'Catalan'),
(9354, 0, 0, 93, 0, 255, 35400, 'COR', 'Corse'),
(9355, 0, 0, 93, 0, 255, 35500, 'GAL', 'Gallo'),
(9356, 0, 0, 93, 0, 255, 35600, 'GAS', 'Gascon'),
(9357, 0, 0, 93, 0, 255, 35700, 'LAN', 'Languedocien'),
(9358, 0, 0, 93, 0, 255, 35800, 'OCC', 'Langue occitane'),
(9359, 0, 0, 93, 0, 255, 35900, 'LRA', 'Langues régionales d''alsace'),
(9360, 0, 0, 93, 0, 255, 36000, 'LIM', 'Limousin'),
(9361, 0, 0, 93, 0, 255, 36100, 'NIS', 'Nissart'),
(9362, 0, 0, 93, 0, 255, 36200, 'PRV', 'Provençal'),
(9363, 0, 0, 93, 0, 255, 36300, 'TAH', 'Tahitien'),
(9364, 0, 0, 93, 0, 255, 36400, 'VAL', 'Vivaro-alpin'),
(9367, 0, 0, 93, 0, 255, 36700, 'MOS', 'Langues régionales des pays mosellans'),
(9368, 0, 0, 93, 0, 255, 36800, 'MEL', 'Langues mélanésiennes'),
(9369, 0, 0, 93, 0, 255, 36900, 'LMJ', 'Mélanésien ajie'),
(9370, 0, 0, 93, 0, 255, 37000, 'LMR', 'Mélanésien drehu'),
(9371, 0, 0, 93, 0, 255, 37100, 'LMN', 'Mélanésien nengone'),
(9372, 0, 0, 93, 0, 255, 37200, 'LMD', 'Mélanésien paici'),
(9373, 0, 0, 93, 0, 255, 37300, 'CRE', 'Créole'),
(9374, 0, 0, 93, 0, 255, 37400, 'WAL', 'Walissien-futunien'),
(9380, 0, 0, 93, 0, 255, 38000, 'LNS', 'Langue non suivie'),
(9381, 0, 0, 93, 0, 255, 38100, 'LIT', 'Lituanien'),
(9382, 0, 0, 93, 0, 255, 38200, 'EST', 'Estonien'),
(9701, 0, 0, 97, 0, 255, 0, 'BPASS', 'Accompagnement soins et services à la personne'),
(9702, 0, 0, 97, 0, 255, 0, 'BPARC', 'Accueil - relation clients et usagers'),
(9703, 0, 0, 97, 0, 255, 0, 'BPAOA', 'Aéronautique - option mécanicien systèmes avionique'),
(9704, 0, 0, 97, 0, 255, 0, 'BPAOC', 'Aéronautique - option mécanicien système cellule'),
(9705, 0, 0, 97, 0, 255, 0, 'BPA3O', 'Aéronautique à trois options (avionique - syst. et structures)'),
(9706, 0, 0, 97, 0, 255, 0, 'BPAEA', 'Agencement de l''espace architectural'),
(9707, 0, 0, 97, 0, 255, 0, 'BPAFB', 'Aménagement et finition du bâtiment'),
(9708, 0, 0, 97, 0, 255, 0, 'BPAMP', 'Artisanat et métiers d''art - option arts de la pierre'),
(9709, 0, 0, 97, 0, 255, 0, 'BPAMC', 'Artisanat et métiers d''art - option comm. visuelle pluri média'),
(9710, 0, 0, 97, 0, 255, 0, 'BPAME', 'Artisanat et métiers d''art - option ébéniste'),
(9711, 0, 0, 97, 0, 255, 0, 'BPAMM', 'Artisanat et métiers d''art - option marchandisage visuel'),
(9712, 0, 0, 97, 0, 255, 0, 'BPAMT', 'Artisanat et métiers d''art - option tapissier d''ameublement'),
(9713, 0, 0, 97, 0, 255, 0, 'BPAMV', 'Artisanat et métiers d''art - verrerie + enseigne / signalétique'),
(9714, 0, 0, 97, 0, 255, 0, 'BPAG', 'Aviation générale'),
(9715, 0, 0, 97, 0, 255, 0, 'BPBIT', 'Bio-industries de transformation'),
(9716, 0, 0, 97, 0, 255, 0, 'BPBP', 'Boulanger - pâtissier'),
(9717, 0, 0, 97, 0, 255, 0, 'BPBCT', 'Boucher charcutier traiteur'),
(9718, 0, 0, 97, 0, 255, 0, 'BPCOM', 'Commerce'),
(9719, 0, 0, 97, 0, 255, 0, 'BPCSR', 'Commercialisation et services en restauration'),
(9720, 0, 0, 97, 0, 255, 0, 'BPCPT', 'Comptabilité'),
(9721, 0, 0, 97, 0, 255, 0, 'BPCTR', 'Conducteur transport routier marchandises'),
(9722, 0, 0, 97, 0, 255, 0, 'BPCR', 'Construction des carrosseries'),
(9723, 0, 0, 97, 0, 255, 0, 'BPCUI', 'Cuisine'),
(9724, 0, 0, 97, 0, 255, 0, 'BPCM', 'Cultures marines'),
(9725, 0, 0, 97, 0, 255, 0, 'BPEEE', 'Électrotechnique, énergie, équipement communicants'),
(9726, 0, 0, 97, 0, 255, 0, 'BPEN', 'Environnement nucléaire'),
(9727, 0, 0, 97, 0, 255, 0, 'BPECP', 'Esthétique cosmétique parfumerie'),
(9728, 0, 0, 97, 0, 255, 0, 'BPEPI', 'Étude et définition de produits industriels'),
(9729, 0, 0, 97, 0, 255, 0, 'BPFPI', 'Façonnage de produits imprimés, routage'),
(9730, 0, 0, 97, 0, 255, 0, 'BPFON', 'Fonderie'),
(9731, 0, 0, 97, 0, 255, 0, 'BPGA', 'Gestion administration'),
(9732, 0, 0, 97, 0, 255, 0, 'BPGP', 'Gestion des pollutions et protection de l''environnement'),
(9733, 0, 0, 97, 0, 255, 0, 'BPHE', 'Hygiène et environnement'),
(9734, 0, 0, 97, 0, 255, 0, 'BPHPS', 'Hygiène, propreté et stérilisation'),
(9735, 0, 0, 97, 0, 255, 0, 'BPIP', 'Industrie de procédés'),
(9736, 0, 0, 97, 0, 255, 0, 'BPIPC', 'Industries des pates, papiers et cartons'),
(9737, 0, 0, 97, 0, 255, 0, 'BPIPB', 'Interventions sur le patrimoine bâti'),
(9738, 0, 0, 97, 0, 255, 0, 'BPLOG', 'Logistique'),
(9739, 0, 0, 97, 0, 255, 0, 'BPMVA', 'Maintenance de véhicules automobiles'),
(9740, 0, 0, 97, 0, 255, 0, 'BPMEI', 'Maintenance des équipements industriels'),
(9741, 0, 0, 97, 0, 255, 0, 'BPMM', 'Maintenance des matériels'),
(9742, 0, 0, 97, 0, 255, 0, 'BPMN', 'Maintenance nautique'),
(9743, 0, 0, 97, 0, 255, 0, 'BPMMV', 'Métiers de la mode - vêtements'),
(9744, 0, 0, 97, 0, 255, 0, 'BPMCC', 'Métiers du cuir option chaussures'),
(9745, 0, 0, 97, 0, 255, 0, 'BPMCM', 'Métiers du cuir option maroquinerie'),
(9746, 0, 0, 97, 0, 255, 0, 'BPMPB', 'Métiers du pressing et de la blanchisserie'),
(9747, 0, 0, 97, 0, 255, 0, 'BPMIC', 'Microtechniques'),
(9748, 0, 0, 97, 0, 255, 0, 'BPMIT', 'Mise en œuvre des matériaux option industries textiles'),
(9749, 0, 0, 97, 0, 255, 0, 'BPMMC', 'Mise en œuvre des matériaux opt. mat. métal. moulés, céramiques'),
(9750, 0, 0, 97, 0, 255, 0, 'BPOL', 'Optique lunetterie'),
(9751, 0, 0, 97, 0, 255, 0, 'BPOBS', 'Ouvrage du bâtiment : aluminium, verre et matériaux de synthèse'),
(9752, 0, 0, 97, 0, 255, 0, 'BPOBM', 'Ouvrage du bâtiment : métallerie'),
(9753, 0, 0, 97, 0, 255, 0, 'BPPP', 'Perruquier posticheur'),
(9754, 0, 0, 97, 0, 255, 0, 'BPPHO', 'Photographie'),
(9755, 0, 0, 97, 0, 255, 0, 'BPPSP', 'Pilotage de systèmes de production automatisée'),
(9756, 0, 0, 97, 0, 255, 0, 'BPPLP', 'Pilote de ligne de production'),
(9757, 0, 0, 97, 0, 255, 0, 'BPPC', 'Plastiques et composites'),
(9758, 0, 0, 97, 0, 255, 0, 'BPPET', 'Poissonnier écailler traiteur'),
(9759, 0, 0, 97, 0, 255, 0, 'BPPCE', 'Procédés de la chimie, de l''eau et des papiers-cartons'),
(9760, 0, 0, 97, 0, 255, 0, 'BPPG', 'Production graphique'),
(9761, 0, 0, 97, 0, 255, 0, 'BPPI', 'Production imprimée'),
(9762, 0, 0, 97, 0, 255, 0, 'BPPMD', 'Productique mécanique - option décolletage'),
(9763, 0, 0, 97, 0, 255, 0, 'BPPD', 'Prothèse dentaire'),
(9764, 0, 0, 97, 0, 255, 0, 'BPRC', 'Réparation des carrosseries'),
(9765, 0, 0, 97, 0, 255, 0, 'BPSEC', 'Secrétariat'),
(9766, 0, 0, 97, 0, 255, 0, 'BPSP', 'Sécurité prévention'),
(9767, 0, 0, 97, 0, 255, 0, 'BPSPL', 'Services de proximité et vie locale'),
(9768, 0, 0, 97, 0, 255, 0, 'BPSEN', 'Systèmes électroniques numériques'),
(9769, 0, 0, 97, 0, 255, 0, 'BPTA', 'Technicien aérostructure'),
(9770, 0, 0, 97, 0, 255, 0, 'BPTCB', 'Technicien constructeur bois'),
(9771, 0, 0, 97, 0, 255, 0, 'BPTFB', 'Technicien de fabrication bois et matériaux associes'),
(9772, 0, 0, 97, 0, 255, 0, 'BPTEC', 'Technicien de maintenance de syst. énergétiques et climatiques'),
(9773, 0, 0, 97, 0, 255, 0, 'BPTSC', 'Technicien de scierie'),
(9774, 0, 0, 97, 0, 255, 0, 'BPTB', 'Technicien du bâtiment : organisation réalisation du gros œuvre'),
(9775, 0, 0, 97, 0, 255, 0, 'BPTFC', 'Technique du froid et du conditionnement de l''air'),
(9776, 0, 0, 97, 0, 255, 0, 'BPTEB', 'Technicien d''études du bâtiment'),
(9777, 0, 0, 97, 0, 255, 0, 'BPTU', 'Technicien d''usinage'),
(9778, 0, 0, 97, 0, 255, 0, 'BPTCI', 'Technicien en chaudronnerie industrielle'),
(9779, 0, 0, 97, 0, 255, 0, 'BPTIC', 'Technicien en installation de syst. énergétiques et climatiques'),
(9780, 0, 0, 97, 0, 255, 0, 'BPTGT', 'Technicien géomètre topographe'),
(9781, 0, 0, 97, 0, 255, 0, 'BPTMA', 'Technicien menuisier agenceur'),
(9782, 0, 0, 97, 0, 255, 0, 'BPTM', 'Technicien modeleur'),
(9783, 0, 0, 97, 0, 255, 0, 'BPTO', 'Technicien outilleur'),
(9784, 0, 0, 97, 0, 255, 0, 'BPTSU', 'Traitements de surfaces'),
(9785, 0, 0, 97, 0, 255, 0, 'BPTRA', 'Transport'),
(9786, 0, 0, 97, 0, 255, 0, 'BPTF', 'Transport fluvial'),
(9787, 0, 0, 97, 0, 255, 0, 'BPTP', 'Travaux publics'),
(9788, 0, 0, 97, 0, 255, 0, 'BPV', 'Vente (prospection-négociation-suivi de clientèle)'),
(9789, 0, 0, 97, 0, 255, 0, 'BPAOO', 'Artisanat et métiers d''art - facteur d''orgues option organier'),
(9790, 0, 0, 97, 0, 255, 0, 'BPAOT', 'Artisanat et métiers d''art - facteur d''orgues option tuyautier'),
(9791, 0, 0, 97, 0, 255, 0, 'BPMVA', 'Maintenance de véhicules - option A voitures particulières'),
(9792, 0, 0, 97, 0, 255, 0, 'BPMVB', 'Maintenance de véhicules - option B véh. de transport routier'),
(9793, 0, 0, 97, 0, 255, 0, 'BPMVC', 'Maintenance de véhicules - option C motocycles'),
(9794, 0, 0, 97, 0, 255, 0, 'BPMAV', 'Menuiserie aluminium verre'),
(9795, 0, 0, 97, 0, 255, 0, 'BPMS', 'Métiers de la sécurité'),
(9796, 0, 0, 97, 0, 255, 0, 'BPRPG', 'Réal. de prod. imprimés et plurimédia option A prod. graphiques'),
(9797, 0, 0, 97, 0, 255, 0, 'BPRPI', 'Réal. de prod. imprimés et plurimédia option B prod. imprimées'),
(9798, 0, 0, 97, 0, 255, 0, 'BPTIN', 'Techniques d''interventions sur installations nucléaires'),
(9801, 0, 0, 98, 0, 255, 0, 'CPHAB', 'Habitat'),
(9802, 0, 0, 98, 0, 255, 0, 'CPHAS', 'Hygiène - Alimentation - Services'),
(9803, 0, 0, 98, 0, 255, 0, 'CPERE', 'Espace rural et environnement'),
(9804, 0, 0, 98, 0, 255, 0, 'CPVDM', 'Vente - Distribution - Magasinage'),
(9805, 0, 0, 98, 0, 255, 0, 'CPPI', 'Production industrielle'),
(9901, 0, 1, 99, 0, 255, 0, 'P1', 'P1 Maîtrise de la langue française'),
(9902, 0, 1, 99, 0, 255, 0, 'P2', 'P2 Pratique d''une langue vivante étrangère'),
(9903, 0, 1, 99, 0, 255, 0, 'P3A', 'P3 Principaux éléments de mathématiques'),
(9904, 0, 1, 99, 0, 255, 0, 'P3B', 'P3 Culture scientifique et technologique'),
(9905, 0, 1, 99, 0, 255, 0, 'P4', 'P4 Maîtrise des TICE'),
(9906, 0, 1, 99, 0, 255, 0, 'P5', 'P5 Culture humaniste'),
(9907, 0, 1, 99, 0, 255, 0, 'P6', 'P6 Compétences sociales et civiques'),
(9908, 0, 1, 99, 0, 255, 0, 'P7', 'P7 Autonomie et initiative'),
(9911, 0, 1, 99, 0, 255, 0, 'APS', 'Apprendre à porter secours'),
(9912, 0, 1, 99, 0, 255, 0, 'PSC1', 'Prévention et secours civiques de niveau 1'),
(9913, 0, 1, 99, 0, 255, 0, 'PSC2', 'Prévention et secours civiques de niveau 2'),
(9921, 0, 1, 99, 0, 255, 0, 'APER', 'Attestation de première éducation à la route'),
(9922, 0, 1, 99, 0, 255, 0, 'ASSR1', 'Attestation scolaire de sécurité routière de niveau 1'),
(9923, 0, 1, 99, 0, 255, 0, 'ASSR2', 'Attestation scolaire de sécurité routière de niveau 2'),
(9931, 0, 1, 99, 0, 255, 0, 'D1', 'D1 Les langages pour penser et communiquer'),
(9932, 0, 1, 99, 0, 255, 0, 'D2', 'D2 Les méthodes et outils pour apprendre'),
(9933, 0, 1, 99, 0, 255, 0, 'D3', 'D3 La formation de la personne et du citoyen'),
(9934, 0, 1, 99, 0, 255, 0, 'D4', 'D4 Les systèmes naturels et les systèmes techniques'),
(9935, 0, 1, 99, 0, 255, 0, 'D5', 'D5 Les représentations du monde et l''activité humaine'),
(9941, 0, 1, 99, 0, 255, 0, 'C23QM', 'Questionner le monde (cycles 2-3)'),
(9942, 0, 1, 99, 0, 255, 0, 'C23ST', 'Sciences et technologie (cycles 2-3)'),
(9943, 0, 1, 99, 0, 255, 0, 'C23EA', 'Enseignements artistiques (cycles 2-3)'),
(9944, 0, 1, 99, 0, 255, 0, 'C23LV', 'Langue vivante (cycles 2-3)'),
(9991, 0, 1, 99, 0, 255, 0, 'DOC', 'Documentation'),
(9992, 0, 1, 99, 0, 255, 0, 'INFO', 'Informatique'),
(9999, 0, 1, 99, 0, 255, 0, 'TRANS', 'Transversal');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_matiere_famille`
--

CREATE TABLE IF NOT EXISTS `sacoche_matiere_famille` (
  `matiere_famille_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `matiere_famille_categorie` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1 = Enseignements usuels ; 2 = Enseignements généraux ; 3 = Enseignements spécifiques ; 4 = Enseignements complémentaires',
  `matiere_famille_nom` varchar(55) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`matiere_famille_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_matiere_famille`
--

INSERT INTO `sacoche_matiere_famille` (`matiere_famille_id`, `matiere_famille_categorie`, `matiere_famille_nom`) VALUES
(1, 2, 'Philosophie sciences humaines'),
(2, 2, 'Lettres'),
(3, 2, 'Langues vivantes'),
(4, 2, 'Histoire géographie'),
(5, 2, 'Sciences économiques et sociales'),
(6, 2, 'Sciences'),
(7, 2, 'Technologie'),
(8, 2, 'Éducation musicale'),
(9, 2, 'Arts plastiques'),
(10, 2, 'Éducation physique et sportive'),
(11, 3, 'Génie industriel du bois'),
(12, 3, 'Génie industriel textile et cuir'),
(13, 3, 'Génie industriel verre céramique'),
(14, 3, 'Génie structures métalliques'),
(15, 3, 'Génie industriel plastiques composites'),
(16, 3, 'Génie chimique'),
(17, 3, 'Génie civil'),
(18, 3, 'Génie thermique'),
(19, 3, 'Génie mécanique de la construction'),
(20, 3, 'Génie mécanique de la productique'),
(21, 3, 'Génie mécanique de la maintenance'),
(22, 3, 'Génie électrique électronique'),
(23, 3, 'Génie électrique électrotechnique'),
(24, 3, 'Génie électrique informat.- télématique'),
(25, 3, 'Indust. graphiques (imprimerie - livre)'),
(26, 3, 'Conduite - navigation'),
(27, 3, 'Métiers des arts appliqués'),
(28, 3, 'Métiers d''art'),
(29, 3, 'Métiers de l''artisanat et spécifiques'),
(30, 3, 'Biotechnologie génie biol.- biochimique'),
(31, 3, 'Biotechnologie santé environnement collectivités'),
(32, 3, 'Paramédical et médical'),
(33, 3, 'Soins personnels'),
(34, 3, 'Commerce'),
(35, 3, 'Bureautique et secrétariat'),
(36, 3, 'Droit et législation'),
(37, 3, 'Informatique de gestion'),
(38, 3, 'Économie'),
(39, 3, 'Comptabilité - finances'),
(40, 3, 'Hôtellerie - tourisme'),
(41, 3, 'Communication'),
(42, 3, 'Assurances'),
(43, 3, 'Gestion des entreprises'),
(44, 3, 'Publicité'),
(45, 3, 'Métiers des arts appliqués (suite)'),
(46, 3, 'Métiers d''art (suite)'),
(47, 2, 'Activités non spécialisées (suite)'),
(48, 2, 'Sciences (suite)'),
(50, 3, 'Langue technique'),
(60, 3, 'Activités hippiques'),
(61, 3, 'Commercialisation'),
(62, 3, 'Élevage et soins aux animaux'),
(63, 3, 'Environnement - aménagement de l''espace'),
(64, 3, 'Équipements pour l''agriculture'),
(65, 3, 'Disciplines professionnelles de l''enseignement agricole'),
(66, 3, 'Production'),
(67, 3, 'Services'),
(68, 3, 'Transformation'),
(69, 3, 'Disciplines générales enseignement agricole'),
(90, 3, 'Enseignement religieux'),
(93, 4, 'Langues vivantes régionales ou spécifiques'),
(97, 4, 'Spécialités de baccalauréat professionnel'),
(98, 4, 'Champs professionnels en SEGPA'),
(99, 1, 'Matières principales'),
(100, 2, 'Activités non spécialisées');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_message`
--

CREATE TABLE IF NOT EXISTS `sacoche_message` (
  `message_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `message_debut_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `message_fin_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `message_contenu` text COLLATE utf8_unicode_ci NOT NULL,
  `message_dests_cache` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `user_id` (`user_id`),
  KEY `message_debut_date` (`message_debut_date`),
  KEY `message_fin_date` (`message_fin_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_niveau`
--

CREATE TABLE IF NOT EXISTS `sacoche_niveau` (
  `niveau_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `niveau_actif` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `niveau_usuel` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `niveau_famille_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `niveau_ordre` smallint(5) unsigned NOT NULL DEFAULT '0',
  `niveau_ref` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `code_mef` char(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Masque à comparer avec le code_mef d''une classe (nomenclature Sconet).',
  `niveau_nom` varchar(75) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`niveau_id`),
  KEY `niveau_actif` (`niveau_actif`),
  KEY `niveau_famille_id` (`niveau_famille_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1000000 ;

--
-- Contenu de la table `sacoche_niveau`
--

INSERT INTO `sacoche_niveau` (`niveau_id`, `niveau_actif`, `niveau_usuel`, `niveau_famille_id`, `niveau_ordre`, `niveau_ref`, `code_mef`, `niveau_nom`) VALUES
(1, 0, 1, 1, 5, 'P1', '', 'Cycle 1 (PS-MS-GS)'),
(2, 0, 1, 1, 30, 'P2', '', 'Cycle 2 (CP-CE1-CE2)'),
(3, 0, 1, 1, 90, 'P3', '', 'Cycle 3 (CM1-CM2-6E)'),
(4, 0, 1, 1, 150, 'P4', '', 'Cycle 4 (5E-4E-3E)'),
(10, 0, 1, 1, 160, 'COLL', '', 'Cycle Collège'),
(16, 0, 0, 1, 170, 'SEGPA', '', 'Cycle SEGPA'),
(20, 0, 1, 1, 205, 'LYCEE', '', 'Cycle Lycée'),
(23, 0, 0, 1, 233, 'BT', '', 'Cycle BT'),
(24, 0, 0, 1, 244, 'CAP', '', 'Cycle CAP'),
(25, 0, 0, 1, 244, 'BEP', '', 'Cycle BEP'),
(26, 0, 0, 1, 248, 'PRO', '', 'Cycle Bac Pro'),
(27, 0, 0, 1, 252, 'BMA', '', 'Cycle BMA'),
(28, 0, 0, 1, 255, 'BP', '', 'Cycle BP'),
(29, 0, 0, 1, 272, 'CAPa', '', 'Cycle CAP Agricole'),
(30, 0, 0, 1, 277, 'PROa', '', 'Cycle Bac Pro Agricole'),
(31, 0, 0, 1, 301, 'CPGE', '', 'Cycle CPGE'),
(32, 0, 0, 1, 313, 'BTS', '', 'Cycle BTS'),
(33, 0, 0, 1, 317, 'DMA', '', 'Cycle DMA'),
(35, 0, 0, 1, 351, 'DUT', '', 'Cycle DUT'),
(37, 0, 0, 1, 372, 'BTSa', '', 'Cycle BTS Agricole'),
(201, 0, 0, 2, 71, 'A1', '', 'A1 : Introductif - Découverte'),
(202, 0, 0, 2, 72, 'A2', '', 'A2 : Intermédiaire - Usuel'),
(203, 0, 0, 2, 73, 'B1', '', 'B1 : Seuil'),
(204, 0, 0, 2, 74, 'B2', '', 'B2 : Avancé - Indépendant'),
(205, 0, 0, 2, 75, 'C1', '', 'C1 : Autonome'),
(206, 0, 0, 2, 76, 'C2', '', 'C2 : Maîtrise'),
(301, 0, 0, 3, 81, 'N1', '', 'Niveau 1'),
(302, 0, 0, 3, 82, 'N2', '', 'Niveau 2'),
(303, 0, 0, 3, 83, 'N3', '', 'Niveau 3'),
(304, 0, 0, 3, 84, 'N4', '', 'Niveau 4'),
(305, 0, 0, 3, 85, 'N5', '', 'Niveau 5'),
(1011, 0, 1, 60, 0, 'TPS', '0041000111.', 'TPS (maternelle, toute petite section)'),
(1031, 0, 1, 60, 1, 'PS', '0001000131.', 'PS (maternelle, petite section)'),
(1032, 0, 1, 60, 2, 'MS', '0001000132.', 'MS (maternelle, moyenne section)'),
(1033, 0, 1, 60, 3, 'GS', '0001000133.', 'GS (maternelle, grande section)'),
(10001, 0, 1, 60, 11, 'CP', '0011000211.', 'CP (cours préparatoire)'),
(20001, 0, 1, 60, 21, 'CE1', '0021000221.', 'CE1 (cours élémentaire 1e année)'),
(20002, 0, 1, 60, 22, 'CE2', '0021000222.', 'CE2 (cours élémentaire 2e année)'),
(30001, 0, 1, 60, 31, 'CM1', '0031000221.', 'CM1 (cours moyen 1e année)'),
(30002, 0, 1, 60, 32, 'CM2', '0031000222.', 'CM2 (cours moyen 2e année)'),
(60002, 0, 0, 60, 60, '1UPE2A', '0601000311.', 'UPE2A (unité pédagogique pour élèves allophones arrivants)'),
(61001, 0, 0, 61, 61, 'ADAP', '0611000411.', 'Classe d''adaptation'),
(62001, 0, 0, 62, 62, 'CLIS', '0621000511.', 'CLIS (classe pour l''inclusion scolaire)'),
(100001, 0, 0, 100, 100, '6MUS', '1001000211.', 'Sixième musique'),
(100002, 0, 0, 100, 100, '6UPE2A', '1001000411.', 'Sixième UPE2A'),
(100003, 0, 1, 100, 100, '6', '1001001211.', 'Sixième'),
(100004, 0, 0, 100, 100, '6DANSE', '1001002211.', 'Sixième danse'),
(100005, 0, 0, 100, 100, '6THEAT', '1001002311.', 'Sixième théâtre'),
(100027, 0, 0, 100, 100, '6BC', '1001002711.', 'Sixième bilangue de continuité'),
(100028, 0, 0, 100, 100, '6BCD', '1001002811.', 'Sixième bilangue de continuité danse'),
(100029, 0, 0, 100, 100, '6BCM', '1001002911.', 'Sixième bilangue de continuité musique'),
(100030, 0, 0, 100, 100, '6BCT', '1001003011.', 'Sixième bilangue de continuité théâtre'),
(101001, 0, 1, 100, 101, '5', '1011000111.', 'Cinquième'),
(101002, 0, 0, 100, 101, '5MUS', '1011000211.', 'Cinquième musique'),
(101003, 0, 0, 100, 101, '5UPE2A', '1011000411.', 'Cinquième UPE2A'),
(101004, 0, 0, 100, 101, '5DANSE', '1011002211.', 'Cinquième danse'),
(101005, 0, 0, 100, 101, '5THEAT', '1011002311.', 'Cinquième théâtre'),
(102001, 0, 1, 100, 102, '4', '1021000111.', 'Quatrième'),
(102002, 0, 0, 100, 102, '4MUS', '1021000211.', 'Quatrième musique'),
(102003, 0, 0, 100, 102, '4UPE2A', '1021000411.', 'Quatrième UPE2A'),
(102004, 0, 0, 100, 102, '4AES', '1021000711.', 'Quatrième d''aide et de soutien'),
(102005, 0, 0, 100, 102, '4E-AGR', '1021002111.', 'Quatrième de l''enseignement agricole'),
(102006, 0, 0, 100, 102, '4DANSE', '1021002211.', 'Quatrième danse'),
(102007, 0, 0, 100, 102, '4THEAT', '1021002311.', 'Quatrième théâtre'),
(103001, 0, 0, 100, 103, '3MUS', '1031000211.', 'Troisième musique'),
(103002, 0, 0, 100, 103, '3UPE2A', '1031000411.', 'Troisième UPE2A'),
(103003, 0, 1, 100, 103, '3', '1031001911.', 'Troisième'),
(103004, 0, 0, 100, 103, '3E-AGR', '1031002111.', 'Troisième de l''enseignement agricole'),
(103005, 0, 0, 100, 103, '3DANSE', '1031002211.', 'Troisième danse'),
(103006, 0, 0, 100, 103, '3THEAT', '1031002311.', 'Troisième théâtre'),
(103007, 0, 0, 100, 103, '3PPRO', '1031002611.', 'Troisième prépa pro'),
(104001, 0, 0, 100, 104, '3I', '1041000111.', 'Troisième d''insertion'),
(105001, 0, 0, 100, 105, 'CL-REL', '1051001511.', 'Classe relais'),
(105002, 0, 0, 100, 105, 'ATREL', '1051002011.', 'Atelier relais'),
(106001, 0, 0, 100, 106, 'ULIS', '1061001611.', 'ULIS (unité localisée pour l''inclusion scolaire)'),
(110001, 0, 0, 160, 110, '3PVP', '1101000622.', '3PVP (troisième préparatoire à la voie professionnelle)'),
(112001, 0, 0, 160, 112, 'CPA', '1122199911.', 'CPA (classe préparatoire à l''apprentissage)'),
(113001, 0, 0, 160, 113, 'CLIPA', '1139999911.', 'CLIPA (classe d''initiation pré-professionnelle en alternance)'),
(114001, 0, 0, 160, 114, 'FAJ', '1149999911.', 'FAJ (formation d''apprenti junior)'),
(115001, 0, 0, 160, 115, 'DIMA', '1159999911.', 'DIMA (dispositif d''initiation aux métiers en alternance)'),
(164001, 0, 0, 160, 164, '6SEGPA', '1641000211.', 'Sixième SEGPA'),
(165001, 0, 0, 160, 165, '5SEGPA', '1651000211.', 'Cinquième SEGPA'),
(166001, 0, 0, 160, 166, '4SEGPA', '1661000211.', 'Quatrième SEGPA'),
(167001, 0, 0, 160, 167, '3SEGPA', '1671000211.', 'Troisième SEGPA'),
(200001, 0, 1, 200, 200, '2', '2001001411.', 'Seconde de détermination'),
(200002, 0, 0, 200, 200, '2GT2', '2001001511.', 'Seconde 2 ens. exploration)'),
(200003, 0, 0, 200, 200, '2GT3', '2001001611.', 'Seconde 3 ens. exploration)'),
(200004, 0, 0, 200, 200, '2GT1', '2001001711.', 'Seconde 1 ens. exploration)'),
(201000, 0, 1, 200, 201, '1', '2011....11.', 'Première générale'),
(201001, 0, 1, 200, 201, '1S', '20111...11.', 'Première S (scientifique)'),
(201002, 0, 0, 200, 201, '1S-SVT', '2011101011.', 'Première S (scientifique) option SVT'),
(201003, 0, 0, 200, 201, '1S-SI', '2011101111.', 'Première S (scientifique) option SI'),
(201004, 0, 0, 200, 201, '1S-EAT', '2011101311.', 'Première S (scientifique) option EAT'),
(201005, 0, 1, 200, 201, '1ES', '2011200511.', 'Première ES (économique et sociale)'),
(201006, 0, 1, 200, 201, '1L', '2011301911.', 'Première L (littéraire)'),
(202000, 0, 1, 200, 202, 'T', '2021....11.', 'Terminale générale'),
(202001, 0, 1, 200, 202, 'TS', '20211...11.', 'Terminale S (scientifique)'),
(202002, 0, 0, 200, 202, 'TS-SVT', '2021101011.', 'Terminale S (scientifique) option SVT'),
(202003, 0, 0, 200, 202, 'TS-SI', '2021101111.', 'Terminale S (scientifique) option SI'),
(202004, 0, 0, 200, 202, 'TS-EAT', '2021101311.', 'Terminale S (scientifique) option EAT'),
(202005, 0, 1, 200, 202, 'TES', '2021200511.', 'Terminale ES (économique et sociale)'),
(202006, 0, 1, 200, 202, 'TL', '2021301911.', 'Terminale L (littéraire)'),
(210000, 0, 1, 210, 210, '2T', '210.....11.', 'Seconde technologique'),
(210001, 0, 0, 210, 210, '2INS', '2101330111.', 'Seconde musique option instrument'),
(210002, 0, 0, 210, 210, '2DAN', '2101330211.', 'Seconde musique option danse'),
(210003, 0, 0, 210, 210, '2STHR', '2103340211.', 'Seconde STHR'),
(211000, 0, 1, 210, 211, '1ST', '211.....11.', 'Première sciences et technologies'),
(211001, 0, 0, 210, 211, '1INS', '2111330111.', 'Première musique option instrument'),
(211002, 0, 0, 210, 211, '1DAN', '2111330211.', 'Première musique option danse'),
(211003, 0, 0, 210, 211, '1STD2A', '2111340311.', 'Première STD2A sc.& tec.design.arts appliqués'),
(211004, 0, 0, 210, 211, '1STI2D', '2112000311.', 'Première STI2D architecture construction'),
(211005, 0, 0, 210, 211, '1STI2D', '2112000411.', 'Première STI2D énergies et environnement'),
(211006, 0, 0, 210, 211, '1STI2D', '2112000511.', 'Première STI2D innov.techno. eco concept.'),
(211007, 0, 0, 210, 211, '1STI2D', '2112000611.', 'Première STI2D système info. et numérique'),
(211008, 0, 0, 210, 211, '1STL', '2112000711.', 'Première STL biotechnologies'),
(211009, 0, 0, 210, 211, '1STL', '2112000811.', 'Première STL sc.phys.chim. en laboratoire'),
(211010, 0, 0, 210, 211, '1STMG', '2113101611.', 'Première STMG sc. & techno. management gestion'),
(211011, 0, 0, 210, 211, '1ST2S', '2113310411.', 'Première ST2S sc. & techno. santé & social'),
(211012, 0, 0, 210, 211, '1HOT', '2113340111.', 'Première technologique hôtellerie'),
(211013, 0, 0, 210, 211, '1STHR', '2113340211.', 'Première STHR'),
(212000, 0, 1, 210, 212, 'TST', '212.....11.', 'Terminale sciences et technologies'),
(212001, 0, 0, 210, 212, 'TINS', '2121330111.', 'Terminale musique option instrument'),
(212002, 0, 0, 210, 212, 'TDAN', '2121330211.', 'Terminale musique option danse'),
(212003, 0, 0, 210, 212, 'TSTD2A', '2121340311.', 'Terminale STD2A sc.& tec.design-arts appliqués'),
(212004, 0, 0, 210, 212, 'TSTI2D', '2122000311.', 'Terminale STI2D architecture construction'),
(212005, 0, 0, 210, 212, 'TSTI2D', '2122000411.', 'Terminale STI2D énergies et environnement'),
(212006, 0, 0, 210, 212, 'TSTI2D', '2122000511.', 'Terminale STI2D innov.techno. eco concept.'),
(212007, 0, 0, 210, 212, 'TSTI2D', '2122000611.', 'Terminale STI2D système info. et numérique'),
(212008, 0, 0, 210, 212, 'TSTL', '2122000711.', 'Terminale STL biotechnologies'),
(212009, 0, 0, 210, 212, 'TSTL', '2122000811.', 'Terminale STL sc.phys.chim. en laboratoire'),
(212010, 0, 0, 210, 212, 'TSTMG', '2123101711.', 'Terminale STMG gestion et finance'),
(212011, 0, 0, 210, 212, 'TSTMG', '2123101811.', 'Terminale STMG mercatique (marketing)'),
(212012, 0, 0, 210, 212, 'TSTMG', '2123101911.', 'Terminale STMG ressources humaines et communication'),
(212013, 0, 0, 210, 212, 'TSTMG', '2123102011.', 'Terminale STMG systèmes d''information de gestion'),
(212014, 0, 0, 210, 212, 'TST2S', '2123310411.', 'Terminale ST2S sc. & techno. santé & social'),
(212015, 0, 0, 210, 212, 'THOT', '2123340111.', 'Terminale technologique hôtellerie'),
(212016, 0, 0, 210, 212, 'TSTHR', '2123340211.', 'Terminale STHR'),
(213000, 0, 0, 210, 213, '1T', '213.....11.', 'Première technologique'),
(213001, 0, 0, 210, 213, '1STAV', '2132100411.', 'Première STAV agronomie, alimentation, environnement, territoires'),
(214000, 0, 0, 210, 214, 'TT', '214.....11.', 'Terminale technologique'),
(214001, 0, 0, 210, 214, 'TSTAV', '2142100411.', 'Terminale STAV agronomie, alimentation, environnement, territoires'),
(220000, 0, 1, 220, 220, '2BT', '220.....11.', 'Seconde BT'),
(220001, 0, 0, 220, 220, '2BT', '2202240611.', 'Seconde BT dessin.arts appliqués : cristallerie'),
(220002, 0, 0, 220, 220, '2BT', '2202240711.', 'Seconde BT dessin.arts appliqués : céramique'),
(220003, 0, 0, 220, 220, '2BT', '2202330411.', 'Seconde BT dessin.arts appliqués : volum.archi'),
(220004, 0, 0, 220, 220, '2BT', '2202410511.', 'Seconde BT dessin.arts appliqués : tapiss.lisse'),
(220005, 0, 0, 220, 220, '2BT', '2203230211.', 'Seconde BT métiers de la musique'),
(221000, 0, 1, 220, 221, '1BT', '221.....11.', 'Première BT'),
(221001, 0, 0, 220, 221, '1BT', '2212240611.', 'Première BT dessin.arts appliqués : cristallerie'),
(221002, 0, 0, 220, 221, '1BT', '2212240711.', 'Première BT dessin.arts appliqués : céramique'),
(221003, 0, 0, 220, 221, '1BT', '2212330411.', 'Première BT dessin.arts appliqués : volum.archi'),
(221004, 0, 0, 220, 221, '1BT', '2212410511.', 'Première BT dessin.arts appliqués : tapiss.lisse'),
(221005, 0, 0, 220, 221, '1BT', '2212421011.', 'Première BT tec.met.spec : technq.habillag(dip)'),
(221006, 0, 0, 220, 221, '1BT', '2213230211.', 'Première BT métiers de la musique'),
(221007, 0, 0, 220, 221, '1BT', '2213230511.', 'Première BT brevet artist.techn. cirque (dip)'),
(221008, 0, 0, 220, 221, '1BT', '2213230611.', 'Première BT tec.met.spec : machinist.const(dip)'),
(221009, 0, 0, 220, 221, '1BT', '2213310311.', 'Première BT podo-orthésiste (dip)'),
(221010, 0, 0, 220, 221, '1BT', '2213310411.', 'Première BT prothésiste-orthésiste (dip)'),
(222000, 0, 1, 220, 222, 'TBT', '222.....11.', 'Terminale BT'),
(222001, 0, 0, 220, 222, 'TBT', '2222240611.', 'Terminale BT dessin.arts appliqués : cristallerie'),
(222002, 0, 0, 220, 222, 'TBT', '2222240711.', 'Terminale BT dessin.arts appliqués : céramique'),
(222003, 0, 0, 220, 222, 'TBT', '2222330411.', 'Terminale BT dessin.arts appliqués : volum.archi'),
(222004, 0, 0, 220, 222, 'TBT', '2222410511.', 'Terminale BT dessin.arts appliqués : tapiss.lisse'),
(222005, 0, 0, 220, 222, 'TBT', '2222421011.', 'Terminale BT tec.met.spec : technq.habillag(dip)'),
(222006, 0, 0, 220, 222, 'TBT', '2223220711.', 'Terminale BT dessin.maquett.op_a : arts graphiq'),
(222007, 0, 0, 220, 222, 'TBT', '2223221011.', 'Terminale BT dessin.maquett.op_d : cartograph.'),
(222008, 0, 0, 220, 222, 'TBT', '2223230211.', 'Terminale BT métiers de la musique'),
(222009, 0, 0, 220, 222, 'TBT', '2223230511.', 'Terminale BT brevet artist.techn. cirque (dip)'),
(222010, 0, 0, 220, 222, 'TBT', '2223230611.', 'Terminale BT tec.met.spec : machinist.const(dip)'),
(222011, 0, 0, 220, 222, 'TBT', '2223310311.', 'Terminale BT podo-orthésiste (dip)'),
(222012, 0, 0, 220, 222, 'TBT', '2223310411.', 'Terminale BT prothésiste-orthésiste (dip)'),
(223000, 0, 0, 220, 223, '1BTA', '223.....11.', 'Première BTA'),
(224000, 0, 0, 220, 224, 'TBTA', '224.....11.', 'Terminale BTA'),
(231000, 0, 0, 220, 231, '1ADN', '231.....11.', 'Première d''adaptation BTN'),
(232000, 0, 0, 220, 232, '1AD', '232.....11.', 'Première d''adaptation BT'),
(232001, 0, 0, 220, 232, '1ADBT', '2322240611.', 'Première d''adaptation BT dessin.arts appliqués : cristallerie'),
(232002, 0, 0, 220, 232, '1ADBT', '2322240711.', 'Première d''adaptation BT dessin.arts appliqués : céramique'),
(232003, 0, 0, 220, 232, '1ADBT', '2322330411.', 'Première d''adaptation BT dessin.arts appliqués : volum.archi'),
(232004, 0, 0, 220, 232, '1ADBT', '2322410511.', 'Première d''adaptation BT dessin.arts appliqués : tapiss.lisse'),
(240000, 0, 1, 240, 240, '1CAP1', '240.....11.', 'CAP 1 an'),
(240001, 0, 0, 240, 240, '1CAP1', '2402010111.', '1CAP1 conduct. installations production'),
(240002, 0, 0, 240, 240, '1CAP1', '2402100211.', '1CAP1 développement : gest.pte expl.rural -tom'),
(240003, 0, 0, 240, 240, '1CAP1', '2402130311.', '1CAP1 développement : gest. milieu marin -tom'),
(240004, 0, 0, 240, 240, '1CAP1', '2402130511.', '1CAP1 mareyage'),
(240005, 0, 0, 240, 240, '1CAP1', '2402130611.', '1CAP1 maritime matelot'),
(240006, 0, 0, 240, 240, '1CAP1', '2402200211.', '1CAP1 employé technique de laboratoire'),
(240007, 0, 0, 240, 240, '1CAP1', '2402200411.', '1CAP1 opérateur industries du recyclage'),
(240008, 0, 0, 240, 240, '1CAP1', '2402200511.', '1CAP1 propreté de l''environnement urbain - collecte et recyclage'),
(240009, 0, 0, 240, 240, '1CAP1', '2402212911.', '1CAP1 agent polyvalent de restauration'),
(240010, 0, 0, 240, 240, '1CAP1', '2402213011.', '1CAP1 charcutier-traiteur'),
(240011, 0, 0, 240, 240, '1CAP1', '2402213911.', '1CAP1 cuisine'),
(240012, 0, 0, 240, 240, '1CAP1', '2402213311.', '1CAP1 chocolatier confiseur'),
(240013, 0, 0, 240, 240, '1CAP1', '2402213511.', '1CAP1 boucher'),
(240014, 0, 0, 240, 240, '1CAP1', '2402213611.', '1CAP1 pâtissier'),
(240015, 0, 0, 240, 240, '1CAP1', '2402213711.', '1CAP1 boulanger'),
(240016, 0, 0, 240, 240, '1CAP1', '2402213811.', '1CAP1 glacier-fabricant'),
(240017, 0, 0, 240, 240, '1CAP1', '2402220111.', '1CAP1 industries chimiques'),
(240018, 0, 0, 240, 240, '1CAP1', '2402232411.', '1CAP1 mouleur noyauteur : cuivre bronze'),
(240019, 0, 0, 240, 240, '1CAP1', '2402233211.', '1CAP1 doreur à la feuille ornemaniste'),
(240020, 0, 0, 240, 240, '1CAP1', '2402233911.', '1CAP1 lapidaire op_a : diamant'),
(240021, 0, 0, 240, 240, '1CAP1', '2402234011.', '1CAP1 orfèvre op_a : monteur orfèvrerie'),
(240022, 0, 0, 240, 240, '1CAP1', '2402234111.', '1CAP1 orfèvre op_b : tourn.repousseur'),
(240023, 0, 0, 240, 240, '1CAP1', '2402234211.', '1CAP1 orfèvre op_c : polisseur aviveur'),
(240024, 0, 0, 240, 240, '1CAP1', '2402234311.', '1CAP1 lapidaire op_b : pierres de coul.'),
(240025, 0, 0, 240, 240, '1CAP1', '2402234911.', '1CAP1 bronzier op_a : monteur en bronze'),
(240026, 0, 0, 240, 240, '1CAP1', '2402235011.', '1CAP1 bronzier op_b : ciseleur sur bronze'),
(240027, 0, 0, 240, 240, '1CAP1', '2402235111.', '1CAP1 bronzier op_c : tourneur sur bronze'),
(240028, 0, 0, 240, 240, '1CAP1', '2402235311.', '1CAP1 émailleur d''art sur metaux'),
(240029, 0, 0, 240, 240, '1CAP1', '2402235411.', '1CAP1 orfèvre op_d : planeur en orfèvre'),
(240030, 0, 0, 240, 240, '1CAP1', '2402235611.', '1CAP1 facteur d''orgues'),
(240031, 0, 0, 240, 240, '1CAP1', '2402236011.', '1CAP1 métiers de la fonderie'),
(240032, 0, 0, 240, 240, '1CAP1', '2402236111.', '1CAP1 art tec. bij. joaill.op.bij.joail'),
(240033, 0, 0, 240, 240, '1CAP1', '2402236211.', '1CAP1 art tec bij.joaill.op.bij.sertis.'),
(240034, 0, 0, 240, 240, '1CAP1', '2402236311.', '1CAP1 art tec bij.joaill.op.polis.fini.'),
(240035, 0, 0, 240, 240, '1CAP1', '2402240611.', '1CAP1 maint.indust.materx de construct.'),
(240036, 0, 0, 240, 240, '1CAP1', '2402241911.', '1CAP1 fabric.industriel.des céramiques'),
(240037, 0, 0, 240, 240, '1CAP1', '2402242011.', '1CAP1 modèles et moules céramiques'),
(240038, 0, 0, 240, 240, '1CAP1', '2402242111.', '1CAP1 tournage en céramique'),
(240039, 0, 0, 240, 240, '1CAP1', '2402242211.', '1CAP1 décoration en céramique'),
(240040, 0, 0, 240, 240, '1CAP1', '2402242511.', '1CAP1 arts & tech.verre : vitrailliste'),
(240041, 0, 0, 240, 240, '1CAP1', '2402242711.', '1CAP1 arts & tech.verre : décorateur'),
(240042, 0, 0, 240, 240, '1CAP1', '2402242811.', '1CAP1 arts du verre et du cristal'),
(240043, 0, 0, 240, 240, '1CAP1', '2402242911.', '1CAP1 souffleur verre : ens.lumineuse'),
(240044, 0, 0, 240, 240, '1CAP1', '2402243011.', '1CAP1 souffl.verre : verrerie scient.'),
(240045, 0, 0, 240, 240, '1CAP1', '2402250511.', '1CAP1 mise en oeuv.caoutchoucs & elasto'),
(240046, 0, 0, 240, 240, '1CAP1', '2402250911.', '1CAP1 plasturgie'),
(240047, 0, 0, 240, 240, '1CAP1', '2402251011.', '1CAP1 composit.plastiq.chaudronnes'),
(240048, 0, 0, 240, 240, '1CAP1', '2402260911.', '1CAP1 scieries op_b : affuteur sciage'),
(240049, 0, 0, 240, 240, '1CAP1', '2402270611.', '1CAP1 froid et climatisation'),
(240050, 0, 0, 240, 240, '1CAP1', '2402271311.', '1CAP1 installateur thermique'),
(240051, 0, 0, 240, 240, '1CAP1', '2402271411.', '1CAP1 installateur en froid et conditionnement d''air'),
(240052, 0, 0, 240, 240, '1CAP1', '2402300211.', '1CAP1 maintenance bâtiments de collect.'),
(240053, 0, 0, 240, 240, '1CAP1', '2402300511.', '1CAP1 monteur structures mobiles'),
(240054, 0, 0, 240, 240, '1CAP1', '2402311511.', '1CAP1 constructeur de routes'),
(240055, 0, 0, 240, 240, '1CAP1', '2402311611.', '1CAP1 constructeur canalalisations t.p.'),
(240056, 0, 0, 240, 240, '1CAP1', '2402311711.', '1CAP1 constructeur en ouvrages d''art'),
(240057, 0, 0, 240, 240, '1CAP1', '2402311811.', '1CAP1 conduct engins tvx pub. carrières'),
(240058, 0, 0, 240, 240, '1CAP1', '2402320411.', '1CAP1 graveur sur pierre'),
(240059, 0, 0, 240, 240, '1CAP1', '2402321211.', '1CAP1 développement : const.entret.batimt -tom'),
(240060, 0, 0, 240, 240, '1CAP1', '2402321711.', '1CAP1 maçon'),
(240061, 0, 0, 240, 240, '1CAP1', '2402321811.', '1CAP1 couvreur'),
(240062, 0, 0, 240, 240, '1CAP1', '2402321911.', '1CAP1 constructeur béton armé bâtiment'),
(240063, 0, 0, 240, 240, '1CAP1', '2402322011.', '1CAP1 tailleur de pierre'),
(240064, 0, 0, 240, 240, '1CAP1', '2402322111.', '1CAP1 marbrier du bâtiment et de la décoration'),
(240065, 0, 0, 240, 240, '1CAP1', '2402330211.', '1CAP1 monteur en isol.thermiq & acoust.'),
(240066, 0, 0, 240, 240, '1CAP1', '2402331111.', '1CAP1 staffeur ornemaniste'),
(240067, 0, 0, 240, 240, '1CAP1', '2402331711.', '1CAP1 installateur sanitaire'),
(240068, 0, 0, 240, 240, '1CAP1', '2402331811.', '1CAP1 carreleur mosaïste'),
(240069, 0, 0, 240, 240, '1CAP1', '2402331911.', '1CAP1 peintre-applicateur de revêtement'),
(240070, 0, 0, 240, 240, '1CAP1', '2402332011.', '1CAP1 solier-moquettiste'),
(240071, 0, 0, 240, 240, '1CAP1', '2402332111.', '1CAP1 étancheur bâtiment travaux public'),
(240072, 0, 0, 240, 240, '1CAP1', '2402332211.', '1CAP1 menuisier aluminium-verre'),
(240073, 0, 0, 240, 240, '1CAP1', '2402332311.', '1CAP1 plâtrier-plaquiste'),
(240074, 0, 0, 240, 240, '1CAP1', '2402341111.', '1CAP1 menuisier en sièges'),
(240075, 0, 0, 240, 240, '1CAP1', '2402342011.', '1CAP1 cannage et paillage ameublement'),
(240076, 0, 0, 240, 240, '1CAP1', '2402342711.', '1CAP1 ouvrier archetier'),
(240077, 0, 0, 240, 240, '1CAP1', '2402342811.', '1CAP1 lutherie'),
(240078, 0, 0, 240, 240, '1CAP1', '2402343011.', '1CAP1 arts bois op_a : sculpteur ornema.'),
(240079, 0, 0, 240, 240, '1CAP1', '2402343111.', '1CAP1 arts bois op_b : tourneur'),
(240080, 0, 0, 240, 240, '1CAP1', '2402343211.', '1CAP1 arts bois op_c : marqueteur'),
(240081, 0, 0, 240, 240, '1CAP1', '2402343311.', '1CAP1 encadreur'),
(240082, 0, 0, 240, 240, '1CAP1', '2402343511.', '1CAP1 tonnellerie'),
(240083, 0, 0, 240, 240, '1CAP1', '2402343711.', '1CAP1 ébéniste'),
(240084, 0, 0, 240, 240, '1CAP1', '2402343811.', '1CAP1 vannerie'),
(240085, 0, 0, 240, 240, '1CAP1', '2402343911.', '1CAP1 charpentier bois'),
(240086, 0, 0, 240, 240, '1CAP1', '2402344011.', '1CAP1 constructeur bois'),
(240087, 0, 0, 240, 240, '1CAP1', '2402344111.', '1CAP1 menuisier fabrict men mob agencmt'),
(240088, 0, 0, 240, 240, '1CAP1', '2402344211.', '1CAP1 menuisier installateur'),
(240089, 0, 0, 240, 240, '1CAP1', '2402344311.', '1CAP1 conducteur-opérateur de scierie'),
(240090, 0, 0, 240, 240, '1CAP1', '2402344411.', '1CAP1 charpentier de marine'),
(240091, 0, 0, 240, 240, '1CAP1', '2402400511.', '1CAP1 métier du pressing'),
(240092, 0, 0, 240, 240, '1CAP1', '2402400611.', '1CAP1 métiers de la blanchisserie'),
(240093, 0, 0, 240, 240, '1CAP1', '2402412511.', '1CAP1 rentrayeur op_a : tapis'),
(240094, 0, 0, 240, 240, '1CAP1', '2402412611.', '1CAP1 rentrayeur op_b : tapisseries'),
(240095, 0, 0, 240, 240, '1CAP1', '2402412711.', '1CAP1 arts de la broderie'),
(240096, 0, 0, 240, 240, '1CAP1', '2402413011.', '1CAP1 arts de la dentelle opt.fuseaux'),
(240097, 0, 0, 240, 240, '1CAP1', '2402413111.', '1CAP1 arts de la dentelle opt.aiguille'),
(240098, 0, 0, 240, 240, '1CAP1', '2402423111.', '1CAP1 arts du tapis et tapiss.de lisse'),
(240099, 0, 0, 240, 240, '1CAP1', '2402423811.', '1CAP1 tapissier-e ameublement en siège'),
(240100, 0, 0, 240, 240, '1CAP1', '2402423911.', '1CAP1 tapissier-e ameublement en décor'),
(240101, 0, 0, 240, 240, '1CAP1', '2402424011.', '1CAP1 métiers de la mode-vêtement flou'),
(240102, 0, 0, 240, 240, '1CAP1', '2402424111.', '1CAP1 métiers de la mode- vêt. tailleur'),
(240103, 0, 0, 240, 240, '1CAP1', '2402424211.', '1CAP1 métiers mode chapelier-modiste'),
(240104, 0, 0, 240, 240, '1CAP1', '2402431311.', '1CAP1 cordonnier bottier'),
(240105, 0, 0, 240, 240, '1CAP1', '2402431511.', '1CAP1 fourrure'),
(240106, 0, 0, 240, 240, '1CAP1', '2402431611.', '1CAP1 chaussure'),
(240107, 0, 0, 240, 240, '1CAP1', '2402431711.', '1CAP1 maroquinerie'),
(240108, 0, 0, 240, 240, '1CAP1', '2402431811.', '1CAP1 sellerie générale'),
(240109, 0, 0, 240, 240, '1CAP1', '2402431911.', '1CAP1 vêtement de peau'),
(240110, 0, 0, 240, 240, '1CAP1', '2402432011.', '1CAP1 cordonnerie multiservice'),
(240111, 0, 0, 240, 240, '1CAP1', '2402432111.', '1CAP1 sellier harnacheur'),
(240112, 0, 0, 240, 240, '1CAP1', '2402500111.', '1CAP1 certif.aptitude au developt -tom'),
(240113, 0, 0, 240, 240, '1CAP1', '2402510811.', '1CAP1 instrumts coupants & de chirurgie'),
(240114, 0, 0, 240, 240, '1CAP1', '2402512311.', '1CAP1 décolletage : opérateur regleur'),
(240115, 0, 0, 240, 240, '1CAP1', '2402512611.', '1CAP1 outillages a decouper et emboutir'),
(240116, 0, 0, 240, 240, '1CAP1', '2402513011.', '1CAP1 développement : fabric.entret.meca. -tom'),
(240117, 0, 0, 240, 240, '1CAP1', '2402513311.', '1CAP1 agent verif. appar. extincteurs'),
(240118, 0, 0, 240, 240, '1CAP1', '2402513411.', '1CAP1 transport câbles-remontées meca.'),
(240119, 0, 0, 240, 240, '1CAP1', '2402513611.', '1CAP1 armurerie (fabricat. et réparat.)'),
(240120, 0, 0, 240, 240, '1CAP1', '2402513711.', '1CAP1 horloger'),
(240121, 0, 0, 240, 240, '1CAP1', '2402522111.', '1CAP1 maintenance des matériels option A matériels agricoles'),
(240122, 0, 0, 240, 240, '1CAP1', '2402522211.', '1CAP1 maintenance des matériels option B matériels TP et manutention'),
(240123, 0, 0, 240, 240, '1CAP1', '2402522311.', '1CAP1 maintenance des matériels option C matériels d''espaces verts'),
(240124, 0, 0, 240, 240, '1CAP1', '2402521711.', '1CAP1 repar.entr.embarcations plaisance'),
(240125, 0, 0, 240, 240, '1CAP1', '2402521811.', '1CAP1 maintenance des véhicules option A voitures particulières'),
(240126, 0, 0, 240, 240, '1CAP1', '2402521911.', '1CAP1 maintenance des véhicules option B véhicules de transport routier'),
(240127, 0, 0, 240, 240, '1CAP1', '2402522011.', '1CAP1 maintenance des véhicules option C motocycles'),
(240128, 0, 0, 240, 240, '1CAP1', '2402530511.', '1CAP1 aéronautique option avionique'),
(240129, 0, 0, 240, 240, '1CAP1', '2402530611.', '1CAP1 aéronautique option systèmes'),
(240130, 0, 0, 240, 240, '1CAP1', '2402530711.', '1CAP1 aéronautique option structures'),
(240131, 0, 0, 240, 240, '1CAP1', '2402542111.', '1CAP1 mise en forme des matériaux'),
(240132, 0, 0, 240, 240, '1CAP1', '2402542311.', '1CAP1 ferronnier'),
(240133, 0, 0, 240, 240, '1CAP1', '2402542511.', '1CAP1 outillage en moules métallique'),
(240134, 0, 0, 240, 240, '1CAP1', '2402542711.', '1CAP1 tuyautier en orgues'),
(240135, 0, 0, 240, 240, '1CAP1', '2402543111.', '1CAP1 serrurier métallier'),
(240136, 0, 0, 240, 240, '1CAP1', '2402543211.', '1CAP1 construction des carrosseries'),
(240137, 0, 0, 240, 240, '1CAP1', '2402543311.', '1CAP1 peinture en carrosserie'),
(240138, 0, 0, 240, 240, '1CAP1', '2402543411.', '1CAP1 réparation des carrosseries'),
(240139, 0, 0, 240, 240, '1CAP1', '2402543511.', '1CAP1 réalisat. en chaudronnerie indus.'),
(240140, 0, 0, 240, 240, '1CAP1', '2402543611.', '1CAP1 ferronnier d''art'),
(240141, 0, 0, 240, 240, '1CAP1', '2402552111.', '1CAP1 métiers enseigne signalétique'),
(240142, 0, 0, 240, 240, '1CAP1', '2402552311.', '1CAP1 prep.& real. ouvrages électriques'),
(240143, 0, 0, 240, 240, '1CAP1', '2403110711.', '1CAP1 emballeur professionnel'),
(240144, 0, 0, 240, 240, '1CAP1', '2403111411.', '1CAP1 agt accueil condte rout.tr.voyag.'),
(240145, 0, 0, 240, 240, '1CAP1', '2403111611.', '1CAP1 agent entreposage et messagerie'),
(240146, 0, 0, 240, 240, '1CAP1', '2403111711.', '1CAP1 conducteur routier marchandises'),
(240147, 0, 0, 240, 240, '1CAP1', '2403111811.', '1CAP1 conducteur livreur marchandises'),
(240148, 0, 0, 240, 240, '1CAP1', '2403111911.', '1CAP1 déménageur véhic.utilitaire léger'),
(240149, 0, 0, 240, 240, '1CAP1', '2403112011.', '1CAP1 distribution objets serv.clientel'),
(240150, 0, 0, 240, 240, '1CAP1', '2403112111.', '1CAP1 transport fluvial'),
(240151, 0, 0, 240, 240, '1CAP1', '2403112211.', '1CAP1 opérateur/opératrice logistique'),
(240152, 0, 0, 240, 240, '1CAP1', '2403121411.', '1CAP1 employé commerce multispécialités'),
(240153, 0, 0, 240, 240, '1CAP1', '2403121511.', '1CAP1 employ.vente : prdts alimentaires'),
(240154, 0, 0, 240, 240, '1CAP1', '2403121611.', '1CAP1 empl.vente : prdts équip.courant'),
(240155, 0, 0, 240, 240, '1CAP1', '2403121711.', '1CAP1 vendeur-magasinier pièces auto'),
(240156, 0, 0, 240, 240, '1CAP1', '2403121811.', '1CAP1 fleuriste'),
(240157, 0, 0, 240, 240, '1CAP1', '2403121911.', '1CAP1 empl.vente sp. : servic.clientèle'),
(240158, 0, 0, 240, 240, '1CAP1', '2403122011.', '1CAP1 empl.vent.sp.librair.papet.presse'),
(240159, 0, 0, 240, 240, '1CAP1', '2403122111.', '1CAP1 poissonnier'),
(240160, 0, 0, 240, 240, '1CAP1', '2403221711.', '1CAP1 arts de la reliure'),
(240161, 0, 0, 240, 240, '1CAP1', '2403222011.', '1CAP1 métiers de la gravure : ornement.'),
(240162, 0, 0, 240, 240, '1CAP1', '2403222111.', '1CAP1 métiers de la gravure : impress.'),
(240163, 0, 0, 240, 240, '1CAP1', '2403222211.', '1CAP1 métiers de la gravure : modèle'),
(240164, 0, 0, 240, 240, '1CAP1', '2403222311.', '1CAP1 met.gravure : marquage poinçonnage'),
(240165, 0, 0, 240, 240, '1CAP1', '2403222511.', '1CAP1 sérigraphie industrielle'),
(240166, 0, 0, 240, 240, '1CAP1', '2403222611.', '1CAP1 signalétique enseigne et décor'),
(240167, 0, 0, 240, 240, '1CAP1', '2403230611.', '1CAP1 monteur en chapiteaux'),
(240168, 0, 0, 240, 240, '1CAP1', '2403230711.', '1CAP1 accessoiriste réalisateur'),
(240169, 0, 0, 240, 240, '1CAP1', '2403230811.', '1CAP1 accordeur de pianos'),
(240170, 0, 0, 240, 240, '1CAP1', '2403231011.', '1CAP1 ass.tech.instr.musiq. : accordéon'),
(240171, 0, 0, 240, 240, '1CAP1', '2403231111.', '1CAP1 ass.tech.instr.musiq. instr.vent'),
(240172, 0, 0, 240, 240, '1CAP1', '2403231211.', '1CAP1 ass.tech.instr.musiq. : piano'),
(240173, 0, 0, 240, 240, '1CAP1', '2403231311.', '1CAP1 ass.tech.instr.musiq. : guitare'),
(240174, 0, 0, 240, 240, '1CAP1', '2403231411.', '1CAP1 opérateur projectionniste cinéma'),
(240175, 0, 0, 240, 240, '1CAP1', '2403310611.', '1CAP1 ortho-prothésiste'),
(240176, 0, 0, 240, 240, '1CAP1', '2403310711.', '1CAP1 podo-orthésiste'),
(240177, 0, 0, 240, 240, '1CAP1', '2403320111.', '1CAP1 développement : act.famil.artis.tour. -tom'),
(240178, 0, 0, 240, 240, '1CAP1', '2403320211.', '1CAP1 petite enfance'),
(240179, 0, 0, 240, 240, '1CAP1', '2403340811.', '1CAP1 services hôteliers'),
(240180, 0, 0, 240, 240, '1CAP1', '2403340911.', '1CAP1 restaurant'),
(240181, 0, 0, 240, 240, '1CAP1', '2403341011.', '1CAP1 services en brasserie-café'),
(240182, 0, 0, 240, 240, '1CAP1', '2403341111.', '1CAP1 ass. tech. milieux famil.collect.'),
(240183, 0, 0, 240, 240, '1CAP1', '2403350111.', '1CAP1 métiers du football'),
(240184, 0, 0, 240, 240, '1CAP1', '2403360311.', '1CAP1 taxidermiste'),
(240185, 0, 0, 240, 240, '1CAP1', '2403361011.', '1CAP1 coiffure'),
(240186, 0, 0, 240, 240, '1CAP1', '2403361111.', '1CAP1 esthétique cosmétique parfumerie'),
(240187, 0, 0, 240, 240, '1CAP1', '2403400211.', '1CAP1 agt prévention médiation'),
(240188, 0, 0, 240, 240, '1CAP1', '2403430111.', '1CAP1 agent de la qualité de l''eau'),
(240189, 0, 0, 240, 240, '1CAP1', '2403430311.', '1CAP1 assainismt collect.déchets liquid'),
(240190, 0, 0, 240, 240, '1CAP1', '2403430511.', '1CAP1 gestion déchets propreté urbaine'),
(240191, 0, 0, 240, 240, '1CAP1', '2403430711.', '1CAP1 agent de propreté et d''hygiène'),
(240192, 0, 0, 240, 240, '1CAP1', '2403440411.', '1CAP1 gardien d''immeuble'),
(240193, 0, 0, 240, 240, '1CAP1', '2403440511.', '1CAP1 agent de sécurité'),
(241001, 0, 1, 241, 241, '1CAP2', '241.....21.', 'CAP 2 ans, 1e année'),
(241002, 0, 1, 241, 241, '2CAP2', '241.....22.', 'CAP 2 ans, 2e année'),
(241003, 0, 0, 241, 241, '1CAP2', '2412010121.', '1CAP2 conduct. installations production'),
(241004, 0, 0, 241, 241, '2CAP2', '2412010122.', '2CAP2 conduct. installations production'),
(241005, 0, 0, 241, 241, '1CAP2', '2412100221.', '1CAP2 développement : gest.pte expl.rural -tom'),
(241006, 0, 0, 241, 241, '2CAP2', '2412100222.', '2CAP2 développement : gest.pte expl.rural -tom'),
(241007, 0, 0, 241, 241, '1CAP2', '2412130321.', '1CAP2 développement : gest. milieu marin -tom'),
(241008, 0, 0, 241, 241, '2CAP2', '2412130322.', '2CAP2 développement : gest. milieu marin -tom'),
(241009, 0, 0, 241, 241, '1CAP2', '2412130521.', '1CAP2 mareyage'),
(241010, 0, 0, 241, 241, '2CAP2', '2412130522.', '2CAP2 mareyage'),
(241011, 0, 0, 241, 241, '1CAP2', '2412130621.', '1CAP2 maritime matelot'),
(241012, 0, 0, 241, 241, '2CAP2', '2412130622.', '2CAP2 maritime matelot'),
(241013, 0, 0, 241, 241, '1CAP2', '2412200221.', '1CAP2 employé technique de laboratoire'),
(241014, 0, 0, 241, 241, '2CAP2', '2412200222.', '2CAP2 employé technique de laboratoire'),
(241015, 0, 0, 241, 241, '2CAP2', '2412200422.', '2CAP2 opérateur industries du recyclage'),
(241016, 0, 0, 241, 241, '1CAP2', '2412200521.', '1CAP2 propreté de l''environnement urbain - collecte et recyclage'),
(241017, 0, 0, 241, 241, '2CAP2', '2412200522.', '2CAP2 propreté de l''environnement urbain - collecte et recyclage'),
(241018, 0, 0, 241, 241, '1CAP2', '2412212921.', '1CAP2 agent polyvalent de restauration'),
(241019, 0, 0, 241, 241, '2CAP2', '2412212922.', '2CAP2 agent polyvalent de restauration'),
(241020, 0, 0, 241, 241, '1CAP2', '2412213021.', '1CAP2 charcutier-traiteur'),
(241021, 0, 0, 241, 241, '2CAP2', '2412213022.', '2CAP2 charcutier-traiteur'),
(241022, 0, 0, 241, 241, '1CAP2', '2412213921.', '1CAP2 cuisine'),
(241023, 0, 0, 241, 241, '2CAP2', '2412213922.', '2CAP2 cuisine'),
(241024, 0, 0, 241, 241, '1CAP2', '2412213321.', '1CAP2 chocolatier confiseur'),
(241025, 0, 0, 241, 241, '2CAP2', '2412213322.', '2CAP2 chocolatier confiseur'),
(241026, 0, 0, 241, 241, '1CAP2', '2412213521.', '1CAP2 boucher'),
(241027, 0, 0, 241, 241, '2CAP2', '2412213522.', '2CAP2 boucher'),
(241028, 0, 0, 241, 241, '1CAP2', '2412213621.', '1CAP2 pâtissier'),
(241029, 0, 0, 241, 241, '2CAP2', '2412213622.', '2CAP2 pâtissier'),
(241030, 0, 0, 241, 241, '1CAP2', '2412213721.', '1CAP2 boulanger'),
(241031, 0, 0, 241, 241, '2CAP2', '2412213722.', '2CAP2 boulanger'),
(241032, 0, 0, 241, 241, '1CAP2', '2412213821.', '1CAP2 glacier-fabricant'),
(241033, 0, 0, 241, 241, '2CAP2', '2412213822.', '2CAP2 glacier-fabricant'),
(241034, 0, 0, 241, 241, '1CAP2', '2412220121.', '1CAP2 industries chimiques'),
(241035, 0, 0, 241, 241, '2CAP2', '2412220122.', '2CAP2 industries chimiques'),
(241036, 0, 0, 241, 241, '1CAP2', '2412232421.', '1CAP2 mouleur noyauteur : cuivre bronze'),
(241037, 0, 0, 241, 241, '2CAP2', '2412232422.', '2CAP2 mouleur noyauteur : cuivre bronze'),
(241038, 0, 0, 241, 241, '1CAP2', '2412233221.', '1CAP2 doreur à la feuille ornemaniste'),
(241039, 0, 0, 241, 241, '2CAP2', '2412233222.', '2CAP2 doreur à la feuille ornemaniste'),
(241040, 0, 0, 241, 241, '1CAP2', '2412233921.', '1CAP2 lapidaire op_a : diamant'),
(241041, 0, 0, 241, 241, '2CAP2', '2412233922.', '2CAP2 lapidaire op_a : diamant'),
(241042, 0, 0, 241, 241, '1CAP2', '2412234021.', '1CAP2 orfèvre op_a : monteur orfèvrerie'),
(241043, 0, 0, 241, 241, '2CAP2', '2412234022.', '2CAP2 orfèvre op_a : monteur orfèvrerie'),
(241044, 0, 0, 241, 241, '1CAP2', '2412234121.', '1CAP2 orfèvre op_b : tourn.repousseur'),
(241045, 0, 0, 241, 241, '2CAP2', '2412234122.', '2CAP2 orfèvre op_b : tourn.repousseur'),
(241046, 0, 0, 241, 241, '1CAP2', '2412234221.', '1CAP2 orfèvre op_c : polisseur aviveur'),
(241047, 0, 0, 241, 241, '2CAP2', '2412234222.', '2CAP2 orfèvre op_c : polisseur aviveur'),
(241048, 0, 0, 241, 241, '1CAP2', '2412234321.', '1CAP2 lapidaire op_b : pierres de coul.'),
(241049, 0, 0, 241, 241, '2CAP2', '2412234322.', '2CAP2 lapidaire op_b : pierres de coul.'),
(241050, 0, 0, 241, 241, '1CAP2', '2412234921.', '1CAP2 bronzier op_a : monteur en bronze'),
(241051, 0, 0, 241, 241, '2CAP2', '2412234922.', '2CAP2 bronzier op_a : monteur en bronze'),
(241052, 0, 0, 241, 241, '1CAP2', '2412235021.', '1CAP2 bronzier op_b : ciseleur sur bronze'),
(241053, 0, 0, 241, 241, '2CAP2', '2412235022.', '2CAP2 bronzier op_b : ciseleur sur bronze'),
(241054, 0, 0, 241, 241, '1CAP2', '2412235121.', '1CAP2 bronzier op_c : tourneur sur bronze'),
(241055, 0, 0, 241, 241, '2CAP2', '2412235122.', '2CAP2 bronzier op_c : tourneur sur bronze'),
(241056, 0, 0, 241, 241, '1CAP2', '2412235321.', '1CAP2 émailleur d''art sur metaux'),
(241057, 0, 0, 241, 241, '2CAP2', '2412235322.', '2CAP2 émailleur d''art sur metaux'),
(241058, 0, 0, 241, 241, '1CAP2', '2412235421.', '1CAP2 orfèvre op_d : planeur en orfèvre'),
(241059, 0, 0, 241, 241, '2CAP2', '2412235422.', '2CAP2 orfèvre op_d : planeur en orfèvre'),
(241060, 0, 0, 241, 241, '2CAP2', '2412235622.', '2CAP2 facteur d''orgues'),
(241061, 0, 0, 241, 241, '1CAP2', '2412236021.', '1CAP2 métiers de la fonderie'),
(241062, 0, 0, 241, 241, '2CAP2', '2412236022.', '2CAP2 métiers de la fonderie'),
(241063, 0, 0, 241, 241, '1CAP2', '2412236121.', '1CAP2 art tec. bij. joaill.op.bij.joail'),
(241064, 0, 0, 241, 241, '2CAP2', '2412236122.', '2CAP2 art tec. bij. joaill.op.bij.joail'),
(241065, 0, 0, 241, 241, '1CAP2', '2412236221.', '1CAP2 art tec bij.joaill.op.bij.sertis.'),
(241066, 0, 0, 241, 241, '2CAP2', '2412236222.', '2CAP2 art tec bij.joaill.op.bij.sertis.'),
(241067, 0, 0, 241, 241, '1CAP2', '2412236321.', '1CAP2 art tec bij.joaill.op.polis.fini.'),
(241068, 0, 0, 241, 241, '2CAP2', '2412236322.', '2CAP2 art tec bij.joaill.op.polis.fini.'),
(241069, 0, 0, 241, 241, '1CAP2', '2412240621.', '1CAP2 maint.indust.materx de construct.'),
(241070, 0, 0, 241, 241, '2CAP2', '2412240622.', '2CAP2 maint.indust.materx de construct.'),
(241071, 0, 0, 241, 241, '1CAP2', '2412241921.', '1CAP2 fabric.industriel.des céramiques'),
(241072, 0, 0, 241, 241, '2CAP2', '2412241922.', '2CAP2 fabric.industriel.des céramiques'),
(241073, 0, 0, 241, 241, '1CAP2', '2412242021.', '1CAP2 modèles et moules céramiques'),
(241074, 0, 0, 241, 241, '2CAP2', '2412242022.', '2CAP2 modèles et moules céramiques'),
(241075, 0, 0, 241, 241, '1CAP2', '2412242121.', '1CAP2 tournage en céramique'),
(241076, 0, 0, 241, 241, '2CAP2', '2412242122.', '2CAP2 tournage en céramique'),
(241077, 0, 0, 241, 241, '1CAP2', '2412242221.', '1CAP2 décoration en céramique'),
(241078, 0, 0, 241, 241, '2CAP2', '2412242222.', '2CAP2 décoration en céramique'),
(241079, 0, 0, 241, 241, '1CAP2', '2412242521.', '1CAP2 arts & tech.verre : vitrailliste'),
(241080, 0, 0, 241, 241, '2CAP2', '2412242522.', '2CAP2 arts & tech.verre : vitrailliste'),
(241081, 0, 0, 241, 241, '1CAP2', '2412242721.', '1CAP2 arts & tech.verre : décorateur'),
(241082, 0, 0, 241, 241, '2CAP2', '2412242722.', '2CAP2 arts & tech.verre : décorateur'),
(241083, 0, 0, 241, 241, '1CAP2', '2412242821.', '1CAP2 arts du verre et du cristal'),
(241084, 0, 0, 241, 241, '2CAP2', '2412242822.', '2CAP2 arts du verre et du cristal'),
(241085, 0, 0, 241, 241, '1CAP2', '2412242921.', '1CAP2 souffleur verre : ens.lumineuse'),
(241086, 0, 0, 241, 241, '2CAP2', '2412242922.', '2CAP2 souffleur verre : ens.lumineuse'),
(241087, 0, 0, 241, 241, '1CAP2', '2412243021.', '1CAP2 souffl.verre : verrerie scient.'),
(241088, 0, 0, 241, 241, '2CAP2', '2412243022.', '2CAP2 souffl.verre : verrerie scient.'),
(241089, 0, 0, 241, 241, '1CAP2', '2412250521.', '1CAP2 mise en oeuv.caoutchoucs & elasto'),
(241090, 0, 0, 241, 241, '2CAP2', '2412250522.', '2CAP2 mise en oeuv.caoutchoucs & elasto'),
(241091, 0, 0, 241, 241, '1CAP2', '2412250921.', '1CAP2 plasturgie'),
(241092, 0, 0, 241, 241, '2CAP2', '2412250922.', '2CAP2 plasturgie'),
(241093, 0, 0, 241, 241, '1CAP2', '2412251021.', '1CAP2 composit.plastiq.chaudronnes'),
(241094, 0, 0, 241, 241, '2CAP2', '2412251022.', '2CAP2 composit.plastiq.chaudronnes'),
(241095, 0, 0, 241, 241, '1CAP2', '2412260921.', '1CAP2 scieries op_b : affuteur sciage'),
(241096, 0, 0, 241, 241, '2CAP2', '2412260922.', '2CAP2 scieries op_b : affuteur sciage'),
(241097, 0, 0, 241, 241, '2CAP2', '2412270622.', '2CAP2 froid et climatisation'),
(241098, 0, 0, 241, 241, '1CAP2', '2412271321.', '1CAP2 installateur thermique'),
(241099, 0, 0, 241, 241, '2CAP2', '2412271322.', '2CAP2 installateur thermique'),
(241100, 0, 0, 241, 241, '1CAP2', '2412271421.', '1CAP2 installateur en froid et conditionnement d''air'),
(241101, 0, 0, 241, 241, '2CAP2', '2412271422.', '2CAP2 installateur en froid et conditionnement d''air'),
(241102, 0, 0, 241, 241, '1CAP2', '2412300221.', '1CAP2 maintenance bâtiments de collect.'),
(241103, 0, 0, 241, 241, '2CAP2', '2412300222.', '2CAP2 maintenance bâtiments de collect.'),
(241104, 0, 0, 241, 241, '1CAP2', '2412300521.', '1CAP2 monteur structures mobiles'),
(241105, 0, 0, 241, 241, '2CAP2', '2412300522.', '2CAP2 monteur structures mobiles'),
(241106, 0, 0, 241, 241, '1CAP2', '2412311521.', '1CAP2 constructeur de routes'),
(241107, 0, 0, 241, 241, '2CAP2', '2412311522.', '2CAP2 constructeur de routes'),
(241108, 0, 0, 241, 241, '1CAP2', '2412311621.', '1CAP2 constructeur canalalisations t.p.'),
(241109, 0, 0, 241, 241, '2CAP2', '2412311622.', '2CAP2 constructeur canalalisations t.p.'),
(241110, 0, 0, 241, 241, '1CAP2', '2412311721.', '1CAP2 constructeur en ouvrages d''art'),
(241111, 0, 0, 241, 241, '2CAP2', '2412311722.', '2CAP2 constructeur en ouvrages d''art'),
(241112, 0, 0, 241, 241, '1CAP2', '2412311821.', '1CAP2 conduct engins tvx pub. carrières'),
(241113, 0, 0, 241, 241, '2CAP2', '2412311822.', '2CAP2 conduct engins tvx pub. carrières'),
(241114, 0, 0, 241, 241, '2CAP2', '2412320422.', '2CAP2 graveur sur pierre'),
(241115, 0, 0, 241, 241, '1CAP2', '2412321221.', '1CAP2 développement : const.entret.batimt -tom'),
(241116, 0, 0, 241, 241, '2CAP2', '2412321222.', '2CAP2 développement : const.entret.batimt -tom'),
(241117, 0, 0, 241, 241, '1CAP2', '2412321721.', '1CAP2 maçon'),
(241118, 0, 0, 241, 241, '2CAP2', '2412321722.', '2CAP2 maçon'),
(241119, 0, 0, 241, 241, '1CAP2', '2412321821.', '1CAP2 couvreur'),
(241120, 0, 0, 241, 241, '2CAP2', '2412321822.', '2CAP2 couvreur'),
(241121, 0, 0, 241, 241, '1CAP2', '2412321921.', '1CAP2 constructeur béton armé bâtiment'),
(241122, 0, 0, 241, 241, '2CAP2', '2412321922.', '2CAP2 constructeur béton armé bâtiment'),
(241123, 0, 0, 241, 241, '1CAP2', '2412322021.', '1CAP2 tailleur de pierre'),
(241124, 0, 0, 241, 241, '2CAP2', '2412322022.', '2CAP2 tailleur de pierre'),
(241125, 0, 0, 241, 241, '1CAP2', '2412322121.', '1CAP2 marbrier du bâtiment et de la décoration'),
(241126, 0, 0, 241, 241, '2CAP2', '2412322122.', '2CAP2 marbrier du bâtiment et de la décoration'),
(241127, 0, 0, 241, 241, '1CAP2', '2412330221.', '1CAP2 monteur en isol.thermiq & acoust.'),
(241128, 0, 0, 241, 241, '2CAP2', '2412330222.', '2CAP2 monteur en isol.thermiq & acoust.'),
(241129, 0, 0, 241, 241, '1CAP2', '2412331121.', '1CAP2 staffeur ornemaniste'),
(241130, 0, 0, 241, 241, '2CAP2', '2412331122.', '2CAP2 staffeur ornemaniste'),
(241131, 0, 0, 241, 241, '1CAP2', '2412331721.', '1CAP2 installateur sanitaire'),
(241132, 0, 0, 241, 241, '2CAP2', '2412331722.', '2CAP2 installateur sanitaire'),
(241133, 0, 0, 241, 241, '1CAP2', '2412331821.', '1CAP2 carreleur mosaïste'),
(241134, 0, 0, 241, 241, '2CAP2', '2412331822.', '2CAP2 carreleur mosaïste'),
(241135, 0, 0, 241, 241, '1CAP2', '2412331921.', '1CAP2 peintre-applicateur de revêtement'),
(241136, 0, 0, 241, 241, '2CAP2', '2412331922.', '2CAP2 peintre-applicateur de revêtement'),
(241137, 0, 0, 241, 241, '1CAP2', '2412332021.', '1CAP2 solier-moquettiste'),
(241138, 0, 0, 241, 241, '2CAP2', '2412332022.', '2CAP2 solier-moquettiste'),
(241139, 0, 0, 241, 241, '1CAP2', '2412332121.', '1CAP2 étancheur bâtiment travaux public'),
(241140, 0, 0, 241, 241, '2CAP2', '2412332122.', '2CAP2 étancheur bâtiment travaux public'),
(241141, 0, 0, 241, 241, '1CAP2', '2412332221.', '1CAP2 menuisier aluminium-verre'),
(241142, 0, 0, 241, 241, '2CAP2', '2412332222.', '2CAP2 menuisier aluminium-verre'),
(241143, 0, 0, 241, 241, '1CAP2', '2412332321.', '1CAP2 plâtrier-plaquiste'),
(241144, 0, 0, 241, 241, '2CAP2', '2412332322.', '2CAP2 plâtrier-plaquiste'),
(241145, 0, 0, 241, 241, '1CAP2', '2412341121.', '1CAP2 menuisier en sièges'),
(241146, 0, 0, 241, 241, '2CAP2', '2412341122.', '2CAP2 menuisier en sièges'),
(241147, 0, 0, 241, 241, '1CAP2', '2412342021.', '1CAP2 cannage et paillage ameublement'),
(241148, 0, 0, 241, 241, '2CAP2', '2412342022.', '2CAP2 cannage et paillage ameublement'),
(241149, 0, 0, 241, 241, '1CAP2', '2412342721.', '1CAP2 ouvrier archetier'),
(241150, 0, 0, 241, 241, '2CAP2', '2412342722.', '2CAP2 ouvrier archetier'),
(241151, 0, 0, 241, 241, '1CAP2', '2412342821.', '1CAP2 lutherie'),
(241152, 0, 0, 241, 241, '2CAP2', '2412342822.', '2CAP2 lutherie'),
(241153, 0, 0, 241, 241, '1CAP2', '2412343021.', '1CAP2 arts bois op_a : sculpteur ornema.'),
(241154, 0, 0, 241, 241, '2CAP2', '2412343022.', '2CAP2 arts bois op_a : sculpteur ornema.'),
(241155, 0, 0, 241, 241, '1CAP2', '2412343121.', '1CAP2 arts bois op_b : tourneur'),
(241156, 0, 0, 241, 241, '2CAP2', '2412343122.', '2CAP2 arts bois op_b : tourneur'),
(241157, 0, 0, 241, 241, '1CAP2', '2412343221.', '1CAP2 arts bois op_c : marqueteur'),
(241158, 0, 0, 241, 241, '2CAP2', '2412343222.', '2CAP2 arts bois op_c : marqueteur'),
(241159, 0, 0, 241, 241, '1CAP2', '2412343321.', '1CAP2 encadreur'),
(241160, 0, 0, 241, 241, '2CAP2', '2412343322.', '2CAP2 encadreur'),
(241161, 0, 0, 241, 241, '1CAP2', '2412343521.', '1CAP2 tonnellerie'),
(241162, 0, 0, 241, 241, '2CAP2', '2412343522.', '2CAP2 tonnellerie'),
(241163, 0, 0, 241, 241, '1CAP2', '2412343721.', '1CAP2 ébéniste'),
(241164, 0, 0, 241, 241, '2CAP2', '2412343722.', '2CAP2 ébéniste'),
(241165, 0, 0, 241, 241, '1CAP2', '2412343821.', '1CAP2 vannerie'),
(241166, 0, 0, 241, 241, '2CAP2', '2412343822.', '2CAP2 vannerie'),
(241167, 0, 0, 241, 241, '1CAP2', '2412343921.', '1CAP2 charpentier bois'),
(241168, 0, 0, 241, 241, '2CAP2', '2412343922.', '2CAP2 charpentier bois'),
(241169, 0, 0, 241, 241, '1CAP2', '2412344021.', '1CAP2 constructeur bois'),
(241170, 0, 0, 241, 241, '2CAP2', '2412344022.', '2CAP2 constructeur bois'),
(241171, 0, 0, 241, 241, '1CAP2', '2412344121.', '1CAP2 menuisier fabrict men mob agencmt'),
(241172, 0, 0, 241, 241, '2CAP2', '2412344122.', '2CAP2 menuisier fabrict men mob agencmt'),
(241173, 0, 0, 241, 241, '1CAP2', '2412344221.', '1CAP2 menuisier installateur'),
(241174, 0, 0, 241, 241, '2CAP2', '2412344222.', '2CAP2 menuisier installateur'),
(241175, 0, 0, 241, 241, '1CAP2', '2412344321.', '1CAP2 conducteur-opérateur de scierie'),
(241176, 0, 0, 241, 241, '2CAP2', '2412344322.', '2CAP2 conducteur-opérateur de scierie'),
(241177, 0, 0, 241, 241, '1CAP2', '2412344421.', '1CAP2 charpentier de marine'),
(241178, 0, 0, 241, 241, '2CAP2', '2412344422.', '2CAP2 charpentier de marine'),
(241179, 0, 0, 241, 241, '1CAP2', '2412400521.', '1CAP2 métier du pressing'),
(241180, 0, 0, 241, 241, '2CAP2', '2412400522.', '2CAP2 métier du pressing'),
(241181, 0, 0, 241, 241, '1CAP2', '2412400621.', '1CAP2 métiers de la blanchisserie'),
(241182, 0, 0, 241, 241, '2CAP2', '2412400622.', '2CAP2 métiers de la blanchisserie'),
(241183, 0, 0, 241, 241, '1CAP2', '2412412521.', '1CAP2 rentrayeur op_a : tapis'),
(241184, 0, 0, 241, 241, '2CAP2', '2412412522.', '2CAP2 rentrayeur op_a : tapis'),
(241185, 0, 0, 241, 241, '1CAP2', '2412412621.', '1CAP2 rentrayeur op_b : tapisseries'),
(241186, 0, 0, 241, 241, '2CAP2', '2412412622.', '2CAP2 rentrayeur op_b : tapisseries'),
(241187, 0, 0, 241, 241, '1CAP2', '2412412721.', '1CAP2 arts de la broderie'),
(241188, 0, 0, 241, 241, '2CAP2', '2412412722.', '2CAP2 arts de la broderie'),
(241189, 0, 0, 241, 241, '1CAP2', '2412413021.', '1CAP2 arts de la dentelle opt.fuseaux'),
(241190, 0, 0, 241, 241, '2CAP2', '2412413022.', '2CAP2 arts de la dentelle opt.fuseaux'),
(241191, 0, 0, 241, 241, '1CAP2', '2412413121.', '1CAP2 arts de la dentelle opt.aiguille'),
(241192, 0, 0, 241, 241, '2CAP2', '2412413122.', '2CAP2 arts de la dentelle opt.aiguille'),
(241193, 0, 0, 241, 241, '1CAP2', '2412423121.', '1CAP2 arts du tapis et tapiss.de lisse'),
(241194, 0, 0, 241, 241, '2CAP2', '2412423122.', '2CAP2 arts du tapis et tapiss.de lisse'),
(241195, 0, 0, 241, 241, '1CAP2', '2412423821.', '1CAP2 tapissier-e ameublement en siège'),
(241196, 0, 0, 241, 241, '2CAP2', '2412423822.', '2CAP2 tapissier-e ameublement en siège'),
(241197, 0, 0, 241, 241, '1CAP2', '2412423921.', '1CAP2 tapissier-e ameublement en décor'),
(241198, 0, 0, 241, 241, '2CAP2', '2412423922.', '2CAP2 tapissier-e ameublement en décor'),
(241199, 0, 0, 241, 241, '1CAP2', '2412424021.', '1CAP2 métiers de la mode-vêtement flou'),
(241200, 0, 0, 241, 241, '2CAP2', '2412424022.', '2CAP2 métiers de la mode-vêtement flou'),
(241201, 0, 0, 241, 241, '1CAP2', '2412424121.', '1CAP2 métiers de la mode- vêt. tailleur'),
(241202, 0, 0, 241, 241, '2CAP2', '2412424122.', '2CAP2 métiers de la mode- vêt. tailleur'),
(241203, 0, 0, 241, 241, '1CAP2', '2412424221.', '1CAP2 métiers mode chapelier-modiste'),
(241204, 0, 0, 241, 241, '2CAP2', '2412424222.', '2CAP2 métiers mode chapelier-modiste'),
(241205, 0, 0, 241, 241, '1CAP2', '2412431321.', '1CAP2 cordonnier bottier'),
(241206, 0, 0, 241, 241, '2CAP2', '2412431322.', '2CAP2 cordonnier bottier'),
(241207, 0, 0, 241, 241, '1CAP2', '2412431521.', '1CAP2 fourrure'),
(241208, 0, 0, 241, 241, '2CAP2', '2412431522.', '2CAP2 fourrure'),
(241209, 0, 0, 241, 241, '1CAP2', '2412431621.', '1CAP2 chaussure'),
(241210, 0, 0, 241, 241, '2CAP2', '2412431622.', '2CAP2 chaussure'),
(241211, 0, 0, 241, 241, '1CAP2', '2412431721.', '1CAP2 maroquinerie'),
(241212, 0, 0, 241, 241, '2CAP2', '2412431722.', '2CAP2 maroquinerie'),
(241213, 0, 0, 241, 241, '1CAP2', '2412431821.', '1CAP2 sellerie générale'),
(241214, 0, 0, 241, 241, '2CAP2', '2412431822.', '2CAP2 sellerie générale'),
(241215, 0, 0, 241, 241, '1CAP2', '2412431921.', '1CAP2 vêtement de peau'),
(241216, 0, 0, 241, 241, '2CAP2', '2412431922.', '2CAP2 vêtement de peau'),
(241217, 0, 0, 241, 241, '1CAP2', '2412432021.', '1CAP2 cordonnerie multiservice'),
(241218, 0, 0, 241, 241, '2CAP2', '2412432022.', '2CAP2 cordonnerie multiservice'),
(241219, 0, 0, 241, 241, '1CAP2', '2412432121.', '1CAP2 sellier harnacheur'),
(241220, 0, 0, 241, 241, '2CAP2', '2412432122.', '2CAP2 sellier harnacheur'),
(241221, 0, 0, 241, 241, '1CAP2', '2412500121.', '1CAP2 certif.aptitude au developt -tom'),
(241222, 0, 0, 241, 241, '2CAP2', '2412500122.', '2CAP2 certif.aptitude au developt -tom'),
(241223, 0, 0, 241, 241, '1CAP2', '2412510821.', '1CAP2 instrumts coupants & de chirurgie'),
(241224, 0, 0, 241, 241, '2CAP2', '2412510822.', '2CAP2 instrumts coupants & de chirurgie'),
(241225, 0, 0, 241, 241, '1CAP2', '2412512321.', '1CAP2 décolletage : opérateur regleur'),
(241226, 0, 0, 241, 241, '2CAP2', '2412512322.', '2CAP2 décolletage : opérateur regleur'),
(241227, 0, 0, 241, 241, '1CAP2', '2412512621.', '1CAP2 outillages a decouper et emboutir'),
(241228, 0, 0, 241, 241, '2CAP2', '2412512622.', '2CAP2 outillages a decouper et emboutir'),
(241229, 0, 0, 241, 241, '1CAP2', '2412513021.', '1CAP2 développement : fabric.entret.meca. -tom'),
(241230, 0, 0, 241, 241, '2CAP2', '2412513022.', '2CAP2 développement : fabric.entret.meca. -tom');
INSERT INTO `sacoche_niveau` (`niveau_id`, `niveau_actif`, `niveau_usuel`, `niveau_famille_id`, `niveau_ordre`, `niveau_ref`, `code_mef`, `niveau_nom`) VALUES
(241231, 0, 0, 241, 241, '1CAP2', '2412513321.', '1CAP2 agent verif. appar. extincteurs'),
(241232, 0, 0, 241, 241, '2CAP2', '2412513322.', '2CAP2 agent verif. appar. extincteurs'),
(241233, 0, 0, 241, 241, '1CAP2', '2412513421.', '1CAP2 transport câbles-remontées meca.'),
(241234, 0, 0, 241, 241, '2CAP2', '2412513422.', '2CAP2 transport câbles-remontées meca.'),
(241235, 0, 0, 241, 241, '1CAP2', '2412513621.', '1CAP2 armurerie (fabricat. et réparat.)'),
(241236, 0, 0, 241, 241, '2CAP2', '2412513622.', '2CAP2 armurerie (fabricat. et réparat.)'),
(241237, 0, 0, 241, 241, '1CAP2', '2412513721.', '1CAP2 horloger'),
(241238, 0, 0, 241, 241, '2CAP2', '2412513722.', '2CAP2 horloger'),
(241239, 0, 0, 241, 241, '1CAP2', '2412522121.', '1CAP2 maintenance des matériels option A matériels agricoles'),
(241240, 0, 0, 241, 241, '2CAP2', '2412522122.', '2CAP2 maintenance des matériels option A matériels agricoles'),
(241241, 0, 0, 241, 241, '1CAP2', '2412522221.', '1CAP2 maintenance des matériels option B matériels TP et manutention'),
(241242, 0, 0, 241, 241, '2CAP2', '2412522222.', '2CAP2 maintenance des matériels option B matériels TP et manutention'),
(241243, 0, 0, 241, 241, '1CAP2', '2412522321.', '1CAP2 maintenance des matériels option C matériels d''espaces verts'),
(241244, 0, 0, 241, 241, '2CAP2', '2412522322.', '2CAP2 maintenance des matériels option C matériels d''espaces verts'),
(241245, 0, 0, 241, 241, '1CAP2', '2412521721.', '1CAP2 repar.entr.embarcations plaisance'),
(241246, 0, 0, 241, 241, '2CAP2', '2412521722.', '2CAP2 repar.entr.embarcations plaisance'),
(241247, 0, 0, 241, 241, '1CAP2', '2412521821.', '1CAP2 maintenance des véhicules option A voitures particulières'),
(241248, 0, 0, 241, 241, '2CAP2', '2412521822.', '2CAP2 maintenance des véhicules option A voitures particulières'),
(241249, 0, 0, 241, 241, '1CAP2', '2412521921.', '1CAP2 maintenance des véhicules option B véhicules de transport routier'),
(241250, 0, 0, 241, 241, '2CAP2', '2412521922.', '2CAP2 maintenance des véhicules option B véhicules de transport routier'),
(241251, 0, 0, 241, 241, '1CAP2', '2412522021.', '1CAP2 maintenance des véhicules option C motocycles'),
(241252, 0, 0, 241, 241, '2CAP2', '2412522022.', '2CAP2 maintenance des véhicules option C motocycles'),
(241253, 0, 0, 241, 241, '1CAP2', '2412530521.', '1CAP2 aéronautique option avionique'),
(241254, 0, 0, 241, 241, '2CAP2', '2412530522.', '2CAP2 aéronautique option avionique'),
(241255, 0, 0, 241, 241, '1CAP2', '2412530621.', '1CAP2 aéronautique option systèmes'),
(241256, 0, 0, 241, 241, '2CAP2', '2412530622.', '2CAP2 aéronautique option systèmes'),
(241257, 0, 0, 241, 241, '1CAP2', '2412530721.', '1CAP2 aéronautique option structures'),
(241258, 0, 0, 241, 241, '2CAP2', '2412530722.', '2CAP2 aéronautique option structures'),
(241259, 0, 0, 241, 241, '1CAP2', '2412542121.', '1CAP2 mise en forme des matériaux'),
(241260, 0, 0, 241, 241, '2CAP2', '2412542122.', '2CAP2 mise en forme des matériaux'),
(241261, 0, 0, 241, 241, '2CAP2', '2412542322.', '2CAP2 ferronnier'),
(241262, 0, 0, 241, 241, '1CAP2', '2412542521.', '1CAP2 outillage en moules métallique'),
(241263, 0, 0, 241, 241, '2CAP2', '2412542522.', '2CAP2 outillage en moules métallique'),
(241264, 0, 0, 241, 241, '2CAP2', '2412542722.', '2CAP2 tuyautier en orgues'),
(241265, 0, 0, 241, 241, '1CAP2', '2412543121.', '1CAP2 serrurier métallier'),
(241266, 0, 0, 241, 241, '2CAP2', '2412543122.', '2CAP2 serrurier métallier'),
(241267, 0, 0, 241, 241, '1CAP2', '2412543221.', '1CAP2 construction des carrosseries'),
(241268, 0, 0, 241, 241, '2CAP2', '2412543222.', '2CAP2 construction des carrosseries'),
(241269, 0, 0, 241, 241, '1CAP2', '2412543321.', '1CAP2 peinture en carrosserie'),
(241270, 0, 0, 241, 241, '2CAP2', '2412543322.', '2CAP2 peinture en carrosserie'),
(241271, 0, 0, 241, 241, '1CAP2', '2412543421.', '1CAP2 réparation des carrosseries'),
(241272, 0, 0, 241, 241, '2CAP2', '2412543422.', '2CAP2 réparation des carrosseries'),
(241273, 0, 0, 241, 241, '1CAP2', '2412543521.', '1CAP2 réalisat. en chaudronnerie indus.'),
(241274, 0, 0, 241, 241, '2CAP2', '2412543522.', '2CAP2 réalisat. en chaudronnerie indus.'),
(241275, 0, 0, 241, 241, '1CAP2', '2412543621.', '1CAP2 ferronnier d''art'),
(241276, 0, 0, 241, 241, '2CAP2', '2412543622.', '2CAP2 ferronnier d''art'),
(241277, 0, 0, 241, 241, '1CAP2', '2412552121.', '1CAP2 métiers enseigne signalétique'),
(241278, 0, 0, 241, 241, '2CAP2', '2412552122.', '2CAP2 métiers enseigne signalétique'),
(241279, 0, 0, 241, 241, '1CAP2', '2412552321.', '1CAP2 prep.& real. ouvrages électriques'),
(241280, 0, 0, 241, 241, '2CAP2', '2412552322.', '2CAP2 prep.& real. ouvrages électriques'),
(241281, 0, 0, 241, 241, '1CAP2', '2413110721.', '1CAP2 emballeur professionnel'),
(241282, 0, 0, 241, 241, '2CAP2', '2413110722.', '2CAP2 emballeur professionnel'),
(241283, 0, 0, 241, 241, '1CAP2', '2413111421.', '1CAP2 agt accueil condte rout.tr.voyag.'),
(241284, 0, 0, 241, 241, '2CAP2', '2413111422.', '2CAP2 agt accueil condte rout.tr.voyag.'),
(241285, 0, 0, 241, 241, '2CAP2', '2413111622.', '2CAP2 agent entreposage et messagerie'),
(241286, 0, 0, 241, 241, '1CAP2', '2413111721.', '1CAP2 conducteur routier marchandises'),
(241287, 0, 0, 241, 241, '2CAP2', '2413111722.', '2CAP2 conducteur routier marchandises'),
(241288, 0, 0, 241, 241, '1CAP2', '2413111821.', '1CAP2 conducteur livreur marchandises'),
(241289, 0, 0, 241, 241, '2CAP2', '2413111822.', '2CAP2 conducteur livreur marchandises'),
(241290, 0, 0, 241, 241, '1CAP2', '2413111921.', '1CAP2 déménageur véhic.utilitaire léger'),
(241291, 0, 0, 241, 241, '2CAP2', '2413111922.', '2CAP2 déménageur véhic.utilitaire léger'),
(241292, 0, 0, 241, 241, '1CAP2', '2413112021.', '1CAP2 distribution objets serv.clientel'),
(241293, 0, 0, 241, 241, '2CAP2', '2413112022.', '2CAP2 distribution objets serv.clientel'),
(241294, 0, 0, 241, 241, '1CAP2', '2413112121.', '1CAP2 transport fluvial'),
(241295, 0, 0, 241, 241, '2CAP2', '2413112122.', '2CAP2 transport fluvial'),
(241296, 0, 0, 241, 241, '1CAP2', '2413112221.', '1CAP2 opérateur/opératrice logistique'),
(241297, 0, 0, 241, 241, '2CAP2', '2413112222.', '2CAP2 opérateur/opératrice logistique'),
(241298, 0, 0, 241, 241, '1CAP2', '2413121421.', '1CAP2 employé commerce multispécialités'),
(241299, 0, 0, 241, 241, '2CAP2', '2413121422.', '2CAP2 employé commerce multispécialités'),
(241300, 0, 0, 241, 241, '1CAP2', '2413121521.', '1CAP2 employ.vente : prdts alimentaires'),
(241301, 0, 0, 241, 241, '2CAP2', '2413121522.', '2CAP2 employ.vente : prdts alimentaires'),
(241302, 0, 0, 241, 241, '1CAP2', '2413121621.', '1CAP2 empl.vente : prdts équip.courants'),
(241303, 0, 0, 241, 241, '2CAP2', '2413121622.', '2CAP2 empl.vente : prdts équip.courant'),
(241304, 0, 0, 241, 241, '1CAP2', '2413121721.', '1CAP2 vendeur-magasinier pièces auto'),
(241305, 0, 0, 241, 241, '2CAP2', '2413121722.', '2CAP2 vendeur-magasinier pièces auto'),
(241306, 0, 0, 241, 241, '1CAP2', '2413121821.', '1CAP2 fleuriste'),
(241307, 0, 0, 241, 241, '2CAP2', '2413121822.', '2CAP2 fleuriste'),
(241308, 0, 0, 241, 241, '1CAP2', '2413121921.', '1CAP2 empl.vente sp. : servic.clientèle'),
(241309, 0, 0, 241, 241, '2CAP2', '2413121922.', '2CAP2 empl.vente sp. : servic.clientèle'),
(241310, 0, 0, 241, 241, '1CAP2', '2413122021.', '1CAP2 empl.vent.sp.librair.papet.presse'),
(241311, 0, 0, 241, 241, '2CAP2', '2413122022.', '2CAP2 empl.vent.sp.librair.papet.presse'),
(241312, 0, 0, 241, 241, '1CAP2', '2413122121.', '1CAP2 poissonnier'),
(241313, 0, 0, 241, 241, '2CAP2', '2413122122.', '2CAP2 poissonnier'),
(241314, 0, 0, 241, 241, '1CAP2', '2413221721.', '1CAP2 arts de la reliure'),
(241315, 0, 0, 241, 241, '2CAP2', '2413221722.', '2CAP2 arts de la reliure'),
(241316, 0, 0, 241, 241, '1CAP2', '2413222021.', '1CAP2 métiers de la gravure : ornement.'),
(241317, 0, 0, 241, 241, '2CAP2', '2413222022.', '2CAP2 métiers de la gravure : ornement.'),
(241318, 0, 0, 241, 241, '1CAP2', '2413222121.', '1CAP2 métiers de la gravure : impress.'),
(241319, 0, 0, 241, 241, '2CAP2', '2413222122.', '2CAP2 métiers de la gravure : impress.'),
(241320, 0, 0, 241, 241, '1CAP2', '2413222221.', '1CAP2 métiers de la gravure : modèle'),
(241321, 0, 0, 241, 241, '2CAP2', '2413222222.', '2CAP2 métiers de la gravure : modèle'),
(241322, 0, 0, 241, 241, '1CAP2', '2413222321.', '1CAP2 met.gravure : marquage poinçonnage'),
(241323, 0, 0, 241, 241, '2CAP2', '2413222322.', '2CAP2 met.gravure : marquage poinçonnage'),
(241324, 0, 0, 241, 241, '1CAP2', '2413222521.', '1CAP2 sérigraphie industrielle'),
(241325, 0, 0, 241, 241, '2CAP2', '2413222522.', '2CAP2 sérigraphie industrielle'),
(241326, 0, 0, 241, 241, '1CAP2', '2413222621.', '1CAP2 signalétique enseigne et décor'),
(241327, 0, 0, 241, 241, '2CAP2', '2413222622.', '2CAP2 signalétique enseigne et décor'),
(241328, 0, 0, 241, 241, '1CAP2', '2413230621.', '1CAP2 monteur en chapiteaux'),
(241329, 0, 0, 241, 241, '2CAP2', '2413230622.', '2CAP2 monteur en chapiteaux'),
(241330, 0, 0, 241, 241, '1CAP2', '2413230721.', '1CAP2 accessoiriste réalisateur'),
(241331, 0, 0, 241, 241, '2CAP2', '2413230722.', '2CAP2 accessoiriste réalisateur'),
(241332, 0, 0, 241, 241, '1CAP2', '2413230821.', '1CAP2 accordeur de pianos'),
(241333, 0, 0, 241, 241, '2CAP2', '2413230822.', '2CAP2 accordeur de pianos'),
(241334, 0, 0, 241, 241, '1CAP2', '2413231021.', '1CAP2 ass.tech.instr.musiq. : accordéon'),
(241335, 0, 0, 241, 241, '2CAP2', '2413231022.', '2CAP2 ass.tech.instr.musiq. : accordéon'),
(241336, 0, 0, 241, 241, '1CAP2', '2413231121.', '1CAP2 ass.tech.instr.musiq. instr.vent'),
(241337, 0, 0, 241, 241, '2CAP2', '2413231122.', '2CAP2 ass.tech.instr.musiq. instr.vent'),
(241338, 0, 0, 241, 241, '1CAP2', '2413231221.', '1CAP2 ass.tech.instr.musiq. : piano'),
(241339, 0, 0, 241, 241, '2CAP2', '2413231222.', '2CAP2 ass.tech.instr.musiq. : piano'),
(241340, 0, 0, 241, 241, '1CAP2', '2413231321.', '1CAP2 ass.tech.instr.musiq. : guitare'),
(241341, 0, 0, 241, 241, '2CAP2', '2413231322.', '2CAP2 ass.tech.instr.musiq. : guitare'),
(241342, 0, 0, 241, 241, '1CAP2', '2413231421.', '1CAP2 opérateur projectionniste cinéma'),
(241343, 0, 0, 241, 241, '2CAP2', '2413231422.', '2CAP2 opérateur projectionniste cinéma'),
(241344, 0, 0, 241, 241, '1CAP2', '2413310621.', '1CAP2 ortho-prothésiste'),
(241345, 0, 0, 241, 241, '2CAP2', '2413310622.', '2CAP2 ortho-prothésiste'),
(241346, 0, 0, 241, 241, '1CAP2', '2413310721.', '1CAP2 podo-orthésiste'),
(241347, 0, 0, 241, 241, '2CAP2', '2413310722.', '2CAP2 podo-orthésiste'),
(241348, 0, 0, 241, 241, '1CAP2', '2413320121.', '1CAP2 développement : act.famil.artis.tour. -tom'),
(241349, 0, 0, 241, 241, '2CAP2', '2413320122.', '2CAP2 développement : act.famil.artis.tour. -tom'),
(241350, 0, 0, 241, 241, '1CAP2', '2413320221.', '1CAP2 petite enfance'),
(241351, 0, 0, 241, 241, '2CAP2', '2413320222.', '2CAP2 petite enfance'),
(241352, 0, 0, 241, 241, '1CAP2', '2413340821.', '1CAP2 services hôteliers'),
(241353, 0, 0, 241, 241, '2CAP2', '2413340822.', '2CAP2 services hôteliers'),
(241354, 0, 0, 241, 241, '1CAP2', '2413340921.', '1CAP2 restaurant'),
(241355, 0, 0, 241, 241, '2CAP2', '2413340922.', '2CAP2 restaurant'),
(241356, 0, 0, 241, 241, '1CAP2', '2413341021.', '1CAP2 services en brasserie-café'),
(241357, 0, 0, 241, 241, '2CAP2', '2413341022.', '2CAP2 services en brasserie-café'),
(241358, 0, 0, 241, 241, '1CAP2', '2413341121.', '1CAP2 ass. tech. milieux famil.collect.'),
(241359, 0, 0, 241, 241, '2CAP2', '2413341122.', '2CAP2 ass. tech. milieux famil.collect.'),
(241360, 0, 0, 241, 241, '1CAP2', '2413350121.', '1CAP2 métiers du football'),
(241361, 0, 0, 241, 241, '2CAP2', '2413350122.', '2CAP2 métiers du football'),
(241362, 0, 0, 241, 241, '1CAP2', '2413360321.', '1CAP2 taxidermiste'),
(241363, 0, 0, 241, 241, '2CAP2', '2413360322.', '2CAP2 taxidermiste'),
(241364, 0, 0, 241, 241, '1CAP2', '2413361021.', '1CAP2 coiffure'),
(241365, 0, 0, 241, 241, '2CAP2', '2413361022.', '2CAP2 coiffure'),
(241366, 0, 0, 241, 241, '1CAP2', '2413361121.', '1CAP2 esthétique cosmétique parfumerie'),
(241367, 0, 0, 241, 241, '2CAP2', '2413361122.', '2CAP2 esthétique cosmétique parfumerie'),
(241368, 0, 0, 241, 241, '1CAP2', '2413400221.', '1CAP2 agt prévention médiation'),
(241369, 0, 0, 241, 241, '2CAP2', '2413400222.', '2CAP2 agt prévention médiation'),
(241370, 0, 0, 241, 241, '1CAP2', '2413430121.', '1CAP2 agent de la qualité de l''eau'),
(241371, 0, 0, 241, 241, '2CAP2', '2413430122.', '2CAP2 agent de la qualité de l''eau'),
(241372, 0, 0, 241, 241, '1CAP2', '2413430321.', '1CAP2 assainismt collect.déchets liquid'),
(241373, 0, 0, 241, 241, '2CAP2', '2413430322.', '2CAP2 assainismt collect.déchets liquid'),
(241374, 0, 0, 241, 241, '2CAP2', '2413430522.', '2CAP2 gestion déchets propreté urbaine'),
(241375, 0, 0, 241, 241, '1CAP2', '2413430721.', '1CAP2 agent de propreté et d''hygiène'),
(241376, 0, 0, 241, 241, '2CAP2', '2413430722.', '2CAP2 agent de propreté et d''hygiène'),
(241377, 0, 0, 241, 241, '1CAP2', '2413440421.', '1CAP2 gardien d''immeuble'),
(241378, 0, 0, 241, 241, '2CAP2', '2413440422.', '2CAP2 gardien d''immeuble'),
(241379, 0, 0, 241, 241, '1CAP2', '2413440521.', '1CAP2 agent de sécurité'),
(241380, 0, 0, 241, 241, '2CAP2', '2413440522.', '2CAP2 agent de sécurité'),
(242001, 0, 1, 242, 242, '1CAP3', '242.....31.', 'CAP 3 ans, 1e année'),
(242002, 0, 1, 242, 242, '2CAP3', '242.....32.', 'CAP 3 ans, 2e année'),
(242003, 0, 1, 242, 242, '3CAP3', '242.....33.', 'CAP 3 ans, 3e année'),
(242004, 0, 0, 242, 242, '1CAP3', '2422100231.', '1CAP3 développement : gest.pte expl.rural -tom'),
(242005, 0, 0, 242, 242, '2CAP3', '2422100232.', '2CAP3 développement : gest.pte expl.rural -tom'),
(242006, 0, 0, 242, 242, '3CAP3', '2422100233.', '3CAP3 développement : gest.pte expl.rural -tom'),
(242007, 0, 0, 242, 242, '1CAP3', '2422130331.', '1CAP3 développement : gest. milieu marin -tom'),
(242008, 0, 0, 242, 242, '2CAP3', '2422130332.', '2CAP3 développement : gest. milieu marin -tom'),
(242009, 0, 0, 242, 242, '3CAP3', '2422130333.', '3CAP3 développement : gest. milieu marin -tom'),
(242010, 0, 0, 242, 242, '1CAP3', '2422321231.', '1CAP3 développement : const.entret.batimt -tom'),
(242011, 0, 0, 242, 242, '2CAP3', '2422321232.', '2CAP3 développement : const.entret.batimt -tom'),
(242012, 0, 0, 242, 242, '3CAP3', '2422321233.', '3CAP3 développement : const.entret.batimt -tom'),
(242013, 0, 0, 242, 242, '1CAP3', '2422500131.', '1CAP3 certif.aptitude au developt -tom'),
(242014, 0, 0, 242, 242, '2CAP3', '2422500132.', '2CAP3 certif.aptitude au developt -tom'),
(242015, 0, 0, 242, 242, '3CAP3', '2422500133.', '3CAP3 certif.aptitude au developt -tom'),
(242016, 0, 0, 242, 242, '1CAP3', '2422513031.', '1CAP3 développement : fabric.entret.meca. -tom'),
(242017, 0, 0, 242, 242, '2CAP3', '2422513032.', '2CAP3 développement : fabric.entret.meca. -tom'),
(242018, 0, 0, 242, 242, '3CAP3', '2422513033.', '3CAP3 développement : fabric.entret.meca. -tom'),
(242019, 0, 0, 242, 242, '1CAP3', '2423320131.', '1CAP3 développement : act.famil.artis.tour. -tom'),
(242020, 0, 0, 242, 242, '2CAP3', '2423320132.', '2CAP3 développement : act.famil.artis.tour. -tom'),
(242021, 0, 0, 242, 242, '3CAP3', '2423320133.', '3CAP3 développement : act.famil.artis.tour. -tom'),
(243000, 0, 0, 243, 243, 'BEP1', '243.....11.', 'BEP 1 an'),
(244001, 0, 0, 243, 244, '2BEP', '244.....21.', 'BEP 2 ans, 1e année (seconde)'),
(244002, 0, 0, 243, 244, 'TBEP', '244.....22.', 'BEP 2 ans, 2e année (terminale)'),
(245000, 0, 0, 247, 245, '1PRO1', '245.....11.', 'Bac Pro 1 an'),
(246001, 0, 0, 247, 246, '1PRO2', '246.....21.', 'Bac Pro 2 ans, 1e année'),
(246002, 0, 0, 247, 246, '2PRO2', '246.....22.', 'Bac Pro 2 ans, 2e année (terminale)'),
(247001, 0, 1, 247, 247, '1PRO3', '247.....31.', 'Bac Pro 3 ans, 1e année (seconde pro)'),
(247002, 0, 1, 247, 247, '2PRO3', '247.....32.', 'Bac Pro 3 ans, 2e année (première pro)'),
(247003, 0, 1, 247, 247, '3PRO3', '247.....33.', 'Bac Pro 3 ans, 3e année (terminale pro)'),
(247004, 0, 0, 247, 247, '2NDPRO', '2472000231.', '2ndPro etud.definition prdts industriels'),
(247005, 0, 0, 247, 247, '1ERPRO', '2472000232.', '1erPro etud.definition prdts industriels'),
(247006, 0, 0, 247, 247, 'TLEPRO', '2472000233.', 'TlePro etud.definition prdts industriels'),
(247007, 0, 0, 247, 247, '2NDPRO', '2472010231.', '2ndPro pilote de ligne de production'),
(247008, 0, 0, 247, 247, '1ERPRO', '2472010232.', '1erPro pilote de ligne de production'),
(247009, 0, 0, 247, 247, 'TLEPRO', '2472010233.', 'TlePro pilote de ligne de production'),
(247010, 0, 0, 247, 247, 'TLEPRO', '2472120133.', 'TlePro cultures marines'),
(247011, 0, 0, 247, 247, '2NDPRO', '2472120431.', '2ndPro cultures marines'),
(247012, 0, 0, 247, 247, '1ERPRO', '2472120432.', '1erPro cultures marines'),
(247013, 0, 0, 247, 247, 'TLEPRO', '2472120433.', 'TlePro cultures marines'),
(247014, 0, 0, 247, 247, '2NDPRO', '2472130231.', '2ndPro CGEM option pêche'),
(247015, 0, 0, 247, 247, '1ERPRO', '2472130232.', '1erPro CGEM option pêche'),
(247016, 0, 0, 247, 247, 'TLEPRO', '2472130233.', 'TlePro CGEM option pêche'),
(247017, 0, 0, 247, 247, '2NDPRO', '2472200331.', '2ndPro bio-industries de transformation'),
(247018, 0, 0, 247, 247, '1ERPRO', '2472200332.', '1erPro bio-industries de transformation'),
(247019, 0, 0, 247, 247, 'TLEPRO', '2472200333.', 'TlePro bio-industries de transformation'),
(247020, 0, 0, 247, 247, '2NDPRO', '2472200431.', '2ndPro proc. chimie eau papiers-cartons'),
(247021, 0, 0, 247, 247, '1ERPRO', '2472200432.', '1erPro proc. chimie eau papiers-cartons'),
(247022, 0, 0, 247, 247, 'TLEPRO', '2472200433.', 'TlePro proc. chimie eau papiers-cartons'),
(247023, 0, 0, 247, 247, '2NDPRO', '2472210431.', '2ndPro boucher charcutier traiteur'),
(247024, 0, 0, 247, 247, '1ERPRO', '2472210432.', '1erPro boucher charcutier traiteur'),
(247025, 0, 0, 247, 247, 'TLEPRO', '2472210433.', 'TlePro boucher charcutier traiteur'),
(247026, 0, 0, 247, 247, '2NDPRO', '2472210531.', '2ndPro boulanger-pâtissier'),
(247027, 0, 0, 247, 247, '1ERPRO', '2472210532.', '1erPro boulanger-pâtissier'),
(247028, 0, 0, 247, 247, 'TLEPRO', '2472210533.', 'TlePro boulanger-pâtissier'),
(247029, 0, 0, 247, 247, '2NDPRO', '2472210631.', '2ndPro cuisine'),
(247030, 0, 0, 247, 247, '1ERPRO', '2472210632.', '1erPro cuisine'),
(247031, 0, 0, 247, 247, 'TLEPRO', '2472210633.', 'TlePro cuisine'),
(247032, 0, 0, 247, 247, '2NDPRO', '2472230231.', '2ndPro traitements de surface'),
(247033, 0, 0, 247, 247, '1ERPRO', '2472230232.', '1erPro traitements de surface'),
(247034, 0, 0, 247, 247, 'TLEPRO', '2472230233.', 'TlePro traitements de surface'),
(247035, 0, 0, 247, 247, '2NDPRO', '2472230331.', '2ndPro fonderie'),
(247036, 0, 0, 247, 247, '1ERPRO', '2472230332.', '1erPro fonderie'),
(247037, 0, 0, 247, 247, 'TLEPRO', '2472230333.', 'TlePro fonderie'),
(247038, 0, 0, 247, 247, '2NDPRO', '2472230431.', '2ndPro artisanat et métiers d''art : facteur d''orgues option organier'),
(247039, 0, 0, 247, 247, '1ERPRO', '2472230432.', '1erPro artisanat et métiers d''art : facteur d''orgues option organier'),
(247040, 0, 0, 247, 247, 'TLEPRO', '2472230433.', 'TlePro artisanat et métiers d''art : facteur d''orgues option organier'),
(247041, 0, 0, 247, 247, '2NDPRO', '2472230531.', '2ndPro artisanat et métiers d''art : facteur d''orgues option tuyautier'),
(247042, 0, 0, 247, 247, '1ERPRO', '2472230532.', '1erPro artisanat et métiers d''art : facteur d''orgues option tuyautier'),
(247043, 0, 0, 247, 247, 'TLEPRO', '2472230533.', 'TlePro artisanat et métiers d''art : facteur d''orgues option tuyautier'),
(247044, 0, 0, 247, 247, '2NDPRO', '2472240231.', '2ndPro artisanat et métiers d''art : verr.scient.techn'),
(247045, 0, 0, 247, 247, '1ERPRO', '2472240232.', '1erPro artisanat et métiers d''art : verr.scient.techn'),
(247046, 0, 0, 247, 247, 'TLEPRO', '2472240233.', 'TlePro artisanat et métiers d''art : verr.scient.techn'),
(247047, 0, 0, 247, 247, '2NDPRO', '2472240331.', '2ndPro artisanat et métiers d''art : met.enseign signal'),
(247048, 0, 0, 247, 247, '1ERPRO', '2472240332.', '1erPro artisanat et métiers d''art : met.enseign signal'),
(247049, 0, 0, 247, 247, 'TLEPRO', '2472240333.', 'TlePro artisanat et métiers d''art : met.enseign signal'),
(247050, 0, 0, 247, 247, '2NDPRO', '2472250331.', '2ndPro plastiques et composites'),
(247051, 0, 0, 247, 247, '1ERPRO', '2472250332.', '1erPro plastiques et composites'),
(247052, 0, 0, 247, 247, 'TLEPRO', '2472250333.', 'TlePro plastiques et composites'),
(247053, 0, 0, 247, 247, '2NDPRO', '2472270331.', '2ndPro techn.install.syst.energ.climatiq'),
(247054, 0, 0, 247, 247, '1ERPRO', '2472270332.', '1erPro techn.install.syst.energ.climatiq'),
(247055, 0, 0, 247, 247, 'TLEPRO', '2472270333.', 'TlePro techn.install.syst.energ.climatiq'),
(247056, 0, 0, 247, 247, '2NDPRO', '2472270431.', '2ndPro techn. maint. syst.energ.climatiq'),
(247057, 0, 0, 247, 247, '1ERPRO', '2472270432.', '1erPro techn. maint. syst.energ.climatiq'),
(247058, 0, 0, 247, 247, 'TLEPRO', '2472270433.', 'TlePro techn. maint. syst.energ.climatiq'),
(247059, 0, 0, 247, 247, '2NDPRO', '2472300331.', '2ndPro artisanat et métiers d''art : marchandisage vis.'),
(247060, 0, 0, 247, 247, '1ERPRO', '2472300332.', '1erPro artisanat et métiers d''art : marchandisage vis.'),
(247061, 0, 0, 247, 247, 'TLEPRO', '2472300333.', 'TlePro artisanat et métiers d''art : marchandisage vis.'),
(247062, 0, 0, 247, 247, '2NDPRO', '2472300431.', '2ndPro techn. études bat.a études & eco.'),
(247063, 0, 0, 247, 247, '1ERPRO', '2472300432.', '1erPro techn. études bat.a études & eco.'),
(247064, 0, 0, 247, 247, 'TLEPRO', '2472300433.', 'TlePro techn. études bat.a études & eco.'),
(247065, 0, 0, 247, 247, '2NDPRO', '2472300531.', '2ndPro techn. études bat b assist.archi.'),
(247066, 0, 0, 247, 247, '1ERPRO', '2472300532.', '1erPro techn. études bat b assist.archi.'),
(247067, 0, 0, 247, 247, 'TLEPRO', '2472300533.', 'TlePro techn. études bat b assist.archi.'),
(247068, 0, 0, 247, 247, '2NDPRO', '2472310231.', '2ndPro travaux publics'),
(247069, 0, 0, 247, 247, '1ERPRO', '2472310232.', '1erPro travaux publics'),
(247070, 0, 0, 247, 247, 'TLEPRO', '2472310233.', 'TlePro travaux publics'),
(247071, 0, 0, 247, 247, '2NDPRO', '2472310331.', '2ndPro technicien géomètre-topographe'),
(247072, 0, 0, 247, 247, '1ERPRO', '2472310332.', '1erPro technicien géomètre-topographe'),
(247073, 0, 0, 247, 247, 'TLEPRO', '2472310333.', 'TlePro technicien géomètre-topographe'),
(247074, 0, 0, 247, 247, '1ERPRO', '2472320232.', '1erPro artisanat et métiers d''art : arts pierre'),
(247075, 0, 0, 247, 247, 'TLEPRO', '2472320233.', 'TlePro artisanat et métiers d''art : arts pierre'),
(247076, 0, 0, 247, 247, '2NDPRO', '2472320331.', '2ndPro technicien bat. : org.real.gros œuvre'),
(247077, 0, 0, 247, 247, '1ERPRO', '2472320332.', '1erPro technicien bat. : org.real.gros œuvre'),
(247078, 0, 0, 247, 247, 'TLEPRO', '2472320333.', 'TlePro technicien bat. : org.real.gros œuvre'),
(247079, 0, 0, 247, 247, '2NDPRO', '2472320531.', '2ndPro interventions sur le patrimoine bâti, option A maçonnerie'),
(247080, 0, 0, 247, 247, '1ERPRO', '2472320532.', '1erPro interventions sur le patrimoine bâti, option A maçonnerie'),
(247081, 0, 0, 247, 247, 'TLEPRO', '2472320533.', 'TlePro interventions sur le patrimoine bâti, option A maçonnerie'),
(247082, 0, 0, 247, 247, '2NDPRO', '2472320631.', '2ndPro interventions sur le patrimoine bâti, option B charpente'),
(247083, 0, 0, 247, 247, '1ERPRO', '2472320632.', '1erPro interventions sur le patrimoine bâti, option B charpente'),
(247084, 0, 0, 247, 247, 'TLEPRO', '2472320633.', 'TlePro interventions sur le patrimoine bâti, option B charpente'),
(247085, 0, 0, 247, 247, '2NDPRO', '2472320731.', '2ndPro interventions sur le patrimoine bâti, option C couverture'),
(247086, 0, 0, 247, 247, '1ERPRO', '2472320732.', '1erPro interventions sur le patrimoine bâti, option C couverture'),
(247087, 0, 0, 247, 247, 'TLEPRO', '2472320733.', 'TlePro interventions sur le patrimoine bâti, option C couverture'),
(247088, 0, 0, 247, 247, '2NDPRO', '2472320831.', '2ndPro métiers et arts de la pierre'),
(247089, 0, 0, 247, 247, '1ERPRO', '2472320832.', '1erPro métiers et arts de la pierre'),
(247090, 0, 0, 247, 247, 'TLEPRO', '2472320833.', 'TlePro métiers et arts de la pierre'),
(247091, 0, 0, 247, 247, '2NDPRO', '2472330331.', '2ndPro menuiserie aluminium-verre'),
(247092, 0, 0, 247, 247, '1ERPRO', '2472330332.', '1erPro menuiserie aluminium-verre'),
(247093, 0, 0, 247, 247, 'TLEPRO', '2472330333.', 'TlePro menuiserie aluminium-verre'),
(247094, 0, 0, 247, 247, '2NDPRO', '2472330431.', '2ndPro aménagement finition bâtiment'),
(247095, 0, 0, 247, 247, '1ERPRO', '2472330432.', '1erPro aménagement finition bâtiment'),
(247096, 0, 0, 247, 247, 'TLEPRO', '2472330433.', 'TlePro aménagement finition bâtiment'),
(247097, 0, 0, 247, 247, 'TLEPRO', '2472340333.', 'TlePro artisanat et métiers d''art : : ébéniste'),
(247098, 0, 0, 247, 247, '2NDPRO', '2472340431.', '2ndPro technicien constructeur bois'),
(247099, 0, 0, 247, 247, '1ERPRO', '2472340432.', '1erPro technicien constructeur bois'),
(247100, 0, 0, 247, 247, 'TLEPRO', '2472340433.', 'TlePro technicien constructeur bois'),
(247101, 0, 0, 247, 247, '2NDPRO', '2472340531.', '2ndPro technicien menuisier agenceur'),
(247102, 0, 0, 247, 247, '1ERPRO', '2472340532.', '1erPro technicien menuisier agenceur'),
(247103, 0, 0, 247, 247, 'TLEPRO', '2472340533.', 'TlePro technicien menuisier agenceur'),
(247104, 0, 0, 247, 247, '2NDPRO', '2472340631.', '2ndPro technicien de scierie'),
(247105, 0, 0, 247, 247, '1ERPRO', '2472340632.', '1erPro technicien de scierie'),
(247106, 0, 0, 247, 247, 'TLEPRO', '2472340633.', 'TlePro technicien de scierie'),
(247107, 0, 0, 247, 247, '2NDPRO', '2472340731.', '2ndPro technic.fab.bois et materx assoc.'),
(247108, 0, 0, 247, 247, '1ERPRO', '2472340732.', '1erPro technic.fab.bois et materx assoc.'),
(247109, 0, 0, 247, 247, 'TLEPRO', '2472340733.', 'TlePro technic.fab.bois et materx assoc.'),
(247110, 0, 0, 247, 247, '2NDPRO', '2472340831.', '2ndPro agencement espace architectural'),
(247111, 0, 0, 247, 247, '1ERPRO', '2472340832.', '1erPro agencement espace architectural'),
(247112, 0, 0, 247, 247, 'TLEPRO', '2472340833.', 'TlePro agencement espace architectural'),
(247113, 0, 0, 247, 247, '2NDPRO', '2472400231.', '2ndPro métiers pressing blanchisserie'),
(247114, 0, 0, 247, 247, '1ERPRO', '2472400232.', '1erPro métiers pressing blanchisserie'),
(247115, 0, 0, 247, 247, 'TLEPRO', '2472400233.', 'TlePro métiers pressing blanchisserie'),
(247116, 0, 0, 247, 247, '2NDPRO', '2472420231.', '2ndPro artisanat et métiers d''art : tapis d''ameublement'),
(247117, 0, 0, 247, 247, '1ERPRO', '2472420232.', '1erPro artisanat et métiers d''art : tapis d''ameublement'),
(247118, 0, 0, 247, 247, 'TLEPRO', '2472420233.', 'TlePro artisanat et métiers d''art : tapis d''ameublement'),
(247119, 0, 0, 247, 247, '2NDPRO', '2472420331.', '2ndPro métiers de la mode - vêtement'),
(247120, 0, 0, 247, 247, '1ERPRO', '2472420332.', '1erPro métiers de la mode - vêtement'),
(247121, 0, 0, 247, 247, 'TLEPRO', '2472420333.', 'TlePro métiers de la mode - vêtement'),
(247122, 0, 0, 247, 247, '2NDPRO', '2472430131.', '2ndPro métiers du cuir : chaussures'),
(247123, 0, 0, 247, 247, '1ERPRO', '2472430132.', '1erPro métiers du cuir : chaussures'),
(247124, 0, 0, 247, 247, 'TLEPRO', '2472430133.', 'TlePro métiers du cuir : chaussures'),
(247125, 0, 0, 247, 247, '2NDPRO', '2472430231.', '2ndPro métiers du cuir : maroquinerie'),
(247126, 0, 0, 247, 247, '1ERPRO', '2472430232.', '1erPro métiers du cuir : maroquinerie'),
(247127, 0, 0, 247, 247, 'TLEPRO', '2472430233.', 'TlePro métiers du cuir : maroquinerie'),
(247128, 0, 0, 247, 247, '2NDPRO', '2472500531.', '2ndPro productique meca. opt.décolletage'),
(247129, 0, 0, 247, 247, '1ERPRO', '2472500532.', '1erPro productique meca. opt.décolletage'),
(247130, 0, 0, 247, 247, 'TLEPRO', '2472500533.', 'TlePro productiq.meca. opt.décolletage'),
(247131, 0, 0, 247, 247, '2NDPRO', '2472500631.', '2ndPro microtechniques'),
(247132, 0, 0, 247, 247, '1ERPRO', '2472500632.', '1erPro microtechniques'),
(247133, 0, 0, 247, 247, 'TLEPRO', '2472500633.', 'TlePro microtechniques'),
(247134, 0, 0, 247, 247, '2NDPRO', '2472500731.', '2ndPro maintenance équipements indust.'),
(247135, 0, 0, 247, 247, '1ERPRO', '2472500732.', '1erPro maintenance équipements indust.'),
(247136, 0, 0, 247, 247, 'TLEPRO', '2472500733.', 'TlePro maintenance équipements indust.'),
(247137, 0, 0, 247, 247, '2NDPRO', '2472500831.', '2ndPro électromecanicien marine'),
(247138, 0, 0, 247, 247, '1ERPRO', '2472500832.', '1erPro électromecanicien marine'),
(247139, 0, 0, 247, 247, 'TLEPRO', '2472500833.', 'TlePro électromecanicien marine'),
(247140, 0, 0, 247, 247, '2NDPRO', '2472500931.', '2ndPro maintenance nautique'),
(247141, 0, 0, 247, 247, '1ERPRO', '2472500932.', '1erPro maintenance nautique'),
(247142, 0, 0, 247, 247, 'TLEPRO', '2472500933.', 'TlePro maintenance nautique'),
(247143, 0, 0, 247, 247, '2NDPRO', '2472510631.', '2ndPro technicien d''usinage'),
(247144, 0, 0, 247, 247, '1ERPRO', '2472510632.', '1erPro technicien d''usinage'),
(247145, 0, 0, 247, 247, 'TLEPRO', '2472510633.', 'TlePro technicien d''usinage'),
(247146, 0, 0, 247, 247, '2NDPRO', '2472510731.', '2ndPro technicien outilleur'),
(247147, 0, 0, 247, 247, '1ERPRO', '2472510732.', '1erPro technicien outilleur'),
(247148, 0, 0, 247, 247, 'TLEPRO', '2472510733.', 'TlePro technicien outilleur'),
(247149, 0, 0, 247, 247, '2NDPRO', '2472510831.', '2ndPro technicien modèleur'),
(247150, 0, 0, 247, 247, '1ERPRO', '2472510832.', '1erPro technicien modèleur'),
(247151, 0, 0, 247, 247, 'TLEPRO', '2472510833.', 'TlePro technicien modèleur'),
(247152, 0, 0, 247, 247, 'TLEPRO', '2472520733.', 'TlePro maint.véhic.auto : voit.particul.'),
(247153, 0, 0, 247, 247, 'TLEPRO', '2472520833.', 'TlePro maint.véhic.auto. : véhic.indust.'),
(247154, 0, 0, 247, 247, 'TLEPRO', '2472521033.', 'TlePro maint.véhic.auto. : motocycles'),
(247155, 0, 0, 247, 247, '2NDPRO', '2472521131.', '2ndPro maintenance des matériels option A matériels agricoles'),
(247156, 0, 0, 247, 247, '1ERPRO', '2472521932.', '1erPro maintenance des matériels option A matériels agricoles'),
(247157, 0, 0, 247, 247, 'TLEPRO', '2472521933.', 'TlePro maintenance des matériels option A matériels agricoles'),
(247158, 0, 0, 247, 247, '2NDPRO', '2472521231.', '2ndPro maintenance des matériels option B TP et manutention'),
(247159, 0, 0, 247, 247, '1ERPRO', '2472522032.', '1erPro maintenance des matériels option B TP et manutention'),
(247160, 0, 0, 247, 247, 'TLEPRO', '2472522033.', 'TlePro maintenance des matériels option B TP et manutention'),
(247161, 0, 0, 247, 247, '2NDPRO', '2472521331.', '2ndPro maintenance des matériels option C matériels d''espaces verts'),
(247162, 0, 0, 247, 247, '1ERPRO', '2472522132.', '1erPro maintenance des matériels option C matériels d''espaces verts'),
(247163, 0, 0, 247, 247, 'TLEPRO', '2472522133.', 'TlePro maintenance des matériels option C matériels d''espaces verts'),
(247164, 0, 0, 247, 247, '2NDPRO', '2472521431.', '2ndPro maintenance des véhicules option A voitures particulières'),
(247165, 0, 0, 247, 247, '1ERPRO', '2472521432.', '1erPro maintenance des véhicules option A voitures particulières'),
(247166, 0, 0, 247, 247, 'TLEPRO', '2472521433.', 'TlePro maintenance des véhicules option A voitures particulières'),
(247167, 0, 0, 247, 247, '2NDPRO', '2472521531.', '2ndPro maintenance des véhicules option B véhicules de transport routier'),
(247168, 0, 0, 247, 247, '1ERPRO', '2472521532.', '1erPro maintenance des véhicules option B véhicules de transport routier'),
(247169, 0, 0, 247, 247, 'TLEPRO', '2472521533.', 'TlePro maintenance des véhicules option B véhicules de transport routier'),
(247170, 0, 0, 247, 247, '2NDPRO', '2472521631.', '2ndPro maintenance des véhicules option C motocycles'),
(247171, 0, 0, 247, 247, '1ERPRO', '2472521632.', '1erPro maintenance des véhicules option C motocycles'),
(247172, 0, 0, 247, 247, 'TLEPRO', '2472521633.', 'TlePro maintenance des véhicules option C motocycles'),
(247173, 0, 0, 247, 247, '2NDPRO', '2472530231.', '2ndPro aéronautique option avionique'),
(247174, 0, 0, 247, 247, '1ERPRO', '2472530232.', '1erPro aéronautique option avionique'),
(247175, 0, 0, 247, 247, 'TLEPRO', '2472530233.', 'TlePro aéronautique option avionique'),
(247176, 0, 0, 247, 247, '2NDPRO', '2472530331.', '2ndPro aéronautique option systèmes'),
(247177, 0, 0, 247, 247, '1ERPRO', '2472530332.', '1erPro aéronautique option systèmes'),
(247178, 0, 0, 247, 247, 'TLEPRO', '2472530333.', 'TlePro aéronautique option systèmes'),
(247179, 0, 0, 247, 247, '2NDPRO', '2472530431.', '2ndPro aéronautique option structure'),
(247180, 0, 0, 247, 247, '1ERPRO', '2472530432.', '1erPro aéronautique option structure'),
(247181, 0, 0, 247, 247, 'TLEPRO', '2472530433.', 'TlePro aéronautique option structure'),
(247182, 0, 0, 247, 247, '2NDPRO', '2472530531.', '2ndPro aviation générale'),
(247183, 0, 0, 247, 247, '1ERPRO', '2472530532.', '1erPro aviation générale'),
(247184, 0, 0, 247, 247, 'TLEPRO', '2472530533.', 'TlePro aviation générale'),
(247185, 0, 0, 247, 247, '2NDPRO', '2472540631.', '2ndPro ouvrages du bâtiment métallerie'),
(247186, 0, 0, 247, 247, '1ERPRO', '2472540632.', '1erPro ouvrages du bâtiment métallerie'),
(247187, 0, 0, 247, 247, 'TLEPRO', '2472540633.', 'TlePro ouvrages du bâtiment métallerie'),
(247188, 0, 0, 247, 247, '2NDPRO', '2472540831.', '2ndPro réparation des carrosseries'),
(247189, 0, 0, 247, 247, '1ERPRO', '2472540832.', '1erPro réparation des carrosseries'),
(247190, 0, 0, 247, 247, 'TLEPRO', '2472540833.', 'TlePro réparation des carrosseries'),
(247191, 0, 0, 247, 247, '2NDPRO', '2472540931.', '2ndPro tech.chaudronnerie industrielle'),
(247192, 0, 0, 247, 247, '1ERPRO', '2472540932.', '1erPro tech.chaudronnerie industrielle'),
(247193, 0, 0, 247, 247, 'TLEPRO', '2472540933.', 'TlePro tech.chaudronnerie industrielle'),
(247194, 0, 0, 247, 247, '2NDPRO', '2472541031.', '2ndPro construction des carrosseries'),
(247195, 0, 0, 247, 247, '1ERPRO', '2472541032.', '1erPro construction des carrosseries'),
(247196, 0, 0, 247, 247, 'TLEPRO', '2472541033.', 'TlePro construction des carrosseries'),
(247197, 0, 0, 247, 247, '2NDPRO', '2472550631.', '2ndPro électrotec. energ. équip.communic'),
(247198, 0, 0, 247, 247, '1ERPRO', '2472550632.', '1erPro électrotec. energ. équip.communic'),
(247199, 0, 0, 247, 247, 'TLEPRO', '2472550633.', 'TlePro électrotec. energ. équip.communic'),
(247200, 0, 0, 247, 247, '2NDPRO', '2472550731.', '2ndPro systèmes électroniques numériques'),
(247201, 0, 0, 247, 247, '1ERPRO', '2472550732.', '1erPro systèmes électroniques numériques'),
(247202, 0, 0, 247, 247, 'TLEPRO', '2472550733.', 'TlePro systèmes électroniques numériques'),
(247203, 0, 0, 247, 247, '2NDPRO', '2472550931.', '2ndPro technic. froid conditionnemt air'),
(247204, 0, 0, 247, 247, '1ERPRO', '2472550932.', '1erPro technic. froid conditionnemt air'),
(247205, 0, 0, 247, 247, 'TLEPRO', '2472550933.', 'TlePro technic. froid conditionnemt air'),
(247206, 0, 0, 247, 247, '2NDPRO', '2473000131.', '2ndPro gestion-administration'),
(247207, 0, 0, 247, 247, '1ERPRO', '2473000132.', '1erPro gestion-administration'),
(247208, 0, 0, 247, 247, 'TLEPRO', '2473000133.', 'TlePro gestion-administration'),
(247209, 0, 0, 247, 247, '2NDPRO', '2473110531.', '2ndPro CGEM option marin de commerce'),
(247210, 0, 0, 247, 247, '1ERPRO', '2473110532.', '1erPro CGEM option marin de commerce'),
(247211, 0, 0, 247, 247, 'TLEPRO', '2473110533.', 'TlePro CGEM option marin de commerce'),
(247212, 0, 0, 247, 247, '2NDPRO', '2473110631.', '2ndPro logistique'),
(247213, 0, 0, 247, 247, '1ERPRO', '2473110632.', '1erPro logistique'),
(247214, 0, 0, 247, 247, 'TLEPRO', '2473110633.', 'TlePro logistique'),
(247215, 0, 0, 247, 247, '2NDPRO', '2473110731.', '2ndPro conduct. transp.rout.marchandises'),
(247216, 0, 0, 247, 247, '1ERPRO', '2473110732.', '1erPro conduct. transp.rout.marchandises'),
(247217, 0, 0, 247, 247, 'TLEPRO', '2473110733.', 'TlePro conduct. transp.rout.marchandises'),
(247218, 0, 0, 247, 247, '2NDPRO', '2473110831.', '2ndPro transport'),
(247219, 0, 0, 247, 247, '1ERPRO', '2473110832.', '1erPro transport'),
(247220, 0, 0, 247, 247, 'TLEPRO', '2473110833.', 'TlePro transport'),
(247221, 0, 0, 247, 247, '2NDPRO', '2473110931.', '2ndPro transport fluvial'),
(247222, 0, 0, 247, 247, '1ERPRO', '2473110932.', '1erPro transport fluvial'),
(247223, 0, 0, 247, 247, 'TLEPRO', '2473110933.', 'TlePro transport fluvial'),
(247224, 0, 0, 247, 247, '2NDPRO', '2473120231.', '2ndPro commerce'),
(247225, 0, 0, 247, 247, '1ERPRO', '2473120232.', '1erPro commerce'),
(247226, 0, 0, 247, 247, 'TLEPRO', '2473120233.', 'TlePro commerce'),
(247227, 0, 0, 247, 247, '2NDPRO', '2473120631.', '2ndPro vente (prospect.nego.suiv.client)'),
(247228, 0, 0, 247, 247, '1ERPRO', '2473120632.', '1erPro vente (prospect.nego.suiv.client)'),
(247229, 0, 0, 247, 247, 'TLEPRO', '2473120633.', 'TlePro vente (prospect.nego.suiv.client)'),
(247230, 0, 0, 247, 247, '2NDPRO', '2473120931.', '2ndPro poissonnier écailler traiteur'),
(247231, 0, 0, 247, 247, '1ERPRO', '2473120932.', '1erPro poissonnier écailler traiteur'),
(247232, 0, 0, 247, 247, 'TLEPRO', '2473120933.', 'TlePro poissonnier écailler traiteur'),
(247233, 0, 0, 247, 247, '2NDPRO', '2473121031.', '2ndPro accueil -relation clients usagers'),
(247234, 0, 0, 247, 247, '1ERPRO', '2473121032.', '1erPro accueil -relation clients usagers'),
(247235, 0, 0, 247, 247, 'TLEPRO', '2473121033.', 'TlePro accueil -relation clients usagers'),
(247236, 0, 0, 247, 247, 'TLEPRO', '2473220433.', 'TlePro production imprimée'),
(247237, 0, 0, 247, 247, 'TLEPRO', '2473220533.', 'TlePro production graphique'),
(247238, 0, 0, 247, 247, '2NDPRO', '2473220631.', '2ndPro façonnage prdts imprimés - routage'),
(247239, 0, 0, 247, 247, '1ERPRO', '2473220632.', '1erPro façonnage prdts imprimés - routage'),
(247240, 0, 0, 247, 247, 'TLEPRO', '2473220633.', 'TlePro façonnage prdts imprimés - routage'),
(247241, 0, 0, 247, 247, '2NDPRO', '2473220731.', '2ndPro réalis. prod. imprimés & plurimédia option A productions graphiques'),
(247242, 0, 0, 247, 247, '1ERPRO', '2473220732.', '1erPro réalis. prod. imprimés & plurimédia option A productions graphiques'),
(247243, 0, 0, 247, 247, 'TLEPRO', '2473220733.', 'TlePro réalis. prod. imprimés & plurimédia option A productions graphiques'),
(247244, 0, 0, 247, 247, '2NDPRO', '2473220831.', '2ndPro réalis. prod. imprimés & plurimédia option B productions imprimées'),
(247245, 0, 0, 247, 247, '1ERPRO', '2473220832.', '1erPro réalis. prod. imprimés & plurimédia option B productions imprimées'),
(247246, 0, 0, 247, 247, 'TLEPRO', '2473220833.', 'TlePro réalis. prod. imprimés & plurimédia option B productions imprimées'),
(247247, 0, 0, 247, 247, '2NDPRO', '2473230331.', '2ndPro artisanat et métiers d''art : com.vis.vis.pluri-m'),
(247248, 0, 0, 247, 247, '1ERPRO', '2473230332.', '1erPro artisanat et métiers d''art : com.vis.vis.pluri-m'),
(247249, 0, 0, 247, 247, 'TLEPRO', '2473230333.', 'TlePro artisanat et métiers d''art : com.vis.vis.pluri-m'),
(247250, 0, 0, 247, 247, '2NDPRO', '2473230431.', '2ndPro photographie'),
(247251, 0, 0, 247, 247, '1ERPRO', '2473230432.', '1erPro photographie'),
(247252, 0, 0, 247, 247, 'TLEPRO', '2473230433.', 'TlePro photographie'),
(247253, 0, 0, 247, 247, '2NDPRO', '2473300231.', '2ndPro services de proximité vie locale'),
(247254, 0, 0, 247, 247, '1ERPRO', '2473300232.', '1erPro services de proximité vie locale'),
(247255, 0, 0, 247, 247, 'TLEPRO', '2473300233.', 'TlePro services de proximité vie locale'),
(247256, 0, 0, 247, 247, '2NDPRO', '2473300331.', '2ndPro acc.soins-s.pers. option A domicile'),
(247257, 0, 0, 247, 247, '1ERPRO', '2473300332.', '1erPro acc.soins-s.pers. option A domicile'),
(247258, 0, 0, 247, 247, 'TLEPRO', '2473300333.', 'TlePro acc.soins-s.pers. option A domicile'),
(247259, 0, 0, 247, 247, '2NDPRO', '2473300431.', '2ndPro acc.soins-s.pers. opt.en structur'),
(247260, 0, 0, 247, 247, '1ERPRO', '2473300432.', '1erPro acc.soins-s.pers. opt.en structur'),
(247261, 0, 0, 247, 247, 'TLEPRO', '2473300433.', 'TlePro acc.soins-s.pers. opt.en structur'),
(247262, 0, 0, 247, 247, '2NDPRO', '2473310131.', '2ndPro optique lunetterie'),
(247263, 0, 0, 247, 247, '1ERPRO', '2473310132.', '1erPro optique lunetterie'),
(247264, 0, 0, 247, 247, 'TLEPRO', '2473310133.', 'TlePro optique lunetterie'),
(247265, 0, 0, 247, 247, '2NDPRO', '2473310231.', '2ndPro prothèse dentaire'),
(247266, 0, 0, 247, 247, '1ERPRO', '2473310232.', '1erPro prothèse dentaire'),
(247267, 0, 0, 247, 247, 'TLEPRO', '2473310233.', 'TlePro prothèse dentaire'),
(247268, 0, 0, 247, 247, '2NDPRO', '2473340331.', '2ndPro commerc. services en restauration'),
(247269, 0, 0, 247, 247, '1ERPRO', '2473340332.', '1erPro commerc. services en restauration'),
(247270, 0, 0, 247, 247, 'TLEPRO', '2473340333.', 'TlePro commerc. services en restauration'),
(247271, 0, 0, 247, 247, '2NDPRO', '2473360131.', '2ndPro esthétique cosmétique parfumerie'),
(247272, 0, 0, 247, 247, '1ERPRO', '2473360132.', '1erPro esthétique cosmétique parfumerie'),
(247273, 0, 0, 247, 247, 'TLEPRO', '2473360133.', 'TlePro esthétique cosmétique parfumerie'),
(247274, 0, 0, 247, 247, '2NDPRO', '2473360231.', '2ndPro perruquier posticheur'),
(247275, 0, 0, 247, 247, '1ERPRO', '2473360232.', '1erPro perruquier posticheur'),
(247276, 0, 0, 247, 247, 'TLEPRO', '2473360233.', 'TlePro perruquier posticheur'),
(247277, 0, 0, 247, 247, 'TLEPRO', '2473430233.', 'TlePro environnement nucléaire'),
(247278, 0, 0, 247, 247, '2NDPRO', '2473430331.', '2ndPro gestion des pollutions et protection de l''environnement'),
(247279, 0, 0, 247, 247, '1ERPRO', '2473430332.', '1erPro gestion des pollutions et protection de l''environnement'),
(247280, 0, 0, 247, 247, 'TLEPRO', '2473430333.', 'TlePro gestion des pollutions et protection de l''environnement'),
(247281, 0, 0, 247, 247, '2NDPRO', '2473430431.', '2ndPro hygiène, propreté, stérilisation'),
(247282, 0, 0, 247, 247, '1ERPRO', '2473430432.', '1erPro hygiène, propreté, stérilisation'),
(247283, 0, 0, 247, 247, 'TLEPRO', '2473430433.', 'TlePro hygiène, propreté sterilisation'),
(247284, 0, 0, 247, 247, '2NDPRO', '2473430531.', '2ndPro techniques d''interventions sur installations nucléaires'),
(247285, 0, 0, 247, 247, '1ERPRO', '2473430532.', '1erPro techniques d''interventions sur installations nucléaires'),
(247286, 0, 0, 247, 247, 'TLEPRO', '2473430533.', 'TlePro techniques d''interventions sur installations nucléaires'),
(247287, 0, 0, 247, 247, 'TLEPRO', '2473440233.', 'TlePro sécurité-prévention'),
(247288, 0, 0, 247, 247, '2NDPRO', '2473440331.', '2ndPro métiers de la sécurité'),
(247289, 0, 0, 247, 247, '1ERPRO', '2473440332.', '1erPro métiers de la sécurité'),
(247290, 0, 0, 247, 247, 'TLEPRO', '2473440333.', 'TlePro métiers de la sécurité'),
(247291, 0, 0, 247, 247, '2NDPRO', '2472230631.', '2ndPro artisanat et métiers d''art facteur d''orgues, 2nde commune'),
(247292, 0, 0, 247, 247, '2NDPRO', '2472240431.', '2ndPro artisanat et métiers d''art, 2nde commune'),
(247293, 0, 0, 247, 247, '2NDPRO', '2472300631.', '2ndPro technicien d''études du bâtiment, 2nde commune'),
(247294, 0, 0, 247, 247, '2NDPRO', '2472320931.', '2ndPro interventions sur le patrimoine bâti, 2nde commune'),
(247295, 0, 0, 247, 247, '1ERPRO', '2472430332.', '1erPro métiers du cuir : sellerie garnissage'),
(247296, 0, 0, 247, 247, 'TLEPRO', '2472430333.', 'TlePro métiers du cuir : sellerie garnissage'),
(247297, 0, 0, 247, 247, '2NDPRO', '2472430431.', '2ndPro métiers du cuir, 2nde commune'),
(247298, 0, 0, 247, 247, '2NDPRO', '2472521731.', '2ndPro maintenance des matériels, 2nde commune'),
(247299, 0, 0, 247, 247, '2NDPRO', '2472521831.', '2ndPro maintenance des véhicules, 2nde commune'),
(247300, 0, 0, 247, 247, '2NDPRO', '2472530631.', '2ndPro aéronautique, 2nde commune'),
(247301, 0, 0, 247, 247, '2NDPRO', '2472551031.', '2ndPro métiers de l''électricité et de ses environnements connectés'),
(247302, 0, 0, 247, 247, '1ERPRO', '2472551032.', '1erPro métiers de l''électricité et de ses environnements connectés'),
(247303, 0, 0, 247, 247, 'TLEPRO', '2472551033.', 'TlePro métiers de l''électricité et de ses environnements connectés'),
(247304, 0, 0, 247, 247, '1ERPRO', '2472551332.', '1erPro systèmes numériques option A sûreté sécurité infras. hab. tertiaire'),
(247305, 0, 0, 247, 247, 'TLEPRO', '2472551333.', 'TlePro systèmes numériques option A sûreté sécurité infras. hab. tertiaire'),
(247306, 0, 0, 247, 247, '1ERPRO', '2472551432.', '1erPro systèmes numériques option B audiovisuels réseau équip. domestiques'),
(247307, 0, 0, 247, 247, 'TLEPRO', '2472551433.', 'TlePro systèmes numériques option B audiovisuels réseau équip. domestiques'),
(247308, 0, 0, 247, 247, '1ERPRO', '2472551532.', '1erPro systèmes numériques option C réseaux inform. syst. communicants'),
(247309, 0, 0, 247, 247, 'TLEPRO', '2472551533.', 'TlePro systèmes numériques option C réseaux inform. syst. communicants'),
(247310, 0, 0, 247, 247, '2NDPRO', '2472551631.', '2ndPro systèmes numériques, 2nde commune'),
(247311, 0, 0, 247, 247, '2NDPRO', '2473220931.', '2ndPro réalisation de produits imprimés et plurimédia, 2nde commune'),
(247312, 0, 0, 247, 247, '2NDPRO', '2473300531.', '2ndPro accompagnement soins et services à la personne, 2nde commune'),
(247313, 0, 0, 247, 247, '2NDPRO', '2472551031.', '2ndPro technicien en appareillage orthopédique'),
(247314, 0, 0, 247, 247, '1ERPRO', '2472551032.', '1erPro technicien en appareillage orthopédique'),
(247315, 0, 0, 247, 247, 'TLEPRO', '2472551033.', 'TlePro technicien en appareillage orthopédique'),
(250000, 0, 1, 250, 250, '1BMA1', '250.....11.', 'BMA 1 an'),
(250001, 0, 0, 250, 250, '1BMA1', '2502231311.', '1BMA1 armurerie'),
(250002, 0, 0, 250, 250, '1BMA1', '2502231611.', '1BMA1 art bijou opt.bijout.joaillerie'),
(250003, 0, 0, 250, 250, '1BMA1', '2502231711.', '1BMA1 art bijou opt.bijout.sertissage'),
(250004, 0, 0, 250, 250, '1BMA1', '2502231811.', '1BMA1 art bijou opt.bijout.poliss.finit'),
(250005, 0, 0, 250, 250, '1BMA1', '2502231911.', '1BMA1 orfèvrerie option monture-tournure'),
(250006, 0, 0, 250, 250, '1BMA1', '2502240811.', '1BMA1 céramique'),
(250007, 0, 0, 250, 250, '1BMA1', '2502240911.', '1BMA1 verrier décorateur'),
(250008, 0, 0, 250, 250, '1BMA1', '2502241011.', '1BMA1 souffleur de verre'),
(250009, 0, 0, 250, 250, '1BMA1', '2502320111.', '1BMA1 gravure sur pierre'),
(250010, 0, 0, 250, 250, '1BMA1', '2502330111.', '1BMA1 volumes : staff matériaux associés'),
(250011, 0, 0, 250, 250, '1BMA1', '2502330211.', '1BMA1 graph.décor option A lettres décor'),
(250012, 0, 0, 250, 250, '1BMA1', '2502330311.', '1BMA1 graph.décor option B deco.surf.volum'),
(250013, 0, 0, 250, 250, '1BMA1', '2502340911.', '1BMA1 technc.factur.instr.op.accordéon'),
(250014, 0, 0, 250, 250, '1BMA1', '2502341011.', '1BMA1 technc.factur.instr.op.guitare'),
(250015, 0, 0, 250, 250, '1BMA1', '2502341111.', '1BMA1 technc.factur.instr.op.piano'),
(250016, 0, 0, 250, 250, '1BMA1', '2502341211.', '1BMA1 ébéniste'),
(250017, 0, 0, 250, 250, '1BMA1', '2502410611.', '1BMA1 arts tech.tapis tapisserie lisse'),
(250018, 0, 0, 250, 250, '1BMA1', '2502410711.', '1BMA1 arts de la dentelle opt.fuseaux'),
(250019, 0, 0, 250, 250, '1BMA1', '2502410811.', '1BMA1 arts de la dentelle opt.aiguilles'),
(250020, 0, 0, 250, 250, '1BMA1', '2502421011.', '1BMA1 broderie'),
(250021, 0, 0, 250, 250, '1BMA1', '2502510111.', '1BMA1 horlogerie'),
(250022, 0, 0, 250, 250, '1BMA1', '2502540111.', '1BMA1 technc.factur.instr.op.inst.vents'),
(250023, 0, 0, 250, 250, '1BMA1', '2502540211.', '1BMA1 ferronnier d''art (bma)'),
(250024, 0, 0, 250, 250, '1BMA1', '2503220611.', '1BMA1 arts de la reliure et dorure'),
(250025, 0, 0, 250, 250, '1BMA1', '2503220711.', '1BMA1 orfèvrerie option gravures-ciselure'),
(251001, 0, 1, 251, 251, '1BMA2', '251.....21.', 'BMA 2 ans, 1e année'),
(251002, 0, 1, 251, 251, '2BMA2', '251.....22.', 'BMA 2 ans, 2e année'),
(251003, 0, 0, 251, 251, '1BMA2', '2512231321.', '1BMA2 armurerie'),
(251004, 0, 0, 251, 251, '2BMA2', '2512231322.', '2BMA2 armurerie'),
(251005, 0, 0, 251, 251, '1BMA2', '2512231621.', '1BMA2 art bijou opt.bijout.joaillerie'),
(251006, 0, 0, 251, 251, '2BMA2', '2512231622.', '2BMA2 art bijou opt.bijout.joaillerie'),
(251007, 0, 0, 251, 251, '1BMA2', '2512231721.', '1BMA2 art bijou opt.bijout.sertissage'),
(251008, 0, 0, 251, 251, '2BMA2', '2512231722.', '2BMA2 art bijou opt.bijout.sertissage'),
(251009, 0, 0, 251, 251, '1BMA2', '2512231821.', '1BMA2 art bijou opt.bijout.poliss.finit'),
(251010, 0, 0, 251, 251, '2BMA2', '2512231822.', '2BMA2 art bijou opt.bijout.poliss.finit'),
(251011, 0, 0, 251, 251, '1BMA2', '2512231921.', '1BMA2 orfèvrerie option monture-tournure'),
(251012, 0, 0, 251, 251, '2BMA2', '2512231922.', '2BMA2 orfèvrerie option monture-tournure'),
(251013, 0, 0, 251, 251, '1BMA2', '2512240821.', '1BMA2 céramique'),
(251014, 0, 0, 251, 251, '2BMA2', '2512240822.', '2BMA2 céramique'),
(251015, 0, 0, 251, 251, '1BMA2', '2512240921.', '1BMA2 verrier décorateur'),
(251016, 0, 0, 251, 251, '2BMA2', '2512240922.', '2BMA2 verrier décorateur'),
(251017, 0, 0, 251, 251, '1BMA2', '2512241021.', '1BMA2 souffleur de verre'),
(251018, 0, 0, 251, 251, '2BMA2', '2512241022.', '2BMA2 souffleur de verre'),
(251019, 0, 0, 251, 251, '1BMA2', '2512320121.', '1BMA2 gravure sur pierre'),
(251020, 0, 0, 251, 251, '2BMA2', '2512320122.', '2BMA2 gravure sur pierre'),
(251021, 0, 0, 251, 251, '1BMA2', '2512330121.', '1BMA2 volumes : staff matériaux associés'),
(251022, 0, 0, 251, 251, '2BMA2', '2512330122.', '2BMA2 volumes : staff matériaux associés'),
(251023, 0, 0, 251, 251, '1BMA2', '2512330221.', '1BMA2 graph.décor option A lettres décor'),
(251024, 0, 0, 251, 251, '2BMA2', '2512330222.', '2BMA2 graph.décor option A lettres décor'),
(251025, 0, 0, 251, 251, '1BMA2', '2512330321.', '1BMA2 graph.décor option B deco.surf.volum'),
(251026, 0, 0, 251, 251, '2BMA2', '2512330322.', '2BMA2 graph.décor option B deco.surf.volum'),
(251027, 0, 0, 251, 251, '1BMA2', '2512340921.', '1BMA2 technc.factur.instr.op.accordéon');
INSERT INTO `sacoche_niveau` (`niveau_id`, `niveau_actif`, `niveau_usuel`, `niveau_famille_id`, `niveau_ordre`, `niveau_ref`, `code_mef`, `niveau_nom`) VALUES
(251028, 0, 0, 251, 251, '2BMA2', '2512340922.', '2BMA2 technc.factur.instr.op.accordéon'),
(251029, 0, 0, 251, 251, '1BMA2', '2512341021.', '1BMA2 technc.factur.instr.op.guitare'),
(251030, 0, 0, 251, 251, '2BMA2', '2512341022.', '2BMA2 technc.factur.instr.op.guitare'),
(251031, 0, 0, 251, 251, '1BMA2', '2512341121.', '1BMA2 technc.factur.instr.op.piano'),
(251032, 0, 0, 251, 251, '2BMA2', '2512341122.', '2BMA2 technc.factur.instr.op.piano'),
(251033, 0, 0, 251, 251, '1BMA2', '2512341221.', '1BMA2 ébéniste'),
(251034, 0, 0, 251, 251, '2BMA2', '2512341222.', '2BMA2 ébéniste'),
(251035, 0, 0, 251, 251, '1BMA2', '2512410621.', '1BMA2 arts tech.tapis tapisserie lisse'),
(251036, 0, 0, 251, 251, '2BMA2', '2512410622.', '2BMA2 arts tech.tapis tapisserie lisse'),
(251037, 0, 0, 251, 251, '1BMA2', '2512410721.', '1BMA2 arts de la dentelle opt.fuseaux'),
(251038, 0, 0, 251, 251, '2BMA2', '2512410722.', '2BMA2 arts de la dentelle opt.fuseaux'),
(251039, 0, 0, 251, 251, '1BMA2', '2512410821.', '1BMA2 arts de la dentelle opt.aiguilles'),
(251040, 0, 0, 251, 251, '2BMA2', '2512410822.', '2BMA2 arts de la dentelle opt.aiguilles'),
(251041, 0, 0, 251, 251, '1BMA2', '2512421021.', '1BMA2 broderie'),
(251042, 0, 0, 251, 251, '2BMA2', '2512421022.', '2BMA2 broderie'),
(251043, 0, 0, 251, 251, '1BMA2', '2512510121.', '1BMA2 horlogerie'),
(251044, 0, 0, 251, 251, '2BMA2', '2512510122.', '2BMA2 horlogerie'),
(251045, 0, 0, 251, 251, '1BMA2', '2512540121.', '1BMA2 technc.factur.instr.op.inst.vents'),
(251046, 0, 0, 251, 251, '2BMA2', '2512540122.', '2BMA2 technc.factur.instr.op.inst.vents'),
(251047, 0, 0, 251, 251, '1BMA2', '2512540221.', '1BMA2 ferronnier d''art (bma)'),
(251048, 0, 0, 251, 251, '2BMA2', '2512540222.', '2BMA2 ferronnier d''art (bma)'),
(251049, 0, 0, 251, 251, '1BMA2', '2513220621.', '1BMA2 arts de la reliure et dorure'),
(251050, 0, 0, 251, 251, '2BMA2', '2513220622.', '2BMA2 arts de la reliure et dorure'),
(251051, 0, 0, 251, 251, '1BMA2', '2513220721.', '1BMA2 orfèvrerie option gravures-ciselure'),
(251052, 0, 0, 251, 251, '2BMA2', '2513220722.', '2BMA2 orfèvrerie option gravures-ciselure'),
(253000, 0, 1, 253, 253, 'MC', '253.....11.', 'Mention complémentaire'),
(253001, 0, 0, 253, 253, 'MC', '2532200111.', 'MC agt control.non destructif (mc4)'),
(253002, 0, 0, 253, 253, 'MC', '2532210311.', 'MC employé traiteur (mc5)'),
(253003, 0, 0, 253, 253, 'MC', '2532210411.', 'MC patis.glace.choc.confis.sp. (mc5)'),
(253004, 0, 0, 253, 253, 'MC', '2532210511.', 'MC cuisinier desserts restau. (mc5)'),
(253005, 0, 0, 253, 253, 'MC', '2532210611.', 'MC vendeur spec. alimentat. (mc5)'),
(253006, 0, 0, 253, 253, 'MC', '2532210711.', 'MC boulangerie spécialisée (mc5)'),
(253007, 0, 0, 253, 253, 'MC', '2532210811.', 'MC patisserie boulangère (mc5)'),
(253008, 0, 0, 253, 253, 'MC', '2532210911.', 'MC art de la cuisine allégée'),
(253009, 0, 0, 253, 253, 'MC', '2532230411.', 'MC joaillerie (mc5)'),
(253010, 0, 0, 253, 253, 'MC', '2532240211.', 'MC graveur sur pierre (mc5)'),
(253011, 0, 0, 253, 253, 'MC', '2532240511.', 'MC conduct.machines verrerie (mc5)'),
(253012, 0, 0, 253, 253, 'MC', '2532270111.', 'MC maint.équipt thermiq.indiv. (mc5)'),
(253013, 0, 0, 253, 253, 'MC', '2532270311.', 'MC techn.des services énergie (mc4)'),
(253014, 0, 0, 253, 253, 'MC', '2532270411.', 'MC tech.En. Renouv. A én.électrique'),
(253015, 0, 0, 253, 253, 'MC', '2532270511.', 'MC tech.En. Renouv. A én.thermique'),
(253016, 0, 0, 253, 253, 'MC', '2532320211.', 'MC zinguerie (mc5)'),
(253017, 0, 0, 253, 253, 'MC', '2532330211.', 'MC plaquiste (mc5)'),
(253018, 0, 0, 253, 253, 'MC', '2532330411.', 'MC peinture décoration (mc4)'),
(253019, 0, 0, 253, 253, 'MC', '2532330611.', 'MC vendeur-conseil en produits techniques pour l''habitat (mc4)'),
(253020, 0, 0, 253, 253, 'MC', '2532340311.', 'MC parqueteur (mc5)'),
(253021, 0, 0, 253, 253, 'MC', '2532420111.', 'MC essayage-retouche-vente (mc5)'),
(253022, 0, 0, 253, 253, 'MC', '2532420211.', 'MC décors text. perm. ephem. (mc5)'),
(253023, 0, 0, 253, 253, 'MC', '2532430111.', 'MC piquage articles chaussants (mc5)'),
(253024, 0, 0, 253, 253, 'MC', '2532500211.', 'MC technic.ascensorist. serv.-modern'),
(253025, 0, 0, 253, 253, 'MC', '2532511811.', 'MC real.circuit oleohydr.pneum. (mc5)'),
(253026, 0, 0, 253, 253, 'MC', '2532512211.', 'MC maquettes et prototypes (mc4)'),
(253027, 0, 0, 253, 253, 'MC', '2532512311.', 'MC maint.inst.oleohydrau.pneum. (mc4)'),
(253028, 0, 0, 253, 253, 'MC', '2532520111.', 'MC techn.maint.vehicul.indust. (mc4)'),
(253029, 0, 0, 253, 253, 'MC', '2532520711.', 'MC maint.mot.diesel équipmts (mc5)'),
(253030, 0, 0, 253, 253, 'MC', '2532520811.', 'MC maintenance contrôle matériels'),
(253031, 0, 0, 253, 253, 'MC', '2532530811.', 'MC aéronautique option avions à moteurs à turbines (mc4)'),
(253032, 0, 0, 253, 253, 'MC', '2532530911.', 'MC aéronautique option avions à moteurs à pistons (mc4)'),
(253033, 0, 0, 253, 253, 'MC', '2532531011.', 'MC aéronautique option hélicoptères à moteurs à turbines (mc4)'),
(253034, 0, 0, 253, 253, 'MC', '2532531111.', 'MC aéronautique option hélicoptères à moteurs à pistons (mc4)'),
(253035, 0, 0, 253, 253, 'MC', '2532531211.', 'MC aéronautique option avionique (mc4)'),
(253036, 0, 0, 253, 253, 'MC', '2532540511.', 'MC soudage (mc5)'),
(253037, 0, 0, 253, 253, 'MC', '2532550711.', 'MC maint.syst.embarqués automobile (mc5)'),
(253038, 0, 0, 253, 253, 'MC', '2532550811.', 'MC Technicien(ne) en réseaux électriques (mc4)'),
(253039, 0, 0, 253, 253, 'MC', '2533110111.', 'MC accueil dans transports (mc4)'),
(253040, 0, 0, 253, 253, 'MC', '2533110211.', 'MC agent transport expl.ferrov. (mc4)'),
(253041, 0, 0, 253, 253, 'MC', '2533110311.', 'MC transporteur fluvial (mc5)'),
(253042, 0, 0, 253, 253, 'MC', '2533120111.', 'MC assist.conseil vent.distanc. (mc4)'),
(253043, 0, 0, 253, 253, 'MC', '2533130111.', 'MC services financiers (mc4)'),
(253044, 0, 0, 253, 253, 'MC', '2533300111.', 'MC aide a domicile (mc5)'),
(253045, 0, 0, 253, 253, 'MC', '2533341011.', 'MC sommellerie (mc5)'),
(253046, 0, 0, 253, 253, 'MC', '2533341111.', 'MC employé barman (mc5)'),
(253047, 0, 0, 253, 253, 'MC', '2533341211.', 'MC organisateur de réception'),
(253048, 0, 0, 253, 253, 'MC', '2533341311.', 'MC accueil-réception (mc4)'),
(253049, 0, 0, 253, 253, 'MC', '2533360511.', 'MC coiffure coupe couleur (mc5)'),
(253050, 0, 0, 253, 253, 'MC', '2533420111.', 'MC entret.collect. patrimoine (mc5)'),
(253051, 0, 0, 253, 253, 'MC', '2533440111.', 'MC sûreté espac.ouverts public (mc5)'),
(253052, 0, 0, 253, 253, 'MC', '2533440211.', 'MC secu.civile et d''entreprise (mc5)'),
(253053, 0, 0, 253, 253, 'MC', '2532500311.', 'MC mécatronique navale (mc4)'),
(253054, 0, 0, 253, 253, 'MC', '2532540611.', 'MC technicien(ne) en soudage'),
(254001, 0, 1, 254, 254, '1BP2', '254.....21.', 'Brevet Professionnel 2 ans, 1e année'),
(254002, 0, 1, 254, 254, '2BP2', '254.....22.', 'Brevet Professionnel 2 ans, 2e année'),
(254003, 0, 0, 254, 254, '1BP2', '2542010121.', '1BP2 pilote d''instal.prod.par procédés'),
(254004, 0, 0, 254, 254, '2BP2', '2542010122.', '2BP2 pilote d''instal.prod.par procédés'),
(254005, 0, 0, 254, 254, '1BP2', '2542200221.', '1BP2 tlr option A biologie'),
(254006, 0, 0, 254, 254, '2BP2', '2542200222.', '2BP2 tlr option A biologie'),
(254007, 0, 0, 254, 254, '1BP2', '2542200321.', '1BP2 tlr option B physicochimie'),
(254008, 0, 0, 254, 254, '2BP2', '2542200322.', '2BP2 tlr option B physicochimie'),
(254009, 0, 0, 254, 254, '2BP2', '2542210422.', '2BP2 cuisinier'),
(254010, 0, 0, 254, 254, '1BP2', '2542211021.', '1BP2 boucher'),
(254011, 0, 0, 254, 254, '2BP2', '2542211022.', '2BP2 boucher'),
(254012, 0, 0, 254, 254, '1BP2', '2542210721.', '1BP2 charcutier traiteur'),
(254013, 0, 0, 254, 254, '2BP2', '2542210722.', '2BP2 charcutier traiteur'),
(254014, 0, 0, 254, 254, '1BP2', '2542210821.', '1BP2 boulanger'),
(254015, 0, 0, 254, 254, '2BP2', '2542210822.', '2BP2 boulanger'),
(254016, 0, 0, 254, 254, '1BP2', '2542210921.', '1BP2 arts de la cuisine'),
(254017, 0, 0, 254, 254, '2BP2', '2542210922.', '2BP2 arts de la cuisine'),
(254018, 0, 0, 254, 254, '1BP2', '2542220221.', '1BP2 conducteur appareils ind.chimique'),
(254019, 0, 0, 254, 254, '2BP2', '2542220222.', '2BP2 conducteur appareils ind.chimique'),
(254020, 0, 0, 254, 254, '1BP2', '2542230621.', '1BP2 gemmologue'),
(254021, 0, 0, 254, 254, '2BP2', '2542230622.', '2BP2 gemmologue'),
(254022, 0, 0, 254, 254, '1BP2', '2542250121.', '1BP2 mise en œuvre caoutch.& elastom.'),
(254023, 0, 0, 254, 254, '2BP2', '2542250122.', '2BP2 mise en œuvre caoutch.& elastom.'),
(254024, 0, 0, 254, 254, '1BP2', '2542250221.', '1BP2 plastiques et composites'),
(254025, 0, 0, 254, 254, '2BP2', '2542250222.', '2BP2 plastiques et composites'),
(254026, 0, 0, 254, 254, '1BP2', '2542270421.', '1BP2 gaz op_a : transport du gaz'),
(254027, 0, 0, 254, 254, '2BP2', '2542270422.', '2BP2 gaz op_a : transport du gaz'),
(254028, 0, 0, 254, 254, '1BP2', '2542270521.', '1BP2 gaz op_b : distribution gaz'),
(254029, 0, 0, 254, 254, '2BP2', '2542270522.', '2BP2 gaz op_b : distribution gaz'),
(254030, 0, 0, 254, 254, '1BP2', '2542270921.', '1BP2 monteur en installations du génie climatique et sanitaire'),
(254031, 0, 0, 254, 254, '2BP2', '2542270922.', '2BP2 monteur en installations du génie climatique et sanitaire'),
(254032, 0, 0, 254, 254, '1BP2', '2542271021.', '1BP2 installateur, dépanneur en froid et conditionnement d''air'),
(254033, 0, 0, 254, 254, '2BP2', '2542271022.', '2BP2 installateur, dépanneur en froid et conditionnement d''air'),
(254034, 0, 0, 254, 254, '2BP2', '2542310322.', '2BP2 conducteur engins chantier t.p.'),
(254035, 0, 0, 254, 254, '1BP2', '2542310521.', '1BP2 conducteur d''engins : travaux publics et carrières'),
(254036, 0, 0, 254, 254, '2BP2', '2542310522.', '2BP2 conducteur d''engins : travaux publics et carrières'),
(254037, 0, 0, 254, 254, '1BP2', '2542320921.', '1BP2 métiers de la piscine'),
(254038, 0, 0, 254, 254, '2BP2', '2542320922.', '2BP2 métiers de la piscine'),
(254039, 0, 0, 254, 254, '2BP2', '2542321022.', '2BP2 métiers de la pierre'),
(254040, 0, 0, 254, 254, '2BP2', '2542321122.', '2BP2 couvreur'),
(254041, 0, 0, 254, 254, '1BP2', '2542321221.', '1BP2 maçon'),
(254042, 0, 0, 254, 254, '2BP2', '2542321222.', '2BP2 maçon'),
(254043, 0, 0, 254, 254, '1BP2', '2542321321.', '1BP2 couvreur'),
(254044, 0, 0, 254, 254, '2BP2', '2542321322.', '2BP2 couvreur'),
(254045, 0, 0, 254, 254, '1BP2', '2542321421.', '1BP2 métiers de la pierre'),
(254046, 0, 0, 254, 254, '2BP2', '2542321422.', '2BP2 métiers de la pierre'),
(254047, 0, 0, 254, 254, '1BP2', '2542330121.', '1BP2 étanchéité bâtiment & travaux publics'),
(254048, 0, 0, 254, 254, '2BP2', '2542330122.', '2BP2 étanchéité bâtiment & travaux publics'),
(254049, 0, 0, 254, 254, '1BP2', '2542330821.', '1BP2 carrelage mosaïque'),
(254050, 0, 0, 254, 254, '2BP2', '2542330822.', '2BP2 carrelage mosaïque'),
(254051, 0, 0, 254, 254, '1BP2', '2542331021.', '1BP2 plâtrerie-plaque'),
(254052, 0, 0, 254, 254, '2BP2', '2542331022.', '2BP2 plâtrerie-plaque'),
(254053, 0, 0, 254, 254, '1BP2', '2542331221.', '1BP2 peinture revêtements'),
(254054, 0, 0, 254, 254, '2BP2', '2542331222.', '2BP2 peinture revêtements'),
(254055, 0, 0, 254, 254, '1BP2', '2542331321.', '1BP2 menuisier aluminium-verre'),
(254056, 0, 0, 254, 254, '2BP2', '2542331322.', '2BP2 menuisier aluminium-verre'),
(254057, 0, 0, 254, 254, '1BP2', '2542340721.', '1BP2 charpentier de marine'),
(254058, 0, 0, 254, 254, '2BP2', '2542340722.', '2BP2 charpentier de marine'),
(254059, 0, 0, 254, 254, '1BP2', '2542340821.', '1BP2 menuisier'),
(254060, 0, 0, 254, 254, '2BP2', '2542340822.', '2BP2 menuisier'),
(254061, 0, 0, 254, 254, '1BP2', '2542340921.', '1BP2 charpentier bois'),
(254062, 0, 0, 254, 254, '2BP2', '2542340922.', '2BP2 charpentier bois'),
(254063, 0, 0, 254, 254, '1BP2', '2542400421.', '1BP2 blanchisseur (se)'),
(254064, 0, 0, 254, 254, '2BP2', '2542400422.', '2BP2 blanchisseur (se)'),
(254065, 0, 0, 254, 254, '1BP2', '2542400521.', '1BP2 maint.articl.textil. : pressing'),
(254066, 0, 0, 254, 254, '2BP2', '2542400522.', '2BP2 maint.articl.textil. : pressing'),
(254067, 0, 0, 254, 254, '1BP2', '2542410621.', '1BP2 ameublement : tapisserie décoration'),
(254068, 0, 0, 254, 254, '2BP2', '2542410622.', '2BP2 ameublement : tapisserie décoration'),
(254069, 0, 0, 254, 254, '1BP2', '2542421421.', '1BP2 vêtement sur mesure : couture flou'),
(254070, 0, 0, 254, 254, '2BP2', '2542421422.', '2BP2 vêtement sur mesure : couture flou'),
(254071, 0, 0, 254, 254, '1BP2', '2542421521.', '1BP2 vêtement sur mesure : tailleur dame'),
(254072, 0, 0, 254, 254, '2BP2', '2542421522.', '2BP2 vêtement sur mesure : tailleur dame'),
(254073, 0, 0, 254, 254, '1BP2', '2542421621.', '1BP2 vêtement sur mesure : tailleur homm'),
(254074, 0, 0, 254, 254, '2BP2', '2542421622.', '2BP2 vêtement sur mesure : tailleur homm'),
(254075, 0, 0, 254, 254, '1BP2', '2542541121.', '1BP2 métallier'),
(254076, 0, 0, 254, 254, '2BP2', '2542541122.', '2BP2 métallier'),
(254077, 0, 0, 254, 254, '1BP2', '2542551321.', '1BP2 installat. et équipmts électriq.'),
(254078, 0, 0, 254, 254, '2BP2', '2542551322.', '2BP2 installat. et équipmts électriq.'),
(254079, 0, 0, 254, 254, '1BP2', '2543100121.', '1BP2 administr.des fonctions publiques'),
(254080, 0, 0, 254, 254, '2BP2', '2543100122.', '2BP2 administr.des fonctions publiques'),
(254081, 0, 0, 254, 254, '1BP2', '2543120621.', '1BP2 fleuriste'),
(254082, 0, 0, 254, 254, '2BP2', '2543120622.', '2BP2 fleuriste'),
(254083, 0, 0, 254, 254, '1BP2', '2543130121.', '1BP2 banque'),
(254084, 0, 0, 254, 254, '2BP2', '2543130122.', '2BP2 banque'),
(254085, 0, 0, 254, 254, '1BP2', '2543130621.', '1BP2 assurances'),
(254086, 0, 0, 254, 254, '2BP2', '2543130622.', '2BP2 assurances'),
(254087, 0, 0, 254, 254, '1BP2', '2543130921.', '1BP2 professions immobilières'),
(254088, 0, 0, 254, 254, '2BP2', '2543130922.', '2BP2 professions immobilières'),
(254089, 0, 0, 254, 254, '1BP2', '2543220321.', '1BP2 libraire'),
(254090, 0, 0, 254, 254, '2BP2', '2543220322.', '2BP2 libraire'),
(254091, 0, 0, 254, 254, '1BP2', '2543240121.', '1BP2 bureautique'),
(254092, 0, 0, 254, 254, '2BP2', '2543240122.', '2BP2 bureautique'),
(254093, 0, 0, 254, 254, '1BP2', '2543310421.', '1BP2 préparateur en pharmacie'),
(254094, 0, 0, 254, 254, '2BP2', '2543310422.', '2BP2 préparateur en pharmacie'),
(254095, 0, 0, 254, 254, '1BP2', '2543340321.', '1BP2 barman'),
(254096, 0, 0, 254, 254, '2BP2', '2543340322.', '2BP2 barman'),
(254097, 0, 0, 254, 254, '1BP2', '2543340421.', '1BP2 gouvernante'),
(254098, 0, 0, 254, 254, '2BP2', '2543340422.', '2BP2 gouvernante'),
(254099, 0, 0, 254, 254, '1BP2', '2543340521.', '1BP2 sommelier'),
(254100, 0, 0, 254, 254, '2BP2', '2543340522.', '2BP2 sommelier'),
(254101, 0, 0, 254, 254, '2BP2', '2543340622.', '2BP2 restaurant'),
(254102, 0, 0, 254, 254, '1BP2', '2543340721.', '1BP2 arts du service et commercialisation en restauration'),
(254103, 0, 0, 254, 254, '2BP2', '2543340722.', '2BP2 arts du service et commercialisation en restauration'),
(254104, 0, 0, 254, 254, '1BP2', '2543360721.', '1BP2 esthétique cosmétique parfumerie'),
(254105, 0, 0, 254, 254, '2BP2', '2543360722.', '2BP2 esthétique cosmétique parfumerie'),
(254106, 0, 0, 254, 254, '1BP2', '2543360821.', '1BP2 coiffure'),
(254107, 0, 0, 254, 254, '2BP2', '2543360822.', '2BP2 coiffure'),
(254108, 0, 0, 254, 254, '1BP2', '2543440121.', '1BP2 agent techniq prévention & secur.'),
(254109, 0, 0, 254, 254, '2BP2', '2543440122.', '2BP2 agent techniq prévention & secur.'),
(254110, 0, 0, 254, 254, '1BP2', '2543440221.', '1BP2 agent techniq.sécurité transports'),
(254111, 0, 0, 254, 254, '2BP2', '2543440222.', '2BP2 agent techniq.sécurité transports'),
(271001, 0, 1, 271, 271, '2CAP2A', '271.....22.', 'CAP Agricole 2 ans, 1e année'),
(271002, 0, 1, 271, 271, '1CAP2A', '271.....21.', 'CAP Agricole 2 ans, 2e année'),
(271003, 0, 0, 271, 271, '2CAP2A', '2712100922.', '2CAP2a agriculture des régions chaudes'),
(271004, 0, 0, 271, 271, '1CAP2A', '2712101021.', '1CAP2a agriculture des régions chaudes'),
(271005, 0, 0, 271, 271, '2CAP2A', '2712101022.', '2CAP2a agriculture des régions chaudes'),
(271006, 0, 0, 271, 271, '2CAP2A', '2712111522.', '2CAP2a vigne et vin'),
(271007, 0, 0, 271, 271, '2CAP2A', '2712111722.', '2CAP2a prod-horticole florale légumière'),
(271008, 0, 0, 271, 271, '2CAP2A', '2712112022.', '2CAP2a prod-horticoles pépinière'),
(271009, 0, 0, 271, 271, '2CAP2A', '2712112222.', '2CAP2a prod-horticoles fruitières'),
(271010, 0, 0, 271, 271, '2CAP2A', '2712112922.', '2CAP2a prod agri matériels prod végétale'),
(271011, 0, 0, 271, 271, '1CAP2A', '2712113021.', '1CAP2a métiers de l''agriculture'),
(271012, 0, 0, 271, 271, '2CAP2A', '2712113022.', '2CAP2a métiers de l''agriculture'),
(271013, 0, 0, 271, 271, '1CAP2A', '2712121321.', '1CAP2a productions aquacoles bpam'),
(271014, 0, 0, 271, 271, '2CAP2A', '2712121322.', '2CAP2a productions aquacoles bpam'),
(271015, 0, 0, 271, 271, '2CAP2A', '2712121922.', '2CAP2a maréchalerie'),
(271016, 0, 0, 271, 271, '1CAP2A', '2712122921.', '1CAP2a maritime et conchylicole'),
(271017, 0, 0, 271, 271, '2CAP2A', '2712122922.', '2CAP2a maritime et conchylicole'),
(271018, 0, 0, 271, 271, '2CAP2A', '2712123022.', '2CAP2a prod agri matériels prod animale'),
(271019, 0, 0, 271, 271, '1CAP2A', '2712123121.', '1CAP2a soigneur d''équidés'),
(271020, 0, 0, 271, 271, '2CAP2A', '2712123122.', '2CAP2a soigneur d''équidés'),
(271021, 0, 0, 271, 271, '2CAP2A', '2712123422.', '2CAP2a lad cavalier d''entraînement'),
(271022, 0, 0, 271, 271, '1CAP2A', '2712123521.', '1CAP2a lad cavalier d''entraînement'),
(271023, 0, 0, 271, 271, '2CAP2A', '2712123522.', '2CAP2a lad cavalier d''entraînement'),
(271024, 0, 0, 271, 271, '1CAP2A', '2712123621.', '1CAP2a maréchal ferrant'),
(271025, 0, 0, 271, 271, '2CAP2A', '2712123622.', '2CAP2a maréchal ferrant'),
(271026, 0, 0, 271, 271, '1CAP2A', '2712131021.', '1CAP2a entretien espace rural'),
(271027, 0, 0, 271, 271, '2CAP2A', '2712131022.', '2CAP2a entretien espace rural'),
(271028, 0, 0, 271, 271, '2CAP2A', '2712131222.', '2CAP2a travaux forestiers bûcheronnage'),
(271029, 0, 0, 271, 271, '2CAP2A', '2712131322.', '2CAP2a travaux forestiers sylviculture'),
(271030, 0, 0, 271, 271, '1CAP2A', '2712131421.', '1CAP2a travaux forestiers'),
(271031, 0, 0, 271, 271, '2CAP2A', '2712131422.', '2CAP2a travaux forestiers'),
(271032, 0, 0, 271, 271, '2CAP2A', '2712140322.', '2CAP2a travaux paysagers'),
(271033, 0, 0, 271, 271, '1CAP2A', '2712140521.', '1CAP2a travaux paysagers'),
(271034, 0, 0, 271, 271, '2CAP2A', '2712140522.', '2CAP2a travaux paysagers'),
(271035, 0, 0, 271, 271, '2CAP2A', '2713300222.', '2CAP2a services en milieu rural'),
(271036, 0, 0, 271, 271, '1CAP2A', '2713300321.', '1CAP2a services aux personnes et vente en espace rural'),
(271037, 0, 0, 271, 271, '2CAP2A', '2713300322.', '2CAP2a services aux personnes et vente en espace rural'),
(271038, 0, 0, 271, 271, '1CAP2A', '2712123721.', '1CAP2a palefrenier soigneur'),
(271039, 0, 0, 271, 271, '2CAP2A', '2712123722.', '2CAP2a palefrenier soigneur'),
(276001, 0, 1, 276, 276, '2DPROA', '276.....31.', 'Bac Pro Agricole, seconde'),
(276002, 0, 1, 276, 276, '1EPROA', '276.....32.', 'Bac Pro Agricole, première'),
(276003, 0, 1, 276, 276, 'TLPROA', '276.....33.', 'Bac Pro Agricole, terminale'),
(276004, 0, 0, 276, 276, '1EPROA', '2762100132.', '1eProA agro-équipement'),
(276005, 0, 0, 276, 276, 'TLPROA', '2762100133.', 'TlProA agro-équipement'),
(276006, 0, 0, 276, 276, '1EPROA', '2762110832.', '1eProA cgea syst dominante cultures'),
(276007, 0, 0, 276, 276, 'TLPROA', '2762110833.', 'TlProA cgea syst dominante cultures'),
(276008, 0, 0, 276, 276, '1EPROA', '2762110932.', '1eProA cgea vigne et vin'),
(276009, 0, 0, 276, 276, 'TLPROA', '2762110933.', 'TlProA cgea vigne et vin'),
(276010, 0, 0, 276, 276, '2DPROA', '2762111031.', '2dProA productions végétales agroéquip'),
(276011, 0, 0, 276, 276, '1EPROA', '2762111132.', '1eProA productions horticoles'),
(276012, 0, 0, 276, 276, 'TLPROA', '2762111133.', 'Tlproa productions horticoles'),
(276013, 0, 0, 276, 276, '1EPROA', '2762120332.', '1eProA tech conseil vente en animalerie'),
(276014, 0, 0, 276, 276, 'TLPROA', '2762120333.', 'Tlproa tech conseil vente en animalerie'),
(276015, 0, 0, 276, 276, '1EPROA', '2762120432.', '1eProA prod-aquacoles'),
(276016, 0, 0, 276, 276, 'TLPROA', '2762120433.', 'TlProA prod-aquacoles'),
(276017, 0, 0, 276, 276, '1EPROA', '2762120732.', '1eProA cgea syst dominante élevage'),
(276018, 0, 0, 276, 276, 'TLPROA', '2762120733.', 'TlProA cgea syst dominante élevage'),
(276019, 0, 0, 276, 276, '2DPROA', '2762120831.', '2dProA productions animales'),
(276020, 0, 0, 276, 276, '2DPROA', '2762120931.', '2dProA technicien en expérimentation animale'),
(276021, 0, 0, 276, 276, '1EPROA', '2762121032.', '1eProA cdte-gest d''une entreprise du secteur canin et félin'),
(276022, 0, 0, 276, 276, 'TLPROA', '2762121033.', 'Tlproa cdte-gest d''une entreprise du secteur canin et félin'),
(276023, 0, 0, 276, 276, '1EPROA', '2762121132.', '1eProA cg entreprise hippique'),
(276024, 0, 0, 276, 276, 'TLPROA', '2762121133.', 'TlProA cg entreprise hippique'),
(276025, 0, 0, 276, 276, '1EPROA', '2762121232.', '1eProA technicien en expérimentation animale'),
(276026, 0, 0, 276, 276, 'TLPROA', '2762121233.', 'TlProA technicien en expérimentation animale'),
(276027, 0, 0, 276, 276, '1EPROA', '2762130232.', '1eProA gestion des milieux naturels et de la faune'),
(276028, 0, 0, 276, 276, 'TLPROA', '2762130233.', 'TlProA gestion des milieux naturels et de la faune'),
(276029, 0, 0, 276, 276, '1EPROA', '2762130332.', '1eProA forêt'),
(276030, 0, 0, 276, 276, 'TLPROA', '2762130333.', 'TlProA forêt'),
(276031, 0, 0, 276, 276, '2DPROA', '2762140431.', '2dProA nature jardin paysage forêt'),
(276032, 0, 0, 276, 276, '1EPROA', '2762140532.', '1eProA aménagements paysagers'),
(276033, 0, 0, 276, 276, 'TLPROA', '2762140533.', 'TlProA aménagements paysagers'),
(276034, 0, 0, 276, 276, '1EPROA', '2762140632.', '1eProA technicien conseil vente en produits de jardin'),
(276035, 0, 0, 276, 276, 'TLPROA', '2762140633.', 'Tlproa technicien conseil vente en produits de jardin'),
(276036, 0, 0, 276, 276, '2DPROA', '2762210331.', '2dProA conseil vente'),
(276037, 0, 0, 276, 276, '2DPROA', '2762210431.', '2dProA alimentation bio-industries labo'),
(276038, 0, 0, 276, 276, '1EPROA', '2762210532.', '1eProA laboratoire contrôle qualité'),
(276039, 0, 0, 276, 276, 'TLPROA', '2762210533.', 'TlProA laboratoire contrôle qualité'),
(276040, 0, 0, 276, 276, '1EPROA', '2762210632.', '1eProA technicien conseil vente en alimentation vins spiritueux'),
(276041, 0, 0, 276, 276, 'TLPROA', '2762210633.', 'Tlproa technicien conseil vente en alimentation vins spiritueux'),
(276042, 0, 0, 276, 276, '1EPROA', '2762210732.', '1eProA technicien conseil vente en alimentation produits alimentaires'),
(276043, 0, 0, 276, 276, 'TLPROA', '2762210733.', 'Tlproa technicien conseil vente en alimentation produits alimentaires'),
(276044, 0, 0, 276, 276, '2DPROA', '2763300131.', '2dProA service aux personnes et aux territoires'),
(276045, 0, 0, 276, 276, '1EPROA', '2763300232.', '1eProA service aux personnes et aux territoires'),
(276046, 0, 0, 276, 276, 'TLPROA', '2763300233.', 'TlProA service aux personnes et aux territoires'),
(276047, 0, 0, 276, 276, '2DPROA', '2769999931.', '2dProA sans spécialité définie'),
(276048, 0, 0, 276, 276, '2DPROA', '2762111231.', '2dProA agricole productions'),
(290001, 0, 0, 290, 290, '1PD4', '2902009911.', '1PD4-1 techno.industriell.fondamentales'),
(290002, 0, 0, 290, 290, '1PD4', '2902109911.', '1PD4-1 spec.pluriv.de l''agronomie agric.'),
(290003, 0, 0, 290, 290, '1PD4', '2902209911.', '1PD4-1 spec.pluritechno des transformat.'),
(290004, 0, 0, 290, 290, '1PD4', '2902309911.', '1PD4-1 spec.pluritechno, génie civil, ..'),
(290005, 0, 0, 290, 290, '1PD4', '2902409911.', '1PD4-1 spec.pluritechno matériaux soupl.'),
(290006, 0, 0, 290, 290, '1PD4', '2902509911.', '1PD4-1 spec.pluritechno mecan.-électric.'),
(290007, 0, 0, 290, 290, '1PD4', '2903009911.', '1PD4-1 spec.plurivalentes des services'),
(290008, 0, 0, 290, 290, '1PD4', '2903109911.', '1PD4-1 spec.plurival.echanges & gestion'),
(290009, 0, 0, 290, 290, '1PD4', '2903209911.', '1PD4-1 spec.plurival.de la communication'),
(290010, 0, 0, 290, 290, '1PD4', '2903309911.', '1PD4-1 spec.pluriv.sanitaires & sociales'),
(290011, 0, 0, 290, 290, '1PD4', '2903409911.', '1PD4-1 spec.pluriv.services à la collect'),
(291001, 0, 0, 290, 291, 'MONI1', '2913320221.', 'Moniteur éducateur : 1ere année'),
(291002, 0, 0, 290, 291, 'MONI2', '2913320222.', 'Moniteur éducateur : 2eme année'),
(291003, 0, 0, 290, 291, '1PD4', '2913320321.', '1PD4-2 tec interv soc et fam'),
(291004, 0, 0, 290, 291, '2PD4', '2913320322.', '2PD4-2 tec interv soc et fam'),
(293001, 0, 0, 290, 293, 'SOIGN', '2933310211.', 'Aide soignant'),
(293002, 0, 0, 290, 293, 'AUXPUE', '2933310311.', 'Auxiliaire de puériculture'),
(293003, 0, 0, 290, 293, '1PD5', '2933320111.', '1PD5-1 auxiliaire vie sociale'),
(293004, 0, 0, 290, 293, 'AIDEMP', '2933320211.', 'Aide médico psychologique (dip d''état)'),
(293005, 0, 0, 290, 293, '1PD5', '2933320411.', '1PD5-1 Accompagnant éducatif et social accompagnement de la vie à domicile'),
(293006, 0, 0, 290, 293, '1PD5', '2933320511.', '1PD5-1 Accompagnant éducatif et social Accomp. vie en structure collective'),
(293007, 0, 0, 290, 293, '1PD5', '2933320611.', '1PD5-1 Accompagnant éducatif et social éducation inclusive & vie ordinaire'),
(318001, 0, 0, 290, 318, 'DCESF', '3183320511.', 'DCESF conseiller eco.sociale & familial'),
(320001, 0, 0, 290, 320, 'CM-NIV', '3202000111.', 'Mise à niveau BTS DMA arts appliqués'),
(320002, 0, 0, 290, 320, 'CM-NIV', '3202551711.', 'Mise à niveau BTS maintenance des systèmes électro-navals'),
(320003, 0, 0, 290, 320, 'CM-NIV', '3203340511.', 'Mise à niveau STS hôtel.restaur.'),
(330001, 0, 0, 290, 330, 'DNTS', '3302270211.', 'DNTS maintenance nucléaire'),
(300001, 0, 0, 301, 300, 'CPES1', '3001000411.', 'CPES1 classe prépa. études supérieures'),
(300002, 0, 0, 301, 300, 'MARINE', '3001101611.', 'CPGE marine marchande'),
(301001, 0, 0, 301, 301, '1MPSI', '3011101821.', 'CPGE1 MPSI (math.phys sc.ingénieur)'),
(301002, 0, 0, 301, 301, '1PCSI', '3011101921.', 'CPGE1 PCSI (phys.chim.sci.ingen.)'),
(301003, 0, 0, 301, 301, '1PTSI', '3011102021.', 'CPGE1 PTSI (phys.techn.sci.ingen.)'),
(301004, 0, 0, 301, 301, '1BCPST', '3011102121.', 'CPGE1 BCPST (bio.chi.phys.sc terre)'),
(301005, 0, 0, 301, 301, '2BCPST', '3011102122.', 'CPGE2 BCPST (bio.chim.phys.sc terre)'),
(301006, 0, 0, 301, 301, '1TSI', '3011102221.', 'CPGE1 TSI (techno et sci indust.)'),
(301007, 0, 0, 301, 301, '2TSI', '3011102222.', 'CPGE2 TSI (techno et sci industriell.)'),
(301008, 0, 0, 301, 301, '1TPC', '3011102321.', 'CPGE1 TPC (techno physique chimie)'),
(301009, 0, 0, 301, 301, '2TPC', '3011102322.', 'CPGE2 TPC (techno physique chimie)'),
(301010, 0, 0, 301, 301, '1TB', '3011102521.', 'CPGE1 TB (techno et biologie)'),
(301011, 0, 0, 301, 301, '2TB', '3011102522.', 'CPGE2 TB (techno et biologie)'),
(301012, 0, 0, 301, 301, '2MP', '3011102722.', 'CPGE2 MP (mathématiques et physique)'),
(301013, 0, 0, 301, 301, '2PC', '3011102822.', 'CPGE2 PC (physique et chimie)'),
(301014, 0, 0, 301, 301, '2PSI', '3011102922.', 'CPGE2 PSI (physique et sc. ingénieur)'),
(301015, 0, 0, 301, 301, '2PT', '3011103022.', 'CPGE2 PT (physique et technologie)'),
(301016, 0, 0, 301, 301, '2MP*', '3011103122.', 'CPGE2 MP * (mathematique et physique)'),
(301017, 0, 0, 301, 301, '2PC*', '3011103222.', 'CPGE2 PC * (physique et chimie)'),
(301018, 0, 0, 301, 301, '2PSI*', '3011103322.', 'CPGE2 PSI * (physique et sc. ingénieur)'),
(301019, 0, 0, 301, 301, '2PT*', '3011103422.', 'CPGE2 PT * (physique et technologie)'),
(301020, 0, 0, 301, 301, 'CPGE-A', '3011103522.', 'CPGE2 agri post bts btsa dut'),
(301021, 0, 0, 301, 301, '1CAC-C', '3011103921.', 'CPGE1 ENS Cachan section C arts et design'),
(301022, 0, 0, 301, 301, '2CAC-C', '3011103922.', 'CPGE2 ENS Cachan section C arts et design'),
(301023, 0, 0, 301, 301, 'ATSINI', '3011104022.', 'CPGE ATS ingénierie industrielle'),
(301024, 0, 0, 301, 301, 'ATSGEC', '3011104122.', 'CPGE ATS génie civil'),
(301025, 0, 0, 301, 301, 'ATSMCH', '3011104222.', 'CPGE ATS métiers de la chimie'),
(301026, 0, 0, 301, 301, 'ATSBIO', '3011104322.', 'CPGE ATS biologie'),
(301027, 0, 0, 301, 301, '1CA-D1', '3011200121.', 'CPGE1 ENS cachan section_d1'),
(301028, 0, 0, 301, 301, '2CA-D1', '3011200122.', 'CPGE2 ENS cachan section_d1'),
(301029, 0, 0, 301, 301, '1CA-D2', '3011200221.', 'CPGE1 ENS cachan section_d2'),
(301030, 0, 0, 301, 301, '2CA-D2', '3011200222.', 'CPGE2 ENS cachan section_d2'),
(301031, 0, 0, 301, 301, '1HEC-T', '3011200621.', 'CPGE1 eco.et commerc. opt technologique'),
(301032, 0, 0, 301, 301, '2HEC-T', '3011200622.', 'CPGE2 eco.et commerc. opt technologique'),
(301033, 0, 0, 301, 301, 'CA-D2', '3011201022.', 'CPGE ENS cachan section_d2 en 1 an'),
(301034, 0, 0, 301, 301, 'CA-D1', '3011201122.', 'CPGE ENS cachan section_d1 en 1 an'),
(301035, 0, 0, 301, 301, '1HEC-S', '3011201221.', 'CPGE1 eco.et commerc. opt scientifique'),
(301036, 0, 0, 301, 301, '2HEC-S', '3011201222.', 'CPGE2 eco.et commerc. opt scientifique'),
(301037, 0, 0, 301, 301, '1HEC-E', '3011201321.', 'CPGE1 eco.et commerc. opt économique'),
(301038, 0, 0, 301, 301, '2HEC-E', '3011201322.', 'CPGE2 eco.et commerc. opt économique'),
(301039, 0, 0, 301, 301, 'ATSECG', '3011201622.', 'CPGE ATS économie-gestion'),
(301040, 0, 0, 301, 301, '1LETSS', '3011300121.', 'CPGE1 lettres et sciences sociales 1e an'),
(301041, 0, 0, 301, 301, '2LSUPB', '3011300122.', 'CPGE2 lettres et sciences sociales 2e an'),
(301042, 0, 0, 301, 301, '1CHART', '3011300221.', 'CPGE1 école natio. Chartes 1e année'),
(301043, 0, 0, 301, 301, '2CHART', '3011300222.', 'CPGE2 école natio. Chartes 2e année'),
(301044, 0, 0, 301, 301, '1STCYR', '3011300321.', 'CPGE1 école spe mili St Cyr 1e an'),
(301045, 0, 0, 301, 301, '2STCYR', '3011300322.', 'CPGE2 école spe mili St Cyr 2e an'),
(301046, 0, 0, 301, 301, '1LETTR', '3011300421.', 'CPGE1 lettres 1ere année'),
(301047, 0, 0, 301, 301, '2LETTR', '3011300522.', 'CPGE2 lettres ENS 2e année'),
(301048, 0, 0, 301, 301, '2FONCL', '3011300622.', 'CPGE2 lettres ENS Fontenay St Cloud'),
(310000, 0, 1, 310, 310, '1BTS1', '310.....11.', 'BTS 1 an'),
(310001, 0, 0, 310, 310, '1BTS1', '3102000911.', '1BTS1 conception des produits industriels'),
(310002, 0, 0, 310, 310, '1BTS1', '3102000711.', '1BTS1 design de produits'),
(310003, 0, 0, 310, 310, '1BTS1', '3102000811.', '1BTS1 technico-commercial'),
(310004, 0, 0, 310, 310, '1BTS1', '3102011311.', '1BTS1 contrôle industriel et régulation automatique'),
(310005, 0, 0, 310, 310, '1BTS1', '3102011111.', '1BTS1 concept.et real.syst.automatiques'),
(310006, 0, 0, 310, 310, '1BTS1', '3102011211.', '1BTS1 systèmes numériques option A informatique et réseaux'),
(310007, 0, 0, 310, 310, '1BTS1', '3102200211.', '1BTS1 techniq.physiq.pour indust.& labo'),
(310008, 0, 0, 310, 310, '1BTS1', '3102210311.', '1BTS1 qualit.ds indus.alim.& bio-indus'),
(310009, 0, 0, 310, 310, '1BTS1', '3102210411.', '1BTS1 biotechnologies'),
(310010, 0, 0, 310, 310, '1BTS1', '3102220411.', '1BTS1 peintures encres et adhésifs'),
(310011, 0, 0, 310, 310, '1BTS1', '3102220611.', '1BTS1 chimiste'),
(310012, 0, 0, 310, 310, '1BTS1', '3102220711.', '1BTS1 bioanalyses et contrôle (bts)'),
(310013, 0, 0, 310, 310, '1BTS1', '3102230711.', '1BTS1 etud. real.outillag.m.e.f. materx'),
(310014, 0, 0, 310, 310, '1BTS1', '3102231111.', '1BTS1 traitm.materx op_a : trait.thermiq'),
(310015, 0, 0, 310, 310, '1BTS1', '3102231211.', '1BTS1 traitm.materx op_b : trait.surface'),
(310016, 0, 0, 310, 310, '1BTS1', '3102231411.', '1BTS1 fonderie'),
(310017, 0, 0, 310, 310, '1BTS1', '3102240411.', '1BTS1 industries céramiques'),
(310018, 0, 0, 310, 310, '1BTS1', '3102240511.', '1BTS1 concepteur art & indus.céramiq.'),
(310019, 0, 0, 310, 310, '1BTS1', '3102250411.', '1BTS1 industries plastiques europlastic'),
(310020, 0, 0, 310, 310, '1BTS1', '3102260211.', '1BTS1 ind.pap. : prodct.pates pap.cartons'),
(310021, 0, 0, 310, 310, '1BTS1', '3102260311.', '1BTS1 ind.pap. : transform.papier-carton'),
(310022, 0, 0, 310, 310, '1BTS1', '3102270411.', '1BTS1 ctrl.rayonmt.ionisants protection'),
(310023, 0, 0, 310, 310, '1BTS1', '3102270911.', '1BTS1 fluides-énergies-domotique option A génie climatiq. et fluidiq.'),
(310024, 0, 0, 310, 310, '1BTS1', '3102271011.', '1BTS1 fluides-énergies-domotique option B froid et conditionn. d''air'),
(310025, 0, 0, 310, 310, '1BTS1', '3102271111.', '1BTS1 fluides-énergies-domotique option C domotique et bat. communic.'),
(310026, 0, 0, 310, 310, '1BTS1', '3102301011.', '1BTS1 études et économie construction'),
(310027, 0, 0, 310, 310, '1BTS1', '3102301111.', '1BTS1 design d''espace'),
(310028, 0, 0, 310, 310, '1BTS1', '3102301211.', '1BTS1 bâtiment'),
(310029, 0, 0, 310, 310, '1BTS1', '3102310311.', '1BTS1 géologie appliquée'),
(310030, 0, 0, 310, 310, '1BTS1', '3102310811.', '1BTS1 métiers du géomètre-topographe et de la modélisation numérique'),
(310031, 0, 0, 310, 310, '1BTS1', '3102310711.', '1BTS1 travaux publics'),
(310032, 0, 0, 310, 310, '1BTS1', '3102320511.', '1BTS1 enveloppe des bâtiments : conception et réalisation'),
(310033, 0, 0, 310, 310, '1BTS1', '3102330511.', '1BTS1 étude et réalisation d''agencement'),
(310034, 0, 0, 310, 310, '1BTS1', '3102330411.', '1BTS1 aménagement finition'),
(310035, 0, 0, 310, 310, '1BTS1', '3102341111.', '1BTS1 développement et réalisation bois'),
(310036, 0, 0, 310, 310, '1BTS1', '3102341211.', '1BTS1 systèmes constructifs bois et habitat'),
(310037, 0, 0, 310, 310, '1BTS1', '3102411011.', '1BTS1 des.mod.text.env. op.b text.m.sur'),
(310038, 0, 0, 310, 310, '1BTS1', '3102411111.', '1BTS1 innovation textile option A structures'),
(310039, 0, 0, 310, 310, '1BTS1', '3102411211.', '1BTS1 innovation textile option B traitements'),
(310040, 0, 0, 310, 310, '1BTS1', '3102420611.', '1BTS1 des.mod.text.env. op.a mode'),
(310041, 0, 0, 310, 310, '1BTS1', '3102420711.', '1BTS1 métiers de la mode-vêtements'),
(310042, 0, 0, 310, 310, '1BTS1', '3102430211.', '1BTS1 ind.cuir op_1 : tannerie mégisserie'),
(310043, 0, 0, 310, 310, '1BTS1', '3102430511.', '1BTS1 métiers mode-chaussure maroquiner'),
(310044, 0, 0, 310, 310, '1BTS1', '3102500111.', '1BTS1 assistance technique d''ingénieur'),
(310045, 0, 0, 310, 310, '1BTS1', '3102500511.', '1BTS1 concept. indust. microtechniques'),
(310046, 0, 0, 310, 310, '1BTS1', '3102500611.', '1BTS1 industrialis. produits mécaniques'),
(310047, 0, 0, 310, 310, '1BTS1', '3102500711.', '1BTS1 maintenance des systèmes option A systèmes de production'),
(310048, 0, 0, 310, 310, '1BTS1', '3102500811.', '1BTS1 maintenance des systèmes option B syst. énergétiques & fluidiques'),
(310049, 0, 0, 310, 310, '1BTS1', '3102500911.', '1BTS1 maintenance des systèmes option C systèmes éoliens'),
(310050, 0, 0, 310, 310, '1BTS1', '3102521411.', '1BTS1 moteurs à combustion interne'),
(310051, 0, 0, 310, 310, '1BTS1', '3102520911.', '1BTS1 maint. a-v. engins tp manutention'),
(310052, 0, 0, 310, 310, '1BTS1', '3102521011.', '1BTS1 av auto. opt.véhic. particuliers'),
(310053, 0, 0, 310, 310, '1BTS1', '3102521111.', '1BTS1 av auto. opt.véhic. industriels'),
(310054, 0, 0, 310, 310, '1BTS1', '3102521211.', '1BTS1 av auto. opt.motocycles'),
(310055, 0, 0, 310, 310, '1BTS1', '3102521311.', '1BTS1 techniques et services en matériels agricoles'),
(310056, 0, 0, 310, 310, '1BTS1', '3102530211.', '1BTS1 aéronautique'),
(310057, 0, 0, 310, 310, '1BTS1', '3102540211.', '1BTS1 construction navale'),
(310058, 0, 0, 310, 310, '1BTS1', '3102540811.', '1BTS1 constructions métalliques'),
(310059, 0, 0, 310, 310, '1BTS1', '3102540911.', '1BTS1 mise en forme materx par forgeage'),
(310060, 0, 0, 310, 310, '1BTS1', '3102541011.', '1BTS1 concept.& real.chaudronnerie ind.'),
(310061, 0, 0, 310, 310, '1BTS1', '3102541111.', '1BTS1 conception et réalisation de carrosserie'),
(310062, 0, 0, 310, 310, '1BTS1', '3102551111.', '1BTS1 génie optique : photonique'),
(310063, 0, 0, 310, 310, '1BTS1', '3102551211.', '1BTS1 génie optique : optiq.instrumentale'),
(310064, 0, 0, 310, 310, '1BTS1', '3102551511.', '1BTS1 électrotechnique'),
(310065, 0, 0, 310, 310, '1BTS1', '3102551611.', '1BTS1 systèmes numériques option B électronique et communications'),
(310066, 0, 0, 310, 310, '1BTS1', '3102551811.', '1BTS1 maintenance des systèmes électro-navals'),
(310067, 0, 0, 310, 310, '1BTS1', '3102551911.', '1BTS1 systèmes photoniques'),
(310068, 0, 0, 310, 310, '1BTS1', '3103110211.', '1BTS1 transport et prestat. logistiques'),
(310069, 0, 0, 310, 310, '1BTS1', '3103120911.', '1BTS1 management unités commerciales'),
(310070, 0, 0, 310, 310, '1BTS1', '3103121011.', '1BTS1 négociation et relation client'),
(310071, 0, 0, 310, 310, '1BTS1', '3103121111.', '1BTS1 commerce internatio. ref.europeen'),
(310072, 0, 0, 310, 310, '1BTS1', '3103130711.', '1BTS1 assurance'),
(310073, 0, 0, 310, 310, '1BTS1', '3103130911.', '1BTS1 professions immobilières'),
(310074, 0, 0, 310, 310, '1BTS1', '3103131011.', '1BTS1 banque, conseiller de clientèle (particuliers)'),
(310075, 0, 0, 310, 310, '1BTS1', '3103140611.', '1BTS1 compta. gestion des organisations'),
(310076, 0, 0, 310, 310, '1BTS1', '3103140711.', '1BTS1 assisitant de gestion de pme pmi'),
(310077, 0, 0, 310, 310, '1BTS1', '3103140811.', '1BTS1 comptabilité et gestion'),
(310078, 0, 0, 310, 310, '1BTS1', '3103200211.', '1BTS1 communication'),
(310079, 0, 0, 310, 310, '1BTS1', '3103210511.', '1BTS1 design communic. : espace & volume'),
(310080, 0, 0, 310, 310, '1BTS1', '3103220611.', '1BTS1 com.i.graph.o.et.real.prdts graph'),
(310081, 0, 0, 310, 310, '1BTS1', '3103220711.', '1BTS1 com.i.graph.o.et.real.prdts impr.'),
(310082, 0, 0, 310, 310, '1BTS1', '3103220811.', '1BTS1 édition'),
(310083, 0, 0, 310, 310, '1BTS1', '3103232511.', '1BTS1 photographie'),
(310084, 0, 0, 310, 310, '1BTS1', '3103232611.', '1BTS1 design graph. op.com.med imprimés'),
(310085, 0, 0, 310, 310, '1BTS1', '3103232711.', '1BTS1 design graph. op.com.med. numeriq'),
(310086, 0, 0, 310, 310, '1BTS1', '3103232811.', '1BTS1 métiers audiovisuel option gestion de la production'),
(310087, 0, 0, 310, 310, '1BTS1', '3103232911.', '1BTS1 métiers audiovisuel option métiers de l''image'),
(310088, 0, 0, 310, 310, '1BTS1', '3103233011.', '1BTS1 métiers audiovisuel option métiers du son'),
(310089, 0, 0, 310, 310, '1BTS1', '3103233111.', '1BTS1 métiers audiovisuel option techn. ingénierie et expl. équipements'),
(310090, 0, 0, 310, 310, '1BTS1', '3103233211.', '1BTS1 métiers audiovisuel option métiers montage et postproduction'),
(310091, 0, 0, 310, 310, '1BTS1', '3103240811.', '1BTS1 assistant de manager'),
(310092, 0, 0, 310, 310, '1BTS1', '3103261011.', '1BTS1 services informatiques aux organisations option A SISR'),
(310093, 0, 0, 310, 310, '1BTS1', '3103261111.', '1BTS1 services informatiques aux organisations option B SLAM'),
(310094, 0, 0, 310, 310, '1BTS1', '3103300111.', '1BTS1 service & prest. s.sanit.& social'),
(310095, 0, 0, 310, 310, '1BTS1', '3103310311.', '1BTS1 diététique'),
(310096, 0, 0, 310, 310, '1BTS1', '3103310711.', '1BTS1 opticien lunetier'),
(310097, 0, 0, 310, 310, '1BTS1', '3103310911.', '1BTS1 analyses de biologie médicale'),
(310098, 0, 0, 310, 310, '1BTS1', '3103311011.', '1BTS1 prothésiste dentaire'),
(310099, 0, 0, 310, 310, '1BTS1', '3103320411.', '1BTS1 économie sociale et familiale'),
(310100, 0, 0, 310, 310, '1BTS1', '3103341411.', '1BTS1 hôtel.rest.op_a : mercatq gest.hot.'),
(310101, 0, 0, 310, 310, '1BTS1', '3103341511.', '1BTS1 hôtel.rest.op_b : art cul.tabl.serv'),
(310102, 0, 0, 310, 310, '1BTS1', '3103341911.', '1BTS1 respons.heberg. ref.label europ.'),
(310103, 0, 0, 310, 310, '1BTS1', '3103342011.', '1BTS1 tourisme'),
(310104, 0, 0, 310, 310, '1BTS1', '3103360311.', '1BTS1 métiers esthétique-cosmétique-parfumerie option A management'),
(310105, 0, 0, 310, 310, '1BTS1', '3103360411.', '1BTS1 métiers esthétique-cosmétique-parfumerie option B formation-marque'),
(310106, 0, 0, 310, 310, '1BTS1', '3103360511.', '1BTS1 métiers esthétique-cosmétique-parfumerie option C cosmétologie'),
(310107, 0, 0, 310, 310, '1BTS1', '3103360711.', '1BTS1 métiers de la coiffure'),
(310108, 0, 0, 310, 310, '1BTS1', '3103430111.', '1BTS1 métiers de l''eau'),
(310109, 0, 0, 310, 310, '1BTS1', '3103430311.', '1BTS1 environnement nucléaire'),
(310110, 0, 0, 310, 310, '1BTS1', '3103430411.', '1BTS1 métiers des services à l''environnement'),
(310111, 0, 0, 310, 310, '1BTS1', '3103450111.', '1BTS1 notariat'),
(310112, 0, 0, 310, 310, '1BTS1', '3102200311.', '1BTS1 pilotage de procédés'),
(310113, 0, 0, 310, 310, '1BTS1', '3102220811.', '1BTS1 métiers de la chimie'),
(310114, 0, 0, 310, 310, '1BTS1', '3102231711.', '1BTS1 concept. des proces. de réal. de prod. option B produc. sérielle'),
(310115, 0, 0, 310, 310, '1BTS1', '3102231811.', '1BTS1 concept. des proces. de réal. de prod. option A produc. unitaire'),
(310116, 0, 0, 310, 310, '1BTS1', '3102250511.', '1BTS1 EuroPlastics et composites option CO conception outillage'),
(310117, 0, 0, 310, 310, '1BTS1', '3102250611.', '1BTS1 EuroPlastics et composites option POP pilotage optimisation product.'),
(310118, 0, 0, 310, 310, '1BTS1', '3102521511.', '1BTS1 maintenance des véhicules option A voitures particulières'),
(310119, 0, 0, 310, 310, '1BTS1', '3102521611.', '1BTS1 maintenance des véhicules option B véhicules transport routier'),
(310120, 0, 0, 310, 310, '1BTS1', '3102521711.', '1BTS1 maintenance des véhicules option C motocycles'),
(310121, 0, 0, 310, 310, '1BTS1', '3102541211.', '1BTS1 forge'),
(311001, 0, 1, 311, 311, '1BTS2', '311.....21.', 'BTS 2 ans, 1e année'),
(311002, 0, 1, 311, 311, '2BTS2', '311.....22.', 'BTS 2 ans, 2e année'),
(311003, 0, 0, 311, 311, '1BTS2', '3112000921.', '1BTS2 conception des produits industriel'),
(311004, 0, 0, 311, 311, '2BTS2', '3112000922.', '2BTS2 conception des produits industriel'),
(311005, 0, 0, 311, 311, '1BTS2', '3112000721.', '1BTS2 design de produits'),
(311006, 0, 0, 311, 311, '2BTS2', '3112000722.', '2BTS2 design de produits'),
(311007, 0, 0, 311, 311, '1BTS2', '3112000821.', '1BTS2 technico-commercial'),
(311008, 0, 0, 311, 311, '2BTS2', '3112000822.', '2BTS2 technico-commercial'),
(311009, 0, 0, 311, 311, '1BTS2', '3112011321.', '1BTS2 contrôle industriel et régulation automatique'),
(311010, 0, 0, 311, 311, '2BTS2', '3112011322.', '2BTS2 contrôle industriel et régulation automatique'),
(311011, 0, 0, 311, 311, '1BTS2', '3112011121.', '1BTS2 concept.et real.syst.automatiques'),
(311012, 0, 0, 311, 311, '2BTS2', '3112011122.', '2BTS2 concept.et real.syst.automatiques'),
(311013, 0, 0, 311, 311, '1BTS2', '3112011221.', '1BTS2 systèmes numériques option A informatique et réseaux'),
(311014, 0, 0, 311, 311, '2BTS2', '3112011222.', '2BTS2 systèmes numériques option A informatique et réseaux'),
(311015, 0, 0, 311, 311, '1BTS2', '3112200221.', '1BTS2 techniq.physiq.pour indust.& labo'),
(311016, 0, 0, 311, 311, '2BTS2', '3112200222.', '2BTS2 techniq.physiq.pour indust.& labo'),
(311017, 0, 0, 311, 311, '1BTS2', '3112210321.', '1BTS2 qualit.ds indus.alim.& bio-indus'),
(311018, 0, 0, 311, 311, '2BTS2', '3112210322.', '2BTS2 qualit.ds indus.alim.& bio-indus'),
(311019, 0, 0, 311, 311, '1BTS2', '3112210421.', '1BTS2 biotechnologies'),
(311020, 0, 0, 311, 311, '2BTS2', '3112210422.', '2BTS2 biotechnologies'),
(311021, 0, 0, 311, 311, '1BTS2', '3112220421.', '1BTS2 peintures encres et adhésifs'),
(311022, 0, 0, 311, 311, '2BTS2', '3112220422.', '2BTS2 peintures encres et adhésifs'),
(311023, 0, 0, 311, 311, '1BTS2', '3112220521.', '1BTS2 biophysicien de laboratoire'),
(311024, 0, 0, 311, 311, '2BTS2', '3112220522.', '2BTS2 biophysicien de laboratoire'),
(311025, 0, 0, 311, 311, '1BTS2', '3112220621.', '1BTS2 chimiste'),
(311026, 0, 0, 311, 311, '2BTS2', '3112220622.', '2BTS2 chimiste'),
(311027, 0, 0, 311, 311, '1BTS2', '3112220721.', '1BTS2 bioanalyses et contrôle (bts)'),
(311028, 0, 0, 311, 311, '2BTS2', '3112220722.', '2BTS2 bioanalyses et contrôle (bts)'),
(311029, 0, 0, 311, 311, '1BTS2', '3112230721.', '1BTS2 etud. real.outillag.m.e.f. materx'),
(311030, 0, 0, 311, 311, '2BTS2', '3112230722.', '2BTS2 etud. real.outillag.m.e.f. materx'),
(311031, 0, 0, 311, 311, '1BTS2', '3112230821.', '1BTS2 physico-métallographe de labo.'),
(311032, 0, 0, 311, 311, '2BTS2', '3112230822.', '2BTS2 physico-métallographe de labo.'),
(311033, 0, 0, 311, 311, '1BTS2', '3112231021.', '1BTS2 traitmt materx : 1ere année comm.'),
(311034, 0, 0, 311, 311, '2BTS2', '3112231122.', '2BTS2 traitm.materx op_a : trait.thermiq'),
(311035, 0, 0, 311, 311, '2BTS2', '3112231222.', '2BTS2 traitm.materx op_b : trait.surface'),
(311036, 0, 0, 311, 311, '1BTS2', '3112231421.', '1BTS2 fonderie'),
(311037, 0, 0, 311, 311, '2BTS2', '3112231422.', '2BTS2 fonderie'),
(311038, 0, 0, 311, 311, '1BTS2', '3112240421.', '1BTS2 industries céramiques'),
(311039, 0, 0, 311, 311, '2BTS2', '3112240422.', '2BTS2 industries céramiques'),
(311040, 0, 0, 311, 311, '1BTS2', '3112240521.', '1BTS2 concepteur art & indus.céramiq.'),
(311041, 0, 0, 311, 311, '2BTS2', '3112240522.', '2BTS2 concepteur art & indus.céramiq.'),
(311042, 0, 0, 311, 311, '1BTS2', '3112250421.', '1BTS2 industries plastiques europlastic'),
(311043, 0, 0, 311, 311, '2BTS2', '3112250422.', '2BTS2 industries plastiques europlastic'),
(311044, 0, 0, 311, 311, '1BTS2', '3112260221.', '1BTS2 ind.pap. : prodct.pates pap.cartons'),
(311045, 0, 0, 311, 311, '2BTS2', '3112260222.', '2BTS2 ind.pap. : prodct.pates pap.cartons'),
(311046, 0, 0, 311, 311, '1BTS2', '3112260321.', '1BTS2 ind.pap. : transform.papier-carton'),
(311047, 0, 0, 311, 311, '2BTS2', '3112260322.', '2BTS2 ind.pap. : transform.papier-carton'),
(311048, 0, 0, 311, 311, '1BTS2', '3112270421.', '1BTS2 ctrl.rayonmt.ionisants protection'),
(311049, 0, 0, 311, 311, '2BTS2', '3112270422.', '2BTS2 ctrl.rayonmt.ionisants protection'),
(311050, 0, 0, 311, 311, '1BTS2', '3112270921.', '1BTS2 fluides-énergies-domotique option A génie climatiq. et fluidiq.'),
(311051, 0, 0, 311, 311, '2BTS2', '3112270922.', '2BTS2 fluides-énergies-domotique option A génie climatiq. et fluidiq.'),
(311052, 0, 0, 311, 311, '1BTS2', '3112271021.', '1BTS2 fluides-énergies-domotique option B froid et conditionn. d''air'),
(311053, 0, 0, 311, 311, '2BTS2', '3112271022.', '2BTS2 fluides-énergies-domotique option B froid et conditionn. d''air'),
(311054, 0, 0, 311, 311, '1BTS2', '3112271121.', '1BTS2 fluides-énergies-domotique option C domotique et bat. communic.'),
(311055, 0, 0, 311, 311, '2BTS2', '3112271122.', '2BTS2 fluides-énergies-domotique option C domotique et bat. communic.'),
(311056, 0, 0, 311, 311, '1BTS2', '3112301021.', '1BTS2 études et économie construction'),
(311057, 0, 0, 311, 311, '2BTS2', '3112301022.', '2BTS2 études et économie construction'),
(311058, 0, 0, 311, 311, '1BTS2', '3112301121.', '1BTS2 design d''espace'),
(311059, 0, 0, 311, 311, '2BTS2', '3112301122.', '2BTS2 design d''espace'),
(311060, 0, 0, 311, 311, '1BTS2', '3112301221.', '1BTS2 bâtiment'),
(311061, 0, 0, 311, 311, '2BTS2', '3112301222.', '2BTS2 bâtiment'),
(311062, 0, 0, 311, 311, '1BTS2', '3112310321.', '1BTS2 géologie appliquée'),
(311063, 0, 0, 311, 311, '2BTS2', '3112310322.', '2BTS2 géologie appliquée'),
(311064, 0, 0, 311, 311, '1BTS2', '3112310821.', '1BTS2 métiers du géomètre-topographe et de la modélisation numérique'),
(311065, 0, 0, 311, 311, '2BTS2', '3112310822.', '2BTS2 métiers du géomètre-topographe et de la modélisation numérique'),
(311066, 0, 0, 311, 311, '1BTS2', '3112310721.', '1BTS2 travaux publics'),
(311067, 0, 0, 311, 311, '2BTS2', '3112310722.', '2BTS2 travaux publics'),
(311068, 0, 0, 311, 311, '1BTS2', '3112320521.', '1BTS2 enveloppe des bâtiments : conception et réalisation'),
(311069, 0, 0, 311, 311, '2BTS2', '3112320522.', '2BTS2 enveloppe des bâtiments : conception et réalisation'),
(311070, 0, 0, 311, 311, '1BTS2', '3112330521.', '1BTS2 étude et réalisation d''agencement'),
(311071, 0, 0, 311, 311, '2BTS2', '3112330522.', '2BTS2 étude et réalisation d''agencement'),
(311072, 0, 0, 311, 311, '1BTS2', '3112330421.', '1BTS2 aménagement finition'),
(311073, 0, 0, 311, 311, '2BTS2', '3112330422.', '2BTS2 aménagement finition'),
(311074, 0, 0, 311, 311, '1BTS2', '3112341121.', '1BTS2 développement et réalisation bois'),
(311075, 0, 0, 311, 311, '2BTS2', '3112341122.', '2BTS2 développement et réalisation bois'),
(311076, 0, 0, 311, 311, '1BTS2', '3112341221.', '1BTS2 systèmes constructifs bois et habitat'),
(311077, 0, 0, 311, 311, '2BTS2', '3112341222.', '2BTS2 systèmes constructifs bois et habitat'),
(311078, 0, 0, 311, 311, '1BTS2', '3112411021.', '1BTS2 des.mod.text.env. op.b text.m.sur'),
(311079, 0, 0, 311, 311, '2BTS2', '3112411022.', '2BTS2 des.mod.text.env. op.b text.m.sur'),
(311080, 0, 0, 311, 311, '1BTS2', '3112411121.', '1BTS2 innovation textile option A structures'),
(311081, 0, 0, 311, 311, '2BTS2', '3112411122.', '2BTS2 innovation textile option A structures'),
(311082, 0, 0, 311, 311, '1BTS2', '3112411221.', '1BTS2 innovation textile option B traitements'),
(311083, 0, 0, 311, 311, '2BTS2', '3112411222.', '2BTS2 innovation textile option B traitements'),
(311084, 0, 0, 311, 311, '1BTS2', '3112420621.', '1BTS2 des.mod.text.env. op.a mode'),
(311085, 0, 0, 311, 311, '2BTS2', '3112420622.', '2BTS2 des.mod.text.env. op.a mode'),
(311086, 0, 0, 311, 311, '1BTS2', '3112420721.', '1BTS2 métiers de la mode-vêtements'),
(311087, 0, 0, 311, 311, '2BTS2', '3112420722.', '2BTS2 métiers de la mode-vêtements'),
(311088, 0, 0, 311, 311, '1BTS2', '3112430121.', '1BTS2 industrie du cuir 1e an.commune'),
(311089, 0, 0, 311, 311, '2BTS2', '3112430222.', '2BTS2 ind.cuir op_1 : tannerie mégisserie'),
(311090, 0, 0, 311, 311, '1BTS2', '3112430521.', '1BTS2 métiers mode-chaussure maroquiner'),
(311091, 0, 0, 311, 311, '2BTS2', '3112430522.', '2BTS2 métiers mode-chaussure maroquiner'),
(311092, 0, 0, 311, 311, '1BTS2', '3112500121.', '1BTS2 assistance technique d''ingénieur'),
(311093, 0, 0, 311, 311, '2BTS2', '3112500122.', '2BTS2 assistance technique d''ingénieur'),
(311094, 0, 0, 311, 311, '1BTS2', '3112500521.', '1BTS2 concept. indust. microtechniques'),
(311095, 0, 0, 311, 311, '2BTS2', '3112500522.', '2BTS2 concept. indust. microtechniques');
INSERT INTO `sacoche_niveau` (`niveau_id`, `niveau_actif`, `niveau_usuel`, `niveau_famille_id`, `niveau_ordre`, `niveau_ref`, `code_mef`, `niveau_nom`) VALUES
(311096, 0, 0, 311, 311, '1BTS2', '3112500621.', '1BTS2 industrialis. produits mécaniques'),
(311097, 0, 0, 311, 311, '2BTS2', '3112500622.', '2BTS2 industrialis. produits mécaniques'),
(311098, 0, 0, 311, 311, '1BTS2', '3112500721.', '1BTS2 maintenance des systèmes option A systèmes de production'),
(311099, 0, 0, 311, 311, '2BTS2', '3112500722.', '2BTS2 maintenance des systèmes option A systèmes de production'),
(311100, 0, 0, 311, 311, '1BTS2', '3112500821.', '1BTS2 maintenance des systèmes option B syst. énergétiques & fluidiques'),
(311101, 0, 0, 311, 311, '2BTS2', '3112500822.', '2BTS2 maintenance des systèmes option B syst. énergétiques & fluidiques'),
(311102, 0, 0, 311, 311, '1BTS2', '3112500921.', '1BTS2 maintenance des systèmes option C systèmes éoliens'),
(311103, 0, 0, 311, 311, '2BTS2', '3112500922.', '2BTS2 maintenance des systèmes option C systèmes éoliens'),
(311104, 0, 0, 311, 311, '1BTS2', '3112521421.', '1BTS2 moteurs à combustion interne'),
(311105, 0, 0, 311, 311, '2BTS2', '3112521422.', '2BTS2 moteurs à combustion interne'),
(311106, 0, 0, 311, 311, '1BTS2', '3112520921.', '1BTS2 maint. a.v. engins tp manutention'),
(311107, 0, 0, 311, 311, '2BTS2', '3112520922.', '2BTS2 maint. a-v. engins tp manutention'),
(311108, 0, 0, 311, 311, '1BTS2', '3112521021.', '1BTS2 av auto. opt.véhic. particuliers'),
(311109, 0, 0, 311, 311, '2BTS2', '3112521022.', '2BTS2 av auto. opt.véhic. particuliers'),
(311110, 0, 0, 311, 311, '1BTS2', '3112521121.', '1BTS2 av auto. opt.véhic. industriels'),
(311111, 0, 0, 311, 311, '2BTS2', '3112521122.', '2BTS2 av auto. opt.véhic. industriels'),
(311112, 0, 0, 311, 311, '1BTS2', '3112521221.', '1BTS2 av auto. opt.motocycles'),
(311113, 0, 0, 311, 311, '2BTS2', '3112521222.', '2BTS2 av auto. opt.motocycles'),
(311114, 0, 0, 311, 311, '1BTS2', '3112521321.', '1BTS2 techniques et services en matériels agricoles'),
(311115, 0, 0, 311, 311, '2BTS2', '3112521322.', '2BTS2 techniques et services en matériels agricoles'),
(311116, 0, 0, 311, 311, '1BTS2', '3112530221.', '1BTS2 aéronautique'),
(311117, 0, 0, 311, 311, '2BTS2', '3112530222.', '2BTS2 aéronautique'),
(311118, 0, 0, 311, 311, '1BTS2', '3112540221.', '1BTS2 construction navale'),
(311119, 0, 0, 311, 311, '2BTS2', '3112540222.', '2BTS2 construction navale'),
(311120, 0, 0, 311, 311, '1BTS2', '3112540821.', '1BTS2 constructions métalliques'),
(311121, 0, 0, 311, 311, '2BTS2', '3112540822.', '2BTS2 constructions métalliques'),
(311122, 0, 0, 311, 311, '1BTS2', '3112540921.', '1BTS2 mise en forme materx par forgeage'),
(311123, 0, 0, 311, 311, '2BTS2', '3112540922.', '2BTS2 mise en forme materx par forgeage'),
(311124, 0, 0, 311, 311, '1BTS2', '3112541021.', '1BTS2 concept.& real.chaudronnerie ind.'),
(311125, 0, 0, 311, 311, '2BTS2', '3112541022.', '2BTS2 concept.& real.chaudronnerie ind.'),
(311126, 0, 0, 311, 311, '1BTS2', '3112541121.', '1BTS2 conception et réalisation de carrosserie'),
(311127, 0, 0, 311, 311, '2BTS2', '3112541122.', '2BTS2 conception et réalisation de carrosserie'),
(311128, 0, 0, 311, 311, '2BTS2', '3112551122.', '2BTS2 génie optique : photonique'),
(311129, 0, 0, 311, 311, '2BTS2', '3112551222.', '2BTS2 génie optique : optiq.instrumentale'),
(311130, 0, 0, 311, 311, '1BTS2', '3112551521.', '1BTS2 électrotechnique'),
(311131, 0, 0, 311, 311, '2BTS2', '3112551522.', '2BTS2 électrotechnique'),
(311132, 0, 0, 311, 311, '1BTS2', '3112551621.', '1BTS2 systèmes numériques option B électronique et communications'),
(311133, 0, 0, 311, 311, '2BTS2', '3112551622.', '2BTS2 systèmes numériques option B électronique et communications'),
(311134, 0, 0, 311, 311, '1BTS2', '3112551821.', '1BTS2 maintenance des systèmes électro-navals'),
(311135, 0, 0, 311, 311, '2BTS2', '3112551822.', '2BTS2 maintenance des systèmes électro-navals'),
(311136, 0, 0, 311, 311, '1BTS2', '3112551921.', '1BTS2 systèmes photoniques'),
(311137, 0, 0, 311, 311, '2BTS2', '3112551922.', '2BTS2 systèmes photoniques'),
(311138, 0, 0, 311, 311, '1BTS2', '3113110221.', '1BTS2 transport et prestat. logistiques'),
(311139, 0, 0, 311, 311, '2BTS2', '3113110222.', '2BTS2 transport et prestat. logistiques'),
(311140, 0, 0, 311, 311, '1BTS2', '3113120921.', '1BTS2 management unités commerciales'),
(311141, 0, 0, 311, 311, '2BTS2', '3113120922.', '2BTS2 management unités commerciales'),
(311142, 0, 0, 311, 311, '1BTS2', '3113121021.', '1BTS2 négociation et relation client'),
(311143, 0, 0, 311, 311, '2BTS2', '3113121022.', '2BTS2 négociation et relation client'),
(311144, 0, 0, 311, 311, '1BTS2', '3113121121.', '1BTS2 commerce internatio. ref.europeen'),
(311145, 0, 0, 311, 311, '2BTS2', '3113121122.', '2BTS2 commerce internatio. ref.europeen'),
(311146, 0, 0, 311, 311, '1BTS2', '3113130721.', '1BTS2 assurance'),
(311147, 0, 0, 311, 311, '2BTS2', '3113130722.', '2BTS2 assurance'),
(311148, 0, 0, 311, 311, '1BTS2', '3113130921.', '1BTS2 professions immobilières'),
(311149, 0, 0, 311, 311, '2BTS2', '3113130922.', '2BTS2 professions immobilières'),
(311150, 0, 0, 311, 311, '1BTS2', '3113131021.', '1BTS2 banque, conseiller de clientèle (particuliers)'),
(311151, 0, 0, 311, 311, '2BTS2', '3113131022.', '2BTS2 banque, conseiller de clientèle (particuliers)'),
(311152, 0, 0, 311, 311, '2BTS2', '3113140622.', '2BTS2 compta. gestion des organisations'),
(311153, 0, 0, 311, 311, '1BTS2', '3113140721.', '1BTS2 assisitant de gestion de pme pmi'),
(311154, 0, 0, 311, 311, '2BTS2', '3113140722.', '2BTS2 assisitant de gestion de pme pmi'),
(311155, 0, 0, 311, 311, '1BTS2', '3113140821.', '1BTS2 comptabilité et gestion'),
(311156, 0, 0, 311, 311, '2BTS2', '3113140822.', '2BTS2 comptabilité et gestion'),
(311157, 0, 0, 311, 311, '1BTS2', '3113200221.', '1BTS2 communication'),
(311158, 0, 0, 311, 311, '2BTS2', '3113200222.', '2BTS2 communication'),
(311159, 0, 0, 311, 311, '1BTS2', '3113210521.', '1BTS2 design communic. : espace & volume'),
(311160, 0, 0, 311, 311, '2BTS2', '3113210522.', '2BTS2 design communic. : espace & volume'),
(311161, 0, 0, 311, 311, '1BTS2', '3113220621.', '1BTS2 com.i.graph.o.et.real.prdts graph'),
(311162, 0, 0, 311, 311, '2BTS2', '3113220622.', '2BTS2 com.i.graph.o.et.real.prdts graph'),
(311163, 0, 0, 311, 311, '1BTS2', '3113220721.', '1BTS2 com.i.graph.o.et.real.prdts impr.'),
(311164, 0, 0, 311, 311, '2BTS2', '3113220722.', '2BTS2 com.i.graph.o.et.real.prdts impr.'),
(311165, 0, 0, 311, 311, '1BTS2', '3113220821.', '1BTS2 édition'),
(311166, 0, 0, 311, 311, '2BTS2', '3113220822.', '2BTS2 édition'),
(311167, 0, 0, 311, 311, '1BTS2', '3113232521.', '1BTS2 photographie'),
(311168, 0, 0, 311, 311, '2BTS2', '3113232522.', '2BTS2 photographie'),
(311169, 0, 0, 311, 311, '1BTS2', '3113232621.', '1BTS2 design graph. op.com.med imprimés'),
(311170, 0, 0, 311, 311, '2BTS2', '3113232622.', '2BTS2 design graph. op.com.med imprimés'),
(311171, 0, 0, 311, 311, '1BTS2', '3113232721.', '1BTS2 design graph. op.com.med. numeriq'),
(311172, 0, 0, 311, 311, '2BTS2', '3113232722.', '2BTS2 design graph. op.com.med. numeriq'),
(311173, 0, 0, 311, 311, '1BTS2', '3113232821.', '1BTS2 métiers audiovisuel option gestion de la production'),
(311174, 0, 0, 311, 311, '2BTS2', '3113232822.', '2BTS2 métiers audiovisuel option gestion de la production'),
(311175, 0, 0, 311, 311, '1BTS2', '3113232921.', '1BTS2 métiers audiovisuel option métiers de l''image'),
(311176, 0, 0, 311, 311, '2BTS2', '3113232922.', '2BTS2 métiers audiovisuel option métiers de l''image'),
(311177, 0, 0, 311, 311, '1BTS2', '3113233021.', '1BTS2 métiers audiovisuel option métiers du son'),
(311178, 0, 0, 311, 311, '2BTS2', '3113233022.', '2BTS2 métiers audiovisuel option métiers du son'),
(311179, 0, 0, 311, 311, '1BTS2', '3113233121.', '1BTS2 métiers audiovisuel option techn. ingénierie et expl. équipements'),
(311180, 0, 0, 311, 311, '2BTS2', '3113233122.', '2BTS2 métiers audiovisuel option techn. ingénierie et expl. équipements'),
(311181, 0, 0, 311, 311, '1BTS2', '3113233221.', '1BTS2 métiers audiovisuel option métiers montage et postproduction'),
(311182, 0, 0, 311, 311, '2BTS2', '3113233222.', '2BTS2 métiers audiovisuel option métiers montage et postproduction'),
(311183, 0, 0, 311, 311, '1BTS2', '3113240821.', '1BTS2 assistant de manager'),
(311184, 0, 0, 311, 311, '2BTS2', '3113240822.', '2BTS2 assistant de manager'),
(311185, 0, 0, 311, 311, '1BTS2', '3113260921.', '1BTS2 services informatiques aux organisations 1ère année'),
(311186, 0, 0, 311, 311, '2BTS2', '3113261022.', '2BTS2 services informatiques aux organisations option A SISR'),
(311187, 0, 0, 311, 311, '2BTS2', '3113261122.', '2BTS2 services informatiques aux organisations option B SLAM'),
(311188, 0, 0, 311, 311, '1BTS2', '3113300121.', '1BTS2 service & prest. s.sanit.& social'),
(311189, 0, 0, 311, 311, '2BTS2', '3113300122.', '2BTS2 service & prest. s.sanit.& social'),
(311190, 0, 0, 311, 311, '1BTS2', '3113310321.', '1BTS2 diététique'),
(311191, 0, 0, 311, 311, '2BTS2', '3113310322.', '2BTS2 diététique'),
(311192, 0, 0, 311, 311, '1BTS2', '3113310721.', '1BTS2 opticien lunetier'),
(311193, 0, 0, 311, 311, '2BTS2', '3113310722.', '2BTS2 opticien lunetier'),
(311194, 0, 0, 311, 311, '1BTS2', '3113310921.', '1BTS2 analyses de biologie médicale'),
(311195, 0, 0, 311, 311, '2BTS2', '3113310922.', '2BTS2 analyses de biologie médicale'),
(311196, 0, 0, 311, 311, '1BTS2', '3113311021.', '1BTS2 prothésiste dentaire'),
(311197, 0, 0, 311, 311, '2BTS2', '3113311022.', '2BTS2 prothésiste dentaire'),
(311198, 0, 0, 311, 311, '1BTS2', '3113320421.', '1BTS2 économie sociale et familiale'),
(311199, 0, 0, 311, 311, '2BTS2', '3113320422.', '2BTS2 économie sociale familiale'),
(311200, 0, 0, 311, 311, '1BTS2', '3113340621.', '1BTS2 hôtellerie restauration1e an.com'),
(311201, 0, 0, 311, 311, '2BTS2', '3113341422.', '2BTS2 hôtel.rest.op_a : mercatq gest.hot.'),
(311202, 0, 0, 311, 311, '2BTS2', '3113341522.', '2BTS2 hôtel.rest.op_b : art cul.tabl.serv'),
(311203, 0, 0, 311, 311, '1BTS2', '3113341921.', '1BTS2 respons.heberg. ref.label europ.'),
(311204, 0, 0, 311, 311, '2BTS2', '3113341922.', '2BTS2 respons.heberg. ref.label europ.'),
(311205, 0, 0, 311, 311, '1BTS2', '3113342021.', '1BTS2 tourisme'),
(311206, 0, 0, 311, 311, '2BTS2', '3113342022.', '2BTS2 tourisme'),
(311207, 0, 0, 311, 311, '2BTS2', '3113360322.', '2BTS2 met. esth.cosm.parf. option A manag.'),
(311208, 0, 0, 311, 311, '2BTS2', '3113360422.', '2BTS2 met. esth.cosm.parf. option B marq.'),
(311209, 0, 0, 311, 311, '2BTS2', '3113360522.', '2BTS2 met. esth.cosm.parf. option C cosm.'),
(311210, 0, 0, 311, 311, '1BTS2', '3113360621.', '1BTS2 met. esth.cosm.parf. 1e ann. comm.'),
(311211, 0, 0, 311, 311, '1BTS2', '3113360721.', '1BTS2 métiers de la coiffure'),
(311212, 0, 0, 311, 311, '2BTS2', '3113360722.', '2BTS2 métiers de la coiffure'),
(311213, 0, 0, 311, 311, '1BTS2', '3113430121.', '1BTS2 métiers de l''eau'),
(311214, 0, 0, 311, 311, '2BTS2', '3113430122.', '2BTS2 métiers de l''eau'),
(311215, 0, 0, 311, 311, '1BTS2', '3113430321.', '1BTS2 environnement nucléaire'),
(311216, 0, 0, 311, 311, '2BTS2', '3113430322.', '2BTS2 environnement nucléaire'),
(311217, 0, 0, 311, 311, '1BTS2', '3113430421.', '1BTS2 métiers des services à l''environnement'),
(311218, 0, 0, 311, 311, '2BTS2', '3113430422.', '2BTS2 métiers des services à l''environnement'),
(311219, 0, 0, 311, 311, '1BTS2', '3113450121.', '1BTS2 notariat'),
(311220, 0, 0, 311, 311, '2BTS2', '3113450122.', '2BTS2 notariat'),
(311221, 0, 0, 311, 311, '1BTS2', '3112200321.', '1BTS2 pilotage de procédés'),
(311222, 0, 0, 311, 311, '2BTS2', '3112200322.', '2BTS2 pilotage de procédés'),
(311223, 0, 0, 311, 311, '1BTS2', '3112220821.', '1BTS2 métiers de la chimie'),
(311224, 0, 0, 311, 311, '2BTS2', '3112220822.', '2BTS2 métiers de la chimie'),
(311225, 0, 0, 311, 311, '1BTS2', '3112231621.', '1BTS2 conception des processus réalisation produits 1ère année commune'),
(311226, 0, 0, 311, 311, '2BTS2', '3112231722.', '2BTS2 concept. des proces. de réal. de prod. option B produc. sérielle'),
(311227, 0, 0, 311, 311, '2BTS2', '3112231822.', '2BTS2 concept. des proces. de réal. de prod. option A produc. unitaire'),
(311228, 0, 0, 311, 311, '1BTS2', '3112250521.', '1BTS2 EuroPlastics et composites option CO conception outillage'),
(311229, 0, 0, 311, 311, '2BTS2', '3112250522.', '2BTS2 EuroPlastics et composites option CO conception outillage'),
(311230, 0, 0, 311, 311, '1BTS2', '3112250621.', '1BTS2 EuroPlastics et composites option POP pilotage optimisation product.'),
(311231, 0, 0, 311, 311, '2BTS2', '3112250622.', '2BTS2 EuroPlastics et composites option POP pilotage optimisation product.'),
(311232, 0, 0, 311, 311, '1BTS2', '3112521521.', '1BTS2 maintenance des véhicules option A voitures particulières'),
(311233, 0, 0, 311, 311, '2BTS2', '3112521522.', '2BTS2 maintenance des véhicules option A voitures particulières'),
(311234, 0, 0, 311, 311, '1BTS2', '3112521621.', '1BTS2 maintenance des véhicules option B véhicules transport routier'),
(311235, 0, 0, 311, 311, '2BTS2', '3112521622.', '2BTS2 maintenance des véhicules option B véhicules transport routier'),
(311236, 0, 0, 311, 311, '1BTS2', '3112521721.', '1BTS2 maintenance des véhicules option C motocycles'),
(311237, 0, 0, 311, 311, '2BTS2', '3112521722.', '2BTS2 maintenance des véhicules option C motocycles'),
(311238, 0, 0, 311, 311, '1BTS2', '3112541221.', '1BTS2 forge'),
(311239, 0, 0, 311, 311, '2BTS2', '3112541222.', '2BTS2 forge'),
(312001, 0, 1, 312, 312, '1BTS3', '312.....31.', 'BTS 3 ans, 1e année'),
(312002, 0, 1, 312, 312, '2BTS3', '312.....32.', 'BTS 3 ans, 2e année'),
(312003, 0, 1, 312, 312, '3BTS3', '312.....33.', 'BTS 3 ans, 3e année'),
(312004, 0, 0, 312, 312, '1BTS3', '3123310431.', '1BTS3 prothésiste orthésiste'),
(312005, 0, 0, 312, 312, '2BTS3', '3123310432.', '2BTS3 prothésiste orthésiste'),
(312006, 0, 0, 312, 312, '3BTS3', '3123310433.', '3BTS3 prothésiste orthésiste'),
(312007, 0, 0, 312, 312, '1BTS3', '3123310531.', '1BTS3 podo-orthésiste'),
(312008, 0, 0, 312, 312, '2BTS3', '3123310532.', '2BTS3 podo-orthésiste'),
(312009, 0, 0, 312, 312, '3BTS3', '3123310533.', '3BTS3 podo-orthésiste'),
(313001, 0, 0, 313, 313, '1DTS3', '3133310931.', '1DTS3 imagerie médicale radiolo.thérap.'),
(313002, 0, 0, 313, 313, '2DTS3', '3133310932.', '2DTS3 imagerie médicale radiolo.thérap.'),
(313003, 0, 0, 313, 313, '3DTS3', '3133310933.', '3DTS3 imagerie médicale radiolo.thérap.'),
(315000, 0, 1, 315, 315, '1DMA1', '315.....11.', 'DMA 1 an'),
(315001, 0, 0, 315, 315, '1DMA1', '3151330111.', '1DMA1 cinéma d''animation'),
(315002, 0, 0, 315, 315, '1DMA1', '3152230111.', '1DMA1 art du bijou et du joyau'),
(315003, 0, 0, 315, 315, '1DMA1', '3152240111.', '1DMA1 textil.céramiq : céram.artisanale'),
(315004, 0, 0, 315, 315, '1DMA1', '3152240211.', '1DMA1 décor architect.opt.verre cristal'),
(315005, 0, 0, 315, 315, '1DMA1', '3152300111.', '1DMA1 habitat : décors et mobiliers'),
(315006, 0, 0, 315, 315, '1DMA1', '3152300211.', '1DMA1 habitat : ornements et objets'),
(315007, 0, 0, 315, 315, '1DMA1', '3152300311.', '1DMA1 décor archi_a : traitement plastique'),
(315008, 0, 0, 315, 315, '1DMA1', '3152300411.', '1DMA1 décor archi_b : décor du mur'),
(315009, 0, 0, 315, 315, '1DMA1', '3152300511.', '1DMA1 décor archi_c : métal'),
(315010, 0, 0, 315, 315, '1DMA1', '3152300611.', '1DMA1 décor archi_d : matériaux synthèse'),
(315011, 0, 0, 315, 315, '1DMA1', '3152340911.', '1DMA1 lutherie'),
(315012, 0, 0, 315, 315, '1DMA1', '3152341011.', '1DMA1 habitat opt.restauration mobilier'),
(315013, 0, 0, 315, 315, '1DMA1', '3152341111.', '1DMA1 facture instrumentale : accordéon'),
(315014, 0, 0, 315, 315, '1DMA1', '3152341211.', '1DMA1 facture instrumentale : guitare'),
(315015, 0, 0, 315, 315, '1DMA1', '3152341311.', '1DMA1 facture instrumentale : piano'),
(315016, 0, 0, 315, 315, '1DMA1', '3152410111.', '1DMA1 textil.céramique : arts textiles'),
(315017, 0, 0, 315, 315, '1DMA1', '3152420411.', '1DMA1 op. costumier réalisateur'),
(315018, 0, 0, 315, 315, '1DMA1', '3152510111.', '1DMA1 horlogerie'),
(315019, 0, 0, 315, 315, '1DMA1', '3152540111.', '1DMA1 facture instrumentale : instruments a vents'),
(315020, 0, 0, 315, 315, '1DMA1', '3153220511.', '1DMA1 arts graphiques opt.gravure'),
(315021, 0, 0, 315, 315, '1DMA1', '3153220611.', '1DMA1 arts graphiques opt.reliure dorure'),
(315022, 0, 0, 315, 315, '1DMA1', '3153220711.', '1DMA1 arts graphiques opt.illustration'),
(315023, 0, 0, 315, 315, '1DMA1', '3153220811.', '1DMA1 arts graphiques opt.typographie'),
(315024, 0, 0, 315, 315, '1DMA1', '3153230111.', '1DMA1 cirque'),
(315025, 0, 0, 315, 315, '1DMA1', '3153231311.', '1DMA1 marionnette'),
(315026, 0, 0, 315, 315, '1DMA1', '3153231611.', '1DMA1 régie du spectacle option lumière'),
(315027, 0, 0, 315, 315, '1DMA1', '3153231711.', '1DMA1 régie du spectacle option son'),
(316001, 0, 1, 316, 316, '1DMA2', '316.....21.', 'DMA 2 ans, 1e année'),
(316002, 0, 1, 316, 316, '2DMA2', '316.....22.', 'DMA 2 ans, 2e année'),
(316003, 0, 0, 316, 316, '1DMA2', '3161330121.', '1DMA2 cinéma d''animation'),
(316004, 0, 0, 316, 316, '2DMA2', '3161330122.', '2DMA2 cinéma d''animation'),
(316005, 0, 0, 316, 316, '1DMA2', '3162230121.', '1DMA2 art du bijou et du joyau'),
(316006, 0, 0, 316, 316, '2DMA2', '3162230122.', '2DMA2 art du bijou et du joyau'),
(316007, 0, 0, 316, 316, '1DMA2', '3162240121.', '1DMA2 textil.céramiq : céram.artisanale'),
(316008, 0, 0, 316, 316, '2DMA2', '3162240122.', '2DMA2 textil.céramiq : céram.artisanale'),
(316009, 0, 0, 316, 316, '1DMA2', '3162240221.', '1DMA2 décor architect.opt.verre cristal'),
(316010, 0, 0, 316, 316, '2DMA2', '3162240222.', '2DMA2 décor architect.opt.verre cristal'),
(316011, 0, 0, 316, 316, '1DMA2', '3162300121.', '1DMA2 habitat : décors et mobiliers'),
(316012, 0, 0, 316, 316, '2DMA2', '3162300122.', '2DMA2 habitat : décors et mobiliers'),
(316013, 0, 0, 316, 316, '1DMA2', '3162300221.', '1DMA2 habitat : ornements et objets'),
(316014, 0, 0, 316, 316, '2DMA2', '3162300222.', '2DMA2 habitat : ornements et objets'),
(316015, 0, 0, 316, 316, '1DMA2', '3162300321.', '1DMA2 décor archi_a : traitement plastique'),
(316016, 0, 0, 316, 316, '2DMA2', '3162300322.', '2DMA2 décor archi_a : traitement plastique'),
(316017, 0, 0, 316, 316, '1DMA2', '3162300421.', '1DMA2 décor archi_b : décor du mur'),
(316018, 0, 0, 316, 316, '2DMA2', '3162300422.', '2DMA2 décor archi_b : décor du mur'),
(316019, 0, 0, 316, 316, '1DMA2', '3162300521.', '1DMA2 décor archi_c : métal'),
(316020, 0, 0, 316, 316, '2DMA2', '3162300522.', '2DMA2 décor archi_c : métal'),
(316021, 0, 0, 316, 316, '1DMA2', '3162300621.', '1DMA2 décor archi_d : matériaux synthèse'),
(316022, 0, 0, 316, 316, '2DMA2', '3162300622.', '2DMA2 décor archi_d : matériaux synthèse'),
(316023, 0, 0, 316, 316, '1DMA2', '3162340921.', '1DMA2 lutherie'),
(316024, 0, 0, 316, 316, '2DMA2', '3162340922.', '2DMA2 lutherie'),
(316025, 0, 0, 316, 316, '1DMA2', '3162341021.', '1DMA2 habitat opt.restauration mobilier'),
(316026, 0, 0, 316, 316, '2DMA2', '3162341022.', '2DMA2 habitat opt.restauration mobilier'),
(316027, 0, 0, 316, 316, '1DMA2', '3162341121.', '1DMA2 facture instrumentale : accordéon'),
(316028, 0, 0, 316, 316, '2DMA2', '3162341122.', '2DMA2 facture instrumentale : accordéon'),
(316029, 0, 0, 316, 316, '1DMA2', '3162341221.', '1DMA2 facture instrumentale : guitare'),
(316030, 0, 0, 316, 316, '2DMA2', '3162341222.', '2DMA2 facture instrumentale : guitare'),
(316031, 0, 0, 316, 316, '1DMA2', '3162341321.', '1DMA2 facture instrumentale : piano'),
(316032, 0, 0, 316, 316, '2DMA2', '3162341322.', '2DMA2 facture instrumentale : piano'),
(316033, 0, 0, 316, 316, '1DMA2', '3162410121.', '1DMA2 textil.céramique : arts textiles'),
(316034, 0, 0, 316, 316, '2DMA2', '3162410122.', '2DMA2 textil.céramique : arts textiles'),
(316035, 0, 0, 316, 316, '1DMA2', '3162420421.', '1DMA2 op. costumier réalisateur'),
(316036, 0, 0, 316, 316, '2DMA2', '3162420422.', '2DMA2 op. costumier réalisateur'),
(316037, 0, 0, 316, 316, '1DMA2', '3162510121.', '1DMA2 horlogerie'),
(316038, 0, 0, 316, 316, '2DMA2', '3162510122.', '2DMA2 horlogerie'),
(316039, 0, 0, 316, 316, '1DMA2', '3162540121.', '1DMA2 facture instrumentale : instruments a vents'),
(316040, 0, 0, 316, 316, '2DMA2', '3162540122.', '2DMA2 facture instrumentale : instruments a vents'),
(316041, 0, 0, 316, 316, '1DMA2', '3163220521.', '1DMA2 arts graphiques opt.gravure'),
(316042, 0, 0, 316, 316, '2DMA2', '3163220522.', '2DMA2 arts graphiques opt.gravure'),
(316043, 0, 0, 316, 316, '1DMA2', '3163220621.', '1DMA2 arts graphiques opt.reliure dorure'),
(316044, 0, 0, 316, 316, '2DMA2', '3163220622.', '2DMA2 arts graphiques opt.reliure dorure'),
(316045, 0, 0, 316, 316, '1DMA2', '3163220721.', '1DMA2 arts graphiques opt.illustration'),
(316046, 0, 0, 316, 316, '2DMA2', '3163220722.', '2DMA2 arts graphiques opt.illustration'),
(316047, 0, 0, 316, 316, '1DMA2', '3163220821.', '1DMA2 arts graphiques opt.typographie'),
(316048, 0, 0, 316, 316, '2DMA2', '3163220822.', '2DMA2 arts graphiques opt.typographie'),
(316049, 0, 0, 316, 316, '1DMA2', '3163230121.', '1DMA2 cirque'),
(316050, 0, 0, 316, 316, '2DMA2', '3163230122.', '2DMA2 cirque'),
(316051, 0, 0, 316, 316, '1DMA2', '3163231321.', '1DMA2 marionnette'),
(316052, 0, 0, 316, 316, '2DMA2', '3163231322.', '2DMA2 marionnette'),
(316053, 0, 0, 316, 316, '1DMA2', '3163231621.', '1DMA2 régie du spectacle option lumière'),
(316054, 0, 0, 316, 316, '2DMA2', '3163231622.', '2DMA2 régie du spectacle option lumière'),
(316055, 0, 0, 316, 316, '1DMA2', '3163231721.', '1DMA2 régie du spectacle option son'),
(316056, 0, 0, 316, 316, '2DMA2', '3163231722.', '2DMA2 régie du spectacle option son'),
(350001, 0, 1, 350, 350, '2DUT1', '350.....21.', 'DUT 2 ans, 1e année'),
(350002, 0, 1, 350, 350, '2DUT2', '350.....22.', 'DUT 2 ans, 2e année'),
(350003, 0, 0, 350, 350, '1DUT2', '3501110221.', '1DUT2 sciences et génie des matériaux'),
(350004, 0, 0, 350, 350, '2DUT2', '3501110222.', '2DUT2 sciences et génie des matériaux'),
(350005, 0, 0, 350, 350, '1DUT2', '3501110321.', '1DUT2 mesures phys mat (année commune)'),
(350006, 0, 0, 350, 350, '1DUT2', '3501160321.', '1DUT2 chimie (année commune)'),
(350007, 0, 0, 350, 350, '1DUT2', '3501180521.', '1DUT2 génie bio (année commune)'),
(350008, 0, 0, 350, 350, '2DUT2', '3501180622.', '2DUT2 génie bio - analys bio et biochim'),
(350009, 0, 0, 350, 350, '2DUT2', '3501180722.', '2DUT2 génie bio - ind alim et biologiq'),
(350010, 0, 0, 350, 350, '2DUT2', '3501180822.', '2DUT2 génie bio - agronomie'),
(350011, 0, 0, 350, 350, '2DUT2', '3501180922.', '2DUT2 génie bio - génie de environnemt'),
(350012, 0, 0, 350, 350, '1DUT2', '3502000621.', '1DUT2 génie industriel et maintenance'),
(350013, 0, 0, 350, 350, '2DUT2', '3502000622.', '2DUT2 génie industriel et maintenance'),
(350014, 0, 0, 350, 350, '1DUT2', '3502221121.', '1DUT2 génie chimiq procédé (an. commu)'),
(350015, 0, 0, 350, 350, '2DUT2', '3502221222.', '2DUT2 génie chimiq proc - procédés'),
(350016, 0, 0, 350, 350, '2DUT2', '3502221322.', '2DUT2 génie chimiq proc- bio-procédés'),
(350017, 0, 0, 350, 350, '1DUT2', '3502270121.', '1DUT2 génie thermique et énergie'),
(350018, 0, 0, 350, 350, '2DUT2', '3502270122.', '2DUT2 génie thermique et énergie'),
(350019, 0, 0, 350, 350, '1DUT2', '3502300121.', '1DUT2 génie civil (année commune)'),
(350020, 0, 0, 350, 350, '1DUT2', '3502510121.', '1DUT2 génie mécanique et productique'),
(350021, 0, 0, 350, 350, '2DUT2', '3502510122.', '2DUT2 génie mécanique et productique'),
(350022, 0, 0, 350, 350, '1DUT2', '3502550621.', '1DUT2 génie elec info ind (an. commune)'),
(350023, 0, 0, 350, 350, '1DUT2', '3503100421.', '1DUT2 gestion adminis et commerciale'),
(350024, 0, 0, 350, 350, '2DUT2', '3503100422.', '2DUT2 gestion adminis et commerciale'),
(350025, 0, 0, 350, 350, '1DUT2', '3503100521.', '1DUT2 gea (année commune)'),
(350026, 0, 0, 350, 350, '1DUT2', '3503110221.', '1DUT2 gestion logistique transport'),
(350027, 0, 0, 350, 350, '2DUT2', '3503110222.', '2DUT2 gestion logistique transport'),
(350028, 0, 0, 350, 350, '1DUT2', '3503110321.', '1DUT2 génie conditionnement emballage'),
(350029, 0, 0, 350, 350, '2DUT2', '3503110322.', '2DUT2 génie conditionnement emballage'),
(350030, 0, 0, 350, 350, '1DUT2', '3503120121.', '1DUT2 techniques de commercialisation'),
(350031, 0, 0, 350, 350, '2DUT2', '3503120122.', '2DUT2 techniques de commercialisation'),
(350032, 0, 0, 350, 350, '1DUT2', '3503120221.', '1DUT2 techniques commercialisation - syst, solutions & serv indus'),
(350033, 0, 0, 350, 350, '2DUT2', '3503120222.', '2DUT2 techniques commercialisation - syst, solutions & serv indus'),
(350034, 0, 0, 350, 350, '1DUT2', '3503200221.', '1DUT2 services et réseaux de communication'),
(350035, 0, 0, 350, 350, '2DUT2', '3503200222.', '2DUT2 services et réseaux de communication'),
(350036, 0, 0, 350, 350, '1DUT2', '3503210121.', '1DUT2 info com journalisme'),
(350037, 0, 0, 350, 350, '2DUT2', '3503210122.', '2DUT2 info com journalisme'),
(350038, 0, 0, 350, 350, '1DUT2', '3503210221.', '1DUT2 info com publicité'),
(350039, 0, 0, 350, 350, '2DUT2', '3503210222.', '2DUT2 info com publicité'),
(350040, 0, 0, 350, 350, '1DUT2', '3503260521.', '1DUT2 informatique (année commune)'),
(350041, 0, 0, 350, 350, '1DUT2', '3503300321.', '1DUT2 carr soc services à la personne'),
(350042, 0, 0, 350, 350, '2DUT2', '3503300322.', '2DUT2 carr soc services à la personne'),
(350043, 0, 0, 350, 350, '1DUT2', '3503310321.', '1DUT2 aide & assistance pour monitoring & maintien domicile'),
(350044, 0, 0, 350, 350, '2DUT2', '3503310322.', '2DUT2 aide & assistance pour monitoring & maintien domicile'),
(350045, 0, 0, 350, 350, '1DUT2', '3503320121.', '1DUT2 carr soc éducation spécialisée'),
(350046, 0, 0, 350, 350, '2DUT2', '3503320122.', '2DUT2 carr soc éducation spécialisée'),
(350047, 0, 0, 350, 350, '1DUT2', '3503320221.', '1DUT2 carr soc assistance sociale'),
(350048, 0, 0, 350, 350, '2DUT2', '3503320222.', '2DUT2 carr soc assistance sociale'),
(350049, 0, 0, 350, 350, '1DUT2', '3503320321.', '1DUT2 carr soc gestion urbaine'),
(350050, 0, 0, 350, 350, '2DUT2', '3503320322.', '2DUT2 carr soc gestion urbaine'),
(350051, 0, 0, 350, 350, '1DUT2', '3503350521.', '1DUT2 carr soc animation soc socio-cult'),
(350052, 0, 0, 350, 350, '2DUT2', '3503350522.', '2DUT2 carr soc animation soc socio-cult'),
(350053, 0, 0, 350, 350, '1DUT2', '3503440321.', '1DUT2 hygiène sécurité environnement'),
(350054, 0, 0, 350, 350, '2DUT2', '3503440322.', '2DUT2 hygiène sécurité environnement'),
(350055, 0, 0, 350, 350, '1DUT2', '3503450121.', '1DUT2 carrières juridiques'),
(350056, 0, 0, 350, 350, '2DUT2', '3503450122.', '2DUT2 carrières juridiques'),
(370000, 0, 1, 370, 370, '1BTS1A', '370.....11.', 'BTS Agricole 1 an'),
(370001, 0, 0, 370, 370, '1BTS1A', '3702100711.', '1BTS1a génie des équipements agricoles'),
(370002, 0, 0, 370, 370, '1BTS1A', '3702101111.', '1BTS1a dev agriculture régions chaudes'),
(370003, 0, 0, 370, 370, '1BTS1A', '3702101311.', '1BTS1a technico-commercial'),
(370004, 0, 0, 370, 370, '1BTS1A', '3702101411.', '1BTS1a analyse, cdte et stratégie de l''entreprise agricole acse'),
(370005, 0, 0, 370, 370, '1BTS1A', '3702111111.', '1BTS1a production horticole'),
(370006, 0, 0, 370, 370, '1BTS1A', '3702120511.', '1BTS1a productions animales'),
(370007, 0, 0, 370, 370, '1BTS1A', '3702130411.', '1BTS1a gestion forestière'),
(370008, 0, 0, 370, 370, '1BTS1A', '3702130811.', '1BTS1a gestion-protec nature'),
(370009, 0, 0, 370, 370, '1BTS1A', '3702140111.', '1BTS1a aménagements paysagers'),
(370010, 0, 0, 370, 370, '1BTS1A', '3703430211.', '1BTS1a gestion-maîtrise-eau'),
(371001, 0, 1, 371, 371, '1BTS2A', '371.....21.', 'BTS Agricole 2 ans, 1e année'),
(371002, 0, 1, 371, 371, '2BTS2A', '371.....22.', 'BTS Agricole 2 ans, 2e année'),
(371003, 0, 0, 371, 371, '1BTS2A', '3712100721.', '1BTS2a génie des équipements agricoles'),
(371004, 0, 0, 371, 371, '2BTS2A', '3712100722.', '1BTS2a génie des équipements agricoles'),
(371005, 0, 0, 371, 371, '1BTS2A', '3712101121.', '1BTS2a dev agriculture régions chaudes'),
(371006, 0, 0, 371, 371, '2BTS2A', '3712101122.', '1BTS2a dev agriculture régions chaudes'),
(371007, 0, 0, 371, 371, '1BTS2A', '3712101221.', '1BTS2a sta produits céréaliers'),
(371008, 0, 0, 371, 371, '2BTS2A', '3712101222.', '1BTS2a sta produits céréaliers'),
(371009, 0, 0, 371, 371, '1BTS2A', '3712101321.', '1BTS2a technico-commercial'),
(371010, 0, 0, 371, 371, '2BTS2A', '3712101322.', '1BTS2a technico-commercial'),
(371011, 0, 0, 371, 371, '1BTS2A', '3712101421.', '1BTS2a analyse, cdte et stratégie de l''entreprise agricole acse'),
(371012, 0, 0, 371, 371, '2BTS2A', '3712101422.', '1BTS2a analyse, cdte et stratégie de l''entreprise agricole acse'),
(371013, 0, 0, 371, 371, '1BTS2A', '3712111121.', '1BTS2a production horticole'),
(371014, 0, 0, 371, 371, '2BTS2A', '3712111122.', '1BTS2a production horticole'),
(371015, 0, 0, 371, 371, '1BTS2A', '3712111221.', '1BTS2a viticulture œnologie'),
(371016, 0, 0, 371, 371, '2BTS2A', '3712111222.', '1BTS2a viticulture œnologie'),
(371017, 0, 0, 371, 371, '1BTS2A', '3712111321.', '1BTS2a agronomie productions végétales'),
(371018, 0, 0, 371, 371, '2BTS2A', '3712111322.', '1BTS2a agronomie productions végétales'),
(371019, 0, 0, 371, 371, '1BTS2A', '3712120521.', '1BTS2a productions animales'),
(371020, 0, 0, 371, 371, '2BTS2A', '3712120522.', '1BTS2a productions animales'),
(371021, 0, 0, 371, 371, '1BTS2A', '3712120621.', '1BTS2a aquaculture'),
(371022, 0, 0, 371, 371, '2BTS2A', '3712120622.', '1BTS2a aquaculture'),
(371023, 0, 0, 371, 371, '1BTS2A', '3712130421.', '1BTS2a gestion forestière'),
(371024, 0, 0, 371, 371, '2BTS2A', '3712130422.', '1BTS2a gestion forestière'),
(371025, 0, 0, 371, 371, '1BTS2A', '3712130821.', '1BTS2a gestion-protec-nature'),
(371026, 0, 0, 371, 371, '2BTS2A', '3712130822.', '1BTS2a gestion-protec-nature'),
(371027, 0, 0, 371, 371, '1BTS2A', '3712140121.', '1BTS2a aménagements paysagers'),
(371028, 0, 0, 371, 371, '2BTS2A', '3712140122.', '1BTS2a aménagements paysagers'),
(371029, 0, 0, 371, 371, '1BTS2A', '3712211121.', '1BTS2a analyses agri biolog et biotechno'),
(371030, 0, 0, 371, 371, '2BTS2A', '3712211122.', '1BTS2a analyses agri biolog et biotechno'),
(371031, 0, 0, 371, 371, '1BTS2A', '3712211221.', '1BTS2a sta produits laitiers'),
(371032, 0, 0, 371, 371, '2BTS2A', '3712211222.', '1BTS2a sta produits laitiers'),
(371033, 0, 0, 371, 371, '1BTS2A', '3712211321.', '1BTS2a sta aliments et processus technologiques'),
(371034, 0, 0, 371, 371, '2BTS2A', '3712211322.', '1BTS2a sta aliments et processus technologiques'),
(371035, 0, 0, 371, 371, '1BTS2A', '3712211421.', '1BTS2a sta viandes et produits de la pêche'),
(371036, 0, 0, 371, 371, '2BTS2A', '3712211422.', '1BTS2a sta viandes et produits de la pêche'),
(371037, 0, 0, 371, 371, '1BTS2A', '3713000121.', '1BTS2a développement, animation des territoires ruraux'),
(371038, 0, 0, 371, 371, '2BTS2A', '3713000122.', '1BTS2a développement, animation des territoires ruraux'),
(371039, 0, 0, 371, 371, '1BTS2A', '3713430221.', '1BTS2a gestion maîtrise eau'),
(371040, 0, 0, 371, 371, '2BTS2A', '3713430222.', '1BTS2a gestion maîtrise eau'),
(390001, 0, 0, 390, 390, '1PD3', '3902009911.', '1PD3 techno.industriell.fondamentales'),
(390002, 0, 0, 390, 390, '1PD3', '3902109911.', '1PD3 spec.pluriv.de l''agronomie agric.'),
(390003, 0, 0, 390, 390, '1PD3', '3902209911.', '1PD3 spec.pluritechno des transformat.'),
(390004, 0, 0, 390, 390, '1PD3', '3902309911.', '1PD3 spec.pluritechno, génie civil, ..'),
(390005, 0, 0, 390, 390, '1PD3', '3902409911.', '1PD3 spec.pluritechno matériaux soupl.'),
(390006, 0, 0, 390, 390, '1PD3', '3902509911.', '1PD3 spec.pluritechno mecan.-électric.'),
(390007, 0, 0, 390, 390, '1PD3', '3903009911.', '1PD3 spec.plurivalentes des services'),
(390008, 0, 0, 390, 390, '1PD3', '3903109911.', '1PD3 spec.plurival.echanges & gestion'),
(390009, 0, 0, 390, 390, '1PD3', '3903209911.', '1PD3 spec.plurival.de la communication'),
(390010, 0, 0, 390, 390, '1PD3', '3903309911.', '1PD3 spec.pluriv.sanitaires & sociales'),
(390011, 0, 0, 390, 390, 'PMED', '3903310111.', 'Pmed prépa écoles paramédicales'),
(390012, 0, 0, 390, 390, 'PUERIC', '3903310511.', 'Diplôme de puériculture'),
(390013, 0, 0, 390, 390, 'PSOC', '3903320411.', 'Psoc prépa écoles carrières sociales'),
(390014, 0, 0, 390, 390, '1PD3', '3903340111.', '1PD3 hôtesse d''accueil'),
(390015, 0, 0, 390, 390, '1PD3', '3903409911.', '1PD3 spec.pluriv.services à la collect'),
(392001, 0, 0, 390, 392, 'ASSOC1', '3923320531.', 'Diplôme d''état assistant social, 1ère année'),
(392002, 0, 0, 390, 392, 'ASSOC2', '3923320532.', 'Diplôme d''état assistant social, 2ème année'),
(392003, 0, 0, 390, 392, 'ASSOC3', '3923320533.', 'Diplôme d''état assistant social, 3ème année'),
(412001, 0, 0, 390, 412, 'DCG1', '4123140331.', 'Diplôme comptabilité et gestion, 1ère année'),
(412002, 0, 0, 390, 412, 'DCG2', '4123140332.', 'Diplôme comptabilité et gestion, 2ème année'),
(412003, 0, 0, 390, 412, 'DCG3', '4123140333.', 'Diplôme comptabilité et gestion, 3ème année'),
(414001, 0, 0, 390, 414, 'DSCG1', '4143140121.', 'Diplôme supérieur comptabilité et gestion, 1ère année'),
(414002, 0, 0, 390, 414, 'DSCG2', '4143140122.', 'Diplôme supérieur comptabilité et gestion, 2ème année'),
(415001, 0, 0, 390, 415, 'LICPRO', '4159999911.', 'Licence professionnelle'),
(416001, 0, 0, 390, 416, '1DSAA', '4162200121.', 'Diplôme supérieur des arts appliqués : design, 1ère année'),
(416002, 0, 0, 390, 416, '2DSAA', '4162200122.', 'Diplôme supérieur des arts appliqués : design, 2ème année'),
(441001, 0, 0, 390, 441, '1PD2', '4413310131.', 'Infirmier ou infirmière niveau II, 1ère année'),
(441002, 0, 0, 390, 441, '2PD2', '4413310132.', 'Infirmier ou infirmière niveau II, 2ème année'),
(441003, 0, 0, 390, 441, '3PD2', '4413310133.', 'Infirmier ou infirmière niveau II, 3ème année'),
(740001, 0, 0, 740, 740, 'FCND5', '7409990111.', 'Formation complémentaire non diplômante hors MLDS de niveau 5'),
(741001, 0, 0, 740, 741, 'FCND4', '7419990111.', 'Formation complémentaire non diplômante hors MLDS de niveau 4'),
(742001, 0, 0, 740, 742, 'FCND3', '7429990111.', 'Formation complémentaire non diplômante hors MLDS de niveau 3'),
(753001, 0, 0, 740, 753, 'APF', '7534100111.', 'Accompagnement parcours de formation MLDS'),
(999999, 0, 0, 0, 0, '', '', '');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_niveau_famille`
--

CREATE TABLE IF NOT EXISTS `sacoche_niveau_famille` (
  `niveau_famille_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `niveau_famille_categorie` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1 = Niveaux usuels ; 2 = Niveaux particuliers ; 3 = Niveaux classes',
  `niveau_famille_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `niveau_famille_nom` varchar(63) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`niveau_famille_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_niveau_famille`
--

INSERT INTO `sacoche_niveau_famille` (`niveau_famille_id`, `niveau_famille_categorie`, `niveau_famille_ordre`, `niveau_famille_nom`) VALUES
(1, 2, 1, 'Cycles (regroupements de niveaux)'),
(2, 2, 2, 'CECRL (Cadre Européen Commun de Référence pour les Langues)'),
(3, 2, 3, 'APSA (Activités Physiques, Sportives et Artistiques)'),
(60, 3, 1, 'Premier degré'),
(100, 3, 2, 'Collège'),
(160, 3, 3, 'SEGPA / Pré-apprentissage'),
(200, 3, 4, 'Filière générale'),
(210, 3, 4, 'Filière technologique'),
(220, 3, 5, 'BT (Brevet de Technicien)'),
(240, 3, 6, 'CAP (Certificat d''Aptitude Professionnelle) en 1 an'),
(241, 3, 6, 'CAP (Certificat d''Aptitude Professionnelle) en 2 ans'),
(242, 3, 6, 'CAP (Certificat d''Aptitude Professionnelle) en 3 ans'),
(243, 3, 6, 'BEP (Brevet d''Etudes Professionnel)'),
(247, 3, 6, 'Bac Pro (Baccalauréat Professionnel)'),
(250, 3, 6, 'BMA (Brevet des Métiers d''Art) en 1 an'),
(251, 3, 6, 'BMA (Brevet des Métiers d''Art) en 2 ans'),
(253, 3, 6, 'MC (Mention Complémentaire)'),
(254, 3, 6, 'BP (Brevet Professionnel)'),
(271, 3, 6, 'CAPa (Certificat d''Aptitude Professionnelle Agricole)'),
(276, 3, 6, 'Bac Pro A (Baccalauréat Professionnel Agricole)'),
(290, 3, 6, 'Formations spécialisées'),
(301, 3, 6, 'CPGE (Classes Préparatoires aux Grandes Écoles)'),
(310, 3, 6, 'BTS (Brevet de Technicien Supérieur) en 1 an'),
(311, 3, 6, 'BTS (Brevet de Technicien Supérieur) en 2 ans'),
(312, 3, 6, 'BTS (Brevet de Technicien Supérieur) en 3 ans'),
(313, 3, 6, 'DTS (Diplôme de Technicien Supérieur)'),
(315, 3, 6, 'DMA (Diplôme des Métiers d''Art) en 1 an'),
(316, 3, 6, 'DMA (Diplôme des Métiers d''Art) en 2 ans'),
(350, 3, 6, 'DUT (Diplôme Universitaire de Technologie)'),
(370, 3, 6, 'BTSa (Brevet de Technicien Supérieur Agricole) en 1 an'),
(371, 3, 6, 'BTSa (Brevet de Technicien Supérieur Agricole) en 2 ans'),
(390, 3, 7, 'Préparations diverses post-BAC'),
(740, 3, 7, 'Formation complémentaire / Décrochage scolaire'),
(999, 1, 0, 'Niveaux principaux');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_notification`
--

CREATE TABLE IF NOT EXISTS `sacoche_notification` (
  `notification_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `abonnement_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notification_attente_id` mediumint(8) unsigned DEFAULT NULL COMMENT 'En cas de modification, pour retrouver une notification non encore envoyée ; passé à NULL une fois la notification envoyée.',
  `notification_statut` enum('attente','consultable','consultée','envoyée') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'attente',
  `notification_date` datetime DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `notification_contenu` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `user_id` (`user_id`),
  KEY `abonnement_ref` (`abonnement_ref`),
  KEY `notification_attente_id` (`notification_attente_id`),
  KEY `notification_statut` (`notification_statut`),
  KEY `notification_date` (`notification_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='En lien avec les tables sacoche_abonnement et sacoche_jointure_user_abonnement.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_officiel_archive`
--

CREATE TABLE IF NOT EXISTS `sacoche_officiel_archive` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `structure_uai` char(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `annee_scolaire` varchar(9) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `archive_type` enum('sacoche','livret') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'sacoche',
  `archive_ref` varchar(9) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Valeur de livret_page_ref ou de officiel_type.',
  `periode_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `periode_nom` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Pour garder trace de cette chaîne.',
  `structure_denomination` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Pour garder trace de cette chaîne.',
  `sacoche_version` varchar(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Pour adapter le code de restauration de l''archive si besoin.',
  `archive_date_generation` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `archive_date_consultation_eleve` date DEFAULT NULL,
  `archive_date_consultation_parent` date DEFAULT NULL,
  `archive_contenu` text COLLATE utf8_unicode_ci NOT NULL,
  `archive_md5_image1` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `archive_md5_image2` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `archive_md5_image3` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  UNIQUE KEY `archive_id` (`user_id`,`structure_uai`,`annee_scolaire`,`archive_type`,`archive_ref`,`periode_id`),
  KEY `structure_uai` (`structure_uai`),
  KEY `annee_scolaire` (`annee_scolaire`),
  KEY `archive_type` (`archive_type`),
  KEY `archive_ref` (`archive_ref`),
  KEY `periode_id` (`periode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_officiel_archive_image`
--

CREATE TABLE IF NOT EXISTS `sacoche_officiel_archive_image` (
  `archive_image_md5` char(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `archive_image_contenu` mediumblob NOT NULL COMMENT 'Archivage des images de sacoche_officiel_archive ici car cela fait gagner beaucoup de place (logo ou tampon de l''établissement inséré à chaque fois).',
  PRIMARY KEY (`archive_image_md5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_officiel_assiduite`
--

CREATE TABLE IF NOT EXISTS `sacoche_officiel_assiduite` (
  `periode_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `assiduite_absence` tinyint(3) unsigned DEFAULT NULL COMMENT 'nombre total d''absences',
  `assiduite_absence_nj` tinyint(3) unsigned DEFAULT NULL COMMENT 'nombre d''absences non justifiées',
  `assiduite_retard` tinyint(3) unsigned DEFAULT NULL COMMENT 'nombre de retards',
  `assiduite_retard_nj` tinyint(3) unsigned DEFAULT NULL COMMENT 'nombre de retards non justifiés',
  PRIMARY KEY (`user_id`,`periode_id`),
  KEY `periode_id` (`periode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_officiel_fichier`
--

CREATE TABLE IF NOT EXISTS `sacoche_officiel_fichier` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `officiel_type` enum('releve','bulletin','palier1','palier2','palier3') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'bulletin',
  `periode_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fichier_date_generation` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `fichier_date_consultation_eleve` date DEFAULT NULL,
  `fichier_date_consultation_parent` date DEFAULT NULL,
  UNIQUE KEY `user_id` (`user_id`,`officiel_type`,`periode_id`),
  KEY `officiel_type` (`officiel_type`),
  KEY `periode_id` (`periode_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_officiel_saisie`
--

CREATE TABLE IF NOT EXISTS `sacoche_officiel_saisie` (
  `officiel_type` enum('releve','bulletin','palier1','palier2','palier3') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'bulletin',
  `periode_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `eleve_ou_classe_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'id élève ou classe suivant le champ saisie_type',
  `rubrique_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'matiere_id ou pilier_id ; 0 pour l''appréciation de synthèse ou la moyenne générale',
  `prof_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '0 pour la moyenne, avec commentaire dans saisie_appreciation si report non automatique',
  `saisie_type` enum('eleve','classe') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'eleve' COMMENT 'indique si la saisie concerne un élève ou une classe',
  `saisie_note` decimal(3,1) unsigned DEFAULT NULL COMMENT 'sur 20, à multiplier par 5 pour avoir le pourcentage',
  `saisie_appreciation` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`eleve_ou_classe_id`,`officiel_type`,`periode_id`,`rubrique_id`,`prof_id`,`saisie_type`),
  KEY `officiel_type` (`officiel_type`),
  KEY `periode_id` (`periode_id`),
  KEY `rubrique_id` (`rubrique_id`),
  KEY `prof_id` (`prof_id`),
  KEY `saisie_type` (`saisie_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_parametre`
--

CREATE TABLE IF NOT EXISTS `sacoche_parametre` (
  `parametre_nom` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parametre_valeur` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`parametre_nom`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_parametre`
--

INSERT INTO `sacoche_parametre` (`parametre_nom`, `parametre_valeur`) VALUES
('calcul_limite', '5'),
('calcul_methode', 'geometrique'),
('calcul_retroactif', 'oui'),
('cas_serveur_host', 'scribe25.ac-igor.fr'),
('cas_serveur_port', '8443'),
('cas_serveur_root', ''),
('cas_serveur_url_login', ''),
('cas_serveur_url_logout', ''),
('cas_serveur_url_validate', ''),
('cas_serveur_verif_certif_ssl', '0'),
('connexion_departement', ''),
('connexion_mode', 'cas'),
('connexion_nom', 'perso'),
('date_last_import_eleves', '0000-00-00'),
('date_last_import_parents', '0000-00-00'),
('date_last_import_professeurs', '0000-00-00'),
('deconnexion_adresse_redirection', ''),
('droit_affecter_langue', 'DIR,ENS,ONLY_LV'),
('droit_annulation_pilier', 'DIR'),
('droit_fiche_brevet_appreciation_generale', 'DIR'),
('droit_fiche_brevet_corriger_appreciation', 'DIR'),
('droit_fiche_brevet_impression_pdf', 'DIR'),
('droit_fiche_brevet_modifier_statut', 'DIR'),
('droit_fiche_brevet_voir_archive', 'DIR,ENS,DOC,EDU'),
('droit_gerer_referentiel', 'ENS,DOC,EDU,ONLY_COORD'),
('droit_gerer_ressource', 'ENS,DOC,EDU'),
('droit_modifier_email', 'DIR,ENS,DOC,EDU,TUT,ELV'),
('droit_modifier_mdp', 'DIR,ENS,DOC,EDU,TUT,ELV'),
('droit_officiel_bulletin_appreciation_generale', 'DIR,ENS,ONLY_PP'),
('droit_officiel_bulletin_corriger_appreciation', 'DIR'),
('droit_officiel_bulletin_impression_pdf', 'DIR'),
('droit_officiel_bulletin_modifier_statut', 'DIR'),
('droit_officiel_bulletin_voir_archive', 'DIR,ENS,DOC,EDU'),
('droit_officiel_livret_appreciation_generale', 'DIR,ENS,ONLY_PP'),
('droit_officiel_livret_corriger_appreciation', 'DIR'),
('droit_officiel_livret_impression_pdf', 'DIR'),
('droit_officiel_livret_modifier_statut', 'DIR'),
('droit_officiel_livret_voir_archive', 'DIR,ENS,DOC,EDU'),
('droit_officiel_releve_appreciation_generale', 'DIR,ENS,ONLY_PP'),
('droit_officiel_releve_corriger_appreciation', 'DIR'),
('droit_officiel_releve_impression_pdf', 'DIR'),
('droit_officiel_releve_modifier_statut', 'DIR'),
('droit_officiel_releve_voir_archive', 'DIR,ENS,DOC,EDU'),
('droit_officiel_saisir_assiduite', 'DIR,EDU'),
('droit_officiel_socle_appreciation_generale', 'DIR,ENS,ONLY_PP'),
('droit_officiel_socle_corriger_appreciation', 'DIR'),
('droit_officiel_socle_impression_pdf', 'DIR'),
('droit_officiel_socle_modifier_statut', 'DIR'),
('droit_officiel_socle_voir_archive', 'DIR,ENS,DOC,EDU'),
('droit_releve_conversion_sur_20', ''),
('droit_releve_etat_acquisition', 'TUT,ELV'),
('droit_releve_moyenne_score', 'TUT,ELV'),
('droit_releve_pourcentage_acquis', 'TUT,ELV'),
('droit_socle_acces', 'TUT,ELV'),
('droit_socle_etat_validation', ''),
('droit_socle_pourcentage_acquis', 'TUT,ELV'),
('droit_socle_proposition_positionnement', 'TUT,ELV'),
('droit_validation_entree', 'DIR,ENS,DOC,EDU'),
('droit_validation_pilier', 'DIR,ENS,ONLY_PP'),
('droit_voir_etat_acquisition_avec_evaluation', ''),
('droit_voir_grilles_items', 'DIR,ENS,DOC,EDU,TUT,ELV'),
('droit_voir_param_algorithme', 'DIR,ENS,DOC,EDU,TUT,ELV'),
('droit_voir_param_notes_acquis', 'DIR,ENS,DOC,EDU,TUT,ELV'),
('droit_voir_referentiels', 'DIR,ENS,DOC,EDU,TUT,ELV'),
('droit_voir_score_bilan', 'DIR,ENS,DOC,EDU,TUT,ELV'),
('enveloppe_horizontal_droite', '20'),
('enveloppe_horizontal_gauche', '110'),
('enveloppe_horizontal_milieu', '100'),
('enveloppe_vertical_bas', '20'),
('enveloppe_vertical_haut', '50'),
('enveloppe_vertical_milieu', '45'),
('etablissement_adresse1', ''),
('etablissement_adresse2', ''),
('etablissement_adresse3', ''),
('etablissement_chef_id', '0'),
('etablissement_courriel', ''),
('etablissement_denomination', 'scribe25'),
('etablissement_fax', ''),
('etablissement_ip_variable', '0'),
('etablissement_langue', 'fr_FR'),
('etablissement_telephone', ''),
('etablissement_url', ''),
('gepi_certificat_empreinte', ''),
('gepi_rne', ''),
('gepi_url', ''),
('liste_paliers_actifs', ''),
('mois_bascule_annee_scolaire', '8'),
('nombre_codes_notation', '4'),
('nombre_etats_acquisition', '3'),
('officiel_bulletin_acquis_texte_code', '1'),
('officiel_bulletin_acquis_texte_nombre', '1'),
('officiel_bulletin_appreciation_generale_longueur', '400'),
('officiel_bulletin_appreciation_generale_modele', ''),
('officiel_bulletin_appreciation_generale_report', ''),
('officiel_bulletin_appreciation_rubrique_longueur', '400'),
('officiel_bulletin_appreciation_rubrique_modele', ''),
('officiel_bulletin_appreciation_rubrique_report', ''),
('officiel_bulletin_assiduite', '0'),
('officiel_bulletin_barre_acquisitions', '1'),
('officiel_bulletin_conversion_sur_20', '1'),
('officiel_bulletin_couleur', 'oui'),
('officiel_bulletin_fond', 'gris'),
('officiel_bulletin_fusion_niveaux', '1'),
('officiel_bulletin_legende', 'oui'),
('officiel_bulletin_ligne_supplementaire', ''),
('officiel_bulletin_moyenne_classe', '1'),
('officiel_bulletin_moyenne_exception_matieres', ''),
('officiel_bulletin_moyenne_generale', '0'),
('officiel_bulletin_moyenne_scores', '1'),
('officiel_bulletin_only_socle', '0'),
('officiel_bulletin_prof_principal', '0'),
('officiel_bulletin_retroactif', 'non'),
('officiel_infos_etablissement', 'denomination,adresse,telephone,fax,courriel,url'),
('officiel_infos_responsables', 'non'),
('officiel_marge_bas', '10'),
('officiel_marge_droite', '5'),
('officiel_marge_gauche', '5'),
('officiel_marge_haut', '5'),
('officiel_nombre_exemplaires', 'un'),
('officiel_releve_aff_coef', '0'),
('officiel_releve_aff_domaine', '0'),
('officiel_releve_aff_reference', '1'),
('officiel_releve_aff_socle', '1'),
('officiel_releve_aff_theme', '0'),
('officiel_releve_appreciation_generale_longueur', '400'),
('officiel_releve_appreciation_generale_modele', ''),
('officiel_releve_appreciation_generale_report', ''),
('officiel_releve_appreciation_rubrique_longueur', '400'),
('officiel_releve_appreciation_rubrique_modele', ''),
('officiel_releve_appreciation_rubrique_report', ''),
('officiel_releve_assiduite', '0'),
('officiel_releve_cases_nb', '4'),
('officiel_releve_conversion_sur_20', '0'),
('officiel_releve_couleur', 'oui'),
('officiel_releve_etat_acquisition', '1'),
('officiel_releve_fond', 'gris'),
('officiel_releve_legende', 'oui'),
('officiel_releve_ligne_supplementaire', ''),
('officiel_releve_moyenne_scores', '1'),
('officiel_releve_only_etat', 'tous'),
('officiel_releve_only_socle', '0'),
('officiel_releve_pages_nb', 'optimise'),
('officiel_releve_pourcentage_acquis', '1'),
('officiel_releve_prof_principal', '0'),
('officiel_releve_retroactif', 'non'),
('officiel_socle_appreciation_generale_longueur', '400'),
('officiel_socle_appreciation_generale_modele', ''),
('officiel_socle_appreciation_generale_report', ''),
('officiel_socle_appreciation_rubrique_longueur', '0'),
('officiel_socle_appreciation_rubrique_modele', ''),
('officiel_socle_appreciation_rubrique_report', ''),
('officiel_socle_assiduite', '0'),
('officiel_socle_couleur', 'oui'),
('officiel_socle_etat_validation', '1'),
('officiel_socle_fond', 'gris'),
('officiel_socle_legende', 'oui'),
('officiel_socle_ligne_supplementaire', ''),
('officiel_socle_only_presence', '0'),
('officiel_socle_pourcentage_acquis', '1'),
('officiel_socle_prof_principal', '0'),
('officiel_tampon_signature', 'signature_ou_tampon'),
('sesamath_id', '0'),
('sesamath_key', ''),
('sesamath_type_nom', ''),
('sesamath_uai', ''),
('version_base', '2016-10-03'),
('version_base_maj_complementaire', ''),
('webmestre_denomination', 'scribe25'),
('webmestre_uai', '0000000E');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_parametre_acquis`
--

CREATE TABLE IF NOT EXISTS `sacoche_parametre_acquis` (
  `acquis_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `acquis_actif` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Au minimum 2 états d''acquisition actifs',
  `acquis_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'De 1 à 6 ; à considérer pour tous les affichages',
  `acquis_seuil_min` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Entre 0 et 99 ; pour les états actifs, doit être cohérent avec l''ordre.',
  `acquis_seuil_max` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Entre 1 et 100 ; pour les états actifs, doit être cohérent avec l''ordre.',
  `acquis_valeur` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Pourcentage d''acquisition considéré (entre 0 à 100) ; pour les états actifs, doit être cohérent avec l''ordre.',
  `acquis_couleur` char(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '#ffffff',
  `acquis_sigle` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `acquis_legende` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`acquis_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Contenu de la table `sacoche_parametre_acquis`
--

INSERT INTO `sacoche_parametre_acquis` (`acquis_id`, `acquis_actif`, `acquis_ordre`, `acquis_seuil_min`, `acquis_seuil_max`, `acquis_valeur`, `acquis_couleur`, `acquis_sigle`, `acquis_legende`) VALUES
(1, 1, 1, 0, 39, 0, '#ff9999', 'NA', 'Non acquis.'),
(2, 1, 2, 40, 60, 50, '#ffdd33', 'VA', 'Partiellement acquis.'),
(3, 1, 3, 61, 100, 100, '#99ff99', 'A', 'Acquis.'),
(4, 0, 4, 0, 0, 0, '#ffffff', '', ''),
(5, 0, 5, 0, 0, 0, '#ffffff', '', ''),
(6, 0, 6, 0, 0, 0, '#ffffff', '', '');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_parametre_note`
--

CREATE TABLE IF NOT EXISTS `sacoche_parametre_note` (
  `note_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `note_actif` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Au minimum 2 codes de notation actifs',
  `note_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'De 1 à 6 ; à considérer pour tous les affichages',
  `note_valeur` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'De 0 à 200 (en général 100 maxi) ; pour les codes actifs, doit être cohérent avec l''ordre.',
  `note_image` varchar(63) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'X',
  `note_sigle` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Équivalent textuel pour les impressions en niveaux de gris',
  `note_legende` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `note_clavier` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'De 1 à 9',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Contenu de la table `sacoche_parametre_note`
--

INSERT INTO `sacoche_parametre_note` (`note_id`, `note_actif`, `note_ordre`, `note_valeur`, `note_image`, `note_sigle`, `note_legende`, `note_clavier`) VALUES
(1, 1, 1, 0, 'disque-double_rouge', 'RR', 'Très insuffisant.', 1),
(2, 1, 2, 33, 'disque_rouge', 'R', 'Insuffisant.', 2),
(3, 1, 3, 67, 'disque_vert-fonce', 'V', 'Satisfaisant.', 3),
(4, 1, 4, 100, 'disque-double_vert-fonce', 'VV', 'Très satisfaisant.', 4),
(5, 0, 5, 0, 'X', '', '', 5),
(6, 0, 6, 0, 'X', '', '', 6);

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_parent_adresse`
--

CREATE TABLE IF NOT EXISTS `sacoche_parent_adresse` (
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `adresse_ligne1` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adresse_ligne2` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adresse_ligne3` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adresse_ligne4` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adresse_postal_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '@see http://fr.wikipedia.org/wiki/Code_postal',
  `adresse_postal_libelle` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adresse_pays_nom` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_periode`
--

CREATE TABLE IF NOT EXISTS `sacoche_periode` (
  `periode_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `periode_ordre` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `periode_nom` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `periode_livret` enum('','T1','T2','T3','S1','S2') COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Période officielle utilisable pour le livret scolaire.',
  PRIMARY KEY (`periode_id`),
  KEY `periode_livret` (`periode_livret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_referentiel`
--

CREATE TABLE IF NOT EXISTS `sacoche_referentiel` (
  `matiere_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `niveau_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `referentiel_partage_etat` enum('bof','non','oui','hs') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'non' COMMENT '[oui] = référentiel partagé sur le serveur communautaire ; [non] = référentiel non partagé avec la communauté ; [bof] = référentiel dont le partage est sans intérêt (pas novateur) ; [hs] = référentiel dont le partage est sans objet (matière spécifique)',
  `referentiel_partage_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `referentiel_calcul_methode` enum('geometrique','arithmetique','classique','bestof1','bestof2','bestof3','frequencemin','frequencemax') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'geometrique' COMMENT 'Coefficients en progression géométrique, arithmetique, ou moyenne classique non pondérée, ou conservation des meilleurs scores, ou de la plus fréquente. Valeur surclassant la configuration par défaut.',
  `referentiel_calcul_limite` tinyint(3) unsigned NOT NULL DEFAULT '5' COMMENT 'Nombre maximum de dernières évaluations prises en comptes (0 pour les prendre toutes). Valeur surclassant la configuration par défaut.',
  `referentiel_calcul_retroactif` enum('non','oui','annuel') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'non' COMMENT 'Avec ou sans prise en compte des évaluations antérieures. Valeur surclassant la configuration par défaut.',
  `referentiel_mode_synthese` enum('inconnu','sans','domaine','theme') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'inconnu',
  `referentiel_information` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`matiere_id`,`niveau_id`),
  KEY `niveau_id` (`niveau_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_referentiel_domaine`
--

CREATE TABLE IF NOT EXISTS `sacoche_referentiel_domaine` (
  `domaine_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `matiere_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `niveau_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `domaine_ordre` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Commence à 1.',
  `domaine_code` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `domaine_ref` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `domaine_nom` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`domaine_id`),
  KEY `matiere_id` (`matiere_id`),
  KEY `niveau_id` (`niveau_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_referentiel_item`
--

CREATE TABLE IF NOT EXISTS `sacoche_referentiel_item` (
  `item_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `theme_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entree_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `item_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Commence à 0.',
  `item_ref` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `item_nom` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `item_abrev` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `item_coef` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `item_cart` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '0 pour empêcher les élèves de demander une évaluation sur cet item.',
  `item_lien` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `item_comm` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'Commentaire associé à l''item, par exemple des échelles descriptives.',
  PRIMARY KEY (`item_id`),
  KEY `theme_id` (`theme_id`),
  KEY `entree_id` (`entree_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_referentiel_theme`
--

CREATE TABLE IF NOT EXISTS `sacoche_referentiel_theme` (
  `theme_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `domaine_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `theme_ordre` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Commence à 1.',
  `theme_ref` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `theme_nom` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`theme_id`),
  KEY `domaine_id` (`domaine_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_saisie`
--

CREATE TABLE IF NOT EXISTS `sacoche_saisie` (
  `prof_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `eleve_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `devoir_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `item_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `saisie_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  `saisie_note` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'NN',
  `saisie_info` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Enregistrement statique du nom du devoir et du professeur, conservé les années suivantes.',
  `saisie_visible_date` date DEFAULT NULL COMMENT 'Ne vaut normalement jamais NULL.',
  PRIMARY KEY (`devoir_id`,`eleve_id`,`item_id`),
  KEY `prof_id` (`prof_id`),
  KEY `eleve_id` (`eleve_id`),
  KEY `item_id` (`item_id`),
  KEY `saisie_date` (`saisie_date`),
  KEY `saisie_visible_date` (`saisie_visible_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_selection_item`
--

CREATE TABLE IF NOT EXISTS `sacoche_selection_item` (
  `selection_item_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `proprio_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `selection_item_nom` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`selection_item_id`),
  KEY `proprio_id` (`proprio_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_siecle_import`
--

CREATE TABLE IF NOT EXISTS `sacoche_siecle_import` (
  `siecle_import_objet` varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `siecle_import_date` date DEFAULT NULL,
  `siecle_import_annee` char(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `siecle_import_contenu` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`siecle_import_objet`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_siecle_import`
--

INSERT INTO `sacoche_siecle_import` (`siecle_import_objet`, `siecle_import_date`, `siecle_import_annee`, `siecle_import_contenu`) VALUES
('sts_emp_UAI', NULL, NULL, ''),
('Nomenclature', NULL, NULL, ''),
('Eleves', NULL, NULL, '');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_socle_composante`
--

CREATE TABLE IF NOT EXISTS `sacoche_socle_composante` (
  `socle_composante_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `socle_domaine_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `socle_composante_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `socle_composante_ordre_livret` tinyint(3) unsigned DEFAULT NULL,
  `socle_composante_nom` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`socle_composante_id`),
  KEY `socle_domaine_id` (`socle_domaine_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_socle_composante`
--

INSERT INTO `sacoche_socle_composante` (`socle_composante_id`, `socle_domaine_id`, `socle_composante_ordre`, `socle_composante_ordre_livret`, `socle_composante_nom`) VALUES
(11, 1, 1, 1, 'Langue française à l''oral et à l''écrit'),
(12, 1, 2, 4, 'Langues étrangères et régionales'),
(13, 1, 3, 2, 'Langages mathématiques, scientifiques et informatiques'),
(14, 1, 4, 6, 'Langages des arts et du corps'),
(21, 2, 1, NULL, 'Organisation du travail personnel'),
(22, 2, 2, NULL, 'Coopération et réalisation de projets'),
(23, 2, 3, NULL, 'Médias, démarches de recherche et de traitement de l''information'),
(24, 2, 4, NULL, 'Outils numériques pour échanger et communiquer'),
(31, 3, 1, NULL, 'Expression de la sensibilité et des opinions, respect des autres'),
(32, 3, 2, NULL, 'La règle et le droit'),
(33, 3, 3, NULL, 'Réflexion et discernement'),
(34, 3, 4, NULL, 'Responsabilité, sens de l''engagement et de l''initiative'),
(41, 4, 1, NULL, 'Démarches scientifiques'),
(42, 4, 2, NULL, 'Conception, création, réalisation'),
(43, 4, 3, NULL, 'Responsabilités individuelles et collectives'),
(44, 4, 4, NULL, 'Connaissances à mobiliser'),
(51, 5, 1, NULL, 'L''espace et le temps'),
(52, 5, 2, NULL, 'Organisations et représentations du monde'),
(53, 5, 3, NULL, 'Invention, élaboration, production'),
(54, 5, 4, NULL, 'Connaissances à mobiliser');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_socle_cycle`
--

CREATE TABLE IF NOT EXISTS `sacoche_socle_cycle` (
  `socle_cycle_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `socle_cycle_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `socle_cycle_nom` char(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `socle_cycle_description` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`socle_cycle_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_socle_cycle`
--

INSERT INTO `sacoche_socle_cycle` (`socle_cycle_id`, `socle_cycle_ordre`, `socle_cycle_nom`, `socle_cycle_description`) VALUES
(2, 1, 'Cycle 2', 'CP CE1 CE2 (apprentissages fondamentaux)'),
(3, 2, 'Cycle 3', 'CM1 CM2 6e (consolidation)'),
(4, 3, 'Cycle 4', '5e 4e 3e (approfondissements)');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_socle_domaine`
--

CREATE TABLE IF NOT EXISTS `sacoche_socle_domaine` (
  `socle_domaine_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `socle_domaine_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `socle_domaine_ordre_livret` tinyint(3) unsigned DEFAULT NULL,
  `socle_domaine_nom` varchar(44) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`socle_domaine_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_socle_domaine`
--

INSERT INTO `sacoche_socle_domaine` (`socle_domaine_id`, `socle_domaine_ordre`, `socle_domaine_ordre_livret`, `socle_domaine_nom`) VALUES
(1, 1, NULL, 'Langages pour penser et communiquer'),
(2, 2, 8, 'Méthodes et outils pour apprendre'),
(3, 3, 7, 'Formation de la personne et du citoyen'),
(4, 4, 5, 'Systèmes naturels et systèmes techniques'),
(5, 5, 3, 'Représentations du monde et activité humaine');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_socle_entree`
--

CREATE TABLE IF NOT EXISTS `sacoche_socle_entree` (
  `entree_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `section_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `entree_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Commence à 0.',
  `entree_nom` varchar(235) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`entree_id`),
  KEY `section_id` (`section_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=21211 ;

--
-- Contenu de la table `sacoche_socle_entree`
--

INSERT INTO `sacoche_socle_entree` (`entree_id`, `section_id`, `entree_ordre`, `entree_nom`) VALUES
(111, 44, 0, 'Adapter son mode de lecture à la nature du texte proposé et à l’objectif poursuivi.'),
(112, 44, 1, 'Repérer les informations dans un texte à partir des éléments explicites et des éléments implicites nécessaires.'),
(113, 44, 2, 'Utiliser ses capacités de raisonnement, ses connaissances sur la langue, savoir faire appel à des outils appropriés pour lire.'),
(114, 44, 3, 'Dégager, par écrit ou oralement, l’essentiel d’un texte lu.'),
(115, 44, 4, 'Manifester, par des moyens divers, sa compréhension de textes variés.'),
(121, 45, 0, 'Reproduire un document sans erreur et avec une présentation adaptée.'),
(122, 45, 1, 'Écrire lisiblement un texte, spontanément ou sous la dictée, en respectant l’orthographe et la grammaire.'),
(123, 45, 2, 'Rédiger un texte bref, cohérent et ponctué, en réponse à une question ou à partir de consignes données.'),
(124, 45, 3, 'Utiliser ses capacités de raisonnement, ses connaissances sur la langue, savoir faire appel à des outils variés pour améliorer son texte.'),
(131, 46, 0, 'Formuler clairement un propos simple.'),
(132, 46, 1, 'Développer de façon suivie un propos en public sur un sujet déterminé.'),
(133, 46, 2, 'Adapter sa prise de parole à la situation de communication.'),
(134, 46, 3, 'Participer à un débat, à un échange verbal.'),
(211, 48, 0, 'Établir un contact social.'),
(212, 48, 1, 'Dialoguer sur des sujets familiers.'),
(213, 48, 2, 'Demander et donner des informations.'),
(214, 48, 3, 'Réagir à des propositions.'),
(221, 49, 0, 'Comprendre un message oral pour réaliser une tâche.'),
(222, 49, 1, 'Comprendre les points essentiels d’un message oral (conversation, information, récit, exposé).'),
(231, 50, 0, 'Reproduire un modèle oral.'),
(232, 50, 1, 'Décrire, raconter, expliquer.'),
(233, 50, 2, 'Présenter un projet et lire à haute voix.'),
(241, 51, 0, 'Comprendre le sens général de documents écrits.'),
(242, 51, 1, 'Savoir repérer des informations dans un texte.'),
(251, 52, 0, 'Copier, écrire sous la dictée.'),
(252, 52, 1, 'Renseigner un questionnaire.'),
(253, 52, 2, 'Écrire un message simple.'),
(254, 52, 3, 'Rendre compte de faits.'),
(255, 52, 4, 'Écrire un court récit, une description.'),
(311, 53, 0, 'Rechercher, extraire et organiser l’information utile.'),
(312, 53, 1, 'Réaliser, manipuler, mesurer, calculer, appliquer des consignes.'),
(313, 53, 2, 'Raisonner, argumenter, pratiquer une démarche expérimentale ou technologique, démontrer.'),
(314, 53, 3, 'Présenter la démarche suivie, les résultats obtenus, communiquer à l’aide d’un langage adapté.'),
(321, 54, 0, 'Organisation et gestion de données : reconnaître des situations de proportionnalité, utiliser des pourcentages, des tableaux, des graphiques. Exploiter des données statistiques et aborder des situations simples de probabilité.'),
(322, 54, 1, 'Nombres et calculs : connaître et utiliser les nombres entiers, décimaux et fractionnaires. Mener à bien un calcul : mental, à la main, à la calculatrice, avec un ordinateur.'),
(323, 54, 2, 'Géométrie : connaître et représenter des figures géométriques et des objets de l’espace. Utiliser leurs propriétés.'),
(324, 54, 3, 'Grandeurs et mesures : réaliser des mesures (longueurs, durées, …), calculer des valeurs (volumes, vitesses, …) en utilisant différentes unités.'),
(331, 55, 0, 'L’univers et la Terre : organisation de l’univers ; structure et évolution au cours des temps géologiques de la Terre, phénomènes physiques.'),
(332, 55, 1, 'La matière : principales caractéristiques, états et transformations ; propriétés physiques et chimiques de la matière et des matériaux ; comportement électrique, interactions avec la lumière.'),
(333, 55, 2, 'Le vivant : unité d’organisation et diversité ; fonctionnement des organismes vivants, évolution des espèces, organisation et fonctionnement du corps humain.'),
(334, 55, 3, 'L’énergie : différentes formes d’énergie, notamment l’énergie électrique, et transformations d’une forme à une autre.'),
(335, 55, 4, 'Les objets techniques : analyse, conception et réalisation ; fonctionnement et conditions d’utilisation.'),
(341, 56, 0, 'Mobiliser ses connaissances pour comprendre des questions liées à l’environnement et au développement durable.'),
(411, 57, 0, 'Utiliser, gérer des espaces de stockage à disposition.'),
(412, 57, 1, 'Utiliser les périphériques à disposition.'),
(413, 57, 2, 'Utiliser les logiciels et les services à disposition.'),
(421, 58, 0, 'Connaître et respecter les règles élémentaires du droit relatif à sa pratique.'),
(422, 58, 1, 'Protéger sa personne et ses données.'),
(423, 58, 2, 'Faire preuve d’esprit critique face à l’information et à son traitement.'),
(424, 58, 3, 'Participer à des travaux collaboratifs en connaissant les enjeux et en respectant les règles.'),
(431, 59, 0, 'Saisir et mettre en page un texte.'),
(432, 59, 1, 'Traiter une image, un son ou une vidéo.'),
(433, 59, 2, 'Organiser la composition du document, prévoir sa présentation en fonction de sa destination.'),
(434, 59, 3, 'Différencier une situation simulée ou modélisée d’une situation réelle.'),
(441, 60, 0, 'Consulter des bases de données documentaires en mode simple (plein texte).'),
(442, 60, 1, 'Identifier, trier et évaluer des ressources.'),
(443, 60, 2, 'Chercher et sélectionner l’information demandée.'),
(453, 61, 0, 'Écrire, envoyer, diffuser, publier.'),
(454, 61, 1, 'Recevoir un commentaire, un message y compris avec pièces jointes.'),
(455, 61, 2, 'Exploiter les spécificités des différentes situations de communication en temps réel ou différé.'),
(511, 62, 0, 'Relevant de l’espace : les grands ensembles physiques et humains et les grands types d’aménagements dans le monde, les principales caractéristiques géographiques de la France et de l’Europe.'),
(512, 62, 1, 'Relevant du temps : les différentes périodes de l’histoire de l’humanité - Les grands traits de l’histoire (politique, sociale, économique, littéraire, artistique, culturelle) de la France et de l’Europe.'),
(513, 62, 2, 'Relevant de la culture littéraire : œuvres littéraires du patrimoine.'),
(514, 62, 3, 'Relevant de la culture artistique : œuvres picturales, musicales, scéniques, architecturales ou cinématographiques du patrimoine.'),
(515, 62, 4, 'Relevant de la culture civique : Droits de l’Homme - Formes d’organisation politique, économique et sociale dans l’Union européenne - Place et rôle de l’État en France - Mondialisation - Développement durable.'),
(521, 67, 0, 'Situer des événements, des œuvres littéraires ou artistiques, des découvertes scientifiques ou techniques, des ensembles géographiques.'),
(522, 67, 1, 'Identifier la diversité des civilisations, des langues, des sociétés, des religions.'),
(523, 67, 2, 'Établir des liens entre les œuvres (littéraires, artistiques) pour mieux les comprendre.'),
(524, 67, 3, 'Mobiliser ses connaissances pour donner du sens à l’actualité.'),
(531, 66, 0, 'Lire et employer différents langages : textes – graphiques – cartes – images – musique.'),
(532, 66, 1, 'Connaître et pratiquer diverses formes d’expression à visée littéraire.'),
(533, 66, 2, 'Connaître et pratiquer diverses formes d’expression à visée artistique.'),
(541, 74, 0, 'Être sensible aux enjeux esthétiques et humains d’un texte littéraire.'),
(542, 74, 1, 'Être sensible aux enjeux esthétiques et humains d’une œuvre artistique.'),
(543, 74, 2, 'Être capable de porter un regard critique sur un fait, un document, une œuvre.'),
(544, 74, 3, 'Manifester sa curiosité pour l’actualité et pour les activités culturelles ou artistiques.'),
(611, 68, 0, 'Principaux droits de l’Homme et du citoyen.'),
(612, 68, 1, 'Valeurs, symboles, institutions de la République.'),
(613, 68, 2, 'Règles fondamentales de la démocratie et de la justice.'),
(614, 68, 3, 'Grandes institutions de l’Union européenne et rôle des grands organismes internationaux.'),
(615, 68, 4, 'Rôle de la défense nationale.'),
(616, 68, 5, 'Fonctionnement et rôle de différents médias.'),
(621, 69, 0, 'Respecter les règles de la vie collective.'),
(622, 69, 1, 'Comprendre l’importance du respect mutuel et accepter toutes les différences.'),
(623, 69, 2, 'Respecter des comportements favorables à sa santé et sa sécurité.'),
(624, 69, 3, 'Respecter quelques notions juridiques de base.'),
(625, 69, 4, 'Savoir utiliser quelques notions économiques et budgétaires de base.'),
(711, 70, 0, 'Se familiariser avec l’environnement économique, les entreprises, les métiers de secteurs et de niveaux de qualification variés.'),
(712, 70, 1, 'Connaître les parcours de formation correspondant à ces métiers et les possibilités de s’y intégrer.'),
(713, 70, 2, 'Savoir s’autoévaluer et être capable de décrire ses intérêts, ses compétences et ses acquis.'),
(721, 71, 0, 'Être autonome dans son travail : savoir l’organiser, le planifier, l’anticiper, rechercher et sélectionner des informations utiles.'),
(722, 71, 1, 'Identifier ses points forts et ses points faibles dans des situations variées.'),
(723, 71, 2, 'Mobiliser à bon escient ses capacités motrices dans le cadre d’une pratique physique (sportive ou artistique) adaptée à son potentiel.'),
(724, 71, 3, 'Savoir nager.'),
(731, 72, 0, 'S’engager dans un projet individuel.'),
(732, 72, 1, 'S’intégrer et coopérer dans un projet collectif.'),
(733, 72, 2, 'Manifester curiosité, créativité, motivation à travers des activités conduites ou reconnues par l’établissement.'),
(734, 72, 3, 'Assumer des rôles, prendre des initiatives et des décisions.'),
(2111, 13, 0, 'S’exprimer à l’oral comme à l’écrit dans un vocabulaire approprié et précis.'),
(2112, 13, 1, 'Prendre la parole en respectant le niveau de langue adapté.'),
(2113, 13, 2, 'Répondre à une question par une phrase complète à l’oral.'),
(2114, 13, 3, 'Prendre part à un dialogue : prendre la parole devant les autres, écouter autrui, formuler et justifier un point de vue.'),
(2115, 13, 4, 'Dire de mémoire, de façon expressive, une dizaine de poèmes et de textes en prose.'),
(2121, 14, 0, 'Lire avec aisance (à haute voix, silencieusement) un texte.'),
(2122, 14, 1, 'Lire seul des textes du patrimoine et des œuvres intégrales de la littérature de jeunesse, adaptés à son âge.'),
(2123, 14, 2, 'Lire seul et comprendre un énoncé, une consigne.'),
(2124, 14, 3, 'Dégager le thème d’un texte.'),
(2125, 14, 4, 'Repérer dans un texte des informations explicites.'),
(2126, 14, 5, 'Inférer des informations nouvelles (implicites).'),
(2127, 14, 6, 'Repérer les effets de choix formels (emploi de certains mots, utilisation d’un niveau de langue).'),
(2128, 14, 7, 'Utiliser ses connaissances pour réfléchir sur un texte, mieux le comprendre.'),
(2129, 14, 8, 'Effectuer, seul, des recherches dans des ouvrages documentaires (livres, produits multimédia).'),
(21210, 14, 9, 'Se repérer dans une bibliothèque, une médiathèque.'),
(2131, 15, 0, 'Copier sans erreur un texte d’au moins quinze lignes en lui donnant une présentation adaptée.'),
(2132, 15, 1, 'Utiliser ses connaissances pour réfléchir sur un texte, mieux l’écrire.'),
(2133, 15, 2, 'Répondre à une question par une phrase complète à l’écrit.'),
(2134, 15, 3, 'Rédiger un texte d’une quinzaine de lignes (récit, description, dialogue, texte poétique, compte rendu) en utilisant ses connaissances en vocabulaire et en grammaire.'),
(2141, 16, 0, 'Comprendre des mots nouveaux et les utiliser à bon escient.'),
(2142, 16, 1, 'Maîtriser quelques relations de sens entre les mots.'),
(2143, 16, 2, 'Maîtriser quelques relations concernant la forme et le sens des mots.'),
(2144, 16, 3, 'Savoir utiliser un dictionnaire papier ou numérique.'),
(2151, 17, 0, 'Distinguer les mots selon leur nature.'),
(2152, 17, 1, 'Identifier les fonctions des mots dans la phrase.'),
(2153, 17, 2, 'Conjuguer les verbes, utiliser les temps à bon escient.'),
(2161, 18, 0, 'Maîtriser l’orthographe grammaticale.'),
(2162, 18, 1, 'Maîtriser l’orthographe lexicale.'),
(2163, 18, 2, 'Orthographier correctement un texte simple de dix lignes – lors de sa rédaction ou de sa dictée – en se référant aux règles connues d’orthographe et de grammaire ainsi qu’à la connaissance du vocabulaire.'),
(2211, 19, 0, 'Communiquer, au besoin avec des pauses pour chercher ses mots.'),
(2212, 19, 1, 'Se présenter ; présenter quelqu’un ; demander à quelqu’un de ses nouvelles en utilisant les formes de politesse les plus élémentaires ; accueil et prise de congé.'),
(2213, 19, 2, 'Répondre à des questions et en poser (sujets familiers ou besoins immédiats).'),
(2214, 19, 3, 'Épeler des mots familiers.'),
(2221, 20, 0, 'Comprendre les consignes de classe.'),
(2222, 20, 1, 'Comprendre des mots familiers et des expressions très courantes.'),
(2223, 20, 2, 'Suivre des instructions courtes et simples.'),
(2231, 21, 0, 'Reproduire un modèle oral.'),
(2232, 21, 1, 'Utiliser des expressions et des phrases proches des modèles rencontrés lors des apprentissages.'),
(2233, 21, 2, 'Lire à haute voix et de manière expressive un texte bref après répétition.'),
(2241, 22, 0, 'Comprendre des textes courts et simples en s’appuyant sur des éléments connus (indications, informations).'),
(2242, 22, 1, 'Se faire une idée du contenu d’un texte informatif simple, accompagné éventuellement d’un document visuel.'),
(2251, 23, 0, 'Copier des mots isolés et des textes courts.'),
(2252, 23, 1, 'Écrire un message électronique simple ou une courte carte postale en référence à des modèles.'),
(2253, 23, 2, 'Renseigner un questionnaire.'),
(2254, 23, 3, 'Produire de manière autonome quelques phrases.'),
(2255, 23, 4, 'Écrire sous la dictée des expressions connues.'),
(2311, 24, 0, 'Écrire, nommer, comparer et utiliser les nombres entiers, les nombres décimaux (jusqu’au centième) et quelques fractions simples.'),
(2312, 24, 1, 'Restituer les tables d’addition et de multiplication de 2 à 9.'),
(2313, 24, 2, 'Utiliser les techniques opératoires des quatre opérations sur les nombres entiers et décimaux (pour la division, le diviseur est un nombre entier).'),
(2314, 24, 3, 'Ajouter deux fractions décimales ou deux fractions simples de même dénominateur.'),
(2315, 24, 4, 'Calculer mentalement en utilisant les quatre opérations.'),
(2316, 24, 5, 'Estimer l’ordre de grandeur d’un résultat.'),
(2317, 24, 6, 'Résoudre des problèmes relevant des quatre opérations.'),
(2318, 24, 7, 'Utiliser une calculatrice.'),
(2321, 25, 0, 'Reconnaître, décrire et nommer les figures et solides usuels.'),
(2322, 25, 1, 'Utiliser la règle, l’équerre et le compas pour vérifier la nature de figures planes usuelles et les construire avec soin et précision.'),
(2323, 25, 2, 'Percevoir et reconnaitre parallèles et perpendiculaires.'),
(2324, 25, 3, 'Résoudre des problèmes de reproduction, de construction.'),
(2331, 26, 0, 'Utiliser des instruments de mesure.'),
(2332, 26, 1, 'Connaître et utiliser les formules du périmètre et de l’aire d’un carré, d’un rectangle et d’un triangle.'),
(2333, 26, 2, 'Utiliser les unités de mesures usuelles.'),
(2334, 26, 3, 'Résoudre des problèmes dont la résolution implique des conversions.'),
(2341, 27, 0, 'Lire, interpréter et construire quelques représentations simples : tableaux, graphiques.'),
(2342, 27, 1, 'Savoir organiser des informations numériques ou géométriques, justifier et apprécier la vraisemblance d’un résultat.'),
(2343, 27, 2, 'Résoudre un problème mettant en jeu une situation de proportionnalité.'),
(2351, 28, 0, 'Pratiquer une démarche d’investigation : savoir observer, questionner.'),
(2352, 28, 1, 'Manipuler et expérimenter, formuler une hypothèse et la tester, argumenter, mettre à l’essai plusieurs pistes de solutions.'),
(2353, 28, 2, 'Exprimer et exploiter les résultats d’une mesure et d’une recherche en utilisant un vocabulaire scientifique à l’écrit ou à l’oral.'),
(2361, 29, 0, 'Le ciel et la Terre.'),
(2362, 29, 1, 'La matière.'),
(2363, 29, 2, 'L’énergie.'),
(2364, 29, 3, 'L’unité et la diversité du vivant.'),
(2365, 29, 4, 'Le fonctionnement du vivant.'),
(2366, 29, 5, 'Le fonctionnement du corps humain et la santé.'),
(2367, 29, 6, 'Les êtres vivants dans leur environnement.'),
(2368, 29, 7, 'Les objets techniques.'),
(2371, 30, 0, 'Mobiliser ses connaissances pour comprendre quelques questions liées à l’environnement et au développement durable et agir en conséquence.'),
(2411, 31, 0, 'Connaitre et maîtriser les fonctions de base d’un ordinateur et de ses périphériques.'),
(2421, 32, 0, 'Prendre conscience des enjeux citoyens de l’usage de l’informatique et de l’internet et adopter une attitude critique face aux résultats obtenus.'),
(2431, 33, 0, 'Produire un document numérique : texte, image, son.'),
(2432, 33, 1, 'Utiliser l’outil informatique pour présenter un travail.'),
(2441, 34, 0, 'Lire un document numérique.'),
(2442, 34, 1, 'Chercher des informations par voie électronique.'),
(2443, 34, 2, 'Découvrir les richesses et les limites des ressources de l’internet.'),
(2453, 35, 0, 'Échanger avec les technologies de l’information et de la communication.'),
(2511, 36, 0, 'Identifier les périodes de l’histoire au programme.'),
(2512, 36, 1, 'Connaître et mémoriser les principaux repères chronologiques (évènements et personnages).'),
(2513, 36, 2, 'Connaître les principaux caractères géographiques physiques et humains de la région où vit l’élève, de la France et de l’Union européenne, les repérer sur des cartes à différentes échelles.'),
(2514, 36, 3, 'Comprendre une ou deux questions liées au développement durable et agir en conséquence (l’eau dans la commune, la réduction et le recyclage des déchets).'),
(2521, 37, 0, 'Lire des œuvres majeures du patrimoine et de la littérature pour la jeunesse.'),
(2522, 37, 1, 'Établir des liens entre les textes lus.'),
(2531, 73, 0, 'Lire et utiliser textes, cartes, croquis, graphiques.'),
(2541, 38, 0, 'Distinguer les grandes catégories de la création artistique (littérature, musique, danse, théâtre, cinéma, dessin, peinture, sculpture, architecture).'),
(2542, 38, 1, 'Reconnaître et décrire des œuvres préalablement étudiées.'),
(2543, 38, 2, 'Pratiquer le dessin et diverses formes d’expressions visuelles et plastiques.'),
(2544, 38, 3, 'Interpréter de mémoire une chanson, participer à un jeu rythmique ; repérer des éléments musicaux caractéristiques simples.'),
(2545, 38, 4, 'Inventer et réaliser des textes, des œuvres plastiques, des chorégraphies ou des enchaînements, à visée artistique ou expressive.'),
(2611, 39, 0, 'Reconnaître les symboles de la République et de l’Union européenne.'),
(2612, 39, 1, 'Comprendre les notions de droits et de devoirs, les accepter et les mettre en application.'),
(2613, 39, 2, 'Avoir conscience de la dignité de la personne humaine et en tirer les conséquences au quotidien.'),
(2621, 40, 0, 'Respecter les règles de la vie collective.'),
(2622, 40, 1, 'Respecter tous les autres, et notamment appliquer les principes de l’égalité des filles et des garçons.'),
(2711, 41, 0, 'Respecter des consignes simples, en autonomie.'),
(2712, 41, 1, 'Être persévérant dans toutes les activités.'),
(2713, 41, 2, 'Commencer à savoir s’autoévaluer dans des situations simples.'),
(2714, 41, 3, 'Soutenir une écoute prolongée (lecture, musique, spectacle, etc.).'),
(2721, 42, 0, 'S’impliquer dans un projet individuel ou collectif.'),
(2731, 43, 0, 'Se respecter en respectant les principales règles d’hygiène de vie ; accomplir les gestes quotidiens sans risquer de se faire mal.'),
(2732, 43, 1, 'Réaliser une performance mesurée dans les activités athlétiques et en natation.'),
(2733, 43, 2, 'Se déplacer en s’adaptant à l’environnement.'),
(1, 1, 0, 'S’exprimer clairement à l’oral en utilisant un vocabulaire approprié.'),
(2, 1, 1, 'Participer en classe à un échange verbal en respectant les règles de la communication.'),
(3, 1, 2, 'Dire de mémoire quelques textes en prose ou poèmes courts.'),
(4, 2, 0, 'Lire seul, à haute voix, un texte comprenant des mots connus et inconnus.'),
(5, 2, 1, 'Lire seul et écouter lire des textes du patrimoine et des œuvres intégrales de la littérature de jeunesse adaptés à son âge.'),
(6, 2, 2, 'Lire seul et comprendre un énoncé, une consigne simple.'),
(7, 2, 3, 'Dégager le thème d’un paragraphe ou d’un texte court.'),
(8, 2, 4, 'Lire silencieusement un texte en déchiffrant les mots inconnus et manifester sa compréhension dans un résumé, une reformulation, des réponses à des questions.'),
(9, 3, 0, 'Copier un texte court sans erreur dans une écriture cursive lisible et avec une présentation soignée.'),
(10, 3, 1, 'Utiliser ses connaissances pour mieux écrire un texte court.'),
(11, 3, 2, 'Écrire de manière autonome un texte de cinq à dix lignes.'),
(12, 4, 0, 'Utiliser des mots précis pour s’exprimer.'),
(13, 4, 1, 'Donner des synonymes.'),
(14, 4, 2, 'Trouver un mot de sens opposé.'),
(15, 4, 3, 'Regrouper des mots par familles.'),
(16, 4, 4, 'Commencer à utiliser l’ordre alphabétique.'),
(17, 5, 0, 'Identifier la phrase, le verbe, le nom, l’article, l’adjectif qualificatif, le pronom personnel (sujet).'),
(18, 5, 1, 'Repérer le verbe d’une phrase et son sujet.'),
(19, 5, 2, 'Conjuguer les verbes du 1er groupe, être et avoir, au présent, au futur, au passé composé de l’indicatif ; conjuguer les verbes faire, aller, dire, venir, au présent de l’indicatif.'),
(20, 5, 3, 'Distinguer le présent du futur et du passé.'),
(21, 6, 0, 'Écrire en respectant les correspondances entre lettres et sons et les règles relatives à la valeur des lettres.'),
(22, 6, 1, 'Écrire sans erreur des mots mémorisés.'),
(23, 6, 2, 'Orthographier correctement des formes conjuguées, respecter l’accord entre le sujet et le verbe, ainsi que les accords en genre et en nombre dans le groupe nominal.'),
(24, 7, 0, 'Écrire, nommer, comparer, ranger les nombres entiers naturels inférieurs à 1000.'),
(25, 7, 1, 'Résoudre des problèmes de dénombrement.'),
(26, 7, 2, 'Calculer : addition, soustraction, multiplication.'),
(27, 7, 3, 'Diviser par 2 et par 5 dans le cas où le quotient exact est entier.'),
(28, 7, 4, 'Restituer et utiliser les tables d’addition et de multiplication par 2, 3, 4 et 5.'),
(29, 7, 5, 'Calculer mentalement en utilisant des additions, des soustractions et des multiplications simples.'),
(30, 7, 6, 'Résoudre des problèmes relevant de l’addition, de la soustraction et de la multiplication.'),
(31, 7, 7, 'Utiliser les fonctions de base de la calculatrice.'),
(32, 8, 0, 'Situer un objet par rapport à soi ou à un autre objet, donner sa position et décrire son déplacement.'),
(33, 8, 1, 'Reconnaître, nommer et décrire les figures planes et les solides usuels.'),
(34, 8, 2, 'Utiliser la règle et l’équerre pour tracer avec soin et précision un carré, un rectangle, un triangle rectangle.'),
(35, 8, 3, 'Percevoir et reconnaître quelques relations et propriétés géométriques : alignement, angle droit, axe de symétrie, égalité de longueurs.'),
(36, 8, 4, 'Repérer des cases, des nœuds d’un quadrillage.'),
(37, 8, 5, 'Résoudre un problème géométrique.'),
(38, 9, 0, 'Utiliser les unités usuelles de mesure ; estimer une mesure.'),
(39, 9, 1, 'Être précis et soigneux dans les mesures et les calculs.'),
(40, 9, 2, 'Résoudre des problèmes de longueur et de masse.'),
(41, 10, 0, 'Utiliser un tableau, un graphique.'),
(42, 10, 1, 'Organiser les données d’un énoncé.'),
(43, 11, 0, 'Reconnaître les emblèmes et les symboles de la République française.'),
(44, 12, 0, 'Respecter les autres et les règles de la vie collective.'),
(45, 12, 1, 'Pratiquer un jeu ou un sport collectif en en respectant les règles.'),
(46, 12, 2, 'Appliquer les codes de la politesse dans ses relations avec ses camarades, avec les adultes de l’école et hors de l’école, avec le maître au sein de la classe.');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_socle_palier`
--

CREATE TABLE IF NOT EXISTS `sacoche_socle_palier` (
  `palier_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `palier_actif` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `palier_ordre` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `palier_nom` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`palier_id`),
  KEY `palier_actif` (`palier_actif`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Contenu de la table `sacoche_socle_palier`
--

INSERT INTO `sacoche_socle_palier` (`palier_id`, `palier_actif`, `palier_ordre`, `palier_nom`) VALUES
(1, 0, 1, 'Palier 1 (fin CE1)'),
(2, 0, 2, 'Palier 2 (fin CM2)'),
(3, 0, 3, 'Palier 3 (fin troisième)');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_socle_pilier`
--

CREATE TABLE IF NOT EXISTS `sacoche_socle_pilier` (
  `pilier_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `palier_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pilier_ordre` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Commence à 1.',
  `pilier_ref` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pilier_nom` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`pilier_id`),
  KEY `palier_id` (`palier_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=19 ;

--
-- Contenu de la table `sacoche_socle_pilier`
--

INSERT INTO `sacoche_socle_pilier` (`pilier_id`, `palier_id`, `pilier_ordre`, `pilier_ref`, `pilier_nom`) VALUES
(1, 3, 1, '1', 'Compétence 1 – La maîtrise de la langue française'),
(2, 3, 2, '2', 'Compétence 2 – La pratique d’une langue vivante étrangère (niveau A2)'),
(3, 3, 3, '3', 'Compétence 3 – Les principaux éléments de mathématiques et la culture scientifique et technologique'),
(4, 3, 4, '4', 'Compétence 4 – La maîtrise des techniques usuelles de l’information et de la communication (B2i)'),
(5, 3, 5, '5', 'Compétence 5 – La culture humaniste'),
(6, 3, 6, '6', 'Compétence 6 – Les compétences sociales et civiques'),
(7, 3, 7, '7', 'Compétence 7 – L’autonomie et l’initiative'),
(8, 2, 1, '1', 'Compétence 1 – La maîtrise de la langue française'),
(9, 2, 2, '2', 'Compétence 2 – La pratique d’une langue vivante étrangère (niveau A1)'),
(10, 2, 3, '3a', 'Compétence 3a – Les principaux éléments de mathématiques'),
(11, 2, 4, '3b', 'Compétence 3b – La culture scientifique et technologique'),
(12, 2, 5, '4', 'Compétence 4 – La maîtrise des techniques usuelles de l’information et de la communication (B2i niveau école)'),
(13, 2, 6, '5', 'Compétence 5 – La culture humaniste'),
(14, 2, 7, '6', 'Compétence 6 – Les compétences sociales et civiques'),
(15, 2, 8, '7', 'Compétence 7 – L’autonomie et l’initiative'),
(16, 1, 1, '1', 'Compétence 1 – La maîtrise de la langue française'),
(17, 1, 2, '3', 'Compétence 3 – Les principaux éléments de mathématiques'),
(18, 1, 3, '6', 'Compétence 6 – Les compétences sociales et civiques');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_socle_section`
--

CREATE TABLE IF NOT EXISTS `sacoche_socle_section` (
  `section_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `pilier_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `section_ordre` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Commence à 1.',
  `section_nom` varchar(165) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`section_id`),
  KEY `pilier_id` (`pilier_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=75 ;

--
-- Contenu de la table `sacoche_socle_section`
--

INSERT INTO `sacoche_socle_section` (`section_id`, `pilier_id`, `section_ordre`, `section_nom`) VALUES
(1, 16, 1, 'Dire'),
(2, 16, 2, 'Lire'),
(3, 16, 3, 'Écrire'),
(4, 16, 4, 'Étude de la langue - vocabulaire'),
(5, 16, 5, 'Étude de la langue - grammaire'),
(6, 16, 6, 'Étude de la langue - orthographe'),
(7, 17, 1, 'Nombres et calcul'),
(8, 17, 2, 'Géométrie'),
(9, 17, 3, 'Grandeurs et mesures'),
(10, 17, 4, 'Organisation et gestion de données'),
(11, 18, 1, 'Connaître les principes et fondements de la vie civique et sociale'),
(12, 18, 2, 'Avoir un comportement responsable'),
(13, 8, 1, 'Dire'),
(14, 8, 2, 'Lire'),
(15, 8, 3, 'Écrire'),
(16, 8, 4, 'Étude de la langue - vocabulaire'),
(17, 8, 5, 'Étude de la langue - grammaire'),
(18, 8, 6, 'Étude de la langue - orthographe'),
(19, 9, 1, 'Réagir et dialoguer'),
(20, 9, 2, 'Comprendre à l’oral'),
(21, 9, 3, 'Parler en continu'),
(22, 9, 4, 'Lire'),
(23, 9, 5, 'Écrire'),
(24, 10, 1, 'Nombres et calcul'),
(25, 10, 2, 'Géométrie'),
(26, 10, 3, 'Grandeurs et mesures'),
(27, 10, 4, 'Organisation et gestion de données'),
(28, 11, 1, 'Pratiquer une démarche scientifique ou technologique'),
(29, 11, 2, 'Maîtriser des connaissances dans divers domaines scientifiques et les mobiliser dans des contextes scientifiques différents et dans des activités de la vie courante'),
(30, 11, 3, 'Environnement et développement durable'),
(31, 12, 1, 'S’approprier un environnement informatique de travail'),
(32, 12, 2, 'Adopter une attitude responsable'),
(33, 12, 3, 'Créer, produire, traiter, exploiter des données'),
(34, 12, 4, 'S’informer, se documenter'),
(35, 12, 5, 'Communiquer, échanger'),
(36, 13, 1, 'Avoir des repères relevant du temps et de l’espace'),
(37, 13, 2, 'Avoir des repères littéraires'),
(73, 13, 3, 'Lire et pratiquer différents langages'),
(38, 13, 4, 'Pratiquer les arts et avoir des repères en histoire des arts'),
(39, 14, 1, 'Connaître les principes et fondements de la vie civique et sociale'),
(40, 14, 2, 'Avoir un comportement responsable'),
(41, 15, 1, 'S’appuyer sur des méthodes de travail pour être autonome'),
(42, 15, 2, 'Faire preuve d’initiative'),
(43, 15, 3, 'Avoir une bonne maîtrise de son corps et une pratique physique (sportive ou artistique)'),
(44, 1, 1, 'Lire'),
(45, 1, 2, 'Écrire'),
(46, 1, 3, 'Dire'),
(48, 2, 1, 'Réagir et dialoguer'),
(49, 2, 2, 'Écouter et comprendre'),
(50, 2, 3, 'Parler en continu'),
(51, 2, 4, 'Lire'),
(52, 2, 5, 'Écrire'),
(53, 3, 1, 'Pratiquer une démarche scientifique et technologique, résoudre des problèmes'),
(54, 3, 2, 'Savoir utiliser des connaissances et des compétences mathématiques'),
(55, 3, 3, 'Savoir utiliser des connaissances dans divers domaines scientifiques'),
(56, 3, 4, 'Environnement et développement durable'),
(57, 4, 1, 'S’approprier un environnement informatique de travail'),
(58, 4, 2, 'Adopter une attitude responsable'),
(59, 4, 3, 'Créer, produire, traiter, exploiter des données'),
(60, 4, 4, 'S’informer, se documenter'),
(61, 4, 5, 'Communiquer, échanger'),
(62, 5, 1, 'Avoir des connaissances et des repères'),
(67, 5, 2, 'Situer dans le temps, l’espace, les civilisations'),
(66, 5, 3, 'Lire et pratiquer différents langages'),
(74, 5, 4, 'Faire preuve de sensibilité, d’esprit critique, de curiosité'),
(68, 6, 1, 'Connaître les principes et fondements de la vie civique et sociale'),
(69, 6, 2, 'Avoir un comportement responsable'),
(70, 7, 1, 'Être acteur de son parcours de formation et d’orientation'),
(71, 7, 2, 'Être capable de mobiliser ses ressources intellectuelles et physiques dans diverses situations'),
(72, 7, 3, 'Faire preuve d’initiative');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_structure_origine`
--

CREATE TABLE IF NOT EXISTS `sacoche_structure_origine` (
  `structure_uai` char(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `structure_denomination` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `structure_localisation` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `structure_courriel` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`structure_uai`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_user`
--

CREATE TABLE IF NOT EXISTS `sacoche_user` (
  `user_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `user_sconet_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ELEVE.ELEVE.ID pour un élève ; INDIVIDU_ID pour un prof ; PERSONNE_ID pour un parent',
  `user_sconet_elenoet` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ELENOET pour un élève (entre 2000 et 5000 ; parfois appelé n° GEP avec un 0 devant)',
  `user_reference` char(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Dans Sconet, ID_NATIONAL pour un élève (pour un prof ce pourrait être le NUMEN mais il n''est pas renseigné et il faudrait deux caractères de plus). Ce champ sert aussi pour un import tableur.',
  `user_profil_sigle` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Nomenclature issue de la BCN (table n_fonction_filiere) et de user_profils SDET.',
  `user_genre` enum('I','M','F') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'I' COMMENT 'Indéterminé / Masculin / Féminin',
  `user_nom` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_prenom` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_naissance_date` date DEFAULT NULL,
  `user_email` varchar(63) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_email_origine` enum('','user','admin') COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_login` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Voir aussi sacoche_user_profil.user_profil_login_modele',
  `user_password` char(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'En MD5 avec un salage.',
  `user_langue` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_daltonisme` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `user_connexion_date` datetime DEFAULT NULL,
  `user_sortie_date` date NOT NULL DEFAULT '9999-12-31',
  `eleve_classe_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `eleve_langue` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT 'Langue choisie pour le socle.',
  `eleve_lv1` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT 'Langue vivante 1 pour le livret scolaire.',
  `eleve_lv2` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT 'Langue vivante 2 pour le livret scolaire.',
  `eleve_uai_origine` char(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Pour un envoi de documents officiels à l''établissement d''origine.',
  `eleve_brevet_serie` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'X' COMMENT 'Série du brevet pour Notanet.',
  `user_id_ent` varchar(63) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Paramètre renvoyé après une identification CAS depuis un ENT (ça peut être le login, mais ça peut aussi être un numéro interne à l''ENT...).',
  `user_id_gepi` varchar(63) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Login de l''utilisateur dans Gepi utilisé pour un transfert note/moyenne vers un bulletin.',
  `user_param_accueil` varchar(127) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'user,alert,messages,previsions,resultats,faiblesses,reussites,demandes,saisies,officiel,socle,help,ecolo',
  `user_pass_key` char(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `user_login` (`user_login`),
  KEY `profil_sigle` (`user_profil_sigle`),
  KEY `user_sortie_date` (`user_sortie_date`),
  KEY `eleve_classe_id` (`eleve_classe_id`),
  KEY `eleve_brevet_serie` (`eleve_brevet_serie`),
  KEY `user_id_ent` (`user_id_ent`),
  KEY `user_id_gepi` (`user_id_gepi`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Contenu de la table `sacoche_user`
--

INSERT INTO `sacoche_user` (`user_id`, `user_sconet_id`, `user_sconet_elenoet`, `user_reference`, `user_profil_sigle`, `user_genre`, `user_nom`, `user_prenom`, `user_naissance_date`, `user_email`, `user_email_origine`, `user_login`, `user_password`, `user_langue`, `user_daltonisme`, `user_connexion_date`, `user_sortie_date`, `eleve_classe_id`, `eleve_langue`, `eleve_lv1`, `eleve_lv2`, `eleve_uai_origine`, `eleve_brevet_serie`, `user_id_ent`, `user_id_gepi`, `user_param_accueil`, `user_pass_key`) VALUES
(1, 0, 0, '', 'ADM', 'I', 'ADMIN', 'Admin', NULL, 'admin@scribe25.ac-igor.fr', 'user', 'admin', '51df606dc7a052211322d33e1b932075', '', 0, '2015-06-23 15:48:23', '9999-12-31', 0, 100, 100, 100, '', 'X', 'admin', '', 'user,alert,messages,resultats,faiblesses,reussites,demandes,saisies,officiel,socle,help,ecolo,previsions', ''),
(2, 0, 0, '', 'ADM', 'I', 'Envole', 'Admin', NULL, '', 'admin', 'admin2', '', '', 0, '0000-00-00 00:00:00', '9999-12-31', 0, 100, 100, 100, '', 'X', 'admin2', '', 'user,alert,messages,resultats,faiblesses,reussites,demandes,saisies,officiel,socle,help,ecolo,previsions', '');

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_user_profil`
--

CREATE TABLE IF NOT EXISTS `sacoche_user_profil` (
  `user_profil_sigle` char(3) COLLATE utf8_unicode_ci NOT NULL,
  `user_profil_structure` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `user_profil_disponible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `user_profil_actif` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `user_profil_obligatoire` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `user_profil_type` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_profil_join_groupes` enum('sansobjet','auto','all','config') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'sansobjet',
  `user_profil_join_matieres` enum('sansobjet','auto','all','config') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'sansobjet',
  `user_profil_nom_court_singulier` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_profil_nom_court_pluriel` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_profil_nom_long_singulier` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_profil_nom_long_pluriel` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_profil_login_modele` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'ppp.nnnnnnnn',
  `user_profil_mdp_longueur_mini` tinyint(3) unsigned NOT NULL DEFAULT '6',
  `user_profil_mdp_date_naissance` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `user_profil_duree_inactivite` tinyint(3) unsigned NOT NULL DEFAULT '30',
  PRIMARY KEY (`user_profil_sigle`),
  KEY `user_profil_structure` (`user_profil_structure`),
  KEY `user_profil_disponible` (`user_profil_disponible`),
  KEY `user_profil_actif` (`user_profil_actif`),
  KEY `user_profil_obligatoire` (`user_profil_obligatoire`),
  KEY `user_profil_type` (`user_profil_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contenu de la table `sacoche_user_profil`
--

INSERT INTO `sacoche_user_profil` (`user_profil_sigle`, `user_profil_structure`, `user_profil_disponible`, `user_profil_actif`, `user_profil_obligatoire`, `user_profil_type`, `user_profil_join_groupes`, `user_profil_join_matieres`, `user_profil_nom_court_singulier`, `user_profil_nom_court_pluriel`, `user_profil_nom_long_singulier`, `user_profil_nom_long_pluriel`, `user_profil_login_modele`, `user_profil_mdp_longueur_mini`, `user_profil_mdp_date_naissance`, `user_profil_duree_inactivite`) VALUES
('OUT', 0, 1, 1, 1, 'public', 'sansobjet', 'sansobjet', 'non connecté', 'non connectés', 'utilisateur non connecté', 'utilisateurs non connectés', 'ppp.nnnnnnnn', 6, 0, 0),
('WBM', 0, 1, 1, 1, 'webmestre', 'sansobjet', 'sansobjet', 'webmestre', 'webmestres', 'webmestre (responsable du serveur)', 'webmestres (responsables du serveur)', 'ppp.nnnnnnnn', 6, 0, 15),
('ENT', 0, 1, 1, 1, 'partenaire', 'sansobjet', 'sansobjet', 'partenaire', 'partenaires', 'partenariat conventionné (ENT)', 'partenariats conventionnés (ENT)', 'ppp.nnnnnnnn', 6, 0, 15),
('ADM', 1, 1, 1, 1, 'administrateur', 'sansobjet', 'sansobjet', 'administrateur', 'administrateurs', 'administrateur (de l''établissement)', 'administrateurs (de l''établissement)', 'ppp.nnnnnnnn', 6, 0, 30),
('ELV', 1, 1, 1, 1, 'eleve', 'config', 'auto', 'élève', 'élèves', 'élève', 'élèves', 'ppp.nnnnnnnn', 6, 0, 30),
('TUT', 1, 1, 1, 1, 'parent', 'auto', 'auto', 'parent', 'parents', 'responsable légal (parent, tuteur)', 'responsables légaux (parents, tuteurs)', 'ppp.nnnnnnnn', 6, 0, 30),
('AVS', 1, 0, 0, 0, 'parent', 'auto', 'auto', 'AVS', 'AVS', 'auxiliaire de vie scolaire (AVS)', 'auxiliaires de vie scolaire (AVS)', 'ppp.nnnnnnnn', 6, 0, 30),
('DIR', 1, 1, 1, 1, 'directeur', 'all', 'all', 'directeur', 'directeurs', 'personnel de direction', 'personnels de direction', 'ppp.nnnnnnnn', 6, 0, 30),
('ENS', 1, 1, 1, 1, 'professeur', 'config', 'config', 'professeur', 'professeurs', 'personnel enseignant', 'personnels enseignants', 'ppp.nnnnnnnn', 6, 0, 30),
('IEX', 1, 1, 0, 0, 'professeur', 'config', 'config', 'intervenant', 'intervenants', 'intervenant extérieur', 'intervenants extérieurs', 'ppp.nnnnnnnn', 6, 0, 30),
('DOC', 1, 1, 1, 0, 'professeur', 'all', 'config', 'documentaliste', 'documentalistes', 'professeur documentaliste', 'professeurs documentalistes', 'ppp.nnnnnnnn', 6, 0, 30),
('EDU', 1, 1, 1, 0, 'professeur', 'all', 'config', 'CPE', 'CPE', 'conseiller d''éducation (CPE)', 'conseillers d''éducation (CPE)', 'ppp.nnnnnnnn', 6, 0, 30),
('AED', 1, 1, 0, 0, 'professeur', 'all', 'config', 'AED', 'AED', 'assistant d''éducation (AED)', 'assistants d''éducation (AED)', 'ppp.nnnnnnnn', 6, 0, 30),
('SUR', 1, 1, 0, 0, 'professeur', 'all', 'config', 'surveillant', 'surveillants', 'personnel de surveillance', 'personnels de surveillance', 'ppp.nnnnnnnn', 6, 0, 30),
('ORI', 1, 1, 0, 0, 'professeur', 'all', 'config', 'COP', 'COP', 'conseiller d''orientation (COP)', 'conseillers d''orientation (COP)', 'ppp.nnnnnnnn', 6, 0, 30),
('MDS', 1, 1, 0, 0, 'professeur', 'all', 'config', 'médecin', 'médecins', 'personnel médico-social', 'personnels médico-sociaux', 'ppp.nnnnnnnn', 6, 0, 30),
('ADF', 1, 1, 0, 0, 'professeur', 'all', 'config', 'administratif', 'administratifs', 'personnel administratif', 'personnels administratifs', 'ppp.nnnnnnnn', 6, 0, 30),
('INS', 1, 0, 0, 0, 'inspecteur', 'auto', 'auto', 'inspecteur', 'inspecteurs', 'inspecteur', 'inspecteurs', 'ppp.nnnnnnnn', 6, 0, 30);

-- --------------------------------------------------------

--
-- Structure de la table `sacoche_user_switch`
--

CREATE TABLE IF NOT EXISTS `sacoche_user_switch` (
  `user_switch_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `user_switch_liste` tinytext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`user_switch_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
