<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2018
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d’Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}
if($_SESSION['SESAMATH_ID']==ID_DEMO) {Json::end( FALSE , 'Action désactivée pour la démo.' );}

$action   = (isset($_POST['f_action']))   ? Clean::texte($_POST['f_action'])      : '';
$id       = (isset($_POST['f_id']))       ? Clean::entier($_POST['f_id'])         : 0;
$courriel = (isset($_POST['f_courriel'])) ? Clean::courriel($_POST['f_courriel']) : '';
$date_fr  = (isset($_POST['f_date']))     ? Clean::date_fr($_POST['f_date'])      : '' ;
$message  = (isset($_POST['f_message']))  ? Clean::texte($_POST['f_message'])     : '' ;

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Ajouter un nouveau courriel
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if( ($action=='ajouter') && $courriel )
{
  // Vérifier le domaine du serveur mail seulement en mode multi-structures car ce peut être sinon une installation sur un serveur local non ouvert sur l’extérieur.
  if(HEBERGEUR_INSTALLATION=='multi-structures')
  {
    list($mail_domaine,$is_domaine_valide) = Outil::tester_domaine_courriel_valide($courriel);
    if(!$is_domaine_valide)
    {
      Json::end( FALSE , 'Erreur avec le domaine "'.$mail_domaine.'" !' );
    }
  }
  // Vérifier que le courriel n’est pas déjà référencé
  if( DB_STRUCTURE_COURRIEL_ERREUR::DB_tester_courriel($courriel) )
  {
    Json::end( FALSE , 'Courriel déjà répertorié !' );
  }
  // Ajout
  $erreur_id = DB_STRUCTURE_COURRIEL_ERREUR::DB_ajouter_courriel( $courriel , $message );
  // Retrait pour les utilisateurs concernés
  $DB_TAB = DB_STRUCTURE_ADMINISTRATEUR::DB_rechercher_users( 'email' , $courriel );
  if(!empty($DB_TAB))
  {
    $tab_donnees = array( ':courriel'=>'' , ':email_origine'=>'' );
    foreach($DB_TAB as $DB_ROW)
    {
      DB_STRUCTURE_ADMINISTRATEUR::DB_modifier_user( $DB_ROW['user_id'] , $tab_donnees );
    }
  }
  // Afficher le retour
  Json::add_row( 'html' , '<tr id="id_'.$erreur_id.'" class="new">' );
  Json::add_row( 'html' ,   '<td>'.html($courriel).'</td>' );
  Json::add_row( 'html' ,   '<td>'.TODAY_FR.'</td>' );
  Json::add_row( 'html' ,   '<td>'.html(Outil::afficher_texte_tronque($message,60)).'</td>' );
  Json::add_row( 'html' ,   '<td class="nu">' );
  Json::add_row( 'html' ,     '<q class="modifier" title="Modifier cette adresse ou son commentaire."></q>' );
  Json::add_row( 'html' ,     '<q class="supprimer" title="Débloquer cette adresse."></q>' );
  Json::add_row( 'html' ,   '</td>' );
  Json::add_row( 'html' , '</tr>' );
  Json::add_row( 'script' , 'tab_erreur_infos['.$erreur_id.']="'.convertCRtoJS(html($message)).'";' );
  Json::end( TRUE );
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Modifier un courriel existant
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if( ($action=='modifier') && $id && $courriel && $date_fr )
{
  // Vérifier le domaine du serveur mail seulement en mode multi-structures car ce peut être sinon une installation sur un serveur local non ouvert sur l’extérieur.
  if(HEBERGEUR_INSTALLATION=='multi-structures')
  {
    list($mail_domaine,$is_domaine_valide) = Outil::tester_domaine_courriel_valide($courriel);
    if(!$is_domaine_valide)
    {
      Json::end( FALSE , 'Erreur avec le domaine "'.$mail_domaine.'" !' );
    }
  }
  // Vérifier que le courriel n’est pas déjà référencé
  if( DB_STRUCTURE_COURRIEL_ERREUR::DB_tester_courriel($courriel,$id) )
  {
    Json::end( FALSE , 'Courriel déjà répertorié !' );
  }
  // Modification
  DB_STRUCTURE_COURRIEL_ERREUR::DB_modifier_courriel( $id , $courriel , $message );
  // Retrait pour les utilisateurs concernés
  $DB_TAB = DB_STRUCTURE_ADMINISTRATEUR::DB_rechercher_users( 'email' , $courriel );
  if(!empty($DB_TAB))
  {
    $tab_donnees = array( ':courriel'=>'' , ':email_origine'=>'' );
    foreach($DB_TAB as $DB_ROW)
    {
      DB_STRUCTURE_ADMINISTRATEUR::DB_modifier_user( $DB_ROW['user_id'] , $tab_donnees );
    }
  }
  // Afficher le retour
  Json::add_row( 'html' , '<td>'.html($courriel).'</td>' );
  Json::add_row( 'html' , '<td>'.html($date_fr).'</td>' );
  Json::add_row( 'html' , '<td>'.html(Outil::afficher_texte_tronque($message,60)).'</td>' );
  Json::add_row( 'html' , '<td class="nu">' );
  Json::add_row( 'html' ,   '<q class="modifier" title="Modifier cette adresse ou son commentaire."></q>' );
  Json::add_row( 'html' ,   '<q class="supprimer" title="Débloquer cette adresse."></q>' );
  Json::add_row( 'html' , '</td>' );
  Json::add_row( 'script' , 'tab_erreur_infos['.$id.']="'.convertCRtoJS(html($message)).'";' );
  Json::end( TRUE );
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Supprimer un courriel existant
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if( ($action=='supprimer') && $id )
{
  // suppression
  DB_STRUCTURE_COURRIEL_ERREUR::DB_supprimer_courriel($id);
  // Afficher le retour
  Json::end( TRUE );
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// On ne devrait pas en arriver là...
// ////////////////////////////////////////////////////////////////////////////////////////////////////

Json::end( FALSE , 'Erreur avec les données transmises !' );

?>
