/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2018
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d’Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */


// jQuery !
$(document).ready
(
  function()
  {

    // initialisation (variables globales)
    var modification = false;
    var images = new Array();
    images['categorie']  = '<q class="modifier" title="Modifier cette catégorie"></q>'
                         + '<q class="dupliquer" title="Dupliquer cette catégorie"></q>'
                         + '<q class="supprimer" title="Supprimer cette catégorie"></q>';
    images['appreciation'] = '<q class="modifier" title="Modifier cette appréciation"></q>'
                           + '<q class="dupliquer" title="Dupliquer cette appréciation"></q>'
                           + '<q class="supprimer" title="Supprimer cette appréciation"></q>';

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Réagir à un réagencement
// ////////////////////////////////////////////////////////////////////////////////////////////////////

    function modif_ordre_ou_contenu()
    {
      if(modification==false)
      {
        modification = true;
        $('#ajax_msg').attr('class','alerte').html("Penser à valider !");
      }
    }

    $('#sortable_v').sortable( { cursor:'ns-resize' , update:function(event,ui){modif_ordre_ou_contenu();} } );

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Clic sur le bouton pour ajouter un titre de catégorie
// ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#categorie_ajouter').click
    (
      function()
      {
        var categorie_val = escapeHtml( $('#categorie_val').val() );
        if(categorie_val == '')
        {
          $('label[for=categorie_val]').addClass('erreur').html("Saisie manquante !");
          $('#categorie_val').focus();
          return false;
        }
        else
        {
          initialiser_compteur();
          $('label[for=categorie_val]').removeAttr('class').html('');
          $('#sortable_v').append('<li><span class="b u">'+categorie_val+'</span>'+images['categorie']+'</li>');
          $('#sortable_v li.i').remove();
          $('#categorie_val').val('');
          modif_ordre_ou_contenu();
          initialiser_compteur();
        }
      }
    );

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Clic sur le bouton pour ajouter une appréciation
// ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#appreciation_ajouter').click
    (
      function()
      {
        var appreciation_val = escapeHtml( $('#appreciation_val').val() );
        if(appreciation_val == '')
        {
          $('label[for=appreciation_val]').addClass('erreur').html("Saisie manquante !");
          $('#appreciation_val').focus();
          return false;
        }
        else
        {
          initialiser_compteur();
          $('label[for=appreciation_val]').removeAttr('class').html('');
          $('#sortable_v').append('<li><span>'+appreciation_val+'</span>'+images['appreciation']+'</li>');
          $('#sortable_v li.i').remove();
          $('#appreciation_val').val('');
          modif_ordre_ou_contenu();
          initialiser_compteur();
        }
      }
    );

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Clic sur le bouton pour supprimer un élément
// ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#sortable_v').on
    (
      'click',
      'q.supprimer',
      function()
      {
        var nb_li = $(this).parent().parent().children().length;
        $(this).parent().remove();
        if(nb_li==1)
        {
          $('#sortable_v').append('<li class="i">Encore aucun élément actuellement ! Utilisez les outils ci-dessous pour en ajouter&hellip;</li>');
        }
        else
        {
          modif_ordre_ou_contenu();
          initialiser_compteur();
        }
        return false;
      }
    );

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Clic sur un bouton pour modifier un élément
// ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#sortable_v').on
    (
      'click',
      'q.modifier',
      function()
      {
        var container = $(this).parent();
        var element = $(this).prev();
        var input_val = element.html();
        // soit c’est un titre de catégorie
        if(element.hasClass('b'))
        {
          container.html('<label class="tab" data-type="categorie">Catégorie :</label><input name="input_val" value="'+escapeQuote(input_val)+'" size="40" maxlength="50" /><input name="input_val_old" value="'+escapeQuote(input_val)+'" type="hidden" /><q class="valider" title="Valider la modification"></q><q class="annuler" title="Annuler la modification"></q><label></label>');
        }
        // soit c’est une appréciation
        else
        {
          container.html('<label class="tab" data-type="appreciation">Appréciation :</label><input name="input_val" value="'+escapeQuote(input_val)+'" size="115" maxlength="250" /><input name="input_val_old" value="'+escapeQuote(input_val)+'" type="hidden" /><q class="valider" title="Valider la modification"></q><q class="annuler" title="Annuler la modification"></q><label></label>');
        }
        container.find('input[name=input_val]').focus();
        return false;
      }
    );

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Clic sur un bouton pour dupliquer un élément
// ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#sortable_v').on
    (
      'click',
      'q.dupliquer',
      function()
      {
        var element = $(this).prev().prev();
        var input_val = element.html();
        // soit c’est un titre de catégorie
        if(element.hasClass('b'))
        {
          $('#categorie_val').val(input_val).focus();
        }
        // soit c’est une appréciation
        else
        {
          $('#appreciation_val').val(input_val).focus();
        }
        return false;
      }
    );

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Clic sur un bouton pour annuler la modification d’un élément
// ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#sortable_v').on
    (
      'click',
      'q.annuler',
      function()
      {
        var container = $(this).parent();
        var objet = container.children('label').attr('data-type');
        var input_val = escapeHtml( container.children('input[name=input_val_old]').val() );
        // soit c’est un titre de catégorie
        if(objet=='categorie')
        {
          $(this).parent().html('<span class="b u">'+input_val+'</span>'+images['categorie']);
        }
        // soit c’est une appréciation
        else
        {
          $(this).parent().html('<span>'+input_val+'</span>'+images['appreciation']);
        }
        return false;
      }
    );

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Clic sur un bouton pour valider la modification d’un élément
// ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#sortable_v').on
    (
      'click',
      'q.valider',
      function()
      {
        var container = $(this).parent();
        var objet = container.children('label').attr('data-type');
        var input_val = escapeHtml( container.children('input[name=input_val]').val() );
        if(!input_val)
        {
          $(this).next().next('label').addClass('erreur').html("Saisie manquante !");
          $(this).parent().children('input[name=input_val]').focus();
          return false;
        }
        // soit c’est un titre de catégorie
        if(objet=='categorie')
        {
          $(this).parent().html('<span class="b u">'+input_val+'</span>'+images['categorie']);
        }
        // soit c’est une appréciation
        else
        {
          $(this).parent().html('<span>'+input_val+'</span>'+images['appreciation']);
        }
        modif_ordre_ou_contenu();
        initialiser_compteur();
        return false;
      }
    );

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Intercepter la touche entrée ou escape pour valider ou annuler les modifications
// ////////////////////////////////////////////////////////////////////////////////////////////////////

    $(document).on
    (
      'keyup',
      'input',
      function(e)
      {
        if(e.which==13)  // touche entrée
        {
          $(this).nextAll('q.valider , q.ajouter').click();
        }
        else if(e.which==27)  // touche escape
        {
          $(this).nextAll('q.annuler').click();
        }
        return false;
      }
    );

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Clic sur le bouton pour valider et enregistrer le contenu des appréciations
// ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#bouton_valider').click
    (
      function()
      {
        // Récupérer les éléments
        var tab_catalogue = new Array();
        var modif_en_cours = false;
        $('#sortable_v li').each
        (
          function()
          {
            if($(this).hasClass('i'))
            {
              // C’est une liste vide
            }
            // soit c’est un titre de catégorie
            else if($(this).children('span.b').length)
            {
              var categorie_val = $(this).children('span').html();
              var categorie_id  = ( typeof($(this).attr('id')) !== 'undefined' ) ? $(this).attr('id') : 'cat_0' ;
              tab_catalogue.push(categorie_id+']¤['+categorie_val);
            }
            // soit c’est une appréciation
            else if($(this).children('span').length)
            {
              var appreciation_val = $(this).children('span').html();
              var appreciation_id  = ( typeof($(this).attr('id')) !== 'undefined' ) ? $(this).attr('id') : 'app_0' ;
              tab_catalogue.push(appreciation_id+']¤['+appreciation_val);
            }
            // soit une modification d’un élément est en cours
            else
            {
              modif_en_cours = true;
              return false;
            }
          }
        );
        if(modif_en_cours)
        {
          $('#ajax_msg').attr('class','erreur').html("Valider ou annuler d’abord toute modification en cours !");
          return false;
        }
        // appel ajax
        $('#ajax_msg').attr('class','loader').html("En cours&hellip;");
        $.ajax
        (
          {
            type : 'POST',
            url : 'ajax.php?page='+PAGE,
            data : 'csrf='+CSRF+'&f_action=enregistrer'+'&f_catalogue='+encodeURIComponent(tab_catalogue.join('}¤{')),
            dataType : 'json',
            error : function(jqXHR, textStatus, errorThrown)
            {
              $('#ajax_msg').attr('class','alerte').html(afficher_json_message_erreur(jqXHR,textStatus));
              return false;
            },
            success : function(responseJSON)
            {
              if(responseJSON['statut']==false)
              {
                $('#ajax_msg').attr('class','alerte').html(responseJSON['value']);
                return false;
              }
              else
              {
                if(responseJSON['value'])
                {
                  responseJSON['value'] = responseJSON['value'].replaceAll( '{{QC}}' , '</span>'+images['categorie']    );
                  responseJSON['value'] = responseJSON['value'].replaceAll( '{{QA}}' , '</span>'+images['appreciation'] );
                  $('#sortable_v').html(responseJSON['value']);
                }
                $('label[for=categorie_val]').removeAttr('class').html('');
                $('label[for=appreciation_val]').removeAttr('class').html('');
                $('#ajax_msg').removeAttr('class').html("");
                initialiser_compteur();
                modification=false;
              }
            }
          }
        );
        return false;
      }
    );

  }
);
