<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2018
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d’Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}
$TITRE = html(Lang::_('Catalogue d’appréciations'));
?>

<ul class="puce">
  <li><span class="manuel"><a class="pop_up" href="<?php echo SERVEUR_DOCUMENTAIRE ?>?fichier=support_professeur__catalogue_appreciations">DOC : Catalogue d’appréciations.</a></span></li>
</ul>

<hr />

<form action="#" method="post" id="form_appreciations">
  <ul id="sortable_v">
    <?php
    // Lister les données de l’utilisateur
    $DB_TAB = DB_STRUCTURE_CATALOGUE::DB_lister_appreciations_avec_categories($_SESSION['USER_ID']);
    if(!empty($DB_TAB))
    {
      $categorie_id = 0;
      foreach($DB_TAB as $DB_ROW)
      {
        if($DB_ROW['categorie_id']!=$categorie_id)
        {
          echo'<li id="cat_'.$DB_ROW['categorie_id'].'"><span class="b u">'.html($DB_ROW['categorie_titre']).'</span><q class="modifier" title="Modifier cette catégorie"></q><q class="dupliquer" title="Dupliquer cette catégorie"></q><q class="supprimer" title="Supprimer cette catégorie"></q></li>';
          $categorie_id = $DB_ROW['categorie_id'];
        }
        if(!empty($DB_ROW['appreciation_id']))
        {
          echo'<li id="app_'.$DB_ROW['appreciation_id'].'"><span>'.html($DB_ROW['appreciation_contenu']).'</span><q class="modifier" title="Modifier cette appréciation"></q><q class="dupliquer" title="Dupliquer cette appréciation"></q><q class="supprimer" title="Supprimer cette appréciation"></q></li>';
        }
      }
    }
    else
    {
      echo'<li class="i">Encore aucun élément actuellement ! Utilisez les outils ci-dessous pour en ajouter&hellip;</li>'.NL;
    }
    ?>
  </ul>
  <div><span class="tab"></span><button class="valider" type="button" id="bouton_valider">Valider / Enregistrer.</button> <label id="ajax_msg">&nbsp;</label></div>
  <hr />
  <h2>Ajouter une catégorie</h2>
  <div class="sortable"><input id="categorie_val" value="" size="40" maxlength="50" /><q id="categorie_ajouter" class="ajouter" title="Ajouter cette categorie"></q><label for="categorie_val"></label></div>
  <h2>Ajouter une appréciation</h2>
  <div class="sortable"><input id="appreciation_val" value="" size="125" maxlength="250" /><q id="appreciation_ajouter" class="ajouter" title="Ajouter cette appreciation"></q><label for="appreciation_val"></label></div>
</form>

