<?php
    if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}
    $TITRE = "Connexion SSO"; // Pas de traduction car pas de choix de langue à ce niveau.
    $BASE = 0;

    // Mettre à jour la base si nécessaire
    DBextra::maj_base_structure_si_besoin($BASE);

    require_once 'CAS-1.3.1/eoleCAS.php';
    require_once 'configCAS/cas.inc.php';

    if (__CAS_DEBUG) {
        EolephpCAS::setDebug('/var/log/phpcas/phpcas-sacoche.log');
    }

    ob_start();

    if(!eolephpCAS::EoleTestphpCAS()) eolephpCAS::client(CAS_VERSION_2_0, __CAS_SERVER, __CAS_PORT, '', false);        
    
    if (__CAS_LOGOUT){
        if (method_exists(eolephpCAS, 'eolelogoutRequests')){
            eolephpCAS::eolelogoutRequests(false);
        }
    }

    if (__CAS_VALIDER_CA) {
        eolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // verification par rapport a la CA
    } else {
        if (method_exists("EolephpCAS", "setNoCasServerValidation")){
            eolephpCAS::setNoCasServerValidation();
        }
    }

    eolephpCAS::forceAuthentication();
    $id_ENT = eolephpCAS::getUser();

    // Pour mettre fin au ob_start() ; cas 1/2 où il n'y a pas eu d'erreur.
    ob_end_clean();


    // Forcer à réinterroger le serveur CAS en cas de nouvel appel à cette page pour être certain que c'est toujours le même utilisateur qui est connecté au CAS.
    // unset($_SESSION['phpCAS']);
    
    // Comparer avec les données de la base
    list( $auth_SUCCESS , $auth_DATA ) = SessionUser::tester_authentification_utilisateur( $BASE , $id_ENT /*login*/ , FALSE /*password*/ , 'cas' /*mode_connection*/ );
    if($auth_SUCCESS!==TRUE) {
        exit_error( 'Incident authentification CAS' /*titre*/ , $auth_DATA /*contenu*/ , 'contact' , $BASE );
    }


    // Connecter l'utilisateur
    SessionUser::initialiser_utilisateur( $BASE , $auth_DATA );

    // Pas de redirection (passage possible d'infos en POST à conserver), on peut laisser le code se poursuivre.
    header('Location: /sacoche');

    return; // Ne pas exécuter la suite de ce fichier inclus.

?>