DROP TABLE IF EXISTS sacoche_matiere;

-- Attention : pas d’apostrophes droites dans les lignes commentées sinon on peut obtenir un bug d’analyse dans la classe pdo de SebR : "SQLSTATE[HY093]: Invalid parameter number: no parameters were bound ..."

CREATE TABLE sacoche_matiere (
  matiere_id          SMALLINT    UNSIGNED                NOT NULL AUTO_INCREMENT,
  matiere_active      TINYINT     UNSIGNED                NOT NULL DEFAULT 0,
  matiere_siecle      TINYINT     UNSIGNED                NOT NULL DEFAULT 0 COMMENT "Si présente dans import SIECLE.",
  matiere_usuelle     TINYINT     UNSIGNED                NOT NULL DEFAULT 0,
  matiere_famille_id  TINYINT     UNSIGNED                NOT NULL DEFAULT 0,
  matiere_nb_demandes TINYINT     UNSIGNED                NOT NULL DEFAULT 0,
  matiere_ordre       TINYINT     UNSIGNED                NOT NULL DEFAULT 255,
  matiere_code        CHAR(6)     COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "Issu de SIECLE <MATIERE CODE> ; Id de la BCN requis pour l’export LSU. Si hors BCN, on envoie à LSU matiere_id (à précéder de X).",
  matiere_ref         VARCHAR(5)  COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "Issu de SIECLE <CODE_GESTION>.",
  matiere_nom         VARCHAR(70) COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  PRIMARY KEY (matiere_id),
  UNIQUE KEY matiere_ref (matiere_ref),
  KEY matiere_active (matiere_active),
  KEY matiere_siecle (matiere_siecle),
  KEY matiere_famille_id (matiere_famille_id),
  FULLTEXT KEY matiere_nom (matiere_nom)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE sacoche_matiere DISABLE KEYS;

-- Attention : sur certains LCS le module pdo_mysql bloque au dela de 40 instructions envoyées d’un coup (mais un INSERT multiple avec des milliers de lignes ne pose pas de pb).

INSERT INTO sacoche_matiere VALUES

-- 100 Activités non spécialisées

(   1, 0, 0, 0, 100, 0, 255, "000100", "PBSCU", "Problèmes socioculturels"),
(   2, 0, 0, 0, 100, 0, 255, "000200", "CPORT", "Comportement"),
(   3, 0, 0, 0, 100, 0, 255, "000300", "ACAUT", "Activités autonomes"),
(   4, 0, 0, 0, 100, 0, 255, "000400", "STAGE", "Stages"),
(   5, 0, 0, 0, 100, 0, 255, "000500", "EDSCU", "Education socioculturelle"),
(   6, 0, 0, 0, 100, 0, 255, "000600", "P-STA", "Préparation stages"),
(   7, 0, 0, 0, 100, 0, 255, "000700", "ACPER", "Activités personnelles"),
(   8, 0, 0, 0, 100, 0, 255, "000800", "F-GEN", "Formation générale"),
(   9, 0, 0, 0, 100, 0, 255, "000900", "ETPRA", "Étude pratique (ses)"),
(  10, 0, 0, 0, 100, 0, 255, "001000", "F-PRO", "Formation professionnelle (ses)"),
(  11, 0, 0, 0, 100, 0, 255, "001100", "IMTRA", "Information monde travail"),
(  12, 0, 0, 0, 100, 0, 255, "001200", "F-PRA", "Formation pratique"),
(  13, 0, 0, 0, 100, 0, 255, "001300", "PR-PF", "Pratiques professionnelles"),
(  14, 0, 0, 0, 100, 0, 255, "001400", "SOUTN", "Soutien"),
(  15, 0, 0, 0, 100, 0, 255, "001500", "ALLEG", "Allègement"),
(  16, 0, 0, 0, 100, 0, 255, "001600", "HYGSC", "Hygiène sécurité"),
(  17, 0, 0, 0, 100, 0, 255, "001700", "CULGE", "Culture générale"),
(  18, 0, 0, 0, 100, 0, 255, "001800", "MADIV", "Matières diverses"),
(  19, 0, 0, 0, 100, 0, 255, "001900", "ACMIP", "Activités en milieu professionnel"),
(  20, 0, 0, 0, 100, 0, 255, "002000", "ACPPD", "Activités personnelles et professionnelles dirigées"),
(  21, 0, 0, 0, 100, 0, 255, "002100", "I-RHU", "Initiation aux relations humaines"),
(  22, 0, 0, 0, 100, 0, 255, "002200", "MOADP", "Modules d’adaptation"),
(  23, 0, 0, 0, 100, 0, 255, "002300", "TPE"  , "Travaux personnels encadrés"),
(  24, 0, 0, 0, 100, 0, 255, "002400", "ACALI", "Accès en autonomie au laboratoire informatique"),
(  25, 0, 0, 0, 100, 0, 255, "002500", "REHUM", "Relations humaines"),
(  26, 0, 0, 0, 100, 0, 255, "002600", "F-RHU", "Formation relations humaines"),
(  27, 0, 0, 0, 100, 0, 255, "002700", "EDGTM", "Education gestuelle Travaux manuels (ses)"),
(  28, 0, 0, 0, 100, 0, 255, "002800", "BRIDG", "Bridge"),
(  29, 0, 0, 0, 100, 0, 255, "002900", "BRAIL", "Braille"),
(  30, 0, 0, 0, 100, 0, 255, "003000", "PR-SC", "Pratiques sociales et culturelles"),
(  31, 0, 0, 0, 100, 0, 255, "003100", "MODUL", "Module"),
(  32, 0, 0, 0, 100, 0, 255, "003200", "AMEXP", "Acquisition des moyens d’expression"),
(  33, 0, 0, 0, 100, 0, 255, "003300", "TX-IP", "Travaux initiative personnelle encadrés"),
(  34, 0, 0, 0, 100, 0, 255, "003400", "EDUOR", "Education à l’orientation"),
(  35, 0, 0, 0, 100, 0, 255, "003500", "PPCP" , "Projet pluridisciplinaire à caractère professionnel"),
(  36, 0, 0, 0, 100, 0, 255, "003600", "APD"  , "Activités professionnelles dirigées"),
(  37, 0, 0, 0, 100, 0, 255, "003700", "ATRAV", "Accompagnement du travail personnel"),
(  38, 0, 0, 0, 100, 0, 255, "003800", "D-SCO", "Traitement des difficultés scolaires"),
(  39, 0, 0, 0, 100, 0, 255, "003900", "VIPRO", "Aide à la vie professionnelle"),
(  40, 0, 0, 0, 100, 0, 255, "004000", "IDNCH", "Itinéraire découverte - nature corps humain"),
(  41, 0, 0, 0, 100, 0, 255, "004100", "IDARH", "Itinéraire découverte - arts humanité"),
(  42, 0, 0, 0, 100, 0, 255, "004200", "IDLCI", "Itinéraire découverte - langues civilisations"),
(  43, 0, 0, 0, 100, 0, 255, "004300", "IDCTQ", "Itinéraire découverte - création techniques"),
(  44, 0, 0, 0, 100, 0, 255, "004400", "DLIAR", "Domaine littéraire et artistique"),
(  45, 0, 0, 0, 100, 0, 255, "004500", "DPRJT", "Démarche de projet"),
(  46, 0, 0, 0, 100, 0, 255, "004600", "IDAUT", "Itinéraire découverte - autres"),
(  47, 0, 0, 0, 100, 0, 255, "004700", "MODRE", "Module régional"),
(  48, 0, 0, 0, 100, 0, 255, "004800", "ASECT", "Approfondissement sectoriel"),
(  49, 0, 0, 0, 100, 0, 255, "004900", "LABCC", "Laboratoire de création et de conception"),
(  50, 0, 0, 0, 100, 0, 255, "005000", "DP3H" , "Découverte professionnelle 3 heures"),
(  51, 0, 0, 0, 100, 0, 255, "005100", "DP6H" , "Découverte professionnelle 6 heures"),
(  52, 0, 0, 0, 100, 0, 255, "005200", "CGEXP", "Culture générale et expression"),
(  53, 0, 0, 0, 100, 0, 255, "005300", "SIGNE", "Langue des signes française"),
(  54, 0, 0, 1, 100, 0, 255, "005400", "VISCO", "Vie scolaire"),
(  55, 0, 0, 0, 100, 0, 255, "005500", "SECUR", "Sécurité"),
(  56, 0, 0, 0, 100, 0, 255, "005600", "PPENC", "Projet pluritechnique encadré"),
(  57, 0, 0, 0, 100, 0, 255, "005700", "RELAP", "Relations professionnelles"),
(  58, 0, 0, 0, 100, 0, 255, "005800", "METHO", "Modules méthodologiques"),
(  59, 0, 0, 0, 100, 0, 255, "005900", "PPAPP", "Projets professionnels appliqués"),
(  60, 0, 0, 0, 100, 0, 255, "006000", "CMPRO", "Connaissance du milieu professionnel"),
(  61, 0, 0, 0, 100, 0, 255, "006100", "APAMO", "Aide au partenariat et à la mobilité"),
(  62, 0, 0, 0, 100, 0, 255, "006200", "ACDEL", "Activités déléguées"),
(  63, 0, 0, 0, 100, 0, 255, "006300", "ATMET", "Ateliers métiers"),
(  64, 0, 0, 0, 100, 0, 255, "006400", "ATLIE", "Atelier(s)"),
(  65, 0, 0, 0, 100, 0, 255, "006500", "AALIC", "Accès autonomie laboratoire informatique & communication"),
(  66, 0, 0, 0, 100, 0, 255, "006600", "ACCPE", "Accompagnement personnalisé"),
(  67, 0, 0, 0, 100, 0, 255, "006700", "INVES", "Méthodologie d’investigation"),
(  68, 0, 0, 0, 100, 0, 255, "006800", "CGENX", "Culture générale et expression"),
(  69, 0, 0, 0, 100, 0, 255, "006900", "ARTS" , "Arts"),
(  70, 0, 0, 0, 100, 0, 255, "007000", "MEPRO", "Méthodologie de projet"),
(  71, 0, 0, 0, 100, 0, 255, "007100", "MRECH", "Méthodologie de recherche"),
(  72, 0, 0, 0, 100, 0, 255, "007200", "ISIC" , "Isic"),
(  73, 0, 0, 0, 100, 0, 255, "007300", "ISAP" , "Isap"),
(  74, 0, 0, 0, 100, 0, 255, "007400", "DECPR", "Découverte professionnelle"),
(  75, 0, 0, 0, 100, 0, 255, "007500", "ACIND", "Activités inter-disciplinaires"),
(  76, 0, 0, 0, 100, 0, 255, "007600", "ACTPR", "Activités de projet"),
(  77, 0, 0, 0, 100, 0, 255, "007700", "CERPR", "Certification professionnelle"),
(  78, 0, 0, 0, 100, 0, 255, "007800", "AAEPR", "Accès autonomie équipements professionnels"),
(  79, 0, 0, 0, 100, 0, 255, "007900", "APDPR", "Approche pluridisciplinaire & dimension professionnelle"),
(  80, 0, 0, 0, 100, 0, 255, "008000", "MOENG", "Modules (français - maths - hist.geo - LV1)"),
(  81, 0, 0, 0, 100, 0, 255, "008100", "AAALO", "Actions appliquées et d’adaptation locale"),
(  82, 0, 0, 0, 100, 0, 255, "008200", "ARRDI", "Accès en responsabilité aux ress. doc. informatisées ets"),
(  83, 0, 0, 0, 100, 0, 255, "008300", "ETUDE", "Études (dirigées ou encadrées)"),
(  84, 0, 0, 0, 100, 0, 255, "008400", "VICLA", "Vie de la classe"),
(  85, 0, 0, 0, 100, 0, 255, "008500", "AIAUT", "Aide individualisée autres matières"),
(  86, 0, 0, 0, 100, 0, 255, "008600", "RANIV", "Remise à niveau"),
(  87, 0, 0, 0, 100, 0, 255, "008700", "AIDIN", "Aide individualisée"),
(  88, 0, 0, 0, 100, 0, 255, "008800", "ACTIP", "Action professionnelle"),
(  89, 0, 0, 0, 100, 0, 255, "008900", "STRTI", "Stratégie et techniques d’intervention"),
(  90, 0, 0, 0, 100, 0, 255, "009000", "MEQUI", "Management d’équipe"),
(  91, 0, 0, 0, 100, 0, 255, "009100", "EPE"  , "Étude personnalisée encadrée"),
(  92, 0, 0, 0, 100, 0, 255, "009200", "ATELP", "Atelier de professionnalisation"),
(  93, 0, 0, 0, 100, 0, 255, "009300", "FILOC", "Formation d’initiative locale"),
(  94, 0, 0, 0, 100, 0, 255, "009400", "AT-PX", "Ateliers principaux"),
(  95, 0, 0, 0, 100, 0, 255, "009500", "AT-CO", "Ateliers complémentaires"),
(  96, 0, 0, 0, 100, 0, 255, "009600", "COMPR", "Connaissance des milieux professionnels"),
(  97, 0, 0, 0, 100, 0, 255, "009700", "PROPR", "Projet professionnel"),
(  98, 0, 0, 0, 100, 0, 255, "009800", "AEAID", "Acccompagn.éducatif - aide devoirs leçons"),
(  99, 0, 0, 0, 100, 0, 255, "009900", "ACNSD", "Activités non spécialisées diverses"),

-- 1 Philosophie sciences humaines

( 101, 0, 0, 0,   1, 0, 255, "010100", "CULSH", "Culture générale et sciences humaines"),
( 102, 0, 0, 0,   1, 0, 255, "010200", "PHI-R", "Philosophie renforcée"),
( 103, 0, 0, 1,   1, 0, 255, "010300", "PHILO", "Philosophie"),
( 104, 0, 0, 0,   1, 0, 255, "010400", "SCHUM", "Sciences humaines"),
( 105, 0, 0, 0,   1, 0, 255, "010500", "HLPHI", "Humanités, littérature et philosophie"),
( 106, 0, 0, 0,   1, 0, 255, "010600", "PSY-S", "Psychologie sociologie"),
( 107, 0, 0, 0,   1, 0, 255, "010700", "PSY-P", "Psychologie - psychosociologie"),
( 108, 0, 0, 0,   1, 0, 255, "010800", "SOCIO", "Sociologie"),
( 109, 0, 0, 0,   1, 0, 255, "010900", "ESTSE", "Esthétique sémiologie"),
( 110, 0, 0, 0,   1, 0, 255, "011000", "PSYKO", "Psychologie"),
( 111, 0, 0, 0,   1, 0, 255, "011100", "PSY-G", "Psychologie et pédagogie"),
( 112, 0, 0, 0,   1, 0, 255, "011200", "PSYSE", "Psycho-sociologie - esthétique - sémiologie"),
( 113, 0, 0, 0,   1, 0, 255, "011300", "PSYCO", "Psychologie de la communication"),
( 114, 0, 0, 0,   1, 0, 255, "011400", "IMACS", "Image:communication sémiologie - esthétique"),
( 115, 0, 0, 0,   1, 0, 255, "011500", "PHIAR", "Philosophie générale de l’art"),
( 116, 0, 0, 0,   1, 0, 255, "011600", "SEMIO", "Sémiologie"),
( 117, 0, 0, 0,   1, 0, 255, "011700", "CULSP", "Culture du spectacle"),
( 118, 0, 0, 0,   1, 0, 255, "011800", "C-COM", "Cultures de la communication"),
( 119, 0, 0, 0,   1, 0, 255, "011900", "S-PSY", "Sensibilisation concepts psy etc"),
( 120, 0, 0, 0,   1, 0, 255, "012000", "CPOLI", "Connaissance des politiques institutions"),
( 121, 0, 0, 0,   1, 0, 255, "012100", "SCHSD", "Sciences humaines, sociales et droit"),
( 122, 0, 0, 0,   1, 0, 255, "012200", "SHPAD", "Sciences humaines et philosophie générale de l’art et du design"),
( 199, 0, 0, 0,   1, 0, 255, "019900", "PHI-H", "Philosophie sciences humaines divers"),

-- 2 Lettres

( 201, 0, 0, 1,   2, 0, 255, "020100", "LATIN", "Latin"),
( 202, 0, 0, 1,   2, 0, 255, "020200", "GREC" , "Grec ancien"),
( 203, 0, 0, 0,   2, 0, 255, "020300", "LCALA", "Langues et cultures de l’Antiquité - Latin"),
( 204, 0, 0, 0,   2, 0, 255, "020400", "LCAGR", "Langues et cultures de l’antiquité - Grec"),
( 205, 0, 0, 0,   2, 0, 255, "020500", "FR-PA", "Français et éléments de psychologie appliquée"),
( 206, 0, 0, 0,   2, 0, 255, "020600", "EX-RU", "Expression française - relations humaines"),
( 207, 0, 0, 1,   2, 0, 255, "020700", "FRANC", "Français"),
( 208, 0, 0, 0,   2, 0, 255, "020800", "FR-MO", "Franchis module"),
( 209, 0, 0, 0,   2, 0, 255, "020900", "LITSO", "Littérature et société"),
( 210, 0, 0, 0,   2, 0, 255, "021000", "THEME", "Thème"),
( 211, 0, 0, 0,   2, 0, 255, "021100", "FR-MT", "Français maths (ses)"),
( 212, 0, 0, 0,   2, 0, 255, "021200", "CULEF", "Culture et expression française"),
( 213, 0, 0, 0,   2, 0, 255, "021300", "EXPRS", "Expression"),
( 214, 0, 0, 0,   2, 0, 255, "021400", "EX-FR", "Expression française"),
( 215, 0, 0, 0,   2, 0, 255, "021500", "T-EEO", "Techniques d’expression écrite et orale"),
( 216, 0, 0, 0,   2, 0, 255, "021600", "FR-SH", "Français sciences humaines"),
( 217, 0, 0, 0,   2, 0, 255, "021700", "FR-PE", "Français et problèmes économiques"),
( 218, 0, 0, 0,   2, 0, 255, "021800", "T-ANA", "Techniques d’analyse"),
( 219, 0, 0, 0,   2, 0, 255, "021900", "EVLAR", "Environnement littéraire et artistique"),
( 220, 0, 0, 0,   2, 0, 255, "022000", "ECEXF", "Ecriture et expression française"),
( 221, 0, 0, 0,   2, 0, 255, "022100", "FR-HG", "Francais, histoire-géographie"),
( 223, 0, 0, 0,   2, 0, 255, "022300", "LETTR", "Lettres"),
( 224, 0, 0, 0,   2, 0, 255, "022400", "GRESP", "Grec spécialité"),
( 225, 0, 0, 0,   2, 0, 255, "022500", "LATSP", "Latin spécialité"),
( 226, 0, 0, 0,   2, 0, 255, "022600", "CGPCO", "Culture générale pratique de la communication"),
( 227, 0, 0, 0,   2, 0, 255, "022700", "FR-PH", "Français philosophie"),
( 228, 0, 0, 0,   2, 0, 255, "022800", "CULCO", "Culture et communication"),
( 229, 0, 0, 0,   2, 0, 255, "022900", "LITCI", "Littérature et civilisation étrangère"),
( 230, 0, 0, 0,   2, 0, 255, "023000", "LCR"  , "Langues et cultures régionales"),
( 231, 0, 0, 0,   2, 0, 255, "023100", "AIFRA", "Aide individualisée en français"),
( 232, 0, 0, 0,   2, 0, 255, "023200", "FRLIT", "Français et littérature"),
( 233, 0, 0, 0,   2, 0, 255, "023300", "LITTE", "Littérature"),
( 234, 0, 0, 0,   2, 0, 255, "023400", "CUGEX", "Culture générale et expression"),
( 235, 0, 0, 0,   2, 0, 255, "023500", "FHGEC", "Francais, histoire-géographie et enseignement moral et civique"),
( 236, 0, 0, 0,   2, 0, 255, "023600", "LGLIT", "Langue et littérature"),
( 237, 0, 0, 0,   2, 0, 255, "023700", "LCUCO", "Langue, culture et communication"),
( 238, 0, 0, 0,   2, 0, 255, "023800", "FRLET", "Français langue étrangère"),
( 239, 0, 0, 0,   2, 0, 255, "023900", "FRLSE", "Français langue seconde"),
( 240, 0, 0, 0,   2, 0, 255, "024000", "LCALG", "Langues et cultures de l’Antiquité latin et grec"),
( 241, 0, 0, 0,   2, 0, 255, "024100", "LLCAL", "Littérature et langues et cultures de l’Antiquité - Latin"),
( 242, 0, 0, 0,   2, 0, 255, "024200", "LLCAG", "Littérature et langues et cultures de l’Antiquité - Grec"),
( 243, 0, 0, 0,   2, 0, 255, "024300", "ELOQU", "Éloquence"),
( 299, 0, 0, 0,   2, 0, 255, "029900", "LETDI", "Lettres divers"),

-- 3 Langues vivantes ; voir la famille 93 pour le rangement des autres langues...

( 300, 0, 0, 0,   3, 0, 255, "039701", "FLE"  , "Français langue étrangère"),
( 301, 0, 0, 0,   3, 0, 255, "030100", "ALL"  , "Allemand"),
( 302, 0, 0, 0,   3, 0, 255, "030200", "AGL"  , "Anglais"),
( 303, 0, 0, 0,   3, 0, 255, "030300", "ARA"  , "Arabe"),
( 304, 0, 0, 0,   3, 0, 255, "030400", "CHI"  , "Chinois"),
( 305, 0, 0, 0,   3, 0, 255, "030500", "DAN"  , "Danois"),
( 306, 0, 0, 0,   3, 0, 255, "030600", "ESP"  , "Espagnol"),
( 309, 0, 0, 0,   3, 0, 255, "030900", "ITA"  , "Italien"),
( 310, 0, 0, 0,   3, 0, 255, "031000", "JAP"  , "Japonais"),
( 311, 0, 0, 0,   3, 0, 255, "031100", "POR"  , "Portugais"),
( 312, 0, 0, 0,   3, 0, 255, "031200", "NEE"  , "Néerlandais"),
( 313, 0, 0, 0,   3, 0, 255, "031300", "POL"  , "Polonais"),
( 314, 0, 0, 0,   3, 0, 255, "031400", "RUS"  , "Russe"),
(9339, 0, 0, 0,   3, 0, 255, "033900", "COE"  , "Coréen"),
( 315, 0, 0, 1,   3, 0, 255, "030101", "ALL1" , "Allemand LV1"),
( 316, 0, 0, 1,   3, 0, 255, "030201", "AGL1" , "Anglais LV1"),
( 317, 0, 0, 0,   3, 0, 255, "030301", "ARA1" , "Arabe LV1"),
( 318, 0, 0, 0,   3, 0, 255, "030401", "CHI1" , "Chinois LV1"),
( 319, 0, 0, 0,   3, 0, 255, "030501", "DAN1" , "Danois LV1"),
( 320, 0, 0, 1,   3, 0, 255, "030601", "ESP1" , "Espagnol LV1"),
( 321, 0, 0, 0,   3, 0, 255, "030901", "ITA1" , "Italien LV1"),
( 322, 0, 0, 0,   3, 0, 255, "031001", "JAP1" , "Japonais LV1"),
( 323, 0, 0, 0,   3, 0, 255, "031101", "POR1" , "Portugais LV1"),
( 324, 0, 0, 0,   3, 0, 255, "031201", "NEE1" , "Néerlandais LV1"),
( 325, 0, 0, 0,   3, 0, 255, "031301", "POL1" , "Polonais LV1"),
( 326, 0, 0, 0,   3, 0, 255, "031401", "RUS1" , "Russe LV1"),
(9391, 0, 0, 0,   3, 0, 255, "033901", "COE1" , "Coréen LV1"),
( 327, 0, 0, 1,   3, 0, 255, "030102", "ALL2" , "Allemand LV2"),
( 328, 0, 0, 1,   3, 0, 255, "030202", "AGL2" , "Anglais LV2"),
( 329, 0, 0, 0,   3, 0, 255, "030302", "ARA2" , "Arabe LV2"),
( 330, 0, 0, 0,   3, 0, 255, "030402", "CHI2" , "Chinois LV2"),
( 331, 0, 0, 0,   3, 0, 255, "030502", "DAN2" , "Danois LV2"),
( 332, 0, 0, 1,   3, 0, 255, "030602", "ESP2" , "Espagnol LV2"),
( 333, 0, 0, 0,   3, 0, 255, "030902", "ITA2" , "Italien LV2"),
( 334, 0, 0, 0,   3, 0, 255, "031002", "JAP2" , "Japonais LV2"),
( 335, 0, 0, 0,   3, 0, 255, "031102", "POR2" , "Portugais LV2"),
( 336, 0, 0, 0,   3, 0, 255, "031202", "NEE2" , "Néerlandais LV2"),
( 337, 0, 0, 0,   3, 0, 255, "031302", "POL2" , "Polonais LV2"),
( 338, 0, 0, 0,   3, 0, 255, "031402", "RUS2" , "Russe LV2"),
(9392, 0, 0, 0,   3, 0, 255, "033902", "COE2" , "Coréen LV2"),
( 339, 0, 0, 0,   3, 0, 255, "030103", "ALL3" , "Allemand LV3"),
( 340, 0, 0, 0,   3, 0, 255, "030203", "AGL3" , "Anglais LV3"),
( 341, 0, 0, 0,   3, 0, 255, "030303", "ARA3" , "Arabe LV3"),
( 342, 0, 0, 0,   3, 0, 255, "030403", "CHI3" , "Chinois LV3"),
( 343, 0, 0, 0,   3, 0, 255, "030503", "DAN3" , "Danois LV3"),
( 344, 0, 0, 0,   3, 0, 255, "030603", "ESP3" , "Espagnol LV3"),
( 345, 0, 0, 0,   3, 0, 255, "030903", "ITA3" , "Italien LV3"),
( 346, 0, 0, 0,   3, 0, 255, "031003", "JAP3" , "Japonais LV3"),
( 347, 0, 0, 0,   3, 0, 255, "031103", "POR3" , "Portugais LV3"),
( 348, 0, 0, 0,   3, 0, 255, "031203", "NEE3" , "Néerlandais LV3"),
( 349, 0, 0, 0,   3, 0, 255, "031303", "POL3" , "Polonais LV3"),
( 350, 0, 0, 0,   3, 0, 255, "031403", "RUS3" , "Russe LV3"),
(9393, 0, 0, 0,   3, 0, 255, "033903", "COE3" , "Coréen LV3"),
( 351, 0, 0, 0,   3, 0, 255, "030104", "ALL4" , "Allemand renforcé"),
( 352, 0, 0, 0,   3, 0, 255, "030204", "AGL4" , "Anglais renforcé"),
( 353, 0, 0, 0,   3, 0, 255, "030304", "ARA4" , "Arabe renforcé"),
( 354, 0, 0, 0,   3, 0, 255, "030404", "CHI4" , "Chinois renforcé"),
( 355, 0, 0, 0,   3, 0, 255, "030504", "DAN4" , "Danois renforcé"),
( 356, 0, 0, 0,   3, 0, 255, "030604", "ESP4" , "Espagnol renforcé"),
( 357, 0, 0, 0,   3, 0, 255, "030904", "ITA4" , "Italien renforcé"),
( 358, 0, 0, 0,   3, 0, 255, "031004", "JAP4" , "Japonais renforcé"),
( 359, 0, 0, 0,   3, 0, 255, "031104", "POR4" , "Portugais renforcé"),
( 360, 0, 0, 0,   3, 0, 255, "031204", "NEE4" , "Néerlandais renforcé"),
( 361, 0, 0, 0,   3, 0, 255, "031304", "POL4" , "Polonais renforcé"),
( 362, 0, 0, 0,   3, 0, 255, "031404", "RUS4" , "Russe renforcé"),
(9394, 0, 0, 0,   3, 0, 255, "033904", "COE4" , "Coréen renforcé"),
( 363, 0, 0, 0,   3, 0, 255, "030109", "ALL9" , "Allemand langue de section"),
( 364, 0, 0, 0,   3, 0, 255, "030209", "AGL9" , "Anglais langue de section"),
( 365, 0, 0, 0,   3, 0, 255, "030309", "ARA9" , "Arabe langue de section"),
( 366, 0, 0, 0,   3, 0, 255, "030409", "CHI9" , "Chinois langue de section"),
( 367, 0, 0, 0,   3, 0, 255, "030509", "DAN9" , "Danois langue de section"),
( 368, 0, 0, 0,   3, 0, 255, "030609", "ESP9" , "Espagnol langue de section"),
( 369, 0, 0, 0,   3, 0, 255, "030909", "ITA9" , "Italien langue de section"),
( 370, 0, 0, 0,   3, 0, 255, "031009", "JAP9" , "Japonais langue de section"),
( 371, 0, 0, 0,   3, 0, 255, "031109", "POR9" , "Portugais langue de section"),
( 372, 0, 0, 0,   3, 0, 255, "031209", "NEE9" , "Néerlandais langue de section"),
( 373, 0, 0, 0,   3, 0, 255, "031309", "POL9" , "Polonais langue de section"),
( 374, 0, 0, 0,   3, 0, 255, "031409", "RUS9" , "Russe langue de section"),
(9395, 0, 0, 0,   3, 0, 255, "033909", "COE9" , "Coréen langue de section"),
( 375, 0, 0, 0,   3, 0, 255, "030119", "ALL9C", "Allemand lettres étrangères"),
( 376, 0, 0, 0,   3, 0, 255, "030219", "AGL9C", "Anglais lettres étrangères"),
( 377, 0, 0, 0,   3, 0, 255, "030319", "ARA9C", "Arabe lettres étrangères"),
( 378, 0, 0, 0,   3, 0, 255, "030419", "CHI9C", "Chinois lettres étrangères"),
( 379, 0, 0, 0,   3, 0, 255, "030519", "DAN9C", "Danois lettres étrangères"),
( 380, 0, 0, 0,   3, 0, 255, "030619", "ESP9C", "Espagnol lettres étrangères"),
( 381, 0, 0, 0,   3, 0, 255, "030919", "ITA9C", "Italien lettres étrangères"),
( 382, 0, 0, 0,   3, 0, 255, "031019", "JAP9C", "Japonais lettres étrangères"),
( 383, 0, 0, 0,   3, 0, 255, "031119", "POR9C", "Portugais lettres étrangères"),
( 384, 0, 0, 0,   3, 0, 255, "031219", "NEE9C", "Néerlandais lettres étrangères"),
( 385, 0, 0, 0,   3, 0, 255, "031319", "POL9C", "Polonais lettres étrangères"),
( 386, 0, 0, 0,   3, 0, 255, "031419", "RUS9C", "Russe lettres étrangères"),
(9396, 0, 0, 0,   3, 0, 255, "033919", "COE9C", "Coréen lettres étrangères"),
( 387, 0, 0, 0,   3, 0, 255, "030108", "ALL8" , "Littérature étrangère en allemand"),
( 388, 0, 0, 0,   3, 0, 255, "030208", "AGL8" , "Littérature étrangère en anglais"),
( 389, 0, 0, 0,   3, 0, 255, "030308", "ARA8" , "Littérature étrangère en arabe"),
( 390, 0, 0, 0,   3, 0, 255, "030408", "CHI8" , "Littérature étrangère en chinois"),
( 391, 0, 0, 0,   3, 0, 255, "030508", "DAN8" , "Littérature étrangère en danois"),
( 392, 0, 0, 0,   3, 0, 255, "030608", "ESP8" , "Littérature étrangère en espagnol"),
( 393, 0, 0, 0,   3, 0, 255, "030908", "ITA8" , "Littérature étrangère en italien"),
( 394, 0, 0, 0,   3, 0, 255, "031008", "JAP8" , "Littérature étrangère en japonais"),
( 395, 0, 0, 0,   3, 0, 255, "031108", "POR8" , "Littérature étrangère en portugais"),
( 396, 0, 0, 0,   3, 0, 255, "031208", "NEE8" , "Littérature étrangère en néerlandais"),
( 397, 0, 0, 0,   3, 0, 255, "031308", "POL8" , "Littérature étrangère en polonais"),
( 398, 0, 0, 0,   3, 0, 255, "031408", "RUS8" , "Littérature étrangère en russe"),
(9397, 0, 0, 0,   3, 0, 255, "033908", "COE8" , "Littérature étrangère en coréen"),
( 399, 0, 0, 0,   3, 0, 255, "039900", "LANDI", "Langues divers"),

-- 4 Histoire géographie

( 401, 0, 0, 0,   4, 0, 255, "040100", "HIGHO", "Histoire et géographie hôtelière"),
( 402, 0, 0, 0,   4, 0, 255, "040200", "I-MDC", "Initiation au monde contemporain"),
( 403, 0, 0, 0,   4, 0, 255, "040300", "HIGEC", "Histoire et géographie économique"),
( 404, 0, 0, 0,   4, 0, 255, "040400", "HIFES", "Histoire faits économiques et sociaux"),
( 405, 0, 0, 0,   4, 0, 255, "040500", "HISTE", "Histoire sciences techniques entreprises"),
( 406, 0, 0, 1,   4, 0, 255, "040600", "HIGEO", "Histoire et géographie"),
( 407, 0, 0, 0,   4, 0, 255, "040700", "HIGMO", "Histoire géographie module"),
( 408, 0, 0, 0,   4, 0, 255, "040800", "HISTO", "Histoire"),
( 409, 0, 0, 0,   4, 0, 255, "040900", "GEOGF", "Géographie"),
( 410, 0, 0, 0,   4, 0, 255, "041000", "GEOGT", "Géographie générale et touristique"),
( 411, 0, 0, 0,   4, 0, 255, "041100", "GEOAT", "Géographie appliquée au tourisme"),
( 412, 0, 0, 0,   4, 0, 255, "041200", "GEOAP", "Géographie appliquée"),
( 413, 0, 0, 0,   4, 0, 255, "041300", "GEOEC", "Géographie économique"),
( 414, 0, 0, 0,   4, 0, 255, "041400", "EDCIV", "Education civique"),
( 415, 0, 0, 0,   4, 0, 255, "041500", "CO-MC", "Connaissance du monde contemporain"),
( 416, 0, 0, 0,   4, 0, 255, "041600", "HIGIC", "Histoire - géographie - instruction civique"),
( 417, 0, 0, 0,   4, 0, 255, "041700", "CIVLS", "Civilisation"),
( 418, 0, 0, 0,   4, 0, 255, "041800", "HIANC", "Histoire ancienne"),
( 419, 0, 0, 0,   4, 0, 255, "041900", "HICTX", "Histoire - commentaire de textes"),
( 420, 0, 0, 0,   4, 0, 255, "042000", "HGECV", "Hist-géo - économie et éducation civique"),
( 421, 0, 0, 0,   4, 0, 255, "042100", "HIGCV", "Histoire-géographie et enseignement moral et civique"),
( 422, 0, 0, 0,   4, 0, 255, "042200", "HIGLP", "Hist - géographie - législation professionnelle"),
( 423, 0, 0, 0,   4, 0, 255, "042300", "HICON", "Histoire contemporaine"),
( 424, 0, 0, 0,   4, 0, 255, "042400", "HIMOD", "Histoire moderne de la France"),
( 425, 0, 0, 0,   4, 0, 255, "042500", "GEFRA", "Géographie historique de la France"),
( 426, 0, 0, 0,   4, 0, 255, "042600", "HIMED", "Histoire médiévale"),
( 427, 0, 0, 0,   4, 0, 255, "042700", "HISMC", "Histoire moderne et contemporaine"),
( 428, 0, 0, 0,   4, 0, 255, "042800", "HECRI", "Histoire des écritures"),
( 429, 0, 0, 0,   4, 0, 255, "042900", "ECJS" , "Education civique juridique et sociale"),
( 430, 0, 0, 0,   4, 0, 255, "043000", "GHCIV", "Géographie et histoire des civilisations"),
( 431, 0, 0, 0,   4, 0, 255, "043100", "ANPAT", "Analyse du patrimoine"),
( 432, 0, 0, 0,   4, 0, 255, "043200", "PATRG", "Patrimoine culturel & touristique régional"),
( 433, 0, 0, 0,   4, 0, 255, "043300", "FHGCI", "Francais hist.geo. éducation civique"),
( 434, 0, 0, 0,   4, 0, 255, "043400", "HIMAG", "Histoire de l’image"),
( 435, 0, 0, 0,   4, 0, 255, "043500", "HMEMO", "Histoire médiévale & moderne"),
( 436, 0, 0, 0,   4, 0, 255, "043600", "HGGMC", "Histoire, géographie & géopolitique du monde contemporain"),
( 437, 0, 0, 0,   4, 0, 255, "043700", "HI-GE", "Histoire-géographie"),
( 438, 0, 0, 1,   4, 0, 255, "043800", "EMC"  , "Enseignement moral et civique"),
( 439, 0, 0, 0,   4, 0, 255, "043900", "HGGSP", "Histoire-géographie, géopolitique et sciences politiques"),
( 499, 0, 0, 0,   4, 0, 255, "049900", "HIGDV", "Histoire et géographie divers"),

-- 5 Sciences économiques et sociales

( 501, 0, 0, 0,   5, 0, 255, "050100", "TDECO", "Travaux dirigés d’économie"),
( 502, 0, 0, 0,   5, 0, 255, "050200", "SECO" , "Sciences économiques"),
( 503, 0, 0, 0,   5, 0, 255, "050300", "E-OAN", "Économie (analyse des économies)"),
( 504, 0, 0, 0,   5, 0, 255, "050400", "I-ESC", "Initiation économique et sociale"),
( 505, 0, 0, 0,   5, 0, 255, "050500", "I-ECO", "Initiation économique"),
( 506, 0, 0, 0,   5, 0, 255, "050600", "STECO", "Sciences et techniques économiques"),
( 507, 0, 0, 1,   5, 0, 255, "050700", "SES"  , "Sciences économiques et sociales"),
( 508, 0, 0, 0,   5, 0, 255, "050800", "E-OAP", "Économie appliquée"),
( 509, 0, 0, 0,   5, 0, 255, "050900", "E-OSS", "Économie et sciences sociales"),
( 510, 0, 0, 0,   5, 0, 255, "051000", "E-OSO", "Économie et social"),
( 511, 0, 0, 0,   5, 0, 255, "051100", "SESMO", "SES module"),
( 512, 0, 0, 0,   5, 0, 255, "051200", "SESDB", "SES débutants"),
( 513, 0, 0, 0,   5, 0, 255, "051300", "SESPE", "Sciences économiques spécialité"),
( 514, 0, 0, 0,   5, 0, 255, "051400", "E-HSC", "Anal économ historiq sociétés contemp."),
( 515, 0, 0, 0,   5, 0, 255, "051500", "I-SEC", "Initiation aux sciences économiques"),
( 516, 0, 0, 0,   5, 0, 255, "051600", "SCSOC", "Sciences sociales"),
( 517, 0, 0, 0,   5, 0, 255, "051700", "PUBLI", "Publics"),
( 518, 0, 0, 0,   5, 0, 255, "051800", "PRESE", "Prestations et services"),
( 519, 0, 0, 0,   5, 0, 255, "051900", "RSHUM", "Ressources humaines"),
( 520, 0, 0, 0,   5, 0, 255, "052000", "ADDRH", "Administ. develop. ressources humaines"),
( 521, 0, 0, 0,   5, 0, 255, "052100", "SSPOL", "Sciences sociales et politiques"),
( 522, 0, 0, 0,   5, 0, 255, "052200", "ECOAP", "Économie approfondie"),
( 523, 0, 0, 0,   5, 0, 255, "052300", "ESHMC", "Économie, sociologie & histoire du monde contemporain"),
( 599, 0, 0, 0,   5, 0, 255, "059900", "SECSD", "Sciences économiques et sociales divers"),

-- 6 Sciences

( 601, 0, 0, 0,   6, 0, 255, "060100", "PCAPP", "Physique et chimie appliquées"),
( 602, 0, 0, 0,   6, 0, 255, "060200", "TPPHC", "Travaux pratiques de physique-chimie"),
( 603, 0, 0, 0,   6, 0, 255, "060300", "CH-GE", "Chimie générale"),
( 604, 0, 0, 0,   6, 0, 255, "060400", "CPIND", "Chimie et physique industrielles"),
( 605, 0, 0, 0,   6, 0, 255, "060500", "TPMAT", "Travaux pratiques mathemat. sup. ou spe."),
( 606, 0, 0, 0,   6, 0, 255, "060600", "SCIEN", "Sciences"),
( 607, 0, 0, 0,   6, 0, 255, "060700", "MA-AI", "Mathematiques pour l’informatique"),
( 608, 0, 0, 0,   6, 0, 255, "060800", "TDPHY", "Travaux dirigés de physique"),
( 609, 0, 0, 0,   6, 0, 255, "060900", "CH-MN", "Chimie minérale"),
( 610, 0, 0, 0,   6, 0, 255, "061000", "TDMAT", "Travaux dirigés de mathématiques"),
( 611, 0, 0, 0,   6, 0, 255, "061100", "SCAPL", "Sciences appliquées"),
( 612, 0, 0, 0,   6, 0, 255, "061200", "CFOSC", "Complément de formation scientifique"),
( 613, 0, 0, 1,   6, 0, 255, "061300", "MATHS", "Mathématiques"),
( 614, 0, 0, 0,   6, 0, 255, "061400", "MA-RF", "Mathématiques renforcées"),
( 615, 0, 0, 0,   6, 0, 255, "061500", "MA-AP", "Mathématiques appliquées"),
( 616, 0, 0, 0,   6, 0, 255, "061600", "MA-IF", "Mathématiques informatique"),
( 617, 0, 0, 0,   6, 0, 255, "061700", "MA-SC", "Maths sciences"),
( 618, 0, 0, 0,   6, 0, 255, "061800", "MA-PH", "Mathématiques - sciences physiques"),
( 619, 0, 0, 0,   6, 0, 255, "061900", "OPTIM", "Optique optoélectronique et imagerie"),
( 620, 0, 0, 0,   6, 0, 255, "062000", "MA-SI", "Mathématiques statistiques informatique"),
( 621, 0, 0, 0,   6, 0, 255, "062100", "MA-ST", "Mathématiques et statistiques"),
( 622, 0, 0, 0,   6, 0, 255, "062200", "MA-ME", "Mathématiques et mécaniques"),
( 623, 0, 0, 1,   6, 0, 255, "062300", "PH-CH", "Physique-chimie"),
( 624, 0, 0, 0,   6, 0, 255, "062400", "SCPHY", "Sciences physiques"),
( 625, 0, 0, 0,   6, 0, 255, "062500", "TPSPH", "TP de sciences physiques"),
( 626, 0, 0, 0,   6, 0, 255, "062600", "PH-LI", "Physique (laboratoire industriel et recherche)"),
( 627, 0, 0, 0,   6, 0, 255, "062700", "PH-IN", "Physique industrielle"),
( 628, 0, 0, 0,   6, 0, 255, "062800", "SCPHA", "Sciences physiques appliquées"),
( 629, 0, 0, 1,   6, 0, 255, "062900", "SVT"  , "Sciences de la vie et de la terre"),
( 630, 0, 0, 0,   6, 0, 255, "063000", "PH-AO", "Physique appliquée optique"),
( 631, 0, 0, 0,   6, 0, 255, "063100", "PH-EL", "Physique électricité"),
( 632, 0, 0, 0,   6, 0, 255, "063200", "CH-LI", "Chimie (laboratoire industriel et recherche)"),
( 633, 0, 0, 0,   6, 0, 255, "063300", "CHIMI", "Chimie"),
( 634, 0, 0, 0,   6, 0, 255, "063400", "SCTKN", "Sciences appliquées et technologies nouvelles"),
( 635, 0, 0, 0,   6, 0, 255, "063500", "CH-CO", "Chimie générale et chimie organique"),
( 636, 0, 0, 0,   6, 0, 255, "063600", "CH-GI", "Chimie générale et inorganique"),
( 637, 0, 0, 0,   6, 0, 255, "063700", "MOSPH", "Module sciences physiques"),
( 638, 0, 0, 0,   6, 0, 255, "063800", "CH-OR", "Chimie organique"),
( 639, 0, 0, 0,   6, 0, 255, "063900", "CH-AM", "Chimie appliquée aux matériaux"),
( 640, 0, 0, 0,   6, 0, 255, "064000", "MA-MO", "Mathématiques module"),
( 641, 0, 0, 0,   6, 0, 255, "064100", "OPEAC", "Optique électronique acoustique"),
( 642, 0, 0, 0,   6, 0, 255, "064200", "PH-CM", "Physique chimie module"),
( 643, 0, 0, 0,   6, 0, 255, "064300", "SPHSA", "Sciences physiques et sciences appliquées"),
( 644, 0, 0, 0,   6, 0, 255, "064400", "SVTMO", "Sciences de la vie et de la terre module"),
( 645, 0, 0, 0,   6, 0, 255, "064500", "SCNAT", "Sciences naturelles"),
( 646, 0, 0, 0,   6, 0, 255, "064600", "LABO" , "Laboratoire"),
( 647, 0, 0, 0,   6, 0, 255, "064700", "SPHPA", "Sciences physiques et physique appliquée"),
( 648, 0, 0, 0,   6, 0, 255, "064800", "UIFCH", "Utilisation de l’informatique en chimie"),
( 649, 0, 0, 0,   6, 0, 255, "064900", "IESP" , "Informatique et électronique en sc ph"),
( 650, 0, 0, 0,   6, 0, 255, "065000", "STATI", "Statistiques"),
( 651, 0, 0, 0,   6, 0, 255, "065100", "MA-AQ", "Mathématiques appliquées et statistiques"),
( 652, 0, 0, 0,   6, 0, 255, "065200", "TSP"  , "Techniques des sciences physiques"),
( 653, 0, 0, 0,   6, 0, 255, "065300", "G-SCI", "Enseignement scientifique"),
( 654, 0, 0, 0,   6, 0, 255, "065400", "PH-MT", "Physique : mécanique - thermique - fluidique"),
( 655, 0, 0, 0,   6, 0, 255, "065500", "CH-AP", "Chimie appliquée"),
( 656, 0, 0, 0,   6, 0, 255, "065600", "OPPHC", "Optique et physico-chimie"),
( 657, 0, 0, 0,   6, 0, 255, "065700", "PHYSI", "Physique"),
( 658, 0, 0, 0,   6, 0, 255, "065800", "TPPHY", "Travaux pratiques de physique"),
( 659, 0, 0, 0,   6, 0, 255, "065900", "TPCHI", "Travaux pratiques de chimie"),
( 660, 0, 0, 0,   6, 0, 255, "066000", "TECSH", "Technologie et schéma"),
( 661, 0, 0, 0,   6, 0, 255, "066100", "CSCTE", "Cadre scientifique et technologique"),
( 662, 0, 0, 0,   6, 0, 255, "066200", "SCEXP", "Sciences expérimentales"),
( 663, 0, 0, 0,   6, 0, 255, "066300", "MA-AS", "Mathématiques appliquées spécialité"),
( 664, 0, 0, 0,   6, 0, 255, "066400", "MA-SP", "Mathématiques spécialité"),
( 665, 0, 0, 0,   6, 0, 255, "066500", "PH-CS", "Physique chimie spécialité"),
( 666, 0, 0, 0,   6, 0, 255, "066600", "SVT-S", "Sciences de la vie & de terre spécialité"),
( 667, 0, 0, 0,   6, 0, 255, "066700", "ATGCH", "Atelier de génie chimique"),
( 668, 0, 0, 0,   6, 0, 255, "066800", "OPTIQ", "Optique"),
( 669, 0, 0, 0,   6, 0, 255, "066900", "SPHCA", "Sciences phys et physique chimie appliquées"),
( 670, 0, 0, 0,   6, 0, 255, "067000", "S-IND", "Sciences industrielles"),
( 671, 0, 0, 0,   6, 0, 255, "067100", "CHI-4", "Chimie (4 heures cpge : pcsi)"),
( 672, 0, 0, 0,   6, 0, 255, "067200", "CHI-2", "Chimie (2eme periode cpge : psi)"),
( 673, 0, 0, 0,   6, 0, 255, "067300", "SC-IG", "Sciences de l’ingénieur"),
( 674, 0, 0, 0,   6, 0, 255, "067400", "CH-TC", "Chimie et technologie chimique"),
( 675, 0, 0, 0,   6, 0, 255, "067500", "PH-TP", "Physique et technologie physique"),
( 676, 0, 0, 0,   6, 0, 255, "067600", "S-IN4", "Sciences indust 4 heures 2e période mpsi"),
( 677, 0, 0, 0,   6, 0, 255, "067700", "S-IN2", "Sciences industr 2 heures mpsi"),
( 678, 0, 0, 0,   6, 0, 255, "067800", "PHCHA", "Physique appliquée - chimie appliquée"),
( 679, 0, 0, 0,   6, 0, 255, "067900", "OPTGP", "Optique géométrique et physique"),
( 680, 0, 0, 0,   6, 0, 255, "068000", "ETSOP", "Étude technique des systèmes optiques"),
( 681, 0, 0, 0,   6, 0, 255, "068100", "SPCHA", "Sciences physiques et chimie appliquée"),
( 682, 0, 0, 0,   6, 0, 255, "068200", "PCMET", "Physique chimie métallurgie"),
( 683, 0, 0, 0,   6, 0, 255, "068300", "AIMAT", "Aide individualisée en mathématiques"),
( 684, 0, 0, 0,   6, 0, 255, "068400", "MAPSP", "Mathématiques appliquées sc physiques"),
( 685, 0, 0, 0,   6, 0, 255, "068500", "MATPC", "Mathématiques, physique-chimie"),
( 686, 0, 0, 0,   6, 0, 255, "068600", "MASPC", "Mathématiques sciences physiques & chimiques"),
( 687, 0, 0, 0,   6, 0, 255, "068700", "SCIIN", "Sciences industrielles de l’ingénieur"),
( 688, 0, 0, 0,   6, 0, 255, "068800", "PCLAB", "Physique et chimie de laboratoire"),
( 689, 0, 0, 0,   6, 0, 255, "068900", "MPHIN", "Mesures physiques et informatique"),
( 690, 0, 0, 0,   6, 0, 255, "069000", "ISING", "Initiation aux sciences de l’ingénieur"),
( 691, 0, 0, 0,   6, 0, 255, "069100", "PHYAP", "Physique appliquée"),
( 692, 0, 0, 0,   6, 0, 255, "069200", "PAUDI", "Perception auditive"),
( 693, 0, 0, 0,   6, 0, 255, "069300", "PVISU", "Perception visuelle"),
( 694, 0, 0, 0,   6, 0, 255, "069400", "SPHCH", "Sciences physiques et chimiques"),
( 695, 0, 0, 0,   6, 0, 255, "069500", "SPCAP", "Sciences physiques&chimiques appliquées"),
( 696, 0, 0, 0,   6, 0, 255, "069600", "MP-SC", "Méthodes et pratiques scientifiques"),
( 697, 0, 0, 0,   6, 0, 255, "069700", "SCLAB", "Sciences physiques et chimiques en laboratoire"),
( 698, 0, 0, 0,   6, 0, 255, "069800", "MATAP", "Mathématiques approfondies"),
( 699, 0, 0, 0,   6, 0, 255, "069900", "SCDIV", "Sciences divers"),

-- 7 Technologie

( 701, 0, 0, 0,   7, 0, 255, "070100", "TECTD", "Technologie et travaux dirigés"),
( 702, 0, 0, 0,   7, 0, 255, "070200", "TECRE", "Technologie et réalisation"),
( 703, 0, 0, 0,   7, 0, 255, "070300", "TECAV", "Technologie appliquée au véhicule"),
( 704, 0, 0, 0,   7, 0, 255, "070400", "MESAU", "Mesures et automatismes"),
( 705, 0, 0, 0,   7, 0, 255, "070500", "T-IND", "Techniques industrielles"),
( 706, 0, 0, 0,   7, 0, 255, "070600", "TECAI", "Technologie et automatismes industriels"),
( 707, 0, 0, 0,   7, 0, 255, "070700", "CNTRE", "Contrôle et régulation"),
( 708, 0, 0, 1,   7, 0, 255, "070800", "TECHN", "Technologie"),
( 709, 0, 0, 0,   7, 0, 255, "070900", "TECGL", "Technologie générale"),
( 710, 0, 0, 0,   7, 0, 255, "071000", "ENPRO", "Enseignement professionnel"),
( 711, 0, 0, 0,   7, 0, 255, "071100", "G-TPR", "Enseignement technologique-professionnel"),
( 712, 0, 0, 0,   7, 0, 255, "071200", "T-REA", "Technique et réalisation"),
( 713, 0, 0, 0,   7, 0, 255, "071300", "TECIN", "Technologie industrielle"),
( 714, 0, 0, 0,   7, 0, 255, "071400", "TECMT", "Technologie appliquée moteur-transmission"),
( 715, 0, 0, 0,   7, 0, 255, "071500", "D-TEC", "Dessin et technologie"),
( 716, 0, 0, 0,   7, 0, 255, "071600", "TECPR", "Technologie professionnelle"),
( 717, 0, 0, 0,   7, 0, 255, "071700", "TECTA", "Technologie et travaux d’atelier"),
( 718, 0, 0, 0,   7, 0, 255, "071800", "TECIM", "Technologie industrielle module"),
( 719, 0, 0, 0,   7, 0, 255, "071900", "ATCTK", "Atelier de conception - technologie"),
( 720, 0, 0, 0,   7, 0, 255, "072000", "TREAL", "Technologie de réalisation"),
( 721, 0, 0, 0,   7, 0, 255, "072100", "TECME", "Technologie : métallurgie"),
( 722, 0, 0, 0,   7, 0, 255, "072200", "TECDE", "Technologie et dessin"),
( 723, 0, 0, 0,   7, 0, 255, "072300", "TECES", "Technologie des équipements et supports"),
( 724, 0, 0, 0,   7, 0, 255, "072400", "T-MEO", "Techniques et mise en œuvre"),
( 725, 0, 0, 0,   7, 0, 255, "072500", "TMNUM", "Technologie des médias numériques"),
( 726, 0, 0, 0,   7, 0, 255, "072600", "MOETP", "Module: enseign. techno. et professionnel."),
( 727, 0, 0, 0,   7, 0, 255, "072700", "ETDIF", "Enseignement technologique différencié"),
( 728, 0, 0, 0,   7, 0, 255, "072800", "QUAEX", "Qualité expérimentation"),
( 729, 0, 0, 0,   7, 0, 255, "072900", "NOUTK", "Nouvelles technologies"),
( 730, 0, 0, 0,   7, 0, 255, "073000", "TCMET", "Technologie - méthodes"),
( 731, 0, 0, 0,   7, 0, 255, "073100", "SCTCI", "Sciences et techniques industrielles"),
( 732, 0, 0, 0,   7, 0, 255, "073200", "ENSTC", "Enseignement technique"),
( 733, 0, 0, 0,   7, 0, 255, "073300", "TMMED", "Technologie multimédia"),
( 734, 0, 0, 0,   7, 0, 255, "073400", "FUTIL", "Fonction utilisateur"),
( 735, 0, 0, 0,   7, 0, 255, "073500", "CITEC", "Création & innovation technologiques"),
( 736, 0, 0, 0,   7, 0, 255, "073600", "INTEC", "Innovation technologique et éco-conception"),
( 737, 0, 0, 0,   7, 0, 255, "073700", "ETT"  , "Enseignements technologiques transversaux"),
( 738, 0, 0, 0,   7, 0, 255, "073800", "STECH", "Sciences et technologie"),
( 739, 0, 0, 0,   7, 0, 255, "073900", "TFABR", "Technologie de fabrication"),
( 740, 0, 0, 0,   7, 0, 255, "074000", "TPROF", "Technologies professionnelles"),
( 741, 0, 0, 0,   7, 0, 255, "074100", "ETP"  , "Enseignements techniques et professionnels"),
( 742, 0, 0, 0,   7, 0, 255, "074200", "TTPRO", "Technologie & techniques professionnelles"),
( 743, 0, 0, 0,   7, 0, 255, "074300", "TECNO", "Technologies"),
( 744, 0, 0, 0,   7, 0, 255, "074400", "EGLS", "Enseignements généraux liés à la specialité"),
( 745, 0, 0, 0,   7, 0, 255, "074500", "PRIND", "Production industrielle"),
( 746, 0, 0, 0,   7, 0, 255, "074600", "SNTEC", "Sciences numériques et technologie"),
( 747, 0, 0, 0,   7, 0, 255, "074700", "NSINF", "Numérique et sciences informatiques"),
( 748, 0, 0, 0,   7, 0, 255, "074800", "OULAN", "Outils et langages numériques"),
( 749, 0, 0, 0,   7, 0, 255, "074900", "INNTE", "Innovation technologique"),
( 750, 0, 0, 0,   7, 0, 255, "075000", "RCHOE", "Réalisation d’un chef d’oeuvre"),
( 751, 0, 0, 0,   7, 0, 255, "075100", "SMDSI", "Support et mise à disposition de services informatiques"),
( 752, 0, 0, 0,   7, 0, 255, "075200", "CYSIN", "Cybersécurite des services informatiques"),
( 799, 0, 0, 0,   7, 0, 255, "079900", "TECDI", "Technologie divers"),

-- 8 Éducation musicale

( 800, 0, 0, 0,   8, 0, 255, "081000", "EMUGT", "Education musicale générale et technique"),
( 801, 0, 0, 0,   8, 0, 255, "080100", "HIMCO", "Histoire musique - critique œuvres enregistrées"),
( 802, 0, 0, 0,   8, 0, 255, "080200", "DISTI", "Dictée - solfège - technique instrumentale"),
( 803, 0, 0, 0,   8, 0, 255, "080300", "DISOL", "Dictée - solfège"),
( 804, 0, 0, 0,   8, 0, 255, "080400", "T-INS", "Technique instrumentale"),
( 805, 0, 0, 0,   8, 0, 255, "080500", "DISTM", "Dictée - solfège - théorie musicale"),
( 806, 0, 0, 0,   8, 0, 255, "080600", "ENITM", "Ensemble instrumental"),
( 807, 0, 0, 0,   8, 0, 255, "080700", "HARMO", "Harmonie"),
( 808, 0, 0, 0,   8, 0, 255, "080800", "SOLFG", "Solfège"),
( 809, 0, 0, 0,   8, 0, 255, "080900", "CHANK", "Chant choral"),
( 811, 0, 0, 0,   8, 0, 255, "081100", "PCVOI", "Pratique collective vocale ou instrumentale"),
( 812, 0, 0, 0,   8, 0, 255, "081200", "N-MUS", "Enseignement musical"),
( 813, 0, 0, 1,   8, 0, 255, "081300", "EDMUS", "Education musicale"),
( 814, 0, 0, 0,   8, 0, 255, "081400", "MUSI5", "Musique 5 heures"),
( 815, 0, 0, 0,   8, 0, 255, "081500", "DANS5", "Danse 5 heures"),
( 816, 0, 0, 0,   8, 0, 255, "081600", "EXEIN", "Exécution instrumentale"),
( 817, 0, 0, 0,   8, 0, 255, "081700", "EXECH", "Exécution chorégraphique"),
( 818, 0, 0, 0,   8, 0, 255, "081800", "HIMUS", "Histoire de la musique"),
( 819, 0, 0, 0,   8, 0, 255, "081900", "I-OMU", "Initiation aux œuvres musicales"),
( 820, 0, 0, 0,   8, 0, 255, "082000", "DIMUS", "Dictée musicale"),
( 821, 0, 0, 0,   8, 0, 255, "082100", "ANALY", "Analyse"),
( 822, 0, 0, 0,   8, 0, 255, "082200", "LECVI", "Lecture à vue instrumentale"),
( 823, 0, 0, 0,   8, 0, 255, "082300", "MUSEN", "Musique d’ensemble"),
( 824, 0, 0, 0,   8, 0, 255, "082400", "HARSO", "Harmonie ou solfège"),
( 825, 0, 0, 0,   8, 0, 255, "082500", "DANSE", "Danse"),
( 826, 0, 0, 0,   8, 0, 255, "082600", "PR-IS", "Pratique instrumentale"),
( 827, 0, 0, 0,   8, 0, 255, "082700", "TECIV", "Technologie instrumentale et vocale"),
( 828, 0, 0, 0,   8, 0, 255, "082800", "KORAL", "Chorale"),
( 829, 0, 0, 0,   8, 0, 255, "082900", "TPENR", "Travaux pratiques d’enregistrement"),
( 830, 0, 0, 0,   8, 0, 255, "083000", "HASOK", "Harmonie ou solfège ou chorégraphie"),
( 831, 0, 0, 0,   8, 0, 255, "083100", "CHANT", "Chant"),
( 832, 0, 0, 0,   8, 0, 255, "083200", "MUSIQ", "Musique"),
( 833, 0, 0, 0,   8, 0, 255, "083300", "HIMUD", "Histoire de la musique et de la danse"),
( 834, 0, 0, 0,   8, 0, 255, "083400", "N-ART", "Enseignement artistique"),
( 835, 0, 0, 0,   8, 0, 255, "083500", "AP-MU", "Atelier de pratique : musique"),
( 836, 0, 0, 0,   8, 0, 255, "083600", "MUSPE", "Musique spécialité"),
( 837, 0, 0, 0,   8, 0, 255, "083700", "MUSPA", "Musique option - pratique artistique"),
( 838, 0, 0, 0,   8, 0, 255, "083800", "MUSCO", "Musicologie"),
( 839, 0, 0, 0,   8, 0, 255, "083900", "FOMUS", "Formation musicale"),
( 840, 0, 0, 0,   8, 0, 255, "084000", "ENSVI", "Ensemble vocal et/ou instrumental"),
( 841, 0, 0, 0,   8, 0, 255, "084100", "CMFOR", "Culture musicale formation de l’oreille"),
( 842, 0, 0, 0,   8, 0, 255, "084200", "FINST", "Formation instrumentale"),
( 843, 0, 0, 0,   8, 0, 255, "084300", "CHKO" , "Chant choral collectif"),
( 844, 0, 0, 0,   8, 0, 255, "084400", "FVOCA", "Formation vocale"),
( 845, 0, 0, 0,   8, 0, 255, "084500", "HIS-M", "Histoire des instruments - styles et musicologie"),
( 846, 0, 0, 0,   8, 0, 255, "084600", "CHORE", "Culture chorégraphique"),
( 847, 0, 0, 0,   8, 0, 255, "084700", "CMUSI", "Culture musicale"),
( 848, 0, 0, 0,   8, 0, 255, "084800", "ATSON", "Atelier son"),
( 849, 0, 0, 0,   8, 0, 255, "084900", "A-SON", "Arts du son"),
( 850, 0, 0, 0,   8, 0, 255, "085000", "CPDAN", "Culture et pratique de la danse"),
( 851, 0, 0, 0,   8, 0, 255, "085100", "CPMUS", "Culture et pratique de la musique"),
( 852, 0, 0, 0,   8, 0, 255, "085200", "CSCHO", "Culture et sciences chorégraphiques"),
( 853, 0, 0, 0,   8, 0, 255, "085300", "CSMUS", "Culture et sciences musicales"),
( 854, 0, 0, 0,   8, 0, 255, "085400", "PRCHO", "Pratique chorégraphique"),
( 855, 0, 0, 0,   8, 0, 255, "085500", "PRMUS", "Pratique musicale"),
( 899, 0, 0, 0,   8, 0, 255, "089900", "EDMUD", "Education musicale divers"),

-- 9 Arts plastiques

( 901, 0, 0, 1,   9, 0, 255, "090100", "A-PLA", "Arts plastiques"),
( 902, 0, 0, 0,   9, 0, 255, "090200", "APLA5", "Arts plastiques 5 heures"),
( 903, 0, 0, 0,   9, 0, 255, "090300", "A-VIS", "Arts visuels"),
( 904, 0, 0, 0,   9, 0, 255, "090400", "EDEST", "Education esthétique"),
( 905, 0, 0, 0,   9, 0, 255, "090500", "EDART", "Education artistique"),
( 906, 0, 0, 0,   9, 0, 255, "090600", "I-EST", "Initiation esthétique"),
( 907, 0, 0, 0,   9, 0, 255, "090700", "GRAPH", "Graphisme"),
( 908, 0, 0, 0,   9, 0, 255, "090800", "VOLUM", "Volume"),
( 909, 0, 0, 0,   9, 0, 255, "090900", "COULR", "Couleur"),
( 910, 0, 0, 0,   9, 0, 255, "091000", "AP-AP", "Atelier de pratique : arts plastiques"),
( 911, 0, 0, 0,   9, 0, 255, "091100", "A-PSP", "Arts plastiques spécialité"),
( 912, 0, 0, 0,   9, 0, 255, "091200", "A-PPA", "Arts plastiques option - pratique artistique"),
( 913, 0, 0, 0,   9, 0, 255, "091300", "TROID", "Compréhension 3d"),
( 914, 0, 0, 0,   9, 0, 255, "091400", "FESTH", "Formation esthétique (sai)"),
( 915, 0, 0, 0,   9, 0, 255, "091500", "AT-3D", "Atelier 3d"),
( 916, 0, 0, 0,   9, 0, 255, "091600", "CVISU", "Culture visuelle"),
( 917, 0, 0, 0,   9, 0, 255, "091700", "CPHOV", "Culture photographique et visuelle"),
( 918, 0, 0, 0,   9, 0, 255, "091800", "CDESG", "Culture du design graphique"),
( 919, 0, 0, 0,   9, 0, 255, "091900", "CTYPO", "Culture typographique"),
( 920, 0, 0, 0,   9, 0, 255, "092000", "PPGRA", "Pratique plastique & graphique"),
( 921, 0, 0, 0,   9, 0, 255, "092100", "DANAL", "Dessin analytique"),
( 998, 0, 0, 0,   9, 0, 255, "099800", "AEART", "Accompagnement éducatif - pratique art.culturel"),
( 999, 0, 0, 0,   9, 0, 255, "099900", "A-PLD", "Arts plastiques divers"),

-- 10 Éducation physique et sportive

(1001, 0, 0, 1,  10, 0, 255, "100100", "EPS"  , "Education physique et sportive"),
(1002, 0, 0, 0,  10, 0, 255, "100200", "ACSPS", "Activités sportives spécialisées"),
(1003, 0, 0, 0,  10, 0, 255, "100300", "EQUIT", "Equitation"),
(1004, 0, 0, 0,  10, 0, 255, "100400", "ESCRI", "Escrime"),
(1005, 0, 0, 0,  10, 0, 255, "100500", "EPSPA", "Education physique et sportive de plein air"),
(1006, 0, 0, 0,  10, 0, 255, "100600", "AP-PP", "Atelier de pratique : prat phys sport"),
(1007, 0, 0, 0,  10, 0, 255, "100700", "ATHLE", "Athlétisme"),
(1008, 0, 0, 0,  10, 0, 255, "100800", "AVIRO", "Aviron"),
(1009, 0, 0, 0,  10, 0, 255, "100900", "BASKT", "Basket-ball"),
(1010, 0, 0, 0,  10, 0, 255, "101000", "FOOTB", "Football"),
(1011, 0, 0, 0,  10, 0, 255, "101100", "GYMGA", "Gymnastique garçons"),
(1012, 0, 0, 0,  10, 0, 255, "101200", "GYMNA", "Gymnastique"),
(1013, 0, 0, 0,  10, 0, 255, "101300", "HANDB", "Handball"),
(1014, 0, 0, 0,  10, 0, 255, "101400", "JUDO" , "Judo"),
(1015, 0, 0, 0,  10, 0, 255, "101500", "NATAT", "Natation"),
(1016, 0, 0, 0,  10, 0, 255, "101600", "RUGBY", "Rugby"),
(1017, 0, 0, 0,  10, 0, 255, "101700", "SKI"  , "Ski"),
(1018, 0, 0, 0,  10, 0, 255, "101800", "TENIS", "Tennis"),
(1019, 0, 0, 0,  10, 0, 255, "101900", "TENIT", "Tennis de table"),
(1020, 0, 0, 0,  10, 0, 255, "102000", "TIRAC", "Tir à l’arc"),
(1021, 0, 0, 0,  10, 0, 255, "102100", "VOLEY", "Volley Ball"),
(1022, 0, 0, 0,  10, 0, 255, "102200", "ESCAL", "Escalade"),
(1023, 0, 0, 0,  10, 0, 255, "102300", "SKIFD", "Ski de fond"),
(1024, 0, 0, 0,  10, 0, 255, "102400", "HEAPS", "Hippologie et équitation ou autres pratiques sportives"),
(1025, 0, 0, 0,  10, 0, 255, "102500", "HPPEQ", "Hippologie et équitation"),
(1026, 0, 0, 0,  10, 0, 255, "102600", "AP-PS", "Atelier de pratique phys et sportives"),
(1027, 0, 0, 0,  10, 0, 255, "102700", "CANOK", "Canoë kayak"),
(1028, 0, 0, 0,  10, 0, 255, "102800", "GYMRS", "Gymnastique rythmique et sportive"),
(1029, 0, 0, 0,  10, 0, 255, "102900", "PAROU", "Patinage artistique sur roulettes"),
(1030, 0, 0, 0,  10, 0, 255, "103000", "GLADS", "Sports de glace (danse sur glace)"),
(1031, 0, 0, 0,  10, 0, 255, "103100", "VOLEF", "Volley-ball féminin"),
(1032, 0, 0, 0,  10, 0, 255, "103200", "VOLEM", "Volley-ball masculin"),
(1033, 0, 0, 0,  10, 0, 255, "103300", "SPAQT", "Sport aquatique"),
(1034, 0, 0, 0,  10, 0, 255, "103400", "CYCLI", "Cyclisme"),
(1035, 0, 0, 0,  10, 0, 255, "103500", "VOILE", "Voile"),
(1036, 0, 0, 0,  10, 0, 255, "103600", "GOLF" , "Golf"),
(1037, 0, 0, 0,  10, 0, 255, "103700", "EPS5H", "Education physique sportive (5 heures)"),
(1038, 0, 0, 0,  10, 0, 255, "103800", "ATEPS", "Atelier d’éducation physique et sportive"),
(1039, 0, 0, 0,  10, 0, 255, "103900", "EPS4H", "Education physique sportive (4 heures)"),
(1040, 0, 0, 0,  10, 0, 255, "104000", "EPSDE", "Educ physique sportive de détermination"),
(1041, 0, 0, 0,  10, 0, 255, "104100", "EPSCO", "Educ physique et sportive de complément"),
(1042, 0, 0, 0,  10, 0, 255, "104200", "COURS", "Courses athlétiques"),
(1043, 0, 0, 0,  10, 0, 255, "104300", "SAUTS", "Sauts athlétiques"),
(1044, 0, 0, 0,  10, 0, 255, "104400", "LANCE", "Lancers athlétiques"),
(1045, 0, 0, 0,  10, 0, 255, "104500", "VTT"  , "VTT"),
(1046, 0, 0, 0,  10, 0, 255, "104600", "BICRS", "Bicross"),
(1047, 0, 0, 0,  10, 0, 255, "104700", "HALMU", "Haltérophile et musculation"),
(1048, 0, 0, 0,  10, 0, 255, "104800", "ARMAR", "Arts martiaux (autres que le judo)"),
(1049, 0, 0, 0,  10, 0, 255, "104900", "GRYTM", "Gymnastique rythmique"),
(1050, 0, 0, 0,  10, 0, 255, "105000", "GAERO", "Gymnastique aérobique"),
(1051, 0, 0, 0,  10, 0, 255, "105100", "GACRO", "Gymnastique acrobatique"),
(1052, 0, 0, 0,  10, 0, 255, "105200", "ROLLE", "Activités sportives sur rollers"),
(1053, 0, 0, 0,  10, 0, 255, "105300", "GAGRE", "Gymnastique aux agrès"),
(1054, 0, 0, 0,  10, 0, 255, "105400", "GSOL" , "Gymnastique au sol"),
(1055, 0, 0, 0,  10, 0, 255, "105500", "GDOUC", "Gymnastiques douces"),
(1056, 0, 0, 0,  10, 0, 255, "105600", "PVOIL", "Planche à voile"),
(1057, 0, 0, 0,  10, 0, 255, "105700", "TRIAT", "Triathlon"),
(1058, 0, 0, 0,  10, 0, 255, "105800", "LUTTE", "Luttes"),
(1059, 0, 0, 0,  10, 0, 255, "105900", "BOXE" , "Boxe"),
(1060, 0, 0, 0,  10, 0, 255, "106000", "BOXFR", "Boxe française"),
(1061, 0, 0, 0,  10, 0, 255, "106100", "BADMI", "Badminton"),
(1062, 0, 0, 0,  10, 0, 255, "106200", "BASEB", "Baseball"),
(1063, 0, 0, 0,  10, 0, 255, "106300", "GARTI", "Gymnastique artistique"),
(1064, 0, 0, 0,  10, 0, 255, "106400", "ULTIM", "Ultimate"),
(1065, 0, 0, 0,  10, 0, 255, "106500", "SUBAQ", "Activités sportives subaquatiques"),
(1066, 0, 0, 0,  10, 0, 255, "106600", "TERNA", "Activités sportives terrestres de pleine nature"),
(1067, 0, 0, 0,  10, 0, 255, "106700", "ACIRQ", "Activités sportives de cirque"),
(1068, 0, 0, 0,  10, 0, 255, "106800", "AQUNA", "Activités sportives aquatiques de pleine nature"),
(1069, 0, 0, 0,  10, 0, 255, "106900", "SUBAN", "Activités sportives subaquatiques de pleine nature"),
(1070, 0, 0, 0,  10, 0, 255, "107000", "RAQUE", "Raquette"),
(1071, 0, 0, 0,  10, 0, 255, "107100", "GLACE", "Sports de glace"),
(1072, 0, 0, 0,  10, 0, 255, "107200", "AMONT", "Activités sportives de montagne"),
(1073, 0, 0, 0,  10, 0, 255, "107300", "CHARV", "Char a voiles"),
(1074, 0, 0, 0,  10, 0, 255, "107400", "CORPS", "Connaissance du corps"),
(1075, 0, 0, 0,  10, 0, 255, "107500", "EPSEE", "EPS enseignement d’exploration"),
(1076, 0, 0, 0,  10, 0, 255, "107600", "HOGAZ", "Hockey sur gazon"),
(1077, 0, 0, 0,  10, 0, 255, "107700", "HOGLA", "Hockey sur glace"),
(1078, 0, 0, 0,  10, 0, 255, "107800", "PATIG", "Patinage sur glace"),
(1079, 0, 0, 0,  10, 0, 255, "107900", "DANSP", "Danse sportive"),
(1080, 0, 0, 0,  10, 0, 255, "108000", "TRAMP", "Trampoline"),
(1081, 0, 0, 0,  10, 0, 255, "108100", "SPMEC", "Sports mécaniques (auto-moto)"),
(1082, 0, 0, 0,  10, 0, 255, "108200", "HANDI", "Handisport"),
(1083, 0, 0, 0,  10, 0, 255, "108300", "COUOR", "Course d’orientation"),
(1084, 0, 0, 0,  10, 0, 255, "108400", "PELBA", "Pelote basque"),
(1085, 0, 0, 0,  10, 0, 255, "108500", "SPAER", "Sports aériens"),
(1086, 0, 0, 0,  10, 0, 255, "108600", "PENTA", "Pentathlon"),
(1098, 0, 0, 0,  10, 0, 255, "109800", "AESPO", "Accompagnemt éducatif - pratique sportive"),
(1099, 0, 0, 0,  10, 0, 255, "109900", "EPSDI", "EPS divers"),

-- 11 Génie industriel du bois

(1102, 0, 0, 0,  11, 0, 255, "110200", "ATTSE", "Atelier techno spécialité ébénisterie"),
(1103, 0, 0, 0,  11, 0, 255, "110300", "HIAAS", "Histoire de l’art et analyse des styles"),
(1105, 0, 0, 0,  11, 0, 255, "110500", "ETFAB", "Étude de fabrication"),
(1106, 0, 0, 0,  11, 0, 255, "110600", "ETSYC", "Étude des systèmes constructifs"),
(1107, 0, 0, 0,  11, 0, 255, "110700", "TPFAS", "TP: fabrication - site"),
(1108, 0, 0, 0,  11, 0, 255, "110800", "TECSP", "Technologie de spécialité"),
(1109, 0, 0, 0,  11, 0, 255, "110900", "CALST", "Calcul des structures"),
(1110, 0, 0, 0,  11, 0, 255, "111000", "TECEB", "Technologie générale ébénisterie"),
(1111, 0, 0, 0,  11, 0, 255, "111100", "TECSE", "Technologie spécialité ébénisterie"),
(1112, 0, 0, 0,  11, 0, 255, "111200", "P-OR" , "Préparation et organisation"),
(1113, 0, 0, 0,  11, 0, 255, "111300", "R-GIB", "Réalisation et contrôle (gen indus bois)"),
(1114, 0, 0, 0,  11, 0, 255, "111400", "HISTY", "Histoire des styles"),
(1115, 0, 0, 0,  11, 0, 255, "111500", "TECCN", "Technologie et construction"),
(1116, 0, 0, 0,  11, 0, 255, "111600", "XYLOG", "Xylologie"),
(1117, 0, 0, 0,  11, 0, 255, "111700", "A-TMH", "Arts et tech du mobilier et de l’habitat"),
(1118, 0, 0, 0,  11, 0, 255, "111800", "BUREM", "Bureau d’études méthodes fabrication pos"),
(1119, 0, 0, 0,  11, 0, 255, "111900", "HYGSP", "Hygiène sécurité prévention"),
(1120, 0, 0, 0,  11, 0, 255, "112000", "MRMNB", "Monographie reco.macr.negoce du bois"),
(1121, 0, 0, 0,  11, 0, 255, "112100", "APINP", "Applications industrielles papeterie"),
(1122, 0, 0, 0,  11, 0, 255, "112200", "EQBOI", "Equipements annexes des industries du bois"),
(1123, 0, 0, 0,  11, 0, 255, "112300", "ATSPE", "Atelier spécialité ébénisterie"),
(1124, 0, 0, 0,  11, 0, 255, "112400", "MESPP", "Mesures et modèles processus papetiers"),
(1125, 0, 0, 0,  11, 0, 255, "112500", "TECIP", "Technologie des industries papetières"),
(1126, 0, 0, 0,  11, 0, 255, "112600", "EFPAP", "Étude fonction et structures des systèmes"),
(1127, 0, 0, 0,  11, 0, 255, "112700", "ERPAP", "Et.relat.produits-procédés (génie papetier)"),
(1128, 0, 0, 0,  11, 0, 255, "112800", "ESPAP", "Étude systémique process (génie papetier)"),
(1129, 0, 0, 0,  11, 0, 255, "112900", "CPPAP", "Conduite des process (génie papetier)"),
(1130, 0, 0, 0,  11, 0, 255, "113000", "EEPBA", "Expérimentation et essais (prod bois-am)"),
(1131, 0, 0, 0,  11, 0, 255, "113100", "ETINT", "Étude d’industrialisation et technologie"),
(1132, 0, 0, 0,  11, 0, 255, "113200", "QUALB", "Qualité (productique bois ameublement)"),
(1133, 0, 0, 0,  11, 0, 255, "113300", "FSECB", "Fabrication et sécurité (prod bois am )"),
(1134, 0, 0, 0,  11, 0, 255, "113400", "E-TMT", "Étude techno moyens de transfo (génie papetier)"),
(1135, 0, 0, 0,  11, 0, 255, "113500", "MOGMT", "Mise en o. gest.moyens de transf.(g.pap)"),
(1136, 0, 0, 0,  11, 0, 255, "113600", "DEVPR", "Développement de produits"),
(1137, 0, 0, 0,  11, 0, 255, "113700", "REAPR", "Réalisation de produits"),
(1138, 0, 0, 0,  11, 0, 255, "113800", "ETARC", "Étude architecturale"),
(1139, 0, 0, 0,  11, 0, 255, "113900", "ETPRP", "Étude et préparation de projet"),
(1199, 0, 0, 0,  11, 0, 255, "119900", "GNIBD", "Génie industriel du bois divers"),

-- 12 Génie industriel textile et cuir

(1201, 0, 0, 0,  12, 0, 255, "120100", "D-PRJ", "Dessin et projet"),
(1202, 0, 0, 0,  12, 0, 255, "120200", "TECAT", "Technologie application et travaux pratiques"),
(1203, 0, 0, 0,  12, 0, 255, "120300", "D-PAR", "Dessin professionnel artistique"),
(1204, 0, 0, 0,  12, 0, 255, "120400", "TECCP", "Technologie de complément"),
(1205, 0, 0, 0,  12, 0, 255, "120500", "CTPRD", "Construction du produit"),
(1206, 0, 0, 0,  12, 0, 255, "120600", "D-APF", "Dessin applique à la profession"),
(1207, 0, 0, 0,  12, 0, 255, "120700", "MOEUV", "Mise en œuvre"),
(1208, 0, 0, 0,  12, 0, 255, "120800", "TECCM", "Technologie construction mach - étude matériels"),
(1209, 0, 0, 0,  12, 0, 255, "120900", "FA-TC", "Fabrication (textile et cuir)"),
(1210, 0, 0, 0,  12, 0, 255, "121000", "ETMTR", "Étude du matériau"),
(1211, 0, 0, 0,  12, 0, 255, "121100", "D-TKM", "Dessin technique machines"),
(1212, 0, 0, 0,  12, 0, 255, "121200", "D-PRO", "Dessin professionnel"),
(1213, 0, 0, 0,  12, 0, 255, "121300", "MONOB", "Mise en œuvre de l’ennoblissement"),
(1214, 0, 0, 0,  12, 0, 255, "121400", "SPTMO", "Sciences physiques et techno de matières d’œuvre"),
(1215, 0, 0, 0,  12, 0, 255, "121500", "ETSET", "Étude des systèmes d’entretien articles textiles"),
(1216, 0, 0, 0,  12, 0, 255, "121600", "PRD-T", "Product m en oeuvre des proc entretien textiles"),
(1217, 0, 0, 0,  12, 0, 255, "121700", "TECCC", "Technologie de construction chaussures"),
(1218, 0, 0, 0,  12, 0, 255, "121800", "TPTKA", "Travaux pratiques et techno d’application"),
(1219, 0, 0, 0,  12, 0, 255, "121900", "D-TXT", "Dessin technique (textile et cuir)"),
(1220, 0, 0, 0,  12, 0, 255, "122000", "N-PCH", "Enseignement professionnel chaussures"),
(1221, 0, 0, 0,  12, 0, 255, "122100", "TECGF", "Technologie générale de fabrication"),
(1222, 0, 0, 0,  12, 0, 255, "122200", "TPHSP", "TP:hygiène-sécur.prod.-réglages-rel.hum."),
(1223, 0, 0, 0,  12, 0, 255, "122300", "TPTXT", "Travaux pratiques (textile et cuir)"),
(1224, 0, 0, 0,  12, 0, 255, "122400", "COUPE", "Coupe (trace moulage)"),
(1225, 0, 0, 0,  12, 0, 255, "122500", "O-IND", "Organisation industrielle"),
(1226, 0, 0, 0,  12, 0, 255, "122600", "F-EST", "Formation esthétique"),
(1227, 0, 0, 0,  12, 0, 255, "122700", "CUIRT", "Cuir brut et tannerie"),
(1228, 0, 0, 0,  12, 0, 255, "122800", "TECFA", "Technologie de fabrication"),
(1229, 0, 0, 0,  12, 0, 255, "122900", "G-OST", "Gestion-organ scient travail"),
(1230, 0, 0, 0,  12, 0, 255, "123000", "CH-AE", "Chimie appliquée à l’ennoblissement"),
(1234, 0, 0, 0,  12, 0, 255, "123400", "CDIRP", "Conception dévelop. industrialisation realisation produits"),
(1240, 0, 0, 0,  12, 0, 255, "124000", "GNIND", "Génie industriel"),
(1241, 0, 0, 0,  12, 0, 255, "124100", "LGTEC", "Langage technique"),
(1242, 0, 0, 0,  12, 0, 255, "124200", "ATCGP", "Atelier-controles et gestion de product"),
(1299, 0, 0, 0,  12, 0, 255, "129900", "GNITD", "Génie industriel textile et cuir divers"),

-- 13 Génie industriel verre céramique

(1301, 0, 0, 0,  13, 0, 255, "130100", "TPMIR", "Travaux pratiques miroiterie"),
(1302, 0, 0, 0,  13, 0, 255, "130200", "ATTP" , "Atelier TP (famille 13)"),
(1303, 0, 0, 0,  13, 0, 255, "130300", "R-EF" , "Réalisation d’ensembles fonctionnels"),
(1304, 0, 0, 0,  13, 0, 255, "130400", "SCAPF", "Sciences appliquées à la profession"),
(1305, 0, 0, 0,  13, 0, 255, "130500", "TPFAB", "Travaux pratiques de fabrication"),
(1306, 0, 0, 0,  13, 0, 255, "130600", "CP-EO", "Conception produits - étude outillages"),
(1307, 0, 0, 0,  13, 0, 255, "130700", "MPMEO", "Matériaux et procédés de mise en œuvre"),
(1308, 0, 0, 0,  13, 0, 255, "130800", "T-DEC", "Techniques de décoration"),
(1309, 0, 0, 0,  13, 0, 255, "130900", "SYOPT", "Système optique"),
(1310, 0, 0, 0,  13, 0, 255, "131000", "PROPT", "Production optique"),
(1311, 0, 0, 0,  13, 0, 255, "131100", "PRMEC", "Production mécanique (optique)"),
(1399, 0, 0, 0,  13, 0, 255, "139900", "GNVCD", "Génie industriel verre et céramique div"),

-- 14 Génie structures métalliques

(1402, 0, 0, 0,  14, 0, 255, "140200", "P-OFC", "Prep et organis fabrication et contrôle"),
(1403, 0, 0, 0,  14, 0, 255, "140300", "METAL", "Métallurgie"),
(1404, 0, 0, 0,  14, 0, 255, "140400", "TRACG", "Traçage"),
(1405, 0, 0, 0,  14, 0, 255, "140500", "ESOUT", "Étude des systèmes d’outillage"),
(1406, 0, 0, 0,  14, 0, 255, "140600", "EPROC", "Étude des processus"),
(1407, 0, 0, 0,  14, 0, 255, "140700", "LABSM", "Laboratoire (structures métalliques)"),
(1408, 0, 0, 0,  14, 0, 255, "140800", "REASM", "Réalisation"),
(1409, 0, 0, 0,  14, 0, 255, "140900", "ESYST", "Étude des systèmes str métalliques"),
(1410, 0, 0, 0,  14, 0, 255, "141000", "TGQPR", "Technologie gestion qualité prévention"),
(1411, 0, 0, 0,  14, 0, 255, "141100", "EMMPG", "Etud moulage méthode prep gest product"),
(1412, 0, 0, 0,  14, 0, 255, "141200", "MEORL", "MEO réalisation (fabrication essais contrôles)"),
(1413, 0, 0, 0,  14, 0, 255, "141300", "TTTUY", "Technologie - traçage - tuyauterie"),
(1414, 0, 0, 0,  14, 0, 255, "141400", "GPDVQ", "Gestion de production - devis - qualité"),
(1415, 0, 0, 0,  14, 0, 255, "141500", "PCHAN", "Préparation du travail - chantier"),
(1416, 0, 0, 0,  14, 0, 255, "141600", "TKMEO", "Techniques de mise en œuvre"),
(1417, 0, 0, 0,  14, 0, 255, "141700", "RPROJ", "Thème (réalisation projet)"),
(1418, 0, 0, 0,  14, 0, 255, "141800", "MOUGR", "Moulage gravitaire"),
(1419, 0, 0, 0,  14, 0, 255, "141900", "MOUSP", "Moulage sous pression"),
(1420, 0, 0, 0,  14, 0, 255, "142000", "EPRDT", "Étude de produits"),
(1421, 0, 0, 0,  14, 0, 255, "142100", "PPROD", "Préparation de la production"),
(1422, 0, 0, 0,  14, 0, 255, "142200", "EMOAF", "Et.&m.en œuvre alliag de fond.&mat.conx"),
(1499, 0, 0, 0,  14, 0, 255, "149900", "GNSMD", "Génie ind structures métal divers"),

-- 15 Génie industriel plastiques composites

(1501, 0, 0, 0,  15, 0, 255, "150100", "EVEXI", "Environnement externe et interne"),
(1502, 0, 0, 0,  15, 0, 255, "150200", "T-CO" , "Techniques connexes (stoc manu trans meca)"),
(1503, 0, 0, 0,  15, 0, 255, "150300", "CA-PC", "Conception et analyse (plastiques composites)"),
(1504, 0, 0, 0,  15, 0, 255, "150400", "CH-MP", "Chimie matières plastiques"),
(1505, 0, 0, 0,  15, 0, 255, "150500", "MOPMM", "Mise oeuv.plast. - maint.matériels essais"),
(1506, 0, 0, 0,  15, 0, 255, "150600", "ETFGR", "Étude fonctionnelle et graphique"),
(1507, 0, 0, 0,  15, 0, 255, "150700", "TPAPC", "TP atelier (plastiques composites)"),
(1508, 0, 0, 0,  15, 0, 255, "150800", "ETRIP", "Étude et réalisation industr de produits"),
(1509, 0, 0, 0,  15, 0, 255, "150900", "ROMOP", "Réalisation outillage pr mise œuvre plastique"),
(1510, 0, 0, 0,  15, 0, 255, "151000", "ETCMP", "Étude et contrôle matériaux et produc"),
(1511, 0, 0, 0,  15, 0, 255, "151100", "CT-OU", "Conception des outillages"),
(1512, 0, 0, 0,  15, 0, 255, "151200", "O-FAB", "Organisation des fabrications"),
(1513, 0, 0, 0,  15, 0, 255, "151300", "ETMLA", "Étude des matériaux et laboratoire"),
(1514, 0, 0, 0,  15, 0, 255, "151400", "ETMDT", "Étude matériaux et div tech trans plas"),
(1515, 0, 0, 0,  15, 0, 255, "151500", "TPMDE", "TP de maintenance-dépannage équipements"),
(1516, 0, 0, 0,  15, 0, 255, "151600", "MPOSP", "Materiaux - procedés orga - suivi product"),
(1517, 0, 0, 0,  15, 0, 255, "151700", "LAOTP", "Labo - analyse - mise œuvre techno produits"),
(1518, 0, 0, 0,  15, 0, 255, "151800", "CT-PL", "Conception (plastiques composites)"),
(1519, 0, 0, 0,  15, 0, 255, "151900", "PH-AM", "Physique appliquée aux matériaux"),
(1520, 0, 0, 0,  15, 0, 255, "152000", "PRD-C", "Productions et contrôles"),
(1521, 0, 0, 0,  15, 0, 255, "152100", "CTCPO", "Construction conception pièces outillage"),
(1522, 0, 0, 0,  15, 0, 255, "152200", "P-OTR", "Préparation organisation travail"),
(1523, 0, 0, 0,  15, 0, 255, "152300", "O-BMT", "Organisation production: bureau méthodes"),
(1524, 0, 0, 0,  15, 0, 255, "152400", "TEPRO", "Technologie étude de procédés"),
(1525, 0, 0, 0,  15, 0, 255, "152500", "LANGT", "Langage technique plasturgie"),
(1526, 0, 0, 0,  15, 0, 255, "152600", "PSCQG", "Production suivi contrôle qualité gestion"),
(1527, 0, 0, 0,  15, 0, 255, "152700", "MCOMP", "Matériaux composites"),
(1528, 0, 0, 0,  15, 0, 255, "152800", "TCMPC", "Technologie contrôle matériaux (plastiques composites)"),
(1529, 0, 0, 0,  15, 0, 255, "152900", "MEOPC", "Mise en œuvre (plastiques composites)"),
(1530, 0, 0, 0,  15, 0, 255, "153000", "QSEPC", "Organisation et qse (plastiques composites)"),
(1531, 0, 0, 0,  15, 0, 255, "153100", "IP-PC", "Industrialisation projet (plastiques composites)"),
(1532, 0, 0, 0,  15, 0, 255, "153200", "MPOPC", "Mainten processus outillage (plastiques composites)"),
(1599, 0, 0, 0,  15, 0, 255, "159900", "GNIPD", "Génie indus plastiques divers"),

-- 16 Génie chimique

(1601, 0, 0, 0,  16, 0, 255, "160100", "TECGC", "Technologie et génie chimique"),
(1602, 0, 0, 0,  16, 0, 255, "160200", "CH-ME", "Chimie - métallurgie"),
(1603, 0, 0, 0,  16, 0, 255, "160300", "TECGQ", "Technologie-gestion de la qualité-prod"),
(1604, 0, 0, 0,  16, 0, 255, "160400", "MT-DA", "Méthodes de développement d’une application"),
(1605, 0, 0, 0,  16, 0, 255, "160500", "MAPLI", "Montage d’appareils (laboratoire indus )"),
(1606, 0, 0, 0,  16, 0, 255, "160600", "T-FBR", "Techniques de fabrication"),
(1607, 0, 0, 0,  16, 0, 255, "160700", "GENCH", "Génie chimique"),
(1699, 0, 0, 0,  16, 0, 255, "169900", "GNCHD", "Génie chimique divers"),

-- 17 Génie civil

(1701, 0, 0, 0,  17, 0, 255, "170100", "D-GCV", "Dessin (génie civil)"),
(1702, 0, 0, 0,  17, 0, 255, "170200", "TOPOG", "Topographie"),
(1703, 0, 0, 0,  17, 0, 255, "170300", "GR3DV", "Gr3 (devis-et couts-prix-compta trav-pr)"),
(1704, 0, 0, 0,  17, 0, 255, "170400", "CO-BA", "Connaissances de base"),
(1705, 0, 0, 0,  17, 0, 255, "170500", "PRJBA", "Projet de bâtiment"),
(1706, 0, 0, 0,  17, 0, 255, "170600", "R-TEM", "Réalisation:topographie - essais - mesures-c"),
(1707, 0, 0, 0,  17, 0, 255, "170700", "PDATP", "Projet : dessin d’architecture et travaux pratiques"),
(1708, 0, 0, 0,  17, 0, 255, "170800", "PXDOI", "Principaux domaines d’intervention"),
(1709, 0, 0, 0,  17, 0, 255, "170900", "VPTTP", "Visite et présentation techniques (TP)"),
(1710, 0, 0, 0,  17, 0, 255, "171000", "CRQCO", "Croquis cote"),
(1711, 0, 0, 0,  17, 0, 255, "171100", "R-TVX", "Réalisation études et travaux"),
(1712, 0, 0, 0,  17, 0, 255, "171200", "ESSMC", "Essais - mesures - contrôle"),
(1713, 0, 0, 0,  17, 0, 255, "171300", "T-AF" , "Technique améliorations foncières"),
(1714, 0, 0, 0,  17, 0, 255, "171400", "MAKET", "Maquette"),
(1715, 0, 0, 0,  17, 0, 255, "171500", "PHGRA", "Photogrammétrie"),
(1716, 0, 0, 0,  17, 0, 255, "171600", "ARCCO", "Architectures et composants"),
(1717, 0, 0, 0,  17, 0, 255, "171700", "R-OUV", "Réalisation des ouvrages"),
(1718, 0, 0, 0,  17, 0, 255, "171800", "R-GCV", "Réalisation et contrôle (génie civil)"),
(1719, 0, 0, 0,  17, 0, 255, "171900", "P-CCH", "Préparation et conduite de chantier"),
(1720, 0, 0, 0,  17, 0, 255, "172000", "TOPOL", "Topologie"),
(1721, 0, 0, 0,  17, 0, 255, "172100", "METRE", "Métré et étude de coûts"),
(1722, 0, 0, 0,  17, 0, 255, "172200", "O-CMO", "Orga et gestion chantier-mise en œuvre"),
(1723, 0, 0, 0,  17, 0, 255, "172300", "P-CHT", "Préparation de chantier"),
(1724, 0, 0, 0,  17, 0, 255, "172400", "EOMST", "Et.ouvr.:meca stru.-techno constructions"),
(1725, 0, 0, 0,  17, 0, 255, "172500", "GR5PM", "Gr5 (techno proc meth-droit-regle const)"),
(1726, 0, 0, 0,  17, 0, 255, "172600", "CADAS", "Cadastre"),
(1727, 0, 0, 0,  17, 0, 255, "172700", "CALTO", "Calculs topométriques"),
(1728, 0, 0, 0,  17, 0, 255, "172800", "GODSI", "Géodésie"),
(1729, 0, 0, 0,  17, 0, 255, "172900", "D-HAC", "Dessin arts appliqués - histoire architect construct"),
(1730, 0, 0, 0,  17, 0, 255, "173000", "TOPTA", "Topographie (thème et application)"),
(1731, 0, 0, 0,  17, 0, 255, "173100", "GR4GD", "Gr4 (dcs-geometrie descri.-tcs-mrm)"),
(1732, 0, 0, 0,  17, 0, 255, "173200", "ETCGC", "Étude des constructions (génie civil)"),
(1733, 0, 0, 0,  17, 0, 255, "173300", "ECPRP", "Et.ct prix-real.piec.ecrit-org.p.d.const"),
(1734, 0, 0, 0,  17, 0, 255, "173400", "TECNU", "Technologie des TP notions d’urbanisme"),
(1735, 0, 0, 0,  17, 0, 255, "173500", "ARCHI", "Architecture"),
(1736, 0, 0, 0,  17, 0, 255, "173600", "MENCH", "Menuiserie charpente"),
(1737, 0, 0, 0,  17, 0, 255, "173700", "ELBAT", "Électricité du bâtiment"),
(1738, 0, 0, 0,  17, 0, 255, "173800", "TPELC", "TP d’électricité"),
(1739, 0, 0, 0,  17, 0, 255, "173900", "PLBSA", "Plomberie sanitaire"),
(1740, 0, 0, 0,  17, 0, 255, "174000", "BATIM", "Bâtiment"),
(1741, 0, 0, 0,  17, 0, 255, "174100", "MACON", "Maçonnerie"),
(1742, 0, 0, 0,  17, 0, 255, "174200", "T-BAT", "Technique du bâtiment"),
(1743, 0, 0, 0,  17, 0, 255, "174300", "ARCON", "Architecture de la construction"),
(1744, 0, 0, 0,  17, 0, 255, "174400", "FABMI", "Fabrication mise en œuvre"),
(1745, 0, 0, 0,  17, 0, 255, "174500", "CONST", "Construction"),
(1746, 0, 0, 0,  17, 0, 255, "174600", "E-OUV", "Études des ouvrages"),
(1747, 0, 0, 0,  17, 0, 255, "174700", "COTOP", "Connaissances topographiques"),
(1748, 0, 0, 0,  17, 0, 255, "174800", "DIGEO", "Domaines d’intervention du géomètre"),
(1749, 0, 0, 0,  17, 0, 255, "174900", "COOTX", "Coordination de travaux"),
(1750, 0, 0, 0,  17, 0, 255, "175000", "GCMTP", "Génie civil et matériels travaux publics"),
(1751, 0, 0, 0,  17, 0, 255, "175100", "PO-GC", "Projet d’ouvrage (génie civil)"),
(1752, 0, 0, 0,  17, 0, 255, "175200", "ARCHC", "Architecture et construction"),
(1753, 0, 0, 0,  17, 0, 255, "175300", "AHUDD", "Architecture, habitat & urbanisme, développement durable"),
(1754, 0, 0, 0,  17, 0, 255, "175400", "GENCI", "Génie civil"),
(1755, 0, 0, 0,  17, 0, 255, "175500", "HABIT", "Habitat"),
(1799, 0, 0, 0,  17, 0, 255, "179900", "GNCID", "Génie civil divers"),

-- 18 Génie thermique

(1801, 0, 0, 0,  18, 0, 255, "180100", "MOSYS", "Mise en œuvre des systèmes"),
(1802, 0, 0, 0,  18, 0, 255, "180200", "TMFAV", "Thermo meca fluide appliquée véhicule"),
(1803, 0, 0, 0,  18, 0, 255, "180300", "TMDPP", "Thermodynamique thermopropulsion"),
(1804, 0, 0, 0,  18, 0, 255, "180400", "AMFVU", "Aérodynamique mécanique des fluides-vol.-tec.util"),
(1805, 0, 0, 0,  18, 0, 255, "180500", "ETCSY", "Étude et conception des systèmes"),
(1806, 0, 0, 0,  18, 0, 255, "180600", "ETSYS", "Étude des systèmes"),
(1807, 0, 0, 0,  18, 0, 255, "180700", "ETITL", "Étude des installations"),
(1808, 0, 0, 0,  18, 0, 255, "180800", "R-INS", "Réalisation et contrôle installations"),
(1809, 0, 0, 0,  18, 0, 255, "180900", "TMDMF", "Thermodynamique mécanique des fluides"),
(1810, 0, 0, 0,  18, 0, 255, "181000", "OSTCH", "Ost-chaudronnerie"),
(1811, 0, 0, 0,  18, 0, 255, "181100", "PREPA", "Préparation"),
(1812, 0, 0, 0,  18, 0, 255, "181200", "FLDEG", "Fluidique et énergétique"),
(1813, 0, 0, 0,  18, 0, 255, "181300", "FLDEA", "Fluidique et énergétique appliquées"),
(1814, 0, 0, 0,  18, 0, 255, "181400", "TMDTM", "Thermodynamique et thermique"),
(1815, 0, 0, 0,  18, 0, 255, "181500", "ENFLE", "Énergétique fluidique environnement"),
(1816, 0, 0, 0,  18, 0, 255, "181600", "RMOPT", "Réalisation mise en œuvre procédures (génie thermique)"),
(1817, 0, 0, 0,  18, 0, 255, "181700", "ENENV", "Énergies et environnement"),
(1899, 0, 0, 0,  18, 0, 255, "189900", "GNTHD", "Génie thermique divers"),

-- 19 Génie mécanique de la construction

(1901, 0, 0, 0,  19, 0, 255, "190100", "D-CAT", "Dessin de construction atelier"),
(1902, 0, 0, 0,  19, 0, 255, "190200", "PD-CT", "Productique construction"),
(1903, 0, 0, 0,  19, 0, 255, "190300", "D-CTR", "Dessin de construction"),
(1904, 0, 0, 0,  19, 0, 255, "190400", "ME-TS", "Mécanique et technologie des structures"),
(1905, 0, 0, 0,  19, 0, 255, "190500", "D-IMC", "Dessin industriel mécanique"),
(1906, 0, 0, 0,  19, 0, 255, "190600", "CTAUT", "Construction et automatisme"),
(1907, 0, 0, 0,  19, 0, 255, "190700", "CTMAT", "Construction mécanique appliquée techno"),
(1908, 0, 0, 0,  19, 0, 255, "190800", "P-MCM", "Prepar orga méthode const moules modèles"),
(1909, 0, 0, 0,  19, 0, 255, "190900", "TECPA", "Technologie securité prévention accidents travail"),
(1910, 0, 0, 0,  19, 0, 255, "191000", "TPEFB", "Travaux pratiques étude fabrication"),
(1911, 0, 0, 0,  19, 0, 255, "191100", "TECMX", "Technologie des matériaux"),
(1912, 0, 0, 0,  19, 0, 255, "191200", "CT"   , "Construction (famille 19)"),
(1913, 0, 0, 0,  19, 0, 255, "191300", "ETCST", "Étude des constructions"),
(1914, 0, 0, 0,  19, 0, 255, "191400", "CTMEC", "Construction mécanique"),
(1915, 0, 0, 0,  19, 0, 255, "191500", "ME-CT", "Mécanique et construction"),
(1916, 0, 0, 0,  19, 0, 255, "191600", "T-TCM", "Techniques graph techno constr des machines"),
(1917, 0, 0, 0,  19, 0, 255, "191700", "D-TGD", "Dessin technique - géométrie descriptive"),
(1918, 0, 0, 0,  19, 0, 255, "191800", "TDATG", "Trav.dirigés analy.technique et expr.gra"),
(1919, 0, 0, 0,  19, 0, 255, "191900", "OBPRD", "Obtention des produits"),
(1920, 0, 0, 0,  19, 0, 255, "192000", "INPRD", "Industrialisation des produits"),
(1922, 0, 0, 0,  19, 0, 255, "192200", "EXMMA", "Étude expe maintenance mater agricoles"),
(1923, 0, 0, 0,  19, 0, 255, "192300", "COMST", "Comportement des systèmes techniques"),
(1924, 0, 0, 0,  19, 0, 255, "192400", "ETAER", "Étude de l’aeronef et de ses systèmes"),
(1925, 0, 0, 0,  19, 0, 255, "192500", "PRPRO", "Préparation de production"),
(1999, 0, 0, 0,  19, 0, 255, "199900", "GNMCD", "Génie meca construction divers"),

-- 20 Génie mécanique de la productique

(2001, 0, 0, 0,  20, 0, 255, "200100", "P-OMF", "Préparation-organisation : méthodes-fabrication-contrôle"),
(2002, 0, 0, 0,  20, 0, 255, "200200", "INSTR", "Instrumentation"),
(2003, 0, 0, 0,  20, 0, 255, "200300", "ME-ID", "Mécanique industrielle"),
(2004, 0, 0, 0,  20, 0, 255, "200400", "MECAN", "Mécanique"),
(2005, 0, 0, 0,  20, 0, 255, "200500", "PD-PO", "Productique : préparation organisation"),
(2006, 0, 0, 0,  20, 0, 255, "200600", "ME-MX", "Mécanique et résistance des matériaux"),
(2007, 0, 0, 0,  20, 0, 255, "200700", "ETMAI", "Étude des mécanismes et autom indust"),
(2008, 0, 0, 0,  20, 0, 255, "200800", "ETCMA", "Étude système (construction-mécanismes-automatismes)"),
(2009, 0, 0, 0,  20, 0, 255, "200900", "TSA"  , "Technologie des systèmes automatisés"),
(2013, 0, 0, 0,  20, 0, 255, "201300", "D-TTC", "Dessin technique technologie de construction"),
(2014, 0, 0, 0,  20, 0, 255, "201400", "PJTCT", "Projet et technologie de construction"),
(2015, 0, 0, 0,  20, 0, 255, "201500", "MESUR", "Mesures"),
(2016, 0, 0, 0,  20, 0, 255, "201600", "D-ITC", "Dessin industriel et tech construction"),
(2017, 0, 0, 0,  20, 0, 255, "201700", "AUTMT", "Automatismes"),
(2018, 0, 0, 0,  20, 0, 255, "201800", "MOPIN", "Mise en œuvre des processus industriels"),
(2019, 0, 0, 0,  20, 0, 255, "201900", "P-ORG", "Préparation - organisation"),
(2020, 0, 0, 0,  20, 0, 255, "202000", "DFPRC", "Définition des processus"),
(2021, 0, 0, 0,  20, 0, 255, "202100", "CTDNI", "Construction et dessin industriel"),
(2022, 0, 0, 0,  20, 0, 255, "202200", "ATAUM", "Atelier automatismes mesures"),
(2023, 0, 0, 0,  20, 0, 255, "202300", "ASAIF", "Automatisation systèmes automatisés informatique"),
(2024, 0, 0, 0,  20, 0, 255, "202400", "USIMS", "Usinage m.s."),
(2025, 0, 0, 0,  20, 0, 255, "202500", "AVPRJ", "Avant-projet"),
(2026, 0, 0, 0,  20, 0, 255, "202600", "PROJT", "Projet"),
(2027, 0, 0, 0,  20, 0, 255, "202700", "ETPMM", "Étude : procédés - moyens - mise en œuvre"),
(2028, 0, 0, 0,  20, 0, 255, "202800", "R-PRQ", "Réalisation et contrôle (productique)"),
(2029, 0, 0, 0,  20, 0, 255, "202900", "ANSPR", "Analyse des syst de pro (productiq text)"),
(2031, 0, 0, 0,  20, 0, 255, "203100", "TPPRD", "Travaux pratiques production"),
(2032, 0, 0, 0,  20, 0, 255, "203200", "ETMMP", "Étude méthodes et moyens de production"),
(2033, 0, 0, 0,  20, 0, 255, "203300", "ATGMP", "Atelier (génie mécanique productique)"),
(2034, 0, 0, 0,  20, 0, 255, "203400", "D-IND", "Dessin industriel"),
(2035, 0, 0, 0,  20, 0, 255, "203500", "ETPOP", "Étude des parties opératives"),
(2036, 0, 0, 0,  20, 0, 255, "203600", "MORFE", "Mise œuvre-realis.(fabrication-essais-contrôle)"),
(2038, 0, 0, 0,  20, 0, 255, "203800", "P-OMH", "Préparation et organisation : méthodes"),
(2039, 0, 0, 0,  20, 0, 255, "203900", "TPAEL", "TP d’automatisme et d’électrotechnique"),
(2040, 0, 0, 0,  20, 0, 255, "204000", "R-SYS", "Réalisation et contrôle de systèmes"),
(2041, 0, 0, 0,  20, 0, 255, "204100", "ETCCP", "Étude de conception et construction de produit"),
(2042, 0, 0, 0,  20, 0, 255, "204200", "MITKA", "Mesures industrielles et tech d’appareil"),
(2043, 0, 0, 0,  20, 0, 255, "204300", "PRODQ", "Productique"),
(2044, 0, 0, 0,  20, 0, 255, "204400", "MICTK", "Microtechniques"),
(2045, 0, 0, 0,  20, 0, 255, "204500", "FA-GM", "Fabrication (génie mécanique productique)"),
(2046, 0, 0, 0,  20, 0, 255, "204600", "AJUST", "Ajustage"),
(2047, 0, 0, 0,  20, 0, 255, "204700", "ANFAB", "Analyse fabrication"),
(2048, 0, 0, 0,  20, 0, 255, "204800", "AUCMA", "Automatismes et commande de machines"),
(2049, 0, 0, 0,  20, 0, 255, "204900", "RGDYI", "Régulation et dynamique des installations"),
(2050, 0, 0, 0,  20, 0, 255, "205000", "MICGR", "Micrographie"),
(2051, 0, 0, 0,  20, 0, 255, "205100", "ETPAC", "Étude des parties commandes"),
(2052, 0, 0, 0,  20, 0, 255, "205200", "P-OSP", "Prep org suivi productions technologie fabrication"),
(2053, 0, 0, 0,  20, 0, 255, "205300", "CTMOU", "Construction - technologie des matériaux outillages"),
(2054, 0, 0, 0,  20, 0, 255, "205400", "CNTQU", "Contrôle qualité"),
(2055, 0, 0, 0,  20, 0, 255, "205500", "TECCT", "Technologie de construction"),
(2056, 0, 0, 0,  20, 0, 255, "205600", "STSYP", "Structure des systèmes de production"),
(2057, 0, 0, 0,  20, 0, 255, "205700", "ME-AP", "Mécanique appliquée"),
(2058, 0, 0, 0,  20, 0, 255, "205800", "PD-MO", "Productique systèmes motorises"),
(2059, 0, 0, 0,  20, 0, 255, "205900", "PD-SM", "Productique structures métalliques"),
(2060, 0, 0, 0,  20, 0, 255, "206000", "PD-BM", "Productique bois et matériaux associés"),
(2061, 0, 0, 0,  20, 0, 255, "206100", "PD-MC", "Productique mécanique"),
(2062, 0, 0, 0,  20, 0, 255, "206200", "PD-MS", "Productique matériaux souples"),
(2063, 0, 0, 0,  20, 0, 255, "206300", "AUCRG", "Automatique - contrôle et régulation"),
(2064, 0, 0, 0,  20, 0, 255, "206400", "SYSAU", "Systèmes automatises"),
(2065, 0, 0, 0,  20, 0, 255, "206500", "ETMIC", "Études (microtechniques)"),
(2066, 0, 0, 0,  20, 0, 255, "206600", "PRMIC", "Préparation (microtechniques)"),
(2067, 0, 0, 0,  20, 0, 255, "206700", "EPROU", "Étude des produits et des outillages"),
(2068, 0, 0, 0,  20, 0, 255, "206800", "INDMC", "Industrialisation"),
(2069, 0, 0, 0,  20, 0, 255, "206900", "PROMC", "Production"),
(2070, 0, 0, 0,  20, 0, 255, "207000", "PD-MT", "Productique microtechniques"),
(2071, 0, 0, 0,  20, 0, 255, "207100", "C-OUT", "Conception des outillages (product mécanique)"),
(2072, 0, 0, 0,  20, 0, 255, "207200", "RE-CO", "Réalisation et contrôle"),
(2073, 0, 0, 0,  20, 0, 255, "207300", "G-MEC", "Génie mécanique"),
(2074, 0, 0, 0,  20, 0, 255, "207400", "COPAC", "Conception des parties de commande"),
(2075, 0, 0, 0,  20, 0, 255, "207500", "COPOP", "Conception des parties opératives"),
(2076, 0, 0, 0,  20, 0, 255, "207600", "AELTT", "Automatisme et électrotechnique"),
(2077, 0, 0, 0,  20, 0, 255, "207700", "ISYPR", "Informatique et systèmes de production"),
(2078, 0, 0, 0,  20, 0, 255, "207800", "CSAUT", "Conception des systèmes automatiques"),
(2079, 0, 0, 0,  20, 0, 255, "207900", "CRCLI", "Conduite  et réalisation  projet client"),
(2080, 0, 0, 0,  20, 0, 255, "208000", "EPCAR", "Étude des produits carrossés"),
(2081, 0, 0, 0,  20, 0, 255, "208100", "CPCAR", "Conception des produits carrossés"),
(2082, 0, 0, 0,  20, 0, 255, "208200", "RPCAR", "Réalisation des produits carrossés"),
(2099, 0, 0, 0,  20, 0, 255, "209900", "GNMPD", "Génie mécanique productique divers"),

-- 21 Génie mécanique de la maintenance

(2101, 0, 0, 0,  21, 0, 255, "210100", "TECCS", "Technologie cellules et systèmes"),
(2102, 0, 0, 0,  21, 0, 255, "210200", "MNMEC", "Maintenance mécanique"),
(2103, 0, 0, 0,  21, 0, 255, "210300", "ME-AT", "Mécanique appliquée moteur transmission"),
(2104, 0, 0, 0,  21, 0, 255, "210400", "MAINT", "Maintenance"),
(2105, 0, 0, 0,  21, 0, 255, "210500", "ME-AV", "Mécanique appliquée au véhicule"),
(2106, 0, 0, 0,  21, 0, 255, "210600", "ANTDI", "Analyse technique dessin industriel"),
(2107, 0, 0, 0,  21, 0, 255, "210700", "TPITV", "TP intervention"),
(2108, 0, 0, 0,  21, 0, 255, "210800", "TPAMN", "TP atelier (maintenance)"),
(2109, 0, 0, 0,  21, 0, 255, "210900", "TPCEM", "TP : carburants - électricité - moteurs - organe"),
(2110, 0, 0, 0,  21, 0, 255, "211000", "TPATD", "TP anal tech diag rep regl gest maint"),
(2111, 0, 0, 0,  21, 0, 255, "211100", "ETSYT", "Étude des systèmes techniques"),
(2112, 0, 0, 0,  21, 0, 255, "211200", "RESMX", "Résistance des matériaux"),
(2113, 0, 0, 0,  21, 0, 255, "211300", "G-MTP", "Gestion de maintenance - technologie-TP"),
(2114, 0, 0, 0,  21, 0, 255, "211400", "ANFST", "Analyse fonctionnelle et structurelle"),
(2115, 0, 0, 0,  21, 0, 255, "211500", "ANFSE", "Analyse fonct. struct. esth indus"),
(2116, 0, 0, 0,  21, 0, 255, "211600", "ANFME", "Analyse fonctionnelle et mécanique"),
(2117, 0, 0, 0,  21, 0, 255, "211700", "MT-MA", "Méthodes de maintenance"),
(2118, 0, 0, 0,  21, 0, 255, "211800", "TPMHS", "TP maintenance hygiène sécurité"),
(2119, 0, 0, 0,  21, 0, 255, "211900", "ESSMO", "Essais moteur"),
(2120, 0, 0, 0,  21, 0, 255, "212000", "ME-VB", "Mécanique et vibrations"),
(2121, 0, 0, 0,  21, 0, 255, "212100", "MEPSM", "Modélisation étude prédictive systèmes mécaniques"),
(2122, 0, 0, 0,  21, 0, 255, "212200", "EMMTP", "Etud expe maintenanc matériels trvx pub"),
(2123, 0, 0, 0,  21, 0, 255, "212300", "STRMT", "Stratégie de maintenance"),
(2124, 0, 0, 0,  21, 0, 255, "212400", "TPMTN", "Travaux pratiques de maintenance"),
(2125, 0, 0, 0,  21, 0, 255, "212500", "ACPRA", "Activités pratiques"),
(2126, 0, 0, 0,  21, 0, 255, "212600", "ANFSM", "Analyse fonction. - structur. & mécanique"),
(2127, 0, 0, 0,  21, 0, 255, "212700", "ORMAV", "Organisation  maintenance & après-vente"),
(2128, 0, 0, 0,  21, 0, 255, "212800", "TNCIV", "Technologie & intervention sur véhicules"),
(2129, 0, 0, 0,  21, 0, 255, "212900", "AMAER", "Assemblage et maintenance des aéronefs"),
(2130, 0, 0, 0,  21, 0, 255, "213000", "MCMAT", "Modélisation comportement des matériels"),
(2131, 0, 0, 0,  21, 0, 255, "213100", "TIMAT", "Technologie & intervention sur matériels"),
(2132, 0, 0, 0,  21, 0, 255, "213200", "EPSYS", "Étude pluritechnologique des systèmes"),
(2133, 0, 0, 0,  21, 0, 255, "213300", "ORMAT", "Organisation de la maintenance"),
(2134, 0, 0, 0,  21, 0, 255, "213400", "TMCPR", "Technique de maintenance conduite prévention"),
(2199, 0, 0, 0,  21, 0, 255, "219900", "GNMMD", "Génie mécanique maintenance divers"),

-- 22 Génie électrique électronique

(2201, 0, 0, 0,  22, 0, 255, "220100", "ELTRO", "Électronique"),
(2202, 0, 0, 0,  22, 0, 255, "220200", "ETHMA", "Étude théorique et schéma"),
(2203, 0, 0, 0,  22, 0, 255, "220300", "ELSIB", "Eln et logique - servomécanismes instruments de bord"),
(2204, 0, 0, 0,  22, 0, 255, "220400", "P-OTS", "Préparation organisation : technologie systèmes électriques"),
(2205, 0, 0, 0,  22, 0, 255, "220500", "MESES", "Mesures et essais"),
(2206, 0, 0, 0,  22, 0, 255, "220600", "AUTMQ", "Automatique"),
(2207, 0, 0, 0,  22, 0, 255, "220700", "ESSYS", "Essai de systèmes"),
(2208, 0, 0, 0,  22, 0, 255, "220800", "ELTAP", "Électrotechnique électronique appliquée"),
(2209, 0, 0, 0,  22, 0, 255, "220900", "R-SEL", "Réalisation cont syst électroniques"),
(2210, 0, 0, 0,  22, 0, 255, "221000", "ELETR", "Électricité et électronique"),
(2211, 0, 0, 0,  22, 0, 255, "221100", "APPEM", "Applications pratiques - essais et mesures"),
(2212, 0, 0, 0,  22, 0, 255, "221200", "TECSC", "Technologie syst commande regul auto :schéma"),
(2213, 0, 0, 0,  22, 0, 255, "221300", "REGUL", "Régulation"),
(2214, 0, 0, 0,  22, 0, 255, "221400", "ELOII", "Électronique - informatique industrielle"),
(2215, 0, 0, 0,  22, 0, 255, "221500", "ANMOS", "Analyse et mise en œuvre des systèmes"),
(2216, 0, 0, 0,  22, 0, 255, "221600", "THSIG", "Théorie du signal"),
(2217, 0, 0, 0,  22, 0, 255, "221700", "ELPUI", "Électronique de puissance"),
(2218, 0, 0, 0,  22, 0, 255, "221800", "ELCOM", "Électronique et communications"),
(2220, 0, 0, 0,  22, 0, 255, "222000", "ELOAI", "Électronique automatique informatique indus"),
(2221, 0, 0, 0,  22, 0, 255, "222100", "G-ELC", "Génie électrique"),
(2222, 0, 0, 0,  22, 0, 255, "222200", "GEIAP", "Génie électrique - informatique appliquée"),
(2223, 0, 0, 0,  22, 0, 255, "222300", "ELIOP", "Electron informatiq ind optoelectroniq"),
(2224, 0, 0, 0,  22, 0, 255, "222400", "AIIAL", "Automatique informatique indus électronique"),
(2225, 0, 0, 0,  22, 0, 255, "222500", "TSENS", "Technologie sensitométrie"),
(2226, 0, 0, 0,  22, 0, 255, "222600", "TQUIP", "Technologie équipements"),
(2227, 0, 0, 0,  22, 0, 255, "222700", "PDVUE", "Prise de vue"),
(2228, 0, 0, 0,  22, 0, 255, "222800", "TIMAG", "Traitement de l’image"),
(2229, 0, 0, 0,  22, 0, 255, "222900", "MASEN", "Maintenance des systèmes électroniques navals"),
(2230, 0, 0, 0,  22, 0, 255, "223000", "MSCCR", "Maintenance des systèmes de contrôle-commande et de régulation"),
(2231, 0, 0, 0,  22, 0, 255, "223100", "DTLPL", "Dessins techniques et lecture des plans"),
(2299, 0, 0, 0,  22, 0, 255, "229900", "CTAUD", "Construction et automatisme divers"),

-- 23 Génie électrique électrotechnique

(2301, 0, 0, 0,  23, 0, 255, "230100", "ELMEC", "Électricité et mécanique"),
(2302, 0, 0, 0,  23, 0, 255, "230200", "TPIEL", "TP initiation à l’électricité"),
(2303, 0, 0, 0,  23, 0, 255, "230300", "PH-AE", "Physique appliquée à l’électrotechnique"),
(2304, 0, 0, 0,  23, 0, 255, "230400", "ELTEO", "Électrotechnique - électronique"),
(2305, 0, 0, 0,  23, 0, 255, "230500", "FA-TP", "Fabrication réalisation TP"),
(2306, 0, 0, 0,  23, 0, 255, "230600", "ELCHI", "Électrochimie"),
(2307, 0, 0, 0,  23, 0, 255, "230700", "ELTTK", "Électrotechnique"),
(2308, 0, 0, 0,  23, 0, 255, "230800", "ADIMA", "Analyse, diagnostic, maintenance"),
(2309, 0, 0, 0,  23, 0, 255, "230900", "TECTS", "Technologie des traitements de surfaces ost"),
(2310, 0, 0, 0,  23, 0, 255, "231000", "R-TPA", "Réalisation (TP appareillage et S.A)"),
(2311, 0, 0, 0,  23, 0, 255, "231100", "P-TOG", "Préparation (tech ost-gest prod)"),
(2312, 0, 0, 0,  23, 0, 255, "231200", "ELECT", "Électricité"),
(2313, 0, 0, 0,  23, 0, 255, "231300", "CTELO", "Construction (électrotechnique)"),
(2314, 0, 0, 0,  23, 0, 255, "231400", "TECSF", "Technologie schéma et fabrication"),
(2315, 0, 0, 0,  23, 0, 255, "231500", "R-TSU", "Réalisation de traitements de surfaces"),
(2316, 0, 0, 0,  23, 0, 255, "231600", "ESSME", "Essais mesures"),
(2317, 0, 0, 0,  23, 0, 255, "231700", "N-IND", "Enseignement industriel"),
(2318, 0, 0, 0,  23, 0, 255, "231800", "ECLAI", "Éclairage"),
(2319, 0, 0, 0,  23, 0, 255, "231900", "SONOR", "Sonorisation"),
(2320, 0, 0, 0,  23, 0, 255, "232000", "CSMAE", "Const.struct.mater.appliq. électronique"),
(2321, 0, 0, 0,  23, 0, 255, "232100", "SCEEL", "Sciences appliquées électriq électroniq"),
(2322, 0, 0, 0,  23, 0, 255, "232200", "CSMEL", "Const.str.mat.appliq. électrotechnique"),
(2323, 0, 0, 0,  23, 0, 255, "232300", "MASTN", "Maintenance des systèmes électrotechniques navals"),
(2399, 0, 0, 0,  23, 0, 255, "239900", "GNEED", "Génie électrique électronique divers"),

-- 24 Génie électrique informat.- télématique

(2401, 0, 0, 0,  24, 0, 255, "240100", "ARCSI", "Architecture des systèmes informatiques"),
(2402, 0, 0, 0,  24, 0, 255, "240200", "MT-IF", "Méthodes informatiques"),
(2403, 0, 0, 0,  24, 0, 255, "240300", "TTNUM", "Traitements numériques"),
(2404, 0, 0, 0,  24, 0, 255, "240400", "IFIND", "Informatique industrielle"),
(2405, 0, 0, 0,  24, 0, 255, "240500", "IFTIQ", "Informatique"),
(2406, 0, 0, 0,  24, 0, 255, "240600", "TECIA", "Technologie maternels:informatique appl"),
(2407, 0, 0, 0,  24, 0, 255, "240700", "IFAPL", "Informatique appliquée"),
(2408, 0, 0, 0,  24, 0, 255, "240800", "ME-II", "Mécanique automatique et informatique indus"),
(2409, 0, 0, 0,  24, 0, 255, "240900", "AUIFI", "Automatique et informatique industrielle"),
(2410, 0, 0, 0,  24, 0, 255, "241000", "IFAUT", "Informatique et automatismes"),
(2411, 0, 0, 0,  24, 0, 255, "241100", "LOGIC", "Logiciels"),
(2412, 0, 0, 0,  24, 0, 255, "241200", "MOSIF", "Mise en œuvre systèmes informatiques"),
(2413, 0, 0, 0,  24, 0, 255, "241300", "AUIFA", "Automatique et informatique appliquées"),
(2414, 0, 0, 0,  24, 0, 255, "241400", "AULOG", "Automatismes et logique"),
(2415, 0, 0, 0,  24, 0, 255, "241500", "XAO"  , "XAO"),
(2416, 0, 0, 0,  24, 0, 255, "241600", "MANIN", "Mise à niveau en informatique"),
(2417, 0, 0, 0,  24, 0, 255, "241700", "ISYST", "Informatique système"),
(2418, 0, 0, 0,  24, 0, 255, "241800", "GESSI", "Gestion des systèmes d’information"),
(2419, 0, 0, 0,  24, 0, 255, "241900", "BIOIL", "Bio-informatique et informatique de laboratoire"),
(2420, 0, 0, 0,  24, 0, 255, "242000", "SINUM", "Systèmes d’information et numérique"),
(2421, 0, 0, 0,  24, 0, 255, "242100", "INFRE", "Informatique et réseaux"),
(2422, 0, 0, 0,  24, 0, 255, "242200", "MSINA", "Maintenance des systèmes informatiques navals"),
(2499, 0, 0, 0,  24, 0, 255, "249900", "GNEID", "Génie électrique inform electro divers"),

-- 25 Indust. graphiques (imprimerie - livre)

(2501, 0, 0, 0,  25, 0, 255, "250100", "IMPRE", "Impression"),
(2502, 0, 0, 0,  25, 0, 255, "250200", "FINIT", "Finition"),
(2503, 0, 0, 0,  25, 0, 255, "250300", "P-FIM", "Préparation de la forme imprimante"),
(2504, 0, 0, 0,  25, 0, 255, "250400", "EX-GR", "Expression graphique"),
(2505, 0, 0, 0,  25, 0, 255, "250500", "TXPCP", "Trav.prof.conduite production"),
(2506, 0, 0, 0,  25, 0, 255, "250600", "T-FAB", "Technique de fabrication"),
(2507, 0, 0, 0,  25, 0, 255, "250700", "TECPT", "Technologie professionnelle et travaux pratiques"),
(2508, 0, 0, 0,  25, 0, 255, "250800", "TECPG", "Technologie des syst de production graphique"),
(2509, 0, 0, 0,  25, 0, 255, "250900", "DFPGR", "Définition des proces production graphique"),
(2510, 0, 0, 0,  25, 0, 255, "251000", "PD-GR", "Productique graphique"),
(2511, 0, 0, 0,  25, 0, 255, "251100", "TECSI", "Technologie des syst d’information graphique"),
(2512, 0, 0, 0,  25, 0, 255, "251200", "O-OPG", "Org mise en œuvre processus graphiques"),
(2513, 0, 0, 0,  25, 0, 255, "251300", "CMNGR", "Communication graphique"),
(2514, 0, 0, 0,  25, 0, 255, "251400", "HIECR", "Histoire sémiologie métamorph écritures"),
(2515, 0, 0, 0,  25, 0, 255, "251500", "D-TYP", "Calligraphie dessin typographie mise en page"),
(2516, 0, 0, 0,  25, 0, 255, "251600", "TYPNU", "Typographie numérique et informatique"),
(2517, 0, 0, 0,  25, 0, 255, "251700", "ATGRA", "Atelier (arts graphiques)"),
(2518, 0, 0, 0,  25, 0, 255, "251800", "LABEG", "Laboratoire expérimentations graphiques"),
(2599, 0, 0, 0,  25, 0, 255, "259900", "IGRAD", "Industrie graphiques divers"),

-- 26 Conduite - navigation

(2601, 0, 0, 0,  26, 0, 255, "260100", "EXPTR", "Exploitation des transports"),
(2602, 0, 0, 0,  26, 0, 255, "260200", "MMSOU", "Motorisation meca soudure"),
(2603, 0, 0, 0,  26, 0, 255, "260300", "ENCOQ", "Entretien des coques"),
(2604, 0, 0, 0,  26, 0, 255, "260400", "CO-NA", "Connaissance du navire"),
(2605, 0, 0, 0,  26, 0, 255, "260500", "HYDSD", "Hydrostatique et hydrodynamique"),
(2606, 0, 0, 0,  26, 0, 255, "260600", "LOGTQ", "Logistique"),
(2607, 0, 0, 0,  26, 0, 255, "260700", "MANMC", "Manutention mécanisée"),
(2608, 0, 0, 0,  26, 0, 255, "260800", "FEOTL", "Faisab. eval. Opérations transport logis"),
(2609, 0, 0, 0,  26, 0, 255, "260900", "OGOTL", "Org.meo gest. Opérations transport logis"),
(2610, 0, 0, 0,  26, 0, 255, "261000", "SVOTL", "Suivi opérations transport logistique"),
(2611, 0, 0, 0,  26, 0, 255, "261100", "DENAV", "Description du navire"),
(2612, 0, 0, 0,  26, 0, 255, "261200", "CONAV", "Conduite du navire"),
(2613, 0, 0, 0,  26, 0, 255, "261300", "MAMAR", "Machines marines"),
(2614, 0, 0, 0,  26, 0, 255, "261400", "MATEL", "Matelotage"),
(2615, 0, 0, 0,  26, 0, 255, "261500", "MANOE", "Manoeuvre"),
(2616, 0, 0, 0,  26, 0, 255, "261600", "STABI", "Stabilité"),
(2617, 0, 0, 0,  26, 0, 255, "261700", "OCEAN", "Océanographie"),
(2618, 0, 0, 0,  26, 0, 255, "261800", "TECPE", "Techniques de pêche"),
(2619, 0, 0, 0,  26, 0, 255, "261900", "RAMEN", "Ramendage"),
(2620, 0, 0, 0,  26, 0, 255, "262000", "SECSU", "Sécurité-survie"),
(2621, 0, 0, 0,  26, 0, 255, "262100", "SYSCO", "Systèmes de commandes"),
(2622, 0, 0, 0,  26, 0, 255, "262200", "METEO", "Météorologie"),
(2623, 0, 0, 0,  26, 0, 255, "262300", "MOLYS", "Molysmologie"),
(2624, 0, 0, 0,  26, 0, 255, "262400", "NAVIG", "Navigation"),
(2625, 0, 0, 0,  26, 0, 255, "262500", "PROCP", "Processus de production"),
(2626, 0, 0, 0,  26, 0, 255, "262600", "MOYPR", "Moyens de production"),
(2627, 0, 0, 0,  26, 0, 255, "262700", "GRMAR", "Gestion des ressources marines"),
(2628, 0, 0, 0,  26, 0, 255, "262800", "CEMAR", "Cultures et elevages marins"),
(2629, 0, 0, 0,  26, 0, 255, "262900", "TRCAP", "Traitement des captures"),
(2630, 0, 0, 0,  26, 0, 255, "263000", "VACAP", "Valorisation des captures"),
(2631, 0, 0, 0,  26, 0, 255, "263100", "ECPEC", "Économie des pêches"),
(2632, 0, 0, 0,  26, 0, 255, "263200", "CMNAU", "Conduite moyens nautiques"),
(2633, 0, 0, 0,  26, 0, 255, "263300", "CMTER", "Conduite moyens terrestres"),
(2634, 0, 0, 0,  26, 0, 255, "263400", "COPEC", "Conduite de la pêche"),
(2635, 0, 0, 0,  26, 0, 255, "263500", "FECON", "Fonctionnement entreprise conchylicole"),
(2636, 0, 0, 0,  26, 0, 255, "263600", "ENNAV", "Entretien du navire"),
(2637, 0, 0, 0,  26, 0, 255, "263700", "CARGA", "Cargaison"),
(2638, 0, 0, 0,  26, 0, 255, "263800", "PRVEL", "Propulsion vélique"),
(2639, 0, 0, 0,  26, 0, 255, "263900", "RADAR", "Stage radar"),
(2640, 0, 0, 0,  26, 0, 255, "264000", "REBTQ", "Règles de barre tenue du quart"),
(2641, 0, 0, 0,  26, 0, 255, "264100", "ENREP", "Entretien réparation"),
(2642, 0, 0, 0,  26, 0, 255, "264200", "ARMAN", "Arrimage et manutention"),
(2643, 0, 0, 0,  26, 0, 255, "264300", "DENST", "Description entretien stabilité"),
(2644, 0, 0, 0,  26, 0, 255, "264400", "MOETL", "Mise en oeuvre d’opérations de transport et prestations logistiques"),
(2645, 0, 0, 0,  26, 0, 255, "264500", "CONTL", "Conception d’opérations de transport et de prestations logistiques"),
(2646, 0, 0, 0,  26, 0, 255, "264600", "APTPL", "Analyse performance activité de transport & prestations logistiques"),
(2647, 0, 0, 0,  26, 0, 255, "264700", "PDPTL", "Pérennisation & dévelop. activité transport & prestations logistiques"),
(2648, 0, 0, 0,  26, 0, 255, "264800", "CGEMA", "Culture éco. jurid. & manag. appliquée transport & prest. logistiques"),
(2699, 0, 0, 0,  26, 0, 255, "269900", "AUTAC", "Autres activités (conduite-navigation)dv"),

-- 27 Métiers des arts appliqués

(2701, 0, 0, 0,  27, 0, 255, "270100", "ATTKA", "Atelier et technologie appliquée"),
(2702, 0, 0, 0,  27, 0, 255, "270200", "EDAAA", "Education artistique - arts appliqués - ana"),
(2703, 0, 0, 0,  27, 0, 255, "270300", "ARCIE", "Archi interieure et expression plastique"),
(2704, 0, 0, 0,  27, 0, 255, "270400", "A-CTA", "Arts et civil;techniques agencement et habitat"),
(2705, 0, 0, 0,  27, 0, 255, "270500", "A-APP", "Arts appliqués"),
(2706, 0, 0, 0,  27, 0, 255, "270600", "PLAST", "Plastique"),
(2707, 0, 0, 0,  27, 0, 255, "270700", "ORGAN", "Organologie"),
(2708, 0, 0, 0,  27, 0, 255, "270800", "TXPRO", "Travaux professionnels"),
(2709, 0, 0, 0,  27, 0, 255, "270900", "TECEP", "Technologie spec -ethique-org profes legisla"),
(2710, 0, 0, 0,  27, 0, 255, "271000", "BCCRE", "Bureau de création : créations"),
(2711, 0, 0, 0,  27, 0, 255, "271100", "BCTEP", "Bureau de création : tvx et études prat"),
(2712, 0, 0, 0,  27, 0, 255, "271200", "BCREA", "Bureau de création : réalisation"),
(2713, 0, 0, 0,  27, 0, 255, "271300", "EDARA", "Education artistique arts appliqués"),
(2714, 0, 0, 0,  27, 0, 255, "271400", "BCCOM", "Bureau de création : communication"),
(2715, 0, 0, 0,  27, 0, 255, "271500", "MODCR", "Modes convent. représentation"),
(2716, 0, 0, 0,  27, 0, 255, "271600", "D-ARA", "Dessin d’arts appliqués"),
(2717, 0, 0, 0,  27, 0, 255, "271700", "BURET", "Bureau d’étude"),
(2718, 0, 0, 0,  27, 0, 255, "271800", "HIATK", "Histoire des arts et des techniques"),
(2719, 0, 0, 0,  27, 0, 255, "271900", "EDPAA", "Education plastique et arts appliqués"),
(2720, 0, 0, 0,  27, 0, 255, "272000", "TECAP", "Technologie approfondissement"),
(2721, 0, 0, 0,  27, 0, 255, "272100", "CPAAD", "Composition art applique aux domaines"),
(2722, 0, 0, 0,  27, 0, 255, "272200", "ESTAP", "Esthétique appliquée à la profession"),
(2723, 0, 0, 0,  27, 0, 255, "272300", "TXEPR", "Travaux et études pratiques"),
(2724, 0, 0, 0,  27, 0, 255, "272400", "CREAT", "Créativité"),
(2725, 0, 0, 0,  27, 0, 255, "272500", "T-GRA", "Technique graphique"),
(2726, 0, 0, 0,  27, 0, 255, "272600", "D-TAC", "Dessin-technologie-atelier de création"),
(2727, 0, 0, 0,  27, 0, 255, "272700", "PERSP", "Perspective"),
(2728, 0, 0, 0,  27, 0, 255, "272800", "ETDOC", "Étude documentaire"),
(2729, 0, 0, 0,  27, 0, 255, "272900", "TECTP", "Technologie et travaux pratiques"),
(2730, 0, 0, 0,  27, 0, 255, "273000", "CPARA", "Composition d’arts appliqués"),
(2731, 0, 0, 0,  27, 0, 255, "273100", "TTGRA", "Traitements graphiques"),
(2732, 0, 0, 0,  27, 0, 255, "273200", "EDAEI", "Education artistique et esthétique indus"),
(2733, 0, 0, 0,  27, 0, 255, "273300", "BCCRC", "Bureau de création : création céramique"),
(2734, 0, 0, 0,  27, 0, 255, "273400", "BCCPL", "Bureau de création : création plastique"),
(2735, 0, 0, 0,  27, 0, 255, "273500", "ATCTS", "Atelier création reali-techno specialit"),
(2736, 0, 0, 0,  27, 0, 255, "273600", "BCAIN", "Bureau création architecture intérieure"),
(2737, 0, 0, 0,  27, 0, 255, "273700", "BCSCM", "Bureau création style et croquis de mode"),
(2738, 0, 0, 0,  27, 0, 255, "273800", "BCCTX", "Bureau de création : création textile"),
(2739, 0, 0, 0,  27, 0, 255, "273900", "RPLAS", "Recherches plastiques"),
(2740, 0, 0, 0,  27, 0, 255, "274000", "CAATR", "Comp arts appl et tech repres projets"),
(2741, 0, 0, 0,  27, 0, 255, "274100", "EX-PC", "Expres plastique dessin création volume"),
(2742, 0, 0, 0,  27, 0, 255, "274200", "A-ATX", "Arts appliqués aux textiles"),
(2743, 0, 0, 0,  27, 0, 255, "274300", "BCDNT", "Bureau de création:TP et dessin technique"),
(2744, 0, 0, 0,  27, 0, 255, "274400", "T-PPG", "Techniques de prod pub graph et audio"),
(2745, 0, 0, 0,  27, 0, 255, "274500", "ERGON", "Ergonomie"),
(2746, 0, 0, 0,  27, 0, 255, "274600", "HIACO", "Histoire de l’art et du costume"),
(2747, 0, 0, 0,  27, 0, 255, "274700", "T-HAB", "Techniques de l’habillage"),
(2748, 0, 0, 0,  27, 0, 255, "274800", "T-MAE", "Techniques maintenance - entretien"),
(2749, 0, 0, 0,  27, 0, 255, "274900", "ETDFO", "Études et définitions des formes"),
(2750, 0, 0, 0,  27, 0, 255, "275000", "ETREA", "Études et réalisations"),
(2751, 0, 0, 0,  27, 0, 255, "275100", "CREAA", "Création artisanale"),
(2752, 0, 0, 0,  27, 0, 255, "275200", "CREAI", "Création industrielle"),
(2753, 0, 0, 0,  27, 0, 255, "275300", "INFGR", "Infographie"),
(2754, 0, 0, 0,  27, 0, 255, "275400", "CT-RE", "Conception de réalisation"),
(2755, 0, 0, 0,  27, 0, 255, "275500", "T-REL", "Techniques (ou technologie) de réalisation"),
(2756, 0, 0, 0,  27, 0, 255, "275600", "TECCO", "Technologie de la communication"),
(2757, 0, 0, 1,  27, 0, 255, "275700", "HIDA" , "Histoire des arts"),
(2758, 0, 0, 0,  27, 0, 255, "275800", "D-CON", "Dessin de conception et d’application"),
(2759, 0, 0, 0,  27, 0, 255, "275900", "HITEC", "Histoire des techniques"),
(2760, 0, 0, 0,  27, 0, 255, "276000", "CR-DS", "Création design"),
(2761, 0, 0, 0,  27, 0, 255, "276100", "CU-DS", "Culture design"),
(2762, 0, 0, 0,  27, 0, 255, "276200", "STUCR", "Studio de création"),
(2763, 0, 0, 0,  27, 0, 255, "276300", "ARVIS", "Arts visuels et appliqués"),
(2764, 0, 0, 0,  27, 0, 255, "276400", "TEDEC", "Techniques du décor"),
(2765, 0, 0, 0,  27, 0, 255, "276500", "R-DEV", "Recherche et développement"),
(2766, 0, 0, 0,  27, 0, 255, "276600", "LABPV", "Labo photo ou vidéo"),
(2767, 0, 0, 0,  27, 0, 255, "276700", "ARCAS", "Étude de cas (arts appliqués)"),
(2768, 0, 0, 0,  27, 0, 255, "276800", "EPFRA", "Expres plastiq fondam - recherche appliq"),
(2769, 0, 0, 0,  27, 0, 255, "276900", "EPRAM", "Exp plastiq fond - recherch.appliq. max"),
(2770, 0, 0, 0,  27, 0, 255, "277000", "CREIP", "Création industrielle : produit"),
(2771, 0, 0, 0,  27, 0, 255, "277100", "CREIE", "Création industrielle : environnement"),
(2772, 0, 0, 0,  27, 0, 255, "277200", "BURCR", "Bureau de création"),
(2773, 0, 0, 0,  27, 0, 255, "277300", "BCRDV", "Bureau de création:recherche et développement"),
(2774, 0, 0, 0,  27, 0, 255, "277400", "RCONV", "Représentation conventionnelle"),
(2775, 0, 0, 0,  27, 0, 255, "277500", "HIDA5", "Histoire des arts 5 heures"),
(2776, 0, 0, 0,  27, 0, 255, "277600", "LIMNU", "Laboratoire images numériques"),
(2777, 0, 0, 0,  27, 0, 255, "277700", "RDEVO", "Représentation en dessin et volume"),
(2778, 0, 0, 0,  27, 0, 255, "277800", "FOGAB", "Formes - outillage et gabarits"),
(2779, 0, 0, 0,  27, 0, 255, "277900", "TECHP", "Techniques particulières"),
(2780, 0, 0, 0,  27, 0, 255, "278000", "ATART", "Atelier artistique"),
(2781, 0, 0, 0,  27, 0, 255, "278100", "PJART", "Projet d’art appliqué"),
(2782, 0, 0, 0,  27, 0, 255, "278200", "PAAHA", "Projet art appliqué et histoire de l’art"),
(2783, 0, 0, 0,  27, 0, 255, "278300", "AACAR", "Arts appliqués et culture artistique"),
(2784, 0, 0, 0,  27, 0, 255, "278400", "EQLSC", "Équipement des lieux scéniques"),
(2785, 0, 0, 0,  27, 0, 255, "278500", "THEAT", "Théâtre"),
(2786, 0, 0, 0,  27, 0, 255, "278600", "CIRQU", "Arts du cirque"),
(2787, 0, 0, 0,  27, 0, 255, "278700", "PRPLA", "Pratique plastique"),
(2788, 0, 0, 0,  27, 0, 255, "278800", "ATCON", "Ateliers de conception"),
(2789, 0, 0, 0,  27, 0, 255, "278900", "CUART", "Culture artistique et technique"),
(2790, 0, 0, 0,  27, 0, 255, "279000", "DCREA", "Démarche créative"),
(2791, 0, 0, 0,  27, 0, 255, "279100", "COTEC", "Communication technique"),
(2792, 0, 0, 0,  27, 0, 255, "279200", "ATECR", "Atelier de création et de réalisation"),
(2793, 0, 0, 0,  27, 0, 255, "279300", "RCHPP", "Recherches et pratiques plastiques"),
(2794, 0, 0, 0,  27, 0, 255, "279400", "A-SPE", "Arts du spectacle"),
(2795, 0, 0, 0,  27, 0, 255, "279500", "PATRI", "Patrimoines"),
(2796, 0, 0, 0,  27, 0, 255, "279600", "CCDES", "Création et culture-design"),
(2797, 0, 0, 0,  27, 0, 255, "279700", "DESAA", "Design et arts appliqués"),
(2798, 0, 0, 0,  27, 0, 255, "279800", "HASCT", "Histoire de l’art des sciences & techniques"),
(2799, 0, 0, 0,  27, 0, 255, "279900", "MARAD", "Métiers d’arts appliqués divers"),

-- 28 Métiers d’art

(2801, 0, 0, 0,  28, 0, 255, "280100", "D-GEO", "Dessin géométrique"),
(2802, 0, 0, 0,  28, 0, 255, "280200", "D-ART", "Dessin d’arts"),
(2803, 0, 0, 0,  28, 0, 255, "280300", "PR-AR", "Pratique artistique"),
(2804, 0, 0, 0,  28, 0, 255, "280400", "HIART", "Histoire de l’art"),
(2805, 0, 0, 0,  28, 0, 255, "280500", "HICIV", "Hist civilis et de leur exp art"),
(2806, 0, 0, 0,  28, 0, 255, "280600", "HISDN", "Histoire des styles et dessins"),
(2807, 0, 0, 0,  28, 0, 255, "280700", "D-VOL", "Dessin : volume"),
(2808, 0, 0, 0,  28, 0, 255, "280800", "D-COU", "Dessin : couleur"),
(2809, 0, 0, 0,  28, 0, 255, "280900", "D-DOC", "Dessin : document"),
(2810, 0, 0, 0,  28, 0, 255, "281000", "CPPVO", "Composition plane et en volume"),
(2811, 0, 0, 0,  28, 0, 255, "281100", "MODVO", "Modelage et études en volume"),
(2812, 0, 0, 0,  28, 0, 255, "281200", "A-TKC", "Arts - techniques et civilisation"),
(2813, 0, 0, 0,  28, 0, 255, "281300", "DSCRP", "Descriptive"),
(2814, 0, 0, 0,  28, 0, 255, "281400", "RCHAR", "Recherche artistique"),
(2815, 0, 0, 0,  28, 0, 255, "281500", "EVCRP", "Envir culturel et recherche plastique"),
(2816, 0, 0, 0,  28, 0, 255, "281600", "T-SON", "Techniques du son"),
(2817, 0, 0, 0,  28, 0, 255, "281700", "THED5", "Théâtre expression dramatique 5 heures"),
(2818, 0, 0, 0,  28, 0, 255, "281800", "TECRL", "Technologie relations"),
(2819, 0, 0, 0,  28, 0, 255, "281900", "T-EVS", "Techniques d’express visuelle et sémiologique"),
(2820, 0, 0, 0,  28, 0, 255, "282000", "TECOU", "Technologie ouverture"),
(2821, 0, 0, 0,  28, 0, 255, "282100", "TPRAT", "Travaux pratiques"),
(2822, 0, 0, 0,  28, 0, 255, "282200", "T-EXA", "Techniques d’expression audiovisuelle"),
(2823, 0, 0, 0,  28, 0, 255, "282300", "HICVI", "Hist des arts liée à la commu visuelle"),
(2824, 0, 0, 0,  28, 0, 255, "282400", "TECPM", "Technologie profession-mach spectacle"),
(2825, 0, 0, 0,  28, 0, 255, "282500", "DCVIS", "Document et communication visuelle"),
(2826, 0, 0, 0,  28, 0, 255, "282600", "HISPC", "Histoire du spectacle"),
(2827, 0, 0, 0,  28, 0, 255, "282700", "CO-MS", "Connaissance du monde du spectacle"),
(2828, 0, 0, 0,  28, 0, 255, "282800", "CIAV5", "Cinéma - audiovisuel 5 heures"),
(2829, 0, 0, 0,  28, 0, 255, "282900", "CMEDI", "Comédie"),
(2830, 0, 0, 0,  28, 0, 255, "283000", "ETROL", "Étude d’un rôle"),
(2831, 0, 0, 0,  28, 0, 255, "283100", "EX-VR", "Expression verbale"),
(2832, 0, 0, 0,  28, 0, 255, "283200", "EX-CP", "Expression corporelle"),
(2833, 0, 0, 0,  28, 0, 255, "283300", "SONPT", "Sonorisation pratique"),
(2834, 0, 0, 0,  28, 0, 255, "283400", "ERSON", "Enregistrements sonores"),
(2835, 0, 0, 0,  28, 0, 255, "283500", "ETRCO", "Étude et réalisation de costumes"),
(2836, 0, 0, 0,  28, 0, 255, "283600", "ECLAR", "Eclairagisme artistique"),
(2837, 0, 0, 0,  28, 0, 255, "283700", "SCENO", "Scénographie"),
(2838, 0, 0, 0,  28, 0, 255, "283800", "THEAD", "Théâtre - expression dramatique"),
(2839, 0, 0, 0,  28, 0, 255, "283900", "EXEMD", "Exécution maquettes décors accessoires"),
(2840, 0, 0, 0,  28, 0, 255, "284000", "RGLUM", "Réglage de la lumière"),
(2841, 0, 0, 0,  28, 0, 255, "284100", "RGMES", "Réglage d’une mise en scène"),
(2842, 0, 0, 0,  28, 0, 255, "284200", "RLVMS", "Relevé d’une mise en scène"),
(2843, 0, 0, 0,  28, 0, 255, "284300", "SCEMX", "Sciences appliquées et étude matériaux"),
(2844, 0, 0, 0,  28, 0, 255, "284400", "HITHE", "Histoire du théâtre"),
(2845, 0, 0, 0,  28, 0, 255, "284500", "PEMAQ", "Perruquage maquillage"),
(2846, 0, 0, 0,  28, 0, 255, "284600", "RDECO", "Recherche en décors costumes"),
(2847, 0, 0, 0,  28, 0, 255, "284700", "T-EPH", "Technique et expression photographique"),
(2848, 0, 0, 0,  28, 0, 255, "284800", "PHOTO", "Photographie"),
(2849, 0, 0, 0,  28, 0, 255, "284900", "AUDVI", "Audiovisuel"),
(2850, 0, 0, 0,  28, 0, 255, "285000", "ADMTH", "Administration (théâtre)"),
(2851, 0, 0, 0,  28, 0, 255, "285100", "T-EXV", "Techniques d’expression visuelle"),
(2852, 0, 0, 0,  28, 0, 255, "285200", "CI-AV", "Cinéma - audiovisuel"),
(2853, 0, 0, 0,  28, 0, 255, "285300", "REGIE", "Régie"),
(2854, 0, 0, 0,  28, 0, 255, "285400", "CI-TG", "Cinématographie"),
(2855, 0, 0, 0,  28, 0, 255, "285500", "PERUQ", "Perruquage"),
(2856, 0, 0, 0,  28, 0, 255, "285600", "ACCES", "Accessoirisme"),
(2857, 0, 0, 0,  28, 0, 255, "285700", "MAQIL", "Maquillage"),
(2858, 0, 0, 0,  28, 0, 255, "285800", "TGOMU", "Transpos.graphique d’une œuvre musicale"),
(2859, 0, 0, 0,  28, 0, 255, "285900", "EX-PL", "Expression plastique"),
(2860, 0, 0, 0,  28, 0, 255, "286000", "D-EPL", "Dessin et expression plastique"),
(2861, 0, 0, 0,  28, 0, 255, "286100", "SDPCC", "Scénographie-décor-personnages conception"),
(2862, 0, 0, 0,  28, 0, 255, "286200", "IMANI", "Interprétation- manipulation"),
(2863, 0, 0, 0,  28, 0, 255, "286300", "SDPCT", "Scénographie-décor-personnages construction"),
(2864, 0, 0, 0,  28, 0, 255, "286400", "TECPL", "Technologie du plateau"),
(2865, 0, 0, 0,  28, 0, 255, "286500", "EX-MU", "Expression musicale"),
(2867, 0, 0, 0,  28, 0, 255, "286700", "DRAMS", "Dramaturgie - mise en scène"),
(2868, 0, 0, 0,  28, 0, 255, "286800", "A-DRA", "Art dramatique"),
(2869, 0, 0, 0,  28, 0, 255, "286900", "T-PHO", "Technique photographie"),
(2870, 0, 0, 0,  28, 0, 255, "287000", "ACOUS", "Acoustique"),
(2871, 0, 0, 0,  28, 0, 255, "287100", "AP-CA", "Atel de pratique : cinéma - audiovisuel"),
(2872, 0, 0, 0,  28, 0, 255, "287200", "AP-TE", "Atel de prat : théâtre exp dramatique"),
(2873, 0, 0, 0,  28, 0, 255, "287300", "CI-SP", "Cinéma spécialité"),
(2874, 0, 0, 0,  28, 0, 255, "287400", "THTSP", "Théâtre spécialité"),
(2875, 0, 0, 0,  28, 0, 255, "287500", "CI-PA", "Cinéma option - pratique artistique"),
(2876, 0, 0, 0,  28, 0, 255, "287600", "THTPA", "Théâtre option - pratique artistique"),
(2877, 0, 0, 0,  28, 0, 255, "287700", "HIASC", "Histoire des arts et scénographie"),
(2878, 0, 0, 0,  28, 0, 255, "287800", "HITDR", "Histoire du théâtre et dramaturgie"),
(2879, 0, 0, 0,  28, 0, 255, "287900", "SOSPC", "Sociologie du spectacle"),
(2880, 0, 0, 0,  28, 0, 255, "288000", "SMACH", "Scénographie - machinerie"),
(2881, 0, 0, 0,  28, 0, 255, "288100", "REGLU", "Régie lumière"),
(2882, 0, 0, 0,  28, 0, 255, "288200", "CULAR", "Culture artistique"),
(2883, 0, 0, 0,  28, 0, 255, "288300", "HIAGR", "Histoire de l’art et de la gravure"),
(2884, 0, 0, 0,  28, 0, 255, "288400", "HIALI", "Histoire de l’art et du livre"),
(2885, 0, 0, 0,  28, 0, 255, "288500", "CPLAC", "Culture plastique - approche création"),
(2886, 0, 0, 0,  28, 0, 255, "288600", "CIPRO", "Arts du cirque (enseignement professionnel)"),
(2887, 0, 0, 0,  28, 0, 255, "288700", "MAPRO", "Arts marionnette (enseignement professionnel)"),
(2888, 0, 0, 0,  28, 0, 255, "288800", "METAO", "Méthode d’analyse des œuvres"),
(2889, 0, 0, 0,  28, 0, 255, "288900", "HADEC", "Histoire de l’art et du décor"),
(2890, 0, 0, 0,  28, 0, 255, "289000", "HSVCA", "Hist spect vivant - cinéma - audiovisuel"),
(2891, 0, 0, 0,  28, 0, 255, "289100", "TCIRQ", "Technique de cirque"),
(2892, 0, 0, 0,  28, 0, 255, "289200", "TSPEC", "Technique de spectacle"),
(2893, 0, 0, 0,  28, 0, 255, "289300", "SPECS", "Spécialisation (cirque et spectacle)"),
(2894, 0, 0, 0,  28, 0, 255, "289400", "ARMAQ", "Art et maquillage"),
(2895, 0, 0, 0,  28, 0, 255, "289500", "RECHA", "Recherche appliquée (arts)"),
(2896, 0, 0, 0,  28, 0, 255, "289600", "SMSON", "Studio de montage et de son"),
(2897, 0, 0, 0,  28, 0, 255, "289700", "SFTEC", "Studio de fabrication - technologie"),
(2898, 0, 0, 0,  28, 0, 255, "289800", "ATEXA", "Atelier d’expression artistique"),
(2899, 0, 0, 0,  28, 0, 255, "289900", "MARDI", "Métiers d’art divers"),

-- 29 Métiers de l’artisanat et spécifiques

(2901, 0, 0, 0,  29, 0, 255, "290100", "BIJOU", "Bijouterie"),
(2902, 0, 0, 0,  29, 0, 255, "290200", "CADTP", "Compo.art appli.dom.techniq.repres.projt"),
(2999, 0, 0, 0,  29, 0, 255, "299900", "ARDIV", "Artisanat divers"),

-- 30 Biotechnologie génie biol.- biochimique

(3001, 0, 0, 0,  30, 0, 255, "300100", "TDBIO", "Travaux dirigés de biologie"),
(3002, 0, 0, 0,  30, 0, 255, "300200", "GEOLO", "Géologie"),
(3003, 0, 0, 0,  30, 0, 255, "300300", "TECSO", "Technologie sondage"),
(3004, 0, 0, 0,  30, 0, 255, "300400", "ACEXT", "Activités extérieures"),
(3005, 0, 0, 0,  30, 0, 255, "300500", "BLGGL", "Biologie - géologie"),
(3006, 0, 0, 0,  30, 0, 255, "300600", "SCBIO", "Sciences biologiques"),
(3007, 0, 0, 0,  30, 0, 255, "300700", "ETSPE", "Étude des syst prod equip-instal usines"),
(3008, 0, 0, 0,  30, 0, 255, "300800", "TECAL", "Activités technologiques d’alimentation"),
(3009, 0, 0, 0,  30, 0, 255, "300900", "ACTEC", "Activités technologiques"),
(3010, 0, 0, 0,  30, 0, 255, "301000", "I-TAD", "Init travaux d’atelier de demi-grand"),
(3011, 0, 0, 0,  30, 0, 255, "301100", "BLGIE", "Biologie"),
(3012, 0, 0, 0,  30, 0, 255, "301200", "ARBOR", "Arboriculture d’ornement"),
(3013, 0, 0, 0,  30, 0, 255, "301300", "BLGAP", "Biologie appliquée"),
(3014, 0, 0, 0,  30, 0, 255, "301400", "CH-IC", "Chimie appliquée aux industries céréalières"),
(3015, 0, 0, 0,  30, 0, 255, "301500", "BLGVG", "Biologie végétale"),
(3016, 0, 0, 0,  30, 0, 255, "301600", "OENOL", "Œnologie"),
(3017, 0, 0, 0,  30, 0, 255, "301700", "TECCE", "Technologie des céréales"),
(3018, 0, 0, 0,  30, 0, 255, "301800", "BLGCM", "Biol cellulaire et moléculaire"),
(3019, 0, 0, 0,  30, 0, 255, "301900", "BLGAN", "Biologie animale"),
(3020, 0, 0, 0,  30, 0, 255, "302000", "MIBIO", "Microbiologie"),
(3021, 0, 0, 0,  30, 0, 255, "302100", "BCHBL", "Biochimie-biologie"),
(3022, 0, 0, 0,  30, 0, 255, "302200", "BCHIM", "Biochimie"),
(3023, 0, 0, 0,  30, 0, 255, "302300", "ALIAN", "Alimentation animale"),
(3024, 0, 0, 0,  30, 0, 255, "302400", "BCHPH", "Biochimie-physiologie"),
(3025, 0, 0, 0,  30, 0, 255, "302500", "BCHMI", "Biochimie microbiologie"),
(3026, 0, 0, 0,  30, 0, 255, "302600", "EXPRM", "Exploitation des ressources de la mer"),
(3027, 0, 0, 0,  30, 0, 255, "302700", "GNRUR", "Génie rural"),
(3028, 0, 0, 0,  30, 0, 255, "302800", "FA-MM", "Fab mainten ds les dom rur et maritimes"),
(3029, 0, 0, 0,  30, 0, 255, "302900", "MI1TF", "Meunerie et industries de 1ere transfor"),
(3030, 0, 0, 0,  30, 0, 255, "303000", "PHYSL", "Physiologie"),
(3031, 0, 0, 0,  30, 0, 255, "303100", "MSPPA", "Manipulation sci de phys papetière"),
(3032, 0, 0, 0,  30, 0, 255, "303200", "SAMEP", "Sciences app mise en œuvre d’études papetières"),
(3033, 0, 0, 0,  30, 0, 255, "303300", "PRD-P", "Production et transformation (papier)"),
(3034, 0, 0, 0,  30, 0, 255, "303400", "I-MAR", "Initiation au milieu marin"),
(3035, 0, 0, 0,  30, 0, 255, "303500", "AGRON", "Agronomie"),
(3036, 0, 0, 0,  30, 0, 255, "303600", "GNBTA", "Génie biologique et techno analyse"),
(3037, 0, 0, 0,  30, 0, 255, "303700", "STL"  , "Sciences et techno des laboratoires"),
(3038, 0, 0, 0,  30, 0, 255, "303800", "GLMIN", "Géologie et minéralogie"),
(3039, 0, 0, 0,  30, 0, 255, "303900", "TECAC", "Technologie des appareils correcteurs"),
(3040, 0, 0, 0,  30, 0, 255, "304000", "TPTAP", "TP et technologie d’application"),
(3041, 0, 0, 0,  30, 0, 255, "304100", "D-TBT", "Dessin technique (biotechnologie)"),
(3042, 0, 0, 0,  30, 0, 255, "304200", "TECCH", "Technologie construction de chaussures"),
(3043, 0, 0, 0,  30, 0, 255, "304300", "SPBSA", "Sciences phy bio et sciences appliquées"),
(3044, 0, 0, 0,  30, 0, 255, "304400", "SCBAG", "Sciences biologiques et agronomie"),
(3045, 0, 0, 0,  30, 0, 255, "304500", "BLGEC", "Biologie-écologie"),
(3046, 0, 0, 0,  30, 0, 255, "304600", "AGRIV", "Agriculture et environnement"),
(3047, 0, 0, 0,  30, 0, 255, "304700", "AMGEV", "Aménagement et environnement"),
(3048, 0, 0, 0,  30, 0, 255, "304800", "BLGEM", "Biologie écologie module"),
(3049, 0, 0, 0,  30, 0, 255, "304900", "HYDRO", "Hydraulique"),
(3050, 0, 0, 0,  30, 0, 255, "305000", "GNPTE", "Génie des procédés traitement des eaux"),
(3051, 0, 0, 0,  30, 0, 255, "305100", "SSSOC", "Sciences sanitaires et sociales"),
(3052, 0, 0, 0,  30, 0, 255, "305200", "CMNAS", "Communication en santé et action sociale"),
(3053, 0, 0, 0,  30, 0, 255, "305300", "BLGHU", "Biologie humaine"),
(3054, 0, 0, 0,  30, 0, 255, "305400", "AGROV", "Agronomie et environnement"),
(3055, 0, 0, 0,  30, 0, 255, "305500", "BLGES", "Biologie écologie agronomie spécialité"),
(3056, 0, 0, 0,  30, 0, 255, "305600", "P-CSS", "Préparation aux concours sanitaire et social"),
(3057, 0, 0, 0,  30, 0, 255, "305700", "S-BT" , "Sciences biologiques et de la terre"),
(3058, 0, 0, 0,  30, 0, 255, "305800", "ECOAG", "Ecologie - agronomie"),
(3059, 0, 0, 0,  30, 0, 255, "305900", "GEIND", "Génie industriel bio"),
(3060, 0, 0, 0,  30, 0, 255, "306000", "GEPRO", "Génie des procédés"),
(3061, 0, 0, 0,  30, 0, 255, "306100", "STBIO", "Sciences et techno des bio-industries"),
(3062, 0, 0, 0,  30, 0, 255, "306200", "IALAB", "Informatique appliquée au laboratoire"),
(3063, 0, 0, 0,  30, 0, 255, "306300", "EXPAN", "Expérimentation animale"),
(3064, 0, 0, 0,  30, 0, 255, "306400", "BBM-E", "Biochimie biologie microbiologie des eaux"),
(3065, 0, 0, 0,  30, 0, 255, "306500", "SCALI", "Sciences des aliments"),
(3066, 0, 0, 0,  30, 0, 255, "306600", "EATCI", "Ecologie-agronomie-territoire-citoyenneté"),
(3067, 0, 0, 0,  30, 0, 255, "306700", "BIOLP", "Biologie de laboratoire et paramédicale"),
(3068, 0, 0, 0,  30, 0, 255, "306800", "AGTCI", "Agronomie-territoire-citoyenneté"),
(3069, 0, 0, 0,  30, 0, 255, "306900", "BASAN", "Biologie appliquée - santé"),
(3070, 0, 0, 0,  30, 0, 255, "307000", "BIOTA", "Biochimie et technologies d’analyse"),
(3071, 0, 0, 0,  30, 0, 255, "307100", "BBCMO", "Biochim. biologie cellulaire moléculaire"),
(3072, 0, 0, 0,  30, 0, 255, "307200", "MBTAN", "Microbiologie et technologies d’analyse"),
(3073, 0, 0, 0,  30, 0, 255, "307300", "MBBCM", "Microbiologie biologie cellul. Molécul."),
(3074, 0, 0, 0,  30, 0, 255, "307400", "STBIN", "Sciences technologies bio-industrielles"),
(3075, 0, 0, 0,  30, 0, 255, "307500", "TECBB", "Technologies biochimiques et biologiques"),
(3076, 0, 0, 0,  30, 0, 255, "307600", "SCTSS", "Scienc. & techniq. sanitaires & sociales"),
(3077, 0, 0, 0,  30, 0, 255, "307700", "BPPHU", "Biologie & physiopathologie humaines"),
(3078, 0, 0, 0,  30, 0, 255, "307800", "BIMGG", "Biologie moléculaire et génie génétique"),
(3079, 0, 0, 0,  30, 0, 255, "307900", "BANAL", "Biochimie analytique"),
(3080, 0, 0, 0,  30, 0, 255, "308000", "BISFP", "Biochimie structur.& fonction. Protéines"),
(3081, 0, 0, 0,  30, 0, 255, "308100", "MBIGF", "Microbiologie et génie fermentaire"),
(3082, 0, 0, 0,  30, 0, 255, "308200", "BTCEL", "Biologie et technologies cellulaires"),
(3083, 0, 0, 0,  30, 0, 255, "308300", "SLABO", "Sciences & laboratoire"),
(3084, 0, 0, 0,  30, 0, 255, "308400", "EAEDD", "Ecologie-agronomie-territoires-développement durable"),
(3085, 0, 0, 0,  30, 0, 255, "308500", "BAT2D", "Biologie agro. territoir.& devel.durable"),
(3086, 0, 0, 0,  30, 0, 255, "308600", "VIVAN", "Chimie - biochimie - sciences du vivant"),
(3087, 0, 0, 0,  30, 0, 255, "308700", "MESIN", "Mesure et instrumentation"),
(3088, 0, 0, 0,  30, 0, 255, "308800", "ECAGT", "Ecologie agronomie et territoires"),
(3089, 0, 0, 0,  30, 0, 255, "308900", "MAPHY", "Microbiologie appliquée & physiopathologie"),
(3090, 0, 0, 0,  30, 0, 255, "309000", "ACMAE", "Agronomie & connaissance milieu agroéquipement"),
(3091, 0, 0, 0,  30, 0, 255, "309100", "STSYS", "Sciences et technologie des systèmes"),
(3092, 0, 0, 0,  30, 0, 255, "309200", "SQSER", "Syst.qual.sécur.envir. resp.sociale & devel.durable"),
(3093, 0, 0, 0,  30, 0, 255, "309300", "BMEAP", "Biologie microbiologie & écologie appliquée"),
(3094, 0, 0, 0,  30, 0, 255, "309400", "ERENV", "Espace rural et environnement"),
(3095, 0, 0, 0,  30, 0, 255, "309500", "ECOLO", "Ecologie"),
(3096, 0, 0, 0,  30, 0, 255, "309600", "DEVDU", "Développement durable"),
(3097, 0, 0, 0,  30, 0, 255, "309700", "AGECT", "Agronomie-économie-territoires"),
(3098, 0, 0, 0,  30, 0, 255, "309800", "CBIPH", "Chimie, biologie et physiopathologie humaines"),
(3099, 0, 0, 0,  30, 0, 255, "309900", "BTGBD", "Biotechnologie génie bio divers"),

-- 31 Biotechnologie santé environnement collectivités

(3101, 0, 0, 0,  31, 0, 255, "310100", "ALIHU", "Alimentation humaine"),
(3102, 0, 0, 0,  31, 0, 255, "310200", "E-FS" , "Économie familiale et sociale"),
(3103, 0, 0, 0,  31, 0, 255, "310300", "DACVQ", "Domaines activités vie quotidienne"),
(3104, 0, 0, 0,  31, 0, 255, "310400", "MCESF", "Mode intervention conseiller en ESF"),
(3105, 0, 0, 0,  31, 0, 255, "310500", "E-DOM", "Économie domestique"),
(3106, 0, 0, 0,  31, 0, 255, "310600", "P-VSF", "Préparation à la vie sociale et familial"),
(3107, 0, 0, 0,  31, 0, 255, "310700", "P-VSP", "Préparation vie sociale et prof (ses)"),
(3108, 0, 0, 0,  31, 0, 255, "310800", "E-SFQ", "Économie sociale-familiale appl quotidien"),
(3109, 0, 0, 0,  31, 0, 255, "310900", "HYGAL", "Hygiène générale et alimentaire"),
(3110, 0, 0, 0,  31, 0, 255, "311000", "HYGPS", "Hygiène prévention secourisme"),
(3111, 0, 0, 0,  31, 0, 255, "311100", "BANCS", "Banc essai"),
(3112, 0, 0, 0,  31, 0, 255, "311200", "REGIM", "Régimes"),
(3113, 0, 0, 0,  31, 0, 255, "311300", "STBPM", "Sciences et techniques bio et paramédicales"),
(3114, 0, 0, 0,  31, 0, 255, "311400", "T-PRO", "Techniques professionnelles"),
(3115, 0, 0, 0,  31, 0, 255, "311500", "VISTA", "Visites stages"),
(3116, 0, 0, 0,  31, 0, 255, "311600", "BPDIE", "Bases physiopathologiques de la diétetique"),
(3117, 0, 0, 0,  31, 0, 255, "311700", "NUTAL", "Nutrition et alimentation"),
(3118, 0, 0, 0,  31, 0, 255, "311800", "CO-MV", "Connaissance milieu vie et travail"),
(3119, 0, 0, 0,  31, 0, 255, "311900", "VSPRO", "Vie sociale et professionnelle"),
(3120, 0, 0, 0,  31, 0, 255, "312000", "STHEV", "Sciences et techno habitat environnement"),
(3121, 0, 0, 0,  31, 0, 255, "312100", "PRVSF", "Prep à la vie sociale et familiale"),
(3122, 0, 0, 0,  31, 0, 255, "312200", "QUALI", "Qualité (famille 31)"),
(3123, 0, 0, 0,  31, 0, 255, "312300", "METSO", "Méthodologie du travail social"),
(3124, 0, 0, 0,  31, 0, 255, "312400", "ALTHP", "Alimentation théorique et pratique"),
(3125, 0, 0, 0,  31, 0, 255, "312500", "HABAM", "Habillement ameublement"),
(3126, 0, 0, 0,  31, 0, 255, "312600", "APSEC", "Actions professionnelles (bio.sant.env.collec)"),
(3127, 0, 0, 0,  31, 0, 255, "312700", "PRISQ", "Prévention des risques"),
(3128, 0, 0, 0,  31, 0, 255, "312800", "PSE"  , "Prévention - santé - environnement"),
(3129, 0, 0, 0,  31, 0, 255, "312900", "HABLO", "Habitat - logement"),
(3130, 0, 0, 0,  31, 0, 255, "313000", "ALSHY", "Alimentation - santé - hygiène"),
(3131, 0, 0, 0,  31, 0, 255, "313100", "BIOTE", "Biotechnologies"),
(3132, 0, 0, 0,  31, 0, 255, "313200", "CDESF", "Connaissance domaines majeurs esf"),
(3133, 0, 0, 0,  31, 0, 255, "313300", "ISPRO", "Insertion sociale et professionnelle"),
(3134, 0, 0, 0,  31, 0, 255, "313400", "INTSO", "Intervention sociale"),
(3135, 0, 0, 0,  31, 0, 255, "313500", "HYASE", "Hygiène alimentation services"),
(3136, 0, 0, 0,  31, 0, 255, "313600", "BCBBT", "Biochimie-biologie-biotechnologie"),
(3137, 0, 0, 0,  31, 0, 255, "313700", "BIOTC", "Biotechnologie"),
(3138, 0, 0, 0,  31, 0, 255, "313800", "DIETH", "Diététique thérapeutique"),
(3139, 0, 0, 0,  31, 0, 255, "313900", "MAQUA", "Management de la qualité"),
(3140, 0, 0, 0,  31, 0, 255, "314000", "BISOR", "Bioexpertise au service de l'organisme"),
(3141, 0, 0, 0,  31, 0, 255, "314100", "PROPQ", "Pratiques opérationnelles de la qualité"),
(3199, 0, 0, 0,  31, 0, 255, "319900", "BTSAD", "Biotechnologie santé divers"),

-- 32 Paramédical et médical

(3201, 0, 0, 0,  32, 0, 255, "320100", "ANAOM", "Anatomie (ostéologie-myologie)"),
(3202, 0, 0, 0,  32, 0, 255, "320200", "FSPTM", "Physiopatho terminologie médicale"),
(3203, 0, 0, 0,  32, 0, 255, "320300", "APB"  , "APB"),
(3204, 0, 0, 0,  32, 0, 255, "320400", "PGIPR", "Patho gene intro pharma radiobio"),
(3205, 0, 0, 0,  32, 0, 255, "320500", "PTTRT", "Patho - therapeu - tech radiodiag - therap"),
(3206, 0, 0, 0,  32, 0, 255, "320600", "T-RR" , "Techniques radiodiag et radiotherap"),
(3207, 0, 0, 0,  32, 0, 255, "320700", "SMS"  , "Sciences médico-sociales"),
(3208, 0, 0, 0,  32, 0, 255, "320800", "STMS" , "Sciences et techniques médico-sociales"),
(3209, 0, 0, 0,  32, 0, 255, "320900", "STRAD", "Stages radiologie"),
(3210, 0, 0, 0,  32, 0, 255, "321000", "ECMED", "Éléments de connaissance médicale"),
(3211, 0, 0, 0,  32, 0, 255, "321100", "IMUNO", "Immunologie"),
(3212, 0, 0, 0,  32, 0, 255, "321200", "HCYTO", "Histologie cytologie"),
(3213, 0, 0, 0,  32, 0, 255, "321300", "HEMAT", "Hématologie"),
(3214, 0, 0, 0,  32, 0, 255, "321400", "P-PSG", "Prepa cert capa en prélèvement sanguin"),
(3215, 0, 0, 0,  32, 0, 255, "321500", "STHSP", "Stage technique hospitalière"),
(3216, 0, 0, 0,  32, 0, 255, "321600", "ANATO", "Anatomie"),
(3217, 0, 0, 0,  32, 0, 255, "321700", "ANAPP", "Anatomie physiologie pathologie"),
(3218, 0, 0, 0,  32, 0, 255, "321800", "SMEDS", "Stage milieu médical spécialisé"),
(3219, 0, 0, 0,  32, 0, 255, "321900", "HHCYT", "Hématologie - histologie - cytologie"),
(3220, 0, 0, 0,  32, 0, 255, "322000", "TECMA", "Technologie matériels"),
(3221, 0, 0, 0,  32, 0, 255, "322100", "ANAMP", "Anatomie - morphologie"),
(3222, 0, 0, 0,  32, 0, 255, "322200", "HANCY", "Hématologie - anatomocythopathologie"),
(3223, 0, 0, 0,  32, 0, 255, "322300", "STBP" , "Sciences et techn biol et paramédicales"),
(3224, 0, 0, 0,  32, 0, 255, "322400", "IMNEP", "Im med medec nucl 4rad elec pathol pharm"),
(3225, 0, 0, 0,  32, 0, 255, "322520", "EMEDS", "Enseignement médical et scientifique"),
(3226, 0, 0, 0,  32, 0, 255, "322600", "C-MED", "Connaissances médicales"),
(3227, 0, 0, 0,  32, 0, 255, "322700", "TPPOD", "Travaux pratiques (podo-orthesiste)"),
(3228, 0, 0, 0,  32, 0, 255, "322800", "TPPRT", "Travaux pratiques (prothesiste.-orthesiste)"),
(3229, 0, 0, 0,  32, 0, 255, "322900", "APPAP", "Application de l’appareillage"),
(3230, 0, 0, 0,  32, 0, 255, "323000", "ETCAP", "Étude et conception de l’appareillage"),
(3231, 0, 0, 0,  32, 0, 255, "323100", "REAAP", "Réalisation de l’appareillage"),
(3232, 0, 0, 0,  32, 0, 255, "323200", "ANVIS", "Analyse de la vision"),
(3233, 0, 0, 0,  32, 0, 255, "323300", "MSFAC", "Mesures faciales"),
(3234, 0, 0, 0,  32, 0, 255, "323400", "ERCEQ", "Étude réalisation contrôle d’équipement"),
(3235, 0, 0, 0,  32, 0, 255, "323500", "MAGAP", "Magasin d’application"),
(3236, 0, 0, 0,  32, 0, 255, "323600", "IMHCY", "Immunologie histologie cytologie"),
(3237, 0, 0, 0,  32, 0, 255, "323700", "ERGSE", "Sécurité et ergonomie"),
(3238, 0, 0, 0,  32, 0, 255, "323800", "IEXPA", "Immunologie et expérimentation animale"),
(3239, 0, 0, 0,  32, 0, 255, "323900", "HEHIC", "Hématologie - histologie - cytologie"),
(3240, 0, 0, 0,  32, 0, 255, "324000", "PHOFF", "Pharmacie d’officine"),
(3241, 0, 0, 0,  32, 0, 255, "324100", "MASSS", "Methodo.appliq.secteur sanit.& soc."),
(3242, 0, 0, 0,  32, 0, 255, "324200", "HEMAN", "Hématologie - anatomopathologie"),
(3243, 0, 0, 0,  32, 0, 255, "324300", "SANTS", "Sante & social"),
(3244, 0, 0, 0,  32, 0, 255, "324400", "AOCCL", "Anatomie-occlusodontie"),
(3245, 0, 0, 0,  32, 0, 255, "324500", "SMVSM", "Sc. matière et vie et sciences médicales"),
(3246, 0, 0, 0,  32, 0, 255, "324600", "IMDTR", "Sc. & techn., fond. méth. imagerie médicale"),
(3247, 0, 0, 0,  32, 0, 255, "324700", "IIMDT", "Sc. & techn., intervention en imagerie médicale"),
(3248, 0, 0, 0,  32, 0, 255, "324800", "OUTMT", "Outils et méthodes de travail"),
(3249, 0, 0, 0,  32, 0, 255, "324900", "INSPP", "Intégration savoirs & posture professionnelle"),
(3299, 0, 0, 0,  32, 0, 255, "329900", "PRMDI", "Paramédical divers"),

-- 33 Soins personnels

(3301, 0, 0, 0,  33, 0, 255, "330100", "ESTCP", "Esthétique - cosmétique - parfumerie"),
(3302, 0, 0, 0,  33, 0, 255, "330200", "ETCRT", "Étude de cas concrets"),
(3303, 0, 0, 0,  33, 0, 255, "330300", "T-HYH", "Techniques de soins et hygiène hospitalière"),
(3304, 0, 0, 0,  33, 0, 255, "330400", "COSME", "Cosmétologie"),
(3305, 0, 0, 0,  33, 0, 255, "330500", "TALOC", "Technologie des appareils et des locaux"),
(3306, 0, 0, 0,  33, 0, 255, "330600", "TESTH", "Techniques esthétiques"),
(3307, 0, 0, 0,  33, 0, 255, "330700", "QUOTI", "Interv.sur le quotidien et son évolution"),
(3308, 0, 0, 0,  33, 0, 255, "330800", "CMOTE", "Conception et moe de techniques cosmet."),
(3309, 0, 0, 0,  33, 0, 255, "330900", "ENEST", "Environnement esthétique"),
(3310, 0, 0, 0,  33, 0, 255, "331000", "PRCOS", "Le produit cosmétique"),
(3311, 0, 0, 0,  33, 0, 255, "331100", "APECP", "Actions professionnelles (esthétique cosmétique parfumerie)"),
(3312, 0, 0, 0,  33, 0, 255, "331200", "TPPLU", "Travaux pratiques pluridimensionnels"),
(3313, 0, 0, 0,  33, 0, 255, "331300", "EFPRC", "Efficacite des produits cosmétiques"),
(3314, 0, 0, 0,  33, 0, 255, "331400", "COELP", "Conception, élaboration, production"),
(3315, 0, 0, 0,  33, 0, 255, "331500", "TECHC", "Techniques cosmétiques"),
(3316, 0, 0, 0,  33, 0, 255, "331600", "FPCCO", "Fondement physico-chimiques cosmétologie"),
(3317, 0, 0, 0,  33, 0, 255, "331700", "COSAP", "Cosmétologie appliquée"),
(3399, 0, 0, 0,  33, 0, 255, "339900", "SPERD", "Soins personnels divers"),

-- 34 Commerce

(3401, 0, 0, 0,  34, 0, 255, "340100", "VADIS", "Vente à distance"),
(3402, 0, 0, 0,  34, 0, 255, "340200", "GDIST", "Grande distribution"),
(3403, 0, 0, 0,  34, 0, 255, "340300", "VPRFR", "Vente de produits frais"),
(3404, 0, 0, 0,  34, 0, 255, "340400", "VCETR", "Vente à la clientèle étrangère"),
(3405, 0, 0, 0,  34, 0, 255, "340500", "VARVS", "Vente d’articles vestimentaires"),
(3406, 0, 0, 0,  34, 0, 255, "340600", "TE-CO", "Technico-commercial"),
(3407, 0, 0, 0,  34, 0, 255, "340700", "VVHOR", "Vente de végétaux horticoles"),
(3408, 0, 0, 0,  34, 0, 255, "340800", "COMGE", "Commercialisation - gestion"),
(3409, 0, 0, 0,  34, 0, 255, "340900", "EXPCT", "Exploitation entrepr com traditionnelle"),
(3410, 0, 0, 0,  34, 0, 255, "341000", "ETOM" , "Étude des offres et marches"),
(3411, 0, 0, 0,  34, 0, 255, "341100", "MARKT", "Marketing études de marchés études de cas"),
(3412, 0, 0, 0,  34, 0, 255, "341200", "FCTCO", "Fonction commerciale"),
(3413, 0, 0, 0,  34, 0, 255, "341300", "ATVTA", "Action vente appliquée"),
(3414, 0, 0, 0,  34, 0, 255, "341400", "T-COM", "Techniques commerciales"),
(3415, 0, 0, 0,  34, 0, 255, "341500", "CMNNE", "Communication et négociation"),
(3416, 0, 0, 0,  34, 0, 255, "341600", "G-CMF", "Gestion ciale et manag force de vente"),
(3417, 0, 0, 0,  34, 0, 255, "341700", "VENTP", "Vente(tp-présentation-expr.-comportement)"),
(3418, 0, 0, 0,  34, 0, 255, "341800", "ATTCA", "Actions technico-commerciales appliquées"),
(3419, 0, 0, 0,  34, 0, 255, "341900", "COMIA", "Commerce international appliqué"),
(3420, 0, 0, 0,  34, 0, 255, "342000", "MT-AC", "Méthodes administratives et commerciales"),
(3421, 0, 0, 0,  34, 0, 255, "342100", "ATCOM", "Action commerciale"),
(3422, 0, 0, 0,  34, 0, 255, "342200", "VLIBR", "Vente en librairie"),
(3423, 0, 0, 0,  34, 0, 255, "342300", "T-TCI", "Technique du commerce international"),
(3424, 0, 0, 0,  34, 0, 255, "342400", "BURCO", "Bureau commercial"),
(3425, 0, 0, 0,  34, 0, 255, "342500", "N-COM", "Enseignement commercial"),
(3426, 0, 0, 0,  34, 0, 255, "342600", "MQNEG", "Mercatique et négociation"),
(3427, 0, 0, 0,  34, 0, 255, "342700", "ANTCO", "Analyse technico-commerciale"),
(3428, 0, 0, 0,  34, 0, 255, "342800", "OU-GC", "Outils de gestion commerciale"),
(3429, 0, 0, 0,  34, 0, 255, "342900", "MERCA", "Mercatique"),
(3430, 0, 0, 0,  34, 0, 255, "343000", "SERVC", "Service et commercialisation"),
(3431, 0, 0, 0,  34, 0, 255, "343100", "APRSE", "Approfondissement sectoriel"),
(3432, 0, 0, 0,  34, 0, 255, "343200", "AIVPF", "Aide à la vie professionnelle"),
(3433, 0, 0, 0,  34, 0, 255, "343300", "MQNMI", "Mercatique négociation - management international"),
(3434, 0, 0, 0,  34, 0, 255, "343400", "AIPAR", "Aide au partenariat"),
(3435, 0, 0, 0,  34, 0, 255, "343500", "ATCOC", "Action et communication commerciales"),
(3436, 0, 0, 0,  34, 0, 255, "343600", "VPAMT", "Vente produits arts maison table"),
(3437, 0, 0, 0,  34, 0, 255, "343700", "ANIML", "Animalerie"),
(3438, 0, 0, 0,  34, 0, 255, "343800", "AGTCC", "Agent commercial de conduite"),
(3439, 0, 0, 0,  34, 0, 255, "343900", "VDISQ", "Vente de disques et produits assimiles"),
(3440, 0, 0, 0,  34, 0, 255, "344000", "VCLAV", "Vente claviers électronique - informatique musicale"),
(3441, 0, 0, 0,  34, 0, 255, "344100", "VBRUN", "Vente de produits bruns"),
(3442, 0, 0, 0,  34, 0, 255, "344200", "G-COM", "Gestion commerciale"),
(3443, 0, 0, 0,  34, 0, 255, "344300", "VHABT", "Vente de produits de l’habitat"),
(3444, 0, 0, 0,  34, 0, 255, "344400", "VTVIN", "Vente de vin"),
(3445, 0, 0, 0,  34, 0, 255, "344500", "CPSMB", "Commerc prdts serv micro-inform bureautq"),
(3446, 0, 0, 0,  34, 0, 255, "344600", "VTPBF", "Vente produits bancaires et financiers"),
(3447, 0, 0, 0,  34, 0, 255, "344700", "VTPAA", "Vente de produits agroalimentaires"),
(3448, 0, 0, 0,  34, 0, 255, "344800", "CPTOU", "Commercialisation de produits touristiques"),
(3449, 0, 0, 0,  34, 0, 255, "344900", "MGUCO", "Management gestion unités commerciales"),
(3450, 0, 0, 0,  34, 0, 255, "345000", "GRCOM", "Gestion de la relation commerciale"),
(3451, 0, 0, 0,  34, 0, 255, "345100", "DUNCO", "Développement de l’unité commerciale"),
(3452, 0, 0, 0,  34, 0, 255, "345200", "G-CLI", "Gestion de clientèles"),
(3453, 0, 0, 0,  34, 0, 255, "345300", "RELCL", "Relation client"),
(3454, 0, 0, 0,  34, 0, 255, "345400", "MEQCO", "Management de l’équipe commerciale"),
(3455, 0, 0, 0,  34, 0, 255, "345500", "GPROJ", "Gestion de projet"),
(3456, 0, 0, 0,  34, 0, 255, "345600", "DCLIE", "Développement de clientèles"),
(3457, 0, 0, 0,  34, 0, 255, "345700", "MANCO", "Management commercial"),
(3458, 0, 0, 0,  34, 0, 255, "345800", "EVDME", "Étude et veille des marches étrangers"),
(3459, 0, 0, 0,  34, 0, 255, "345900", "PSCLI", "Prospection et suivi de clientèle"),
(3460, 0, 0, 0,  34, 0, 255, "346000", "NEGOV", "Négociation vente"),
(3461, 0, 0, 0,  34, 0, 255, "346100", "GOPIE", "Gestion des ope rations d’import-export"),
(3462, 0, 0, 0,  34, 0, 255, "346200", "GRSER", "Gestion de la relation de service"),
(3463, 0, 0, 0,  34, 0, 255, "346300", "ARELC", "Atelier relations commerciales"),
(3464, 0, 0, 0,  34, 0, 255, "346400", "RELCF", "Relation avec la clientèle & les fournisseurs"),
(3465, 0, 0, 0,  34, 0, 255, "346500", "MANEC", "Management de l’entité commerciale"),
(3466, 0, 0, 0,  34, 0, 255, "346600", "VPSCP", "Mise en valeur prod. et serv. et comm. publiciaire"),
(3467, 0, 0, 0,  34, 0, 255, "346700", "TNERC", "Technique de négociation relation client"),
(3468, 0, 0, 0,  34, 0, 255, "346800", "TECOM", "Technologies commerciales"),
(3469, 0, 0, 0,  34, 0, 255, "346900", "IMSMA", "Image et mise en scène de la marque"),
(3470, 0, 0, 0,  34, 0, 255, "347000", "DSACC", "Développement & suivi de l’activité commerciale"),
(3471, 0, 0, 0,  34, 0, 255, "347100", "MAGRH", "Management gestion des ressources humaines"),
(3472, 0, 0, 0,  34, 0, 255, "347200", "MERMA", "Mercatique (marketing)"),
(3473, 0, 0, 0,  34, 0, 255, "347300", "VDECO", "Vente et développement commercial"),
(3474, 0, 0, 0,  34, 0, 255, "347400", "VDMAG", "Vente distribution magasinage"),
(3475, 0, 0, 0,  34, 0, 255, "347500", "MERGA", "Mercatique et gestion appliquée"),
(3476, 0, 0, 0,  34, 0, 255, "347600", "DRCVC", "Développement de la relation client et vente conseil"),
(3477, 0, 0, 0,  34, 0, 255, "347700", "ADOCO", "Animation et dynamisation de l’offre commerciale"),
(3478, 0, 0, 0,  34, 0, 255, "347800", "GESOP", "Gestion opérationnelle"),
(3479, 0, 0, 0,  34, 0, 255, "347900", "MAEQC", "Management de l’équipe commerciale"),
(3480, 0, 0, 0,  34, 0, 255, "348000", "PPRET", "Parcours de professionnalisation à l’étranger"),
(3499, 0, 0, 0,  34, 0, 255, "349900", "E-GSD", "Économie et gestion divers"),

-- 35 Bureautique et secrétariat

(3501, 0, 0, 0,  35, 0, 255, "350100", "SDSCI", "Secrétariat et documentation scientifique"),
(3502, 0, 0, 0,  35, 0, 255, "350200", "CORES", "Correspondance"),
(3503, 0, 0, 0,  35, 0, 255, "350300", "SAIDO", "Saisie données"),
(3504, 0, 0, 0,  35, 0, 255, "350400", "CORRA", "Correspondance et rapport"),
(3505, 0, 0, 0,  35, 0, 255, "350500", "T-SEC", "Techniques de secrétariat"),
(3506, 0, 0, 0,  35, 0, 255, "350600", "BURTQ", "Bureautique"),
(3507, 0, 0, 0,  35, 0, 255, "350700", "UCLAV", "Utilisation des claviers"),
(3508, 0, 0, 0,  35, 0, 255, "350800", "DACTL", "Dactylographie"),
(3509, 0, 0, 0,  35, 0, 255, "350900", "PRPAR", "Prise rapide de la parole"),
(3510, 0, 0, 0,  35, 0, 255, "351000", "STENO", "Sténographie"),
(3511, 0, 0, 0,  35, 0, 255, "351100", "SCTLA", "Secrétariat en langue étrangère A"),
(3512, 0, 0, 0,  35, 0, 255, "351200", "SCTLB", "Secrétariat en langue étrangère B"),
(3513, 0, 0, 0,  35, 0, 255, "351300", "T-BSE", "Techniques de base du secrétariat"),
(3514, 0, 0, 0,  35, 0, 255, "351400", "BUREA", "Bureau"),
(3515, 0, 0, 0,  35, 0, 255, "351500", "MA1BU", "Module d’approfond. 1 (bureautique)"),
(3516, 0, 0, 0,  35, 0, 255, "351600", "MA2BU", "Module d’approfond. 2 (bureautique)"),
(3517, 0, 0, 0,  35, 0, 255, "351700", "I-OUB", "Initiation aux outils de la bureautique"),
(3518, 0, 0, 0,  35, 0, 255, "351800", "MTPCP", "Méthode pratique de communication professionnelle"),
(3519, 0, 0, 0,  35, 0, 255, "351900", "O-GES", "Organisation et gestion"),
(3520, 0, 0, 0,  35, 0, 255, "352000", "MTACP", "Méthodologie action et conduite projets"),
(3521, 0, 0, 0,  35, 0, 255, "352100", "CMNLF", "Communic profess secret langue française"),
(3522, 0, 0, 0,  35, 0, 255, "352200", "CMNLE", "Communic profess secret langues étrangères"),
(3523, 0, 0, 0,  35, 0, 255, "352300", "O-GAI", "Organisation gest. activ. nationale internationale"),
(3524, 0, 0, 0,  35, 0, 255, "352400", "ATPRO", "Actions professionnelles"),
(3525, 0, 0, 0,  35, 0, 255, "352500", "AIVPR", "Aide à la vie professionnelle"),
(3526, 0, 0, 0,  35, 0, 255, "352600", "RATTR", "Rattrapage (enseignement professionnel)"),
(3599, 0, 0, 0,  35, 0, 255, "359900", "BRTSD", "Bureautique et secrétariat divers"),

-- 36 Droit et législation

(3601, 0, 0, 0,  36, 0, 255, "360100", "ITDRE", "Introduction au droit de l’entreprise"),
(3602, 0, 0, 0,  36, 0, 255, "360200", "DR-VG", "Droit - vie et gestion des entreprises"),
(3603, 0, 0, 0,  36, 0, 255, "360300", "LGSET", "Législation et sécurité du travail"),
(3604, 0, 0, 0,  36, 0, 255, "360400", "E-GDR", "Économie - gestion et droit"),
(3605, 0, 0, 0,  36, 0, 255, "360500", "DR-LS", "Droit - législation sociale - organisation du travail"),
(3606, 0, 0, 0,  36, 0, 255, "360600", "DR-TR", "Droit du travail"),
(3607, 0, 0, 0,  36, 0, 255, "360700", "LDTSS", "Législation - drt travail santé securité-travail"),
(3608, 0, 0, 0,  36, 0, 255, "360800", "DR-TP", "Droit en travaux publics"),
(3609, 0, 0, 0,  36, 0, 255, "360900", "LEGIS", "Législation"),
(3610, 0, 0, 0,  36, 0, 255, "361000", "LGSPA", "Législation - sécurité - prévention accident"),
(3611, 0, 0, 0,  36, 0, 255, "361100", "DR-TL", "Droit travail - législation sociale - org. de l’entreprise"),
(3612, 0, 0, 0,  36, 0, 255, "361200", "RJCTC", "Relations juridiques crédit travail contentieux"),
(3613, 0, 0, 0,  36, 0, 255, "361300", "AECJS", "Actualité économique juridique et sociale"),
(3614, 0, 0, 0,  36, 0, 255, "361400", "G-ELT", "Gestion entreprises - législation travail"),
(3615, 0, 0, 0,  36, 0, 255, "361500", "LGRGS", "Législation - règlementation - sécurité"),
(3616, 0, 0, 0,  36, 0, 255, "361600", "DR-SF", "Droit des sociétés - droit fiscal"),
(3617, 0, 0, 0,  36, 0, 255, "361700", "PGXDR", "Principes généraux du droit"),
(3618, 0, 0, 0,  36, 0, 255, "361800", "LGDEO", "Législation déontologie"),
(3619, 0, 0, 0,  36, 0, 255, "361900", "LGTRA", "Législation du travail"),
(3620, 0, 0, 0,  36, 0, 255, "362000", "DROIT", "Droit"),
(3621, 0, 0, 0,  36, 0, 255, "362100", "I-JUR", "Initiation juridique"),
(3622, 0, 0, 0,  36, 0, 255, "362200", "DR-FI", "Droit fiscal"),
(3623, 0, 0, 0,  36, 0, 255, "362300", "DR-LG", "Droit législatif"),
(3624, 0, 0, 0,  36, 0, 255, "362400", "DR-SO", "Droit social"),
(3625, 0, 0, 0,  36, 0, 255, "362500", "I-DCI", "Initiation au droit civil"),
(3626, 0, 0, 0,  36, 0, 255, "362600", "I-DCO", "Initiation au droit commercial"),
(3627, 0, 0, 0,  36, 0, 255, "362700", "E-GLG", "Économie gestion législation"),
(3628, 0, 0, 0,  36, 0, 255, "362800", "DR-CC", "Droit civil et commercial"),
(3629, 0, 0, 0,  36, 0, 255, "362900", "DR-AP", "Droit appliqué"),
(3630, 0, 0, 0,  36, 0, 255, "363000", "LGECO", "Législation et économie"),
(3631, 0, 0, 0,  36, 0, 255, "363100", "LGOST", "Législation et org scient du travail"),
(3632, 0, 0, 0,  36, 0, 255, "363200", "ATSIN", "Action sociale et institutions"),
(3633, 0, 0, 0,  36, 0, 255, "363300", "ASPPS", "Aspects psychosociaux et juridiques"),
(3634, 0, 0, 0,  36, 0, 255, "363400", "I-EJU", "Initiation économique et juridique"),
(3635, 0, 0, 0,  36, 0, 255, "363500", "DIMJE", "Dimension juridico-économique"),
(3636, 0, 0, 0,  36, 0, 255, "363600", "GREGE", "Gr (ent-gest - eco gen - e ent - droit social)"),
(3637, 0, 0, 0,  36, 0, 255, "363700", "LGEGE", "Législation - économie - gestion entreprise"),
(3638, 0, 0, 0,  36, 0, 255, "363800", "LGTRS", "Législation du travail et sécurité"),
(3639, 0, 0, 0,  36, 0, 255, "363900", "DR-DA", "Droit général et droit des assurances"),
(3640, 0, 0, 0,  36, 0, 255, "364000", "RGLTT", "Règlement et legis transports tourisme"),
(3641, 0, 0, 0,  36, 0, 255, "364100", "DR-CI", "Droit civil"),
(3642, 0, 0, 0,  36, 0, 255, "364200", "DR-CO", "Droit commercial"),
(3643, 0, 0, 0,  36, 0, 255, "364300", "SMSBU", "Sciences médico-sociales et bureautique"),
(3644, 0, 0, 0,  36, 0, 255, "364400", "DRGIM", "Droit général de l’immobilier"),
(3645, 0, 0, 0,  36, 0, 255, "364500", "DGSMQ", "Droit - gestion et mercatique appliquée"),
(3646, 0, 0, 0,  36, 0, 255, "364600", "DRTPR", "Droit professionnel"),
(3647, 0, 0, 0,  36, 0, 255, "364700", "DRSOC", "Droit des sociétés"),
(3648, 0, 0, 0,  36, 0, 255, "364800", "VEJEC", "Vie eco.jurid. de l’entrep. Commercialisation"),
(3649, 0, 0, 0,  36, 0, 255, "364900", "CASVQ", "Cadre pol jur act soc vie quotidienne"),
(3650, 0, 0, 0,  36, 0, 255, "365000", "INTDT", "Introduction au droit"),
(3651, 0, 0, 0,  36, 0, 255, "365100", "INRES", "Institutions et réseaux"),
(3652, 0, 0, 0,  36, 0, 255, "365200", "EEJMA", "Environ.eco.jur.& manager.de l’assurance"),
(3653, 0, 0, 0,  36, 0, 255, "365300", "DG-DN", "Droit général et droit notarial"),
(3654, 0, 0, 0,  36, 0, 255, "365400", "T-NOT", "Techniques du notariat"),
(3655, 0, 0, 0,  36, 0, 255, "365500", "APA-N", "Activités prof. appliquées (notariat)"),
(3656, 0, 0, 0,  36, 0, 255, "365600", "OIRAE", "Organisat.indust.&règlement.aéronautique"),
(3657, 0, 0, 0,  36, 0, 255, "365700", "DGEMC", "Droit et grands enjeux du monde contemporain"),
(3658, 0, 0, 0,  36, 0, 255, "365800", "DRAPP", "Droit approfondi"),
(3659, 0, 0, 0,  36, 0, 255, "365900", "ENVEJ", "Environnement économique et juridique"),
(3660, 0, 0, 0,  36, 0, 255, "366000", "COJAT", "Cadre organisationnel juridique activité touristique"),
(3661, 0, 0, 0,  36, 0, 255, "366100", "DR-VD", "Droit et veille juridique"),
(3662, 0, 0, 0,  36, 0, 255, "366200", "ETUOS", "Environnement de travail : outil stratégique"),
(3663, 0, 0, 0,  36, 0, 255, "366300", "EVENP", "Évolution de l’environnement professionnel"),
(3664, 0, 0, 0,  36, 0, 255, "366400", "DRECO", "Document. règlement. expert. cosmetovig."),
(3665, 0, 0, 0,  36, 0, 255, "366500", "EEJME", "Environnement économ., juridique & manager. édition"),
(3666, 0, 0, 0,  36, 0, 255, "366600", "EEJOB", "Environnement économ., juridique & organis. activité bancaire"),
(3667, 0, 0, 0,  36, 0, 255, "366700", "ENVPR", "Environnement professionnel"),
(3668, 0, 0, 0,  36, 0, 255, "366800", "DROEC", "Droit et économie"),
(3669, 0, 0, 0,  36, 0, 255, "366900", "EDESV", "Économie, droit et environnement du spectacle vivant"),
(3670, 0, 0, 0,  36, 0, 255, "367000", "ENEJM", "Environnement économique, juridique et management"),
(3671, 0, 0, 0,  36, 0, 255, "367100", "DCDRS", "Droit civil et droit des sociétés"),
(3672, 0, 0, 0,  36, 0, 255, "367200", "DRPUB", "Droit public"),
(3673, 0, 0, 0,  36, 0, 255, "367300", "FONDR", "Fondamentaux du droit"),
(3674, 0, 0, 0,  36, 0, 255, "367400", "DRSGA", "Droit des sociétés et des groupements d’affaires"),
(3699, 0, 0, 0,  36, 0, 255, "369900", "DR-LD", "Droit et législation divers"),

-- 37 Informatique de gestion

(3701, 0, 0, 0,  37, 0, 255, "370100", "MA-GI", "Maths appliquées - outils gestion - informatique"),
(3702, 0, 0, 0,  37, 0, 255, "370200", "APINF", "Applications informatiques"),
(3703, 0, 0, 0,  37, 0, 255, "370300", "TTDON", "Traitement des données"),
(3704, 0, 0, 0,  37, 0, 255, "370400", "ECOSI", "Enseignement commun (si)"),
(3705, 0, 0, 0,  37, 0, 255, "370500", "TECIF", "Technologies informatiques"),
(3706, 0, 0, 0,  37, 0, 255, "370600", "G-INF", "Gestion et informatique"),
(3707, 0, 0, 0,  37, 0, 255, "370700", "STT"  , "Sciences et technologies tertiaires"),
(3708, 0, 0, 0,  37, 0, 255, "370800", "NEGIF", "Négociations informatiques"),
(3709, 0, 0, 0,  37, 0, 255, "370900", "ALGLG", "Algorithme et langages"),
(3710, 0, 0, 0,  37, 0, 255, "371000", "TXAIN", "Travaux d’application d’informat."),
(3711, 0, 0, 0,  37, 0, 255, "371100", "G-AMG", "Gestion et application math à la gestion"),
(3712, 0, 0, 0,  37, 0, 255, "371200", "IFOSI", "Informatique organisat syst information"),
(3713, 0, 0, 0,  37, 0, 255, "371300", "ANOIF", "Analyse organisation - informatisation"),
(3714, 0, 0, 0,  37, 0, 255, "371400", "IFAPG", "Informatique appliquée à la gestion"),
(3715, 0, 0, 0,  37, 0, 255, "371500", "ITAGM", "Informat telemat appli gest mercatique"),
(3716, 0, 0, 0,  37, 0, 255, "371600", "APROF", "Approfondissements"),
(3717, 0, 0, 0,  37, 0, 255, "371700", "OU-GI", "Outils de gestion et informatique appli"),
(3718, 0, 0, 0,  37, 0, 255, "371800", "IFGES", "Informatique et gestion"),
(3719, 0, 0, 0,  37, 0, 255, "371900", "IUMLI", "Init utilis mater - logic informatique de l’ets"),
(3720, 0, 0, 0,  37, 0, 255, "372000", "AMSIQ", "Architecture matérielle systèmes informatiques"),
(3721, 0, 0, 0,  37, 0, 255, "372100", "ALSIQ", "Architecture logicielle systèmes informatiques"),
(3722, 0, 0, 0,  37, 0, 255, "372200", "DAIGL", "Dvlpt applications informatiques génie logiciel"),
(3723, 0, 0, 0,  37, 0, 255, "372300", "ACPIG", "Actions professionnelles (informatique gestion)"),
(3724, 0, 0, 0,  37, 0, 255, "372400", "IFGCM", "Informatique de gestion et communication"),
(3725, 0, 0, 0,  37, 0, 255, "372500", "CEIPE", "Connaissance de l’entreprise init. pratique informatique"),
(3726, 0, 0, 0,  37, 0, 255, "372600", "IFCOM", "Informatique commerciale"),
(3727, 0, 0, 0,  37, 0, 255, "372700", "GSYSI", "Gestion du système d’information"),
(3728, 0, 0, 0,  37, 0, 255, "372800", "ALGOA", "Algorithmique appliquée"),
(3729, 0, 0, 0,  37, 0, 255, "372900", "AEMJI", "An.eco.manager.jurid. services informatiques"),
(3730, 0, 0, 0,  37, 0, 255, "373000", "MTINF", "Méthodes et techniques informatiques"),
(3731, 0, 0, 0,  37, 0, 255, "373100", "ISCNU", "Informatique et sciences du numérique"),
(3732, 0, 0, 0,  37, 0, 255, "373200", "SIGET", "Systèmes d’information de gestion"),
(3733, 0, 0, 0,  37, 0, 255, "373300", "SYSIG", "Système d’information de gestion"),
(3734, 0, 0, 0,  37, 0, 255, "373400", "SISR" , "Solutions d’infrastructure, systèmes et réseaux"),
(3735, 0, 0, 0,  37, 0, 255, "373500", "SLAM" , "Solutions logicielles et applications métiers"),
(3736, 0, 0, 0,  37, 0, 255, "373600", "PRPEN", "Projets personnalisés encadrés"),
(3737, 0, 0, 0,  37, 0, 255, "373700", "ICN"  , "Informatique et création numérique"),
(3799, 0, 0, 0,  37, 0, 255, "379900", "IFGSD", "Informatique de gestion divers"),

-- 38 Économie

(3801, 0, 0, 0,  38, 0, 255, "380100", "E-TRU", "Économie de la construction"),
(3802, 0, 0, 0,  38, 0, 255, "380200", "DOMEC", "Domaine économique"),
(3803, 0, 0, 0,  38, 0, 255, "380300", "E-GCG", "Économie et gestion/conjoint"),
(3804, 0, 0, 0,  38, 0, 255, "380400", "E-OGS", "Économie et gestion"),
(3805, 0, 0, 0,  38, 0, 255, "380500", "E-TKG", "Économie et techniques de gestion"),
(3806, 0, 0, 0,  38, 0, 255, "380600", "E-OGN", "Économie générale"),
(3807, 0, 0, 0,  38, 0, 255, "380700", "E-VIE", "Économie - vie des entreprises"),
(3808, 0, 0, 0,  38, 0, 255, "380800", "E-ONO", "Économie"),
(3809, 0, 0, 0,  38, 0, 255, "380900", "PBECO", "Problèmes économiques"),
(3810, 0, 0, 0,  38, 0, 255, "381000", "E-DRT", "Économie et droit"),
(3811, 0, 0, 0,  38, 0, 255, "381100", "EVEJU", "Environnement économique et juridique"),
(3812, 0, 0, 0,  38, 0, 255, "381200", "CFOEC", "Complément de formation économique"),
(3813, 0, 0, 0,  38, 0, 255, "381300", "E-GEE", "Économie générale et eco d’entreprise"),
(3814, 0, 0, 0,  38, 0, 255, "381400", "E-EED", "Économie générale - eco entreprise droit"),
(3815, 0, 0, 0,  38, 0, 255, "381500", "APRMT", "Approfondissement méthodologique"),
(3816, 0, 0, 0,  38, 0, 255, "381600", "HIECO", "Histoire économique"),
(3817, 0, 0, 0,  38, 0, 255, "381700", "ANMPE", "Analyse monétaire politique économique"),
(3818, 0, 0, 0,  38, 0, 255, "381800", "ODOEC", "Option à dominante économique"),
(3819, 0, 0, 0,  38, 0, 255, "381900", "E-TDR", "Économie générale et touristique-droit"),
(3820, 0, 0, 0,  38, 0, 255, "382000", "ECEND", "Économie d’entreprise et droit"),
(3821, 0, 0, 0,  38, 0, 255, "382100", "ETECO", "Études techniques et économiques"),
(3822, 0, 0, 0,  38, 0, 255, "382200", "ENVEC", "Environnement économique"),
(3823, 0, 0, 0,  38, 0, 255, "382300", "PO-EG", "Projet d’ouvrage (économie gestion)"),
(3824, 0, 0, 0,  38, 0, 255, "382400", "ECDBQ", "Économie et droit bancaire"),
(3825, 0, 0, 0,  38, 0, 255, "382500", "DEDPI", "Dimension économique des projet industriel"),
(3826, 0, 0, 0,  38, 0, 255, "382600", "EDTOU", "Économie et droit appliqués au tourisme"),
(3827, 0, 0, 0,  38, 0, 255, "382700", "EGOTR", "Économie gestion organisation du travail"),
(3828, 0, 0, 0,  38, 0, 255, "382800", "EEMNO", "Environ. eco et managerial du notariat"),
(3829, 0, 0, 0,  38, 0, 255, "382900", "ECONS", "Économie - consommation"),
(3830, 0, 0, 0,  38, 0, 255, "383000", "PFEG" , "Principes fondamentaux de l’économie et de la gestion"),
(3831, 0, 0, 0,  38, 0, 255, "383100", "ECOOR", "Économie et organisation"),
(3832, 0, 0, 0,  38, 0, 255, "383200", "CEJUM", "Culture économique, juridique et manageriale"),
(3833, 0, 0, 0,  38, 0, 255, "383300", "ECOGE", "Économie-gestion"),
(3834, 0, 0, 0,  38, 0, 255, "383400", "EC-DR", "Économie-droit"),
(3835, 0, 0, 0,  38, 0, 255, "383500", "RCTOU", "Relation commerciale et tourisme"),
(3836, 0, 0, 0,  38, 0, 255, "383600", "ECOCO", "Économie et commercialisation"),
(3837, 0, 0, 0,  38, 0, 255, "383700", "ECCON", "Économie contemporaine"),
(3838, 0, 0, 0,  38, 0, 255, "383800", "CEJMA", "Culture économique, juridique et managériale appliquée"),
(3899, 0, 0, 0,  38, 0, 255, "389900", "E-ODI", "Économie divers"),

-- 39 Comptabilité - finances

(3901, 0, 0, 0,  39, 0, 255, "390100", "G-FDT", "Gestion financière des travaux"),
(3902, 0, 0, 0,  39, 0, 255, "390200", "G-FIN", "Gestion financière"),
(3903, 0, 0, 0,  39, 0, 255, "390300", "G-CAB", "Gestion - comptabilité analytique-budgétaire"),
(3904, 0, 0, 0,  39, 0, 255, "390400", "MOCTB", "Module élémentaire comptabilité"),
(3905, 0, 0, 0,  39, 0, 255, "390500", "MT-QU", "Méthodes quantitatives"),
(3906, 0, 0, 0,  39, 0, 255, "390600", "CPT-G", "Comptabilité et gestion"),
(3907, 0, 0, 0,  39, 0, 255, "390700", "FIETB", "Financement des entr et techn bancaires"),
(3908, 0, 0, 0,  39, 0, 255, "390800", "CPTTA", "Comptabilité"),
(3909, 0, 0, 0,  39, 0, 255, "390900", "TXSYC", "Travaux de synthèse comptabilité"),
(3910, 0, 0, 0,  39, 0, 255, "391000", "TXSYN", "Travaux de synthèse"),
(3911, 0, 0, 0,  39, 0, 255, "391100", "ETCAS", "Étude de cas"),
(3912, 0, 0, 0,  39, 0, 255, "391200", "TPSYN", "Travaux pratiques de synthèse"),
(3913, 0, 0, 0,  39, 0, 255, "391300", "T-IMM", "Technique de l’immobilier"),
(3914, 0, 0, 0,  39, 0, 255, "391400", "CPT-R", "Comptabilité approfondie et révision"),
(3915, 0, 0, 0,  39, 0, 255, "391500", "G-CFS", "Gestion comptable fiscale et sociale"),
(3916, 0, 0, 0,  39, 0, 255, "391600", "GFPAC", "Gest financ prev analyses contrôle gestion"),
(3917, 0, 0, 0,  39, 0, 255, "391700", "ACTPS", "Activités professionnelles de synthèse"),
(3918, 0, 0, 0,  39, 0, 255, "391800", "MANCI", "Mise à niveau (comptabilité finances informatique)"),
(3919, 0, 0, 0,  39, 0, 255, "391900", "TECBQ", "Techniques bancaires"),
(3920, 0, 0, 0,  39, 0, 255, "392000", "ABQAP", "Actions bancaires appliquées"),
(3921, 0, 0, 0,  39, 0, 255, "392100", "OGACO", "Organisation et gestion administrative et comptable"),
(3922, 0, 0, 0,  39, 0, 255, "392200", "CPTFI", "Comptabilité et finance d’entreprises"),
(3923, 0, 0, 0,  39, 0, 255, "392300", "FINET", "Finance d’entreprise"),
(3924, 0, 0, 0,  39, 0, 255, "392400", "INTCT", "Introduction a la comptabilité"),
(3925, 0, 0, 0,  39, 0, 255, "392500", "CTAPP", "Comptabilité approfondie"),
(3926, 0, 0, 0,  39, 0, 255, "392600", "TGADF", "Techniq. gestion administr. & financière"),
(3927, 0, 0, 0,  39, 0, 255, "392700", "GFACT", "Gestion et financement des actifs"),
(3928, 0, 0, 0,  39, 0, 255, "392800", "PEREN", "Pérennisation de l’entreprise"),
(3929, 0, 0, 0,  39, 0, 255, "392900", "GRISQ", "Gestion du risque"),
(3930, 0, 0, 0,  39, 0, 255, "393000", "P1P2" , "P1 plus P2"),
(3931, 0, 0, 0,  39, 0, 255, "393100", "P3P4" , "P3 plus P4"),
(3932, 0, 0, 0,  39, 0, 255, "393200", "P5P6" , "P5 plus P6"),
(3933, 0, 0, 0,  39, 0, 255, "393300", "P7-"  , "P7"),
(3934, 0, 0, 0,  39, 0, 255, "393400", "ATEPR", "Ateliers professionnels"),
(3935, 0, 0, 0,  39, 0, 255, "393500", "MOPAP", "Module optionnel d’approfondissement"),
(3936, 0, 0, 0,  39, 0, 255, "393600", "AREID", "Accès ressources informatiques & documentaires"),
(3999, 0, 0, 0,  39, 0, 255, "399900", "CPT-F", "Comptabilité - finances divers"),

-- 40 Hôtellerie - tourisme

(4001, 0, 0, 0,  40, 0, 255, "400100", "GGTIC", "Geo gene - touris et itinéraires commerc"),
(4002, 0, 0, 0,  40, 0, 255, "400200", "CUISI", "Cuisine"),
(4003, 0, 0, 0,  40, 0, 255, "400300", "CUITP", "Cuisine (technologie - travaux pratiques)"),
(4004, 0, 0, 0,  40, 0, 255, "400400", "MQTOU", "Mercatique du tourisme"),
(4005, 0, 0, 0,  40, 0, 255, "400500", "T-CUL", "Techniques culinaires"),
(4006, 0, 0, 0,  40, 0, 255, "400600", "ATTOG", "Action touristique générale"),
(4007, 0, 0, 0,  40, 0, 255, "400700", "ATTAA", "Action touristique approfondie appliquée"),
(4008, 0, 0, 0,  40, 0, 255, "400800", "RESTP", "Restaurant(technologie - tp - oenologie)"),
(4009, 0, 0, 0,  40, 0, 255, "400900", "ATTOA", "Action touristique approfondie"),
(4010, 0, 0, 0,  40, 0, 255, "401000", "ATTGA", "Action touristique générale appliquée"),
(4011, 0, 0, 0,  40, 0, 255, "401100", "DCTRP", "Document de transport"),
(4012, 0, 0, 0,  40, 0, 255, "401200", "O-TOU", "Organisation du tourisme"),
(4013, 0, 0, 0,  40, 0, 255, "401300", "E-TOU", "Économie touristique"),
(4015, 0, 0, 0,  40, 0, 255, "401500", "BTARI", "Billetterie et tarification"),
(4016, 0, 0, 0,  40, 0, 255, "401600", "TPAGE", "Travaux pratiques d’agence"),
(4017, 0, 0, 0,  40, 0, 255, "401700", "FRETF", "Fret et trafic"),
(4018, 0, 0, 0,  40, 0, 255, "401800", "DOCUM", "Documentation"),
(4019, 0, 0, 0,  40, 0, 255, "401900", "RESTO", "Restaurant"),
(4020, 0, 0, 0,  40, 0, 255, "402000", "O-PCL", "Organisation et production culinaire"),
(4021, 0, 0, 0,  40, 0, 255, "402100", "T-AHR", "Techniques administratives hôtelières restaur"),
(4022, 0, 0, 0,  40, 0, 255, "402200", "ACPRO", "Activités professionnelles"),
(4023, 0, 0, 0,  40, 0, 255, "402300", "HBGMT", "Hébergement"),
(4024, 0, 0, 0,  40, 0, 255, "402400", "SAHRE", "Sciences app à l’hôtellerie et à la restauration"),
(4025, 0, 0, 0,  40, 0, 255, "402500", "G-HOT", "Gestion hôtelière"),
(4026, 0, 0, 0,  40, 0, 255, "402600", "HOTTP", "Hôtel (technologie - travaux pratiques)"),
(4027, 0, 0, 0,  40, 0, 255, "402700", "T-HOT", "Techniques hôtelières"),
(4028, 0, 0, 0,  40, 0, 255, "402800", "IHOTM", "Ingénierie hôtel et maintenance"),
(4029, 0, 0, 0,  40, 0, 255, "402900", "CAEHT", "Cond animat entreprise hôtelière"),
(4030, 0, 0, 0,  40, 0, 255, "403000", "TECCU", "Technologie culinaire"),
(4031, 0, 0, 0,  40, 0, 255, "403100", "PR-CG", "Pratique de la conduite des groupes"),
(4032, 0, 0, 0,  40, 0, 255, "403200", "PUBED", "Publicité édition"),
(4033, 0, 0, 0,  40, 0, 255, "403300", "O-STT", "Organisation de la station"),
(4034, 0, 0, 0,  40, 0, 255, "403400", "T-HEB", "Technique de l’hébergement"),
(4035, 0, 0, 0,  40, 0, 255, "403500", "O-SEJ", "Organisation des séjours"),
(4036, 0, 0, 0,  40, 0, 255, "403600", "E-GTL", "Économie gest entre et org tour loisir"),
(4037, 0, 0, 0,  40, 0, 255, "403700", "RSOHU", "Relations sociales et humaines"),
(4038, 0, 0, 0,  40, 0, 255, "403800", "T-HCP", "Techniques accueil heberg communication prof"),
(4039, 0, 0, 0,  40, 0, 255, "403900", "ACMPR", "Activités et manifestations professionnelles"),
(4040, 0, 0, 0,  40, 0, 255, "404000", "SCTEC", "Sciences appliquées et technologie"),
(4041, 0, 0, 0,  40, 0, 255, "404100", "PCTRG", "Patrimoine culturel et tourist régional"),
(4042, 0, 0, 0,  40, 0, 255, "404200", "TOURQ", "Tourismatique"),
(4043, 0, 0, 0,  40, 0, 255, "404300", "DVTOU", "Développement touristique"),
(4044, 0, 0, 0,  40, 0, 255, "404400", "EVTOU", "Environnement touristique"),
(4045, 0, 0, 0,  40, 0, 255, "404500", "NGTOU", "Négociation touristique"),
(4046, 0, 0, 0,  40, 0, 255, "404600", "CCTOU", "Concep commerc produits touristiques syst infq"),
(4047, 0, 0, 0,  40, 0, 255, "404700", "AAPRO", "Accueil animation professionnels"),
(4048, 0, 0, 0,  40, 0, 255, "404800", "ACSPE", "Accueil de touristes à besoins spécifiques"),
(4049, 0, 0, 0,  40, 0, 255, "404900", "OTRLV", "Organisation et technique de la réception"),
(4050, 0, 0, 0,  40, 0, 255, "405000", "ASPAT", "Analyse spatiale appliquée au tourisme"),
(4051, 0, 0, 0,  40, 0, 255, "405100", "MGAOT", "Mercatique gestion appliquée organisation touristique"),
(4052, 0, 0, 0,  40, 0, 255, "405200", "TCTOU", "Techniques touristiques"),
(4053, 0, 0, 0,  40, 0, 255, "405300", "APTOU", "Action professionnelle touristique"),
(4054, 0, 0, 0,  40, 0, 255, "405400", "MPTOU", "Mercatique et productions touristiques"),
(4055, 0, 0, 0,  40, 0, 255, "405500", "GTMED", "Gestion de projet touristique multimédia"),
(4056, 0, 0, 0,  40, 0, 255, "405600", "OTETA", "Organisation et technique des étages"),
(4057, 0, 0, 0,  40, 0, 255, "405700", "MERTC", "Mercatique et techniques de commercialisation"),
(4058, 0, 0, 0,  40, 0, 255, "405800", "SAAHE", "Sciences appliquées alimentation hygiène environnement"),
(4059, 0, 0, 0,  40, 0, 255, "405900", "TTERR", "Tourisme et territoires"),
(4060, 0, 0, 0,  40, 0, 255, "406000", "MCPT" , "Mercatique conception prestation touristique"),
(4061, 0, 0, 0,  40, 0, 255, "406100", "ECGEH", "Économie-gestion hôtelière"),
(4062, 0, 0, 0,  40, 0, 255, "406200", "PRSTC", "Projet sthr (sciences & technologies culinaires)"),
(4063, 0, 0, 0,  40, 0, 255, "406300", "PRSTS", "Projet sthr (sciences & technologies des services)"),
(4064, 0, 0, 0,  40, 0, 255, "406400", "SCTES", "Sciences et technologies des services"),
(4065, 0, 0, 0,  40, 0, 255, "406500", "STECU", "Sciences et technologies culinaires"),
(4066, 0, 0, 0,  40, 0, 255, "406600", "ESALE", "Enseignement scientifique alimentation-environnement"),
(4067, 0, 0, 0,  40, 0, 255, "406700", "MAEHR", "Management d’une entreprise d’hôtellerie-restauration"),
(4068, 0, 0, 0,  40, 0, 255, "406800", "SCTCS", "Sciences et technologies culinaires et des services"),
(4069, 0, 0, 0,  40, 0, 255, "406900", "CSAEN", "Sciences et technologies culinaires & services-E.S.A.E."),
(4070, 0, 0, 0,  40, 0, 255, "407000", "GERCT", "Gestion de la relation clientèle touristique"),
(4071, 0, 0, 0,  40, 0, 255, "407100", "ELPRT", "Élaboration d’une prestation touristique"),
(4099, 0, 0, 0,  40, 0, 255, "409900", "HOTDI", "Hôtellerie tourisme divers"),

-- 41 Communication

(4101, 0, 0, 0,  41, 0, 255, "410100", "T-INF", "Techniques d’information"),
(4102, 0, 0, 0,  41, 0, 255, "410200", "T-ANG", "Techniques d’animation de groupes"),
(4103, 0, 0, 0,  41, 0, 255, "410300", "DEXPI", "Discipline d’expression et d’information"),
(4104, 0, 0, 0,  41, 0, 255, "410400", "T-COA", "Technique de communication - d’animation"),
(4105, 0, 0, 0,  41, 0, 255, "410500", "CMNPO", "Communication professio orale et écrite"),
(4106, 0, 0, 0,  41, 0, 255, "410600", "EX-CM", "Expression communication"),
(4107, 0, 0, 0,  41, 0, 255, "410700", "CMNCA", "Communication"),
(4108, 0, 0, 0,  41, 0, 255, "410800", "MT-TG", "Méthodes et techniques graphiques communication"),
(4109, 0, 0, 0,  41, 0, 255, "410900", "EDTKC", "Edition et techniques de communication"),
(4110, 0, 0, 0,  41, 0, 255, "411000", "FR-TC", "Français et techniques de communication"),
(4111, 0, 0, 0,  41, 0, 255, "411100", "CMNCI", "Communication et civilisation"),
(4112, 0, 0, 0,  41, 0, 255, "411200", "OU-TC", "Outils et techniques de communication"),
(4113, 0, 0, 0,  41, 0, 255, "411300", "DIMPF", "Dimension professionnelle"),
(4114, 0, 0, 0,  41, 0, 255, "411400", "DIMPS", "Dimension psychologique et sociologique"),
(4115, 0, 0, 0,  41, 0, 255, "411500", "SHUTE", "Sciences humaines et techniques d’expression"),
(4116, 0, 0, 0,  41, 0, 255, "411600", "AP-TI", "Atelier de pratique:techn info comm"),
(4117, 0, 0, 0,  41, 0, 255, "411700", "CMNOR", "Communication et organisation"),
(4118, 0, 0, 0,  41, 0, 255, "411800", "ATCOA", "Action et communication administratives"),
(4119, 0, 0, 0,  41, 0, 255, "411900", "EVISP", "Expression visuelle et production"),
(4120, 0, 0, 0,  41, 0, 255, "412000", "ERACO", "Études recherches appliquées à la communication"),
(4121, 0, 0, 0,  41, 0, 255, "412100", "STCOE", "Stratégie de communication des entreprises"),
(4122, 0, 0, 0,  41, 0, 255, "412200", "CTCOM", "Conception et technique de communication"),
(4123, 0, 0, 0,  41, 0, 255, "412300", "CMGRH", "Communication gestion ressources humaines"),
(4124, 0, 0, 0,  41, 0, 255, "412400", "TECIC", "Technologie informatique et de communication"),
(4125, 0, 0, 0,  41, 0, 255, "412500", "TINFC", "Technologie information et communication"),
(4126, 0, 0, 0,  41, 0, 255, "412600", "COTCO", "Communication techniques commerciales"),
(4127, 0, 0, 0,  41, 0, 255, "412700", "TOIFA", "Techniques d’org techniq info formation animation"),
(4128, 0, 0, 0,  41, 0, 255, "412800", "OUCOT", "Outils de la communication technique"),
(4129, 0, 0, 0,  41, 0, 255, "412900", "COMTC", "Communication commerciale et technique"),
(4130, 0, 0, 0,  41, 0, 255, "413000", "GCLCP", "Gestion clientèle communication profes"),
(4131, 0, 0, 0,  41, 0, 255, "413100", "SEMEC", "Sémiologie espace et  communication"),
(4132, 0, 0, 0,  41, 0, 255, "413200", "CP-LN", "Communication professionnelle en langue nationale"),
(4133, 0, 0, 0,  41, 0, 255, "413300", "INFCO", "Information et communication"),
(4134, 0, 0, 0,  41, 0, 255, "413400", "INFGE", "Information et gestion"),
(4135, 0, 0, 0,  41, 0, 255, "413500", "COMAN", "Communication animation"),
(4136, 0, 0, 0,  41, 0, 255, "413600", "TICOP", "Techniq.information & communication prof"),
(4137, 0, 0, 0,  41, 0, 255, "413700", "COGRC", "Communication & gestion relation client"),
(4138, 0, 0, 0,  41, 0, 255, "413800", "CMAIC", "Communication  management interculturels"),
(4139, 0, 0, 0,  41, 0, 255, "413900", "INFOR", "Information"),
(4140, 0, 0, 0,  41, 0, 255, "414000", "ANCOM", "Analyse et communication"),
(4141, 0, 0, 0,  41, 0, 255, "414100", "PJCOM", "Projet de communication"),
(4142, 0, 0, 0,  41, 0, 255, "414200", "CONSA", "Conseil et relation annonceur"),
(4143, 0, 0, 0,  41, 0, 255, "414300", "VEILO", "Veille opérationnelle"),
(4144, 0, 0, 0,  41, 0, 255, "414400", "APROD", "Atelier production"),
(4145, 0, 0, 0,  41, 0, 255, "414500", "ANIMF", "Techniques d’animation et de formation"),
(4146, 0, 0, 0,  41, 0, 255, "414600", "CPUBL", "Connaissances des publics"),
(4147, 0, 0, 0,  41, 0, 255, "414700", "COMEO", "Communication écrite et orale"),
(4148, 0, 0, 0,  41, 0, 255, "414800", "DESCV", "Design de communication visuelle"),
(4149, 0, 0, 0,  41, 0, 255, "414900", "COMTK", "Communication technique"),
(4150, 0, 0, 0,  41, 0, 255, "415000", "PRJCO", "Projet de communication"),
(4151, 0, 0, 0,  41, 0, 255, "415100", "TPIII", "Travail partenariat instut.et interinsti"),
(4152, 0, 0, 0,  41, 0, 255, "415200", "COPRO", "Communication professionnelle"),
(4153, 0, 0, 0,  41, 0, 255, "415300", "DYPAR", "Implications ds dynamiques partenariales"),
(4154, 0, 0, 0,  41, 0, 255, "415400", "GRCLI", "Gestion de la relation client"),
(4155, 0, 0, 0,  41, 0, 255, "415500", "GINFT", "Gestion de l’information touristique"),
(4156, 0, 0, 0,  41, 0, 255, "415600", "IMMED", "Information et multimedias"),
(4157, 0, 0, 0,  41, 0, 255, "415700", "ITOUR", "Information et tourismatique"),
(4158, 0, 0, 0,  41, 0, 255, "415800", "CCOMM", "Culture de la communication"),
(4159, 0, 0, 0,  41, 0, 255, "415900", "MEMOC", "Méthodes et moyens de communication"),
(4160, 0, 0, 0,  41, 0, 255, "416000", "PROCC", "Promotion et communication commerciale"),
(4161, 0, 0, 0,  41, 0, 255, "416100", "TEFAP", "Technique de formation, d’animation de promotion"),
(4162, 0, 0, 0,  41, 0, 255, "416200", "ERPED", "Étude & réalisation de projets d’édition"),
(4163, 0, 0, 0,  41, 0, 255, "416300", "CTMAN", "Communication & techniques de management"),
(4164, 0, 0, 0,  41, 0, 255, "416400", "CTECO", "Communication technique et commerciale"),
(4165, 0, 0, 0,  41, 0, 255, "416500", "OAEXC", "Outils analyse expression et communication"),
(4166, 0, 0, 0,  41, 0, 255, "416600", "RHCOM", "Ressources humaines et communication"),
(4167, 0, 0, 0,  41, 0, 255, "416700", "RCLSI", "Relation client sinistres"),
(4199, 0, 0, 0,  41, 0, 255, "419900", "CMNDV", "Communication divers"),

-- 42 Assurances

(4201, 0, 0, 0,  42, 0, 255, "420100", "TXASS", "Travaux d’assurance"),
(4202, 0, 0, 0,  42, 0, 255, "420200", "BURAS", "Bureau d’assurance"),
(4203, 0, 0, 0,  42, 0, 255, "420300", "DCASS", "Différentes catégories d’assurance"),
(4204, 0, 0, 0,  42, 0, 255, "420400", "ASSMF", "Assurances maritimes fluviales aériennes"),
(4205, 0, 0, 0,  42, 0, 255, "420500", "TXASY", "Travaux d’application et de synthèse"),
(4206, 0, 0, 0,  42, 0, 255, "420600", "FONDA", "Fondamentaux de l’assurance"),
(4207, 0, 0, 0,  42, 0, 255, "420700", "TASSU", "Technique d’assurance"),
(4208, 0, 0, 0,  42, 0, 255, "420800", "AVPRO", "Aide à la vie professionnelle assurance"),
(4209, 0, 0, 0,  42, 0, 255, "420900", "ATRSP", "Assurances transports"),
(4210, 0, 0, 0,  42, 0, 255, "421000", "EOASS", "Économie et organisation de l’assurance"),
(4211, 0, 0, 0,  42, 0, 255, "421100", "EJBCA", "Ens eco jur out bur tec comm comp adm"),
(4212, 0, 0, 0,  42, 0, 255, "421200", "CUPRA", "Culture professionnelle appliquée"),
(4213, 0, 0, 0,  42, 0, 255, "421300", "GESIN", "Gestion des sinistres"),
(4299, 0, 0, 0,  42, 0, 255, "429900", "ASSUD", "Assurances divers"),

-- 43 Gestion des entreprises

(4301, 0, 0, 0,  43, 0, 255, "430100", "T-GES", "Techniques de gestion et informatique"),
(4302, 0, 0, 0,  43, 0, 255, "430200", "DECPV", "Découverte pratique vie orga entreprise"),
(4303, 0, 0, 0,  43, 0, 255, "430300", "INTEX", "Intervention extérieure sur entreprise"),
(4304, 0, 0, 0,  43, 0, 255, "430400", "O-TRA", "Organisation du travail"),
(4305, 0, 0, 0,  43, 0, 255, "430500", "G-ENT", "Gestion de l’entreprise"),
(4306, 0, 0, 0,  43, 0, 255, "430600", "CNTGS", "Contrôle de gestion"),
(4307, 0, 0, 0,  43, 0, 255, "430700", "E-OVE", "Économie et orga et vie de l’entreprise"),
(4308, 0, 0, 0,  43, 0, 255, "430800", "O-GEN", "Organisation et gestion de l’entreprise"),
(4309, 0, 0, 0,  43, 0, 255, "430900", "OU-MG", "Outils mathématiques de gestion"),
(4310, 0, 0, 0,  43, 0, 255, "431000", "PGSEN", "Principe de gestion entreprises"),
(4311, 0, 0, 0,  43, 0, 255, "431100", "O-PLN", "Organisation et planification"),
(4312, 0, 0, 0,  43, 0, 255, "431200", "E-OEN", "Économie et organi de l’entreprise"),
(4313, 0, 0, 0,  43, 0, 255, "431300", "ANADA", "Analyse administrative et appliquée"),
(4314, 0, 0, 0,  43, 0, 255, "431400", "OU-GS", "Outils de gestion"),
(4315, 0, 0, 0,  43, 0, 255, "431500", "VIENT", "Vie de l’entreprise"),
(4316, 0, 0, 0,  43, 0, 255, "431600", "T-QTG", "Techniques quantitatives de gestion"),
(4317, 0, 0, 0,  43, 0, 255, "431700", "G-LEG", "Gestion et législation"),
(4318, 0, 0, 0,  43, 0, 255, "431800", "O-EEC", "Organisation exploitations entreprises chantiers"),
(4319, 0, 0, 0,  43, 0, 255, "431900", "G-VDE", "Gestion et vie des entreprises"),
(4320, 0, 0, 0,  43, 0, 255, "432000", "GESTN", "Gestion"),
(4321, 0, 0, 0,  43, 0, 255, "432100", "N-GES", "Enseignement mise à niveau gestion"),
(4322, 0, 0, 0,  43, 0, 255, "432200", "E-GSE", "Économie et gestion de l’entreprise"),
(4323, 0, 0, 0,  43, 0, 255, "432300", "MT-AG", "Méthodes administratives et gestion"),
(4324, 0, 0, 0,  43, 0, 255, "432400", "G-ADM", "Gestion des activités administratives"),
(4325, 0, 0, 0,  43, 0, 255, "432500", "I-GSE", "Initiation à la gestion des entreprises"),
(4326, 0, 0, 0,  43, 0, 255, "432600", "T-ADM", "Techniques administratives"),
(4327, 0, 0, 0,  43, 0, 255, "432700", "ENTGS", "L’entreprise et sa gestion"),
(4328, 0, 0, 0,  43, 0, 255, "432800", "E-ENT", "Économie d’entreprise"),
(4329, 0, 0, 0,  43, 0, 255, "432900", "O-EGE", "Organisatio product : eco gest entreprise"),
(4330, 0, 0, 0,  43, 0, 255, "433000", "E-EGS", "Économie d’entreprise et gestion"),
(4331, 0, 0, 0,  43, 0, 255, "433100", "MA-GG", "Mathématiques générales appliquées gestion"),
(4332, 0, 0, 0,  43, 0, 255, "433200", "OADGS", "Option à dominante gestion"),
(4333, 0, 0, 0,  43, 0, 255, "433300", "E-ORO", "Économie et organisation d’une opération"),
(4334, 0, 0, 0,  43, 0, 255, "433400", "MT-GP", "Méthodes d’administration et de gestion des PME PMI"),
(4335, 0, 0, 0,  43, 0, 255, "433500", "TXSAP", "Travaux de synthèse et actions profess."),
(4336, 0, 0, 0,  43, 0, 255, "433600", "GQUAL", "Gestion de la qualité (gest entreprises)"),
(4337, 0, 0, 0,  43, 0, 255, "433700", "OGCOM", "Organisation gestion commerciales"),
(4338, 0, 0, 0,  43, 0, 255, "433800", "GLMOM", "Gest legisl mercatiq outils mathem"),
(4339, 0, 0, 0,  43, 0, 255, "433900", "GEOSI", "Gest entrepr org syst information"),
(4340, 0, 0, 0,  43, 0, 255, "434000", "COGDF", "Communic org gest dossiers fonctionnels"),
(4341, 0, 0, 0,  43, 0, 255, "434100", "GEXPL", "Gestion de l’exploitation"),
(4342, 0, 0, 0,  43, 0, 255, "434200", "GT-RH", "Gestion et techniques des ressources humaines"),
(4343, 0, 0, 0,  43, 0, 255, "434300", "MANOR", "Management des organisations"),
(4344, 0, 0, 0,  43, 0, 255, "434400", "GTEAF", "Gestion techn. et econ. d’une affaire"),
(4345, 0, 0, 0,  43, 0, 255, "434500", "MANAG", "Management"),
(4346, 0, 0, 0,  43, 0, 255, "434600", "SIGES", "Système d’information et de gestion"),
(4347, 0, 0, 0,  43, 0, 255, "434700", "MANGE", "Management et gestion de l’entreprise"),
(4348, 0, 0, 0,  43, 0, 255, "434800", "AIDEC", "Aide a la décision"),
(4349, 0, 0, 0,  43, 0, 255, "434900", "ORGAC", "Organisation de l’action"),
(4350, 0, 0, 0,  43, 0, 255, "435000", "GTECO", "Gestion technique et économique"),
(4351, 0, 0, 0,  43, 0, 255, "435100", "GVQSE", "Gest.vie quotidienne ds serv.ou entrepr."),
(4352, 0, 0, 0,  43, 0, 255, "435200", "GDROI", "Gestion et droit"),
(4353, 0, 0, 0,  43, 0, 255, "435300", "MENTR", "Management des entreprises"),
(4354, 0, 0, 0,  43, 0, 255, "435400", "SCDG" , "Sciences de gestion"),
(4355, 0, 0, 0,  43, 0, 255, "435500", "GESFI", "Gestion et finance"),
(4356, 0, 0, 0,  43, 0, 255, "435600", "EGAAE", "Économie-gestion appliquée agroéquipement"),
(4357, 0, 0, 0,  43, 0, 255, "435700", "GEDAC", "Gestion économique & développement de l’activité"),
(4358, 0, 0, 0,  43, 0, 255, "435800", "ORMEO", "Organisation et mise en œuvre"),
(4359, 0, 0, 0,  43, 0, 255, "435900", "MASCG", "Management et sciences de gestion"),
(4360, 0, 0, 0,  43, 0, 255, "436000", "GESMG", "Gestion et management"),
(4361, 0, 0, 0,  43, 0, 255, "436100", "GEAPP", "Gestion approfondie"),
(4362, 0, 0, 0,  43, 0, 255, "436200", "OPRAD", "Optimisation processus administratifs"),
(4363, 0, 0, 0,  43, 0, 255, "436300", "COGRH", "Collaboration à la gestion des ressources humaines"),
(4364, 0, 0, 0,  43, 0, 255, "436400", "GMENT", "Gestion management des entreprises"),
(4365, 0, 0, 0,  43, 0, 255, "436500", "GEHTE", "Gestion de l’environnement humain et technique"),
(4366, 0, 0, 0,  43, 0, 255, "436600", "GEFIN", "Gestion économique et financière"),
(4367, 0, 0, 0,  43, 0, 255, "436700", "SGENU", "Sciences de gestion et numérique"),
(4368, 0, 0, 0,  43, 0, 255, "436800", "MAGES", "Management et gestion"),
(4369, 0, 0, 0,  43, 0, 255, "436900", "GESAP", "Gestion appliquée"),
(4370, 0, 0, 0,  43, 0, 255, "437000", "TRAGE", "Travaux de gestion d’entreprise"),
(4371, 0, 0, 0,  43, 0, 255, "437100", "CACPR", "Cadre de l’action professionnelle"),
(4372, 0, 0, 0,  43, 0, 255, "437200", "ENTRE", "Entrepreneuriat"),
(4373, 0, 0, 0,  43, 0, 255, "437300", "MARHU", "Management des ressources humaines"),
(4399, 0, 0, 0,  43, 0, 255, "439900", "G-DIV", "Gestion divers"),

-- 44 Publicité

(4401, 0, 0, 0,  44, 0, 255, "440100", "TXSAC", "Trav.prof.synth.et action.publici.appro."),
(4402, 0, 0, 0,  44, 0, 255, "440200", "ETCPU", "Études commerciales et études publicitaires"),
(4403, 0, 0, 0,  44, 0, 255, "440300", "SMCPU", "Stratégie et moyens de communication publicitaire"),
(4499, 0, 0, 0,  44, 0, 255, "449900", "PUBDI", "Publicité divers"),

-- 45 Métiers des arts appliqués (suite)

(4501, 0, 0, 0,  45, 0, 255, "450100", "HUMOD", "Humanités modernes"),
(4502, 0, 0, 0,  45, 0, 255, "450200", "SMAJU", "Stratégie marketing juridique"),
(4503, 0, 0, 0,  45, 0, 255, "450300", "CPRTE", "Cultures et pratiques techniques"),
(4504, 0, 0, 0,  45, 0, 255, "450400", "PPLME", "Pratiques plastiques et médiations"),
(4505, 0, 0, 0,  45, 0, 255, "450500", "IPRRE", "Innovation, prospective et recherche"),
(4506, 0, 0, 0,  45, 0, 255, "450600", "LEXRE", "Laboratoire expérimentation et recherche"),
(4507, 0, 0, 0,  45, 0, 255, "450700", "MACPR", "Macro-projet"),
(4508, 0, 0, 0,  45, 0, 255, "450800", "MREPR", "Mémoire de recherche professionnel"),
(4509, 0, 0, 0,  45, 0, 255, "450900", "MELVE", "Mémoire en langue vivante etrangère"),
(4510, 0, 0, 0,  45, 0, 255, "451000", "PRCRA", "Pratiques créatives et artistiques"),
(4511, 0, 0, 0,  45, 0, 255, "451100", "RDPRO", "Recherche et démarche de projet"),
(4512, 0, 0, 0,  45, 0, 255, "451200", "DESTC", "Design, sciences & technologies contemporaines"),
(4513, 0, 0, 0,  45, 0, 255, "451300", "INEXP", "Investigation, exploitation, projection"),
(4514, 0, 0, 0,  45, 0, 255, "451400", "MEDIA", "Médiation"),
(4515, 0, 0, 0,  45, 0, 255, "451500", "DESMA", "Design et métiers d’art"),
(4516, 0, 0, 0,  45, 0, 255, "451600", "ANAMD", "Analyse et méthodes en design"),
(4517, 0, 0, 0,  45, 0, 255, "451700", "CCDMA", "Conception et création en design et métiers d’art"),
(4518, 0, 0, 0,  45, 0, 255, "451800", "CPTHE", "Culture et pratique du théâtre"),
(4519, 0, 0, 0,  45, 0, 255, "451900", "CSTHE", "Culture et sciences théâtrales"),
(4520, 0, 0, 0,  45, 0, 255, "452000", "PRTHE", "Pratique théâtrale"),

-- 46 Métiers d’art (suite)

(4601, 0, 0, 0,  46, 0, 255, "460100", "CULTA", "Cultures artistiques"),
(4602, 0, 0, 0,  46, 0, 255, "460200", "TEMEO", "Technique et mise en œuvre"),
(4603, 0, 0, 0,  46, 0, 255, "460300", "CAUDA", "Culture audiovisuelle et artistique"),
(4604, 0, 0, 0,  46, 0, 255, "460400", "HUMCU", "Humanités et cultures"),
(4605, 0, 0, 0,  46, 0, 255, "460500", "METEC", "Méthodologies et techniques"),
(4606, 0, 0, 0,  46, 0, 255, "460600", "ATCRE", "Ateliers de création"),

-- 47 Activités non spécialisées (suite)

(4701, 0, 0, 0,  47, 0, 255, "470100", "ACMET", "Accompagnement méthodologique"),
(4702, 0, 0, 0,  47, 0, 255, "470200", "MODAS", "Module d’aides spécifiques"),
(4703, 0, 0, 0,  47, 0, 255, "470300", "ENSHL", "Enseignement non suivi hors langue vivante"),
(4704, 0, 0, 0,  47, 0, 255, "470400", "PAREX", "Parcours d’excellence"),
(4705, 0, 0, 0,  47, 0, 255, "470500", "PROFE", "Professionnalisation"),
(4706, 0, 0, 0,  47, 0, 255, "470600", "ACHOR", "Accompagnement au choix de l’orientation"),
(4707, 0, 0, 0,  47, 0, 255, "470700", "CAPCO", "Consolidation, accomp. personnalisé et au choix d’orientation"),
(4708, 0, 0, 0,  47, 0, 255, "470800", "POETU", "Poursuite d’études"),
(4709, 0, 0, 0,  47, 0, 255, "470900", "INPRO", "Insertion professionnelle"),
(4710, 0, 0, 0,  47, 0, 255, "471000", "PRSPE", "Projet de spécialisation"),
(4711, 0, 0, 0,  47, 0, 255, "471100", "RCOPR", "Relations et communication professionnelles"),
(4712, 0, 0, 0,  47, 0, 255, "471200", "MOAPS", "Module d’approfondissement sectoriel"),
(4713, 0, 0, 0,  47, 0, 255, "471300", "PACEC", "Parcours de certification complémentaire"),

-- 48 Sciences (suite)

(4801, 0, 0, 0,  48, 0, 255, "480100", "TSYOP", "Technologie des systèmes optiques"),
(4802, 0, 0, 1,  48, 0, 255, "480200", "EIST" , "Enseignement intégré de science et technologie"),
(4803, 0, 0, 0,  48, 0, 255, "480300", "MATCO", "Mathématiques complémentaires"),
(4804, 0, 0, 0,  48, 0, 255, "480400", "MATEX", "Mathématiques expertes"),
(4805, 0, 0, 0,  48, 0, 255, "480500", "PHCHS", "Physique-chimie pour la santé"),
(4806, 0, 0, 0,  48, 0, 255, "480600", "SISPH", "Sciences de l’ingénieur et sciences physiques"),
(4807, 0, 0, 0,  48, 0, 255, "480700", "PHCHM", "Physique-chimie et mathématiques"),
(4808, 0, 0, 0,  48, 0, 255, "480800", "MASPR", "Mathématiques appliquées, statistiques et probabilités"),

-- 49 Biotechnologie génie biol.- biochimique (suite)

(4901, 0, 0, 0,  49, 0, 255, "490100", "INDED", "Ingénierie et développement durable"),

-- 50 Langue technique

(5001, 0, 0, 0,  50, 0, 255, "500100", "AGINF", "Langue anglaise appliquée à l’informatique"),
(5002, 0, 0, 0,  50, 0, 255, "500200", "AGTEC", "Anglais technique"),
(5003, 0, 0, 0,  50, 0, 255, "500300", "AGCOM", "Anglais commercial et technique"),
(5004, 0, 0, 0,  50, 0, 255, "500400", "ANGL" , "Anglais"),
(5005, 0, 0, 0,  50, 0, 255, "500500", "LGMOD", "Langue vivante module"),
(5006, 0, 0, 0,  50, 0, 255, "500600", "COMLV", "Communication en lv étrangère"),
(5007, 0, 0, 0,  50, 0, 255, "500700", "ANGAF", "Anglais des affaires"),
(5008, 0, 0, 0,  50, 0, 255, "500800", "NVLVE", "Négociation vente en lve"),
(5009, 0, 0, 0,  50, 0, 255, "500900", "LILVE", "Littérature étrangère en langue étrangère"),
(5010, 0, 0, 0,  50, 0, 255, "501000", "DAALV", "Design et arts appliqués en lv1"),
(5011, 0, 0, 0,  50, 0, 255, "501100", "ETLV1", "Enseignement technologique en lv1"),
(5012, 0, 0, 0,  50, 0, 255, "501200", "ENSLA", "Enseignement de specialité en anglais"),
(5098, 0, 0, 0,  50, 0, 255, "509800", "AELVE", "Accompagn.éducatif - pratique orale lve"),
(5099, 0, 0, 0,  50, 0, 255, "509900", "LGDIV", "Langue technique diverse"),

-- 51 Services

(5101, 0, 0, 0,  51, 0, 255, "510100", "PMOPS", "Préparation et mise en oeuvre d’une prestation de securité"),
(5102, 0, 0, 0,  51, 0, 255, "510200", "PASEG", "Participation à la sécurite globale"),
(5103, 0, 0, 0,  51, 0, 255, "510300", "MSHUG", "Module surveillance humaine et gardiennage"),

-- 60 Activités hippiques

(6001, 0, 0, 0,  60, 0, 255, "600100", "EQUIA", "Equitation"),
(6002, 0, 0, 0,  60, 0, 255, "600200", "HIEQA", "Hippologie-équitation"),
(6003, 0, 0, 0,  60, 0, 255, "600300", "MAREA", "Maréchalerie"),
(6004, 0, 0, 0,  60, 0, 255, "600400", "ZOOHA", "Zootechnie hippologie"),
(6005, 0, 0, 0,  60, 0, 255, "600500", "HIPPO", "Hippologie"),

-- 61 Commercialisation

(6101, 0, 0, 0,  61, 0, 255, "610100", "TCMRA", "Techniques commerciales"),
(6102, 0, 0, 0,  61, 0, 255, "610200", "TECOA", "Techniques économiques"),

-- 62 Élevage et soins aux animaux

(6201, 0, 0, 0,  62, 0, 255, "620100", "TANIA", "Techniques animalières"),
(6202, 0, 0, 0,  62, 0, 255, "620200", "ANIMA", "Animalerie"),

-- 63 Environnement - aménagement de l’espace

(6301, 0, 0, 0,  63, 0, 255, "630100", "ESF-A", "Économie sociale familiale"),
(6302, 0, 0, 0,  63, 0, 255, "630200", "AEN-A", "Aménagement espaces naturels"),
(6303, 0, 0, 0,  63, 0, 255, "630300", "TFORA", "Techniques forestières"),
(6304, 0, 0, 0,  63, 0, 255, "630400", "APAYA", "Aménagement paysager"),

-- 64 Équipements pour l’agriculture

(6401, 0, 0, 0,  64, 0, 255, "640100", "MACHA", "Machinisme"),
(6402, 0, 0, 0,  64, 0, 255, "640200", "STEQA", "Sciences et technologies des équipements"),
(6403, 0, 0, 0,  64, 0, 255, "640300", "AEQUA", "Agro-équipements"),
(6404, 0, 0, 0,  64, 0, 255, "640400", "EQAGA", "Equipements agroalimentaires"),
(6405, 0, 0, 0,  64, 0, 255, "640500", "EQHYA", "Equipements hydrauliques"),
(6406, 0, 0, 0,  64, 0, 255, "640600", "STAEQ", "Sciences et techniques des agroéquipements"),

-- 65 Disciplines professionnelles de l’enseignement agricole

(6510, 0, 0, 0,  65, 0, 255, "651000", "ETP-A", "Enseignement technologique et professionnel"),
(6520, 0, 0, 0,  65, 0, 255, "652000", "SCTCA", "Sciences et techniques"),
(6530, 0, 0, 0,  65, 0, 255, "653000", "PPROA", "Pratiques professionnelles"),
(6540, 0, 0, 0,  65, 0, 255, "654000", "PROPA", "Projet professionnel"),

-- 66 Production

(6601, 0, 0, 0,  66, 0, 255, "660100", "AGROA", "Agronomie"),
(6602, 0, 0, 0,  66, 0, 255, "660200", "STAQA", "Sciences et techniques aquacoles"),
(6603, 0, 0, 0,  66, 0, 255, "660300", "STHOA", "Sciences et techniques horticoles"),
(6604, 0, 0, 0,  66, 0, 255, "660400", "OENOA", "Œnologie"),
(6605, 0, 0, 0,  66, 0, 255, "660500", "VITIA", "Viticulture"),
(6606, 0, 0, 0,  66, 0, 255, "660600", "VIOEA", "Viticulture - Œnologie"),
(6607, 0, 0, 0,  66, 0, 255, "660700", "ZOOTA", "Zootechnie"),
(6608, 0, 0, 0,  66, 0, 255, "660800", "TAQUA", "Technologie aquacole"),
(6609, 0, 0, 0,  66, 0, 255, "660900", "PVEGE", "Priductions végétales"),
(6610, 0, 0, 0,  66, 0, 255, "661000", "AQUAC", "Aquaculture"),
(6611, 0, 0, 0,  66, 0, 255, "661100", "PHORT", "Productions horticoles"),
(6612, 0, 0, 0,  66, 0, 255, "661200", "PANIM", "Productions animales"),

-- 67 Services

-- 68 Transformation

(6801, 0, 0, 0,  68, 0, 255, "680100", "GPIAA", "Génie des procédés IAA"),
(6802, 0, 0, 0,  68, 0, 255, "680200", "GALIM", "Génie alimentaire"),
(6803, 0, 0, 0,  68, 0, 255, "680300", "GINDA", "Génie industriel"),

-- 69 Disciplines générales enseignement agricole

(6901, 0, 0, 0,  69, 0, 255, "690100", "APLUA", "Act. pluridisciplinaires"),
(6902, 0, 0, 0,  69, 0, 255, "690200", "AIF-A", "Aide indiv français"),
(6903, 0, 0, 0,  69, 0, 255, "690300", "AIM-A", "Aide indiv maths"),
(6904, 0, 0, 0,  69, 0, 255, "690400", "ARTSA", "Arts"),
(6905, 0, 0, 0,  69, 0, 255, "690500", "BCHIA", "Biochimie"),
(6906, 0, 0, 0,  69, 0, 255, "690600", "BCHMA", "Biochimie - microbiologie"),
(6907, 0, 0, 0,  69, 0, 255, "690700", "BIOLA", "Biologie"),
(6908, 0, 0, 0,  69, 0, 255, "690800", "BANIA", "Biologie animale"),
(6909, 0, 0, 0,  69, 0, 255, "690900", "BVEGA", "Biologie végétale"),
(6910, 0, 0, 0,  69, 0, 255, "691000", "BECOA", "Biologie - Ecologie"),
(6911, 0, 0, 0,  69, 0, 255, "691100", "CHIMA", "Chimie"),
(6912, 0, 0, 0,  69, 0, 255, "691200", "CPTBA", "Compta-bureau"),
(6913, 0, 0, 0,  69, 0, 255, "691300", "DOCUA", "Documentation"),
(6914, 0, 0, 0,  69, 0, 255, "691400", "EPS-A", "E.P.S."),
(6915, 0, 0, 0,  69, 0, 255, "691500", "ECOLA", "Ecologie"),
(6916, 0, 0, 0,  69, 0, 255, "691600", "EENTA", "Économie d’entreprise"),
(6917, 0, 0, 0,  69, 0, 255, "691700", "EDRTA", "Économie - droit"),
(6918, 0, 0, 0,  69, 0, 255, "691800", "ECJSA", "Education civique - juridique - sociale"),
(6919, 0, 0, 0,  69, 0, 255, "691900", "ESOCA", "Education socioculturelle"),
(6920, 0, 0, 0,  69, 0, 255, "692000", "FRANA", "Français"),
(6921, 0, 0, 0,  69, 0, 255, "692100", "GEO-A", "Géographie"),
(6922, 0, 0, 0,  69, 0, 255, "692200", "GESTA", "Gestion"),
(6923, 0, 0, 0,  69, 0, 255, "692300", "GRECA", "Grec"),
(6924, 0, 0, 0,  69, 0, 255, "692400", "HVC-A", "Heures de vie de classe"),
(6925, 0, 0, 0,  69, 0, 255, "692500", "HGECA", "Histoire-Géo. - Education civique"),
(6926, 0, 0, 0,  69, 0, 255, "692600", "HIGEA", "Histoire-Géographie"),
(6927, 0, 0, 0,  69, 0, 255, "692700", "HPS-A", "Hygiène - Prévention - Secourisme"),
(6928, 0, 0, 0,  69, 0, 255, "692800", "INFOA", "Informatique"),
(6929, 0, 0, 0,  69, 0, 255, "692900", "LATIA", "Latin"),
(6930, 0, 0, 0,  69, 0, 255, "693000", "MATHA", "Mathématiques"),
(6931, 0, 0, 0,  69, 0, 255, "693100", "MRCAA", "Mercatique"),
(6932, 0, 0, 0,  69, 0, 255, "693200", "MBIOA", "Microbiologie"),
(6933, 0, 0, 0,  69, 0, 255, "693300", "PHILA", "Philosophie"),
(6934, 0, 0, 0,  69, 0, 255, "693400", "PHYSA", "Physique"),
(6935, 0, 0, 0,  69, 0, 255, "693500", "P-APA", "Physique appliquée"),
(6936, 0, 0, 0,  69, 0, 255, "693600", "P-CHA", "Physique-Chimie"),
(6937, 0, 0, 0,  69, 0, 255, "693700", "6937A", "Pratiques prof."),
(6938, 0, 0, 0,  69, 0, 255, "693800", "PSC-A", "Pratiques soc. et cultur."),
(6939, 0, 0, 0,  69, 0, 255, "693900", "PSE-A", "Prévention santé environnement"),
(6940, 0, 0, 0,  69, 0, 255, "694000", "SESGA", "Sci. éco- soc.- gestion"),
(6941, 0, 0, 0,  69, 0, 255, "694100", "SES-A", "Sciences éco et sociales"),
(6942, 0, 0, 0,  69, 0, 255, "694200", "SEH-A", "Sciences éco. et humaines"),
(6943, 0, 0, 0,  69, 0, 255, "694300", "SECOA", "Sciences économiques"),
(6944, 0, 0, 0,  69, 0, 255, "694400", "SBURA", "Secrét. bureautique"),
(6945, 0, 0, 0,  69, 0, 255, "694500", "STATA", "Statistiques"),
(6946, 0, 0, 0,  69, 0, 255, "694600", "SVT-A", "Sciences de la vie et de la terre"),
(6947, 0, 0, 0,  69, 0, 255, "694700", "TCMUA", "Tech. de communication"),
(6948, 0, 0, 0,  69, 0, 255, "694800", "TDOCA", "Tech. de documentation"),
(6949, 0, 0, 0,  69, 0, 255, "694900", "TIM-A", "TIM"),
(6950, 0, 0, 0,  69, 0, 255, "695000", "FRDOA", "Français Documentation"),
(6951, 0, 0, 0,  69, 0, 255, "695100", "FRPHA", "Français Philosophie"),
(6952, 0, 0, 0,  69, 0, 255, "695200", "MAINA", "Mathématiques Informatique"),
(6954, 0, 0, 0,  69, 0, 255, "695400", "BCHMB", "Biochimie microbiologie biotechnologie"),
(6991, 0, 0, 0,  69, 0, 255, "695301", "ANG-A", "Anglais"),
(6992, 0, 0, 0,  69, 0, 255, "695302", "ALL-A", "Allemand"),
(6993, 0, 0, 0,  69, 0, 255, "695303", "ITA-A", "Italien"),
(6994, 0, 0, 0,  69, 0, 255, "695304", "ESP-A", "Espagnol"),

-- 90 Enseignement religieux

(9010, 0, 0, 0,  90, 0, 255, "901000", "CATHO", "Enseignement religieux catholique"),
(9020, 0, 0, 0,  90, 0, 255, "902000", "ISRLT", "Enseignement religieux israélite"),
(9030, 0, 0, 0,  90, 0, 255, "903000", "PROTT", "Enseignement religieux protestant"),
(9031, 0, 0, 0,  90, 0, 255, "903100", "LUTHR", "Enseignement religieux luthérien"),
(9032, 0, 0, 0,  90, 0, 255, "903200", "CALVN", "Enseignement religieux calviniste"),
(9099, 0, 0, 0,  90, 0, 255, "909900", "RLGDI", "Enseignement religieux divers"),

-- 93 Langues vivantes régionales ou spécifiques

(9307, 0, 0, 0,  93, 0, 255, "030700", "GRE", "Grec moderne"),
(9308, 0, 0, 0,  93, 0, 255, "030800", "HEB", "Hébreu"),
(9315, 0, 0, 0,  93, 0, 255, "031500", "ARM", "Arménien"),
(9316, 0, 0, 0,  93, 0, 255, "031600", "AMH", "Amharique"),
(9317, 0, 0, 0,  93, 0, 255, "031700", "ARD", "Arabe dialectal"),
(9318, 0, 0, 0,  93, 0, 255, "031800", "BER", "Berbère"),
(9319, 0, 0, 0,  93, 0, 255, "031900", "BUL", "Bulgare"),
(9320, 0, 0, 0,  93, 0, 255, "032000", "CAM", "Cambodgien"),
(9321, 0, 0, 0,  93, 0, 255, "032100", "VIE", "Vietnamien"),
(9322, 0, 0, 0,  93, 0, 255, "032200", "FIN", "Finnois"),
(9323, 0, 0, 0,  93, 0, 255, "032300", "HON", "Hongrois"),
(9324, 0, 0, 0,  93, 0, 255, "032400", "ISL", "Islandais"),
(9325, 0, 0, 0,  93, 0, 255, "032500", "NOR", "Norvégien"),
(9326, 0, 0, 0,  93, 0, 255, "032600", "MLG", "Malgache"),
(9327, 0, 0, 0,  93, 0, 255, "032700", "ROU", "Roumain"),
(9328, 0, 0, 0,  93, 0, 255, "032800", "TCH", "Tchèque"),
(9330, 0, 0, 0,  93, 0, 255, "033000", "PER", "Persan"),
(9331, 0, 0, 0,  93, 0, 255, "033100", "TUR", "Turc"),
(9332, 0, 0, 0,  93, 0, 255, "033200", "LAO", "Laotien"),
(9333, 0, 0, 0,  93, 0, 255, "033300", "SUE", "Suédois"),
(9334, 0, 0, 0,  93, 0, 255, "033400", "AME", "Américain"),
(9335, 0, 0, 0,  93, 0, 255, "033500", "ALB", "Albanais"),
(9336, 0, 0, 0,  93, 0, 255, "033600", "SER", "Serbe"),
(9337, 0, 0, 0,  93, 0, 255, "033700", "CRO", "Croate"),
(9338, 0, 0, 0,  93, 0, 255, "033800", "BAM", "Bambara"),
-- Coréen passé dans la famille n°3
(9340, 0, 0, 0,  93, 0, 255, "034000", "HAO", "Haoussa"),
(9341, 0, 0, 0,  93, 0, 255, "034100", "HIN", "Hindi"),
(9342, 0, 0, 0,  93, 0, 255, "034200", "INM", "Indonésien-malais"),
(9343, 0, 0, 0,  93, 0, 255, "034300", "MAC", "Macédonien"),
(9344, 0, 0, 0,  93, 0, 255, "034400", "PEU", "Peul"),
(9345, 0, 0, 0,  93, 0, 255, "034500", "SLQ", "Slovaque"),
(9346, 0, 0, 0,  93, 0, 255, "034600", "SLN", "Slovène"),
(9347, 0, 0, 0,  93, 0, 255, "034700", "SWA", "Swahili"),
(9348, 0, 0, 0,  93, 0, 255, "034800", "TAM", "Tamoul"),
(9350, 0, 0, 0,  93, 0, 255, "035000", "AUV", "Auvergnat"),
(9351, 0, 0, 0,  93, 0, 255, "035100", "BAS", "Basque"),
(9352, 0, 0, 0,  93, 0, 255, "035200", "BRE", "Breton"),
(9353, 0, 0, 0,  93, 0, 255, "035300", "CAT", "Catalan"),
(9354, 0, 0, 0,  93, 0, 255, "035400", "COR", "Corse"),
(9355, 0, 0, 0,  93, 0, 255, "035500", "GAL", "Gallo"),
(9356, 0, 0, 0,  93, 0, 255, "035600", "GAS", "Gascon"),
(9357, 0, 0, 0,  93, 0, 255, "035700", "LAN", "Languedocien"),
(9358, 0, 0, 0,  93, 0, 255, "035800", "OCC", "Langue occitane"),
(9359, 0, 0, 0,  93, 0, 255, "035900", "LRA", "Langues régionales d’alsace"),
(9360, 0, 0, 0,  93, 0, 255, "036000", "LIM", "Limousin"),
(9361, 0, 0, 0,  93, 0, 255, "036100", "NIS", "Nissart"),
(9362, 0, 0, 0,  93, 0, 255, "036200", "PRV", "Provençal"),
(9363, 0, 0, 0,  93, 0, 255, "036300", "TAH", "Tahitien"),
(9364, 0, 0, 0,  93, 0, 255, "036400", "VAL", "Vivaro-alpin"),
(9367, 0, 0, 0,  93, 0, 255, "036700", "MOS", "Langues régionales des pays mosellans"),
(9368, 0, 0, 0,  93, 0, 255, "036800", "MEL", "Langues mélanésiennes"),
(9369, 0, 0, 0,  93, 0, 255, "036900", "LMJ", "Mélanésien ajie"),
(9370, 0, 0, 0,  93, 0, 255, "037000", "LMR", "Mélanésien drehu"),
(9371, 0, 0, 0,  93, 0, 255, "037100", "LMN", "Mélanésien nengone"),
(9372, 0, 0, 0,  93, 0, 255, "037200", "LMD", "Mélanésien paici"),
(9373, 0, 0, 0,  93, 0, 255, "037300", "CRE", "Créole"),
(9374, 0, 0, 0,  93, 0, 255, "037400", "WAL", "Walissien-futunien"),
(9380, 0, 0, 0,  93, 0, 255, "038000", "LNS", "Langue non suivie"),
(9381, 0, 0, 0,  93, 0, 255, "038100", "LIT", "Lituanien"),
(9382, 0, 0, 0,  93, 0, 255, "038200", "EST", "Estonien"),

-- 96 Spécialités de baccalauréat professionnel (suite) (https://eduscol.education.fr/1916/le-baccalaureat-professionnel#summary-item-7)

(9601, 0, 0, 0,  96, 0, 255,       "", "BPAAV", "Aéronautique - option Avionique"), -- première session 2016
(9602, 0, 0, 0,  96, 0, 255,       "", "BPAST", "Aéronautique - option Structure"), -- première session 2016
(9603, 0, 0, 0,  96, 0, 255,       "", "BPASY", "Aéronautique - option Systèmes"),  -- première session 2016
(9604, 0, 0, 0,  96, 0, 255,       "", "BPERA", "Étude et réalisation d’agencement"), -- ex 9706 "Agencement de l’espace architectural"
(9605, 0, 0, 0,  96, 0, 255,       "", "BPMCS", "Métiers du cuir option Sellerie garnissage"), -- première session 2018
(9606, 0, 0, 0,  96, 0, 255,       "", "BPMAP", "Métiers et arts de la pierre"), -- première session 2018
(9607, 0, 0, 0,  96, 0, 255,       "", "BPAMV", "Artisanat et métiers d’art - option Verrerie scient. et techn."),
(9608, 0, 0, 0,  96, 0, 255,       "", "BPEEC", "Métiers de l’électricité et de ses environnements connectés"), -- remplace 9725 -- premiere session 2019
(9609, 0, 0, 0,  96, 0, 255,       "", "BPSNA", "Systèmes numériques A - Sûreté et sécu. infra., hab. et tert."), -- première session 2019
(9610, 0, 0, 0,  96, 0, 255,       "", "BPSNB", "Systèmes numériques B - Audiovisuels, réseau et équip. domest."), -- première session 2019
(9611, 0, 0, 0,  96, 0, 255,       "", "BPSNC", "Systèmes numériques C - Réseaux inform. et syst. communicants"), -- première session 2019
(9612, 0, 0, 0,  96, 0, 255,       "", "BPTAO", "Technicien en appareillage orthopédique"), -- première session 2019
(9613, 0, 0, 0,  96, 0, 255,       "", "BPAEP", "Animation - enfance et personnes âgées"),  -- première session 2023
(9614, 0, 0, 0,  96, 0, 255,       "", "BPFOT", "Artisanat et métiers d’art - Facteur d’orgues opt. Organier Tuyautier"), -- première session 2021
(9615, 0, 0, 0,  96, 0, 255,       "", "BPAGO", "Assistance à la gestion des organisations et de leurs activités"), -- première session 2023
(9616, 0, 0, 0,  96, 0, 255,       "", "BPMSP", "Maintenance des systèmes de production connectés"), -- première session 2024
(9617, 0, 0, 0,  96, 0, 255,       "", "BPACC", "Métiers de l’accueil"), -- première session 2022 ; remplace 97027
(9618, 0, 0, 0,  96, 0, 255,       "", "BPCOI", "Métiers de la coiffure"), -- première session 2023
(9619, 0, 0, 0,  96, 0, 255,       "", "BPCVA", "Métiers commerce & vente A - Animation gestion espace commercial"),       -- première session 2022 ; remplace 9718
(9620, 0, 0, 0,  96, 0, 255,       "", "BPCVB", "Métiers commerce & vente B - Prosp. clientèle valor. offre commerciale"), -- première session 2022 ; remplace 9788
(9621, 0, 0, 0,  96, 0, 255,       "", "BPOTM", "Organisation de transport de marchandises"), -- première session 2023
(9622, 0, 0, 0,  96, 0, 255,       "", "BPGAZ", "Technicien Gaz"), -- première session 2020
(9623, 0, 0, 0,  96, 0, 255,       "", "BPTPD", "Technicien en prothèse dentaire"), -- première session 2023 ; remplace 9763
(9624, 0, 0, 0,  96, 0, 255,       "", "BPTRP", "Technicien réal. produits mécaniques - opt. suivi productions"), -- première session 2024
(9625, 0, 0, 0,  96, 0, 255,       "", "BPEBA", "Technicien d’études du bâtiment option A - Études et économie"),        -- doublon avec 9776 à supprimer
(9626, 0, 0, 0,  96, 0, 255,       "", "BPEBB", "Technicien d’études du bâtiment option B - Assistant en architecture"), -- doublon avec 9776 à supprimer
(9627, 0, 0, 0,  96, 0, 255,       "", "BPASA", "Accompagnement soins et services à la personne option B - En structure"), -- doublon avec 9701 à supprimer
(9628, 0, 0, 0,  96, 0, 255,       "", "BPASB", "Accompagnement soins et services à la personne option A - À domicile"),   -- doublon avec 9701 à supprimer
(9629, 0, 0, 0,  96, 0, 255,       "", "BPPBA", "Interventions sur le patrimoine bâti option A - Maçonnerie"), -- doublon avec 9737 à supprimer
(9630, 0, 0, 0,  96, 0, 255,       "", "BPPBB", "Interventions sur le patrimoine bâti option B - Charpente"),  -- doublon avec 9737 à supprimer
(9631, 0, 0, 0,  96, 0, 255,       "", "BPPBC", "Interventions sur le patrimoine bâti option C - Couverture"), -- doublon avec 9737 à supprimer
(9632, 0, 0, 0,  96, 0, 255,       "", "BPMAA", "Maintenance des matériels option A - Matériels agricoles"),
(9633, 0, 0, 0,  96, 0, 255,       "", "BPMAB", "Maintenance des matériels option B - Matériels de construction et de manutention"),
(9634, 0, 0, 0,  96, 0, 255,       "", "BPMAC", "Maintenance des matériels option C - Matériels d’espaces verts"),

-- 97 Spécialités de baccalauréat professionnel (https://eduscol.education.fr/1916/le-baccalaureat-professionnel#summary-item-7)

(9701, 0, 0, 0,  97, 0, 255,       "", "BPASS", "Accompagnement soins et services à la personne"),
(9702, 0, 0, 0,  97, 0, 255,       "", "BPARC", "Accueil - relation clients et usagers"), -- dernière session 2021
(9703, 0, 0, 0,  97, 0, 255,       "", "BPAOA", "Aéronautique - option mécanicien systèmes avionique"), -- à retirer
(9704, 0, 0, 0,  97, 0, 255,       "", "BPAOC", "Aéronautique - option mécanicien système cellule"), -- à retirer
(9705, 0, 0, 0,  97, 0, 255,       "", "BPA3O", "Aéronautique à trois options (avionique - syst. et structures)"), -- à retirer
(9706, 0, 0, 0,  97, 0, 255,       "", "BPAEA", "Agencement de l’espace architectural"), -- à retirer
(9707, 0, 0, 0,  97, 0, 255,       "", "BPAFB", "Aménagement et finition du bâtiment"),
(9708, 0, 0, 0,  97, 0, 255,       "", "BPAMP", "Artisanat et métiers d’art - option arts de la pierre"), -- dernière session 2017
(9709, 0, 0, 0,  97, 0, 255,       "", "BPAMC", "Artisanat et métiers d’art - option comm. visuelle pluri média"),
(9710, 0, 0, 0,  97, 0, 255,       "", "BPAME", "Artisanat et métiers d’art - option ébéniste"), -- dernière session 2016
(9711, 0, 0, 0,  97, 0, 255,       "", "BPAMM", "Artisanat et métiers d’art - option Marchandisage visuel"),
(9712, 0, 0, 0,  97, 0, 255,       "", "BPAMT", "Artisanat et métiers d’art - option Tapissier d’ameublement"),
(9713, 0, 0, 0,  97, 0, 255,       "", "BPAMS", "Artisanat et métiers d’art - option mét. enseigne signalétique"),
(9714, 0, 0, 0,  97, 0, 255,       "", "BPAG" , "Aviation générale"),
(9715, 0, 0, 0,  97, 0, 255,       "", "BPBIT", "Bio-industries de transformation"),
(9716, 0, 0, 0,  97, 0, 255,       "", "BPBP" , "Boulanger - pâtissier"),
(9717, 0, 0, 0,  97, 0, 255,       "", "BPBCT", "Boucher charcutier traiteur"),
(9718, 0, 0, 0,  97, 0, 255,       "", "BPCOM", "Commerce"), -- dernière session 2021
(9719, 0, 0, 0,  97, 0, 255,       "", "BPCSR", "Commercialisation et services en restauration"),
(9720, 0, 0, 0,  97, 0, 255,       "", "BPCPT", "Comptabilité"), -- à retirer
(9721, 0, 0, 0,  97, 0, 255,       "", "BPCTR", "Conducteur transport routier marchandises"),
(9722, 0, 0, 0,  97, 0, 255,       "", "BPCR" , "Construction des carrosseries"),
(9723, 0, 0, 0,  97, 0, 255,       "", "BPCUI", "Cuisine"),
(9724, 0, 0, 0,  97, 0, 255,       "", "BPCM" , "Cultures marines"),
(9725, 0, 0, 0,  97, 0, 255,       "", "BPEEE", "Électrotechnique, énergie, équipement communicants"), -- dernière session 2018
(9726, 0, 0, 0,  97, 0, 255,       "", "BPEN" , "Environnement nucléaire"), -- dernière session 2016
(9727, 0, 0, 0,  97, 0, 255,       "", "BPECP", "Esthétique cosmétique parfumerie"), -- première session 2020
(9728, 0, 0, 0,  97, 0, 255,       "", "BPEPI", "Étude et définition de produits industriels"),
(9729, 0, 0, 0,  97, 0, 255,       "", "BPFPI", "Façonnage de produits imprimés, routage"),
(9730, 0, 0, 0,  97, 0, 255,       "", "BPFON", "Fonderie"),
(9731, 0, 0, 0,  97, 0, 255,       "", "BPGA" , "Gestion administration"), -- dernière session 2022
(9732, 0, 0, 0,  97, 0, 255,       "", "BPGP" , "Gestion des pollutions et protection de l’environnement"), -- première session 2016
(9733, 0, 0, 0,  97, 0, 255,       "", "BPHE" , "Hygiène et environnement"),
(9734, 0, 0, 0,  97, 0, 255,       "", "BPHPS", "Hygiène, propreté et stérilisation"), -- première session 2016
(9735, 0, 0, 0,  97, 0, 255,       "", "BPIP" , "Industrie de procédés"), -- à retirer
(9736, 0, 0, 0,  97, 0, 255,       "", "BPIPC", "Industries des pates, papiers et cartons"), -- à retirer
(9737, 0, 0, 0,  97, 0, 255,       "", "BPIPB", "Interventions sur le patrimoine bâti"), -- première session 2016
(9738, 0, 0, 0,  97, 0, 255,       "", "BPLOG", "Logistique"),
(9739, 0, 0, 0,  97, 0, 255,       "", "BPMV" , "Maintenance de véhicules automobiles"), -- dernière session 2016
(9740, 0, 0, 0,  97, 0, 255,       "", "BPMEI", "Maintenance des équipements industriels"), -- dernière session 2023
(9741, 0, 0, 0,  97, 0, 255,       "", "BPMM" , "Maintenance des matériels"), -- dernières sessions 2018-2019 / premières sessions 2018-2019
(9742, 0, 0, 0,  97, 0, 255,       "", "BPMN" , "Maintenance nautique"),
(9743, 0, 0, 0,  97, 0, 255,       "", "BPMMV", "Métiers de la mode - vêtements"),
(9744, 0, 0, 0,  97, 0, 255,       "", "BPMCC", "Métiers du cuir option Chaussures"),
(9745, 0, 0, 0,  97, 0, 255,       "", "BPMCM", "Métiers du cuir option Maroquinerie"),
(9746, 0, 0, 0,  97, 0, 255,       "", "BPMPB", "Métiers du pressing et de la blanchisserie"), -- dernière session 2023
(9747, 0, 0, 0,  97, 0, 255,       "", "BPMIC", "Microtechniques"),
(9748, 0, 0, 0,  97, 0, 255,       "", "BPMIT", "Mise en œuvre des matériaux option industries textiles"), -- à retirer
(9749, 0, 0, 0,  97, 0, 255,       "", "BPMMC", "Mise en œuvre des matériaux opt. mat. métal. moulés, céramiques"), -- à retirer
(9750, 0, 0, 0,  97, 0, 255,       "", "BPOL" , "Optique lunetterie"),
(9751, 0, 0, 0,  97, 0, 255,       "", "BPOBS", "Ouvrage du bâtiment : aluminium, verre et matériaux de synthèse"), -- à retirer
(9752, 0, 0, 0,  97, 0, 255,       "", "BPOBM", "Ouvrage du bâtiment : métallerie"),
(9753, 0, 0, 0,  97, 0, 255,       "", "BPPP" , "Perruquier posticheur"),
(9754, 0, 0, 0,  97, 0, 255,       "", "BPPHO", "Photographie"),
(9755, 0, 0, 0,  97, 0, 255,       "", "BPPSP", "Pilotage de systèmes de production automatisée"), -- à retirer
(9756, 0, 0, 0,  97, 0, 255,       "", "BPPLP", "Pilote de ligne de production"),
(9757, 0, 0, 0,  97, 0, 255,       "", "BPPC" , "Plastiques et composites"),
(9758, 0, 0, 0,  97, 0, 255,       "", "BPPET", "Poissonnier écailler traiteur"),
(9759, 0, 0, 0,  97, 0, 255,       "", "BPPCE", "Procédés de la chimie, de l’eau et des papiers-cartons"),
(9760, 0, 0, 0,  97, 0, 255,       "", "BPPG" , "Production graphique"), -- dernière session 2016
(9761, 0, 0, 0,  97, 0, 255,       "", "BPPI" , "Production imprimée"), -- dernière session 2016
(9762, 0, 0, 0,  97, 0, 255,       "", "BPPMD", "Productique mécanique - option Décolletage"), -- dernière session 2023
(9763, 0, 0, 0,  97, 0, 255,       "", "BPPD" , "Prothèse dentaire"), -- dernière session 2022
(9764, 0, 0, 0,  97, 0, 255,       "", "BPRC" , "Réparation des carrosseries"),
(9765, 0, 0, 0,  97, 0, 255,       "", "BPSEC", "Secrétariat"), -- à retirer
(9766, 0, 0, 0,  97, 0, 255,       "", "BPSP" , "Sécurité prévention"), -- dernière session 2016
(9767, 0, 0, 0,  97, 0, 255,       "", "BPSPL", "Services de proximité et vie locale"), -- dernière session 2022
(9768, 0, 0, 0,  97, 0, 255,       "", "BPSEN", "Systèmes électroniques numériques"), -- dernière session 2018
(9769, 0, 0, 0,  97, 0, 255,       "", "BPTA" , "Technicien aérostructure"), -- à retirer
(9770, 0, 0, 0,  97, 0, 255,       "", "BPTCB", "Technicien constructeur bois"),
(9771, 0, 0, 0,  97, 0, 255,       "", "BPTFB", "Technicien de fabrication bois et matériaux associés"),
(9772, 0, 0, 0,  97, 0, 255,       "", "BPTEC", "Technicien de maintenance de syst. énergétiques et climatiques"),
(9773, 0, 0, 0,  97, 0, 255,       "", "BPTSC", "Technicien de scierie"),
(9774, 0, 0, 0,  97, 0, 255,       "", "BPTB" , "Technicien du bâtiment : organisation réalisation du gros œuvre"),
(9775, 0, 0, 0,  97, 0, 255,       "", "BPTFC", "Technicien du froid et du conditionnement de l’air"),
(9776, 0, 0, 0,  97, 0, 255,       "", "BPTEB", "Technicien d’études du bâtiment"),
(9777, 0, 0, 0,  97, 0, 255,       "", "BPTU" , "Technicien d’usinage"), -- dernière session 2023
(9778, 0, 0, 0,  97, 0, 255,       "", "BPTCI", "Technicien en chaudronnerie industrielle"), -- première session 2021
(9779, 0, 0, 0,  97, 0, 255,       "", "BPTIC", "Technicien en installation de syst. énergétiques et climatiques"),
(9780, 0, 0, 0,  97, 0, 255,       "", "BPTGT", "Technicien géomètre topographe"),
(9781, 0, 0, 0,  97, 0, 255,       "", "BPTMA", "Technicien menuisier agenceur"),
(9782, 0, 0, 0,  97, 0, 255,       "", "BPTM" , "Technicien modeleur"),
(9783, 0, 0, 0,  97, 0, 255,       "", "BPTO" , "Technicien outilleur"), -- dernière session 2023
(9784, 0, 0, 0,  97, 0, 255,       "", "BPTDM", "Traitements des matériaux"), -- ex "Traitements de surfaces"
(9785, 0, 0, 0,  97, 0, 255,       "", "BPTRA", "Transport"), -- dernière session 2022
(9786, 0, 0, 0,  97, 0, 255,       "", "BPTF" , "Transport fluvial"),
(9787, 0, 0, 0,  97, 0, 255,       "", "BPTP" , "Travaux publics"),
(9788, 0, 0, 0,  97, 0, 255,       "", "BPV"  , "Vente (prospection-négociation-suivi de clientèle)"), -- dernière session 2021
(9789, 0, 0, 0,  97, 0, 255,       "", "BPAOO", "Artisanat et métiers d’art - Facteur d’orgues option Organier"),
(9790, 0, 0, 0,  97, 0, 255,       "", "BPAOT", "Artisanat et métiers d’art - Facteur d’orgues option Tuyautier"),
(9791, 0, 0, 0,  97, 0, 255,       "", "BPMVA", "Maintenance des véhicules - option A voitures particulières"),    -- première session 2017
(9792, 0, 0, 0,  97, 0, 255,       "", "BPMVB", "Maintenance des véhicules - option B véh. de transport routier"), -- première session 2017
(9793, 0, 0, 0,  97, 0, 255,       "", "BPMVC", "Maintenance des véhicules - option C motocycles"),                -- première session 2017
(9794, 0, 0, 0,  97, 0, 255,       "", "BPMAV", "Menuiserie aluminium verre"),
(9795, 0, 0, 0,  97, 0, 255,       "", "BPMS" , "Métiers de la sécurité"), -- remplace 9766 -- première session 2017
(9796, 0, 0, 0,  97, 0, 255,       "", "BPRPG", "Réal. de prod. imprimés et plurimédia option A prod. graphiques"), -- remplace 9760 -- première session 2017
(9797, 0, 0, 0,  97, 0, 255,       "", "BPRPI", "Réal. de prod. imprimés et plurimédia option B prod. imprimées"),  -- remplace 9761 -- première session 2017
(9798, 0, 0, 0,  97, 0, 255,       "", "BPTIN", "Techniques d’interventions sur installations nucléaires"), -- remplace 9726 -- première session 2017

-- 98 Champs professionnels en SEGPA (http://www.education.gouv.fr/cid24467/mene0900316c.html)

(9801, 0, 0, 0,  98, 0, 255,       "", "CPHAB", "Habitat"),
(9802, 0, 0, 0,  98, 0, 255,       "", "CPHAS", "Hygiène - Alimentation - Services"),
(9803, 0, 0, 0,  98, 0, 255,       "", "CPERE", "Espace rural et environnement"),
(9804, 0, 0, 0,  98, 0, 255,       "", "CPVDM", "Vente - Distribution - Magasinage"),
(9805, 0, 0, 0,  98, 0, 255,       "", "CPPI" , "Production industrielle"),

-- 99 Matières principales

(9901, 0, 0, 1,  99, 0, 255,       "", "P1"   , "P1 Maîtrise de la langue française"),
(9902, 0, 0, 1,  99, 0, 255,       "", "P2"   , "P2 Pratique d’une langue vivante étrangère"),
(9903, 0, 0, 1,  99, 0, 255,       "", "P3A"  , "P3 Principaux éléments de mathématiques"),
(9904, 0, 0, 1,  99, 0, 255,       "", "P3B"  , "P3 Culture scientifique et technologique"),
(9905, 0, 0, 1,  99, 0, 255,       "", "P4"   , "P4 Maîtrise des TICE"),
(9906, 0, 0, 1,  99, 0, 255,       "", "P5"   , "P5 Culture humaniste"),
(9907, 0, 0, 1,  99, 0, 255,       "", "P6"   , "P6 Compétences sociales et civiques"),
(9908, 0, 0, 1,  99, 0, 255,       "", "P7"   , "P7 Autonomie et initiative"),
(9911, 0, 0, 1,  99, 0, 255,       "", "APS"  , "Apprendre à porter secours"),
(9912, 0, 0, 1,  99, 0, 255,       "", "PSC1" , "Prévention et secours civiques de niveau 1"),
(9913, 0, 0, 1,  99, 0, 255,       "", "PSC2" , "Prévention et secours civiques de niveau 2"),
(9921, 0, 0, 1,  99, 0, 255,       "", "APER" , "Attestation de première éducation à la route"),
(9922, 0, 0, 1,  99, 0, 255,       "", "ASSR1", "Attestation scolaire de sécurité routière de niveau 1"),
(9923, 0, 0, 1,  99, 0, 255,       "", "ASSR2", "Attestation scolaire de sécurité routière de niveau 2"),
(9931, 0, 0, 1,  99, 0, 255,       "", "D1"   , "D1 Les langages pour penser et communiquer"),
(9932, 0, 0, 1,  99, 0, 255,       "", "D2"   , "D2 Les méthodes et outils pour apprendre"),
(9933, 0, 0, 1,  99, 0, 255,       "", "D3"   , "D3 La formation de la personne et du citoyen"),
(9934, 0, 0, 1,  99, 0, 255,       "", "D4"   , "D4 Les systèmes naturels et les systèmes techniques"),
(9935, 0, 0, 1,  99, 0, 255,       "", "D5"   , "D5 Les représentations du monde et l’activité humaine"),
(9941, 0, 0, 1,  99, 0, 255,       "", "C23QM", "C23 Questionner le monde"),
(9942, 0, 0, 1,  99, 0, 255,       "", "C23ST", "C23 Sciences et technologie"),
(9943, 0, 0, 1,  99, 0, 255,       "", "C23EA", "C23 Enseignements artistiques"),
(9944, 0, 0, 1,  99, 0, 255,       "", "C23LV", "C23 Langue vivante"),
(9951, 0, 0, 1,  99, 0, 255,       "", "C1LAN", "C1 Mobiliser le langage dans toutes ses dimensions"),
(9952, 0, 0, 1,  99, 0, 255,       "", "C1AP" , "C1 Agir, s’exprimer, comprendre à travers l’activité physique"),
(9953, 0, 0, 1,  99, 0, 255,       "", "C1AA" , "C1 Agir, s’exprimer, comprendre à travers les activités artistiques"),
(9954, 0, 0, 1,  99, 0, 255,       "", "C1OSP", "C1 Construire les premiers outils pour structurer sa pensée"),
(9955, 0, 0, 1,  99, 0, 255,       "", "C1EM" , "C1 Explorer le monde"),
(9991, 0, 0, 1,  99, 0, 255,       "", "DOC"  , "Documentation"),
(9992, 0, 0, 1,  99, 0, 255,       "", "INFO" , "Informatique"),
(9993, 0, 0, 1,  99, 0, 255,       "", "EMI"  , "Éducation aux Médias et à l’Information"),
(9999, 0, 0, 1,  99, 0, 255,       "", "TRANS", "Transversal");

ALTER TABLE sacoche_matiere ENABLE KEYS;
