/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2018
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d’Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

// Activer le mode strict afin de tendre vers un code rigoureux
'use strict';

// jQuery !
$(document).ready
(
  function()
  {

    // ////////////////////////////////////////////////////////////////////////////////////////////////////
    // Traitement du premier formulaire pour afficher la liste des élèves d’un regroupement
    // ////////////////////////////////////////////////////////////////////////////////////////////////////

    var recharger_page = function()
    {
      var groupe_id = $('#f_groupe_id').val();
      if(groupe_id)
      {
        var groupe_type = $('#f_groupe_id option:selected').parent().attr('label');
        $('#f_groupe_type').val(groupe_type);
      }
      $('#form_prechoix').attr('action','./index.php?page=evaluation&section=crcn');
      $('#form_prechoix').submit();
    }

    $('#bouton_annuler').click
    (
      function()
      {
        $(window).off('beforeunload', confirmOnLeave );
        $('#f_groupe_id').prop('disabled',false);
        recharger_page();
      }
    );

    // ////////////////////////////////////////////////////////////////////////////////////////////////////
    // Charger le select f_eleve_id en ajax (pour un parent de plusieurs enfants)
    // ////////////////////////////////////////////////////////////////////////////////////////////////////

    function maj_eleve(groupe_id,groupe_type)
    {
      $.ajax
      (
        {
          type : 'POST',
          url : 'ajax.php?page=_maj_select_eleves',
          data : 'f_groupe_id='+groupe_id+'&f_groupe_type='+groupe_type+'&f_eleves_ordre=nom'+'&f_statut=1',
          dataType : 'json',
          error : function(jqXHR, textStatus, errorThrown)
          {
            $('#ajax_maj').attr('class','alerte').html(afficher_json_message_erreur(jqXHR,textStatus));
          },
          success : function(responseJSON)
          {
            initialiser_compteur();
            if(responseJSON['statut']==true)
            {
              $('#ajax_maj').removeAttr('class').html('');
              $('#f_eleve_id').html(responseJSON['value']).parent().show();
              if($('#f_eleve_id option').length==2)
              {
                // Cas d’un seul élève retourné dans le regroupement (en particulier pour un parent de plusieurs enfants)
                $('#f_eleve_id option').eq(1).prop('selected',true);
                recharger_page();
              }
            }
            else
            {
              $('#ajax_maj').attr('class','alerte').html(responseJSON['value']);
            }
          }
        }
      );
    }

    $('#f_groupe_id').change
    (
      function()
      {
        if(user_profil=='parent')
        {
          var groupe_type = $('#f_groupe_id option:selected').parent().attr('label');
          // Pour un parent de plusieurs enfants, on met à jour f_eleve_id
          $('#f_eleve_id').html('<option value=""></option>').parent().hide();
          $('#ajax_maj').removeAttr('class').html('');
          var groupe_id = $('#f_groupe_id option:selected').val();
          if(groupe_id)
          {
            $('#ajax_maj').attr('class','loader').html('En cours&hellip;');
            maj_eleve(groupe_id,groupe_type);
          }
          else
          {
            $('#label_crcn , #table_crcn').remove();
            $('#ajax_maj').removeAttr('class').html('');
          }
        }
        else
        {
          recharger_page();
        }
      }
    );

    $('#f_eleve_id').change
    (
      function()
      {
        if(user_profil=='parent')
        {
          var eleve_id = $('#f_eleve_id option:selected').val();
          if(eleve_id)
          {
            recharger_page();
          }
          else
          {
            $('#label_crcn , #table_crcn').remove();
            $('#ajax_maj').removeAttr('class').html('');
          }
        }
      }
    );

    // ////////////////////////////////////////////////////////////////////////////////////////////////////
    // Action sur les cases du tableau
    // ////////////////////////////////////////////////////////////////////////////////////////////////////

    function alerter_modification()
    {
      $('#f_groupe_id').prop('disabled',true);
      $('#ajax_maj').attr('class','alerte').html('Confirmez ou annulez vos modifications avant de changer de classe / groupe.');
      $(window).on('beforeunload', confirmOnLeave );
    }

    $('table.saisie_crcn').on
    (
      'click',
      'th[data-cible]',
      function()
      {
        var obj_th = $(this);
        var cible  = obj_th.attr('data-cible');
        var numero = $('input[type=radio]:checked').val();
        if( cible == 'all' )
        {
          $('table.saisie_crcn').children('tbody').children('tr').children('td').html(numero);
        }
        if( cible == 'domaine' )
        {
          obj_th.parent().parent().children('tr').children('td').html(numero);
        }
        if( cible == 'competence' )
        {
          obj_th.parent().children('td').html(numero);
        }
        if( cible == 'eleve' )
        {
          var rang = obj_th.attr('data-rang');
          $('table.saisie_crcn').children('tbody').children('tr').each( function(){$(this).children('td').eq(rang).html(numero);} );
        }
        if( cible == 'eleve_domaine' )
        {
          var rang = obj_th.attr('data-rang');
          obj_th.parent().parent().children('tr').each( function(){$(this).children('td').eq(rang).html(numero);} );
        }
        alerter_modification();
      }
    );

    $('table.saisie_crcn').on
    (
      'click',
      'td[data-cible]',
      function()
      {
        var obj_td = $(this);
        var numero = $('input[type=radio]:checked').val();
        $(this).html(numero);
        alerter_modification();
      }
    );

    // ////////////////////////////////////////////////////////////////////////////////////////////////////
    // Enregistrer les changements
    // ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#bouton_valider').click
    (
      function()
      {
        // Grouper les valeurs dans un champ unique afin d’éviter tout problème avec une limitation du module "suhosin" (voir par exemple http://xuxu.fr/2008/12/04/nombre-de-variables-post-limite-ou-tronque) ou "max input vars" généralement fixé à 1000.
        var tab_eleve      = new Array();
        var tab_competence = new Array();
        var tab_niveau     = new Array();
        $('table.saisie_crcn').children('tbody').children('tr').children('td').each
        (
          function()
          {
            var obj_td = $(this);
            var eleve      = obj_td.data('eleve');
            var competence = obj_td.data('competence');
            var niveau     = obj_td.html();
            niveau = (isNaN(entier(niveau))) ? 0 : niveau ;
            tab_eleve.push(eleve);
            tab_competence.push(competence);
            tab_niveau.push(niveau);
          }
        );
        $('#form_prechoix button').prop('disabled',true);
        $('#ajax_maj').attr('class','loader').html('En cours&hellip;');
        $.ajax
        (
          {
            type : 'POST',
            url : 'ajax.php?page='+PAGE,
            data : 'csrf='+CSRF+'&f_action=enregistrer'+'&f_eleve_liste='+tab_eleve+'&f_competence_liste='+tab_competence+'&f_niveau_liste='+tab_niveau,
            dataType : 'json',
            error : function(jqXHR, textStatus, errorThrown)
            {
              $('#form_prechoix button').prop('disabled',false);
              $('#ajax_maj').attr('class','alerte').html(afficher_json_message_erreur(jqXHR,textStatus));
              return false;
            },
            success : function(responseJSON)
            {
              initialiser_compteur();
              $('#form_prechoix button').prop('disabled',false);
              if(responseJSON['statut']==true)
              {
                $(window).off('beforeunload', confirmOnLeave );
                $('#ajax_maj').attr('class','valide').html('Demande réalisée !');
                $('#f_groupe_id').prop('disabled',false);
             }
              else
              {
                $('#ajax_maj').attr('class','alerte').html(responseJSON['value']);
              }
            }
          }
        );
      }
    );

  }
);
