<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2018
 * 
 * ****************************************************************************************************
 * SACoche <https://sacoche.sesamath.net> - Suivi d’Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <https://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}

// DÉBUT NON PRISE EN COMPE SI INCLUSION DEPUIS livret_crcn.php
if($PAGE=='evaluation_crcn'):

$TITRE = in_array($_SESSION['USER_PROFIL_TYPE'],array('eleve','parent')) ? html(Lang::_('Compétences numériques')) : html(Lang::_('Évaluer les compétences numériques')) ;

// Indication des profils autorisés
$puce_profil_consultation = in_array($_SESSION['USER_PROFIL_TYPE'],array('directeur','administrateur')) ? '<li><span class="danger">Les directeurs n’ont qu’un accès en consultation car leur profil n’est pas utilisé pour évaluer.</span></li>' : '' ;

Layout::add( 'js_inline_before' , 'var user_profil = "'.$_SESSION['USER_PROFIL_TYPE'].'";' );
?>

<ul class="puce">
  <li><span class="manuel"><a class="pop_up" href="<?php echo SERVEUR_DOCUMENTAIRE ?>?fichier=support_professeur__evaluations_crcn">DOC : Évaluation des compétences numériques (CRCN)</a></span></li>
  <li><span class="astuce">Ces positionnements sont utilisés pour le <b>dernier bilan périodique de CM2 et de 6e du Livret Scolaire</b>.</span></li>
  <?php echo $puce_profil_consultation ?>
</ul>

<hr />

<?php
endif;
// FIN NON PRISE EN COMPE SI INCLUSION DEPUIS livret_crcn.php

if( !DB_STRUCTURE_LIVRET::DB_tester_classes_crcn() )
{
  $consigne = ($_SESSION['USER_PROFIL_TYPE']=='professeur') ? 'un administrateur ou directeur doit commencer' : 'commencez' ;
  echo'<p class="danger">Aucune classe n’est associée à une page du livret concernée par ce dispositif !<br />Si besoin, '.$consigne.' par <a href="./index.php?page=livret&amp;section=classes">associer les classes au livret scolaire</a>.</p>'.NL;
  return; // Ne pas exécuter la suite de ce fichier inclus.
}

//Pour un lien depuis la page d’accueil
$eleve_id    = isset($_GET['eleve_id'])       ? Clean::entier($_GET['eleve_id'])        : 0;
$groupe_id   = isset($_GET['classe_id'])      ? Clean::entier($_GET['classe_id'])       : 0;
$groupe_type = isset($_GET['classe_id'])      ? 'c'                                     : '';
// Récupération des données transmises
$eleve_id    = isset($_POST['f_eleve_id'])    ? Clean::entier($_POST['f_eleve_id'])     : $eleve_id;
$groupe_id   = isset($_POST['f_groupe_id'])   ? Clean::entier($_POST['f_groupe_id'])    : $groupe_id;
$groupe_type = isset($_POST['f_groupe_type']) ? Clean::lettres($_POST['f_groupe_type']) : $groupe_type;
$numero      = isset($_POST['f_numero'])      ? Clean::entier($_POST['f_numero'])       : 1;

$tab_types = array( 'c'=>'classe' , 'g'=>'groupe' , 'b'=>'besoin' ) + array( 'Classes'=>'classe' , 'Groupes'=>'groupe' , 'Besoins'=>'besoin' );

if( $groupe_id && !isset($tab_types[$groupe_type]) )
{
  echo'<p class="danger">Type de groupe inattendu ("'.html($groupe_type).'").</p>';
  $groupe_id = 0;
}

// Fabrication des éléments select du formulaire
if( in_array($_SESSION['USER_PROFIL_TYPE'],array('directeur','administrateur')) )
{
  $tab_groupes = DB_STRUCTURE_COMMUN::DB_OPT_classes_groupes_etabl();
  $tab_eleves  = array(); // inutilisé
  $of_groupe  = '';
  $of_eleve   = FALSE;
  $sel_groupe = $groupe_id;
  $sel_eleve  = FALSE;
  $class_form_eleve = 'show';
  $class_bloc_eleve = 'hide';
}
if($_SESSION['USER_PROFIL_TYPE']=='professeur')
{
  $tab_groupes = ($_SESSION['USER_JOIN_GROUPES']=='config') ? DB_STRUCTURE_COMMUN::DB_OPT_groupes_professeur($_SESSION['USER_ID']) : DB_STRUCTURE_COMMUN::DB_OPT_classes_groupes_etabl() ;
  $tab_eleves  = array(); // inutilisé
  $of_groupe  = '';
  $of_eleve   = FALSE;
  $sel_groupe = $groupe_id;
  $sel_eleve  = FALSE;
  $class_form_eleve = 'show';
  $class_bloc_eleve = 'hide';
}
if( ($_SESSION['USER_PROFIL_TYPE']=='parent') && ($_SESSION['NB_ENFANTS']>1) )
{
  $tab_groupes = $_SESSION['OPT_PARENT_CLASSES'];
  $tab_eleves  = ($eleve_id) ? DB_STRUCTURE_COMMUN::DB_OPT_eleves_regroupement( 'classe' , $groupe_id , 1 /*statut*/ , 'nom' /*ordre*/ ) : array() ; // maj en ajax suivant le choix du groupe
  $of_groupe  = '';
  $of_eleve   = '';
  $sel_groupe = $groupe_id;
  $sel_eleve  = $eleve_id;
  $class_form_eleve = 'show';
  $class_bloc_eleve = ($eleve_id) ? 'show' : 'hide' ;
}
if( ($_SESSION['USER_PROFIL_TYPE']=='parent') && ($_SESSION['NB_ENFANTS']==1) )
{
  $tab_groupes = array( 0 => array( 'valeur'=>$_SESSION['ELEVE_CLASSE_ID'] , 'texte'=>$_SESSION['ELEVE_CLASSE_NOM'] , 'optgroup'=>'classe' ) );
  $tab_eleves  = array( 0 => array( 'valeur'=>$_SESSION['OPT_PARENT_ENFANTS'][0]['valeur'] , 'texte'=>$_SESSION['OPT_PARENT_ENFANTS'][0]['texte'] ) );
  $of_groupe  = FALSE;
  $of_eleve   = FALSE;
  $sel_groupe = $_SESSION['ELEVE_CLASSE_ID'];
  $sel_eleve  = $_SESSION['OPT_PARENT_ENFANTS'][0]['valeur'];
  $class_form_eleve = 'hide';
  $class_bloc_eleve = 'hide';
}
if($_SESSION['USER_PROFIL_TYPE']=='eleve')
{
  $tab_groupes = array( 0 => array( 'valeur'=>$_SESSION['ELEVE_CLASSE_ID'] , 'texte'=>$_SESSION['ELEVE_CLASSE_NOM'] , 'optgroup'=>'classe' ) );
  $tab_eleves  = array( 0 => array( 'valeur'=>$_SESSION['USER_ID'] , 'texte'=>$_SESSION['USER_NOM'].' '.$_SESSION['USER_PRENOM'] ) );
  $tab_profs   = DB_STRUCTURE_COMMUN::DB_OPT_profs_groupe( 'classe' , $_SESSION['ELEVE_CLASSE_ID'] );
  $of_groupe  = FALSE;
  $of_eleve   = FALSE;
  $sel_groupe = $_SESSION['ELEVE_CLASSE_ID'];
  $sel_eleve  = $_SESSION['USER_ID'];
  $class_form_eleve = 'hide';
  $class_bloc_eleve = 'hide';
}

$select_groupe = HtmlForm::afficher_select($tab_groupes , 'f_groupe_id' /*select_nom*/ , $of_groupe /*option_first*/ , $sel_groupe /*selection*/ , 'regroupements' /*optgroup*/ );
$select_eleve  = HtmlForm::afficher_select($tab_eleves  , 'f_eleve_id'  /*select_nom*/ , $of_eleve  /*option_first*/ , $sel_eleve  /*selection*/ ,              '' /*optgroup*/ );
?>

<form action="#" method="post" id="form_prechoix">
  <p class="<?php echo $class_form_eleve ?>">
    <label class="tab" for="f_groupe_id">Classe / groupe :</label><?php echo $select_groupe ?><input id="f_groupe_type" name="f_groupe_type" type="hidden" value="" /><label id="ajax_maj">&nbsp;</label><br />
    <span id="bloc_eleve" class="<?php echo $class_bloc_eleve ?>"><label class="tab" for="f_eleve_id">Élève :</label><?php echo $select_eleve ?></span>
  </p>

<?php
if( !$sel_groupe || ( !$sel_eleve && in_array($_SESSION['USER_PROFIL_TYPE'],array('eleve','parent')) ) )
{
  echo'</form>';
  return; // Ne pas exécuter la suite de ce fichier inclus.
}

// Lister les élèves
if( !in_array($_SESSION['USER_PROFIL_TYPE'],array('eleve','parent')) )
{
  $tab_thead = array();
  $DB_TAB = DB_STRUCTURE_COMMUN::DB_lister_users_regroupement( 'eleve' /*profil_type*/ , 1 /*statut*/ , $tab_types[$groupe_type] , $sel_groupe , 'nom' /*eleves_ordre*/ , 'user_id,user_nom,user_prenom' /*champs*/ );
  if(empty($DB_TAB))
  {
    echo'</form>';
    echo'<p class="danger">Aucun élève trouvé dans ce regroupement !</p>';
    return; // Ne pas exécuter la suite de ce fichier inclus.
  }
  foreach($DB_TAB as $DB_ROW)
  {
    $tab_thead[$DB_ROW['user_id']] = '<th><dfn>'.html($DB_ROW['user_nom']).' '.html($DB_ROW['user_prenom']).'</dfn></th>';
  }
  $tab_eleve_id = array_keys($tab_thead);
  $listing_eleve_id = implode(',',$tab_eleve_id);
}
else
{
  $listing_eleve_id = $sel_eleve;
}

// Lister les niveaux de maîtrise
$tab_radio_boutons = array();
$tab_niveau_public = array(
  0 => '',
  3 => 'CYCLE 2 / CYCLE 3',
  5 => 'CYCLE 4 / LYCÉE',
  6 => 'SUPÉRIEUR / ADULTE',
);
$DB_TAB_NIVEAUX = DB_STRUCTURE_LIVRET::DB_lister_crcn_niveaux();
if( !in_array($_SESSION['USER_PROFIL_TYPE'],array('eleve','parent')) )
{
  foreach($DB_TAB_NIVEAUX as $DB_ROW)
  {
    $infobulle = ($DB_ROW['crcn_niveau_numero']) ? infobulle($tab_niveau_public[$DB_ROW['crcn_niveau_cycle']].BRJS.$DB_ROW['crcn_niveau_description']) : '' ;
    $texte     = ($DB_ROW['crcn_niveau_numero']) ? '<b>'.$DB_ROW['crcn_niveau_numero'].'</b>&nbsp;'.$DB_ROW['crcn_niveau_categorie'] : 'Non renseigné' ;
    $value     = ($DB_ROW['crcn_niveau_numero']) ? $DB_ROW['crcn_niveau_numero'] : '&nbsp;' ;
    $checked   = ($DB_ROW['crcn_niveau_numero']==$numero) ? ' checked="checked"' : '' ;
    $disabled  = ($DB_ROW['crcn_niveau_cycle']>5) ? ' disabled="disabled"' : '' ;
    $input     = ($_SESSION['USER_PROFIL_TYPE']=='professeur') ? '<input type="radio" id="numero_'.$DB_ROW['crcn_niveau_numero'].'" name="f_numero" value="'.$value.'"'.$checked.$disabled.' />&nbsp;' : '' ;
    $tab_radio_boutons[] = '<label for="numero_'.$DB_ROW['crcn_niveau_numero'].'" class="crcn_niveau_'.$DB_ROW['crcn_niveau_numero'].'"'.$infobulle.'>&nbsp;'.$input.$texte.'&nbsp;</label>';
  }
  $radio_boutons = implode('<br /><span class="tab"></span>',$tab_radio_boutons);
}
else
{
  unset($DB_TAB_NIVEAUX[0]);
  foreach($DB_TAB_NIVEAUX as $DB_ROW)
  {
    $infobulle = infobulle($tab_niveau_public[$DB_ROW['crcn_niveau_cycle']].BRJS.$DB_ROW['crcn_niveau_description']);
    $texte     = '<b>'.$DB_ROW['crcn_niveau_numero'].'</b>&nbsp;'.$DB_ROW['crcn_niveau_categorie'];
    $value     = $DB_ROW['crcn_niveau_numero'];
    $tab_radio_boutons[] = '<label class="crcn_niveau_'.$DB_ROW['crcn_niveau_numero'].'"'.$infobulle.'>&nbsp;'.$texte.'&nbsp;</label>';
  }
  $radio_boutons = implode(' ',$tab_radio_boutons);
}
// Lister les domaines et leurs compétences
$tab_tbody = array();
$memo_domaine = 0;
$DB_TAB = DB_STRUCTURE_LIVRET::DB_lister_crcn_domaines_competences( TRUE /*with_detail*/);
foreach($DB_TAB as $DB_ROW)
{
  if($DB_ROW['crcn_domaine_id']!=$memo_domaine)
  {
    $tab_tbody[$DB_ROW['crcn_domaine_id']][0] = '<th><b>'.html($DB_ROW['crcn_domaine_libelle']).'</b></th>';
    $memo_domaine = $DB_ROW['crcn_domaine_id'];
  }
  $description = 'DESCRIPTION'.BRJS.$DB_ROW['crcn_competence_description']
               . BRJS.BRJS.'NIVEAU 1'.BRJS.$DB_ROW['crcn_competence_niveau_1']
               . BRJS.BRJS.'NIVEAU 2'.BRJS.$DB_ROW['crcn_competence_niveau_2']
               . BRJS.BRJS.'NIVEAU 3'.BRJS.$DB_ROW['crcn_competence_niveau_3']
               . BRJS.BRJS.'NIVEAU 4'.BRJS.$DB_ROW['crcn_competence_niveau_4']
               . BRJS.BRJS.'NIVEAU 5'.BRJS.$DB_ROW['crcn_competence_niveau_5'];
  $tab_tbody[$DB_ROW['crcn_domaine_id']][$DB_ROW['crcn_competence_id']] = '<th>'.infobulle($description,TRUE).' '.html($DB_ROW['crcn_competence_libelle']).'</th>';
}

// Lister niveaux déjà saisis
$tab_saisies = array();
$DB_TAB = DB_STRUCTURE_LIVRET::DB_lister_crcn_saisies( $listing_eleve_id , FALSE /*only_positif*/ );
foreach($DB_TAB as $DB_ROW)
{
  $verbe = ($DB_ROW['crcn_niveau_numero']) ? 'renseigné' : 'retiré' ;
  $identite = ($DB_ROW['prof_nom']) ? To::texte_identite( $DB_ROW['prof_nom'] , FALSE , $DB_ROW['prof_prenom'] , TRUE , $DB_ROW['prof_genre'] ) : ( ($DB_ROW['prof_id']) ? 'l’ancien compte n°'.$DB_ROW['prof_id'] : 'un établissement antérieur' ) ;
  $tab_saisies[$DB_ROW['eleve_id']][$DB_ROW['crcn_competence_id']] = array(
    'val'   => $DB_ROW['crcn_niveau_numero'],
    'title' => $verbe.' le '.To::date_sql_to_french($DB_ROW['crcn_saisie_date']).' par '.$identite,
  );
}

if( in_array($_SESSION['USER_PROFIL_TYPE'],array('eleve','parent')) )
{
  echo'<p id="label_crcn"><label class="tab">Niveau de maîtrise :</label>'.$radio_boutons.'</p>';
}
?>
<table id="table_crcn" class="saisie_crcn">
  <?php if( !in_array($_SESSION['USER_PROFIL_TYPE'],array('eleve','parent')) ): ?>
  <thead>
    <tr>
      <td rowspan="2">
        <?php
        echo'<label class="tab">Niveau de maîtrise :</label>'.$radio_boutons;
        if($_SESSION['USER_PROFIL_TYPE']=='professeur')
        {
          echo'<p class="hc"><button id="bouton_valider" type="button" class="valider">Enregistrer.</button> <button id="bouton_annuler" type="button" class="annuler">Annuler.</button></p>';
        }
        ?>
      </td>
      <td></td>
      <?php echo implode('',$tab_thead); ?>
    </tr>
    <tr>
      <?php
      echo ($puce_profil_consultation) ? '<th'.infobulle('Inactif pour les directeurs et les administrateurs.').'>&#8664;</th>' : '<th data-cible="all"'.infobulle('Appliquer le niveau de maîtrise à toutes les compétences de tous les élèves.').'>&#8664;</th>' ;
      foreach($tab_eleve_id as $key => $eleve_id)
      {
        echo ($puce_profil_consultation) ? '<th'.infobulle('Inactif pour les directeurs et les administrateurs.').'>&#8659;</th>' : '<th data-cible="eleve" data-rang="'.$key.'"'.infobulle('Appliquer le niveau de maîtrise à toutes les compétences de cet élève.').'>&#8659;</th>' ;
      }
      ?>
    </tr>
  </thead>
  <?php endif; ?>
  <?php
    foreach($tab_tbody as $domaine_id => $tab_tbody_domaine)
    {
      echo'<tbody class="crcn_domaine_'.$domaine_id.'">';
      if( !in_array($_SESSION['USER_PROFIL_TYPE'],array('eleve','parent')) )
      {
        echo'<tr>'.$tab_tbody_domaine[0];
        echo ($puce_profil_consultation) ? '<th'.infobulle('Inactif pour les directeurs et les administrateurs.').'>&#8600;</th>' : '<th data-cible="domaine"'.infobulle('Appliquer le niveau de maîtrise aux compétences de tous les élèves pour ce domaine.').'>&#8600;</th>' ;
        foreach($tab_eleve_id as $key => $eleve_id)
        {
          echo ($puce_profil_consultation) ? '<th'.infobulle('Inactif pour les directeurs et les administrateurs.').'>&#8595;</th>' : '<th data-cible="eleve_domaine" data-rang="'.$key.'" data-domaine="'.$domaine_id.'"'.infobulle('Appliquer le niveau de maîtrise aux compétences de cet élève pour ce domaine.').'>&#8595;</th>' ;
        }
        echo'</tr>';
        unset( $tab_tbody_domaine[0] );
        foreach($tab_tbody_domaine as $competence_id => $th_competence)
        {
          echo'<tr>'.$th_competence;
          echo ($puce_profil_consultation) ? '<th'.infobulle('Inactif pour les directeurs et les administrateurs.').'>&#8594;</th>' : '<th data-cible="competence"'.infobulle('Appliquer le niveau de maîtrise à cette compétence pour tous les élèves.').'>&#8594;</th>' ;
          foreach($tab_eleve_id as $key => $eleve_id)
          {
            $value = !empty($tab_saisies[$eleve_id][$competence_id]['val']) ? $tab_saisies[$eleve_id][$competence_id]['val'] : '&nbsp;' ; // pas de saisie ou saisie NULL (supprimée)
            $title = isset($tab_saisies[$eleve_id][$competence_id]) ? infobulle($tab_saisies[$eleve_id][$competence_id]['title']) : ( ($puce_profil_consultation) ? infobulle('Inactif pour les directeurs et les administrateurs.') : '' ) ;
            echo ($puce_profil_consultation) ? '<td'.$title.'>'.$value.'</td>' : '<td data-cible="eleve_competence" data-eleve="'.$eleve_id.'" data-competence="'.$competence_id.'"'.$title.'>'.$value.'</td>' ;
          }
          echo'</tr>';
        }
      }
      else
      {
        echo'<tr>'.str_replace('<th>','<th colspan="2">',$tab_tbody_domaine[0]).'</tr>';
        unset( $tab_tbody_domaine[0] );
        foreach($tab_tbody_domaine as $competence_id => $th_competence)
        {
          echo'<tr>'.$th_competence;
          $value = !empty($tab_saisies[$sel_eleve][$competence_id]['val']) ? $tab_saisies[$sel_eleve][$competence_id]['val'] : '' ; // pas de saisie ou saisie NULL (supprimée)
          $title = isset($tab_saisies[$sel_eleve][$competence_id]) ? infobulle($tab_saisies[$sel_eleve][$competence_id]['title'],TRUE) : '' ;
          $texte = ($value) ? '<b>Niveau '.$value.'</b>' : '&nbsp;Non&nbsp;renseigné&nbsp;' ;
          echo'<td>'.$texte.' '.$title.'</td>';
          echo'</tr>';
        }
      }
      echo'</tbody>';
    }
  ?>
</table>

</form>

<p />
