/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2018
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d’Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

// Activer le mode strict afin de tendre vers un code rigoureux
'use strict';

// jQuery !
$(document).ready
(
  function()
  {

    // ////////////////////////////////////////////////////////////////////////////////////////////////////
    // Actualiser l’affichage des vignettes élèves au changement du select pour un regroupement donné
    // ////////////////////////////////////////////////////////////////////////////////////////////////////

    function maj_affichage()
    {
      $('#bilan').html('');
      // On récupère le regroupement
      var groupe_val = $('#f_groupe option:selected').val();
      if(!groupe_val)
      {
        $('#ajax_msg').removeAttr('class').html('');
        return false
      }
      // Pour un directeur ou un administrateur, groupe_val est de la forme d3 / n2 / c51 / g44
      if(isNaN(entier(groupe_val)))
      {
        var groupe_type = groupe_val.substring(0,1);
        var groupe_id   = groupe_val.substring(1);
      }
      // Pour un professeur, groupe_val est un entier, et il faut récupérer la 1ère lettre du label parent
      else
      {
        var groupe_type = $('#f_groupe option:selected').parent().attr('label').substring(0,1).toLowerCase();
        var groupe_id   = groupe_val;
      }
      var groupe_nom = $('#f_groupe option:selected').text();
      $('#ajax_msg').attr('class','loader').html('En cours&hellip;');
      $.ajax
      (
        {
          type : 'POST',
          url : 'ajax.php?page='+PAGE,
          data : 'csrf='+CSRF+'&f_action=generer_groupe'+'&f_groupe_id='+groupe_id+'&f_groupe_type='+groupe_type+'&f_groupe_nom='+groupe_nom,
          dataType : 'json',
          error : function(jqXHR, textStatus, errorThrown)
          {
            $('#ajax_msg').attr('class','alerte').html(afficher_json_message_erreur(jqXHR,textStatus));
          },
          success : function(responseJSON)
          {
            initialiser_compteur();
            if(responseJSON['statut']==false)
            {
              $('#ajax_msg').attr('class','alerte').html(responseJSON['value']);
            }
            else
            {
              $('#ajax_msg').attr('class','valide').html('Demande réalisée !');
              $('#bilan').html(responseJSON['value']);
            }
          }
        }
      );
    }

    $('#f_groupe').change
    (
      function()
      {
        maj_affichage();
      }
    );

    // ////////////////////////////////////////////////////////////////////////////////////////////////////
    // Générer un PDF pour plusieurs regroupements d’un coup
    // ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#bouton_valider_multiple').click
    (
      function()
      {
        $('#bilan').html('');
        if( !$('#f_groupe_multiple input:checked').length )
        {
          $('#ajax_msg_multiple').attr('class','erreur').html('Sélectionnez au moins un regroupement !');
          return false;
        }
        $('#form_select_multiple button').prop('disabled',true);
        $('#ajax_msg_multiple').attr('class','loader').html('En cours&hellip;');
        // Grouper les checkbox dans un champ unique afin d’éviter tout problème avec une limitation du module "suhosin" (voir par exemple http://xuxu.fr/2008/12/04/nombre-de-variables-post-limite-ou-tronque) ou "max input vars" généralement fixé à 1000.
        var tab_groupe_multiple = new Array();
        $('#f_groupe_multiple input:checked').each
        (
          function()
          {
            tab_groupe_multiple.push($(this).val());
          }
        );
        $.ajax
        (
          {
            type : 'POST',
            url : 'ajax.php?page='+PAGE,
            data : 'csrf='+CSRF+'&f_action=generer_multiple'+'&f_groupe_multiple='+tab_groupe_multiple,
            dataType : 'json',
            error : function(jqXHR, textStatus, errorThrown)
            {
              $('#form_select_multiple button').prop('disabled',false);
              $('#ajax_msg_multiple').attr('class','alerte').html(afficher_json_message_erreur(jqXHR,textStatus));
              return false;
            },
            success : function(responseJSON)
            {
              initialiser_compteur();
              $('#form_select_multiple button').prop('disabled',false);
              if(responseJSON['statut']==true)
              {
                $('#ajax_msg_multiple').attr('class','valide').html('Demande réalisée !');
                $('#bilan_multiple').html(responseJSON['value']);
              }
              else
              {
                $('#ajax_msg_multiple').attr('class','alerte').html(responseJSON['value']);
              }
            }
          }
        );
      }
    );

    $('#form_select_multiple input').change
    (
      function()
      {
        $('#ajax_msg_multiple').removeAttr('class').html('');
        $('#bilan_multiple').html('');
      }
    );

  }
);
