<?php
if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}

// Appeler [adresse-de-sacoche]/webservices.php?qui=devexterne_netsynchro

// Ouverture de la session et gestion des droits d’accès
$PAGE = 'webservices';
Session::recuperer_droit_acces($PAGE);
Session::execute();

// Informations sur l’hébergement
require_once(CHEMIN_DOSSIER_PRIVATE_CONFIG.'constantes.php');

$page = 'webservices.php?qui=devexterne_netsynchro';

$test = (isset($_GET['test'])) ? Clean::entier($_GET['test']) : 0 ;

Erreur500::prevention_et_gestion_erreurs_fatales( TRUE /*memory*/ , FALSE /*time*/ );

require('netsynchro/class.cURL_DEV.php');
?>

<h2>NetSynchro</h2>

<ul>
  <li>
    1. Valider la connexion en récupérant le fichier élèves avec adresse d’un établissement de l’académie de Lille
    <ul>
      <li><a href="<?php echo $page ?>&test=11">Étape 1</a></li>
      <li><a href="<?php echo $page ?>&test=12">Étape 2</a></li>
    </ul>
  </li>
</ul>

<hr />

<pre>

<?php

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// 0. Convertir certificat PKS en PEM
// ////////////////////////////////////////////////////////////////////////////////////////////////////

function pks2pem($name_without_extension,$keypass)
{
  $password = $name_without_extension;
  $file_pem = CHEMIN_DOSSIER_WEBSERVICES.'netsynchro'.DS.$name_without_extension.'.pem';
  if(!is_file($file_pem))
  {
    $file_p12 = CHEMIN_DOSSIER_WEBSERVICES.'netsynchro'.DS.$name_without_extension.'.p12';
    if(!is_file($file_p12))
    {
      $file_jks = CHEMIN_DOSSIER_WEBSERVICES.'netsynchro'.DS.$name_without_extension.'.jks';
      if(!is_file($file_jks))
      {
        exit('Fichier '.$file_jks.' manquant !');
      }
      // jks -> p12
      // https://gist.github.com/Hakky54/049299f0874fd4b870257c6458e0dcbd
      exec('keytool -importkeystore -srckeystore '.$file_jks.' -destkeystore '.$file_p12.' -srcstoretype JKS -deststoretype PKCS12 -destkeypass '.$keypass);
      if(!is_file($file_p12))
      {
        exit('Fichier '.$file_p12.' non obtenu à partir de '.$file_jks.' !');
      }
    }
    // p12 -> pem
    // méthode 1
    // https://stackoverflow.com/questions/5422205/convert-p12-to-pem-using-php-and-openssl
    $results = array();
    $worked = openssl_pkcs12_read( file_get_contents($file_p12), $results, $password );
    if($worked)
    {
      file_put_contents($file_pem, $results['cert']);
      file_put_contents($file_pem.'.pkey', $results['pkey']);
    }
    else
    {
      echo __LINE__.' : '.openssl_error_string()."\r\n";
      // méthode 2
      // https://gist.github.com/Hakky54/049299f0874fd4b870257c6458e0dcbd
      exec('openssl pkcs12 -in '.$file_p12.' -out '.$file_pem);
      if(!is_file($file_pem))
      {
        exit('Fichier '.$file_pem.' non obtenu à partir de '.$file_p12.' !');
      }
    }
  }
  return $file_pem;
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// 1. Valider la connexion en récupérant le fichier élèves avec adresse d’un établissement de l’académie de Lille
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($test==11)
{
  $url      = 'https://ses2d-aca1.ac-dijon.fr/netsync/api/flux/recup/async/sco-ele-adr';
  $keypass  = '0211150L.ac-dijon.fr';
  $keystore = pks2pem('0211150L.ac-dijon.fr_2021',$keypass);
  ;
  $tab_get = array(
    'Code-Rne'        => '0622863A',
    'Compression-Zip' => FALSE,
  );
  
  $curl_response = cURL_DEV::netsynchro( $url , $keystore , $keypass , $tab_get );
  var_dump($curl_response);
}

?>
</pre>