DROP TABLE IF EXISTS sacoche_parametre;

CREATE TABLE sacoche_parametre (
  parametre_nom    VARCHAR(50)  COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  parametre_valeur VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  PRIMARY KEY (parametre_nom)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE sacoche_parametre DISABLE KEYS;

INSERT INTO sacoche_parametre VALUES 
( "calcul_limite"                                    , "5" ),
( "calcul_methode"                                   , "geometrique" ),
( "calcul_retroactif"                                , "oui" ),
( "cas_serveur_host"                                 , "" ),
( "cas_serveur_port"                                 , "" ),
( "cas_serveur_root"                                 , "" ),
( "cas_serveur_url_login"                            , "" ),
( "cas_serveur_url_logout"                           , "" ),
( "cas_serveur_url_validate"                         , "" ),
( "cas_serveur_verif_certif_ssl"                     , "1" ),
( "cas_service_api_key"                              , "" ),
( "connexion_departement"                            , "" ),
( "connexion_mode"                                   , "normal" ),
( "connexion_nom"                                    , "sacoche" ),
( "date_last_import_eleves"                          , "0000-00-00" ),
( "date_last_import_parents"                         , "0000-00-00" ),
( "date_last_import_professeurs"                     , "0000-00-00" ),
( "deconnexion_adresse_redirection"                  , "" ),
( "droit_gerer_livret_ap"                            , "ENS,DOC,EDU,ONLY_PP" ),
( "droit_gerer_livret_devoirsfaits"                  , "ENS,DOC,EDU,ONLY_PP" ),
( "droit_gerer_livret_elements"                      , "ENS,DOC,EDU,ONLY_COORD" ),
( "droit_gerer_livret_enscompl"                      , "ENS,DOC,EDU,ONLY_PP" ),
( "droit_gerer_livret_epi"                           , "ENS,DOC,EDU,ONLY_PP" ),
( "droit_gerer_livret_langcultregion"                , "ENS,DOC,EDU,ONLY_PP" ),
( "droit_gerer_livret_modaccomp"                     , "ENS,DOC,EDU,ONLY_PP" ),
( "droit_gerer_livret_parcours"                      , "ENS,DOC,EDU,ONLY_PP" ),
( "droit_gerer_referentiel"                          , "ENS,DOC,EDU,ONLY_COORD" ),
( "droit_gerer_mode_synthese"                        , "ENS,DOC,EDU,ONLY_COORD" ),
( "droit_gerer_ressource"                            , "ENS,DOC,EDU" ),
( "droit_modifier_email"                             , "DIR,ENS,DOC,EDU,TUT,ELV" ),
( "droit_modifier_mdp"                               , "DIR,ENS,DOC,EDU,TUT,ELV" ),
( "droit_officiel_bulletin_appreciation_generale"    , "DIR,ENS,ONLY_PP" ),
( "droit_officiel_bulletin_corriger_appreciation"    , "DIR" ),
( "droit_officiel_bulletin_impression_pdf"           , "DIR" ),
( "droit_officiel_bulletin_modifier_statut"          , "DIR" ),
( "droit_officiel_bulletin_voir_archive"             , "DIR,ENS,DOC,EDU" ),
( "droit_officiel_livret_appreciation_generale"      , "DIR,ENS,ONLY_PP" ),
( "droit_officiel_livret_corriger_appreciation"      , "DIR" ),
( "droit_officiel_livret_impression_pdf"             , "DIR" ),
( "droit_officiel_livret_modifier_statut"            , "DIR" ),
( "droit_officiel_livret_positionner_enscompl"       , "DIR,ENS" ),
( "droit_officiel_livret_positionner_langcultregion" , "DIR,ENS" ),
( "droit_officiel_livret_positionner_socle"          , "DIR,ENS" ),
( "droit_officiel_livret_voir_archive"               , "DIR,ENS,DOC,EDU" ),
( "droit_officiel_releve_appreciation_generale"      , "DIR,ENS,ONLY_PP" ),
( "droit_officiel_releve_corriger_appreciation"      , "DIR" ),
( "droit_officiel_releve_impression_pdf"             , "DIR" ),
( "droit_officiel_releve_modifier_statut"            , "DIR" ),
( "droit_officiel_releve_voir_archive"               , "DIR,ENS,DOC,EDU" ),
( "droit_officiel_saisir_assiduite"                  , "DIR,EDU" ),
( "droit_releve_conversion_sur_20"                   , "" ),
( "droit_releve_etat_acquisition"                    , "TUT,ELV" ),
( "droit_releve_moyenne_score"                       , "TUT,ELV" ),
( "droit_releve_pourcentage_acquis"                  , "TUT,ELV" ),
( "droit_socle_acces"                                , "TUT,ELV" ),
( "droit_socle_prevision_points_brevet"              , "TUT,ELV" ),
( "droit_socle_proposition_positionnement"           , "TUT,ELV" ),
( "droit_voir_etat_acquisition_avec_evaluation"      , "" ),
( "droit_voir_grilles_items"                         , "DIR,ENS,DOC,EDU,TUT,ELV" ),
( "droit_voir_param_algorithme"                      , "DIR,ENS,DOC,EDU,TUT,ELV" ),
( "droit_voir_param_notes_acquis"                    , "DIR,ENS,DOC,EDU,TUT,ELV" ),
( "droit_voir_referentiels"                          , "DIR,ENS,DOC,EDU,TUT,ELV" ),
( "droit_voir_score_bilan"                           , "DIR,ENS,DOC,EDU,TUT,ELV" ),
( "droit_voir_score_maitrise"                        , "DIR,ENS,DOC,EDU,TUT,ELV" ),
( "enveloppe_horizontal_droite"                      , "20" ),
( "enveloppe_horizontal_gauche"                      , "110" ),
( "enveloppe_horizontal_milieu"                      , "100" ),
( "enveloppe_vertical_bas"                           , "20" ),
( "enveloppe_vertical_haut"                          , "50" ),
( "enveloppe_vertical_milieu"                        , "45" ),
( "etablissement_adresse1"                           , "" ),
( "etablissement_adresse2"                           , "" ),
( "etablissement_adresse3"                           , "" ),
( "etablissement_courriel"                           , "" ),
( "etablissement_denomination"                       , "" ),
( "etablissement_fax"                                , "" ),
( "etablissement_ip_variable"                        , "0" ),
( "etablissement_langue"                             , "fr_FR" ),
( "etablissement_telephone"                          , "" ),
( "etat_acquisition_neutre_legende"                  , "Indéterminé" ),
( "etablissement_url"                                , "" ),
( "mois_bascule_annee_scolaire"                      , "8" ),
( "nombre_codes_notation"                            , "4" ),
( "nombre_etats_acquisition"                         , "3" ),
( "officiel_infos_etablissement"                     , "denomination,adresse,telephone,fax,courriel,url" ),
( "officiel_infos_responsables"                      , "non" ),
( "officiel_marge_bas"                               , "10" ),
( "officiel_marge_droite"                            , "5" ),
( "officiel_marge_gauche"                            , "5" ),
( "officiel_marge_haut"                              , "5" ),
( "officiel_nombre_exemplaires"                      , "un" ),
( "officiel_signature_transparence"                  , "non" ),
( "officiel_tampon_signature"                        , "signature_ou_tampon" ),
( "sesamath_id"                                      , "0" ),
( "sesamath_key"                                     , "" ),
( "sesamath_type_nom"                                , "" ),
( "sesamath_uai"                                     , "" ),
( "version_base"                                     , "" ),
( "version_base_maj_complementaire"                  , "" ),
( "webmestre_denomination"                           , "" ),
( "webmestre_uai"                                    , "" );

ALTER TABLE sacoche_parametre ENABLE KEYS;
