#!/bin/bash

cart=`ip route show default | awk '/default/ {print $5}'`
mac=`ifconfig ${cart} | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'`+
rne=$(CreoleGet numero_etab)
etab=$(CreoleGet libelle_etab)
eole_module=$(CreoleGet eole_module)
eole_release=$(CreoleGet eole_release)
weburl=$(CreoleGet web_url)
web_redirection=$(CreoleGet web_redirection)
container_path_web=$(CreoleGet container_path_web)

serveurstat="https://envole.ac-dijon.fr/ninestat/api"

# Proxy
activer_proxy_client=$(CreoleGet activer_proxy_client non)
if [[ "${activer_proxy_client}" == "oui" ]]
then
proxy_client_adresse=$(CreoleGet proxy_client_adresse)
proxy_client_port=$(CreoleGet proxy_client_port)

export HTTP_PROXY="${proxy_client_adresse}:${proxy_client_port}"
export HTTPS_PROXY="${proxy_client_adresse}:${proxy_client_port}"
fi

rawurlencode() {
  local string="${1}"
  local strlen=${#string}
  local encoded=""
  local pos c o

  for (( pos=0 ; pos<strlen ; pos++ )); do
     c=${string:$pos:1}
     case "$c" in
        [-_.~a-zA-Z0-9] ) o="${c}" ;;
        * )               printf -v o '%%%02x' "'$c"
     esac
     encoded+="${o}"
  done
  echo "${encoded}"    # You can either set a return variable (FASTER) 
  REPLY="${encoded}"   #+or echo the result (EASIER)... or both... :p
}

# Lister les versions de paquets Envole
paquets=( "eole-scrumblr" "eole-adminer" "eole-dispatcher" "eole-ninegate" "eole-nineboard" "eole-phpmyadmin" "eole-etherhome" "eole-infosquota" "eole-eoe" "eole-eop" "eole-sacoche" "eole-posh" "eole-ajaxplorer" "eole-balado" "eole-bergamote" "eole-cdc" "eole-cdt" "eole-dokuwiki" "eole-eportail" "eole-envole-connecteur" "eole-etherpad" "eole-ethercalc" "eole-etherdraw" "eole-fluxbb" "eole-gepi" "eole-calendrier" "eole-grr" "eole-iconito" "eole-limesurvey" "eole-jappix" "eole-mahara" "eole-moodle-update" "eole-opensondage" "eole-owncloud" "eole-piwigo" "eole-piwik" "eole-pydio" "eole-roundcube" "eole-spipeva" "eole-taskfreak" "eole-webcalendar" "eole-wordpress" "eole-fengoffice" "eole-mindmaps" "eole-nextcloud" "eole-kanboard" )
rm -rf /tmp/lstpaquet.txt
for i in "${paquets[@]}"
do
    dpkg-query -f '${Package}-${Version}\n' -W | grep ${i} >> /tmp/lstpaquet.txt
done

sed '/apps/d' /tmp/lstpaquet.txt > /tmp/lstpaquet2.txt
sed '/python/d' /tmp/lstpaquet2.txt > /tmp/lstpaquet.txt
sed '/pkg/d' /tmp/lstpaquet.txt > /tmp/lstpaquet2.txt
sed '/common/d' /tmp/lstpaquet2.txt > /tmp/lstpaquet.txt
sed '/server/d' /tmp/lstpaquet.txt > /tmp/lstpaquet2.txt
sed '/web/d' /tmp/lstpaquet2.txt > /tmp/lstpaquet.txt

awk 'NR==0; NR > 0 {print $0 | "sort -t\\| -n -k 1,1"}' /tmp/lstpaquet.txt > $container_path_web/var/www/html/sondepiwik/lstpaquet.txt
chmod +r $container_path_web/var/www/html/sondepiwik/lstpaquet.txt

sed ':a;N;$!ba;s/\n/;/g' /tmp/lstpaquet.txt  > /tmp/lstpaquetfinal.txt
apps=`cat /tmp/lstpaquetfinal.txt`

# Construction de la chaine de parametre
mac=`echo $(rawurlencode "${mac}")`
etab=`echo $(rawurlencode "${etab}")`
eole_module=`echo $(rawurlencode "${eole_module}")`
eole_release=`echo $(rawurlencode "${eole_release}")`
apps=`echo $(rawurlencode "${apps}")`
urletab=`echo $(rawurlencode "${weburl}${web_redirection}")`

data="idserver=$mac&idlocal=$rne&name=$etab&module=$eole_module&version=$eole_release&url=$urletab&apps=$apps"

curl -k --request POST \
  --url ${serveurstat} \
  --silent \
  --header 'accept: application/json' \
  --header 'cache-control: no-cache' \
  --header 'content-type: application/x-www-form-urlencoded' \
  --header 'postman-token: e8cbba3a-9e51-204b-b742-a5b7a083738d' \
  --data ${data}


