/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar;

import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.Calendar;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import us.k5n.webcalendar.Event;
import us.k5n.webcalendar.Utils;
import us.k5n.webcalendar.WebCalendarErrorException;
import us.k5n.webcalendar.WebCalendarParseException;

public class EventList
extends Vector {
    Document document;

    public EventList(String string, String string2) throws WebCalendarParseException, WebCalendarErrorException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
            this.document = documentBuilder.parse(stringBufferInputStream);
            this.domToEvents(this.document, string2);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            System.err.println("XML:\n" + string + "\n[end xml]");
            throw new WebCalendarParseException("Error parsing XML from WebCalendar server: " + exception.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new WebCalendarParseException("I/O Error parsing XML from WebCalendar server: " + iOException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new WebCalendarParseException("Parser Config Error parsing XML from WebCalendar server: " + parserConfigurationException.toString());
        }
    }

    public EventList() {
    }

    private void domToEvents(Document document, String string) throws WebCalendarParseException, WebCalendarErrorException {
        String string2 = Utils.getError(document);
        if (string2 != null) {
            throw new WebCalendarErrorException(string2);
        }
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() < 1) {
            System.err.println("No <" + string + "> found");
            throw new WebCalendarParseException("No <" + string + "> tag found in XML");
        }
        if (nodeList.getLength() > 1) {
            System.err.println("Too many <" + string + "> found (" + nodeList.getLength() + ")");
            throw new WebCalendarParseException("Too many <" + string + "> found (" + nodeList.getLength() + ")");
        }
        Node node = nodeList.item(0);
        nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if ("event".equals(node2.getNodeName())) {
                this.addElement(new Event(node2));
                continue;
            }
            System.err.println("Not sure what to do with <" + node2.getNodeName() + "> tag (expecting <event>... ignoring)");
        }
    }

    public Event eventAt(int n) {
        return (Event)this.elementAt(n);
    }

    public EventList getEventsForDate(Calendar calendar) {
        EventList eventList = new EventList();
        for (int i = 0; i < this.size(); ++i) {
            Event event = this.eventAt(i);
            if (!event.dateMatches(calendar)) continue;
            eventList.addElement(event);
        }
        return eventList;
    }
}

