<?php
/* $Id: select_user.php,v 1.35.2.2 2008/02/12 01:47:52 cknudsen Exp $ */
include_once 'includes/init.php';
print_header ();
echo '
    <h2>' . translate ( 'View Another Users Calendar' ) . '</h2>';

if ( $ALLOW_VIEW_OTHER != 'Y' && ! $is_admin ) {
  $error = print_not_auth (7);
  echo '
    <blockquote>' . $error . '</blockquote>';
} else if (  $PUBLIC_ACCESS == 'Y' && $login == '__public__' &&
  $PUBLIC_ACCESS_OTHERS != 'Y' ) {
  $error = print_not_auth (35);
  echo '
    <blockquote>' . $error . '</blockquote>';
} else {
  $userlist = get_my_users ( '', 'view' );
  if ( $NONUSER_ENABLED == 'Y' ) {
    $nonusers = get_my_nonusers ( $login, true );
    $userlist = ( $NONUSER_AT_TOP == 'Y'
      ? array_merge ( $nonusers, $userlist )
      : array_merge ( $userlist, $nonusers ) );
  }

  if ( strstr ( $STARTVIEW, 'view' ) )
    $url = 'month.php';
  else {
    $url = $STARTVIEW;
    if ( $url == 'month' || $url == 'day' || $url == 'week' || $url == 'year' )
      $url .= '.php';
  }

  ob_start ();

  echo '
    <form action="' . $url . '" method="get" name="SelectUser">
      <select name="user" onchange="document.SelectUser.submit()">';
  
  //envole : les users sont triés par groupe dans "user_get_users" (voir "user-cas.php") mais des modifications possibles obligent à retrier
  $groupes_envole = array();
  for ( $i = 0, $cnt = count ( $userlist ); $i < $cnt; $i++ ) {
    // Don't list current user
    if ( $login == $userlist[$i]['cal_login'] )
      continue;
      
    $groupe = isset($userlist[$i]['cal_groupe']) ? $userlist[$i]['cal_groupe'] : "??????";
    $user_envole = $userlist[$i]['cal_lastname'];
    if(preg_match("/^(?:m\.|mme)\s+(.+)$/i",$user_envole,$matched)) $user_envole = $matched[1];
    if(!array_key_exists($groupe,$groupes_envole)) $groupes_envole[$groupe] = array();
    else //homonymes
        {
        $n = 0;
        $user_envole_initial = $user_envole;
        while(array_key_exists($user_envole,$groupes_envole[$groupe])) $user_envole = $user_envole_initial.(++$n);
        }
      
    $groupes_envole[$groupe][$user_envole] = '
        <option value="' . $userlist[$i]['cal_login'] . '">'
     . $userlist[$i]['cal_fullname'] . '</option>';
  }

  foreach($groupes_envole as $groupval=>$optgroup)
    {
    ksort($optgroup);
    echo '<optgroup label="&nbsp;'.$groupval.'">'.implode("\n",$optgroup).'</optgroup>';
    }

  echo '
      </select>
      <input type="submit" value="' . translate ( 'Go' ) . '" />
    </form>';

  ob_end_flush ();
}

echo '<br /><br />
    ' . print_trailer ();

?>
