\r wordpress
SET character_set_client = utf8;

DELIMITER |
DROP PROCEDURE IF EXISTS populate_buddy_press|
CREATE PROCEDURE populate_buddy_press()
BEGIN
    -- First we delete current records in the association table user<>blog in buddypress
    DELETE FROM wp_bp_user_blogs;
    DELETE FROM wp_bp_user_blogs_blogmeta;

--    SELECT @fdsc := option_value FROM wp_options WHERE option_name='blogdescription';
--    SELECT @furl := option_value FROM wp_options WHERE option_name='siteurl';
--    SELECT @ftitle := option_value FROM wp_options WHERE option_name='blogname';
    SELECT option_value INTO @fdsc FROM wp_options WHERE option_name='blogdescription';
    SELECT option_value INTO @furl FROM wp_options WHERE option_name='siteurl';
    SELECT option_value INTO @ftitle FROM wp_options WHERE option_name='blogname';
    INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (1, 'description', @fdsc);
    INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (1, 'url', @furl);
    INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (1, 'name', @ftitle);
    INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (1, 'last_activity', NOW());
    INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (1, 'close_comments_for_old_posts', '0');
    INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (1, 'close_comments_days_old', '14');
    INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (1, 'thread_comments_depth', '5');

    -- We now loop through all the blogs
    users_blogs: BEGIN
        DECLARE done_ids INT DEFAULT FALSE;
        DECLARE idblog BIGINT;

        DECLARE ids CURSOR FOR SELECT blog_id FROM wp_blogs WHERE blog_id > 1;
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done_ids=TRUE;

        OPEN ids;
        -- We loop through secondary blogs
        read_ids: LOOP
            FETCH ids INTO idblog;
            IF done_ids THEN
                LEAVE read_ids;
            END IF;

            -- Generate wp_*_capabilities from current cursor
            SET @bid = CONCAT('wp_',idblog,'_capabilities');
            SET @toptionsname = CONCAT('wp_',idblog,'_options');
            -- We search all people belonging to the current blog

            
            -- Now we add meta to blogmeta table
            updates: BEGIN
                SET @s1 = CONCAT('SELECT option_value INTO @dsc FROM ',@toptionsname, ' WHERE option_name="blogdescription"');
                PREPARE st1 FROM @s1;
                EXECUTE st1;
                DEALLOCATE PREPARE st1;

                SET @s2 = CONCAT('SELECT option_value INTO @url FROM ',@toptionsname, ' WHERE option_name="siteurl"');
                PREPARE st2 FROM @s2;
                EXECUTE st2;
                DEALLOCATE PREPARE st2;
                
                SET @s3 = CONCAT('SELECT option_value INTO @title FROM ',@toptionsname, ' WHERE option_name="blogname"');
                PREPARE st3 FROM @s3;
                EXECUTE st3;
                DEALLOCATE PREPARE st3;

                INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (idblog, 'description', @dsc);
                INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (idblog, 'url', @url);
                INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (idblog, 'name', @title);
                INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (idblog, 'last_activity', NOW());
                INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (idblog, 'close_comments_for_old_posts', '0');
                INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (idblog, 'close_comments_days_old', '14');
                INSERT INTO wp_bp_user_blogs_blogmeta (blog_id, meta_key, meta_value) VALUES (idblog, 'thread_comments_depth', '5');
            END updates;

            -- now we search for users in this blogs
            bu: BEGIN
                DECLARE done_users INT DEFAULT FALSE;
                DECLARE iduser BIGINT;
                DECLARE users CURSOR FOR SELECT user_id FROM wp_usermeta WHERE meta_key=@bid;
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET done_users=TRUE;

                OPEN users;

                read_users: LOOP
                    FETCH users INTO iduser;
                    IF done_users THEN
                        LEAVE read_users;
                    END IF;

                    -- for each found user, we add it to buddypress link table
                    INSERT INTO wp_bp_user_blogs (user_id, blog_id) VALUES (iduser, idblog);
            END LOOP read_users;
            CLOSE users;
            END bu;

    END LOOP read_ids;
    CLOSE ids;
    END users_blogs;

    -- Now we add link for primary blog
    prim_b: BEGIN
        DECLARE done_prim INT DEFAULT FALSE;
        DECLARE iduser BIGINT;
    
        DECLARE uids CURSOR FOR SELECT user_id FROM wp_usermeta WHERE meta_key='wp_capabilities';
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done_prim=TRUE;
    
        OPEN uids;
        read_prim: LOOP
            FETCH uids INTO iduser;
            IF done_prim THEN
                LEAVE read_prim;
            END IF;
            INSERT INTO wp_bp_user_blogs (user_id, blog_id) VALUES (iduser, 1);
        END LOOP read_prim;
        CLOSE uids;
    END prim_b;

END|
    

CALL populate_buddy_press()|
DROP PROCEDURE IF EXISTS populate_buddy_press|
