\r wordpress
SET character_set_client = utf8;

DELIMITER |
DROP PROCEDURE IF EXISTS redefine_theme|


CREATE PROCEDURE redefine_theme()
BEGIN
dbv: BEGIN
        DECLARE done INT DEFAULT FALSE;
        DECLARE a VARCHAR(64);
        DECLARE blog CURSOR FOR SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema='wordpress' AND table_name like 'wp%_options';
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

        OPEN blog;

        read_loop: LOOP
            FETCH blog INTO a;
            IF done THEN
                LEAVE read_loop;
            END IF;
        
            SET @prefix = SUBSTRING_INDEX(a, '_options',1);
            SET @cct2 = CONCAT('UPDATE ', a, ' SET option_value="twentyfifteen" WHERE option_value="twentyten"');
            PREPARE stmt2 FROM @cct2;
            EXECUTE stmt2;
            DEALLOCATE PREPARE stmt2;

            SET @cct2 = CONCAT('UPDATE ', a, ' SET option_value="twentyfifteen" WHERE option_value="twentyeleven"');
            PREPARE stmt2 FROM @cct2;
            EXECUTE stmt2;
            DEALLOCATE PREPARE stmt2;

            SET @cct2 = CONCAT('UPDATE ', a, ' SET option_value="twentyfifteen" WHERE option_value="twentytwelve"');
            PREPARE stmt2 FROM @cct2;
            EXECUTE stmt2;
            DEALLOCATE PREPARE stmt2;

        END LOOP read_loop;

        CLOSE blog;
    END dbv;
END|

CALL redefine_theme()|
DROP PROCEDURE IF EXISTS redefine_theme|