\r wordpress
SET character_set_client = utf8;

DELIMITER |
DROP PROCEDURE IF EXISTS do_updates|
DROP PROCEDURE IF EXISTS do_wordpress_update_to351|
DROP PROCEDURE IF EXISTS do_wordpress_update_to361|
DROP PROCEDURE IF EXISTS update_db_version_to361|
DROP PROCEDURE IF EXISTS do_wordpress_update_to392|
DROP PROCEDURE IF EXISTS update_db_version_to392|
DROP PROCEDURE IF EXISTS do_wordpress_update_to401|
DROP PROCEDURE IF EXISTS update_db_version_to401|
DROP PROCEDURE IF EXISTS do_wordpress_update_to43|
DROP PROCEDURE IF EXISTS update_db_version_to43|
DROP PROCEDURE IF EXISTS verifyplugins|

-- Creation of a procedure upgrading the wordpress database
CREATE PROCEDURE do_updates()
BEGIN
    -- Check if wordpress version is lesser than 3.9.2
    IF((SELECT meta_value FROM wp_sitemeta WHERE meta_key='wpmu_upgrade_site')<22441) THEN
        CALL do_wordpress_update_to351();
    END IF;
    IF((SELECT meta_value FROM wp_sitemeta WHERE meta_key='wpmu_upgrade_site')<22448) THEN
        CALL do_wordpress_update_to361();
        CALL update_db_version_to361();
    END IF;
    IF((SELECT meta_value FROM wp_sitemeta WHERE meta_key='wpmu_upgrade_site')<27916) THEN
        CALL do_wordpress_update_to392();
        CALL update_db_version_to392();
    END IF;

    -- Finally update to version 4.0.1
    IF((SELECT meta_value FROM wp_sitemeta WHERE meta_key='wpmu_upgrade_site')<29630) THEN
        CALL do_wordpress_update_to401();
        CALL update_db_version_to401();
    END IF;

    IF((SELECT meta_value FROM wp_sitemeta WHERE meta_key='wpmu_upgrade_site')<33055) THEN
        CALL do_wordpress_update_to43();
        CALL update_db_version_to43();
    END IF;
    
    -- Vérification de structure
    CALL verifyplugins();
END|

-- ------------------------------------------------------------------
-- Now is the time to declare the procs to upgrade wordpress to 4.3 |
-- ------------------------------------------------------------------
CREATE PROCEDURE update_db_version_to43()
BEGIN
    SET @db_version = '33055';

    versions: BEGIN
        DECLARE done_ids INT DEFAULT FALSE;
        DECLARE idb BIGINT;

        -- as we can have multiple blogs, we need to know the id wordpress gave them
        -- we create and use a cursor to do that

        DECLARE blog_ids CURSOR FOR SELECT blog_id FROM wp_blogs;
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done_ids=TRUE;

        OPEN blog_ids;

        -- we fetch `blog_ids` cursor in a loop

        read_ids: LOOP
            FETCH blog_ids INTO idb;
            IF done_ids THEN
                LEAVE read_ids;
            END IF;


            IF((SELECT COUNT(*) FROM wp_blog_versions WHERE blog_id=idb)>0) THEN

            -- if we got a record for the current id in `wp_blogs_versions` table, we update the db_version recorded

                UPDATE wp_blog_versions SET db_version=@db_version, last_updated=NOW();
            ELSE

            -- else, we insert a new record
            INSERT INTO wp_blog_versions (blog_id, db_version, last_updated) VALUES (idb, @db_version, NOW());
            END IF;
        END LOOP read_ids;

        CLOSE blog_ids;
    END versions;
    
    dbv: BEGIN
        DECLARE done INT DEFAULT FALSE;
        DECLARE a VARCHAR(64);
        DECLARE blog CURSOR FOR SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema='wordpress' AND table_name like 'wp%_options';
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

        OPEN blog;

        read_loop: LOOP
            FETCH blog INTO a;
            IF done THEN
                LEAVE read_loop;
            END IF;
        
            SET @prefix = SUBSTRING_INDEX(a, '_options',1);
            SET @cct2 = CONCAT('UPDATE ', a, ' SET option_value=',@db_version, ' WHERE option_name="db_version"');
            PREPARE stmt2 FROM @cct2;
            EXECUTE stmt2;
            DEALLOCATE PREPARE stmt2;

        END LOOP read_loop;

        CLOSE blog;
    END dbv;

        -- Update the `last_updated field` on blogs records
    UPDATE wp_blog_versions SET db_version=@db_version,last_updated=NOW();
    UPDATE wp_blogs SET last_updated=NOW();
    UPDATE wp_sitemeta SET meta_value=@db_version WHERE meta_key='wpmu_upgrade_site';
    UPDATE wp_options SET option_value=@db_version WHERE option_name='db_version';

END|

CREATE PROCEDURE do_wordpress_update_to43()
BEGIN
    ALTER TABLE `wp_bp_activity_meta` DROP KEY `meta_key`;
    ALTER TABLE `wp_bp_activity_meta` ADD KEY `meta_key` (`meta_key`(191));

    ALTER TABLE `wp_postmeta` DROP KEY `meta_key`;
    ALTER TABLE `wp_postmeta` ADD KEY `meta_key` (`meta_key`(191));

    ALTER TABLE `wp_posts` DROP KEY `post_name`;
    ALTER TABLE `wp_posts` ADD KEY `post_name` (`post_name`(191));

    ALTER TABLE `wp_terms` DROP KEY `slug`;
    ALTER TABLE `wp_terms` ADD KEY `slug` (`slug`(191));
    ALTER TABLE `wp_terms` DROP KEY `name`;
    ALTER TABLE `wp_terms` ADD KEY `name` (`name`(191));
    UPDATE wp_sitemeta SET meta_value='a:7:{s:7:"classic";b:1;s:12:"twentyeleven";b:1;s:6:"envole";b:1;s:14:"twentythirteen";b:1;s:12:"twentytwelve";b:1;s:14:"twentyfourteen";b:1;s:7:"inkness";b:1;}' WHERE meta_key='allowedthemes';
END|
-- --------------------------------------------------------------------
-- Now is the time to declare the procs to upgrade wordpress to 4.0.1 |
-- --------------------------------------------------------------------
CREATE PROCEDURE update_db_version_to401()
BEGIN
    SET @db_version = '29630';

    versions: BEGIN
        DECLARE done_ids INT DEFAULT FALSE;
        DECLARE idb BIGINT;

        -- as we can have multiple blogs, we need to know the id wordpress gave them
        -- we create and use a cursor to do that

        DECLARE blog_ids CURSOR FOR SELECT blog_id FROM wp_blogs;
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done_ids=TRUE;

        OPEN blog_ids;

        -- we fetch `blog_ids` cursor in a loop

        read_ids: LOOP
            FETCH blog_ids INTO idb;
            IF done_ids THEN
                LEAVE read_ids;
            END IF;


            IF((SELECT COUNT(*) FROM wp_blog_versions WHERE blog_id=idb)>0) THEN

            -- if we got a record for the current id in `wp_blogs_versions` table, we update the db_version recorded

                UPDATE wp_blog_versions SET db_version=@db_version, last_updated=NOW();
            ELSE

            -- else, we insert a new record
            INSERT INTO wp_blog_versions (blog_id, db_version, last_updated) VALUES (idb, @db_version, NOW());
            END IF;
        END LOOP read_ids;

        CLOSE blog_ids;
    END versions;
    
    dbv: BEGIN
        DECLARE done INT DEFAULT FALSE;
        DECLARE a VARCHAR(64);
        DECLARE blog CURSOR FOR SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema='wordpress' AND table_name like 'wp%_options';
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

        OPEN blog;

        read_loop: LOOP
            FETCH blog INTO a;
            IF done THEN
                LEAVE read_loop;
            END IF;
        
            SET @prefix = SUBSTRING_INDEX(a, '_options',1);
            SET @cct2 = CONCAT('UPDATE ', a, ' SET option_value=',@db_version, ' WHERE option_name="db_version"');
            PREPARE stmt2 FROM @cct2;
            EXECUTE stmt2;
            DEALLOCATE PREPARE stmt2;

        END LOOP read_loop;

        CLOSE blog;
    END dbv;

        -- Update the `last_updated field` on blogs records
    UPDATE wp_blog_versions SET db_version=@db_version,last_updated=NOW();
    UPDATE wp_blogs SET last_updated=NOW();
    UPDATE wp_sitemeta SET meta_value=@db_version WHERE meta_key='wpmu_upgrade_site';
    UPDATE wp_options SET option_value=@db_version WHERE option_name='db_version';

END|


CREATE PROCEDURE do_wordpress_update_to401()
BEGIN

    -- Mise à jour de la structure de la base
    -- Alterations sans risque d'erreur si on repasse le script une seconde fois
    ALTER TABLE `wp_blogs` MODIFY `archived` tinyint(2) NOT NULL DEFAULT '0';
    -- Passage à 0 de archived car la ligne précédente en changeant la nature du champs passe le archived à 1 !!!
    -- Inconvénient : tous les sites archivés sont désarchivés.
    UPDATE `wp_blogs` SET `archived` = '0' WHERE 1;

    -- Alter les tables en laissant la possibilité de repasser une seconde 
    --  fois le script (suppression puis recréation dans ce cas)
    IF((SELECT COUNT(*) FROM information_schema.statistics WHERE index_schema='wordpress' AND table_name='wp_comments' AND index_name='comment_author_email')>0) THEN
        ALTER TABLE `wp_comments` DROP INDEX `comment_author_email`;
    END IF;
    ALTER TABLE `wp_comments` ADD INDEX `comment_author_email` (`comment_author_email`(10));

    IF((SELECT COUNT(*) FROM information_schema.statistics WHERE index_schema='wordpress' AND table_name='wp_signups' AND index_name='domain_path')>0) THEN
        ALTER TABLE `wp_signups` DROP INDEX `domain_path`;
    END IF;
    ALTER TABLE `wp_signups` ADD INDEX `domain_path` (`domain`,`path`);

    -- Création des tables supplémentaires pour wp_statistics si elle n'existent pas 
    CREATE TABLE IF NOT EXISTS `wp_statistics_exclusions` (
      `ID` int(11) NOT NULL AUTO_INCREMENT,
      `date` date NOT NULL,
      `reason` varchar(255) DEFAULT NULL,
      `count` bigint(20) NOT NULL,
      PRIMARY KEY (`ID`),
      KEY `date` (`date`),
      KEY `reason` (`reason`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8;

    CREATE TABLE IF NOT EXISTS `wp_statistics_historical` (
      `ID` bigint(20) NOT NULL AUTO_INCREMENT,
      `category` varchar(25) NOT NULL,
      `page_id` bigint(20) NOT NULL,
      `uri` varchar(255) NOT NULL,
      `value` bigint(20) NOT NULL,
      PRIMARY KEY (`ID`),
      UNIQUE KEY `page_id` (`page_id`),
      UNIQUE KEY `uri` (`uri`),
      KEY `category` (`category`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8;

    CREATE TABLE IF NOT EXISTS `wp_statistics_pages` (
      `uri` varchar(255) NOT NULL,
      `date` date NOT NULL,
      `count` int(11) NOT NULL,
      `id` int(11) NOT NULL,
      UNIQUE KEY `date_2` (`date`,`uri`),
      KEY `url` (`uri`),
      KEY `date` (`date`),
      KEY `id` (`id`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8;

    CREATE TABLE IF NOT EXISTS `wp_statistics_useronline` (
      `ID` int(11) NOT NULL AUTO_INCREMENT,
      `ip` varchar(60) NOT NULL,
      `timestamp` int(10) NOT NULL,
      `date` datetime NOT NULL,
      `referred` text NOT NULL,
      `agent` varchar(255) NOT NULL,
      `platform` varchar(255) DEFAULT NULL,
      `version` varchar(255) DEFAULT NULL,
      PRIMARY KEY (`ID`)
    ) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

    CREATE TABLE IF NOT EXISTS `wp_statistics_visit` (
      `ID` int(11) NOT NULL AUTO_INCREMENT,
      `last_visit` datetime NOT NULL,
      `last_counter` date NOT NULL,
      `visit` int(10) NOT NULL,
      PRIMARY KEY (`ID`)
    ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

    CREATE TABLE IF NOT EXISTS `wp_statistics_visitor` (
      `ID` int(11) NOT NULL AUTO_INCREMENT,
      `last_counter` date NOT NULL,
      `referred` text NOT NULL,
      `agent` varchar(255) NOT NULL,
      `platform` varchar(255) DEFAULT NULL,
      `version` varchar(255) DEFAULT NULL,
      `UAString` varchar(255) DEFAULT NULL,
      `ip` varchar(60) NOT NULL,
      `location` varchar(10) DEFAULT NULL,
      PRIMARY KEY (`ID`),
      UNIQUE KEY `date_ip_agent` (`last_counter`,`ip`,`agent`(75),`platform`(75),`version`(75)),
      KEY `agent` (`agent`),
      KEY `platform` (`platform`),
      KEY `version` (`version`),
      KEY `location` (`location`)
    ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

    -- Alterations des tables wp_statistics si elle existaient déjà, elles ont besoin d'être corrigées
    ALTER TABLE `wp_statistics_useronline` MODIFY `ip` varchar(60) NOT NULL;
    ALTER TABLE `wp_statistics_visitor` MODIFY `ip` varchar(60) NOT NULL;
    IF((SELECT COUNT(*) FROM information_schema.statistics WHERE index_schema='wordpress' AND table_name='wp_statistics_visitor' AND index_name='date_ip')>0) THEN
        ALTER TABLE `wp_statistics_visitor` DROP INDEX `date_ip`;
        ALTER TABLE `wp_statistics_visitor` ADD UNIQUE INDEX `date_ip_agent` (`last_counter`,`ip`,`agent`(75),`platform`(75),`version`(75));
    END IF;

    -- Mise à jour des données de la base
    -- Mise à jour de la table wp_usermeta
    UPDATE `wp_usermeta` SET `meta_value`='mfold=o&editor=html' WHERE `meta_key`='wp_user-settings';

    -- Mise à jour des versions de plugins dans la base afin d'avoir un affichage bien propre après maj
    UPDATE `wp_options` SET `option_value`='4.9.3' WHERE `option_name`='su_option_version';
    UPDATE `wp_options` SET `option_value`='{\"plugin_options_db_version\":29,\"table_scheme_db_version\":3,\"prev_tablepress_version\":\"1.4\",\"tablepress_version\":\"1.5.1\",\"first_activation\":1418208220,\"message_plugin_update\":true,\"message_plugin_update_content\":\"<info>This update includes several new features, enhancements, and bugfixes. Updating is recommended.<\\/info>\",\"message_donation_nag\":true,\"use_custom_css\":true,\"use_custom_css_file\":true,\"custom_css\":\"\",\"custom_css_minified\":\"\",\"custom_css_version\":0}' WHERE `option_name`='tablepress_plugin_options';
    UPDATE `wp_options` SET `option_value`='8.3.1' WHERE `option_name`='wp_statistics_plugin_version';
    UPDATE `wp_options` SET `option_value`='8.3.1' WHERE `option_name`='wp_statistics_db_version';
    UPDATE `wp_sitemeta` SET `meta_value`='O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1418205765;s:7:\"checked\";a:7:{s:6:\"envole\";s:3:\"0.1\";s:7:\"inkness\";s:7:\"1.0.3.1\";s:12:\"twentyeleven\";s:3:\"1.9\";s:14:\"twentyfourteen\";s:3:\"1.2\";s:9:\"twentyten\";s:3:\"1.7\";s:14:\"twentythirteen\";s:3:\"1.3\";s:12:\"twentytwelve\";s:3:\"1.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}' WHERE `meta_key`='_site_transient_update_themes';
    UPDATE `wp_sitemeta` SET `meta_value`='O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.0.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.0.1.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.0.1\";s:7:\"version\";s:5:\"4.0.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"3.8\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1418205770;s:15:\"version_checked\";s:5:\"4.0.1\";s:12:\"translations\";a:0:{}}' WHERE `meta_key`='_site_transient_update_core';
    UPDATE `wp_sitemeta` SET `meta_value`='O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1418205753;s:7:\"checked\";a:14:{s:19:\"akismet/akismet.php\";s:5:\"3.0.3\";s:24:\"buddypress/bp-loader.php\";s:5:\"2.1.1\";s:29:\"envole_hooks/envole_hooks.php\";s:3:\"1.0\";s:9:\"hello.php\";s:3:\"1.6\";s:31:\"iframe-shortcode/flyniframe.php\";s:5:\"1.0.2\";s:38:\"wp-miniaudioplayer/miniAudioPlayer.php\";s:5:\"1.5.8\";s:31:\"page-links-to/page-links-to.php\";s:5:\"2.9.4\";s:25:\"private-wp/private-wp.php\";s:3:\"1.1\";s:43:\"shortcodes-ultimate/shortcodes-ultimate.php\";s:5:\"4.9.3\";s:25:\"tablepress/tablepress.php\";s:5:\"1.5.1\";s:9:\"wpcas.php\";s:2:\"10\";s:39:\"wp-hide-dashboard/wp-hide-dashboard.php\";s:3:\"2.2\";s:23:\"wp-sentry/wp-sentry.php\";s:4:\"0.8d\";s:31:\"wp-statistics/wp-statistics.php\";s:5:\"8.3.1\";}s:8:\"response\";a:1:{s:31:\"wp-statistics/wp-statistics.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"21429\";s:4:\"slug\";s:13:\"wp-statistics\";s:6:\"plugin\";s:31:\"wp-statistics/wp-statistics.php\";s:11:\"new_version\";s:5:\"8.5.1\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wp-statistics/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wp-statistics.8.5.1.zip\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:11:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.0.3\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.0.3.zip\";}s:24:\"buddypress/bp-loader.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"7756\";s:4:\"slug\";s:10:\"buddypress\";s:6:\"plugin\";s:24:\"buddypress/bp-loader.php\";s:11:\"new_version\";s:5:\"2.1.1\";s:14:\"upgrade_notice\";s:56:\"See: http://codex.buddypress.org/releases/version-2-1-1/\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/buddypress/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/buddypress.2.1.1.zip\";}s:9:\"hello.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3564\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";}s:31:\"iframe-shortcode/flyniframe.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"25782\";s:4:\"slug\";s:16:\"iframe-shortcode\";s:6:\"plugin\";s:31:\"iframe-shortcode/flyniframe.php\";s:11:\"new_version\";s:3:\"0.1\";s:14:\"upgrade_notice\";s:15:\"Initial Release\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/iframe-shortcode/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/iframe-shortcode.0.1.zip\";}s:38:\"wp-miniaudioplayer/miniAudioPlayer.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"35600\";s:4:\"slug\";s:18:\"wp-miniaudioplayer\";s:6:\"plugin\";s:38:\"wp-miniaudioplayer/miniAudioPlayer.php\";s:11:\"new_version\";s:5:\"1.5.8\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wp-miniaudioplayer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wp-miniaudioplayer.1.5.8.zip\";}s:31:\"page-links-to/page-links-to.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"216\";s:4:\"slug\";s:13:\"page-links-to\";s:6:\"plugin\";s:31:\"page-links-to/page-links-to.php\";s:11:\"new_version\";s:5:\"2.9.4\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/page-links-to/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/page-links-to.2.9.4.zip\";}s:25:\"private-wp/private-wp.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"2372\";s:4:\"slug\";s:10:\"private-wp\";s:6:\"plugin\";s:25:\"private-wp/private-wp.php\";s:11:\"new_version\";s:3:\"1.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/private-wp/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/private-wp.1.1.zip\";}s:43:\"shortcodes-ultimate/shortcodes-ultimate.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"21713\";s:4:\"slug\";s:19:\"shortcodes-ultimate\";s:6:\"plugin\";s:43:\"shortcodes-ultimate/shortcodes-ultimate.php\";s:11:\"new_version\";s:5:\"4.9.3\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/shortcodes-ultimate/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/shortcodes-ultimate.zip\";}s:25:\"tablepress/tablepress.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"32125\";s:4:\"slug\";s:10:\"tablepress\";s:6:\"plugin\";s:25:\"tablepress/tablepress.php\";s:11:\"new_version\";s:5:\"1.5.1\";s:14:\"upgrade_notice\";s:95:\"This update includes several new features, enhancements, and bugfixes. Updating is recommended.\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/tablepress/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/tablepress.1.5.1.zip\";}s:39:\"wp-hide-dashboard/wp-hide-dashboard.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"5010\";s:4:\"slug\";s:17:\"wp-hide-dashboard\";s:6:\"plugin\";s:39:\"wp-hide-dashboard/wp-hide-dashboard.php\";s:11:\"new_version\";s:3:\"2.2\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/wp-hide-dashboard/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/wp-hide-dashboard.2.2.zip\";}s:23:\"wp-sentry/wp-sentry.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3962\";s:4:\"slug\";s:9:\"wp-sentry\";s:6:\"plugin\";s:23:\"wp-sentry/wp-sentry.php\";s:11:\"new_version\";s:4:\"0.8d\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wp-sentry/\";s:7:\"package\";s:52:\"https://downloads.wordpress.org/plugin/wp-sentry.zip\";}}}' WHERE `meta_key`='_site_transient_update_plugins';

END|

-- --------------------------------------------------------------------
-- Now is the time to declare the procs to upgrade wordpress to 3.9.1 |
-- --------------------------------------------------------------------
CREATE PROCEDURE update_db_version_to392()
BEGIN
    SET @db_version = '27916';

    versions: BEGIN
        DECLARE done_ids INT DEFAULT FALSE;
        DECLARE idb BIGINT;

        -- as we can have multiple blogs, we need to know the id wordpress gave them
        -- we create and use a cursor to do that

        DECLARE blog_ids CURSOR FOR SELECT blog_id FROM wp_blogs;
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done_ids=TRUE;

        OPEN blog_ids;

        -- we fetch `blog_ids` cursor in a loop

        read_ids: LOOP
            FETCH blog_ids INTO idb;
            IF done_ids THEN
                LEAVE read_ids;
            END IF;


            IF((SELECT COUNT(*) FROM wp_blog_versions WHERE blog_id=idb)>0) THEN

            -- if we got a record for the current id in `wp_blogs_versions` table, we update the db_version recorded

                UPDATE wp_blog_versions SET db_version=@db_version, last_updated=NOW();
            ELSE

            -- else, we insert a new record
            INSERT INTO wp_blog_versions (blog_id, db_version, last_updated) VALUES (idb, @db_version, NOW());
            END IF;
        END LOOP read_ids;

        CLOSE blog_ids;
    END versions;
    
    dbv: BEGIN
        DECLARE done INT DEFAULT FALSE;
        DECLARE a VARCHAR(64);
        DECLARE blog CURSOR FOR SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema='wordpress' AND table_name like 'wp%_options';
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

        OPEN blog;

        read_loop: LOOP
            FETCH blog INTO a;
            IF done THEN
                LEAVE read_loop;
            END IF;
        
            SET @prefix = SUBSTRING_INDEX(a, '_options',1);
            SET @cct2 = CONCAT('UPDATE ', a, ' SET option_value=',@db_version, ' WHERE option_name="db_version"');
            PREPARE stmt2 FROM @cct2;
            EXECUTE stmt2;
            DEALLOCATE PREPARE stmt2;

        END LOOP read_loop;

        CLOSE blog;
    END dbv;

        -- Update the `last_updated field` on blogs records
    UPDATE wp_blog_versions SET db_version=@db_version,last_updated=NOW();
    UPDATE wp_blogs SET last_updated=NOW();
    UPDATE wp_sitemeta SET meta_value=@db_version WHERE meta_key='wpmu_upgrade_site';
    UPDATE wp_options SET option_value=@db_version WHERE option_name='db_version';

END|


CREATE PROCEDURE do_wordpress_update_to392()
BEGIN
    -- First we delete the useless options of blogs
    opts: BEGIN
        DECLARE done INT DEFAULT FALSE;
        DECLARE a VARCHAR(64);
        DECLARE blogs CURSOR FOR SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema='wordpress' AND table_name LIKE 'wp%_options';
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

        open blogs;
        read_loop: LOOP
            FETCH blogs INTO a;
            IF done THEN
                LEAVE read_loop;
            END IF;
            SET @cct = CONCAT('DELETE FROM ', a,' WHERE option_name LIKE "links_recently_updated%"');
            PREPARE stmt FROM @cct;
            EXECUTE stmt;
            DEALLOCATE PREPARE stmt;

            SET @cct15 = CONCAT('DELETE FROM ', a, ' WHERE option_name="db_upgraded"');
            PREPARE stmt15 FROM @cct15;
            EXECUTE stmt15;
            DEALLOCATE PREPARE stmt15;

            SET @cct2 = CONCAT('INSERT INTO ', a, ' (option_name,option_value,autoload) VALUES ("db_upgraded","1","yes")');
            PREPARE stmt2 FROM @cct2;
            EXECUTE stmt2;
            DEALLOCATE PREPARE stmt2;

            -- Update of language : setup it to french by default

            SET @cct3 = CONCAT('UPDATE ', a,' SET option_value="fr_FR" WHERE option_name ="WPLANG"');
            PREPARE stmt3 FROM @cct3;
            EXECUTE stmt3;
            DEALLOCATE PREPARE stmt3;

            SET @cct3 = CONCAT('UPDATE ', a,' SET option_value="Europe/Paris" WHERE option_name ="timezone_string"');
            PREPARE stmt3 FROM @cct3;
            EXECUTE stmt3;
            DEALLOCATE PREPARE stmt3;

        END LOOP read_loop;
        CLOSE blogs;
    END opts;

    -- Alter on wp_signups

    ALTER TABLE wp_signups DROP KEY domain;
    ALTER TABLE wp_signups ADD KEY `user_email` (`user_email`);
    ALTER TABLE wp_signups ADD KEY `user_login_email` (`user_login`,`user_email`);
    ALTER TABLE wp_signups ADD KEY `domain_path` (`domain`,`path`);
    ALTER TABLE wp_signups ADD `signup_id` bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY;


    

    -- Creation of all the buddypress tables
    --

    CREATE TABLE `wp_bp_activity_meta` (
      `id` bigint(20) NOT NULL AUTO_INCREMENT,
      `activity_id` bigint(20) NOT NULL,
      `meta_key` varchar(255) DEFAULT NULL,
      `meta_value` longtext,
      PRIMARY KEY (`id`),
      KEY `activity_id` (`activity_id`),
      KEY `meta_key` (`meta_key`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8;

    CREATE TABLE `wp_bp_activity` (
      `id` bigint(20) NOT NULL AUTO_INCREMENT,
      `user_id` bigint(20) NOT NULL,
      `component` varchar(75) NOT NULL,
      `type` varchar(75) NOT NULL,
      `action` text NOT NULL,
      `content` longtext NOT NULL,
      `primary_link` varchar(255) NOT NULL,
      `item_id` bigint(20) NOT NULL,
      `secondary_item_id` bigint(20) DEFAULT NULL,
      `date_recorded` datetime NOT NULL,
      `hide_sitewide` tinyint(1) DEFAULT '0',
      `mptt_left` int(11) NOT NULL DEFAULT '0',
      `mptt_right` int(11) NOT NULL DEFAULT '0',
      `is_spam` tinyint(1) NOT NULL DEFAULT '0',
      PRIMARY KEY (`id`),
      KEY `date_recorded` (`date_recorded`),
      KEY `user_id` (`user_id`),
      KEY `item_id` (`item_id`),
      KEY `secondary_item_id` (`secondary_item_id`),
      KEY `component` (`component`),
      KEY `type` (`type`),
      KEY `mptt_left` (`mptt_left`),
      KEY `mptt_right` (`mptt_right`),
      KEY `hide_sitewide` (`hide_sitewide`),
      KEY `is_spam` (`is_spam`)
    ) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
    --
    -- Table structure for table `wp_bp_notifications`
    --

    CREATE TABLE `wp_bp_notifications` (
      `id` bigint(20) NOT NULL AUTO_INCREMENT,
      `user_id` bigint(20) NOT NULL,
      `item_id` bigint(20) NOT NULL,
      `secondary_item_id` bigint(20) DEFAULT NULL,
      `component_name` varchar(75) NOT NULL,
      `component_action` varchar(75) NOT NULL,
      `date_notified` datetime NOT NULL,
      `is_new` tinyint(1) NOT NULL DEFAULT '0',
      PRIMARY KEY (`id`),
      KEY `item_id` (`item_id`),
      KEY `secondary_item_id` (`secondary_item_id`),
      KEY `user_id` (`user_id`),
      KEY `is_new` (`is_new`),
      KEY `component_name` (`component_name`),
      KEY `component_action` (`component_action`),
      KEY `useritem` (`user_id`,`is_new`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8;

    --
    -- Table structure for table `wp_bp_user_blogs_blogmeta`
    --

    CREATE TABLE `wp_bp_user_blogs_blogmeta` (
      `id` bigint(20) NOT NULL AUTO_INCREMENT,
      `blog_id` bigint(20) NOT NULL,
      `meta_key` varchar(255) DEFAULT NULL,
      `meta_value` longtext,
      PRIMARY KEY (`id`),
      KEY `blog_id` (`blog_id`),
      KEY `meta_key` (`meta_key`)
    ) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;
    --
    -- Table structure for table `wp_bp_user_blogs`
    --
    CREATE TABLE `wp_bp_user_blogs` (
      `id` bigint(20) NOT NULL AUTO_INCREMENT,
      `user_id` bigint(20) NOT NULL,
      `blog_id` bigint(20) NOT NULL,
      PRIMARY KEY (`id`),
      KEY `user_id` (`user_id`),
      KEY `blog_id` (`blog_id`)
    ) ENGINE=MyISAM AUTO_INCREMENT=11771 DEFAULT CHARSET=utf8;


    --
    -- Table structure for table `wp_bp_xprofile_data`
    --

    CREATE TABLE `wp_bp_xprofile_data` (
      `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
      `field_id` bigint(20) unsigned NOT NULL,
      `user_id` bigint(20) unsigned NOT NULL,
      `value` longtext NOT NULL,
      `last_updated` datetime NOT NULL,
      PRIMARY KEY (`id`),
      KEY `field_id` (`field_id`),
      KEY `user_id` (`user_id`)
    ) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

    --
    -- Table structure for table `wp_bp_xprofile_fields`
    --

    CREATE TABLE `wp_bp_xprofile_fields` (
      `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
      `group_id` bigint(20) unsigned NOT NULL,
      `parent_id` bigint(20) unsigned NOT NULL,
      `type` varchar(150) NOT NULL,
      `name` varchar(150) NOT NULL,
      `description` longtext NOT NULL,
      `is_required` tinyint(1) NOT NULL DEFAULT '0',
      `is_default_option` tinyint(1) NOT NULL DEFAULT '0',
      `field_order` bigint(20) NOT NULL DEFAULT '0',
      `option_order` bigint(20) NOT NULL DEFAULT '0',
      `order_by` varchar(15) NOT NULL DEFAULT '',
      `can_delete` tinyint(1) NOT NULL DEFAULT '1',
      PRIMARY KEY (`id`),
      KEY `group_id` (`group_id`),
      KEY `parent_id` (`parent_id`),
      KEY `field_order` (`field_order`),
      KEY `can_delete` (`can_delete`),
      KEY `is_required` (`is_required`)
    ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

    --
    -- Table structure for table `wp_bp_xprofile_groups`
    --

    CREATE TABLE `wp_bp_xprofile_groups` (
      `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
      `name` varchar(150) NOT NULL,
      `description` mediumtext NOT NULL,
      `group_order` bigint(20) NOT NULL DEFAULT '0',
      `can_delete` tinyint(1) NOT NULL,
      PRIMARY KEY (`id`),
      KEY `can_delete` (`can_delete`)
    ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

    CREATE TABLE `wp_bp_xprofile_meta` (
      `id` bigint(20) NOT NULL AUTO_INCREMENT,
      `object_id` bigint(20) NOT NULL,
      `object_type` varchar(150) NOT NULL,
      `meta_key` varchar(255) DEFAULT NULL,
      `meta_value` longtext,
      PRIMARY KEY (`id`),
      KEY `object_id` (`object_id`),
      KEY `meta_key` (`meta_key`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8;

END|

-- --------------------------------------------------------------------
-- Now is the time to declare the procs to upgrade wordpress to 3.6.1 |
-- --------------------------------------------------------------------


CREATE PROCEDURE update_db_version_to361()
BEGIN
    SET @db_version = '24448';

    versions: BEGIN
        DECLARE done_ids INT DEFAULT FALSE;
        DECLARE idb BIGINT;

        -- as we can have multiple blogs, we need to know the id wordpress gave them
        -- we create and use a cursor to do that

        DECLARE blog_ids CURSOR FOR SELECT blog_id FROM wp_blogs;
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done_ids=TRUE;

        OPEN blog_ids;

        -- we fetch `blog_ids` cursor in a loop

        read_ids: LOOP
            FETCH blog_ids INTO idb;
            IF done_ids THEN
                LEAVE read_ids;
            END IF;


            IF((SELECT COUNT(*) FROM wp_blog_versions WHERE blog_id=idb)>0) THEN

            -- if we got a record for the current id in `wp_blogs_versions` table, we update the db_version recorded

                UPDATE wp_blog_versions SET db_version=@db_version, last_updated=NOW();
            ELSE

            -- else, we insert a new record
                INSERT INTO wp_blog_versions (blog_id, db_version, last_updated) VALUES (idb, @db_version, NOW());
            END IF;
        END LOOP read_ids;
        CLOSE blog_ids;
    END versions;
    
    dbv: BEGIN
        DECLARE done INT DEFAULT FALSE;
        DECLARE a VARCHAR(64);
        DECLARE blog CURSOR FOR SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema='wordpress' AND table_name like 'wp%_options';
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

        OPEN blog;

        read_loop: LOOP
            FETCH blog INTO a;
            IF done THEN
                LEAVE read_loop;
            END IF;
        
            SET @prefix = SUBSTRING_INDEX(a, '_options',1);
            SET @cct2 = CONCAT('UPDATE ', a, ' SET option_value=',@db_version, ' WHERE option_name="db_version"');
            PREPARE stmt2 FROM @cct2;
            EXECUTE stmt2;
            DEALLOCATE PREPARE stmt2;

        END LOOP read_loop;
        CLOSE blog;
    END dbv;

    

    UPDATE wp_sitemeta SET meta_value=@db_version WHERE meta_key='wpmu_upgrade_site';
    UPDATE wp_options SET option_value=@db_version WHERE option_name='db_version';
END|


CREATE PROCEDURE do_wordpress_update_to361()
BEGIN
    SET @db_version = '24448';
        

        -- We drop the embed_autourls option
        DELETE FROM wp_options WHERE option_name='embed_autourls';
        -- Finally we update the `wpmu_upgrade_site` meta
        UPDATE wp_sitemeta SET meta_value=@db_version WHERE meta_key='wpmu_upgrade_site';
        UPDATE wp_options SET option_value=@db_version WHERE option_name='db_version';

        -- Changes for theming
        UPDATE wp_sitemeta SET meta_value='a:5:{s:6:"envole";s:7:"/themes";s:12:"twentyeleven";s:7:"/themes";s:9:"twentyten";s:7:"/themes";s:14:"twentythirteen";s:7:"/themes";s:12:"twentytwelve";s:7:"/themes";}' WHERE meta_key='_site_transient_theme_roots';
        UPDATE wp_sitemeta SET meta_value='a:6:{s:7:"classic";b:1;s:12:"twentyeleven";b:1;s:6:"envole";b:1;s:9:"twentyten";b:1;s:14:"twentythirteen";b:1;s:12:"twentytwelve";b:1;}' WHERE meta_key='allowedthemes';

        UPDATE wp_options SET option_value='Twenty Thirteen' WHERE (option_name='current_theme' AND option_value='Wordpress Classic');
END|
    
    

CREATE PROCEDURE do_wordpress_update_to351()
BEGIN
    IF((SELECT meta_value FROM wp_sitemeta WHERE meta_key='wpmu_upgrade_site')<22441) THEN
        -- The  new revision of the database is 22441

        SET @db_version ='22441';

        -- Here we start the block that will alter columns and keys of tables

        alters: BEGIN

            DECLARE done INT DEFAULT FALSE;

            -- a will hold the current value of our cursor 

            DECLARE a VARCHAR(64);

            -- as we can have multiple blogs on the same wordpress, we need to know how many we have
            -- and what is the prefix for each blog
            -- so we search for table wp*_options in information_schema.tables

            DECLARE blog CURSOR FOR SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema='wordpress' AND table_name like 'wp%_options';

            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;


            OPEN blog;

            -- we fetch `blog` cursor in a loop

            read_loop: LOOP
                FETCH blog INTO a;
                IF done THEN
                    LEAVE read_loop;
                END IF;

                -- extraction of the prefix of the table (i.e : wp, wp_2, wp_3, etc...)

                SET @prefix = SUBSTRING_INDEX(a, '_options',1);

                -- we search if our current wp*_options have a `blog_id` in information schema

                IF((SELECT COUNT(*) FROM information_schema.columns WHERE table_name=a AND column_name='blog_id')>0) THEN

                    -- if so, we drop that column

                    SET @cct = CONCAT("ALTER TABLE ", a, " DROP COLUMN blog_id");
                    PREPARE stmt FROM @cct;
                    EXECUTE stmt;
                    DEALLOCATE PREPARE stmt;

                END IF;

                -- we update the db_version option in current wp*_option tables

                SET @cct2 = CONCAT('UPDATE ', a, ' SET option_value=',@db_version, ' WHERE option_name="db_version"');
                PREPARE stmt2 FROM @cct2;
                EXECUTE stmt2;
                DEALLOCATE PREPARE stmt2;
                
                -- we have to drop the `comment_approved` key if it exists in the wp*_comments tables
                
                SET @comments_table = CONCAT(@prefix,'_comments');
                IF((SELECT COUNT(*) FROM information_schema.statistics WHERE index_schema='wordpress' AND table_name=@comments_table AND index_name='comment_approved')>0) THEN
                    SET @cct_comments = CONCAT('ALTER TABLE ', @comments_table,' DROP KEY comment_approved');
                    PREPARE stmt_comments FROM @cct_comments;
                    EXECUTE stmt_comments;
                    DEALLOCATE PREPARE stmt_comments;
                END IF;

                -- we modify the type of `post_content_filtered` field in the wp*_posts tables

                SET @posts_table = CONCAT(@prefix,'_posts');
                SET @cct_posts = CONCAT('ALTER TABLE ', @posts_table,' MODIFY post_content_filtered longtext');
                PREPARE stmt_posts FROM @cct_posts;
                EXECUTE stmt_posts;
                DEALLOCATE PREPARE stmt_posts;

            END LOOP read_loop;
            CLOSE blog;

        END alters;

        -- HERE WE ARE DONE WITH ALTERING TABLES


        -- Let's update the db_version everywhere else

        versions: BEGIN
            DECLARE done_ids INT DEFAULT FALSE;
            DECLARE idb BIGINT;

            -- as we can have multiple blogs, we need to know the id wordpress gave them
            -- we create and use a cursor to do that

            DECLARE blog_ids CURSOR FOR SELECT blog_id FROM wp_blogs;
            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done_ids=TRUE;

            OPEN blog_ids;

            -- we fetch `blog_ids` cursor in a loop

            read_ids: LOOP
                FETCH blog_ids INTO idb;
                IF done_ids THEN
                    LEAVE read_ids;
                END IF;


                IF((SELECT COUNT(*) FROM wp_blog_versions WHERE blog_id=idb)>0) THEN

                    -- if we got a record for the current id in `wp_blogs_versions` table, we update the db_version recorded
                
                    UPDATE wp_blog_versions SET db_version=@db_version, last_updated=NOW();
                ELSE
                
                    -- else, we insert a new record
                    INSERT INTO wp_blog_versions (blog_id, db_version, last_updated) VALUES (idb, @db_version, NOW());
                END IF;
            END LOOP read_ids;
            CLOSE blog_ids;
        END versions;
        
        -- Finally we update the `wpmu_upgrade_site` meta
        
        UPDATE wp_sitemeta SET meta_value=@db_version WHERE meta_key='wpmu_upgrade_site';
    END IF;
END|

CREATE PROCEDURE verifyplugins()
BEGIN
    IF((SELECT COUNT(*) FROM information_schema.columns WHERE table_name='wp_statistics_useronline' AND column_name='created')=0) THEN
        ALTER TABLE wp_statistics_useronline ADD `created` INT(11) NULL DEFAULT NULL AFTER version;
    END IF;

    IF((SELECT COUNT(*) FROM information_schema.columns WHERE table_name='wp_statistics_useronline' AND column_name='location')=0) THEN
        ALTER TABLE wp_statistics_useronline ADD `location` VARCHAR(10) NULL DEFAULT NULL AFTER created;
    END IF;
    
    IF((SELECT COUNT(*) FROM information_schema.columns WHERE table_name='wp_statistics_visitor' AND column_name='hits')=0) THEN
        ALTER TABLE wp_statistics_visitor ADD `hits` INT(11) NULL DEFAULT NULL AFTER location;
    END IF;    

    IF((SELECT COUNT(*) FROM information_schema.columns WHERE table_name='wp_statistics_visitor' AND column_name='honeypot')=0) THEN
        ALTER TABLE wp_statistics_visitor ADD `honeypot` INT(11) NULL DEFAULT NULL AFTER hits;
    END IF;    

END|

CALL do_updates()|

DROP PROCEDURE IF EXISTS do_updates|
DROP PROCEDURE IF EXISTS do_wordpress_update_to351|
DROP PROCEDURE IF EXISTS do_wordpress_update_to361|
DROP PROCEDURE IF EXISTS update_db_version_to361|
DROP PROCEDURE IF EXISTS do_wordpress_update_to392|
DROP PROCEDURE IF EXISTS update_db_version_to392|
DROP PROCEDURE IF EXISTS do_wordpress_update_to401|
DROP PROCEDURE IF EXISTS update_db_version_to401|
DROP PROCEDURE IF EXISTS update_db_version_to43|
DROP PROCEDURE IF EXISTS do_wordpress_update_to43|
DROP PROCEDURE IF EXISTS verifyplugins|



