<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
ini_set('error_log', 'test.log');
error_reporting(-1);

require_once '/var/www/html/wordpress/wp-load.php';
class WP_Administrator
{
    private $db;

    public function __construct()
    {
        try
        {
            $this->db = new PDO('mysql:host='.DB_HOST.';dbname='.DB_NAME,DB_USER, DB_PASSWORD);
            $this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        }catch(PDOException $e)
        {
            throw new Exception( $e->getMessage() );
        }
    }


    /**
     * Plugins management
     */
    private function getWideActivatedPlugins()
    {
        $query = "SELECT meta_value FROM wp_sitemeta WHERE meta_key='active_sitewide_plugins'";
        $stmt = $this->db->prepare($query);
        try
        {
            $stmt->execute();

            $res = $stmt->fetchAll(PDO::FETCH_CLASS);
            return $res;



        }catch(PDOException $e)
        {
            throw new Exception( $e->getMessage() );
        }
    }

    public function disableWidePlugin($in_pluginNamePath)
    {
        $plugs = $this->getWideActivatedPlugins();
        $activatedPlugins = unserialize($plugs[0]->meta_value);
        if(!array_key_exists($in_pluginNamePath, $activatedPlugins))
        {
            //throw new Exception("Le plugin ".$in_pluginNamePath." n'est pas activé ou n'existe pas...\n");
        }else
        {
            unset($activatedPlugins[$in_pluginNamePath]);
            try
            {
                $uQuery = "UPDATE wp_sitemeta SET meta_value=:serial WHERE meta_key='active_sitewide_plugins'";
                $stmt = $this->db->prepare($uQuery);
                $stmt->bindValue(':serial', serialize($activatedPlugins), PDO::PARAM_STR);
                $res = $stmt->execute();
                return $res;
            }catch(PDOException $e)
            {
                throw new Exception($e->getMessage());
            }
        }
    }

    public function enableWidePlugin($in_pluginNamePath)
    {
        $plugs = $this->getWideActivatedPlugins();
        $activatedPlugins = unserialize($plugs[0]->meta_value);
        if(array_key_exists($in_pluginNamePath, $activatedPlugins))
        {
            //throw new Exception("Le plugin ".$in_pluginNamePath." est déjà activé.\n");
        }else
        {
            $activatedPlugins[$in_pluginNamePath] = time();
            try
            {
                $uQuery = "UPDATE wp_sitemeta SET meta_value=:serial WHERE meta_key='active_sitewide_plugins'";
                $stmt = $this->db->prepare($uQuery);
                $stmt->bindValue(':serial', serialize($activatedPlugins), PDO::PARAM_STR);
                $res = $stmt->execute();
                return $res;
            }catch(PDOException $e)
            {
                throw new Exception($e->getMessage());
            }
        }
    }

    /**
     * Themes management
     */
    public function getWideAllowedThemes()
    {
        $query = "SELECT meta_value FROM wp_sitemeta WHERE meta_key='allowedthemes'";
        $stmt = $this->db->prepare($query);
        try
        {
            $stmt->execute();

            $res = $stmt->fetchAll(PDO::FETCH_CLASS);
            return $res;
        }catch(PDOException $e)
        {
            throw new Exception( $e->getMessage() );
        }
    }

    public function allowTheme($in_themeName)
    {
        $th = $this->getWideAllowedThemes();
        $themes = unserialize($th[0]->meta_value);

        if(array_key_exists($in_themeName, $themes))
        {
            //throw new Exception("Le theme ".$in_themeName." est déjà activé");
        }else
        {
            $themes[$in_themeName] = true;
            try
            {
                $aQuery = "UPDATE wp_sitemeta SET meta_value=:serial WHERE meta_key='allowedthemes'";
                $stmt = $this->db->prepare($aQuery);
                $stmt->bindValue(':serial', serialize($themes), PDO::PARAM_STR);
                $res = $stmt->execute();
                return $res;
            }catch(PDOException $e)
            {
                throw new Exception($e->getMessage());
            }
        }
    }

    public function disallowTheme($in_themeName)
    {
        $th = $this->getWideAllowedThemes();
        $themes =  unserialize($th[0]->meta_value);
        var_dump($themes);
        if(!array_key_exists($in_themeName, $themes))
        {
            throw new Exception("Le thème ".$in_themeName." n'est pas activé ou n'existe pas...\n");
        }else
        {
            unset($themes[$in_themeName]);
            try{
                $aQuery = "UPDATE wp_sitemeta SET meta_value=:serial WHERE meta_key='allowedthemes'";
                $stmt = $this->db->prepare($aQuery);
                $stmt->bindValue(':serial', serialize($themes), PDO::PARAM_STR);
                $res = $stmt->execute();
                return $res;
            }catch(PDOException $e)
            {
                throw new Exception($e->getMessage());
            }
        }
    }
}
?>
