<?php

/*
  Plugin Name: wpCAS-envole
  Version: 10
  Plugin URI: http://dev.ac-creteil.fr
  Description: Plugin adapté par l'équipe EnvOLE. Plugin to integrate WordPress or WordPressMU with existing <a href="http://en.wikipedia.org/wiki/Central_Authentication_Service">CAS</a> single sign-on architectures. Based largely on <a href="http://schwink.net">Stephen Schwink</a>'s <a href="http://wordpress.org/extend/plugins/cas-authentication/">CAS Authentication</a> plugin. Optionally, you can set a function to execute when a CAS username isn't found in WordPress (so, for example, you could provision a WordPress account for them).
  Author: Coutouly lucile
  Author URI: http://dev.ac-creteil.fr
*/

/*
  Copyright (C) 2008 Casey Bisson

  This plugin owes a huge debt to
  Stephen Schwink's CAS Authentication plugin, copyright (C) 2008
  and released under GPL.


  This plugin honors and extends Schwink's work, and is licensed under the same terms.



  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


$error_reporting = error_reporting(0); // hide any warnings when attempting to fetch the optional config file
include_once(dirname(__FILE__).'/wpcas-conf.php'); // attempt to fetch the optional config file
error_reporting($error_reporting); // unhide warnings

// do we have a valid options array? fetch the options from the DB if not
if(!is_array($wpcas_options)){
	$wpcas_options = get_option('wpcas_options');
	add_action('admin_menu', 'wpcas_options_page_add');
}

$cas_configured = true;

// try to configure the phpCAS client
if ($wpcas_options['include_path'] == '' || (include_once $wpcas_options['include_path']) != true)
	$cas_configured = false;

if ($wpcas_options['server_hostname'] == '' || intval($wpcas_options['server_port']) == 0)
	$cas_configured = false;


if ($cas_configured){
	@session_start(); //fait ici et non par le client CAS depuis un bug sur un écrasement de session constaté
	if (__CAS_DEBUG){
		EolephpCAS::setDebug("/var/log/posh/phpCAS-wordpress.log");
	}
	EolephpCAS::client($wpcas_options['cas_version'],$wpcas_options['server_hostname'],intval($wpcas_options['server_port']),$wpcas_options['server_path'],false);
	EolephpCAS::setNoClearTicketsFromUrl();

	if ($wpcas_options['cas_validation_ca']) {
		EolephpCAS::setCasServerCACert($wpcas_options['cas_ca_location']);
    }
    else {
        if (method_exists('EolephpCAS', 'setNoCasServerValidation')){
            EolephpCAS::setNoCasServerValidation();
        }
    }
    
	if (__CAS_LOGOUT){
		if(method_exists('EolephpCAS','EoleLogoutRequests')) EolephpCAS::EoleLogoutRequests(false);
	}
}

// plugin hooks into authentication system
add_action('wp_authenticate', array('wpCAS', 'authenticate'), 10, 2);
add_action('wp_logout', array('wpCAS', 'logout'));
add_action('lost_password', array('wpCAS', 'disable_function'));
add_action('retrieve_password', array('wpCAS', 'disable_function'));
add_action('password_reset', array('wpCAS', 'disable_function'));
add_filter('show_password_fields', array('wpCAS', 'show_password_fields'));

//envole : remplacer la fonction définie dans "wp-includes/pluggable.php" pour permettre la déconnexion globale (Single Sign Out)
if (!function_exists('is_user_logged_in')) : //lors de l'install, pluggable.php est chargé en premier... (wpcas.php est chargé lors de l'activation par activate_plugin() dans wp-admin/includes/plugin.php, quelle utilité ?!)
	function is_user_logged_in()
	{
		//procédure de la fonction originale
		$user = wp_get_current_user();
		$existe_wordpress_user = !empty($user->ID);
		$existe_cas_user = !empty($_SESSION["phpCAS"]["user"]);
		$test = (!$existe_wordpress_user || !$existe_cas_user) ? : ($user->user_login==$_SESSION["phpCAS"]["user"]);

		if($existe_wordpress_user && !$test){
		wp_clear_auth_cookie();
			wp_set_current_user(0);
		}

		$user = wp_get_current_user();
		$existe_wordpress_user = !empty($user->ID);

		return $existe_wordpress_user;
	}
endif;

//envole : la partie d'administration n'utilise pas "is_user_logged_in()" mais "auth_redirect()" donc on ajoute un hook mais comme il se trouve après la vérification des cookies, on redirige
function is_admin_logged_in()
{
	$user = wp_get_current_user(); //on récupère les infos de l'utilisateur authentifié par cookies
	if(!EolephpCAS::isAuthenticated() || $user->user_login!=EolephpCAS::getUser())
	{
		wp_clear_auth_cookie();
		$login = "wp-login.php?redirect_to=/wp-admin/";
		wp_redirect(function_exists('site_url')  ? site_url($login) : $login);
		exit();
	}
}
//envole : hook présent dans "wp-admin/admin.php"
add_action('admin_init', 'is_admin_logged_in');

class wpCAS{
  /*
    We call phpCAS to authenticate the user at the appropriate time
    (the script dies there if login was unsuccessful)
    If the user is not provisioned, wpcas_nowpuser() is called
  */

	function authenticate(){
		global $wpdb;
		global $wpcas_options, $cas_configured;

		if (!$cas_configured)
			die(__('wpCAS plugin not configured', 'wpcas'));

		//forcer à redemander les infos auprès du serveur CAS
		unset($_SESSION["phpCAS"]);

		if(EolephpCAS::isAuthenticated()){
			// CAS was successful
			$attributs=EolephpCAS::getDetails();

			if(!is_array($attributs)){
				include('../envole/echecCAS.php');
			}
			else{
				//correspondances des statuts
				$profils = array
					(
					"National_1" => "eleve",
					"National_2" => "responsable",
					"National_3" => "professeur",
					"National_6" => "administratif",
					"administrateur" => "administrateur",
					"autre" => "visiteur"
					);
			
				$login = $attributs['utilisateur']['user'][0];
				$mail = $attributs['utilisateur']['email'][0];
				$cas_profil = $attributs['utilisateur']['profil'][0];
			
				if(array_key_exists($cas_profil,$profils)) $profil =  $profils[$cas_profil];
				else $profil =  $profils["autre"];
			}

			if ($user = get_userdatabylogin($login)){ // user already exists
				// the CAS user has a WP account
				wp_set_auth_cookie($user->ID);
				//$wpdb->show_errors=true;
				$sql="SELECT * FROM wp_sentry_groups WHERE FIND_IN_SET('".$user->ID."', member_list)";
				//ajout suite à la prise en compte des parents car ancien groupe à ne plus tenir compte (30/03/10)
				$sql .= " AND name!='eleves-et-parents'";
				$res=$wpdb->get_row($sql);

				if(!$res) wpcas_nogroup($login,$profil);
			}
			else{
				// the CAS user _does_not_have_ a WP account
				if (function_exists('wpcas_nowpuser'))
					wpcas_nowpuser($login,$mail,$profil);
				else
					die(__('you do not have permission here', 'wpcas'));
			}

			if(isset($_REQUEST['redirect_to'])){
				$local_redirect_to=$_REQUEST['redirect_to'];
			
				// force la redirection en https lors d'un accès direct à la partie admin en http pour eviter une boucle de redirection infinie
				if(preg_match('/^http[^s]/', $local_redirect_to) && preg_match('/wp-admin/', $local_redirect_to))
					$local_redirect_to=preg_replace('/^http/', 'https', $local_redirect_to);
			
				// bad code is bad (but working) /!\ ne marche pas dans l'autre sens
				$local_redirect_to=function_exists('site_url') ? preg_match('/^http/', $local_redirect_to) ?
				$local_redirect_to : site_url($local_redirect_to) : $local_redirect_to;
				wp_redirect($local_redirect_to);
				
			}
			elseif($profil=="administrateur"){
				wp_redirect(function_exists('site_url')  ? site_url('/wp-admin/') : '/wp-admin/');
			}
			else{
				wp_redirect(function_exists('site_url')  ? site_url('index.php') : 'index.php');
			}
		  
			exit();
		}
		else{
			// hey, authenticate
			EolephpCAS::forceAuthentication();
			die();
		}
	}

	// hook CAS logout to WP logout
	function logout(){
		global $cas_configured;

		if (!$cas_configured)
			die(__('wpCAS plugin not configured', 'wpcas'));

		EolephpCAS::logout(array('url' => get_settings('siteurl')));
		exit();
	}

	// hide password fields on user profile page.
	function show_password_fields($show_password_fields){
		return false;
	}

	// disabled reset, lost, and retrieve password features
	function disable_function(){
		die(__('Sorry, this feature is disabled.', 'wpcas'));
	}
}

// EOLE : gère l'auto connection à wordpress si l'utilisateur est identifié sur le SSO
// gère également la déconnection automatique et le changement d'utilisateur automatique
// utilise la fonction gateway du SSO, si l'utilisateur n'est pas identifié il accede
// quand même à la partie publique de wordpress
function auto_connect(){
	global $current_user;

	if(EolephpCAS::checkAuthentication()) {
		get_currentuserinfo();
		$wordpress_user=$current_user->user_login;
		$cas_user=EolephpCAS::getUser();
		
		if (!is_user_logged_in()){
			wp_redirect("wp-login.php?redirect_to=".EolephpCAS::getServiceURL());
			exit();
		}
		else if($cas_user!=$wordpress_user ) {
			wp_redirect("wp-login.php?redirect_to=".EolephpCAS::getServiceURL());
			exit();
		}
	}
	else {
		if (is_user_logged_in()){
			$urllogout=str_replace("amp;","",wp_logout_url(get_settings('siteurl')));
			wp_redirect($urllogout);
			exit();
		}
	}
}

function test_private(){
	global $current_user;

	// Récupérer le blog en cours
	$currentblog=get_current_blog_id();
	$detailsite=get_blog_details($currentblog);

	// Site privé
	if($detailsite->public==0) {
		// si l'utilisateur n'est pas connecté on le redirige vers une page d'interdiction
		if(!is_user_logged_in()) {
			header("location: /wordpress/wp-content/plugins/denied.php");
			exit();
		}
		// sinon on vérifie qu'il appartient à la liste des utilisateurs de ce site
		elseif(!current_user_can_for_blog($currentblog, "read")) {
			header("location: /wordpress/wp-content/plugins/denied.php");
			exit();
		}
	}
}

add_action('template_redirect', 'auto_connect');
add_action('template_redirect', 'test_private');

//----------------------------------------------------------------------------
//    ADMIN OPTION PAGE FUNCTIONS
//----------------------------------------------------------------------------

function wpcas_options_page_add(){
	add_options_page(__('wpCAS', 'wpcas'), __('wpCAS', 'wpcas'), 8, basename(__FILE__), 'wpcas_options_page');
}

function wpcas_options_page(){
	global $wpdb;

	// Setup Default Options Array
	$optionarray_def = array(
	'new_user' => FALSE,
	'redirect_url' => '',
	'email_suffix' => 'yourschool.edu',
	'cas_version' => CAS_VERSION_1_0,
	'include_path' => '',
	'server_hostname' => 'yourschool.edu',
	'server_port' => '443',
	'server_path' => ''
	);

	if (isset($_POST['submit'])){
		// Options Array Update
		$optionarray_update = array (
		'new_user' => $_POST['new_user'],
		'redirect_url' => $_POST['redirect_url'],
		'email_suffix' => $_POST['email_suffix'],
		'include_path' => $_POST['include_path'],
		'cas_version' => $_POST['cas_version'],
		'server_hostname' => $_POST['server_hostname'],
		'server_port' => $_POST['server_port'],
		'server_path' => $_POST['server_path']
		);
	
		update_option('wpcas_options', $optionarray_update);
	}

	// Get Options
	$optionarray_def = get_option('wpcas_options');

?>

<div class="wrap">
    <h2>CAS Authentication Options</h2>
    <form method="post" action="<?php echo $_SERVER['PHP_SELF'] . '?page=' . basename(__FILE__); ?>&updated=true">
		<h3><?php _e('wpCAS options', 'wpcas') ?></h3>
		<h4><?php _e('Note', 'wpcas') ?></h4>
		<p><?php _e('Now that you’ve activated this plugin, WordPress is attempting to authenticate using CAS, even if it’s not configured or misconfigured.', 'wpcas') ?></p>
		<p><?php _e('Save yourself some trouble, open up another browser or use another machine to test logins. That way you can preserve this session to adjust the configuration or deactivate the plugin.', 'wpcas') ?></p>
		<h4><?php _e('Also note', 'wpcas') ?></h4>
		<p><?php _e('These settings are overridden by the <code>wpcas-conf.php</code> file, if present.', 'wpcas') ?></p>

		<h4><?php _e('phpCAS include path', 'wpcas') ?></h4>
		<table width="700px" cellspacing="2" cellpadding="5" class="editform">
		<tr>
			<td colspan="2"><?php _e('Full absolute path to CAS.php script', 'wpcas') ?></td>
		</tr>
		<tr valign="center">
			<th width="300px" scope="row"><?php _e('CAS.php path', 'wpcas') ?></th>
			<td><input type="text" name="include_path" id="include_path_inp" value="<?php echo $optionarray_def['include_path']; ?>" size="35" /></td>
		</tr>
		</table>
      
		<h4><?php _e('phpCAS::client() parameters', 'wpcas') ?></h4>
		<table width="700px" cellspacing="2" cellpadding="5" class="editform">
			<tr valign="center">
				<th width="300px" scope="row">CAS verions</th>
				<td>
					<select name="cas_version" id="cas_version_inp">
					<option value="2.0" <?php echo ($optionarray_def['cas_version'] == '2.0')?'selected':''; ?>>CAS_VERSION_2_0</option>
					<option value="1.0" <?php echo ($optionarray_def['cas_version'] == '1.0')?'selected':''; ?>>CAS_VERSION_1_0</option>
				</td>
			</tr>
			<tr valign="center">
				<th width="300px" scope="row"><?php _e('server hostname', 'wpcas') ?></th>
				<td><input type="text" name="server_hostname" id="server_hostname_inp" value="<?php echo $optionarray_def['server_hostname']; ?>" size="35" /></td>
			</tr>
			<tr valign="center">
				<th width="300px" scope="row"><?php _e('server port', 'wpcas') ?></th>
				<td><input type="text" name="server_port" id="server_port_inp" value="<?php echo $optionarray_def['server_port']; ?>" size="35" /></td>
			</tr>
			<tr valign="center">
				<th width="300px" scope="row"><?php _e('server path', 'wpcas') ?></th>
				<td><input type="text" name="server_path" id="server_path_inp" value="<?php echo $optionarray_def['server_path']; ?>" size="35" /></td>
			</tr>
		</table>
      
		<div class="submit">
			<input type="submit" name="submit" value="<?php _e('Update Options') ?> &raquo;" />
		</div>
	</form>
</div>
<?php
}
?>
