\r wordpress
SET character_set_client = utf8;

-- blogs
UPDATE wp_blogs SET domain='%%web_url'; 


-- options
UPDATE wp_options SET option_value='https://%%web_url/wordpress' WHERE option_name='siteurl';
UPDATE wp_options SET option_value='https://%%web_url/wordpress' WHERE option_name='home';
UPDATE wp_options SET option_value='https://%%web_url/wordpress/wp-content/uploads' WHERE option_name='fileupload_url';




%if %%is_defined('domaine_messagerie_etab')
UPDATE wp_options SET option_value='admin@%%domaine_messagerie_etab' WHERE option_name='new_admin_email';
%else
UPDATE wp_options SET option_value='%%system_mail_to' WHERE option_name='new_admin_email';
%end if


-- site
UPDATE wp_site SET domain='%%web_url';

-- Metas du site
UPDATE wp_sitemeta SET meta_value='https://%%web_url/worpdress/' WHERE meta_key='siteurl' AND site_id=1;
%if %%is_defined('domaine_messagerie_etab')
UPDATE wp_sitemeta SET meta_value='admin@%%domaine_messagerie_etab' WHERE meta_key='admin_email';
%else
UPDATE wp_sitemeta SET meta_value='%%system_mail_to' WHERE meta_key='admin_email';
%end if
UPDATE wp_sitemeta SET meta_value='1' WHERE meta_key='upload_space_check_disabled';


-- Metas des users
UPDATE wp_usermeta SET meta_value='%%web_url' WHERE meta_key='source_domain';

-- Admin
%if %%is_defined('domaine_messagerie_etab')
UPDATE wp_users SET user_email='admin@%%domaine_messagerie_etab' WHERE user_login='admin';
%else
UPDATE wp_users SET user_email='%%system_mail_to' WHERE user_login='admin';
%end if

UPDATE wp_sitemeta SET meta_value='a:7:{s:7:"classic";b:1;s:12:"twentyeleven";b:1;s:6:"envole";b:1;s:14:"twentythirteen";b:1;s:12:"twentytwelve";b:1;s:14:"twentyfourteen";b:1;s:7:"inkness";b:1;}' WHERE meta_key='allowedthemes';

%if %%is_defined('activer_wordpress') and %%activer_wordpress == 'oui'
%if %%is_defined('activer_addadmin') and %%activer_addadmin == 'oui'
-- ------------------------------------------------------------------------------------------------------------------------------------------
-- WORDPRESS = Création admin secondaire

DROP PROCEDURE IF EXISTS AddAdminWordpress;
delimiter |

CREATE PROCEDURE AddAdminWordpress(_adminuser VARCHAR(60))
BEGIN
    DECLARE ad_id INT DEFAULT 0;

    SELECT COUNT(ID) INTO ad_id FROM wp_users WHERE user_login=_adminuser;

    IF ad_id = 0 THEN
        INSERT IGNORE INTO wp_users(`user_login`,`user_registered`,`user_nicename`, `user_email`,`user_status`,`display_name`, `spam`, `deleted`) VALUES
                                   (_adminuser,   NOW(), _adminuser, CONCAT(_adminuser,'@%%domaine_messagerie_etab'), 0, _adminuser, 0, 0);
    END IF;

    SELECT ID INTO ad_id FROM wp_users WHERE user_login=_adminuser;
    
    IF ad_id > 0 THEN
        INSERT IGNORE INTO wp_usermeta(`user_id`,`meta_key`,`meta_value`) VALUES
                                        (ad_id, 'nickname', _adminuser),
                                        (ad_id, 'rich_editing', 'true'),
                                        (ad_id, 'comment_shortcuts', 'false'),
                                        (ad_id, 'admin_color', 'fresh'),
                                        (ad_id, 'show_admin_bar_front', 'true'),
                                        (ad_id, 'wp_capabilities', 'a:1:{s:13:"administrator";s:1:"1";}'),
                                        (ad_id, 'wp_user_level', '10'),
                                        (ad_id, 'dismissed_wp_pointers', 'wp330_toolbar,wp330_media_uploader,wp330_saving_widgets'),
                                        (ad_id, 'source_url', '%%web_url'),
                                        (ad_id, 'primary_blog', '1'),
                                        (ad_id, 'wp_dashboard_quick_press_last_post_id', '25'),
                                        (ad_id, 'wp_user-settings', 'mfold=o&editor=html'),
                                        (ad_id, 'closedpostboxes_dashboard', 'a:0:{}');

    END IF;

END|
DELIMITER ;
CALL AddAdminWordpress('%%uid_addadmin');

%end if
%end if
