
function xmlText(node,item) {return $(node).find(item).text()}

$.fn.redraw = function(){
  $(this).each(function(){
    var redraw = this.offsetHeight;
  });
};


// Wrapper, pour compatibilité de infosplus qui a été créé sur le framework ajax de posh
// et non de jquery
$p={
    print: function(id,div,where) {
        if (where=="bottom") $("#"+id).append(div)
        if (where=="top") $("#"+id).prepend(div)
    }
}


function BuildInfos()   {}
function AdjustFooter() {}
function getRGB(color)  {

    if (color.indexOf("rgb(")==0) {
        var result = color.match(/\d+/g);
        return [parseInt(result[1]), parseInt(result[2]), parseInt(result[3])];
    }

    if (result = /rgb(s*([0-9]{1,3})s*,s*([0-9]{1,3})s*,s*([0-9]{1,3})s*)/.exec(color)) return [parseInt(result[1]), parseInt(result[2]), parseInt(result[3])];
    if (result = /rgb(s*([0-9]+(?:.[0-9]+)?)%s*,s*([0-9]+(?:.[0-9]+)?)%s*,s*([0-9]+(?:.[0-9]+)?)%s*)/.exec(color)) return [parseFloat(result[1]) * 2.55, parseFloat(result[2]) * 2.55, parseFloat(result[3]) * 2.55];
    if (result = /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(color)) return [parseInt(result[1], 16), parseInt(result[2], 16), parseInt(result[3], 16)];
    if (result = /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(color)) return [parseInt(result[1] + result[1], 16), parseInt(result[2] + result[2], 16), parseInt(result[3] + result[3], 16)];
}

function lighter(color,alpha,percent)
{
    if (color==undefined) return "white";
    var rgb = getRGB(color);
    if (rgb==undefined) {
        console.log("rgb undefined for:"+color);
        return "white";
    }
    for(var i = 0; i < rgb.length; i++){
        rgb[i] = Math.min(Math.round(rgb[i] * (percent || 2.0)), 255);
    }
    var newColor = 'rgba(' + rgb[0] + ',' + rgb[1] + ',' + rgb[2] + ','+ (alpha || 1) +')';
    return newColor
}

//filter results based on query
function filter(selector, query) {
          query =       $.trim(query); //trim white space
          query = query.replace(/ /gi, '|'); //add OR for regex query

          count=0
          $(selector).each(function() {
              if (($(this).text().search(new RegExp(query, "i")) < 0)){
                  $(this).hide().removeClass('visible')
              } else
              {
                  $(this).show().addClass('visible');
                  count++
              }
          });
          $(selector).unhighlight()
          $(selector).highlight(query);
}


function getDefaultCategorieColor(app)
{
    if (app.categorie==$mxdesktop.allCategorie) return "white";
    // Pour le moment en dure, a recupérer depuis le chargement des items de bureau
    if (app.categorie.toLowerCase().indexOf("applications")!=-1) return "rgb(220,220,255)";
    if (app.categorie.toLowerCase().indexOf("administration")!=-1) return "rgb(255,220,220)";
    return "rgb("+Math.floor((Math.random()*55)+120)+","+Math.floor((Math.random()*55)+130)+","+Math.floor((Math.random()*55)+150)+")";
}

function getFaForBadgeInfos(infos)
{
    if (infos.type=="infos") return "fa-info-circle"
    if (infos.type=="error") return "fa-times-circle"
    if (infos.type=="warning") return "fa-exclamation-triangle"
    return "fa-circle"
}

function xshow(id)
{

}

function SortAppByCategorie(a, b){
  // Classe d'abord par indice de la catégorie puis par nom catégorie puis par nom de l'appli
  var aName = ($mxdesktop.listeDesCategories[a.categorie].indice || 999) + a.key().toLowerCase();
  var bName = ($mxdesktop.listeDesCategories[b.categorie].indice || 999) + b.key().toLowerCase();
  return ((aName < bName) ? -1 : ((aName > bName) ? 1 : 0));
}


// Init $envole
$envole={}
$envole.xdesktop={}
$envole.xdesktop.callback="controllers/infosplus.php"


$mxdesktop={

    appName:"Mes applications",
    allCategorie:"Toutes",
    notificationsCategorie:"notifications",
    favorisCategorie:"favoris",
    inprogressCategorie:"encours",
    categorieIcone:"fa-folder",
    searchCategorie:"search",


    sortCategorie:function(a,b) {
        a1= $mxdesktop.listeDesCategories[a];
        b1= $mxdesktop.listeDesCategories[b];
        a2=(a1.indice || 999) + a1.name
        b2=(b1.indice || 999) + b1.name
        return ((a2 < b2) ? -1 : ((a2 > b2) ? 1 : 0));

    },

    log: function(msg) {
        $(".starter-template .help").html(msg);
    },


    createApp: function(attributs) {
           app= {id:Math.random().toString(36).substring(7),
                   libelle:attributs.libelle,
                   libellecours:attributs.libellecours || attributs.libelle,
                   icon:attributs.icon,
                   url:attributs.url,
                   listesDesUrl:[],
                   src:attributs.src,srcicone:attributs.srcicone,
                   nom:attributs.nom,
                   infos:attributs.infos,
                   infosChecked:[],
                   favoris:false,
                   categorie:attributs.categorie,
                   json:function() {
                        return {libelle:this.libelle,icon:this.icon,url:this.url,nom:this.url,categorie:this.categorie};
                   },
                   key: function() {
                        return this.categorie+"/"+this.nom;
                   },
                   active:function() {
                      $mxdesktop.unSelectAllCategorie()
                      $("ul.catprogress li").removeClass("active")
                      $("ul.catprogress li[appid="+this.id+"]").addClass("active");
                      $("#li"+$mxdesktop.inprogressCategorie).addClass("active");
                      $("li.search").show();
                   }
                 }
           return app;
    },

    Initialisation:function() {

        $mxdesktop.log("Chargement...")
        $mxdesktop.title=$(".navbar-brand").html()

        // Création des 2 catégories Favoris et Notifications
        // AddCategorie("Favoris","heart",$mxdesktop.favorisCategorie);
        AddCategorie("Notifications","bell",$mxdesktop.notificationsCategorie);
        progress=AddCategorie("En cours","play-circle",$mxdesktop.inprogressCategorie);
        progress.append("<ul class='catprogress'>")

        // Une zone de recherche
        a=$('<a href="#" class="categorie" catname="'+$mxdesktop.searchCategorie+'">'+$mxdesktop.searchCategorie+'</a>')
        cattop=$("<div>").addClass("topcategorie").css("background-color",'rgba(0,0,0,0)')
        a.html('<span class="glyphicon glyphicon-'+'search'+'"></span>'+'<input type="search" id="searchapps">');
        li=$("<li>").append(cattop).append(a)
        li.addClass($mxdesktop.searchCategorie)
        $(".navbar-left ul.nav").append(li)
        $("#searchapps").bind('keyup',$mxdesktop.performSearch)

        // Gestion de l'expand du panneau de gauche en (mode réduit)
        $("#expandleftside").click(function() {
                    if (!$(".navbar-left").hasClass("active")) {
                            $(".navbar-left").addClass("active")
                            $(".navbar-left").removeClass("fermer")
                            $(".navbar-left").css("width",$(window).width()+"px")
                        } else {
                            $(".navbar-left").addClass("fermer")
                            $(".navbar-left").removeClass("active")
                        }
        });

        // Soyons à l'écoute des InfosPlus (récupération des badges)

        // Listener sur l'ajout d'un badge
        document.addEventListener("addInfoPlus", function(event) {$mxdesktop.OnAddInfoPlus(event)}, false);

        // Listener sur le chargement d'un badge
        document.addEventListener("startInfoPlus", function(event) {$mxdesktop.OnStartInfoPlus(event)}, false);

        // Listener sur la fin de chargement d'un badge
        document.addEventListener("stopInfoPlus", function(event) {$mxdesktop.OnStopInfoPlus(event)}, false);

        $mxdesktop.listeDesApplications={}
        $mxdesktop.listeDesCategories={}
        $mxdesktop.nomDesApplications={}
        $mxdesktop.listeDesCategories[$mxdesktop.allCategorie]={name:"Toutes mes Applications",
                                                                color:"#FFF",
                                                                icone:'home',
                                                                apps:[] }
        $mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie]={name:"Mes Favoris",
                                                                color:"#FEE",
                                                                icone:'heart',
                                                                apps:[] }
        // On va lancer la récupération des items de bureau
        // Le menu sera construit après parsing du (ou des) xml reçu
        $mxactions.recupererLesItemDeBureau();
    },

    /* construit les categories depuis xml_string
     */
    GetCategories: function(xmlDoc,source) {
        //var xmlDoc = $.parseXML( xml_string )
        var $xml = $( xmlDoc )
        url={}

        console.log("GetCategories For:"+source)

        // Récupération des infos sur la source
        var srcicone;
        if ($xml.find("icone").length!=0) srcicone = $xml.find("icone")[0].textContent
        if ($xml.find("nom").length!=0) source = $xml.find("nom")[0].textContent


        // TODO: Parser la balise 'categories'
        $xml.find("categorie").each(function(){
            nom=xmlText(this,'nom');
            couleur=xmlText(this,'couleur');
            indice=xmlText(this,'indice') || 999;
            icone=xmlText(this,'icone') || "fa-folder"
            if ($mxdesktop.listeDesCategories[nom] == undefined )
            {
                $mxdesktop.listeDesCategories[nom]={name:nom,
                                                    color:couleur,
                                                    icone:icone,
                                                    indice:indice,
                                                    apps:[]}
            }
        })

        // Réorganisation des app dans les catégories
        $xml.find("reorg").each(function(){
            categorie=xmlText(this,'cat');
            newCategorie=$mxdesktop.listeDesCategories[categorie]
            if (newCategorie != undefined)
            {
                url=xmlText(this,'url');
                console.log("Reorganisation de url:"+url+" =>"+categorie)
                bFind=false
                console.log($mxdesktop.listeDesApplications)
                for (key in $mxdesktop.listeDesApplications)
                {
                    app=$mxdesktop.listeDesApplications[key]
                    console.log(app.url)
                    if (app.url.indexOf(url)!=-1)
                    {
                        bFind=true;break
                    }
                }
                if (bFind)
                {
                    console.log("app trouvé")
                    if (app.categorie!=newCategorie)
                    {
                        $mxdesktop.listeDesCategories[app.categorie].apps = jQuery.grep($mxdesktop.listeDesCategories[app.categorie].apps , function (value) {
                            return value.id != app.id;
                        });
                        app.categorie=categorie
                        $mxdesktop.listeDesCategories[app.categorie].apps.push(app)
                    }
                }
            }
        })


        // Parse du xml
        $xml.find("buttondata").each(function(){

            // Récupération des données depuis le xml
            infos={url:xmlText(this,'infos_url'),
                   type:xmlText(this,'infos_type'),
                   message:xmlText(this,'infos_message')}


            categorie=xmlText(this,'categoriename');
            libelle=xmlText(this,'libelle')
            libellecours=xmlText(this,'libellecours') || libelle;
            nom=xmlText(this,'nom')

            // Determine la categorie a partir du nom (cf ancienne nomenclature)
            if ((categorie==undefined || categorie=="") && nom.indexOf("/")!=-1) {
                categorie=nom.split("/")[0];
                libelle=nom.split("/")[1];
                if (libelle=="") libelle=categorie
            }

            // Création d'une appli
            app=$mxdesktop.createApp({id:Math.random().toString(36).substring(7),
                 libelle:libelle,src:source,srcicone:srcicone,
                 libellecours:libellecours,
                 icon:xmlText(this,'icon'),
                 url:xmlText(this,'url'),
                 nom:nom,
                 infos:infos,
                 infosChecked:[],
                 favoris:false,
                 categorie:categorie
            });

            // Ajoute l'url une seule fois
            if (url[app.url] == undefined )
            {
                url[app.url]=app

                if ($mxdesktop.nomDesApplications[app.key()] == undefined)
                {
                    $mxdesktop.nomDesApplications[app.key()]=[]
                }
                $mxdesktop.nomDesApplications[app.key()].push(app);

                // Si il y a pas de categorie, on tente de le récupérer dans le nom
                if (app.categorie=="" && nom.indexOf("/")!=-1)
                {
                    a=app.nom.split("/")
                    app.categorie=a[0];
                    if (a.length>1) app.nom=a[1];
                }

                // Ajout à la liste des categories
                $mxdesktop.listeDesCategories[$mxdesktop.allCategorie].apps.push(app);

                if ($mxdesktop.listeDesCategories[app.categorie] == undefined )
                {
                   $mxdesktop.listeDesCategories[app.categorie]={name:app.categorie,
                                                                 color:getDefaultCategorieColor(app),
                                                                 icone:"fa-folder",
                                                                 apps:[]}
                }
                $mxdesktop.listeDesCategories[app.categorie].apps.push(app);

                // Ajout à la liste des applications
                $mxdesktop.listeDesApplications[app.id]=app;
            }
        })

        // Sera utile pour créer les badges, qui se base sur $envole.xdesktop
        $envole.xdesktop.listeDesApplications=$mxdesktop.listeDesApplications;

        return $mxdesktop.listeDesCategories;
    },

    // Création du menu qui s'affiche a gauche
    createMenu:function() {

             

            // Trie la liste des categories
            var keys = Object.keys($mxdesktop.listeDesCategories);
            keys.sort($mxdesktop.sortCategorie);

            // Construction de la liste des catégories
            //for (key in $mxdesktop.listeDesCategories)
            for (z=0;z<keys.length;z++)
            {
                key=keys[z]
                categorie=$mxdesktop.listeDesCategories[key]

                // Pas d'appli, on passe à la catégorie suivante
                if (categorie.apps.length==0) continue;

                cattop=$("<div>").addClass("topcategorie")
                                 .css("background-color",categorie.color)

                a=$('<a href="#" class="categorie" catname="'+key+'">'+categorie.name+'</a>')

                // Ajout d'une icone si elle existe
                if (categorie.icone!=undefined && categorie.icone.indexOf("fa-")!=0)
                {
                    a.html('<span class="glyphicon glyphicon-'+categorie.icone+'"></span>'+categorie.name);
                    a.find("span").css("color",categorie.color)
                } else
                {
                    a.html('<i class="fa '+categorie.icone+' marker"></i>'+""+categorie.name+"");
                    a.find("i").css("color",categorie.color)
                }

                if ($("#li"+key).length!=0) continue;

                li=$("<li>").append(cattop).append(a).attr("id","li"+key).attr("role","categorie")

                // Construction de la liste des applis dans la categorie
                if (key!=$mxdesktop.favorisCategorie) {
                    ul=$("<ul class='catapps' catname='"+key+"'>")
                    for (i=0;i<categorie.apps.length;i++)
                    {
                        app=categorie.apps[i]
                        icone=$("<icone class='small'>").css("background-image","url("+app.icon+")")
                                          .attr("appid",app.id)
                        libelle=$("<span class='libelle'>"+app.libelle+"</span>").append(icone)
                        cattop=$("<i class='fa'>").addClass(categorie.icone).addClass("marker").css("color",categorie.color)
                        span=$("<a href='#' appid='"+app.id+"'>")
                        tr=$("<tr>").append($("<td>").append(cattop)).append($("<td>").append(icone)).append($("<td>").append(libelle))
                        span.append($("<table>").append(tr))
                        span.click(function(){
                            appid=$(this).attr("appid")
                            app=$mxdesktop.openApp(appid);
                        })

                        liapp=$("<li>").append(span)
                        liapp.attr("appid",app.id)
                        ul.append(liapp)
                    }
                    li.append(ul);

                    ul.hide();
                }

                $(".navbar-left ul.nav").append(li)

            } // End for

            $( "#li"+$mxdesktop.favorisCategorie ).insertBefore($("#li"+$mxdesktop.inprogressCategorie))
            $( "#li"+$mxdesktop.allCategorie ).insertBefore($("#li"+$mxdesktop.inprogressCategorie))

            // Clique sur la toolbar pour réduire l'espace catégorie
            $(".navbar-left .toolbar").click(function() {

                if (!$(".navbar-left").hasClass("small"))
                {
                    $(".navbar-left").addClass("small")
                    $(".appContainer").addClass("small")
                } else
                {
                    $(".navbar-left").removeClass("small")
                    $(".appContainer").removeClass("small")
                }
                AdjustHeight()
            })


            // Clique sur une categorie
            $("a.categorie").click(function()
            {
                categorie=$(this).attr("catname")

                if (categorie==$mxdesktop.searchCategorie) return;

                // Ouverture de la catégorie
                $mxdesktop.openCategorie(categorie)

                $(".navbar-left").removeClass("small")
                $(".appContainer").removeClass("small")

            });

            // Ouverture de la categorie allCategorie
            $mxdesktop.openCategorie($mxdesktop.allCategorie);

            // On ajuste la taille de la fenetre
            AdjustHeight();

            // Lorsque la grille des appli devient visible on enleve la class active sur les éléments encours
            $('.tab-content .container:visible').livequery(function() {
                    $("#li"+$mxdesktop.inprogressCategorie).removeClass("active")
                    $("ul.catprogress li").removeClass("active");
                    $("li.search").hide();
                    $(".navbar-brand").html($mxdesktop.title)
            });

            // Cache la categorie des apps en cours
            $("#liencours").hide();

            // Les badges
            $envole.xdesktop.createInfosPlus(1); // Dans 1 ms
    },

    isSmall:function() {
        return ($(".navbar-toggle").is(":visible"))
    },

    hideAll:function() {
        $(".panel").hide();
    },

    addReflection:function() {
        $("icone").addClass("reflectBelow")
    },

    drawCustomScrollbar: function() {

        $("#listedesicones").mCustomScrollbar("destroy");
        // Mod enom mobile on met la scrollbar custom
        if (!IsMobile())
        {
            $("#listedesicones").mCustomScrollbar({scrollInertia:200,theme:"dark-thick"});
            $("#listedesicones").redraw();
        }
    },

    performSearch:function(event) {

        $element=$(event.target)

        // La liste des icones est affichée
        if ($("#icons li").length!=0)
        {
            $("#listedesicones").mCustomScrollbar("destroy");
            $("#icons li[others='true']").addClass("large")
            filter("#icons > li",$element.val())

            // Si pas de filtre, on unlight le tout
            if ($element.val()=="")
            {
                 $("body").unhighlight()
                 $("#icons li[others='true']").removeClass("large")
            } else
            {
                if ($("#btnGroupBycategorie").hasClass("active"))
                {
                    // On va cacher les toolbars on il y a aucun item afficher
                    $("#icons .toolbar").each(function() {
                        cat=$(this).attr("categorie")
                        b=false
                        $("#icons > li[categorie='"+cat+"']").each(function() { if ($(this).is(":visible")) b=true })
                        if (!b) {
                            $(this).hide()
                            $("#icons div[categorie='"+cat+"']").hide();
                        } else
                        {
                            $(this).show()
                            $("#icons div[categorie='"+cat+"']").show();
                        }
                    });
                }
            }

            $mxdesktop.drawCustomScrollbar();

            // L'action précédente enlève le focus sur la zonne de recherche on la remet donc
            $element.focus();

        }
        // Sinon on recherche dans la zone de gauche
        else
        {
            $(".navbar-left ul.nav li").show();

            // Si plus aucune app en cours on cache le menu (qui vient d'être affiché avec la ligne précédente)
            if ($("ul.catprogress li").length==0)
            {
                $("#liencours").hide();
            }

            // Pas de valeur de recherche on remet tout par défaut
            if ($element.val()=="")
            {
                $mxdesktop.unSelectAllCategorie()
                $("body").unhighlight()
                return;
            }

            // Cache la categorie 'all'
            $mxdesktop.getCategorie($mxdesktop.allCategorie).parent().hide();

            // on étend toutes les categories
            $(".catapps").css({"height":"auto"});
            $(".catapps[catname!='"+$mxdesktop.allCategorie+"']").each(function(){
                catname=$(this).attr("catname")
                categorie=$mxdesktop.listeDesCategories[catname]
                $(this).css("background-color",lighter(categorie.color))
                $(this).parent().css("background-color",lighter(categorie.color,1,0.2))
            })

            // on affiche les categories sauf 'all'
            $(".catapps[catname!='"+$mxdesktop.allCategorie+"']").show();

            // Appliquons le filtre
            filter(".catapps li",$element.val())

            // On va afficher uniquement les categories disposant d'au moins un lien
            $(".catapps[catname!='"+$mxdesktop.allCategorie+"']").each(function(){
                b=false
                $(this).mCustomScrollbar('destroy');
                $(this).find("li").each(function() { if ($(this).is(":visible") ) b=true;})
                if (!b) $(this).parent().hide(); else
                { $(this).parent().show();$(this).mCustomScrollbar(); }
            })
        }
    },

    // retourne l'objet app en fonction de son id
    app:function(appid) {
        return $mxdesktop.listeDesApplications[appid]
    },

    // Recherche une app par son url, retourne null si pas trouvé
    findAppByUrl:function(url) {
        for (key in $mxdesktop.listeDesApplications)
        {
            app=$mxdesktop.listeDesApplications[key]
            if (app.url.toLowerCase()==url)
            {
                return app
            }
        }
        return null;

    },

    //
    favorisAppToggle: function(appid) {
        $mxactions.favorisAppToggle($mxdesktop.app(appid))
    },

    // recharge d'une application
    reloadApp:function(appid) {
        $mxdesktop.closeApp(appid)
        $mxdesktop.openApp(appid)
    },

    // Permet de mettre à jour la toolbar d'une app
    updateToolbarForApp:function(appid)
    {
        app=$mxdesktop.app(appid)
        // Occupons nous de l'icone favoris
        $fav=$("#btnFavoris span")
        $fav.removeClass()
        $fav.addClass("glyphicon")
        if (app.favoris)
        {
            $fav.addClass("glyphicon-heart")
            $fav.css("color","red")
        } else
        {
            $fav.addClass("glyphicon-heart-empty")
            $fav.css("color","black")
        }
    },

    // fermeture d'une application
    closeApp:function(appid) {
        app=$mxdesktop.app(appid)

        // Si la frame existe on la supprime
        if (app.iframe!=undefined)
        {
            app.iframe.remove();
            delete app.iframe
        }

        // Supression de l'entrée dans les apps en cours
        li=$("ul.catprogress li[appid="+app.id+"]")
        li.remove();

        // Si plus aucune app en cours on cache le menu
        if ($("ul.catprogress li").length==0)
        {
            $("#liencours").hide();
        }

        // Affiche, toutes les apps
        $mxdesktop.openCategorie($mxdesktop.allCategorie);

    },

    // Lors d'une erreur sur le chargement d'une app, on met un point !
    errorOnLoadingApp:function(appid) {
        app=$mxdesktop.app(appid)
        $("ul.catprogress li[appid="+appid+"] i").removeClass().addClass("pull-left")
                                                 .addClass("fa")
                                                 .addClass("fa-exclamation")
                                                 .css("color","red !important").redraw()

    },

    // Ouverture d'une URL
    openApp:function(appid) {

        app=$mxdesktop.listeDesApplications[appid]

        $(".appContainer iframe").hide();
        $mxdesktop.clear()


        // Mode normal, on affiche l'appli dans une iframe a droite
        if (/*!$mxdesktop.isSmall()*/true)
        {
            // Si le lien est en http dans un contexte https
            if ( (parent.location.href.indexOf("https://")==0) && (app.url.indexOf("http://")==0) )
            {
                // TODO: Traiter le cas http
                alert("non https, not yet implemented")
                return
            }

            // Iframe inexistante, on va en créer une
            if (app.iframe==undefined)
            {
                iframe=$("<iframe>").attr("appid",app.id)

                categorie=$mxdesktop.listeDesCategories[app.categorie];

                // Capture de l'évenement onload
                iframe.load(function() {
                    appid=$(this).attr("appid")
                    app=$mxdesktop.app(appid)
                    if (app.timerLoading) clearTimeout(app.timerLoading)
                    delete app.timerLoading

                    $("ul.catprogress li[appid="+appid+"] i").removeClass()
                                                             .addClass("pull-left").addClass("fa").addClass(categorie.icone)
                                                             .css("color",categorie.color).redraw()
                    $(this).redraw();
                })

                // capture de l'évenement onerror
                iframe.error(function() {
                    appid=$(this).attr("appid")
                    $mxdesktop.errorOnLoadingApp(appid)
                })

                // Lorsqu'une iframe est visible on deselectionne les categories
                $('iframe[appid='+app.id+']:visible').livequery(function() {
                    app.active();
                })

                // Demande le chargement de l'appli
                iframe.attr("src",app.url)
                // Timer de 10s
                app.timerLoading = setTimeout($mxdesktop.errorOnLoadingApp, 10000,[app.id]);

                $(".appContainer").append(iframe)
                app.iframe=iframe

                // Récupération de la categorie "InProgress pour ajouter l'appli
                $link=$mxdesktop.getCategorie($mxdesktop.inprogressCategorie)
                $element=$("ul.catapps li[appid="+app.id+"]").clone();
                $element.find(".marker").css("color",$mxdesktop.listeDesCategories[app.categorie].color)
                $link.parent().find("ul").append($element[0])

                // Ajout d'un indicateur de chargement
                $("ul.catprogress li[appid="+appid+"] i").addClass("fa-spinner")
                                                         .addClass("fa-spin")
                                                         .css("color","black")

                $element.click(function() {
                    appid=$(this).attr("appid")
                    $mxdesktop.openApp(appid)
                    $mxdesktop.unSelectAllCategorie();
                })

            }
            // sinon on l'affiche
            else
            {
                iframe=app.iframe
                iframe.show()
            }

            $("body").css("background-color","white")

            // Construction de la toolbar,
            $(".appToolbar").remove()
            $(".appContainer").prepend('<div class="appToolbar"></div>')

            actions=$("<div>").addClass("actions").addClass("btn-toolbar")
            toolbar=$("<div class='btn-group'>")

            // Texte informatif
            infos=$("<div class='toolinfos'>")
            table=$("<table><tr>")
            expand=$('<td></td>')
            icone=$("<icone class='small'>").css("background-image","url("+app.icon+")")
            texte=$("<td><span>"+app.nom+"</span></td>")
            table.append(expand).append($("<td>").append(icone)).append(texte)
            infos.append(table)

            // Buttons
            // close
            close=$('<button type="button" class="btn btn-danger btn-xs">')
            close.append($('<span class="glyphicon glyphicon-remove">'))
            close.click(function() {$mxdesktop.closeApp($(this).attr("appid"))    });

            // expand
            expand=$('<button type="button" class="btn btn-danger btn-xs">')
            expand.append($('<span class="glyphicon glyphicon-resize-full">'))

            // favoris
            favoris=$('<button type="button" class="btn btn-normal btn-xs visible-lg" id="btnFavoris">')
            favoris.append($('<span class="glyphicon glyphicon-heart-empty">'))
            favoris.click(function() {$mxdesktop.favorisAppToggle($(this).attr("appid"))    });

            // Epingler
            epingler=$('<button  type="button" class="btn btn-normal btn-xs visible-lg" id="btnEpingler">')
            epingler.append($('<span class="glyphicon glyphicon-pushpin">'))

            // reload
            refresh=$('<button type="button" class="btn btn-success btn-xs">')
            refresh.append($('<span class="glyphicon glyphicon-refresh">'))
            refresh.click(function() {$mxdesktop.reloadApp($(this).attr("appid"))    });

            toolbar.append(refresh).append(epingler).append(favoris).append(close)
            actions.append(toolbar)

            toolbar.find(".btn").attr("appid",app.id)

            $(".appToolbar").append(infos).append(actions).addClass("navbar-inverse")
            $mxdesktop.updateToolbarForApp(app.id)

            iframe.css("width","100%")

            $(".navbar-left").removeClass("active")
            $(".navbar-left").addClass("fermer")

            $(".starter-template p.lead").empty();
            $(".tab-content .container").hide();

            // Affiche la liste des appli en cours et l'appli
            setTimeout(function() {$(".appContainer").show();$("#liencours").show();app.active()},800,[app]);

            h=$(window).height()-$(".btn-toolbar").height();
            iframe.css("height",h+"px")

            AdjustHeight();

        } else
        {
            window.open(app.url,app.nom)
        }
        return app

    },

    // Ouverture des favoris
    openFavoris:function() {

        $(".starter-template p.lead").empty();
        $("#badgescontainer").empty();
        $(".starter-template h2.help").hide()

        // Affiche le container
        $(".appContainer").hide();
        $(".container").show();

        $(".starter-template p.lead").html("Pas encore implémenté");

    },

    clear:function() {
        // Un peu de netoyage
        $(".starter-template p.lead").empty();
        $("#badgescontainer").empty();
        $("#dvInfosContainer").empty();
        $("#qtip-"+$mxdesktop.notificationsQtip).qtip('destroy', true);
    },

    getCategorie:function(categorie) {
        $link=$(".navbar-left ul.nav a.categorie[catname='"+categorie+"']")
        return $link;
    },

    // enleve la selection sur les categories
    unSelectAllCategorie:function(categorie) {
        if (categorie!=$mxdesktop.searchCategorie) {
            $(".navbar-left ul li[role='categorie']").removeClass("active");
        }

        $(".navbar-left ul.nav li").css("background-color","rgba(0,0,0,0)");
       // $("#li"+$mxdesktop.inprogressCategorie).css("background-color","white");

       // $(".catapps").css({"height":"0px"});
        $(".catapps").hide('slow');
    },

    // Ouverture d'une categorie
    openCategorie:function(categorie) {

                // On tente d'ouvrir l'item search, y a rien à faire
                if (categorie==$mxdesktop.searchCategorie) return

                $link=$mxdesktop.getCategorie(categorie)

                // Déja actif ?, on enleve la selection et on s'en va
                if ($link.parent().hasClass("active"))
                {
                    $mxdesktop.unSelectAllCategorie(categorie)
                    return;
                }

                // un-select allCategories and Selection de l'item
                $mxdesktop.unSelectAllCategorie(categorie)
                $link.parent().addClass("active")

                currentCategorie=$link.attr("catname")

                // cas spécificiques  Notifications et favoris -----
                if (categorie==$mxdesktop.notificationsCategorie)
                {
                    $mxdesktop.openNotifications();
                    return
                }

                // --------------------------------------------------
                //$(".tab-content .container").mCustomScrollbar("destroy");

                // On change la couleur du body
                color=$mxdesktop.listeDesCategories[currentCategorie].color
                //$("body").css("background-color",color)
                $link.parent().css("background-color",color)

                $mxdesktop.clear()

                // Création de la liste des icones
                if ( $(".tab-content .container").is(":visible") ||
                     currentCategorie==$mxdesktop.allCategorie ||
                     currentCategorie==$mxdesktop.favorisCategorie || (IsMobile() && $mxdesktop.isSmall()) )
                {

                    $(".starter-template h2.help").hide()


                    // ================== CREATION DE LA BARRE D'OUTILS ================================
                    // Gestion des options d'affichage
                    mainbar=$('<div class="mainbar">')
                    groupe=$('<div class="btn-group">')

                    // Afficher / cacher les favoris
                    showFavoris=$('<a type="button" class="btn btn-default active" role="button">')
                    showFavoris.append($('<i class="fa fa-heart">')).attr("title","Afficher/Cacher les favoris")
                    showFavoris.click(function()
                    {
                        if ($(this).hasClass("active")) { $(this).removeClass("active");$("#icons [role='favoris']").hide('fast'); }
                        else  { $(this).addClass("active");
                                exclude=""
                                if (showAll.hasClass("active")) exclude="[groupby!='byCategorie']"
                                $("#icons [role='favoris']"+exclude).show('fast');
                         }
                    })

                    // Affichage des notifications
                    showNotifications=$('<a type="button" class="btn btn-default" role="button">').attr("id","btnshowNotifications")
                    showNotifications.append($('<i class="fa fa-bell-o">&nbsp;<span class="badge"></span>')).attr("title","Voir les notifications")
                    $mxdesktop.openNotifications
                    showNotifications.qtip({
                                id:$mxdesktop.notificationsQtip,
                                position: {
                                    my: 'top center',
                                    at: 'bottom center',
                                    target: showNotifications,
                                    adjust: { y:0 }
                                },
                                show: {
                                    event: 'click',
                                    effect: function() {$(this).slideDown();},
                                    render: function() {
		                                $(this).attr('id', 'myID'); // MARCHE PAS
	                                }
                                },
                                hide: {
                                    fixed:true,delay:3000,
                                    effect: function() {$(this).slideUp();}/*,event: 'click'*/
                                },
                                prerender: true,
                                style: {
                                    classes:'qtip-bootstrap',width:'350px'
                                }
                    })

                    setTimeout(function() {$mxdesktop.OnAddInfoPlus()},100);

                    // Afficher
                    showByCategorie=$('<a type="button" id="btnGroupBycategorie" class="btn btn-default active" role="button">')
                    showByCategorie.append($('<i class="fa fa-list-ul">')).attr("title","Grouper par catégorie")
                    showByCategorie.click(function() {$("#icons [groupby='byCategorie']").show('fast',function() {$mxdesktop.drawCustomScrollbar();})})

                    showAll=$('<a type="button" class="btn btn-default" role="button">')
                    showAll.append($('<i class="fa fa-th">')).attr("title","")
                    showAll.click(function() {$("#icons [groupby='byCategorie']").hide('fast');})

                    // Groupe de recheche
                    searchGroup=$('<div class="input-group"><span class="glyphicon glyphicon-search input-group-addon"></span></div>')
                    searchInput=$('<input type="search" class="form-control" placeholder="rechercher une application">')
                    searchInput.bind('keyup',$mxdesktop.performSearch) // Sur keyup on lance la recherche
                    searchGroup.append(searchInput)
                    searchGroup.find(".glyphicon").css("top","0px")

                    mainbar.append(searchGroup);
                    if ( currentCategorie==$mxdesktop.allCategorie ) mainbar.append(showFavoris);

                    mainbar.append("&nbsp;")
                    mainbar.append(showNotifications)

                    mainbar.append("&nbsp;")

                    groupe.append(showByCategorie);
                    groupe.append(showAll);
                    groupe.find("a").click(function(){$(this).parent().find("a").removeClass("active");$(this).addClass("active")})

                    mainbar.append(groupe)
                    $(".starter-template p.lead").append(mainbar)
                    // ================== FIN DE CREATION DE LA BARRE D'OUTILS ================================

                    listedesicones=$("<div>").attr("id","listedesicones").css("overflow-y", "auto")
                    listedesicones.append("<ul id='icons'></ul>");
                    ul=$(".starter-template p.lead").append(listedesicones)
                    $mxdesktop.listeDesCategories[currentCategorie].apps.sort(SortAppByCategorie)

                    arr=[]
                    arr=arr.concat($mxdesktop.listeDesCategories[currentCategorie].apps)

                    // Si 'toutes' les appli sont affichées on ajoute tout d'abord les favoris
                    if (currentCategorie==$mxdesktop.allCategorie)
                    {
                        for (i=0;i<$mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].apps.length;i++)
                        {
                            a=$mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].apps[i]
                            arr.unshift(a)
                        }
                    }

                    appIdentiques={}

                    lastIsFav=false
                    lastCategorie=""
                    for (i=0;i<arr.length;i++)
                    {
                        app=arr[i]

                        if (appIdentiques[app.key()]!=undefined) continue;

                        // Une appli ne peut être affiché qu'une seule fois !!!
                        if ($("#icons li[appid='"+app.id+"']").length!=0) continue;

                        // Si l'app précédente est favoris et l'actuelle non
                        // on va créer des toolbars de séparation
                        if (lastIsFav && !app.favoris) {

                            // Toolbar favoris
                            favoris=$mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie]
                            toolbar=$("<div class='toolbar'>").attr("role","favoris").attr("groupby","byCategorie")
                            toolbar.append('<span class="glyphicon glyphicon-'+favoris.icone+'"></span> ')
                            toolbar.append(favoris.name)
                            deleteZone=$("<button type='button'>").addClass("btn").addClass("btn-danger").css("float","right")
                            deleteZone.append('<span class="glyphicon glyphicon-trash"></span> Déposer ici pour supprimer').css("opacity","0")
                            deleteZone.droppable({
                              accept: "#icons li[favoris='true']",
                              activeClass: "delete-favoris-active",
                              hoverClass: "delete-favoris-hover",
                              drop: function( event, ui ) {
                                //event.preventDefault()
                                $mxactions.removeFromFavoris(ui.draggable.attr("appid"),
                                                        function() {$mxdesktop.openCategorie($mxdesktop.allCategorie);}
                                                       )
                             }
                            });
                            toolbar.append(deleteZone)

                            $( "#icons" ).prepend(toolbar)
                            dropzone=$("<div>")
                                               .css("height","auto")
                                               .css("display","inline-block").attr("role","favoris")
                            dropzone.droppable({
                              accept: "#icons li[favoris!='true']",
                              activeClass: "favoris-state-active",
                              hoverClass: "favoris-state-hover",
                              drop: function( event, ui ) {
                                $mxactions.addToFavoris(ui.draggable.attr("appid"),
                                                        function() {$mxdesktop.openCategorie($mxdesktop.allCategorie);}
                                                       )
                             }
                            });

                            $( "#icons" ).append(dropzone)

                            separateur=$("<div>").css("width","100%").css("height","1px").css("display","inline-block").attr("groupby","byCategorie")
                            $( "#icons" ).append(separateur)

                            $( "#icons li").appendTo(dropzone)

                            // Toolbar all
                            /*all=$mxdesktop.listeDesCategories[$mxdesktop.allCategorie]
                            toolbar=$("<div class='toolbar'>")
                            toolbar.append('<span class="glyphicon glyphicon-'+all.icone+'"></span> ')
                            toolbar.append(all.name)
                            $( "#icons" ).append(toolbar)*/

                            lastCategorie=""
                        }

                        // Toolbar permettant de séparer les catégories, l'attribut grouby='byCategorie' va nous servir de filtre
                        if (lastCategorie!=app.categorie && !app.favoris)
                        {
                            separateur=$("<div>").css("width","100%").css("height","1px").css("display","inline-block").attr("groupby","byCategorie").attr('categorie',app.categorie)
                            $( "#icons" ).append(separateur)

                            c=$mxdesktop.listeDesCategories[app.categorie]
                            toolbar=$("<div class='toolbar'>").attr("groupby","byCategorie").attr('categorie',app.categorie).css("border-bottom-color",c.color)
                            stack=$('<span class="fa-stack fa-lg">').css("color",c.color)
                            stack.append('<i class="fa fa-circle fa-stack-2x"></i>')
                            stack.append('<i class="fa '+c.icone+' fa-stack-1x fa-inverse"></i>')
                            toolbar.append(stack)
                            toolbar.append(c.name)

                            $( "#icons" ).append(toolbar)
                        }

                        lastIsFav=app.favoris
                        lastCategorie=app.categorie

                        // Construction des éléments
                        source=$("<div class='source'>"+"</div>").css("background-image","url('"+app.srcicone+"')")


                        icone=$("<icone>").css("background-image","url("+app.icon+")")
                                          .attr("appid",app.id)
                                          .attr("id","icon_"+app.id);


                        icone.append(source).append($("<badges>"))

                        //icone.append($('<span class="others fa-stack fa-lg"><i class="fa fa-plus-circle fa-stack-2x"></i></span>'))
                        divi=$("<div>").append(icone).css("border-color",$mxdesktop.listeDesCategories[app.categorie].color)
                        $plus=$('<span class="others fa-stack fa-lg"><i class="fa fa-plus-circle fa-stack-2x"></i></span>')

                        text=$("<texte>"+app.libellecours+"</texte>")
                        table=$("<table>")
                        tr1=$("<tr>");td=$("<td>").append(divi).addClass("tdicone") ;tr1.append(td)
                        tr2=$("<tr>");td=$("<td>").append(text).addClass("tdtexte")  ;tr2.append(td)
                        tr3=$("<tr>");td=$("<td>").append($plus);tr3.append(td)
                        table.append(tr1).append(tr2).append(tr3)

                        div=$("<div class='divicone'>").append(table)
                        li=$("<li>").append(div).attr("appid",app.id).attr("favoris",app.favoris).attr('categorie',app.categorie)
                        // Ajout à la liste des icones
                        $( "#icons" ).append(li)

                        // Traitement des appli avec la même catégorie et le même nom
                        if ($mxdesktop.nomDesApplications[app.key()]!=undefined && $mxdesktop.nomDesApplications[app.key()].length > 1 )
                        {
                            divapps=$("<div>").addClass("apps").attr("appid",app.id)
                            divapps.append("<span>"+app.nom+"</span>")
                            listeDesAppIdentiques=$("<ul>")
                            for (var z=0;z<$mxdesktop.nomDesApplications[app.key()].length;z++)
                            {
                               a=$mxdesktop.nomDesApplications[app.key()][z]
                               l=$("<li>"+a.libelle+"</li>").attr("appid",a.id)
                               listeDesAppIdentiques.append(l)
                            }
                            divapps.append(listeDesAppIdentiques)
                            divi.append(divapps)
                            li.attr("others","true")
                            self=li
                            self.qtip({
                                content: {
                                    text:divapps
                                },
                                position: {
                                    my: 'top center',
                                    at: 'bottom center',
                                    target: self.find("span.others"),  viewport: $(".starter-template"),
                                    adjust: { y:0 }
                                },
                                show: {
                                    event: 'click',
                                    effect: function() {$(this).slideDown();}
                                },
                                hide: {
                                    fixed:true,delay:300,
                                    effect: function() {$(this).slideUp();}
                                   /* event: 'click'*/
                                },
                                style: {
                                    classes:'qtip-bootstrap'
                                },
                                events: {
                                    show: function(event, api) {
                                        appid=$(this).find(".apps").attr("appid")
                                        $("#icons li[appid!='"+appid+"']").animate({opacity: "0.2"}, 500)
                                    },
                                    hide: function(event, api) {
                                        self.redraw();
                                        appid=$(this).find(".apps").attr("appid")
                                        $("#icons li[appid!='"+appid+"']").animate({opacity: "1"}, 500)
                                    }
                                }
                            })
                            text.html(app.libellecours)
                        }

                        appIdentiques[app.key()]=true


                    } // End each app


                    $("#icons > li[favoris!='true']").draggable({helper: 'clone'});
                    $("#icons > li[favoris='true']").draggable({helper: 'clone'})

                    // Un peu de reflection
                    $mxdesktop.addReflection();

                    // Clique sur Icone
                    $("#icons li").click(function() {
                        if ($(this).attr("others")=="true")
                        {
                            /*if ( $(this).hasClass("large") ) {
                                $(this).removeClass("large")
                           } else {
                                $(this).addClass("large")
                            }*/
                            //.show();


                            return
                        }


                        appid=$(this).attr("appid")
                        $mxdesktop.openApp(appid)
                    });

                    $(".appContainer").hide();
                    $(".tab-content .container").show();

                    AdjustHeight();
                    $mxdesktop.drawCustomScrollbar();

                } else
                {
                    //$(".starter-template h1").hide()
                    //$(".tab-content .container").mCustomScrollbar("destroy");
                    //$(".starter-template h2.help").show()
                }

                $(".starter-template p.lead").show();

                // On étend la liste des appli (si appContainer est visible, pas 'toutes les applis' sélectionnés et pas en mode 'petit'
                if ( ($(".appContainer").is(":visible") || ($mxdesktop.isSmall()&& !IsMobile())) &&
                       currentCategorie!=$mxdesktop.allCategorie
                   )
                {
                    ul=$link.parent().find(".catapps")
                    ul.show('slow',function() {
                        if (!$(this).hasClass("mCustomScrollbar"))  $(this).mCustomScrollbar();
                    });

                }

                if ( $mxdesktop.isSmall() && IsMobile() )
                {
                    $(".navbar-left").addClass("fermer")
                    $(".navbar-left").removeClass("active")
                }


    }

};


