/*===================================================================
Loading: Module permettant d'afficher la progression de chargement

v1: 17/01/2014 : cleon : création

*/


aspects.loading.create = function(){
 var __instance=new function()
{
this.version = "1.0";


// Sur une Initialisation on met en place la div permettant de cacher l'environnement
// et de faire afficher la progression du chargement
$mxdesktop.Initialisation=AOP.aspect($mxdesktop.Initialisation).before(function(f,args) 
{
    w=550
    if ( $(window).width() <768 ) w=320

    $loadingDiv=$("<div id='aop_loading'>").css({"width":"100%","height":"100%","position":"absolute","top":"0px","left":"0px","z-index":1000,"background-color":"rgba(255,255,255,0.9)","margin":"auto auto","text-align":"center"})
    $messageDiv=$("<div>").css({"width":w+"px","height":"300px","margin":"auto","margin-top":"50px",
"margin": "50px auto auto",
"padding": "15px",
"border": "1px solid lightgray",
"border-radius": "5px",
"background-color": "rgba(245,245,245,0.5)",
"box-shadow": "1px 1px 12px #CCC"})
    $messageDiv.append("<p class='lead'><i class='fa fa-coffee'></i>  Chargement de votre environnement en cours, <br> Veuillez patienter...</p><br>")

    $sourcesInfo=$("<div>").css({"text-align":"left"})

    $messageDiv.append($sourcesInfo)
    $loadingDiv.append($messageDiv)
    
    $(".tab-content").prepend($loadingDiv)   
});

// recupererLesItemDeBureau : Est appelé lors de la demande de récupération d'une ressource
$mxactions.recupererLesItemDeBureau=AOP.aspect($mxactions.recupererLesItemDeBureau).before(function(f,args) 
{
    if ($mxdesktop.config.desktopitems.length==0) return;

    source=$mxdesktop.config.desktopitems[0]
    if (source.id==undefined) source.id=RANDOM()
    
    if ($("#aoploading"+source.id).length!=0) return;

    // Ajout de la source avec un spinner
    load="<i class='fa fa-spinner fa-spin'></i>"
    $sourcesInfo.append("<div nom='"+source.nom+"' rid='"+source.id+"' id='aoploading"+source.id+"'>"+load+"   "+source.nom+"</div>")

});


// GetCategories : Est appelé lors du callback, après retour de l'url de récupération
$mxdesktop.GetCategories=AOP.aspect($mxdesktop.GetCategories).after(function(f,args) 
{   
   $sourcesInfo.find("div").each(function(o,v) {
        nom=$(this).attr("nom")
        rid=$(this).attr("rid")
        if ($mxdesktop.listeDesSources[rid]!=undefined)
        {   
            $i=$(this).find("i")
            $i.removeClass("fa-spinner fa-spin").addClass("fa-check").css("color","#090")
        } 
    });

    // Si plus de sources en chargement, on affiche l'appli
    setTimeout(function() {
        if ($sourcesInfo.find("i.fa-spin").length==0) {
            $loadingDiv.fadeOut("fast",function() {$loadingDiv.remove()})
        }
    },1000);

});

// verificationDesSourcesChargees : Est appelé au bout de 10s pour vérifier que toutes les sources sont chargées
$mxdesktop.verificationDesSourcesChargees=AOP.aspect($mxdesktop.verificationDesSourcesChargees).before(function(f,args) 
{
    bKo=0
    fallback=undefined
   
    // Cache les items dont le chargement est OK
    $sourcesInfo.find("i.fa-check").each(function() {
        $(this).parent().hide("slow");    
    });

    //Met une coche en echec a coté des sources restantes
    for (sid in $mxdesktop.sourcesEnCoursDeChargement) 
    {
        source=$mxdesktop.sourcesEnCoursDeChargement[sid]
        $div=$sourcesInfo.find("div[rid='"+source.id+"']")
        if ($div.length!=0  )
        {   
            $i=$div.find("i")
            $i.removeClass("fa-spinner fa-spin").addClass("fa-times").css("color","red")
            bKo=bKo+1
            fallback=source.fallback
            source.fallback=undefined
        }       
    }

    // Si pas de pb , on enleve la div 'loading'
    if (bKo==0) {
        $loadingDiv.fadeOut("fast",function() {$loadingDiv.remove()})
    } 
    // Sinon, on notifie de l'erreur et invite a cliquer sur le bouton 'Continuer' (si au moins 1 source)
    else
    {
        m="Les ressources suivantes n'ont pu être chargées";
        if (bKo==1) m="La ressource suivante n'a pu être chargée"

        // Aucune source, n'a pu être récupérée
        if (Object.keys($mxdesktop.listeDesSources).length==0 )
        {
            m="<i class='fa fa-warning'></i>  Impossible de charger les ressources"
            if (fallback!=undefined) {
                $sourcesInfo.append("<br>L'application va charger les ressources locales uniquement<br><br>")
                $btn=$('<button type="button" class="btn btn-danger">Continuer</button>').addClass("pull-right")
                $sourcesInfo.append($btn)
                $btn.click(function() 
                {
                    $sourcesInfo.html("")
                    $mxdesktop.config.desktopitems=[fallback]
                    $btn.remove()
                    timerOfverificationDesSourcesChargees=setTimeout($mxdesktop.verificationDesSourcesChargees,5000);
                    $mxactions.recupererLesItemDeBureau();
                })
            }

            $sourcesInfo.append("<br>Si le problème persiste veuillez contacter l'administrateur de votre établissement.")
        } 
        // Au moins une source de dispo        
        else
        {
            $sourcesInfo.append("<br>Cliquer sur le bouton 'Continuer' pour accéder à votre environnement partiel<br><br>")
            $btn=$('<button type="button" class="btn btn-danger">Continuer</button>').addClass("pull-right")
            $sourcesInfo.append($btn)
            $btn.click(function() {
            $loadingDiv.fadeOut("fast",function() {$loadingDiv.remove()})
        });

        }
        
        $messageDiv.find("p.lead").html(m)
        
    }

    // Refresh de la div
    setTimeout(function(){$("body").css("height","99%")},100);
});

}
return __instance}



