/* =============================================================
seshat : Module permettant de charger les ressources
         depuis seshat. Ce module permet ainsi de récupérer
         dans un même espace les items de
            - Arena (si Pers. Educ. Nat. )
            - Tous établissements d'affectation 

configuration : 

seshat.ini
{
 "url":"https://<SESHAT-ACADEMIQUE>/edispatcher/ressources.php",
 "nom":"Ressources Communes ENT-Réunion"
}

=================================================================*/

aspects.seshat.create = function(){
    var __instance =new function()
    {
        this.version = "1.0";

        // Avant l'initialisation on va modififer la ressource principale à charger
        $mxdesktop.Initialisation=AOP.aspect($mxdesktop.Initialisation).before(function()
        {
            __instance.info("Load Ressource From Seshat")

            // Si c'est l'admin local on utilisera les ressources locales
            if ($mxdesktop.envole.uid == "admin") {
                __instance.info(" -> Admin user detected, loading local ressource")
                return    
            }

            // Récupération de la configuration
            __instance.getConfig(function(data) {
                if (data.length >0 && data[0].url != undefined)
                {
                    $mxdesktop.config.desktopitems=[{url:data[0].url,
                                                     nom:data[0].nom || "Ressources Communes ENT-Réunion",
                                                     callback:"controllers/callback.php",
                                                     fallback:$mxdesktop.config.desktopitems[0]
                                                   }]
                } else {
                    __instance.error("Aucune configuration valide pour seshat")
                }
            })


        });

    }    

    return __instance;
}

