/* =============================================================
seshat : Module permettant de charger les ressources
         depuis seshat. Ce module permet ainsi de récupérer
         dans un même espace les items de
            - Arena (si Pers. Educ. Nat. )
            - Tous établissements d'affectation 

configuration : 

seshatEnvole.ini
{
 "url":"https://<SESHAT-ACADEMIQUE>/edispatcher/ressources.php",
 "nom":"Ressources Communes"
}

=================================================================*/

aspects.seshatEnvole.create = function(){
    var __instance =new function()
    {
        this.version = "1.1";

        // Avant l'initialisation on va modififer la ressource principale à charger
        $mxactions.recupererLesItemDeBureau=AOP.aspect($mxactions.recupererLesItemDeBureau).before(function()
        {
            if (__instance.already!=undefined) return;

            __instance.already=true;
            __instance.info("Load Ressource From Seshat")

            // Si c'est l'admin local on utilisera les ressources locales
            if ($mxdesktop.envole.uid == "admin") {
                __instance.info(" -> Admin user detected, loading local ressource")
                source=$mxdesktop.config.desktopitems[0]; 
		source.services_url="xdesktop/controllers/mxServices.php";               
                $mxdesktop.listeDesOthersSources={}
                $mxdesktop.listeDesOthersSources[source.id]=source;
                $mxdesktop.defaultCategorie="Aucune categorie"
                return    
            }

            // Récupération de la configuration
            __instance.getConfig(function(data) {
                if (data.length >0 && data[0].url != undefined)
                {
                    url=data[0].url+"?rne="+$mxdesktop.envole.rne+"&provenance="+$mxdesktop.envole.provenance;
                    $mxdesktop.config.desktopitems=[{url:url,
                                                     nom:data[0].nom || "Ressources Communes",
                                                     callback:"controllers/callback.php",
                                                     fallback:$mxdesktop.config.desktopitems[0]
                                                   }]
                } else {
                    __instance.error("Aucune configuration valide pour seshat")
                }
            })
        });
    }    

    return __instance;
}

