// VERSION : 1.1f


// Init $envole
$envole={}
$envole.xdesktop={}
$envole.xdesktop.callback="controllers/infosplus.php"

var currentCategorie=undefined                      // Categorie actuellement affichée
var postitTimeout=undefined                         // Timeout pour l'affichage du postit
var timerOfverificationDesSourcesChargees=undefined // Timer permettant de vérifier que toutes les sources sont chargées

$mxdesktop={

    appWaitTimeLoading:30,  // Temps d'attente (en secponde) du chargement d'une appli, avant de dire qu'elle est HS
    sourcesWaitTimeLoading:20,  // Temps d'attente (en seconde) d'attente pour vérifier les sources

    appName:"Mes applications",
    allCategorie:"Toutes",
    notificationsCategorie:"notifications",
    favorisCategorie:"favoris",
    inprogressCategorie:"encours",
    categorieIcone:"fa-folder",
    searchCategorie:"search",
    defaultCategorieIcon:"fa-square",
    defaultCategorieColor:"#5d83aa",
    unableToLoadSourceMsg:"Impossible de charger les ressources pour cet établissement",
    mixedContentMessage:"<b>Pour des raisons de sécurité</b>,<br> les URL en http sont bloquées dans un environnement sécurisé en https.<br>Cette application, s'est donc ouverte dans un nouvel onglet de votre navigateur",
    appErrorMessage:"Une erreur est survenue au chargement de cette application, veuillez cliquer sur le lien suivant pour essayer de l'ouvrir dans une nouvelle fenêtre",
    appExternalMessage:"Cette application a été ouverte dans un nouvel onglet",
    appLoadingMessage:"<i class='fa fa-spinner fa-spin'></i> Veuillez patienter...",

    sourcesEnCoursDeChargement:{},

    css:['bootstrap/dist/css/bootstrap.css',
         'bootstrap/font-awesome/css/font-awesome.css',
         'bootstrap/assets/css/jquery.mCustomScrollbar.css',
         'bootstrap/assets/css/jquery.toastmessage.css',
         'style/mxdesktop.css','style/mxdesktop.local.css'],

    // Classe d'abord par indice de la catégorie puis par nom catégorie puis par nom de l'appli
    SortAppByCategorie:function(a, b){
      var aName = ($mxdesktop.listeDesCategories[a.categorie].indice || "999") +  a.key().toLowerCase();
      var bName = ($mxdesktop.listeDesCategories[b.categorie].indice || "999") +  b.key().toLowerCase();
      return ((aName < bName) ? -1 : ((aName > bName) ? 1 : 0));
    },

    // Classe d'abord par indice de la catégorie puis par nom catégorie puis par nom de l'appli
    SortAppWithoutCategorie:function(a, b){
      var aName =   a.keyWithoutCategorie().toLowerCase();
      var bName =   b.keyWithoutCategorie().toLowerCase();
      return ((aName < bName) ? -1 : ((aName > bName) ? 1 : 0));
    },

    // Utilisé pour la création des menus
    sortCategorie:function(a,b) {
        a1= $mxdesktop.listeDesCategories[a];
        b1= $mxdesktop.listeDesCategories[b];
        a2=(a1.indice || "999") + a1.name // 999: si pas d'indice on met à la fin
        b2=(b1.indice || "999") + b1.name // 999: si pas d'indice on met à la fin
        return ((a2 < b2) ? -1 : ((a2 > b2) ? 1 : 0));

    },

    log: function(msg) {
        $(".starter-template .help").html(msg);
    },

    writeCss: function(head) {
        for (i=0;i<$mxdesktop.css.length;i++)
        {
            if (head.find("link[href='"+$mxdesktop.css[i]+"']").length>0) continue
            head.append("<link rel='stylesheet' type='text/css' href='"+$mxdesktop.css[i]+"?nocache' />")
        }
    },


    // ==== Création d'un objet App : contient tous les attributs pour décrire une appli 
    createApp: function(attributs) {

	   // Si pas de libelle ou pas de nom on ne va pas créer d'application
	   if (!attributs.libelle || ! attributs.nom) return null;

           // Si icon commence par / on préfix par l'url de la source
           if (attributs.icon!=undefined && attributs.icon.indexOf("/")==0 && attributs.source.baseurl != undefined) {
                attributs.icon=attributs.source.baseurl+attributs.icon;
           }

           // Si url commence par / on préfix par l'url de la source
           var urlBase=attributs.url
           if (attributs.url && attributs.url.indexOf("/")==0 && attributs.source.baseurl != undefined) {
                urlBase=attributs.url;
                attributs.url=attributs.source.baseurl+attributs.url;
           }

           // Fixes: #8301, normalisation du nom des categories
           if (!attributs.categorie) attributs.categorie=""
           attributs.categorie=attributs.categorie.normalize()
    
           app= {id:Math.random().toString(36).substring(7),
                   libelle:attributs.libelle,
                   libellecours:attributs.libellecours || attributs.libelle,
                   icon:attributs.icon,
                   url:attributs.url,
                   urlBase:urlBase,
                   favurl:attributs.favurl || attributs.url,
                   listesDesUrl:[],
                   source:attributs.source,
                   nom:attributs.nom,
                   infos:attributs.infos,
                   infosChecked:[],
                   favoris:false,
                   external:attributs.external || false,
                   categorie:attributs.categorie,

                   isExternal:function() {
                      return this.external
                   },   
                   isMixedContent:function() {
                    return ( (window.location.href.indexOf("https://")==0) && (this.url.indexOf("http://")==0) )
                   },
 
                   toogleExternal:function() {
                     if (this.external==undefined || this.isExternal()) 
                        this.external=false
                     else 
                        this.external=true
                   },
                   json:function() {
                        return {id:this.id,libelle:this.libelle,icon:this.icon,
                                favurl:encodeURIComponent(this.favurl),url:encodeURIComponent(this.url),nom:this.nom,
                                categorie:this.categorie};
                   },
                   requestForService:function() {
                        o=this.json();s="";for (k in o) {s=s+"&"+k+"="+o[k] } // Construction des paramètres de l'appli
                        a=window.location.href.split("/");a[a.length-1]="controllers/services.php"; // Ajout du callback
                        s=s+"&callback="+a.join("/")
                        return s.replace("&","?")
                   },
                   key: function() {
                        return this.categorie+"/"+attributs.source.nom+"/"+this.nom;
                   },
                   keyWithoutCategorie: function() {
                        return attributs.source.nom+"/"+this.nom;
                   },
                   active:function() {
                      $mxdesktop.unSelectAllCategorie()
                      $("ul.catprogress li").removeClass("active")
                      $("ul.catprogress li[appid="+this.id+"]").addClass("active");
                      $("#li"+$mxdesktop.inprogressCategorie).addClass("active");
                      $("li.search").show();
                   }
                 }
           return app;
    },

    modeNormal:function() {
        $i=$(".navbar-left .toolbar i")
        $i.removeClass().addClass("fa")
        $(".navbar-left").removeClass("reduit").addClass("normal")  
        $i.addClass("fa-arrow-circle-left")
    },

    modeReduit:function() {
        $i=$(".navbar-left .toolbar i")
        $i.removeClass().addClass("fa")
        $(".navbar-left").addClass("reduit").removeClass("normal")   
        $i.addClass("fa-arrow-circle-right")
    },

    Initialisation:function() {
        $mxdesktop.log("Chargement...")
        $mxdesktop.title=$(".navbar-brand").html()

        $(".navbar-left .toolbar i").click(function() {

            if ($(".navbar-left").hasClass("reduit")) 
            {
               $mxdesktop.modeNormal()        
            } else
            {
               $mxdesktop.modeReduit()
            }   
        });

        $mxdesktop.listeDesApplications={}
        $mxdesktop.listeDesCategories={}
        $mxdesktop.listeDesSources={}
        $mxdesktop.listeDesOthersSources={}
        $mxdesktop.listeDesUrl={}
        $mxdesktop.tableauDesReog=[]
        $mxdesktop.nomDesApplications={}
        
        $mxdesktop.listeDesCategories[$mxdesktop.allCategorie]={name:"Mes Applications",
                                                                color:"#AAA",
                                                                icone:'fa-home',
                                                                apps:[] }
        $mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie]={name:"Mes Favoris",
                                                                color:"#7c7c7c",
                                                                icone:'fa-star',
                                                                apps:[] }

       
        // Création catégories par défaut
        // fav
        catFav=$mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie]
        $fav=AddCategorie(catFav.name,catFav.icone,$mxdesktop.favorisCategorie);
        $fav.find("i").css("color",catFav.color)

        // All
        catAll=$mxdesktop.listeDesCategories[$mxdesktop.allCategorie]
        $all=AddCategorie(catAll.name,catAll.icone,$mxdesktop.allCategorie);
        $all.find("i").css("color",catAll.color)
        $all.droppable({
          accept: "li[favoris='true']",
          activeClass: "ui-state-hover",
          hoverClass: "ui-state-active",
          drop: function( event, ui ) {
                appid=ui.draggable.attr("appid")
                $mxactions.toggleFavoris(appid,function() {$mxdesktop.openCategorie(currentCategorie)})
          }
        })

        // Notif
        AddCategorie("Notifications","bell",$mxdesktop.notificationsCategorie);
        progress=AddCategorie("En cours","play-circle",$mxdesktop.inprogressCategorie);
        progress.append("<ul class='catprogress'>")

        $fav.droppable({
          accept: "li[favoris='false']",
          activeClass: "ui-state-hover",
          hoverClass: "ui-state-active",
          drop: function( event, ui ) {
                appid=ui.draggable.attr("appid")
                $mxactions.toggleFavoris(appid,function() {$mxdesktop.openCategorie(currentCategorie)})
          }
        })

        // Une zone de recherche
        a=$('<a href="#" class="categorie" catname="'+$mxdesktop.searchCategorie+'">'+$mxdesktop.searchCategorie+'</a>')
        cattop=$("<div>").addClass("topcategorie").css("background-color",'rgba(0,0,0,0)')
        a.html('<span class="glyphicon glyphicon-'+'search'+'"></span>'+'<input type="search" id="searchapps">');
        li=$("<li>").append(cattop).append(a)
        li.addClass($mxdesktop.searchCategorie)
        $(".navbar-left ul.nav").append(li)
        $("#searchapps").bind('keyup',$mxdesktop.performSearch)

        // Soyons à l'écoute des InfosPlus (récupération des badges)

        // Listener sur l'ajout d'un badge
        document.addEventListener("addinfosplusEvent", function(event) {$mxdesktop.OnAddInfoPlus(event)}, false);

        // Listener sur le chargement d'un badge
        document.addEventListener("startinfosplusEvent", function(event) {$mxdesktop.OnStartInfoPlus(event)}, false);

        // Listener sur la fin de chargement d'un badge
        document.addEventListener("stopinfosplusEvent", function(event) {$mxdesktop.OnStopInfoPlus(event)}, false);

        // Listener sur le changement de mode d'affichage (provenant du parent)
        document.addEventListener("modereduit", function(event) {$mxdesktop.modeReduit()}, false);
        document.addEventListener("modenormal", function(event) {$mxdesktop.modeNormal()}, false);

        window.modeReduit=$mxdesktop.modeReduit;
        window.modeNormal=$mxdesktop.modeNormal;

        timerOfverificationDesSourcesChargees=setTimeout($mxdesktop.verificationDesSourcesChargees,$mxdesktop.sourcesWaitTimeLoading*1000);
  
        setInterval(function()
        {
            $("ul.catprogress li").each(function() {
                appid=$(this).attr("appid")
                app=$mxdesktop.listeDesApplications[appid]
                if (app.wnd!=undefined && app.wnd.closed) $mxdesktop.closeApp(appid);
            })
        },1000);
  
        // On va lancer la récupération des items de bureau
        // Le menu sera construit après parsing du (ou des) xml reçu
        $mxactions.recupererLesItemDeBureau();
    },

    hasMultipleSource:function() {
        return Object.keys($mxdesktop.listeDesSources).length>2
    },

    verificationDesSourcesChargees: function() {
      
        if ($mxdesktop.sourcesEnCoursDeChargement.length!=0)
        {
            for (sid in $mxdesktop.sourcesEnCoursDeChargement) 
            {
                source=$mxdesktop.sourcesEnCoursDeChargement[sid]
                // SI il y a un fallback, on va le lancer
                if (source.fallback!=undefined) 
                {
                    $mxdesktop.config.desktopitems=[fallback]
                    timerOfverificationDesSourcesChargees=setTimeout($mxdesktop.verificationDesSourcesChargees,$mxdesktop.sourcesWaitTimeLoading*1000);
                    $mxactions.recupererLesItemDeBureau();
                    return;
                }
                source.$source=$("<div class=sourcedesc>")
                source.$source.append($("<i class='fa fa-warning'></i>").css("color","red"))
                source.$source.append(source.nom)
                source.message=$mxdesktop.unableToLoadSourceMsg
                $mxdesktop.addPostitMessageForSource(source);
            }
            //$mxdesktop.listeDesOthersSources={}
        }  

    },

    reorganisationApp: function(newapp,app,affectation)
    {

       // Changement de categorie  
       if (newapp.categorie != undefined && newapp.categorie!="") 
       {
            
            newCategorie=$mxdesktop.listeDesCategories[newapp.categorie]    
            if (newCategorie != undefined && app.categorie!=newapp.categorie )
            {
                if (affectation) {
                    // Suppression de l'ancienne categorie
                    $mxdesktop.listeDesCategories[app.categorie].apps = jQuery.grep($mxdesktop.listeDesCategories[app.categorie].apps , 
                                                                    function (value) {return value.id != app.id;});
                    $mxdesktop.listeDesCategories[app.categorie].apps.push(app)
                }
                app.categorie=newapp.categorie
                
            } 
        }
        if (newapp.icon!=undefined && newapp.icon!= ""  ) app.icon=newapp.icon
        if (newapp.nom!=undefined  && newapp.nom!= "" ) app.nom=newapp.nom
        if (newapp.url!=undefined  && newapp.url!= "" ) app.url=newapp.url
        if (newapp.libelle!=undefined  && newapp.libelle!= "" ) app.libelle=newapp.libelle
        if (newapp.libellecours!=undefined  && newapp.libellecours!= "" ) app.libellecours=newapp.libellecours 
        if (newapp.hidden!=undefined  && newapp.hidden!= "" ) app.hidden=newapp.hidden
        if (newapp.infos.url!=undefined  && newapp.infos.url!= "" ) app.infos.url=newapp.infos.url
        if (newapp.external!=undefined  && newapp.external!= "" ) app.external=$.parseJSON(newapp.external);
        
    },


    addPostitMessageForSource: function(source) {
        if (source.message==undefined || source.message=="") return

        $div=$("<div class='message'>")
        $div.append(source.$source);
        $div.append(source.message)
        $("#postit").append($div)

        $("#postit .message p").each(function() { if ($(this).text()=="") $(this).remove();})

    },

    /* construit les categories depuis xml_string
     */
    GetCategories: function(xmlDoc,source) {
        //var xmlDoc = $.parseXML( xml_string )
        var $xml = $( xmlDoc )
        src=source.id /*|| source.nom*/ || $.md5(xmlDoc);
        if ($mxdesktop.listeDesSources[source.id]!=undefined)
        {
            return;
        }

        // Il s'agit d'une url externe, on récupère quelques paramètres
        if ($mxdesktop.listeDesOthersSources[source.id] != undefined )
        {
            other=$mxdesktop.listeDesOthersSources[source.id];
            source.icone=other.icone
            source.nom=other.nom      
            source.couleur=other.couleur    
            source.message_url=other.message_url
            source.services_url=other.services_url 
            source.userinfos=other.userinfos || source.userinfos 
            delete $mxdesktop.listeDesOthersSources[source.id]
        }

        // Ajout de la source
        delete $mxdesktop.sourcesEnCoursDeChargement[source.id];
        $mxdesktop.listeDesSources[source.id]=source;
        source.visible=true;

        if (source.referer!=undefined)
        {
            a=source.referer.split("/");   
            source.baseurl=a[0]+"//"+a[2];
        }

         // Si c'est l'administrateur du post-it on propose le lien
        if (source.userinfos.groupes && ( $mxdesktop.envole.uid=="admin" || source.userinfos.groupes.split("|").indexOf("admin_postit")!=-1))
        {
            source.message=source.message+"<br><div class='pull-right'><a target='_blank' href='"+source.baseurl+$mxdesktop.envolePath+"/includes/plugins/plugin_xdesktop/postit_liste.php?mxdesktop'"+"><i class='fa fa-pencil-square-o'></i>&nbsp;Gérer les messages</a></div>";
        }
    
        // Récupération des infos sur la source
        if ($xml.find("description").length!=0)
        {
            $el=$($xml.find("description")[0]);
            if ($el.find("icon").length!=0)         {srcicone = $xml.find("icon")[0].textContent;source.icone=srcicone}
            if ($el.find("nom").length!=0)          {srcnom = $xml.find("nom")[0].textContent;source.nom=srcnom}
            // Récupération de l'url de services 
            if ($el.find("services_url").length!=0) 
            {
                surl = $xml.find("services_url")[0].textContent;
                source.services_url=decodeURIComponent(surl)
            }
            
            if ($el.find("federationBefore").length!=0)   
            {
                lienDeFederation=$xml.find("federationBefore")[0].textContent
                $frame=$('<iframe width=0 height=0 style="display:none;">');
                $("body").append($frame)
                $frame.attr("src",lienDeFederation)
            }
        }

        // Nouvelles Url a charger 
        $xml.find("others").each(function(){
            srcnom=xmlText(this,'nom');
            ressource=decodeURIComponent(xmlText(this,'ressource')); 
            federation=decodeURIComponent(xmlText(this,'federationBefore')); 
            icone=xmlText(this,'icone');
            couleur=xmlText(this,'couleur');
            message_url=xmlText(this,'message_url');
            services_url=decodeURIComponent(xmlText(this,'services_url'));
            othersource={url:ressource,nom:srcnom,
                        callback:"controllers/callback.php",encode:true,icone:icone,couleur:couleur,
                        message_url:message_url,services_url:services_url,id:RANDOM()}
            
            $mxdesktop.listeDesOthersSources[othersource.id]=othersource;
            // Si url de fédération, on fédère d'abord via une iframe
            // et sur un onLoad on ajoute la source
            if (federation != undefined && federation != "" )
            {
                 $frame=$('<iframe width=0 height=0 style="display:none;">');
                 $("body").append($frame)
                 $frame.attr("src",federation)
                 $frame.load(othersource,function(event) {
                    $mxdesktop.config.desktopitems.push(event.data); // event.data correspond a l'objet othersource passé en paramètre
                    if ($mxdesktop.config.desktopitems.length==1) {$mxactions.recupererLesItemDeBureau();}
                 })

            } else
            {
                $mxdesktop.config.desktopitems.push(othersource);
            }
        })


        // Récupération des paramètres des catégories si pas de categories par defaut
        if ($mxdesktop.defaultCategorie == undefined) 
        {
            $xml.find("categorie").each(function(){
            nom=xmlText(this,'nom');
            couleur=xmlText(this,'couleur') || $mxdesktop.defaultCategorieColor;
            indice=xmlText(this,'indice') || "999";
            if (indice.length == 1)   indice="00"+indice
            if (indice.length == 2)   indice="0"+indice
            icone=xmlText(this,'icone') || $mxdesktop.defaultCategorieIcon
            var key=nom.normalize()
            if ($mxdesktop.listeDesCategories[key] == undefined )
            {
                $mxdesktop.listeDesCategories[key]={name:nom,
                                                    color:couleur,
                                                    icone:icone,
                                                    indice:indice,
                                                    apps:[]}
            }
            })
        }
        if ($xml.find("defaultCategorie").length!=0)   {$mxdesktop.defaultCategorie = $xml.find("defaultCategorie")[0].textContent;}

        // Réorganisation des app 
        $xml.find("reorg").each(function(){
            xmlapp=$(this).find("app");
            condition=xmlText(this,'condition');
            reorg={condition:condition,app:extractAppFromXml(xmlapp)}
            $mxdesktop.tableauDesReog.push(reorg)
            bFind=false
            for (key in $mxdesktop.listeDesApplications)
            {
                    app=$mxdesktop.listeDesApplications[key]
                    if (eval(reorg.condition)){bFind=true;break}
            }
            if (bFind) {
                $mxdesktop.reorganisationApp(reorg.app,app,true)   
            }
        })


        // Parse du xml
        $xml.find("buttondata").each(function(){

            // Création d'une appli
            jsonapp=extractAppFromXml(this);
            jsonapp.source=source;
            app=$mxdesktop.createApp(jsonapp);
	    if (app==null) return;

            // Vérifie s'il faut réorganiser
            for (i=0;i<$mxdesktop.tableauDesReog.length;i++)    
            {
                reorg=$mxdesktop.tableauDesReog[i];
                try {if (eval(reorg.condition))  {$mxdesktop.reorganisationApp(reorg.app,app,false) ; break;}} catch(e){}
            }

            // L'appli est marqué comme chaché, on passe à la suivante
            if (app.hidden!=undefined) return;


            // Ajoute l'url une seule fois
            if ($mxdesktop.listeDesUrl[app.url] == undefined )
            {
                $mxdesktop.listeDesUrl[app.url]=app

                if ($mxdesktop.nomDesApplications[app.key()] == undefined)
                {
                    $mxdesktop.nomDesApplications[app.key()]=[]
                }
                $mxdesktop.nomDesApplications[app.key()].push(app);

                // Si il y a pas de categorie, on tente de le récupérer dans le nom
                if (app.categorie=="" && nom.indexOf("/")!=-1)
                {
                    a=app.nom.split("/")
                    app.categorie=a[0];
                    if (a.length>1) app.nom=a[1];
                }

                // Ajout à la liste des categories
                $mxdesktop.listeDesCategories[$mxdesktop.allCategorie].apps.push(app);

                if ($mxdesktop.listeDesCategories[app.categorie] == undefined || app.categorie=="")
                {
                    app.categorie=app.categorie || "Aucune catégorie"

                   // Si il y a une categorie par défaut, eu lieu d'en créer une on va l'utiliser, évite d'avoir 36000 catégories
                   if ($mxdesktop.defaultCategorie != undefined && $mxdesktop.listeDesCategories[$mxdesktop.defaultCategorie] != undefined ) app.categorie=$mxdesktop.defaultCategorie
                   else {
                       $mxdesktop.listeDesCategories[app.categorie]={name:app.categorie,
                                                                     color:$mxdesktop.defaultCategorieColor,
                                                                     icone:$mxdesktop.defaultCategorieIcon,
                                                                     indice:"999",
                                                                     apps:[]}
                   }
                }
                $mxdesktop.listeDesCategories[app.categorie].apps.push(app);

                // Ajout à la liste des applications
                $mxdesktop.listeDesApplications[app.id]=app;
            }
        })


        // Traitement des favaris fournis par la source ======================
        if (source.favoris!=undefined && source.favoris!="") 
        {
            data=JSON.parse(source.favoris)
            for (i=0;i<data.length;i++)
            {
                item=data[i]
                app=$mxdesktop.findAppByUrl(item.url)
                if (app==null)
                {
                    app=$mxdesktop.createApp({
                          libelle:item.libelle,icon:item.icon,url:decodeURIComponent(item.url),nom:item.libelle,
                          categorie:$mxdesktop.favorisCategorie,source:source})
                    $mxdesktop.listeDesCategories[app.categorie].apps.push(app);  
                    // Indique si l'appli a été défini par l'utlisateur (ie ne correspond pas à une url chargée par le bureau)
                    if (app) app.userdefined=true 
                } else
                {
                    $mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].apps.push(app); 
                }

		// Si app existe , on la met dans les favoris
		if (app) {
                    // Ajout à la liste des applications
                    $mxdesktop.listeDesApplications[app.id]=app;
                    app.favoris=true
		}
            } 
        } 
        // ==== Fin de traitement des favoris ===============================        


        if (source.message_url!=undefined)
        {
            url=source.baseurl+source.message_url
            $.ajax({
                url: url,
                dataType: "json"
            }).success(function(data) {
                source.message=data.message;
            })
        }

	// Si il y a un referer (ie il y a callback, le message est en html, sinon est en text)
        message=xmlText(this,'message') ||  (source.referer?xmlHtml($xml,'message'):xmlText($xml,'message')) ;
        if (message!="" && message != undefined)
        {
            source.message=$.trim(message)
        }

        if (source.message==$mxdesktop.unableToLoadSourceMsg ) source.message=""

        // Réinit du timer permettant de vérifier les sources
        if (timerOfverificationDesSourcesChargees!=undefined) clearTimeout(timerOfverificationDesSourcesChargees)
        timerOfverificationDesSourcesChargees=setTimeout($mxdesktop.verificationDesSourcesChargees,$mxdesktop.sourcesWaitTimeLoading*1000);

        // Sera utile pour créer les badges, qui se base sur $envole.xdesktop
        $envole.xdesktop.listeDesApplications=$mxdesktop.listeDesApplications;

        // Réactualise la categorie
        if ( ! $(".appContainer").is(":visible") ){
            $mxdesktop.openCategorie(currentCategorie)
        }

        return $mxdesktop.listeDesCategories;
    },

    // Création du menu qui s'affiche a gauche
    createMenu:function() {

            
 
            $("#mysidecategory li[role='categorie'][catname!='"+$mxdesktop.allCategorie+"']").remove()

            // Trie la liste des categories
            var keys = Object.keys($mxdesktop.listeDesCategories);
            keys.sort($mxdesktop.sortCategorie);

           
            // Construction de la liste des catégories
            for (z=0;z<keys.length;z++)
            {
                key=keys[z]
                categorie=$mxdesktop.listeDesCategories[key]

                // Pas d'appli, on passe à la catégorie suivante
                if (categorie.apps.length==0) continue;

                cattop=$("<div>").addClass("topcategorie")
                                 .css("background-color",categorie.color)


                a=$('<a href="#" class="categorie" catname="'+key+'">'+categorie.name+'</a>')

                // Ajout d'une icone si elle existe
                if (categorie.icone!=undefined && categorie.icone.indexOf("fa-")!=0)
                {
                    a.html('<span class="glyphicon glyphicon-'+categorie.icone+'"></span>'+categorie.name);
                    a.find("span").css("color",categorie.color)
                } else
                {
                    a.html('<i class="fa '+categorie.icone+' marker"></i>'+""+categorie.name+"");
                    $modeReduit=$('<i class="fa '+categorie.icone+' fa-inverse marker"></i>')
                    cattop.qtip({
                        content: {
                            text: categorie.name
                        },style: {
                            classes: 'qtip-tipsy'
                        },position: {
                            my: 'center left',  // Position my top left...
                            at: 'center right', // at the bottom right of...
                        }, events: {
                            show: function(event, api) {
                                if (!$(".navbar-left").hasClass("reduit")) {
                                    try { event.preventDefault(); } catch (e) {}
                                }
                            }
                       }
                    })

                    cattop.append($modeReduit)
                    a.find("i").css("color",categorie.color)
                    
                }

                
                // la categorie existe déja, on passe à la suivante
                if ($("#li"+key).length!=0) continue;

                // la categorie existe déja, on passe à la suivante
                if ($("li[catname='"+key+"']").length!=0) continue;

                li=$("<li>").append(cattop).append(a).attr("id","li"+key).attr("role","categorie").attr("catname",key);

                // Construction de la liste des applis dans la categorie
                if (key!=$mxdesktop.favorisCategorie) {
                    ul=$("<ul class='catapps' catname='"+key+"'>")
                    for (i=0;i<categorie.apps.length;i++)
                    {
                        app=categorie.apps[i]
                        icone=$("<icone class='small'>").css("background-image","url("+app.icon+")")
                                          .attr("appid",app.id)
                        libelle=$("<span class='libelle'>"+app.libelle+"</span>").append(icone)
                        cattop=$("<i class='fa'>").addClass(categorie.icone).addClass("marker").css("color",categorie.color)
                        span=$("<a href='#' appid='"+app.id+"'>")
                        tr=$("<tr>").append($("<td>").append(cattop)).append($("<td>").append(icone)).append($("<td>").append(libelle))
                        span.append($("<table>").append(tr))
                        span.click(function(){
                            appid=$(this).attr("appid")
                            app=$mxdesktop.openApp(appid);
                        })

                        liapp=$("<li>").append(span)
                        liapp.attr("appid",app.id)
                        ul.append(liapp)
                    }
                    li.append(ul);

                    ul.hide();
                }

               $(".navbar-left > ul.nav").append(li)

            } // End for

            $( "#li"+$mxdesktop.favorisCategorie ).insertBefore($("#li"+$mxdesktop.inprogressCategorie))
            $( "#li"+$mxdesktop.allCategorie ).insertAfter($("#li"+$mxdesktop.inprogressCategorie))

            // Clique sur la toolbar pour réduire l'espace catégorie
            $(".navbar-left .toolbar").click(function() {

                if (!$(".navbar-left").hasClass("small"))
                {
                    $(".navbar-left").addClass("small")
                    $(".appContainer").addClass("small")
                } else
                {
                    $(".navbar-left").removeClass("small")
                    $(".appContainer").removeClass("small")
                }
                AdjustHeight()
            })


            // Clique sur une categorie
            $("#mysidecategory li[role='categorie']").unbind("click");
            $("#mysidecategory li[role='categorie']").click(function()
            {
                categorie=$(this).attr("catname")

                if (categorie==$mxdesktop.searchCategorie) return;

                // Ouverture de la catégorie
                $mxdesktop.openCategorie(categorie)

               // $mxdesktop.modeNormal()
               // $(".appContainer").removeClass("small")

            });

            // Ouverture de la categorie allCategorie
            $mxdesktop.openCategorie($mxdesktop.allCategorie);

            // On ajuste la taille de la fenetre
            AdjustHeight();

            // Lorsque la grille des appli devient visible on enleve la class active sur les éléments encours
            $('.tab-content .container:visible').livequery(function() {
                    $("#li"+$mxdesktop.inprogressCategorie).removeClass("active")
                    $("ul.catprogress li").removeClass("active");
                    $("li.search").hide();
                    $(".navbar-brand").html($mxdesktop.title)
            });

            // Cache la categorie des apps en cours
            $("#liencours").hide();

            // Les badges
            $envole.xdesktop.createInfosPlus(1); // Dans 1 ms

            $mxdesktop.createMenuInProgress=false
    },

    isSmall:function() {
        return ($(window).width()<=768)
    },

    hideAll:function() {
        $(".panel").hide();
    },


    addReflection:function() {
        $("icone").addClass("reflectBelow")
    },

    drawCustomScrollbar: function() {

        $("#listedesicones").mCustomScrollbar("destroy");
        height=$(".container").height()
        $("#listedesicones").css("height",height-$("#listedesicones").position().top-2); 

        // Mod enom mobile on met la scrollbar custom
        if (!IsMobile())
        {
            $("#listedesicones").mCustomScrollbar({mouseWheelPixels:100,scrollInertia:50,theme:"dark-thick",
                /*callbacks: {
                    onScroll: function() {
                        $("#postit").css("top",(-$("#listedesicones .mCSB_container").position().top)+"px");
                    }}*/
            });
            $("#listedesicones").redraw();
        }
    },

    adjustToolbarVisibility:function() {
        // On va cacher les toolbars on il y a aucun item afficher
        $("#icons .toolbar").each(function() {
            cat=$(this).attr("categorie")
            b=false
            $("#icons > li[categorie='"+cat+"']").each(function() { if ($(this).is(":visible")) { b=true; return false;} })
            if (!b) {
                $(this).hide()
                $("#icons > div[categorie='"+cat+"']").hide();
            } else
            {
                $(this).show()
                $("#icons > div[categorie='"+cat+"']").show();
            }
        });

        // Idem pour les séparateurs de sources
        $("#icons .sourcesep").hide();
            $("#icons li:visible").each(function() {
                $("#icons .sourcesep."+$(this).attr("appid")).show();    
        })

    },

    performSearch:function(event) {

        $element=$(event.target)

        // La liste des icones est affichée
        if ($("#icons li").length!=0)
        {
            $("#listedesicones").mCustomScrollbar("destroy");
            $("#icons li[others='true']").addClass("large")
            filter("#icons > li",$element.val())

            // Si pas de filtre, on unlight le tout
            if ($element.val()=="")
            {
                 $("body").unhighlight()
                 $("#icons li[others='true']").removeClass("large")
                 $("#icons .sourcesep").show();
               
            }

            $("#icons .sourcesep").hide();
            $("#icons li:visible").each(function() {
                  
                app=$mxdesktop.app($(this).attr("appid"))
                if (!app.source.visible) {$(this).hide().removeClass('visible');return;}

                $("#icons .sourcesep."+$(this).attr("appid")).show();
            })
            

            if ($("#btnGroupBycategorie").hasClass("active"))
            {
                    $mxdesktop.adjustToolbarVisibility();
            }

            $mxdesktop.drawCustomScrollbar();

            // L'action précédente enlève le focus sur la zonne de recherche on la remet donc
            $element.focus();

        }
        // Sinon on recherche dans la zone de gauche
        else
        {
            $(".navbar-left ul.nav li").show();

            // Si plus aucune app en cours on cache le menu (qui vient d'être affiché avec la ligne précédente)
            if ($("ul.catprogress li").length==0)
            {
                $("#liencours").hide();
            }

            // Pas de valeur de recherche on remet tout par défaut
            if ($element.val()=="")
            {
                $mxdesktop.unSelectAllCategorie()
                $("body").unhighlight()
                return;
            }

            // Cache la categorie 'all'
            $mxdesktop.getCategorie($mxdesktop.allCategorie).parent().hide();

            // on étend toutes les categories
            $(".catapps").css({"height":"auto"});
            $(".catapps[catname!='"+$mxdesktop.allCategorie+"']").each(function(){
                catname=$(this).attr("catname")
                categorie=$mxdesktop.listeDesCategories[catname]
                //$(this).css("background-color",lighter(categorie.color))
                $(this).parent().css("background-color",lighter(categorie.color,0.5,1.9))
            })

            // on affiche les categories sauf 'all'
            $(".catapps[catname!='"+$mxdesktop.allCategorie+"']").show();

            // Appliquons le filtre
            filter(".catapps li",$element.val())

            // On va afficher uniquement les categories disposant d'au moins un lien
            $(".catapps[catname!='"+$mxdesktop.allCategorie+"']").each(function(){
                b=false
                $(this).mCustomScrollbar('destroy');
                $(this).find("li").each(function() { if ($(this).is(":visible") ) b=true;})
                if (!b) $(this).parent().hide(); else
                { $(this).parent().show();$(this).mCustomScrollbar(); }
            })
        }
    },

    // retourne l'objet app en fonction de son id
    app:function(appidOrApp) {
        // Pasage d'un id ou de l'appli elle même
        if (typeof(appidOrApp)=="string") return $mxdesktop.listeDesApplications[appidOrApp]
        else return appidOrApp
    },

    // Recherche une app par son url, retourne null si pas trouvé
    findAppByUrl:function(url) {
        if (!url) return null
        url=url.toLowerCase()
        for (key in $mxdesktop.listeDesApplications)
        {
            app=$mxdesktop.listeDesApplications[key]
            if (app.url.toLowerCase()==url || ( app.urlBase && app.urlBase.toLowerCase()==url ) )
            {
                return app
            }
        }
        return null;

    },

    //
    favorisAppToggle: function(appid) {
        $mxactions.favorisAppToggle($mxdesktop.app(appid))
    },

    // recharge d'une application
    reloadApp:function(appid) {
        $mxdesktop.closeApp(appid)
        $mxdesktop.openApp(appid)
    },

    // Permet de mettre à jour la toolbar d'une app
    updateToolbarForApp:function(appid)
    {
        app=$mxdesktop.app(appid)
        // Occupons nous de l'icone favoris
        $fav=$("#btnFavoris span")
        $fav.removeClass()
        $fav.addClass("glyphicon")
        if (app.favoris)
        {
            $fav.addClass("glyphicon-star")
            $fav.css("color","red")
        } else
        {
            $fav.addClass("glyphicon-star-empty")
            $fav.css("color","black")
        }
    },

    // fermeture d'une application
    closeApp:function(appid) {
        var app=$mxdesktop.app(appid)

        // Si la frame existe on la supprime
        if (app.iframe!=undefined)
        {
            app.iframe.remove();
            delete app.iframe
        }

        // Si la frame existe on la supprime
        if (app.wnd!=undefined)
        {
            app.wnd.close();
            delete app.wnd
        }

        // Supression de l'entrée dans les apps en cours
        li=$("ul.catprogress li[appid="+app.id+"]")
        li.remove();

        // Si plus aucune app en cours on cache le menu
        if ($("ul.catprogress li").length==0)
        {
            $("#liencours").hide();
        }

        // Affiche, toutes les apps
        $mxdesktop.openCategorie($mxdesktop.allCategorie);

    },

    displayIframeMessage: function (iframe,titre,message) {
         $message=$("<div class='container'>");
         $c=$("<div class='starter-template'>");
         $c.append("<h1>"+titre+"</h1>") 
         $c.append($("<p class='lead'>"+message+"</p>"))
         $head=iframe.contents().find('head')
         $mxdesktop.writeCss($head)
         $message.append($c);
         iframe.contents().find('body').empty();
         iframe.contents().find('body').append($message)
    },

    // Lors d'une erreur sur le chargement d'une app, on met un point d'exclamation
    errorOnLoadingApp:function(appid) {
        var app=$mxdesktop.app(appid)
        $("ul.catprogress li[appid="+appid+"] i").removeClass().addClass("pull-left")
                                                 .addClass("fa")
                                                 .addClass("fa-exclamation")
                                                 .css("color","red !important").redraw()

         // ET ouverture dans un onglet externe
         app.external=true
         message=$mxdesktop.appErrorMessage+"<br><a href='javascript:parent.$mxdesktop.openApp(\""+appid+"\")'>Ouvrir dans un nouvel onglet</a>"
         $mxdesktop.displayIframeMessage(app.iframe,"Erreur de chargement",message);
    },

    externalApp:function(appid) {
            var app=$mxdesktop.app(appid)
            $mxdesktop.closeApp(appid)
            app.toogleExternal() 
            $mxdesktop.openApp(appid);
    },

    // Ouverture d'une URL
    openApp:function(appid) {

        var app=$mxdesktop.app(appid)
        var categorie=$mxdesktop.listeDesCategories[app.categorie]  
        var darkerColor=lighter(categorie.color,1,0.5);

        $(".appContainer iframe").hide();

            url=app.url

            // App externe ou MixedContent ?
            if ( app.isExternal() || app.isMixedContent() )
            {
                
                if (app.wnd==undefined || app.wnd.closed)
                {
                    url="about:blank"
                    app.wnd=window.open(app.url, '_blank');
                    setTimeout(function() {$mxdesktop.openCategorie($mxdesktop.allCategorie)},2000)

                } else {
                    app.wnd.focus()
                }  
            }


            // Iframe inexistante, on va en créer une
            if (app.iframe==undefined )
            {
                iframe=$("<iframe>").attr("appid",app.id)
                app.iframe=iframe

                categorie=$mxdesktop.listeDesCategories[app.categorie];

                // Capture de l'évenement onload
                iframe.load(function() {
                        appid=$(this).attr("appid")
                        app=$mxdesktop.app(appid)
                        if (app.timerLoading) clearTimeout(app.timerLoading)
                        delete app.timerLoading

                        $("ul.catprogress li[appid="+appid+"] i").remove();
                        $(this).redraw();
                })

                // capture de l'évenement onerror
                iframe.error(function() {
                        appid=$(this).attr("appid")
                        $mxdesktop.errorOnLoadingApp(appid)
                })


                // Lorsqu'une iframe est visible on deselectionne les categories
                $('iframe[appid='+app.id+']:visible').livequery(function() {
                    app.active();
                })

                
                $(".appContainer").append(iframe)
                $mxdesktop.displayIframeMessage(iframe,"Ouverture de l'application",$mxdesktop.appLoadingMessage);
                
                // Demande le chargement de l'appli
                iframe.attr("src",url)
                // Timer 
                app.timerLoading = setTimeout($mxdesktop.errorOnLoadingApp, $mxdesktop.appWaitTimeLoading*1000,app.id);

                // Récupération de la categorie "InProgress pour ajouter l'appli
                $link=$mxdesktop.getCategorie($mxdesktop.inprogressCategorie)
                $element=$("ul.catapps li[appid="+app.id+"]").clone();
                $element.find(".marker").css("color",categorie.color)
                $element.find("icone").css("border-color",categorie.color)
                

                $link.parent().find("ul").append($element[0])

                $("ul.catprogress li[appid="+appid+"] i").addClass("fa-spinner")
                                                             .addClass("fa-spin")
                                                             .css("color","black")

                $element.click(function() {
                    appid=$(this).attr("appid")
                    $mxdesktop.openApp(appid)
                    $mxdesktop.unSelectAllCategorie();
                })

            }
            // sinon on l'affiche
            else
            {
                iframe=app.iframe
                iframe.show()
            }

            $("body").css("background-color","white")

            // Construction de la toolbar,
            $(".appToolbar").remove()
            $(".appContainer").prepend('<div class="appToolbar"></div>')

            $(".appContainer").css("background-color","white")
            $(".appToolbar").css("background-color",lighter(categorie.color,1,0.7))

            actions=$("<div>").addClass("actions").addClass("btn-toolbar")


            toolbar=$("<div class='btn-group'>")

            // Texte informatif
            infos=$("<div class='toolinfos'>")
            table=$("<table style='width:100%'>")
            icone=$("<icone class='small'>").css("background-image","url("+app.icon+")")
            texte=$("<span>"+app.libelle+"</span>")
            $sep=$("<div>").css({"width":"100%","height":"1px","background-color":categorie.color})
            // -> Favoris
            $fav=$("<i class='fa pull-right'>").css("cursor","pointer").attr("appid",app.id)
            if (app.favoris) 
            { 
                m="Cliquez ici pour enlever cette application de vos favoris"
                $fav.addClass("fa-star")
            }
            else 
            {
                m="Cliquez ici pour ajouter à vos favoris"
                $fav.addClass("fa-star-o")
            }
            $fav.qtip({
                       position: {my: 'top center',at: 'bottom center',},
                       content:  {text:m},
                       style:    {classes: 'qtip-tipsy qtip-shadow'}
            });

            $fav.click(function() {
                $mxactions.toggleFavoris($(this).attr("appid"))    
            });
            // <- End Favoris
            


            texte.append($fav)

            texte.append($sep)
            if ($mxdesktop.hasMultipleSource()) {
                texte.append($("<span class='source'>").append(app.source.nom).addClass("pull-left") )
            }
            texte.append($("<span>").append(categorie.name).addClass("pull-right").addClass("categorie") )

            tr=$("<tr>")
            tr.append($("<td>").append(icone).addClass("ico"))
                 .append($("<td>").append(texte).addClass("texte"))
            table.append(tr)
            infos.append(table)

           
            

            // Buttons
            // close
            var close=$('<button type="button" class="btn btn-danger btn-xs">')
            close.append($('<span class="glyphicon glyphicon-remove">'))
            

            // external
            var external=$('<button type="button" class="btn btn-info btn-xs">')
            $i=$('<i class="fa">')
            if ( app.isExternal() ) 
                $i.addClass("fa-chevron-circle-down").addClass() 
            else 
                $i.addClass("fa-external-link")

            external.append($i)
            

            // === Pour me moment pas utilisé 
            // favoris
            favoris=$('<button type="button" class="btn btn-normal btn-xs visible-lg hidden" id="btnFavoris">')
            favoris.append($('<span class="glyphicon glyphicon-star-empty">'))
            favoris.click(function() {$mxdesktop.favorisAppToggle($(this).attr("appid"))    });

            // Epingler
            epingler=$('<button  type="button" class="btn btn-normal btn-xs visible-lg hidden" id="btnEpingler">')
            epingler.append($('<span class="glyphicon glyphicon-pushpin">'))
            //========

            //
            showAll=$('<button type="button" class="btn btn-primary btn-xs visible-xs" id="btnShowAll">')
            showAll.append($('<i class="fa fa-home">'))
            

            // reload
            refresh=$('<button type="button" class="btn btn-success btn-xs">')
            refresh.append($('<span class="glyphicon glyphicon-refresh">'))

            

            // Si mode petit on va créer un menu 
            if ($mxdesktop.isSmall()) {
                $carret=$('<button type="button" href="#" class="btndropdown-toggle btn-link" data-toggle="dropdown"><i class="fa fa-ellipsis-vertical">&nbsp;</i></button>').css("width","32px");
                $ul=$('<ul class="dropdown-menu" role="menu">')
                refresh=$('<li class="btn pull-left"><a href="#">Recharger&nbsp;<i class="fa fa-refresh"></i></a></li>')
                close=$('<li class="btn pull-left"><a href="#">Quitter cette application&nbsp;<i class="fa fa-times-circle"></i></a></li>')
                showAll=$('<li class="btn pull-left"><a href="#">Accueil&nbsp;<i class="fa fa-home"></i></a></li>')
                external=$('<li class="btn pull-left"><a href="#">Ouvrir dans un nouvel onglet&nbsp;<i class="fa fa-external-link"></i></a></li>')

                $menu=$ul
                $menu.append(showAll)
                if ( ! app.isExternal() && !app.isMixedContent() ) $menu.append(refresh)
                if ( ! app.isExternal() && !app.isMixedContent() ) $menu.append(external)
                $menu.append(close)
                
                toolbar.append($carret)
                toolbar.append($ul)
            } else 
            {
                $menu=toolbar
                if ( ! app.isExternal() && !app.isMixedContent() ) $menu.append(refresh)
                $menu.append(close)
                $menu.append(showAll)
                if ( ! app.isExternal() && !app.isMixedContent() ) $menu.append(external)

                close.qtip({
                       position: {my: 'top center',at: 'bottom center',},
                       content:  {text:"Fermer l'application"},
                       style:    {classes: 'qtip-tipsy qtip-shadow'}
                });
                external.qtip({
                       position: {my: 'top center',at: 'bottom center',},
                       content:  {text:"Ouvrir dans un nouvel onglet"},
                       style:    {classes: 'qtip-tipsy qtip-shadow'}
                });
                refresh.qtip({
                       position: {my: 'top center',at: 'bottom center',},
                       content:  {text:"Rafraichir l'application"},
                       style:    {classes: 'qtip-tipsy qtip-shadow'}
                });

                
            }

            showAll.click(function() {$mxdesktop.openCategorie($mxdesktop.allCategorie)    });
            refresh.click(function() {$mxdesktop.reloadApp($(this).attr("appid"))    });
            external.click(function() {$mxdesktop.externalApp($(this).attr("appid"))});
            close.click(function() {$mxdesktop.closeApp($(this).attr("appid"))    });

            toolbar.find(".btn").attr("appid",app.id)
            actions.append(toolbar)

            $t=$("<table>").css("width","100%")
            $tr=$("<tr>")
            
            $tr.append($("<td>").append(infos))
            $tr.append($("<td>").append(actions))
            if (!$mxdesktop.isSmall()) $tr.css("width","200px")
            $t.append($tr);

            $(".appToolbar").append($t)
            $mxdesktop.updateToolbarForApp(app.id)

            iframe.css("width","100%")

           // $(".navbar-left").removeClass("active")
           // $(".navbar-left").addClass("fermer")

           // $(".starter-template p.lead").empty();
            $(".tab-content .container").animate({opacity: 0}, 300,'swing',function() {$(".tab-content .container").hide();$(".tab-content .container").css("opacity",1);$(".appContainer").fadeIn('slow');$(".starter-template p.lead").empty();})

            // Affiche la liste des appli en cours et l'appli
            setTimeout(function() {$("#liencours").show();app.active()},1,[app]);

            h=$(window).height()-$(".btn-toolbar").height();
            iframe.css("height",h+"px").css("border-color",darkerColor)

            table.find(".ico").css("width",icone.width());

            if (app.wnd!=undefined) {
            setTimeout(function() {
                if (app.isExternal()) 
                {
                    m=$mxdesktop.appExternalMessage
                    m=m+"<br><a href='javaScript:parent.$mxdesktop.externalApp(\""+app.id+"\")'>Pour l'intégrer dans cette fenêtre, veuillez cliquer sur ce lien</a><br><br><small class='text-danger'><i class='fa fa-exclamation-triangle'></i>Cette intégration peut ne pas fonctionner et fermera l'onglet actuel</small> "
                } else
                {
                    m=$mxdesktop.mixedContentMessage
                }
               
                $mxdesktop.displayIframeMessage(app.iframe,"",m);
            },1000);
            }

            setTimeout(AdjustHeight,1500);

            return app

    },

    // Ouverture des favoris
    openFavoris:function() {

        $(".starter-template p.lead").empty();
        $("#badgescontainer").empty();
        $(".starter-template h2.help").hide()

        // Affiche le container
        $(".appContainer").hide();
        $(".container").show();

        $(".starter-template p.lead").html("Pas encore implémenté");

    },

    clear:function() {
        // Un peu de netoyage
        $(".starter-template p.lead").empty();
        $("#badgescontainer").empty();
        $("#dvInfosContainer").empty();
        $("#qtip-"+$mxdesktop.notificationsQtip).qtip('destroy', true);
    },

    getCategorie:function(categorie) {
        $link=$(".navbar-left ul.nav a.categorie[catname='"+categorie+"']")
        return $link;
    },

    // enleve la selection sur les categories
    unSelectAllCategorie:function(categorie) {
        if (categorie!=$mxdesktop.searchCategorie) {
            $(".navbar-left ul li").removeClass("active");
        }

        $(".navbar-left ul.nav li").css("background-color","rgba(0,0,0,0)");
       // $("#li"+$mxdesktop.inprogressCategorie).css("background-color","white");

       // $(".catapps").css({"height":"0px"});
        $(".catapps").hide('slow');
    },

    // Ouverture d'une categorie
    openCategorie:function(categorie) {

                if (categorie==undefined) categorie=$mxdesktop.allCategorie;

                // On tente d'ouvrir l'item search, y a rien à faire
                if (categorie==$mxdesktop.searchCategorie) return

                $link=$mxdesktop.getCategorie(categorie)

                // un-select allCategories and Selection de l'item
                $mxdesktop.unSelectAllCategorie(categorie)
                $link.parent().addClass("active")

                currentCategorie=$link.attr("catname")
                if (currentCategorie==undefined) currentCategorie=$mxdesktop.allCategorie;

                // cas spécificiques  Notifications -----
                if (categorie==$mxdesktop.notificationsCategorie)
                {
                    $mxdesktop.openNotifications();
                    $(".appContainer").hide();
                    $(".tab-content .container").show();
                    return
                }

                // On change la couleur du body
                color="#FFF";                
                if ($mxdesktop.listeDesCategories[currentCategorie])
                    color=$mxdesktop.listeDesCategories[currentCategorie].color
                else {
                    console.log(currentCategorie+" categorie inconnue");
                }
                
                //$("body").css("background-color",color)
                $link.parent().css("background-color",color)

                $mxdesktop.clear()

                // Création de la liste des icones
                if ( $(".tab-content .container").is(":visible") ||
                     currentCategorie==$mxdesktop.allCategorie ||
                     currentCategorie==$mxdesktop.favorisCategorie || true /*|| (IsMobile() && $mxdesktop.isSmall())*/ )
                {

                    $(".starter-template h2.help").hide()


                    // ================== CREATION DE LA BARRE D'OUTILS ================================
                    // Gestion des options d'affichage
                    mainbar=$('<div class="mainbar">')
                    groupe=$('<div class="btn-group">')
                                        
                    // Affichage des notifications
                    showNotifications=$('<a type="button" class="btn btn-default" role="button">').attr("id","btnshowNotifications")
                    showNotifications.append($('<i class="fa fa-bell-o">&nbsp;<span class="badge"></span>')).attr("title","Voir les notifications")
                   // $mxdesktop.openNotifications
                    showNotifications.qtip({
                                id:$mxdesktop.notificationsQtip,
                                position: {
                                    my: 'top center',
                                    at: 'bottom center',
                                    target: showNotifications,  viewport: $(".starter-template"),
                                    adjust: { y:0 }
                                },
                                show: {
                                    event: 'click',
                                    effect: function() {$(this).slideDown('fast',function() 
                                    {
                                        if (IsMobile()) return
                                        $(".qtip-content .notifications-content").mCustomScrollbar("destroy")
                                        $(".qtip-content .notifications-content").mCustomScrollbar()  
                                    });},
                                },
                                hide: {
                                    event: 'unfocus',
                                    fixed:true,delay:3000,
                                    effect: function() {$(this).slideUp();}
                                },
                                prerender: true,
                                style: {
                                    classes:'qtip-bootstrap',width:'320px'
                                },
                                events: {
                                    show: function(event, api) {
                                       // if (!IsMobile()) setTimeout(function() {},1000)
                                      // $(".qtip-content .notifications-content").mCustomScrollbar()
                                    }
                                }
                                

                    })

                    setTimeout(function() {$mxdesktop.OnAddInfoPlus()},100);

                    // Afficher
                    showByCategorie=$('<a type="button" id="btnGroupBycategorie" class="btn btn-default active" role="button">')
                    showByCategorie.append($('<i class="fa fa-list-ul">')).attr("title","Grouper par catégorie")
                    showByCategorie.click(function() 
                    {
                        $("#icons").removeClass("wall")
                        $("#icons [groupby='byCategorie']").show('fast',function() {/*$mxdesktop.drawCustomScrollbar();*/})
                    })

                    showAll=$('<a type="button" class="btn btn-default" role="button">')
                    showAll.append($('<i class="fa fa-th">')).attr("title","")
                    showAll.click(function() 
                    {
                        $("#icons").addClass("wall")
                        $("#icons [groupby='byCategorie']").hide('fast');
                    })

                    // Groupe de recheche
                    searchGroup=$('<div class="input-group"><span class="glyphicon glyphicon-search input-group-addon form-control"></span></div>')
                    searchInput=$('<input type="search" class="form-control" placeholder="rechercher une application">')
                    searchInput.bind('keyup',$mxdesktop.performSearch) // Sur keyup on lance la recherche
                    searchGroup.append(searchInput)
                    searchGroup.find(".glyphicon").css("top","0px").css("width","20px").css("height","34px")

                    mainbar.append(searchGroup);
                    
                    mainbar.append(showNotifications)
                    mainbar.append("&nbsp;")
                    //if ( currentCategorie==$mxdesktop.allCategorie ) mainbar.append(showFavoris);

                    

                    showPostit=$('<a type="button" class="btn btn-default" role="button">').attr("id","btnshowPostit").hide();
                    showPostit.append($('<i class="fa fa-thumb-tack">')).attr("title","Afficher les messages")
                    showPostit.click(function() {
                        if ($(".tdpostit").is(":visible")) {
                            $(".tdpostit").hide();
                            $("td.icons").show();  
                            $(this).removeClass("active")  
                        } else
                        {
                            $(".tdpostit").show();
                            $("td.icons").hide(); 
                            $(this).addClass("active") 
                        }
                    });

                    mainbar.append("&nbsp;")
                    mainbar.append(showPostit)

                    // Liste des apps en cours
                    if ($("ul.catprogress > li").length >0) {
                        showInProgress=$('<a type="button" class="btn btn-default visible-xs-inline" role="button">').attr("id","btnshowInProgress")
                        showInProgress.append($('<i class="fa fa-play-circle-o">'))
                        mainbar.append("&nbsp;")
                        mainbar.append(showInProgress)
                        showInProgress.qtip({
                                content: {
                                    text: $("ul.catprogress").clone()
                                },
                                position: {
                                    my: 'top center',
                                    at: 'bottom center',
                                    target: showInProgress,  viewport: $(".starter-template"),
                                    adjust: { y:0 }
                                },
                                show: {
                                    event: 'click',
                                    effect: function() {$(this).slideDown();},
                                },
                                hide: {
                                    /*event: 'click',*/
                                    fixed:true,delay:3000,
                                    effect: function() {$(this).slideUp();}/*,event: 'click'*/
                                },
                                style: {
                                    classes:'qtip-bootstrap',width:'200px'
                                },
                                events: {
                                    show: function(event, api) {
                                        $(this).find("li").click(function(){$mxdesktop.openApp($(this).attr("appid"))})
                                    }
                                }
                      })
                                
                    }


                    mainbar.append("&nbsp;")

                    groupe.append(showByCategorie);
                    groupe.append(showAll);
                    groupe.find("a").click(function(){$(this).parent().find("a").removeClass("active");$(this).addClass("active")})

                    mainbar.append(groupe)
                
                    // Liste des sources disponibles
                    if (Object.keys($mxdesktop.listeDesSources).length>1) {
                        $btnSource=$('<div class="btn-group">')
                        $btnSource.append('<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">Mes Etablissements <span class="caret"></span></button>'); 
                        $sources=$('<ul class="dropdown-menu sources  pull-right" role="menu">')
                        for (src in $mxdesktop.listeDesSources)
                        {
                            source=$mxdesktop.listeDesSources[src]
                            $source=$("<span>")
                            if (source.icone!=undefined)  {
                               $source.css("background-image","url('"+source.icone+"')").css("background-size","cover").css({display:"inline-block",width:"20px",height:"20px"})
                            }
                            if (source.couleur!=undefined) 
                            { 
                                sico=$("<i>").addClass("fa").addClass("fa-bookmark").css("color",source.couleur);
                                $source.append(sico);
                            }

                            $check=$('<span class="glyphicon glyphicon-ok mark"></span>');
                            if (source.visible) {$check.css("color","green")} else { $check.css("color","#AAA") }
                            arr=source.nom.split(' ');
                            nom=source.nom
                            if (arr.length > 2 && nom.length > 40 ) {nom=arr[arr.length-2]+" "+arr[arr.length-1]}
                            source.nomcours=nom

                            $nom=$("<span class='nom'>").append(nom)

                            source.$source=$("<div class='sourcedesc'>").append($source.clone()).append($nom.clone()) // Pour le postit
                            $a=$("<a>").attr("href","#").append($source).append($nom).append($check);
                            $lisrc=$('<li>').append($a).attr("sourceid",src)
                            // Clique sur la visibilité d'une source
                            $lisrc.click(function(e) {
                                
                               // $(".mainbar input[type='search']").val("");
                                

                                src=$(this).attr("sourceid");
                                source=$mxdesktop.listeDesSources[src]
                                $check=$(this).find("span.glyphicon");
                                source.visible=!source.visible;
                                $select=$("#icons li[sourceid='"+source.id+"']");
                                if (source.visible) 
                                {$check.css("color","green");$select.show()} 
                                else 
                                { $check.css("color","#AAA");$select.hide() } 

                                // Ajustons la recherche
                                $(".mainbar input[type='search']").trigger('keyup');

                                $mxdesktop.adjustToolbarVisibility(); 
                                
                                e.stopPropagation();          
                            });
                            $sources.append($lisrc) 
                        }
                        $btn=$('<button type="button" class="btn btn-link pull-right">Fermer</button>');
                        $btn.css("margin-right","10px");
                        $lisrc=$('<li>').append($btn).attr("sourceid",src)
                        $sources.append($lisrc) 
            
                        $btnSource.append($sources);
                        mainbar.append("&nbsp;")
                        mainbar.append($btnSource)
                    }
                    

                   
                    $(".starter-template p.lead").append( $("<div>").append(mainbar))
                    // ================== FIN DE CREATION DE LA BARRE D'OUTILS ================================

                    listedesicones=$("<div>").attr("id","listedesicones").css("overflow-y", "auto")
                    listedesicones.append("<table><tr><td class='icons'><ul id='icons'></ul></td><td class='tdpostit'><div id='postit' class='note simple-sticker' style='display:none;'></div></td></tr></table>");
                    ul=$(".starter-template p.lead").append(listedesicones)
                    $mxdesktop.listeDesCategories[currentCategorie].apps.sort($mxdesktop.SortAppByCategorie)

                    arr=[]
                    arr=arr.concat($mxdesktop.listeDesCategories[currentCategorie].apps)

                    // Si 'toutes' les appli sont affichées on ajoute tout d'abord les favoris
                    if (currentCategorie==$mxdesktop.allCategorie)
                    {
                        $mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].apps.sort($mxdesktop.SortAppWithoutCategorie)
                        // On parcours de la fin au debut
                        for (i=$mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].apps.length-1;i>=0;i--)
                        {
                            a=$mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].apps[i]
                            arr.unshift(a)
                        }
                    }

                    if (currentCategorie==$mxdesktop.favorisCategorie) {
                        arr.sort($mxdesktop.SortAppWithoutCategorie)                  
                    }

                    appIdentiques={}


                    // Liste des favoris
                    if (currentCategorie==$mxdesktop.allCategorie  )
                    {
                            // Toolbar favoris
                            favoris=$mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie]
                            toolbar=$("<div class='toolbar'>").attr("role","favoris").attr("groupby","byCategorie")
                            toolbar.append('<i class="fa '+favoris.icone+'"></i> ')
                            toolbar.append(favoris.name)
                            deleteZone=$("<button type='button'>").addClass("btn").addClass("btn-danger").css("float","right")
                            deleteZone.append('<span class="glyphicon glyphicon-trash"></span> Déposer ici pour supprimer').css("opacity","0")

                            $( "#icons" ).prepend(toolbar)
                            dropzone=$("<div>")
                                               .css("height","auto")
                                               .css("display","inline-block").attr("role","favoris")
                            dropzone.droppable({
                              accept: "#icons li[favoris!='true']",
                              activeClass: "favoris-state-active",
                              hoverClass: "favoris-state-hover",
                              drop: function( event, ui ) {
                                $mxactions.addToFavoris(ui.draggable.attr("appid"),
                                                        function() {$mxdesktop.openCategorie($mxdesktop.allCategorie);}
                                                       )
                             }
                            });

                            $( "#icons" ).append(dropzone)

                            separateur=$("<div>").css("width","100%").css("height","1px").css("display","inline-block").attr("groupby","byCategorie")
                            //$( "#icons" ).append(separateur)
                            if ($mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].apps.length == 0 )
                            {
                                span="<span>Vous ne disposez pas encore de favoris, pour en ajouter veuillez ouvrir une application et cliquer sur <i class='fa fa-star-o'></i> dans la barre de titre</span>"
                                if (!$(".navbar-left").is(":visible") || !$(".navbar-left").hasClass("reduit")) {
                                    span="<span>Vous ne disposez pas encore de favoris, pour en ajouter veuillez glisser-déposer l'icone de l'application sur le menu ' <i class='fa fa-star'></i> "+$mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].name+" ' situé à gauche</span>"        
                                }

                                $noFav=$(span).css("width","100%").css("height","1px").css("display","inline-block").attr("groupby","byCategorie").attr("role","favoris").addClass("help")
                                $noFav.find("i").css("color",$mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].color)
                                $( "#icons" ).append($noFav)

                            }

                            $( "#icons li").appendTo(dropzone)

                    }

                    lastIsFav=false
                    lastCategorie=""
                    lastSource=""
                    var $sourcesep=undefined
                    for (i=0;i<arr.length;i++)
                    {
                        app=arr[i]

                        if (appIdentiques[app.key()]!=undefined) continue;

                        // Une appli ne peut être affiché qu'une seule fois !!!
                        if ($("#icons li[appid='"+app.id+"']").length!=0) continue;

                        // Si l'app précédente est favoris et l'actuelle non
                        // on va créer des toolbars de séparation
                        // fixes: #8588 : Si affichage de tous, uniquement (currentCategorie==$mxdesktop.allCategorie)
                        if (lastIsFav && !app.favoris && currentCategorie==$mxdesktop.allCategorie) {
                            lastCategorie=""
                        }

                        // Toolbar permettant de séparer les catégories, l'attribut grouby='byCategorie' va nous servir de filtre
                        //fixes: #8588, Si premier élément en mode 'catégorie' -> Affiche toolbar
                        //              Si mode 'Mes favoris' -> Pas de toolbar
                        if (lastCategorie!=app.categorie && 
                            (!app.favoris || (i==0 && currentCategorie!=$mxdesktop.allCategorie) ) && 
                            (currentCategorie!=$mxdesktop.favorisCategorie))
                        {
                            separateur=$("<div>").css("width","101%").css("height","1px").css("display","inline-block").attr("groupby","byCategorie").attr('categorie',app.categorie)
                            $( "#icons" ).append(separateur)

                            c=$mxdesktop.listeDesCategories[app.categorie]
                            toolbar=$("<div class='toolbar'>").attr("groupby","byCategorie").attr('categorie',app.categorie).css("border-bottom-color",c.color)
                            stack=$('<span class="fa-stack fa-lg">').css("color",c.color)
                            stack.append('<i class="fa fa-circle fa-stack-2x"></i>')
                            stack.append('<i class="fa '+c.icone+' fa-stack-1x fa-inverse"></i>')
                            toolbar.append(stack)
                            toolbar.append(c.name)

                            $( "#icons" ).append(toolbar)
                            lastSource=""
                        }

                        if ($mxdesktop.hasMultipleSource() && app.source!=lastSource) {
                            if (lastSource!="") {
                                separateur=$("<div class='sourcesep'>").css("width","101%").css("height","1px").css("display","inline-block").attr("groupby","byCategorie")
                                $( "#icons" ).append(separateur)
                            }

                            $sourcesep=$("<div class='sourcesep'>").attr("groupby","byCategorie")  
                            $sourcesep.append(app.source.nomcours) 
                            $( "#icons" ).append($sourcesep)  
                            
                            lastSource=app.source
                        }

                        lastIsFav=app.favoris
                        lastCategorie=app.categorie

                        // Construction du petit insigne permettant de différencoer les sources
                        if (Object.keys($mxdesktop.listeDesSources).length>1) {
                            source=$("<div class='source'>"+"</div>").attr("title",app.source.nom);
                            if (app.source.icone!=undefined)    source.css("background-image","url('"+app.source.icone+"')")
                            if (app.source.couleur!=undefined && Object.keys($mxdesktop.listeDesSources).length>2) 
                            { 
                                //source.css("background-color",app.source.couleur)
                                sico=$("<i>").addClass("fa").addClass("fa-bookmark").css("color",app.source.couleur);
                                source.append(sico);
                            }
                            source.qtip({
                                    content: {
                                        text:app.source.nom
                                    },style: {
                                        classes: 'qtip-tipsy qtip-shadow'
                                    }
                            });
                        }

                        // Création de l'icone
                        icone=$("<icone>").css("background-image","url("+app.icon+")")
                                          .attr("appid",app.id)
                                          .attr("id","icon_"+app.id);

                        // ajoute la zone qui contiendra les badges
                        icone.append(source).append($("<badges>"))

                        // Couleur de bordure permettant de différencier les catégories d'icones
                        icone.css("border-color",$mxdesktop.listeDesCategories[app.categorie].color)
                        $plus=$('<span class="others fa-stack fa-lg"><i class="fa fa-plus-circle fa-stack-2x"></i></span>')

                        text=$("<texte>"+app.libellecours+"</texte>")
                        table=$("<table>")
                        tr1=$("<tr>");td=$("<td>").append(icone).addClass("tdicone") ;tr1.append(td)
                        tr2=$("<tr>");td=$("<td>").append(text).addClass("tdtexte")  ;tr2.append(td)
                        tr3=$("<tr>");td=$("<td>").append($plus);tr3.append(td)
                        table.append(tr1).append(tr3).append(tr2)

                        div=$("<div class='divicone'>").append(table)
                        li=$("<li>").append(div).attr("appid",app.id).attr("favoris",app.favoris).attr('categorie',app.categorie).attr('sourceid',app.source.id)
                        if (app.favoris) li.attr("role","favoris")
                        // Ajout à la liste des icones
                        $( "#icons" ).append(li)

                        // Ceci permettra de supprimer les separateur de source lors de la recherche
                        if ($sourcesep!=undefined) { 
                            $sourcesep.addClass(app.id);
                            prev=$sourcesep.prev()
                            if (prev.hasClass("sourcesep")) prev.addClass(app.id);

                        }

                        // Traitement des appli avec la même catégorie et le même nom
                        // Création d'un petit plus a gauche pour indiquer qu'il y a d'autre lien dans l'icone
                        if ($mxdesktop.nomDesApplications[app.key()]!=undefined && $mxdesktop.nomDesApplications[app.key()].length > 1 )
                        {
                            divapps=$("<div>").addClass("apps").attr("appid",app.id)
                            divapps.append("<span>"+app.nom+"</span>")
                            listeDesAppIdentiques=$("<ul>")
                            for (var z=0;z<$mxdesktop.nomDesApplications[app.key()].length;z++)
                            {
                               a=$mxdesktop.nomDesApplications[app.key()][z]
                               l=$("<li>"+a.libelle+"</li>").attr("appid",a.id)
                               listeDesAppIdentiques.append(l)
                            }
                            divapps.append(listeDesAppIdentiques)
                            icone.append(divapps)
                            li.attr("others","true")
                            self=li
                            self.qtip({
                                content: {
                                    text:divapps
                                },
                                position: {
                                    my: 'top center',
                                    at: 'bottom center',
                                    target: self.find("span.others"),  viewport: $(".starter-template"),
                                    adjust: { y:0 }
                                },
                                show: {
                                    event: 'click',
                                    effect: function() {$(this).slideDown();}
                                },
                                hide: {
                                    fixed:true,delay:300,
                                    effect: function() {$(this).slideUp();}
                                   /* event: 'click'*/
                                },
                                style: {
                                    classes:'qtip-bootstrap'
                                },
                                events: {
                                    show: function(event, api) {
                                        appid=$(this).find(".apps").attr("appid")
                                        $("#icons li[appid!='"+appid+"']").animate({opacity: "0.2"}, 500)
                                    },
                                    hide: function(event, api) {
                                        self.redraw();
                                        appid=$(this).find(".apps").attr("appid")
                                        $("#icons li[appid!='"+appid+"']").animate({opacity: "1"}, 500)
                                    }
                                }
                            })
                            text.html(app.nom)
                        }

                        appIdentiques[app.key()]=true


                    } // End each app

                    $( "#icons" ).append("<br><br><br>");

                    $("#icons > li[favoris!='true']").draggable(
                        {helper: 'clone', appendTo: '.container',
                        scroll: false}
                    );
                    $("#icons > li[favoris='true']").draggable(
                        {helper: 'clone', appendTo: '.container',
                        scroll: false}
                    );
                   

                    // Un peu de reflection
                    $mxdesktop.addReflection();

                    // Clique sur Icone
                    $("#icons li").click(function() {
                        if ($(this).attr("others")=="true")
                        {
                            /*if ( $(this).hasClass("large") ) {
                                $(this).removeClass("large")
                           } else {
                                $(this).addClass("large")
                            }*/
                            //.show();


                            return
                        }


                        appid=$(this).attr("appid")
                        $mxdesktop.openApp(appid)
                    });

                    $(".appContainer").hide();
                    $(".tab-content .container").show();

                    AdjustHeight();
                    $mxdesktop.drawCustomScrollbar();

                } else
                {
                    //$(".starter-template h1").hide()
                    //$(".tab-content .container").mCustomScrollbar("destroy");
                    //$(".starter-template h2.help").show()
                }

                $(".starter-template p.lead").show();

                // On étend la liste des appli (si appContainer est visible, pas 'toutes les applis' sélectionnés et pas en mode 'petit'
               /* if ( ($(".appContainer").is(":visible") || ($mxdesktop.isSmall()&& !IsMobile())) &&
                       currentCategorie!=$mxdesktop.allCategorie
                   )
                {
                    ul=$link.parent().find(".catapps")
                    ul.show('slow',function() {
                        if (!$(this).hasClass("mCustomScrollbar"))  $(this).mCustomScrollbar();
                    });

                }*/

                bPostit=false
                for (src in $mxdesktop.listeDesSources)
                {
                    source=$mxdesktop.listeDesSources[src]
                    if (source.message!=undefined && source.message!="")
                    {
                        $mxdesktop.addPostitMessageForSource(source)
                        bPostit=true
                    }
                }

                if (bPostit) {
                    if (postitTimeout!=undefined) clearTimeout(postitTimeout)
                    if ($mxdesktop.listeDesOthersSources.length!=0 && $mxdesktop.listeDesOthersSources.length!=undefined) 
                    {
                        postitTimeout=setTimeout($mxdesktop.showPostit,3000)
                    } else $mxdesktop.showPostit();
                }

    },

    // fixes #7750 : Ajout des classes CSS pour afficher les cachets
    showPostit:function() 
    {
                $("#postit .rappel").each(function() {
                    $(this).prepend('<span class="fa-stack fa-lg"><i class="fa fa-square-o fa-stack-2x"></i><i class="fa fa-clock-o  fa-stack-1x"></i></span>')
                })

                $("#postit .recycle").each(function() {
                    $(this).prepend('<span class="fa-stack fa-lg"><i class="fa fa-square-o fa-stack-2x"></i><i class="fa fa-lightbulb-o fa-stack-1x"></i></span>')
                })

                $("#postit .attention").each(function() {
                    $(this).prepend('<span class="fa-stack fa-lg"><i class="fa fa-square-o fa-stack-2x"></i><i class="fa fa-exclamation-triangle fa-stack-1x"></i></span>')
                })

                $("#postit .mail").each(function() {
                    $(this).prepend('<span class="fa-stack fa-lg"><i class="fa fa-square-o fa-stack-2x"></i><i class="fa fa-comment fa-stack-1x"></i></span>')
                })

                $("#postit .important").each(function() {
                    $(this).prepend('<span class="fa-stack fa-lg"><i class="fa fa-square-o fa-stack-2x"></i><i class="fa fa-exclamation fa-stack-1x"></i></span>')
                })

                // Suppression, des balises <p> vide
                $("#postit .message").find("p").each( function() { 
                    if ($(this).text().trim()=="") {$(this).remove() } 
                })

                $("#postit").show()
        
    }

};

// ==================================================================================
// Quelques fonction utilitaires 

// Extraction d'un noeud dans un flux xml
function xmlText(node,item) {return $(node).find(item).text()}
function xmlHtml(node,item) {return $(node).find(item).html()}

// Jquery redraw
$.fn.redraw = function(){
  $(this).each(function(){
    var redraw = this.offsetHeight;
  });
};

// Extraction au format json d'un flux xml représentant une app
function extractAppFromXml(xml)
{
    // Récupération des données depuis le xml
    infos={url:xmlText(xml,'infos_url'),
                   type:xmlText(xml,'infos_type'),
                   message:xmlHtml(xml,'infos_message')}

    // Les balises & sont transformés en &amp; , on fait donc l'inverse
    if (infos.message!=undefined) infos.message=infos.message.replace( /\&amp;/g, '&' );
    if (infos.url!=undefined) infos.url=infos.url.replace( /\&amp;/g, '&' );


    categorie=xmlText(xml,'categoriename');
    nom=xmlText(xml,'nom')
    libelle=xmlText(xml,'libelle')
    url=xmlText(xml,'url')
    favurl=xmlText(xml,'favurl') || url // Url pour stocker dans favoris
    libellecours=xmlText(xml,'libellecours') || libelle;
            
    nom=nom || libelle
    if (nom==undefined) nom="Aucun nom";

    // Determine la categorie a partir du nom (cf ancienne nomenclature)
    if ((categorie==undefined || categorie=="") && nom.indexOf("/")!=-1) {
                categorie=nom.split("/")[0];
                libelle=nom.split("/")[1];
                if (libelle=="") libelle=categorie
    }

    return {id:Math.random().toString(36).substring(7),
                 libelle:libelle,
                 libellecours:libellecours,
                 icon:xmlText(xml,'icon'),
                 url:url,
                 hidden:xmlText(xml,'hidden'),
                 external:xmlText(xml,'external')=="true",
                 nom:nom,
                 favurl:favurl,
                 infos:infos,
                 infosChecked:[],
                 favoris:false,
                 categorie:categorie.normalize()}
}


// Wrapper, pour compatibilité de infosplus qui a été créé sur le framework ajax de posh
// et non de jquery
$p={
    print: function(id,div,where) {
        if (where=="bottom") $("#"+id).append(div)
        if (where=="top") $("#"+id).prepend(div)
    }
}


function BuildInfos()   {}
function AdjustFooter() {}
function getRGB(color)  {

    if (color.indexOf("rgb(")==0) {
        var result = color.match(/\d+/g);
        return [parseInt(result[1]), parseInt(result[2]), parseInt(result[3])];
    }

    if (result = /rgb(s*([0-9]{1,3})s*,s*([0-9]{1,3})s*,s*([0-9]{1,3})s*)/.exec(color)) return [parseInt(result[1]), parseInt(result[2]), parseInt(result[3])];
    if (result = /rgb(s*([0-9]+(?:.[0-9]+)?)%s*,s*([0-9]+(?:.[0-9]+)?)%s*,s*([0-9]+(?:.[0-9]+)?)%s*)/.exec(color)) return [parseFloat(result[1]) * 2.55, parseFloat(result[2]) * 2.55, parseFloat(result[3]) * 2.55];
    if (result = /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(color)) return [parseInt(result[1], 16), parseInt(result[2], 16), parseInt(result[3], 16)];
    if (result = /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(color)) return [parseInt(result[1] + result[1], 16), parseInt(result[2] + result[2], 16), parseInt(result[3] + result[3], 16)];
}

function lighter(color,alpha,percent)
{
    if (color==undefined) return "white";
    var rgb = getRGB(color);
    if (rgb==undefined) {
        console.log("rgb undefined for:"+color);
        return "white";
    }
    for(var i = 0; i < rgb.length; i++){
        rgb[i] = Math.min(Math.round(rgb[i] * (percent || 2.0)), 255);
    }
    var newColor = 'rgba(' + rgb[0] + ',' + rgb[1] + ',' + rgb[2] + ','+ (alpha || 1) +')';
    return newColor
}

//filter results based on query
function filter(selector, query) {
          query =       $.trim(query); //trim white space
          query = query.replace(/ /gi, '|'); //add OR for regex query

          count=0
          $(selector).each(function() {
              if (($(this).text().search(new RegExp(query, "i")) < 0)){
                  $(this).hide().removeClass('visible')
              } else
              {
                  $(this).show().addClass('visible');
                  count++
              }
          });
          $(selector).unhighlight()
          $(selector).highlight(query);
}


function getDefaultCategorieColor(app)
{
    if (app.categorie==$mxdesktop.allCategorie) return "white";
    // Pour le moment en dure, a recupérer depuis le chargement des items de bureau
    /*if (app.categorie.toLowerCase().indexOf("applications")!=-1) return "rgb(220,220,255)";
    if (app.categorie.toLowerCase().indexOf("administration")!=-1) return "rgb(255,220,220)";
    return "rgb("+Math.floor((Math.random()*55)+120)+","+Math.floor((Math.random()*55)+130)+","+Math.floor((Math.random()*55)+150)+")";*/
    return "rgb(92,92,92)";
}

function getFaForBadgeInfos(infos)
{
    if (infos.type=="infos") return "fa-info-circle"
    if (infos.type=="error") return "fa-times-circle"
    if (infos.type=="warning") return "fa-exclamation-triangle"
    if (infos.type=="new") return "fa-certificate"
    return "fa-circle"
}

function xshow(id)
{

}

function RANDOM() {
   return  Math.random().toString(36).substring(7);
}

// fixes: #8472: tester avec a/&é~#'{([-|è`_çà@)]=}$£ø*µù%!:;,?./§
// ne fait pas planter
String.prototype.normalize = function () {
    return this.replace(/[^a-zA-Z0-9\s]/g,'');
};


