<?php

define("NO_CAS_SESSION",true);
header("Access-Control-Allow-Origin: *");

include_once("../include/config.php");

include_once('../include/models.php');
include_once("../include/config.php");

include_once("../include/mysql.php");

include_once("../include/session.php");
include_once('../include/app.php');

// GET: /conf : récupère la configuration pour un utilisateur 
$app->get('/conf', function ()  use ($app) {
    $app->requireAuth();

    $app->json( USER()->conf);
});


// POST: /conf : sauvegarde de la configuration
$app->post('/conf', function ()  use ($app) {
    $app->requireAuth();

    $conf=$app->request()->post("conf");
    USER()->conf=$conf;
    R::store(USER());
});

// POST: /me : #10413 : FIXES CAS LOGOUT
$app->post('/me', function ()  use ($app) {
    $logoutRequest=$app->request()->post('logoutRequest');
    if ($logoutRequest!=null) include("../include/CASauto.php");
});

// GET: /me : Infos sur l'utilisateur actuel
$app->get('/me', function ()  use ($app) {
    $app->requireAuth();
    $app->json(USER()->exporter());
});

// GET: /alive : 
$app->get('/alive', function ()  use ($app) {
    $app->requireAuth();
    $token=TOKEN();
    if ($token) {
        $token->updated=new DateTime("now");
        R::store($token);
    }

    $app->json(USER()->export());
});

// GET: /user/:uid : Infos sur l'utilisateur uid
$app->get('/user/:uid', function ($uid)  use ($app) {
    $app->requireAdmin();
    // Récupération de l'utilisateur
    $user=R::findOne("user","uid = ?",array($uid));
    if (!$user) {
        $app->notfound("$uid introuvable");
    }
    $app->json($user->export());
});

// POST: /user/apps : Save user apps
$app->post('/user/profil/:profil/apps',function ($profil) use ($app) {
    $app->requireAuth();

    // Récupération du profil, si inexistant on va le créer
    $p=R::findOne("profil","user_id = ? AND name = ?",array(USER()->id,$profil));
    if (!$p) {
        $p=R::dispense("profil");
        $p->user=USER();
        $p->name=$profil;
    }

    $p->apps=$app->request()->post("apps");

    R::store($p);
});

// POST: /user/profil/clear : Efface le cache
$app->post('/user/profil/clear',function () use ($app) {
    $app->requireAuth();

    $all=R::findAll("profil","user_id = ?",array(USER()->id) );
    R::trashAll($all);
});

$app->get('/user/profil/:profil/apps',function ($profil) use ($app) {
    $app->requireAuth();

    // Suppression des profils en cache, après reconfigure
    if (file_exists(dirname(__FILE__).'/../cache/postservice')) {
        $all=R::findAll("profil");
        R::trashAll($all);
        unlink(dirname(__FILE__).'/../cache/postservice');
    }

    $p=R::findOne("profil","user_id = ? AND name = ?",array(USER()->id,$profil));
    if (!$p) {$app->json(array());return;}

    $app->json(array("apps"=>$p->apps));
});

// GET: /messages : Récupère les messages pour l'utilisateur actuel
$app->get('/messages', function ()  use ($app) {
    $app->requireAuth();
    $app->json(USER()->getMessages());
});

// GET: /session : Création d'un token de session
$app->get('/session', function ()  use ($app) {
    $app->requireAuth();
    $app->json(array("token"=>TOKEN()->value,"adminPostit"=>USER()->isAdminPostit()));
});

// GET: /messages/:uid : Récupère les messages pour l'utilisateur :uid
$app->get('/messages/:uid', function ($uid)  use ($app) {
    $app->requireAdmin();
    // Récupération de l'utilisateur
    $user=R::findOne("user","uid = ?",array($uid));
    if (!$user) {$app->notfound("$uid introuvable");}

    $app->json($user->getMessages());
});


// GET:/messages/all : Récupération de tous les messages
$app->get('/messages/all/', function ()  use ($app) {

    // AdminPostit nécessaire
    $app->requireAdminPostit();

    // Tous les postits
    $postits  = R::findAll( 'postit',' ORDER BY updated DESC ');
    $a=array();
    foreach ($postits as $postit) {
        $postit->countResponses();
        $exp=$postit->export();
        $exp["access"]=$postit->getMeta("access");
        $exp["close"]=$postit->getMeta("close");
        $exp["total"]=$postit->getMeta("total");
        $exp["responses"]=$postit->getAvailableResponses();
        $a[]=$exp;
    }

    // Toutes les infosbulles
    $infosbulle  = R::findAll( 'infosbulle',' ORDER BY updated DESC ');
    $b=array();
    foreach ($infosbulle as $info) {$b[]=$info->export();}

    $app->json(array("postits"=>$a,"infosbulle"=>$b));
});

$app->post('/message/:id/close', function ($id)  use ($app) {
    $app->requireAuth();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();
     if (!$postit->isVisibleForUser(USER(),false)) $app->forbiden();

    USER()->closePostit($postit,$app->request()->post("never"));

    echo json_encode($postit->export());
});

// PCADEOT : FIXES #13811
// GET:/messages/:id/list : Export CSV des logs d'accès au message, types d'état et valeurs d'etats : ACCESS, CLOSE et réponses.

$app->get('/message/:id/list', function ($id)  use ($app) {
    $app->requireAdminPostit();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();

    $list = R::getAll("SELECT user.uid AS UID, user.display_name AS USERNAME, response.type as STATUT, response.created as DATE  FROM user INNER JOIN response on response.user_id = user.id WHERE response.postit_id = ?", array($postit->id) );

    //  echo json_encode($list);
    //  die;

        header("Cache-Control: no-cache, must-revalidate");
        header("Cache-Control: post-check=0,pre-check=0");
        header("Cache-Control: max-age=0");
        header("Pragma: no-cache");
        header("Expires: 0");
        header("Content-Type: application/force-download; charset=UTF-8");
        header("Content-disposition: attachment; filename='export_liste_vues.csv'");
        echo "UID".";"."USERNAME".";"."TYPE".";"."VALEUR".";"."DATE"."\r\n";
        foreach ($list as $individual) {
            echo $individual['UID'].";";
            echo $individual['USERNAME'].";";
            if ($individual['STATUT']=="/_ACCESS_/") echo "[état:];Vu";
            else if ($individual['STATUT']=="/_CLOSE_/") echo "[état:];Fermé";
            else echo "[réponse:];".$individual['STATUT'];
            echo ";";
            echo $individual['DATE'].";";
            echo "\r\n";
        }
        // --
});

$app->delete('/message/:id', function ($id)  use ($app) {
    $app->requireAdminPostit();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();
    R::trash($postit);
});

// Ne plus afficher un message
$app->post('/message/:id/never', function ($id)  use ($app) {
    $app->requireAuth();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();
    if (!$postit->isVisibleForUser(USER(),false)) $app->forbiden();

    USER()->closePostit($postit,$app->request()->post("value"));

    echo json_encode($postit->export());
});

// Init 'action close' 
$app->delete('/message/:id/never', function ($id)  use ($app) {
    $app->requireAdminPostit();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();

    $all=R::find("response",'postit_id = ? AND type = ?',array($postit->id,Postit::$CLOSE));
    R::trashAll($all);
});

// Efface toutes les réponses pour un postit
$app->delete('/message/:id/responses', function ($id)  use ($app) {
    $app->requireAdminPostit();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();

    $all=R::find("response",'postit_id = ? AND type not like ?',array($postit->id,'/_%_/'));
    R::trashAll($all);
});

// Réponse à une question
$app->post('/message/:id/response', function ($id)  use ($app) {
    $app->requireAuth();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();
    if (!$postit->isVisibleForUser(USER())) $app->forbiden();

    // Vérifie que la réponse fait bien partie du pool de réponse
    $value=$app->request()->post("value");
    $bOk=false;
    foreach($postit->getAvailableResponses() as $response) {
        if ($value==$response->{'libelle'}) $bOk=true;
    }
    if (!$bOk) $app->forbiden("libelle '$value' invalide");

    // Création de la response
    USER()->deleteAllResponsesForPostit($postit);
    USER()->createResponseForPostit($postit,$value);

    // va compter le nombre de réponse
    $postit->countResponses();

    echo json_encode(array("responses"=>$postit->getAvailableResponses(),
                           "user_responses"=>$postit->getResponsesForUser(USER())
                    ));

    

});

// GET:/message/id : Récupération d'un message (réf: #9367)
$app->get('/message/:id', function ($id)  use ($app) {

    $app->requireAuth();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();
    if (!$postit->isVisibleForUser(USER()) && ! USER()->isAdminPostit()  ) $app->forbiden();

    $postit->countResponses();
    $exp=$postit->export();
    $exp["access"]=$postit->getMeta("access");
    $exp["close"]=$postit->getMeta("close");
    $exp["total"]=$postit->getMeta("total");
    $exp["responses"]=$postit->getAvailableResponses();

    echo json_encode($exp);

});

// POST:/message/type/id : Sauvegarde d'un message
$app->post('/message/:id', function ($id)  use ($app) {

    // AdminPostit nécessaire
    $app->requireAdminPostit();

    // Récupération du postit
    $obj=R::findOne("postit",'id = ?',array($id));

    // Pas trouvé
    if (!$obj) {
        // id==0, on va en créer un
        if ($id==0) {
            $obj=R::dispense("postit");
        } else {
            $app->pass();
        }
    } 

    // Récupération des paramètres
    $req = $app->request();

    $url="".$req->post("url");
    if ($url=="0") $url="";

    $obj->message=$req->post("message");
    $obj->filtre=$req->post("filtre");
    $obj->valeur=$req->post("valeur");
    $obj->flag=$req->post("flag"); 
    $obj->closeable=$req->post("closeable"); 
    $obj->requestable=$req->post("requestable");
    $obj->displayMode=$req->post("displayMode");
    $obj->responses=json_encode($req->post("responses"));
    $obj->url=$url; 
    $obj->start=new DateTime("".$req->post("start")); 
    $obj->stop=new DateTime("".$req->post("stop"));

    // Sauvegarde 
    R::store($obj);

    echo json_encode($obj->export());

});

// ==================================================
// apps =============================================
$app->get('/apps/all', function ()  use ($app) {

    if (!isset($config['dblogin'])) {
        $app->json(array("label"=>"Appli locales","children"=>array())); 
        return;
    }

    R::selectDatabase( 'poshprofile' );

    $desktopitem  = R::getAll( 'SELECT * FROM desktopitem order by libelle' );
    $items = R::convertToBeans( 'item', $desktopitem );
    
    $a=array();
    foreach ($desktopitem as $item) 
    {
        $a[]=array("key"=>"local_".$item["desktopid"],"name"=>$item["name"],"libelle"=>$item["libelle"],"icon"=>$item["icon"]);
    }

    $local=array("label"=>"Appli locales","children"=>$a);

    $app->json(array($local));

});


// ==================================================

// ==================================================
// LDAP =============================================

$app->get('/filtres',function () use ($app) {
    $app->requireAdminPostit();
    include_once("../include/ldap.php");

    $profils=array();
    $profils[]=array("value"=>"national_1","text"=>"Elèves");
    $profils[]=array("value"=>"national_2","text"=>"Parents");
    $profils[]=array("value"=>"national_3","text"=>"Enseignants");
    $profils[]=array("value"=>"national_6","text"=>"Administratifs");
    
    global $config;
    if (isset($config["profils"])) {
        foreach($config["profils"] as $profil) {
            if (!isset($profil["description"])) $profil["description"]=$profil["libelle"];
            $profils[]=array("value"=>"@".$profil["libelle"],"text"=>$profil["description"]);
        }
    }

    $a=array("groups"=>LDAP\GetGroups(),"users"=>LDAP\GetUsers(),"profils"=>$profils);
    //$app->json($a);
    // FIXE ME: $app->json, pb lorsqu'il y a bcp de groupes et d'utilisateurs
    header('Content-type: application/json');
    echo json_encode($a);die(); 
});

// GET: /ldap/groupes Récupération des groupes LDAP
$app->get('/ldap/groupes', function ()  use ($app) {
    $app->requireAuth();
    include_once("../include/ldap.php");
    echo json_encode(LDAP\GetGroups());
});

// GET: /ldap/users Récupération des users LDAP
$app->get('/ldap/users', function ()  use ($app) {
    $app->requireAuth();
    include_once("../include/ldap.php");
    echo json_encode(LDAP\GetUsers() );
});
// ==================================================

$app->run();

?>
