#!/bin/bash

xdir="/var/www/html/xdesktop"
aspects="$xdir/aspects"

[ ! -e  $aspects/enabled/$1 ] && ln -s $aspects/available/$1 $aspects/enabled/$1

# Le dossier $aspects/enabled doit être accessible en écriture a www-data 
chown -R www-data.www-data $aspects/enabled

# Gestion du cache des aspects
[ -e $aspects/enabled/version.txt ]  && V=$( cat $aspects/enabled/version.txt) && /bin/rm -rf $aspects/enabled/version.txt
[ ! -z "$V" -a -e $aspects/enabled/cache_$V.js ]  && /bin/rm -rf $aspects/enabled/cache_$V.js

# Cache js et css
[ ! -d $xdir/cache ] && mkdir $xdir/cache
chown -R www-data.www-data $xdir/cache
[ -e $xdir/cache/cache.js ] && /bin/rm -rf $xdir/cache/cache.js
