<?php
// Micro-framework Slim
require 'Slim/Slim.php';
\Slim\Slim::registerAutoloader();


// USER actuel
function USER($user=false) {
    // Sauvegarde user
    if ($user!=false) {
        $_SESSION["user"]=$user;
        return $user;
    }
    // Pas de user, return false
    if (!isset($_SESSION["user"])) {
        return false;
    }
    // retourne le user de la session
    return $_SESSION["user"];
}

// TOKEN actuel
function TOKEN() {
    if (!isset($_SESSION["token"])) {
        return false;
    }
    return $_SESSION["token"];
}


class mySlim extends Slim\Slim {

    function auth() {

        // Un token est passé
        if (isset($_GET["token"]) || isset($_POST["token"]) ) {
            if (isset($_GET["token"]))  $t=$_GET["token"];
            if (isset($_POST["token"])) $t=$_POST["token"];

            $token=R::findOne("token","value = ?",array($t));
            if ($token) {
                $_SESSION["user_login"]=$token->user->uid;
                $_SESSION["groupes"]="";
                $_SESSION["token"]=$token;
                USER($token->user);
            }
        } else {
            include("CASauto.php");
        }


        // Récupération du profil
        if (isset($config['dblogin'])) {
            include_once("profil.php");
        }
        
    }

    function json($mixed) {
        if ($this->request()->get("api")) {
            $this->api($mixed);
        } else {
            echo json_encode($mixed);
        }
    }
    
    function api($mixed) {
        $api=$this->request()->get("api");
        $id=$this->request()->get("id");
        $json=json_encode($mixed);
        $this->response->headers->set('Content-Type', 'text/javascript');
        $this->response->setBody(<<<EOL
var data=$json;
$api('$id',data);
EOL
);
    }

    function unauthorized() {
        $this->halt(403,"NO SESSION");
    }

    function forbiden($message="") {
        $this->halt(403,$message);
    }

    function notfound($message="") {
        $this->halt(404,$message);
    }

    function requireGroup($groupe) {
        $this->requireAuth();
        if (!USER()->hasGroup($groupe)) $this->forbiden("L'appartenance au groupe $groupe est nécessaire");
    }

    function requireAdminPostit() {
        $this->requireAuth();
        if (!USER()->isAdminPostit()) $this->forbiden("Droit insuffisant, groupe '". User::$GROUP_ADMINPOSTIT. "' requis");
    }

    function requireAdmin() {
        $this->requireAuth();
        if (!USER()->isAdmin())  $this->forbiden("Administrateur requis");
    }

    function requireAuth() {
    
        // Si pas de groupe ou pas de uid, on lance l'authentification
        if (!isset($_SESSION["groupes"]) || !isset($_SESSION["user_login"]) ) {
            $this->auth();
        }

        // Tjs pas de variable de session 
        if (!isset($_SESSION["groupes"]) && !isset($_SESSION["user_login"]) ) {
            $this->unauthorized();
        }

        // Est-ce qu'un user existe ?
        if (!USER()) {
            $user=R::findOne("user","uid = ?",array($_SESSION['user_login']));
            if (!$user) {
                $user=R::dispense("user");
                $user->uid=$_SESSION['user_login'];
            }
            
            // Récupération des attributs CAS
            $data=$_SESSION["phpCAS"]["attributes"]['infos'];
            foreach($data as $key=>$value) {
		// On ne met pas  à jour l'attribut uid
		// Cet attribut 'uid' est donné par $_SESSION['user_login'] (Cf: CASauto.php)
                // 'uid' est renseigné lors de la création de l'utilisateur
                if ($key=="uid") continue; 

                if (is_array($value))  $value=implode("|",$value);
                $user->{$key}=strtolower($value);
            }

            // Profils
            global $config;
            if (isset($config["profils"])) {
                if (!isset($user->{'ent_person_profils'})) {
                    $groups=array();
                } else {
                    $groups=$groupes=explode("|",$user->{'ent_person_profils'});
                }

                foreach($config["profils"] as $profil) {
                    
                    $rep=preg_replace('/{([a-z]*)}/i','$user->${1}',$profil["expression"] );
                    try {
                        $b=eval(' try { return '.$rep.'; } catch (Exception $ex) { return false;}');
                        if ($b) {
                            $groups[]="@".$profil["libelle"];
                        } else
                        {
                            unset($groups["@".$profil["libelle"]]);
                        }
                    } catch (Exception $ex) {
                        
                    }
                }
                $user->{'ent_person_profils'}=strtolower(implode("|",array_unique($groups)));
            }

            // Création d'un token de session
            $token=R::dispense("token");
            $token->user=$user;
            $token->value=substr( md5(rand()), 0, 7).substr( md5(rand().time()), 0, 7);
            $token->created=new DateTime("now");
            $token->updated=new DateTime("now");
            R::store($token);
            $_SESSION["token"]=$token;

            // Met le user en session
            USER($user);

            // Enregistre les modifications sur le user
            R::store($user);
        } else
        {
            $token=TOKEN();
            if ($token) {
                $token->updated=new DateTime("now");
                R::store($token);
            }
        }

        // Suppression des anciens token
        $time=strtotime("-1 hour"); 
        $previousHour=$now=date("Y-m-j H:i:s",$time);
        $oldTokens=R::findAll("token","updated < ?",array($previousHour));
        R::trashAll($oldTokens);

        return true;

    }

}


// Create app
$app = new mySlim();
?>
