<?php

namespace LDAP; 

global $config;
if (isset($config['LDAPserver'])) {
    require_once('configCAS/ldap.inc.php');
}

// retourne tous les groupes LDAP
function GetGroups() {
    global $config;
    if (!isset($config['LDAPserver'])) return array();

    $ds=ldap_connect(__LDAP_HOST);
    $gr_types = array('Classe', 'Option', 'Groupe','Matiere', 'Equipe','Niveau');
    $a=array();
    foreach ($gr_types as $type) {
        $lds = ldap_search($ds, "ou=local,ou=groupes,".__LDAP_BASE_DN_EXTENSION.",".__LDAP_BASE_DN, "(&(objectclass=sambaGroupMapping)(objectclass=posixGroup)(type=$type))", array("cn"));
        $ldge = ldap_get_entries ($ds, $lds);

        if ($ldge["count"]>0) {
            $z=array();
            for ($n=0 ; $n < $ldge["count"] ; $n++){
                $z[]=$ldge[$n]["cn"][0];
            }
            $a[]=array("label"=>$type,"children"=>$z);
        }
    }
    return $a;
}

function GetUsers() {
    global $config;
    if (!isset($config['LDAPserver'])) return array();

    $ds=ldap_connect(__LDAP_HOST);
    $lds = ldap_search($ds, "ou=utilisateurs,".__LDAP_BASE_DN_EXTENSION.",".__LDAP_BASE_DN, "(&(objectclass=ENTPerson)(objectclass=person))", array("uid","cn","ENTPersonProfils"));
    $ldge = ldap_get_entries ($ds, $lds);
    $a=array();
    for ($n=0 ; $n < $ldge["count"] ; $n++){
        $profil=$ldge[$n]["entpersonprofils"][0];
        if (!isset($a[$profil])) $a[$profil]=array();
        $a[$profil][]=array("uid"=>$ldge[$n]["uid"][0],"cn"=>$ldge[$n]["cn"][0]);
    }

    $z=array();
    foreach($a as $profil=>$uids) {
            $z[]=array("label"=>$profil,"children"=>$uids);
    }
    return $z;
}

?>
