<?php

include_once('rb.php');

define('REDBEAN_MODEL_PREFIX', '');

// Configuration de RB
R::setup('mysql:host='.$config['dbhost'].';dbname='.$config['xdesktop_dbname'],$config['xdesktop_dblogin'],$config['xdesktop_dbpassword']);

// Ajout de la base poshprofile
if (isset($config['dblogin'])) {
    R::addDatabase( 'poshprofile', 'mysql:host='.$config['dbhost'].';dbname='.'poshprofile',$config['dblogin'],$config['dbpassword'], true );
}

R::selectDatabase( 'default' );

class Base extends RedBean_SimpleModel {

    public function update() {
        $this->updated=new DateTime("now");
    }

}

// Posttit class
class Infosbulle extends Base {

}

// Posttit class
class Postit extends Base {

    public static $CLOSE="/_CLOSE_/";
    public static $ACCESS="/_ACCESS_/";

    public function open() {
        if (!$this->responses || $this->responses=="null") $this->responses="[]";
    }

    // Parse en JSON les réponses possibles
    function getAvailableResponses() {
        $responses=$this->bean->getMeta("responses");
        if ($responses) return $responses;

        $this->bean->setMeta("responses",json_decode($this->responses));
        return $this->bean->getMeta("responses");
    }

    // Compte les réponses
    function countResponses() {
        $total=0;
        foreach($this->getAvailableResponses() as $response) {
            $c=R::count( 'response', 'postit_id = ? AND type = ?',array($this->id,$response->{'libelle'}));
            $total=$c+$total;
            $response->{'count'}=$c;
        }
        $c=R::count( 'response', 'postit_id = ? AND type = ?',array($this->id,Postit::$ACCESS));
        $this->bean->setMeta("access",$c);

        $c=R::count( 'response', 'postit_id = ? AND type = ?',array($this->id,Postit::$CLOSE));
        $this->bean->setMeta("close",$c);

        $this->bean->setMeta("total",$total);
    }

    function getResponsesForUser($user) {
        $ret=array();
        $all=R::find("response",'user_id = ? AND postit_id = ?',array($user->id,$this->id));
        foreach($all as $response) {
            $ret[]=array("created"=>$response->created,"libelle"=>$response->type);
        }
        return $ret;
    }

    function isVisibleForUser($user,$bCheckClosed=true) {

        if ($bCheckClosed) {
            $resp=$user->getResponseForPostit($this,Postit::$CLOSE);
            if ($resp) return false;
        }

        if ($this->filtre=="aucun") return true;

        $possible=json_decode(strtolower($this->valeur));
        if ($this->filtre=="uid") {
            return (in_array($user->uid,$possible)) ;
        }

        if ($this->filtre=="profil") {
            $profils=explode("|",$user->ent_person_profils);
            return count(array_intersect($profils,$possible))>0;
        }

        if ($this->filtre=="groupe") {
            $groupes=explode("|",$user->user_groups);
            return count(array_intersect($groupes,$possible))>0;
        }

        return false;
    }

}

// User class
class User extends Base {

    public static $GROUP_ATTRIBUT="user_groups";
    public static $GROUP_ADMINPOSTIT="admin_postit";
    public static $GROUP_ADMIN="domainadmins";

    function exporter() {
        $ret=$this->bean->export();
        $ret["admin_postit"]=$this->isAdminPostit();
        $ret["admin"]=$this->isAdmin();
        return $ret;
    }

    function hasGroup($groupe) {
        return in_array(strtolower($groupe),explode("|",$this->{self::$GROUP_ATTRIBUT}));
    }

    function isAdminPostit() {
        global $config;
        if (isset($config["admin_postit"])) {
            if (in_array($this->uid,$config["admin_postit"])) return true;
        }

        return $this->hasGroup(self::$GROUP_ADMINPOSTIT) || $this->uid == "admin";
    }

    function isAdmin() {
        global $config;
        if (isset($config["admin"])) {
            if (in_array($this->uid,$config["admin"])) return true;
        }

        return $this->hasGroup(self::$GROUP_ADMIN) || $this->uid == "admin";
    }

    function closePostit($postit,$val) {
        $resp=$this->getResponseForPostit($postit,Postit::$CLOSE);

        // Pas de reponse et on demande de ne plus afficher => création d'une response 'close'
        if (!$resp && $val=="true") {
            $this->createResponseForPostit($postit,Postit::$CLOSE);
        } 
        // Il existe une reponse et on demande d'afficher' => suppression de la response 'close'
        elseif ($resp && $val!="true") {
            R::trash($resp);
        }

    }

    function deleteAllResponsesForPostit($postit) {
        $all=R::find("response",'user_id = ? AND postit_id = ? AND type not like ?',array($this->id,$postit->id,'/_%_/'));
        R::trashAll($all);
    }

    function createResponseForPostit($postit,$type) {
        $resp=R::findOne("response",'user_id = ? AND postit_id = ? AND type = ?',array($this->id,$postit->id,$type));
        if (!$resp) {
            $resp=R::dispense("response");
            $resp->user=$this;
            $resp->postit=$postit;
            $resp->type=$type;
            $resp->created=new DateTime("now");
            R::store($resp);
        }
        return $resp;
    }

    function getResponseForPostit($postit,$type) {
        $resp=R::findOne("response",'user_id = ? AND postit_id = ? AND type = ?',array($this->id,$postit->id,$type));
        return $resp;
    }

 
    // Retourne les messages pour l'utilisateur
    function getMessages() {
        
        $now=date("Y-m-j H:i:s");
        $postits  = R::findAll( 'postit','start < ? and stop > ? ORDER BY updated DESC ',array($now,$now));

        $a=array();
        foreach ($postits as $postit) {
            if ($postit->isVisibleForUser($this)) {
                $this->createResponseForPostit($postit,Postit::$ACCESS);
                $exp=$postit->export();
                $exp["user_responses"]=$postit->getResponsesForUser($this);
                $a[]=$exp;
            }
        }

        return array("messages"=>$a,"admin"=>$this->isAdminPostit());
    }

}
?>
