
// ===========================================================================
// Gestion de la configuration
function ConfManager() {

    this.configs={}
    this.BY_CATEGORIE="BY_CATEGORIE";


}

// Chargement de la configuration
ConfManager.prototype.load=function() {
    var self=this
    $.ajax({url:"api/conf",dataType:"json"})
    .success(function(data) {
        try {
            data=JSON.parse(data);
            for(var key in data) {
                if (self.configs[key])  {
                    if (self.configs[key].observable()!=data[key]) self.configs[key].observable(data[key]);
                    if (self.configs[key].callback) {
                        self.configs[key].callback(data[key])
                    }
                }
            }
        } catch (exception) {
        }
    })
    .always(function(){
        setTimeout(function() {$(".loading-cache").hide();},500);
    })

}



ConfManager.prototype.save=function() {
    $.ajax({url:"api/conf",method:"post",data:{conf:JSON.stringify(CONF.getConf())}})
    .success(function(data) {
    })
}

ConfManager.prototype.getConf=function() {

    var conf={}
    for(var key in this.configs) 
    { 
        // Les key commencants par un ! ne sont pas retenues pour la conf
        if (key.charAt(0)=="!") continue;
        var attr = this.configs[key]; 
        conf[key]=attr.observable()
    }
    return conf;
}

ConfManager.prototype.register=function(key,observable,callback) {
    CONF.configs[key]={observable:observable,callback:callback}
    observable.watch(CONF.onChange, {key:key})
}

ConfManager.prototype.onChange=function(key,parents, child) {
    //if (CONF.configs[key].observable()==child()) return;
    console.log(key+"="+child());

    if (CONF.configs[key].callback) {
        CONF.configs[key].callback(child())
    }
    CONF.save();
}

var CONF=new ConfManager();



// ===========================================================================
// Un serveur pour une source de données
function Server(data) {
    for (key in data) {this[key]=data[key];}
    this.selected=ko.observable(true);

    this.icone=data.icone || ""
}

Server.prototype.toExport=function()  { return undefined }


Server.prototype.urlIcone=function() {return "url("+this.icone+")";}

Server.prototype.toggle=function(data,event) {
    this.selected(!this.selected())
    if (event) event.stopPropagation();
}


// Définition d'une source de données
function Source(data) {
    this.url=data.url
    this.baseurl=data.baseurl || ""
    this.callback=data.callback
    this.nom=data.nom
    this.fallback=data.fallback
    this.services_url=data.services_url
    this.uaj=(data.uaj || "").toUpperCase()
    this.userinfos=data.userinfos;
    this.id=data.id || $.md5(this.url || this.baseurl)
    this.icone=data.icone
    this.faicon=data.faicon || ""
    this.type=data.type || ""
    this.favoris=data.favoris;
    this.couleur=(data.couleur || "#000").replace("##","#")

    this.federationBefore=data.federationBefore

    this.federer=data.federer
    this.data=data.data

    this.noapps=data.noapps
    this.nomessages=data.nomessages;
	
	// ref #9349 : Url pour la récupération des messages Arena
    this.messages_arena=data.messages_arena;

    this.messages=ko.observableArray([])
    this.servers=ko.observableArray([])
    this.adminMessage=ko.observable(false);
    this.apps=ko.observableArray([]);

    this.loading=ko.observable(false);
    this.status=ko.observable(SOURCE_STATE.UNKNOWN);
    this.error=ko.observable(false);

    this.nomCours=ko.observable(this.nom)
    var n = this.nom.split(" ");
    var ret=[]
    var c=0;
    for (var i=n.length-1;i>=0;i--)
    {
        if ((c+n[i].length)>25) {
            if (ret.length==0) ret.push(n[i])
            break;
        }
                    
        c=c+n[i].length;
        ret.push(n[i])
    }
    this.nomCours(ret.reverse().join(" "));

    // ref #9349 : Possibilité de pouvoir changer le libellé des messages provenant de Arena 
    this.koLibelleMessage=ko.observable(this.nomCours())
    this.koFaIcon=ko.observable(this.faicon)
    this.koCouleur=ko.observable(this.couleur)

    // Chargement différé des sources uniquement si c'est configuré
    if (!this.isCurrent() && this.type!="COMMUNE" && MX.config['_defered']) this.status(SOURCE_STATE.DEFERED)

}

// https://domaine/xdesktop/api/<action>?id=<id>&api=Source.<func>
Source.prototype.apiUrl=function(action,func) {
    return this.fullUrl()+"/api/"+action+"?id="+this.id+"&api=Source."+func;
}

Source.prototype.basePath=function() {return "/xdesktop"}

// <baseurl>/<basePath>
Source.prototype.fullUrl=function()  {return this.baseurl +this.basePath()+""}

// va vérifier toutes les 1mn que la source est OK
Source.prototype.alive=function() {
    var self=this;
    if (MX.noui) return;
    if (this.aliveInterval) return;
    this.aliveInterval=setInterval(function() {
        self.AJAX({url:self.fullUrl()+"/api/alive"})
    },60*MX.sourceTimeAlive*1000);

}

Source.prototype.AJAX=function(options) {
    // Un token exist ?
    if (this.token) {
        if (!options.data) options.data={}
        options.data.token=this.token;
    }
    return $.ajax(options)
}

Source.setMessages=function(sid,data) {
    var s=MX.getSource(sid);if (!s) {return}
    s.setMessages(data);
}

Source.setToken=function(sid,data) {
    var s=MX.getSource(sid);if (!s) {return}
    s.url=s.data || s.url || ""
    s.token=data.token
    s.status(SOURCE_STATE.FEDERATED)
    clearTimeout(s.federerTimeout);
    s.alive()
    s.load()
}

SOURCE_STATE={DEFERED:-2,UNKNOWN:-1,LOADING:0,LOADED:1,FEDERATING:2,FEDERATED:3,ENDED:4}


// Lancement d'une fédération
Source.prototype.lancerLaFederation = function() {
    var self=this;

    // Il est nécessaire de faire une fédération avant de charger les données
    if (self.federer && self.status()!=SOURCE_STATE.FEDERATED) {
        console.log("Federer avant chargement de "+self.data)
        
        // On passe par une iframe
        var $frame=$('<iframe width=0 height=0 style="display:none;">');
        $("body").append($frame)
        self.status(SOURCE_STATE.FEDERATING)

        // Lorsque l'iframe est chargée on va récupérer le token de session
        // se token sera utile pour les requetes ajax
        $frame.load(self,function(event) {
            event.data.url=event.data.data;
            console.log("Federeration terminée pour "+event.data.data)
            event.data.status(SOURCE_STATE.FEDERATED)
            clearTimeout(self.federerTimeout);
            self.federerTimeout=undefined;
            
            // Récupération du token de session
            setTimeout(function(){
                var oHead = document.getElementsByTagName('HEAD').item(0);
                var oScript= document.createElement("script");
                oScript.type = "text/javascript";
                oScript.src=self.apiUrl("session","setToken"); // utilisation de l'API
                oHead.appendChild( oScript);
                // Au bout de 3s , on vérifie l'état, si tjs en FEDERATED
                // on indique que la source est en erreur
                setTimeout(function(){
                    if (self.status()==SOURCE_STATE.FEDERATED) {
                        console.error(self.nom+" récupération du token impossible")
                        self.error(true);
                        self.loading(false);
                    }
                },3000);

            },500);
        })
        
        // On attend que l'iframe se charge si pas de retour (20s)
        // -> source en erreur
        self.federerTimeout=setTimeout(function() {
            console.error(self.nom+" la fédération n a pas répondu")
	    // L'erreur est survenue sur la source actuellement selectionnée, on va dons selectionner celle par défaut
            if (MX.currentSource()==self) {
                MX.selectDefaultSource()
            }
            self.error(true);
            self.loading(false);
        },20*1000);

        console.log("La fédération va se faire avec :"+self.federer);
        $frame.attr("src",self.federer)
        return true;
    }

    // Pas de fédération nécessaire
    return false
}

Source.prototype.load=function() {

    var self=this;

    // La source est marquée comme étant en chargement différé
    // on  ne fait donc rien
    if (this.status()==SOURCE_STATE.DEFERED) return;

    self.loading(true);

    // Une fédération avant ?
    if (this.lancerLaFederation()) return

    // Si le flag noapps est positionné, 
    // on ne va pas récupérer les applis
    if (self.noapps) {
        self.status(SOURCE_STATE.ENDED)
        self.loading(false);
        self.getMessages();
        self.alive()
        return;
    }
    
    // Le chargement continue
    self.status(SOURCE_STATE.LOADING)

    // Construction de l'url
    sep="?"
    if (this.url.indexOf("?")!=-1) sep="&"
    var url=self.url+sep+"id="+self.id+"&js=1";

    // De type XML, on charge directement la ressource
    if (self.type=="XML") {
        $.ajax({
            url: url
        }).success(function(xml) {
            var data={xml:xml,id:self.id,nom:"Ressources locales"}
            MX.GetCategories(xml,data)
            self.error(false);
            self.loading(false);
            self.status(SOURCE_STATE.ENDED);
            self.alive()
            self.noapps=true;
        })
        return
    }
    
    // Appel de l'url, via un script js 
    // ce script, si tout se passe bien appel setData
    var oHead = document.getElementsByTagName('HEAD').item(0);
    var oScript= document.createElement("script");
    oScript.type = "text/javascript";
    oScript.src=url;
    oHead.appendChild( oScript);

    console.log("Chargement de '"+self.nom+"' avec l'url "+url)

    // On attend que ça charge ( 20s )
    // -> source en erreur si le timeout se déclenche
    self.loadingTimeout=setTimeout(function() {
            self.error(true);self.loading(false);
            if (self.fallback) {
                self.fallbacked=true;
                MX.addSource(self.fallback);
            }
    },20*1000);
}

//setData est appelé par retour de load
Source.prototype.setData=function(data) {

    // OK données reçues, on clear le loadingTimeout
    if (this.loadingTimeout) {
        clearTimeout(this.loadingTimeout)
        this.loadingTimeout=undefined;
    }

    console.log("Données recues pour "+this.nom);
    data=JSON.parse(data);
    xml=$("<div/>").html(data.xml).text();
    MX.GetCategories(xml,data)

    console.log(this.apps().length+ " applications trouvées");

    // On va mettre a jour les infos sur la source
    this.status(SOURCE_STATE.ENDED)
    this.error(false);
    this.loading(false);
    this.alive()

    // Activation de la source liée au portail xdesktop
    if (this.type != "COMMUNE") {
        var bActive=MX.config["numero_etab"].toUpperCase() == this.uaj || this.nom=="local"            
        for (var i=0;i<this.servers().length;i++) {this.servers()[i].selected(bActive)}
	if (bActive) MX.currentSource(this);
    } 

    MX.verificationDesSourcesChargees();

    // Récupération des badges
    $envole.xdesktop.createInfosPlus(10); // Dans 10 ms

    // Si la source est marquée comme a selectionner, on va le faire
    if (this.selectOnLoad) this.select()
}

// Est-ce une source liée au portail actuel 
Source.prototype.isCurrent=function() {
    if (!$mxdesktop.config["numero_etab"]) return true
    return $mxdesktop.config["numero_etab"].toUpperCase() == this.uaj || this.nom=="local"
}

Source.prototype.addApp=function(app) {
    this.apps.push(app);

    var server = ko.utils.arrayFirst(this.servers(), function(item) {return app.server === item.id;})
    if (! server) {
        // Est-ce que le serveur est déclaré dans MX ?
        if (MX.servers[app.server]) server=MX.servers[app.server]
        else server=new Server({id:app.server,nom:app.server,couleur:this.couleur})
        this.servers.push(server)
    } 
    app.oServer=server;
}

Source.prototype.checkStyle=function() {

    if (this.noServerSelected()()) {
        var s="fa-square-o"
        if (this.type!="COMMUNE") s="fa-circle-o" 
    } else
    {
        var s="fa-check-square"
        if (this.type!="COMMUNE") s="fa-check-circle"
    }

    return s;
}

// Selection d'une source
Source.prototype.select=function() {

    // Si la source que l'on cherche a activer n'est pas encore charger on va le faire
    if (this.status()==SOURCE_STATE.DEFERED) {
       this.status(SOURCE_STATE.UNKNOWN)
       this.selectOnLoad=true // La source sera à selectionner une fois chargée
       this.load();
    }

    // Si ce n'est pas une ressource commune on va
    // enlever la selection des autres ressources 'non communes' (Seshat)
    if (this.type!="COMMUNE") {
        for (var z=0;z<MX.sources().length;z++) {
            var srv=MX.sources()[z]
            if (srv.type=="COMMUNE") continue;
            for (var i=0;i<srv.servers().length;i++) {srv.servers()[i].selected(false)}
        }
        for (var i=0;i<this.servers().length;i++) {this.servers()[i].selected(true)}
	MX.currentSource(this)

	$('.btn-group.open').trigger('click')

        return;
    }

    if (this.allServerSelected()()) {
        for (var i=0;i<this.servers().length;i++) {this.servers()[i].selected(false)}
        return;
    }

    for (var i=0;i<this.servers().length;i++) {this.servers()[i].selected(true)}
}

Source.prototype.allServerSelected=function(){
    var self=this;
    return ko.computed(function(){return self.servers.selected()().length == self.servers().length && self.servers().length!=0 })
}

Source.prototype.partialServerSelected=function(){
    var self=this;
    return ko.computed(function(){var c=self.servers.selected()().length; return c>0 && c < self.servers().length})
}

Source.prototype.noServerSelected=function(){
    var self=this;
    return ko.computed(function(){var c=self.servers.selected()().length; return c==0 && self.servers().length!=0})
}

// ref #9349 : ajout de messages_arena dans l'export des variables
Source.prototype.toExport=function() { return ["nom","url","baseurl","uaj","services_url","userinfos","icone","couleur","id","type","noapps","nomessages","messages_arena","federer","data","faicon","federationBefore"] }

Source.prototype.urlIcone=function() {return "url("+this.icone+")";}

Source.prototype.addMessage=function(message) {
    this.messages.push(new Postit({message:message,flag:""}))
}

window.addEventListener("message", receiveMessage, false);

function receiveMessage(event) {

    data=JSON.parse(event.data);

    if (data.type=="closeAdminPostit") {
        var s=MX.getSource(data.sid);
        if (!s) return;
	MX.popupClosed=false;
        s.getMessages();
        $("#adminPostit").hide();
        $("body").css("overflow-y","auto");
    }
}

Source.prototype.administrerLesMessages=function() {
    var self=this;

    if (!this.adminMessage()) return;

    $("#adminPostit").attr("src","");
    $('*').scrollTop(0);


    setTimeout(function(){
        $("#adminPostit").attr("src",self.fullUrl()+"/admin.php?id="+self.id )

        $("#adminPostit").show();
        $("body").css("overflow-y","hidden");
        /*$("#adminPostit .btn-close").unbind();  
        $("#adminPostit .btn-close").click(function() {
            self.getMessages();
            $("#adminPostit").hide();
            
        })*/
    },200)
    
 
}

Source.prototype.setMessages=function(data)
{
    var self=this;
    for(var i=0;i<data.messages.length;i++)
    {
            var message=new Postit(data.messages[i]);
            message.source=self;
            
            var bAddToList=!message.isPopup()
        
            // Si url existe sur le message on va essayé de trouvé l'appli
            // qui correspond
            if (message.url()!="" && !message.isPopup() ) {
                var arr=$mxdesktop.applications();
                for (var z=0;z<arr.length;z++) {
                    var app=arr[z];
                    if (app.addMessageIfMatch(message)) {bAddToList=false;break;}
                }
            }

            if (bAddToList) self.messages.push(message);

    }

    self.adminMessage(data.admin);

    // Cache la zone de postit si pas de message
    if ($(".unmessage").length!=0 || self.adminMessage()) 
        $("#postit").show()
    else
        $("#postit").hide()

    
}

Source.prototype.getMessages=function()
{
    var self=this;

    console.log("Récupération des messages pour :"+self.nom)

    // Source en erreur, on ne fait rien
    if (this.error() || this.nomessages) {
        if (this.error()) console.error(" -> Source en erreur")
        if (this.nomessages) console.error(" -> nomessages set")
        return;
    }

    self.messages.removeAll();

    // fixes: #11150 : recup message arena si edispatecher sur le même serveur que xdesktop 
    if ( (window.location.href.indexOf(self.baseurl)==-1) || self.messages_arena ) {
        var oHead = document.getElementsByTagName('HEAD').item(0);
        var oScript= document.createElement("script");
        oScript.type = "text/javascript";
        // #9349 : Url pour les messages arena
        oScript.src=(self.messages_arena || (self.fullUrl()+"/api/messages")) + "?id="+self.id+"&api=Source.setMessages";
        oHead.appendChild( oScript);
        return;
    }


    $.ajax({
        url: self.fullUrl()+"/api/messages",dataType: "json"
    }).success(function(data) {
        self.setMessages(data);
    })
}
// ===========================================================================

function exportObject(objtoExport) {
    var data={}
    var toExport=objtoExport.toExport();

    if (toExport!=undefined) {
        for (var i=0;i<toExport.length;i++)
        {
            data[toExport[i]]=objtoExport[toExport[i]];
        }
    } else
    {
        for (key in objtoExport) {
            if (key === "arrInfos") continue;

            var v=objtoExport[key];
            if (v && v.toExport) continue;
            if (typeof v === "function") continue;
            
            data[key]=v;
        }
    }


    return data;
}

// Categorie =================================================================
function Categorie(data) {

    var self=this;

    for (key in data) {
        this[key]=data[key];
    }
    if (!this.id) this.id=this.name.normalize(); 
    if (!this.indice) this.indice="000"

    this.apps=ko.observableArray([]);
    this.selected=ko.observable(MX.allSelected());

    $mxdesktop.categories.push(this);

    this.isFavoris=this.id==MX.favorisCategorie;

}

Categorie.prototype.addApp=function(app) {
    var a=ko.utils.arrayFirst(this.apps(), function(item) {return item.id === app.id;})
    if (a) return;
    MX.listeDesUrl[app.url]=app;
    this.apps.push(app);
}


Categorie.prototype.bgColor=function() {
        var self=this;
        return ko.pureComputed(function() {if (MX.searchAppLeft()!='' || (self.selected() && !$mxdesktop.allSelected() && !MX.appOpened() && !MX.isAccueil())) return self.color
        else return "rgba(0,0,0,0)";},MX)
}

Categorie.prototype.hasVisibleApp=function() {
    var self=this;
    return ko.pureComputed(function() {
        return self.apps.filterBySearch()().length > 0
    },MX )
}

Categorie.prototype.isVisible=function() {
    var self=this;
    return ko.pureComputed(function() {
        return (! MX.isAccueil() && self.selected() && self.apps.filterBySearch()().length > 0) || (MX.isAccueil() && self.id==MX.favorisCategorie)
    },MX )
}

Categorie.prototype.isVisibleLeft=function() {
    var self=this;
    return ko.pureComputed(function() {
        return (self.apps.filterBySearchLeft()().length > 0 || self.id==MX.favorisCategorie)
    },MX )
}



Categorie.prototype.classe=function() {
    var self=this;
    return ko.pureComputed(function() {
        if (self.selected() && ! MX.allSelected() && !MX.appOpened() && !MX.isAccueil()) return "active"
        if (MX.searchAppLeft()!='') return "filtered"
        return ""
    },MX);
}

Categorie.prototype.select=function() 
{
    Categorie.selectAll(false);
    this.selected(true);
    MX.allSelected(false);
    MX.appOpened(false);
    MX.isAccueil(false)
    MX.openCategorie();
    MX.currentCategorie(this.id);
    setTimeout(function() {MX.enableDragAndDrop();},500);
}

Categorie.selectAll=function(bSelect)
{
    var arr=$mxdesktop.categories();
    for (var z=0;z<arr.length;z++) {
        if (arr[z].apps().length==0) arr[z].selected(false);
        else arr[z].selected(bSelect);

        // Suppression des qtip, s'il existe
        for (var i=0;i<arr[z].apps().length;i++) {
            var a=arr[z].apps()[i];
            if (a.qtip) a.qtip=undefined
        }

    }
}

Categorie.prototype.toExport=function() { return ["name","color","icone","indice","id"] }

// ===========================================================================

// App =======================================================================
function App(data) {
    for (key in data) {
        this[key]=data[key];
    }
    this.id=RANDOM(); 
    this.server=data.server || "default"

    this.urlBase=this.urlBase || "";
    this.badges=ko.observableArray([]);
    this.others=ko.observableArray([]);
    this.loading=ko.observable(false);
    this.hasOthers=ko.observable(false);
    this.error=ko.observable(false);
    if (this.external) {
        this.isExternal=ko.observable(true);
    } else
    {
        this.isExternal=ko.observable(this.isMixedContent());
    }
    
    this.key=this.categorie+"/"+this.source.nom+"/"+this.nom;
    this.search=[this.nom,this.url,this.libellecours+this.libelle].join("[]").toLowerCase()

    var key=this.key

    if (MX.listeDesUrl[this.url] != undefined) return;
    
    // Vérification que l'appli n'éxiste pas déja
    if (MX.nomDesApplications[key] != undefined) {
        var  appRef=MX.nomDesApplications[key];
        if (!appRef.hasOthers()) {
            appRef.others.push(appRef);
            appRef.libellecours=appRef.nom
        }
        appRef.others.push(this);
        this.isOthers=true;
        appRef.hasOthers(true);
    } else {
        MX.nomDesApplications[key]=this
        this.isOthers=false;
    }


    var oC=MX.listeDesCategories[this.categorie];
    if (oC) {
        this.oCategorie=oC
    } else 
    // Si aucune catégorie trouvée, on va en créer une
    {
        oC=new Categorie({name:this.categorie,color:MX.defaultCategorieColor,icone:MX.defaultCategorieIcon,indice:9999,apps:[]})
        MX.listeDesCategories[this.categorie]=oC
        this.oCategorie=oC
    }

    this.isFavoris=ko.observable(data.favoris)

    $mxdesktop.applications.push(this)
    this.source.addApp(this)
}

App.prototype.attrOthers=function() {
    var self=this;
    return ko.computed(function() {return (self.others().length!=0)?"true":"false"},MX);
}

App.prototype.currentError=function() {
    var self=this;
    return ko.computed(function() {var a=MX.currentApp();return a!=null && a.id==self.id && self.error()},MX);
}

App.prototype.currentExternal=function() {
    var self=this;
    return ko.computed(function() {var a=MX.currentApp();return a!=null && a.id==self.id && self.isExternal()},MX);
}

App.prototype.currentLoading=function() {
    var self=this;
    return ko.computed(function() {var a=MX.currentApp();return a!=null && a.id==self.id && self.loading()},MX);
}

App.prototype.addToFavoris=function() {
    $mxactions.toggleFavoris(this.id);
    MX.clearCache();
}

App.prototype.removeFromFavoris=function() {
    $mxactions.toggleFavoris(this.id);
    MX.clearCache();
}


App.prototype.isVisible=function() {
    var self=this;
    return ko.computed(function() {
        var v=MX.searchApp().toLowerCase();
        if (v=="") return true;
        return (self.url.indexOf(v)!=-1) || (self.nom.indexOf(v)!=-1)  || (self.libelle.indexOf(v)!=-1)
    },MX);
}

App.prototype.addMessageIfMatch=function(message) {
    var url=message.url()
    if (url.length<3) return false;

    if (this.url.indexOf(url)!=-1) {
        console.log(this.libelle+" match '"+url+"' => addInfos")
        this.addInfos(message.forBadge())
        return true
    }
    return false
}

App.prototype.toExport=function()  { return undefined }
App.prototype.toExclude=function() { return ["source"] }

App.prototype.isMixedContent=function() {return ( (window.location.href.indexOf("https://")==0) && (this.url.indexOf("http://")==0) )}

//App.prototype.key= function()                 {return this.categorie+"/"+this.source.nom+"/"+this.nom;}
App.prototype.keyWithoutCategorie= function() {return this.source.nom+"/"+this.nom;}

App.prototype.json=function() {
    return {id:this.id,libelle:this.libelle,icon:this.icon,
            favurl:encodeURIComponent(this.favurl),url:encodeURIComponent(this.url),nom:this.nom,
            categorie:this.categorie}
}

App.prototype.requestForService=function() {
    o=this.json();s="";for (k in o) {s=s+"&"+k+"="+o[k] } // Construction des paramètres de l'appli
    a=window.location.href.split("/");a[a.length-1]="controllers/services.php"; // Ajout du callback
    s=s+"&callback="+a.join("/")
    return s.replace("&","?")
}


App.prototype.urlIcone=function() {return "url("+this.icon+")";}

App.prototype.close=function(data,event) {
    this.error(false)
    MX.closeApp(this)
    if (this.wnd) {
        this.wnd.close();
        delete this.wnd
    }
    //ref #9352, sur la fermeture d'une appli
    // on demande à la source de récupérer les messages
    this.source.getMessages()
}

App.prototype.reload=function(data,event) {
    var self=this;
    this.close();
    self.open(data,event)
    //setTimeout(function(){self.open(data,event)},100)
    MX.reloadApp(this.id);
}

App.prototype.getIframe=function() {
    return $("iframe[appid='"+this.id+"']")
}

App.prototype.isOpen=function() {
    return this.getIframe().length!=0 || this.wnd;
}

App.prototype.externalize=function(data,event) {
    this.error(false);
    this.loading(false);
    this.close()
    this.isExternal(true);
    this.open(false,false,true)
}

App.prototype.internalize=function(data,event) {
    this.error(false);
    this.loading(false);
    this.close()
    this.isExternal(false);
    this.open(false,false,true)
}

App.prototype.openOther=function(data,event) {
    this.open(data,event,true)
}

App.prototype.open=function(data,event,force) {

    // SI Ctrl, on affiche appli dans les logs, juste pour debug
    if (event) {
        event.stopPropagation();
        if (event.ctrlKey) {
            console.log(this);
            return;
        }
    }

    // Si app sans others
    if (!this.hasOthers() || force) {

        // Si c'est une app externe, traitement particulier pour l'ouvrir dans un onglet
        if (this.isExternal()) {
            if (!this.wnd || (this.wnd && this.wnd.closed)) {
                wnd=window.open("redirect.php?url="+encodeURIComponent(this.url), "_blank"); 
                
                //patches #12410 : Piwik, sous Chrome va ré-ouvrir l'appli dans la fenetre actuelle de xdesktop
                //                 malgré une ouverture dans un nouvel onglet
                //                 Ce patch ne va pas mettre de iframe dans xdesktop pour piwik
                if ( this.url.indexOf("piwik")!=-1       ||
                     this.url.indexOf("phpmyadmin")!=-1 
                    ) 
                {
                  return ;
                }
                
                // Cas de piwik traité, on sauvegarde la fenetre extrene, pour pouvoir y mettre un focus
                // lors d'un nouveau clique sur l'appli
                this.wnd=wnd;

            } else {
                this.wnd.focus();
            }
        }

        if (!this.isOpen()) {this.loading(true);this.error(false)}
        MX.openApp(this)

        // ref #9352, suppression des badges à l'ouverture de l'appli
        // ils seront récupérés à la fermeture de l'application
        this.badges.removeAll();
        this.arrInfos=[];

        // En attente 
        setTimeout(function(a) {
            if (a.loading()) {
                console.log(a.id+"/"+a.nom+" loading timeout")
                a.loading(false);
                a.error(true)
                AdjustHeight();
            }
        },MX.appWaitTimeLoading*1000,this)
    }

    // L'appli regroupe d'autre appli => ouverture d'un tip pour choisir l'appli
    if (this.hasOthers() && !this.qtip) {
        var target=$(event.currentTarget)
        this.qtip=target.qtip({id:this.id,
                               suppress: false,content: {
                                text:target.find(".apps")
                               },
                               position: {
                                    my: 'top center',
                                    at: 'bottom center',
                                    target: target.find("span.others"),  viewport: $("#listedesicones"),
                                    adjust: { y:0 }
                                },
                                show: {
                                    event: 'click',
                                    effect: function() {$(this).slideDown();}
                                },
                                hide: {
                                    fixed:true,delay:300,
                                    effect: function() {$(this).slideUp();}
                                   /* event: 'click'*/
                                },
                                style: {
                                    classes:'qtip-bootstrap'
                                },
                                events: {
                                    show: function(event, api) {
                                        appid=$(this).find(".apps").attr("appid")
                                        $("#icons li[appid!='"+appid+"']").animate({opacity: "0.2"}, 500)
                                    },
                                    hide: function(event, api) {
                                        //MX.redraw();
                                        appid=$(this).find(".apps").attr("appid")
                                        $("#icons li[appid!='"+appid+"']").animate({opacity: "1"}, 500)
                                    }
                                }
                            });

        target.trigger("click");
        return;
    }
}

App.prototype.addInfos=function(data) {

    // Y a t'il déja un badge avec le même id ? si ou on le supprime d'abord
    var b=ko.utils.arrayFirst(this.badges(), function(item) {return item.id === data.id;})
    if (b)this.badges.remove(b)

    // Déja un badge de type 'count', on le supprime d'abord
    var b=ko.utils.arrayFirst(this.badges(), function(item) {return item.type === "count";})
    if (b)this.badges.remove(b)

    // Pas plus de 3 badges sur une icone
    if (this.badges().length>=3) return ;

    this.badges.push(new Badge(data));
    $("ul.icons .badge-tool").tooltip({html:true})

    // Refresh carousel dans 3s
    setTimeout(function() {
        $("#myCarousel2").carousel("pause").removeData()
        $("#myCarousel2").carousel(0)
        }
    ,3000);
}



// ==============================================================================
function Badge(data) {
    for (key in data) {
        this[key]=data[key];
    }
}

Badge.prototype.fa=function()
{
    if (this.type=="infos") return "fa-info-circle infos"
    if (this.type=="error") return "fa-times-circle error"
    if (this.type=="warning") return "fa-exclamation-triangle warning"
    if (this.type=="new") return "fa-certificate new"
    return "fa-circle"
}

Badge.prototype.faLibelle=function()
{
    if (this.type=="infos") return "Informations"
    if (this.type=="error") return "Erreur"
    if (this.type=="warning") return "Attention"
    if (this.type=="new") return "Nouveau"
    return "Informations"
}



ko.observableArray.fn.filterByBadges = function() {
    return ko.computed(function() {
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
            if (ko.unwrap(current.badges().length!=0))
                matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}

ko.observableArray.fn.filterBySearch = function() {
    return ko.pureComputed(function() {
        v=MX.searchApp().toLowerCase();
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
            if (current.oServer.selected() && ((current.search.indexOf(v)!=-1)|| v==""))
                    matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}

ko.observableArray.fn.filterBySearchLeft = function() {
    return ko.pureComputed(function() {
        v=MX.searchAppLeft().toLowerCase();
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
            if (current.oServer.selected() && ((current.search.indexOf(v)!=-1)|| v==""))
                    matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}



ko.observableArray.fn.notLoadedSource = function() {
    return ko.computed(function() {
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
	    var s=current.status()
            if (s!=SOURCE_STATE.ENDED && s!=SOURCE_STATE.DEFERED  && !current.noapps) matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}

ko.observableArray.fn.notLoadingSourceInError = function() {
    return ko.computed(function() {
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
            if (!current.loading() && current.error()) matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}

// Liste des sources chargées et qui ne sont pas en erreur
ko.observableArray.fn.availableSources = function() {
    return ko.computed(function() {
        // fixes: #11301, si xdesktop non initialisé on ne retourne rien
        if (!$mxdesktop.initialized) return [];
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
            if (current.type!="COMMUNE" && ! current.error()) matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}

ko.observableArray.fn.selected = function() {
    return ko.computed(function() {
        // fixes: #11301, si xdesktop non initialisé on ne retourne rien
        if (!$mxdesktop.initialized) return [];    
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
            if (current.selected()) matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}

ko.bindingHandlers.iconpicker = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        // This will be called when the binding is first applied to an element
        // Set up any initial state, event handlers, etc. here
    },
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var value = ko.unwrap(valueAccessor());
        $(element).iconpicker({ 
            iconset: 'fontawesome',
            icon: value, rows: 5,cols: 10,
            placement: 'bottom',
        }).on('change', function(e) { 
            var value = valueAccessor();
            value(e.icon);
        });
    }
};


