
// Definition d'une Réponse ======================================
function Response(data) {
    var self=this
    this.libelle=ko.observable(data.libelle)
    this.type=ko.observable(data.type || "primary");
    this.icon=ko.observable(data.icon || "fa-check");
    this.count=ko.observable(data.count || 0);

    this.saving=ko.observable(false);

    this.selectType =function(type,event) {
        console.log(type)
        self.type(type);
    }
}

Response.types=["primary","info","success","warning","danger"];

Response.prototype.exporter=function(){
    return {"libelle":this.libelle(),"icon":this.icon(),"type":this.type()}
}

Response.prototype.css=function() {
            var self=this;
            return ko.computed(function() {
                var r=ko.utils.arrayFirst(self.postit.userResponses(), function(item) {return self.libelle() === item.libelle;})
                if (r) {return "btn-"+self.type()}
                else {return "btn-link"}
            })
}
// ==================================================================

function Base(data) {

    this.data=data || {message:"Votre message ici",flag:"",url:""};
    this.id=this.data.id || 0;

    // Suppression des balises script dans le message
    this.message=this.data.message.replace("<script>","").replace("</script>","");

    var url=this.data.url || "";
    url=url.trim();
    if (url=="0") url="";
    this.url=ko.observable(url)

    if (this.data.start) this.data.start=this.data.start.replace(" ","T");
    if (this.data.stop)  this.data.stop=this.data.stop.replace(" ","T");

    this.start=new Date(this.data.start || moment().toDate())
    this.stop=new Date(this.data.stop || moment().add('days', 30).toDate())

    this.selectedFilter=ko.observable(this.data.filtre||"aucun");
    this.valeur=JSON.parse((this.data.valeur||"[]"));
    
    this.valeur2=this.valeur.join()
    .replace("national_1","Eleves")
    .replace("national_2","Parents")
    .replace("national_3","Enseignants")
    .replace("national_6","Administratifs")

    this.selectedProfils=ko.observableArray(this.valeur);
    this.selectedGroupes = ko.observableArray(this.valeur);
    this.selectedUsers = ko.observableArray(this.valeur);

    this.access=ko.observable(this.data.access || 0);
    this.close=ko.observable(this.data.close || 0);
    this.total=ko.observable(this.data.total || 0);

    this.flag=ko.observable(this.data.flag || "");

    this.initialize && this.initialize.apply(this, this.data);

}

Base.prototype.isUid = function(){return this.data.type=="uid";}

// isFinished() : Est-ce que la date de fin est dépassé ?
Base.prototype.isFinished = function()
{
    return new Date().getTime() > this.stop;
}

Base.prototype.isOnair = function()
{
    var now=new Date().getTime();
    return now < this.stop && now > this.start;
}

Base.prototype.isSoon = function()
{
    var now=new Date().getTime();
    return  this.start > now;
}

// prettyDate() : Affichage du temps restant
Base.prototype.prettyDate = function()
{
    return moment(this.isOnair()?this.stop:this.start).fromNow();
}

// date() : Format les dates de début et de fin du postit
Base.prototype.date = function()
{
    return moment(this.start).format('D MMMM YYYY')+" <i class='fa fa-arrow-circle-right'></i> "+
    moment(this.stop).format('D MMMM YYYY');
}

Base.prototype.edit = function () {
    MVM.loading(true);
    var self=this;

    /// On va récupérer une mise a jour du message si postit existant
	// ref: #9367
    if (self.id!=0) {
        $.ajax({
            url: self.api(),
            dataType: "json",
        }).done(function(data) {

            // Récupération de l'index et suppression du postit
            var index=MVM.postits.indexOf(self);
            MVM.postits.remove(self);

            // Création d'un nouveau avec update des infos
            var newPostit=new Postit(data);
            MVM.postits.splice(index,0, newPostit ); 

            // Edition
            newPostit._edit();
            MVM.loading(false);
        })
        // En cas d'échec, on enlève le flag loading
        .fail(function() {
            MVM.loading(false);
        })

    // Nouveau postit, pas nécessaire de récupérer les infos
    } else {
        setTimeout(function(){self._edit();MVM.loading(false);},100);
    }

}

Base.prototype._edit = function () 
{
    var self=this;

    var $target=$("#modal")
    $("#myModalLabel").html(self.title+" édition");

    // Suppression du binding en cours
    ko.cleanNode($("#modal")[0]);

    // Utilisation du template knockout, postit-edit-template
    $target.find(".modal-body").html('<div class="" data-bind="template: { name: \''+this.editTemplate+'\'}"></div>')

    // Apply viewModel bindings
    ko.applyBindings(self,$("#modal")[0]);
    
    // Affichage la boite d'édition
    MVM.showModal();

    // Initialisation de l'éditeur
    $('#editor').summernote({height: 150,minHeight:150,maxHeight:150,lang: 'fr-FR',
        toolbar: [
        ['style', ['bold', 'italic', 'underline', 'clear']],
        ['font', ['strikethrough']],
        ['fontsize', ['fontsize']],
        ['color', ['color']],
        ['para', ['ul', 'ol', 'paragraph']],
        ['height', ['height']],
        ['misc', ['link','table','codeview']]
    ]
    });

    // Les datePicker
    var oneDayAgo = new Date();
    oneDayAgo.setDate(oneDayAgo.getDate() - 2);
    $('#start').datetimepicker({language: 'fr',useSeconds: false,/*minDate:oneDayAgo,*/useMinutes: false,pickTime:false,
                                defaultDate:moment(this.start).format('D/MM/YYYY')});
    $('#stop').datetimepicker({language: 'fr',useSeconds: false,/*minDate:oneDayAgo,*/useMinutes: false,pickTime:false,
                                defaultDate:moment(this.stop).format('D/MM/YYYY')});


    /*$("#start").on("dp.change",function (e) {
               $('#stop').data("DateTimePicker").setMinDate(e.date);
    });
    $("#stop").on("dp.change",function (e) {
               $('#start').data("DateTimePicker").setMaxDate(e.date);
    });*/

    // Choosen
    $(".chosen-select").chosen({width: "100%",no_results_text:"Aucun résultat"});

    // Active les tabs
    $('#tabPostit a:first').tab('show')

    $('.form-control').tooltip(options)
    $('.flag-choice i').tooltip();

    // Fermeture
    $target.find(".modal-footer button.btn-default").click(function(e) {
        MVM.refresh();
    })

    // Sauvegarde
    $target.find(".modal-footer button.save").click(function(e) {
    
         var filtre=self.selectedFilter();
         var valeur=[]
         if (filtre=="uid") valeur=self.selectedUsers();
         if (filtre=="groupe") valeur=self.selectedGroupes();
         if (filtre=="profil") valeur=self.selectedProfils();

         var responses=[]
         var arr=self.responses()
         for(var z=0;z<arr.length;z++) {
            responses.push(arr[z].exporter())
         }

        var dStart=$('#start').data("DateTimePicker").getDate();
        var dStop=$('#stop').data("DateTimePicker").getDate()

        if (dStart.unix()>dStop.unix()) {var d=dstart;dstop=dstart;dstart=d}
        dStart.startOf('day');
        dStop.endOf('day');


        if (!dStart) {alert("Date de début incohérente");return }
        if (!dStop) {alert("Date de fin incohérente");return }

         // Récupération des données
         data={"message":$('#editor').code(),
               "start":dStart.format(),
               "stop":dStop.format(),
               "flag":self.flag(),"filtre":filtre,"valeur":JSON.stringify(valeur),"url":self.url(),
               "closeable":self.closeable(),"requestable":self.requestable(), "responses":responses,
               "displayMode":self.displayMode()
              }

         // requete POST pour sauvegarder les données
         $.ajax({url: self.api(),method:"post",data: data}).done(function(response) {
                MVM.closeModal();
                MVM.refresh();
         });         


    });

    
}

// Definition de la méthode d'héritage
Base.extend = function(childPrototype) { // defining a static method 'extend'
    var parent = this;
    var child = function() { // the child constructor is a call to its parent's
        return parent.apply(this, arguments);
    };
    child.extend = parent.extend; // adding the extend method to the child class
    var Surrogate = function() {}; // surrogate "trick" as seen previously
    Surrogate.prototype = parent.prototype;
    child.prototype = new Surrogate;
    for(var key in childPrototype){
        child.prototype[key] = childPrototype[key];
    }
    return child; // returning the child class
};

// Postit Object =======================================
var Postit = Base.extend({
    initialize : function(data) { 
        var self=this;
        this.editTemplate="postit-edit-template";
        this.title="Message"
        this.infosbulle=false;
        this.neverDisplay=ko.observable((this.data.neverDisplay || "")=="true")

        this.visible=ko.observable(!this.neverDisplay());
        this.loading=ko.observable(false);
        this.closeable=ko.observable((this.data.closeable)=="true")
        this.requestable=ko.observable((this.data.requestable)=="true")

        this.displayMode=ko.observable((this.data.display_mode || "postit"))

        // Liste des reponses possible pour le postit
        this.responses=ko.observableArray([])
        var arr=this.data.responses;
        if (typeof(arr) == "string" || ! arr ) arr=JSON.parse(this.data.responses || "[]");
        for (var z=0;z<arr.length;z++) {
            var resp=new Response(arr[z]);
            resp.postit=self;
            this.responses.push(resp)
        }

        // Réponses de l'utilisateur
        this.userResponses=ko.observableArray([])
        var arr=this.data.user_responses || [];
        for (var z=0;z<arr.length;z++) {
            var resp=arr[z];
            this.userResponses.push(resp)
        }

        this.closeProgress=ko.observable(-1);

        this.deleteResponse =function(response,event) {
            self.responses.remove(response)
        }

        this.selectResponse =function(response,event) {
            if (!response) return;

            response.saving(true)
            self.AJAX({url: self.api("response"),data:{value:response.libelle},dataType: "json",method:"post"})
            .success(function(data) {
                self.userResponses.removeAll()
                var arr=data.user_responses;
                for (var z=0;z<arr.length;z++) {
                    var resp=arr[z];
                    self.userResponses.push(resp)
                }

            })
            .always(function(){response.saving(false)})
        }

        if (this.displayMode()=="popup" && (typeof(MX)!= "undefined")) {
            MX.popups.push(this);
        }

    }
});

Postit.displayModes=[{text:"postit",value:"postit"},{text:"popup",value:"popup"}];

Postit.prototype.isPopup = function() {
    var dp=this.displayMode();
    return dp=="popup"   
}

Postit.prototype.responsesRendered =function() {
    console.log("OOOOOO");
}

Postit.prototype.addResponse =function() {
    this.responses.push(new Response({libelle:"valeur"}))
}

Postit.prototype.api=function(action) {

    var base="";
    if (this.source) {
        base=this.source.fullUrl()+"/";
    }

    return base+"api/message/"+this.id + ((action!=undefined)?("/"+action):"")
}

Postit.prototype.AJAX=function(options) {

    // Un token exist ?
    if (this.source && this.source.token) {
        if (!options.data) options.data={}
        options.data.token=this.source.token;
    }

    return $.ajax(options)
}

Postit.prototype.trash=function(data,event) {
    if (event) event.stopPropagation();
    var self=this;
    this.AJAX({url: this.api(),method:"delete",callback:function(data) {MVM.refresh()}})
}

Postit.prototype.initClose=function() {
    var self=this;
    this.AJAX({url: this.api("never"),method:"delete",noconfirm:true})
    .success(function(data) {
        self.close(0);
    })
}

//click:exportList
Postit.prototype.exportList=function() {
        var self=this;
        if (self.id!=0) {
            window.location.href=this.api("list");
        }
}


Postit.prototype.initResponses=function() {
     var self=this;
     this.AJAX({url: this.api("responses"),method:"delete",message:"Cela supprimera toutes les réponses,<br />Confirmez vous cette action ?",callback:
        function(data) {
        var arr=self.responses();
        for (var i=0;i<arr.length;i++) {
            arr[i].count(0);
        }
        self.total(0);
    }
    })
}


Postit.prototype.toogleDisplay = function() {
    var self=this

    if (self.closeTimeout) {
        clearInterval(self.closeTimeout);
        self.closeProgress(-1);
    }

    self.loading(true);
    this.AJAX({url:self.api("never"),data:{value:!self.neverDisplay()},dataType: "json",method:"post"})
    .success(function(data) {
        self.neverDisplay(!self.neverDisplay())

        // Si mode popup, rend juste invisible
        if (self.isPopup()) {
            self.visible(false);
            return;
        }

        // Si ne plus afficher, progress bar pour effacer le message
        if (self.neverDisplay()) {
            self.closeProgress(3);
            self.closeTimeout=setInterval(function() {
                var val=self.closeProgress();
                if (val<=0) {
                    self.visible(false);
                    clearInterval(self.closeTimeout);
                    self.closeTimeout=undefined;
                }
                self.closeProgress(val-1);
            },1000)
        }


    }).always(function(){self.loading(false);})
}

Postit.prototype.close = function() {
    var self=this
    self.loading(true);
    this.AJAX({url: self.api("close"),data:{never:self.neverDisplay()},dataType: "json",method:"post"})
    .success(function(data) {
        self.visible(false)
    }).always(function(){self.loading(false);})
}


Postit.prototype.isForApp = function() { return this.url()!=""}

Postit.prototype.forBadge=function() {
    var r={}
    r.message=this.message;
    r.id=this.id;
    r.type=this.badgeType();
    return r;
}

Postit.prototype.badgeType = function()
{
    switch (this.data.flag) {
        case "rappel":return "infos";
        case "attention": return "warning";
        case "important": return "error";
        case "mail": return "new";
    }
    return "infos";
}

Postit.prototype.faBadge = function()
{
    switch (this.data.flag) {
        case "rappel":return "infos";
        case "attention": return "warning";
        case "important": return "error";
        case "mail": return "new";
    }
    return "infos";
}


Postit.prototype.faLibelle = function()
{
    switch (this.data.flag) {
        case "rappel":return "Rappel";
        case "recycle": return "Information";
        case "attention": return "Attention";
        case "mail": return "Message";
        case "important": return "Important";
    }
    return "";
}

Postit.prototype.faStyle = function()
{
    switch (this.data.flag) {
        case "rappel":return "fa-clock-o";
        case "recycle": return "lightbulb-o";
        case "attention": return "fa-exclamation-triangle";
        case "mail": return "fa-envelope";
        case "important": return "fa-exclamation";
    }
    return "none";
}



// END Postit Object =======================================




// KO Structure for option value ===========================
ko.bindingHandlers.option = {
    update: function(element, valueAccessor) {
       var value = ko.utils.unwrapObservable(valueAccessor());
       ko.selectExtensions.writeValue(element, value);   
    }        
};

function Group(label, children) {
    this.label = ko.observable(label);
    this.children = ko.observableArray(children);
}

function Option(label, property) {
    this.label = ko.observable(label);
    this.value = ko.observable(property);
}

function OptionApp(key, libelle,icon) {
    var self=this;

    this.key = ko.observable(key);
    this.libelle = ko.observable(libelle);
    this.icon = ko.observable(icon);

    this.html=ko.computed(function() {
        return "<img src='"+self.icon()+"' style='width:48px;height:48px;'>"+self.libelle();
    })

}
// ========================================================

function MessagesViewModel() {
    var self=this;

    self.loading=ko.observable(false);

    self.postits=ko.observableArray([]);
    self.infosbulle=ko.observableArray([]);
    self.availableFilters = ko.observableArray([{value:"aucun",text:"Pas de filtre (Visible pour tout le monde)"},
                                                {value:"uid",text:"login"},
                                                {value:"profil",text:"profil"},
                                                {value:"groupe",text:"groupe"}/*,{value:"custom",text:"personalisé"}*/])
    self.availableProfils = ko.observableArray([])

    setTimeout(function() {
        // récupération des groupes
        self.availableGroupes=ko.observableArray([]);
        self.availableUsers=ko.observableArray([]);
        $.ajax({
            url: "api/filtres",
            dataType: "json",
        }).success(function(data) {

            var groups=data.groups
            for (var i=0;i<groups.length ; i++)
            {
                var item=groups[i]
                var children=[];
                for (z=0;z<item.children.length;z++) {children.push(new Option(item.children[z],item.children[z]))}
                self.availableGroupes.push(new Group(item.label,children)); 
            }

            var users=data.users
            for (var i=0;i<users.length ; i++)
            {
                var item=users[i]
                var children=[];
                for (z=0;z<item.children.length;z++) {children.push(new Option(item.children[z]["cn"],item.children[z]["uid"]))}
                self.availableUsers.push(new Group(item.label,children)); 
            }

            var profils=data.profils
            for (var i=0;i<profils.length ; i++)
            {
                var item=profils[i]
                self.availableProfils.push(item); 
            }

        })

        // récupération des users
        /*self.availableUsers=ko.observableArray([]);
        $.ajax({
            url: "api/ldap/users",
            dataType: "json",
        }).success(function(data) {
            for (var i=0;i<data.length ; i++)
            {
                var item=data[i]
                var children=[];
                for (z=0;z<item.children.length;z++) {children.push(new Option(item.children[z]["url"],item.children[z]["uid"]))}
                self.availableUsers.push(new Group(item.label,children)); 
            }
        })

        // récupération des appli
        self.availableApps=ko.observableArray([]);
        $.ajax({
            url: "api/apps/all",
            dataType: "json",
        }).success(function(data) {
            for (var i=0;i<data.length ; i++)
            {
                var item=data[i]
                var children=[];
                for (z=0;z<item.children.length;z++) 
                {
                    var elt=item.children[z];
                    children.push(new OptionApp(elt["key"],elt["libelle"],elt["icon"]))
                }
                self.availableApps.push(new Group(item.label,children)); 
            }
        })*/

    },1000);
}

// Permet de rafraichir la liste des postits
MessagesViewModel.prototype.refresh = function()
{
    var self=this;
    self.postits.removeAll();
    self.infosbulle.removeAll();

    $.ajax({
        url: "api/messages/all/",
        dataType: "json",async:false,
    }).success(function(data) {

        for (var i=0;i<data.postits.length ; i++)
        {
            self.postits.push(  new Postit(data.postits[i]) ); 
        }
       
    })
}

MessagesViewModel.prototype.close = function() {
    var data=JSON.stringify({type:"closeAdminPostit",sid:MVM.sourceid})
    window.parent.postMessage(data,"*");
}

MessagesViewModel.prototype.showModal = function()
{
    $("#modal").find(".modal-footer button").unbind();    
    $("#modal").modal({backdrop: 'static'});  
}

MessagesViewModel.prototype.closeModal = function()
{
    $("#modal").find(".modal-footer button").unbind();    
    $("#modal").modal('hide');  
}

MessagesViewModel.prototype.addMessage = function () 
{
    var postit=new Postit()   
    postit.edit();
}

MessagesViewModel.prototype.addInfosbulle = function () 
{
    var infosbulle=new InfosBulle()   
    infosbulle.edit();
}

ko.observableArray.fn.soon = function() {
    return ko.computed(function() {
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
            if (current.isSoon()) matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}

ko.observableArray.fn.onair = function() {
    return ko.computed(function() {
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
            if (current.isOnair()) matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}

ko.observableArray.fn.finished = function() {
    return ko.computed(function() {
        var allItems = this(), matchingItems = [];
        for (var i = 0; i < allItems.length; i++) {
            var current = allItems[i];
            if (current.isFinished()) matchingItems.push(current);
        }
        return matchingItems;
    }, this);
}


// Initialisation du datable (en Français et bootstrapé)
function initDatatable() {
    var table=$('.datatable').DataTable({
				"sPaginationType": "bs_normal",
                "bDestroy":true,
                "oLanguage": {
                    "sProcessing":     "Traitement en cours...",
                    "sSearch":         "Rechercher&nbsp;:",
                    "sLengthMenu":     "Afficher _MENU_ &eacute;l&eacute;ments",
                    "sInfo":           "Affichage de l'&eacute;lement _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
                    "sInfoEmpty":      "Affichage de l'&eacute;lement 0 &agrave; 0 sur 0 &eacute;l&eacute;ments",
                    "sInfoFiltered":   "(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)",
                    "sInfoPostFix":    "",
                    "sLoadingRecords": "Chargement en cours...",
                    "sZeroRecords":    "Aucun &eacute;l&eacute;ment &agrave; afficher",
                    "sEmptyTable":     "Aucune donn&eacute;e disponible dans le tableau",
                    "oPaginate": {
                        "sFirst":      "Premier",
                        "sPrevious":   "Pr&eacute;c&eacute;dent",
                        "sNext":       "Suivant",
                        "sLast":       "Dernier"
                    },
                    "oAria": {
                        "sSortAscending":  ": activer pour trier la colonne par ordre croissant",
                        "sSortDescending": ": activer pour trier la colonne par ordre dÃ©croissant"
                    }
                }
	});	
	$('.datatable').each(function(){
				var datatable = $(this);
				// SEARCH - Add the placeholder for Search and Turn this into in-line form control
				var search_input = datatable.closest('.dataTables_wrapper').find('div[id$=_filter] input');
				search_input.attr('placeholder', 'Search');
				search_input.addClass('form-control input-sm');
				// LENGTH - Inline-Form control
				var length_sel = datatable.closest('.dataTables_wrapper').find('div[id$=_length] select');
				length_sel.addClass('form-control input-sm');
                datatable.bind('page', function(e){
                    window.console && console.log('pagination event:', e) //this event must be fired whenever you paginate
                });
	}); 
    
    $('.datatable th[dt-visible="hide"]').each(function(index) {
        var column = table.column(index);
        column.visible( false );
    })
    
    return table;
}



$.datepicker.regional['fr'] = {
		closeText: 'Fermer',
		prevText: '&#x3c;Préc',
		nextText: 'Suiv&#x3e;',
		currentText: 'Aujourd\'hui',
		monthNames: ['Janvier','Fevrier','Mars','Avril','Mai','Juin','Juillet','Aout','Septembre','Octobre','Novembre','Decembre'],
		monthNamesShort: ['Jan','Fev','Mar','Avr','Mai','Jun','Jul','Aou','Sep','Oct','Nov','Dec'],
		dayNames: ['Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi'],
		dayNamesShort: ['Dim','Lun','Mar','Mer','Jeu','Ven','Sam'],
		dayNamesMin: ['Di','Lu','Ma','Me','Je','Ve','Sa'],
		weekHeader: 'Sm',
		dateFormat: 'dd-mm-yy',
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: '',
		minDate: 0,
		maxDate: '+12M +0D',
		numberOfMonths: 2,
		showButtonPanel: true};
	$.datepicker.setDefaults($.datepicker.regional['fr']);	



