<?php
    include_once('include/include.php');
    // Récupération des postit de posh,
    // Une fois la premiere version diffusée cet appel peut être supprimé
    include_once "./controllers/messages.php";
    include_once('assets.php');

    include_once("include/templates.php");

?>
<!DOCTYPE html>
<html>

<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="shortcut icon" href="bootstrap/assets/ico/favicon.png">

        <title>Gestion des messages</title>
        <link href="assets.php?cssadmin" rel="stylesheet">
</head>

<body style="overflow: auto;" class="gestion">

    <div class="loading-cache">
            <div>
                <i class="fa fa-spinner fa-spin"></i> Chargement en cours....
            </div>
        </div>


    <?php
        // Charegement des ressources js (sans les aspects, mode admin)
	write_assets_js(false,true);
    ?>

    <div class="col-md-12 content">

        <div class="waiting" data-bind="visible:MVM.loading">
            <div class="message">
                <i class="fa fa-cog fa-spin"></i> Chargement en cours, veuillez patienter
            </div>
        </div>

        <?php if (!isset($_GET["ng"]) ) { ?>
        <div style="text-align:right" data-bind="visible: window.top != window">
            <button class="btn btn-danger" data-bind="click:MVM.close">
                <i class="fa fa-times"></i> Revenir au bureau
            </button>
        </div>
        <?php } ?>

        <ul class="nav nav-tabs" role="tablist" style="margin-top:-30px;">
          <li class="active"><a href="#messages" role="tab" data-toggle="tab">Messages</a></li>
          <!-- <li><a href="#infosbulle" role="tab" data-toggle="tab">Infos Bulle</a></li> -->
        </ul>

        <div class="tab-content">
          <div class="tab-pane active" id="messages"><div class="" data-bind="template: { name: 'messages-gestion-template2'  }"></div></div>
          <!-- <div class="tab-pane" id="infosbulle"><div class="" data-bind="template: { name: 'infosbulle-gestion-template'  }"></div></div>-->
        </div>


    </div>


    <! -- Définition d'une boite de dialogue -->
     <div id="modal" class="modal fade bs-example-modal-lg" tabindex="-1">
              <div class="modal-dialog modal-lg">
                <div class="modal-content">

                  <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="myModalLabel">Modal title</h4>
                    <div class="alert alert-danger" style='display:none'>
                        <div></div>
                    </div>
                  </div>

                  <div class="modal-body">
                 </div>

                  <div class="modal-footer">

                    <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary save"
                            data-loading-text="<i class='fa fa-spinner fa-spin'></i> veuillez patienter">Enregistrer</button>
                  </div>

                </div>
              </div>
    </div>
    <!--- --- --- --- -->

    <!-- Edition d'un postit -->
    <script id="postit-edit-template" type="text/html">

        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist" id="tabPostit">
          <li class="active"><a href="#message" role="tab" data-toggle="tab">Message</a></li>
          <li><a href="#options" role="tab" data-toggle="tab">Options</a></li>
          <!-- ko if: requestable -->
          <li><a href="#responses" role="tab" data-toggle="tab">Réponses</a></li>
          <!-- /ko -->
        </ul>

        <!-- Tab panes -->
        <div class="tab-content">

          <!-- Message -->
          <div class="tab-pane active" id="message">

            <!-- Type de message -->

                <div class="form-group flag-choice" >
                    <div style="text-align:right">
                     <i data-toggle="tooltip" data-placement="bottom" title="Un rappel"
                        class="fa fa-clock-o img-circle"              data-bind="css:{actif: flag()=='rappel'},click:function(){flag('rappel')}"></i>
                     <i data-toggle="tooltip" data-placement="bottom" title="Attention/Important"
                        class="fa fa-exclamation-triangle img-circle" data-bind="css:{actif: flag()=='attention'},click:function(){flag('attention')}"></i>
                     <i data-toggle="tooltip" data-placement="bottom" title="Message"
                        class="fa fa-envelope img-circle"             data-bind="css:{actif: flag()=='mail'},click:function(){flag('mail')}"></i>
                    </div>
                </div>

            <!-- FIN FILTRE -->

            <div data-bind="html: message" id="editor"></div>
            <br />
            <!-- APPLICATION -->
                <div class="form-group" data-bind="if: ! requestable()">
                    <label for="filtre" class="col-sm-4 control-label">Url applicative (si besoin)<br /></label>
                    <div class="col-sm-8">
                         <input type='text' class="form-control" data-bind="value: url" data-toggle="tooltip" data-placement="bottom"  title="Si vous souhaitez que le message s'affiche uniquement pour une application, veuillez saisir ci-dessous la valeur que doit contenir l'url (Ex: /cdt, gepi,...)"  />
                </div>
                    </div>

                <!-- FIN APPLICATION -->
          </div>

          <!-- Options -->
          <div class="tab-pane" id="options">

            <form role="form">

                <!-- DATE -->
                <div class="form-group">
                  <label for="filtre" class="col-sm-2 control-label">Période</label>
                  <div class="col-sm-10">
                      <span>Debut</span>
                      <div class="input-group date" id="start">
                        <input type='text' class="form-control" />
                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                      </div>

                      <span>Fin</span>
                      <div class="input-group date" id="stop">
                        <input type='text' class="form-control" />
                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                     </div>
                </div>
               </div>
                <!-- FIN DATE -->

                <!-- FILTRE -->
                <div class="form-group">
                    <label for="filtre" class="col-sm-4 control-label">Filtrer avec</label>
                    <div class="col-sm-8">
                        <select data-bind="options: MVM.availableFilters,value:selectedFilter,
                                          optionsText: function(item) {return item.text},
                                          optionsValue: function(item) {return item.value}">
                        </select>
                    </div>
                </div>
                <!-- FIN FILTRE -->

                <!-- Options pour filtre -->
                <div class="form-group">
                    <!-- UID -->
                    <div data-bind="visible:selectedFilter()=='uid'">
                        <label for="uid" class="col-sm-4 control-label">Login (uid)</label>
                        <div class="col-sm-8">
                            <select class="chosen-select"  multiple="true" data-placeholder="login"
                                    data-bind="foreach: MVM.availableUsers, selectedOptions: selectedUsers">
                                <optgroup data-bind="attr: {label: label}, foreach: children">
                                    <option data-bind="text: label, value: value"></option>
                                </optgroup>
                            </select>
                        </div>
                    </div>

                    <!-- Profil -->
                    <div data-bind="visible:selectedFilter()=='profil'">
                        <label class="col-sm-4 control-label">Profils</label>
                        <div class="col-sm-8">
                            <select class="chosen-select"  multiple="true"  data-placeholder="Profils"
                                    data-bind="options: MVM.availableProfils,
                                               optionsText: function(item) {return item.text},
                                               optionsValue: function(item) {return item.value},
                                               selectedOptions:selectedProfils">
                            </select>
                        </div>
                    </div>

                    <!-- Groupe -->
                    <div data-bind="visible:selectedFilter()=='groupe'">
                        <label class="col-sm-4 control-label">Groupes</label>
                        <div class="col-sm-8">
                            <select class="chosen-select"  multiple="true" data-placeholder="Groupe"
                                    data-bind="foreach: MVM.availableGroupes, selectedOptions: selectedGroupes">
                                <optgroup data-bind="attr: {label: label}, foreach: children">
                                    <option data-bind="html: label, value: value"></option>
                                </optgroup>
                            </select>
                        </div>
                    </div>


                </div>
                <!-- FIN Options pour filtre -->

                <!-- Type de message -->
                <div class="form-group">
                    <label  class="col-sm-4 control-label">Type de message</label>
                    <div class="col-sm-8">
                        <select data-bind="options: Postit.displayModes,value:displayMode,
                                          optionsText: function(item) {return item.text},
                                          optionsValue: function(item) {return item.value}">
                        </select>
                    </div>
                </div>
                <!-- FIN FILTRE -->

                <!-- PEUT ETRE FERME -->
                <div class="form-group">
                    <label for="filtre" class="col-sm-4 control-label">L'utilisateur peut fermer ce message ?</label>
                    <div class="col-sm-8">
                         <input type="checkbox" data-bind="checked: closeable" />
                    </div>
                </div>

                <!-- Questions/Reponses -->
                <div class="form-group">
                    <label for="filtre" class="col-sm-4 control-label">Est-ce une question ?</label>
                    <div class="col-sm-8">
                         <input type="checkbox" data-bind="checked: requestable" />
                    </div>
                </div>

                <div class="form-group">
                    <label for="filtre" class="col-sm-4 control-label">Informations</label>
                    <div class="col-sm-8">
                        <i class="fa fa-user text-info"></i> Nombre d'utilisateur ayant <b>vu</b> ce message <b><span data-bind="text: access"></span></b><br />
                        <!-- ko if: closeable -->
                        <i class="fa fa-times text-danger"></i> Nombre d'utilisateur ayant <b>fermer</b> ce message <b><span data-bind="text: close"></span></b><span>&nbsp;<button type="button" class="btn btn-primary btn-xs" data-bind="click:initClose"><i class="fa fa-eraser"></i> Réinitialiser</button></span><br /> <!-- AJOUT BR -->
                        <!-- /ko -->

                        <!-- PCADEOT : FIXES #13811 -->
                        <!-- Affiche message+bouton d'Export CSV des logs d'accès au message, etats ACCESS, CLOSE et réponses. -->

			<span><button type="button" class="btn btn-primary btn-xs" data-bind="click:exportList"><i class="fa fa-floppy-o"></i> Exporter</button></span>&nbsp;le journal d'accès à ce message.<br />

                    </div>
                </div>

             </form>

          </div>

          <!-- FIN OPTIONS -->

         <!-- Questions -->
         <!-- ko if: requestable -->
          <div class="tab-pane" id="responses">
            Liste des réponses possibles pour ce message
            <button type="button" class="btn btn-success" data-bind="click:addResponse"><i class="fa fa-plus-circle"></i> Ajouter</button><br /><br />

            <table class="table table-striped table-hover" data-bind="visible: responses().length >0">
                <thead>
                    <th>Libelle de la réponse</th>
                    <th>Icône</th>
                    <th>Couleur</th>
                    <th>Exemple</th>
                    <th>Nb.</th>
                    <th></th>
                </thead>
                <tbody data-bind="foreach:{data: responses, as: 'response'}">
                <tr>
                    <td>
                         <input type="text" data-bind="value: response.libelle,attr:{'readonly':response.count()!=0}" />
                    </td>
                    <td>
                        <button class="btn btn-default" data-iconset="fontawesome" role="iconpicker"
                                data-bind="iconpicker:response.icon"></button>
                    </td>
                    <td>
                        <div data-bind="foreach: { data: Response.types, as: 'type'}">
                            <button type="button" class="btn btn-xs" data-bind="css:'btn-'+type,click:$parent.selectType">
                                <i class="fa fa-check-square-o" data-bind="visible:response.type()==type"></i>
                                <i class="fa fa-square-o" data-bind="visible:response.type()!=type"></i>
                            </button>
                        </div>
                    </td>
                    <td>
                        <button type="button" class="btn btn-xs" data-bind="css:'btn-'+response.type()">
                            <i class="fa" data-bind="css:response.icon"></i>
                            &nbsp;<span data-bind="html:response.libelle"></span>
                        </button>
                    </td>
                    <td>
                        <span data-bind="text:response.count"></span>
                    </td>
                    <td>
                        <button type="button" class="btn btn-danger" data-bind="click:$parent.deleteResponse">
                        <i class="fa fa-trash-o"></i>
                        </button>
                    </td>
                </tr>
            </table>

            <div data-bind="visible:total() > 0">
                <button type="button" class="btn btn-danger" data-bind="click:initResponses">Effacer les réponses des utilisateurs</button><br /><br />
            </div>

          </div>
         <!-- /ko -->

        </div>

    </script>
    <!--- --- --- --- -->

    <script>

        var MVM=new MessagesViewModel();
        <?php if (isset($_GET["id"])) { ?>
            MVM.sourceid="<?php echo $_GET["id"]; ?>"
        <?php } ?>

        $(document).ready(function()
        {
            ko.applyBindings(MVM,$(".content")[0]);
            MVM.refresh();
            $(".loading-cache").hide()
        })

    </script>

</body>
