<?php

define("NO_CAS_SESSION",true);
header("Access-Control-Allow-Origin: *");

include_once("../include/config.php");

include_once('../include/models.php');
include_once("../include/config.php");

include_once("../include/mysql.php");

include_once("../include/session.php");
include_once('../include/app.php');

// GET: /conf : récupère la configuration pour un utilisateur
$app->get('/conf', function ()  use ($app) {
    $app->requireAuth();

    $app->json( USER()->conf);
});


// POST: /conf : sauvegarde de la configuration
$app->post('/conf', function ()  use ($app) {
    $app->requireAuth();

    $conf=$app->request()->post("conf");
    USER()->conf=$conf;
    R::store(USER());
});

// POST: /me : #10413 : FIXES CAS LOGOUT
$app->post('/me', function ()  use ($app) {
    $logoutRequest=$app->request()->post('logoutRequest');
    if ($logoutRequest!=null) include("../include/CASauto.php");
});

// GET: /me : Infos sur l'utilisateur actuel
$app->get('/me', function ()  use ($app) {
    $app->requireAuth();
    $app->json(USER()->exporter());
});

// GET: /alive :
$app->get('/alive', function ()  use ($app) {
    $app->requireAuth();
    $token=TOKEN();
    if ($token) {
        $token->updated=new DateTime("now");
        R::store($token);
    }

    $app->json(USER()->export());
});

// GET: /user/:uid : Infos sur l'utilisateur uid
$app->get('/user/:uid', function ($uid)  use ($app) {
    $app->requireAdmin();
    // Récupération de l'utilisateur
    $user=R::findOne("user","uid = ?",array($uid));
    if (!$user) {
        $app->notfound("$uid introuvable");
    }
    $app->json($user->export());
});

// Recuperation du profilage en function des donnees en post
$app->post('/profil',function () use ($app) {
  $data = $app->request()->post("data");

  $data = str_replace("'",'"',$data);
  $data = json_decode($data,true);

  $user_datas = array('user'=>"", 'details'=>$data);
  global $config;

  include_once("../include/config.php");
  include_once("../include/mysql.php");
  include_once("../include/profil.php");

  $app->json($tbitem);
});

// Recuperation de la liste des applications et du profilage
$app->get('/applications',function () use ($app) {

  global $config;

  error_reporting(E_ALL);

  include_once("../include/config.php");
  include_once("../include/mysql.php");
  $dbprofil = new ps_db;
  $dbprofil->dbname($config["dbhostprofil"],$config["dbloginprofil"],$config["dbpasswordprofil"],$config["dbnameprofil"]);

  $db2 = new ps_db;
  $db2->dbname($config["dbhostprofil"],$config["dbloginprofil"],$config["dbpasswordprofil"],$config["dbnameprofil"]);


  // Récupération des applications
  $dbprofil->query("SELECT desktopid,name,libelle,url,icon FROM desktopitem");
  $apps = [];
  while ($dbprofil->next_record()) {
    $name    = $dbprofil->f('name');
    $id      = $dbprofil->f('desktopid');
    $profils = [];

    # Requete sql pour récupérer le profilage
    $sql = "SELECT userattr.attrname as name ,userattr.attrvalue as value
            FROM  profiledesktopitem,profile, userattrprofile,userattr
            WHERE profiledesktopitem.profileid = profile.profileid
                            AND userattrprofile.profileid    = profile.profileid
                            AND userattrprofile.userattrid   = userattr.userattrid
                            AND profiledesktopitem.desktopid = " . $id;

    $db2->close();$db2->query($sql);
    while ($db2->next_record()) {
        $key   = $db2->f('name');$value = "POSH-PROFIL|".$db2->f('value');
        if (array_key_exists($key,$profils)) {
          $profils[$key][] = $value;
        } else {
          $profils[$key] = [$value];
        }
    }

    $apps[$name] = array(
                    "id"      => $id,
                    "name"    => $name,
                    "libelle" => $dbprofil->f('libelle'),
                    "icon"    => $dbprofil->f('icon'),
                    "url"     => $dbprofil->f('url'),
                    "profils" => $profils
                  );
  }

  header('Content-type: application/json');
  echo json_encode($apps);die();

});

// POST: /user/apps : Save user apps
$app->post('/user/profil/:profil/apps',function ($profil) use ($app) {
    $app->requireAuth();

    // Récupération du profil, si inexistant on va le créer
    $p=R::findOne("profil","user_id = ? AND name = ?",array(USER()->id,$profil));
    if (!$p) {
        $p=R::dispense("profil");
        $p->user=USER();
        $p->name=$profil;
    }

    $p->apps=$app->request()->post("apps");

    R::store($p);
});

// POST: /user/profil/clear : Efface le cache
$app->post('/user/profil/clear',function () use ($app) {
    $app->requireAuth();

    $all=R::findAll("profil","user_id = ?",array(USER()->id) );
    R::trashAll($all);
});

$app->get('/user/profil/:profil/apps',function ($profil) use ($app) {
    $app->requireAuth();

    // Suppression des profils en cache, après reconfigure
    if (file_exists(dirname(__FILE__).'/../cache/postservice')) {
        $all=R::findAll("profil");
        R::trashAll($all);
        unlink(dirname(__FILE__).'/../cache/postservice');
    }

    $p=R::findOne("profil","user_id = ? AND name = ?",array(USER()->id,$profil));
    if (!$p) {$app->json(array());return;}

    $app->json(array("apps"=>$p->apps));
});

// GET: /messages : Récupère les messages pour l'utilisateur actuel
$app->get('/messages', function ()  use ($app) {
    $app->requireAuth();
    $app->json(USER()->getMessages());
});

// GET: /session : Création d'un token de session
$app->get('/session', function ()  use ($app) {
    $app->requireAuth();
    // Cas d'un passage par une iframe pour ouvrir une session
    // ( edispatcher et xdesktop portés par le même DNS mais sur des containers différents)
    if (isset($_GET['iframe'])) {
        header('Content-type: text/html');
        echo "
            <script>
              var data={'token':'".TOKEN()->value."','adminPostit':".USER()->isAdminPostit()?'true':'false'."};
              parent.__CALLBACK.setToken('". $_GET['id'] ."',data);
            </script>
            ";
        die();
    }
    $app->json(array("token"=>TOKEN()->value,"adminPostit"=>USER()->isAdminPostit()));
});

// GET: /messages/:uid : Récupère les messages pour l'utilisateur :uid
$app->get('/messages/:uid', function ($uid)  use ($app) {
    $app->requireAdmin();
    // Récupération de l'utilisateur
    $user=R::findOne("user","uid = ?",array($uid));
    if (!$user) {$app->notfound("$uid introuvable");}

    $app->json($user->getMessages());
});


// GET:/messages/all : Récupération de tous les messages
$app->get('/messages/all/', function ()  use ($app) {

    // AdminPostit nécessaire
    $app->requireAdminPostit();

    // Tous les postits
    $postits  = R::findAll( 'postit',' ORDER BY updated DESC ');
    $a=array();
    foreach ($postits as $postit) {
        $postit->countResponses();
        $exp=$postit->export();
        $exp["access"]=$postit->getMeta("access");
        $exp["close"]=$postit->getMeta("close");
        $exp["total"]=$postit->getMeta("total");
        $exp["responses"]=$postit->getAvailableResponses();
        $a[]=$exp;
    }

    // Toutes les infosbulles
    $infosbulle  = R::findAll( 'infosbulle',' ORDER BY updated DESC ');
    $b=array();
    foreach ($infosbulle as $info) {$b[]=$info->export();}

    $app->json(array("postits"=>$a,"infosbulle"=>$b));
});

$app->post('/message/:id/close', function ($id)  use ($app) {
    $app->requireAuth();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();
     if (!$postit->isVisibleForUser(USER(),false)) $app->forbiden();

    USER()->closePostit($postit,$app->request()->post("never"));

    echo json_encode($postit->export());
});

// PCADEOT : FIXES #13811
// GET:/messages/:id/list : Export CSV des logs d'accès au message, types d'état et valeurs d'etats : ACCESS, CLOSE et réponses.

$app->get('/message/:id/list', function ($id)  use ($app) {
    $app->requireAdminPostit();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();

    $list = R::getAll("SELECT user.uid AS UID, user.display_name AS USERNAME,user.*, response.type as STATUT, response.created as DATE  FROM user INNER JOIN response on response.user_id = user.id WHERE response.postit_id = ?", array($postit->id) );

        header("Cache-Control: no-cache, must-revalidate");
        header("Cache-Control: post-check=0,pre-check=0");
        header("Cache-Control: max-age=0");
        header("Pragma: no-cache");
        header("Expires: 0");
        header("Content-Type: application/force-download; charset=UTF-8");
        header("Content-disposition: attachment; filename='export_liste_vues.csv'");
        echo "UID".";"."USERNAME".";"."TYPE".";"."VALEUR".";"."DATE". ";PROFIL".  "\r\n";
        foreach ($list as $individual) {
            $profil="";
            if (isset($individual['ent_person_profils'])) {$profils=$individual['ent_person_profils'];}
            if (isset($individual['profils'])) {$profils=$individual['profils'];}
            echo $individual['UID'].";";
            echo $individual['USERNAME'].";";
            if ($individual['STATUT']=="/_ACCESS_/") echo "[état:];Vu";
            else if ($individual['STATUT']=="/_CLOSE_/") echo "[état:];Fermé";
            else echo "[réponse:];".$individual['STATUT'];
            echo ";";
            echo $individual['DATE'].";";
            echo $individual['ent_person_profils'] .";";
            echo "\r\n";
        }
        // --
});

$app->delete('/message/:id', function ($id)  use ($app) {
    $app->requireAdminPostit();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();
    R::trash($postit);
});

// Ne plus afficher un message
$app->post('/message/:id/never', function ($id)  use ($app) {
    $app->requireAuth();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();
    if (!$postit->isVisibleForUser(USER(),false)) $app->forbiden();

    USER()->closePostit($postit,$app->request()->post("value"));

    echo json_encode($postit->export());
});

// Init 'action close'
$app->delete('/message/:id/never', function ($id)  use ($app) {
    $app->requireAdminPostit();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();

    $all=R::find("response",'postit_id = ? AND type = ?',array($postit->id,Postit::$CLOSE));
    R::trashAll($all);
});

// Efface toutes les réponses pour un postit
$app->delete('/message/:id/responses', function ($id)  use ($app) {
    $app->requireAdminPostit();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();

    $all=R::find("response",'postit_id = ? AND type not like ?',array($postit->id,'/_%_/'));
    R::trashAll($all);
});

// Réponse à une question
$app->post('/message/:id/response', function ($id)  use ($app) {
    $app->requireAuth();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();
    if (!$postit->isVisibleForUser(USER())) $app->forbiden();

    // Vérifie que la réponse fait bien partie du pool de réponse
    $value=$app->request()->post("value");
    $bOk=false;
    foreach($postit->getAvailableResponses() as $response) {
        if ($value==$response->{'libelle'}) $bOk=true;
    }
    if (!$bOk) $app->forbiden("libelle '$value' invalide");

    // Création de la response
    USER()->deleteAllResponsesForPostit($postit);
    USER()->createResponseForPostit($postit,$value);

    // va compter le nombre de réponse
    $postit->countResponses();

    echo json_encode(array("responses"=>$postit->getAvailableResponses(),
                           "user_responses"=>$postit->getResponsesForUser(USER())
                    ));



});

// GET:/message/id : Récupération d'un message (réf: #9367)
$app->get('/message/:id', function ($id)  use ($app) {

    $app->requireAuth();
    $postit=R::findOne("postit",'id = ?',array($id));
    if (!$postit) $app->pass();
    if (!$postit->isVisibleForUser(USER()) && ! USER()->isAdminPostit()  ) $app->forbiden();

    $postit->countResponses();
    $exp=$postit->export();
    $exp["access"]=$postit->getMeta("access");
    $exp["close"]=$postit->getMeta("close");
    $exp["total"]=$postit->getMeta("total");
    $exp["responses"]=$postit->getAvailableResponses();

    echo json_encode($exp);

});

// POST:/message/type/id : Sauvegarde d'un message
$app->post('/message/:id', function ($id)  use ($app) {

    // AdminPostit nécessaire
    $app->requireAdminPostit();

    // Récupération du postit
    $obj=R::findOne("postit",'id = ?',array($id));

    // Pas trouvé
    if (!$obj) {
        // id==0, on va en créer un
        if ($id==0) {
            $obj=R::dispense("postit");
        } else {
            $app->pass();
        }
    }

    // Récupération des paramètres
    $req = $app->request();

    $url="".$req->post("url");
    if ($url=="0") $url="";

    $obj->message=$req->post("message");
    $obj->filtre=$req->post("filtre");
    $obj->valeur=$req->post("valeur");
    $obj->flag=$req->post("flag");
    $obj->closeable=$req->post("closeable");
    $obj->requestable=$req->post("requestable");
    $obj->displayMode=$req->post("displayMode");
    $obj->responses=json_encode($req->post("responses"));
    $obj->url=$url;
    $obj->start=new DateTime("".$req->post("start"));
    $obj->stop=new DateTime("".$req->post("stop"));

    // Sauvegarde
    R::store($obj);

    echo json_encode($obj->export());

});

// ==================================================
// apps =============================================
$app->get('/apps/all', function ()  use ($app) {

    if (!isset($config['dbhostprofil'])) {
        $app->json(array("label"=>"Appli locales","children"=>array()));
        return;
    }

    R::selectDatabase( 'poshprofile' );

    $desktopitem  = R::getAll( 'SELECT * FROM desktopitem order by libelle' );
    $items = R::convertToBeans( 'item', $desktopitem );

    $a=array();
    foreach ($desktopitem as $item)
    {
        $a[]=array("key"=>"local_".$item["desktopid"],"name"=>$item["name"],"libelle"=>$item["libelle"],"icon"=>$item["icon"]);
    }

    $local=array("label"=>"Appli locales","children"=>$a);

    $app->json(array($local));

});




// ==================================================

// ==================================================
// LDAP =============================================

$app->get('/filtres',function () use ($app) {
    $app->requireAdminPostit();
    include_once("../include/ldap.php");

    $profils=array();
    $profils[]=array("value"=>"national_1","text"=>"Elèves");
    $profils[]=array("value"=>"national_2","text"=>"Parents");
    $profils[]=array("value"=>"national_3","text"=>"Enseignants");
    $profils[]=array("value"=>"national_6","text"=>"Administratifs");

    global $config;
    if (isset($config["profils"])) {
        foreach($config["profils"] as $profil) {
            if (!isset($profil["description"])) $profil["description"]=$profil["libelle"];
            $profils[]=array("value"=>"@".$profil["libelle"],"text"=>$profil["description"]);
        }
    }

    $groups= LDAP\GetGroups();
    $users = LDAP\GetUsers();

    $a=array("groups"=>$groups,"users"=>$users,"profils"=>$profils);
    //$app->json($a);
    // FIXE ME: $app->json, pb lorsqu'il y a bcp de groupes et d'utilisateurs
    header('Content-type: application/json');
    echo json_encode($a);die();
});

// GET: /ldap/groupes Récupération des groupes LDAP
$app->get('/ldap/groupes', function ()  use ($app) {
    $app->requireAuth();
    include_once("../include/ldap.php");
    echo json_encode(LDAP\GetGroups());
});

// GET: /ldap/users Récupération des users LDAP
$app->get('/ldap/users', function ()  use ($app) {
    $app->requireAuth();
    include_once("../include/ldap.php");
    echo json_encode(LDAP\GetUsers() );
});
// ==================================================

$app->run();
